import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataGoogleStorageBucketObjectContentConfig extends cdktf.TerraformMetaArguments {
    /**
    * The name of the containing bucket.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/storage_bucket_object_content#bucket DataGoogleStorageBucketObjectContent#bucket}
    */
    readonly bucket: string;
    /**
    * Data as string to be uploaded. Must be defined if source is not. Note: The content field is marked as sensitive. To view the raw contents of the object, please define an output.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/storage_bucket_object_content#content DataGoogleStorageBucketObjectContent#content}
    */
    readonly content?: string;
    /**
    * The name of the object. If you're interpolating the name of this object, see output_name instead.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/storage_bucket_object_content#name DataGoogleStorageBucketObjectContent#name}
    */
    readonly name: string;
}
export declare class DataGoogleStorageBucketObjectContentCustomerEncryption extends cdktf.ComplexComputedList {
    get encryptionAlgorithm(): string;
    get encryptionKey(): string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google/d/storage_bucket_object_content google_storage_bucket_object_content}
*/
export declare class DataGoogleStorageBucketObjectContent extends cdktf.TerraformDataSource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google/d/storage_bucket_object_content google_storage_bucket_object_content} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataGoogleStorageBucketObjectContentConfig
    */
    constructor(scope: Construct, id: string, config: DataGoogleStorageBucketObjectContentConfig);
    private _bucket?;
    get bucket(): string;
    set bucket(value: string);
    get bucketInput(): string | undefined;
    get cacheControl(): string;
    private _content?;
    get content(): string;
    set content(value: string);
    resetContent(): void;
    get contentInput(): string | undefined;
    get contentDisposition(): string;
    get contentEncoding(): string;
    get contentLanguage(): string;
    get contentType(): string;
    get crc32C(): string;
    customerEncryption(index: string): DataGoogleStorageBucketObjectContentCustomerEncryption;
    get detectMd5Hash(): string;
    get eventBasedHold(): cdktf.IResolvable;
    get id(): string;
    get kmsKeyName(): string;
    get md5Hash(): string;
    get mediaLink(): string;
    metadata(key: string): string | cdktf.IResolvable;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    get outputName(): string;
    get selfLink(): string;
    get source(): string;
    get storageClass(): string;
    get temporaryHold(): cdktf.IResolvable;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
