import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface EndpointsServiceConfig extends cdktf.TerraformMetaArguments {
    /**
    * The full text of the Service Config YAML file (Example located here). If provided, must also provide protoc_output_base64. open_api config must not be provided.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/endpoints_service#grpc_config EndpointsService#grpc_config}
    */
    readonly grpcConfig?: string;
    /**
    * The full text of the OpenAPI YAML configuration as described here. Either this, or both of grpc_config and protoc_output_base64 must be specified.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/endpoints_service#openapi_config EndpointsService#openapi_config}
    */
    readonly openapiConfig?: string;
    /**
    * The project ID that the service belongs to. If not provided, provider project is used.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/endpoints_service#project EndpointsService#project}
    */
    readonly project?: string;
    /**
    * The full contents of the Service Descriptor File generated by protoc. This should be a compiled .pb file, base64-encoded.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/endpoints_service#protoc_output_base64 EndpointsService#protoc_output_base64}
    */
    readonly protocOutputBase64?: string;
    /**
    * The name of the service. Usually of the form $apiname.endpoints.$projectid.cloud.goog.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/endpoints_service#service_name EndpointsService#service_name}
    */
    readonly serviceName: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/endpoints_service#timeouts EndpointsService#timeouts}
    */
    readonly timeouts?: EndpointsServiceTimeouts;
}
export declare class EndpointsServiceApisMethods extends cdktf.ComplexComputedList {
    get name(): string;
    get requestType(): string;
    get responseType(): string;
    get syntax(): string;
}
export declare class EndpointsServiceApis extends cdktf.ComplexComputedList {
    get methods(): cdktf.IResolvable;
    get name(): string;
    get syntax(): string;
    get version(): string;
}
export declare class EndpointsServiceEndpoints extends cdktf.ComplexComputedList {
    get address(): string;
    get name(): string;
}
export interface EndpointsServiceTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/endpoints_service#create EndpointsService#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/endpoints_service#delete EndpointsService#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/endpoints_service#update EndpointsService#update}
    */
    readonly update?: string;
}
export declare function endpointsServiceTimeoutsToTerraform(struct?: EndpointsServiceTimeoutsOutputReference | EndpointsServiceTimeouts | cdktf.IResolvable): any;
export declare class EndpointsServiceTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): EndpointsServiceTimeouts | undefined;
    set internalValue(value: EndpointsServiceTimeouts | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google/r/endpoints_service google_endpoints_service}
*/
export declare class EndpointsService extends cdktf.TerraformResource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google/r/endpoints_service google_endpoints_service} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options EndpointsServiceConfig
    */
    constructor(scope: Construct, id: string, config: EndpointsServiceConfig);
    apis(index: string): EndpointsServiceApis;
    get configId(): string;
    get dnsAddress(): string;
    endpoints(index: string): EndpointsServiceEndpoints;
    private _grpcConfig?;
    get grpcConfig(): string;
    set grpcConfig(value: string);
    resetGrpcConfig(): void;
    get grpcConfigInput(): string | undefined;
    get id(): string;
    private _openapiConfig?;
    get openapiConfig(): string;
    set openapiConfig(value: string);
    resetOpenapiConfig(): void;
    get openapiConfigInput(): string | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _protocOutputBase64?;
    get protocOutputBase64(): string;
    set protocOutputBase64(value: string);
    resetProtocOutputBase64(): void;
    get protocOutputBase64Input(): string | undefined;
    private _serviceName?;
    get serviceName(): string;
    set serviceName(value: string);
    get serviceNameInput(): string | undefined;
    private _timeouts;
    get timeouts(): EndpointsServiceTimeoutsOutputReference;
    putTimeouts(value: EndpointsServiceTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): EndpointsServiceTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
