import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface LoggingProjectSinkConfig extends cdktf.TerraformMetaArguments {
    /**
    * A description of this sink. The maximum length of the description is 8000 characters.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/logging_project_sink#description LoggingProjectSink#description}
    */
    readonly description?: string;
    /**
    * The destination of the sink (or, in other words, where logs are written to). Can be a Cloud Storage bucket, a PubSub topic, or a BigQuery dataset. Examples: "storage.googleapis.com/[GCS_BUCKET]" "bigquery.googleapis.com/projects/[PROJECT_ID]/datasets/[DATASET]" "pubsub.googleapis.com/projects/[PROJECT_ID]/topics/[TOPIC_ID]" The writer associated with the sink must have access to write to the above resource.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/logging_project_sink#destination LoggingProjectSink#destination}
    */
    readonly destination: string;
    /**
    * If set to True, then this sink is disabled and it does not export any log entries.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/logging_project_sink#disabled LoggingProjectSink#disabled}
    */
    readonly disabled?: boolean | cdktf.IResolvable;
    /**
    * The filter to apply when exporting logs. Only log entries that match the filter are exported.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/logging_project_sink#filter LoggingProjectSink#filter}
    */
    readonly filter?: string;
    /**
    * The name of the logging sink.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/logging_project_sink#name LoggingProjectSink#name}
    */
    readonly name: string;
    /**
    * The ID of the project to create the sink in. If omitted, the project associated with the provider is used.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/logging_project_sink#project LoggingProjectSink#project}
    */
    readonly project?: string;
    /**
    * Whether or not to create a unique identity associated with this sink. If false (the default), then the writer_identity used is serviceAccount:cloud-logs@system.gserviceaccount.com. If true, then a unique service account is created and used for this sink. If you wish to publish logs across projects, you must set unique_writer_identity to true.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/logging_project_sink#unique_writer_identity LoggingProjectSink#unique_writer_identity}
    */
    readonly uniqueWriterIdentity?: boolean | cdktf.IResolvable;
    /**
    * bigquery_options block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/logging_project_sink#bigquery_options LoggingProjectSink#bigquery_options}
    */
    readonly bigqueryOptions?: LoggingProjectSinkBigqueryOptions;
    /**
    * exclusions block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/logging_project_sink#exclusions LoggingProjectSink#exclusions}
    */
    readonly exclusions?: LoggingProjectSinkExclusions[] | cdktf.IResolvable;
}
export interface LoggingProjectSinkBigqueryOptions {
    /**
    * Whether to use BigQuery's partition tables. By default, Logging creates dated tables based on the log entries' timestamps, e.g. syslog_20170523. With partitioned tables the date suffix is no longer present and special query syntax has to be used instead. In both cases, tables are sharded based on UTC timezone.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/logging_project_sink#use_partitioned_tables LoggingProjectSink#use_partitioned_tables}
    */
    readonly usePartitionedTables: boolean | cdktf.IResolvable;
}
export declare function loggingProjectSinkBigqueryOptionsToTerraform(struct?: LoggingProjectSinkBigqueryOptionsOutputReference | LoggingProjectSinkBigqueryOptions): any;
export declare class LoggingProjectSinkBigqueryOptionsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): LoggingProjectSinkBigqueryOptions | undefined;
    set internalValue(value: LoggingProjectSinkBigqueryOptions | undefined);
    private _usePartitionedTables?;
    get usePartitionedTables(): boolean | cdktf.IResolvable;
    set usePartitionedTables(value: boolean | cdktf.IResolvable);
    get usePartitionedTablesInput(): boolean | cdktf.IResolvable | undefined;
}
export interface LoggingProjectSinkExclusions {
    /**
    * A description of this exclusion.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/logging_project_sink#description LoggingProjectSink#description}
    */
    readonly description?: string;
    /**
    * If set to True, then this exclusion is disabled and it does not exclude any log entries
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/logging_project_sink#disabled LoggingProjectSink#disabled}
    */
    readonly disabled?: boolean | cdktf.IResolvable;
    /**
    * An advanced logs filter that matches the log entries to be excluded. By using the sample function, you can exclude less than 100% of the matching log entries
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/logging_project_sink#filter LoggingProjectSink#filter}
    */
    readonly filter: string;
    /**
    * A client-assigned identifier, such as "load-balancer-exclusion". Identifiers are limited to 100 characters and can include only letters, digits, underscores, hyphens, and periods. First character has to be alphanumeric.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/logging_project_sink#name LoggingProjectSink#name}
    */
    readonly name: string;
}
export declare function loggingProjectSinkExclusionsToTerraform(struct?: LoggingProjectSinkExclusions | cdktf.IResolvable): any;
/**
* Represents a {@link https://www.terraform.io/docs/providers/google/r/logging_project_sink google_logging_project_sink}
*/
export declare class LoggingProjectSink extends cdktf.TerraformResource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google/r/logging_project_sink google_logging_project_sink} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options LoggingProjectSinkConfig
    */
    constructor(scope: Construct, id: string, config: LoggingProjectSinkConfig);
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _destination?;
    get destination(): string;
    set destination(value: string);
    get destinationInput(): string | undefined;
    private _disabled?;
    get disabled(): boolean | cdktf.IResolvable;
    set disabled(value: boolean | cdktf.IResolvable);
    resetDisabled(): void;
    get disabledInput(): boolean | cdktf.IResolvable | undefined;
    private _filter?;
    get filter(): string;
    set filter(value: string);
    resetFilter(): void;
    get filterInput(): string | undefined;
    get id(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _uniqueWriterIdentity?;
    get uniqueWriterIdentity(): boolean | cdktf.IResolvable;
    set uniqueWriterIdentity(value: boolean | cdktf.IResolvable);
    resetUniqueWriterIdentity(): void;
    get uniqueWriterIdentityInput(): boolean | cdktf.IResolvable | undefined;
    get writerIdentity(): string;
    private _bigqueryOptions;
    get bigqueryOptions(): LoggingProjectSinkBigqueryOptionsOutputReference;
    putBigqueryOptions(value: LoggingProjectSinkBigqueryOptions): void;
    resetBigqueryOptions(): void;
    get bigqueryOptionsInput(): LoggingProjectSinkBigqueryOptions | undefined;
    private _exclusions?;
    get exclusions(): LoggingProjectSinkExclusions[] | cdktf.IResolvable;
    set exclusions(value: LoggingProjectSinkExclusions[] | cdktf.IResolvable);
    resetExclusions(): void;
    get exclusionsInput(): cdktf.IResolvable | LoggingProjectSinkExclusions[] | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
