"use strict";
var _a, _b, _c;
Object.defineProperty(exports, "__esModule", { value: true });
exports.NetworkServicesEdgeCacheOrigin = exports.NetworkServicesEdgeCacheOriginTimeoutsOutputReference = exports.networkServicesEdgeCacheOriginTimeoutsToTerraform = exports.NetworkServicesEdgeCacheOriginTimeoutOutputReference = exports.networkServicesEdgeCacheOriginTimeoutToTerraform = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdktf = require("cdktf");
function networkServicesEdgeCacheOriginTimeoutToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        connect_timeout: cdktf.stringToTerraform(struct.connectTimeout),
        max_attempts_timeout: cdktf.stringToTerraform(struct.maxAttemptsTimeout),
        response_timeout: cdktf.stringToTerraform(struct.responseTimeout),
    };
}
exports.networkServicesEdgeCacheOriginTimeoutToTerraform = networkServicesEdgeCacheOriginTimeoutToTerraform;
class NetworkServicesEdgeCacheOriginTimeoutOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource, terraformAttribute, isSingleItem) {
        super(terraformResource, terraformAttribute, isSingleItem);
        this.isEmptyObject = false;
    }
    get internalValue() {
        let hasAnyValues = this.isEmptyObject;
        const internalValueResult = {};
        if (this._connectTimeout !== undefined) {
            hasAnyValues = true;
            internalValueResult.connectTimeout = this._connectTimeout;
        }
        if (this._maxAttemptsTimeout !== undefined) {
            hasAnyValues = true;
            internalValueResult.maxAttemptsTimeout = this._maxAttemptsTimeout;
        }
        if (this._responseTimeout !== undefined) {
            hasAnyValues = true;
            internalValueResult.responseTimeout = this._responseTimeout;
        }
        return hasAnyValues ? internalValueResult : undefined;
    }
    set internalValue(value) {
        if (value === undefined) {
            this.isEmptyObject = false;
            this._connectTimeout = undefined;
            this._maxAttemptsTimeout = undefined;
            this._responseTimeout = undefined;
        }
        else {
            this.isEmptyObject = Object.keys(value).length === 0;
            this._connectTimeout = value.connectTimeout;
            this._maxAttemptsTimeout = value.maxAttemptsTimeout;
            this._responseTimeout = value.responseTimeout;
        }
    }
    get connectTimeout() {
        return this.getStringAttribute('connect_timeout');
    }
    set connectTimeout(value) {
        this._connectTimeout = value;
    }
    resetConnectTimeout() {
        this._connectTimeout = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get connectTimeoutInput() {
        return this._connectTimeout;
    }
    get maxAttemptsTimeout() {
        return this.getStringAttribute('max_attempts_timeout');
    }
    set maxAttemptsTimeout(value) {
        this._maxAttemptsTimeout = value;
    }
    resetMaxAttemptsTimeout() {
        this._maxAttemptsTimeout = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get maxAttemptsTimeoutInput() {
        return this._maxAttemptsTimeout;
    }
    get responseTimeout() {
        return this.getStringAttribute('response_timeout');
    }
    set responseTimeout(value) {
        this._responseTimeout = value;
    }
    resetResponseTimeout() {
        this._responseTimeout = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get responseTimeoutInput() {
        return this._responseTimeout;
    }
}
exports.NetworkServicesEdgeCacheOriginTimeoutOutputReference = NetworkServicesEdgeCacheOriginTimeoutOutputReference;
_a = JSII_RTTI_SYMBOL_1;
NetworkServicesEdgeCacheOriginTimeoutOutputReference[_a] = { fqn: "@cdktf/provider-google.NetworkServicesEdgeCacheOriginTimeoutOutputReference", version: "0.6.40" };
function networkServicesEdgeCacheOriginTimeoutsToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        create: cdktf.stringToTerraform(struct.create),
        delete: cdktf.stringToTerraform(struct.delete),
        update: cdktf.stringToTerraform(struct.update),
    };
}
exports.networkServicesEdgeCacheOriginTimeoutsToTerraform = networkServicesEdgeCacheOriginTimeoutsToTerraform;
class NetworkServicesEdgeCacheOriginTimeoutsOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource, terraformAttribute, isSingleItem) {
        super(terraformResource, terraformAttribute, isSingleItem);
        this.isEmptyObject = false;
    }
    get internalValue() {
        let hasAnyValues = this.isEmptyObject;
        const internalValueResult = {};
        if (this._create !== undefined) {
            hasAnyValues = true;
            internalValueResult.create = this._create;
        }
        if (this._delete !== undefined) {
            hasAnyValues = true;
            internalValueResult.delete = this._delete;
        }
        if (this._update !== undefined) {
            hasAnyValues = true;
            internalValueResult.update = this._update;
        }
        return hasAnyValues ? internalValueResult : undefined;
    }
    set internalValue(value) {
        if (value === undefined) {
            this.isEmptyObject = false;
            this._create = undefined;
            this._delete = undefined;
            this._update = undefined;
        }
        else {
            this.isEmptyObject = Object.keys(value).length === 0;
            this._create = value.create;
            this._delete = value.delete;
            this._update = value.update;
        }
    }
    get create() {
        return this.getStringAttribute('create');
    }
    set create(value) {
        this._create = value;
    }
    resetCreate() {
        this._create = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get createInput() {
        return this._create;
    }
    get delete() {
        return this.getStringAttribute('delete');
    }
    set delete(value) {
        this._delete = value;
    }
    resetDelete() {
        this._delete = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get deleteInput() {
        return this._delete;
    }
    get update() {
        return this.getStringAttribute('update');
    }
    set update(value) {
        this._update = value;
    }
    resetUpdate() {
        this._update = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get updateInput() {
        return this._update;
    }
}
exports.NetworkServicesEdgeCacheOriginTimeoutsOutputReference = NetworkServicesEdgeCacheOriginTimeoutsOutputReference;
_b = JSII_RTTI_SYMBOL_1;
NetworkServicesEdgeCacheOriginTimeoutsOutputReference[_b] = { fqn: "@cdktf/provider-google.NetworkServicesEdgeCacheOriginTimeoutsOutputReference", version: "0.6.40" };
/**
* Represents a {@link https://www.terraform.io/docs/providers/google/r/network_services_edge_cache_origin google_network_services_edge_cache_origin}
*/
class NetworkServicesEdgeCacheOrigin extends cdktf.TerraformResource {
    // ===========
    // INITIALIZER
    // ===========
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google/r/network_services_edge_cache_origin google_network_services_edge_cache_origin} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options NetworkServicesEdgeCacheOriginConfig
    */
    constructor(scope, id, config) {
        super(scope, id, {
            terraformResourceType: 'google_network_services_edge_cache_origin',
            terraformGeneratorMetadata: {
                providerName: 'google'
            },
            provider: config.provider,
            dependsOn: config.dependsOn,
            count: config.count,
            lifecycle: config.lifecycle
        });
        // timeout - computed: false, optional: true, required: false
        this._timeout = new NetworkServicesEdgeCacheOriginTimeoutOutputReference(this, "timeout", true);
        // timeouts - computed: false, optional: true, required: false
        this._timeouts = new NetworkServicesEdgeCacheOriginTimeoutsOutputReference(this, "timeouts", true);
        this._description = config.description;
        this._failoverOrigin = config.failoverOrigin;
        this._labels = config.labels;
        this._maxAttempts = config.maxAttempts;
        this._name = config.name;
        this._originAddress = config.originAddress;
        this._port = config.port;
        this._project = config.project;
        this._protocol = config.protocol;
        this._retryConditions = config.retryConditions;
        this._timeout.internalValue = config.timeout;
        this._timeouts.internalValue = config.timeouts;
    }
    get description() {
        return this.getStringAttribute('description');
    }
    set description(value) {
        this._description = value;
    }
    resetDescription() {
        this._description = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get descriptionInput() {
        return this._description;
    }
    get failoverOrigin() {
        return this.getStringAttribute('failover_origin');
    }
    set failoverOrigin(value) {
        this._failoverOrigin = value;
    }
    resetFailoverOrigin() {
        this._failoverOrigin = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get failoverOriginInput() {
        return this._failoverOrigin;
    }
    // id - computed: true, optional: true, required: false
    get id() {
        return this.getStringAttribute('id');
    }
    get labels() {
        return this.getStringMapAttribute('labels');
    }
    set labels(value) {
        this._labels = value;
    }
    resetLabels() {
        this._labels = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get labelsInput() {
        return this._labels;
    }
    get maxAttempts() {
        return this.getNumberAttribute('max_attempts');
    }
    set maxAttempts(value) {
        this._maxAttempts = value;
    }
    resetMaxAttempts() {
        this._maxAttempts = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get maxAttemptsInput() {
        return this._maxAttempts;
    }
    get name() {
        return this.getStringAttribute('name');
    }
    set name(value) {
        this._name = value;
    }
    // Temporarily expose input value. Use with caution.
    get nameInput() {
        return this._name;
    }
    get originAddress() {
        return this.getStringAttribute('origin_address');
    }
    set originAddress(value) {
        this._originAddress = value;
    }
    // Temporarily expose input value. Use with caution.
    get originAddressInput() {
        return this._originAddress;
    }
    get port() {
        return this.getNumberAttribute('port');
    }
    set port(value) {
        this._port = value;
    }
    resetPort() {
        this._port = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get portInput() {
        return this._port;
    }
    get project() {
        return this.getStringAttribute('project');
    }
    set project(value) {
        this._project = value;
    }
    resetProject() {
        this._project = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get projectInput() {
        return this._project;
    }
    get protocol() {
        return this.getStringAttribute('protocol');
    }
    set protocol(value) {
        this._protocol = value;
    }
    resetProtocol() {
        this._protocol = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get protocolInput() {
        return this._protocol;
    }
    get retryConditions() {
        return this.getListAttribute('retry_conditions');
    }
    set retryConditions(value) {
        this._retryConditions = value;
    }
    resetRetryConditions() {
        this._retryConditions = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get retryConditionsInput() {
        return this._retryConditions;
    }
    get timeout() {
        return this._timeout;
    }
    putTimeout(value) {
        this._timeout.internalValue = value;
    }
    resetTimeout() {
        this._timeout.internalValue = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get timeoutInput() {
        return this._timeout.internalValue;
    }
    get timeouts() {
        return this._timeouts;
    }
    putTimeouts(value) {
        this._timeouts.internalValue = value;
    }
    resetTimeouts() {
        this._timeouts.internalValue = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get timeoutsInput() {
        return this._timeouts.internalValue;
    }
    // =========
    // SYNTHESIS
    // =========
    synthesizeAttributes() {
        return {
            description: cdktf.stringToTerraform(this._description),
            failover_origin: cdktf.stringToTerraform(this._failoverOrigin),
            labels: cdktf.hashMapper(cdktf.stringToTerraform)(this._labels),
            max_attempts: cdktf.numberToTerraform(this._maxAttempts),
            name: cdktf.stringToTerraform(this._name),
            origin_address: cdktf.stringToTerraform(this._originAddress),
            port: cdktf.numberToTerraform(this._port),
            project: cdktf.stringToTerraform(this._project),
            protocol: cdktf.stringToTerraform(this._protocol),
            retry_conditions: cdktf.listMapper(cdktf.stringToTerraform)(this._retryConditions),
            timeout: networkServicesEdgeCacheOriginTimeoutToTerraform(this._timeout.internalValue),
            timeouts: networkServicesEdgeCacheOriginTimeoutsToTerraform(this._timeouts.internalValue),
        };
    }
}
exports.NetworkServicesEdgeCacheOrigin = NetworkServicesEdgeCacheOrigin;
_c = JSII_RTTI_SYMBOL_1;
NetworkServicesEdgeCacheOrigin[_c] = { fqn: "@cdktf/provider-google.NetworkServicesEdgeCacheOrigin", version: "0.6.40" };
// =================
// STATIC PROPERTIES
// =================
NetworkServicesEdgeCacheOrigin.tfResourceType = "google_network_services_edge_cache_origin";
//# sourceMappingURL=data:application/json;base64,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