import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface RuntimeconfigConfigIamBindingConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/runtimeconfig_config_iam_binding#config RuntimeconfigConfigIamBinding#config}
    */
    readonly config: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/runtimeconfig_config_iam_binding#members RuntimeconfigConfigIamBinding#members}
    */
    readonly members: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/runtimeconfig_config_iam_binding#project RuntimeconfigConfigIamBinding#project}
    */
    readonly project?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/runtimeconfig_config_iam_binding#role RuntimeconfigConfigIamBinding#role}
    */
    readonly role: string;
    /**
    * condition block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/runtimeconfig_config_iam_binding#condition RuntimeconfigConfigIamBinding#condition}
    */
    readonly condition?: RuntimeconfigConfigIamBindingCondition;
}
export interface RuntimeconfigConfigIamBindingCondition {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/runtimeconfig_config_iam_binding#description RuntimeconfigConfigIamBinding#description}
    */
    readonly description?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/runtimeconfig_config_iam_binding#expression RuntimeconfigConfigIamBinding#expression}
    */
    readonly expression: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/runtimeconfig_config_iam_binding#title RuntimeconfigConfigIamBinding#title}
    */
    readonly title: string;
}
export declare function runtimeconfigConfigIamBindingConditionToTerraform(struct?: RuntimeconfigConfigIamBindingConditionOutputReference | RuntimeconfigConfigIamBindingCondition): any;
export declare class RuntimeconfigConfigIamBindingConditionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): RuntimeconfigConfigIamBindingCondition | undefined;
    set internalValue(value: RuntimeconfigConfigIamBindingCondition | undefined);
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _expression?;
    get expression(): string;
    set expression(value: string);
    get expressionInput(): string | undefined;
    private _title?;
    get title(): string;
    set title(value: string);
    get titleInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google/r/runtimeconfig_config_iam_binding google_runtimeconfig_config_iam_binding}
*/
export declare class RuntimeconfigConfigIamBinding extends cdktf.TerraformResource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google/r/runtimeconfig_config_iam_binding google_runtimeconfig_config_iam_binding} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options RuntimeconfigConfigIamBindingConfig
    */
    constructor(scope: Construct, id: string, config: RuntimeconfigConfigIamBindingConfig);
    private _config?;
    get config(): string;
    set config(value: string);
    get configInput(): string | undefined;
    get etag(): string;
    get id(): string;
    private _members?;
    get members(): string[];
    set members(value: string[]);
    get membersInput(): string[] | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _role?;
    get role(): string;
    set role(value: string);
    get roleInput(): string | undefined;
    private _condition;
    get condition(): RuntimeconfigConfigIamBindingConditionOutputReference;
    putCondition(value: RuntimeconfigConfigIamBindingCondition): void;
    resetCondition(): void;
    get conditionInput(): RuntimeconfigConfigIamBindingCondition | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
