import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface StorageDefaultObjectAccessControlConfig extends cdktf.TerraformMetaArguments {
    /**
    * The name of the bucket.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_default_object_access_control#bucket StorageDefaultObjectAccessControl#bucket}
    */
    readonly bucket: string;
    /**
    * The entity holding the permission, in one of the following forms:
    * user-{{userId}}
    * user-{{email}} (such as "user-liz@example.com")
    * group-{{groupId}}
    * group-{{email}} (such as "group-example@googlegroups.com")
    * domain-{{domain}} (such as "domain-example.com")
    * project-team-{{projectId}}
    * allUsers
    * allAuthenticatedUsers
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_default_object_access_control#entity StorageDefaultObjectAccessControl#entity}
    */
    readonly entity: string;
    /**
    * The name of the object, if applied to an object.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_default_object_access_control#object StorageDefaultObjectAccessControl#object}
    */
    readonly object?: string;
    /**
    * The access permission for the entity. Possible values: ["OWNER", "READER"]
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_default_object_access_control#role StorageDefaultObjectAccessControl#role}
    */
    readonly role: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_default_object_access_control#timeouts StorageDefaultObjectAccessControl#timeouts}
    */
    readonly timeouts?: StorageDefaultObjectAccessControlTimeouts;
}
export declare class StorageDefaultObjectAccessControlProjectTeam extends cdktf.ComplexComputedList {
    get projectNumber(): string;
    get team(): string;
}
export interface StorageDefaultObjectAccessControlTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_default_object_access_control#create StorageDefaultObjectAccessControl#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_default_object_access_control#delete StorageDefaultObjectAccessControl#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_default_object_access_control#update StorageDefaultObjectAccessControl#update}
    */
    readonly update?: string;
}
export declare function storageDefaultObjectAccessControlTimeoutsToTerraform(struct?: StorageDefaultObjectAccessControlTimeoutsOutputReference | StorageDefaultObjectAccessControlTimeouts | cdktf.IResolvable): any;
export declare class StorageDefaultObjectAccessControlTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): StorageDefaultObjectAccessControlTimeouts | undefined;
    set internalValue(value: StorageDefaultObjectAccessControlTimeouts | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google/r/storage_default_object_access_control google_storage_default_object_access_control}
*/
export declare class StorageDefaultObjectAccessControl extends cdktf.TerraformResource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google/r/storage_default_object_access_control google_storage_default_object_access_control} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options StorageDefaultObjectAccessControlConfig
    */
    constructor(scope: Construct, id: string, config: StorageDefaultObjectAccessControlConfig);
    private _bucket?;
    get bucket(): string;
    set bucket(value: string);
    get bucketInput(): string | undefined;
    get domain(): string;
    get email(): string;
    private _entity?;
    get entity(): string;
    set entity(value: string);
    get entityInput(): string | undefined;
    get entityId(): string;
    get generation(): number;
    get id(): string;
    private _object?;
    get object(): string;
    set object(value: string);
    resetObject(): void;
    get objectInput(): string | undefined;
    projectTeam(index: string): StorageDefaultObjectAccessControlProjectTeam;
    private _role?;
    get role(): string;
    set role(value: string);
    get roleInput(): string | undefined;
    private _timeouts;
    get timeouts(): StorageDefaultObjectAccessControlTimeoutsOutputReference;
    putTimeouts(value: StorageDefaultObjectAccessControlTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): StorageDefaultObjectAccessControlTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
