# pygt3x
![Tests](https://github.com/actigraph/pygt3x/actions/workflows/tests.yml/badge.svg)

Python module for reading GT3X/AGDC file format data generated by ActiGraph devices.

## Example Usage

To read calibrated accelerometer data, you can use the code snippet below:

```python
from pygt3x.reader import FileReader
from pygt3x.calibration import CalibratedReader

# Read raw data and calibrate
# Dump to pandas data frame
with FileReader("FILENAME") as reader:
    calibrated_reader = CalibratedReader(reader)
    df = calibrated_reader.to_pandas()
    print(df.head(5))
```

If your AGDC file contains temperature data, you can read it using:

```python
from pygt3x.reader import FileReader
from pygt3x.calibration import CalibratedReader

with FileReader("FILENAME") as reader:
    calibrated_reader = CalibratedReader(reader)
    df = calibrated_reader.temperature_to_pandas()
    print(df.head(5))
```