import datetime as dt
from typing import Any, Union

from emitime.conversion import Number as Number
from emitime.conversion import add_conversion_methods as add_conversion_methods
from emitime.conversion import is_moment_str as is_moment_str
from emitime.conversion import is_time_str as is_time_str

LikeInterval = Union[str, dt.timedelta, dt.time, Interval]
LikeMoment = Union[str, dt.date, dt.datetime, Moment]

def upI(value: LikeInterval) -> dt.timedelta: ...
def upM(value: LikeMoment) -> dt.datetime: ...
def is_interval(value: Any) -> bool: ...
def is_moment(value: Any) -> bool: ...

class Interval:
    def __init__(self, *args, **kwargs) -> None: ...
    @property
    def timedelta(self) -> dt.timedelta: ...
    @timedelta.setter
    def timedelta(self, value: LikeInterval) -> None: ...
    def __add__(
        self, other: Union["Interval", "Moment"]
    ) -> Union["Interval", "Moment"]: ...
    def __radd__(  # type: ignore
        self, other: Union["Interval", "Moment"]
    ) -> Union["Interval", "Moment"]: ...
    def __sub__(self, other: LikeInterval) -> Interval: ...
    def __rsub__(
        self, other: Union[LikeInterval, LikeMoment]
    ) -> Union["Interval", "Moment"]: ...
    def __mul__(self, other: Number) -> Interval: ...
    def __rmul__(self, other: Number) -> Interval: ...
    def __floordiv__(self, other: LikeInterval) -> int: ...
    def __mod__(self, other: LikeInterval) -> Interval: ...
    def __lt__(self, other: LikeInterval) -> bool: ...
    def __le__(self, other: LikeInterval) -> bool: ...
    def __eq__(self, other: LikeInterval) -> bool: ...  # type: ignore
    def __gt__(self, other: LikeInterval) -> bool: ...
    def __ge__(self, other: LikeInterval) -> bool: ...
    def __float__(self) -> float: ...

class Moment:
    def __init__(self, *args, **kwargs) -> None: ...
    @property
    def datetime(self) -> dt.datetime: ...
    @datetime.setter
    def datetime(self, value: LikeMoment) -> None: ...
    @property
    def date(self) -> dt.date: ...
    @date.setter
    def date(self, value: dt.date) -> None: ...
    @date.setter
    def date(self, value: str) -> None: ...
    @property
    def time(self) -> dt.time: ...
    @time.setter
    def time(self, value: dt.time) -> None: ...
    @time.setter
    def time(self, value: str) -> None: ...
    def __sub__(
        self, other: Union[LikeInterval, LikeMoment]
    ) -> Union[Interval, Moment]: ...
    def __rsub__(self, other: LikeMoment) -> Interval: ...
    def __add__(self, other: LikeInterval) -> Moment: ...
    def __radd__(self, other: LikeInterval) -> Moment: ...
    def __lt__(self, other: LikeMoment) -> bool: ...
    def __le__(self, other: LikeMoment) -> bool: ...
    def __eq__(self, other: LikeMoment) -> bool: ...  # type: ignore
    def __gt__(self, other: LikeMoment) -> bool: ...
    def __ge__(self, other: LikeMoment) -> bool: ...
    def __float__(self) -> float: ...
