"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.OpsworksCm = void 0;
const shared_1 = require("../shared");
/**
 * Statement provider for service [opsworks-cm](https://docs.aws.amazon.com/IAM/latest/UserGuide/list_awsopsworksconfigurationmanagement.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
class OpsworksCm extends shared_1.PolicyStatement {
    /**
     * Statement provider for service [opsworks-cm](https://docs.aws.amazon.com/IAM/latest/UserGuide/list_awsopsworksconfigurationmanagement.html).
     *
     * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
     */
    constructor(sid) {
        super(sid);
        this.servicePrefix = 'opsworks-cm';
        this.accessLevelList = {
            "Write": [
                "AssociateNode",
                "CreateBackup",
                "CreateServer",
                "DeleteBackup",
                "DeleteServer",
                "DisassociateNode",
                "RestoreServer",
                "StartMaintenance",
                "UpdateServer",
                "UpdateServerEngineAttributes"
            ],
            "List": [
                "DescribeAccountAttributes",
                "DescribeBackups",
                "DescribeEvents",
                "DescribeNodeAssociationStatus",
                "DescribeServers"
            ]
        };
    }
    /**
     * Associate a node to a configuration management server.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/opsworks-cm/latest/APIReference/API_AssociateNode.html
     */
    toAssociateNode() {
        this.to('opsworks-cm:AssociateNode');
        return this;
    }
    /**
     * Create a backup for the specified server.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/opsworks-cm/latest/APIReference/API_CreateBackup.html
     */
    toCreateBackup() {
        this.to('opsworks-cm:CreateBackup');
        return this;
    }
    /**
     * Create a new server.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/opsworks-cm/latest/APIReference/API_CreateServer.html
     */
    toCreateServer() {
        this.to('opsworks-cm:CreateServer');
        return this;
    }
    /**
     * Delete the specified backup and possibly its S3 bucket.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/opsworks-cm/latest/APIReference/API_DeleteBackup.html
     */
    toDeleteBackup() {
        this.to('opsworks-cm:DeleteBackup');
        return this;
    }
    /**
     * Deletes the specified server with his corresponding CF stack and possibly the S3 bucket.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/opsworks-cm/latest/APIReference/API_DeleteServer.html
     */
    toDeleteServer() {
        this.to('opsworks-cm:DeleteServer');
        return this;
    }
    /**
     * Describe the service limits for the user's account.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/opsworks-cm/latest/APIReference/API_DescribeAccountAttributes.html
     */
    toDescribeAccountAttributes() {
        this.to('opsworks-cm:DescribeAccountAttributes');
        return this;
    }
    /**
     * Describe a single backup, all backups of a specified server or all backups of the user's account.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/opsworks-cm/latest/APIReference/API_DescribeBackups.html
     */
    toDescribeBackups() {
        this.to('opsworks-cm:DescribeBackups');
        return this;
    }
    /**
     * Describe all events of the specified server.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/opsworks-cm/latest/APIReference/API_DescribeEvents.html
     */
    toDescribeEvents() {
        this.to('opsworks-cm:DescribeEvents');
        return this;
    }
    /**
     * Describe the association status for the specified node token and the specified server.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/opsworks-cm/latest/APIReference/API_DescribeNodeAssociationStatus.html
     */
    toDescribeNodeAssociationStatus() {
        this.to('opsworks-cm:DescribeNodeAssociationStatus');
        return this;
    }
    /**
     * Describes the specified server or all servers of the user's account.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/opsworks-cm/latest/APIReference/API_DescribeServers.html
     */
    toDescribeServers() {
        this.to('opsworks-cm:DescribeServers');
        return this;
    }
    /**
     * Disassociates a specified node from a server.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/opsworks-cm/latest/APIReference/API_DisassociateNode.html
     */
    toDisassociateNode() {
        this.to('opsworks-cm:DisassociateNode');
        return this;
    }
    /**
     * Applies a backup to specified server. Possibly swaps out the ec2-instance if specified.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/opsworks-cm/latest/APIReference/API_RestoreServer.html
     */
    toRestoreServer() {
        this.to('opsworks-cm:RestoreServer');
        return this;
    }
    /**
     * Start the server maintenance immediately.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/opsworks-cm/latest/APIReference/API_StartMaintenance.html
     */
    toStartMaintenance() {
        this.to('opsworks-cm:StartMaintenance');
        return this;
    }
    /**
     * Update general server settings.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/opsworks-cm/latest/APIReference/API_UpdateServer.html
     */
    toUpdateServer() {
        this.to('opsworks-cm:UpdateServer');
        return this;
    }
    /**
     * Update server settings specific to the configuration management type.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/opsworks-cm/latest/APIReference/API_UpdateServerEngineAttributes.html
     */
    toUpdateServerEngineAttributes() {
        this.to('opsworks-cm:UpdateServerEngineAttributes');
        return this;
    }
}
exports.OpsworksCm = OpsworksCm;
//# sourceMappingURL=data:application/json;base64,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