import { AccessLevelList } from "../shared/access-level";
import { PolicyStatement } from "../shared";
/**
 * Statement provider for service [timestream](https://docs.aws.amazon.com/IAM/latest/UserGuide/list_awstimestream.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
export declare class Timestream extends PolicyStatement {
    servicePrefix: string;
    /**
     * Statement provider for service [timestream](https://docs.aws.amazon.com/IAM/latest/UserGuide/list_awstimestream.html).
     *
     * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
     */
    constructor(sid?: string);
    /**
     * Grants Permission to cancel queries in your account
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/Timestream/latest/APIReference/API_CancelQuery.html
     */
    toCancelQuery(): this;
    /**
     * Grants permissions to create a database in your account.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/Timestream/latest/APIReference/API_CreateDatabase.html
     */
    toCreateDatabase(): this;
    /**
     * Grants permissions to create a table in your account.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/Timestream/latest/APIReference/API_CreateTable.html
     */
    toCreateTable(): this;
    /**
     * Grants permissions to delete a database in your account.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/Timestream/latest/APIReference/API_DeleteDatabase.html
     */
    toDeleteDatabase(): this;
    /**
     * Grants permissions to delete a table in your account.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/Timestream/latest/APIReference/API_DeleteTable.html
     */
    toDeleteTable(): this;
    /**
     * Grants permissions to describe a database in your account.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/Timestream/latest/APIReference/API_DescribeDatabase.html
     */
    toDescribeDatabase(): this;
    /**
     * Grants permissions to describe timestream endpoints.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/Timestream/latest/APIReference/API_DescribeEndpoints.html
     */
    toDescribeEndpoints(): this;
    /**
     * Grants Permissions to describe a table in your account
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/Timestream/latest/APIReference/API_DescribeTable.html
     */
    toDescribeTable(): this;
    /**
     * Grants Permission to list databases in your account
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/Timestream/latest/APIReference/API_ListDatabases.html
     */
    toListDatabases(): this;
    /**
     * Grants Permissions to list measures of a table in your account
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/Timestream/latest/APIReference/API_ListMeasures.html
     */
    toListMeasures(): this;
    /**
     * Grants Permission to list tables in your account
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/Timestream/latest/APIReference/API_ListTables.html
     */
    toListTables(): this;
    /**
     * Grants permissions to list tags of a resource in your account.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/Timestream/latest/APIReference/API_ListTagsForResource.html
     */
    toListTagsForResource(): this;
    /**
     * Grants Permission to issue 'select from table' queries
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/Timestream/latest/APIReference/API_Query.html
     */
    toSelect(): this;
    /**
     * Grants Permissions to issue 'select 1' queries
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/Timestream/latest/APIReference/API_Query.html
     */
    toSelectValues(): this;
    /**
     * Grants permissions to add tags to a resource.
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/Timestream/latest/APIReference/API_TagResource.html
     */
    toTagResource(): this;
    /**
     * Grants permissions to remove a tag from a resource.
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/Timestream/latest/APIReference/API_UntagResource.html
     */
    toUntagResource(): this;
    /**
     * Grants permissions to update a database in your account.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/Timestream/latest/APIReference/API_UpdateDatabase.html
     */
    toUpdateDatabase(): this;
    /**
     * Grants permissions to update a table in your account.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/Timestream/latest/APIReference/API_UpdateTable.html
     */
    toUpdateTable(): this;
    /**
     * Grants permissions to ingest data to a table in your account.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/Timestream/latest/APIReference/API_WriteRecords.html
     */
    toWriteRecords(): this;
    protected accessLevelList: AccessLevelList;
    /**
     * Adds a resource of type database to the statement
     *
     * https://docs.aws.amazon.com/Timestream/latest/UserGuide/database-example-policies.html
     *
     * @param databaseName - Identifier for the databaseName.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onDatabase(databaseName: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type table to the statement
     *
     * https://docs.aws.amazon.com/Timestream/latest/UserGuide/table-example-policies.html
     *
     * @param databaseName - Identifier for the databaseName.
     * @param tableName - Identifier for the tableName.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onTable(databaseName: string, tableName: string, account?: string, region?: string, partition?: string): this;
}
