# Metadata

One of the TuxBuild artifacts is a file called `metadata.json`. This file is
produced by [TuxMake](https://tuxmake.org) and contains details of the build
environment and the build results. An example `metadata.json` file is listed
below.

```json
{
    "artifacts": {
        "dtbs": [
            "dtbs/al/alpine-v2-evp.dtb",
            "dtbs/allwinner/sun50i-a64-amarula-relic.dtb",
            "dtbs/allwinner/sun50i-a64-bananapi-m64.dtb",
            "dtbs/allwinner/sun50i-a64-nanopi-a64.dtb",
            "dtbs/allwinner/sun50i-a64-oceanic-5205-5inmfd.dtb",
            "dtbs/allwinner/sun50i-a64-olinuxino-emmc.dtb",
            "dtbs/allwinner/sun50i-a64-olinuxino.dtb",
            "dtbs/allwinner/sun50i-a64-orangepi-win.dtb",
            "dtbs/allwinner/sun50i-a64-pine64-lts.dtb",
            "dtbs/allwinner/sun50i-a64-pine64-plus.dtb",
            "dtbs/allwinner/sun50i-a64-pine64.dtb",
            "dtbs/allwinner/sun50i-a64-pinebook.dtb",
            "dtbs/allwinner/sun50i-a64-sopine-baseboard.dtb",
            "dtbs/allwinner/sun50i-a64-teres-i.dtb",
            "dtbs/allwinner/sun50i-h5-bananapi-m2-plus-v1.2.dtb",
            "dtbs/allwinner/sun50i-h5-bananapi-m2-plus.dtb",
            "dtbs/allwinner/sun50i-h5-emlid-neutis-n5-devboard.dtb",
            "dtbs/allwinner/sun50i-h5-libretech-all-h3-cc.dtb",
            "dtbs/allwinner/sun50i-h5-nanopi-neo-plus2.dtb",
            "dtbs/allwinner/sun50i-h5-nanopi-neo2.dtb",
            "dtbs/allwinner/sun50i-h5-orangepi-pc2.dtb",
            "dtbs/allwinner/sun50i-h5-orangepi-prime.dtb",
            "dtbs/allwinner/sun50i-h5-orangepi-zero-plus.dtb",
            "dtbs/allwinner/sun50i-h5-orangepi-zero-plus2.dtb",
            "dtbs/allwinner/sun50i-h6-beelink-gs1.dtb",
            "dtbs/allwinner/sun50i-h6-orangepi-3.dtb",
            "dtbs/allwinner/sun50i-h6-orangepi-lite2.dtb",
            "dtbs/allwinner/sun50i-h6-orangepi-one-plus.dtb",
            "dtbs/allwinner/sun50i-h6-pine-h64.dtb",
            "dtbs/allwinner/sun50i-h6-tanix-tx6.dtb",
            "dtbs/altera/socfpga_stratix10_socdk.dtb",
            "dtbs/amd/amd-overdrive-rev-b0.dtb",
            "dtbs/amd/amd-overdrive-rev-b1.dtb",
            "dtbs/amd/amd-overdrive.dtb",
            "dtbs/amd/husky.dtb",
            "dtbs/amlogic/meson-axg-s400.dtb",
            "dtbs/amlogic/meson-g12a-sei510.dtb",
            "dtbs/amlogic/meson-g12a-u200.dtb",
            "dtbs/amlogic/meson-g12a-x96-max.dtb",
            "dtbs/amlogic/meson-g12b-a311d-khadas-vim3.dtb",
            "dtbs/amlogic/meson-g12b-odroid-n2.dtb",
            "dtbs/amlogic/meson-g12b-s922x-khadas-vim3.dtb",
            "dtbs/amlogic/meson-gxbb-nanopi-k2.dtb",
            "dtbs/amlogic/meson-gxbb-nexbox-a95x.dtb",
            "dtbs/amlogic/meson-gxbb-odroidc2.dtb",
            "dtbs/amlogic/meson-gxbb-p200.dtb",
            "dtbs/amlogic/meson-gxbb-p201.dtb",
            "dtbs/amlogic/meson-gxbb-vega-s95-meta.dtb",
            "dtbs/amlogic/meson-gxbb-vega-s95-pro.dtb",
            "dtbs/amlogic/meson-gxbb-vega-s95-telos.dtb",
            "dtbs/amlogic/meson-gxbb-wetek-hub.dtb",
            "dtbs/amlogic/meson-gxbb-wetek-play2.dtb",
            "dtbs/amlogic/meson-gxl-s805x-libretech-ac.dtb",
            "dtbs/amlogic/meson-gxl-s805x-p241.dtb",
            "dtbs/amlogic/meson-gxl-s905d-p230.dtb",
            "dtbs/amlogic/meson-gxl-s905d-p231.dtb",
            "dtbs/amlogic/meson-gxl-s905d-phicomm-n1.dtb",
            "dtbs/amlogic/meson-gxl-s905w-p281.dtb",
            "dtbs/amlogic/meson-gxl-s905w-tx3-mini.dtb",
            "dtbs/amlogic/meson-gxl-s905x-hwacom-amazetv.dtb",
            "dtbs/amlogic/meson-gxl-s905x-khadas-vim.dtb",
            "dtbs/amlogic/meson-gxl-s905x-libretech-cc.dtb",
            "dtbs/amlogic/meson-gxl-s905x-nexbox-a95x.dtb",
            "dtbs/amlogic/meson-gxl-s905x-p212.dtb",
            "dtbs/amlogic/meson-gxm-khadas-vim2.dtb",
            "dtbs/amlogic/meson-gxm-nexbox-a1.dtb",
            "dtbs/amlogic/meson-gxm-q200.dtb",
            "dtbs/amlogic/meson-gxm-q201.dtb",
            "dtbs/amlogic/meson-gxm-rbox-pro.dtb",
            "dtbs/amlogic/meson-gxm-vega-s96.dtb",
            "dtbs/amlogic/meson-sm1-khadas-vim3l.dtb",
            "dtbs/amlogic/meson-sm1-sei610.dtb",
            "dtbs/apm/apm-merlin.dtb",
            "dtbs/apm/apm-mustang.dtb",
            "dtbs/arm/foundation-v8-gicv3-psci.dtb",
            "dtbs/arm/foundation-v8-gicv3.dtb",
            "dtbs/arm/foundation-v8-psci.dtb",
            "dtbs/arm/foundation-v8.dtb",
            "dtbs/arm/fvp-base-revc.dtb",
            "dtbs/arm/juno-r1.dtb",
            "dtbs/arm/juno-r2.dtb",
            "dtbs/arm/juno.dtb",
            "dtbs/arm/rtsm_ve-aemv8a.dtb",
            "dtbs/arm/vexpress-v2f-1xv7-ca53x2.dtb",
            "dtbs/broadcom/bcm2837-rpi-3-a-plus.dtb",
            "dtbs/broadcom/bcm2837-rpi-3-b-plus.dtb",
            "dtbs/broadcom/bcm2837-rpi-3-b.dtb",
            "dtbs/broadcom/bcm2837-rpi-cm3-io3.dtb",
            "dtbs/broadcom/northstar2/ns2-svk.dtb",
            "dtbs/broadcom/northstar2/ns2-xmc.dtb",
            "dtbs/broadcom/stingray/bcm958742k.dtb",
            "dtbs/broadcom/stingray/bcm958742t.dtb",
            "dtbs/broadcom/stingray/bcm958802a802x.dtb",
            "dtbs/cavium/thunder-88xx.dtb",
            "dtbs/cavium/thunder2-99xx.dtb",
            "dtbs/exynos/exynos5433-tm2.dtb",
            "dtbs/exynos/exynos5433-tm2e.dtb",
            "dtbs/exynos/exynos7-espresso.dtb",
            "dtbs/freescale/fsl-ls1012a-frdm.dtb",
            "dtbs/freescale/fsl-ls1012a-frwy.dtb",
            "dtbs/freescale/fsl-ls1012a-oxalis.dtb",
            "dtbs/freescale/fsl-ls1012a-qds.dtb",
            "dtbs/freescale/fsl-ls1012a-rdb.dtb",
            "dtbs/freescale/fsl-ls1028a-qds.dtb",
            "dtbs/freescale/fsl-ls1028a-rdb.dtb",
            "dtbs/freescale/fsl-ls1043a-qds.dtb",
            "dtbs/freescale/fsl-ls1043a-rdb.dtb",
            "dtbs/freescale/fsl-ls1046a-frwy.dtb",
            "dtbs/freescale/fsl-ls1046a-qds.dtb",
            "dtbs/freescale/fsl-ls1046a-rdb.dtb",
            "dtbs/freescale/fsl-ls1088a-qds.dtb",
            "dtbs/freescale/fsl-ls1088a-rdb.dtb",
            "dtbs/freescale/fsl-ls2080a-qds.dtb",
            "dtbs/freescale/fsl-ls2080a-rdb.dtb",
            "dtbs/freescale/fsl-ls2080a-simu.dtb",
            "dtbs/freescale/fsl-ls2088a-qds.dtb",
            "dtbs/freescale/fsl-ls2088a-rdb.dtb",
            "dtbs/freescale/fsl-lx2160a-qds.dtb",
            "dtbs/freescale/fsl-lx2160a-rdb.dtb",
            "dtbs/freescale/imx8mm-evk.dtb",
            "dtbs/freescale/imx8mn-ddr4-evk.dtb",
            "dtbs/freescale/imx8mq-evk.dtb",
            "dtbs/freescale/imx8mq-hummingboard-pulse.dtb",
            "dtbs/freescale/imx8mq-librem5-devkit.dtb",
            "dtbs/freescale/imx8mq-nitrogen.dtb",
            "dtbs/freescale/imx8mq-pico-pi.dtb",
            "dtbs/freescale/imx8mq-zii-ultra-rmb3.dtb",
            "dtbs/freescale/imx8mq-zii-ultra-zest.dtb",
            "dtbs/freescale/imx8qxp-ai_ml.dtb",
            "dtbs/freescale/imx8qxp-mek.dtb",
            "dtbs/hisilicon/hi3660-hikey960.dtb",
            "dtbs/hisilicon/hi3670-hikey970.dtb",
            "dtbs/hisilicon/hi3798cv200-poplar.dtb",
            "dtbs/hisilicon/hi6220-hikey.dtb",
            "dtbs/hisilicon/hip05-d02.dtb",
            "dtbs/hisilicon/hip06-d03.dtb",
            "dtbs/hisilicon/hip07-d05.dtb",
            "dtbs/intel/socfpga_agilex_socdk.dtb",
            "dtbs/lg/lg1312-ref.dtb",
            "dtbs/lg/lg1313-ref.dtb",
            "dtbs/marvell/armada-3720-db.dtb",
            "dtbs/marvell/armada-3720-espressobin.dtb",
            "dtbs/marvell/armada-3720-turris-mox.dtb",
            "dtbs/marvell/armada-3720-uDPU.dtb",
            "dtbs/marvell/armada-7040-db.dtb",
            "dtbs/marvell/armada-8040-clearfog-gt-8k.dtb",
            "dtbs/marvell/armada-8040-db.dtb",
            "dtbs/marvell/armada-8040-mcbin-singleshot.dtb",
            "dtbs/marvell/armada-8040-mcbin.dtb",
            "dtbs/marvell/armada-8080-db.dtb",
            "dtbs/mediatek/mt2712-evb.dtb",
            "dtbs/mediatek/mt6755-evb.dtb",
            "dtbs/mediatek/mt6795-evb.dtb",
            "dtbs/mediatek/mt6797-evb.dtb",
            "dtbs/mediatek/mt6797-x20-dev.dtb",
            "dtbs/mediatek/mt7622-bananapi-bpi-r64.dtb",
            "dtbs/mediatek/mt7622-rfb1.dtb",
            "dtbs/mediatek/mt8173-evb.dtb",
            "dtbs/mediatek/mt8183-evb.dtb",
            "dtbs/nvidia/tegra132-norrin.dtb",
            "dtbs/nvidia/tegra186-p2771-0000.dtb",
            "dtbs/nvidia/tegra194-p2972-0000.dtb",
            "dtbs/nvidia/tegra210-p2371-0000.dtb",
            "dtbs/nvidia/tegra210-p2371-2180.dtb",
            "dtbs/nvidia/tegra210-p2571.dtb",
            "dtbs/nvidia/tegra210-p2894-0050-a08.dtb",
            "dtbs/nvidia/tegra210-p3450-0000.dtb",
            "dtbs/nvidia/tegra210-smaug.dtb",
            "dtbs/qcom/apq8016-sbc.dtb",
            "dtbs/qcom/apq8096-db820c.dtb",
            "dtbs/qcom/ipq8074-hk01.dtb",
            "dtbs/qcom/msm8916-longcheer-l8150.dtb",
            "dtbs/qcom/msm8916-mtp.dtb",
            "dtbs/qcom/msm8916-samsung-a3u-eur.dtb",
            "dtbs/qcom/msm8916-samsung-a5u-eur.dtb",
            "dtbs/qcom/msm8992-bullhead-rev-101.dtb",
            "dtbs/qcom/msm8994-angler-rev-101.dtb",
            "dtbs/qcom/msm8996-mtp.dtb",
            "dtbs/qcom/msm8998-asus-novago-tp370ql.dtb",
            "dtbs/qcom/msm8998-hp-envy-x2.dtb",
            "dtbs/qcom/msm8998-lenovo-miix-630.dtb",
            "dtbs/qcom/msm8998-mtp.dtb",
            "dtbs/qcom/qcs404-evb-1000.dtb",
            "dtbs/qcom/qcs404-evb-4000.dtb",
            "dtbs/qcom/sdm845-cheza-r1.dtb",
            "dtbs/qcom/sdm845-cheza-r2.dtb",
            "dtbs/qcom/sdm845-cheza-r3.dtb",
            "dtbs/qcom/sdm845-db845c.dtb",
            "dtbs/qcom/sdm845-mtp.dtb",
            "dtbs/qcom/sdm850-lenovo-yoga-c630.dtb",
            "dtbs/qcom/sm8150-mtp.dtb",
            "dtbs/renesas/r8a774a1-hihope-rzg2m-ex.dtb",
            "dtbs/renesas/r8a774a1-hihope-rzg2m.dtb",
            "dtbs/renesas/r8a774c0-cat874.dtb",
            "dtbs/renesas/r8a774c0-ek874.dtb",
            "dtbs/renesas/r8a7795-es1-h3ulcb-kf.dtb",
            "dtbs/renesas/r8a7795-es1-h3ulcb.dtb",
            "dtbs/renesas/r8a7795-es1-salvator-x.dtb",
            "dtbs/renesas/r8a7795-h3ulcb-kf.dtb",
            "dtbs/renesas/r8a7795-h3ulcb.dtb",
            "dtbs/renesas/r8a7795-salvator-x.dtb",
            "dtbs/renesas/r8a7795-salvator-xs.dtb",
            "dtbs/renesas/r8a7796-m3ulcb-kf.dtb",
            "dtbs/renesas/r8a7796-m3ulcb.dtb",
            "dtbs/renesas/r8a7796-salvator-x.dtb",
            "dtbs/renesas/r8a7796-salvator-xs.dtb",
            "dtbs/renesas/r8a77965-m3nulcb-kf.dtb",
            "dtbs/renesas/r8a77965-m3nulcb.dtb",
            "dtbs/renesas/r8a77965-salvator-x.dtb",
            "dtbs/renesas/r8a77965-salvator-xs.dtb",
            "dtbs/renesas/r8a77970-eagle.dtb",
            "dtbs/renesas/r8a77970-v3msk.dtb",
            "dtbs/renesas/r8a77980-condor.dtb",
            "dtbs/renesas/r8a77980-v3hsk.dtb",
            "dtbs/renesas/r8a77990-ebisu.dtb",
            "dtbs/renesas/r8a77995-draak.dtb",
            "dtbs/rockchip/px30-evb.dtb",
            "dtbs/rockchip/rk3328-evb.dtb",
            "dtbs/rockchip/rk3328-roc-cc.dtb",
            "dtbs/rockchip/rk3328-rock64.dtb",
            "dtbs/rockchip/rk3368-evb-act8846.dtb",
            "dtbs/rockchip/rk3368-geekbox.dtb",
            "dtbs/rockchip/rk3368-lion-haikou.dtb",
            "dtbs/rockchip/rk3368-orion-r68-meta.dtb",
            "dtbs/rockchip/rk3368-px5-evb.dtb",
            "dtbs/rockchip/rk3368-r88.dtb",
            "dtbs/rockchip/rk3399-evb.dtb",
            "dtbs/rockchip/rk3399-ficus.dtb",
            "dtbs/rockchip/rk3399-firefly.dtb",
            "dtbs/rockchip/rk3399-gru-bob.dtb",
            "dtbs/rockchip/rk3399-gru-kevin.dtb",
            "dtbs/rockchip/rk3399-gru-scarlet-inx.dtb",
            "dtbs/rockchip/rk3399-gru-scarlet-kd.dtb",
            "dtbs/rockchip/rk3399-hugsun-x99.dtb",
            "dtbs/rockchip/rk3399-khadas-edge-captain.dtb",
            "dtbs/rockchip/rk3399-khadas-edge-v.dtb",
            "dtbs/rockchip/rk3399-khadas-edge.dtb",
            "dtbs/rockchip/rk3399-leez-p710.dtb",
            "dtbs/rockchip/rk3399-nanopc-t4.dtb",
            "dtbs/rockchip/rk3399-nanopi-m4.dtb",
            "dtbs/rockchip/rk3399-nanopi-neo4.dtb",
            "dtbs/rockchip/rk3399-orangepi.dtb",
            "dtbs/rockchip/rk3399-puma-haikou.dtb",
            "dtbs/rockchip/rk3399-roc-pc.dtb",
            "dtbs/rockchip/rk3399-rock-pi-4.dtb",
            "dtbs/rockchip/rk3399-rock960.dtb",
            "dtbs/rockchip/rk3399-rockpro64.dtb",
            "dtbs/rockchip/rk3399-sapphire-excavator.dtb",
            "dtbs/rockchip/rk3399-sapphire.dtb",
            "dtbs/socionext/uniphier-ld11-global.dtb",
            "dtbs/socionext/uniphier-ld11-ref.dtb",
            "dtbs/socionext/uniphier-ld20-global.dtb",
            "dtbs/socionext/uniphier-ld20-ref.dtb",
            "dtbs/socionext/uniphier-pxs3-ref.dtb",
            "dtbs/sprd/sc9836-openphone.dtb",
            "dtbs/sprd/sp9860g-1h10.dtb",
            "dtbs/synaptics/berlin4ct-dmp.dtb",
            "dtbs/synaptics/berlin4ct-stb.dtb",
            "dtbs/ti/k3-am654-base-board.dtb",
            "dtbs/ti/k3-j721e-common-proc-board.dtb",
            "dtbs/xilinx/avnet-ultra96-rev1.dtb",
            "dtbs/xilinx/zynqmp-zc1232-revA.dtb",
            "dtbs/xilinx/zynqmp-zc1254-revA.dtb",
            "dtbs/xilinx/zynqmp-zc1275-revA.dtb",
            "dtbs/xilinx/zynqmp-zc1751-xm015-dc1.dtb",
            "dtbs/xilinx/zynqmp-zc1751-xm016-dc2.dtb",
            "dtbs/xilinx/zynqmp-zc1751-xm017-dc3.dtb",
            "dtbs/xilinx/zynqmp-zc1751-xm018-dc4.dtb",
            "dtbs/xilinx/zynqmp-zc1751-xm019-dc5.dtb",
            "dtbs/xilinx/zynqmp-zcu100-revC.dtb",
            "dtbs/xilinx/zynqmp-zcu102-rev1.0.dtb",
            "dtbs/xilinx/zynqmp-zcu102-revA.dtb",
            "dtbs/xilinx/zynqmp-zcu102-revB.dtb",
            "dtbs/xilinx/zynqmp-zcu104-revA.dtb",
            "dtbs/xilinx/zynqmp-zcu106-revA.dtb",
            "dtbs/xilinx/zynqmp-zcu111-revA.dtb",
            "dtbs/zte/zx296718-evb.dtb",
            "dtbs/zte/zx296718-pcbox.dtb"
        ],
        "modules": [
            "lib/modules/5.4.100/build",
            "lib/modules/5.4.100/kernel/arch/arm64/crypto/aes-neon-blk.ko",
            "lib/modules/5.4.100/kernel/arch/arm64/crypto/aes-neon-bs.ko",
            "lib/modules/5.4.100/kernel/arch/arm64/crypto/chacha-neon.ko",
            "lib/modules/5.4.100/kernel/arch/arm64/crypto/crct10dif-ce.ko",
            "lib/modules/5.4.100/kernel/arch/arm64/crypto/sha3-ce.ko",
            "lib/modules/5.4.100/kernel/arch/arm64/crypto/sha512-arm64.ko",
            "lib/modules/5.4.100/kernel/arch/arm64/crypto/sha512-ce.ko",
            "lib/modules/5.4.100/kernel/arch/arm64/crypto/sm3-ce.ko",
            "lib/modules/5.4.100/kernel/arch/arm64/lib/xor-neon.ko",
            "lib/modules/5.4.100/kernel/block/bfq.ko",
            "lib/modules/5.4.100/kernel/crypto/algif_hash.ko",
            "lib/modules/5.4.100/kernel/crypto/xor.ko",
            "lib/modules/5.4.100/kernel/drivers/block/nbd.ko",
            "lib/modules/5.4.100/kernel/drivers/bluetooth/btbcm.ko",
            "lib/modules/5.4.100/kernel/drivers/bluetooth/btintel.ko",
            "lib/modules/5.4.100/kernel/drivers/bluetooth/btrtl.ko",
            "lib/modules/5.4.100/kernel/drivers/bluetooth/btusb.ko",
            "lib/modules/5.4.100/kernel/drivers/bluetooth/hci_uart.ko",
            "lib/modules/5.4.100/kernel/drivers/char/hw_random/bcm2835-rng.ko",
            "lib/modules/5.4.100/kernel/drivers/char/hw_random/cavium-rng-vf.ko",
            "lib/modules/5.4.100/kernel/drivers/char/hw_random/cavium-rng.ko",
            "lib/modules/5.4.100/kernel/drivers/char/hw_random/exynos-trng.ko",
            "lib/modules/5.4.100/kernel/drivers/char/hw_random/hisi-rng.ko",
            "lib/modules/5.4.100/kernel/drivers/char/hw_random/imx-rngc.ko",
            "lib/modules/5.4.100/kernel/drivers/char/hw_random/iproc-rng200.ko",
            "lib/modules/5.4.100/kernel/drivers/char/hw_random/meson-rng.ko",
            "lib/modules/5.4.100/kernel/drivers/char/hw_random/mtk-rng.ko",
            "lib/modules/5.4.100/kernel/drivers/char/hw_random/omap-rng.ko",
            "lib/modules/5.4.100/kernel/drivers/char/hw_random/optee-rng.ko",
            "lib/modules/5.4.100/kernel/drivers/char/hw_random/rng-core.ko",
            "lib/modules/5.4.100/kernel/drivers/char/hw_random/xgene-rng.ko",
            "lib/modules/5.4.100/kernel/drivers/char/ipmi/ipmi_devintf.ko",
            "lib/modules/5.4.100/kernel/drivers/char/ipmi/ipmi_msghandler.ko",
            "lib/modules/5.4.100/kernel/drivers/char/ipmi/ipmi_si.ko",
            "lib/modules/5.4.100/kernel/drivers/clk/bcm/clk-raspberrypi.ko",
            "lib/modules/5.4.100/kernel/drivers/clk/meson/axg-audio.ko",
            "lib/modules/5.4.100/kernel/drivers/clk/meson/clk-phase.ko",
            "lib/modules/5.4.100/kernel/drivers/clk/meson/sclk-div.ko",
            "lib/modules/5.4.100/kernel/drivers/cpufreq/cppc_cpufreq.ko",
            "lib/modules/5.4.100/kernel/drivers/cpufreq/cpufreq_conservative.ko",
            "lib/modules/5.4.100/kernel/drivers/cpufreq/cpufreq_powersave.ko",
            "lib/modules/5.4.100/kernel/drivers/cpufreq/imx-cpufreq-dt.ko",
            "lib/modules/5.4.100/kernel/drivers/cpufreq/raspberrypi-cpufreq.ko",
            "lib/modules/5.4.100/kernel/drivers/crypto/bcm/bcm_crypto_spu.ko",
            "lib/modules/5.4.100/kernel/drivers/dma/bcm-sba-raid.ko",
            "lib/modules/5.4.100/kernel/drivers/dma/bcm2835-dma.ko",
            "lib/modules/5.4.100/kernel/drivers/dma/sh/usb-dmac.ko",
            "lib/modules/5.4.100/kernel/drivers/dma/sun6i-dma.ko",
            "lib/modules/5.4.100/kernel/drivers/fpga/altera-freeze-bridge.ko",
            "lib/modules/5.4.100/kernel/drivers/fpga/fpga-bridge.ko",
            "lib/modules/5.4.100/kernel/drivers/fpga/fpga-region.ko",
            "lib/modules/5.4.100/kernel/drivers/fpga/of-fpga-region.ko",
            "lib/modules/5.4.100/kernel/drivers/fpga/stratix10-soc.ko",
            "lib/modules/5.4.100/kernel/drivers/gpu/drm/bridge/adv7511/adv7511.ko",
            "lib/modules/5.4.100/kernel/drivers/gpu/drm/bridge/analogix/analogix_dp.ko",
            "lib/modules/5.4.100/kernel/drivers/gpu/drm/bridge/sii902x.ko",
            "lib/modules/5.4.100/kernel/drivers/gpu/drm/bridge/synopsys/dw-hdmi-i2s-audio.ko",
            "lib/modules/5.4.100/kernel/drivers/gpu/drm/bridge/synopsys/dw-hdmi.ko",
            "lib/modules/5.4.100/kernel/drivers/gpu/drm/bridge/synopsys/dw-mipi-dsi.ko",
            "lib/modules/5.4.100/kernel/drivers/gpu/drm/drm.ko",
            "lib/modules/5.4.100/kernel/drivers/gpu/drm/drm_kms_helper.ko",
            "lib/modules/5.4.100/kernel/drivers/gpu/drm/drm_vram_helper.ko",
            "lib/modules/5.4.100/kernel/drivers/gpu/drm/etnaviv/etnaviv.ko",
            "lib/modules/5.4.100/kernel/drivers/gpu/drm/exynos/exynosdrm.ko",
            "lib/modules/5.4.100/kernel/drivers/gpu/drm/hisilicon/hibmc/hibmc-drm.ko",
            "lib/modules/5.4.100/kernel/drivers/gpu/drm/hisilicon/kirin/dw_drm_dsi.ko",
            "lib/modules/5.4.100/kernel/drivers/gpu/drm/hisilicon/kirin/kirin-drm.ko",
            "lib/modules/5.4.100/kernel/drivers/gpu/drm/i2c/ch7006.ko",
            "lib/modules/5.4.100/kernel/drivers/gpu/drm/i2c/sil164.ko",
            "lib/modules/5.4.100/kernel/drivers/gpu/drm/i2c/tda998x.ko",
            "lib/modules/5.4.100/kernel/drivers/gpu/drm/lima/lima.ko",
            "lib/modules/5.4.100/kernel/drivers/gpu/drm/meson/meson-drm.ko",
            "lib/modules/5.4.100/kernel/drivers/gpu/drm/meson/meson_dw_hdmi.ko",
            "lib/modules/5.4.100/kernel/drivers/gpu/drm/msm/msm.ko",
            "lib/modules/5.4.100/kernel/drivers/gpu/drm/nouveau/nouveau.ko",
            "lib/modules/5.4.100/kernel/drivers/gpu/drm/panel/panel-simple.ko",
            "lib/modules/5.4.100/kernel/drivers/gpu/drm/panfrost/panfrost.ko",
            "lib/modules/5.4.100/kernel/drivers/gpu/drm/pl111/pl111_drm.ko",
            "lib/modules/5.4.100/kernel/drivers/gpu/drm/rcar-du/rcar-du-drm.ko",
            "lib/modules/5.4.100/kernel/drivers/gpu/drm/rcar-du/rcar_lvds.ko",
            "lib/modules/5.4.100/kernel/drivers/gpu/drm/rockchip/rockchipdrm.ko",
            "lib/modules/5.4.100/kernel/drivers/gpu/drm/scheduler/gpu-sched.ko",
            "lib/modules/5.4.100/kernel/drivers/gpu/drm/sun4i/sun4i-backend.ko",
            "lib/modules/5.4.100/kernel/drivers/gpu/drm/sun4i/sun4i-drm-hdmi.ko",
            "lib/modules/5.4.100/kernel/drivers/gpu/drm/sun4i/sun4i-drm.ko",
            "lib/modules/5.4.100/kernel/drivers/gpu/drm/sun4i/sun4i-frontend.ko",
            "lib/modules/5.4.100/kernel/drivers/gpu/drm/sun4i/sun4i-tcon.ko",
            "lib/modules/5.4.100/kernel/drivers/gpu/drm/sun4i/sun4i_tv.ko",
            "lib/modules/5.4.100/kernel/drivers/gpu/drm/sun4i/sun6i_drc.ko",
            "lib/modules/5.4.100/kernel/drivers/gpu/drm/sun4i/sun8i-drm-hdmi.ko",
            "lib/modules/5.4.100/kernel/drivers/gpu/drm/sun4i/sun8i-mixer.ko",
            "lib/modules/5.4.100/kernel/drivers/gpu/drm/sun4i/sun8i_tcon_top.ko",
            "lib/modules/5.4.100/kernel/drivers/gpu/drm/tegra/tegra-drm.ko",
            "lib/modules/5.4.100/kernel/drivers/gpu/drm/ttm/ttm.ko",
            "lib/modules/5.4.100/kernel/drivers/gpu/drm/vc4/vc4.ko",
            "lib/modules/5.4.100/kernel/drivers/gpu/host1x/host1x.ko",
            "lib/modules/5.4.100/kernel/drivers/hid/i2c-hid/i2c-hid.ko",
            "lib/modules/5.4.100/kernel/drivers/hwmon/ina2xx.ko",
            "lib/modules/5.4.100/kernel/drivers/hwmon/ina3221.ko",
            "lib/modules/5.4.100/kernel/drivers/hwmon/lm90.ko",
            "lib/modules/5.4.100/kernel/drivers/hwmon/pwm-fan.ko",
            "lib/modules/5.4.100/kernel/drivers/hwmon/raspberrypi-hwmon.ko",
            "lib/modules/5.4.100/kernel/drivers/i2c/busses/i2c-bcm2835.ko",
            "lib/modules/5.4.100/kernel/drivers/i2c/busses/i2c-gpio.ko",
            "lib/modules/5.4.100/kernel/drivers/i2c/busses/i2c-qcom-geni.ko",
            "lib/modules/5.4.100/kernel/drivers/iio/adc/rockchip_saradc.ko",
            "lib/modules/5.4.100/kernel/drivers/iio/buffer/industrialio-triggered-buffer.ko",
            "lib/modules/5.4.100/kernel/drivers/iio/buffer/kfifo_buf.ko",
            "lib/modules/5.4.100/kernel/drivers/iio/common/cros_ec_sensors/cros_ec_sensors.ko",
            "lib/modules/5.4.100/kernel/drivers/iio/common/cros_ec_sensors/cros_ec_sensors_core.ko",
            "lib/modules/5.4.100/kernel/drivers/iio/light/cros_ec_light_prox.ko",
            "lib/modules/5.4.100/kernel/drivers/iio/light/isl29018.ko",
            "lib/modules/5.4.100/kernel/drivers/iio/pressure/cros_ec_baro.ko",
            "lib/modules/5.4.100/kernel/drivers/iio/pressure/mpl3115.ko",
            "lib/modules/5.4.100/kernel/drivers/input/input-polldev.ko",
            "lib/modules/5.4.100/kernel/drivers/input/keyboard/adc-keys.ko",
            "lib/modules/5.4.100/kernel/drivers/input/keyboard/snvs_pwrkey.ko",
            "lib/modules/5.4.100/kernel/drivers/input/touchscreen/atmel_mxt_ts.ko",
            "lib/modules/5.4.100/kernel/drivers/mailbox/bcm-flexrm-mailbox.ko",
            "lib/modules/5.4.100/kernel/drivers/md/dm-log.ko",
            "lib/modules/5.4.100/kernel/drivers/md/dm-mirror.ko",
            "lib/modules/5.4.100/kernel/drivers/md/dm-mod.ko",
            "lib/modules/5.4.100/kernel/drivers/md/dm-region-hash.ko",
            "lib/modules/5.4.100/kernel/drivers/md/dm-zero.ko",
            "lib/modules/5.4.100/kernel/drivers/md/md-mod.ko",
            "lib/modules/5.4.100/kernel/drivers/media/cec/cec.ko",
            "lib/modules/5.4.100/kernel/drivers/media/common/v4l2-tpg/v4l2-tpg.ko",
            "lib/modules/5.4.100/kernel/drivers/media/common/videobuf2/videobuf2-common.ko",
            "lib/modules/5.4.100/kernel/drivers/media/common/videobuf2/videobuf2-dma-contig.ko",
            "lib/modules/5.4.100/kernel/drivers/media/common/videobuf2/videobuf2-memops.ko",
            "lib/modules/5.4.100/kernel/drivers/media/common/videobuf2/videobuf2-v4l2.ko",
            "lib/modules/5.4.100/kernel/drivers/media/common/videobuf2/videobuf2-vmalloc.ko",
            "lib/modules/5.4.100/kernel/drivers/media/i2c/ir-kbd-i2c.ko",
            "lib/modules/5.4.100/kernel/drivers/media/platform/exynos-gsc/exynos-gsc.ko",
            "lib/modules/5.4.100/kernel/drivers/media/platform/rcar-fcp.ko",
            "lib/modules/5.4.100/kernel/drivers/media/platform/s5p-jpeg/s5p-jpeg.ko",
            "lib/modules/5.4.100/kernel/drivers/media/platform/s5p-mfc/s5p-mfc.ko",
            "lib/modules/5.4.100/kernel/drivers/media/platform/sunxi/sun6i-csi/sun6i-csi.ko",
            "lib/modules/5.4.100/kernel/drivers/media/platform/vivid/vivid.ko",
            "lib/modules/5.4.100/kernel/drivers/media/platform/vsp1/vsp1.ko",
            "lib/modules/5.4.100/kernel/drivers/media/rc/keymaps/rc-adstech-dvb-t-pci.ko",
            "lib/modules/5.4.100/kernel/drivers/media/rc/keymaps/rc-alink-dtu-m.ko",
            "lib/modules/5.4.100/kernel/drivers/media/rc/keymaps/rc-anysee.ko",
            "lib/modules/5.4.100/kernel/drivers/media/rc/keymaps/rc-apac-viewcomp.ko",
            "lib/modules/5.4.100/kernel/drivers/media/rc/keymaps/rc-astrometa-t2hybrid.ko",
            "lib/modules/5.4.100/kernel/drivers/media/rc/keymaps/rc-asus-pc39.ko",
            "lib/modules/5.4.100/kernel/drivers/media/rc/keymaps/rc-asus-ps3-100.ko",
            "lib/modules/5.4.100/kernel/drivers/media/rc/keymaps/rc-ati-tv-wonder-hd-600.ko",
            "lib/modules/5.4.100/kernel/drivers/media/rc/keymaps/rc-ati-x10.ko",
            "lib/modules/5.4.100/kernel/drivers/media/rc/keymaps/rc-avermedia-a16d.ko",
            "lib/modules/5.4.100/kernel/drivers/media/rc/keymaps/rc-avermedia-cardbus.ko",
            "lib/modules/5.4.100/kernel/drivers/media/rc/keymaps/rc-avermedia-dvbt.ko",
            "lib/modules/5.4.100/kernel/drivers/media/rc/keymaps/rc-avermedia-m135a.ko",
            "lib/modules/5.4.100/kernel/drivers/media/rc/keymaps/rc-avermedia-m733a-rm-k6.ko",
            "lib/modules/5.4.100/kernel/drivers/media/rc/keymaps/rc-avermedia-rm-ks.ko",
            "lib/modules/5.4.100/kernel/drivers/media/rc/keymaps/rc-avermedia.ko",
            "lib/modules/5.4.100/kernel/drivers/media/rc/keymaps/rc-avertv-303.ko",
            "lib/modules/5.4.100/kernel/drivers/media/rc/keymaps/rc-azurewave-ad-tu700.ko",
            "lib/modules/5.4.100/kernel/drivers/media/rc/keymaps/rc-behold-columbus.ko",
            "lib/modules/5.4.100/kernel/drivers/media/rc/keymaps/rc-behold.ko",
            "lib/modules/5.4.100/kernel/drivers/media/rc/keymaps/rc-budget-ci-old.ko",
            "lib/modules/5.4.100/kernel/drivers/media/rc/keymaps/rc-cec.ko",
            "lib/modules/5.4.100/kernel/drivers/media/rc/keymaps/rc-cinergy-1400.ko",
            "lib/modules/5.4.100/kernel/drivers/media/rc/keymaps/rc-cinergy.ko",
            "lib/modules/5.4.100/kernel/drivers/media/rc/keymaps/rc-d680-dmb.ko",
            "lib/modules/5.4.100/kernel/drivers/media/rc/keymaps/rc-delock-61959.ko",
            "lib/modules/5.4.100/kernel/drivers/media/rc/keymaps/rc-dib0700-nec.ko",
            "lib/modules/5.4.100/kernel/drivers/media/rc/keymaps/rc-dib0700-rc5.ko",
            "lib/modules/5.4.100/kernel/drivers/media/rc/keymaps/rc-digitalnow-tinytwin.ko",
            "lib/modules/5.4.100/kernel/drivers/media/rc/keymaps/rc-digittrade.ko",
            "lib/modules/5.4.100/kernel/drivers/media/rc/keymaps/rc-dm1105-nec.ko",
            "lib/modules/5.4.100/kernel/drivers/media/rc/keymaps/rc-dntv-live-dvb-t.ko",
            "lib/modules/5.4.100/kernel/drivers/media/rc/keymaps/rc-dntv-live-dvbt-pro.ko",
            "lib/modules/5.4.100/kernel/drivers/media/rc/keymaps/rc-dtt200u.ko",
            "lib/modules/5.4.100/kernel/drivers/media/rc/keymaps/rc-dvbsky.ko",
            "lib/modules/5.4.100/kernel/drivers/media/rc/keymaps/rc-dvico-mce.ko",
            "lib/modules/5.4.100/kernel/drivers/media/rc/keymaps/rc-dvico-portable.ko",
            "lib/modules/5.4.100/kernel/drivers/media/rc/keymaps/rc-em-terratec.ko",
            "lib/modules/5.4.100/kernel/drivers/media/rc/keymaps/rc-encore-enltv-fm53.ko",
            "lib/modules/5.4.100/kernel/drivers/media/rc/keymaps/rc-encore-enltv.ko",
            "lib/modules/5.4.100/kernel/drivers/media/rc/keymaps/rc-encore-enltv2.ko",
            "lib/modules/5.4.100/kernel/drivers/media/rc/keymaps/rc-evga-indtube.ko",
            "lib/modules/5.4.100/kernel/drivers/media/rc/keymaps/rc-eztv.ko",
            "lib/modules/5.4.100/kernel/drivers/media/rc/keymaps/rc-flydvb.ko",
            "lib/modules/5.4.100/kernel/drivers/media/rc/keymaps/rc-flyvideo.ko",
            "lib/modules/5.4.100/kernel/drivers/media/rc/keymaps/rc-fusionhdtv-mce.ko",
            "lib/modules/5.4.100/kernel/drivers/media/rc/keymaps/rc-gadmei-rm008z.ko",
            "lib/modules/5.4.100/kernel/drivers/media/rc/keymaps/rc-geekbox.ko",
            "lib/modules/5.4.100/kernel/drivers/media/rc/keymaps/rc-genius-tvgo-a11mce.ko",
            "lib/modules/5.4.100/kernel/drivers/media/rc/keymaps/rc-gotview7135.ko",
            "lib/modules/5.4.100/kernel/drivers/media/rc/keymaps/rc-hauppauge.ko",
            "lib/modules/5.4.100/kernel/drivers/media/rc/keymaps/rc-hisi-poplar.ko",
            "lib/modules/5.4.100/kernel/drivers/media/rc/keymaps/rc-hisi-tv-demo.ko",
            "lib/modules/5.4.100/kernel/drivers/media/rc/keymaps/rc-imon-mce.ko",
            "lib/modules/5.4.100/kernel/drivers/media/rc/keymaps/rc-imon-pad.ko",
            "lib/modules/5.4.100/kernel/drivers/media/rc/keymaps/rc-imon-rsc.ko",
            "lib/modules/5.4.100/kernel/drivers/media/rc/keymaps/rc-iodata-bctv7e.ko",
            "lib/modules/5.4.100/kernel/drivers/media/rc/keymaps/rc-it913x-v1.ko",
            "lib/modules/5.4.100/kernel/drivers/media/rc/keymaps/rc-it913x-v2.ko",
            "lib/modules/5.4.100/kernel/drivers/media/rc/keymaps/rc-kaiomy.ko",
            "lib/modules/5.4.100/kernel/drivers/media/rc/keymaps/rc-khadas.ko",
            "lib/modules/5.4.100/kernel/drivers/media/rc/keymaps/rc-kworld-315u.ko",
            "lib/modules/5.4.100/kernel/drivers/media/rc/keymaps/rc-kworld-pc150u.ko",
            "lib/modules/5.4.100/kernel/drivers/media/rc/keymaps/rc-kworld-plus-tv-analog.ko",
            "lib/modules/5.4.100/kernel/drivers/media/rc/keymaps/rc-leadtek-y04g0051.ko",
            "lib/modules/5.4.100/kernel/drivers/media/rc/keymaps/rc-lme2510.ko",
            "lib/modules/5.4.100/kernel/drivers/media/rc/keymaps/rc-manli.ko",
            "lib/modules/5.4.100/kernel/drivers/media/rc/keymaps/rc-medion-x10-digitainer.ko",
            "lib/modules/5.4.100/kernel/drivers/media/rc/keymaps/rc-medion-x10-or2x.ko",
            "lib/modules/5.4.100/kernel/drivers/media/rc/keymaps/rc-medion-x10.ko",
            "lib/modules/5.4.100/kernel/drivers/media/rc/keymaps/rc-msi-digivox-ii.ko",
            "lib/modules/5.4.100/kernel/drivers/media/rc/keymaps/rc-msi-digivox-iii.ko",
            "lib/modules/5.4.100/kernel/drivers/media/rc/keymaps/rc-msi-tvanywhere-plus.ko",
            "lib/modules/5.4.100/kernel/drivers/media/rc/keymaps/rc-msi-tvanywhere.ko",
            "lib/modules/5.4.100/kernel/drivers/media/rc/keymaps/rc-nebula.ko",
            "lib/modules/5.4.100/kernel/drivers/media/rc/keymaps/rc-nec-terratec-cinergy-xs.ko",
            "lib/modules/5.4.100/kernel/drivers/media/rc/keymaps/rc-norwood.ko",
            "lib/modules/5.4.100/kernel/drivers/media/rc/keymaps/rc-npgtech.ko",
            "lib/modules/5.4.100/kernel/drivers/media/rc/keymaps/rc-odroid.ko",
            "lib/modules/5.4.100/kernel/drivers/media/rc/keymaps/rc-pctv-sedna.ko",
            "lib/modules/5.4.100/kernel/drivers/media/rc/keymaps/rc-pinnacle-color.ko",
            "lib/modules/5.4.100/kernel/drivers/media/rc/keymaps/rc-pinnacle-grey.ko",
            "lib/modules/5.4.100/kernel/drivers/media/rc/keymaps/rc-pinnacle-pctv-hd.ko",
            "lib/modules/5.4.100/kernel/drivers/media/rc/keymaps/rc-pixelview-002t.ko",
            "lib/modules/5.4.100/kernel/drivers/media/rc/keymaps/rc-pixelview-mk12.ko",
            "lib/modules/5.4.100/kernel/drivers/media/rc/keymaps/rc-pixelview-new.ko",
            "lib/modules/5.4.100/kernel/drivers/media/rc/keymaps/rc-pixelview.ko",
            "lib/modules/5.4.100/kernel/drivers/media/rc/keymaps/rc-powercolor-real-angel.ko",
            "lib/modules/5.4.100/kernel/drivers/media/rc/keymaps/rc-proteus-2309.ko",
            "lib/modules/5.4.100/kernel/drivers/media/rc/keymaps/rc-purpletv.ko",
            "lib/modules/5.4.100/kernel/drivers/media/rc/keymaps/rc-pv951.ko",
            "lib/modules/5.4.100/kernel/drivers/media/rc/keymaps/rc-rc6-mce.ko",
            "lib/modules/5.4.100/kernel/drivers/media/rc/keymaps/rc-real-audio-220-32-keys.ko",
            "lib/modules/5.4.100/kernel/drivers/media/rc/keymaps/rc-reddo.ko",
            "lib/modules/5.4.100/kernel/drivers/media/rc/keymaps/rc-snapstream-firefly.ko",
            "lib/modules/5.4.100/kernel/drivers/media/rc/keymaps/rc-streamzap.ko",
            "lib/modules/5.4.100/kernel/drivers/media/rc/keymaps/rc-su3000.ko",
            "lib/modules/5.4.100/kernel/drivers/media/rc/keymaps/rc-tango.ko",
            "lib/modules/5.4.100/kernel/drivers/media/rc/keymaps/rc-tanix-tx3mini.ko",
            "lib/modules/5.4.100/kernel/drivers/media/rc/keymaps/rc-tanix-tx5max.ko",
            "lib/modules/5.4.100/kernel/drivers/media/rc/keymaps/rc-tbs-nec.ko",
            "lib/modules/5.4.100/kernel/drivers/media/rc/keymaps/rc-technisat-ts35.ko",
            "lib/modules/5.4.100/kernel/drivers/media/rc/keymaps/rc-technisat-usb2.ko",
            "lib/modules/5.4.100/kernel/drivers/media/rc/keymaps/rc-terratec-cinergy-c-pci.ko",
            "lib/modules/5.4.100/kernel/drivers/media/rc/keymaps/rc-terratec-cinergy-s2-hd.ko",
            "lib/modules/5.4.100/kernel/drivers/media/rc/keymaps/rc-terratec-cinergy-xs.ko",
            "lib/modules/5.4.100/kernel/drivers/media/rc/keymaps/rc-terratec-slim-2.ko",
            "lib/modules/5.4.100/kernel/drivers/media/rc/keymaps/rc-terratec-slim.ko",
            "lib/modules/5.4.100/kernel/drivers/media/rc/keymaps/rc-tevii-nec.ko",
            "lib/modules/5.4.100/kernel/drivers/media/rc/keymaps/rc-tivo.ko",
            "lib/modules/5.4.100/kernel/drivers/media/rc/keymaps/rc-total-media-in-hand-02.ko",
            "lib/modules/5.4.100/kernel/drivers/media/rc/keymaps/rc-total-media-in-hand.ko",
            "lib/modules/5.4.100/kernel/drivers/media/rc/keymaps/rc-trekstor.ko",
            "lib/modules/5.4.100/kernel/drivers/media/rc/keymaps/rc-tt-1500.ko",
            "lib/modules/5.4.100/kernel/drivers/media/rc/keymaps/rc-twinhan-dtv-cab-ci.ko",
            "lib/modules/5.4.100/kernel/drivers/media/rc/keymaps/rc-twinhan1027.ko",
            "lib/modules/5.4.100/kernel/drivers/media/rc/keymaps/rc-videomate-m1f.ko",
            "lib/modules/5.4.100/kernel/drivers/media/rc/keymaps/rc-videomate-s350.ko",
            "lib/modules/5.4.100/kernel/drivers/media/rc/keymaps/rc-videomate-tv-pvr.ko",
            "lib/modules/5.4.100/kernel/drivers/media/rc/keymaps/rc-videostrong-kii-pro.ko",
            "lib/modules/5.4.100/kernel/drivers/media/rc/keymaps/rc-wetek-hub.ko",
            "lib/modules/5.4.100/kernel/drivers/media/rc/keymaps/rc-wetek-play2.ko",
            "lib/modules/5.4.100/kernel/drivers/media/rc/keymaps/rc-winfast-usbii-deluxe.ko",
            "lib/modules/5.4.100/kernel/drivers/media/rc/keymaps/rc-winfast.ko",
            "lib/modules/5.4.100/kernel/drivers/media/rc/keymaps/rc-x96max.ko",
            "lib/modules/5.4.100/kernel/drivers/media/rc/keymaps/rc-xbox-dvd.ko",
            "lib/modules/5.4.100/kernel/drivers/media/rc/keymaps/rc-zx-irdec.ko",
            "lib/modules/5.4.100/kernel/drivers/media/rc/meson-ir.ko",
            "lib/modules/5.4.100/kernel/drivers/media/rc/rc-core.ko",
            "lib/modules/5.4.100/kernel/drivers/media/rc/sunxi-cir.ko",
            "lib/modules/5.4.100/kernel/drivers/media/usb/gspca/gspca_main.ko",
            "lib/modules/5.4.100/kernel/drivers/media/usb/uvc/uvcvideo.ko",
            "lib/modules/5.4.100/kernel/drivers/media/v4l2-core/v4l2-fwnode.ko",
            "lib/modules/5.4.100/kernel/drivers/media/v4l2-core/v4l2-mem2mem.ko",
            "lib/modules/5.4.100/kernel/drivers/mfd/exynos-lpass.ko",
            "lib/modules/5.4.100/kernel/drivers/misc/eeprom/at25.ko",
            "lib/modules/5.4.100/kernel/drivers/net/ethernet/atheros/atl1c/atl1c.ko",
            "lib/modules/5.4.100/kernel/drivers/net/ethernet/broadcom/bnx2x/bnx2x.ko",
            "lib/modules/5.4.100/kernel/drivers/net/ethernet/mellanox/mlx4/mlx4_core.ko",
            "lib/modules/5.4.100/kernel/drivers/net/ethernet/mellanox/mlx4/mlx4_en.ko",
            "lib/modules/5.4.100/kernel/drivers/net/ethernet/mellanox/mlx5/core/mlx5_core.ko",
            "lib/modules/5.4.100/kernel/drivers/net/ethernet/mellanox/mlxfw/mlxfw.ko",
            "lib/modules/5.4.100/kernel/drivers/net/ethernet/qualcomm/emac/qcom-emac.ko",
            "lib/modules/5.4.100/kernel/drivers/net/ethernet/stmicro/stmmac/dwmac-altr-socfpga.ko",
            "lib/modules/5.4.100/kernel/drivers/net/ethernet/stmicro/stmmac/dwmac-generic.ko",
            "lib/modules/5.4.100/kernel/drivers/net/ethernet/stmicro/stmmac/dwmac-ipq806x.ko",
            "lib/modules/5.4.100/kernel/drivers/net/ethernet/stmicro/stmmac/dwmac-meson.ko",
            "lib/modules/5.4.100/kernel/drivers/net/ethernet/stmicro/stmmac/dwmac-meson8b.ko",
            "lib/modules/5.4.100/kernel/drivers/net/ethernet/stmicro/stmmac/dwmac-qcom-ethqos.ko",
            "lib/modules/5.4.100/kernel/drivers/net/ethernet/stmicro/stmmac/dwmac-rk.ko",
            "lib/modules/5.4.100/kernel/drivers/net/ethernet/stmicro/stmmac/dwmac-sun8i.ko",
            "lib/modules/5.4.100/kernel/drivers/net/ethernet/stmicro/stmmac/dwmac-sunxi.ko",
            "lib/modules/5.4.100/kernel/drivers/net/ethernet/stmicro/stmmac/stmmac-platform.ko",
            "lib/modules/5.4.100/kernel/drivers/net/ethernet/stmicro/stmmac/stmmac.ko",
            "lib/modules/5.4.100/kernel/drivers/net/macvlan.ko",
            "lib/modules/5.4.100/kernel/drivers/net/macvtap.ko",
            "lib/modules/5.4.100/kernel/drivers/net/mdio.ko",
            "lib/modules/5.4.100/kernel/drivers/net/phy/at803x.ko",
            "lib/modules/5.4.100/kernel/drivers/net/phy/marvell.ko",
            "lib/modules/5.4.100/kernel/drivers/net/phy/marvell10g.ko",
            "lib/modules/5.4.100/kernel/drivers/net/phy/mdio-mux-meson-g12a.ko",
            "lib/modules/5.4.100/kernel/drivers/net/phy/meson-gxl.ko",
            "lib/modules/5.4.100/kernel/drivers/net/phy/microchip.ko",
            "lib/modules/5.4.100/kernel/drivers/net/phy/realtek.ko",
            "lib/modules/5.4.100/kernel/drivers/net/tap.ko",
            "lib/modules/5.4.100/kernel/drivers/net/tun.ko",
            "lib/modules/5.4.100/kernel/drivers/net/usb/cdc_ether.ko",
            "lib/modules/5.4.100/kernel/drivers/net/usb/cdc_ncm.ko",
            "lib/modules/5.4.100/kernel/drivers/net/usb/cdc_subset.ko",
            "lib/modules/5.4.100/kernel/drivers/net/usb/dm9601.ko",
            "lib/modules/5.4.100/kernel/drivers/net/usb/lan78xx.ko",
            "lib/modules/5.4.100/kernel/drivers/net/usb/mcs7830.ko",
            "lib/modules/5.4.100/kernel/drivers/net/usb/net1080.ko",
            "lib/modules/5.4.100/kernel/drivers/net/usb/pegasus.ko",
            "lib/modules/5.4.100/kernel/drivers/net/usb/plusb.ko",
            "lib/modules/5.4.100/kernel/drivers/net/usb/r8152.ko",
            "lib/modules/5.4.100/kernel/drivers/net/usb/rtl8150.ko",
            "lib/modules/5.4.100/kernel/drivers/net/usb/smsc75xx.ko",
            "lib/modules/5.4.100/kernel/drivers/net/usb/smsc95xx.ko",
            "lib/modules/5.4.100/kernel/drivers/net/usb/sr9800.ko",
            "lib/modules/5.4.100/kernel/drivers/net/usb/zaurus.ko",
            "lib/modules/5.4.100/kernel/drivers/net/veth.ko",
            "lib/modules/5.4.100/kernel/drivers/net/vxlan.ko",
            "lib/modules/5.4.100/kernel/drivers/net/wireless/ath/ath.ko",
            "lib/modules/5.4.100/kernel/drivers/net/wireless/ath/ath10k/ath10k_core.ko",
            "lib/modules/5.4.100/kernel/drivers/net/wireless/ath/ath10k/ath10k_pci.ko",
            "lib/modules/5.4.100/kernel/drivers/net/wireless/broadcom/brcm80211/brcmfmac/brcmfmac.ko",
            "lib/modules/5.4.100/kernel/drivers/net/wireless/broadcom/brcm80211/brcmutil/brcmutil.ko",
            "lib/modules/5.4.100/kernel/drivers/net/wireless/marvell/mwifiex/mwifiex.ko",
            "lib/modules/5.4.100/kernel/drivers/net/wireless/marvell/mwifiex/mwifiex_pcie.ko",
            "lib/modules/5.4.100/kernel/drivers/net/wireless/ti/wl18xx/wl18xx.ko",
            "lib/modules/5.4.100/kernel/drivers/net/wireless/ti/wlcore/wlcore.ko",
            "lib/modules/5.4.100/kernel/drivers/net/wireless/ti/wlcore/wlcore_sdio.ko",
            "lib/modules/5.4.100/kernel/drivers/nvme/host/nvme-core.ko",
            "lib/modules/5.4.100/kernel/drivers/nvme/host/nvme.ko",
            "lib/modules/5.4.100/kernel/drivers/nvmem/nvmem_meson_efuse.ko",
            "lib/modules/5.4.100/kernel/drivers/pci/controller/dwc/pcie-tegra194.ko",
            "lib/modules/5.4.100/kernel/drivers/pci/controller/pcie-rockchip-host.ko",
            "lib/modules/5.4.100/kernel/drivers/perf/fsl_imx8_ddr_perf.ko",
            "lib/modules/5.4.100/kernel/drivers/perf/thunderx2_pmu.ko",
            "lib/modules/5.4.100/kernel/drivers/phy/renesas/phy-rcar-gen3-usb3.ko",
            "lib/modules/5.4.100/kernel/drivers/phy/rockchip/phy-rockchip-inno-hdmi.ko",
            "lib/modules/5.4.100/kernel/drivers/phy/rockchip/phy-rockchip-pcie.ko",
            "lib/modules/5.4.100/kernel/drivers/phy/tegra/phy-tegra194-p2u.ko",
            "lib/modules/5.4.100/kernel/drivers/power/supply/sbs-battery.ko",
            "lib/modules/5.4.100/kernel/drivers/pwm/pwm-bcm2835.ko",
            "lib/modules/5.4.100/kernel/drivers/pwm/pwm-cros-ec.ko",
            "lib/modules/5.4.100/kernel/drivers/pwm/pwm-meson.ko",
            "lib/modules/5.4.100/kernel/drivers/pwm/pwm-rcar.ko",
            "lib/modules/5.4.100/kernel/drivers/pwm/pwm-sun4i.ko",
            "lib/modules/5.4.100/kernel/drivers/pwm/pwm-tegra.ko",
            "lib/modules/5.4.100/kernel/drivers/regulator/vctrl-regulator.ko",
            "lib/modules/5.4.100/kernel/drivers/remoteproc/qcom_common.ko",
            "lib/modules/5.4.100/kernel/drivers/remoteproc/qcom_q6v5.ko",
            "lib/modules/5.4.100/kernel/drivers/remoteproc/qcom_q6v5_mss.ko",
            "lib/modules/5.4.100/kernel/drivers/remoteproc/qcom_q6v5_pas.ko",
            "lib/modules/5.4.100/kernel/drivers/remoteproc/qcom_sysmon.ko",
            "lib/modules/5.4.100/kernel/drivers/reset/reset-meson-audio-arb.ko",
            "lib/modules/5.4.100/kernel/drivers/rpmsg/qcom_glink_smem.ko",
            "lib/modules/5.4.100/kernel/drivers/rtc/rtc-imx-sc.ko",
            "lib/modules/5.4.100/kernel/drivers/rtc/rtc-meson-vrtc.ko",
            "lib/modules/5.4.100/kernel/drivers/rtc/rtc-rk808.ko",
            "lib/modules/5.4.100/kernel/drivers/rtc/rtc-rx8581.ko",
            "lib/modules/5.4.100/kernel/drivers/rtc/rtc-snvs.ko",
            "lib/modules/5.4.100/kernel/drivers/scsi/mpt3sas/mpt3sas.ko",
            "lib/modules/5.4.100/kernel/drivers/scsi/raid_class.ko",
            "lib/modules/5.4.100/kernel/drivers/soc/amlogic/meson-canvas.ko",
            "lib/modules/5.4.100/kernel/drivers/soc/qcom/glink_ssr.ko",
            "lib/modules/5.4.100/kernel/drivers/soc/qcom/mdt_loader.ko",
            "lib/modules/5.4.100/kernel/drivers/soc/qcom/qmi_helpers.ko",
            "lib/modules/5.4.100/kernel/drivers/spi/spi-bcm2835.ko",
            "lib/modules/5.4.100/kernel/drivers/spi/spi-bcm2835aux.ko",
            "lib/modules/5.4.100/kernel/drivers/spi/spi-bitbang.ko",
            "lib/modules/5.4.100/kernel/drivers/spi/spi-imx.ko",
            "lib/modules/5.4.100/kernel/drivers/spi/spi-meson-spicc.ko",
            "lib/modules/5.4.100/kernel/drivers/spi/spi-meson-spifc.ko",
            "lib/modules/5.4.100/kernel/drivers/spi/spidev.ko",
            "lib/modules/5.4.100/kernel/drivers/thermal/broadcom/bcm2835_thermal.ko",
            "lib/modules/5.4.100/kernel/drivers/thermal/broadcom/brcmstb_thermal.ko",
            "lib/modules/5.4.100/kernel/drivers/thermal/qoriq_thermal.ko",
            "lib/modules/5.4.100/kernel/drivers/thermal/rockchip_thermal.ko",
            "lib/modules/5.4.100/kernel/drivers/thermal/tegra/tegra-bpmp-thermal.ko",
            "lib/modules/5.4.100/kernel/drivers/usb/gadget/udc/renesas_usb3.ko",
            "lib/modules/5.4.100/kernel/drivers/usb/misc/usbtest.ko",
            "lib/modules/5.4.100/kernel/drivers/usb/renesas_usbhs/renesas_usbhs.ko",
            "lib/modules/5.4.100/kernel/drivers/usb/serial/ftdi_sio.ko",
            "lib/modules/5.4.100/kernel/drivers/usb/serial/pl2303.ko",
            "lib/modules/5.4.100/kernel/drivers/usb/serial/usb-serial-simple.ko",
            "lib/modules/5.4.100/kernel/drivers/usb/serial/usbserial.ko",
            "lib/modules/5.4.100/kernel/drivers/usb/typec/typec.ko",
            "lib/modules/5.4.100/kernel/drivers/video/backlight/generic_bl.ko",
            "lib/modules/5.4.100/kernel/drivers/video/backlight/lp855x_bl.ko",
            "lib/modules/5.4.100/kernel/drivers/video/backlight/pwm_bl.ko",
            "lib/modules/5.4.100/kernel/drivers/watchdog/imx_sc_wdt.ko",
            "lib/modules/5.4.100/kernel/drivers/watchdog/meson_gxbb_wdt.ko",
            "lib/modules/5.4.100/kernel/drivers/watchdog/meson_wdt.ko",
            "lib/modules/5.4.100/kernel/drivers/watchdog/sunxi_wdt.ko",
            "lib/modules/5.4.100/kernel/fs/btrfs/btrfs.ko",
            "lib/modules/5.4.100/kernel/fs/fuse/cuse.ko",
            "lib/modules/5.4.100/kernel/fs/fuse/fuse.ko",
            "lib/modules/5.4.100/kernel/fs/nfs/blocklayout/blocklayoutdriver.ko",
            "lib/modules/5.4.100/kernel/fs/nfs/flexfilelayout/nfs_layout_flexfiles.ko",
            "lib/modules/5.4.100/kernel/fs/overlayfs/overlay.ko",
            "lib/modules/5.4.100/kernel/kernel/rcu/rcutorture.ko",
            "lib/modules/5.4.100/kernel/kernel/torture.ko",
            "lib/modules/5.4.100/kernel/kernel/trace/preemptirq_delay_test.ko",
            "lib/modules/5.4.100/kernel/lib/libcrc32c.ko",
            "lib/modules/5.4.100/kernel/lib/raid6/raid6_pq.ko",
            "lib/modules/5.4.100/kernel/lib/zstd/zstd_compress.ko",
            "lib/modules/5.4.100/kernel/lib/zstd/zstd_decompress.ko",
            "lib/modules/5.4.100/kernel/net/802/garp.ko",
            "lib/modules/5.4.100/kernel/net/802/mrp.ko",
            "lib/modules/5.4.100/kernel/net/802/p8022.ko",
            "lib/modules/5.4.100/kernel/net/802/psnap.ko",
            "lib/modules/5.4.100/kernel/net/802/stp.ko",
            "lib/modules/5.4.100/kernel/net/8021q/8021q.ko",
            "lib/modules/5.4.100/kernel/net/bluetooth/bluetooth.ko",
            "lib/modules/5.4.100/kernel/net/bluetooth/hidp/hidp.ko",
            "lib/modules/5.4.100/kernel/net/bridge/br_netfilter.ko",
            "lib/modules/5.4.100/kernel/net/bridge/bridge.ko",
            "lib/modules/5.4.100/kernel/net/ipv4/ip_tunnel.ko",
            "lib/modules/5.4.100/kernel/net/ipv4/netfilter/ip_tables.ko",
            "lib/modules/5.4.100/kernel/net/ipv4/netfilter/ipt_REJECT.ko",
            "lib/modules/5.4.100/kernel/net/ipv4/netfilter/iptable_filter.ko",
            "lib/modules/5.4.100/kernel/net/ipv4/netfilter/iptable_mangle.ko",
            "lib/modules/5.4.100/kernel/net/ipv4/netfilter/iptable_nat.ko",
            "lib/modules/5.4.100/kernel/net/ipv4/netfilter/nf_defrag_ipv4.ko",
            "lib/modules/5.4.100/kernel/net/ipv4/netfilter/nf_log_ipv4.ko",
            "lib/modules/5.4.100/kernel/net/ipv4/netfilter/nf_reject_ipv4.ko",
            "lib/modules/5.4.100/kernel/net/ipv4/tunnel4.ko",
            "lib/modules/5.4.100/kernel/net/ipv4/udp_tunnel.ko",
            "lib/modules/5.4.100/kernel/net/ipv6/ip6_udp_tunnel.ko",
            "lib/modules/5.4.100/kernel/net/ipv6/netfilter/ip6_tables.ko",
            "lib/modules/5.4.100/kernel/net/ipv6/netfilter/ip6t_REJECT.ko",
            "lib/modules/5.4.100/kernel/net/ipv6/netfilter/ip6table_filter.ko",
            "lib/modules/5.4.100/kernel/net/ipv6/netfilter/ip6table_mangle.ko",
            "lib/modules/5.4.100/kernel/net/ipv6/netfilter/ip6table_nat.ko",
            "lib/modules/5.4.100/kernel/net/ipv6/netfilter/nf_defrag_ipv6.ko",
            "lib/modules/5.4.100/kernel/net/ipv6/netfilter/nf_log_ipv6.ko",
            "lib/modules/5.4.100/kernel/net/ipv6/netfilter/nf_reject_ipv6.ko",
            "lib/modules/5.4.100/kernel/net/ipv6/sit.ko",
            "lib/modules/5.4.100/kernel/net/llc/llc.ko",
            "lib/modules/5.4.100/kernel/net/mac80211/mac80211.ko",
            "lib/modules/5.4.100/kernel/net/netfilter/nf_conntrack.ko",
            "lib/modules/5.4.100/kernel/net/netfilter/nf_log_common.ko",
            "lib/modules/5.4.100/kernel/net/netfilter/nf_nat.ko",
            "lib/modules/5.4.100/kernel/net/netfilter/x_tables.ko",
            "lib/modules/5.4.100/kernel/net/netfilter/xt_CHECKSUM.ko",
            "lib/modules/5.4.100/kernel/net/netfilter/xt_LOG.ko",
            "lib/modules/5.4.100/kernel/net/netfilter/xt_MASQUERADE.ko",
            "lib/modules/5.4.100/kernel/net/netfilter/xt_addrtype.ko",
            "lib/modules/5.4.100/kernel/net/netfilter/xt_conntrack.ko",
            "lib/modules/5.4.100/kernel/net/netfilter/xt_nat.ko",
            "lib/modules/5.4.100/kernel/net/netfilter/xt_tcpudp.ko",
            "lib/modules/5.4.100/kernel/net/qrtr/qrtr-smd.ko",
            "lib/modules/5.4.100/kernel/net/qrtr/qrtr-tun.ko",
            "lib/modules/5.4.100/kernel/net/qrtr/qrtr.ko",
            "lib/modules/5.4.100/kernel/net/rfkill/rfkill.ko",
            "lib/modules/5.4.100/kernel/net/wireless/cfg80211.ko",
            "lib/modules/5.4.100/kernel/sound/hda/snd-hda-core.ko",
            "lib/modules/5.4.100/kernel/sound/pci/hda/snd-hda-codec-hdmi.ko",
            "lib/modules/5.4.100/kernel/sound/pci/hda/snd-hda-codec.ko",
            "lib/modules/5.4.100/kernel/sound/pci/hda/snd-hda-tegra.ko",
            "lib/modules/5.4.100/kernel/sound/soc/bcm/snd-soc-bcm2835-i2s.ko",
            "lib/modules/5.4.100/kernel/sound/soc/codecs/snd-soc-ak4613.ko",
            "lib/modules/5.4.100/kernel/sound/soc/codecs/snd-soc-da7219.ko",
            "lib/modules/5.4.100/kernel/sound/soc/codecs/snd-soc-dmic.ko",
            "lib/modules/5.4.100/kernel/sound/soc/codecs/snd-soc-es7134.ko",
            "lib/modules/5.4.100/kernel/sound/soc/codecs/snd-soc-es7241.ko",
            "lib/modules/5.4.100/kernel/sound/soc/codecs/snd-soc-hdmi-codec.ko",
            "lib/modules/5.4.100/kernel/sound/soc/codecs/snd-soc-max98357a.ko",
            "lib/modules/5.4.100/kernel/sound/soc/codecs/snd-soc-msm8916-analog.ko",
            "lib/modules/5.4.100/kernel/sound/soc/codecs/snd-soc-msm8916-digital.ko",
            "lib/modules/5.4.100/kernel/sound/soc/codecs/snd-soc-pcm3168a-i2c.ko",
            "lib/modules/5.4.100/kernel/sound/soc/codecs/snd-soc-pcm3168a.ko",
            "lib/modules/5.4.100/kernel/sound/soc/codecs/snd-soc-rl6231.ko",
            "lib/modules/5.4.100/kernel/sound/soc/codecs/snd-soc-rt5514-spi.ko",
            "lib/modules/5.4.100/kernel/sound/soc/codecs/snd-soc-rt5514.ko",
            "lib/modules/5.4.100/kernel/sound/soc/codecs/snd-soc-rt5645.ko",
            "lib/modules/5.4.100/kernel/sound/soc/codecs/snd-soc-spdif-rx.ko",
            "lib/modules/5.4.100/kernel/sound/soc/codecs/snd-soc-spdif-tx.ko",
            "lib/modules/5.4.100/kernel/sound/soc/codecs/snd-soc-tas571x.ko",
            "lib/modules/5.4.100/kernel/sound/soc/generic/snd-soc-audio-graph-card.ko",
            "lib/modules/5.4.100/kernel/sound/soc/generic/snd-soc-simple-card-utils.ko",
            "lib/modules/5.4.100/kernel/sound/soc/generic/snd-soc-simple-card.ko",
            "lib/modules/5.4.100/kernel/sound/soc/meson/snd-soc-meson-axg-fifo.ko",
            "lib/modules/5.4.100/kernel/sound/soc/meson/snd-soc-meson-axg-frddr.ko",
            "lib/modules/5.4.100/kernel/sound/soc/meson/snd-soc-meson-axg-pdm.ko",
            "lib/modules/5.4.100/kernel/sound/soc/meson/snd-soc-meson-axg-sound-card.ko",
            "lib/modules/5.4.100/kernel/sound/soc/meson/snd-soc-meson-axg-spdifin.ko",
            "lib/modules/5.4.100/kernel/sound/soc/meson/snd-soc-meson-axg-spdifout.ko",
            "lib/modules/5.4.100/kernel/sound/soc/meson/snd-soc-meson-axg-tdm-formatter.ko",
            "lib/modules/5.4.100/kernel/sound/soc/meson/snd-soc-meson-axg-tdm-interface.ko",
            "lib/modules/5.4.100/kernel/sound/soc/meson/snd-soc-meson-axg-tdmin.ko",
            "lib/modules/5.4.100/kernel/sound/soc/meson/snd-soc-meson-axg-tdmout.ko",
            "lib/modules/5.4.100/kernel/sound/soc/meson/snd-soc-meson-axg-toddr.ko",
            "lib/modules/5.4.100/kernel/sound/soc/meson/snd-soc-meson-g12a-tohdmitx.ko",
            "lib/modules/5.4.100/kernel/sound/soc/qcom/snd-soc-apq8016-sbc.ko",
            "lib/modules/5.4.100/kernel/sound/soc/qcom/snd-soc-lpass-apq8016.ko",
            "lib/modules/5.4.100/kernel/sound/soc/qcom/snd-soc-lpass-cpu.ko",
            "lib/modules/5.4.100/kernel/sound/soc/qcom/snd-soc-lpass-platform.ko",
            "lib/modules/5.4.100/kernel/sound/soc/rockchip/snd-soc-rk3399-gru-sound.ko",
            "lib/modules/5.4.100/kernel/sound/soc/rockchip/snd-soc-rockchip-i2s.ko",
            "lib/modules/5.4.100/kernel/sound/soc/rockchip/snd-soc-rockchip-pcm.ko",
            "lib/modules/5.4.100/kernel/sound/soc/rockchip/snd-soc-rockchip-rt5645.ko",
            "lib/modules/5.4.100/kernel/sound/soc/rockchip/snd-soc-rockchip-spdif.ko",
            "lib/modules/5.4.100/kernel/sound/soc/sh/rcar/snd-soc-rcar.ko",
            "lib/modules/5.4.100/kernel/sound/soc/sunxi/sun4i-spdif.ko",
            "lib/modules/5.4.100/modules.alias",
            "lib/modules/5.4.100/modules.alias.bin",
            "lib/modules/5.4.100/modules.builtin",
            "lib/modules/5.4.100/modules.builtin.alias.bin",
            "lib/modules/5.4.100/modules.builtin.bin",
            "lib/modules/5.4.100/modules.builtin.modinfo",
            "lib/modules/5.4.100/modules.dep",
            "lib/modules/5.4.100/modules.dep.bin",
            "lib/modules/5.4.100/modules.devname",
            "lib/modules/5.4.100/modules.order",
            "lib/modules/5.4.100/modules.softdep",
            "lib/modules/5.4.100/modules.symbols",
            "lib/modules/5.4.100/modules.symbols.bin",
            "lib/modules/5.4.100/source"
        ]
    },
    "build": {
        "environment": {
            "SCCACHE_BUCKET": "sccache.tuxbuild.com"
        },
        "jobs": 8,
        "kconfig": "defconfig",
        "kconfig_add": [
            "https://raw.githubusercontent.com/Linaro/meta-lkft/sumo/recipes-kernel/linux/files/lkft.config",
            "https://raw.githubusercontent.com/Linaro/meta-lkft/sumo/recipes-kernel/linux/files/lkft-crypto.config",
            "https://raw.githubusercontent.com/Linaro/meta-lkft/sumo/recipes-kernel/linux/files/distro-overrides.config",
            "https://raw.githubusercontent.com/Linaro/meta-lkft/sumo/recipes-kernel/linux/files/systemd.config",
            "https://raw.githubusercontent.com/Linaro/meta-lkft/sumo/recipes-kernel/linux/files/virtio.config",
            "CONFIG_ARM64_MODULE_PLTS=y",
            "CONFIG_RCU_TORTURE_TEST=m"
        ],
        "reproducer_cmdline": [
            "tuxmake",
            "--target-arch=arm64",
            "--kconfig=defconfig",
            "--kconfig-add=https://raw.githubusercontent.com/Linaro/meta-lkft/sumo/recipes-kernel/linux/files/lkft.config",
            "--kconfig-add=https://raw.githubusercontent.com/Linaro/meta-lkft/sumo/recipes-kernel/linux/files/lkft-crypto.config",
            "--kconfig-add=https://raw.githubusercontent.com/Linaro/meta-lkft/sumo/recipes-kernel/linux/files/distro-overrides.config",
            "--kconfig-add=https://raw.githubusercontent.com/Linaro/meta-lkft/sumo/recipes-kernel/linux/files/systemd.config",
            "--kconfig-add=https://raw.githubusercontent.com/Linaro/meta-lkft/sumo/recipes-kernel/linux/files/virtio.config",
            "--kconfig-add=CONFIG_ARM64_MODULE_PLTS=y",
            "--kconfig-add=CONFIG_RCU_TORTURE_TEST=m",
            "--toolchain=gcc-9",
            "--wrapper=sccache",
            "--environment=SCCACHE_BUCKET=sccache.tuxbuild.com",
            "--runtime=podman",
            "--image=public.ecr.aws/tuxmake/arm64_gcc-9",
            "config",
            "default",
            "kernel",
            "xipkernel",
            "modules",
            "dtbs",
            "dtbs-legacy",
            "debugkernel"
        ],
        "runtime": "podman",
        "target_arch": "arm64",
        "targets": [
            "config",
            "default",
            "kernel",
            "xipkernel",
            "modules",
            "dtbs",
            "dtbs-legacy",
            "debugkernel"
        ],
        "toolchain": "gcc-9",
        "verbose": false,
        "wrapper": "sccache"
    },
    "compiler": {
        "name": "aarch64-linux-gnu-gcc",
        "version": "9",
        "version_full": "aarch64-linux-gnu-gcc (Debian 9.3.0-19) 9.3.0"
    },
    "os": {
        "name": "Debian GNU/Linux",
        "version": "bullseye/sid"
    },
    "results": {
        "artifacts": {
            "config": [
                "config"
            ],
            "debugkernel": [
                "vmlinux.xz",
                "System.map"
            ],
            "default": [],
            "dtbs": [
                "dtbs.tar.xz"
            ],
            "kernel": [
                "Image.gz"
            ],
            "log": [
                "build.log"
            ],
            "modules": [
                "modules.tar.xz"
            ]
        },
        "duration": {
            "build": 787.5343642234802,
            "cleanup": 0.5303952693939209,
            "copy": 0.027663707733154297,
            "metadata": 2.082645893096924,
            "prepare": 10.646704196929932,
            "validate": 0.00034880638122558594
        },
        "errors": 0,
        "status": "PASS",
        "targets": {
            "config": {
                "duration": 6.564590930938721,
                "status": "PASS"
            },
            "debugkernel": {
                "duration": 13.16604733467102,
                "status": "PASS"
            },
            "default": {
                "duration": 712.1463911533356,
                "status": "PASS"
            },
            "dtbs": {
                "duration": 7.316602468490601,
                "status": "PASS"
            },
            "dtbs-legacy": {
                "duration": 0.7907559871673584,
                "status": "SKIP"
            },
            "kernel": {
                "duration": 24.262251377105713,
                "status": "PASS"
            },
            "modules": {
                "duration": 22.893776416778564,
                "status": "PASS"
            },
            "xipkernel": {
                "duration": 0.39379310607910156,
                "status": "SKIP"
            }
        },
        "warnings": 7
    },
    "sccache": {
        "cache_hits": 0,
        "cache_misses": 0
    },
    "source": {
        "kernelversion": "5.4.100"
    },
    "system_map": {
        "text_offset": "0xffff800010080000"
    },
    "tools": {
        "bc": "bc 1.07.1",
        "bison": "bison (GNU Bison) 3.7.4",
        "depmod": "kmod version 28",
        "fdformat": "fdformat from util-linux 2.36.1",
        "flex": "flex 2.6.4",
        "gcc": "gcc (Debian 9.3.0-20) 9.3.0",
        "ld": "GNU ld (GNU Binutils for Debian) 2.35.1",
        "make": "GNU Make 4.3",
        "openssl": "OpenSSL 1.1.1i  8 Dec 2020",
        "ps": "ps from procps-ng 3.3.16"
    },
    "tuxmake": {
        "version": "0.15.0"
    },
    "uname": {
        "kernel": "Linux",
        "kernel_release": "5.8.0-1023-aws",
        "kernel_version": "#25-Ubuntu SMP Fri Feb 5 05:28:00 UTC 2021",
        "machine": "x86_64",
        "operating_system": "GNU/Linux"
    },
    "vmlinux": {
        "bss_size": 546632,
        "data_size": 11684970,
        "file_size": 42819656,
        "text_size": 23735188
    }
}
```
