# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['areas',
 'areas.config',
 'areas.exception',
 'areas.parameters',
 'areas.subroutines',
 'areas.util']

package_data = \
{'': ['*']}

install_requires = \
['PyYAML>=6.0,<7.0', 'Unidecode>=1.3.4,<2.0.0', 'pytest>=7.2.0,<8.0.0']

entry_points = \
{'console_scripts': ['test = scripts:test']}

setup_kwargs = {
    'name': 'areas',
    'version': '0.1.6',
    'description': 'ARM64 and RISC-V (extensible) assessment system',
    'long_description': '# areas<!-- omit in toc -->\n\n[![GitHub license](https://img.shields.io/github/license/luist18/areas?color=blue)](https://github.com/luist18/areas/blob/main/LICENSE)\n\n**A**RM64 and **R**ISC-V (**e**xtensible) **A**ssessment **S**ystem.\n\n*areas* is originally a fork from [João Damas\'](https://github.com/cyrilico) [Automatic Observation and (grade) Calculation for (subroutine) Operations tool](https://github.com/cyrilico/aoco-code-correction). It is a tool to automate student\'s grading in the assignments done during the Microprocessor and Personal Computers course unit.\n\n## Differences with the original tool<!-- omit in toc -->\n\nTo ease the communication between the backend server and the tool the output demanded changes. Output `.txt` and `.csv` files are now combined in a more complete `.json` file. Structure of the `.zip` input file is simplified. Unsupported data types such as long and double are now supported. A new input parameter - weight - is introduced.\n\n---\n\n## Table of contents<!-- omit in toc -->\n\n- [1. Installation](#1-installation)\n- [2. Developing](#2-developing)\n- [3. Running](#3-running)\n- [4. Usage](#4-usage)\n- [5. File syntax and structure](#5-file-syntax-and-structure)\n  - [5.1. Available data types](#51-available-data-types)\n    - [5.1.1. Primitive data types](#511-primitive-data-types)\n    - [5.1.2. Array data types](#512-array-data-types)\n  - [5.2. subroutines.yaml](#52-subroutinesyaml)\n  - [5.3. tests.yaml](#53-testsyaml)\n  - [5.4. submission.zip](#54-submissionzip)\n- [6. Results](#6-results)\n\n## 1. Installation\n\nUsing Docker:\n\n```bash\ndocker pull luist188/areas\n```\n\n## 2. Developing\n\nTo develop the tool you must setup a Docker development environment to ease the dependencies installation and setup an isolated environment.\n\n1. Build the Docker development image:\n\n   ```bash\n   docker build -f Dockerfile.dev -t areas .\n   ```\n\n2. Run the image with the shared folder:\n\n   ```bash\n   docker run -it -v $(pwd):/usr/app areas\n   ```\n\nNote: if you are running MacOS with the M1 (or superior) chip you must add `--platform linux/x86_64` to `docker build` and `docker run`.\n\n## 3. Running\n\n1. Place the input files inside any directory.\n2. Run the image with a shared volume pointing to the input directory: `docker run -v input:destination -it luist188/areas` (you can learn more about `docker run` usage [here](https://docs.docker.com/engine/reference/run/))\n3. Run the alias command (assure you are using `/bin/bash`) `areas` or run `python main.py` in the tool\'s source.\n\n## 4. Usage\n\n```console\n$ areas [-h] -sr SR -t T -sm SM [SM ...] [-gfd GFD] [-ffd FFD] [-grf GRF] [-tout TOUT] [-fpre FPRE]\n\n$ areas [args]\n\nOptions:\n  --help, -h                Show help                                         [boolean]\n  -sr <subroutines.yaml>    .yaml file containing subroutine declaration      [required] [string]\n  -t <tests.yaml>           .yaml file containing the test cases              [required] [string]\n  -sm <submission.zip...>   .zip files containing user submission             [required] [string array]\n  -gfd <directory>          path to the directory to store temporary files\n    (e.g., compiled binaries)                                                 [default:grading] [string]\n  -ffd <directory>          path to the directory to store the grading for\n    each submission                                                           [default:feedback] [string]\n  -tout <timeout>           float timeout value                               [default:2.0] [float]\n  -fpre <precision>         floating point threshold for comparing floating\n    points in test cases                                                      [default:1e-6] [float]\n```\n\n## 5. File syntax and structure\n\n### 5.1. Available data types\n\n#### 5.1.1. Primitive data types\n\n- `int`\n- `long`\n- `float`\n- `double`\n- `char`\n- `chari` (char represented as an unsgined intenger - similar to char but has to be used when printed characters are not ASCII characters)\n\n#### 5.1.2. Array data types\n\n- `char*/string`\n- `array int`\n- `array long`\n- `array float`\n- `array double`\n- `array char`\n- `array chari`\n\n### 5.2. subroutines.yaml\n\nThe input file for the subroutine declaration has to follow a specific structure and syntax described as follows:\n\n```yaml\nfoo: \n  params: \n    - int\n    - array char\n    - array int\n    - array int\n  return: \n    - int\n    - array int\n\nbar: \n  params: \n    - long\n  return: \n    - long\n```\n\nEach subroutine has an optional parameter to define the subroutine architecture, the syntax is as follows:\n\n```yaml\nfoo: \n  architecture: arm\n  params: \n    - int\n    - array char\n    - array int\n    - array int\n  return: \n    - int\n    - array int\n```\n\nBy default, if the architecture parameter is omitted, the system will assume ARM64 as the subroutine architecture. The available architectures are the following:\n\n- `arm` - ARM64 architecture\n- `riscv` - RISC-V architecture\n\nThe subroutine name has to match the `.s` to test and is case insensitive. Thus, the subroutine `foo` or `bar` is going to check any `.s` file that matches its name case insensitive. All subroutines must contain an array of parameters, `params`, and an array of returns, `return`.\n\n### 5.3. tests.yaml\n\nThe input file for the test cases declaration has to follow a specific structure and syntax described as follows:\n\n```yaml\nbar:\n  - inputs:\n    - 6\n    outputs: \n    - 36\n    weight: 0.5\n  - inputs:\n    - 5\n    outputs: \n    - 25\n    weight: 0.5\n```\n\nThe root declaration of a test case must match the name declared in the `subroutines.yaml` file. Test cases have an array of inputs that has a list of outputs and a test weight. The sum of the test weights must be 1.0.\n\n### 5.4. submission.zip\n\nThe submission `zip` file must contain a `.s` file in its root. For example, for the subroutine `foo` and `bar` the `zip` structure should be as follows:\n\n```tree\nsubmission.zip\n├── foo.s\n└── bar.s\n```\n\n## 6. Results\n\nFor each submission file a `.json` file is created in the feedback directory with the same name of the `.zip` file. The file contains all information about compilation status and test cases. In addition, a simplified version of the result of all submissions is created in a `result.json`. The content of the files look as follows:\n\nFile **submission.json**\n\n```json\n[\n    {\n        "name": "foo",\n        "compiled": true,\n        "ok": true,\n        "passed_count": 2,\n        "test_count": 2,\n        "score": 1,\n        "tests": [\n            {\n                "weight": 1,\n                "run": true,\n                "input": [\n                    6,\n                    ["-", "+", "+", "-", "-", "+"],\n                    [1, 2, 3, 0, 1, -25],\n                    [13, 2, 8, 4, 5, 25]\n                ],\n                "output": [\n                    "0",\n                    ["12", "4", "11", "4", "4", "0"]\n                ],\n                "passed": true\n            }\n        ]\n    },\n    {\n        "name": "bar",\n        "compiled": true,\n        "ok": true,\n        "passed_count": 2,\n        "test_count": 2,\n        "score": 1,\n        "tests": [\n            {\n                "weight": 0.5,\n                "run": true,\n                "input": [\n                    6\n                ],\n                "output": [\n                    "36"\n                ],\n                "passed": true\n            },\n            {\n                "weight": 0.5,\n                "run": true,\n                "input": [\n                    5\n                ],\n                "output": [\n                    "25"\n                ],\n                "passed": true\n            }\n        ]\n    }\n]\n```\n\nFile **result.json**\n\n```json\n[\n    {\n        "submission_name": "submission",\n        "subroutines": [\n            {\n                "name": "foo",\n                "score": 0\n            },\n            {\n                "name": "bar",\n                "score": 0.5\n            }\n        ]\n    },\n    {\n        "submission_name": "submission2",\n        "subroutines": [\n            {\n                "name": "foo",\n                "score": 1\n            },\n            {\n                "name": "bar",\n                "score": 1\n            }\n        ]\n    }\n]\n```\n\n## License<!-- omit in toc -->\n\n[MIT](https://choosealicense.com/licenses/mit/)\n',
    'author': 'Luis Tavares',
    'author_email': 'luistavares10@outlook.pt',
    'maintainer': 'None',
    'maintainer_email': 'None',
    'url': 'https://github.com/luist18/areasear',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'entry_points': entry_points,
    'python_requires': '>=3.9,<4.0',
}


setup(**setup_kwargs)
