# Text messages, may be localized if need
APP_NAME = 'RASA storyteller'

LOCATE_FILES_WINDOW_NAME = 'Locate your files'

TAB_INTENTS_HEADING = 'Intents'
TAB_INTENTS_DESCRIPTION = 'Natural Language Understanding: specify intents which will be understood by bot'
TAB_RESPONSES_HEADING = 'Answers'
TAB_RESPONSES_DESCRIPTION = 'Prepare your bot`s responses here'
TAB_STORIES_HEADING = 'Stories'
TAB_STORIES_DESCRIPTION = 'Construct your own complex stories'

LOCATE_FILE_TEXT = "Locate your {filename} file"

MSG_INVALID_OR_UNEXISTING_FILE = "Invalid or unexistent files"
MSG_FIRST_SELECT_ITEM = "First you need to select an item"
MSG_EXPORT_SUCCESSFUL = "Export completed successfully"

FORM_NAME_ADD_INTENT = 'Add intent'
FORM_NAME_ADD_RESPONSE = 'Add answer'
FORM_NAME_EDIT_INTENT = 'Edit intent'
FORM_NAME_EDIT_ANSWER = 'Edit answer'
FORM_NAME_ADD_CHILD = 'Add child'
FORM_NAME_ADD_SIBLING = 'Add sibling'
FORM_NAME_ADD_STORY_ITEM = 'Add story item'

# App theme, supported by PySimpleGui
APP_THEME = 'DarkBlue2'
APP_THEME_BG_COLOR = '#242834'

# Actions and buttons names
ACTION_SUBMIT = "Submit"
ACTION_CANCEL = "Cancel"
ACTION_ADD_INTENT = 'Add intent'
ACTION_ADD_INTENT_EXAMPLE = 'Add intent example'
ACTION_UPDATE_INTENT = 'Update intent'
ACTION_REMOVE_INTENT = 'Remove intent'
ACTION_ADD_RESPONSE = 'Add answer'
ACTION_ADD_RESPONSE_EXAMPLE = 'Add answer example'
ACTION_UPDATE_RESPONSE = 'Update answer'
ACTION_REMOVE_RESPONSE = 'Remove answer'
ACTION_ADD_CHILD = 'Add child'
ACTION_ADD_SIBLING = 'Add sibling'
ACTION_REMOVE_STORY_ITEM = 'Remove item'
ACTION_MOVE_STORY_ITEM_UP = 'Move up'
ACTION_MOVE_STORY_ITEM_DOWN = 'Move down'
ACTION_EXPORT_DATA = 'Export data'
ACTION_CLOSE_WINDOW = 'Close'
ACTION_ADD_NEW_ITEM_AS_A_CHILD = 'Add new intent/answer as a kid'
BUTTON_ADD_EXAMPLE = 'Add example'

DEFAULT_FORM_SUBMIT_ACTIONS = (ACTION_SUBMIT, '\r', '\n')
DEFAULT_FORM_CANCEL_ACTIONS = (ACTION_CANCEL, 'Escape:27')

# Object types
TYPE_INTENT = "intent"
TYPE_RESPONSE = "answer"
TYPE_ROOT = "root"

# Base64 versions of images (PNG files) for buttons and icons
green_button = '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'
blue_button = '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'
black_button = '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'
orange_button = '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'

ANSWER_ICON = b'iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAADc0lEQVR42l2Ta2hbZRjH/+85OSeJp0mT1GTN0qUim810WDadbpWBgyatMEYn88ZmSzuqs25U2AcR/TAGwph4qZNOMuxUnH4pa52D2XWgwwmbXdt1sRVbakRN2+S0uTWn536OZ6lM5wMPvDy8/Pg/lz/B/6NudzNca1sqQ449lR4vd7tUyOeEQkoawPLcIH49/+1/v5M7r/pWFrpyYWf3M9GGhs24LxiCWmSg0QSmKWD2ryR+uPELxuPnhkGzuzDxufIv4NGDDAw9daz/Df+T1TXou8bj50wBz2/wYZwX8Lug40RsAwRaRv/ELOKvfsCDokO48bG6Cnh4/6V3B49HfZQTX40tIi2b+LKpFg96HZjKSTjyYwrzRQXPbfShcZMf/YlZnGg/NoxbX8QI6ttiHW+2D4U31eG7yQJUisaSrONsYxiP+J0Y5UV0X52DYZjwMhRYBji4Yx16zl7ExVPnmgjZdiR+qPe1zvmcBs4A3HYayYKKGStzKytYWpFQX7MGT4U58CuKlSocLIuI38TRl3tOk9rW4+nmrn0BIhOM8BISWRm1bjve21qFB7xOTOdEq4U/MW3Vg3YTT9cFoVCAUVWFy+98mCGhrh4xunev41pGxEI2D7EkWHI1XG/bis3VLowvLGN//01MLRRxb9ALBTSejaxFIBTEZz29Etn4+qdics39DkZT4KaBrGhANHSMdT5RBoymS3hhIIGZhTxqA5XICiIU3UB3SyO+6TsjkZpXTqWlhyIBSjHLvWWWJcjWwEY7Hl8FZG4DJjEzl0c4UAFFlSFICqojEYiXhzLEse/9uC+2o9MoirCZJhZLClRLwciB7WXAWEYoA6bnlhD2uyFrGmzWKhRrG8tXfjpNuN1vx1yN24dojgMRJPAlFYZp4HrHtjJgwjqkF7+eROIPCxBwWQAdNo8PajYF4cpYU/mQuPaPLvl2NkQpUcV8OguHncH3rY+VAbcWBbSdn8TNJI91lgKDqwAh1oqvjgwLZw7FVgEdJxnK4055t9T7FWuIS4s83opugcdhR16ScXRoHL5KN5z3OK3jV1BITPFGvhgS+g6rd8zk7IqzNsZ2oWL9+ihlKSiZLEqMB6yhwqXlwRIDmgUTfksOa6q2S+x9Sbnbjf8Ed/iTZpvP00Lb6D2EYct2NlVF0DV9QMvmB4WTB+6y89/rZI8dnqV10wAAAABJRU5ErkJggg=='
QUESTION_ICON = b'iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAB3ElEQVR42mNkwAHit32aICDKno8s9vzZh9ZV/uI1yGKM2DRHbP7UmmDEXcTOzMjxjQmo5P9/BtZ/DAxH7n18te3ip8YzWfLTcBoQu/VTSa8Hb/fJdwwMP/4yMPz+z8DwHYhZgCql+RkY1p95/+Xu4x8Ld0RL5WA1IHj9u3vF3oKKtz8wMJz9AFGgx8vA8OHbfwYONkaGr19/M9x8/PX9XFdBIawGuK58/d1Qno/j2vOP57YEihmDxNJWPPyvbyvH8OMXA8Onz38YXn369mW6DT8vzjBAB6mrH/3XMJVlYAJ65T3QBTfufPi3KkCMmSgDDHtu/l+SpcYw6+ovBj4pNoYrx168fP7wff2JEq2ZBA0AaZ6cqcbQdPEfw0eg0ifXPjE8nbRHj+FSyGW80QgG5tvNDEOVTopaqYC5jx98Yrjet8uK4Uz4cYLpAAT4+p7niqsKTYLxX95+t+9TkaQzujp8BiQAKVBKfAvEPEC8AmjABKINIBbgNcC87vQjIQNF2ZvHb7++t+2CNMPVzN9EG2Bdd/6mRbaB2urTDAyPrr9iYDx4+sX/LT6SRBtgOvP+/6fs4gzPnn5hYHj2mYHh84tPDIus+UnyguTCz4+eP3oly/Dp11OGbk0ZbGoA9qfAETkQhkkAAAAASUVORK5CYII='

# Main trees parameters
TREE_LAYOUT_COMMON_PARAMS = {
    "def_col_width": 30,
    "auto_size_columns": False,
    "num_rows": 40,
    "show_expanded": False,
    "enable_events": True,
    "justification": 'left'
}

INTENT_TREE_KEY = 'active_intent'
RESPONSE_TREE_KEY = 'active_answer'
STORIES_TREE_KEY = 'active_story_item'

NLU_FILE_KEY = 'nlu_file'
DOMAIN_FILE_KEY = 'domain_file'
STORIES_FILE_KEY = 'stories_file'
