# coding: utf-8

"""
    MailSlurp API

    MailSlurp is an API for sending and receiving emails from dynamically allocated email addresses. It's designed for developers and QA teams to test applications, process inbound emails, send templated notifications, attachments, and more.   ## Resources - [Homepage](https://www.mailslurp.com) - Get an [API KEY](https://app.mailslurp.com/sign-up/) - Generated [SDK Clients](https://www.mailslurp.com/docs/) - [Examples](https://github.com/mailslurp/examples) repository   # noqa: E501

    The version of the OpenAPI document: 6.5.2
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from mailslurp_client.configuration import Configuration


class CreateInboxDto(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'allow_team_access': 'bool',
        'description': 'str',
        'email_address': 'str',
        'expires_at': 'datetime',
        'expires_in': 'int',
        'favourite': 'bool',
        'name': 'str',
        'tags': 'list[str]',
        'use_domain_pool': 'bool'
    }

    attribute_map = {
        'allow_team_access': 'allowTeamAccess',
        'description': 'description',
        'email_address': 'emailAddress',
        'expires_at': 'expiresAt',
        'expires_in': 'expiresIn',
        'favourite': 'favourite',
        'name': 'name',
        'tags': 'tags',
        'use_domain_pool': 'useDomainPool'
    }

    def __init__(self, allow_team_access=None, description=None, email_address=None, expires_at=None, expires_in=None, favourite=None, name=None, tags=None, use_domain_pool=None, local_vars_configuration=None):  # noqa: E501
        """CreateInboxDto - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._allow_team_access = None
        self._description = None
        self._email_address = None
        self._expires_at = None
        self._expires_in = None
        self._favourite = None
        self._name = None
        self._tags = None
        self._use_domain_pool = None
        self.discriminator = None

        if allow_team_access is not None:
            self.allow_team_access = allow_team_access
        if description is not None:
            self.description = description
        if email_address is not None:
            self.email_address = email_address
        if expires_at is not None:
            self.expires_at = expires_at
        if expires_in is not None:
            self.expires_in = expires_in
        if favourite is not None:
            self.favourite = favourite
        if name is not None:
            self.name = name
        if tags is not None:
            self.tags = tags
        if use_domain_pool is not None:
            self.use_domain_pool = use_domain_pool

    @property
    def allow_team_access(self):
        """Gets the allow_team_access of this CreateInboxDto.  # noqa: E501

        Grant team access to this inbox and the emails that belong to it for team members of your organization.  # noqa: E501

        :return: The allow_team_access of this CreateInboxDto.  # noqa: E501
        :rtype: bool
        """
        return self._allow_team_access

    @allow_team_access.setter
    def allow_team_access(self, allow_team_access):
        """Sets the allow_team_access of this CreateInboxDto.

        Grant team access to this inbox and the emails that belong to it for team members of your organization.  # noqa: E501

        :param allow_team_access: The allow_team_access of this CreateInboxDto.  # noqa: E501
        :type: bool
        """

        self._allow_team_access = allow_team_access

    @property
    def description(self):
        """Gets the description of this CreateInboxDto.  # noqa: E501

        Optional description of the inbox for labelling purposes. Is shown in the dashboard and can be used with  # noqa: E501

        :return: The description of this CreateInboxDto.  # noqa: E501
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """Sets the description of this CreateInboxDto.

        Optional description of the inbox for labelling purposes. Is shown in the dashboard and can be used with  # noqa: E501

        :param description: The description of this CreateInboxDto.  # noqa: E501
        :type: str
        """

        self._description = description

    @property
    def email_address(self):
        """Gets the email_address of this CreateInboxDto.  # noqa: E501

        A custom email address to use with the inbox. Defaults to null. When null MailSlurp will assign a random email address to the inbox such as `123@mailslurp.com`. If you use the `useDomainPool` option when the email address is null it will generate an email address with a more varied domain ending such as `123@mailslurp.info` or `123@mailslurp.biz`. When a custom email address is provided the address is split into a domain and the domain is queried against your user. If you have created the domain in the MailSlurp dashboard and verified it you can use any email address that ends with the domain. Send an email to this address and the inbox will receive and store it for you. To retrieve the email use the Inbox and Email Controller endpoints with the inbox ID.  # noqa: E501

        :return: The email_address of this CreateInboxDto.  # noqa: E501
        :rtype: str
        """
        return self._email_address

    @email_address.setter
    def email_address(self, email_address):
        """Sets the email_address of this CreateInboxDto.

        A custom email address to use with the inbox. Defaults to null. When null MailSlurp will assign a random email address to the inbox such as `123@mailslurp.com`. If you use the `useDomainPool` option when the email address is null it will generate an email address with a more varied domain ending such as `123@mailslurp.info` or `123@mailslurp.biz`. When a custom email address is provided the address is split into a domain and the domain is queried against your user. If you have created the domain in the MailSlurp dashboard and verified it you can use any email address that ends with the domain. Send an email to this address and the inbox will receive and store it for you. To retrieve the email use the Inbox and Email Controller endpoints with the inbox ID.  # noqa: E501

        :param email_address: The email_address of this CreateInboxDto.  # noqa: E501
        :type: str
        """

        self._email_address = email_address

    @property
    def expires_at(self):
        """Gets the expires_at of this CreateInboxDto.  # noqa: E501

        Optional inbox expiration date. If null then this inbox is permanent and the emails in it won't be deleted. If an expiration date is provided or is required by your plan the inbox will be closed when the expiration time is reached. Expired inboxes still contain their emails but can no longer send or receive emails. An ExpiredInboxRecord is created when an inbox and the email address and inbox ID are recorded. The expiresAt property is a timestamp string in ISO DateTime Format yyyy-MM-dd'T'HH:mm:ss.SSSXXX.  # noqa: E501

        :return: The expires_at of this CreateInboxDto.  # noqa: E501
        :rtype: datetime
        """
        return self._expires_at

    @expires_at.setter
    def expires_at(self, expires_at):
        """Sets the expires_at of this CreateInboxDto.

        Optional inbox expiration date. If null then this inbox is permanent and the emails in it won't be deleted. If an expiration date is provided or is required by your plan the inbox will be closed when the expiration time is reached. Expired inboxes still contain their emails but can no longer send or receive emails. An ExpiredInboxRecord is created when an inbox and the email address and inbox ID are recorded. The expiresAt property is a timestamp string in ISO DateTime Format yyyy-MM-dd'T'HH:mm:ss.SSSXXX.  # noqa: E501

        :param expires_at: The expires_at of this CreateInboxDto.  # noqa: E501
        :type: datetime
        """

        self._expires_at = expires_at

    @property
    def expires_in(self):
        """Gets the expires_in of this CreateInboxDto.  # noqa: E501

        Number of milliseconds that inbox should exist for  # noqa: E501

        :return: The expires_in of this CreateInboxDto.  # noqa: E501
        :rtype: int
        """
        return self._expires_in

    @expires_in.setter
    def expires_in(self, expires_in):
        """Sets the expires_in of this CreateInboxDto.

        Number of milliseconds that inbox should exist for  # noqa: E501

        :param expires_in: The expires_in of this CreateInboxDto.  # noqa: E501
        :type: int
        """

        self._expires_in = expires_in

    @property
    def favourite(self):
        """Gets the favourite of this CreateInboxDto.  # noqa: E501

        Is the inbox favorited. Favouriting inboxes is typically done in the dashboard for quick access or filtering  # noqa: E501

        :return: The favourite of this CreateInboxDto.  # noqa: E501
        :rtype: bool
        """
        return self._favourite

    @favourite.setter
    def favourite(self, favourite):
        """Sets the favourite of this CreateInboxDto.

        Is the inbox favorited. Favouriting inboxes is typically done in the dashboard for quick access or filtering  # noqa: E501

        :param favourite: The favourite of this CreateInboxDto.  # noqa: E501
        :type: bool
        """

        self._favourite = favourite

    @property
    def name(self):
        """Gets the name of this CreateInboxDto.  # noqa: E501

        Optional name of the inbox. Displayed in the dashboard for easier search  # noqa: E501

        :return: The name of this CreateInboxDto.  # noqa: E501
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this CreateInboxDto.

        Optional name of the inbox. Displayed in the dashboard for easier search  # noqa: E501

        :param name: The name of this CreateInboxDto.  # noqa: E501
        :type: str
        """

        self._name = name

    @property
    def tags(self):
        """Gets the tags of this CreateInboxDto.  # noqa: E501

        Tags that inbox has been tagged with. Tags can be added to inboxes to group different inboxes within an account. You can also search for inboxes by tag in the dashboard UI.  # noqa: E501

        :return: The tags of this CreateInboxDto.  # noqa: E501
        :rtype: list[str]
        """
        return self._tags

    @tags.setter
    def tags(self, tags):
        """Sets the tags of this CreateInboxDto.

        Tags that inbox has been tagged with. Tags can be added to inboxes to group different inboxes within an account. You can also search for inboxes by tag in the dashboard UI.  # noqa: E501

        :param tags: The tags of this CreateInboxDto.  # noqa: E501
        :type: list[str]
        """

        self._tags = tags

    @property
    def use_domain_pool(self):
        """Gets the use_domain_pool of this CreateInboxDto.  # noqa: E501

        Use the MailSlurp domain name pool with this inbox when creating the email address. Defaults to null. If enabled the inbox will be an email address with a domain randomly chosen from a list of the MailSlurp domains. This is useful when the default `@mailslurp.com` email addresses used with inboxes are blocked or considered spam by a provider or receiving service. When domain pool is enabled an email address will be generated ending in `@mailslurp.{world,info,xyz,...}` . This means a TLD is randomly selecting from a list of `.biz`, `.info`, `.xyz` etc to add variance to the generated email addresses. When null or false MailSlurp uses the default behavior of `@mailslurp.com` or custom email address provided by the emailAddress field.  # noqa: E501

        :return: The use_domain_pool of this CreateInboxDto.  # noqa: E501
        :rtype: bool
        """
        return self._use_domain_pool

    @use_domain_pool.setter
    def use_domain_pool(self, use_domain_pool):
        """Sets the use_domain_pool of this CreateInboxDto.

        Use the MailSlurp domain name pool with this inbox when creating the email address. Defaults to null. If enabled the inbox will be an email address with a domain randomly chosen from a list of the MailSlurp domains. This is useful when the default `@mailslurp.com` email addresses used with inboxes are blocked or considered spam by a provider or receiving service. When domain pool is enabled an email address will be generated ending in `@mailslurp.{world,info,xyz,...}` . This means a TLD is randomly selecting from a list of `.biz`, `.info`, `.xyz` etc to add variance to the generated email addresses. When null or false MailSlurp uses the default behavior of `@mailslurp.com` or custom email address provided by the emailAddress field.  # noqa: E501

        :param use_domain_pool: The use_domain_pool of this CreateInboxDto.  # noqa: E501
        :type: bool
        """

        self._use_domain_pool = use_domain_pool

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, CreateInboxDto):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, CreateInboxDto):
            return True

        return self.to_dict() != other.to_dict()
