# Generated by Django 3.0.5 on 2020-05-04 12:12
from django.core.management.sql import emit_post_migrate_signal
from django.contrib.auth.models import Permission
from django.db import migrations


def apply_migration(apps, schema_editor):
    # Ensure permissions have been created.
    # Ref: https://code.djangoproject.com/ticket/23422#comment:18
    if not Permission.objects.filter(codename='add_user').exists():
        emit_post_migrate_signal(
            verbosity=1,
            interactive=False,
            db='default',
        )
    Group = apps.get_model('auth', 'Group')
    dpo = Group(name='DPO')
    dpo.save()
    dpo.permissions.add(Permission.objects.get(codename='add_user').pk)
    dpo.permissions.add(Permission.objects.get(codename='change_user').pk)
    dpo.permissions.add(Permission.objects.get(codename='view_signature').pk)
    dpo.permissions.add(Permission.objects.get(codename='view_calloutemail').pk)
    reviewers = Group(name='reviewers')
    reviewers.save()
    dpo.permissions.add(Permission.objects.get(codename='view_signature').pk)
    dpo.permissions.add(Permission.objects.get(codename='view_calloutemail').pk)


def revert_migration(apps, schema_editor):
    Group = apps.get_model('auth', 'Group')
    Group.objects.filter(name__in=['DPO', 'reviewers']).delete()


class Migration(migrations.Migration):

    dependencies = [
        ('appel_crises', '0013_calloutemail_template_id'),
        ('auth', '0011_update_proxy_permissions'),
    ]

    operations = [
        migrations.RunPython(apply_migration, revert_migration)
    ]
