""" Ambra SDK models.

Do not edit this file by hand.
This is generated by parsing /v3/dictionary.html service doc.
"""

from ambra_sdk.models.base import BaseModel
from ambra_sdk.models.fields import (
    FK,
    Boolean,
    Date,
    DateTime,
    DictField,
    Float,
    Integer,
    JsonB,
    String,
)



class Accelerator(BaseModel):
    """Accelerator."""
    
    id = Integer(description='Primary key for internal use')
    uuid = String(description='UUID for external use')
    account_id = Integer(description='FK. The associated account')
    account = FK(model='Account', description='The associated account')
    address = String(description='The domain name and IP address')
    fqdn = String(description='The domain name and IP address')
    name = String(description='Name')
    push_shared_studies = Boolean(description='Push shared studies to the accelerator')
    serial_no = String(description='The serial number')
    upgrade = Boolean(description='Version and upgrade flag')
    version = String(description='Version and upgrade flag')
    created = DateTime(description='Timestamp when the record was created')
    created_by = Integer(description='FK. ID of the user who created the record')
    created_by_obj = FK(model='User', description='ID of the user who created the record')
    updated = DateTime(description='Timestamp when the record was last updated')
    updated_by = Integer(description='FK. ID of the user who updated the record')
    updated_by_obj = FK(model='User', description='ID of the user who updated the record')


    def __init__(
        self,
	*,
        id=None,
        uuid=None,
        account_id=None,
        account=None,
        address=None,
        fqdn=None,
        name=None,
        push_shared_studies=None,
        serial_no=None,
        upgrade=None,
        version=None,
        created=None,
        created_by=None,
        created_by_obj=None,
        updated=None,
        updated_by=None,
        updated_by_obj=None,
    ):
        self.id = id
        self.uuid = uuid
        self.account_id = account_id
        self.account = account
        self.address = address
        self.fqdn = fqdn
        self.name = name
        self.push_shared_studies = push_shared_studies
        self.serial_no = serial_no
        self.upgrade = upgrade
        self.version = version
        self.created = created
        self.created_by = created_by
        self.created_by_obj = created_by_obj
        self.updated = updated
        self.updated_by = updated_by
        self.updated_by_obj = updated_by_obj



class Account(BaseModel):
    """Account."""
    
    id = Integer(description='Primary key for internal use')
    uuid = String(description='UUID for external use')
    access_token = String(description='Stripe access token')
    billing = DictField(description='Billing information')
    can_request = Boolean(description='Can request')
    css = String(description='Account css')
    customfields = DictField(description='Custom fields')
    fair_warning = String(description='Fair warning data. This should be a JSON hash of the keys needed to run and distribute the report')
    name = String(description='Name')
    namespace_id = Integer(description='FK. Namespace of the account')
    namespace = FK(model='Namespace', description='Namespace of the account')
    password_expire = Integer(description='Days before the passwords expire')
    role_id = Integer(description='FK. Default role id')
    role = FK(model='Role', description='Default role id')
    saml = DictField(description='Native SAML information')
    session_expire = Integer(description='Minutes before an idle session expires')
    settings = DictField(description='Account settings')
    vanity_h = DictField(description='Vanity URLs')
    vendor = String(description='The vendor field')
    created = DateTime(description='Timestamp when the record was created')
    created_by = Integer(description='FK. ID of the user who created the record')
    created_by_obj = FK(model='User', description='ID of the user who created the record')
    updated = DateTime(description='Timestamp when the record was last updated')
    updated_by = Integer(description='FK. ID of the user who updated the record')
    updated_by_obj = FK(model='User', description='ID of the user who updated the record')


    def __init__(
        self,
	*,
        id=None,
        uuid=None,
        access_token=None,
        billing=None,
        can_request=None,
        css=None,
        customfields=None,
        fair_warning=None,
        name=None,
        namespace_id=None,
        namespace=None,
        password_expire=None,
        role_id=None,
        role=None,
        saml=None,
        session_expire=None,
        settings=None,
        vanity_h=None,
        vendor=None,
        created=None,
        created_by=None,
        created_by_obj=None,
        updated=None,
        updated_by=None,
        updated_by_obj=None,
    ):
        self.id = id
        self.uuid = uuid
        self.access_token = access_token
        self.billing = billing
        self.can_request = can_request
        self.css = css
        self.customfields = customfields
        self.fair_warning = fair_warning
        self.name = name
        self.namespace_id = namespace_id
        self.namespace = namespace
        self.password_expire = password_expire
        self.role_id = role_id
        self.role = role
        self.saml = saml
        self.session_expire = session_expire
        self.settings = settings
        self.vanity_h = vanity_h
        self.vendor = vendor
        self.created = created
        self.created_by = created_by
        self.created_by_obj = created_by_obj
        self.updated = updated
        self.updated_by = updated_by
        self.updated_by_obj = updated_by_obj



class AccountCanShare(BaseModel):
    """AccountCanShare."""
    
    id = Integer(description='Primary key for internal use')
    account_id = Integer(description='FK. The account this rule is for')
    account = FK(model='Account', description='The account this rule is for')
    by_account_id = Integer(description='FK. Who is sharing')
    by_account = FK(model='Account', description='Who is sharing')
    by_group_id = Integer(description='FK. Who is sharing')
    by_group = FK(model='Group', description='Who is sharing')
    by_location_id = Integer(description='FK. Who is sharing')
    by_location = FK(model='Location', description='Who is sharing')
    by_user_id = Integer(description='FK. Who is sharing')
    by_user = FK(model='User', description='Who is sharing')
    with_account_id = Integer(description='FK. With who can they share')
    with_account = FK(model='Account', description='With who can they share')
    with_group_id = Integer(description='FK. With who can they share')
    with_group = FK(model='Group', description='With who can they share')
    with_location_id = Integer(description='FK. With who can they share')
    with_location = FK(model='Location', description='With who can they share')
    with_user_id = Integer(description='FK. With who can they share')
    with_user = FK(model='User', description='With who can they share')
    created = DateTime(description='Timestamp when the record was created')
    created_by = Integer(description='FK. ID of the user who created the record')
    created_by_obj = FK(model='User', description='ID of the user who created the record')
    updated = DateTime(description='Timestamp when the record was last updated')
    updated_by = Integer(description='FK. ID of the user who updated the record')
    updated_by_obj = FK(model='User', description='ID of the user who updated the record')


    def __init__(
        self,
	*,
        id=None,
        account_id=None,
        account=None,
        by_account_id=None,
        by_account=None,
        by_group_id=None,
        by_group=None,
        by_location_id=None,
        by_location=None,
        by_user_id=None,
        by_user=None,
        with_account_id=None,
        with_account=None,
        with_group_id=None,
        with_group=None,
        with_location_id=None,
        with_location=None,
        with_user_id=None,
        with_user=None,
        created=None,
        created_by=None,
        created_by_obj=None,
        updated=None,
        updated_by=None,
        updated_by_obj=None,
    ):
        self.id = id
        self.account_id = account_id
        self.account = account
        self.by_account_id = by_account_id
        self.by_account = by_account
        self.by_group_id = by_group_id
        self.by_group = by_group
        self.by_location_id = by_location_id
        self.by_location = by_location
        self.by_user_id = by_user_id
        self.by_user = by_user
        self.with_account_id = with_account_id
        self.with_account = with_account
        self.with_group_id = with_group_id
        self.with_group = with_group
        self.with_location_id = with_location_id
        self.with_location = with_location
        self.with_user_id = with_user_id
        self.with_user = with_user
        self.created = created
        self.created_by = created_by
        self.created_by_obj = created_by_obj
        self.updated = updated
        self.updated_by = updated_by
        self.updated_by_obj = updated_by_obj



class AccountMd5Counter(BaseModel):
    """AccountMd5Counter."""
    
    id = Integer(description='Primary key for internal use')
    account_id = Integer(description='FK. Primary key for internal use')
    account = FK(model='Account', description='Primary key for internal use')
    counter = Integer(description='Primary key for internal use')
    md5 = String(description='Primary key for internal use')
    created = DateTime(description='Timestamp when the record was created')
    created_by = Integer(description='FK. ID of the user who created the record')
    created_by_obj = FK(model='User', description='ID of the user who created the record')


    def __init__(
        self,
	*,
        id=None,
        account_id=None,
        account=None,
        counter=None,
        md5=None,
        created=None,
        created_by=None,
        created_by_obj=None,
    ):
        self.id = id
        self.account_id = account_id
        self.account = account
        self.counter = counter
        self.md5 = md5
        self.created = created
        self.created_by = created_by
        self.created_by_obj = created_by_obj



class AccountSamlRole(BaseModel):
    """AccountSamlRole."""
    
    id = Integer(description='Primary key for internal use')
    account_id = Integer(description='FK. The account this rule is for')
    account = FK(model='Account', description='The account this rule is for')
    event_approve = Boolean(description='The event flags')
    event_case_assignment = Boolean(description='The event flags')
    event_harvest = Boolean(description='The event flags')
    event_link = Boolean(description='The event flags')
    event_link_mine = Boolean(description='The event flags')
    event_message = Boolean(description='The event flags')
    event_new_report = Boolean(description='The event flags')
    event_node = Boolean(description='The event flags')
    event_report_remove = Boolean(description='The event flags')
    event_share = Boolean(description='The event flags')
    event_status_change = Boolean(description='The event flags')
    event_study_comment = Boolean(description='The event flags')
    event_thin_study_fail = Boolean(description='The event flags')
    event_thin_study_success = Boolean(description='The event flags')
    event_upload = Boolean(description='The event flags')
    event_upload_fail = Boolean(description='The event flags')
    namespace_id = Integer(description='FK. The namespace this is for')
    namespace = FK(model='Namespace', description='The namespace this is for')
    role_id = Integer(description='FK. The role this is for')
    role = FK(model='Role', description='The role this is for')
    saml_role = String(description='The SAML role')
    sequence = Integer(description='Ordering sequence')
    created = DateTime(description='Timestamp when the record was created')
    created_by = Integer(description='FK. ID of the user who created the record')
    created_by_obj = FK(model='User', description='ID of the user who created the record')
    updated = DateTime(description='Timestamp when the record was last updated')
    updated_by = Integer(description='FK. ID of the user who updated the record')
    updated_by_obj = FK(model='User', description='ID of the user who updated the record')


    def __init__(
        self,
	*,
        id=None,
        account_id=None,
        account=None,
        event_approve=None,
        event_case_assignment=None,
        event_harvest=None,
        event_link=None,
        event_link_mine=None,
        event_message=None,
        event_new_report=None,
        event_node=None,
        event_report_remove=None,
        event_share=None,
        event_status_change=None,
        event_study_comment=None,
        event_thin_study_fail=None,
        event_thin_study_success=None,
        event_upload=None,
        event_upload_fail=None,
        namespace_id=None,
        namespace=None,
        role_id=None,
        role=None,
        saml_role=None,
        sequence=None,
        created=None,
        created_by=None,
        created_by_obj=None,
        updated=None,
        updated_by=None,
        updated_by_obj=None,
    ):
        self.id = id
        self.account_id = account_id
        self.account = account
        self.event_approve = event_approve
        self.event_case_assignment = event_case_assignment
        self.event_harvest = event_harvest
        self.event_link = event_link
        self.event_link_mine = event_link_mine
        self.event_message = event_message
        self.event_new_report = event_new_report
        self.event_node = event_node
        self.event_report_remove = event_report_remove
        self.event_share = event_share
        self.event_status_change = event_status_change
        self.event_study_comment = event_study_comment
        self.event_thin_study_fail = event_thin_study_fail
        self.event_thin_study_success = event_thin_study_success
        self.event_upload = event_upload
        self.event_upload_fail = event_upload_fail
        self.namespace_id = namespace_id
        self.namespace = namespace
        self.role_id = role_id
        self.role = role
        self.saml_role = saml_role
        self.sequence = sequence
        self.created = created
        self.created_by = created_by
        self.created_by_obj = created_by_obj
        self.updated = updated
        self.updated_by = updated_by
        self.updated_by_obj = updated_by_obj



class Activity(BaseModel):
    """Activity."""
    
    id = Integer(description='Primary key for internal use')
    uuid = String(description='UUID for external use')
    message = String(description='Message associated with activity')
    namespace_id = Integer(description='FK. Id of the namespace the activity is associated with')
    namespace = FK(model='Namespace', description='Id of the namespace the activity is associated with')
    study_id = Integer(description='FK. Id of the study the activity is associated with')
    study = FK(model='Study', description='Id of the study the activity is associated with')
    type_field = String(description='Type of activity')
    user_id = Integer(description='FK. Id of the user the activity is specifically for.')
    user = FK(model='User', description='Id of the user the activity is specifically for.')
    created = DateTime(description='Timestamp when the record was created')
    created_by = Integer(description='FK. ID of the user who created the record')
    created_by_obj = FK(model='User', description='ID of the user who created the record')
    updated = DateTime(description='Timestamp when the record was last updated')
    updated_by = Integer(description='FK. ID of the user who updated the record')
    updated_by_obj = FK(model='User', description='ID of the user who updated the record')


    def __init__(
        self,
	*,
        id=None,
        uuid=None,
        message=None,
        namespace_id=None,
        namespace=None,
        study_id=None,
        study=None,
        type_field=None,
        user_id=None,
        user=None,
        created=None,
        created_by=None,
        created_by_obj=None,
        updated=None,
        updated_by=None,
        updated_by_obj=None,
    ):
        self.id = id
        self.uuid = uuid
        self.message = message
        self.namespace_id = namespace_id
        self.namespace = namespace
        self.study_id = study_id
        self.study = study
        self.type_field = type_field
        self.user_id = user_id
        self.user = user
        self.created = created
        self.created_by = created_by
        self.created_by_obj = created_by_obj
        self.updated = updated
        self.updated_by = updated_by
        self.updated_by_obj = updated_by_obj



class Analytics(BaseModel):
    """Analytics."""
    
    id = Integer(description='Primary key for internal use')
    last_id = Integer(description='The id of the last audit job processed')
    created = DateTime(description='Timestamp when the record was created')
    created_by = Integer(description='FK. ID of the user who created the record')
    created_by_obj = FK(model='User', description='ID of the user who created the record')
    updated = DateTime(description='Timestamp when the record was last updated')
    updated_by = Integer(description='FK. ID of the user who updated the record')
    updated_by_obj = FK(model='User', description='ID of the user who updated the record')


    def __init__(
        self,
	*,
        id=None,
        last_id=None,
        created=None,
        created_by=None,
        created_by_obj=None,
        updated=None,
        updated_by=None,
        updated_by_obj=None,
    ):
        self.id = id
        self.last_id = last_id
        self.created = created
        self.created_by = created_by
        self.created_by_obj = created_by_obj
        self.updated = updated
        self.updated_by = updated_by
        self.updated_by_obj = updated_by_obj



class Annotation(BaseModel):
    """Annotation."""
    
    id = Integer(description='Primary key for internal use')
    uuid = String(description='UUID for external use')
    frame_number = String(description='The frame identification')
    instance_uid = String(description='The frame identification')
    json = String(description='Data structure')
    series_uid = String(description='The frame identification')
    stamp = Boolean(description='This is a stamped so no other user can create or edit an annotation for this image')
    study_id = Integer(description='FK. Associated study')
    study = FK(model='Study', description='Associated study')
    user_id = Integer(description='FK. User who created the annotation')
    user = FK(model='User', description='User who created the annotation')
    created = DateTime(description='Timestamp when the record was created')
    created_by = Integer(description='FK. ID of the user who created the record')
    created_by_obj = FK(model='User', description='ID of the user who created the record')
    updated = DateTime(description='Timestamp when the record was last updated')
    updated_by = Integer(description='FK. ID of the user who updated the record')
    updated_by_obj = FK(model='User', description='ID of the user who updated the record')


    def __init__(
        self,
	*,
        id=None,
        uuid=None,
        frame_number=None,
        instance_uid=None,
        json=None,
        series_uid=None,
        stamp=None,
        study_id=None,
        study=None,
        user_id=None,
        user=None,
        created=None,
        created_by=None,
        created_by_obj=None,
        updated=None,
        updated_by=None,
        updated_by_obj=None,
    ):
        self.id = id
        self.uuid = uuid
        self.frame_number = frame_number
        self.instance_uid = instance_uid
        self.json = json
        self.series_uid = series_uid
        self.stamp = stamp
        self.study_id = study_id
        self.study = study
        self.user_id = user_id
        self.user = user
        self.created = created
        self.created_by = created_by
        self.created_by_obj = created_by_obj
        self.updated = updated
        self.updated_by = updated_by
        self.updated_by_obj = updated_by_obj



class Appointment(BaseModel):
    """Appointment."""
    
    id = Integer(description='Primary key for internal use')
    uuid = String(description='UUID for external use')
    account_id = Integer(description='FK. The associated account')
    account = FK(model='Account', description='The associated account')
    customfields = DictField(description='Custom fields')
    description = String(description='Description')
    end_time = DateTime(description='Time range')
    patient_id = Integer(description='FK. The associated patient')
    patient = FK(model='Patient', description='The associated patient')
    start_time = DateTime(description='Time range')
    user_id = Integer(description='FK. The associated user')
    user = FK(model='User', description='The associated user')
    created = DateTime(description='Timestamp when the record was created')
    created_by = Integer(description='FK. ID of the user who created the record')
    created_by_obj = FK(model='User', description='ID of the user who created the record')
    updated = DateTime(description='Timestamp when the record was last updated')
    updated_by = Integer(description='FK. ID of the user who updated the record')
    updated_by_obj = FK(model='User', description='ID of the user who updated the record')


    def __init__(
        self,
	*,
        id=None,
        uuid=None,
        account_id=None,
        account=None,
        customfields=None,
        description=None,
        end_time=None,
        patient_id=None,
        patient=None,
        start_time=None,
        user_id=None,
        user=None,
        created=None,
        created_by=None,
        created_by_obj=None,
        updated=None,
        updated_by=None,
        updated_by_obj=None,
    ):
        self.id = id
        self.uuid = uuid
        self.account_id = account_id
        self.account = account
        self.customfields = customfields
        self.description = description
        self.end_time = end_time
        self.patient_id = patient_id
        self.patient = patient
        self.start_time = start_time
        self.user_id = user_id
        self.user = user
        self.created = created
        self.created_by = created_by
        self.created_by_obj = created_by_obj
        self.updated = updated
        self.updated_by = updated_by
        self.updated_by_obj = updated_by_obj



class ArchiveStudy(BaseModel):
    """ArchiveStudy."""
    
    id = Integer(description='Primary key for internal use')
    uuid = String(description='UUID for external use')
    archive_vault_id = Integer(description='FK. The vault it is stored in')
    archive_vault = FK(model='Archive', description='The vault it is stored in')
    datum_signature = String(description='Signature of the current study datum and phi')
    delay_until = DateTime(description='Delay the store or delete until this time')
    engine_id = Integer(description='FK. The storage engine')
    engine = FK(model='Engine', description='The storage engine')
    job_id = String(description='When was the job started and the Last error message')
    last_error = String(description='When was the job started and the Last error message')
    need_delete = Boolean(description='Flag to control the store,restore and delete of the study. Indexed so the count in the control loop is fast')
    need_restore = Boolean(description='Flag to control the store,restore and delete of the study. Indexed so the count in the control loop is fast')
    need_store = Boolean(description='Flag to control the store,restore and delete of the study. Indexed so the count in the control loop is fast')
    phi_signature = String(description='Signature of the current study datum and phi')
    priority = Integer(description='Job priority. The higher the number the higher the priority of the job. This mirrors the archive flag in namespace')
    started_at = DateTime(description='When was the job started and the Last error message')
    storage_namespace = Integer(description='FK. The storage namespace')
    storage_namespace_obj = FK(model='Namespace', description='The storage namespace')
    study_uid = String(description='Study instance id')
    created = DateTime(description='Timestamp when the record was created')
    created_by = Integer(description='FK. ID of the user who created the record')
    created_by_obj = FK(model='User', description='ID of the user who created the record')
    updated = DateTime(description='Timestamp when the record was last updated')
    updated_by = Integer(description='FK. ID of the user who updated the record')
    updated_by_obj = FK(model='User', description='ID of the user who updated the record')


    def __init__(
        self,
	*,
        id=None,
        uuid=None,
        archive_vault_id=None,
        archive_vault=None,
        datum_signature=None,
        delay_until=None,
        engine_id=None,
        engine=None,
        job_id=None,
        last_error=None,
        need_delete=None,
        need_restore=None,
        need_store=None,
        phi_signature=None,
        priority=None,
        started_at=None,
        storage_namespace=None,
        storage_namespace_obj=None,
        study_uid=None,
        created=None,
        created_by=None,
        created_by_obj=None,
        updated=None,
        updated_by=None,
        updated_by_obj=None,
    ):
        self.id = id
        self.uuid = uuid
        self.archive_vault_id = archive_vault_id
        self.archive_vault = archive_vault
        self.datum_signature = datum_signature
        self.delay_until = delay_until
        self.engine_id = engine_id
        self.engine = engine
        self.job_id = job_id
        self.last_error = last_error
        self.need_delete = need_delete
        self.need_restore = need_restore
        self.need_store = need_store
        self.phi_signature = phi_signature
        self.priority = priority
        self.started_at = started_at
        self.storage_namespace = storage_namespace
        self.storage_namespace_obj = storage_namespace_obj
        self.study_uid = study_uid
        self.created = created
        self.created_by = created_by
        self.created_by_obj = created_by_obj
        self.updated = updated
        self.updated_by = updated_by
        self.updated_by_obj = updated_by_obj



class ArchiveStudyAws(BaseModel):
    """ArchiveStudyAws."""
    
    id = Integer(description='Primary key for internal use')
    uuid = String(description='UUID for external use')
    archive_study_id = Integer(description='FK. The associated study archive')
    archive_study = FK(model='Archive', description='The associated study archive')
    aws_archive = String(description='The id of the AWS archive')
    aws_checksum = String(description='Checksum from AWS archive')
    aws_size = Integer(description='Checksum from AWS archive')
    datum_signature = String(description='Signature of the current study datum and phi')
    job_id = String(description='Job Id and state, restoring state can be PENDING, RETRIEVING, DONE')
    phi_signature = String(description='Signature of the current study datum and phi')
    state = String(description='Job Id and state, restoring state can be PENDING, RETRIEVING, DONE')
    type_field = String(description='Type archive either datum or phi')
    created = DateTime(description='Timestamp when the record was created')
    created_by = Integer(description='FK. ID of the user who created the record')
    created_by_obj = FK(model='User', description='ID of the user who created the record')
    updated = DateTime(description='Timestamp when the record was last updated')
    updated_by = Integer(description='FK. ID of the user who updated the record')
    updated_by_obj = FK(model='User', description='ID of the user who updated the record')


    def __init__(
        self,
	*,
        id=None,
        uuid=None,
        archive_study_id=None,
        archive_study=None,
        aws_archive=None,
        aws_checksum=None,
        aws_size=None,
        datum_signature=None,
        job_id=None,
        phi_signature=None,
        state=None,
        type_field=None,
        created=None,
        created_by=None,
        created_by_obj=None,
        updated=None,
        updated_by=None,
        updated_by_obj=None,
    ):
        self.id = id
        self.uuid = uuid
        self.archive_study_id = archive_study_id
        self.archive_study = archive_study
        self.aws_archive = aws_archive
        self.aws_checksum = aws_checksum
        self.aws_size = aws_size
        self.datum_signature = datum_signature
        self.job_id = job_id
        self.phi_signature = phi_signature
        self.state = state
        self.type_field = type_field
        self.created = created
        self.created_by = created_by
        self.created_by_obj = created_by_obj
        self.updated = updated
        self.updated_by = updated_by
        self.updated_by_obj = updated_by_obj



class ArchiveVault(BaseModel):
    """ArchiveVault."""
    
    id = Integer(description='Primary key for internal use')
    uuid = String(description='UUID for external use')
    closed = Boolean(description='Is the archive closed for new records')
    key = String(description='AWS credentials')
    region = String(description='AWS credentials')
    secret = String(description='AWS credentials')
    vault = String(description='AWS credentials')
    created = DateTime(description='Timestamp when the record was created')
    created_by = Integer(description='FK. ID of the user who created the record')
    created_by_obj = FK(model='User', description='ID of the user who created the record')
    updated = DateTime(description='Timestamp when the record was last updated')
    updated_by = Integer(description='FK. ID of the user who updated the record')
    updated_by_obj = FK(model='User', description='ID of the user who updated the record')


    def __init__(
        self,
	*,
        id=None,
        uuid=None,
        closed=None,
        key=None,
        region=None,
        secret=None,
        vault=None,
        created=None,
        created_by=None,
        created_by_obj=None,
        updated=None,
        updated_by=None,
        updated_by_obj=None,
    ):
        self.id = id
        self.uuid = uuid
        self.closed = closed
        self.key = key
        self.region = region
        self.secret = secret
        self.vault = vault
        self.created = created
        self.created_by = created_by
        self.created_by_obj = created_by_obj
        self.updated = updated
        self.updated_by = updated_by
        self.updated_by_obj = updated_by_obj



class Audit(BaseModel):
    """Audit."""
    
    id = Integer(description='Primary key for internal use')
    uuid = String(description='UUID for external use')
    account_id = Integer(description='FK. Account id of the association account')
    account = FK(model='Account', description='Account id of the association account')
    action = String(description='The audit action')
    data = String(description='The audit data')
    parent_id = Integer(description='FK. Id of the parent object')
    parent = FK(model='SelfField', description='Id of the parent object')
    pid = String(description='After the June 29 2016 release this holds the sid and client ip address')
    proxy_id = Integer(description='FK. Id of the proxy user who did the action')
    proxy = FK(model='User', description='Id of the proxy user who did the action')
    type_field = String(description='Type of object we are auditing')
    user_id = Integer(description='FK. User who did the action')
    user = FK(model='User', description='User who did the action')
    created = DateTime(description='Timestamp when the record was created')


    def __init__(
        self,
	*,
        id=None,
        uuid=None,
        account_id=None,
        account=None,
        action=None,
        data=None,
        parent_id=None,
        parent=None,
        pid=None,
        proxy_id=None,
        proxy=None,
        type_field=None,
        user_id=None,
        user=None,
        created=None,
    ):
        self.id = id
        self.uuid = uuid
        self.account_id = account_id
        self.account = account
        self.action = action
        self.data = data
        self.parent_id = parent_id
        self.parent = parent
        self.pid = pid
        self.proxy_id = proxy_id
        self.proxy = proxy
        self.type_field = type_field
        self.user_id = user_id
        self.user = user
        self.created = created



class BillingSummary(BaseModel):
    """BillingSummary."""
    
    id = Integer(description='Primary key for internal use')
    uuid = String(description='UUID for external use')
    account_id = Integer(description='FK. The account')
    account = FK(model='Account', description='The account')
    account_name = String(description='The account')
    account_uuid = String(description='The account')
    admin_fee = Float(description='The fields')
    annual_volume_floor_count = Float(description='The fields')
    bucket_charges = Float(description='The fields')
    flat_rate = Float(description='The fields')
    month = String(description='The month this is for')
    monthly_volume_floor_count = Float(description='The fields')
    mtd_studies = Float(description='The fields')
    per_study_price = Float(description='The fields')
    size = Float(description='The fields')
    size_past = Float(description='The fields')
    size_price = Float(description='The fields')
    size_price_past = Float(description='The fields')
    storage_overage = Float(description='The fields')
    storage_price = Float(description='The fields')
    total = Float(description='The fields')
    total_storage_size = Float(description='The fields')
    ytd_studies = Float(description='The fields')
    created = DateTime(description='Timestamp when the record was created')
    created_by = Integer(description='FK. ID of the user who created the record')
    created_by_obj = FK(model='User', description='ID of the user who created the record')
    updated = DateTime(description='Timestamp when the record was last updated')
    updated_by = Integer(description='FK. ID of the user who updated the record')
    updated_by_obj = FK(model='User', description='ID of the user who updated the record')


    def __init__(
        self,
	*,
        id=None,
        uuid=None,
        account_id=None,
        account=None,
        account_name=None,
        account_uuid=None,
        admin_fee=None,
        annual_volume_floor_count=None,
        bucket_charges=None,
        flat_rate=None,
        month=None,
        monthly_volume_floor_count=None,
        mtd_studies=None,
        per_study_price=None,
        size=None,
        size_past=None,
        size_price=None,
        size_price_past=None,
        storage_overage=None,
        storage_price=None,
        total=None,
        total_storage_size=None,
        ytd_studies=None,
        created=None,
        created_by=None,
        created_by_obj=None,
        updated=None,
        updated_by=None,
        updated_by_obj=None,
    ):
        self.id = id
        self.uuid = uuid
        self.account_id = account_id
        self.account = account
        self.account_name = account_name
        self.account_uuid = account_uuid
        self.admin_fee = admin_fee
        self.annual_volume_floor_count = annual_volume_floor_count
        self.bucket_charges = bucket_charges
        self.flat_rate = flat_rate
        self.month = month
        self.monthly_volume_floor_count = monthly_volume_floor_count
        self.mtd_studies = mtd_studies
        self.per_study_price = per_study_price
        self.size = size
        self.size_past = size_past
        self.size_price = size_price
        self.size_price_past = size_price_past
        self.storage_overage = storage_overage
        self.storage_price = storage_price
        self.total = total
        self.total_storage_size = total_storage_size
        self.ytd_studies = ytd_studies
        self.created = created
        self.created_by = created_by
        self.created_by_obj = created_by_obj
        self.updated = updated
        self.updated_by = updated_by
        self.updated_by_obj = updated_by_obj



class BoxFile(BaseModel):
    """BoxFile."""
    
    id = Integer(description='Primary key for internal use')
    uuid = String(description='UUID for external use')
    not_dicom = Boolean(description='Flag if this is not a dicom file')
    sha1 = String(description='Sha1 of the file')
    storage_namespace = Integer(description='FK. The storage namespace')
    storage_namespace_obj = FK(model='Namespace', description='The storage namespace')
    study_uid = String(description='Study instance id')
    user_id = Integer(description='FK. User who created it')
    user = FK(model='User', description='User who created it')
    created = DateTime(description='Timestamp when the record was created')
    created_by = Integer(description='FK. ID of the user who created the record')
    created_by_obj = FK(model='User', description='ID of the user who created the record')
    updated = DateTime(description='Timestamp when the record was last updated')
    updated_by = Integer(description='FK. ID of the user who updated the record')
    updated_by_obj = FK(model='User', description='ID of the user who updated the record')


    def __init__(
        self,
	*,
        id=None,
        uuid=None,
        not_dicom=None,
        sha1=None,
        storage_namespace=None,
        storage_namespace_obj=None,
        study_uid=None,
        user_id=None,
        user=None,
        created=None,
        created_by=None,
        created_by_obj=None,
        updated=None,
        updated_by=None,
        updated_by_obj=None,
    ):
        self.id = id
        self.uuid = uuid
        self.not_dicom = not_dicom
        self.sha1 = sha1
        self.storage_namespace = storage_namespace
        self.storage_namespace_obj = storage_namespace_obj
        self.study_uid = study_uid
        self.user_id = user_id
        self.user = user
        self.created = created
        self.created_by = created_by
        self.created_by_obj = created_by_obj
        self.updated = updated
        self.updated_by = updated_by
        self.updated_by_obj = updated_by_obj



class Brand(BaseModel):
    """Brand."""
    
    id = Integer(description='Primary key for internal use')
    uuid = String(description='UUID for external use')
    anonymous_permissions = String(description='The permissions over-ride as a json structure')
    cd_multi = String(description='The branding elements')
    cd_single = String(description='The branding elements')
    cd_viewer_settings = String(description='The branding elements')
    cluster_id = Integer(description='FK. The cluster associated with the brand')
    cluster = FK(model='Cluster', description='The cluster associated with the brand')
    css = String(description='The branding elements')
    image_1 = String(description='The branding elements')
    image_2 = String(description='The branding elements')
    image_3 = String(description='The branding elements')
    less = String(description='The branding elements')
    name = String(description='Name for the brand')
    oauth = String(description='OAuth information')
    phr_default_events = String(description='The events over-ride as a json structure')
    phr_permissions = String(description='The permissions over-ride as a json structure')
    safari_instruction_1 = String(description='The branding elements')
    safari_instruction_2 = String(description='The branding elements')
    safari_instruction_3 = String(description='The branding elements')
    safari_instruction_4 = String(description='The branding elements')
    safari_instruction_5 = String(description='The branding elements')
    saml = DictField(description='Native SAML information')
    saml_redirect_url = String(description='PingOne SAML info')
    session_expire = Integer(description='Minutes before an idle session expires')
    settings = DictField(description='Brand settings')
    ssi_js = String(description='The branding elements')
    support_html = String(description='The branding elements')
    ui_json = String(description='The branding elements')
    uploader_icon = String(description='The branding elements')
    uploader_logo = String(description='The branding elements')
    created = DateTime(description='Timestamp when the record was created')
    created_by = Integer(description='FK. ID of the user who created the record')
    created_by_obj = FK(model='User', description='ID of the user who created the record')
    updated = DateTime(description='Timestamp when the record was last updated')
    updated_by = Integer(description='FK. ID of the user who updated the record')
    updated_by_obj = FK(model='User', description='ID of the user who updated the record')


    def __init__(
        self,
	*,
        id=None,
        uuid=None,
        anonymous_permissions=None,
        cd_multi=None,
        cd_single=None,
        cd_viewer_settings=None,
        cluster_id=None,
        cluster=None,
        css=None,
        image_1=None,
        image_2=None,
        image_3=None,
        less=None,
        name=None,
        oauth=None,
        phr_default_events=None,
        phr_permissions=None,
        safari_instruction_1=None,
        safari_instruction_2=None,
        safari_instruction_3=None,
        safari_instruction_4=None,
        safari_instruction_5=None,
        saml=None,
        saml_redirect_url=None,
        session_expire=None,
        settings=None,
        ssi_js=None,
        support_html=None,
        ui_json=None,
        uploader_icon=None,
        uploader_logo=None,
        created=None,
        created_by=None,
        created_by_obj=None,
        updated=None,
        updated_by=None,
        updated_by_obj=None,
    ):
        self.id = id
        self.uuid = uuid
        self.anonymous_permissions = anonymous_permissions
        self.cd_multi = cd_multi
        self.cd_single = cd_single
        self.cd_viewer_settings = cd_viewer_settings
        self.cluster_id = cluster_id
        self.cluster = cluster
        self.css = css
        self.image_1 = image_1
        self.image_2 = image_2
        self.image_3 = image_3
        self.less = less
        self.name = name
        self.oauth = oauth
        self.phr_default_events = phr_default_events
        self.phr_permissions = phr_permissions
        self.safari_instruction_1 = safari_instruction_1
        self.safari_instruction_2 = safari_instruction_2
        self.safari_instruction_3 = safari_instruction_3
        self.safari_instruction_4 = safari_instruction_4
        self.safari_instruction_5 = safari_instruction_5
        self.saml = saml
        self.saml_redirect_url = saml_redirect_url
        self.session_expire = session_expire
        self.settings = settings
        self.ssi_js = ssi_js
        self.support_html = support_html
        self.ui_json = ui_json
        self.uploader_icon = uploader_icon
        self.uploader_logo = uploader_logo
        self.created = created
        self.created_by = created_by
        self.created_by_obj = created_by_obj
        self.updated = updated
        self.updated_by = updated_by
        self.updated_by_obj = updated_by_obj



class BrandNamespace(BaseModel):
    """BrandNamespace."""
    
    id = Integer(description='Primary key for internal use')
    uuid = String(description='UUID for external use')
    brand_id = Integer(description='FK. ')
    brand = FK(model='Brand', description='')
    namespace_id = String(description='')
    created = DateTime(description='Timestamp when the record was created')
    created_by = Integer(description='FK. ID of the user who created the record')
    created_by_obj = FK(model='User', description='ID of the user who created the record')
    updated = DateTime(description='Timestamp when the record was last updated')
    updated_by = Integer(description='FK. ID of the user who updated the record')
    updated_by_obj = FK(model='User', description='ID of the user who updated the record')


    def __init__(
        self,
	*,
        id=None,
        uuid=None,
        brand_id=None,
        brand=None,
        namespace_id=None,
        created=None,
        created_by=None,
        created_by_obj=None,
        updated=None,
        updated_by=None,
        updated_by_obj=None,
    ):
        self.id = id
        self.uuid = uuid
        self.brand_id = brand_id
        self.brand = brand
        self.namespace_id = namespace_id
        self.created = created
        self.created_by = created_by
        self.created_by_obj = created_by_obj
        self.updated = updated
        self.updated_by = updated_by
        self.updated_by_obj = updated_by_obj



class BrandVanity(BaseModel):
    """BrandVanity."""
    
    id = Integer(description='Primary key for internal use')
    uuid = String(description='UUID for external use')
    brand_id = Integer(description='FK. ')
    brand = FK(model='Brand', description='')
    vanity = String(description='')
    created = DateTime(description='Timestamp when the record was created')
    created_by = Integer(description='FK. ID of the user who created the record')
    created_by_obj = FK(model='User', description='ID of the user who created the record')
    updated = DateTime(description='Timestamp when the record was last updated')
    updated_by = Integer(description='FK. ID of the user who updated the record')
    updated_by_obj = FK(model='User', description='ID of the user who updated the record')


    def __init__(
        self,
	*,
        id=None,
        uuid=None,
        brand_id=None,
        brand=None,
        vanity=None,
        created=None,
        created_by=None,
        created_by_obj=None,
        updated=None,
        updated_by=None,
        updated_by_obj=None,
    ):
        self.id = id
        self.uuid = uuid
        self.brand_id = brand_id
        self.brand = brand
        self.vanity = vanity
        self.created = created
        self.created_by = created_by
        self.created_by_obj = created_by_obj
        self.updated = updated
        self.updated_by = updated_by
        self.updated_by_obj = updated_by_obj



class Case(BaseModel):
    """Case."""
    
    id = Integer(description='Primary key for internal use')
    uuid = String(description='UUID for external use')
    account_id = Integer(description='FK. The associated account')
    account = FK(model='Account', description='The associated account')
    assigned_admin_date = DateTime(description='The admin assigned to the case')
    assigned_admin_id = Integer(description='FK. The admin assigned to the case')
    assigned_admin = FK(model='User', description='The admin assigned to the case')
    assigned_medical_date = DateTime(description='The medical person assigned to the case')
    assigned_medical_id = Integer(description='FK. The medical person assigned to the case')
    assigned_medical = FK(model='User', description='The medical person assigned to the case')
    case_status = String(description='The status of the case and the date of the last change')
    case_status_date = DateTime(description='The status of the case and the date of the last change')
    closed = Boolean(description='The case is closed')
    closed_date = DateTime(description='The case is closed')
    completed = Boolean(description='The case is completed')
    completed_date = DateTime(description='The case is completed')
    customfields = DictField(description='Custom fields')
    name = String(description='Basic information')
    namespace_id = Integer(description='FK. The namespace the case is in')
    namespace = FK(model='Namespace', description='The namespace the case is in')
    returned_date = DateTime(description='The returned date and reason')
    returned_reason = String(description='The returned date and reason')
    study_charge_id = Integer(description='FK. Payment for the case')
    submitted = Boolean(description='The case is submitted')
    submitted_date = DateTime(description='The case is submitted')
    user_id = Integer(description='FK. The user the case is for')
    user = FK(model='User', description='The user the case is for')
    created = DateTime(description='Timestamp when the record was created')
    created_by = Integer(description='FK. ID of the user who created the record')
    created_by_obj = FK(model='User', description='ID of the user who created the record')
    updated = DateTime(description='Timestamp when the record was last updated')
    updated_by = Integer(description='FK. ID of the user who updated the record')
    updated_by_obj = FK(model='User', description='ID of the user who updated the record')


    def __init__(
        self,
	*,
        id=None,
        uuid=None,
        account_id=None,
        account=None,
        assigned_admin_date=None,
        assigned_admin_id=None,
        assigned_admin=None,
        assigned_medical_date=None,
        assigned_medical_id=None,
        assigned_medical=None,
        case_status=None,
        case_status_date=None,
        closed=None,
        closed_date=None,
        completed=None,
        completed_date=None,
        customfields=None,
        name=None,
        namespace_id=None,
        namespace=None,
        returned_date=None,
        returned_reason=None,
        study_charge_id=None,
        submitted=None,
        submitted_date=None,
        user_id=None,
        user=None,
        created=None,
        created_by=None,
        created_by_obj=None,
        updated=None,
        updated_by=None,
        updated_by_obj=None,
    ):
        self.id = id
        self.uuid = uuid
        self.account_id = account_id
        self.account = account
        self.assigned_admin_date = assigned_admin_date
        self.assigned_admin_id = assigned_admin_id
        self.assigned_admin = assigned_admin
        self.assigned_medical_date = assigned_medical_date
        self.assigned_medical_id = assigned_medical_id
        self.assigned_medical = assigned_medical
        self.case_status = case_status
        self.case_status_date = case_status_date
        self.closed = closed
        self.closed_date = closed_date
        self.completed = completed
        self.completed_date = completed_date
        self.customfields = customfields
        self.name = name
        self.namespace_id = namespace_id
        self.namespace = namespace
        self.returned_date = returned_date
        self.returned_reason = returned_reason
        self.study_charge_id = study_charge_id
        self.submitted = submitted
        self.submitted_date = submitted_date
        self.user_id = user_id
        self.user = user
        self.created = created
        self.created_by = created_by
        self.created_by_obj = created_by_obj
        self.updated = updated
        self.updated_by = updated_by
        self.updated_by_obj = updated_by_obj



class CaseStatusLock(BaseModel):
    """CaseStatusLock."""
    
    id = Integer(description='Primary key for internal use')
    uuid = String(description='UUID for external use')
    case_id = Integer(description='FK. The case and user id')
    case = FK(model='Case', description='The case and user id')
    user_id = Integer(description='FK. The case and user id')
    user = FK(model='User', description='The case and user id')
    created = DateTime(description='Timestamp when the record was created')
    created_by = Integer(description='FK. ID of the user who created the record')
    created_by_obj = FK(model='User', description='ID of the user who created the record')
    updated = DateTime(description='Timestamp when the record was last updated')
    updated_by = Integer(description='FK. ID of the user who updated the record')
    updated_by_obj = FK(model='User', description='ID of the user who updated the record')


    def __init__(
        self,
	*,
        id=None,
        uuid=None,
        case_id=None,
        case=None,
        user_id=None,
        user=None,
        created=None,
        created_by=None,
        created_by_obj=None,
        updated=None,
        updated_by=None,
        updated_by_obj=None,
    ):
        self.id = id
        self.uuid = uuid
        self.case_id = case_id
        self.case = case
        self.user_id = user_id
        self.user = user
        self.created = created
        self.created_by = created_by
        self.created_by_obj = created_by_obj
        self.updated = updated
        self.updated_by = updated_by
        self.updated_by_obj = updated_by_obj



class CaseStudy(BaseModel):
    """CaseStudy."""
    
    id = Integer(description='Primary key for internal use')
    uuid = String(description='UUID for external use')
    case_id = Integer(description='FK. ')
    case = FK(model='Case', description='')
    storage_namespace = Integer(description='FK. ')
    storage_namespace_obj = FK(model='Namespace', description='')
    study_uid = String(description='')
    created = DateTime(description='Timestamp when the record was created')
    created_by = Integer(description='FK. ID of the user who created the record')
    created_by_obj = FK(model='User', description='ID of the user who created the record')
    updated = DateTime(description='Timestamp when the record was last updated')
    updated_by = Integer(description='FK. ID of the user who updated the record')
    updated_by_obj = FK(model='User', description='ID of the user who updated the record')


    def __init__(
        self,
	*,
        id=None,
        uuid=None,
        case_id=None,
        case=None,
        storage_namespace=None,
        storage_namespace_obj=None,
        study_uid=None,
        created=None,
        created_by=None,
        created_by_obj=None,
        updated=None,
        updated_by=None,
        updated_by_obj=None,
    ):
        self.id = id
        self.uuid = uuid
        self.case_id = case_id
        self.case = case
        self.storage_namespace = storage_namespace
        self.storage_namespace_obj = storage_namespace_obj
        self.study_uid = study_uid
        self.created = created
        self.created_by = created_by
        self.created_by_obj = created_by_obj
        self.updated = updated
        self.updated_by = updated_by
        self.updated_by_obj = updated_by_obj



class Cluster(BaseModel):
    """Cluster."""
    
    id = Integer(description='Primary key for internal use')
    uuid = String(description='UUID for external use')
    archive = Boolean(description='Is this an archive cluster')
    archive_cluster_id = Integer(description='FK. Id of the archive cluster this should be backed up to')
    archive_cluster = FK(model='Archive', description='Id of the archive cluster this should be backed up to')
    backup_cluster_id = Integer(description='FK. Id of the backup cluster this should be backed up to')
    backup_cluster = FK(model='Archive', description='Id of the backup cluster this should be backed up to')
    copies = Integer(description='Number of copies in the cluster')
    is_default = Boolean(description='This is the default cluster')
    max_days = Integer(description='Max days studies should stay in the cluster')
    name = String(description='Name for the cluster')
    rsync = Boolean(description='Is this a rsync cluster')
    created = DateTime(description='Timestamp when the record was created')
    created_by = Integer(description='FK. ID of the user who created the record')
    created_by_obj = FK(model='User', description='ID of the user who created the record')
    updated = DateTime(description='Timestamp when the record was last updated')
    updated_by = Integer(description='FK. ID of the user who updated the record')
    updated_by_obj = FK(model='User', description='ID of the user who updated the record')


    def __init__(
        self,
	*,
        id=None,
        uuid=None,
        archive=None,
        archive_cluster_id=None,
        archive_cluster=None,
        backup_cluster_id=None,
        backup_cluster=None,
        copies=None,
        is_default=None,
        max_days=None,
        name=None,
        rsync=None,
        created=None,
        created_by=None,
        created_by_obj=None,
        updated=None,
        updated_by=None,
        updated_by_obj=None,
    ):
        self.id = id
        self.uuid = uuid
        self.archive = archive
        self.archive_cluster_id = archive_cluster_id
        self.archive_cluster = archive_cluster
        self.backup_cluster_id = backup_cluster_id
        self.backup_cluster = backup_cluster
        self.copies = copies
        self.is_default = is_default
        self.max_days = max_days
        self.name = name
        self.rsync = rsync
        self.created = created
        self.created_by = created_by
        self.created_by_obj = created_by_obj
        self.updated = updated
        self.updated_by = updated_by
        self.updated_by_obj = updated_by_obj



class ClusterAccount(BaseModel):
    """ClusterAccount."""
    
    id = Integer(description='Primary key for internal use')
    uuid = String(description='UUID for external use')
    account_id = Integer(description='FK. Id of the cluster and account')
    account = FK(model='Account', description='Id of the cluster and account')
    cluster_id = Integer(description='FK. Id of the cluster and account')
    cluster = FK(model='Cluster', description='Id of the cluster and account')
    created = DateTime(description='Timestamp when the record was created')
    created_by = Integer(description='FK. ID of the user who created the record')
    created_by_obj = FK(model='User', description='ID of the user who created the record')
    updated = DateTime(description='Timestamp when the record was last updated')
    updated_by = Integer(description='FK. ID of the user who updated the record')
    updated_by_obj = FK(model='User', description='ID of the user who updated the record')


    def __init__(
        self,
	*,
        id=None,
        uuid=None,
        account_id=None,
        account=None,
        cluster_id=None,
        cluster=None,
        created=None,
        created_by=None,
        created_by_obj=None,
        updated=None,
        updated_by=None,
        updated_by_obj=None,
    ):
        self.id = id
        self.uuid = uuid
        self.account_id = account_id
        self.account = account
        self.cluster_id = cluster_id
        self.cluster = cluster
        self.created = created
        self.created_by = created_by
        self.created_by_obj = created_by_obj
        self.updated = updated
        self.updated_by = updated_by
        self.updated_by_obj = updated_by_obj



class ClusterNamespace(BaseModel):
    """ClusterNamespace."""
    
    id = Integer(description='Primary key for internal use')
    uuid = String(description='UUID for external use')
    cluster_id = Integer(description='FK. Id of the cluster and account')
    cluster = FK(model='Cluster', description='Id of the cluster and account')
    namespace_id = Integer(description='FK. Id of the cluster and account')
    namespace = FK(model='Namespace', description='Id of the cluster and account')
    created = DateTime(description='Timestamp when the record was created')
    created_by = Integer(description='FK. ID of the user who created the record')
    created_by_obj = FK(model='User', description='ID of the user who created the record')
    updated = DateTime(description='Timestamp when the record was last updated')
    updated_by = Integer(description='FK. ID of the user who updated the record')
    updated_by_obj = FK(model='User', description='ID of the user who updated the record')


    def __init__(
        self,
	*,
        id=None,
        uuid=None,
        cluster_id=None,
        cluster=None,
        namespace_id=None,
        namespace=None,
        created=None,
        created_by=None,
        created_by_obj=None,
        updated=None,
        updated_by=None,
        updated_by_obj=None,
    ):
        self.id = id
        self.uuid = uuid
        self.cluster_id = cluster_id
        self.cluster = cluster
        self.namespace_id = namespace_id
        self.namespace = namespace
        self.created = created
        self.created_by = created_by
        self.created_by_obj = created_by_obj
        self.updated = updated
        self.updated_by = updated_by
        self.updated_by_obj = updated_by_obj



class Customcode(BaseModel):
    """Customcode."""
    
    id = Integer(description='Primary key for internal use')
    uuid = String(description='UUID for external use')
    account_id = Integer(description='FK. The account')
    account = FK(model='Account', description='The account')
    code = String(description='The code')
    has_zip = Boolean(description='Associated zip file')
    language = String(description='Type of code and the language')
    name = String(description='Basic information')
    settings = JsonB(description='The settings')
    type_field = String(description='Type of code and the language')
    zip = String(description='Associated zip file')
    created = DateTime(description='Timestamp when the record was created')
    created_by = Integer(description='FK. ID of the user who created the record')
    created_by_obj = FK(model='User', description='ID of the user who created the record')
    updated = DateTime(description='Timestamp when the record was last updated')
    updated_by = Integer(description='FK. ID of the user who updated the record')
    updated_by_obj = FK(model='User', description='ID of the user who updated the record')


    def __init__(
        self,
	*,
        id=None,
        uuid=None,
        account_id=None,
        account=None,
        code=None,
        has_zip=None,
        language=None,
        name=None,
        settings=None,
        type_field=None,
        zip=None,
        created=None,
        created_by=None,
        created_by_obj=None,
        updated=None,
        updated_by=None,
        updated_by_obj=None,
    ):
        self.id = id
        self.uuid = uuid
        self.account_id = account_id
        self.account = account
        self.code = code
        self.has_zip = has_zip
        self.language = language
        self.name = name
        self.settings = settings
        self.type_field = type_field
        self.zip = zip
        self.created = created
        self.created_by = created_by
        self.created_by_obj = created_by_obj
        self.updated = updated
        self.updated_by = updated_by
        self.updated_by_obj = updated_by_obj



class CustomcodeDeploy(BaseModel):
    """CustomcodeDeploy."""
    
    id = Integer(description='Primary key for internal use')
    uuid = String(description='UUID for external use')
    account_id = Integer(description='FK. Deployment information')
    account = FK(model='Account', description='Deployment information')
    customcode_id = Integer(description='FK. Deployment information')
    customcode = FK(model='Customcode', description='Deployment information')
    namespace_id = Integer(description='FK. Deployment information')
    namespace = FK(model='Namespace', description='Deployment information')
    created = DateTime(description='Timestamp when the record was created')
    created_by = Integer(description='FK. ID of the user who created the record')
    created_by_obj = FK(model='User', description='ID of the user who created the record')
    updated = DateTime(description='Timestamp when the record was last updated')
    updated_by = Integer(description='FK. ID of the user who updated the record')
    updated_by_obj = FK(model='User', description='ID of the user who updated the record')


    def __init__(
        self,
	*,
        id=None,
        uuid=None,
        account_id=None,
        account=None,
        customcode_id=None,
        customcode=None,
        namespace_id=None,
        namespace=None,
        created=None,
        created_by=None,
        created_by_obj=None,
        updated=None,
        updated_by=None,
        updated_by_obj=None,
    ):
        self.id = id
        self.uuid = uuid
        self.account_id = account_id
        self.account = account
        self.customcode_id = customcode_id
        self.customcode = customcode
        self.namespace_id = namespace_id
        self.namespace = namespace
        self.created = created
        self.created_by = created_by
        self.created_by_obj = created_by_obj
        self.updated = updated
        self.updated_by = updated_by
        self.updated_by_obj = updated_by_obj



class Customfield(BaseModel):
    """Customfield."""
    
    id = Integer(description='Primary key for internal use')
    uuid = String(description='UUID for external use')
    account_id = Integer(description='FK. Associated object and account')
    account = FK(model='Account', description='Associated object and account')
    capture_on_share_code = Boolean(description='Settings')
    dicom_tag = String(description='Map to this DICOM tag in storage')
    dicom_tag_ignore_empty = Boolean(description='Do not do the DICOM tag mapping if the field is empty')
    display_order = Integer(description='Order the fields should be displayed in')
    has_macro = Boolean(description='Flag if the values has a macro that needs expansion')
    hl7_component = Integer(description='HL7 options')
    hl7_field = Integer(description='HL7 options')
    hl7_segment = String(description='HL7 options')
    load_dicom_tag = Boolean(description='Load the DICOM tag from storage')
    load_from_sr = String(description='Load the value from the SR')
    load_hl7 = String(description='HL7 options')
    load_hl7_filter = String(description='HL7 options')
    name = String(description='Name and type  of the field')
    object = String(description='Associated object and account')
    options = String(description='Settings')
    other_dicom_tags = String(description='An array of other DICOM tags to map to in storage')
    required = Boolean(description='Settings')
    type_field = String(description='Name and type  of the field')
    wrapped_dicom_only = Boolean(description='Settings')
    created = DateTime(description='Timestamp when the record was created')
    created_by = Integer(description='FK. ID of the user who created the record')
    created_by_obj = FK(model='User', description='ID of the user who created the record')
    updated = DateTime(description='Timestamp when the record was last updated')
    updated_by = Integer(description='FK. ID of the user who updated the record')
    updated_by_obj = FK(model='User', description='ID of the user who updated the record')


    def __init__(
        self,
	*,
        id=None,
        uuid=None,
        account_id=None,
        account=None,
        capture_on_share_code=None,
        dicom_tag=None,
        dicom_tag_ignore_empty=None,
        display_order=None,
        has_macro=None,
        hl7_component=None,
        hl7_field=None,
        hl7_segment=None,
        load_dicom_tag=None,
        load_from_sr=None,
        load_hl7=None,
        load_hl7_filter=None,
        name=None,
        object=None,
        options=None,
        other_dicom_tags=None,
        required=None,
        type_field=None,
        wrapped_dicom_only=None,
        created=None,
        created_by=None,
        created_by_obj=None,
        updated=None,
        updated_by=None,
        updated_by_obj=None,
    ):
        self.id = id
        self.uuid = uuid
        self.account_id = account_id
        self.account = account
        self.capture_on_share_code = capture_on_share_code
        self.dicom_tag = dicom_tag
        self.dicom_tag_ignore_empty = dicom_tag_ignore_empty
        self.display_order = display_order
        self.has_macro = has_macro
        self.hl7_component = hl7_component
        self.hl7_field = hl7_field
        self.hl7_segment = hl7_segment
        self.load_dicom_tag = load_dicom_tag
        self.load_from_sr = load_from_sr
        self.load_hl7 = load_hl7
        self.load_hl7_filter = load_hl7_filter
        self.name = name
        self.object = object
        self.options = options
        self.other_dicom_tags = other_dicom_tags
        self.required = required
        self.type_field = type_field
        self.wrapped_dicom_only = wrapped_dicom_only
        self.created = created
        self.created_by = created_by
        self.created_by_obj = created_by_obj
        self.updated = updated
        self.updated_by = updated_by
        self.updated_by_obj = updated_by_obj



class DatabaseScripts(BaseModel):
    """DatabaseScripts."""
    
    id = Integer(description='Primary key for internal use')
    name = String(description='Name of the script that was run')
    created = DateTime(description='Timestamp when the record was created')
    created_by = Integer(description='FK. ID of the user who created the record')
    created_by_obj = FK(model='User', description='ID of the user who created the record')
    updated = DateTime(description='Timestamp when the record was last updated')
    updated_by = Integer(description='FK. ID of the user who updated the record')
    updated_by_obj = FK(model='User', description='ID of the user who updated the record')


    def __init__(
        self,
	*,
        id=None,
        name=None,
        created=None,
        created_by=None,
        created_by_obj=None,
        updated=None,
        updated_by=None,
        updated_by_obj=None,
    ):
        self.id = id
        self.name = name
        self.created = created
        self.created_by = created_by
        self.created_by_obj = created_by_obj
        self.updated = updated
        self.updated_by = updated_by
        self.updated_by_obj = updated_by_obj



class Destination(BaseModel):
    """Destination."""
    
    id = Integer(description='Primary key for internal use')
    uuid = String(description='UUID for external use')
    account_id = Integer(description='FK. The associated account')
    account = FK(model='Account', description='The associated account')
    address = String(description='DICOM Address and port of the destination')
    aetitle = String(description='AEtitle')
    c_echo_interval = Integer(description='Do a c echo of the destination every c_echo_interval seconds')
    c_echo_schedule = String(description='The c echo schedule')
    can_query_retrieve = Boolean(description='Flags for destination capabilities')
    can_retrieve_thin = Boolean(description='Flags for destination capabilities')
    can_search = Boolean(description='Flags for destination capabilities')
    can_search_mwl = Boolean(description='Flags for destination capabilities')
    cd_burn_info = String(description='The CD burner information')
    cd_burn_name = String(description='The CD burner information')
    cd_burn_priority = Integer(description='The CD burner information')
    default_query_retrieve_level = String(description='How the query retrieve should be done')
    fire_webhooks = Boolean(description='Fire webhooks for this destination')
    gateway_settings = String(description='Gateway stores settings and data here')
    hl7_address = String(description='HL7 ORM destination address and port')
    hl7_fetch_filter = String(description='Fetch filter')
    hl7_port = Integer(description='HL7 ORM destination address and port')
    linked_destination = Integer(description='FK. The id of the linked destination')
    linked_destination_obj = FK(model='Destination', description='The id of the linked destination')
    name = String(description='Name')
    node_id = Integer(description='FK. The associated node')
    node = FK(model='Node', description='The associated node')
    path = String(description='Path for a FOLDER destination')
    port = Integer(description='DICOM Address and port of the destination')
    push_related_studies = Boolean(description='Push all related studies in the namespace when a study is pushed')
    sort_order = Integer(description='Sort order')
    sqlch_psh_if_img_unchg = Boolean(description='Flag if destination should squelch re-pushes if the image count has not changed')
    sqlch_psh_if_route_hl7 = Boolean(description='Flag if destination should squelch pushes that are generated by HL7 based routing')
    type_field = String(description='Type of destination can be either a DICOM, FOLDER, ACCELERATOR or BURNER')
    created = DateTime(description='Timestamp when the record was created')
    created_by = Integer(description='FK. ID of the user who created the record')
    created_by_obj = FK(model='User', description='ID of the user who created the record')
    updated = DateTime(description='Timestamp when the record was last updated')
    updated_by = Integer(description='FK. ID of the user who updated the record')
    updated_by_obj = FK(model='User', description='ID of the user who updated the record')


    def __init__(
        self,
	*,
        id=None,
        uuid=None,
        account_id=None,
        account=None,
        address=None,
        aetitle=None,
        c_echo_interval=None,
        c_echo_schedule=None,
        can_query_retrieve=None,
        can_retrieve_thin=None,
        can_search=None,
        can_search_mwl=None,
        cd_burn_info=None,
        cd_burn_name=None,
        cd_burn_priority=None,
        default_query_retrieve_level=None,
        fire_webhooks=None,
        gateway_settings=None,
        hl7_address=None,
        hl7_fetch_filter=None,
        hl7_port=None,
        linked_destination=None,
        linked_destination_obj=None,
        name=None,
        node_id=None,
        node=None,
        path=None,
        port=None,
        push_related_studies=None,
        sort_order=None,
        sqlch_psh_if_img_unchg=None,
        sqlch_psh_if_route_hl7=None,
        type_field=None,
        created=None,
        created_by=None,
        created_by_obj=None,
        updated=None,
        updated_by=None,
        updated_by_obj=None,
    ):
        self.id = id
        self.uuid = uuid
        self.account_id = account_id
        self.account = account
        self.address = address
        self.aetitle = aetitle
        self.c_echo_interval = c_echo_interval
        self.c_echo_schedule = c_echo_schedule
        self.can_query_retrieve = can_query_retrieve
        self.can_retrieve_thin = can_retrieve_thin
        self.can_search = can_search
        self.can_search_mwl = can_search_mwl
        self.cd_burn_info = cd_burn_info
        self.cd_burn_name = cd_burn_name
        self.cd_burn_priority = cd_burn_priority
        self.default_query_retrieve_level = default_query_retrieve_level
        self.fire_webhooks = fire_webhooks
        self.gateway_settings = gateway_settings
        self.hl7_address = hl7_address
        self.hl7_fetch_filter = hl7_fetch_filter
        self.hl7_port = hl7_port
        self.linked_destination = linked_destination
        self.linked_destination_obj = linked_destination_obj
        self.name = name
        self.node_id = node_id
        self.node = node
        self.path = path
        self.port = port
        self.push_related_studies = push_related_studies
        self.sort_order = sort_order
        self.sqlch_psh_if_img_unchg = sqlch_psh_if_img_unchg
        self.sqlch_psh_if_route_hl7 = sqlch_psh_if_route_hl7
        self.type_field = type_field
        self.created = created
        self.created_by = created_by
        self.created_by_obj = created_by_obj
        self.updated = updated
        self.updated_by = updated_by
        self.updated_by_obj = updated_by_obj



class DestinationBurn(BaseModel):
    """DestinationBurn."""
    
    id = Integer(description='Primary key for internal use')
    uuid = String(description='UUID for external use')
    batch_no = String(description='Batch no')
    destination_id = Integer(description='FK. The destination')
    destination = FK(model='Destination', description='The destination')
    metrics = DictField(description='The metrics hash')
    node_id = Integer(description='FK. The node to use')
    node = FK(model='Node', description='The node to use')
    patientid = String(description='The patient id')
    pickup = DateTime(description='When was this picked up by the node')
    status = String(description='Status of the delivery')
    status_reason = String(description='Status of the delivery')
    study_h = DictField(description='The hash of studies to burn')
    created = DateTime(description='Timestamp when the record was created')
    created_by = Integer(description='FK. ID of the user who created the record')
    created_by_obj = FK(model='User', description='ID of the user who created the record')
    updated = DateTime(description='Timestamp when the record was last updated')
    updated_by = Integer(description='FK. ID of the user who updated the record')
    updated_by_obj = FK(model='User', description='ID of the user who updated the record')


    def __init__(
        self,
	*,
        id=None,
        uuid=None,
        batch_no=None,
        destination_id=None,
        destination=None,
        metrics=None,
        node_id=None,
        node=None,
        patientid=None,
        pickup=None,
        status=None,
        status_reason=None,
        study_h=None,
        created=None,
        created_by=None,
        created_by_obj=None,
        updated=None,
        updated_by=None,
        updated_by_obj=None,
    ):
        self.id = id
        self.uuid = uuid
        self.batch_no = batch_no
        self.destination_id = destination_id
        self.destination = destination
        self.metrics = metrics
        self.node_id = node_id
        self.node = node
        self.patientid = patientid
        self.pickup = pickup
        self.status = status
        self.status_reason = status_reason
        self.study_h = study_h
        self.created = created
        self.created_by = created_by
        self.created_by_obj = created_by_obj
        self.updated = updated
        self.updated_by = updated_by
        self.updated_by_obj = updated_by_obj



class DestinationSearch(BaseModel):
    """DestinationSearch."""
    
    id = Integer(description='Primary key for internal use')
    uuid = String(description='UUID for external use')
    asked_by = Integer(description='FK. This is the id of the destination search that requested the asking_node search')
    asked_by_obj = FK(model='User', description='This is the id of the destination search that requested the asking_node search')
    asking_node = Integer(description='FK. Pass the results of this back to this node')
    asking_node_obj = FK(model='Node', description='Pass the results of this back to this node')
    copy_to = Integer(description='FK. Namespace to copy any retrieved or thin studies into')
    copy_to_obj = FK(model='Namespace', description='Namespace to copy any retrieved or thin studies into')
    count = Integer(description='Status of the search')
    create_study = Integer(description='Number of studies or thin studies to create from the search rather than creating an activity')
    create_thin = Integer(description='Number of studies or thin studies to create from the search rather than creating an activity')
    destination_id = Integer(description='FK. The destination to search')
    destination = FK(model='Destination', description='The destination to search')
    extra = String(description='Extra data for speciality workflows like MPI')
    hl7_id = Integer(description='FK. The search was triggered by this HL7 message')
    hl7 = FK(model='Hl7', description='The search was triggered by this HL7 message')
    node_id = Integer(description='FK. The node to use')
    node = FK(model='Node', description='The node to use')
    payload = String(description='The search payload')
    pickup = DateTime(description='When was this picked up by the node')
    push_to = Integer(description='FK. Destination to push any retrieved studies to')
    push_to_obj = FK(model='Destination', description='Destination to push any retrieved studies to')
    results = String(description='The search results')
    status = String(description='Status of the search')
    study_id = Integer(description='FK. Study id if this is a MWL search')
    study = FK(model='Study', description='Study id if this is a MWL search')
    user_id = Integer(description='FK. The user who ran the search')
    user = FK(model='User', description='The user who ran the search')
    created = DateTime(description='Timestamp when the record was created')
    created_by = Integer(description='FK. ID of the user who created the record')
    created_by_obj = FK(model='User', description='ID of the user who created the record')
    updated = DateTime(description='Timestamp when the record was last updated')
    updated_by = Integer(description='FK. ID of the user who updated the record')
    updated_by_obj = FK(model='User', description='ID of the user who updated the record')


    def __init__(
        self,
	*,
        id=None,
        uuid=None,
        asked_by=None,
        asked_by_obj=None,
        asking_node=None,
        asking_node_obj=None,
        copy_to=None,
        copy_to_obj=None,
        count=None,
        create_study=None,
        create_thin=None,
        destination_id=None,
        destination=None,
        extra=None,
        hl7_id=None,
        hl7=None,
        node_id=None,
        node=None,
        payload=None,
        pickup=None,
        push_to=None,
        push_to_obj=None,
        results=None,
        status=None,
        study_id=None,
        study=None,
        user_id=None,
        user=None,
        created=None,
        created_by=None,
        created_by_obj=None,
        updated=None,
        updated_by=None,
        updated_by_obj=None,
    ):
        self.id = id
        self.uuid = uuid
        self.asked_by = asked_by
        self.asked_by_obj = asked_by_obj
        self.asking_node = asking_node
        self.asking_node_obj = asking_node_obj
        self.copy_to = copy_to
        self.copy_to_obj = copy_to_obj
        self.count = count
        self.create_study = create_study
        self.create_thin = create_thin
        self.destination_id = destination_id
        self.destination = destination
        self.extra = extra
        self.hl7_id = hl7_id
        self.hl7 = hl7
        self.node_id = node_id
        self.node = node
        self.payload = payload
        self.pickup = pickup
        self.push_to = push_to
        self.push_to_obj = push_to_obj
        self.results = results
        self.status = status
        self.study_id = study_id
        self.study = study
        self.user_id = user_id
        self.user = user
        self.created = created
        self.created_by = created_by
        self.created_by_obj = created_by_obj
        self.updated = updated
        self.updated_by = updated_by
        self.updated_by_obj = updated_by_obj



class Dicomdata(BaseModel):
    """Dicomdata."""
    
    id = Integer(description='Primary key for internal use')
    uuid = String(description='UUID for external use')
    customfields = DictField(description='Custom fields')
    dicom_tags = DictField(description='The tags as a hstore')
    instance_uid = String(description='The series and image identification')
    phi_namespace = Integer(description='FK. Associated study')
    phi_namespace_obj = FK(model='Namespace', description='Associated study')
    series_uid = String(description='The series and image identification')
    storage_namespace = Integer(description='FK. Associated study')
    storage_namespace_obj = FK(model='Namespace', description='Associated study')
    study_id = Integer(description='FK. Associated study')
    study = FK(model='Study', description='Associated study')
    study_uid = String(description='Associated study')
    created = DateTime(description='Timestamp when the record was created')
    created_by = Integer(description='FK. ID of the user who created the record')
    created_by_obj = FK(model='User', description='ID of the user who created the record')
    updated = DateTime(description='Timestamp when the record was last updated')
    updated_by = Integer(description='FK. ID of the user who updated the record')
    updated_by_obj = FK(model='User', description='ID of the user who updated the record')


    def __init__(
        self,
	*,
        id=None,
        uuid=None,
        customfields=None,
        dicom_tags=None,
        instance_uid=None,
        phi_namespace=None,
        phi_namespace_obj=None,
        series_uid=None,
        storage_namespace=None,
        storage_namespace_obj=None,
        study_id=None,
        study=None,
        study_uid=None,
        created=None,
        created_by=None,
        created_by_obj=None,
        updated=None,
        updated_by=None,
        updated_by_obj=None,
    ):
        self.id = id
        self.uuid = uuid
        self.customfields = customfields
        self.dicom_tags = dicom_tags
        self.instance_uid = instance_uid
        self.phi_namespace = phi_namespace
        self.phi_namespace_obj = phi_namespace_obj
        self.series_uid = series_uid
        self.storage_namespace = storage_namespace
        self.storage_namespace_obj = storage_namespace_obj
        self.study_id = study_id
        self.study = study
        self.study_uid = study_uid
        self.created = created
        self.created_by = created_by
        self.created_by_obj = created_by_obj
        self.updated = updated
        self.updated_by = updated_by
        self.updated_by_obj = updated_by_obj



class Dictionary(BaseModel):
    """Dictionary."""
    
    id = Integer(description='Primary key for internal use')
    uuid = String(description='UUID for external use')
    account_id = Integer(description='FK. Name and account')
    account = FK(model='Account', description='Name and account')
    case_sensitive = Boolean(description='Settings')
    lookup = String(description='JSON array of the fields names to lookup on')
    name = String(description='Name and account')
    object = String(description='Type of object the dictionary runs against')
    replace = String(description='JSON array of the fields names to replace')
    created = DateTime(description='Timestamp when the record was created')
    created_by = Integer(description='FK. ID of the user who created the record')
    created_by_obj = FK(model='User', description='ID of the user who created the record')
    updated = DateTime(description='Timestamp when the record was last updated')
    updated_by = Integer(description='FK. ID of the user who updated the record')
    updated_by_obj = FK(model='User', description='ID of the user who updated the record')


    def __init__(
        self,
	*,
        id=None,
        uuid=None,
        account_id=None,
        account=None,
        case_sensitive=None,
        lookup=None,
        name=None,
        object=None,
        replace=None,
        created=None,
        created_by=None,
        created_by_obj=None,
        updated=None,
        updated_by=None,
        updated_by_obj=None,
    ):
        self.id = id
        self.uuid = uuid
        self.account_id = account_id
        self.account = account
        self.case_sensitive = case_sensitive
        self.lookup = lookup
        self.name = name
        self.object = object
        self.replace = replace
        self.created = created
        self.created_by = created_by
        self.created_by_obj = created_by_obj
        self.updated = updated
        self.updated_by = updated_by
        self.updated_by_obj = updated_by_obj



class DictionaryAttach(BaseModel):
    """DictionaryAttach."""
    
    id = Integer(description='Primary key for internal use')
    uuid = String(description='UUID for external use')
    account_id = Integer(description='FK. The attachment is either to an account or a namespace')
    account = FK(model='Account', description='The attachment is either to an account or a namespace')
    add_if_no_match = Boolean(description='Options')
    approve_if_match = Boolean(description='Options')
    dictionary_id = Integer(description='FK. Associated dictionary')
    dictionary = FK(model='Dictionary', description='Associated dictionary')
    namespace_id = Integer(description='FK. The attachment is either to an account or a namespace')
    namespace = FK(model='Namespace', description='The attachment is either to an account or a namespace')
    sequence = Integer(description='The sequence to order by')
    skip_if_lookup_unchanged = Boolean(description='Options')
    skip_if_replace_has_value = Boolean(description='Options')
    created = DateTime(description='Timestamp when the record was created')
    created_by = Integer(description='FK. ID of the user who created the record')
    created_by_obj = FK(model='User', description='ID of the user who created the record')
    updated = DateTime(description='Timestamp when the record was last updated')
    updated_by = Integer(description='FK. ID of the user who updated the record')
    updated_by_obj = FK(model='User', description='ID of the user who updated the record')


    def __init__(
        self,
	*,
        id=None,
        uuid=None,
        account_id=None,
        account=None,
        add_if_no_match=None,
        approve_if_match=None,
        dictionary_id=None,
        dictionary=None,
        namespace_id=None,
        namespace=None,
        sequence=None,
        skip_if_lookup_unchanged=None,
        skip_if_replace_has_value=None,
        created=None,
        created_by=None,
        created_by_obj=None,
        updated=None,
        updated_by=None,
        updated_by_obj=None,
    ):
        self.id = id
        self.uuid = uuid
        self.account_id = account_id
        self.account = account
        self.add_if_no_match = add_if_no_match
        self.approve_if_match = approve_if_match
        self.dictionary_id = dictionary_id
        self.dictionary = dictionary
        self.namespace_id = namespace_id
        self.namespace = namespace
        self.sequence = sequence
        self.skip_if_lookup_unchanged = skip_if_lookup_unchanged
        self.skip_if_replace_has_value = skip_if_replace_has_value
        self.created = created
        self.created_by = created_by
        self.created_by_obj = created_by_obj
        self.updated = updated
        self.updated_by = updated_by
        self.updated_by_obj = updated_by_obj



class DictionaryEntry(BaseModel):
    """DictionaryEntry."""
    
    id = Integer(description='Primary key for internal use')
    uuid = String(description='UUID for external use')
    dictionary_id = Integer(description='FK. Associated dictionary')
    dictionary = FK(model='Dictionary', description='Associated dictionary')
    lookup = String(description='JSON array or regexp of the lookup value')
    md5 = String(description='MD5 of the record')
    regexp = Boolean(description='Is this a regexp')
    replace = String(description='JSON array of the replace values')
    created = DateTime(description='Timestamp when the record was created')
    created_by = Integer(description='FK. ID of the user who created the record')
    created_by_obj = FK(model='User', description='ID of the user who created the record')
    updated = DateTime(description='Timestamp when the record was last updated')
    updated_by = Integer(description='FK. ID of the user who updated the record')
    updated_by_obj = FK(model='User', description='ID of the user who updated the record')


    def __init__(
        self,
	*,
        id=None,
        uuid=None,
        dictionary_id=None,
        dictionary=None,
        lookup=None,
        md5=None,
        regexp=None,
        replace=None,
        created=None,
        created_by=None,
        created_by_obj=None,
        updated=None,
        updated_by=None,
        updated_by_obj=None,
    ):
        self.id = id
        self.uuid = uuid
        self.dictionary_id = dictionary_id
        self.dictionary = dictionary
        self.lookup = lookup
        self.md5 = md5
        self.regexp = regexp
        self.replace = replace
        self.created = created
        self.created_by = created_by
        self.created_by_obj = created_by_obj
        self.updated = updated
        self.updated_by = updated_by
        self.updated_by_obj = updated_by_obj



class Drchrono(BaseModel):
    """Drchrono."""
    
    id = Integer(description='Primary key for internal use')
    uuid = String(description='UUID for external use')
    account_id = Integer(description='FK. Associated account')
    account = FK(model='Account', description='Associated account')
    doctor = String(description='Doctor id on drchrono')
    refresh_token = String(description='Refresh token')
    user_id = Integer(description='FK. Associated user')
    user = FK(model='User', description='Associated user')
    created = DateTime(description='Timestamp when the record was created')
    created_by = Integer(description='FK. ID of the user who created the record')
    created_by_obj = FK(model='User', description='ID of the user who created the record')
    updated = DateTime(description='Timestamp when the record was last updated')
    updated_by = Integer(description='FK. ID of the user who updated the record')
    updated_by_obj = FK(model='User', description='ID of the user who updated the record')


    def __init__(
        self,
	*,
        id=None,
        uuid=None,
        account_id=None,
        account=None,
        doctor=None,
        refresh_token=None,
        user_id=None,
        user=None,
        created=None,
        created_by=None,
        created_by_obj=None,
        updated=None,
        updated_by=None,
        updated_by_obj=None,
    ):
        self.id = id
        self.uuid = uuid
        self.account_id = account_id
        self.account = account
        self.doctor = doctor
        self.refresh_token = refresh_token
        self.user_id = user_id
        self.user = user
        self.created = created
        self.created_by = created_by
        self.created_by_obj = created_by_obj
        self.updated = updated
        self.updated_by = updated_by
        self.updated_by_obj = updated_by_obj



class Engine(BaseModel):
    """Engine."""
    
    id = Integer(description='Primary key for internal use')
    uuid = String(description='UUID for external use')
    cluster_id = Integer(description='FK. The cluster it is in')
    cluster = FK(model='Cluster', description='The cluster it is in')
    fqdn = String(description='The fully qualified domain name of the storage engine')
    host_map = String(description='The host map JSON')
    idle_storage_host = String(description='The URL services should for archiving activity')
    is_full = Boolean(description='Flag if the engine is full or offline')
    is_offline = Boolean(description='Flag if the engine is full or offline')
    magic_sid = String(description='The magic sid for the storage engine')
    max_pull_jobs = Integer(description='The max number of pull jobs  to run on the engine at one time')
    max_push_jobs = Integer(description='The max number of push jobs to run on the engine at one time')
    no_phi = Boolean(description='No PHI is stored on this engine')
    no_purge = Boolean(description='Exclude studies on this engine from all purges')
    services_url = String(description='The URL services should use to access the storage engine')
    created = DateTime(description='Timestamp when the record was created')
    created_by = Integer(description='FK. ID of the user who created the record')
    created_by_obj = FK(model='User', description='ID of the user who created the record')
    updated = DateTime(description='Timestamp when the record was last updated')
    updated_by = Integer(description='FK. ID of the user who updated the record')
    updated_by_obj = FK(model='User', description='ID of the user who updated the record')


    def __init__(
        self,
	*,
        id=None,
        uuid=None,
        cluster_id=None,
        cluster=None,
        fqdn=None,
        host_map=None,
        idle_storage_host=None,
        is_full=None,
        is_offline=None,
        magic_sid=None,
        max_pull_jobs=None,
        max_push_jobs=None,
        no_phi=None,
        no_purge=None,
        services_url=None,
        created=None,
        created_by=None,
        created_by_obj=None,
        updated=None,
        updated_by=None,
        updated_by_obj=None,
    ):
        self.id = id
        self.uuid = uuid
        self.cluster_id = cluster_id
        self.cluster = cluster
        self.fqdn = fqdn
        self.host_map = host_map
        self.idle_storage_host = idle_storage_host
        self.is_full = is_full
        self.is_offline = is_offline
        self.magic_sid = magic_sid
        self.max_pull_jobs = max_pull_jobs
        self.max_push_jobs = max_push_jobs
        self.no_phi = no_phi
        self.no_purge = no_purge
        self.services_url = services_url
        self.created = created
        self.created_by = created_by
        self.created_by_obj = created_by_obj
        self.updated = updated
        self.updated_by = updated_by
        self.updated_by_obj = updated_by_obj



class Filter(BaseModel):
    """Filter."""
    
    id = Integer(description='Primary key for internal use')
    uuid = String(description='UUID for external use')
    account_id = Integer(description='FK. The associated account')
    account = FK(model='Account', description='The associated account')
    configuration = String(description='The configuration as a json structure')
    name = String(description='Name')
    type_field = String(description='The type of the filter')
    user_id = Integer(description='FK. The user')
    user = FK(model='User', description='The user')
    created = DateTime(description='Timestamp when the record was created')
    created_by = Integer(description='FK. ID of the user who created the record')
    created_by_obj = FK(model='User', description='ID of the user who created the record')
    updated = DateTime(description='Timestamp when the record was last updated')
    updated_by = Integer(description='FK. ID of the user who updated the record')
    updated_by_obj = FK(model='User', description='ID of the user who updated the record')


    def __init__(
        self,
	*,
        id=None,
        uuid=None,
        account_id=None,
        account=None,
        configuration=None,
        name=None,
        type_field=None,
        user_id=None,
        user=None,
        created=None,
        created_by=None,
        created_by_obj=None,
        updated=None,
        updated_by=None,
        updated_by_obj=None,
    ):
        self.id = id
        self.uuid = uuid
        self.account_id = account_id
        self.account = account
        self.configuration = configuration
        self.name = name
        self.type_field = type_field
        self.user_id = user_id
        self.user = user
        self.created = created
        self.created_by = created_by
        self.created_by_obj = created_by_obj
        self.updated = updated
        self.updated_by = updated_by
        self.updated_by_obj = updated_by_obj



class FilterShare(BaseModel):
    """FilterShare."""
    
    id = Integer(description='Primary key for internal use')
    account_id = Integer(description='FK. Who it is shared with')
    account = FK(model='Account', description='Who it is shared with')
    filter_id = Integer(description='FK. Primary key for internal use')
    filter = FK(model='Filter', description='Primary key for internal use')
    group_id = Integer(description='FK. Who it is shared with')
    group = FK(model='Group', description='Who it is shared with')
    location_id = Integer(description='FK. Who it is shared with')
    location = FK(model='Location', description='Who it is shared with')
    user_id = Integer(description='FK. Who it is shared with')
    user = FK(model='User', description='Who it is shared with')
    created = DateTime(description='Timestamp when the record was created')
    created_by = Integer(description='FK. ID of the user who created the record')
    created_by_obj = FK(model='User', description='ID of the user who created the record')
    updated = DateTime(description='Timestamp when the record was last updated')
    updated_by = Integer(description='FK. ID of the user who updated the record')
    updated_by_obj = FK(model='User', description='ID of the user who updated the record')


    def __init__(
        self,
	*,
        id=None,
        account_id=None,
        account=None,
        filter_id=None,
        filter=None,
        group_id=None,
        group=None,
        location_id=None,
        location=None,
        user_id=None,
        user=None,
        created=None,
        created_by=None,
        created_by_obj=None,
        updated=None,
        updated_by=None,
        updated_by_obj=None,
    ):
        self.id = id
        self.account_id = account_id
        self.account = account
        self.filter_id = filter_id
        self.filter = filter
        self.group_id = group_id
        self.group = group
        self.location_id = location_id
        self.location = location
        self.user_id = user_id
        self.user = user
        self.created = created
        self.created_by = created_by
        self.created_by_obj = created_by_obj
        self.updated = updated
        self.updated_by = updated_by
        self.updated_by_obj = updated_by_obj



class Group(BaseModel):
    """Group."""
    
    id = Integer(description='Primary key for internal use')
    uuid = String(description='UUID for external use')
    account_id = Integer(description='FK. The associated account')
    account = FK(model='Account', description='The associated account')
    customfields = DictField(description='Custom fields')
    name = String(description='Name')
    namespace_id = Integer(description='FK. The namespace')
    namespace = FK(model='Namespace', description='The namespace')
    role_id = Integer(description='FK. Default role id')
    role = FK(model='Role', description='Default role id')
    created = DateTime(description='Timestamp when the record was created')
    created_by = Integer(description='FK. ID of the user who created the record')
    created_by_obj = FK(model='User', description='ID of the user who created the record')
    updated = DateTime(description='Timestamp when the record was last updated')
    updated_by = Integer(description='FK. ID of the user who updated the record')
    updated_by_obj = FK(model='User', description='ID of the user who updated the record')


    def __init__(
        self,
	*,
        id=None,
        uuid=None,
        account_id=None,
        account=None,
        customfields=None,
        name=None,
        namespace_id=None,
        namespace=None,
        role_id=None,
        role=None,
        created=None,
        created_by=None,
        created_by_obj=None,
        updated=None,
        updated_by=None,
        updated_by_obj=None,
    ):
        self.id = id
        self.uuid = uuid
        self.account_id = account_id
        self.account = account
        self.customfields = customfields
        self.name = name
        self.namespace_id = namespace_id
        self.namespace = namespace
        self.role_id = role_id
        self.role = role
        self.created = created
        self.created_by = created_by
        self.created_by_obj = created_by_obj
        self.updated = updated
        self.updated_by = updated_by
        self.updated_by_obj = updated_by_obj



class Help(BaseModel):
    """Help."""
    
    id = Integer(description='Primary key for internal use')
    uuid = String(description='UUID for external use')
    key = String(description='Help key')
    text = String(description='The help text')
    created = DateTime(description='Timestamp when the record was created')
    created_by = Integer(description='FK. ID of the user who created the record')
    created_by_obj = FK(model='User', description='ID of the user who created the record')
    updated = DateTime(description='Timestamp when the record was last updated')
    updated_by = Integer(description='FK. ID of the user who updated the record')
    updated_by_obj = FK(model='User', description='ID of the user who updated the record')


    def __init__(
        self,
	*,
        id=None,
        uuid=None,
        key=None,
        text=None,
        created=None,
        created_by=None,
        created_by_obj=None,
        updated=None,
        updated_by=None,
        updated_by_obj=None,
    ):
        self.id = id
        self.uuid = uuid
        self.key = key
        self.text = text
        self.created = created
        self.created_by = created_by
        self.created_by_obj = created_by_obj
        self.updated = updated
        self.updated_by = updated_by
        self.updated_by_obj = updated_by_obj



class Hl7(BaseModel):
    """Hl7."""
    
    id = Integer(description='Primary key for internal use')
    uuid = String(description='UUID for external use')
    accession_number_h = DictField(description='KV storage of all the accession numbers in the message')
    account_id = Integer(description='FK. Account the message is for')
    account = FK(model='Account', description='Account the message is for')
    md5 = String(description='md5 hash of the message')
    message = String(description='The message data')
    node_id = Integer(description='FK. Node that sent the message')
    node = FK(model='Node', description='Node that sent the message')
    patient_name = String(description='Patient Name')
    patientid = String(description='Patient MRN')
    type_field = String(description='Type of message')
    created = DateTime(description='Timestamp when the record was created')
    created_by = Integer(description='FK. ID of the user who created the record')
    created_by_obj = FK(model='User', description='ID of the user who created the record')
    updated = DateTime(description='Timestamp when the record was last updated')
    updated_by = Integer(description='FK. ID of the user who updated the record')
    updated_by_obj = FK(model='User', description='ID of the user who updated the record')


    def __init__(
        self,
	*,
        id=None,
        uuid=None,
        accession_number_h=None,
        account_id=None,
        account=None,
        md5=None,
        message=None,
        node_id=None,
        node=None,
        patient_name=None,
        patientid=None,
        type_field=None,
        created=None,
        created_by=None,
        created_by_obj=None,
        updated=None,
        updated_by=None,
        updated_by_obj=None,
    ):
        self.id = id
        self.uuid = uuid
        self.accession_number_h = accession_number_h
        self.account_id = account_id
        self.account = account
        self.md5 = md5
        self.message = message
        self.node_id = node_id
        self.node = node
        self.patient_name = patient_name
        self.patientid = patientid
        self.type_field = type_field
        self.created = created
        self.created_by = created_by
        self.created_by_obj = created_by_obj
        self.updated = updated
        self.updated_by = updated_by
        self.updated_by_obj = updated_by_obj



class Hl7Accession(BaseModel):
    """Hl7Accession."""
    
    id = Integer(description='Primary key for internal use')
    accession_number = String(description='Accession number')
    account_id = Integer(description='FK. Account')
    account = FK(model='Account', description='Account')
    hl7_id = Integer(description='FK. Message')
    hl7 = FK(model='Hl7', description='Message')
    study_id = Integer(description='FK. Id of the study an order was associated with by the /study/find/order functionality')
    study = FK(model='Study', description='Id of the study an order was associated with by the /study/find/order functionality')
    type_field = String(description='Type of message')
    created = DateTime(description='Timestamp when the record was created')


    def __init__(
        self,
	*,
        id=None,
        accession_number=None,
        account_id=None,
        account=None,
        hl7_id=None,
        hl7=None,
        study_id=None,
        study=None,
        type_field=None,
        created=None,
    ):
        self.id = id
        self.accession_number = accession_number
        self.account_id = account_id
        self.account = account
        self.hl7_id = hl7_id
        self.hl7 = hl7
        self.study_id = study_id
        self.study = study
        self.type_field = type_field
        self.created = created



class Hl7Template(BaseModel):
    """Hl7Template."""
    
    id = Integer(description='Primary key for internal use')
    uuid = String(description='UUID for external use')
    account_id = Integer(description='FK. The associated account')
    account = FK(model='Account', description='The associated account')
    body = String(description='Type of message')
    name = String(description='Name')
    type_field = String(description='Type of message')
    created = DateTime(description='Timestamp when the record was created')
    created_by = Integer(description='FK. ID of the user who created the record')
    created_by_obj = FK(model='User', description='ID of the user who created the record')
    updated = DateTime(description='Timestamp when the record was last updated')
    updated_by = Integer(description='FK. ID of the user who updated the record')
    updated_by_obj = FK(model='User', description='ID of the user who updated the record')


    def __init__(
        self,
	*,
        id=None,
        uuid=None,
        account_id=None,
        account=None,
        body=None,
        name=None,
        type_field=None,
        created=None,
        created_by=None,
        created_by_obj=None,
        updated=None,
        updated_by=None,
        updated_by_obj=None,
    ):
        self.id = id
        self.uuid = uuid
        self.account_id = account_id
        self.account = account
        self.body = body
        self.name = name
        self.type_field = type_field
        self.created = created
        self.created_by = created_by
        self.created_by_obj = created_by_obj
        self.updated = updated
        self.updated_by = updated_by
        self.updated_by_obj = updated_by_obj



class Hl7Transform(BaseModel):
    """Hl7Transform."""
    
    id = Integer(description='Primary key for internal use')
    uuid = String(description='UUID for external use')
    account_id = Integer(description='FK. The associated account')
    account = FK(model='Account', description='The associated account')
    conditions = String(description='')
    name = String(description='Name')
    order_by = Integer(description='')
    replacements = String(description='')
    created = DateTime(description='Timestamp when the record was created')
    created_by = Integer(description='FK. ID of the user who created the record')
    created_by_obj = FK(model='User', description='ID of the user who created the record')
    updated = DateTime(description='Timestamp when the record was last updated')
    updated_by = Integer(description='FK. ID of the user who updated the record')
    updated_by_obj = FK(model='User', description='ID of the user who updated the record')


    def __init__(
        self,
	*,
        id=None,
        uuid=None,
        account_id=None,
        account=None,
        conditions=None,
        name=None,
        order_by=None,
        replacements=None,
        created=None,
        created_by=None,
        created_by_obj=None,
        updated=None,
        updated_by=None,
        updated_by_obj=None,
    ):
        self.id = id
        self.uuid = uuid
        self.account_id = account_id
        self.account = account
        self.conditions = conditions
        self.name = name
        self.order_by = order_by
        self.replacements = replacements
        self.created = created
        self.created_by = created_by
        self.created_by_obj = created_by_obj
        self.updated = updated
        self.updated_by = updated_by
        self.updated_by_obj = updated_by_obj



class Keyimage(BaseModel):
    """Keyimage."""
    
    id = Integer(description='Primary key for internal use')
    uuid = String(description='UUID for external use')
    frame_number = String(description='The frame identification')
    instance_uid = String(description='The frame identification')
    series_uid = String(description='The frame identification')
    study_id = Integer(description='FK. Associated study')
    study = FK(model='Study', description='Associated study')
    user_id = Integer(description='FK. User who created the annotation')
    user = FK(model='User', description='User who created the annotation')
    version = String(description='The frame identification')
    created = DateTime(description='Timestamp when the record was created')
    created_by = Integer(description='FK. ID of the user who created the record')
    created_by_obj = FK(model='User', description='ID of the user who created the record')
    updated = DateTime(description='Timestamp when the record was last updated')
    updated_by = Integer(description='FK. ID of the user who updated the record')
    updated_by_obj = FK(model='User', description='ID of the user who updated the record')


    def __init__(
        self,
	*,
        id=None,
        uuid=None,
        frame_number=None,
        instance_uid=None,
        series_uid=None,
        study_id=None,
        study=None,
        user_id=None,
        user=None,
        version=None,
        created=None,
        created_by=None,
        created_by_obj=None,
        updated=None,
        updated_by=None,
        updated_by_obj=None,
    ):
        self.id = id
        self.uuid = uuid
        self.frame_number = frame_number
        self.instance_uid = instance_uid
        self.series_uid = series_uid
        self.study_id = study_id
        self.study = study
        self.user_id = user_id
        self.user = user
        self.version = version
        self.created = created
        self.created_by = created_by
        self.created_by_obj = created_by_obj
        self.updated = updated
        self.updated_by = updated_by
        self.updated_by_obj = updated_by_obj



class Link(BaseModel):
    """Link."""
    
    id = Integer(description='Primary key for internal use')
    uuid = String(description='UUID for external use')
    acceptance_required = Boolean(description='Is acceptance of the study required')
    account_id = Integer(description='FK. The associated account')
    account = FK(model='Account', description='The associated account')
    action = String(description='Action to take on the link. This can either be view, list or upload')
    anonymize = String(description='Anonymization rules to be applied to studies uploaded via this link')
    charge_amount = Integer(description='Charge amount in pennies')
    charge_currency = String(description='Charge amount in pennies')
    charge_description = String(description='Charge amount in pennies')
    email = String(description='Email address, any additional message and other notification emails to send the link to')
    filter = String(description='The study the link is for or the filter expression or the namespace for an upload action')
    include_priors = Boolean(description='Include priors')
    max_hits = Integer(description='The maximum number of times the link can be used')
    message = String(description='Mobile phone used to send additional message to')
    minutes_alive = Integer(description='The number of minutes the link will be alive for')
    mobile_phone = String(description='Mobile phone used to send additional message to')
    namespace_id = Integer(description='FK. The study the link is for or the filter expression or the namespace for an upload action')
    namespace = FK(model='Namespace', description='The study the link is for or the filter expression or the namespace for an upload action')
    notify = String(description='Mobile phone used to send additional message to')
    parameters = String(description='Optional parameter to include on the link')
    password = String(description='Password to access link')
    password_is_dob = Boolean(description='The password is the study DOB')
    password_max_attempts = Integer(description='Max number of failed password attempts on the link')
    pin_auth = Boolean(description='The email must be an account member and PIN auth is required')
    prompt_for_anonymize = Boolean(description='Anonymization rules to be applied to studies uploaded via this link')
    referer = String(description='The referer for the link')
    share_code = String(description='Share code for the link')
    share_on_view = Boolean(description='Share the study after it is viewed')
    skip_email_prompt = Boolean(description='Skip ask for the email')
    study_id = Integer(description='FK. The study the link is for or the filter expression or the namespace for an upload action')
    study = FK(model='Study', description='The study the link is for or the filter expression or the namespace for an upload action')
    upload_match = String(description='Must match rules for uploads')
    use_share_code = Boolean(description='Use the namespace share code information for uploads')
    user_id = Integer(description='FK. The user who created the link. Any filter is applied in this users context as well')
    user = FK(model='User', description='The user who created the link. Any filter is applied in this users context as well')
    created = DateTime(description='Timestamp when the record was created')
    created_by = Integer(description='FK. ID of the user who created the record')
    created_by_obj = FK(model='User', description='ID of the user who created the record')
    updated = DateTime(description='Timestamp when the record was last updated')
    updated_by = Integer(description='FK. ID of the user who updated the record')
    updated_by_obj = FK(model='User', description='ID of the user who updated the record')


    def __init__(
        self,
	*,
        id=None,
        uuid=None,
        acceptance_required=None,
        account_id=None,
        account=None,
        action=None,
        anonymize=None,
        charge_amount=None,
        charge_currency=None,
        charge_description=None,
        email=None,
        filter=None,
        include_priors=None,
        max_hits=None,
        message=None,
        minutes_alive=None,
        mobile_phone=None,
        namespace_id=None,
        namespace=None,
        notify=None,
        parameters=None,
        password=None,
        password_is_dob=None,
        password_max_attempts=None,
        pin_auth=None,
        prompt_for_anonymize=None,
        referer=None,
        share_code=None,
        share_on_view=None,
        skip_email_prompt=None,
        study_id=None,
        study=None,
        upload_match=None,
        use_share_code=None,
        user_id=None,
        user=None,
        created=None,
        created_by=None,
        created_by_obj=None,
        updated=None,
        updated_by=None,
        updated_by_obj=None,
    ):
        self.id = id
        self.uuid = uuid
        self.acceptance_required = acceptance_required
        self.account_id = account_id
        self.account = account
        self.action = action
        self.anonymize = anonymize
        self.charge_amount = charge_amount
        self.charge_currency = charge_currency
        self.charge_description = charge_description
        self.email = email
        self.filter = filter
        self.include_priors = include_priors
        self.max_hits = max_hits
        self.message = message
        self.minutes_alive = minutes_alive
        self.mobile_phone = mobile_phone
        self.namespace_id = namespace_id
        self.namespace = namespace
        self.notify = notify
        self.parameters = parameters
        self.password = password
        self.password_is_dob = password_is_dob
        self.password_max_attempts = password_max_attempts
        self.pin_auth = pin_auth
        self.prompt_for_anonymize = prompt_for_anonymize
        self.referer = referer
        self.share_code = share_code
        self.share_on_view = share_on_view
        self.skip_email_prompt = skip_email_prompt
        self.study_id = study_id
        self.study = study
        self.upload_match = upload_match
        self.use_share_code = use_share_code
        self.user_id = user_id
        self.user = user
        self.created = created
        self.created_by = created_by
        self.created_by_obj = created_by_obj
        self.updated = updated
        self.updated_by = updated_by
        self.updated_by_obj = updated_by_obj



class LinkCharge(BaseModel):
    """LinkCharge."""
    
    id = Integer(description='Primary key for internal use')
    uuid = String(description='UUID for external use')
    account_id = Integer(description='FK. Link and account id')
    account = FK(model='Account', description='Link and account id')
    charge_amount = Integer(description='The charge amount')
    link_id = Integer(description='FK. Link and account id')
    link = FK(model='Link', description='Link and account id')
    processor = String(description='The processor information')
    created = DateTime(description='Timestamp when the record was created')
    created_by = Integer(description='FK. ID of the user who created the record')
    created_by_obj = FK(model='User', description='ID of the user who created the record')
    updated = DateTime(description='Timestamp when the record was last updated')
    updated_by = Integer(description='FK. ID of the user who updated the record')
    updated_by_obj = FK(model='User', description='ID of the user who updated the record')


    def __init__(
        self,
	*,
        id=None,
        uuid=None,
        account_id=None,
        account=None,
        charge_amount=None,
        link_id=None,
        link=None,
        processor=None,
        created=None,
        created_by=None,
        created_by_obj=None,
        updated=None,
        updated_by=None,
        updated_by_obj=None,
    ):
        self.id = id
        self.uuid = uuid
        self.account_id = account_id
        self.account = account
        self.charge_amount = charge_amount
        self.link_id = link_id
        self.link = link
        self.processor = processor
        self.created = created
        self.created_by = created_by
        self.created_by_obj = created_by_obj
        self.updated = updated
        self.updated_by = updated_by
        self.updated_by_obj = updated_by_obj



class LinkUsage(BaseModel):
    """LinkUsage."""
    
    id = Integer(description='Primary key for internal use')
    uuid = String(description='UUID for external use')
    account_id = Integer(description='FK. Link and account id')
    account = FK(model='Account', description='Link and account id')
    client_address = String(description='Address that used the link')
    client_email = String(description='Address that used the link')
    extra = String(description='Any extra analytical data to store with the link')
    link_id = Integer(description='FK. Link and account id')
    link = FK(model='Link', description='Link and account id')
    sid = String(description='Sid of the session')
    created = DateTime(description='Timestamp when the record was created')
    created_by = Integer(description='FK. ID of the user who created the record')
    created_by_obj = FK(model='User', description='ID of the user who created the record')
    updated = DateTime(description='Timestamp when the record was last updated')
    updated_by = Integer(description='FK. ID of the user who updated the record')
    updated_by_obj = FK(model='User', description='ID of the user who updated the record')


    def __init__(
        self,
	*,
        id=None,
        uuid=None,
        account_id=None,
        account=None,
        client_address=None,
        client_email=None,
        extra=None,
        link_id=None,
        link=None,
        sid=None,
        created=None,
        created_by=None,
        created_by_obj=None,
        updated=None,
        updated_by=None,
        updated_by_obj=None,
    ):
        self.id = id
        self.uuid = uuid
        self.account_id = account_id
        self.account = account
        self.client_address = client_address
        self.client_email = client_email
        self.extra = extra
        self.link_id = link_id
        self.link = link
        self.sid = sid
        self.created = created
        self.created_by = created_by
        self.created_by_obj = created_by_obj
        self.updated = updated
        self.updated_by = updated_by
        self.updated_by_obj = updated_by_obj



class Location(BaseModel):
    """Location."""
    
    id = Integer(description='Primary key for internal use')
    uuid = String(description='UUID for external use')
    account_id = Integer(description='FK. The associated account')
    account = FK(model='Account', description='The associated account')
    customfields = DictField(description='Custom fields')
    name = String(description='Name')
    namespace_id = Integer(description='FK. The namespace')
    namespace = FK(model='Namespace', description='The namespace')
    role_id = Integer(description='FK. Default role id')
    role = FK(model='Role', description='Default role id')
    created = DateTime(description='Timestamp when the record was created')
    created_by = Integer(description='FK. ID of the user who created the record')
    created_by_obj = FK(model='User', description='ID of the user who created the record')
    updated = DateTime(description='Timestamp when the record was last updated')
    updated_by = Integer(description='FK. ID of the user who updated the record')
    updated_by_obj = FK(model='User', description='ID of the user who updated the record')


    def __init__(
        self,
	*,
        id=None,
        uuid=None,
        account_id=None,
        account=None,
        customfields=None,
        name=None,
        namespace_id=None,
        namespace=None,
        role_id=None,
        role=None,
        created=None,
        created_by=None,
        created_by_obj=None,
        updated=None,
        updated_by=None,
        updated_by_obj=None,
    ):
        self.id = id
        self.uuid = uuid
        self.account_id = account_id
        self.account = account
        self.customfields = customfields
        self.name = name
        self.namespace_id = namespace_id
        self.namespace = namespace
        self.role_id = role_id
        self.role = role
        self.created = created
        self.created_by = created_by
        self.created_by_obj = created_by_obj
        self.updated = updated
        self.updated_by = updated_by
        self.updated_by_obj = updated_by_obj



class MailTemplate(BaseModel):
    """MailTemplate."""
    
    id = Integer(description='Primary key for internal use')
    uuid = String(description='UUID for external use')
    account_id = Integer(description='FK. Account the template is for')
    account = FK(model='Account', description='Account the template is for')
    bcc = String(description='Email addresses')
    cc = String(description='Email addresses')
    delay = Integer(description='Number of seconds to delay sending the mail for')
    filter_field = String(description='Filter field and regexp')
    filter_regexp = String(description='Filter field and regexp')
    from_email_address = String(description='Email addresses')
    from_email_name = String(description='Email addresses')
    html = String(description='Templates')
    namespace_id = Integer(description='FK. Scope it down to a namespace or vanity')
    namespace = FK(model='Namespace', description='Scope it down to a namespace or vanity')
    reply_to_email_address = String(description='Email addresses')
    sms = String(description='Templates')
    squelch_period = Integer(description='Number of seconds to squelch sending the mail for for a given template and a study')
    txt = String(description='Templates')
    type_field = String(description='Tmpl type')
    vanity = String(description='Scope it down to a namespace or vanity')
    created = DateTime(description='Timestamp when the record was created')
    created_by = Integer(description='FK. ID of the user who created the record')
    created_by_obj = FK(model='User', description='ID of the user who created the record')
    updated = DateTime(description='Timestamp when the record was last updated')
    updated_by = Integer(description='FK. ID of the user who updated the record')
    updated_by_obj = FK(model='User', description='ID of the user who updated the record')


    def __init__(
        self,
	*,
        id=None,
        uuid=None,
        account_id=None,
        account=None,
        bcc=None,
        cc=None,
        delay=None,
        filter_field=None,
        filter_regexp=None,
        from_email_address=None,
        from_email_name=None,
        html=None,
        namespace_id=None,
        namespace=None,
        reply_to_email_address=None,
        sms=None,
        squelch_period=None,
        txt=None,
        type_field=None,
        vanity=None,
        created=None,
        created_by=None,
        created_by_obj=None,
        updated=None,
        updated_by=None,
        updated_by_obj=None,
    ):
        self.id = id
        self.uuid = uuid
        self.account_id = account_id
        self.account = account
        self.bcc = bcc
        self.cc = cc
        self.delay = delay
        self.filter_field = filter_field
        self.filter_regexp = filter_regexp
        self.from_email_address = from_email_address
        self.from_email_name = from_email_name
        self.html = html
        self.namespace_id = namespace_id
        self.namespace = namespace
        self.reply_to_email_address = reply_to_email_address
        self.sms = sms
        self.squelch_period = squelch_period
        self.txt = txt
        self.type_field = type_field
        self.vanity = vanity
        self.created = created
        self.created_by = created_by
        self.created_by_obj = created_by_obj
        self.updated = updated
        self.updated_by = updated_by
        self.updated_by_obj = updated_by_obj



class Meeting(BaseModel):
    """Meeting."""
    
    id = Integer(description='Primary key for internal use')
    uuid = String(description='UUID for external use')
    link_id = Integer(description='FK. Associated link')
    link = FK(model='Link', description='Associated link')
    name = String(description='Name of the meeting')
    state = String(description='Current state data structure')
    study_id = Integer(description='FK. Associated study')
    study = FK(model='Study', description='Associated study')
    user_id = Integer(description='FK. User who created the meeting')
    user = FK(model='User', description='User who created the meeting')
    created = DateTime(description='Timestamp when the record was created')
    created_by = Integer(description='FK. ID of the user who created the record')
    created_by_obj = FK(model='User', description='ID of the user who created the record')
    updated = DateTime(description='Timestamp when the record was last updated')
    updated_by = Integer(description='FK. ID of the user who updated the record')
    updated_by_obj = FK(model='User', description='ID of the user who updated the record')


    def __init__(
        self,
	*,
        id=None,
        uuid=None,
        link_id=None,
        link=None,
        name=None,
        state=None,
        study_id=None,
        study=None,
        user_id=None,
        user=None,
        created=None,
        created_by=None,
        created_by_obj=None,
        updated=None,
        updated_by=None,
        updated_by_obj=None,
    ):
        self.id = id
        self.uuid = uuid
        self.link_id = link_id
        self.link = link
        self.name = name
        self.state = state
        self.study_id = study_id
        self.study = study
        self.user_id = user_id
        self.user = user
        self.created = created
        self.created_by = created_by
        self.created_by_obj = created_by_obj
        self.updated = updated
        self.updated_by = updated_by
        self.updated_by_obj = updated_by_obj



class MeetingUser(BaseModel):
    """MeetingUser."""
    
    id = Integer(description='Primary key for internal use')
    uuid = String(description='UUID for external use')
    meeting_id = Integer(description='FK. ')
    meeting = FK(model='Meeting', description='')
    user_id = Integer(description='FK. ')
    user = FK(model='User', description='')
    created = DateTime(description='Timestamp when the record was created')
    created_by = Integer(description='FK. ID of the user who created the record')
    created_by_obj = FK(model='User', description='ID of the user who created the record')
    updated = DateTime(description='Timestamp when the record was last updated')
    updated_by = Integer(description='FK. ID of the user who updated the record')
    updated_by_obj = FK(model='User', description='ID of the user who updated the record')


    def __init__(
        self,
	*,
        id=None,
        uuid=None,
        meeting_id=None,
        meeting=None,
        user_id=None,
        user=None,
        created=None,
        created_by=None,
        created_by_obj=None,
        updated=None,
        updated_by=None,
        updated_by_obj=None,
    ):
        self.id = id
        self.uuid = uuid
        self.meeting_id = meeting_id
        self.meeting = meeting
        self.user_id = user_id
        self.user = user
        self.created = created
        self.created_by = created_by
        self.created_by_obj = created_by_obj
        self.updated = updated
        self.updated_by = updated_by
        self.updated_by_obj = updated_by_obj



class Message(BaseModel):
    """Message."""
    
    id = Integer(description='Primary key for internal use')
    uuid = String(description='UUID for external use')
    body = String(description='Body of the message')
    namespace_id = Integer(description='FK. The namespace the message is for')
    namespace = FK(model='Namespace', description='The namespace the message is for')
    parent_id = Integer(description='FK. The parent message')
    parent = FK(model='Message', description='The parent message')
    study_id = Integer(description='FK. The study the message is for')
    study = FK(model='Study', description='The study the message is for')
    subject = String(description='Subject')
    user_id = Integer(description='FK. The user who sent the message')
    user = FK(model='User', description='The user who sent the message')
    created = DateTime(description='Timestamp when the record was created')
    created_by = Integer(description='FK. ID of the user who created the record')
    created_by_obj = FK(model='User', description='ID of the user who created the record')
    updated = DateTime(description='Timestamp when the record was last updated')
    updated_by = Integer(description='FK. ID of the user who updated the record')
    updated_by_obj = FK(model='User', description='ID of the user who updated the record')


    def __init__(
        self,
	*,
        id=None,
        uuid=None,
        body=None,
        namespace_id=None,
        namespace=None,
        parent_id=None,
        parent=None,
        study_id=None,
        study=None,
        subject=None,
        user_id=None,
        user=None,
        created=None,
        created_by=None,
        created_by_obj=None,
        updated=None,
        updated_by=None,
        updated_by_obj=None,
    ):
        self.id = id
        self.uuid = uuid
        self.body = body
        self.namespace_id = namespace_id
        self.namespace = namespace
        self.parent_id = parent_id
        self.parent = parent
        self.study_id = study_id
        self.study = study
        self.subject = subject
        self.user_id = user_id
        self.user = user
        self.created = created
        self.created_by = created_by
        self.created_by_obj = created_by_obj
        self.updated = updated
        self.updated_by = updated_by
        self.updated_by_obj = updated_by_obj



class Namespace(BaseModel):
    """Namespace."""
    
    id = Integer(description='Primary key for internal use')
    uuid = String(description='UUID for external use')
    account_id = Integer(description='FK. Who it is linked to')
    account = FK(model='Account', description='Who it is linked to')
    anonymize = String(description='Anonymization rules')
    archive = Integer(description='Archive setting. 0 = no archive or else archive and restore based on the priority value of the setting. e.g. 99 is high priority, -99 is low priority')
    cache = Boolean(description='Cache new studies image')
    case_pricing = String(description='Charging information')
    charge_description = String(description='Charging information')
    coverpage = String(description='Cover page template')
    currency = String(description='Charging information')
    event_approve = Boolean(description='The default event settings flags')
    event_case_assignment = Boolean(description='The default event settings flags')
    event_harvest = Boolean(description='The default event settings flags')
    event_link = Boolean(description='The default event settings flags')
    event_link_mine = Boolean(description='The default event settings flags')
    event_message = Boolean(description='The default event settings flags')
    event_new_report = Boolean(description='The default event settings flags')
    event_node = Boolean(description='The default event settings flags')
    event_report_remove = Boolean(description='The default event settings flags')
    event_share = Boolean(description='The default event settings flags')
    event_status_change = Boolean(description='The default event settings flags')
    event_study_comment = Boolean(description='The default event settings flags')
    event_thin_study_fail = Boolean(description='The default event settings flags')
    event_thin_study_success = Boolean(description='The default event settings flags')
    event_upload = Boolean(description='The default event settings flags')
    event_upload_fail = Boolean(description='The default event settings flags')
    group_id = Integer(description='FK. Who it is linked to')
    group = FK(model='Group', description='Who it is linked to')
    harvest_hold = Integer(description='Storage settings')
    hl7_template = String(description='HL7 template for the namespace')
    linkage_name = String(description='Name of the linked object for sorting purposes')
    location_id = Integer(description='FK. Who it is linked to')
    location = FK(model='Location', description='Who it is linked to')
    must_approve = Boolean(description='Flag if study approval for a share is needed')
    must_approve_harvest = Boolean(description='Flag if study approval for a harvest is needed')
    must_approve_upload = Boolean(description='Flag if study approval for a upload is needed')
    no_bill = Boolean(description='Do not bill this namespace')
    no_cluster_archive = Boolean(description='Storage settings')
    no_share = Boolean(description='Flag if this namespace can not be shared into')
    prompt_for_anonymize = Boolean(description='Anonymization rules')
    search_threshold = Integer(description='The UI search threshold')
    second_opinion_config = String(description='Second opinion settings')
    second_opinion_share = Boolean(description='Second opinion settings')
    settings = DictField(description='Namespace settings')
    share_code = String(description='Share code for the name space')
    share_description = String(description='Share code for the name space')
    share_pricing = String(description='Charging information')
    share_settings = String(description='Share code for the name space')
    share_via_gateway = Boolean(description='Allow gateway uploads to the share code')
    study_defaults = String(description='Study defaults')
    sum_case_price_matches = Boolean(description='Charging information')
    upload_hold = Integer(description='Storage settings')
    user_id = Integer(description='FK. Who it is linked to')
    user = FK(model='User', description='Who it is linked to')
    created = DateTime(description='Timestamp when the record was created')
    created_by = Integer(description='FK. ID of the user who created the record')
    created_by_obj = FK(model='User', description='ID of the user who created the record')
    updated = DateTime(description='Timestamp when the record was last updated')
    updated_by = Integer(description='FK. ID of the user who updated the record')
    updated_by_obj = FK(model='User', description='ID of the user who updated the record')


    def __init__(
        self,
	*,
        id=None,
        uuid=None,
        account_id=None,
        account=None,
        anonymize=None,
        archive=None,
        cache=None,
        case_pricing=None,
        charge_description=None,
        coverpage=None,
        currency=None,
        event_approve=None,
        event_case_assignment=None,
        event_harvest=None,
        event_link=None,
        event_link_mine=None,
        event_message=None,
        event_new_report=None,
        event_node=None,
        event_report_remove=None,
        event_share=None,
        event_status_change=None,
        event_study_comment=None,
        event_thin_study_fail=None,
        event_thin_study_success=None,
        event_upload=None,
        event_upload_fail=None,
        group_id=None,
        group=None,
        harvest_hold=None,
        hl7_template=None,
        linkage_name=None,
        location_id=None,
        location=None,
        must_approve=None,
        must_approve_harvest=None,
        must_approve_upload=None,
        no_bill=None,
        no_cluster_archive=None,
        no_share=None,
        prompt_for_anonymize=None,
        search_threshold=None,
        second_opinion_config=None,
        second_opinion_share=None,
        settings=None,
        share_code=None,
        share_description=None,
        share_pricing=None,
        share_settings=None,
        share_via_gateway=None,
        study_defaults=None,
        sum_case_price_matches=None,
        upload_hold=None,
        user_id=None,
        user=None,
        created=None,
        created_by=None,
        created_by_obj=None,
        updated=None,
        updated_by=None,
        updated_by_obj=None,
    ):
        self.id = id
        self.uuid = uuid
        self.account_id = account_id
        self.account = account
        self.anonymize = anonymize
        self.archive = archive
        self.cache = cache
        self.case_pricing = case_pricing
        self.charge_description = charge_description
        self.coverpage = coverpage
        self.currency = currency
        self.event_approve = event_approve
        self.event_case_assignment = event_case_assignment
        self.event_harvest = event_harvest
        self.event_link = event_link
        self.event_link_mine = event_link_mine
        self.event_message = event_message
        self.event_new_report = event_new_report
        self.event_node = event_node
        self.event_report_remove = event_report_remove
        self.event_share = event_share
        self.event_status_change = event_status_change
        self.event_study_comment = event_study_comment
        self.event_thin_study_fail = event_thin_study_fail
        self.event_thin_study_success = event_thin_study_success
        self.event_upload = event_upload
        self.event_upload_fail = event_upload_fail
        self.group_id = group_id
        self.group = group
        self.harvest_hold = harvest_hold
        self.hl7_template = hl7_template
        self.linkage_name = linkage_name
        self.location_id = location_id
        self.location = location
        self.must_approve = must_approve
        self.must_approve_harvest = must_approve_harvest
        self.must_approve_upload = must_approve_upload
        self.no_bill = no_bill
        self.no_cluster_archive = no_cluster_archive
        self.no_share = no_share
        self.prompt_for_anonymize = prompt_for_anonymize
        self.search_threshold = search_threshold
        self.second_opinion_config = second_opinion_config
        self.second_opinion_share = second_opinion_share
        self.settings = settings
        self.share_code = share_code
        self.share_description = share_description
        self.share_pricing = share_pricing
        self.share_settings = share_settings
        self.share_via_gateway = share_via_gateway
        self.study_defaults = study_defaults
        self.sum_case_price_matches = sum_case_price_matches
        self.upload_hold = upload_hold
        self.user_id = user_id
        self.user = user
        self.created = created
        self.created_by = created_by
        self.created_by_obj = created_by_obj
        self.updated = updated
        self.updated_by = updated_by
        self.updated_by_obj = updated_by_obj



class NamespaceChildren(BaseModel):
    """NamespaceChildren."""
    
    id = Integer(description='Primary key for internal use')
    uuid = String(description='UUID for external use')
    account_id = Integer(description='FK. Account the namespaces are in')
    account = FK(model='Account', description='Account the namespaces are in')
    child_id = Integer(description='FK. Child namespace')
    child = FK(model='SelfField', description='Child namespace')
    fields = String(description='JSON list of the fields')
    namespace_id = Integer(description='FK. Parent namespace')
    namespace = FK(model='Namespace', description='Parent namespace')
    created = DateTime(description='Timestamp when the record was created')
    created_by = Integer(description='FK. ID of the user who created the record')
    created_by_obj = FK(model='User', description='ID of the user who created the record')
    updated = DateTime(description='Timestamp when the record was last updated')
    updated_by = Integer(description='FK. ID of the user who updated the record')
    updated_by_obj = FK(model='User', description='ID of the user who updated the record')


    def __init__(
        self,
	*,
        id=None,
        uuid=None,
        account_id=None,
        account=None,
        child_id=None,
        child=None,
        fields=None,
        namespace_id=None,
        namespace=None,
        created=None,
        created_by=None,
        created_by_obj=None,
        updated=None,
        updated_by=None,
        updated_by_obj=None,
    ):
        self.id = id
        self.uuid = uuid
        self.account_id = account_id
        self.account = account
        self.child_id = child_id
        self.child = child
        self.fields = fields
        self.namespace_id = namespace_id
        self.namespace = namespace
        self.created = created
        self.created_by = created_by
        self.created_by_obj = created_by_obj
        self.updated = updated
        self.updated_by = updated_by
        self.updated_by_obj = updated_by_obj



class Node(BaseModel):
    """Node."""
    
    id = Integer(description='Primary key for internal use')
    uuid = String(description='UUID for external use')
    accelerator_id = Integer(description='FK. The associated accelerator')
    accelerator = FK(model='Accelerator', description='The associated accelerator')
    account_id = Integer(description='FK. The associated account')
    account = FK(model='Account', description='The associated account')
    category = String(description='Category and searchability')
    configuration_h = DictField(description='The configuration hash')
    ctc_bucket = String(description='Category and searchability')
    facility_contact = String(description='Facility information')
    facility_contact_title = String(description='Facility information')
    facility_email = String(description='Facility information')
    facility_name = String(description='Facility information')
    facility_notes = String(description='Facility information')
    facility_state = String(description='Facility information')
    facility_zip = String(description='Facility information')
    is_public = Boolean(description='Category and searchability')
    monitor_email = String(description='Monitoring flags')
    monitor_node_last_send = Boolean(description='Monitoring flags')
    monitor_node_last_send_threshold = Integer(description='Number of minutes as the threshold for firing the notification')
    monitor_node_ping = Boolean(description='Monitoring flags')
    monitor_node_slow_push = Boolean(description='Monitoring flags')
    monitor_node_slow_push_threshold = Integer(description='Number of minutes as the threshold for firing the notification')
    monitor_study_create = Boolean(description='Monitoring flags')
    monitor_study_create_threshold = Integer(description='Number of minutes as the threshold for firing the notification')
    name = String(description='Name')
    namespace_id = Integer(description='FK. The associated namespace')
    namespace = FK(model='Namespace', description='The associated namespace')
    reload_configuration = Boolean(description='Reload configuration')
    serial_no = String(description='The serial number')
    settings = DictField(description='Account settings overrides')
    type_field = String(description='The type of the node')
    user_id = Integer(description='FK. The user to generate a node sid for')
    user = FK(model='User', description='The user to generate a node sid for')
    created = DateTime(description='Timestamp when the record was created')
    created_by = Integer(description='FK. ID of the user who created the record')
    created_by_obj = FK(model='User', description='ID of the user who created the record')
    updated = DateTime(description='Timestamp when the record was last updated')
    updated_by = Integer(description='FK. ID of the user who updated the record')
    updated_by_obj = FK(model='User', description='ID of the user who updated the record')


    def __init__(
        self,
	*,
        id=None,
        uuid=None,
        accelerator_id=None,
        accelerator=None,
        account_id=None,
        account=None,
        category=None,
        configuration_h=None,
        ctc_bucket=None,
        facility_contact=None,
        facility_contact_title=None,
        facility_email=None,
        facility_name=None,
        facility_notes=None,
        facility_state=None,
        facility_zip=None,
        is_public=None,
        monitor_email=None,
        monitor_node_last_send=None,
        monitor_node_last_send_threshold=None,
        monitor_node_ping=None,
        monitor_node_slow_push=None,
        monitor_node_slow_push_threshold=None,
        monitor_study_create=None,
        monitor_study_create_threshold=None,
        name=None,
        namespace_id=None,
        namespace=None,
        reload_configuration=None,
        serial_no=None,
        settings=None,
        type_field=None,
        user_id=None,
        user=None,
        created=None,
        created_by=None,
        created_by_obj=None,
        updated=None,
        updated_by=None,
        updated_by_obj=None,
    ):
        self.id = id
        self.uuid = uuid
        self.accelerator_id = accelerator_id
        self.accelerator = accelerator
        self.account_id = account_id
        self.account = account
        self.category = category
        self.configuration_h = configuration_h
        self.ctc_bucket = ctc_bucket
        self.facility_contact = facility_contact
        self.facility_contact_title = facility_contact_title
        self.facility_email = facility_email
        self.facility_name = facility_name
        self.facility_notes = facility_notes
        self.facility_state = facility_state
        self.facility_zip = facility_zip
        self.is_public = is_public
        self.monitor_email = monitor_email
        self.monitor_node_last_send = monitor_node_last_send
        self.monitor_node_last_send_threshold = monitor_node_last_send_threshold
        self.monitor_node_ping = monitor_node_ping
        self.monitor_node_slow_push = monitor_node_slow_push
        self.monitor_node_slow_push_threshold = monitor_node_slow_push_threshold
        self.monitor_study_create = monitor_study_create
        self.monitor_study_create_threshold = monitor_study_create_threshold
        self.name = name
        self.namespace_id = namespace_id
        self.namespace = namespace
        self.reload_configuration = reload_configuration
        self.serial_no = serial_no
        self.settings = settings
        self.type_field = type_field
        self.user_id = user_id
        self.user = user
        self.created = created
        self.created_by = created_by
        self.created_by_obj = created_by_obj
        self.updated = updated
        self.updated_by = updated_by
        self.updated_by_obj = updated_by_obj



class NodeConnect(BaseModel):
    """NodeConnect."""
    
    id = Integer(description='Primary key for internal use')
    uuid = String(description='UUID for external use')
    connected = Boolean(description='Status')
    from_account_id = Integer(description='FK. Node information')
    from_account = FK(model='Account', description='Node information')
    message = String(description='Message')
    node_id = Integer(description='FK. Node information')
    node = FK(model='Node', description='Node information')
    to_account_id = Integer(description='FK. Node information')
    to_account = FK(model='Account', description='Node information')
    user_id = Integer(description='FK. Node information')
    user = FK(model='User', description='Node information')
    created = DateTime(description='Timestamp when the record was created')
    created_by = Integer(description='FK. ID of the user who created the record')
    created_by_obj = FK(model='User', description='ID of the user who created the record')


    def __init__(
        self,
	*,
        id=None,
        uuid=None,
        connected=None,
        from_account_id=None,
        from_account=None,
        message=None,
        node_id=None,
        node=None,
        to_account_id=None,
        to_account=None,
        user_id=None,
        user=None,
        created=None,
        created_by=None,
        created_by_obj=None,
    ):
        self.id = id
        self.uuid = uuid
        self.connected = connected
        self.from_account_id = from_account_id
        self.from_account = from_account
        self.message = message
        self.node_id = node_id
        self.node = node
        self.to_account_id = to_account_id
        self.to_account = to_account
        self.user_id = user_id
        self.user = user
        self.created = created
        self.created_by = created_by
        self.created_by_obj = created_by_obj



class NodeEvent(BaseModel):
    """NodeEvent."""
    
    id = Integer(description='Primary key for internal use')
    uuid = String(description='UUID for external use')
    count = Integer(description='Count of the number of times this event was fired. The audit table will have detail on the individual events.')
    destination_id = Integer(description='FK. The event parameters')
    destination = FK(model='Destination', description='The event parameters')
    event = String(description='The event parameters')
    node_id = Integer(description='FK. The event parameters')
    node = FK(model='Node', description='The event parameters')
    created = DateTime(description='Timestamp when the record was created')
    created_by = Integer(description='FK. ID of the user who created the record')
    created_by_obj = FK(model='User', description='ID of the user who created the record')
    updated = DateTime(description='Timestamp when the record was last updated')
    updated_by = Integer(description='FK. ID of the user who updated the record')
    updated_by_obj = FK(model='User', description='ID of the user who updated the record')


    def __init__(
        self,
	*,
        id=None,
        uuid=None,
        count=None,
        destination_id=None,
        destination=None,
        event=None,
        node_id=None,
        node=None,
        created=None,
        created_by=None,
        created_by_obj=None,
        updated=None,
        updated_by=None,
        updated_by_obj=None,
    ):
        self.id = id
        self.uuid = uuid
        self.count = count
        self.destination_id = destination_id
        self.destination = destination
        self.event = event
        self.node_id = node_id
        self.node = node
        self.created = created
        self.created_by = created_by
        self.created_by_obj = created_by_obj
        self.updated = updated
        self.updated_by = updated_by
        self.updated_by_obj = updated_by_obj



class NodeProgress(BaseModel):
    """NodeProgress."""
    
    id = Integer(description='Primary key for internal use')
    uuid = String(description='UUID for external use')
    accession_number = String(description='Study information')
    destination_id = Integer(description='FK. Node information')
    destination = FK(model='Destination', description='Node information')
    detail = String(description='Description of the progress')
    node_id = Integer(description='FK. Node information')
    node = FK(model='Node', description='Node information')
    patientid = String(description='Study information')
    queue = String(description='Queue information')
    state = String(description='Queue information')
    study_uid = String(description='Study information')
    created = DateTime(description='Timestamp when the record was created')
    created_by = Integer(description='FK. ID of the user who created the record')
    created_by_obj = FK(model='User', description='ID of the user who created the record')


    def __init__(
        self,
	*,
        id=None,
        uuid=None,
        accession_number=None,
        destination_id=None,
        destination=None,
        detail=None,
        node_id=None,
        node=None,
        patientid=None,
        queue=None,
        state=None,
        study_uid=None,
        created=None,
        created_by=None,
        created_by_obj=None,
    ):
        self.id = id
        self.uuid = uuid
        self.accession_number = accession_number
        self.destination_id = destination_id
        self.destination = destination
        self.detail = detail
        self.node_id = node_id
        self.node = node
        self.patientid = patientid
        self.queue = queue
        self.state = state
        self.study_uid = study_uid
        self.created = created
        self.created_by = created_by
        self.created_by_obj = created_by_obj



class NpiInviteShare(BaseModel):
    """NpiInviteShare."""
    
    id = Integer(description='Primary key for internal use')
    uuid = String(description='UUID for external use')
    done = Boolean(description='Flag if the share was done')
    message = String(description='Share message')
    npi = String(description='NPI to invite')
    study_id = Integer(description='FK. Id for the study to be shared')
    study = FK(model='Study', description='Id for the study to be shared')
    user_id = Integer(description='FK. Id the invitation is from')
    user = FK(model='User', description='Id the invitation is from')
    created = DateTime(description='Timestamp when the record was created')
    created_by = Integer(description='FK. ID of the user who created the record')
    created_by_obj = FK(model='User', description='ID of the user who created the record')
    updated = DateTime(description='Timestamp when the record was last updated')
    updated_by = Integer(description='FK. ID of the user who updated the record')
    updated_by_obj = FK(model='User', description='ID of the user who updated the record')


    def __init__(
        self,
	*,
        id=None,
        uuid=None,
        done=None,
        message=None,
        npi=None,
        study_id=None,
        study=None,
        user_id=None,
        user=None,
        created=None,
        created_by=None,
        created_by_obj=None,
        updated=None,
        updated_by=None,
        updated_by_obj=None,
    ):
        self.id = id
        self.uuid = uuid
        self.done = done
        self.message = message
        self.npi = npi
        self.study_id = study_id
        self.study = study
        self.user_id = user_id
        self.user = user
        self.created = created
        self.created_by = created_by
        self.created_by_obj = created_by_obj
        self.updated = updated
        self.updated_by = updated_by
        self.updated_by_obj = updated_by_obj



class Order(BaseModel):
    """Order."""
    
    id = Integer(description='Primary key for internal use')
    uuid = String(description='UUID for external use')
    accession_number = String(description='Basic information')
    account_id = Integer(description='FK. The associated account')
    account = FK(model='Account', description='The associated account')
    customfields = DictField(description='Custom fields')
    order_number = String(description='Basic information')
    patient_birth_date = String(description='Basic information')
    patient_name = String(description='Basic information')
    patient_sex = String(description='Basic information')
    patientid = String(description='Basic information')
    referring_physician = String(description='Basic information')
    sending_facility = String(description='Basic information')
    study_uid = String(description='The study uid')
    created = DateTime(description='Timestamp when the record was created')
    created_by = Integer(description='FK. ID of the user who created the record')
    created_by_obj = FK(model='User', description='ID of the user who created the record')
    updated = DateTime(description='Timestamp when the record was last updated')
    updated_by = Integer(description='FK. ID of the user who updated the record')
    updated_by_obj = FK(model='User', description='ID of the user who updated the record')


    def __init__(
        self,
	*,
        id=None,
        uuid=None,
        accession_number=None,
        account_id=None,
        account=None,
        customfields=None,
        order_number=None,
        patient_birth_date=None,
        patient_name=None,
        patient_sex=None,
        patientid=None,
        referring_physician=None,
        sending_facility=None,
        study_uid=None,
        created=None,
        created_by=None,
        created_by_obj=None,
        updated=None,
        updated_by=None,
        updated_by_obj=None,
    ):
        self.id = id
        self.uuid = uuid
        self.accession_number = accession_number
        self.account_id = account_id
        self.account = account
        self.customfields = customfields
        self.order_number = order_number
        self.patient_birth_date = patient_birth_date
        self.patient_name = patient_name
        self.patient_sex = patient_sex
        self.patientid = patientid
        self.referring_physician = referring_physician
        self.sending_facility = sending_facility
        self.study_uid = study_uid
        self.created = created
        self.created_by = created_by
        self.created_by_obj = created_by_obj
        self.updated = updated
        self.updated_by = updated_by
        self.updated_by_obj = updated_by_obj



class OrderSps(BaseModel):
    """OrderSps."""
    
    id = Integer(description='Primary key for internal use')
    uuid = String(description='UUID for external use')
    modality = String(description='The step information')
    mpps_status = String(description='The mpps information')
    mpps_uid = String(description='The mpps information')
    order_id = Integer(description='FK. The associated order')
    order = FK(model='Order', description='The associated order')
    requested_procedure_description = String(description='The step information')
    requested_procedure_id = String(description='The step information')
    scheduled_procedure_step_description = String(description='The step information')
    scheduled_procedure_step_id = String(description='The step information')
    scheduled_procedure_step_start_date = String(description='The step information')
    scheduled_procedure_step_start_time = String(description='The step information')
    scheduled_station_aetitle = String(description='The step information')
    created = DateTime(description='Timestamp when the record was created')
    created_by = Integer(description='FK. ID of the user who created the record')
    created_by_obj = FK(model='User', description='ID of the user who created the record')
    updated = DateTime(description='Timestamp when the record was last updated')
    updated_by = Integer(description='FK. ID of the user who updated the record')
    updated_by_obj = FK(model='User', description='ID of the user who updated the record')


    def __init__(
        self,
	*,
        id=None,
        uuid=None,
        modality=None,
        mpps_status=None,
        mpps_uid=None,
        order_id=None,
        order=None,
        requested_procedure_description=None,
        requested_procedure_id=None,
        scheduled_procedure_step_description=None,
        scheduled_procedure_step_id=None,
        scheduled_procedure_step_start_date=None,
        scheduled_procedure_step_start_time=None,
        scheduled_station_aetitle=None,
        created=None,
        created_by=None,
        created_by_obj=None,
        updated=None,
        updated_by=None,
        updated_by_obj=None,
    ):
        self.id = id
        self.uuid = uuid
        self.modality = modality
        self.mpps_status = mpps_status
        self.mpps_uid = mpps_uid
        self.order_id = order_id
        self.order = order
        self.requested_procedure_description = requested_procedure_description
        self.requested_procedure_id = requested_procedure_id
        self.scheduled_procedure_step_description = scheduled_procedure_step_description
        self.scheduled_procedure_step_id = scheduled_procedure_step_id
        self.scheduled_procedure_step_start_date = scheduled_procedure_step_start_date
        self.scheduled_procedure_step_start_time = scheduled_procedure_step_start_time
        self.scheduled_station_aetitle = scheduled_station_aetitle
        self.created = created
        self.created_by = created_by
        self.created_by_obj = created_by_obj
        self.updated = updated
        self.updated_by = updated_by
        self.updated_by_obj = updated_by_obj



class Patient(BaseModel):
    """Patient."""
    
    id = Integer(description='Primary key for internal use')
    uuid = String(description='UUID for external use')
    account_id = Integer(description='FK. The associated account')
    account = FK(model='Account', description='The associated account')
    alt_email = String(description='Contact info')
    alt_mobile_phone = String(description='Contact info')
    birth_date = String(description='Basic information')
    customfields = DictField(description='Custom fields')
    email = String(description='Contact info')
    event_share = Boolean(description='The event flags')
    first = String(description='Basic information')
    last = String(description='Basic information')
    last_event = DateTime(description='Ordering field')
    mobile_phone = String(description='Contact info')
    mrn = String(description='Basic information')
    name = String(description='Basic information')
    sex = String(description='Basic information')
    user_id = Integer(description='FK. The associated user')
    user = FK(model='User', description='The associated user')
    created = DateTime(description='Timestamp when the record was created')
    created_by = Integer(description='FK. ID of the user who created the record')
    created_by_obj = FK(model='User', description='ID of the user who created the record')
    updated = DateTime(description='Timestamp when the record was last updated')
    updated_by = Integer(description='FK. ID of the user who updated the record')
    updated_by_obj = FK(model='User', description='ID of the user who updated the record')


    def __init__(
        self,
	*,
        id=None,
        uuid=None,
        account_id=None,
        account=None,
        alt_email=None,
        alt_mobile_phone=None,
        birth_date=None,
        customfields=None,
        email=None,
        event_share=None,
        first=None,
        last=None,
        last_event=None,
        mobile_phone=None,
        mrn=None,
        name=None,
        sex=None,
        user_id=None,
        user=None,
        created=None,
        created_by=None,
        created_by_obj=None,
        updated=None,
        updated_by=None,
        updated_by_obj=None,
    ):
        self.id = id
        self.uuid = uuid
        self.account_id = account_id
        self.account = account
        self.alt_email = alt_email
        self.alt_mobile_phone = alt_mobile_phone
        self.birth_date = birth_date
        self.customfields = customfields
        self.email = email
        self.event_share = event_share
        self.first = first
        self.last = last
        self.last_event = last_event
        self.mobile_phone = mobile_phone
        self.mrn = mrn
        self.name = name
        self.sex = sex
        self.user_id = user_id
        self.user = user
        self.created = created
        self.created_by = created_by
        self.created_by_obj = created_by_obj
        self.updated = updated
        self.updated_by = updated_by
        self.updated_by_obj = updated_by_obj



class Purge(BaseModel):
    """Purge."""
    
    id = Integer(description='Primary key for internal use')
    uuid = String(description='UUID for external use')
    account_id = Integer(description='FK. The associated account')
    account = FK(model='Account', description='The associated account')
    adults = Boolean(description='Include adults  in this rule')
    archive = Boolean(description='Flag to make it a thin, archive or skinny study')
    days_old = Integer(description='Age of the studies to purge and how to calculate the purge')
    days_old_how = String(description='Age of the studies to purge and how to calculate the purge')
    global_field = Boolean(description='Is this a global purge rule')
    max_deletes = Integer(description='Maximum number of purges per run of the rule')
    minors = Boolean(description='Include minors in this rule')
    modalities = String(description='The modalities to limit the rule to as a JSON array')
    name = String(description='Name')
    namespaces = String(description='The namespaces to limit the rule to as a JSON array')
    owned_phr = Boolean(description='Include owned PHR namespaces in the rule')
    shared_from_phr = Boolean(description='If a study was shared from a PHR delete the copy in the PHR as well')
    skinny = Boolean(description='Flag to make it a thin, archive or skinny study')
    study_status_tags = String(description='A CSV list of the study status tags limit the purge to')
    suspended = Boolean(description='Suspend this rule from running')
    thin = Boolean(description='Flag to make it a thin, archive or skinny study')
    created = DateTime(description='Timestamp when the record was created')
    created_by = Integer(description='FK. ID of the user who created the record')
    created_by_obj = FK(model='User', description='ID of the user who created the record')
    updated = DateTime(description='Timestamp when the record was last updated')
    updated_by = Integer(description='FK. ID of the user who updated the record')
    updated_by_obj = FK(model='User', description='ID of the user who updated the record')


    def __init__(
        self,
	*,
        id=None,
        uuid=None,
        account_id=None,
        account=None,
        adults=None,
        archive=None,
        days_old=None,
        days_old_how=None,
        global_field=None,
        max_deletes=None,
        minors=None,
        modalities=None,
        name=None,
        namespaces=None,
        owned_phr=None,
        shared_from_phr=None,
        skinny=None,
        study_status_tags=None,
        suspended=None,
        thin=None,
        created=None,
        created_by=None,
        created_by_obj=None,
        updated=None,
        updated_by=None,
        updated_by_obj=None,
    ):
        self.id = id
        self.uuid = uuid
        self.account_id = account_id
        self.account = account
        self.adults = adults
        self.archive = archive
        self.days_old = days_old
        self.days_old_how = days_old_how
        self.global_field = global_field
        self.max_deletes = max_deletes
        self.minors = minors
        self.modalities = modalities
        self.name = name
        self.namespaces = namespaces
        self.owned_phr = owned_phr
        self.shared_from_phr = shared_from_phr
        self.skinny = skinny
        self.study_status_tags = study_status_tags
        self.suspended = suspended
        self.thin = thin
        self.created = created
        self.created_by = created_by
        self.created_by_obj = created_by_obj
        self.updated = updated
        self.updated_by = updated_by
        self.updated_by_obj = updated_by_obj



class Radreport(BaseModel):
    """Radreport."""
    
    id = Integer(description='Primary key for internal use')
    uuid = String(description='UUID for external use')
    attachment = String(description='The attachment information')
    fields = String(description='The fields in the report')
    study_id = Integer(description='FK. Attached study')
    study = FK(model='Study', description='Attached study')
    type_field = String(description='Type of report')
    user_id = Integer(description='FK. User who created the report')
    user = FK(model='User', description='User who created the report')
    created = DateTime(description='Timestamp when the record was created')
    created_by = Integer(description='FK. ID of the user who created the record')
    created_by_obj = FK(model='User', description='ID of the user who created the record')
    updated = DateTime(description='Timestamp when the record was last updated')
    updated_by = Integer(description='FK. ID of the user who updated the record')
    updated_by_obj = FK(model='User', description='ID of the user who updated the record')


    def __init__(
        self,
	*,
        id=None,
        uuid=None,
        attachment=None,
        fields=None,
        study_id=None,
        study=None,
        type_field=None,
        user_id=None,
        user=None,
        created=None,
        created_by=None,
        created_by_obj=None,
        updated=None,
        updated_by=None,
        updated_by_obj=None,
    ):
        self.id = id
        self.uuid = uuid
        self.attachment = attachment
        self.fields = fields
        self.study_id = study_id
        self.study = study
        self.type_field = type_field
        self.user_id = user_id
        self.user = user
        self.created = created
        self.created_by = created_by
        self.created_by_obj = created_by_obj
        self.updated = updated
        self.updated_by = updated_by
        self.updated_by_obj = updated_by_obj



class RadreportAnalytics(BaseModel):
    """RadreportAnalytics."""
    
    id = Integer(description='Primary key for internal use')
    account_id = Integer(description='FK. The primary keys')
    account = FK(model='Account', description='The primary keys')
    day = Date(description='The day')
    namespace_id = Integer(description='FK. The primary keys')
    namespace = FK(model='Namespace', description='The primary keys')
    radreport_create = Integer(description='The metrics')
    radreport_delete = Integer(description='The metrics')
    radreport_report_generated = Integer(description='The metrics')
    radreport_signed = Integer(description='The metrics')
    user_id = Integer(description='FK. The primary keys')
    user = FK(model='User', description='The primary keys')


    def __init__(
        self,
	*,
        id=None,
        account_id=None,
        account=None,
        day=None,
        namespace_id=None,
        namespace=None,
        radreport_create=None,
        radreport_delete=None,
        radreport_report_generated=None,
        radreport_signed=None,
        user_id=None,
        user=None,
    ):
        self.id = id
        self.account_id = account_id
        self.account = account
        self.day = day
        self.namespace_id = namespace_id
        self.namespace = namespace
        self.radreport_create = radreport_create
        self.radreport_delete = radreport_delete
        self.radreport_report_generated = radreport_report_generated
        self.radreport_signed = radreport_signed
        self.user_id = user_id
        self.user = user



class RadreportTemplate(BaseModel):
    """RadreportTemplate."""
    
    id = Integer(description='Primary key for internal use')
    uuid = String(description='UUID for external use')
    account_id = Integer(description='FK. Associated account')
    account = FK(model='Account', description='Associated account')
    active = Boolean(description='Is this the active record')
    body = String(description='Template fields')
    name = String(description='Description of report template')
    options = String(description='Template metadata')
    preview = String(description='Template fields')
    type_field = String(description='Type of report template')
    created = DateTime(description='Timestamp when the record was created')
    created_by = Integer(description='FK. ID of the user who created the record')
    created_by_obj = FK(model='User', description='ID of the user who created the record')
    updated = DateTime(description='Timestamp when the record was last updated')
    updated_by = Integer(description='FK. ID of the user who updated the record')
    updated_by_obj = FK(model='User', description='ID of the user who updated the record')


    def __init__(
        self,
	*,
        id=None,
        uuid=None,
        account_id=None,
        account=None,
        active=None,
        body=None,
        name=None,
        options=None,
        preview=None,
        type_field=None,
        created=None,
        created_by=None,
        created_by_obj=None,
        updated=None,
        updated_by=None,
        updated_by_obj=None,
    ):
        self.id = id
        self.uuid = uuid
        self.account_id = account_id
        self.account = account
        self.active = active
        self.body = body
        self.name = name
        self.options = options
        self.preview = preview
        self.type_field = type_field
        self.created = created
        self.created_by = created_by
        self.created_by_obj = created_by_obj
        self.updated = updated
        self.updated_by = updated_by
        self.updated_by_obj = updated_by_obj



class Radreportmacro(BaseModel):
    """Radreportmacro."""
    
    id = Integer(description='Primary key for internal use')
    uuid = String(description='UUID for external use')
    account_id = Integer(description='FK. Associated account')
    account = FK(model='Account', description='Associated account')
    body = String(description='Macro fields')
    hotkey = String(description='Macro fields')
    modality = String(description='Macro fields')
    name = String(description='Macro fields')
    type_field = String(description='Type of report')
    user_id = Integer(description='FK. User who owns the macro')
    user = FK(model='User', description='User who owns the macro')
    created = DateTime(description='Timestamp when the record was created')
    created_by = Integer(description='FK. ID of the user who created the record')
    created_by_obj = FK(model='User', description='ID of the user who created the record')
    updated = DateTime(description='Timestamp when the record was last updated')
    updated_by = Integer(description='FK. ID of the user who updated the record')
    updated_by_obj = FK(model='User', description='ID of the user who updated the record')


    def __init__(
        self,
	*,
        id=None,
        uuid=None,
        account_id=None,
        account=None,
        body=None,
        hotkey=None,
        modality=None,
        name=None,
        type_field=None,
        user_id=None,
        user=None,
        created=None,
        created_by=None,
        created_by_obj=None,
        updated=None,
        updated_by=None,
        updated_by_obj=None,
    ):
        self.id = id
        self.uuid = uuid
        self.account_id = account_id
        self.account = account
        self.body = body
        self.hotkey = hotkey
        self.modality = modality
        self.name = name
        self.type_field = type_field
        self.user_id = user_id
        self.user = user
        self.created = created
        self.created_by = created_by
        self.created_by_obj = created_by_obj
        self.updated = updated
        self.updated_by = updated_by
        self.updated_by_obj = updated_by_obj



class Role(BaseModel):
    """Role."""
    
    id = Integer(description='Primary key for internal use')
    uuid = String(description='UUID for external use')
    account_id = Integer(description='FK. The associated account')
    account = FK(model='Account', description='The associated account')
    description = String(description='Description')
    name = String(description='Name')
    permissions = String(description='The permissions as a json structure')
    type_field = String(description='Type if role is system created')
    created = DateTime(description='Timestamp when the record was created')
    created_by = Integer(description='FK. ID of the user who created the record')
    created_by_obj = FK(model='User', description='ID of the user who created the record')
    updated = DateTime(description='Timestamp when the record was last updated')
    updated_by = Integer(description='FK. ID of the user who updated the record')
    updated_by_obj = FK(model='User', description='ID of the user who updated the record')


    def __init__(
        self,
	*,
        id=None,
        uuid=None,
        account_id=None,
        account=None,
        description=None,
        name=None,
        permissions=None,
        type_field=None,
        created=None,
        created_by=None,
        created_by_obj=None,
        updated=None,
        updated_by=None,
        updated_by_obj=None,
    ):
        self.id = id
        self.uuid = uuid
        self.account_id = account_id
        self.account = account
        self.description = description
        self.name = name
        self.permissions = permissions
        self.type_field = type_field
        self.created = created
        self.created_by = created_by
        self.created_by_obj = created_by_obj
        self.updated = updated
        self.updated_by = updated_by
        self.updated_by_obj = updated_by_obj



class Route(BaseModel):
    """Route."""
    
    id = Integer(description='Primary key for internal use')
    uuid = String(description='UUID for external use')
    account_id = Integer(description='FK. The associated account')
    account = FK(model='Account', description='The associated account')
    actions = String(description='The rule actions')
    conditions = String(description='The rule conditions')
    delay = Integer(description='Number of minutes to delay running this rule after it is triggered')
    delay_till_schedule = Boolean(description='Delay running the rule until the schedule time')
    manual_roles = DictField(description='Roles that can manually run this route')
    name = String(description='Name')
    namespace_id = Integer(description='FK. The associated namespace')
    namespace = FK(model='Namespace', description='The associated namespace')
    no_re_run = Boolean(description='Should the rule be not be run on a re-run of a storage notification')
    on_harvest = Boolean(description='Should the rule be run on harvested studies')
    on_manual_route = Boolean(description='Should the rule be able to be applied manually')
    on_share = Boolean(description='Should the rule be run on shared studies')
    on_thin = Boolean(description='Should the rule be run on the creation of thin studies')
    on_upload = Boolean(description='Should the rule be run on uploaded studies')
    options = String(description='The rule options')
    other_namespaces = DictField(description='The other namespaces this rule is associated with')
    schedule = String(description='The rule schedule')
    suspended = Boolean(description='Suspend this rule from running')
    created = DateTime(description='Timestamp when the record was created')
    created_by = Integer(description='FK. ID of the user who created the record')
    created_by_obj = FK(model='User', description='ID of the user who created the record')
    updated = DateTime(description='Timestamp when the record was last updated')
    updated_by = Integer(description='FK. ID of the user who updated the record')
    updated_by_obj = FK(model='User', description='ID of the user who updated the record')


    def __init__(
        self,
	*,
        id=None,
        uuid=None,
        account_id=None,
        account=None,
        actions=None,
        conditions=None,
        delay=None,
        delay_till_schedule=None,
        manual_roles=None,
        name=None,
        namespace_id=None,
        namespace=None,
        no_re_run=None,
        on_harvest=None,
        on_manual_route=None,
        on_share=None,
        on_thin=None,
        on_upload=None,
        options=None,
        other_namespaces=None,
        schedule=None,
        suspended=None,
        created=None,
        created_by=None,
        created_by_obj=None,
        updated=None,
        updated_by=None,
        updated_by_obj=None,
    ):
        self.id = id
        self.uuid = uuid
        self.account_id = account_id
        self.account = account
        self.actions = actions
        self.conditions = conditions
        self.delay = delay
        self.delay_till_schedule = delay_till_schedule
        self.manual_roles = manual_roles
        self.name = name
        self.namespace_id = namespace_id
        self.namespace = namespace
        self.no_re_run = no_re_run
        self.on_harvest = on_harvest
        self.on_manual_route = on_manual_route
        self.on_share = on_share
        self.on_thin = on_thin
        self.on_upload = on_upload
        self.options = options
        self.other_namespaces = other_namespaces
        self.schedule = schedule
        self.suspended = suspended
        self.created = created
        self.created_by = created_by
        self.created_by_obj = created_by_obj
        self.updated = updated
        self.updated_by = updated_by
        self.updated_by_obj = updated_by_obj



class RouteRoundRobin(BaseModel):
    """RouteRoundRobin."""
    
    id = Integer(description='Primary key for internal use')
    action = String(description='Primary key for internal use')
    route_id = Integer(description='FK. Primary key for internal use')
    route = FK(model='Route', description='Primary key for internal use')
    study_id = Integer(description='FK. Primary key for internal use')
    study = FK(model='Study', description='Primary key for internal use')
    created = DateTime(description='Timestamp when the record was created')
    created_by = Integer(description='FK. ID of the user who created the record')
    created_by_obj = FK(model='User', description='ID of the user who created the record')
    updated = DateTime(description='Timestamp when the record was last updated')
    updated_by = Integer(description='FK. ID of the user who updated the record')
    updated_by_obj = FK(model='User', description='ID of the user who updated the record')


    def __init__(
        self,
	*,
        id=None,
        action=None,
        route_id=None,
        route=None,
        study_id=None,
        study=None,
        created=None,
        created_by=None,
        created_by_obj=None,
        updated=None,
        updated_by=None,
        updated_by_obj=None,
    ):
        self.id = id
        self.action = action
        self.route_id = route_id
        self.route = route
        self.study_id = study_id
        self.study = study
        self.created = created
        self.created_by = created_by
        self.created_by_obj = created_by_obj
        self.updated = updated
        self.updated_by = updated_by
        self.updated_by_obj = updated_by_obj



class RsnaclrDoc(BaseModel):
    """RsnaclrDoc."""
    
    id = Integer(description='Primary key for internal use')
    uuid = String(description='UUID for external use')
    attachmentid = String(description='')
    author = JsonB(description='')
    class_code = JsonB(description='')
    comments = String(description='')
    communityid = String(description='')
    confidentiality_code = JsonB(description='')
    creation_time = String(description='')
    documentid = String(description='')
    event_code_list = JsonB(description='')
    format_code = JsonB(description='')
    healthcare_facility_type_code = JsonB(description='')
    language_code = String(description='')
    legal_authenticator = String(description='')
    limited_metadata = Boolean(description='')
    mime_type = String(description='')
    patientid = String(description='')
    practice_setting_code = JsonB(description='')
    reference_id_list = JsonB(description='')
    repositoryid = String(description='')
    rsna_status = String(description='')
    rsnaclr_subset_id = Integer(description='FK. The associated submission set')
    rsnaclr_subset = FK(model='RsnaclrSubset', description='The associated submission set')
    service_start_time = String(description='')
    service_stop_time = String(description='')
    sha1 = String(description='')
    size = Integer(description='')
    source_patient_id = String(description='')
    source_patient_info = JsonB(description='')
    title = String(description='')
    type_code = JsonB(description='')
    uniqueid = String(description='')
    created = DateTime(description='Timestamp when the record was created')
    created_by = Integer(description='FK. ID of the user who created the record')
    created_by_obj = FK(model='User', description='ID of the user who created the record')
    updated = DateTime(description='Timestamp when the record was last updated')
    updated_by = Integer(description='FK. ID of the user who updated the record')
    updated_by_obj = FK(model='User', description='ID of the user who updated the record')


    def __init__(
        self,
	*,
        id=None,
        uuid=None,
        attachmentid=None,
        author=None,
        class_code=None,
        comments=None,
        communityid=None,
        confidentiality_code=None,
        creation_time=None,
        documentid=None,
        event_code_list=None,
        format_code=None,
        healthcare_facility_type_code=None,
        language_code=None,
        legal_authenticator=None,
        limited_metadata=None,
        mime_type=None,
        patientid=None,
        practice_setting_code=None,
        reference_id_list=None,
        repositoryid=None,
        rsna_status=None,
        rsnaclr_subset_id=None,
        rsnaclr_subset=None,
        service_start_time=None,
        service_stop_time=None,
        sha1=None,
        size=None,
        source_patient_id=None,
        source_patient_info=None,
        title=None,
        type_code=None,
        uniqueid=None,
        created=None,
        created_by=None,
        created_by_obj=None,
        updated=None,
        updated_by=None,
        updated_by_obj=None,
    ):
        self.id = id
        self.uuid = uuid
        self.attachmentid = attachmentid
        self.author = author
        self.class_code = class_code
        self.comments = comments
        self.communityid = communityid
        self.confidentiality_code = confidentiality_code
        self.creation_time = creation_time
        self.documentid = documentid
        self.event_code_list = event_code_list
        self.format_code = format_code
        self.healthcare_facility_type_code = healthcare_facility_type_code
        self.language_code = language_code
        self.legal_authenticator = legal_authenticator
        self.limited_metadata = limited_metadata
        self.mime_type = mime_type
        self.patientid = patientid
        self.practice_setting_code = practice_setting_code
        self.reference_id_list = reference_id_list
        self.repositoryid = repositoryid
        self.rsna_status = rsna_status
        self.rsnaclr_subset_id = rsnaclr_subset_id
        self.rsnaclr_subset = rsnaclr_subset
        self.service_start_time = service_start_time
        self.service_stop_time = service_stop_time
        self.sha1 = sha1
        self.size = size
        self.source_patient_id = source_patient_id
        self.source_patient_info = source_patient_info
        self.title = title
        self.type_code = type_code
        self.uniqueid = uniqueid
        self.created = created
        self.created_by = created_by
        self.created_by_obj = created_by_obj
        self.updated = updated
        self.updated_by = updated_by
        self.updated_by_obj = updated_by_obj



class RsnaclrSubset(BaseModel):
    """RsnaclrSubset."""
    
    id = Integer(description='Primary key for internal use')
    uuid = String(description='UUID for external use')
    author = JsonB(description='')
    comments = String(description='')
    communityid = String(description='')
    content_type_code = JsonB(description='')
    intended_recipient = JsonB(description='')
    limited_metadata = Boolean(description='')
    patientid = String(description='RSNA patient Id')
    rsna_status = String(description='Status of the submission set')
    sourceid = String(description='')
    study_id = Integer(description='FK. Study the submission set is attached to')
    study = FK(model='Study', description='Study the submission set is attached to')
    submission_time = String(description='')
    title = String(description='')
    uniqueid = String(description='')
    created = DateTime(description='Timestamp when the record was created')
    created_by = Integer(description='FK. ID of the user who created the record')
    created_by_obj = FK(model='User', description='ID of the user who created the record')
    updated = DateTime(description='Timestamp when the record was last updated')
    updated_by = Integer(description='FK. ID of the user who updated the record')
    updated_by_obj = FK(model='User', description='ID of the user who updated the record')


    def __init__(
        self,
	*,
        id=None,
        uuid=None,
        author=None,
        comments=None,
        communityid=None,
        content_type_code=None,
        intended_recipient=None,
        limited_metadata=None,
        patientid=None,
        rsna_status=None,
        sourceid=None,
        study_id=None,
        study=None,
        submission_time=None,
        title=None,
        uniqueid=None,
        created=None,
        created_by=None,
        created_by_obj=None,
        updated=None,
        updated_by=None,
        updated_by_obj=None,
    ):
        self.id = id
        self.uuid = uuid
        self.author = author
        self.comments = comments
        self.communityid = communityid
        self.content_type_code = content_type_code
        self.intended_recipient = intended_recipient
        self.limited_metadata = limited_metadata
        self.patientid = patientid
        self.rsna_status = rsna_status
        self.sourceid = sourceid
        self.study_id = study_id
        self.study = study
        self.submission_time = submission_time
        self.title = title
        self.uniqueid = uniqueid
        self.created = created
        self.created_by = created_by
        self.created_by_obj = created_by_obj
        self.updated = updated
        self.updated_by = updated_by
        self.updated_by_obj = updated_by_obj



class Rsync(BaseModel):
    """Rsync."""
    
    id = Integer(description='Primary key for internal use')
    uuid = String(description='UUID for external use')
    is_full = Boolean(description='Is the account full')
    name = String(description='ssh account name')
    created = DateTime(description='Timestamp when the record was created')
    created_by = Integer(description='FK. ID of the user who created the record')
    created_by_obj = FK(model='User', description='ID of the user who created the record')
    updated = DateTime(description='Timestamp when the record was last updated')
    updated_by = Integer(description='FK. ID of the user who updated the record')
    updated_by_obj = FK(model='User', description='ID of the user who updated the record')


    def __init__(
        self,
	*,
        id=None,
        uuid=None,
        is_full=None,
        name=None,
        created=None,
        created_by=None,
        created_by_obj=None,
        updated=None,
        updated_by=None,
        updated_by_obj=None,
    ):
        self.id = id
        self.uuid = uuid
        self.is_full = is_full
        self.name = name
        self.created = created
        self.created_by = created_by
        self.created_by_obj = created_by_obj
        self.updated = updated
        self.updated_by = updated_by
        self.updated_by_obj = updated_by_obj



class Setting(BaseModel):
    """Setting."""
    
    id = Integer(description='Primary key for internal use')
    uuid = String(description='UUID for external use')
    key = String(description='')
    user_id = Integer(description='FK. ')
    user = FK(model='User', description='')
    value = String(description='')
    created = DateTime(description='Timestamp when the record was created')
    created_by = Integer(description='FK. ID of the user who created the record')
    created_by_obj = FK(model='User', description='ID of the user who created the record')
    updated = DateTime(description='Timestamp when the record was last updated')
    updated_by = Integer(description='FK. ID of the user who updated the record')
    updated_by_obj = FK(model='User', description='ID of the user who updated the record')


    def __init__(
        self,
	*,
        id=None,
        uuid=None,
        key=None,
        user_id=None,
        user=None,
        value=None,
        created=None,
        created_by=None,
        created_by_obj=None,
        updated=None,
        updated_by=None,
        updated_by_obj=None,
    ):
        self.id = id
        self.uuid = uuid
        self.key = key
        self.user_id = user_id
        self.user = user
        self.value = value
        self.created = created
        self.created_by = created_by
        self.created_by_obj = created_by_obj
        self.updated = updated
        self.updated_by = updated_by
        self.updated_by_obj = updated_by_obj



class StorageStudy(BaseModel):
    """StorageStudy."""
    
    id = Integer(description='Primary key for internal use')
    uuid = String(description='UUID for external use')
    corrupt = Boolean(description='Flag if the study is corrupt')
    engine_id = Integer(description='FK. The storage engine')
    engine = FK(model='Engine', description='The storage engine')
    is_frozen = Boolean(description='Flag if the study is frozen')
    last_update = DateTime(description='Time of the last update of the study')
    rsync_id = Integer(description='FK. The rysnc account')
    rsync = FK(model='Rsync', description='The rysnc account')
    storage_namespace = Integer(description='FK. The storage namespace')
    storage_namespace_obj = FK(model='Namespace', description='The storage namespace')
    study_uid = String(description='Study instance id')
    created = DateTime(description='Timestamp when the record was created')
    created_by = Integer(description='FK. ID of the user who created the record')
    created_by_obj = FK(model='User', description='ID of the user who created the record')
    updated = DateTime(description='Timestamp when the record was last updated')
    updated_by = Integer(description='FK. ID of the user who updated the record')
    updated_by_obj = FK(model='User', description='ID of the user who updated the record')


    def __init__(
        self,
	*,
        id=None,
        uuid=None,
        corrupt=None,
        engine_id=None,
        engine=None,
        is_frozen=None,
        last_update=None,
        rsync_id=None,
        rsync=None,
        storage_namespace=None,
        storage_namespace_obj=None,
        study_uid=None,
        created=None,
        created_by=None,
        created_by_obj=None,
        updated=None,
        updated_by=None,
        updated_by_obj=None,
    ):
        self.id = id
        self.uuid = uuid
        self.corrupt = corrupt
        self.engine_id = engine_id
        self.engine = engine
        self.is_frozen = is_frozen
        self.last_update = last_update
        self.rsync_id = rsync_id
        self.rsync = rsync
        self.storage_namespace = storage_namespace
        self.storage_namespace_obj = storage_namespace_obj
        self.study_uid = study_uid
        self.created = created
        self.created_by = created_by
        self.created_by_obj = created_by_obj
        self.updated = updated
        self.updated_by = updated_by
        self.updated_by_obj = updated_by_obj



class Study(BaseModel):
    """Study."""
    
    id = Integer(description='Primary key for internal use')
    uuid = String(description='UUID for external use')
    accession_number = String(description='This is the MRN')
    attachment_count = Integer(description='This is the MRN')
    callback_url = String(description='2013-11 - This is depreciated as the storage id is now used. If this is dropped update its usage in the database script.')
    compressed_size = Integer(description='This is the MRN')
    customfields = DictField(description='Custom fields')
    destination_ae_title = String(description='The aetitle the study was harvested against')
    engine_id = Integer(description='FK. The storage engine the study is stored on')
    engine = FK(model='Engine', description='The storage engine the study is stored on')
    image_count = Integer(description='This is the MRN')
    integration_key = String(description='Key for integration with third party systems')
    medical_record_locator = String(description='This is the MRN')
    modality = String(description='This is the MRN')
    must_approve = Boolean(description='Flag if study approval is needed')
    node_id = Integer(description='FK. The harvest node id')
    node = FK(model='Node', description='The harvest node id')
    patient_additional_history = String(description='This is the MRN')
    patient_address = String(description='This is the MRN')
    patient_age = String(description='This is the MRN')
    patient_birth_date = String(description='This is the MRN')
    patient_birth_time = String(description='This is the MRN')
    patient_birthname = String(description='This is the MRN')
    patient_comments = String(description='This is the MRN')
    patient_current_location = String(description='This is the MRN')
    patient_ethnic_group = String(description='This is the MRN')
    patient_institution_residence = String(description='This is the MRN')
    patient_mother_birthname = String(description='This is the MRN')
    patient_name = String(description='Dicom fields')
    patient_name_other = String(description='This is the MRN')
    patient_occupation = String(description='This is the MRN')
    patient_phone = String(description='This is the MRN')
    patient_religious_preference = String(description='This is the MRN')
    patient_sex = String(description='This is the MRN')
    patient_size = String(description='This is the MRN')
    patient_weight = String(description='This is the MRN')
    patientid = String(description='This is the MRN')
    patientid_other = String(description='This is the MRN')
    phantom = Boolean(description='A phantom study is one that is in the process loading into storage')
    phi_namespace = Integer(description='FK. The PHI namespace. This controls the study visibility')
    phi_namespace_obj = FK(model='Namespace', description='The PHI namespace. This controls the study visibility')
    referring_physician = String(description='This is the MRN')
    shared_from = Integer(description='FK. Id of the study this was originally shared from')
    shared_from_obj = FK(model='StudyShare', description='Id of the study this was originally shared from')
    size = Integer(description='This is the MRN')
    source = String(description='The original source of the study')
    source_ae_title = String(description='The aetitle the study was harvested against')
    storage_namespace = Integer(description='FK. The storage namespace')
    storage_namespace_obj = FK(model='Namespace', description='The storage namespace')
    storage_state = String(description='Storage state. Empty or null is available or else &#39;U&#39; if unavailable or &#39;R&#39; if getting restored from the archive')
    study_date = String(description='This is the MRN')
    study_description = String(description='This is the MRN')
    study_status = String(description='The status of the study')
    study_time = String(description='This is the MRN')
    study_uid = String(description='Study instance id')
    thin = Boolean(description='A thin study is not in primary storage and needs to be query retrieved to be loaded into storage or loaded from an archive')
    created = DateTime(description='Timestamp when the record was created')
    created_by = Integer(description='FK. ID of the user who created the record')
    created_by_obj = FK(model='User', description='ID of the user who created the record')
    updated = DateTime(description='Timestamp when the record was last updated')
    updated_by = Integer(description='FK. ID of the user who updated the record')
    updated_by_obj = FK(model='User', description='ID of the user who updated the record')


    def __init__(
        self,
	*,
        id=None,
        uuid=None,
        accession_number=None,
        attachment_count=None,
        callback_url=None,
        compressed_size=None,
        customfields=None,
        destination_ae_title=None,
        engine_id=None,
        engine=None,
        image_count=None,
        integration_key=None,
        medical_record_locator=None,
        modality=None,
        must_approve=None,
        node_id=None,
        node=None,
        patient_additional_history=None,
        patient_address=None,
        patient_age=None,
        patient_birth_date=None,
        patient_birth_time=None,
        patient_birthname=None,
        patient_comments=None,
        patient_current_location=None,
        patient_ethnic_group=None,
        patient_institution_residence=None,
        patient_mother_birthname=None,
        patient_name=None,
        patient_name_other=None,
        patient_occupation=None,
        patient_phone=None,
        patient_religious_preference=None,
        patient_sex=None,
        patient_size=None,
        patient_weight=None,
        patientid=None,
        patientid_other=None,
        phantom=None,
        phi_namespace=None,
        phi_namespace_obj=None,
        referring_physician=None,
        shared_from=None,
        shared_from_obj=None,
        size=None,
        source=None,
        source_ae_title=None,
        storage_namespace=None,
        storage_namespace_obj=None,
        storage_state=None,
        study_date=None,
        study_description=None,
        study_status=None,
        study_time=None,
        study_uid=None,
        thin=None,
        created=None,
        created_by=None,
        created_by_obj=None,
        updated=None,
        updated_by=None,
        updated_by_obj=None,
    ):
        self.id = id
        self.uuid = uuid
        self.accession_number = accession_number
        self.attachment_count = attachment_count
        self.callback_url = callback_url
        self.compressed_size = compressed_size
        self.customfields = customfields
        self.destination_ae_title = destination_ae_title
        self.engine_id = engine_id
        self.engine = engine
        self.image_count = image_count
        self.integration_key = integration_key
        self.medical_record_locator = medical_record_locator
        self.modality = modality
        self.must_approve = must_approve
        self.node_id = node_id
        self.node = node
        self.patient_additional_history = patient_additional_history
        self.patient_address = patient_address
        self.patient_age = patient_age
        self.patient_birth_date = patient_birth_date
        self.patient_birth_time = patient_birth_time
        self.patient_birthname = patient_birthname
        self.patient_comments = patient_comments
        self.patient_current_location = patient_current_location
        self.patient_ethnic_group = patient_ethnic_group
        self.patient_institution_residence = patient_institution_residence
        self.patient_mother_birthname = patient_mother_birthname
        self.patient_name = patient_name
        self.patient_name_other = patient_name_other
        self.patient_occupation = patient_occupation
        self.patient_phone = patient_phone
        self.patient_religious_preference = patient_religious_preference
        self.patient_sex = patient_sex
        self.patient_size = patient_size
        self.patient_weight = patient_weight
        self.patientid = patientid
        self.patientid_other = patientid_other
        self.phantom = phantom
        self.phi_namespace = phi_namespace
        self.phi_namespace_obj = phi_namespace_obj
        self.referring_physician = referring_physician
        self.shared_from = shared_from
        self.shared_from_obj = shared_from_obj
        self.size = size
        self.source = source
        self.source_ae_title = source_ae_title
        self.storage_namespace = storage_namespace
        self.storage_namespace_obj = storage_namespace_obj
        self.storage_state = storage_state
        self.study_date = study_date
        self.study_description = study_description
        self.study_status = study_status
        self.study_time = study_time
        self.study_uid = study_uid
        self.thin = thin
        self.created = created
        self.created_by = created_by
        self.created_by_obj = created_by_obj
        self.updated = updated
        self.updated_by = updated_by
        self.updated_by_obj = updated_by_obj



class StudyAnalytics(BaseModel):
    """StudyAnalytics."""
    
    id = Integer(description='Primary key for internal use')
    account_id = Integer(description='FK. The primary keys')
    account = FK(model='Account', description='The primary keys')
    day = Date(description='The day')
    login = Integer(description='Login')
    namespace_id = Integer(description='FK. The primary keys')
    namespace = FK(model='Namespace', description='The primary keys')
    study_approve = Integer(description='Study approved')
    study_auto_approve = Integer(description='Study approved')
    study_create = Integer(description='Total study created')
    study_create_copy = Integer(description='Count by creation type')
    study_create_harvest = Integer(description='Count by creation type')
    study_create_share = Integer(description='Count by creation type')
    study_create_upload = Integer(description='Count by creation type')
    study_delete = Integer(description='Delete, view download and push')
    study_download = Integer(description='Delete, view download and push')
    study_push = Integer(description='Delete, view download and push')
    study_report_view = Integer(description='Delete, view download and push')
    study_share_in = Integer(description='Share in and out')
    study_share_out = Integer(description='Share in and out')
    study_view = Integer(description='Delete, view download and push')


    def __init__(
        self,
	*,
        id=None,
        account_id=None,
        account=None,
        day=None,
        login=None,
        namespace_id=None,
        namespace=None,
        study_approve=None,
        study_auto_approve=None,
        study_create=None,
        study_create_copy=None,
        study_create_harvest=None,
        study_create_share=None,
        study_create_upload=None,
        study_delete=None,
        study_download=None,
        study_push=None,
        study_report_view=None,
        study_share_in=None,
        study_share_out=None,
        study_view=None,
    ):
        self.id = id
        self.account_id = account_id
        self.account = account
        self.day = day
        self.login = login
        self.namespace_id = namespace_id
        self.namespace = namespace
        self.study_approve = study_approve
        self.study_auto_approve = study_auto_approve
        self.study_create = study_create
        self.study_create_copy = study_create_copy
        self.study_create_harvest = study_create_harvest
        self.study_create_share = study_create_share
        self.study_create_upload = study_create_upload
        self.study_delete = study_delete
        self.study_download = study_download
        self.study_push = study_push
        self.study_report_view = study_report_view
        self.study_share_in = study_share_in
        self.study_share_out = study_share_out
        self.study_view = study_view



class StudyAttachment(BaseModel):
    """StudyAttachment."""
    
    id = Integer(description='Primary key for internal use')
    uuid = String(description='UUID for external use')
    attachment_guid = String(description='The attachment id')
    storage_namespace = Integer(description='FK. The storage namespace')
    storage_namespace_obj = FK(model='Namespace', description='The storage namespace')
    study_uid = String(description='Study instance id')
    user_id = Integer(description='FK. The user id')
    user = FK(model='User', description='The user id')
    created = DateTime(description='Timestamp when the record was created')
    created_by = Integer(description='FK. ID of the user who created the record')
    created_by_obj = FK(model='User', description='ID of the user who created the record')
    updated = DateTime(description='Timestamp when the record was last updated')
    updated_by = Integer(description='FK. ID of the user who updated the record')
    updated_by_obj = FK(model='User', description='ID of the user who updated the record')


    def __init__(
        self,
	*,
        id=None,
        uuid=None,
        attachment_guid=None,
        storage_namespace=None,
        storage_namespace_obj=None,
        study_uid=None,
        user_id=None,
        user=None,
        created=None,
        created_by=None,
        created_by_obj=None,
        updated=None,
        updated_by=None,
        updated_by_obj=None,
    ):
        self.id = id
        self.uuid = uuid
        self.attachment_guid = attachment_guid
        self.storage_namespace = storage_namespace
        self.storage_namespace_obj = storage_namespace_obj
        self.study_uid = study_uid
        self.user_id = user_id
        self.user = user
        self.created = created
        self.created_by = created_by
        self.created_by_obj = created_by_obj
        self.updated = updated
        self.updated_by = updated_by
        self.updated_by_obj = updated_by_obj



class StudyCharge(BaseModel):
    """StudyCharge."""
    
    id = Integer(description='Primary key for internal use')
    uuid = String(description='UUID for external use')
    account_id = Integer(description='FK. The study and account id')
    account = FK(model='Account', description='The study and account id')
    detail = String(description='The stripe capture')
    study_id = Integer(description='FK. The study and account id')
    study = FK(model='Study', description='The study and account id')
    created = DateTime(description='Timestamp when the record was created')
    created_by = Integer(description='FK. ID of the user who created the record')
    created_by_obj = FK(model='User', description='ID of the user who created the record')
    updated = DateTime(description='Timestamp when the record was last updated')
    updated_by = Integer(description='FK. ID of the user who updated the record')
    updated_by_obj = FK(model='User', description='ID of the user who updated the record')


    def __init__(
        self,
	*,
        id=None,
        uuid=None,
        account_id=None,
        account=None,
        detail=None,
        study_id=None,
        study=None,
        created=None,
        created_by=None,
        created_by_obj=None,
        updated=None,
        updated_by=None,
        updated_by_obj=None,
    ):
        self.id = id
        self.uuid = uuid
        self.account_id = account_id
        self.account = account
        self.detail = detail
        self.study_id = study_id
        self.study = study
        self.created = created
        self.created_by = created_by
        self.created_by_obj = created_by_obj
        self.updated = updated
        self.updated_by = updated_by
        self.updated_by_obj = updated_by_obj



class StudyComment(BaseModel):
    """StudyComment."""
    
    id = Integer(description='Primary key for internal use')
    uuid = String(description='UUID for external use')
    body = String(description='Body of the comment')
    study_id = Integer(description='FK. The study and user id')
    study = FK(model='Study', description='The study and user id')
    user_id = Integer(description='FK. The study and user id')
    user = FK(model='User', description='The study and user id')
    created = DateTime(description='Timestamp when the record was created')
    created_by = Integer(description='FK. ID of the user who created the record')
    created_by_obj = FK(model='User', description='ID of the user who created the record')
    updated = DateTime(description='Timestamp when the record was last updated')
    updated_by = Integer(description='FK. ID of the user who updated the record')
    updated_by_obj = FK(model='User', description='ID of the user who updated the record')


    def __init__(
        self,
	*,
        id=None,
        uuid=None,
        body=None,
        study_id=None,
        study=None,
        user_id=None,
        user=None,
        created=None,
        created_by=None,
        created_by_obj=None,
        updated=None,
        updated_by=None,
        updated_by_obj=None,
    ):
        self.id = id
        self.uuid = uuid
        self.body = body
        self.study_id = study_id
        self.study = study
        self.user_id = user_id
        self.user = user
        self.created = created
        self.created_by = created_by
        self.created_by_obj = created_by_obj
        self.updated = updated
        self.updated_by = updated_by
        self.updated_by_obj = updated_by_obj



class StudyDeleted(BaseModel):
    """StudyDeleted."""
    
    id = Integer(description='')
    uuid = String(description='')
    accession_number = String(description='')
    attachment_count = Integer(description='')
    callback_url = String(description='')
    compressed_size = Integer(description='')
    customfields = DictField(description='')
    deleted = DateTime(description='')
    deleted_by = Integer(description='FK. ')
    deleted_by_obj = FK(model='User', description='')
    destination_ae_title = String(description='')
    engine_id = Integer(description='FK. ')
    engine = FK(model='Engine', description='')
    image_count = Integer(description='')
    integration_key = String(description='')
    medical_record_locator = String(description='')
    modality = String(description='')
    must_approve = Boolean(description='')
    node_id = Integer(description='FK. ')
    node = FK(model='Node', description='')
    patient_additional_history = String(description='')
    patient_address = String(description='')
    patient_age = String(description='')
    patient_birth_date = String(description='')
    patient_birth_time = String(description='')
    patient_birthname = String(description='')
    patient_comments = String(description='')
    patient_current_location = String(description='')
    patient_ethnic_group = String(description='')
    patient_institution_residence = String(description='')
    patient_mother_birthname = String(description='')
    patient_name = String(description='')
    patient_name_other = String(description='')
    patient_occupation = String(description='')
    patient_phone = String(description='')
    patient_religious_preference = String(description='')
    patient_sex = String(description='')
    patient_size = String(description='')
    patient_weight = String(description='')
    patientid = String(description='')
    patientid_other = String(description='')
    phantom = Boolean(description='')
    phi_namespace = Integer(description='FK. ')
    phi_namespace_obj = FK(model='Namespace', description='')
    referring_physician = String(description='')
    shared_from = Integer(description='FK. ')
    shared_from_obj = FK(model='StudyShare', description='')
    size = Integer(description='')
    source = String(description='')
    source_ae_title = String(description='')
    storage_namespace = Integer(description='FK. ')
    storage_namespace_obj = FK(model='Namespace', description='')
    storage_state = String(description='')
    study_date = String(description='')
    study_description = String(description='')
    study_status = String(description='')
    study_time = String(description='')
    study_uid = String(description='')
    thin = Boolean(description='')
    created = DateTime(description='')
    created_by = Integer(description='FK. ')
    created_by_obj = FK(model='User', description='')
    updated = DateTime(description='')
    updated_by = Integer(description='FK. ')
    updated_by_obj = FK(model='User', description='')


    def __init__(
        self,
	*,
        id=None,
        uuid=None,
        accession_number=None,
        attachment_count=None,
        callback_url=None,
        compressed_size=None,
        customfields=None,
        deleted=None,
        deleted_by=None,
        deleted_by_obj=None,
        destination_ae_title=None,
        engine_id=None,
        engine=None,
        image_count=None,
        integration_key=None,
        medical_record_locator=None,
        modality=None,
        must_approve=None,
        node_id=None,
        node=None,
        patient_additional_history=None,
        patient_address=None,
        patient_age=None,
        patient_birth_date=None,
        patient_birth_time=None,
        patient_birthname=None,
        patient_comments=None,
        patient_current_location=None,
        patient_ethnic_group=None,
        patient_institution_residence=None,
        patient_mother_birthname=None,
        patient_name=None,
        patient_name_other=None,
        patient_occupation=None,
        patient_phone=None,
        patient_religious_preference=None,
        patient_sex=None,
        patient_size=None,
        patient_weight=None,
        patientid=None,
        patientid_other=None,
        phantom=None,
        phi_namespace=None,
        phi_namespace_obj=None,
        referring_physician=None,
        shared_from=None,
        shared_from_obj=None,
        size=None,
        source=None,
        source_ae_title=None,
        storage_namespace=None,
        storage_namespace_obj=None,
        storage_state=None,
        study_date=None,
        study_description=None,
        study_status=None,
        study_time=None,
        study_uid=None,
        thin=None,
        created=None,
        created_by=None,
        created_by_obj=None,
        updated=None,
        updated_by=None,
        updated_by_obj=None,
    ):
        self.id = id
        self.uuid = uuid
        self.accession_number = accession_number
        self.attachment_count = attachment_count
        self.callback_url = callback_url
        self.compressed_size = compressed_size
        self.customfields = customfields
        self.deleted = deleted
        self.deleted_by = deleted_by
        self.deleted_by_obj = deleted_by_obj
        self.destination_ae_title = destination_ae_title
        self.engine_id = engine_id
        self.engine = engine
        self.image_count = image_count
        self.integration_key = integration_key
        self.medical_record_locator = medical_record_locator
        self.modality = modality
        self.must_approve = must_approve
        self.node_id = node_id
        self.node = node
        self.patient_additional_history = patient_additional_history
        self.patient_address = patient_address
        self.patient_age = patient_age
        self.patient_birth_date = patient_birth_date
        self.patient_birth_time = patient_birth_time
        self.patient_birthname = patient_birthname
        self.patient_comments = patient_comments
        self.patient_current_location = patient_current_location
        self.patient_ethnic_group = patient_ethnic_group
        self.patient_institution_residence = patient_institution_residence
        self.patient_mother_birthname = patient_mother_birthname
        self.patient_name = patient_name
        self.patient_name_other = patient_name_other
        self.patient_occupation = patient_occupation
        self.patient_phone = patient_phone
        self.patient_religious_preference = patient_religious_preference
        self.patient_sex = patient_sex
        self.patient_size = patient_size
        self.patient_weight = patient_weight
        self.patientid = patientid
        self.patientid_other = patientid_other
        self.phantom = phantom
        self.phi_namespace = phi_namespace
        self.phi_namespace_obj = phi_namespace_obj
        self.referring_physician = referring_physician
        self.shared_from = shared_from
        self.shared_from_obj = shared_from_obj
        self.size = size
        self.source = source
        self.source_ae_title = source_ae_title
        self.storage_namespace = storage_namespace
        self.storage_namespace_obj = storage_namespace_obj
        self.storage_state = storage_state
        self.study_date = study_date
        self.study_description = study_description
        self.study_status = study_status
        self.study_time = study_time
        self.study_uid = study_uid
        self.thin = thin
        self.created = created
        self.created_by = created_by
        self.created_by_obj = created_by_obj
        self.updated = updated
        self.updated_by = updated_by
        self.updated_by_obj = updated_by_obj



class StudyFetch(BaseModel):
    """StudyFetch."""
    
    id = Integer(description='Primary key for internal use')
    uuid = String(description='UUID for external use')
    accession_number = String(description='The accession number to fetch')
    destination_id = Integer(description='FK. The destination')
    destination = FK(model='Destination', description='The destination')
    node_id = Integer(description='FK. The node to use')
    node = FK(model='Node', description='The node to use')
    patientid = String(description='Extra data to scope the fetch down further')
    pickup = DateTime(description='When was this picked up by the node')
    source = String(description='How was the study fetch trigger, &#39;H&#39;l7 or &#39;O&#39;ther')
    status = String(description='Status of the delivery')
    study_id = Integer(description='FK. Study id if this is for a thin study')
    study = FK(model='Study', description='Study id if this is for a thin study')
    study_uid = String(description='Extra data to scope the fetch down further')
    created = DateTime(description='Timestamp when the record was created')
    created_by = Integer(description='FK. ID of the user who created the record')
    created_by_obj = FK(model='User', description='ID of the user who created the record')
    updated = DateTime(description='Timestamp when the record was last updated')
    updated_by = Integer(description='FK. ID of the user who updated the record')
    updated_by_obj = FK(model='User', description='ID of the user who updated the record')


    def __init__(
        self,
	*,
        id=None,
        uuid=None,
        accession_number=None,
        destination_id=None,
        destination=None,
        node_id=None,
        node=None,
        patientid=None,
        pickup=None,
        source=None,
        status=None,
        study_id=None,
        study=None,
        study_uid=None,
        created=None,
        created_by=None,
        created_by_obj=None,
        updated=None,
        updated_by=None,
        updated_by_obj=None,
    ):
        self.id = id
        self.uuid = uuid
        self.accession_number = accession_number
        self.destination_id = destination_id
        self.destination = destination
        self.node_id = node_id
        self.node = node
        self.patientid = patientid
        self.pickup = pickup
        self.source = source
        self.status = status
        self.study_id = study_id
        self.study = study
        self.study_uid = study_uid
        self.created = created
        self.created_by = created_by
        self.created_by_obj = created_by_obj
        self.updated = updated
        self.updated_by = updated_by
        self.updated_by_obj = updated_by_obj



class StudyHl7(BaseModel):
    """StudyHl7."""
    
    id = Integer(description='Primary key for internal use')
    uuid = String(description='UUID for external use')
    ack = String(description='The returned ACK message')
    destination_id = Integer(description='FK. The destination')
    destination = FK(model='Destination', description='The destination')
    hl7_id = Integer(description='FK. The study or hl7 id to use')
    hl7 = FK(model='Hl7', description='The study or hl7 id to use')
    hl7_template_hl7_id = Integer(description='FK. HL7 template and associated hl7 message to use in the template')
    hl7_template_hl7 = FK(model='Hl7Template', description='HL7 template and associated hl7 message to use in the template')
    hl7_template_id = Integer(description='FK. HL7 template and associated hl7 message to use in the template')
    hl7_template = FK(model='Hl7Template', description='HL7 template and associated hl7 message to use in the template')
    node_id = Integer(description='FK. The node to use')
    node = FK(model='Node', description='The node to use')
    pickup = DateTime(description='When was this picked up by the node')
    status = String(description='Status of the delivery')
    status_reason = String(description='Status of the delivery')
    study_id = Integer(description='FK. The study or hl7 id to use')
    study = FK(model='Study', description='The study or hl7 id to use')
    created = DateTime(description='Timestamp when the record was created')
    created_by = Integer(description='FK. ID of the user who created the record')
    created_by_obj = FK(model='User', description='ID of the user who created the record')
    updated = DateTime(description='Timestamp when the record was last updated')
    updated_by = Integer(description='FK. ID of the user who updated the record')
    updated_by_obj = FK(model='User', description='ID of the user who updated the record')


    def __init__(
        self,
	*,
        id=None,
        uuid=None,
        ack=None,
        destination_id=None,
        destination=None,
        hl7_id=None,
        hl7=None,
        hl7_template_hl7_id=None,
        hl7_template_hl7=None,
        hl7_template_id=None,
        hl7_template=None,
        node_id=None,
        node=None,
        pickup=None,
        status=None,
        status_reason=None,
        study_id=None,
        study=None,
        created=None,
        created_by=None,
        created_by_obj=None,
        updated=None,
        updated_by=None,
        updated_by_obj=None,
    ):
        self.id = id
        self.uuid = uuid
        self.ack = ack
        self.destination_id = destination_id
        self.destination = destination
        self.hl7_id = hl7_id
        self.hl7 = hl7
        self.hl7_template_hl7_id = hl7_template_hl7_id
        self.hl7_template_hl7 = hl7_template_hl7
        self.hl7_template_id = hl7_template_id
        self.hl7_template = hl7_template
        self.node_id = node_id
        self.node = node
        self.pickup = pickup
        self.status = status
        self.status_reason = status_reason
        self.study_id = study_id
        self.study = study
        self.created = created
        self.created_by = created_by
        self.created_by_obj = created_by_obj
        self.updated = updated
        self.updated_by = updated_by
        self.updated_by_obj = updated_by_obj



class StudyNotReady(BaseModel):
    """StudyNotReady."""
    
    id = Integer(description='Primary key for internal use')
    phi_namespace = Integer(description='FK. Primary key for internal use')
    phi_namespace_obj = FK(model='Namespace', description='Primary key for internal use')
    study_id = Integer(description='FK. Primary key for internal use')
    study = FK(model='Study', description='Primary key for internal use')


    def __init__(
        self,
	*,
        id=None,
        phi_namespace=None,
        phi_namespace_obj=None,
        study_id=None,
        study=None,
    ):
        self.id = id
        self.phi_namespace = phi_namespace
        self.phi_namespace_obj = phi_namespace_obj
        self.study_id = study_id
        self.study = study



class StudyPhi(BaseModel):
    """StudyPhi."""
    
    id = Integer(description='Primary key for internal use')
    uuid = String(description='UUID for external use')
    customfields = DictField(description='The PHI override in DICOM tag=&gt;value format. We name this customfields so we get the merging at save')
    extended = String(description='The extended PHI attributes')
    study_id = Integer(description='FK. The study id')
    study = FK(model='Study', description='The study id')
    created = DateTime(description='Timestamp when the record was created')
    created_by = Integer(description='FK. ID of the user who created the record')
    created_by_obj = FK(model='User', description='ID of the user who created the record')
    updated = DateTime(description='Timestamp when the record was last updated')
    updated_by = Integer(description='FK. ID of the user who updated the record')
    updated_by_obj = FK(model='User', description='ID of the user who updated the record')


    def __init__(
        self,
	*,
        id=None,
        uuid=None,
        customfields=None,
        extended=None,
        study_id=None,
        study=None,
        created=None,
        created_by=None,
        created_by_obj=None,
        updated=None,
        updated_by=None,
        updated_by_obj=None,
    ):
        self.id = id
        self.uuid = uuid
        self.customfields = customfields
        self.extended = extended
        self.study_id = study_id
        self.study = study
        self.created = created
        self.created_by = created_by
        self.created_by_obj = created_by_obj
        self.updated = updated
        self.updated_by = updated_by
        self.updated_by_obj = updated_by_obj



class StudyPush(BaseModel):
    """StudyPush."""
    
    id = Integer(description='Primary key for internal use')
    uuid = String(description='UUID for external use')
    destination_id = Integer(description='FK. The destination')
    destination = FK(model='Destination', description='The destination')
    detail = String(description='Additional detail to send to the node')
    image_count = Integer(description='The image count when the study was pushed')
    is_local = Boolean(description='Is this push local?')
    node_id = Integer(description='FK. The node to use')
    node = FK(model='Node', description='The node to use')
    pending = Integer(description='Counter for pending deliveries needed')
    pickup = DateTime(description='When was this picked up by the node')
    status = String(description='Status of the delivery')
    status_reason = String(description='Status of the delivery')
    study_id = Integer(description='FK. The study to push')
    study = FK(model='Study', description='The study to push')
    created = DateTime(description='Timestamp when the record was created')
    created_by = Integer(description='FK. ID of the user who created the record')
    created_by_obj = FK(model='User', description='ID of the user who created the record')
    updated = DateTime(description='Timestamp when the record was last updated')
    updated_by = Integer(description='FK. ID of the user who updated the record')
    updated_by_obj = FK(model='User', description='ID of the user who updated the record')


    def __init__(
        self,
	*,
        id=None,
        uuid=None,
        destination_id=None,
        destination=None,
        detail=None,
        image_count=None,
        is_local=None,
        node_id=None,
        node=None,
        pending=None,
        pickup=None,
        status=None,
        status_reason=None,
        study_id=None,
        study=None,
        created=None,
        created_by=None,
        created_by_obj=None,
        updated=None,
        updated_by=None,
        updated_by_obj=None,
    ):
        self.id = id
        self.uuid = uuid
        self.destination_id = destination_id
        self.destination = destination
        self.detail = detail
        self.image_count = image_count
        self.is_local = is_local
        self.node_id = node_id
        self.node = node
        self.pending = pending
        self.pickup = pickup
        self.status = status
        self.status_reason = status_reason
        self.study_id = study_id
        self.study = study
        self.created = created
        self.created_by = created_by
        self.created_by_obj = created_by_obj
        self.updated = updated
        self.updated_by = updated_by
        self.updated_by_obj = updated_by_obj



class StudyPushStatus(BaseModel):
    """StudyPushStatus."""
    
    id = Integer(description='Primary key for internal use')
    uuid = String(description='UUID for external use')
    destination_id = Integer(description='FK. The destination')
    destination = FK(model='Destination', description='The destination')
    phi_namespace = Integer(description='FK. PHI namespace to allow for scoping the filter down')
    phi_namespace_obj = FK(model='Namespace', description='PHI namespace to allow for scoping the filter down')
    status = String(description='Current status - pe&#39;N&#39;ding, &#39;I&#39;n-process, &#39;P&#39;artial, &#39;S&#39;uccess, &#39;F&#39;ailure')
    status_reason = String(description='Current status - pe&#39;N&#39;ding, &#39;I&#39;n-process, &#39;P&#39;artial, &#39;S&#39;uccess, &#39;F&#39;ailure')
    study_id = Integer(description='FK. The study')
    study = FK(model='Study', description='The study')
    study_push_id = Integer(description='FK. The latest push')
    study_push = FK(model='StudyPush', description='The latest push')
    created = DateTime(description='Timestamp when the record was created')
    created_by = Integer(description='FK. ID of the user who created the record')
    created_by_obj = FK(model='User', description='ID of the user who created the record')
    updated = DateTime(description='Timestamp when the record was last updated')
    updated_by = Integer(description='FK. ID of the user who updated the record')
    updated_by_obj = FK(model='User', description='ID of the user who updated the record')


    def __init__(
        self,
	*,
        id=None,
        uuid=None,
        destination_id=None,
        destination=None,
        phi_namespace=None,
        phi_namespace_obj=None,
        status=None,
        status_reason=None,
        study_id=None,
        study=None,
        study_push_id=None,
        study_push=None,
        created=None,
        created_by=None,
        created_by_obj=None,
        updated=None,
        updated_by=None,
        updated_by_obj=None,
    ):
        self.id = id
        self.uuid = uuid
        self.destination_id = destination_id
        self.destination = destination
        self.phi_namespace = phi_namespace
        self.phi_namespace_obj = phi_namespace_obj
        self.status = status
        self.status_reason = status_reason
        self.study_id = study_id
        self.study = study
        self.study_push_id = study_push_id
        self.study_push = study_push
        self.created = created
        self.created_by = created_by
        self.created_by_obj = created_by_obj
        self.updated = updated
        self.updated_by = updated_by
        self.updated_by_obj = updated_by_obj



class StudyQuestion(BaseModel):
    """StudyQuestion."""
    
    id = Integer(description='Primary key for internal use')
    uuid = String(description='UUID for external use')
    account_id = Integer(description='FK. The study and account id')
    account = FK(model='Account', description='The study and account id')
    answer = String(description='Question and answer')
    answered = DateTime(description='When was this picked up and answered by the ai stack')
    detail = String(description='Question and answer')
    next_question = Integer(description='Id of the next question to ask when this one is answered')
    pickup = DateTime(description='When was this picked up and answered by the ai stack')
    question = String(description='Question and answer')
    raw_answer = String(description='Question and answer')
    study_id = Integer(description='FK. The study and account id')
    study = FK(model='Study', description='The study and account id')
    created = DateTime(description='Timestamp when the record was created')
    created_by = Integer(description='FK. ID of the user who created the record')
    created_by_obj = FK(model='User', description='ID of the user who created the record')
    updated = DateTime(description='Timestamp when the record was last updated')
    updated_by = Integer(description='FK. ID of the user who updated the record')
    updated_by_obj = FK(model='User', description='ID of the user who updated the record')


    def __init__(
        self,
	*,
        id=None,
        uuid=None,
        account_id=None,
        account=None,
        answer=None,
        answered=None,
        detail=None,
        next_question=None,
        pickup=None,
        question=None,
        raw_answer=None,
        study_id=None,
        study=None,
        created=None,
        created_by=None,
        created_by_obj=None,
        updated=None,
        updated_by=None,
        updated_by_obj=None,
    ):
        self.id = id
        self.uuid = uuid
        self.account_id = account_id
        self.account = account
        self.answer = answer
        self.answered = answered
        self.detail = detail
        self.next_question = next_question
        self.pickup = pickup
        self.question = question
        self.raw_answer = raw_answer
        self.study_id = study_id
        self.study = study
        self.created = created
        self.created_by = created_by
        self.created_by_obj = created_by_obj
        self.updated = updated
        self.updated_by = updated_by
        self.updated_by_obj = updated_by_obj



class StudyShare(BaseModel):
    """StudyShare."""
    
    id = Integer(description='Primary key for internal use')
    account_id = Integer(description='FK. Who it is shared with')
    account = FK(model='Account', description='Who it is shared with')
    group_id = Integer(description='FK. Who it is shared with')
    group = FK(model='Group', description='Who it is shared with')
    location_id = Integer(description='FK. Who it is shared with')
    location = FK(model='Location', description='Who it is shared with')
    message = String(description='Share message')
    new_study_id = Integer(description='FK. Id of the new study created by the share')
    new_study = FK(model='Study', description='Id of the new study created by the share')
    study_id = Integer(description='FK. Primary key for internal use')
    study = FK(model='Study', description='Primary key for internal use')
    user_id = Integer(description='FK. Who it is shared with')
    user = FK(model='User', description='Who it is shared with')
    created = DateTime(description='Timestamp when the record was created')
    created_by = Integer(description='FK. ID of the user who created the record')
    created_by_obj = FK(model='User', description='ID of the user who created the record')
    updated = DateTime(description='Timestamp when the record was last updated')
    updated_by = Integer(description='FK. ID of the user who updated the record')
    updated_by_obj = FK(model='User', description='ID of the user who updated the record')


    def __init__(
        self,
	*,
        id=None,
        account_id=None,
        account=None,
        group_id=None,
        group=None,
        location_id=None,
        location=None,
        message=None,
        new_study_id=None,
        new_study=None,
        study_id=None,
        study=None,
        user_id=None,
        user=None,
        created=None,
        created_by=None,
        created_by_obj=None,
        updated=None,
        updated_by=None,
        updated_by_obj=None,
    ):
        self.id = id
        self.account_id = account_id
        self.account = account
        self.group_id = group_id
        self.group = group
        self.location_id = location_id
        self.location = location
        self.message = message
        self.new_study_id = new_study_id
        self.new_study = new_study
        self.study_id = study_id
        self.study = study
        self.user_id = user_id
        self.user = user
        self.created = created
        self.created_by = created_by
        self.created_by_obj = created_by_obj
        self.updated = updated
        self.updated_by = updated_by
        self.updated_by_obj = updated_by_obj



class StudyShareAi(BaseModel):
    """StudyShareAi."""
    
    id = Integer(description='Primary key for internal use')
    uuid = String(description='UUID for external use')
    account_id = Integer(description='FK. UUID for external use')
    account = FK(model='Account', description='UUID for external use')
    from_account_id = Integer(description='FK. Id and account of the study it was shared from')
    from_account = FK(model='Account', description='Id and account of the study it was shared from')
    from_study_id = Integer(description='FK. Id and account of the study it was shared from')
    from_study = FK(model='Study', description='Id and account of the study it was shared from')
    study_id = Integer(description='FK. UUID for external use')
    study = FK(model='Study', description='UUID for external use')
    created = DateTime(description='Timestamp when the record was created')
    created_by = Integer(description='FK. ID of the user who created the record')
    created_by_obj = FK(model='User', description='ID of the user who created the record')
    updated = DateTime(description='Timestamp when the record was last updated')
    updated_by = Integer(description='FK. ID of the user who updated the record')
    updated_by_obj = FK(model='User', description='ID of the user who updated the record')


    def __init__(
        self,
	*,
        id=None,
        uuid=None,
        account_id=None,
        account=None,
        from_account_id=None,
        from_account=None,
        from_study_id=None,
        from_study=None,
        study_id=None,
        study=None,
        created=None,
        created_by=None,
        created_by_obj=None,
        updated=None,
        updated_by=None,
        updated_by_obj=None,
    ):
        self.id = id
        self.uuid = uuid
        self.account_id = account_id
        self.account = account
        self.from_account_id = from_account_id
        self.from_account = from_account
        self.from_study_id = from_study_id
        self.from_study = from_study
        self.study_id = study_id
        self.study = study
        self.created = created
        self.created_by = created_by
        self.created_by_obj = created_by_obj
        self.updated = updated
        self.updated_by = updated_by
        self.updated_by_obj = updated_by_obj



class StudyShareRsna(BaseModel):
    """StudyShareRsna."""
    
    id = Integer(description='Primary key for internal use')
    uuid = String(description='UUID for external use')
    exam_id = String(description='The PIN and Exam id')
    pin = String(description='The PIN and Exam id')
    reason = String(description='Reason the delivery failed')
    status = String(description='Status of the delivery')
    study_id = Integer(description='FK. The study shared')
    study = FK(model='Study', description='The study shared')
    created = DateTime(description='Timestamp when the record was created')
    created_by = Integer(description='FK. ID of the user who created the record')
    created_by_obj = FK(model='User', description='ID of the user who created the record')
    updated = DateTime(description='Timestamp when the record was last updated')
    updated_by = Integer(description='FK. ID of the user who updated the record')
    updated_by_obj = FK(model='User', description='ID of the user who updated the record')


    def __init__(
        self,
	*,
        id=None,
        uuid=None,
        exam_id=None,
        pin=None,
        reason=None,
        status=None,
        study_id=None,
        study=None,
        created=None,
        created_by=None,
        created_by_obj=None,
        updated=None,
        updated_by=None,
        updated_by_obj=None,
    ):
        self.id = id
        self.uuid = uuid
        self.exam_id = exam_id
        self.pin = pin
        self.reason = reason
        self.status = status
        self.study_id = study_id
        self.study = study
        self.created = created
        self.created_by = created_by
        self.created_by_obj = created_by_obj
        self.updated = updated
        self.updated_by = updated_by
        self.updated_by_obj = updated_by_obj



class StudyStar(BaseModel):
    """StudyStar."""
    
    id = Integer(description='Primary key for internal use')
    star = Boolean(description='The study star')
    study_id = Integer(description='FK. ')
    study = FK(model='Study', description='')
    user_id = Integer(description='FK. ')
    user = FK(model='User', description='')
    created = DateTime(description='Timestamp when the record was created')
    created_by = Integer(description='FK. ID of the user who created the record')
    created_by_obj = FK(model='User', description='ID of the user who created the record')
    updated = DateTime(description='Timestamp when the record was last updated')
    updated_by = Integer(description='FK. ID of the user who updated the record')
    updated_by_obj = FK(model='User', description='ID of the user who updated the record')


    def __init__(
        self,
	*,
        id=None,
        star=None,
        study_id=None,
        study=None,
        user_id=None,
        user=None,
        created=None,
        created_by=None,
        created_by_obj=None,
        updated=None,
        updated_by=None,
        updated_by_obj=None,
    ):
        self.id = id
        self.star = star
        self.study_id = study_id
        self.study = study
        self.user_id = user_id
        self.user = user
        self.created = created
        self.created_by = created_by
        self.created_by_obj = created_by_obj
        self.updated = updated
        self.updated_by = updated_by
        self.updated_by_obj = updated_by_obj



class StudyStatusLock(BaseModel):
    """StudyStatusLock."""
    
    id = Integer(description='Primary key for internal use')
    uuid = String(description='UUID for external use')
    study_id = Integer(description='FK. The study and user id')
    study = FK(model='Study', description='The study and user id')
    user_id = Integer(description='FK. The study and user id')
    user = FK(model='User', description='The study and user id')
    created = DateTime(description='Timestamp when the record was created')
    created_by = Integer(description='FK. ID of the user who created the record')
    created_by_obj = FK(model='User', description='ID of the user who created the record')
    updated = DateTime(description='Timestamp when the record was last updated')
    updated_by = Integer(description='FK. ID of the user who updated the record')
    updated_by_obj = FK(model='User', description='ID of the user who updated the record')


    def __init__(
        self,
	*,
        id=None,
        uuid=None,
        study_id=None,
        study=None,
        user_id=None,
        user=None,
        created=None,
        created_by=None,
        created_by_obj=None,
        updated=None,
        updated_by=None,
        updated_by_obj=None,
    ):
        self.id = id
        self.uuid = uuid
        self.study_id = study_id
        self.study = study
        self.user_id = user_id
        self.user = user
        self.created = created
        self.created_by = created_by
        self.created_by_obj = created_by_obj
        self.updated = updated
        self.updated_by = updated_by
        self.updated_by_obj = updated_by_obj



class StudyTiming(BaseModel):
    """StudyTiming."""
    
    id = Integer(description='Primary key for internal use')
    event = String(description='The event')
    node_id = Integer(description='FK. Node id')
    node = FK(model='Node', description='Node id')
    size = Integer(description='The event')
    storage_namespace = Integer(description='FK. The study uid and storage namespace')
    storage_namespace_obj = FK(model='Namespace', description='The study uid and storage namespace')
    study_uid = String(description='The study uid and storage namespace')
    created = DateTime(description='Timestamp when the record was created')
    created_by = Integer(description='FK. ID of the user who created the record')
    created_by_obj = FK(model='User', description='ID of the user who created the record')


    def __init__(
        self,
	*,
        id=None,
        event=None,
        node_id=None,
        node=None,
        size=None,
        storage_namespace=None,
        storage_namespace_obj=None,
        study_uid=None,
        created=None,
        created_by=None,
        created_by_obj=None,
    ):
        self.id = id
        self.event = event
        self.node_id = node_id
        self.node = node
        self.size = size
        self.storage_namespace = storage_namespace
        self.storage_namespace_obj = storage_namespace_obj
        self.study_uid = study_uid
        self.created = created
        self.created_by = created_by
        self.created_by_obj = created_by_obj



class System(BaseModel):
    """System."""
    
    id = Integer(description='Primary key for internal use')
    ai_password = String(description='AI stack basic auth credentials')
    ai_username = String(description='AI stack basic auth credentials')
    archive = DictField(description='The archive settings')
    athena_pk = String(description='Athena key and secret')
    athena_sk = String(description='Athena key and secret')
    aws_pk = String(description='AWS information')
    aws_region = String(description='AWS information')
    aws_sk = String(description='AWS information')
    cache = Boolean(description='Cache new studies images')
    captcha_pk = String(description='Captcha public key')
    captcha_sk = String(description='Captcha secret key')
    database_version = Integer(description='Database version')
    drchrono_client_id = String(description='Drchrono information')
    drchrono_client_secret = String(description='Drchrono information')
    drchrono_redirect_uri = String(description='Drchrono information')
    email_from = String(description='From email address and name')
    email_from_name = String(description='From email address and name')
    email_validation = Boolean(description='Flag to enable email validation')
    enhanced_security = Boolean(description='Enable enhanced security')
    global_purge = Boolean(description='Flag to enable global purge rule support')
    google_client_id = String(description='Google information')
    google_client_secret = String(description='Google information')
    google_service_account = String(description='Google information')
    hide_help_tool = Boolean(description='Flag to hide the help tool globally')
    indicator_html = String(description='HTML for the terms of use, privacy policy and indicators of use')
    indicator_md5 = String(description='MD5 sums of the terms of use, privacy policy and indicators of use')
    log_days = Integer(description='Number of days to retain logs for')
    passwdqc = String(description='Password controls')
    passwdqc_description = String(description='Password controls')
    phr_permissions = String(description='The PHR  permissions over-ride')
    privacy_html = String(description='HTML for the terms of use, privacy policy and indicators of use')
    privacy_md5 = String(description='MD5 sums of the terms of use, privacy policy and indicators of use')
    rsna_xds = String(description='RSNA XDS server')
    stripe_ca = String(description='Stripe connect client id')
    stripe_pk = String(description='Stripe public key')
    stripe_sk = String(description='Stripe secret key')
    stripe_uri = String(description='Stripe URI')
    terms_html = String(description='HTML for the terms of use, privacy policy and indicators of use')
    terms_md5 = String(description='MD5 sums of the terms of use, privacy policy and indicators of use')
    twilio_from = String(description='Twilio key, secret and from phone number')
    twilio_pk = String(description='Twilio key, secret and from phone number')
    twilio_sk = String(description='Twilio key, secret and from phone number')
    user_settings = DictField(description='Default user settings')
    watchdog_host = String(description='Watch dog host, used if not set in site.conf')
    websocket_domain = String(description='Websocket domain')
    created = DateTime(description='Timestamp when the record was created')
    created_by = Integer(description='FK. ID of the user who created the record')
    created_by_obj = FK(model='User', description='ID of the user who created the record')
    updated = DateTime(description='Timestamp when the record was last updated')
    updated_by = Integer(description='FK. ID of the user who updated the record')
    updated_by_obj = FK(model='User', description='ID of the user who updated the record')


    def __init__(
        self,
	*,
        id=None,
        ai_password=None,
        ai_username=None,
        archive=None,
        athena_pk=None,
        athena_sk=None,
        aws_pk=None,
        aws_region=None,
        aws_sk=None,
        cache=None,
        captcha_pk=None,
        captcha_sk=None,
        database_version=None,
        drchrono_client_id=None,
        drchrono_client_secret=None,
        drchrono_redirect_uri=None,
        email_from=None,
        email_from_name=None,
        email_validation=None,
        enhanced_security=None,
        global_purge=None,
        google_client_id=None,
        google_client_secret=None,
        google_service_account=None,
        hide_help_tool=None,
        indicator_html=None,
        indicator_md5=None,
        log_days=None,
        passwdqc=None,
        passwdqc_description=None,
        phr_permissions=None,
        privacy_html=None,
        privacy_md5=None,
        rsna_xds=None,
        stripe_ca=None,
        stripe_pk=None,
        stripe_sk=None,
        stripe_uri=None,
        terms_html=None,
        terms_md5=None,
        twilio_from=None,
        twilio_pk=None,
        twilio_sk=None,
        user_settings=None,
        watchdog_host=None,
        websocket_domain=None,
        created=None,
        created_by=None,
        created_by_obj=None,
        updated=None,
        updated_by=None,
        updated_by_obj=None,
    ):
        self.id = id
        self.ai_password = ai_password
        self.ai_username = ai_username
        self.archive = archive
        self.athena_pk = athena_pk
        self.athena_sk = athena_sk
        self.aws_pk = aws_pk
        self.aws_region = aws_region
        self.aws_sk = aws_sk
        self.cache = cache
        self.captcha_pk = captcha_pk
        self.captcha_sk = captcha_sk
        self.database_version = database_version
        self.drchrono_client_id = drchrono_client_id
        self.drchrono_client_secret = drchrono_client_secret
        self.drchrono_redirect_uri = drchrono_redirect_uri
        self.email_from = email_from
        self.email_from_name = email_from_name
        self.email_validation = email_validation
        self.enhanced_security = enhanced_security
        self.global_purge = global_purge
        self.google_client_id = google_client_id
        self.google_client_secret = google_client_secret
        self.google_service_account = google_service_account
        self.hide_help_tool = hide_help_tool
        self.indicator_html = indicator_html
        self.indicator_md5 = indicator_md5
        self.log_days = log_days
        self.passwdqc = passwdqc
        self.passwdqc_description = passwdqc_description
        self.phr_permissions = phr_permissions
        self.privacy_html = privacy_html
        self.privacy_md5 = privacy_md5
        self.rsna_xds = rsna_xds
        self.stripe_ca = stripe_ca
        self.stripe_pk = stripe_pk
        self.stripe_sk = stripe_sk
        self.stripe_uri = stripe_uri
        self.terms_html = terms_html
        self.terms_md5 = terms_md5
        self.twilio_from = twilio_from
        self.twilio_pk = twilio_pk
        self.twilio_sk = twilio_sk
        self.user_settings = user_settings
        self.watchdog_host = watchdog_host
        self.websocket_domain = websocket_domain
        self.created = created
        self.created_by = created_by
        self.created_by_obj = created_by_obj
        self.updated = updated
        self.updated_by = updated_by
        self.updated_by_obj = updated_by_obj



class Tag(BaseModel):
    """Tag."""
    
    id = Integer(description='Primary key for internal use')
    uuid = String(description='UUID for external use')
    object = String(description='The associated user and object class')
    tag = String(description='The tag')
    user_id = Integer(description='FK. The associated user and object class')
    user = FK(model='User', description='The associated user and object class')
    created = DateTime(description='Timestamp when the record was created')
    created_by = Integer(description='FK. ID of the user who created the record')
    created_by_obj = FK(model='User', description='ID of the user who created the record')
    updated = DateTime(description='Timestamp when the record was last updated')
    updated_by = Integer(description='FK. ID of the user who updated the record')
    updated_by_obj = FK(model='User', description='ID of the user who updated the record')


    def __init__(
        self,
	*,
        id=None,
        uuid=None,
        object=None,
        tag=None,
        user_id=None,
        user=None,
        created=None,
        created_by=None,
        created_by_obj=None,
        updated=None,
        updated_by=None,
        updated_by_obj=None,
    ):
        self.id = id
        self.uuid = uuid
        self.object = object
        self.tag = tag
        self.user_id = user_id
        self.user = user
        self.created = created
        self.created_by = created_by
        self.created_by_obj = created_by_obj
        self.updated = updated
        self.updated_by = updated_by
        self.updated_by_obj = updated_by_obj



class TagObject(BaseModel):
    """TagObject."""
    
    id = Integer(description='Primary key for internal use')
    uuid = String(description='UUID for external use')
    object = String(description='The user and object fields')
    object_id = Integer(description='FK. The user and object fields')
    tags = DictField(description='The tags')
    user_id = Integer(description='FK. The user and object fields')
    user = FK(model='User', description='The user and object fields')
    created = DateTime(description='Timestamp when the record was created')
    created_by = Integer(description='FK. ID of the user who created the record')
    created_by_obj = FK(model='User', description='ID of the user who created the record')
    updated = DateTime(description='Timestamp when the record was last updated')
    updated_by = Integer(description='FK. ID of the user who updated the record')
    updated_by_obj = FK(model='User', description='ID of the user who updated the record')


    def __init__(
        self,
	*,
        id=None,
        uuid=None,
        object=None,
        object_id=None,
        tags=None,
        user_id=None,
        user=None,
        created=None,
        created_by=None,
        created_by_obj=None,
        updated=None,
        updated_by=None,
        updated_by_obj=None,
    ):
        self.id = id
        self.uuid = uuid
        self.object = object
        self.object_id = object_id
        self.tags = tags
        self.user_id = user_id
        self.user = user
        self.created = created
        self.created_by = created_by
        self.created_by_obj = created_by_obj
        self.updated = updated
        self.updated_by = updated_by
        self.updated_by_obj = updated_by_obj



class TemplateAssign(BaseModel):
    """TemplateAssign."""
    
    id = Integer(description='Primary key for internal use')
    uuid = String(description='UUID for external use')
    account_id = Integer(description='FK. Account the template is for')
    account = FK(model='Account', description='Account the template is for')
    name = String(description='Template name, this is the directory name for the template')
    version = String(description='Version, this is the file name to serve')
    created = DateTime(description='Timestamp when the record was created')
    created_by = Integer(description='FK. ID of the user who created the record')
    created_by_obj = FK(model='User', description='ID of the user who created the record')
    updated = DateTime(description='Timestamp when the record was last updated')
    updated_by = Integer(description='FK. ID of the user who updated the record')
    updated_by_obj = FK(model='User', description='ID of the user who updated the record')


    def __init__(
        self,
	*,
        id=None,
        uuid=None,
        account_id=None,
        account=None,
        name=None,
        version=None,
        created=None,
        created_by=None,
        created_by_obj=None,
        updated=None,
        updated_by=None,
        updated_by_obj=None,
    ):
        self.id = id
        self.uuid = uuid
        self.account_id = account_id
        self.account = account
        self.name = name
        self.version = version
        self.created = created
        self.created_by = created_by
        self.created_by_obj = created_by_obj
        self.updated = updated
        self.updated_by = updated_by
        self.updated_by_obj = updated_by_obj



class Terminology(BaseModel):
    """Terminology."""
    
    id = Integer(description='Primary key for internal use')
    uuid = String(description='UUID for external use')
    account_id = Integer(description='FK. Account id if we have an over ride')
    account = FK(model='Account', description='Account id if we have an over ride')
    language = String(description='ISO 639-1 code of the language')
    tag = String(description='Dynamic tag')
    value = String(description='The translated value')
    vanity = String(description='Vanity override')
    created = DateTime(description='Timestamp when the record was created')
    created_by = Integer(description='FK. ID of the user who created the record')
    created_by_obj = FK(model='User', description='ID of the user who created the record')
    updated = DateTime(description='Timestamp when the record was last updated')
    updated_by = Integer(description='FK. ID of the user who updated the record')
    updated_by_obj = FK(model='User', description='ID of the user who updated the record')


    def __init__(
        self,
	*,
        id=None,
        uuid=None,
        account_id=None,
        account=None,
        language=None,
        tag=None,
        value=None,
        vanity=None,
        created=None,
        created_by=None,
        created_by_obj=None,
        updated=None,
        updated_by=None,
        updated_by_obj=None,
    ):
        self.id = id
        self.uuid = uuid
        self.account_id = account_id
        self.account = account
        self.language = language
        self.tag = tag
        self.value = value
        self.vanity = vanity
        self.created = created
        self.created_by = created_by
        self.created_by_obj = created_by_obj
        self.updated = updated
        self.updated_by = updated_by
        self.updated_by_obj = updated_by_obj



class TrainingAccount(BaseModel):
    """TrainingAccount."""
    
    id = Integer(description='Primary key for internal use')
    uuid = String(description='UUID for external use')
    account_id = Integer(description='FK. ')
    account = FK(model='Account', description='')
    form_description = String(description='')
    form_number = String(description='')
    group_description = String(description='')
    group_number = Integer(description='')
    created = DateTime(description='Timestamp when the record was created')
    created_by = Integer(description='FK. ID of the user who created the record')
    created_by_obj = FK(model='User', description='ID of the user who created the record')
    updated = DateTime(description='Timestamp when the record was last updated')
    updated_by = Integer(description='FK. ID of the user who updated the record')
    updated_by_obj = FK(model='User', description='ID of the user who updated the record')


    def __init__(
        self,
	*,
        id=None,
        uuid=None,
        account_id=None,
        account=None,
        form_description=None,
        form_number=None,
        group_description=None,
        group_number=None,
        created=None,
        created_by=None,
        created_by_obj=None,
        updated=None,
        updated_by=None,
        updated_by_obj=None,
    ):
        self.id = id
        self.uuid = uuid
        self.account_id = account_id
        self.account = account
        self.form_description = form_description
        self.form_number = form_number
        self.group_description = group_description
        self.group_number = group_number
        self.created = created
        self.created_by = created_by
        self.created_by_obj = created_by_obj
        self.updated = updated
        self.updated_by = updated_by
        self.updated_by_obj = updated_by_obj



class TrainingUser(BaseModel):
    """TrainingUser."""
    
    id = Integer(description='Primary key for internal use')
    uuid = String(description='UUID for external use')
    form_number = String(description='')
    results = DictField(description='The form data from the training')
    user_id = Integer(description='FK. ')
    user = FK(model='User', description='')
    created = DateTime(description='Timestamp when the record was created')
    created_by = Integer(description='FK. ID of the user who created the record')
    created_by_obj = FK(model='User', description='ID of the user who created the record')
    updated = DateTime(description='Timestamp when the record was last updated')
    updated_by = Integer(description='FK. ID of the user who updated the record')
    updated_by_obj = FK(model='User', description='ID of the user who updated the record')


    def __init__(
        self,
	*,
        id=None,
        uuid=None,
        form_number=None,
        results=None,
        user_id=None,
        user=None,
        created=None,
        created_by=None,
        created_by_obj=None,
        updated=None,
        updated_by=None,
        updated_by_obj=None,
    ):
        self.id = id
        self.uuid = uuid
        self.form_number = form_number
        self.results = results
        self.user_id = user_id
        self.user = user
        self.created = created
        self.created_by = created_by
        self.created_by_obj = created_by_obj
        self.updated = updated
        self.updated_by = updated_by
        self.updated_by_obj = updated_by_obj



class User(BaseModel):
    """User."""
    
    id = Integer(description='Primary key for internal use')
    uuid = String(description='UUID for external use')
    access_token = String(description='Stripe access token')
    billing = Boolean(description='Are they a billing person')
    blocked = Boolean(description='Is a the user blocked from the system')
    disabled = Boolean(description='Is a the user disabled from the system')
    email = String(description='Email address')
    email_validation = Boolean(description='2 - email is validated')
    event_approve = Boolean(description='The event flags for the personal namespace')
    event_case_assignment = Boolean(description='The event flags for the personal namespace')
    event_harvest = Boolean(description='The event flags for the personal namespace')
    event_link = Boolean(description='The event flags for the personal namespace')
    event_link_mine = Boolean(description='The event flags for the personal namespace')
    event_message = Boolean(description='The event flags for the personal namespace')
    event_new_report = Boolean(description='The event flags for the personal namespace')
    event_report_remove = Boolean(description='The event flags for the personal namespace')
    event_share = Boolean(description='The event flags for the personal namespace')
    event_status_change = Boolean(description='The event flags for the personal namespace')
    event_study_comment = Boolean(description='The event flags for the personal namespace')
    event_thin_study_fail = Boolean(description='The event flags for the personal namespace')
    event_thin_study_success = Boolean(description='The event flags for the personal namespace')
    event_upload = Boolean(description='The event flags for the personal namespace')
    event_upload_fail = Boolean(description='The event flags for the personal namespace')
    first = String(description='Name')
    indicator_md5 = String(description='MD5 sums of the accepted terms of use, privacy policy and indicators of use')
    last = String(description='Name')
    last_login = DateTime(description='The last login time')
    mobile_phone = String(description='Mobile phone')
    namespace_id = Integer(description='FK. Their namespace')
    namespace = FK(model='Namespace', description='Their namespace')
    npi = String(description='NPI number')
    oauth = String(description='OAuth id and refresh token')
    password = String(description='Password')
    pin_required = Boolean(description='Is a PIN required for login')
    privacy_md5 = String(description='MD5 sums of the accepted terms of use, privacy policy and indicators of use')
    refresh_token = String(description='OAuth id and refresh token')
    signature = String(description='Signature image (base64)')
    support = Boolean(description='Are they a support person')
    sysadmin = Boolean(description='Are they a system administrator')
    terms_md5 = String(description='MD5 sums of the accepted terms of use, privacy policy and indicators of use')
    time_zone = String(description='Timezone')
    token = String(description='Shared secret for TOKEN authentication')
    ui_json = String(description='JSON for UI settings')
    created = DateTime(description='Timestamp when the record was created')
    created_by = Integer(description='FK. ID of the user who created the record')
    created_by_obj = FK(model='User', description='ID of the user who created the record')
    updated = DateTime(description='Timestamp when the record was last updated')
    updated_by = Integer(description='FK. ID of the user who updated the record')
    updated_by_obj = FK(model='User', description='ID of the user who updated the record')


    def __init__(
        self,
	*,
        id=None,
        uuid=None,
        access_token=None,
        billing=None,
        blocked=None,
        disabled=None,
        email=None,
        email_validation=None,
        event_approve=None,
        event_case_assignment=None,
        event_harvest=None,
        event_link=None,
        event_link_mine=None,
        event_message=None,
        event_new_report=None,
        event_report_remove=None,
        event_share=None,
        event_status_change=None,
        event_study_comment=None,
        event_thin_study_fail=None,
        event_thin_study_success=None,
        event_upload=None,
        event_upload_fail=None,
        first=None,
        indicator_md5=None,
        last=None,
        last_login=None,
        mobile_phone=None,
        namespace_id=None,
        namespace=None,
        npi=None,
        oauth=None,
        password=None,
        pin_required=None,
        privacy_md5=None,
        refresh_token=None,
        signature=None,
        support=None,
        sysadmin=None,
        terms_md5=None,
        time_zone=None,
        token=None,
        ui_json=None,
        created=None,
        created_by=None,
        created_by_obj=None,
        updated=None,
        updated_by=None,
        updated_by_obj=None,
    ):
        self.id = id
        self.uuid = uuid
        self.access_token = access_token
        self.billing = billing
        self.blocked = blocked
        self.disabled = disabled
        self.email = email
        self.email_validation = email_validation
        self.event_approve = event_approve
        self.event_case_assignment = event_case_assignment
        self.event_harvest = event_harvest
        self.event_link = event_link
        self.event_link_mine = event_link_mine
        self.event_message = event_message
        self.event_new_report = event_new_report
        self.event_report_remove = event_report_remove
        self.event_share = event_share
        self.event_status_change = event_status_change
        self.event_study_comment = event_study_comment
        self.event_thin_study_fail = event_thin_study_fail
        self.event_thin_study_success = event_thin_study_success
        self.event_upload = event_upload
        self.event_upload_fail = event_upload_fail
        self.first = first
        self.indicator_md5 = indicator_md5
        self.last = last
        self.last_login = last_login
        self.mobile_phone = mobile_phone
        self.namespace_id = namespace_id
        self.namespace = namespace
        self.npi = npi
        self.oauth = oauth
        self.password = password
        self.pin_required = pin_required
        self.privacy_md5 = privacy_md5
        self.refresh_token = refresh_token
        self.signature = signature
        self.support = support
        self.sysadmin = sysadmin
        self.terms_md5 = terms_md5
        self.time_zone = time_zone
        self.token = token
        self.ui_json = ui_json
        self.created = created
        self.created_by = created_by
        self.created_by_obj = created_by_obj
        self.updated = updated
        self.updated_by = updated_by
        self.updated_by_obj = updated_by_obj



class UserAccount(BaseModel):
    """UserAccount."""
    
    id = Integer(description='Primary key for internal use')
    uuid = String(description='UUID for external use')
    account_alias = String(description='The users alias for the account')
    account_email = String(description='The email for account. One needed if this is different that the users email')
    account_id = Integer(description='FK. Mapping between the user and account')
    account = FK(model='Account', description='Mapping between the user and account')
    account_login = String(description='The users login name for the account')
    account_password = String(description='The users password in the account')
    customfields = DictField(description='Custom fields')
    event_approve = Boolean(description='The event flags')
    event_case_assignment = Boolean(description='The event flags')
    event_harvest = Boolean(description='The event flags')
    event_join = Boolean(description='The event flags')
    event_link = Boolean(description='The event flags')
    event_link_mine = Boolean(description='The event flags')
    event_message = Boolean(description='The event flags')
    event_new_report = Boolean(description='The event flags')
    event_node = Boolean(description='The event flags')
    event_purge = Boolean(description='The event flags')
    event_report_remove = Boolean(description='The event flags')
    event_share = Boolean(description='The event flags')
    event_status_change = Boolean(description='The event flags')
    event_study_comment = Boolean(description='The event flags')
    event_thin_study_fail = Boolean(description='The event flags')
    event_thin_study_success = Boolean(description='The event flags')
    event_upload = Boolean(description='The event flags')
    event_upload_fail = Boolean(description='The event flags')
    global_field = Boolean(description='This user is automatically added to every group and location in the account')
    last_reset = DateTime(description='Time the password was last reset')
    max_sessions = Integer(description='Override for the max number of sessions a user can have')
    password_reset = Boolean(description='Flag to reset the password')
    role_id = Integer(description='FK. Role')
    role = FK(model='Role', description='Role')
    session_expire = Integer(description='Minutes before an idle session expires, this is an override of the account setting')
    settings = DictField(description='Account settings overrides')
    user_id = Integer(description='FK. Mapping between the user and account')
    user = FK(model='User', description='Mapping between the user and account')
    created = DateTime(description='Timestamp when the record was created')
    created_by = Integer(description='FK. ID of the user who created the record')
    created_by_obj = FK(model='User', description='ID of the user who created the record')
    updated = DateTime(description='Timestamp when the record was last updated')
    updated_by = Integer(description='FK. ID of the user who updated the record')
    updated_by_obj = FK(model='User', description='ID of the user who updated the record')


    def __init__(
        self,
	*,
        id=None,
        uuid=None,
        account_alias=None,
        account_email=None,
        account_id=None,
        account=None,
        account_login=None,
        account_password=None,
        customfields=None,
        event_approve=None,
        event_case_assignment=None,
        event_harvest=None,
        event_join=None,
        event_link=None,
        event_link_mine=None,
        event_message=None,
        event_new_report=None,
        event_node=None,
        event_purge=None,
        event_report_remove=None,
        event_share=None,
        event_status_change=None,
        event_study_comment=None,
        event_thin_study_fail=None,
        event_thin_study_success=None,
        event_upload=None,
        event_upload_fail=None,
        global_field=None,
        last_reset=None,
        max_sessions=None,
        password_reset=None,
        role_id=None,
        role=None,
        session_expire=None,
        settings=None,
        user_id=None,
        user=None,
        created=None,
        created_by=None,
        created_by_obj=None,
        updated=None,
        updated_by=None,
        updated_by_obj=None,
    ):
        self.id = id
        self.uuid = uuid
        self.account_alias = account_alias
        self.account_email = account_email
        self.account_id = account_id
        self.account = account
        self.account_login = account_login
        self.account_password = account_password
        self.customfields = customfields
        self.event_approve = event_approve
        self.event_case_assignment = event_case_assignment
        self.event_harvest = event_harvest
        self.event_join = event_join
        self.event_link = event_link
        self.event_link_mine = event_link_mine
        self.event_message = event_message
        self.event_new_report = event_new_report
        self.event_node = event_node
        self.event_purge = event_purge
        self.event_report_remove = event_report_remove
        self.event_share = event_share
        self.event_status_change = event_status_change
        self.event_study_comment = event_study_comment
        self.event_thin_study_fail = event_thin_study_fail
        self.event_thin_study_success = event_thin_study_success
        self.event_upload = event_upload
        self.event_upload_fail = event_upload_fail
        self.global_field = global_field
        self.last_reset = last_reset
        self.max_sessions = max_sessions
        self.password_reset = password_reset
        self.role_id = role_id
        self.role = role
        self.session_expire = session_expire
        self.settings = settings
        self.user_id = user_id
        self.user = user
        self.created = created
        self.created_by = created_by
        self.created_by_obj = created_by_obj
        self.updated = updated
        self.updated_by = updated_by
        self.updated_by_obj = updated_by_obj



class UserAws(BaseModel):
    """UserAws."""
    
    id = Integer(description='Primary key for internal use')
    uuid = String(description='UUID for external use')
    customer_identifier = String(description='The AWS customer identifier')
    product_code = String(description='The product they are registered for')
    subscription_state = String(description='The state of the subscription')
    user_id = Integer(description='FK. User id')
    user = FK(model='User', description='User id')
    created = DateTime(description='Timestamp when the record was created')
    created_by = Integer(description='FK. ID of the user who created the record')
    created_by_obj = FK(model='User', description='ID of the user who created the record')
    updated = DateTime(description='Timestamp when the record was last updated')
    updated_by = Integer(description='FK. ID of the user who updated the record')
    updated_by_obj = FK(model='User', description='ID of the user who updated the record')


    def __init__(
        self,
	*,
        id=None,
        uuid=None,
        customer_identifier=None,
        product_code=None,
        subscription_state=None,
        user_id=None,
        user=None,
        created=None,
        created_by=None,
        created_by_obj=None,
        updated=None,
        updated_by=None,
        updated_by_obj=None,
    ):
        self.id = id
        self.uuid = uuid
        self.customer_identifier = customer_identifier
        self.product_code = product_code
        self.subscription_state = subscription_state
        self.user_id = user_id
        self.user = user
        self.created = created
        self.created_by = created_by
        self.created_by_obj = created_by_obj
        self.updated = updated
        self.updated_by = updated_by
        self.updated_by_obj = updated_by_obj



class UserGroup(BaseModel):
    """UserGroup."""
    
    id = Integer(description='Primary key for internal use')
    uuid = String(description='UUID for external use')
    event_approve = Boolean(description='The event flags')
    event_case_assignment = Boolean(description='The event flags')
    event_harvest = Boolean(description='The event flags')
    event_link = Boolean(description='The event flags')
    event_link_mine = Boolean(description='The event flags')
    event_message = Boolean(description='The event flags')
    event_new_report = Boolean(description='The event flags')
    event_node = Boolean(description='The event flags')
    event_report_remove = Boolean(description='The event flags')
    event_share = Boolean(description='The event flags')
    event_status_change = Boolean(description='The event flags')
    event_study_comment = Boolean(description='The event flags')
    event_thin_study_fail = Boolean(description='The event flags')
    event_thin_study_success = Boolean(description='The event flags')
    event_upload = Boolean(description='The event flags')
    event_upload_fail = Boolean(description='The event flags')
    group_id = Integer(description='FK. Mapping between the user and group')
    group = FK(model='Group', description='Mapping between the user and group')
    no_physician_alias_share = Boolean(description='Do not do a physician alias share into this group')
    role_id = Integer(description='FK. Role over ride for the user in this group')
    role = FK(model='Role', description='Role over ride for the user in this group')
    user_id = Integer(description='FK. Mapping between the user and group')
    user = FK(model='User', description='Mapping between the user and group')
    created = DateTime(description='Timestamp when the record was created')
    created_by = Integer(description='FK. ID of the user who created the record')
    created_by_obj = FK(model='User', description='ID of the user who created the record')
    updated = DateTime(description='Timestamp when the record was last updated')
    updated_by = Integer(description='FK. ID of the user who updated the record')
    updated_by_obj = FK(model='User', description='ID of the user who updated the record')


    def __init__(
        self,
	*,
        id=None,
        uuid=None,
        event_approve=None,
        event_case_assignment=None,
        event_harvest=None,
        event_link=None,
        event_link_mine=None,
        event_message=None,
        event_new_report=None,
        event_node=None,
        event_report_remove=None,
        event_share=None,
        event_status_change=None,
        event_study_comment=None,
        event_thin_study_fail=None,
        event_thin_study_success=None,
        event_upload=None,
        event_upload_fail=None,
        group_id=None,
        group=None,
        no_physician_alias_share=None,
        role_id=None,
        role=None,
        user_id=None,
        user=None,
        created=None,
        created_by=None,
        created_by_obj=None,
        updated=None,
        updated_by=None,
        updated_by_obj=None,
    ):
        self.id = id
        self.uuid = uuid
        self.event_approve = event_approve
        self.event_case_assignment = event_case_assignment
        self.event_harvest = event_harvest
        self.event_link = event_link
        self.event_link_mine = event_link_mine
        self.event_message = event_message
        self.event_new_report = event_new_report
        self.event_node = event_node
        self.event_report_remove = event_report_remove
        self.event_share = event_share
        self.event_status_change = event_status_change
        self.event_study_comment = event_study_comment
        self.event_thin_study_fail = event_thin_study_fail
        self.event_thin_study_success = event_thin_study_success
        self.event_upload = event_upload
        self.event_upload_fail = event_upload_fail
        self.group_id = group_id
        self.group = group
        self.no_physician_alias_share = no_physician_alias_share
        self.role_id = role_id
        self.role = role
        self.user_id = user_id
        self.user = user
        self.created = created
        self.created_by = created_by
        self.created_by_obj = created_by_obj
        self.updated = updated
        self.updated_by = updated_by
        self.updated_by_obj = updated_by_obj



class UserInvite(BaseModel):
    """UserInvite."""
    
    id = Integer(description='Primary key for internal use')
    uuid = String(description='UUID for external use')
    account_id = Integer(description='FK. Account the invitation is for')
    account = FK(model='Account', description='Account the invitation is for')
    email = String(description='Email address to invite')
    groups = String(description='JSON hashes of the groups and locations to add them to with the role as the key value')
    locations = String(description='JSON hashes of the groups and locations to add them to with the role as the key value')
    role_id = Integer(description='FK. Role the invitation is for')
    role = FK(model='Role', description='Role the invitation is for')
    user_id = Integer(description='FK. Id of the user who accepted the invitation')
    user = FK(model='User', description='Id of the user who accepted the invitation')
    created = DateTime(description='Timestamp when the record was created')
    created_by = Integer(description='FK. ID of the user who created the record')
    created_by_obj = FK(model='User', description='ID of the user who created the record')
    updated = DateTime(description='Timestamp when the record was last updated')
    updated_by = Integer(description='FK. ID of the user who updated the record')
    updated_by_obj = FK(model='User', description='ID of the user who updated the record')


    def __init__(
        self,
	*,
        id=None,
        uuid=None,
        account_id=None,
        account=None,
        email=None,
        groups=None,
        locations=None,
        role_id=None,
        role=None,
        user_id=None,
        user=None,
        created=None,
        created_by=None,
        created_by_obj=None,
        updated=None,
        updated_by=None,
        updated_by_obj=None,
    ):
        self.id = id
        self.uuid = uuid
        self.account_id = account_id
        self.account = account
        self.email = email
        self.groups = groups
        self.locations = locations
        self.role_id = role_id
        self.role = role
        self.user_id = user_id
        self.user = user
        self.created = created
        self.created_by = created_by
        self.created_by_obj = created_by_obj
        self.updated = updated
        self.updated_by = updated_by
        self.updated_by_obj = updated_by_obj



class UserInviteShare(BaseModel):
    """UserInviteShare."""
    
    id = Integer(description='Primary key for internal use')
    uuid = String(description='UUID for external use')
    email = String(description='Email address to invite')
    message = String(description='Share message')
    study_id = Integer(description='FK. Id for the study to be shared')
    study = FK(model='Study', description='Id for the study to be shared')
    user_id = Integer(description='FK. Id the invitation is from')
    user = FK(model='User', description='Id the invitation is from')
    created = DateTime(description='Timestamp when the record was created')
    created_by = Integer(description='FK. ID of the user who created the record')
    created_by_obj = FK(model='User', description='ID of the user who created the record')
    updated = DateTime(description='Timestamp when the record was last updated')
    updated_by = Integer(description='FK. ID of the user who updated the record')
    updated_by_obj = FK(model='User', description='ID of the user who updated the record')


    def __init__(
        self,
	*,
        id=None,
        uuid=None,
        email=None,
        message=None,
        study_id=None,
        study=None,
        user_id=None,
        user=None,
        created=None,
        created_by=None,
        created_by_obj=None,
        updated=None,
        updated_by=None,
        updated_by_obj=None,
    ):
        self.id = id
        self.uuid = uuid
        self.email = email
        self.message = message
        self.study_id = study_id
        self.study = study
        self.user_id = user_id
        self.user = user
        self.created = created
        self.created_by = created_by
        self.created_by_obj = created_by_obj
        self.updated = updated
        self.updated_by = updated_by
        self.updated_by_obj = updated_by_obj



class UserLocation(BaseModel):
    """UserLocation."""
    
    id = Integer(description='Primary key for internal use')
    uuid = String(description='UUID for external use')
    event_approve = Boolean(description='The event flags')
    event_case_assignment = Boolean(description='The event flags')
    event_harvest = Boolean(description='The event flags')
    event_link = Boolean(description='The event flags')
    event_link_mine = Boolean(description='The event flags')
    event_message = Boolean(description='The event flags')
    event_new_report = Boolean(description='The event flags')
    event_node = Boolean(description='The event flags')
    event_report_remove = Boolean(description='The event flags')
    event_share = Boolean(description='The event flags')
    event_status_change = Boolean(description='The event flags')
    event_study_comment = Boolean(description='The event flags')
    event_thin_study_fail = Boolean(description='The event flags')
    event_thin_study_success = Boolean(description='The event flags')
    event_upload = Boolean(description='The event flags')
    event_upload_fail = Boolean(description='The event flags')
    location_id = Integer(description='FK. Mapping between the user and location')
    location = FK(model='Location', description='Mapping between the user and location')
    no_physician_alias_share = Boolean(description='Do not do a physician alias share into this location')
    role_id = Integer(description='FK. Role over ride for the user in this location')
    role = FK(model='Role', description='Role over ride for the user in this location')
    user_id = Integer(description='FK. Mapping between the user and location')
    user = FK(model='User', description='Mapping between the user and location')
    created = DateTime(description='Timestamp when the record was created')
    created_by = Integer(description='FK. ID of the user who created the record')
    created_by_obj = FK(model='User', description='ID of the user who created the record')
    updated = DateTime(description='Timestamp when the record was last updated')
    updated_by = Integer(description='FK. ID of the user who updated the record')
    updated_by_obj = FK(model='User', description='ID of the user who updated the record')


    def __init__(
        self,
	*,
        id=None,
        uuid=None,
        event_approve=None,
        event_case_assignment=None,
        event_harvest=None,
        event_link=None,
        event_link_mine=None,
        event_message=None,
        event_new_report=None,
        event_node=None,
        event_report_remove=None,
        event_share=None,
        event_status_change=None,
        event_study_comment=None,
        event_thin_study_fail=None,
        event_thin_study_success=None,
        event_upload=None,
        event_upload_fail=None,
        location_id=None,
        location=None,
        no_physician_alias_share=None,
        role_id=None,
        role=None,
        user_id=None,
        user=None,
        created=None,
        created_by=None,
        created_by_obj=None,
        updated=None,
        updated_by=None,
        updated_by_obj=None,
    ):
        self.id = id
        self.uuid = uuid
        self.event_approve = event_approve
        self.event_case_assignment = event_case_assignment
        self.event_harvest = event_harvest
        self.event_link = event_link
        self.event_link_mine = event_link_mine
        self.event_message = event_message
        self.event_new_report = event_new_report
        self.event_node = event_node
        self.event_report_remove = event_report_remove
        self.event_share = event_share
        self.event_status_change = event_status_change
        self.event_study_comment = event_study_comment
        self.event_thin_study_fail = event_thin_study_fail
        self.event_thin_study_success = event_thin_study_success
        self.event_upload = event_upload
        self.event_upload_fail = event_upload_fail
        self.location_id = location_id
        self.location = location
        self.no_physician_alias_share = no_physician_alias_share
        self.role_id = role_id
        self.role = role
        self.user_id = user_id
        self.user = user
        self.created = created
        self.created_by = created_by
        self.created_by_obj = created_by_obj
        self.updated = updated
        self.updated_by = updated_by
        self.updated_by_obj = updated_by_obj



class Validate(BaseModel):
    """Validate."""
    
    id = Integer(description='Primary key for internal use')
    uuid = String(description='UUID for external use')
    account_id = Integer(description='FK. The associated account')
    account = FK(model='Account', description='The associated account')
    conditions = String(description='The validate conditions')
    name = String(description='Name')
    created = DateTime(description='Timestamp when the record was created')
    created_by = Integer(description='FK. ID of the user who created the record')
    created_by_obj = FK(model='User', description='ID of the user who created the record')
    updated = DateTime(description='Timestamp when the record was last updated')
    updated_by = Integer(description='FK. ID of the user who updated the record')
    updated_by_obj = FK(model='User', description='ID of the user who updated the record')


    def __init__(
        self,
	*,
        id=None,
        uuid=None,
        account_id=None,
        account=None,
        conditions=None,
        name=None,
        created=None,
        created_by=None,
        created_by_obj=None,
        updated=None,
        updated_by=None,
        updated_by_obj=None,
    ):
        self.id = id
        self.uuid = uuid
        self.account_id = account_id
        self.account = account
        self.conditions = conditions
        self.name = name
        self.created = created
        self.created_by = created_by
        self.created_by_obj = created_by_obj
        self.updated = updated
        self.updated_by = updated_by
        self.updated_by_obj = updated_by_obj



class Webhook(BaseModel):
    """Webhook."""
    
    id = Integer(description='Primary key for internal use')
    uuid = String(description='UUID for external use')
    account_id = Integer(description='FK. The account')
    account = FK(model='Account', description='The account')
    auth = String(description='The webhook auth')
    by_accession_number = Boolean(description='Expand the once to check by accession_number as well')
    by_uid = Boolean(description='Expand the once to check by study_uid as well')
    cron = String(description='Cron string for a cron type of webhook')
    delay = Integer(description='Number of seconds to delay running this webhook after it is triggered')
    event = String(description='The event to trigger the webhook for')
    filter_field = String(description='Filter field and regexp')
    filter_regexp = String(description='Filter field and regexp')
    last_error = String(description='The last error the webhook had')
    max_age = Integer(description='Ignore studies that are more than this number of days old')
    method = String(description='Call method (POST,GET,POST_JSON,PUT)')
    name = String(description='Name')
    node_id = Integer(description='FK. The node id to proxy the call through')
    node = FK(model='Node', description='The node id to proxy the call through')
    once = Boolean(description='Run this only once for a specific study')
    parameters = String(description='The parameters for the call')
    retry = Boolean(description='Retry if it fails and a counter to track the retries')
    retry_count = Integer(description='Retry if it fails and a counter to track the retries')
    sid_user_id = Integer(description='FK. The user id to generate a sid as')
    sid_user = FK(model='User', description='The user id to generate a sid as')
    suspended = Boolean(description='Suspend this hook from running')
    url = String(description='The URL to call')
    created = DateTime(description='Timestamp when the record was created')
    created_by = Integer(description='FK. ID of the user who created the record')
    created_by_obj = FK(model='User', description='ID of the user who created the record')
    updated = DateTime(description='Timestamp when the record was last updated')
    updated_by = Integer(description='FK. ID of the user who updated the record')
    updated_by_obj = FK(model='User', description='ID of the user who updated the record')


    def __init__(
        self,
	*,
        id=None,
        uuid=None,
        account_id=None,
        account=None,
        auth=None,
        by_accession_number=None,
        by_uid=None,
        cron=None,
        delay=None,
        event=None,
        filter_field=None,
        filter_regexp=None,
        last_error=None,
        max_age=None,
        method=None,
        name=None,
        node_id=None,
        node=None,
        once=None,
        parameters=None,
        retry=None,
        retry_count=None,
        sid_user_id=None,
        sid_user=None,
        suspended=None,
        url=None,
        created=None,
        created_by=None,
        created_by_obj=None,
        updated=None,
        updated_by=None,
        updated_by_obj=None,
    ):
        self.id = id
        self.uuid = uuid
        self.account_id = account_id
        self.account = account
        self.auth = auth
        self.by_accession_number = by_accession_number
        self.by_uid = by_uid
        self.cron = cron
        self.delay = delay
        self.event = event
        self.filter_field = filter_field
        self.filter_regexp = filter_regexp
        self.last_error = last_error
        self.max_age = max_age
        self.method = method
        self.name = name
        self.node_id = node_id
        self.node = node
        self.once = once
        self.parameters = parameters
        self.retry = retry
        self.retry_count = retry_count
        self.sid_user_id = sid_user_id
        self.sid_user = sid_user
        self.suspended = suspended
        self.url = url
        self.created = created
        self.created_by = created_by
        self.created_by_obj = created_by_obj
        self.updated = updated
        self.updated_by = updated_by
        self.updated_by_obj = updated_by_obj



class WebhookNode(BaseModel):
    """WebhookNode."""
    
    id = Integer(description='Primary key for internal use')
    uuid = String(description='UUID for external use')
    method = String(description='Call method')
    node_id = Integer(description='FK. The node id to proxy the call through')
    node = FK(model='Node', description='The node id to proxy the call through')
    parameters = String(description='The parameters for the call')
    pickup = DateTime(description='When was this picked up by the node')
    status = String(description='Status of the delivery')
    url = String(description='The URL to call')
    webhook_id = Integer(description='FK. The webhook id')
    webhook = FK(model='Webhook', description='The webhook id')
    created = DateTime(description='Timestamp when the record was created')
    created_by = Integer(description='FK. ID of the user who created the record')
    created_by_obj = FK(model='User', description='ID of the user who created the record')
    updated = DateTime(description='Timestamp when the record was last updated')
    updated_by = Integer(description='FK. ID of the user who updated the record')
    updated_by_obj = FK(model='User', description='ID of the user who updated the record')


    def __init__(
        self,
	*,
        id=None,
        uuid=None,
        method=None,
        node_id=None,
        node=None,
        parameters=None,
        pickup=None,
        status=None,
        url=None,
        webhook_id=None,
        webhook=None,
        created=None,
        created_by=None,
        created_by_obj=None,
        updated=None,
        updated_by=None,
        updated_by_obj=None,
    ):
        self.id = id
        self.uuid = uuid
        self.method = method
        self.node_id = node_id
        self.node = node
        self.parameters = parameters
        self.pickup = pickup
        self.status = status
        self.url = url
        self.webhook_id = webhook_id
        self.webhook = webhook
        self.created = created
        self.created_by = created_by
        self.created_by_obj = created_by_obj
        self.updated = updated
        self.updated_by = updated_by
        self.updated_by_obj = updated_by_obj



class WebhookOnce(BaseModel):
    """WebhookOnce."""
    
    id = Integer(description='Primary key for internal use')
    uuid = String(description='UUID for external use')
    study_id = Integer(description='FK. The webhook and study id')
    study = FK(model='Study', description='The webhook and study id')
    webhook_id = Integer(description='FK. The webhook and study id')
    webhook = FK(model='Webhook', description='The webhook and study id')
    created = DateTime(description='Timestamp when the record was created')
    created_by = Integer(description='FK. ID of the user who created the record')
    created_by_obj = FK(model='User', description='ID of the user who created the record')
    updated = DateTime(description='Timestamp when the record was last updated')
    updated_by = Integer(description='FK. ID of the user who updated the record')
    updated_by_obj = FK(model='User', description='ID of the user who updated the record')


    def __init__(
        self,
	*,
        id=None,
        uuid=None,
        study_id=None,
        study=None,
        webhook_id=None,
        webhook=None,
        created=None,
        created_by=None,
        created_by_obj=None,
        updated=None,
        updated_by=None,
        updated_by_obj=None,
    ):
        self.id = id
        self.uuid = uuid
        self.study_id = study_id
        self.study = study
        self.webhook_id = webhook_id
        self.webhook = webhook
        self.created = created
        self.created_by = created_by
        self.created_by_obj = created_by_obj
        self.updated = updated
        self.updated_by = updated_by
        self.updated_by_obj = updated_by_obj


