""" Audit.

Do not edit this file by hand.
This is generated by parsing api.html service doc.
"""
from ambra_sdk.exceptions.service import FilterNotFound
from ambra_sdk.exceptions.service import InvalidBucket
from ambra_sdk.exceptions.service import InvalidCondition
from ambra_sdk.exceptions.service import InvalidField
from ambra_sdk.exceptions.service import MissingFields
from ambra_sdk.exceptions.service import NotFound
from ambra_sdk.exceptions.service import NotPermitted
from ambra_sdk.service.query import QueryO
from ambra_sdk.service.query import QueryOP
from ambra_sdk.service.query import QueryOPF

class Audit:
    """Audit."""

    def __init__(self, api):
        self._api = api

    
    def object(
        self,
        uuid,
        customfield_detail=None,
        download=None,
        reverse=None,
    ):
        """Object.
        :param uuid: The uuid of the object to audit
        :param customfield_detail: Flag to include the customfield name in the detail (optional)
        :param download: Flag to create a zipped CSV file. A report_id will be returned and the file can be accessed via /report/status and /report/zip (optional)
        :param reverse: Flag to reverse the default sort order (optional)
        """
        request_data = {
           'download': download,
           'uuid': uuid,
           'customfield_detail': customfield_detail,
           'reverse': reverse,
        }
	
        errors_mapping = {}
        errors_mapping['FILTER_NOT_FOUND'] = FilterNotFound('The filter can not be found. The error_subtype will hold the filter UUID')
        errors_mapping['INVALID_CONDITION'] = InvalidCondition('The condition is not support. The error_subtype will hold the filter expression this applies to')
        errors_mapping['INVALID_FIELD'] = InvalidField('The field is not valid for this object. The error_subtype will hold the filter expression this applies to')
        errors_mapping['MISSING_FIELDS'] = MissingFields('A required field is missing or does not have data in it. The error_subtype holds a array of all the missing fields')
        errors_mapping['NOT_FOUND'] = NotFound('The object was not found')
        errors_mapping['NOT_PERMITTED'] = NotPermitted('You are not permitted to access this object')
        query_data = {
            'api': self._api,
            'url': '/audit/object',
            'request_data': request_data,
            'errors_mapping': errors_mapping,
            'required_sid': True,
        }
        query_data['paginated_field'] = 'events'
        return QueryOPF(**query_data)
    
    def user(
        self,
        account_id,
        user_id,
        download=None,
        reverse=None,
    ):
        """User.
        :param account_id: The id of the account
        :param user_id: The id of the user to audit
        :param download: Flag to create a zipped CSV file. A report_id will be returned and the file can be accessed via /report/status and /report/zip (optional)
        :param reverse: Flag to reverse the default sort order (optional)
        """
        request_data = {
           'user_id': user_id,
           'download': download,
           'account_id': account_id,
           'reverse': reverse,
        }
	
        errors_mapping = {}
        errors_mapping['MISSING_FIELDS'] = MissingFields('A required field is missing or does not have data in it. The error_subtype holds a array of all the missing fields')
        errors_mapping['NOT_FOUND'] = NotFound('The user was not found')
        errors_mapping['NOT_PERMITTED'] = NotPermitted('You are not permitted to access this user record')
        query_data = {
            'api': self._api,
            'url': '/audit/user',
            'request_data': request_data,
            'errors_mapping': errors_mapping,
            'required_sid': True,
        }
        query_data['paginated_field'] = 'events'
        return QueryOP(**query_data)
    
    def account(
        self,
        account_id,
        download=None,
        reverse=None,
    ):
        """Account.
        :param account_id: The id of the account
        :param download: Flag to create a zipped CSV file. A report_id will be returned and the file can be accessed via /report/status and /report/zip (optional)
        :param reverse: Flag to reverse the default sort order (optional)
        """
        request_data = {
           'download': download,
           'account_id': account_id,
           'reverse': reverse,
        }
	
        errors_mapping = {}
        errors_mapping['FILTER_NOT_FOUND'] = FilterNotFound('The filter can not be found. The error_subtype will hold the filter UUID')
        errors_mapping['INVALID_CONDITION'] = InvalidCondition('The condition is not support. The error_subtype will hold the filter expression this applies to')
        errors_mapping['INVALID_FIELD'] = InvalidField('The field is not valid for this object. The error_subtype will hold the filter expression this applies to')
        errors_mapping['MISSING_FIELDS'] = MissingFields('A required field is missing or does not have data in it. The error_subtype holds a array of all the missing fields')
        errors_mapping['NOT_FOUND'] = NotFound('The account was not found')
        errors_mapping['NOT_PERMITTED'] = NotPermitted('You are not permitted to access this information')
        query_data = {
            'api': self._api,
            'url': '/audit/account',
            'request_data': request_data,
            'errors_mapping': errors_mapping,
            'required_sid': True,
        }
        query_data['paginated_field'] = 'events'
        return QueryOPF(**query_data)
    
    def deleted(
        self,
        account_id,
        type=None,
    ):
        """Deleted.
        :param account_id: The id of the account
        :param type: type

        Notes:
        type - The type of the object (Study OR User etc.)
        """
        request_data = {
           'type': type,
           'account_id': account_id,
        }
	
        errors_mapping = {}
        errors_mapping['MISSING_FIELDS'] = MissingFields('A required field is missing or does not have data in it. The error_subtype holds a array of all the missing fields')
        errors_mapping['NOT_PERMITTED'] = NotPermitted('You are not permitted to access this record')
        query_data = {
            'api': self._api,
            'url': '/audit/deleted',
            'request_data': request_data,
            'errors_mapping': errors_mapping,
            'required_sid': True,
        }
        query_data['paginated_field'] = 'objects'
        return QueryOP(**query_data)
    
    def log(
        self,
        bucket,
        logged_params,
    ):
        """Log.
        :param bucket: Name of the bucket to log to
        :param logged_params: Dict of parameters. They are logged to a message in the bucket
        """
        request_data = {
           'bucket': bucket,
        }
        if logged_params is not None:
            logged_params_dict = {'{prefix}{k}'.format(prefix='', k=k): v for k,v in logged_params.items()}
            request_data.update(logged_params_dict)
	
        errors_mapping = {}
        errors_mapping['INVALID_BUCKET'] = InvalidBucket('The bucket name can only contain A-z characters and must be between 4 and 16 characters long')
        errors_mapping['MISSING_FIELDS'] = MissingFields('A required field is missing or does not have data in it. The error_subtype holds a array of all the missing fields')
        query_data = {
            'api': self._api,
            'url': '/audit/log',
            'request_data': request_data,
            'errors_mapping': errors_mapping,
            'required_sid': True,
        }
        return QueryO(**query_data)
    
    def failedlogins(
        self,
        account_id,
        from_time=None,
    ):
        """Failedlogins.
        :param account_id: The id of the account
        :param from_time: Only return events after the epoch time (optional)
        """
        request_data = {
           'account_id': account_id,
           'from_time': from_time,
        }
	
        errors_mapping = {}
        query_data = {
            'api': self._api,
            'url': '/audit/failedlogins',
            'request_data': request_data,
            'errors_mapping': errors_mapping,
            'required_sid': True,
        }
        return QueryO(**query_data)
    