""" Destination.

Do not edit this file by hand.
This is generated by parsing api.html service doc.
"""
from ambra_sdk.exceptions.service import DupAetitle
from ambra_sdk.exceptions.service import FilterNotFound
from ambra_sdk.exceptions.service import InsufficientCriteria
from ambra_sdk.exceptions.service import InvalidCdBurnInfo
from ambra_sdk.exceptions.service import InvalidCondition
from ambra_sdk.exceptions.service import InvalidField
from ambra_sdk.exceptions.service import InvalidFlag
from ambra_sdk.exceptions.service import InvalidGatewayType
from ambra_sdk.exceptions.service import InvalidInteger
from ambra_sdk.exceptions.service import InvalidNodeType
from ambra_sdk.exceptions.service import InvalidSchedule
from ambra_sdk.exceptions.service import InvalidSortField
from ambra_sdk.exceptions.service import InvalidSortOrder
from ambra_sdk.exceptions.service import InvalidType
from ambra_sdk.exceptions.service import InvalidValue
from ambra_sdk.exceptions.service import MissingFields
from ambra_sdk.exceptions.service import NodeNotFound
from ambra_sdk.exceptions.service import NotFound
from ambra_sdk.exceptions.service import NotPermitted
from ambra_sdk.exceptions.service import NotSupported
from ambra_sdk.exceptions.service import NotSysadmin
from ambra_sdk.service.query import QueryO
from ambra_sdk.service.query import QueryOPSF

class Destination:
    """Destination."""

    def __init__(self, api):
        self._api = api

    
    def list(
        self,
        account_id,
        uuid,
        node_id=None,
        serial_no=None,
    ):
        """List.
        :param account_id: uuid of the account
        :param uuid: uuid of the destination
        :param node_id: node_id
        :param serial_no: serial_no

        Notes:
        (sid OR node_id AND serial_no) - Either the sid or the node uuid and serial number
        """
        request_data = {
           'account_id': account_id,
           'node_id': node_id,
           'uuid': uuid,
           'serial_no': serial_no,
        }
	
        errors_mapping = {}
        errors_mapping['FILTER_NOT_FOUND'] = FilterNotFound('The filter can not be found. The error_subtype will hold the filter UUID')
        errors_mapping['INVALID_CONDITION'] = InvalidCondition('The condition is not support. The error_subtype will hold the filter expression this applies to')
        errors_mapping['INVALID_FIELD'] = InvalidField('The field is not valid for this object. The error_subtype will hold the filter expression this applies to')
        errors_mapping['INVALID_SORT_FIELD'] = InvalidSortField('The field is not valid for this object. The error_subtype will hold the field name this applies to')
        errors_mapping['INVALID_SORT_ORDER'] = InvalidSortOrder('The sort order for the field is invalid. The error_subtype will hold the field name this applies to')
        errors_mapping['MISSING_FIELDS'] = MissingFields('A required field is missing or does not have data in it. The error_subtype holds a array of all the missing fields')
        errors_mapping['NOT_FOUND'] = NotFound('The account can not be found')
        errors_mapping['NOT_PERMITTED'] = NotPermitted('You are not permitted to view this list')
        query_data = {
            'api': self._api,
            'url': '/destination/list',
            'request_data': request_data,
            'errors_mapping': errors_mapping,
            'required_sid': True,
        }
        query_data['paginated_field'] = 'destinations'
        return QueryOPSF(**query_data)
    
    def add(
        self,
        account_id,
        address,
        aetitle,
        linked_destination,
        name,
        node_id,
        path,
        port,
        c_echo_interval=None,
        c_echo_schedule=None,
        can_mwl_search=None,
        can_query_retrieve=None,
        can_retrieve_thin=None,
        can_search=None,
        cd_burn_info=None,
        cd_burn_name=None,
        cd_burn_priority=None,
        default_query_retrieve_level=None,
        fire_webhooks=None,
        gateway_settings=None,
        hl7_address=None,
        hl7_fetch_filter=None,
        hl7_port=None,
        push_related_studies=None,
        sort_order=None,
        sqlch_psh_if_img_unchg=None,
        sqlch_psh_if_route_hl7=None,
        type=None,
    ):
        """Add.
        :param account_id: uuid of the account
        :param address: Address of the destination (required if DICOM type)
        :param aetitle: Aetitle of the destination (required if DICOM type)
        :param linked_destination: uuid of the destination for LINKED destinations
        :param name: Name of the destination
        :param node_id: uuid of the node that handles the destination
        :param path: Path of the folder for a FOLDER type of destination (required if FOLDER type)
        :param port: Port of the destination (required if DICOM type)
        :param c_echo_interval: Interval in seconds to C echo the destination (optional)
        :param c_echo_schedule: C echo schedule (optional)
        :param can_mwl_search: Can this destination support searching a modality work list (optional)
        :param can_query_retrieve: Can this destination support query retrieve from HL7 messages (optional)
        :param can_retrieve_thin: Can this destination support retrieving thin studies (optional)
        :param can_search: Can this destination support searching (optional)
        :param cd_burn_info: A JSON hash with the CD burning information (optional)
        :param cd_burn_name: Name for the CD burner software (optional)
        :param cd_burn_priority: Integer value for the burner priority (optional)
        :param default_query_retrieve_level: default_query_retrieve_level
        :param fire_webhooks: Fire webhooks for events associated with this destination (optional)
        :param gateway_settings: Gateway settings (optional)
        :param hl7_address: Address of an attached HL7 destination (optional except for VIRTUAL destinations)
        :param hl7_fetch_filter: A transform condition expression (see /transform/add for format) to match against the HL7 message. Only fire a query retrieve if the message matches the condition (optional)
        :param hl7_port: Port of an attached HL7 destination (optional except for VIRTUAL destinations)
        :param push_related_studies: Push all the related studies (same MRN/patientid) in the namespace when a study is pushed (optional)
        :param sort_order: Integer value for sorting (optional)
        :param sqlch_psh_if_img_unchg: Squelch pushes to the destination if the image count has not changed and the push is by a routing rule (optional)
        :param sqlch_psh_if_route_hl7: Squelch pushes to the destination if the push was generated by HL7 triggered routing (optional)
        :param type: Type of the destination either DICOM, FOLDER, ACCELERATOR,VIRTUAL, BURNER, XDS, LINKED or UPLOADER. Defaults to DICOM (optional)

        Notes:
        default_query_retrieve_level - Default query retrieve level this can be either (study OR series OR image) and defaults to study if not specified (optional)
        """
        request_data = {
           'address': address,
           'can_search': can_search,
           'hl7_fetch_filter': hl7_fetch_filter,
           'gateway_settings': gateway_settings,
           'name': name,
           'path': path,
           'push_related_studies': push_related_studies,
           'linked_destination': linked_destination,
           'can_retrieve_thin': can_retrieve_thin,
           'cd_burn_info': cd_burn_info,
           'cd_burn_priority': cd_burn_priority,
           'account_id': account_id,
           'type': type,
           'hl7_port': hl7_port,
           'can_mwl_search': can_mwl_search,
           'fire_webhooks': fire_webhooks,
           'default_query_retrieve_level': default_query_retrieve_level,
           'c_echo_schedule': c_echo_schedule,
           'sort_order': sort_order,
           'c_echo_interval': c_echo_interval,
           'node_id': node_id,
           'cd_burn_name': cd_burn_name,
           'can_query_retrieve': can_query_retrieve,
           'aetitle': aetitle,
           'sqlch_psh_if_img_unchg': sqlch_psh_if_img_unchg,
           'port': port,
           'sqlch_psh_if_route_hl7': sqlch_psh_if_route_hl7,
           'hl7_address': hl7_address,
        }
	
        errors_mapping = {}
        errors_mapping['DUP_AETITLE'] = DupAetitle('Duplicate aetitle. All destinations for the same node must have a unique aetitle')
        errors_mapping['INVALID_CD_BURN_INFO'] = InvalidCdBurnInfo('Invalid cd_burn_info. The error_subtype holds more detail')
        errors_mapping['INVALID_FLAG'] = InvalidFlag('An invalid flag was passed. The error_subtype holds the name of the invalid flag')
        errors_mapping['INVALID_GATEWAY_TYPE'] = InvalidGatewayType('The type is wrong for the gateway it is getting attached to')
        errors_mapping['INVALID_INTEGER'] = InvalidInteger('An invalid integer was passed. The error_subtype holds the name of the invalid integer')
        errors_mapping['INVALID_NODE_TYPE'] = InvalidNodeType('The node type is invalid for this type of destination')
        errors_mapping['INVALID_NODE_TYPE'] = InvalidNodeType('The node is not a harvester')
        errors_mapping['INVALID_SCHEDULE'] = InvalidSchedule('The schedule is invalid. The error_subtype holds the error detail')
        errors_mapping['INVALID_TYPE'] = InvalidType('An invalid type was passed')
        errors_mapping['INVALID_VALUE'] = InvalidValue('An invalid value was passed. The error_subtype holds the value')
        errors_mapping['MISSING_FIELDS'] = MissingFields('A required field is missing or does not have data in it. The error_subtype holds a array of all the missing fields')
        errors_mapping['NODE_NOT_FOUND'] = NodeNotFound('The node can not be found')
        errors_mapping['NOT_FOUND'] = NotFound('The account can not be found')
        errors_mapping['NOT_PERMITTED'] = NotPermitted('You are not permitted to add a destination to this account')
        errors_mapping['NOT_SYSADMIN'] = NotSysadmin('The user is not a sysadmin user')
        query_data = {
            'api': self._api,
            'url': '/destination/add',
            'request_data': request_data,
            'errors_mapping': errors_mapping,
            'required_sid': True,
        }
        return QueryO(**query_data)
    
    def set(
        self,
        uuid,
        address=None,
        aetitle=None,
        c_echo_interval=None,
        c_echo_schedule=None,
        can_mwl_search=None,
        can_query_retrieve=None,
        can_retrieve_thin=None,
        can_search=None,
        cd_burn_info=None,
        cd_burn_name=None,
        cd_burn_priority=None,
        default_query_retrieve_level=None,
        fire_webhooks=None,
        gateway_settings=None,
        hl7_address=None,
        hl7_fetch_filter=None,
        hl7_port=None,
        name=None,
        node_id=None,
        path=None,
        port=None,
        push_related_studies=None,
        sort_order=None,
        sqlch_psh_if_img_unchg=None,
        sqlch_psh_if_route_hl7=None,
    ):
        """Set.
        :param uuid: uuid of the destination
        :param address: Address of the destination (optional)
        :param aetitle: Aetitle of the destination (optional)
        :param c_echo_interval: Interval in seconds to C echo the destination (optional)
        :param c_echo_schedule: C echo schedule (optional)
        :param can_mwl_search: Can this destination support searching a modality work list (optional)
        :param can_query_retrieve: Can this destination support query retrieve from HL7 messages (optional)
        :param can_retrieve_thin: Can this destination support retrieving thin studies (optional)
        :param can_search: Can this destination support searching (optional)
        :param cd_burn_info: A JSON hash with the CD burning information (optional)
        :param cd_burn_name: Name for the CD burner software (optional)
        :param cd_burn_priority: Integer value for the burner priority (optional)
        :param default_query_retrieve_level: default_query_retrieve_level
        :param fire_webhooks: Fire webhooks for events associated with this destination (optional)
        :param gateway_settings: Gateway settings (optional)
        :param hl7_address: Address of an attached HL7 destination (optional)
        :param hl7_fetch_filter: A transform condition expression (see /transform/add for format) to match against the HL7 message. Only fire a query retrieve if the message matches the condition (optional)
        :param hl7_port: Port of an attached HL7 destination (optional)
        :param name: Name of the destination (optional)
        :param node_id: uuid of the node that handles the destination (optional)
        :param path: Path of the folder (optional)
        :param port: Port of the destination (optional)
        :param push_related_studies: Push all the related studies (same MRN/patientid) in the namespace when a study is pushed (optional)
        :param sort_order: Integer value for sorting (optional)
        :param sqlch_psh_if_img_unchg: Squelch pushes to the destination if the image count has not changed and the push is by a routing rule (optional)
        :param sqlch_psh_if_route_hl7: Squelch pushes to the destination if the push was generated by HL7 triggered routing (optional)

        Notes:
        default_query_retrieve_level - Default query retrieve level this can be either (study OR series OR image) and defaults to study if not specified (optional)
        """
        request_data = {
           'address': address,
           'can_search': can_search,
           'hl7_fetch_filter': hl7_fetch_filter,
           'gateway_settings': gateway_settings,
           'name': name,
           'path': path,
           'push_related_studies': push_related_studies,
           'can_retrieve_thin': can_retrieve_thin,
           'cd_burn_info': cd_burn_info,
           'cd_burn_priority': cd_burn_priority,
           'hl7_port': hl7_port,
           'can_mwl_search': can_mwl_search,
           'default_query_retrieve_level': default_query_retrieve_level,
           'fire_webhooks': fire_webhooks,
           'uuid': uuid,
           'c_echo_schedule': c_echo_schedule,
           'sort_order': sort_order,
           'c_echo_interval': c_echo_interval,
           'node_id': node_id,
           'cd_burn_name': cd_burn_name,
           'can_query_retrieve': can_query_retrieve,
           'aetitle': aetitle,
           'sqlch_psh_if_img_unchg': sqlch_psh_if_img_unchg,
           'port': port,
           'sqlch_psh_if_route_hl7': sqlch_psh_if_route_hl7,
           'hl7_address': hl7_address,
        }
	
        errors_mapping = {}
        errors_mapping['DUP_AETITLE'] = DupAetitle('Duplicate aetitle. All destinations for the same node must have a unique aetitle')
        errors_mapping['INVALID_CD_BURN_INFO'] = InvalidCdBurnInfo('Invalid cd_burn_info. The error_subtype holds more detail')
        errors_mapping['INVALID_FLAG'] = InvalidFlag('An invalid flag was passed. The error_subtype holds the name of the invalid flag')
        errors_mapping['INVALID_INTEGER'] = InvalidInteger('An invalid integer was passed. The error_subtype holds the name of the invalid integer')
        errors_mapping['INVALID_NODE_TYPE'] = InvalidNodeType('The node is not a harvester')
        errors_mapping['INVALID_SCHEDULE'] = InvalidSchedule('The schedule is invalid. The error_subtype holds the error detail')
        errors_mapping['INVALID_VALUE'] = InvalidValue('An invalid value was passed. The error_subtype holds the value')
        errors_mapping['MISSING_FIELDS'] = MissingFields('A required field is missing or does not have data in it. The error_subtype holds a array of all the missing fields')
        errors_mapping['NODE_NOT_FOUND'] = NodeNotFound('The node can not be found')
        errors_mapping['NOT_FOUND'] = NotFound('The destination can not be found')
        errors_mapping['NOT_PERMITTED'] = NotPermitted('You are not permitted to edit the destination')
        query_data = {
            'api': self._api,
            'url': '/destination/set',
            'request_data': request_data,
            'errors_mapping': errors_mapping,
            'required_sid': True,
        }
        return QueryO(**query_data)
    
    def get(
        self,
        uuid,
    ):
        """Get.
        :param uuid: uuid of the destination
        """
        request_data = {
           'uuid': uuid,
        }
	
        errors_mapping = {}
        errors_mapping['MISSING_FIELDS'] = MissingFields('A required field is missing or does not have data in it. The error_subtype holds a array of all the missing fields')
        errors_mapping['NOT_FOUND'] = NotFound('The destination can not be found')
        errors_mapping['NOT_PERMITTED'] = NotPermitted('You are not permitted to view the destination')
        query_data = {
            'api': self._api,
            'url': '/destination/get',
            'request_data': request_data,
            'errors_mapping': errors_mapping,
            'required_sid': True,
        }
        return QueryO(**query_data)
    
    def delete(
        self,
        uuid,
    ):
        """Delete.
        :param uuid: uuid of the destination
        """
        request_data = {
           'uuid': uuid,
        }
	
        errors_mapping = {}
        errors_mapping['MISSING_FIELDS'] = MissingFields('A required field is missing or does not have data in it. The error_subtype holds a array of all the missing fields')
        errors_mapping['NOT_FOUND'] = NotFound('The destination can not be found')
        errors_mapping['NOT_PERMITTED'] = NotPermitted('You are not permitted to delete the destination')
        query_data = {
            'api': self._api,
            'url': '/destination/delete',
            'request_data': request_data,
            'errors_mapping': errors_mapping,
            'required_sid': True,
        }
        return QueryO(**query_data)
    
    def search(
        self,
        uuid,
        accession_number=None,
        copy_to=None,
        create_study=None,
        create_thin=None,
        end_datetime=None,
        modality=None,
        node_id=None,
        patient_birth_date=None,
        patient_name=None,
        patient_sex=None,
        patientid=None,
        push_to=None,
        query_fields=None,
        referring_physician=None,
        result_fields=None,
        serial_no=None,
        start_datetime=None,
        study_uid=None,
    ):
        """Search.
        :param uuid: uuid of the destination
        :param accession_number: Accession number to find (optional)
        :param copy_to: uuid of a namespace to copy the retrieved or create_thin studies into (optional)
        :param create_study: The maximum number of studies to retrieve from this search instead of creating an activity for the search results (optional)
        :param create_thin: The maximum number of thin studies to create from this search instead of creating an activity for the search results (optional)
        :param end_datetime: DICOM end date time stamp to bound the search (optional)
        :param modality: Modality (optional)
        :param node_id: node_id
        :param patient_birth_date: Birth date to find (optional)
        :param patient_name: Patient name to find (optional)
        :param patient_sex: Gender to find (optional)
        :param patientid: Patient id to find (optional)
        :param push_to: uuid of a destination to push the retrieved studies to (optional)
        :param query_fields: A JSON hash of additional query fields (optional)
        :param referring_physician: Referring physician to find (optional)
        :param result_fields: A JSON array of DICOM tags that the destination should return (optional)
        :param serial_no: serial_no
        :param start_datetime: DICOM start date time stamp to bound the search (optional)
        :param study_uid: Study uid to find (optional)

        Notes:
        The rest of the fields are used for the search
        (sid OR node_id AND serial_no) - Either the sid or the node uuid and serial number
        """
        request_data = {
           'modality': modality,
           'patient_name': patient_name,
           'result_fields': result_fields,
           'serial_no': serial_no,
           'referring_physician': referring_physician,
           'accession_number': accession_number,
           'push_to': push_to,
           'start_datetime': start_datetime,
           'patient_birth_date': patient_birth_date,
           'patient_sex': patient_sex,
           'end_datetime': end_datetime,
           'study_uid': study_uid,
           'patientid': patientid,
           'query_fields': query_fields,
           'uuid': uuid,
           'copy_to': copy_to,
           'node_id': node_id,
           'create_thin': create_thin,
           'create_study': create_study,
        }
	
        errors_mapping = {}
        errors_mapping['INSUFFICIENT_CRITERIA'] = InsufficientCriteria('Not enough search fields are populated')
        errors_mapping['MISSING_FIELDS'] = MissingFields('A required field is missing or does not have data in it. The error_subtype holds a array of all the missing fields')
        errors_mapping['NOT_FOUND'] = NotFound('The destination or namespace can not be found')
        errors_mapping['NOT_PERMITTED'] = NotPermitted('You are not permitted to search the destination')
        errors_mapping['NOT_SUPPORTED'] = NotSupported('The destination does not support searching a destination')
        query_data = {
            'api': self._api,
            'url': '/destination/search',
            'request_data': request_data,
            'errors_mapping': errors_mapping,
            'required_sid': True,
        }
        return QueryO(**query_data)
    
    def retrieve(
        self,
        activity_id,
    ):
        """Retrieve.
        :param activity_id: uuid of the DESTINATION_SEARCH activity to retrieve from
        """
        request_data = {
           'activity_id': activity_id,
        }
	
        errors_mapping = {}
        errors_mapping['MISSING_FIELDS'] = MissingFields('A required field is missing or does not have data in it. The error_subtype holds a array of all the missing fields')
        errors_mapping['NOT_FOUND'] = NotFound('The activity can not be found')
        query_data = {
            'api': self._api,
            'url': '/destination/retrieve',
            'request_data': request_data,
            'errors_mapping': errors_mapping,
            'required_sid': True,
        }
        return QueryO(**query_data)
    
    def search_mwl(
        self,
        study_id,
        uuid,
        accession_number=None,
        order_date=None,
        order_number=None,
        patient_birth_date=None,
        patient_name=None,
        patient_sex=None,
        patientid=None,
    ):
        """Search mwl.
        :param study_id: The id of the study we are searching for orders for
        :param uuid: uuid of the destination
        :param accession_number: Accession number to find (optional)
        :param order_date: Order date to find (optional)
        :param order_number: Order number to find (optional)
        :param patient_birth_date: Birth date to find (optional)
        :param patient_name: Patient name to find (optional)
        :param patient_sex: Gender to find (optional)
        :param patientid: Patient id to find (optional)

        Notes:
        The rest of the fields are used for the search
        """
        request_data = {
           'patient_birth_date': patient_birth_date,
           'order_date': order_date,
           'patient_name': patient_name,
           'patientid': patientid,
           'order_number': order_number,
           'uuid': uuid,
           'patient_sex': patient_sex,
           'accession_number': accession_number,
           'study_id': study_id,
        }
	
        errors_mapping = {}
        errors_mapping['INSUFFICIENT_CRITERIA'] = InsufficientCriteria('Not enough search fields are populated')
        errors_mapping['MISSING_FIELDS'] = MissingFields('A required field is missing or does not have data in it. The error_subtype holds a array of all the missing fields')
        errors_mapping['NOT_FOUND'] = NotFound('The destination or study can not be found')
        errors_mapping['NOT_PERMITTED'] = NotPermitted('You are not permitted to search the destination')
        errors_mapping['NOT_SUPPORTED'] = NotSupported('The destination does not support searching a destination')
        query_data = {
            'api': self._api,
            'url': '/destination/search/mwl',
            'request_data': request_data,
            'errors_mapping': errors_mapping,
            'required_sid': True,
        }
        return QueryO(**query_data)
    