""" Dictionary.

Do not edit this file by hand.
This is generated by parsing api.html service doc.
"""
from ambra_sdk.exceptions.service import FilterNotFound
from ambra_sdk.exceptions.service import InvalidCondition
from ambra_sdk.exceptions.service import InvalidField
from ambra_sdk.exceptions.service import InvalidFlag
from ambra_sdk.exceptions.service import InvalidInteger
from ambra_sdk.exceptions.service import InvalidLookup
from ambra_sdk.exceptions.service import InvalidObject
from ambra_sdk.exceptions.service import InvalidRegexp
from ambra_sdk.exceptions.service import InvalidSortField
from ambra_sdk.exceptions.service import InvalidSortOrder
from ambra_sdk.exceptions.service import MissingFields
from ambra_sdk.exceptions.service import NotFound
from ambra_sdk.exceptions.service import NotList
from ambra_sdk.exceptions.service import NotPermitted
from ambra_sdk.service.query import QueryO
from ambra_sdk.service.query import QueryOPSF

class Dictionary:
    """Dictionary."""

    def __init__(self, api):
        self._api = api

    
    def list(
        self,
        account_id,
    ):
        """List.
        :param account_id: The account id
        """
        request_data = {
           'account_id': account_id,
        }
	
        errors_mapping = {}
        errors_mapping['FILTER_NOT_FOUND'] = FilterNotFound('The filter can not be found. The error_subtype will hold the filter UUID')
        errors_mapping['INVALID_CONDITION'] = InvalidCondition('The condition is not support. The error_subtype will hold the filter expression this applies to')
        errors_mapping['INVALID_FIELD'] = InvalidField('The field is not valid for this object. The error_subtype will hold the filter expression this applies to')
        errors_mapping['INVALID_SORT_FIELD'] = InvalidSortField('The field is not valid for this object. The error_subtype will hold the field name this applies to')
        errors_mapping['INVALID_SORT_ORDER'] = InvalidSortOrder('The sort order for the field is invalid. The error_subtype will hold the field name this applies to')
        errors_mapping['MISSING_FIELDS'] = MissingFields('A required field is missing or does not have data in it. The error_subtype holds a array of all the missing fields')
        errors_mapping['NOT_FOUND'] = NotFound('The account can not be found')
        errors_mapping['NOT_PERMITTED'] = NotPermitted('You are not permitted to do this')
        query_data = {
            'api': self._api,
            'url': '/dictionary/list',
            'request_data': request_data,
            'errors_mapping': errors_mapping,
            'required_sid': True,
        }
        query_data['paginated_field'] = 'dictionaries'
        return QueryOPSF(**query_data)
    
    def add(
        self,
        account_id,
        case_sensitive,
        lookup,
        name,
        replace,
        object=None,
    ):
        """Add.
        :param account_id: The account id
        :param case_sensitive: Flag if the dictionary lookup is case sensitive or not
        :param lookup: A JSON array of field names that will be concatenated and MD5 hashed for the dictionary lookup value
        :param name: The dictionary name
        :param replace: A JSON array of the field names that will be replaced for a successful lookup
        :param object: object

        Notes:
        object - Object this is applied against (Study OR Order OR User_account OR Case)
        """
        request_data = {
           'object': object,
           'replace': replace,
           'case_sensitive': case_sensitive,
           'lookup': lookup,
           'account_id': account_id,
           'name': name,
        }
	
        errors_mapping = {}
        errors_mapping['INVALID_FIELD'] = InvalidField('An invalid field name was passed. The error_subtype holds the name of the invalid field')
        errors_mapping['INVALID_FLAG'] = InvalidFlag('An invalid flag was passed. The error_subtype holds the name of the invalid flag')
        errors_mapping['INVALID_OBJECT'] = InvalidObject('An invalid object was passed')
        errors_mapping['MISSING_FIELDS'] = MissingFields('A required field is missing or does not have data in it. The error_subtype holds a array of all the missing fields')
        errors_mapping['NOT_FOUND'] = NotFound('The account can not be found')
        errors_mapping['NOT_LIST'] = NotList('The field is not a JSON array. The error_subtype holds the name of the field')
        errors_mapping['NOT_PERMITTED'] = NotPermitted('You are not permitted to do this')
        query_data = {
            'api': self._api,
            'url': '/dictionary/add',
            'request_data': request_data,
            'errors_mapping': errors_mapping,
            'required_sid': True,
        }
        return QueryO(**query_data)
    
    def set(
        self,
        name,
        uuid,
    ):
        """Set.
        :param name: The dictionary name
        :param uuid: The dictionary id
        """
        request_data = {
           'uuid': uuid,
           'name': name,
        }
	
        errors_mapping = {}
        errors_mapping['MISSING_FIELDS'] = MissingFields('A required field is missing or does not have data in it. The error_subtype holds a array of all the missing fields')
        errors_mapping['NOT_FOUND'] = NotFound('The dictionary can not be found')
        errors_mapping['NOT_PERMITTED'] = NotPermitted('You are not permitted to do this')
        query_data = {
            'api': self._api,
            'url': '/dictionary/set',
            'request_data': request_data,
            'errors_mapping': errors_mapping,
            'required_sid': True,
        }
        return QueryO(**query_data)
    
    def get(
        self,
        uuid,
    ):
        """Get.
        :param uuid: The dictionary id
        """
        request_data = {
           'uuid': uuid,
        }
	
        errors_mapping = {}
        errors_mapping['MISSING_FIELDS'] = MissingFields('A required field is missing or does not have data in it. The error_subtype holds a array of all the missing fields')
        errors_mapping['NOT_FOUND'] = NotFound('The dictionary can not be found')
        errors_mapping['NOT_PERMITTED'] = NotPermitted('You are not permitted to do this')
        query_data = {
            'api': self._api,
            'url': '/dictionary/get',
            'request_data': request_data,
            'errors_mapping': errors_mapping,
            'required_sid': True,
        }
        return QueryO(**query_data)
    
    def delete(
        self,
        uuid,
    ):
        """Delete.
        :param uuid: The dictionary id
        """
        request_data = {
           'uuid': uuid,
        }
	
        errors_mapping = {}
        errors_mapping['MISSING_FIELDS'] = MissingFields('A required field is missing or does not have data in it. The error_subtype holds a array of all the missing fields')
        errors_mapping['NOT_FOUND'] = NotFound('The dictionary can not be found')
        errors_mapping['NOT_PERMITTED'] = NotPermitted('You are not permitted to do this')
        query_data = {
            'api': self._api,
            'url': '/dictionary/delete',
            'request_data': request_data,
            'errors_mapping': errors_mapping,
            'required_sid': True,
        }
        return QueryO(**query_data)
    
    def entries(
        self,
        uuid,
        lookup=None,
    ):
        """Entries.
        :param uuid: The dictionary id
        :param lookup: Only return the entry for the optional lookup entry (optional)
        """
        request_data = {
           'uuid': uuid,
           'lookup': lookup,
        }
	
        errors_mapping = {}
        errors_mapping['MISSING_FIELDS'] = MissingFields('A required field is missing or does not have data in it. The error_subtype holds a array of all the missing fields')
        errors_mapping['NOT_FOUND'] = NotFound('The dictionary can not be found')
        errors_mapping['NOT_LIST'] = NotList('The field is not a JSON array. The error_subtype holds the name of the field')
        errors_mapping['NOT_PERMITTED'] = NotPermitted('You are not permitted to do this')
        query_data = {
            'api': self._api,
            'url': '/dictionary/entries',
            'request_data': request_data,
            'errors_mapping': errors_mapping,
            'required_sid': True,
        }
        return QueryO(**query_data)
    
    def entry_add(
        self,
        lookup,
        replace,
        uuid,
        regexp=None,
    ):
        """Entry add.
        :param lookup: The JSON array of the lookup values to add. Alternatively a regular expression if the regexp parameter is passed
        :param replace: The JSON array of the replacement field values
        :param uuid: The dictionary id
        :param regexp: An integer value that indicates that this entry is a regular expression (optional)
        """
        request_data = {
           'replace': replace,
           'regexp': regexp,
           'uuid': uuid,
           'lookup': lookup,
        }
	
        errors_mapping = {}
        errors_mapping['INVALID_INTEGER'] = InvalidInteger('Invalid integer. The error_subtype holds the invalid integer.')
        errors_mapping['INVALID_LOOKUP'] = InvalidLookup('The lookup does not have the required number of fields')
        errors_mapping['INVALID_REGEXP'] = InvalidRegexp('Invalid regular expression. The error_subtype holds the invalid regexp.')
        errors_mapping['MISSING_FIELDS'] = MissingFields('A required field is missing or does not have data in it. The error_subtype holds a array of all the missing fields')
        errors_mapping['NOT_FOUND'] = NotFound('The dictionary can not be found')
        errors_mapping['NOT_LIST'] = NotList('The field is not a JSON array. The error_subtype holds the name of the field')
        errors_mapping['NOT_PERMITTED'] = NotPermitted('You are not permitted to do this')
        query_data = {
            'api': self._api,
            'url': '/dictionary/entry/add',
            'request_data': request_data,
            'errors_mapping': errors_mapping,
            'required_sid': True,
        }
        return QueryO(**query_data)
    
    def entry_delete(
        self,
        lookup,
        uuid,
    ):
        """Entry delete.
        :param lookup: The JSON array of the lookup values or the regular expression to delete
        :param uuid: The dictionary id
        """
        request_data = {
           'uuid': uuid,
           'lookup': lookup,
        }
	
        errors_mapping = {}
        errors_mapping['MISSING_FIELDS'] = MissingFields('A required field is missing or does not have data in it. The error_subtype holds a array of all the missing fields')
        errors_mapping['NOT_FOUND'] = NotFound('The dictionary or entry  can not be found')
        errors_mapping['NOT_LIST'] = NotList('The field is not a JSON array. The error_subtype holds the name of the field')
        errors_mapping['NOT_PERMITTED'] = NotPermitted('You are not permitted to do this')
        query_data = {
            'api': self._api,
            'url': '/dictionary/entry/delete',
            'request_data': request_data,
            'errors_mapping': errors_mapping,
            'required_sid': True,
        }
        return QueryO(**query_data)
    
    def attach(
        self,
        uuid,
        account_id=None,
        add_if_no_match=None,
        approve_if_match=None,
        namespace_id=None,
        sequence=None,
        skip_if_lookup_unchanged=None,
        skip_if_replace_has_value=None,
    ):
        """Attach.
        :param uuid: The dictionary id
        :param account_id: account_id
        :param add_if_no_match: Flag to add the lookup and replace values to the dictionary if no match occurs (optional)
        :param approve_if_match: Approve the object if there was a match (optional)
        :param namespace_id: namespace_id
        :param sequence: An integer value. Attachments are processed from low number to high number (optional)
        :param skip_if_lookup_unchanged: Flag to skip the lookup if the lookup field(s) are un-changed (optional)
        :param skip_if_replace_has_value: Flag to skip the lookup if the replace field already has a value (optional)

        Notes:
        (account_id OR namespace_id) - uuid of the account or namespace to the dictionary to
        """
        request_data = {
           'skip_if_lookup_unchanged': skip_if_lookup_unchanged,
           'sequence': sequence,
           'skip_if_replace_has_value': skip_if_replace_has_value,
           'namespace_id': namespace_id,
           'uuid': uuid,
           'add_if_no_match': add_if_no_match,
           'approve_if_match': approve_if_match,
           'account_id': account_id,
        }
	
        errors_mapping = {}
        errors_mapping['MISSING_FIELDS'] = MissingFields('A required field is missing or does not have data in it. The error_subtype holds a array of all the missing fields')
        errors_mapping['NOT_FOUND'] = NotFound('The dictionary or entry  can not be found')
        errors_mapping['NOT_PERMITTED'] = NotPermitted('You are not permitted to do this')
        query_data = {
            'api': self._api,
            'url': '/dictionary/attach',
            'request_data': request_data,
            'errors_mapping': errors_mapping,
            'required_sid': True,
        }
        return QueryO(**query_data)
    
    def attach_set(
        self,
        uuid,
        add_if_no_match=None,
        approve_if_match=None,
        sequence=None,
        skip_if_lookup_unchanged=None,
        skip_if_replace_has_value=None,
    ):
        """Attach set.
        :param uuid: The dictionary attach id
        :param add_if_no_match: Flag to add the lookup and replace values to the dictionary if no match occurs (optional)
        :param approve_if_match: Approve the object if there was a match (optional)
        :param sequence: An integer value. Attachments are processed from low number to high number (optional)
        :param skip_if_lookup_unchanged: Flag to skip the lookup if the lookup field(s) are un-changed (optional)
        :param skip_if_replace_has_value: Flag to skip the lookup if any of the replace fields already has a value (optional)
        """
        request_data = {
           'skip_if_lookup_unchanged': skip_if_lookup_unchanged,
           'sequence': sequence,
           'skip_if_replace_has_value': skip_if_replace_has_value,
           'uuid': uuid,
           'add_if_no_match': add_if_no_match,
           'approve_if_match': approve_if_match,
        }
	
        errors_mapping = {}
        errors_mapping['MISSING_FIELDS'] = MissingFields('A required field is missing or does not have data in it. The error_subtype holds a array of all the missing fields')
        errors_mapping['NOT_FOUND'] = NotFound('The dictionary attachment can not be found')
        errors_mapping['NOT_PERMITTED'] = NotPermitted('You are not permitted to do this')
        query_data = {
            'api': self._api,
            'url': '/dictionary/attach/set',
            'request_data': request_data,
            'errors_mapping': errors_mapping,
            'required_sid': True,
        }
        return QueryO(**query_data)
    
    def detach(
        self,
        uuid,
    ):
        """Detach.
        :param uuid: The dictionary attach id
        """
        request_data = {
           'uuid': uuid,
        }
	
        errors_mapping = {}
        errors_mapping['MISSING_FIELDS'] = MissingFields('A required field is missing or does not have data in it. The error_subtype holds a array of all the missing fields')
        errors_mapping['NOT_FOUND'] = NotFound('The dictionary attachment can not be found')
        errors_mapping['NOT_PERMITTED'] = NotPermitted('You are not permitted to do this')
        query_data = {
            'api': self._api,
            'url': '/dictionary/detach',
            'request_data': request_data,
            'errors_mapping': errors_mapping,
            'required_sid': True,
        }
        return QueryO(**query_data)
    