""" Namespace.

Do not edit this file by hand.
This is generated by parsing api.html service doc.
"""
from ambra_sdk.exceptions.service import InvalidAmount
from ambra_sdk.exceptions.service import InvalidCondition
from ambra_sdk.exceptions.service import InvalidCredentials
from ambra_sdk.exceptions.service import InvalidCurrency
from ambra_sdk.exceptions.service import InvalidCustomfield
from ambra_sdk.exceptions.service import InvalidFieldName
from ambra_sdk.exceptions.service import InvalidFlag
from ambra_sdk.exceptions.service import InvalidInteger
from ambra_sdk.exceptions.service import InvalidJson
from ambra_sdk.exceptions.service import InvalidLink
from ambra_sdk.exceptions.service import InvalidRegexp
from ambra_sdk.exceptions.service import InvalidSetting
from ambra_sdk.exceptions.service import InvalidSettingValue
from ambra_sdk.exceptions.service import MissingFields
from ambra_sdk.exceptions.service import NeedsAnyOrAll
from ambra_sdk.exceptions.service import NotFound
from ambra_sdk.exceptions.service import NotHash
from ambra_sdk.exceptions.service import NotList
from ambra_sdk.exceptions.service import NotPermitted
from ambra_sdk.exceptions.service import OnlyAll
from ambra_sdk.service.query import QueryO

class Namespace:
    """Namespace."""

    def __init__(self, api):
        self._api = api

    
    def permissions(
        self,
        namespace_id=None,
        oauth=None,
        phi_namespace=None,
        serial_no=None,
        storage_namespace=None,
        study_id=None,
        study_uid=None,
        uuid=None,
    ):
        """Permissions.
        :param namespace_id: namespace_id
        :param oauth: Flag to return the OAuth token information for the user (optional)
        :param phi_namespace: phi_namespace
        :param serial_no: serial_no
        :param storage_namespace: storage_namespace
        :param study_id: study_id
        :param study_uid: study_uid
        :param uuid: uuid

        Notes:
        (namespace_id OR study_id OR study_uid AND storage_namespace AND phi_namespace) The uuid of the namespace or study or the study_uid/storage_namespace/phi_namespace triplet
        (sid OR uuid AND serial_no) - Either the sid or the node id and serial number
        """
        request_data = {
           'study_uid': study_uid,
           'storage_namespace': storage_namespace,
           'namespace_id': namespace_id,
           'oauth': oauth,
           'uuid': uuid,
           'serial_no': serial_no,
           'phi_namespace': phi_namespace,
           'study_id': study_id,
        }
	
        errors_mapping = {}
        errors_mapping['INVALID_CREDENTIALS'] = InvalidCredentials('The sid or node credentials are invalid')
        errors_mapping['MISSING_FIELDS'] = MissingFields('A required field is missing or does not have data in it. The error_subtype holds a array of all the missing fields')
        errors_mapping['NOT_FOUND'] = NotFound('The object was not found')
        query_data = {
            'api': self._api,
            'url': '/namespace/permissions',
            'request_data': request_data,
            'errors_mapping': errors_mapping,
            'required_sid': True,
        }
        return QueryO(**query_data)
    
    def settings(
        self,
        ai_settings,
        auto_create_patient,
        auto_enable_dicom_wrapping,
        cloud_storage_config,
        disable_duplicate_study_upload,
        enable_dicom_wrapping,
        enable_epic_patient_lookup,
        enable_multipart_uploader,
        link_defaults,
        no_dup_share,
        pixel_anonymize_color,
        priority_notifications,
        single_file_dicom_wrapping,
        study_field_flags,
        ui_json,
        upload_settings,
        uuid,
    ):
        """Settings.
        :param ai_settings: Dict of ai settings
        :param auto_create_patient: Value for the setting
        :param auto_enable_dicom_wrapping: Value for the setting
        :param cloud_storage_config: Value for the setting
        :param disable_duplicate_study_upload: Value for the setting
        :param enable_dicom_wrapping: Value for the setting
        :param enable_epic_patient_lookup: Value for the setting
        :param enable_multipart_uploader: Value for the setting
        :param link_defaults: Value for the setting
        :param no_dup_share: Flag to stop duplicate studies (same study_uid and image count) from getting shared into the namespace
        :param pixel_anonymize_color: Value for the setting
        :param priority_notifications: Value for the setting
        :param single_file_dicom_wrapping: Value for the setting
        :param study_field_flags: A JSON hash of study_field_* role values to override the role values for studies in the namespace
        :param ui_json: Value for the setting
        :param upload_settings: Value for the setting
        :param uuid: The uuid of the namespace

        Notes:
        The following account settings can be over-ridden in the namespace
        """
        request_data = {
           'disable_duplicate_study_upload': disable_duplicate_study_upload,
           'link_defaults': link_defaults,
           'no_dup_share': no_dup_share,
           'cloud_storage_config': cloud_storage_config,
           'upload_settings': upload_settings,
           'enable_multipart_uploader': enable_multipart_uploader,
           'single_file_dicom_wrapping': single_file_dicom_wrapping,
           'priority_notifications': priority_notifications,
           'ui_json': ui_json,
           'study_field_flags': study_field_flags,
           'auto_enable_dicom_wrapping': auto_enable_dicom_wrapping,
           'uuid': uuid,
           'enable_dicom_wrapping': enable_dicom_wrapping,
           'auto_create_patient': auto_create_patient,
           'pixel_anonymize_color': pixel_anonymize_color,
           'enable_epic_patient_lookup': enable_epic_patient_lookup,
        }
        if ai_settings is not None:
            ai_settings_dict = {'{prefix}{k}'.format(prefix='', k=k): v for k,v in ai_settings.items()}
            request_data.update(ai_settings_dict)
	
        errors_mapping = {}
        errors_mapping['INVALID_SETTING'] = InvalidSetting('An invalid setting was passed. The error_subtype holds the name of the invalid setting')
        errors_mapping['INVALID_SETTING_VALUE'] = InvalidSettingValue('An invalid setting value was passed. The error_subtype holds the name of the setting with the invalid value')
        errors_mapping['MISSING_FIELDS'] = MissingFields('A required field is missing or does not have data in it. The error_subtype holds a array of all the missing fields')
        errors_mapping['NOT_FOUND'] = NotFound('The namespace was not found')
        query_data = {
            'api': self._api,
            'url': '/namespace/settings',
            'request_data': request_data,
            'errors_mapping': errors_mapping,
            'required_sid': True,
        }
        return QueryO(**query_data)
    
    def share_code(
        self,
        namespace_id=None,
        serial_no=None,
        share_code=None,
        uuid=None,
    ):
        """Share_code.
        :param namespace_id: namespace_id
        :param serial_no: serial_no
        :param share_code: share_code
        :param uuid: uuid

        Notes:
        (share_code OR namespace_id) - The share code or namespace id
        (sid OR uuid AND serial_no) - Either the sid or the node id and serial number (optional)
        """
        request_data = {
           'namespace_id': namespace_id,
           'uuid': uuid,
           'serial_no': serial_no,
           'share_code': share_code,
        }
	
        errors_mapping = {}
        errors_mapping['INVALID_LINK'] = InvalidLink('The anonymous upload link is no longer valid')
        errors_mapping['MISSING_FIELDS'] = MissingFields('A required field is missing or does not have data in it. The error_subtype holds a array of all the missing fields')
        errors_mapping['NOT_FOUND'] = NotFound('The share code was not found or if gateway credentials are passed is not valid for gateway uploads')
        query_data = {
            'api': self._api,
            'url': '/namespace/share_code',
            'request_data': request_data,
            'errors_mapping': errors_mapping,
            'required_sid': True,
        }
        return QueryO(**query_data)
    
    def share_pricing(
        self,
        uuid,
        charge_description=None,
        currency=None,
        pricing=None,
        second_opinion_config=None,
        second_opinion_share=None,
    ):
        """Share pricing.
        :param uuid: The uuid of the namespace
        :param charge_description: The description of the charge (optional)
        :param currency: currency
        :param pricing: Pricing table in JSON format (optional)
        :param second_opinion_config: JSON configuration for the second opinion workflow (optional)
        :param second_opinion_share: Flag to enable/disable the second opinion workflow for the share (optional)

        Notes:
        currency - 3-letter ISO code for currency to charge in (USD OR GBP) (optional)
        """
        request_data = {
           'pricing': pricing,
           'currency': currency,
           'uuid': uuid,
           'second_opinion_config': second_opinion_config,
           'second_opinion_share': second_opinion_share,
           'charge_description': charge_description,
        }
	
        errors_mapping = {}
        errors_mapping['INVALID_AMOUNT'] = InvalidAmount('An invalid amount. The error_subtype holds the invalid amount')
        errors_mapping['INVALID_CURRENCY'] = InvalidCurrency('Invalid currency')
        errors_mapping['INVALID_JSON'] = InvalidJson('The field is not in valid JSON format. The error_subtype holds the name of the field')
        errors_mapping['MISSING_FIELDS'] = MissingFields('A required field is missing or does not have data in it. The error_subtype holds a array of all the missing fields')
        errors_mapping['NEEDS_ANY_OR_ALL'] = NeedsAnyOrAll('The hash needs an &#34;ANY&#34; or &#34;ALL&#34; key')
        errors_mapping['NOT_FOUND'] = NotFound('The namespace was not found')
        errors_mapping['NOT_HASH'] = NotHash('The pricing field is not a hash')
        errors_mapping['NOT_PERMITTED'] = NotPermitted('You are not permitted to price this namespace')
        errors_mapping['ONLY_ALL'] = OnlyAll('If the hash has an ALL value it can&#39;t have any other values')
        query_data = {
            'api': self._api,
            'url': '/namespace/share/pricing',
            'request_data': request_data,
            'errors_mapping': errors_mapping,
            'required_sid': True,
        }
        return QueryO(**query_data)
    
    def case_pricing(
        self,
        uuid,
        case_pricing=None,
        sum_case_price_matches=None,
    ):
        """Case pricing.
        :param uuid: The uuid of the namespace
        :param case_pricing: Pricing table in JSON format (optional)
        :param sum_case_price_matches: Flag to search for all matches in pricing table and to add them up (optional)
        """
        request_data = {
           'sum_case_price_matches': sum_case_price_matches,
           'uuid': uuid,
           'case_pricing': case_pricing,
        }
	
        errors_mapping = {}
        errors_mapping['INVALID_CONDITION'] = InvalidCondition('The pricing condition is invalid')
        errors_mapping['INVALID_FLAG'] = InvalidFlag('The field is not a valid flag')
        errors_mapping['INVALID_INTEGER'] = InvalidInteger('The price is not an integer number')
        errors_mapping['INVALID_JSON'] = InvalidJson('The field is not in valid JSON format. The error_subtype holds the name of the field')
        errors_mapping['MISSING_FIELDS'] = MissingFields('A required field is missing or does not have data in it. The error_subtype holds a array of all the missing fields')
        errors_mapping['NOT_FOUND'] = NotFound('The namespace was not found')
        errors_mapping['NOT_LIST'] = NotList('The pricing table is not a JSON list')
        errors_mapping['NOT_PERMITTED'] = NotPermitted('You are not permitted to price this namespace')
        query_data = {
            'api': self._api,
            'url': '/namespace/case/pricing',
            'request_data': request_data,
            'errors_mapping': errors_mapping,
            'required_sid': True,
        }
        return QueryO(**query_data)
    
    def anonymize(
        self,
        uuid,
        prompt_for_anonymize=None,
        rules=None,
    ):
        """Anonymize.
        :param uuid: The uuid of the namespace
        :param prompt_for_anonymize: Flag to prompt if the anonymization rules should be applied. Only applicable to ingress anonymization. (optional)
        :param rules: Anonymization rules in JSON format. The format is a hash with the keys the names of the fields to anonymize and the values the regular expressions to apply. (optional)
        """
        request_data = {
           'rules': rules,
           'uuid': uuid,
           'prompt_for_anonymize': prompt_for_anonymize,
        }
	
        errors_mapping = {}
        errors_mapping['INVALID_FIELD_NAME'] = InvalidFieldName('The field name is n the rules hash is invalid. The error_subtype holds the invalid field name')
        errors_mapping['INVALID_JSON'] = InvalidJson('The field is not in valid JSON format. The error_subtype holds the name of the field')
        errors_mapping['INVALID_REGEXP'] = InvalidRegexp('Invalid regular expression. The error_subtype holds the invalid regexp.')
        errors_mapping['MISSING_FIELDS'] = MissingFields('A required field is missing or does not have data in it. The error_subtype holds a array of all the missing fields')
        errors_mapping['NOT_FOUND'] = NotFound('The namespace was not found')
        errors_mapping['NOT_HASH'] = NotHash('The rules field is not a hash')
        errors_mapping['NOT_PERMITTED'] = NotPermitted('You are not permitted to anonymize this namespace')
        query_data = {
            'api': self._api,
            'url': '/namespace/anonymize',
            'request_data': request_data,
            'errors_mapping': errors_mapping,
            'required_sid': True,
        }
        return QueryO(**query_data)
    
    def coverpage(
        self,
        uuid,
        coverpage=None,
    ):
        """Coverpage.
        :param uuid: The uuid of the namespace
        :param coverpage: The coverpage value. See the notes for formatting details or pass an empty string to remove the current cover page. (optional)
        """
        request_data = {
           'uuid': uuid,
           'coverpage': coverpage,
        }
	
        errors_mapping = {}
        errors_mapping['MISSING_FIELDS'] = MissingFields('A required field is missing or does not have data in it. The error_subtype holds a array of all the missing fields')
        errors_mapping['NOT_FOUND'] = NotFound('The namespace was not found')
        errors_mapping['NOT_PERMITTED'] = NotPermitted('You are not permitted to do this')
        query_data = {
            'api': self._api,
            'url': '/namespace/coverpage',
            'request_data': request_data,
            'errors_mapping': errors_mapping,
            'required_sid': True,
        }
        return QueryO(**query_data)
    
    def validate_customfields(
        self,
        share_code,
        customfield_param=None,
    ):
        """Validate customfields.
        :param share_code: The share code
        :param customfield_param: Custom field(s)
        """
        request_data = {
           'share_code': share_code,
        }
        if customfield_param is not None:
            customfield_param_dict = {'{prefix}{k}'.format(prefix='customfield-', k=k): v for k,v in customfield_param.items()}
            request_data.update(customfield_param_dict)
	
        errors_mapping = {}
        errors_mapping['INVALID_CUSTOMFIELD'] = InvalidCustomfield('Invalid custom field(s) name or value were passed. The error_subtype holds an array of the error details')
        query_data = {
            'api': self._api,
            'url': '/namespace/validate/customfields',
            'request_data': request_data,
            'errors_mapping': errors_mapping,
            'required_sid': False,
        }
        return QueryO(**query_data)
    
    def event_defaults(
        self,
        uuid,
        event_approve=None,
        event_case_assignment=None,
        event_harvest=None,
        event_link=None,
        event_link_mine=None,
        event_message=None,
        event_new_report=None,
        event_node=None,
        event_report_remove=None,
        event_share=None,
        event_status_change=None,
        event_study_comment=None,
        event_thin_study_fail=None,
        event_thin_study_success=None,
        event_upload=None,
        event_upload_fail=None,
    ):
        """Event defaults.
        :param uuid: The uuid of the namespace
        :param event_approve: Notify the user on a approval needed into the namespace (optional)
        :param event_case_assignment: Notify the user when they are assigned a case as a medical or admin user (optional)
        :param event_harvest: Notify the user on a harvest into the namespace (optional)
        :param event_link: Notify the user when an anonymous link is hit in the namespace (optional)
        :param event_link_mine: Notify the user when an anonymous link created by the user is hit in the namespace (optional)
        :param event_message: Notify the user when a message is sent to the namespace (optional)
        :param event_new_report: Notify the user when a report is attached in the namespace (optional)
        :param event_node: Notify the user when a namespace node sends an event (optional)
        :param event_report_remove: Notify the user when a report is removed in the namespace (optional)
        :param event_share: Notify the user on a share into the namespace (optional)
        :param event_status_change: Notify the user when the status of a study is changed (optional)
        :param event_study_comment: Notify the user when a comment is attached to a study in the namespace (optional)
        :param event_thin_study_fail: Notify the user when a thin study retrieval they initiated fails (optional)
        :param event_thin_study_success: Notify the user when a thin study retrieval they initiated succeeds (optional)
        :param event_upload: Notify the user on an upload into the namespace (optional)
        :param event_upload_fail: Notify the user on a failed upload into the namespace (optional)
        """
        request_data = {
           'event_link_mine': event_link_mine,
           'event_study_comment': event_study_comment,
           'event_case_assignment': event_case_assignment,
           'event_thin_study_success': event_thin_study_success,
           'event_report_remove': event_report_remove,
           'event_upload': event_upload,
           'event_link': event_link,
           'event_thin_study_fail': event_thin_study_fail,
           'uuid': uuid,
           'event_share': event_share,
           'event_approve': event_approve,
           'event_upload_fail': event_upload_fail,
           'event_harvest': event_harvest,
           'event_status_change': event_status_change,
           'event_node': event_node,
           'event_new_report': event_new_report,
           'event_message': event_message,
        }
	
        errors_mapping = {}
        errors_mapping['INVALID_FLAG'] = InvalidFlag('An invalid flag was passed. The error_subtype holds the name of the invalid flag')
        errors_mapping['MISSING_FIELDS'] = MissingFields('A required field is missing or does not have data in it. The error_subtype holds a array of all the missing fields')
        errors_mapping['NOT_FOUND'] = NotFound('The namespace was not found')
        errors_mapping['NOT_PERMITTED'] = NotPermitted('You are not permitted to apply defaults to this namespace')
        query_data = {
            'api': self._api,
            'url': '/namespace/event/defaults',
            'request_data': request_data,
            'errors_mapping': errors_mapping,
            'required_sid': True,
        }
        return QueryO(**query_data)
    
    def study_defaults(
        self,
        uuid,
        defaults=None,
    ):
        """Study defaults.
        :param uuid: The uuid of the namespace
        :param defaults: Default values in JSON format. The format is a hash with the keys the names of the fields and the values are the default value. The available field name are as listed in the returned field hash. (optional)
        """
        request_data = {
           'defaults': defaults,
           'uuid': uuid,
        }
	
        errors_mapping = {}
        errors_mapping['INVALID_FIELD_NAME'] = InvalidFieldName('The field name in the default hash is invalid. The error_subtype holds the invalid field name')
        errors_mapping['INVALID_JSON'] = InvalidJson('The field is not in valid JSON format. The error_subtype holds the name of the field')
        errors_mapping['MISSING_FIELDS'] = MissingFields('A required field is missing or does not have data in it. The error_subtype holds a array of all the missing fields')
        errors_mapping['NOT_FOUND'] = NotFound('The namespace was not found')
        errors_mapping['NOT_HASH'] = NotHash('The rules field is not a hash')
        errors_mapping['NOT_PERMITTED'] = NotPermitted('You are not permitted to apply defaults to this namespace')
        query_data = {
            'api': self._api,
            'url': '/namespace/study/defaults',
            'request_data': request_data,
            'errors_mapping': errors_mapping,
            'required_sid': True,
        }
        return QueryO(**query_data)
    
    def engine_fqdn(
        self,
        namespace_id=None,
        phi_namespace=None,
        source=None,
        storage_namespace=None,
        study_id=None,
        study_uid=None,
    ):
        """Engine fqdn.
        :param namespace_id: namespace_id
        :param phi_namespace: phi_namespace
        :param source: The source of the query (optional)
        :param storage_namespace: storage_namespace
        :param study_id: study_id
        :param study_uid: study_uid

        Notes:
        (namespace_id OR study_id OR study_uid AND storage_namespace AND phi_namespace) - The uuid of the namespace or study or the study_uid/storage_namespace/phi_namespace triplet
        """
        request_data = {
           'source': source,
           'study_uid': study_uid,
           'namespace_id': namespace_id,
           'storage_namespace': storage_namespace,
           'phi_namespace': phi_namespace,
           'study_id': study_id,
        }
	
        errors_mapping = {}
        errors_mapping['MISSING_FIELDS'] = MissingFields('A required field is missing or does not have data in it. The error_subtype holds a array of all the missing fields')
        errors_mapping['NOT_FOUND'] = NotFound('The namespace was not found')
        query_data = {
            'api': self._api,
            'url': '/namespace/engine/fqdn',
            'request_data': request_data,
            'errors_mapping': errors_mapping,
            'required_sid': False,
        }
        return QueryO(**query_data)
    
    def removed_user_report(
        self,
        email,
        uuid,
    ):
        """Removed user report.
        :param email: Optional email address to send the report to
        :param uuid: The UUID of the namespace
        """
        request_data = {
           'email': email,
           'uuid': uuid,
        }
	
        errors_mapping = {}
        errors_mapping['MISSING_FIELDS'] = MissingFields('A required field is missing or does not have data in it. The error_subtype holds a array of all the missing fields')
        errors_mapping['NOT_FOUND'] = NotFound('The namespace was not found')
        errors_mapping['NOT_PERMITTED'] = NotPermitted('You are not permitted to do this')
        query_data = {
            'api': self._api,
            'url': '/namespace/removed/user/report',
            'request_data': request_data,
            'errors_mapping': errors_mapping,
            'required_sid': True,
        }
        return QueryO(**query_data)
    