""" Tag.

Do not edit this file by hand.
This is generated by parsing api.html service doc.
"""
from ambra_sdk.exceptions.service import FilterNotFound
from ambra_sdk.exceptions.service import InvalidCondition
from ambra_sdk.exceptions.service import InvalidField
from ambra_sdk.exceptions.service import InvalidObject
from ambra_sdk.exceptions.service import InvalidSortField
from ambra_sdk.exceptions.service import InvalidSortOrder
from ambra_sdk.exceptions.service import MissingFields
from ambra_sdk.exceptions.service import NotFound
from ambra_sdk.exceptions.service import NotPermitted
from ambra_sdk.service.query import QueryO
from ambra_sdk.service.query import QueryOPSF

class Tag:
    """Tag."""

    def __init__(self, api):
        self._api = api

    
    def list(
        self,
        object=None,
    ):
        """List.
        :param object: object

        Notes:
        object - Object class (Study OR User_account OR Group OR Location OR Account OR Patient OR Case OR Order OR Message)
        """
        request_data = {
           'object': object,
        }
	
        errors_mapping = {}
        errors_mapping['FILTER_NOT_FOUND'] = FilterNotFound('The filter can not be found. The error_subtype will hold the filter UUID')
        errors_mapping['INVALID_CONDITION'] = InvalidCondition('The condition is not support. The error_subtype will hold the filter expression this applies to')
        errors_mapping['INVALID_FIELD'] = InvalidField('The field is not valid for this object. The error_subtype will hold the filter expression this applies to')
        errors_mapping['INVALID_SORT_FIELD'] = InvalidSortField('The field is not valid for this object. The error_subtype will hold the field name this applies to')
        errors_mapping['INVALID_SORT_ORDER'] = InvalidSortOrder('The sort order for the field is invalid. The error_subtype will hold the field name this applies to')
        query_data = {
            'api': self._api,
            'url': '/tag/list',
            'request_data': request_data,
            'errors_mapping': errors_mapping,
            'required_sid': True,
        }
        query_data['paginated_field'] = 'tags'
        return QueryOPSF(**query_data)
    
    def add(
        self,
        object_id,
        tag,
        object=None,
    ):
        """Add.
        :param object_id: UUID of the object
        :param tag: Value of the tag
        :param object: object

        Notes:
        object - Object class to apply it to (Study OR User_account OR Group OR Location OR Account OR Patient OR Case OR Order OR Message)
        """
        request_data = {
           'tag': tag,
           'object': object,
           'object_id': object_id,
        }
	
        errors_mapping = {}
        errors_mapping['INVALID_OBJECT'] = InvalidObject('The object type is invalid')
        errors_mapping['MISSING_FIELDS'] = MissingFields('A required field is missing or does not have data in it. The error_subtype holds a array of all the missing fields')
        errors_mapping['NOT_FOUND'] = NotFound('The object was not found')
        errors_mapping['NOT_PERMITTED'] = NotPermitted('You are not permitted to tag this object')
        query_data = {
            'api': self._api,
            'url': '/tag/add',
            'request_data': request_data,
            'errors_mapping': errors_mapping,
            'required_sid': True,
        }
        return QueryO(**query_data)
    
    def delete(
        self,
        object_id,
        tag,
        object=None,
    ):
        """Delete.
        :param object_id: UUID of the object
        :param tag: Value of the tag
        :param object: object

        Notes:
        object - Object class to apply it to (Study OR User_account OR Group OR Location OR Account OR Patient OR Case OR Order)
        """
        request_data = {
           'tag': tag,
           'object': object,
           'object_id': object_id,
        }
	
        errors_mapping = {}
        errors_mapping['INVALID_OBJECT'] = InvalidObject('The object type is invalid')
        errors_mapping['MISSING_FIELDS'] = MissingFields('A required field is missing or does not have data in it. The error_subtype holds a array of all the missing fields')
        errors_mapping['NOT_FOUND'] = NotFound('The object was not found')
        query_data = {
            'api': self._api,
            'url': '/tag/delete',
            'request_data': request_data,
            'errors_mapping': errors_mapping,
            'required_sid': True,
        }
        return QueryO(**query_data)
    