# pylint:disable=line-too-long
import logging

from ...sim_type import SimTypeFunction,     SimTypeShort, SimTypeInt, SimTypeLong, SimTypeLongLong, SimTypeDouble, SimTypeFloat,     SimTypePointer,     SimTypeChar,     SimStruct,     SimTypeFixedSizeArray,     SimTypeBottom,     SimUnion,     SimTypeBool
from ...calling_conventions import SimCCStdcall, SimCCMicrosoftAMD64
from .. import SIM_PROCEDURES as P
from . import SimLibrary


_l = logging.getLogger(name=__name__)


lib = SimLibrary()
lib.set_default_cc('X86', SimCCStdcall)
lib.set_default_cc('AMD64', SimCCMicrosoftAMD64)
lib.set_library_names("msacm32.dll")
prototypes = \
    {
        # 
        'acmGetVersion': SimTypeFunction([], SimTypeInt(signed=False, label="UInt32")),
        # 
        'acmMetrics': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["hao", "uMetric", "pMetric"]),
        # 
        'acmDriverEnum': SimTypeFunction([SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["hadid", "dwInstance", "fdwSupport"]), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=False, label="UInt32"), arg_names=["fnCallback", "dwInstance", "fdwEnum"]),
        # 
        'acmDriverID': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=False, label="UInt32"), arg_names=["hao", "phadid", "fdwDriverID"]),
        # 
        'acmDriverAddA': SimTypeFunction([SimTypePointer(SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=False, label="UInt32"), arg_names=["phadid", "hinstModule", "lParam", "dwPriority", "fdwAdd"]),
        # 
        'acmDriverAddW': SimTypeFunction([SimTypePointer(SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=False, label="UInt32"), arg_names=["phadid", "hinstModule", "lParam", "dwPriority", "fdwAdd"]),
        # 
        'acmDriverRemove': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=False, label="UInt32"), arg_names=["hadid", "fdwRemove"]),
        # 
        'acmDriverOpen': SimTypeFunction([SimTypePointer(SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=False, label="UInt32"), arg_names=["phad", "hadid", "fdwOpen"]),
        # 
        'acmDriverClose': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=False, label="UInt32"), arg_names=["had", "fdwClose"]),
        # 
        'acmDriverMessage': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)], SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), arg_names=["had", "uMsg", "lParam1", "lParam2"]),
        # 
        'acmDriverPriority': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=False, label="UInt32"), arg_names=["hadid", "dwPriority", "fdwPriority"]),
        # 
        'acmDriverDetailsA': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimStruct({"cbStruct": SimTypeInt(signed=False, label="UInt32"), "fccType": SimTypeInt(signed=False, label="UInt32"), "fccComp": SimTypeInt(signed=False, label="UInt32"), "wMid": SimTypeShort(signed=False, label="UInt16"), "wPid": SimTypeShort(signed=False, label="UInt16"), "vdwACM": SimTypeInt(signed=False, label="UInt32"), "vdwDriver": SimTypeInt(signed=False, label="UInt32"), "fdwSupport": SimTypeInt(signed=False, label="UInt32"), "cFormatTags": SimTypeInt(signed=False, label="UInt32"), "cFilterTags": SimTypeInt(signed=False, label="UInt32"), "hicon": SimTypeBottom(label="HICON"), "szShortName": SimTypeFixedSizeArray(SimTypeBottom(label="CHAR"), 32), "szLongName": SimTypeFixedSizeArray(SimTypeBottom(label="CHAR"), 128), "szCopyright": SimTypeFixedSizeArray(SimTypeBottom(label="CHAR"), 80), "szLicensing": SimTypeFixedSizeArray(SimTypeBottom(label="CHAR"), 128), "szFeatures": SimTypeFixedSizeArray(SimTypeBottom(label="CHAR"), 512)}, name="ACMDRIVERDETAILSA", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=False, label="UInt32"), arg_names=["hadid", "padd", "fdwDetails"]),
        # 
        'acmDriverDetailsW': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimStruct({"cbStruct": SimTypeInt(signed=False, label="UInt32"), "fccType": SimTypeInt(signed=False, label="UInt32"), "fccComp": SimTypeInt(signed=False, label="UInt32"), "wMid": SimTypeShort(signed=False, label="UInt16"), "wPid": SimTypeShort(signed=False, label="UInt16"), "vdwACM": SimTypeInt(signed=False, label="UInt32"), "vdwDriver": SimTypeInt(signed=False, label="UInt32"), "fdwSupport": SimTypeInt(signed=False, label="UInt32"), "cFormatTags": SimTypeInt(signed=False, label="UInt32"), "cFilterTags": SimTypeInt(signed=False, label="UInt32"), "hicon": SimTypeBottom(label="HICON"), "szShortName": SimTypeFixedSizeArray(SimTypeChar(label="Char"), 32), "szLongName": SimTypeFixedSizeArray(SimTypeChar(label="Char"), 128), "szCopyright": SimTypeFixedSizeArray(SimTypeChar(label="Char"), 80), "szLicensing": SimTypeFixedSizeArray(SimTypeChar(label="Char"), 128), "szFeatures": SimTypeFixedSizeArray(SimTypeChar(label="Char"), 512)}, name="ACMDRIVERDETAILSW", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=False, label="UInt32"), arg_names=["hadid", "padd", "fdwDetails"]),
        # 
        'acmFormatTagDetailsA': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimStruct({"cbStruct": SimTypeInt(signed=False, label="UInt32"), "dwFormatTagIndex": SimTypeInt(signed=False, label="UInt32"), "dwFormatTag": SimTypeInt(signed=False, label="UInt32"), "cbFormatSize": SimTypeInt(signed=False, label="UInt32"), "fdwSupport": SimTypeInt(signed=False, label="UInt32"), "cStandardFormats": SimTypeInt(signed=False, label="UInt32"), "szFormatTag": SimTypeFixedSizeArray(SimTypeBottom(label="CHAR"), 48)}, name="ACMFORMATTAGDETAILSA", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=False, label="UInt32"), arg_names=["had", "paftd", "fdwDetails"]),
        # 
        'acmFormatTagDetailsW': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimStruct({"cbStruct": SimTypeInt(signed=False, label="UInt32"), "dwFormatTagIndex": SimTypeInt(signed=False, label="UInt32"), "dwFormatTag": SimTypeInt(signed=False, label="UInt32"), "cbFormatSize": SimTypeInt(signed=False, label="UInt32"), "fdwSupport": SimTypeInt(signed=False, label="UInt32"), "cStandardFormats": SimTypeInt(signed=False, label="UInt32"), "szFormatTag": SimTypeFixedSizeArray(SimTypeChar(label="Char"), 48)}, name="ACMFORMATTAGDETAILSW", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=False, label="UInt32"), arg_names=["had", "paftd", "fdwDetails"]),
        # 
        'acmFormatTagEnumA': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimStruct({"cbStruct": SimTypeInt(signed=False, label="UInt32"), "dwFormatTagIndex": SimTypeInt(signed=False, label="UInt32"), "dwFormatTag": SimTypeInt(signed=False, label="UInt32"), "cbFormatSize": SimTypeInt(signed=False, label="UInt32"), "fdwSupport": SimTypeInt(signed=False, label="UInt32"), "cStandardFormats": SimTypeInt(signed=False, label="UInt32"), "szFormatTag": SimTypeFixedSizeArray(SimTypeBottom(label="CHAR"), 48)}, name="ACMFORMATTAGDETAILSA", pack=False, align=None), offset=0), SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimStruct({"cbStruct": SimTypeInt(signed=False, label="UInt32"), "dwFormatTagIndex": SimTypeInt(signed=False, label="UInt32"), "dwFormatTag": SimTypeInt(signed=False, label="UInt32"), "cbFormatSize": SimTypeInt(signed=False, label="UInt32"), "fdwSupport": SimTypeInt(signed=False, label="UInt32"), "cStandardFormats": SimTypeInt(signed=False, label="UInt32"), "szFormatTag": SimTypeFixedSizeArray(SimTypeBottom(label="CHAR"), 48)}, name="ACMFORMATTAGDETAILSA", pack=False, align=None), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["hadid", "paftd", "dwInstance", "fdwSupport"]), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=False, label="UInt32"), arg_names=["had", "paftd", "fnCallback", "dwInstance", "fdwEnum"]),
        # 
        'acmFormatTagEnumW': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimStruct({"cbStruct": SimTypeInt(signed=False, label="UInt32"), "dwFormatTagIndex": SimTypeInt(signed=False, label="UInt32"), "dwFormatTag": SimTypeInt(signed=False, label="UInt32"), "cbFormatSize": SimTypeInt(signed=False, label="UInt32"), "fdwSupport": SimTypeInt(signed=False, label="UInt32"), "cStandardFormats": SimTypeInt(signed=False, label="UInt32"), "szFormatTag": SimTypeFixedSizeArray(SimTypeChar(label="Char"), 48)}, name="ACMFORMATTAGDETAILSW", pack=False, align=None), offset=0), SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimStruct({"cbStruct": SimTypeInt(signed=False, label="UInt32"), "dwFormatTagIndex": SimTypeInt(signed=False, label="UInt32"), "dwFormatTag": SimTypeInt(signed=False, label="UInt32"), "cbFormatSize": SimTypeInt(signed=False, label="UInt32"), "fdwSupport": SimTypeInt(signed=False, label="UInt32"), "cStandardFormats": SimTypeInt(signed=False, label="UInt32"), "szFormatTag": SimTypeFixedSizeArray(SimTypeChar(label="Char"), 48)}, name="ACMFORMATTAGDETAILSW", pack=False, align=None), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["hadid", "paftd", "dwInstance", "fdwSupport"]), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=False, label="UInt32"), arg_names=["had", "paftd", "fnCallback", "dwInstance", "fdwEnum"]),
        # 
        'acmFormatDetailsA': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimStruct({"cbStruct": SimTypeInt(signed=False, label="UInt32"), "dwFormatIndex": SimTypeInt(signed=False, label="UInt32"), "dwFormatTag": SimTypeInt(signed=False, label="UInt32"), "fdwSupport": SimTypeInt(signed=False, label="UInt32"), "pwfx": SimTypePointer(SimStruct({"wFormatTag": SimTypeShort(signed=False, label="UInt16"), "nChannels": SimTypeShort(signed=False, label="UInt16"), "nSamplesPerSec": SimTypeInt(signed=False, label="UInt32"), "nAvgBytesPerSec": SimTypeInt(signed=False, label="UInt32"), "nBlockAlign": SimTypeShort(signed=False, label="UInt16"), "wBitsPerSample": SimTypeShort(signed=False, label="UInt16"), "cbSize": SimTypeShort(signed=False, label="UInt16")}, name="WAVEFORMATEX", pack=False, align=None), offset=0), "cbwfx": SimTypeInt(signed=False, label="UInt32"), "szFormat": SimTypeFixedSizeArray(SimTypeBottom(label="CHAR"), 128)}, name="ACMFORMATDETAILSA", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=False, label="UInt32"), arg_names=["had", "pafd", "fdwDetails"]),
        # 
        'acmFormatDetailsW': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimStruct({"cbStruct": SimTypeInt(signed=False, label="UInt32"), "dwFormatIndex": SimTypeInt(signed=False, label="UInt32"), "dwFormatTag": SimTypeInt(signed=False, label="UInt32"), "fdwSupport": SimTypeInt(signed=False, label="UInt32"), "pwfx": SimTypePointer(SimStruct({"wFormatTag": SimTypeShort(signed=False, label="UInt16"), "nChannels": SimTypeShort(signed=False, label="UInt16"), "nSamplesPerSec": SimTypeInt(signed=False, label="UInt32"), "nAvgBytesPerSec": SimTypeInt(signed=False, label="UInt32"), "nBlockAlign": SimTypeShort(signed=False, label="UInt16"), "wBitsPerSample": SimTypeShort(signed=False, label="UInt16"), "cbSize": SimTypeShort(signed=False, label="UInt16")}, name="WAVEFORMATEX", pack=False, align=None), offset=0), "cbwfx": SimTypeInt(signed=False, label="UInt32"), "szFormat": SimTypeFixedSizeArray(SimTypeChar(label="Char"), 128)}, name="tACMFORMATDETAILSW", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=False, label="UInt32"), arg_names=["had", "pafd", "fdwDetails"]),
        # 
        'acmFormatEnumA': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimStruct({"cbStruct": SimTypeInt(signed=False, label="UInt32"), "dwFormatIndex": SimTypeInt(signed=False, label="UInt32"), "dwFormatTag": SimTypeInt(signed=False, label="UInt32"), "fdwSupport": SimTypeInt(signed=False, label="UInt32"), "pwfx": SimTypePointer(SimStruct({"wFormatTag": SimTypeShort(signed=False, label="UInt16"), "nChannels": SimTypeShort(signed=False, label="UInt16"), "nSamplesPerSec": SimTypeInt(signed=False, label="UInt32"), "nAvgBytesPerSec": SimTypeInt(signed=False, label="UInt32"), "nBlockAlign": SimTypeShort(signed=False, label="UInt16"), "wBitsPerSample": SimTypeShort(signed=False, label="UInt16"), "cbSize": SimTypeShort(signed=False, label="UInt16")}, name="WAVEFORMATEX", pack=False, align=None), offset=0), "cbwfx": SimTypeInt(signed=False, label="UInt32"), "szFormat": SimTypeFixedSizeArray(SimTypeBottom(label="CHAR"), 128)}, name="ACMFORMATDETAILSA", pack=False, align=None), offset=0), SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimStruct({"cbStruct": SimTypeInt(signed=False, label="UInt32"), "dwFormatIndex": SimTypeInt(signed=False, label="UInt32"), "dwFormatTag": SimTypeInt(signed=False, label="UInt32"), "fdwSupport": SimTypeInt(signed=False, label="UInt32"), "pwfx": SimTypePointer(SimStruct({"wFormatTag": SimTypeShort(signed=False, label="UInt16"), "nChannels": SimTypeShort(signed=False, label="UInt16"), "nSamplesPerSec": SimTypeInt(signed=False, label="UInt32"), "nAvgBytesPerSec": SimTypeInt(signed=False, label="UInt32"), "nBlockAlign": SimTypeShort(signed=False, label="UInt16"), "wBitsPerSample": SimTypeShort(signed=False, label="UInt16"), "cbSize": SimTypeShort(signed=False, label="UInt16")}, name="WAVEFORMATEX", pack=False, align=None), offset=0), "cbwfx": SimTypeInt(signed=False, label="UInt32"), "szFormat": SimTypeFixedSizeArray(SimTypeBottom(label="CHAR"), 128)}, name="ACMFORMATDETAILSA", pack=False, align=None), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["hadid", "pafd", "dwInstance", "fdwSupport"]), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=False, label="UInt32"), arg_names=["had", "pafd", "fnCallback", "dwInstance", "fdwEnum"]),
        # 
        'acmFormatEnumW': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimStruct({"cbStruct": SimTypeInt(signed=False, label="UInt32"), "dwFormatIndex": SimTypeInt(signed=False, label="UInt32"), "dwFormatTag": SimTypeInt(signed=False, label="UInt32"), "fdwSupport": SimTypeInt(signed=False, label="UInt32"), "pwfx": SimTypePointer(SimStruct({"wFormatTag": SimTypeShort(signed=False, label="UInt16"), "nChannels": SimTypeShort(signed=False, label="UInt16"), "nSamplesPerSec": SimTypeInt(signed=False, label="UInt32"), "nAvgBytesPerSec": SimTypeInt(signed=False, label="UInt32"), "nBlockAlign": SimTypeShort(signed=False, label="UInt16"), "wBitsPerSample": SimTypeShort(signed=False, label="UInt16"), "cbSize": SimTypeShort(signed=False, label="UInt16")}, name="WAVEFORMATEX", pack=False, align=None), offset=0), "cbwfx": SimTypeInt(signed=False, label="UInt32"), "szFormat": SimTypeFixedSizeArray(SimTypeChar(label="Char"), 128)}, name="tACMFORMATDETAILSW", pack=False, align=None), offset=0), SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimStruct({"cbStruct": SimTypeInt(signed=False, label="UInt32"), "dwFormatIndex": SimTypeInt(signed=False, label="UInt32"), "dwFormatTag": SimTypeInt(signed=False, label="UInt32"), "fdwSupport": SimTypeInt(signed=False, label="UInt32"), "pwfx": SimTypePointer(SimStruct({"wFormatTag": SimTypeShort(signed=False, label="UInt16"), "nChannels": SimTypeShort(signed=False, label="UInt16"), "nSamplesPerSec": SimTypeInt(signed=False, label="UInt32"), "nAvgBytesPerSec": SimTypeInt(signed=False, label="UInt32"), "nBlockAlign": SimTypeShort(signed=False, label="UInt16"), "wBitsPerSample": SimTypeShort(signed=False, label="UInt16"), "cbSize": SimTypeShort(signed=False, label="UInt16")}, name="WAVEFORMATEX", pack=False, align=None), offset=0), "cbwfx": SimTypeInt(signed=False, label="UInt32"), "szFormat": SimTypeFixedSizeArray(SimTypeChar(label="Char"), 128)}, name="tACMFORMATDETAILSW", pack=False, align=None), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["hadid", "pafd", "dwInstance", "fdwSupport"]), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=False, label="UInt32"), arg_names=["had", "pafd", "fnCallback", "dwInstance", "fdwEnum"]),
        # 
        'acmFormatSuggest': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimStruct({"wFormatTag": SimTypeShort(signed=False, label="UInt16"), "nChannels": SimTypeShort(signed=False, label="UInt16"), "nSamplesPerSec": SimTypeInt(signed=False, label="UInt32"), "nAvgBytesPerSec": SimTypeInt(signed=False, label="UInt32"), "nBlockAlign": SimTypeShort(signed=False, label="UInt16"), "wBitsPerSample": SimTypeShort(signed=False, label="UInt16"), "cbSize": SimTypeShort(signed=False, label="UInt16")}, name="WAVEFORMATEX", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"wFormatTag": SimTypeShort(signed=False, label="UInt16"), "nChannels": SimTypeShort(signed=False, label="UInt16"), "nSamplesPerSec": SimTypeInt(signed=False, label="UInt32"), "nAvgBytesPerSec": SimTypeInt(signed=False, label="UInt32"), "nBlockAlign": SimTypeShort(signed=False, label="UInt16"), "wBitsPerSample": SimTypeShort(signed=False, label="UInt16"), "cbSize": SimTypeShort(signed=False, label="UInt16")}, name="WAVEFORMATEX", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=False, label="UInt32"), arg_names=["had", "pwfxSrc", "pwfxDst", "cbwfxDst", "fdwSuggest"]),
        # 
        'acmFormatChooseA': SimTypeFunction([SimTypePointer(SimStruct({"cbStruct": SimTypeInt(signed=False, label="UInt32"), "fdwStyle": SimTypeInt(signed=False, label="UInt32"), "hwndOwner": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "pwfx": SimTypePointer(SimStruct({"wFormatTag": SimTypeShort(signed=False, label="UInt16"), "nChannels": SimTypeShort(signed=False, label="UInt16"), "nSamplesPerSec": SimTypeInt(signed=False, label="UInt32"), "nAvgBytesPerSec": SimTypeInt(signed=False, label="UInt32"), "nBlockAlign": SimTypeShort(signed=False, label="UInt16"), "wBitsPerSample": SimTypeShort(signed=False, label="UInt16"), "cbSize": SimTypeShort(signed=False, label="UInt16")}, name="WAVEFORMATEX", pack=False, align=None), offset=0), "cbwfx": SimTypeInt(signed=False, label="UInt32"), "pszTitle": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "szFormatTag": SimTypeFixedSizeArray(SimTypeBottom(label="CHAR"), 48), "szFormat": SimTypeFixedSizeArray(SimTypeBottom(label="CHAR"), 128), "pszName": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cchName": SimTypeInt(signed=False, label="UInt32"), "fdwEnum": SimTypeInt(signed=False, label="UInt32"), "pwfxEnum": SimTypePointer(SimStruct({"wFormatTag": SimTypeShort(signed=False, label="UInt16"), "nChannels": SimTypeShort(signed=False, label="UInt16"), "nSamplesPerSec": SimTypeInt(signed=False, label="UInt32"), "nAvgBytesPerSec": SimTypeInt(signed=False, label="UInt32"), "nBlockAlign": SimTypeShort(signed=False, label="UInt16"), "wBitsPerSample": SimTypeShort(signed=False, label="UInt16"), "cbSize": SimTypeShort(signed=False, label="UInt16")}, name="WAVEFORMATEX", pack=False, align=None), offset=0), "hInstance": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "pszTemplateName": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "lCustData": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "pfnHook": SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["hwnd", "uMsg", "wParam", "lParam"]), offset=0)}, name="ACMFORMATCHOOSEA", pack=False, align=None), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["pafmtc"]),
        # 
        'acmFormatChooseW': SimTypeFunction([SimTypePointer(SimStruct({"cbStruct": SimTypeInt(signed=False, label="UInt32"), "fdwStyle": SimTypeInt(signed=False, label="UInt32"), "hwndOwner": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "pwfx": SimTypePointer(SimStruct({"wFormatTag": SimTypeShort(signed=False, label="UInt16"), "nChannels": SimTypeShort(signed=False, label="UInt16"), "nSamplesPerSec": SimTypeInt(signed=False, label="UInt32"), "nAvgBytesPerSec": SimTypeInt(signed=False, label="UInt32"), "nBlockAlign": SimTypeShort(signed=False, label="UInt16"), "wBitsPerSample": SimTypeShort(signed=False, label="UInt16"), "cbSize": SimTypeShort(signed=False, label="UInt16")}, name="WAVEFORMATEX", pack=False, align=None), offset=0), "cbwfx": SimTypeInt(signed=False, label="UInt32"), "pszTitle": SimTypePointer(SimTypeChar(label="Char"), offset=0), "szFormatTag": SimTypeFixedSizeArray(SimTypeChar(label="Char"), 48), "szFormat": SimTypeFixedSizeArray(SimTypeChar(label="Char"), 128), "pszName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "cchName": SimTypeInt(signed=False, label="UInt32"), "fdwEnum": SimTypeInt(signed=False, label="UInt32"), "pwfxEnum": SimTypePointer(SimStruct({"wFormatTag": SimTypeShort(signed=False, label="UInt16"), "nChannels": SimTypeShort(signed=False, label="UInt16"), "nSamplesPerSec": SimTypeInt(signed=False, label="UInt32"), "nAvgBytesPerSec": SimTypeInt(signed=False, label="UInt32"), "nBlockAlign": SimTypeShort(signed=False, label="UInt16"), "wBitsPerSample": SimTypeShort(signed=False, label="UInt16"), "cbSize": SimTypeShort(signed=False, label="UInt16")}, name="WAVEFORMATEX", pack=False, align=None), offset=0), "hInstance": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "pszTemplateName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "lCustData": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "pfnHook": SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["hwnd", "uMsg", "wParam", "lParam"]), offset=0)}, name="ACMFORMATCHOOSEW", pack=False, align=None), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["pafmtc"]),
        # 
        'acmFilterTagDetailsA': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimStruct({"cbStruct": SimTypeInt(signed=False, label="UInt32"), "dwFilterTagIndex": SimTypeInt(signed=False, label="UInt32"), "dwFilterTag": SimTypeInt(signed=False, label="UInt32"), "cbFilterSize": SimTypeInt(signed=False, label="UInt32"), "fdwSupport": SimTypeInt(signed=False, label="UInt32"), "cStandardFilters": SimTypeInt(signed=False, label="UInt32"), "szFilterTag": SimTypeFixedSizeArray(SimTypeBottom(label="CHAR"), 48)}, name="ACMFILTERTAGDETAILSA", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=False, label="UInt32"), arg_names=["had", "paftd", "fdwDetails"]),
        # 
        'acmFilterTagDetailsW': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimStruct({"cbStruct": SimTypeInt(signed=False, label="UInt32"), "dwFilterTagIndex": SimTypeInt(signed=False, label="UInt32"), "dwFilterTag": SimTypeInt(signed=False, label="UInt32"), "cbFilterSize": SimTypeInt(signed=False, label="UInt32"), "fdwSupport": SimTypeInt(signed=False, label="UInt32"), "cStandardFilters": SimTypeInt(signed=False, label="UInt32"), "szFilterTag": SimTypeFixedSizeArray(SimTypeChar(label="Char"), 48)}, name="ACMFILTERTAGDETAILSW", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=False, label="UInt32"), arg_names=["had", "paftd", "fdwDetails"]),
        # 
        'acmFilterTagEnumA': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimStruct({"cbStruct": SimTypeInt(signed=False, label="UInt32"), "dwFilterTagIndex": SimTypeInt(signed=False, label="UInt32"), "dwFilterTag": SimTypeInt(signed=False, label="UInt32"), "cbFilterSize": SimTypeInt(signed=False, label="UInt32"), "fdwSupport": SimTypeInt(signed=False, label="UInt32"), "cStandardFilters": SimTypeInt(signed=False, label="UInt32"), "szFilterTag": SimTypeFixedSizeArray(SimTypeBottom(label="CHAR"), 48)}, name="ACMFILTERTAGDETAILSA", pack=False, align=None), offset=0), SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimStruct({"cbStruct": SimTypeInt(signed=False, label="UInt32"), "dwFilterTagIndex": SimTypeInt(signed=False, label="UInt32"), "dwFilterTag": SimTypeInt(signed=False, label="UInt32"), "cbFilterSize": SimTypeInt(signed=False, label="UInt32"), "fdwSupport": SimTypeInt(signed=False, label="UInt32"), "cStandardFilters": SimTypeInt(signed=False, label="UInt32"), "szFilterTag": SimTypeFixedSizeArray(SimTypeBottom(label="CHAR"), 48)}, name="ACMFILTERTAGDETAILSA", pack=False, align=None), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["hadid", "paftd", "dwInstance", "fdwSupport"]), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=False, label="UInt32"), arg_names=["had", "paftd", "fnCallback", "dwInstance", "fdwEnum"]),
        # 
        'acmFilterTagEnumW': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimStruct({"cbStruct": SimTypeInt(signed=False, label="UInt32"), "dwFilterTagIndex": SimTypeInt(signed=False, label="UInt32"), "dwFilterTag": SimTypeInt(signed=False, label="UInt32"), "cbFilterSize": SimTypeInt(signed=False, label="UInt32"), "fdwSupport": SimTypeInt(signed=False, label="UInt32"), "cStandardFilters": SimTypeInt(signed=False, label="UInt32"), "szFilterTag": SimTypeFixedSizeArray(SimTypeChar(label="Char"), 48)}, name="ACMFILTERTAGDETAILSW", pack=False, align=None), offset=0), SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimStruct({"cbStruct": SimTypeInt(signed=False, label="UInt32"), "dwFilterTagIndex": SimTypeInt(signed=False, label="UInt32"), "dwFilterTag": SimTypeInt(signed=False, label="UInt32"), "cbFilterSize": SimTypeInt(signed=False, label="UInt32"), "fdwSupport": SimTypeInt(signed=False, label="UInt32"), "cStandardFilters": SimTypeInt(signed=False, label="UInt32"), "szFilterTag": SimTypeFixedSizeArray(SimTypeChar(label="Char"), 48)}, name="ACMFILTERTAGDETAILSW", pack=False, align=None), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["hadid", "paftd", "dwInstance", "fdwSupport"]), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=False, label="UInt32"), arg_names=["had", "paftd", "fnCallback", "dwInstance", "fdwEnum"]),
        # 
        'acmFilterDetailsA': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimStruct({"cbStruct": SimTypeInt(signed=False, label="UInt32"), "dwFilterIndex": SimTypeInt(signed=False, label="UInt32"), "dwFilterTag": SimTypeInt(signed=False, label="UInt32"), "fdwSupport": SimTypeInt(signed=False, label="UInt32"), "pwfltr": SimTypePointer(SimStruct({"cbStruct": SimTypeInt(signed=False, label="UInt32"), "dwFilterTag": SimTypeInt(signed=False, label="UInt32"), "fdwFilter": SimTypeInt(signed=False, label="UInt32"), "dwReserved": SimTypeFixedSizeArray(SimTypeInt(signed=False, label="UInt32"), 5)}, name="WAVEFILTER", pack=False, align=None), offset=0), "cbwfltr": SimTypeInt(signed=False, label="UInt32"), "szFilter": SimTypeFixedSizeArray(SimTypeBottom(label="CHAR"), 128)}, name="ACMFILTERDETAILSA", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=False, label="UInt32"), arg_names=["had", "pafd", "fdwDetails"]),
        # 
        'acmFilterDetailsW': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimStruct({"cbStruct": SimTypeInt(signed=False, label="UInt32"), "dwFilterIndex": SimTypeInt(signed=False, label="UInt32"), "dwFilterTag": SimTypeInt(signed=False, label="UInt32"), "fdwSupport": SimTypeInt(signed=False, label="UInt32"), "pwfltr": SimTypePointer(SimStruct({"cbStruct": SimTypeInt(signed=False, label="UInt32"), "dwFilterTag": SimTypeInt(signed=False, label="UInt32"), "fdwFilter": SimTypeInt(signed=False, label="UInt32"), "dwReserved": SimTypeFixedSizeArray(SimTypeInt(signed=False, label="UInt32"), 5)}, name="WAVEFILTER", pack=False, align=None), offset=0), "cbwfltr": SimTypeInt(signed=False, label="UInt32"), "szFilter": SimTypeFixedSizeArray(SimTypeChar(label="Char"), 128)}, name="ACMFILTERDETAILSW", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=False, label="UInt32"), arg_names=["had", "pafd", "fdwDetails"]),
        # 
        'acmFilterEnumA': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimStruct({"cbStruct": SimTypeInt(signed=False, label="UInt32"), "dwFilterIndex": SimTypeInt(signed=False, label="UInt32"), "dwFilterTag": SimTypeInt(signed=False, label="UInt32"), "fdwSupport": SimTypeInt(signed=False, label="UInt32"), "pwfltr": SimTypePointer(SimStruct({"cbStruct": SimTypeInt(signed=False, label="UInt32"), "dwFilterTag": SimTypeInt(signed=False, label="UInt32"), "fdwFilter": SimTypeInt(signed=False, label="UInt32"), "dwReserved": SimTypeFixedSizeArray(SimTypeInt(signed=False, label="UInt32"), 5)}, name="WAVEFILTER", pack=False, align=None), offset=0), "cbwfltr": SimTypeInt(signed=False, label="UInt32"), "szFilter": SimTypeFixedSizeArray(SimTypeBottom(label="CHAR"), 128)}, name="ACMFILTERDETAILSA", pack=False, align=None), offset=0), SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimStruct({"cbStruct": SimTypeInt(signed=False, label="UInt32"), "dwFilterIndex": SimTypeInt(signed=False, label="UInt32"), "dwFilterTag": SimTypeInt(signed=False, label="UInt32"), "fdwSupport": SimTypeInt(signed=False, label="UInt32"), "pwfltr": SimTypePointer(SimStruct({"cbStruct": SimTypeInt(signed=False, label="UInt32"), "dwFilterTag": SimTypeInt(signed=False, label="UInt32"), "fdwFilter": SimTypeInt(signed=False, label="UInt32"), "dwReserved": SimTypeFixedSizeArray(SimTypeInt(signed=False, label="UInt32"), 5)}, name="WAVEFILTER", pack=False, align=None), offset=0), "cbwfltr": SimTypeInt(signed=False, label="UInt32"), "szFilter": SimTypeFixedSizeArray(SimTypeBottom(label="CHAR"), 128)}, name="ACMFILTERDETAILSA", pack=False, align=None), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["hadid", "pafd", "dwInstance", "fdwSupport"]), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=False, label="UInt32"), arg_names=["had", "pafd", "fnCallback", "dwInstance", "fdwEnum"]),
        # 
        'acmFilterEnumW': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimStruct({"cbStruct": SimTypeInt(signed=False, label="UInt32"), "dwFilterIndex": SimTypeInt(signed=False, label="UInt32"), "dwFilterTag": SimTypeInt(signed=False, label="UInt32"), "fdwSupport": SimTypeInt(signed=False, label="UInt32"), "pwfltr": SimTypePointer(SimStruct({"cbStruct": SimTypeInt(signed=False, label="UInt32"), "dwFilterTag": SimTypeInt(signed=False, label="UInt32"), "fdwFilter": SimTypeInt(signed=False, label="UInt32"), "dwReserved": SimTypeFixedSizeArray(SimTypeInt(signed=False, label="UInt32"), 5)}, name="WAVEFILTER", pack=False, align=None), offset=0), "cbwfltr": SimTypeInt(signed=False, label="UInt32"), "szFilter": SimTypeFixedSizeArray(SimTypeChar(label="Char"), 128)}, name="ACMFILTERDETAILSW", pack=False, align=None), offset=0), SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimStruct({"cbStruct": SimTypeInt(signed=False, label="UInt32"), "dwFilterIndex": SimTypeInt(signed=False, label="UInt32"), "dwFilterTag": SimTypeInt(signed=False, label="UInt32"), "fdwSupport": SimTypeInt(signed=False, label="UInt32"), "pwfltr": SimTypePointer(SimStruct({"cbStruct": SimTypeInt(signed=False, label="UInt32"), "dwFilterTag": SimTypeInt(signed=False, label="UInt32"), "fdwFilter": SimTypeInt(signed=False, label="UInt32"), "dwReserved": SimTypeFixedSizeArray(SimTypeInt(signed=False, label="UInt32"), 5)}, name="WAVEFILTER", pack=False, align=None), offset=0), "cbwfltr": SimTypeInt(signed=False, label="UInt32"), "szFilter": SimTypeFixedSizeArray(SimTypeChar(label="Char"), 128)}, name="ACMFILTERDETAILSW", pack=False, align=None), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["hadid", "pafd", "dwInstance", "fdwSupport"]), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=False, label="UInt32"), arg_names=["had", "pafd", "fnCallback", "dwInstance", "fdwEnum"]),
        # 
        'acmFilterChooseA': SimTypeFunction([SimTypePointer(SimStruct({"cbStruct": SimTypeInt(signed=False, label="UInt32"), "fdwStyle": SimTypeInt(signed=False, label="UInt32"), "hwndOwner": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "pwfltr": SimTypePointer(SimStruct({"cbStruct": SimTypeInt(signed=False, label="UInt32"), "dwFilterTag": SimTypeInt(signed=False, label="UInt32"), "fdwFilter": SimTypeInt(signed=False, label="UInt32"), "dwReserved": SimTypeFixedSizeArray(SimTypeInt(signed=False, label="UInt32"), 5)}, name="WAVEFILTER", pack=False, align=None), offset=0), "cbwfltr": SimTypeInt(signed=False, label="UInt32"), "pszTitle": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "szFilterTag": SimTypeFixedSizeArray(SimTypeBottom(label="CHAR"), 48), "szFilter": SimTypeFixedSizeArray(SimTypeBottom(label="CHAR"), 128), "pszName": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cchName": SimTypeInt(signed=False, label="UInt32"), "fdwEnum": SimTypeInt(signed=False, label="UInt32"), "pwfltrEnum": SimTypePointer(SimStruct({"cbStruct": SimTypeInt(signed=False, label="UInt32"), "dwFilterTag": SimTypeInt(signed=False, label="UInt32"), "fdwFilter": SimTypeInt(signed=False, label="UInt32"), "dwReserved": SimTypeFixedSizeArray(SimTypeInt(signed=False, label="UInt32"), 5)}, name="WAVEFILTER", pack=False, align=None), offset=0), "hInstance": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "pszTemplateName": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "lCustData": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "pfnHook": SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["hwnd", "uMsg", "wParam", "lParam"]), offset=0)}, name="ACMFILTERCHOOSEA", pack=False, align=None), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["pafltrc"]),
        # 
        'acmFilterChooseW': SimTypeFunction([SimTypePointer(SimStruct({"cbStruct": SimTypeInt(signed=False, label="UInt32"), "fdwStyle": SimTypeInt(signed=False, label="UInt32"), "hwndOwner": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "pwfltr": SimTypePointer(SimStruct({"cbStruct": SimTypeInt(signed=False, label="UInt32"), "dwFilterTag": SimTypeInt(signed=False, label="UInt32"), "fdwFilter": SimTypeInt(signed=False, label="UInt32"), "dwReserved": SimTypeFixedSizeArray(SimTypeInt(signed=False, label="UInt32"), 5)}, name="WAVEFILTER", pack=False, align=None), offset=0), "cbwfltr": SimTypeInt(signed=False, label="UInt32"), "pszTitle": SimTypePointer(SimTypeChar(label="Char"), offset=0), "szFilterTag": SimTypeFixedSizeArray(SimTypeChar(label="Char"), 48), "szFilter": SimTypeFixedSizeArray(SimTypeChar(label="Char"), 128), "pszName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "cchName": SimTypeInt(signed=False, label="UInt32"), "fdwEnum": SimTypeInt(signed=False, label="UInt32"), "pwfltrEnum": SimTypePointer(SimStruct({"cbStruct": SimTypeInt(signed=False, label="UInt32"), "dwFilterTag": SimTypeInt(signed=False, label="UInt32"), "fdwFilter": SimTypeInt(signed=False, label="UInt32"), "dwReserved": SimTypeFixedSizeArray(SimTypeInt(signed=False, label="UInt32"), 5)}, name="WAVEFILTER", pack=False, align=None), offset=0), "hInstance": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "pszTemplateName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "lCustData": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "pfnHook": SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["hwnd", "uMsg", "wParam", "lParam"]), offset=0)}, name="ACMFILTERCHOOSEW", pack=False, align=None), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["pafltrc"]),
        # 
        'acmStreamOpen': SimTypeFunction([SimTypePointer(SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimStruct({"wFormatTag": SimTypeShort(signed=False, label="UInt16"), "nChannels": SimTypeShort(signed=False, label="UInt16"), "nSamplesPerSec": SimTypeInt(signed=False, label="UInt32"), "nAvgBytesPerSec": SimTypeInt(signed=False, label="UInt32"), "nBlockAlign": SimTypeShort(signed=False, label="UInt16"), "wBitsPerSample": SimTypeShort(signed=False, label="UInt16"), "cbSize": SimTypeShort(signed=False, label="UInt16")}, name="WAVEFORMATEX", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"wFormatTag": SimTypeShort(signed=False, label="UInt16"), "nChannels": SimTypeShort(signed=False, label="UInt16"), "nSamplesPerSec": SimTypeInt(signed=False, label="UInt32"), "nAvgBytesPerSec": SimTypeInt(signed=False, label="UInt32"), "nBlockAlign": SimTypeShort(signed=False, label="UInt16"), "wBitsPerSample": SimTypeShort(signed=False, label="UInt16"), "cbSize": SimTypeShort(signed=False, label="UInt16")}, name="WAVEFORMATEX", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"cbStruct": SimTypeInt(signed=False, label="UInt32"), "dwFilterTag": SimTypeInt(signed=False, label="UInt32"), "fdwFilter": SimTypeInt(signed=False, label="UInt32"), "dwReserved": SimTypeFixedSizeArray(SimTypeInt(signed=False, label="UInt32"), 5)}, name="WAVEFILTER", pack=False, align=None), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=False, label="UInt32"), arg_names=["phas", "had", "pwfxSrc", "pwfxDst", "pwfltr", "dwCallback", "dwInstance", "fdwOpen"]),
        # 
        'acmStreamClose': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=False, label="UInt32"), arg_names=["has", "fdwClose"]),
        # 
        'acmStreamSize': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=False, label="UInt32"), arg_names=["has", "cbInput", "pdwOutputBytes", "fdwSize"]),
        # 
        'acmStreamReset': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=False, label="UInt32"), arg_names=["has", "fdwReset"]),
        # 
        'acmStreamMessage': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["has", "uMsg", "lParam1", "lParam2"]),
        # 
        'acmStreamConvert': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimStruct({"cbStruct": SimTypeInt(signed=False, label="UInt32"), "fdwStatus": SimTypeInt(signed=False, label="UInt32"), "dwUser": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "pbSrc": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cbSrcLength": SimTypeInt(signed=False, label="UInt32"), "cbSrcLengthUsed": SimTypeInt(signed=False, label="UInt32"), "dwSrcUser": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "pbDst": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cbDstLength": SimTypeInt(signed=False, label="UInt32"), "cbDstLengthUsed": SimTypeInt(signed=False, label="UInt32"), "dwDstUser": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "dwReservedDriver": SimTypeFixedSizeArray(SimTypeInt(signed=False, label="UInt32"), 10)}, name="ACMSTREAMHEADER", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=False, label="UInt32"), arg_names=["has", "pash", "fdwConvert"]),
        # 
        'acmStreamPrepareHeader': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimStruct({"cbStruct": SimTypeInt(signed=False, label="UInt32"), "fdwStatus": SimTypeInt(signed=False, label="UInt32"), "dwUser": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "pbSrc": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cbSrcLength": SimTypeInt(signed=False, label="UInt32"), "cbSrcLengthUsed": SimTypeInt(signed=False, label="UInt32"), "dwSrcUser": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "pbDst": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cbDstLength": SimTypeInt(signed=False, label="UInt32"), "cbDstLengthUsed": SimTypeInt(signed=False, label="UInt32"), "dwDstUser": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "dwReservedDriver": SimTypeFixedSizeArray(SimTypeInt(signed=False, label="UInt32"), 10)}, name="ACMSTREAMHEADER", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=False, label="UInt32"), arg_names=["has", "pash", "fdwPrepare"]),
        # 
        'acmStreamUnprepareHeader': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimStruct({"cbStruct": SimTypeInt(signed=False, label="UInt32"), "fdwStatus": SimTypeInt(signed=False, label="UInt32"), "dwUser": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "pbSrc": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cbSrcLength": SimTypeInt(signed=False, label="UInt32"), "cbSrcLengthUsed": SimTypeInt(signed=False, label="UInt32"), "dwSrcUser": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "pbDst": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cbDstLength": SimTypeInt(signed=False, label="UInt32"), "cbDstLengthUsed": SimTypeInt(signed=False, label="UInt32"), "dwDstUser": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "dwReservedDriver": SimTypeFixedSizeArray(SimTypeInt(signed=False, label="UInt32"), 10)}, name="ACMSTREAMHEADER", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=False, label="UInt32"), arg_names=["has", "pash", "fdwUnprepare"]),
    }

lib.set_prototypes(prototypes)
