from networkx import connected_components
from protein_inference.problem_network import ProblemNetwork


class PSMsNetworkSplitter:
    """
    A class that splits a networkx graph generated a psm
    table.

    Attributes:
    -----------
    network : networkx.Graph
        A networkx graph generated by PSMsNetworkGenerator.

    Methods:
    --------
    split_networks()
        Splits the networkx graph into connected components,
        converts them into ProblemNetworks and returns
        the results as a list. 
    
    """

    def __init__(self, network):

        self.network = network
        return

    def split_networks(self):

        list_subnetworks = list()

        for comps in connected_components(self.network):
            sg = self.network.subgraph(comps)
            list_subnetworks.append(ProblemNetwork(sg))

        return list_subnetworks
