import { Construct } from '@aws-cdk/core';
/**
 * This interface is translated into a _struct_ containing data.
 *
 * E.g. if translated to Java, an interface `StructProperties` is created containing a builder subclass to create an instance of the interface.
 *
 * @see https://aws.github.io/jsii/user-guides/lib-author/typescript-restrictions/#interfaces
 * @stability stable
 */
export interface StructProperties {
    /**
     * @stability stable
     */
    readonly myProp: string;
}
/**
 * This is a _behavioral interface_ identified by `I` in its name.
 *
 * It will be translated to a "regular" interface which needs to be implemented.
 * You can also use methods here, e.g. `doSth(): void;`.
 *
 * @see https://aws.github.io/jsii/user-guides/lib-author/typescript-restrictions/#interfaces
 * @stability stable
 */
export interface IBehaviorProperties {
    /**
     * @stability stable
     */
    readonly otherProp: string;
}
/**
 * A simple CDK construct illustrating the differences in declaring construct properties with interfaces.
 *
 * @stability stable
 */
export declare class ConstructWithProperties extends Construct {
    /**
     * @stability stable
     */
    constructor(parent: Construct, name: string, props: StructProperties, props2: IBehaviorProperties);
}
