"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
"""
import builtins
import cosmos.base.v1beta1.coin_pb2
import google.protobuf.any_pb2
import google.protobuf.descriptor
import google.protobuf.duration_pb2
import google.protobuf.internal.containers
import google.protobuf.internal.enum_type_wrapper
import google.protobuf.message
import google.protobuf.timestamp_pb2
import tendermint.types.types_pb2
import typing
import typing_extensions

DESCRIPTOR: google.protobuf.descriptor.FileDescriptor = ...

# BondStatus is the status of a validator.
class BondStatus(_BondStatus, metaclass=_BondStatusEnumTypeWrapper):
    pass
class _BondStatus:
    V = typing.NewType('V', builtins.int)
class _BondStatusEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[_BondStatus.V], builtins.type):
    DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor = ...
    # UNSPECIFIED defines an invalid validator status.
    BOND_STATUS_UNSPECIFIED = BondStatus.V(0)
    # UNBONDED defines a validator that is not bonded.
    BOND_STATUS_UNBONDED = BondStatus.V(1)
    # UNBONDING defines a validator that is unbonding.
    BOND_STATUS_UNBONDING = BondStatus.V(2)
    # BONDED defines a validator that is bonded.
    BOND_STATUS_BONDED = BondStatus.V(3)

# UNSPECIFIED defines an invalid validator status.
BOND_STATUS_UNSPECIFIED = BondStatus.V(0)
# UNBONDED defines a validator that is not bonded.
BOND_STATUS_UNBONDED = BondStatus.V(1)
# UNBONDING defines a validator that is unbonding.
BOND_STATUS_UNBONDING = BondStatus.V(2)
# BONDED defines a validator that is bonded.
BOND_STATUS_BONDED = BondStatus.V(3)
global___BondStatus = BondStatus


# HistoricalInfo contains header and validator information for a given block.
# It is stored as part of staking module's state, which persists the `n` most
# recent HistoricalInfo
# (`n` is set by the staking module's `historical_entries` parameter).
class HistoricalInfo(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor = ...
    HEADER_FIELD_NUMBER: builtins.int
    VALSET_FIELD_NUMBER: builtins.int
    @property
    def header(self) -> tendermint.types.types_pb2.Header: ...
    @property
    def valset(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___Validator]: ...
    def __init__(self,
        *,
        header : typing.Optional[tendermint.types.types_pb2.Header] = ...,
        valset : typing.Optional[typing.Iterable[global___Validator]] = ...,
        ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal[u"header",b"header"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal[u"header",b"header",u"valset",b"valset"]) -> None: ...
global___HistoricalInfo = HistoricalInfo

# CommissionRates defines the initial commission rates to be used for creating
# a validator.
class CommissionRates(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor = ...
    RATE_FIELD_NUMBER: builtins.int
    MAX_RATE_FIELD_NUMBER: builtins.int
    MAX_CHANGE_RATE_FIELD_NUMBER: builtins.int
    # rate is the commission rate charged to delegators, as a fraction.
    rate: typing.Text = ...
    # max_rate defines the maximum commission rate which validator can ever charge, as a fraction.
    max_rate: typing.Text = ...
    # max_change_rate defines the maximum daily increase of the validator commission, as a fraction.
    max_change_rate: typing.Text = ...
    def __init__(self,
        *,
        rate : typing.Text = ...,
        max_rate : typing.Text = ...,
        max_change_rate : typing.Text = ...,
        ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal[u"max_change_rate",b"max_change_rate",u"max_rate",b"max_rate",u"rate",b"rate"]) -> None: ...
global___CommissionRates = CommissionRates

# Commission defines commission parameters for a given validator.
class Commission(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor = ...
    COMMISSION_RATES_FIELD_NUMBER: builtins.int
    UPDATE_TIME_FIELD_NUMBER: builtins.int
    # commission_rates defines the initial commission rates to be used for creating a validator.
    @property
    def commission_rates(self) -> global___CommissionRates: ...
    # update_time is the last time the commission rate was changed.
    @property
    def update_time(self) -> google.protobuf.timestamp_pb2.Timestamp: ...
    def __init__(self,
        *,
        commission_rates : typing.Optional[global___CommissionRates] = ...,
        update_time : typing.Optional[google.protobuf.timestamp_pb2.Timestamp] = ...,
        ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal[u"commission_rates",b"commission_rates",u"update_time",b"update_time"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal[u"commission_rates",b"commission_rates",u"update_time",b"update_time"]) -> None: ...
global___Commission = Commission

# Description defines a validator description.
class Description(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor = ...
    MONIKER_FIELD_NUMBER: builtins.int
    IDENTITY_FIELD_NUMBER: builtins.int
    WEBSITE_FIELD_NUMBER: builtins.int
    SECURITY_CONTACT_FIELD_NUMBER: builtins.int
    DETAILS_FIELD_NUMBER: builtins.int
    # moniker defines a human-readable name for the validator.
    moniker: typing.Text = ...
    # identity defines an optional identity signature (ex. UPort or Keybase).
    identity: typing.Text = ...
    # website defines an optional website link.
    website: typing.Text = ...
    # security_contact defines an optional email for security contact.
    security_contact: typing.Text = ...
    # details define other optional details.
    details: typing.Text = ...
    def __init__(self,
        *,
        moniker : typing.Text = ...,
        identity : typing.Text = ...,
        website : typing.Text = ...,
        security_contact : typing.Text = ...,
        details : typing.Text = ...,
        ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal[u"details",b"details",u"identity",b"identity",u"moniker",b"moniker",u"security_contact",b"security_contact",u"website",b"website"]) -> None: ...
global___Description = Description

# Validator defines a validator, together with the total amount of the
# Validator's bond shares and their exchange rate to coins. Slashing results in
# a decrease in the exchange rate, allowing correct calculation of future
# undelegations without iterating over delegators. When coins are delegated to
# this validator, the validator is credited with a delegation whose number of
# bond shares is based on the amount of coins delegated divided by the current
# exchange rate. Voting power can be calculated as total bonded shares
# multiplied by exchange rate.
class Validator(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor = ...
    OPERATOR_ADDRESS_FIELD_NUMBER: builtins.int
    CONSENSUS_PUBKEY_FIELD_NUMBER: builtins.int
    JAILED_FIELD_NUMBER: builtins.int
    STATUS_FIELD_NUMBER: builtins.int
    TOKENS_FIELD_NUMBER: builtins.int
    DELEGATOR_SHARES_FIELD_NUMBER: builtins.int
    DESCRIPTION_FIELD_NUMBER: builtins.int
    UNBONDING_HEIGHT_FIELD_NUMBER: builtins.int
    UNBONDING_TIME_FIELD_NUMBER: builtins.int
    COMMISSION_FIELD_NUMBER: builtins.int
    MIN_SELF_DELEGATION_FIELD_NUMBER: builtins.int
    # operator_address defines the address of the validator's operator; bech encoded in JSON.
    operator_address: typing.Text = ...
    # consensus_pubkey is the consensus public key of the validator, as a Protobuf Any.
    @property
    def consensus_pubkey(self) -> google.protobuf.any_pb2.Any: ...
    # jailed defined whether the validator has been jailed from bonded status or not.
    jailed: builtins.bool = ...
    # status is the validator status (bonded/unbonding/unbonded).
    status: global___BondStatus.V = ...
    # tokens define the delegated tokens (incl. self-delegation).
    tokens: typing.Text = ...
    # delegator_shares defines total shares issued to a validator's delegators.
    delegator_shares: typing.Text = ...
    # description defines the description terms for the validator.
    @property
    def description(self) -> global___Description: ...
    # unbonding_height defines, if unbonding, the height at which this validator has begun unbonding.
    unbonding_height: builtins.int = ...
    # unbonding_time defines, if unbonding, the min time for the validator to complete unbonding.
    @property
    def unbonding_time(self) -> google.protobuf.timestamp_pb2.Timestamp: ...
    # commission defines the commission parameters.
    @property
    def commission(self) -> global___Commission: ...
    # min_self_delegation is the validator's self declared minimum self delegation.
    min_self_delegation: typing.Text = ...
    def __init__(self,
        *,
        operator_address : typing.Text = ...,
        consensus_pubkey : typing.Optional[google.protobuf.any_pb2.Any] = ...,
        jailed : builtins.bool = ...,
        status : global___BondStatus.V = ...,
        tokens : typing.Text = ...,
        delegator_shares : typing.Text = ...,
        description : typing.Optional[global___Description] = ...,
        unbonding_height : builtins.int = ...,
        unbonding_time : typing.Optional[google.protobuf.timestamp_pb2.Timestamp] = ...,
        commission : typing.Optional[global___Commission] = ...,
        min_self_delegation : typing.Text = ...,
        ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal[u"commission",b"commission",u"consensus_pubkey",b"consensus_pubkey",u"description",b"description",u"unbonding_time",b"unbonding_time"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal[u"commission",b"commission",u"consensus_pubkey",b"consensus_pubkey",u"delegator_shares",b"delegator_shares",u"description",b"description",u"jailed",b"jailed",u"min_self_delegation",b"min_self_delegation",u"operator_address",b"operator_address",u"status",b"status",u"tokens",b"tokens",u"unbonding_height",b"unbonding_height",u"unbonding_time",b"unbonding_time"]) -> None: ...
global___Validator = Validator

# ValAddresses defines a repeated set of validator addresses.
class ValAddresses(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor = ...
    ADDRESSES_FIELD_NUMBER: builtins.int
    @property
    def addresses(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[typing.Text]: ...
    def __init__(self,
        *,
        addresses : typing.Optional[typing.Iterable[typing.Text]] = ...,
        ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal[u"addresses",b"addresses"]) -> None: ...
global___ValAddresses = ValAddresses

# DVPair is struct that just has a delegator-validator pair with no other data.
# It is intended to be used as a marshalable pointer. For example, a DVPair can
# be used to construct the key to getting an UnbondingDelegation from state.
class DVPair(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor = ...
    DELEGATOR_ADDRESS_FIELD_NUMBER: builtins.int
    VALIDATOR_ADDRESS_FIELD_NUMBER: builtins.int
    delegator_address: typing.Text = ...
    validator_address: typing.Text = ...
    def __init__(self,
        *,
        delegator_address : typing.Text = ...,
        validator_address : typing.Text = ...,
        ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal[u"delegator_address",b"delegator_address",u"validator_address",b"validator_address"]) -> None: ...
global___DVPair = DVPair

# DVPairs defines an array of DVPair objects.
class DVPairs(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor = ...
    PAIRS_FIELD_NUMBER: builtins.int
    @property
    def pairs(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___DVPair]: ...
    def __init__(self,
        *,
        pairs : typing.Optional[typing.Iterable[global___DVPair]] = ...,
        ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal[u"pairs",b"pairs"]) -> None: ...
global___DVPairs = DVPairs

# DVVTriplet is struct that just has a delegator-validator-validator triplet
# with no other data. It is intended to be used as a marshalable pointer. For
# example, a DVVTriplet can be used to construct the key to getting a
# Redelegation from state.
class DVVTriplet(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor = ...
    DELEGATOR_ADDRESS_FIELD_NUMBER: builtins.int
    VALIDATOR_SRC_ADDRESS_FIELD_NUMBER: builtins.int
    VALIDATOR_DST_ADDRESS_FIELD_NUMBER: builtins.int
    delegator_address: typing.Text = ...
    validator_src_address: typing.Text = ...
    validator_dst_address: typing.Text = ...
    def __init__(self,
        *,
        delegator_address : typing.Text = ...,
        validator_src_address : typing.Text = ...,
        validator_dst_address : typing.Text = ...,
        ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal[u"delegator_address",b"delegator_address",u"validator_dst_address",b"validator_dst_address",u"validator_src_address",b"validator_src_address"]) -> None: ...
global___DVVTriplet = DVVTriplet

# DVVTriplets defines an array of DVVTriplet objects.
class DVVTriplets(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor = ...
    TRIPLETS_FIELD_NUMBER: builtins.int
    @property
    def triplets(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___DVVTriplet]: ...
    def __init__(self,
        *,
        triplets : typing.Optional[typing.Iterable[global___DVVTriplet]] = ...,
        ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal[u"triplets",b"triplets"]) -> None: ...
global___DVVTriplets = DVVTriplets

# Delegation represents the bond with tokens held by an account. It is
# owned by one delegator, and is associated with the voting power of one
# validator.
class Delegation(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor = ...
    DELEGATOR_ADDRESS_FIELD_NUMBER: builtins.int
    VALIDATOR_ADDRESS_FIELD_NUMBER: builtins.int
    SHARES_FIELD_NUMBER: builtins.int
    # delegator_address is the bech32-encoded address of the delegator.
    delegator_address: typing.Text = ...
    # validator_address is the bech32-encoded address of the validator.
    validator_address: typing.Text = ...
    # shares define the delegation shares received.
    shares: typing.Text = ...
    def __init__(self,
        *,
        delegator_address : typing.Text = ...,
        validator_address : typing.Text = ...,
        shares : typing.Text = ...,
        ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal[u"delegator_address",b"delegator_address",u"shares",b"shares",u"validator_address",b"validator_address"]) -> None: ...
global___Delegation = Delegation

# UnbondingDelegation stores all of a single delegator's unbonding bonds
# for a single validator in an time-ordered list.
class UnbondingDelegation(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor = ...
    DELEGATOR_ADDRESS_FIELD_NUMBER: builtins.int
    VALIDATOR_ADDRESS_FIELD_NUMBER: builtins.int
    ENTRIES_FIELD_NUMBER: builtins.int
    # delegator_address is the bech32-encoded address of the delegator.
    delegator_address: typing.Text = ...
    # validator_address is the bech32-encoded address of the validator.
    validator_address: typing.Text = ...
    # entries are the unbonding delegation entries.
    # unbonding delegation entries
    @property
    def entries(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___UnbondingDelegationEntry]: ...
    def __init__(self,
        *,
        delegator_address : typing.Text = ...,
        validator_address : typing.Text = ...,
        entries : typing.Optional[typing.Iterable[global___UnbondingDelegationEntry]] = ...,
        ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal[u"delegator_address",b"delegator_address",u"entries",b"entries",u"validator_address",b"validator_address"]) -> None: ...
global___UnbondingDelegation = UnbondingDelegation

# UnbondingDelegationEntry defines an unbonding object with relevant metadata.
class UnbondingDelegationEntry(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor = ...
    CREATION_HEIGHT_FIELD_NUMBER: builtins.int
    COMPLETION_TIME_FIELD_NUMBER: builtins.int
    INITIAL_BALANCE_FIELD_NUMBER: builtins.int
    BALANCE_FIELD_NUMBER: builtins.int
    # creation_height is the height which the unbonding took place.
    creation_height: builtins.int = ...
    # completion_time is the unix time for unbonding completion.
    @property
    def completion_time(self) -> google.protobuf.timestamp_pb2.Timestamp: ...
    # initial_balance defines the tokens initially scheduled to receive at completion.
    initial_balance: typing.Text = ...
    # balance defines the tokens to receive at completion.
    balance: typing.Text = ...
    def __init__(self,
        *,
        creation_height : builtins.int = ...,
        completion_time : typing.Optional[google.protobuf.timestamp_pb2.Timestamp] = ...,
        initial_balance : typing.Text = ...,
        balance : typing.Text = ...,
        ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal[u"completion_time",b"completion_time"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal[u"balance",b"balance",u"completion_time",b"completion_time",u"creation_height",b"creation_height",u"initial_balance",b"initial_balance"]) -> None: ...
global___UnbondingDelegationEntry = UnbondingDelegationEntry

# RedelegationEntry defines a redelegation object with relevant metadata.
class RedelegationEntry(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor = ...
    CREATION_HEIGHT_FIELD_NUMBER: builtins.int
    COMPLETION_TIME_FIELD_NUMBER: builtins.int
    INITIAL_BALANCE_FIELD_NUMBER: builtins.int
    SHARES_DST_FIELD_NUMBER: builtins.int
    # creation_height  defines the height which the redelegation took place.
    creation_height: builtins.int = ...
    # completion_time defines the unix time for redelegation completion.
    @property
    def completion_time(self) -> google.protobuf.timestamp_pb2.Timestamp: ...
    # initial_balance defines the initial balance when redelegation started.
    initial_balance: typing.Text = ...
    # shares_dst is the amount of destination-validator shares created by redelegation.
    shares_dst: typing.Text = ...
    def __init__(self,
        *,
        creation_height : builtins.int = ...,
        completion_time : typing.Optional[google.protobuf.timestamp_pb2.Timestamp] = ...,
        initial_balance : typing.Text = ...,
        shares_dst : typing.Text = ...,
        ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal[u"completion_time",b"completion_time"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal[u"completion_time",b"completion_time",u"creation_height",b"creation_height",u"initial_balance",b"initial_balance",u"shares_dst",b"shares_dst"]) -> None: ...
global___RedelegationEntry = RedelegationEntry

# Redelegation contains the list of a particular delegator's redelegating bonds
# from a particular source validator to a particular destination validator.
class Redelegation(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor = ...
    DELEGATOR_ADDRESS_FIELD_NUMBER: builtins.int
    VALIDATOR_SRC_ADDRESS_FIELD_NUMBER: builtins.int
    VALIDATOR_DST_ADDRESS_FIELD_NUMBER: builtins.int
    ENTRIES_FIELD_NUMBER: builtins.int
    # delegator_address is the bech32-encoded address of the delegator.
    delegator_address: typing.Text = ...
    # validator_src_address is the validator redelegation source operator address.
    validator_src_address: typing.Text = ...
    # validator_dst_address is the validator redelegation destination operator address.
    validator_dst_address: typing.Text = ...
    # entries are the redelegation entries.
    # redelegation entries
    @property
    def entries(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___RedelegationEntry]: ...
    def __init__(self,
        *,
        delegator_address : typing.Text = ...,
        validator_src_address : typing.Text = ...,
        validator_dst_address : typing.Text = ...,
        entries : typing.Optional[typing.Iterable[global___RedelegationEntry]] = ...,
        ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal[u"delegator_address",b"delegator_address",u"entries",b"entries",u"validator_dst_address",b"validator_dst_address",u"validator_src_address",b"validator_src_address"]) -> None: ...
global___Redelegation = Redelegation

# Params defines the parameters for the staking module.
class Params(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor = ...
    UNBONDING_TIME_FIELD_NUMBER: builtins.int
    MAX_VALIDATORS_FIELD_NUMBER: builtins.int
    MAX_ENTRIES_FIELD_NUMBER: builtins.int
    HISTORICAL_ENTRIES_FIELD_NUMBER: builtins.int
    BOND_DENOM_FIELD_NUMBER: builtins.int
    # unbonding_time is the time duration of unbonding.
    @property
    def unbonding_time(self) -> google.protobuf.duration_pb2.Duration: ...
    # max_validators is the maximum number of validators.
    max_validators: builtins.int = ...
    # max_entries is the max entries for either unbonding delegation or redelegation (per pair/trio).
    max_entries: builtins.int = ...
    # historical_entries is the number of historical entries to persist.
    historical_entries: builtins.int = ...
    # bond_denom defines the bondable coin denomination.
    bond_denom: typing.Text = ...
    def __init__(self,
        *,
        unbonding_time : typing.Optional[google.protobuf.duration_pb2.Duration] = ...,
        max_validators : builtins.int = ...,
        max_entries : builtins.int = ...,
        historical_entries : builtins.int = ...,
        bond_denom : typing.Text = ...,
        ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal[u"unbonding_time",b"unbonding_time"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal[u"bond_denom",b"bond_denom",u"historical_entries",b"historical_entries",u"max_entries",b"max_entries",u"max_validators",b"max_validators",u"unbonding_time",b"unbonding_time"]) -> None: ...
global___Params = Params

# DelegationResponse is equivalent to Delegation except that it contains a
# balance in addition to shares which is more suitable for client responses.
class DelegationResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor = ...
    DELEGATION_FIELD_NUMBER: builtins.int
    BALANCE_FIELD_NUMBER: builtins.int
    @property
    def delegation(self) -> global___Delegation: ...
    @property
    def balance(self) -> cosmos.base.v1beta1.coin_pb2.Coin: ...
    def __init__(self,
        *,
        delegation : typing.Optional[global___Delegation] = ...,
        balance : typing.Optional[cosmos.base.v1beta1.coin_pb2.Coin] = ...,
        ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal[u"balance",b"balance",u"delegation",b"delegation"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal[u"balance",b"balance",u"delegation",b"delegation"]) -> None: ...
global___DelegationResponse = DelegationResponse

# RedelegationEntryResponse is equivalent to a RedelegationEntry except that it
# contains a balance in addition to shares which is more suitable for client
# responses.
class RedelegationEntryResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor = ...
    REDELEGATION_ENTRY_FIELD_NUMBER: builtins.int
    BALANCE_FIELD_NUMBER: builtins.int
    @property
    def redelegation_entry(self) -> global___RedelegationEntry: ...
    balance: typing.Text = ...
    def __init__(self,
        *,
        redelegation_entry : typing.Optional[global___RedelegationEntry] = ...,
        balance : typing.Text = ...,
        ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal[u"redelegation_entry",b"redelegation_entry"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal[u"balance",b"balance",u"redelegation_entry",b"redelegation_entry"]) -> None: ...
global___RedelegationEntryResponse = RedelegationEntryResponse

# RedelegationResponse is equivalent to a Redelegation except that its entries
# contain a balance in addition to shares which is more suitable for client
# responses.
class RedelegationResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor = ...
    REDELEGATION_FIELD_NUMBER: builtins.int
    ENTRIES_FIELD_NUMBER: builtins.int
    @property
    def redelegation(self) -> global___Redelegation: ...
    @property
    def entries(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___RedelegationEntryResponse]: ...
    def __init__(self,
        *,
        redelegation : typing.Optional[global___Redelegation] = ...,
        entries : typing.Optional[typing.Iterable[global___RedelegationEntryResponse]] = ...,
        ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal[u"redelegation",b"redelegation"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal[u"entries",b"entries",u"redelegation",b"redelegation"]) -> None: ...
global___RedelegationResponse = RedelegationResponse

# Pool is used for tracking bonded and not-bonded token supply of the bond
# denomination.
class Pool(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor = ...
    NOT_BONDED_TOKENS_FIELD_NUMBER: builtins.int
    BONDED_TOKENS_FIELD_NUMBER: builtins.int
    not_bonded_tokens: typing.Text = ...
    bonded_tokens: typing.Text = ...
    def __init__(self,
        *,
        not_bonded_tokens : typing.Text = ...,
        bonded_tokens : typing.Text = ...,
        ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal[u"bonded_tokens",b"bonded_tokens",u"not_bonded_tokens",b"not_bonded_tokens"]) -> None: ...
global___Pool = Pool
