"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
"""
import builtins
import google.protobuf.descriptor
import google.protobuf.internal.containers
import google.protobuf.internal.enum_type_wrapper
import google.protobuf.message
import ibc.core.client.v1.client_pb2
import typing
import typing_extensions

DESCRIPTOR: google.protobuf.descriptor.FileDescriptor = ...

# State defines if a channel is in one of the following states:
# CLOSED, INIT, TRYOPEN, OPEN or UNINITIALIZED.
class State(_State, metaclass=_StateEnumTypeWrapper):
    pass
class _State:
    V = typing.NewType('V', builtins.int)
class _StateEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[_State.V], builtins.type):
    DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor = ...
    # Default State
    STATE_UNINITIALIZED_UNSPECIFIED = State.V(0)
    # A channel has just started the opening handshake.
    STATE_INIT = State.V(1)
    # A channel has acknowledged the handshake step on the counterparty chain.
    STATE_TRYOPEN = State.V(2)
    # A channel has completed the handshake. Open channels are
    # ready to send and receive packets.
    STATE_OPEN = State.V(3)
    # A channel has been closed and can no longer be used to send or receive
    # packets.
    STATE_CLOSED = State.V(4)

# Default State
STATE_UNINITIALIZED_UNSPECIFIED = State.V(0)
# A channel has just started the opening handshake.
STATE_INIT = State.V(1)
# A channel has acknowledged the handshake step on the counterparty chain.
STATE_TRYOPEN = State.V(2)
# A channel has completed the handshake. Open channels are
# ready to send and receive packets.
STATE_OPEN = State.V(3)
# A channel has been closed and can no longer be used to send or receive
# packets.
STATE_CLOSED = State.V(4)
global___State = State


# Order defines if a channel is ORDERED or UNORDERED
class Order(_Order, metaclass=_OrderEnumTypeWrapper):
    pass
class _Order:
    V = typing.NewType('V', builtins.int)
class _OrderEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[_Order.V], builtins.type):
    DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor = ...
    # zero-value for channel ordering
    ORDER_NONE_UNSPECIFIED = Order.V(0)
    # packets can be delivered in any order, which may differ from the order in
    # which they were sent.
    ORDER_UNORDERED = Order.V(1)
    # packets are delivered exactly in the order which they were sent
    ORDER_ORDERED = Order.V(2)

# zero-value for channel ordering
ORDER_NONE_UNSPECIFIED = Order.V(0)
# packets can be delivered in any order, which may differ from the order in
# which they were sent.
ORDER_UNORDERED = Order.V(1)
# packets are delivered exactly in the order which they were sent
ORDER_ORDERED = Order.V(2)
global___Order = Order


# Channel defines pipeline for exactly-once packet delivery between specific
# modules on separate blockchains, which has at least one end capable of
# sending packets and one end capable of receiving packets.
class Channel(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor = ...
    STATE_FIELD_NUMBER: builtins.int
    ORDERING_FIELD_NUMBER: builtins.int
    COUNTERPARTY_FIELD_NUMBER: builtins.int
    CONNECTION_HOPS_FIELD_NUMBER: builtins.int
    VERSION_FIELD_NUMBER: builtins.int
    # current state of the channel end
    state: global___State.V = ...
    # whether the channel is ordered or unordered
    ordering: global___Order.V = ...
    # counterparty channel end
    @property
    def counterparty(self) -> global___Counterparty: ...
    # list of connection identifiers, in order, along which packets sent on
    # this channel will travel
    @property
    def connection_hops(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[typing.Text]: ...
    # opaque channel version, which is agreed upon during the handshake
    version: typing.Text = ...
    def __init__(self,
        *,
        state : global___State.V = ...,
        ordering : global___Order.V = ...,
        counterparty : typing.Optional[global___Counterparty] = ...,
        connection_hops : typing.Optional[typing.Iterable[typing.Text]] = ...,
        version : typing.Text = ...,
        ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal[u"counterparty",b"counterparty"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal[u"connection_hops",b"connection_hops",u"counterparty",b"counterparty",u"ordering",b"ordering",u"state",b"state",u"version",b"version"]) -> None: ...
global___Channel = Channel

# IdentifiedChannel defines a channel with additional port and channel
# identifier fields.
class IdentifiedChannel(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor = ...
    STATE_FIELD_NUMBER: builtins.int
    ORDERING_FIELD_NUMBER: builtins.int
    COUNTERPARTY_FIELD_NUMBER: builtins.int
    CONNECTION_HOPS_FIELD_NUMBER: builtins.int
    VERSION_FIELD_NUMBER: builtins.int
    PORT_ID_FIELD_NUMBER: builtins.int
    CHANNEL_ID_FIELD_NUMBER: builtins.int
    # current state of the channel end
    state: global___State.V = ...
    # whether the channel is ordered or unordered
    ordering: global___Order.V = ...
    # counterparty channel end
    @property
    def counterparty(self) -> global___Counterparty: ...
    # list of connection identifiers, in order, along which packets sent on
    # this channel will travel
    @property
    def connection_hops(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[typing.Text]: ...
    # opaque channel version, which is agreed upon during the handshake
    version: typing.Text = ...
    # port identifier
    port_id: typing.Text = ...
    # channel identifier
    channel_id: typing.Text = ...
    def __init__(self,
        *,
        state : global___State.V = ...,
        ordering : global___Order.V = ...,
        counterparty : typing.Optional[global___Counterparty] = ...,
        connection_hops : typing.Optional[typing.Iterable[typing.Text]] = ...,
        version : typing.Text = ...,
        port_id : typing.Text = ...,
        channel_id : typing.Text = ...,
        ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal[u"counterparty",b"counterparty"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal[u"channel_id",b"channel_id",u"connection_hops",b"connection_hops",u"counterparty",b"counterparty",u"ordering",b"ordering",u"port_id",b"port_id",u"state",b"state",u"version",b"version"]) -> None: ...
global___IdentifiedChannel = IdentifiedChannel

# Counterparty defines a channel end counterparty
class Counterparty(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor = ...
    PORT_ID_FIELD_NUMBER: builtins.int
    CHANNEL_ID_FIELD_NUMBER: builtins.int
    # port on the counterparty chain which owns the other end of the channel.
    port_id: typing.Text = ...
    # channel end on the counterparty chain
    channel_id: typing.Text = ...
    def __init__(self,
        *,
        port_id : typing.Text = ...,
        channel_id : typing.Text = ...,
        ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal[u"channel_id",b"channel_id",u"port_id",b"port_id"]) -> None: ...
global___Counterparty = Counterparty

# Packet defines a type that carries data across different chains through IBC
class Packet(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor = ...
    SEQUENCE_FIELD_NUMBER: builtins.int
    SOURCE_PORT_FIELD_NUMBER: builtins.int
    SOURCE_CHANNEL_FIELD_NUMBER: builtins.int
    DESTINATION_PORT_FIELD_NUMBER: builtins.int
    DESTINATION_CHANNEL_FIELD_NUMBER: builtins.int
    DATA_FIELD_NUMBER: builtins.int
    TIMEOUT_HEIGHT_FIELD_NUMBER: builtins.int
    TIMEOUT_TIMESTAMP_FIELD_NUMBER: builtins.int
    # number corresponds to the order of sends and receives, where a Packet
    # with an earlier sequence number must be sent and received before a Packet
    # with a later sequence number.
    sequence: builtins.int = ...
    # identifies the port on the sending chain.
    source_port: typing.Text = ...
    # identifies the channel end on the sending chain.
    source_channel: typing.Text = ...
    # identifies the port on the receiving chain.
    destination_port: typing.Text = ...
    # identifies the channel end on the receiving chain.
    destination_channel: typing.Text = ...
    # actual opaque bytes transferred directly to the application module
    data: builtins.bytes = ...
    # block height after which the packet times out
    @property
    def timeout_height(self) -> ibc.core.client.v1.client_pb2.Height: ...
    # block timestamp (in nanoseconds) after which the packet times out
    timeout_timestamp: builtins.int = ...
    def __init__(self,
        *,
        sequence : builtins.int = ...,
        source_port : typing.Text = ...,
        source_channel : typing.Text = ...,
        destination_port : typing.Text = ...,
        destination_channel : typing.Text = ...,
        data : builtins.bytes = ...,
        timeout_height : typing.Optional[ibc.core.client.v1.client_pb2.Height] = ...,
        timeout_timestamp : builtins.int = ...,
        ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal[u"timeout_height",b"timeout_height"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal[u"data",b"data",u"destination_channel",b"destination_channel",u"destination_port",b"destination_port",u"sequence",b"sequence",u"source_channel",b"source_channel",u"source_port",b"source_port",u"timeout_height",b"timeout_height",u"timeout_timestamp",b"timeout_timestamp"]) -> None: ...
global___Packet = Packet

# PacketState defines the generic type necessary to retrieve and store
# packet commitments, acknowledgements, and receipts.
# Caller is responsible for knowing the context necessary to interpret this
# state as a commitment, acknowledgement, or a receipt.
class PacketState(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor = ...
    PORT_ID_FIELD_NUMBER: builtins.int
    CHANNEL_ID_FIELD_NUMBER: builtins.int
    SEQUENCE_FIELD_NUMBER: builtins.int
    DATA_FIELD_NUMBER: builtins.int
    # channel port identifier.
    port_id: typing.Text = ...
    # channel unique identifier.
    channel_id: typing.Text = ...
    # packet sequence.
    sequence: builtins.int = ...
    # embedded data that represents packet state.
    data: builtins.bytes = ...
    def __init__(self,
        *,
        port_id : typing.Text = ...,
        channel_id : typing.Text = ...,
        sequence : builtins.int = ...,
        data : builtins.bytes = ...,
        ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal[u"channel_id",b"channel_id",u"data",b"data",u"port_id",b"port_id",u"sequence",b"sequence"]) -> None: ...
global___PacketState = PacketState

# Acknowledgement is the recommended acknowledgement format to be used by
# app-specific protocols.
# NOTE: The field numbers 21 and 22 were explicitly chosen to avoid accidental
# conflicts with other protobuf message formats used for acknowledgements.
# The first byte of any message with this format will be the non-ASCII values
# `0xaa` (result) or `0xb2` (error). Implemented as defined by ICS:
# https://github.com/cosmos/ics/tree/master/spec/ics-004-channel-and-packet-semantics#acknowledgement-envelope
class Acknowledgement(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor = ...
    RESULT_FIELD_NUMBER: builtins.int
    ERROR_FIELD_NUMBER: builtins.int
    result: builtins.bytes = ...
    error: typing.Text = ...
    def __init__(self,
        *,
        result : builtins.bytes = ...,
        error : typing.Text = ...,
        ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal[u"error",b"error",u"response",b"response",u"result",b"result"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal[u"error",b"error",u"response",b"response",u"result",b"result"]) -> None: ...
    def WhichOneof(self, oneof_group: typing_extensions.Literal[u"response",b"response"]) -> typing.Optional[typing_extensions.Literal["result","error"]]: ...
global___Acknowledgement = Acknowledgement
