"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
"""
import builtins
import google.protobuf.descriptor
import google.protobuf.internal.containers
import google.protobuf.internal.enum_type_wrapper
import google.protobuf.message
import ibc.core.commitment.v1.commitment_pb2
import typing
import typing_extensions

DESCRIPTOR: google.protobuf.descriptor.FileDescriptor = ...

# State defines if a connection is in one of the following states:
# INIT, TRYOPEN, OPEN or UNINITIALIZED.
class State(_State, metaclass=_StateEnumTypeWrapper):
    pass
class _State:
    V = typing.NewType('V', builtins.int)
class _StateEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[_State.V], builtins.type):
    DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor = ...
    # Default State
    STATE_UNINITIALIZED_UNSPECIFIED = State.V(0)
    # A connection end has just started the opening handshake.
    STATE_INIT = State.V(1)
    # A connection end has acknowledged the handshake step on the counterparty
    # chain.
    STATE_TRYOPEN = State.V(2)
    # A connection end has completed the handshake.
    STATE_OPEN = State.V(3)

# Default State
STATE_UNINITIALIZED_UNSPECIFIED = State.V(0)
# A connection end has just started the opening handshake.
STATE_INIT = State.V(1)
# A connection end has acknowledged the handshake step on the counterparty
# chain.
STATE_TRYOPEN = State.V(2)
# A connection end has completed the handshake.
STATE_OPEN = State.V(3)
global___State = State


# ICS03 - Connection Data Structures as defined in
# https://github.com/cosmos/ics/tree/master/spec/ics-003-connection-semantics#data-structures

# ConnectionEnd defines a stateful object on a chain connected to another
# separate one.
# NOTE: there must only be 2 defined ConnectionEnds to establish
# a connection between two chains.
class ConnectionEnd(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor = ...
    CLIENT_ID_FIELD_NUMBER: builtins.int
    VERSIONS_FIELD_NUMBER: builtins.int
    STATE_FIELD_NUMBER: builtins.int
    COUNTERPARTY_FIELD_NUMBER: builtins.int
    DELAY_PERIOD_FIELD_NUMBER: builtins.int
    # client associated with this connection.
    client_id: typing.Text = ...
    # IBC version which can be utilised to determine encodings or protocols for
    # channels or packets utilising this connection.
    @property
    def versions(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___Version]: ...
    # current state of the connection end.
    state: global___State.V = ...
    # counterparty chain associated with this connection.
    @property
    def counterparty(self) -> global___Counterparty: ...
    # delay period that must pass before a consensus state can be used for
    # packet-verification NOTE: delay period logic is only implemented by some
    # clients.
    delay_period: builtins.int = ...
    def __init__(self,
        *,
        client_id : typing.Text = ...,
        versions : typing.Optional[typing.Iterable[global___Version]] = ...,
        state : global___State.V = ...,
        counterparty : typing.Optional[global___Counterparty] = ...,
        delay_period : builtins.int = ...,
        ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal[u"counterparty",b"counterparty"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal[u"client_id",b"client_id",u"counterparty",b"counterparty",u"delay_period",b"delay_period",u"state",b"state",u"versions",b"versions"]) -> None: ...
global___ConnectionEnd = ConnectionEnd

# IdentifiedConnection defines a connection with additional connection
# identifier field.
class IdentifiedConnection(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor = ...
    ID_FIELD_NUMBER: builtins.int
    CLIENT_ID_FIELD_NUMBER: builtins.int
    VERSIONS_FIELD_NUMBER: builtins.int
    STATE_FIELD_NUMBER: builtins.int
    COUNTERPARTY_FIELD_NUMBER: builtins.int
    DELAY_PERIOD_FIELD_NUMBER: builtins.int
    # connection identifier.
    id: typing.Text = ...
    # client associated with this connection.
    client_id: typing.Text = ...
    # IBC version which can be utilised to determine encodings or protocols for
    # channels or packets utilising this connection
    @property
    def versions(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___Version]: ...
    # current state of the connection end.
    state: global___State.V = ...
    # counterparty chain associated with this connection.
    @property
    def counterparty(self) -> global___Counterparty: ...
    # delay period associated with this connection.
    delay_period: builtins.int = ...
    def __init__(self,
        *,
        id : typing.Text = ...,
        client_id : typing.Text = ...,
        versions : typing.Optional[typing.Iterable[global___Version]] = ...,
        state : global___State.V = ...,
        counterparty : typing.Optional[global___Counterparty] = ...,
        delay_period : builtins.int = ...,
        ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal[u"counterparty",b"counterparty"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal[u"client_id",b"client_id",u"counterparty",b"counterparty",u"delay_period",b"delay_period",u"id",b"id",u"state",b"state",u"versions",b"versions"]) -> None: ...
global___IdentifiedConnection = IdentifiedConnection

# Counterparty defines the counterparty chain associated with a connection end.
class Counterparty(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor = ...
    CLIENT_ID_FIELD_NUMBER: builtins.int
    CONNECTION_ID_FIELD_NUMBER: builtins.int
    PREFIX_FIELD_NUMBER: builtins.int
    # identifies the client on the counterparty chain associated with a given
    # connection.
    client_id: typing.Text = ...
    # identifies the connection end on the counterparty chain associated with a
    # given connection.
    connection_id: typing.Text = ...
    # commitment merkle prefix of the counterparty chain.
    @property
    def prefix(self) -> ibc.core.commitment.v1.commitment_pb2.MerklePrefix: ...
    def __init__(self,
        *,
        client_id : typing.Text = ...,
        connection_id : typing.Text = ...,
        prefix : typing.Optional[ibc.core.commitment.v1.commitment_pb2.MerklePrefix] = ...,
        ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal[u"prefix",b"prefix"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal[u"client_id",b"client_id",u"connection_id",b"connection_id",u"prefix",b"prefix"]) -> None: ...
global___Counterparty = Counterparty

# ClientPaths define all the connection paths for a client state.
class ClientPaths(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor = ...
    PATHS_FIELD_NUMBER: builtins.int
    # list of connection paths
    @property
    def paths(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[typing.Text]: ...
    def __init__(self,
        *,
        paths : typing.Optional[typing.Iterable[typing.Text]] = ...,
        ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal[u"paths",b"paths"]) -> None: ...
global___ClientPaths = ClientPaths

# ConnectionPaths define all the connection paths for a given client state.
class ConnectionPaths(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor = ...
    CLIENT_ID_FIELD_NUMBER: builtins.int
    PATHS_FIELD_NUMBER: builtins.int
    # client state unique identifier
    client_id: typing.Text = ...
    # list of connection paths
    @property
    def paths(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[typing.Text]: ...
    def __init__(self,
        *,
        client_id : typing.Text = ...,
        paths : typing.Optional[typing.Iterable[typing.Text]] = ...,
        ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal[u"client_id",b"client_id",u"paths",b"paths"]) -> None: ...
global___ConnectionPaths = ConnectionPaths

# Version defines the versioning scheme used to negotiate the IBC verison in
# the connection handshake.
class Version(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor = ...
    IDENTIFIER_FIELD_NUMBER: builtins.int
    FEATURES_FIELD_NUMBER: builtins.int
    # unique version identifier
    identifier: typing.Text = ...
    # list of features compatible with the specified identifier
    @property
    def features(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[typing.Text]: ...
    def __init__(self,
        *,
        identifier : typing.Text = ...,
        features : typing.Optional[typing.Iterable[typing.Text]] = ...,
        ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal[u"features",b"features",u"identifier",b"identifier"]) -> None: ...
global___Version = Version

# Params defines the set of Connection parameters.
class Params(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor = ...
    MAX_EXPECTED_TIME_PER_BLOCK_FIELD_NUMBER: builtins.int
    # maximum expected time per block (in nanoseconds), used to enforce block delay. This parameter should reflect the
    # largest amount of time that the chain might reasonably take to produce the next block under normal operating
    # conditions. A safe choice is 3-5x the expected time per block.
    max_expected_time_per_block: builtins.int = ...
    def __init__(self,
        *,
        max_expected_time_per_block : builtins.int = ...,
        ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal[u"max_expected_time_per_block",b"max_expected_time_per_block"]) -> None: ...
global___Params = Params
