"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
"""
import builtins
import cosmos.base.v1beta1.coin_pb2
import google.protobuf.descriptor
import google.protobuf.internal.containers
import google.protobuf.internal.enum_type_wrapper
import google.protobuf.message
import google.protobuf.timestamp_pb2
import typing
import typing_extensions

DESCRIPTOR: google.protobuf.descriptor.FileDescriptor = ...

# ResolveStatus encodes the status of an oracle request.
class ResolveStatus(_ResolveStatus, metaclass=_ResolveStatusEnumTypeWrapper):
    pass
class _ResolveStatus:
    V = typing.NewType('V', builtins.int)
class _ResolveStatusEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[_ResolveStatus.V], builtins.type):
    DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor = ...
    # Open - the request is not yet resolved.
    RESOLVE_STATUS_OPEN_UNSPECIFIED = ResolveStatus.V(0)
    # Success - the request has been resolved successfully with no errors.
    RESOLVE_STATUS_SUCCESS = ResolveStatus.V(1)
    # Failure - an error occured during the request's resolve call.
    RESOLVE_STATUS_FAILURE = ResolveStatus.V(2)
    # Expired - the request does not get enough reports from validator within the
    # timeframe.
    RESOLVE_STATUS_EXPIRED = ResolveStatus.V(3)

# Open - the request is not yet resolved.
RESOLVE_STATUS_OPEN_UNSPECIFIED = ResolveStatus.V(0)
# Success - the request has been resolved successfully with no errors.
RESOLVE_STATUS_SUCCESS = ResolveStatus.V(1)
# Failure - an error occured during the request's resolve call.
RESOLVE_STATUS_FAILURE = ResolveStatus.V(2)
# Expired - the request does not get enough reports from validator within the
# timeframe.
RESOLVE_STATUS_EXPIRED = ResolveStatus.V(3)
global___ResolveStatus = ResolveStatus


# DataSource is the data structure for storing data sources in the storage.
class DataSource(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor = ...
    OWNER_FIELD_NUMBER: builtins.int
    NAME_FIELD_NUMBER: builtins.int
    DESCRIPTION_FIELD_NUMBER: builtins.int
    FILENAME_FIELD_NUMBER: builtins.int
    TREASURY_FIELD_NUMBER: builtins.int
    FEE_FIELD_NUMBER: builtins.int
    # Owner is an address of the account who own the data source
    owner: typing.Text = ...
    # Name is data source name used for display
    name: typing.Text = ...
    # Description is data source description used for display
    description: typing.Text = ...
    # Filename is string of file name used as reference for locating
    # data source file stored in bandchain nodes
    filename: typing.Text = ...
    # Treasury is the account address who receive data source fee from requester.
    treasury: typing.Text = ...
    # Fee is the data source fee per ask_count that data provider will receive
    # from requester.
    @property
    def fee(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[cosmos.base.v1beta1.coin_pb2.Coin]: ...
    def __init__(self,
        *,
        owner : typing.Text = ...,
        name : typing.Text = ...,
        description : typing.Text = ...,
        filename : typing.Text = ...,
        treasury : typing.Text = ...,
        fee : typing.Optional[typing.Iterable[cosmos.base.v1beta1.coin_pb2.Coin]] = ...,
        ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal[u"description",b"description",u"fee",b"fee",u"filename",b"filename",u"name",b"name",u"owner",b"owner",u"treasury",b"treasury"]) -> None: ...
global___DataSource = DataSource

# OracleScript is the data structure for storing oracle scripts in the storage.
class OracleScript(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor = ...
    OWNER_FIELD_NUMBER: builtins.int
    NAME_FIELD_NUMBER: builtins.int
    DESCRIPTION_FIELD_NUMBER: builtins.int
    FILENAME_FIELD_NUMBER: builtins.int
    SCHEMA_FIELD_NUMBER: builtins.int
    SOURCE_CODE_URL_FIELD_NUMBER: builtins.int
    # Owner is an address of the account who own the oracle script
    owner: typing.Text = ...
    # Name is oracle script name used for display
    name: typing.Text = ...
    # Description is oracle script description used for display
    description: typing.Text = ...
    # Filename is string of file name used as reference for locating
    # compiled oracle script WASM file stored in bandchain nodes
    filename: typing.Text = ...
    # Schema is the schema of the oracle script input/output
    # which is formatted in OBI format e.g.
    # "{symbol:string,multiplier:u64}/{px:u64}"
    schema: typing.Text = ...
    # SourceCodeURL is the URL of oracle script's source code.
    # It is recommendded to store source code on IPFS and get its URL to preserve
    # decentralization.
    source_code_url: typing.Text = ...
    def __init__(self,
        *,
        owner : typing.Text = ...,
        name : typing.Text = ...,
        description : typing.Text = ...,
        filename : typing.Text = ...,
        schema : typing.Text = ...,
        source_code_url : typing.Text = ...,
        ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal[u"description",b"description",u"filename",b"filename",u"name",b"name",u"owner",b"owner",u"schema",b"schema",u"source_code_url",b"source_code_url"]) -> None: ...
global___OracleScript = OracleScript

# RawRequest is the data structure for storing raw requests in the storage.
class RawRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor = ...
    EXTERNAL_ID_FIELD_NUMBER: builtins.int
    DATA_SOURCE_ID_FIELD_NUMBER: builtins.int
    CALLDATA_FIELD_NUMBER: builtins.int
    # ExternalID is an ID of the raw request
    external_id: builtins.int = ...
    # DataSourceID is an ID of data source script that relates to the raw request
    data_source_id: builtins.int = ...
    # Calldata is the data used as argument params for executing data source
    # script
    calldata: builtins.bytes = ...
    def __init__(self,
        *,
        external_id : builtins.int = ...,
        data_source_id : builtins.int = ...,
        calldata : builtins.bytes = ...,
        ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal[u"calldata",b"calldata",u"data_source_id",b"data_source_id",u"external_id",b"external_id"]) -> None: ...
global___RawRequest = RawRequest

# RawRequest is the data structure for storing raw reporter in the storage.
class RawReport(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor = ...
    EXTERNAL_ID_FIELD_NUMBER: builtins.int
    EXIT_CODE_FIELD_NUMBER: builtins.int
    DATA_FIELD_NUMBER: builtins.int
    # ExternalID is an ID of the raw request
    external_id: builtins.int = ...
    # ExitCode is status code provided by validators to specify error, if any.
    # Exit code is usually filled by the exit code returned from execution of
    # specified data source script. With code 0 means there is no error.
    exit_code: builtins.int = ...
    # Data is raw result provided by validators.
    # It is usually filled by the result from execution of specified data source
    # script.
    data: builtins.bytes = ...
    def __init__(self,
        *,
        external_id : builtins.int = ...,
        exit_code : builtins.int = ...,
        data : builtins.bytes = ...,
        ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal[u"data",b"data",u"exit_code",b"exit_code",u"external_id",b"external_id"]) -> None: ...
global___RawReport = RawReport

# Request is the data structure for storing requests in the storage.
class Request(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor = ...
    ORACLE_SCRIPT_ID_FIELD_NUMBER: builtins.int
    CALLDATA_FIELD_NUMBER: builtins.int
    REQUESTED_VALIDATORS_FIELD_NUMBER: builtins.int
    MIN_COUNT_FIELD_NUMBER: builtins.int
    REQUEST_HEIGHT_FIELD_NUMBER: builtins.int
    REQUEST_TIME_FIELD_NUMBER: builtins.int
    CLIENT_ID_FIELD_NUMBER: builtins.int
    RAW_REQUESTS_FIELD_NUMBER: builtins.int
    IBC_CHANNEL_FIELD_NUMBER: builtins.int
    EXECUTE_GAS_FIELD_NUMBER: builtins.int
    # OracleScriptID is ID of an oracle script
    oracle_script_id: builtins.int = ...
    # Calldata is the data used as argument params for the oracle script
    calldata: builtins.bytes = ...
    # RequestedValidators is a list of validator addresses that are assigned for
    # fulfilling the request
    @property
    def requested_validators(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[typing.Text]: ...
    # MinCount is minimum number of validators required for fulfilling the
    # request
    min_count: builtins.int = ...
    # RequestHeight is block height that the request has been created
    request_height: builtins.int = ...
    # RequestTime is timestamp of the chain's block which contains the request
    request_time: builtins.int = ...
    # ClientID is arbitrary id provided by requester.
    # It is used by client-side for referencing the request
    client_id: typing.Text = ...
    # RawRequests is a list of raw requests specified by execution of oracle
    # script
    @property
    def raw_requests(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___RawRequest]: ...
    # IBCChannel is an IBC channel info of the other chain, which contains a
    # channel and a port to allow bandchain connect to that chain. This field
    # allows other chain be able to request data from bandchain via IBC.
    @property
    def ibc_channel(self) -> global___IBCChannel: ...
    # ExecuteGas is amount of gas to reserve for executing
    execute_gas: builtins.int = ...
    def __init__(self,
        *,
        oracle_script_id : builtins.int = ...,
        calldata : builtins.bytes = ...,
        requested_validators : typing.Optional[typing.Iterable[typing.Text]] = ...,
        min_count : builtins.int = ...,
        request_height : builtins.int = ...,
        request_time : builtins.int = ...,
        client_id : typing.Text = ...,
        raw_requests : typing.Optional[typing.Iterable[global___RawRequest]] = ...,
        ibc_channel : typing.Optional[global___IBCChannel] = ...,
        execute_gas : builtins.int = ...,
        ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal[u"ibc_channel",b"ibc_channel"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal[u"calldata",b"calldata",u"client_id",b"client_id",u"execute_gas",b"execute_gas",u"ibc_channel",b"ibc_channel",u"min_count",b"min_count",u"oracle_script_id",b"oracle_script_id",u"raw_requests",b"raw_requests",u"request_height",b"request_height",u"request_time",b"request_time",u"requested_validators",b"requested_validators"]) -> None: ...
global___Request = Request

# Report is the data structure for storing reports in the storage.
class Report(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor = ...
    VALIDATOR_FIELD_NUMBER: builtins.int
    IN_BEFORE_RESOLVE_FIELD_NUMBER: builtins.int
    RAW_REPORTS_FIELD_NUMBER: builtins.int
    # Validator is a validator address who submit the report
    validator: typing.Text = ...
    # InBeforeResolve indicates whether the report is submitted before the
    # request resolved
    in_before_resolve: builtins.bool = ...
    # RawReports is list of raw reports provided by the validator.
    # Each raw report has different external ID
    @property
    def raw_reports(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___RawReport]: ...
    def __init__(self,
        *,
        validator : typing.Text = ...,
        in_before_resolve : builtins.bool = ...,
        raw_reports : typing.Optional[typing.Iterable[global___RawReport]] = ...,
        ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal[u"in_before_resolve",b"in_before_resolve",u"raw_reports",b"raw_reports",u"validator",b"validator"]) -> None: ...
global___Report = Report

# OracleRequestPacketData encodes an oracle request sent from other blockchains
# to BandChain.
class OracleRequestPacketData(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor = ...
    CLIENT_ID_FIELD_NUMBER: builtins.int
    ORACLE_SCRIPT_ID_FIELD_NUMBER: builtins.int
    CALLDATA_FIELD_NUMBER: builtins.int
    ASK_COUNT_FIELD_NUMBER: builtins.int
    MIN_COUNT_FIELD_NUMBER: builtins.int
    FEE_LIMIT_FIELD_NUMBER: builtins.int
    PREPARE_GAS_FIELD_NUMBER: builtins.int
    EXECUTE_GAS_FIELD_NUMBER: builtins.int
    # ClientID is the unique identifier of this oracle request, as specified by
    # the client. This same unique ID will be sent back to the requester with the
    # oracle response.
    client_id: typing.Text = ...
    # OracleScriptID is the unique identifier of the oracle script to be
    # executed.
    oracle_script_id: builtins.int = ...
    # Calldata is the OBI-encoded calldata bytes available for oracle executor to
    # read.
    calldata: builtins.bytes = ...
    # AskCount is the number of validators that are requested to respond to this
    # oracle request. Higher value means more security, at a higher gas cost.
    ask_count: builtins.int = ...
    # MinCount is the minimum number of validators necessary for the request to
    # proceed to the execution phase. Higher value means more security, at the
    # cost of liveness.
    min_count: builtins.int = ...
    # FeeLimit is the maximum tokens that will be paid to all data source
    # providers.
    @property
    def fee_limit(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[cosmos.base.v1beta1.coin_pb2.Coin]: ...
    # PrepareGas is amount of gas to pay to prepare raw requests
    prepare_gas: builtins.int = ...
    # ExecuteGas is amount of gas to reserve for executing
    execute_gas: builtins.int = ...
    def __init__(self,
        *,
        client_id : typing.Text = ...,
        oracle_script_id : builtins.int = ...,
        calldata : builtins.bytes = ...,
        ask_count : builtins.int = ...,
        min_count : builtins.int = ...,
        fee_limit : typing.Optional[typing.Iterable[cosmos.base.v1beta1.coin_pb2.Coin]] = ...,
        prepare_gas : builtins.int = ...,
        execute_gas : builtins.int = ...,
        ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal[u"ask_count",b"ask_count",u"calldata",b"calldata",u"client_id",b"client_id",u"execute_gas",b"execute_gas",u"fee_limit",b"fee_limit",u"min_count",b"min_count",u"oracle_script_id",b"oracle_script_id",u"prepare_gas",b"prepare_gas"]) -> None: ...
global___OracleRequestPacketData = OracleRequestPacketData

# OracleRequestPacketAcknowledgement encodes an oracle request acknowledgement
# send back to requester chain.
class OracleRequestPacketAcknowledgement(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor = ...
    REQUEST_ID_FIELD_NUMBER: builtins.int
    # RequestID is BandChain's unique identifier for this oracle request.
    request_id: builtins.int = ...
    def __init__(self,
        *,
        request_id : builtins.int = ...,
        ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal[u"request_id",b"request_id"]) -> None: ...
global___OracleRequestPacketAcknowledgement = OracleRequestPacketAcknowledgement

# OracleResponsePacketData encodes an oracle response from BandChain to the
# requester.
class OracleResponsePacketData(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor = ...
    CLIENT_ID_FIELD_NUMBER: builtins.int
    REQUEST_ID_FIELD_NUMBER: builtins.int
    ANS_COUNT_FIELD_NUMBER: builtins.int
    REQUEST_TIME_FIELD_NUMBER: builtins.int
    RESOLVE_TIME_FIELD_NUMBER: builtins.int
    RESOLVE_STATUS_FIELD_NUMBER: builtins.int
    RESULT_FIELD_NUMBER: builtins.int
    # ClientID is the unique identifier matched with that of the oracle request
    # packet.
    client_id: typing.Text = ...
    # RequestID is BandChain's unique identifier for this oracle request.
    request_id: builtins.int = ...
    # AnsCount is the number of validators among to the asked validators that
    # actually responded to this oracle request prior to this oracle request
    # being resolved.
    ans_count: builtins.int = ...
    # RequestTime is the UNIX epoch time at which the request was sent to
    # BandChain.
    request_time: builtins.int = ...
    # ResolveTime is the UNIX epoch time at which the request was resolved to the
    # final result.
    resolve_time: builtins.int = ...
    # ResolveStatus is the status of this oracle request, which can be OK,
    # FAILURE, or EXPIRED.
    resolve_status: global___ResolveStatus.V = ...
    # Result is the final aggregated value encoded in OBI format. Only available
    # if status if OK.
    result: builtins.bytes = ...
    def __init__(self,
        *,
        client_id : typing.Text = ...,
        request_id : builtins.int = ...,
        ans_count : builtins.int = ...,
        request_time : builtins.int = ...,
        resolve_time : builtins.int = ...,
        resolve_status : global___ResolveStatus.V = ...,
        result : builtins.bytes = ...,
        ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal[u"ans_count",b"ans_count",u"client_id",b"client_id",u"request_id",b"request_id",u"request_time",b"request_time",u"resolve_status",b"resolve_status",u"resolve_time",b"resolve_time",u"result",b"result"]) -> None: ...
global___OracleResponsePacketData = OracleResponsePacketData

# Result encodes a result of request and store in chain
class Result(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor = ...
    CLIENT_ID_FIELD_NUMBER: builtins.int
    ORACLE_SCRIPT_ID_FIELD_NUMBER: builtins.int
    CALLDATA_FIELD_NUMBER: builtins.int
    ASK_COUNT_FIELD_NUMBER: builtins.int
    MIN_COUNT_FIELD_NUMBER: builtins.int
    REQUEST_ID_FIELD_NUMBER: builtins.int
    ANS_COUNT_FIELD_NUMBER: builtins.int
    REQUEST_TIME_FIELD_NUMBER: builtins.int
    RESOLVE_TIME_FIELD_NUMBER: builtins.int
    RESOLVE_STATUS_FIELD_NUMBER: builtins.int
    RESULT_FIELD_NUMBER: builtins.int
    # ClientID is the unique identifier of this oracle request, as specified by
    # the client. This same unique ID will be sent back to the requester with the
    # oracle response.
    client_id: typing.Text = ...
    # OracleScriptID is the unique identifier of the oracle script to be
    # executed.
    oracle_script_id: builtins.int = ...
    # Calldata is the calldata bytes available for oracle executor to read.
    calldata: builtins.bytes = ...
    # AskCount is the number of validators that are requested to respond to this
    # oracle request. Higher value means more security, at a higher gas cost.
    ask_count: builtins.int = ...
    # MinCount is the minimum number of validators necessary for the request to
    # proceed to the execution phase. Higher value means more security, at the
    # cost of liveness.
    min_count: builtins.int = ...
    # RequestID is BandChain's unique identifier for this oracle request.
    request_id: builtins.int = ...
    # AnsCount is the number of validators among to the asked validators that
    # actually responded to this oracle request prior to this oracle request
    # being resolved.
    ans_count: builtins.int = ...
    # RequestTime is the UNIX epoch time at which the request was sent to
    # BandChain.
    request_time: builtins.int = ...
    # ResolveTime is the UNIX epoch time at which the request was resolved to the
    # final result.
    resolve_time: builtins.int = ...
    # ResolveStatus is the status of this oracle request, which can be OK,
    # FAILURE, or EXPIRED.
    resolve_status: global___ResolveStatus.V = ...
    # Result is the final aggregated value only available if status if OK.
    result: builtins.bytes = ...
    def __init__(self,
        *,
        client_id : typing.Text = ...,
        oracle_script_id : builtins.int = ...,
        calldata : builtins.bytes = ...,
        ask_count : builtins.int = ...,
        min_count : builtins.int = ...,
        request_id : builtins.int = ...,
        ans_count : builtins.int = ...,
        request_time : builtins.int = ...,
        resolve_time : builtins.int = ...,
        resolve_status : global___ResolveStatus.V = ...,
        result : builtins.bytes = ...,
        ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal[u"ans_count",b"ans_count",u"ask_count",b"ask_count",u"calldata",b"calldata",u"client_id",b"client_id",u"min_count",b"min_count",u"oracle_script_id",b"oracle_script_id",u"request_id",b"request_id",u"request_time",b"request_time",u"resolve_status",b"resolve_status",u"resolve_time",b"resolve_time",u"result",b"result"]) -> None: ...
global___Result = Result

# ValidatorStatus maintains whether a validator is an active oracle provider.
class ValidatorStatus(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor = ...
    IS_ACTIVE_FIELD_NUMBER: builtins.int
    SINCE_FIELD_NUMBER: builtins.int
    # IsActive is a boolean indicating active status of validator.
    # The validator will be deactivated when they are unable to send reports
    # to fulfill oracle request before the request expired.
    is_active: builtins.bool = ...
    # Since is a block timestamp when validator has been activated/deactivated
    @property
    def since(self) -> google.protobuf.timestamp_pb2.Timestamp: ...
    def __init__(self,
        *,
        is_active : builtins.bool = ...,
        since : typing.Optional[google.protobuf.timestamp_pb2.Timestamp] = ...,
        ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal[u"since",b"since"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal[u"is_active",b"is_active",u"since",b"since"]) -> None: ...
global___ValidatorStatus = ValidatorStatus

# ActiveValidator is information of currently active validator
class ActiveValidator(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor = ...
    ADDRESS_FIELD_NUMBER: builtins.int
    POWER_FIELD_NUMBER: builtins.int
    # Address is a validator address
    address: typing.Text = ...
    # Power is an amount of token that the validator is holding
    power: builtins.int = ...
    def __init__(self,
        *,
        address : typing.Text = ...,
        power : builtins.int = ...,
        ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal[u"address",b"address",u"power",b"power"]) -> None: ...
global___ActiveValidator = ActiveValidator

# Params is the data structure that keeps the parameters of the oracle module.
class Params(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor = ...
    MAX_RAW_REQUEST_COUNT_FIELD_NUMBER: builtins.int
    MAX_ASK_COUNT_FIELD_NUMBER: builtins.int
    MAX_CALLDATA_SIZE_FIELD_NUMBER: builtins.int
    MAX_REPORT_DATA_SIZE_FIELD_NUMBER: builtins.int
    EXPIRATION_BLOCK_COUNT_FIELD_NUMBER: builtins.int
    BASE_OWASM_GAS_FIELD_NUMBER: builtins.int
    PER_VALIDATOR_REQUEST_GAS_FIELD_NUMBER: builtins.int
    SAMPLING_TRY_COUNT_FIELD_NUMBER: builtins.int
    ORACLE_REWARD_PERCENTAGE_FIELD_NUMBER: builtins.int
    INACTIVE_PENALTY_DURATION_FIELD_NUMBER: builtins.int
    IBC_REQUEST_ENABLED_FIELD_NUMBER: builtins.int
    # MaxRawRequestCount is the maximum number of data source raw requests a
    # request can make.
    max_raw_request_count: builtins.int = ...
    # MaxAskCount is the maximum number of validators a request can target.
    max_ask_count: builtins.int = ...
    # MaxCalldataSize is the maximum size limit of calldata (bytes) in a request.
    max_calldata_size: builtins.int = ...
    # MaxReportDataSize is the maximum size limit of report data (bytes) in a
    # report.
    max_report_data_size: builtins.int = ...
    # ExpirationBlockCount is the number of blocks a request stays valid before
    # it gets expired due to insufficient reports.
    expiration_block_count: builtins.int = ...
    # BaseOwasmGas is the base amount of Cosmos-SDK gas charged for owasm
    # execution.
    base_owasm_gas: builtins.int = ...
    # PerValidatorRequestGas is the amount of Cosmos-SDK gas charged per
    # requested validator.
    per_validator_request_gas: builtins.int = ...
    # SamplingTryCount the number of validator sampling tries to pick the highest
    # voting power subset of validators to perform an oracle task.
    sampling_try_count: builtins.int = ...
    # OracleRewardPercentage is the percentage of block rewards allocated to
    # active oracle validators.
    oracle_reward_percentage: builtins.int = ...
    # InactivePenaltyDuration is the duration period where a validator cannot
    # activate back after missing an oracle report.
    inactive_penalty_duration: builtins.int = ...
    # IBCRequestEnabled is a flag indicating whether sending oracle request via
    # IBC is allowed
    ibc_request_enabled: builtins.bool = ...
    def __init__(self,
        *,
        max_raw_request_count : builtins.int = ...,
        max_ask_count : builtins.int = ...,
        max_calldata_size : builtins.int = ...,
        max_report_data_size : builtins.int = ...,
        expiration_block_count : builtins.int = ...,
        base_owasm_gas : builtins.int = ...,
        per_validator_request_gas : builtins.int = ...,
        sampling_try_count : builtins.int = ...,
        oracle_reward_percentage : builtins.int = ...,
        inactive_penalty_duration : builtins.int = ...,
        ibc_request_enabled : builtins.bool = ...,
        ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal[u"base_owasm_gas",b"base_owasm_gas",u"expiration_block_count",b"expiration_block_count",u"ibc_request_enabled",b"ibc_request_enabled",u"inactive_penalty_duration",b"inactive_penalty_duration",u"max_ask_count",b"max_ask_count",u"max_calldata_size",b"max_calldata_size",u"max_raw_request_count",b"max_raw_request_count",u"max_report_data_size",b"max_report_data_size",u"oracle_reward_percentage",b"oracle_reward_percentage",u"per_validator_request_gas",b"per_validator_request_gas",u"sampling_try_count",b"sampling_try_count"]) -> None: ...
global___Params = Params

# PendingResolveList is a list of requests that are waiting to be resolved
class PendingResolveList(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor = ...
    REQUEST_IDS_FIELD_NUMBER: builtins.int
    # RequestIDs is a list of request IDs that are waiting to be resolved
    @property
    def request_ids(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.int]: ...
    def __init__(self,
        *,
        request_ids : typing.Optional[typing.Iterable[builtins.int]] = ...,
        ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal[u"request_ids",b"request_ids"]) -> None: ...
global___PendingResolveList = PendingResolveList

# IBCChannel is information of IBC protocol to allow communicating with other
# chain
class IBCChannel(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor = ...
    PORT_ID_FIELD_NUMBER: builtins.int
    CHANNEL_ID_FIELD_NUMBER: builtins.int
    # PortID is port ID used for sending response packet when request is
    # resolved.
    port_id: typing.Text = ...
    # ChannelID is channel ID used for sending response packet when request is
    # resolved.
    channel_id: typing.Text = ...
    def __init__(self,
        *,
        port_id : typing.Text = ...,
        channel_id : typing.Text = ...,
        ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal[u"channel_id",b"channel_id",u"port_id",b"port_id"]) -> None: ...
global___IBCChannel = IBCChannel

# RequestVerification is a message that is constructed and signed by a reporter
# to be used as a part of verification of oracle request.
class RequestVerification(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor = ...
    CHAIN_ID_FIELD_NUMBER: builtins.int
    VALIDATOR_FIELD_NUMBER: builtins.int
    REQUEST_ID_FIELD_NUMBER: builtins.int
    EXTERNAL_ID_FIELD_NUMBER: builtins.int
    # ChainID is the ID of targeted chain
    chain_id: typing.Text = ...
    # Validator is an validator address
    validator: typing.Text = ...
    # RequestID is the targeted request ID
    request_id: builtins.int = ...
    # ExternalID is the oracle's external ID of data source
    external_id: builtins.int = ...
    def __init__(self,
        *,
        chain_id : typing.Text = ...,
        validator : typing.Text = ...,
        request_id : builtins.int = ...,
        external_id : builtins.int = ...,
        ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal[u"chain_id",b"chain_id",u"external_id",b"external_id",u"request_id",b"request_id",u"validator",b"validator"]) -> None: ...
global___RequestVerification = RequestVerification

# PriceResult is a result from standard price reference
class PriceResult(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor = ...
    SYMBOL_FIELD_NUMBER: builtins.int
    MULTIPLIER_FIELD_NUMBER: builtins.int
    PX_FIELD_NUMBER: builtins.int
    REQUEST_ID_FIELD_NUMBER: builtins.int
    RESOLVE_TIME_FIELD_NUMBER: builtins.int
    # Symbol is unit of data indicating what the data is. It is price currencies
    # for this case.
    symbol: typing.Text = ...
    # Multiplier is a number used for left-shifting value to eliminate decimal
    # digits
    multiplier: builtins.int = ...
    # Px is the actual data, which is rate number multiplied by the multiplier.
    px: builtins.int = ...
    # RequestID is oracle request ID that contains this price
    request_id: builtins.int = ...
    # ResolveTime is epoch timestamp indicating the time when the request had
    # been resolved
    resolve_time: builtins.int = ...
    def __init__(self,
        *,
        symbol : typing.Text = ...,
        multiplier : builtins.int = ...,
        px : builtins.int = ...,
        request_id : builtins.int = ...,
        resolve_time : builtins.int = ...,
        ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal[u"multiplier",b"multiplier",u"px",b"px",u"request_id",b"request_id",u"resolve_time",b"resolve_time",u"symbol",b"symbol"]) -> None: ...
global___PriceResult = PriceResult
