import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface BigqueryReservationAssignmentConfig extends cdktf.TerraformMetaArguments {
    /**
    * The resource which will use the reservation. E.g. projects/myproject, folders/123, organizations/456.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_reservation_assignment#assignee BigqueryReservationAssignment#assignee}
    */
    readonly assignee: string;
    /**
    * Types of job, which could be specified when using the reservation. Possible values: JOB_TYPE_UNSPECIFIED, PIPELINE, QUERY
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_reservation_assignment#job_type BigqueryReservationAssignment#job_type}
    */
    readonly jobType: string;
    /**
    * The location for the resource
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_reservation_assignment#location BigqueryReservationAssignment#location}
    */
    readonly location?: string;
    /**
    * The project for the resource
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_reservation_assignment#project BigqueryReservationAssignment#project}
    */
    readonly project?: string;
    /**
    * The reservation for the resource
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_reservation_assignment#reservation BigqueryReservationAssignment#reservation}
    */
    readonly reservation: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_reservation_assignment#timeouts BigqueryReservationAssignment#timeouts}
    */
    readonly timeouts?: BigqueryReservationAssignmentTimeouts;
}
export interface BigqueryReservationAssignmentTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_reservation_assignment#create BigqueryReservationAssignment#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_reservation_assignment#delete BigqueryReservationAssignment#delete}
    */
    readonly delete?: string;
}
export declare function bigqueryReservationAssignmentTimeoutsToTerraform(struct?: BigqueryReservationAssignmentTimeoutsOutputReference | BigqueryReservationAssignmentTimeouts | cdktf.IResolvable): any;
export declare class BigqueryReservationAssignmentTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): BigqueryReservationAssignmentTimeouts | undefined;
    set internalValue(value: BigqueryReservationAssignmentTimeouts | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google/r/bigquery_reservation_assignment google_bigquery_reservation_assignment}
*/
export declare class BigqueryReservationAssignment extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_bigquery_reservation_assignment";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google/r/bigquery_reservation_assignment google_bigquery_reservation_assignment} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options BigqueryReservationAssignmentConfig
    */
    constructor(scope: Construct, id: string, config: BigqueryReservationAssignmentConfig);
    private _assignee?;
    get assignee(): string;
    set assignee(value: string);
    get assigneeInput(): string | undefined;
    get id(): string;
    private _jobType?;
    get jobType(): string;
    set jobType(value: string);
    get jobTypeInput(): string | undefined;
    private _location?;
    get location(): string;
    set location(value: string);
    resetLocation(): void;
    get locationInput(): string | undefined;
    get name(): string;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _reservation?;
    get reservation(): string;
    set reservation(value: string);
    get reservationInput(): string | undefined;
    get state(): string;
    private _timeouts;
    get timeouts(): BigqueryReservationAssignmentTimeoutsOutputReference;
    putTimeouts(value: BigqueryReservationAssignmentTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): BigqueryReservationAssignmentTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
