import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface ComputeNetworkPeeringRoutesConfigConfig extends cdktf.TerraformMetaArguments {
    /**
    * Whether to export the custom routes to the peer network.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_network_peering_routes_config#export_custom_routes ComputeNetworkPeeringRoutesConfig#export_custom_routes}
    */
    readonly exportCustomRoutes: boolean | cdktf.IResolvable;
    /**
    * Whether to import the custom routes to the peer network.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_network_peering_routes_config#import_custom_routes ComputeNetworkPeeringRoutesConfig#import_custom_routes}
    */
    readonly importCustomRoutes: boolean | cdktf.IResolvable;
    /**
    * The name of the primary network for the peering.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_network_peering_routes_config#network ComputeNetworkPeeringRoutesConfig#network}
    */
    readonly network: string;
    /**
    * Name of the peering.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_network_peering_routes_config#peering ComputeNetworkPeeringRoutesConfig#peering}
    */
    readonly peering: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_network_peering_routes_config#project ComputeNetworkPeeringRoutesConfig#project}
    */
    readonly project?: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_network_peering_routes_config#timeouts ComputeNetworkPeeringRoutesConfig#timeouts}
    */
    readonly timeouts?: ComputeNetworkPeeringRoutesConfigTimeouts;
}
export interface ComputeNetworkPeeringRoutesConfigTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_network_peering_routes_config#create ComputeNetworkPeeringRoutesConfig#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_network_peering_routes_config#delete ComputeNetworkPeeringRoutesConfig#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_network_peering_routes_config#update ComputeNetworkPeeringRoutesConfig#update}
    */
    readonly update?: string;
}
export declare function computeNetworkPeeringRoutesConfigTimeoutsToTerraform(struct?: ComputeNetworkPeeringRoutesConfigTimeoutsOutputReference | ComputeNetworkPeeringRoutesConfigTimeouts | cdktf.IResolvable): any;
export declare class ComputeNetworkPeeringRoutesConfigTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ComputeNetworkPeeringRoutesConfigTimeouts | undefined;
    set internalValue(value: ComputeNetworkPeeringRoutesConfigTimeouts | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google/r/compute_network_peering_routes_config google_compute_network_peering_routes_config}
*/
export declare class ComputeNetworkPeeringRoutesConfig extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_compute_network_peering_routes_config";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google/r/compute_network_peering_routes_config google_compute_network_peering_routes_config} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options ComputeNetworkPeeringRoutesConfigConfig
    */
    constructor(scope: Construct, id: string, config: ComputeNetworkPeeringRoutesConfigConfig);
    private _exportCustomRoutes?;
    get exportCustomRoutes(): boolean | cdktf.IResolvable;
    set exportCustomRoutes(value: boolean | cdktf.IResolvable);
    get exportCustomRoutesInput(): boolean | cdktf.IResolvable | undefined;
    get id(): string;
    private _importCustomRoutes?;
    get importCustomRoutes(): boolean | cdktf.IResolvable;
    set importCustomRoutes(value: boolean | cdktf.IResolvable);
    get importCustomRoutesInput(): boolean | cdktf.IResolvable | undefined;
    private _network?;
    get network(): string;
    set network(value: string);
    get networkInput(): string | undefined;
    private _peering?;
    get peering(): string;
    set peering(value: string);
    get peeringInput(): string | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _timeouts;
    get timeouts(): ComputeNetworkPeeringRoutesConfigTimeoutsOutputReference;
    putTimeouts(value: ComputeNetworkPeeringRoutesConfigTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): ComputeNetworkPeeringRoutesConfigTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
