import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface ComputeSharedVpcHostProjectConfig extends cdktf.TerraformMetaArguments {
    /**
    * The ID of the project that will serve as a Shared VPC host project
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_shared_vpc_host_project#project ComputeSharedVpcHostProject#project}
    */
    readonly project: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_shared_vpc_host_project#timeouts ComputeSharedVpcHostProject#timeouts}
    */
    readonly timeouts?: ComputeSharedVpcHostProjectTimeouts;
}
export interface ComputeSharedVpcHostProjectTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_shared_vpc_host_project#create ComputeSharedVpcHostProject#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_shared_vpc_host_project#delete ComputeSharedVpcHostProject#delete}
    */
    readonly delete?: string;
}
export declare function computeSharedVpcHostProjectTimeoutsToTerraform(struct?: ComputeSharedVpcHostProjectTimeoutsOutputReference | ComputeSharedVpcHostProjectTimeouts | cdktf.IResolvable): any;
export declare class ComputeSharedVpcHostProjectTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ComputeSharedVpcHostProjectTimeouts | undefined;
    set internalValue(value: ComputeSharedVpcHostProjectTimeouts | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google/r/compute_shared_vpc_host_project google_compute_shared_vpc_host_project}
*/
export declare class ComputeSharedVpcHostProject extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_compute_shared_vpc_host_project";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google/r/compute_shared_vpc_host_project google_compute_shared_vpc_host_project} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options ComputeSharedVpcHostProjectConfig
    */
    constructor(scope: Construct, id: string, config: ComputeSharedVpcHostProjectConfig);
    get id(): string;
    private _project?;
    get project(): string;
    set project(value: string);
    get projectInput(): string | undefined;
    private _timeouts;
    get timeouts(): ComputeSharedVpcHostProjectTimeoutsOutputReference;
    putTimeouts(value: ComputeSharedVpcHostProjectTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): ComputeSharedVpcHostProjectTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
