import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface ContainerAzureNodePoolConfig extends cdktf.TerraformMetaArguments {
    /**
    * Optional. Annotations on the node pool. This field has the same restrictions as Kubernetes annotations. The total size of all keys and values combined is limited to 256k. Keys can have 2 segments: prefix (optional) and name (required), separated by a slash (/). Prefix must be a DNS subdomain. Name must be 63 characters or less, begin and end with alphanumerics, with dashes (-), underscores (_), dots (.), and alphanumerics between.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_azure_node_pool#annotations ContainerAzureNodePool#annotations}
    */
    readonly annotations?: {
        [key: string]: string;
    };
    /**
    * Optional. The Azure availability zone of the nodes in this nodepool. When unspecified, it defaults to `1`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_azure_node_pool#azure_availability_zone ContainerAzureNodePool#azure_availability_zone}
    */
    readonly azureAvailabilityZone?: string;
    /**
    * The azureCluster for the resource
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_azure_node_pool#cluster ContainerAzureNodePool#cluster}
    */
    readonly cluster: string;
    /**
    * The location for the resource
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_azure_node_pool#location ContainerAzureNodePool#location}
    */
    readonly location: string;
    /**
    * The name of this resource.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_azure_node_pool#name ContainerAzureNodePool#name}
    */
    readonly name: string;
    /**
    * The project for the resource
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_azure_node_pool#project ContainerAzureNodePool#project}
    */
    readonly project?: string;
    /**
    * The ARM ID of the subnet where the node pool VMs run. Make sure it's a subnet under the virtual network in the cluster configuration.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_azure_node_pool#subnet_id ContainerAzureNodePool#subnet_id}
    */
    readonly subnetId: string;
    /**
    * The Kubernetes version (e.g. `1.19.10-gke.1000`) running on this node pool.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_azure_node_pool#version ContainerAzureNodePool#version}
    */
    readonly version: string;
    /**
    * autoscaling block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_azure_node_pool#autoscaling ContainerAzureNodePool#autoscaling}
    */
    readonly autoscaling: ContainerAzureNodePoolAutoscaling;
    /**
    * config block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_azure_node_pool#config ContainerAzureNodePool#config}
    */
    readonly config: ContainerAzureNodePoolConfigA;
    /**
    * max_pods_constraint block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_azure_node_pool#max_pods_constraint ContainerAzureNodePool#max_pods_constraint}
    */
    readonly maxPodsConstraint: ContainerAzureNodePoolMaxPodsConstraint;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_azure_node_pool#timeouts ContainerAzureNodePool#timeouts}
    */
    readonly timeouts?: ContainerAzureNodePoolTimeouts;
}
export interface ContainerAzureNodePoolAutoscaling {
    /**
    * Maximum number of nodes in the node pool. Must be >= min_node_count.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_azure_node_pool#max_node_count ContainerAzureNodePool#max_node_count}
    */
    readonly maxNodeCount: number;
    /**
    * Minimum number of nodes in the node pool. Must be >= 1 and <= max_node_count.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_azure_node_pool#min_node_count ContainerAzureNodePool#min_node_count}
    */
    readonly minNodeCount: number;
}
export declare function containerAzureNodePoolAutoscalingToTerraform(struct?: ContainerAzureNodePoolAutoscalingOutputReference | ContainerAzureNodePoolAutoscaling): any;
export declare class ContainerAzureNodePoolAutoscalingOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ContainerAzureNodePoolAutoscaling | undefined;
    set internalValue(value: ContainerAzureNodePoolAutoscaling | undefined);
    private _maxNodeCount?;
    get maxNodeCount(): number;
    set maxNodeCount(value: number);
    get maxNodeCountInput(): number | undefined;
    private _minNodeCount?;
    get minNodeCount(): number;
    set minNodeCount(value: number);
    get minNodeCountInput(): number | undefined;
}
export interface ContainerAzureNodePoolConfigRootVolume {
    /**
    * Optional. The size of the disk, in GiBs. When unspecified, a default value is provided. See the specific reference in the parent resource.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_azure_node_pool#size_gib ContainerAzureNodePool#size_gib}
    */
    readonly sizeGib?: number;
}
export declare function containerAzureNodePoolConfigRootVolumeToTerraform(struct?: ContainerAzureNodePoolConfigRootVolumeOutputReference | ContainerAzureNodePoolConfigRootVolume): any;
export declare class ContainerAzureNodePoolConfigRootVolumeOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ContainerAzureNodePoolConfigRootVolume | undefined;
    set internalValue(value: ContainerAzureNodePoolConfigRootVolume | undefined);
    private _sizeGib?;
    get sizeGib(): number;
    set sizeGib(value: number);
    resetSizeGib(): void;
    get sizeGibInput(): number | undefined;
}
export interface ContainerAzureNodePoolConfigSshConfig {
    /**
    * The SSH public key data for VMs managed by Anthos. This accepts the authorized_keys file format used in OpenSSH according to the sshd(8) manual page.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_azure_node_pool#authorized_key ContainerAzureNodePool#authorized_key}
    */
    readonly authorizedKey: string;
}
export declare function containerAzureNodePoolConfigSshConfigToTerraform(struct?: ContainerAzureNodePoolConfigSshConfigOutputReference | ContainerAzureNodePoolConfigSshConfig): any;
export declare class ContainerAzureNodePoolConfigSshConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ContainerAzureNodePoolConfigSshConfig | undefined;
    set internalValue(value: ContainerAzureNodePoolConfigSshConfig | undefined);
    private _authorizedKey?;
    get authorizedKey(): string;
    set authorizedKey(value: string);
    get authorizedKeyInput(): string | undefined;
}
export interface ContainerAzureNodePoolConfigA {
    /**
    * Optional. A set of tags to apply to all underlying Azure resources for this node pool. This currently only includes Virtual Machine Scale Sets. Specify at most 50 pairs containing alphanumerics, spaces, and symbols (.+-=_:@/). Keys can be up to 127 Unicode characters. Values can be up to 255 Unicode characters.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_azure_node_pool#tags ContainerAzureNodePool#tags}
    */
    readonly tags?: {
        [key: string]: string;
    };
    /**
    * Optional. The Azure VM size name. Example: `Standard_DS2_v2`. See (/anthos/clusters/docs/azure/reference/supported-vms) for options. When unspecified, it defaults to `Standard_DS2_v2`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_azure_node_pool#vm_size ContainerAzureNodePool#vm_size}
    */
    readonly vmSize?: string;
    /**
    * root_volume block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_azure_node_pool#root_volume ContainerAzureNodePool#root_volume}
    */
    readonly rootVolume?: ContainerAzureNodePoolConfigRootVolume;
    /**
    * ssh_config block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_azure_node_pool#ssh_config ContainerAzureNodePool#ssh_config}
    */
    readonly sshConfig: ContainerAzureNodePoolConfigSshConfig;
}
export declare function containerAzureNodePoolConfigAToTerraform(struct?: ContainerAzureNodePoolConfigAOutputReference | ContainerAzureNodePoolConfigA): any;
export declare class ContainerAzureNodePoolConfigAOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ContainerAzureNodePoolConfigA | undefined;
    set internalValue(value: ContainerAzureNodePoolConfigA | undefined);
    private _tags?;
    get tags(): {
        [key: string]: string;
    };
    set tags(value: {
        [key: string]: string;
    });
    resetTags(): void;
    get tagsInput(): {
        [key: string]: string;
    } | undefined;
    private _vmSize?;
    get vmSize(): string;
    set vmSize(value: string);
    resetVmSize(): void;
    get vmSizeInput(): string | undefined;
    private _rootVolume;
    get rootVolume(): ContainerAzureNodePoolConfigRootVolumeOutputReference;
    putRootVolume(value: ContainerAzureNodePoolConfigRootVolume): void;
    resetRootVolume(): void;
    get rootVolumeInput(): ContainerAzureNodePoolConfigRootVolume | undefined;
    private _sshConfig;
    get sshConfig(): ContainerAzureNodePoolConfigSshConfigOutputReference;
    putSshConfig(value: ContainerAzureNodePoolConfigSshConfig): void;
    get sshConfigInput(): ContainerAzureNodePoolConfigSshConfig | undefined;
}
export interface ContainerAzureNodePoolMaxPodsConstraint {
    /**
    * The maximum number of pods to schedule on a single node.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_azure_node_pool#max_pods_per_node ContainerAzureNodePool#max_pods_per_node}
    */
    readonly maxPodsPerNode: number;
}
export declare function containerAzureNodePoolMaxPodsConstraintToTerraform(struct?: ContainerAzureNodePoolMaxPodsConstraintOutputReference | ContainerAzureNodePoolMaxPodsConstraint): any;
export declare class ContainerAzureNodePoolMaxPodsConstraintOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ContainerAzureNodePoolMaxPodsConstraint | undefined;
    set internalValue(value: ContainerAzureNodePoolMaxPodsConstraint | undefined);
    private _maxPodsPerNode?;
    get maxPodsPerNode(): number;
    set maxPodsPerNode(value: number);
    get maxPodsPerNodeInput(): number | undefined;
}
export interface ContainerAzureNodePoolTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_azure_node_pool#create ContainerAzureNodePool#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_azure_node_pool#delete ContainerAzureNodePool#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_azure_node_pool#update ContainerAzureNodePool#update}
    */
    readonly update?: string;
}
export declare function containerAzureNodePoolTimeoutsToTerraform(struct?: ContainerAzureNodePoolTimeoutsOutputReference | ContainerAzureNodePoolTimeouts | cdktf.IResolvable): any;
export declare class ContainerAzureNodePoolTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ContainerAzureNodePoolTimeouts | undefined;
    set internalValue(value: ContainerAzureNodePoolTimeouts | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google/r/container_azure_node_pool google_container_azure_node_pool}
*/
export declare class ContainerAzureNodePool extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_container_azure_node_pool";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google/r/container_azure_node_pool google_container_azure_node_pool} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options ContainerAzureNodePoolConfig
    */
    constructor(scope: Construct, id: string, config: ContainerAzureNodePoolConfig);
    private _annotations?;
    get annotations(): {
        [key: string]: string;
    };
    set annotations(value: {
        [key: string]: string;
    });
    resetAnnotations(): void;
    get annotationsInput(): {
        [key: string]: string;
    } | undefined;
    private _azureAvailabilityZone?;
    get azureAvailabilityZone(): string;
    set azureAvailabilityZone(value: string);
    resetAzureAvailabilityZone(): void;
    get azureAvailabilityZoneInput(): string | undefined;
    private _cluster?;
    get cluster(): string;
    set cluster(value: string);
    get clusterInput(): string | undefined;
    get createTime(): string;
    get etag(): string;
    get id(): string;
    private _location?;
    get location(): string;
    set location(value: string);
    get locationInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    get reconciling(): cdktf.IResolvable;
    get state(): string;
    private _subnetId?;
    get subnetId(): string;
    set subnetId(value: string);
    get subnetIdInput(): string | undefined;
    get uid(): string;
    get updateTime(): string;
    private _version?;
    get version(): string;
    set version(value: string);
    get versionInput(): string | undefined;
    private _autoscaling;
    get autoscaling(): ContainerAzureNodePoolAutoscalingOutputReference;
    putAutoscaling(value: ContainerAzureNodePoolAutoscaling): void;
    get autoscalingInput(): ContainerAzureNodePoolAutoscaling | undefined;
    private _config;
    get config(): ContainerAzureNodePoolConfigAOutputReference;
    putConfig(value: ContainerAzureNodePoolConfigA): void;
    get configInput(): ContainerAzureNodePoolConfigA | undefined;
    private _maxPodsConstraint;
    get maxPodsConstraint(): ContainerAzureNodePoolMaxPodsConstraintOutputReference;
    putMaxPodsConstraint(value: ContainerAzureNodePoolMaxPodsConstraint): void;
    get maxPodsConstraintInput(): ContainerAzureNodePoolMaxPodsConstraint | undefined;
    private _timeouts;
    get timeouts(): ContainerAzureNodePoolTimeoutsOutputReference;
    putTimeouts(value: ContainerAzureNodePoolTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): ContainerAzureNodePoolTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
