import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataGoogleCloudIdentityGroupsConfig extends cdktf.TerraformMetaArguments {
    /**
    * The resource name of the entity under which this Group resides in the
  Cloud Identity resource hierarchy.
  
  Must be of the form identitysources/{identity_source_id} for external-identity-mapped
  groups or customers/{customer_id} for Google Groups.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/cloud_identity_groups#parent DataGoogleCloudIdentityGroups#parent}
    */
    readonly parent: string;
}
export interface DataGoogleCloudIdentityGroupsGroupsGroupKey {
}
export declare function dataGoogleCloudIdentityGroupsGroupsGroupKeyToTerraform(struct?: DataGoogleCloudIdentityGroupsGroupsGroupKey): any;
export declare class DataGoogleCloudIdentityGroupsGroupsGroupKeyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleCloudIdentityGroupsGroupsGroupKey | undefined;
    set internalValue(value: DataGoogleCloudIdentityGroupsGroupsGroupKey | undefined);
    get id(): string;
    get namespace(): string;
}
export declare class DataGoogleCloudIdentityGroupsGroupsGroupKeyList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleCloudIdentityGroupsGroupsGroupKeyOutputReference;
}
export interface DataGoogleCloudIdentityGroupsGroups {
}
export declare function dataGoogleCloudIdentityGroupsGroupsToTerraform(struct?: DataGoogleCloudIdentityGroupsGroups): any;
export declare class DataGoogleCloudIdentityGroupsGroupsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleCloudIdentityGroupsGroups | undefined;
    set internalValue(value: DataGoogleCloudIdentityGroupsGroups | undefined);
    get createTime(): string;
    get description(): string;
    get displayName(): string;
    private _groupKey;
    get groupKey(): DataGoogleCloudIdentityGroupsGroupsGroupKeyList;
    get initialGroupConfig(): string;
    labels(key: string): string | cdktf.IResolvable;
    get name(): string;
    get parent(): string;
    get updateTime(): string;
}
export declare class DataGoogleCloudIdentityGroupsGroupsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleCloudIdentityGroupsGroupsOutputReference;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google/d/cloud_identity_groups google_cloud_identity_groups}
*/
export declare class DataGoogleCloudIdentityGroups extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "google_cloud_identity_groups";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google/d/cloud_identity_groups google_cloud_identity_groups} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataGoogleCloudIdentityGroupsConfig
    */
    constructor(scope: Construct, id: string, config: DataGoogleCloudIdentityGroupsConfig);
    private _groups;
    get groups(): DataGoogleCloudIdentityGroupsGroupsList;
    get id(): string;
    private _parent?;
    get parent(): string;
    set parent(value: string);
    get parentInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
