import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataGoogleComposerEnvironmentConfig extends cdktf.TerraformMetaArguments {
    /**
    * Name of the environment.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/composer_environment#name DataGoogleComposerEnvironment#name}
    */
    readonly name: string;
    /**
    * The ID of the project in which the resource belongs. If it is not provided, the provider project is used.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/composer_environment#project DataGoogleComposerEnvironment#project}
    */
    readonly project?: string;
    /**
    * The location or Compute Engine region for the environment.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/composer_environment#region DataGoogleComposerEnvironment#region}
    */
    readonly region?: string;
}
export interface DataGoogleComposerEnvironmentConfigDatabaseConfig {
}
export declare function dataGoogleComposerEnvironmentConfigDatabaseConfigToTerraform(struct?: DataGoogleComposerEnvironmentConfigDatabaseConfig): any;
export declare class DataGoogleComposerEnvironmentConfigDatabaseConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleComposerEnvironmentConfigDatabaseConfig | undefined;
    set internalValue(value: DataGoogleComposerEnvironmentConfigDatabaseConfig | undefined);
    get machineType(): string;
}
export declare class DataGoogleComposerEnvironmentConfigDatabaseConfigList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleComposerEnvironmentConfigDatabaseConfigOutputReference;
}
export interface DataGoogleComposerEnvironmentConfigEncryptionConfig {
}
export declare function dataGoogleComposerEnvironmentConfigEncryptionConfigToTerraform(struct?: DataGoogleComposerEnvironmentConfigEncryptionConfig): any;
export declare class DataGoogleComposerEnvironmentConfigEncryptionConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleComposerEnvironmentConfigEncryptionConfig | undefined;
    set internalValue(value: DataGoogleComposerEnvironmentConfigEncryptionConfig | undefined);
    get kmsKeyName(): string;
}
export declare class DataGoogleComposerEnvironmentConfigEncryptionConfigList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleComposerEnvironmentConfigEncryptionConfigOutputReference;
}
export interface DataGoogleComposerEnvironmentConfigMaintenanceWindow {
}
export declare function dataGoogleComposerEnvironmentConfigMaintenanceWindowToTerraform(struct?: DataGoogleComposerEnvironmentConfigMaintenanceWindow): any;
export declare class DataGoogleComposerEnvironmentConfigMaintenanceWindowOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleComposerEnvironmentConfigMaintenanceWindow | undefined;
    set internalValue(value: DataGoogleComposerEnvironmentConfigMaintenanceWindow | undefined);
    get endTime(): string;
    get recurrence(): string;
    get startTime(): string;
}
export declare class DataGoogleComposerEnvironmentConfigMaintenanceWindowList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleComposerEnvironmentConfigMaintenanceWindowOutputReference;
}
export interface DataGoogleComposerEnvironmentConfigNodeConfigIpAllocationPolicy {
}
export declare function dataGoogleComposerEnvironmentConfigNodeConfigIpAllocationPolicyToTerraform(struct?: DataGoogleComposerEnvironmentConfigNodeConfigIpAllocationPolicy): any;
export declare class DataGoogleComposerEnvironmentConfigNodeConfigIpAllocationPolicyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleComposerEnvironmentConfigNodeConfigIpAllocationPolicy | undefined;
    set internalValue(value: DataGoogleComposerEnvironmentConfigNodeConfigIpAllocationPolicy | undefined);
    get clusterIpv4CidrBlock(): string;
    get clusterSecondaryRangeName(): string;
    get servicesIpv4CidrBlock(): string;
    get servicesSecondaryRangeName(): string;
    get useIpAliases(): cdktf.IResolvable;
}
export declare class DataGoogleComposerEnvironmentConfigNodeConfigIpAllocationPolicyList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleComposerEnvironmentConfigNodeConfigIpAllocationPolicyOutputReference;
}
export interface DataGoogleComposerEnvironmentConfigNodeConfig {
}
export declare function dataGoogleComposerEnvironmentConfigNodeConfigToTerraform(struct?: DataGoogleComposerEnvironmentConfigNodeConfig): any;
export declare class DataGoogleComposerEnvironmentConfigNodeConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleComposerEnvironmentConfigNodeConfig | undefined;
    set internalValue(value: DataGoogleComposerEnvironmentConfigNodeConfig | undefined);
    get diskSizeGb(): number;
    private _ipAllocationPolicy;
    get ipAllocationPolicy(): DataGoogleComposerEnvironmentConfigNodeConfigIpAllocationPolicyList;
    get machineType(): string;
    get network(): string;
    get oauthScopes(): string[];
    get serviceAccount(): string;
    get subnetwork(): string;
    get tags(): string[];
    get zone(): string;
}
export declare class DataGoogleComposerEnvironmentConfigNodeConfigList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleComposerEnvironmentConfigNodeConfigOutputReference;
}
export interface DataGoogleComposerEnvironmentConfigPrivateEnvironmentConfig {
}
export declare function dataGoogleComposerEnvironmentConfigPrivateEnvironmentConfigToTerraform(struct?: DataGoogleComposerEnvironmentConfigPrivateEnvironmentConfig): any;
export declare class DataGoogleComposerEnvironmentConfigPrivateEnvironmentConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleComposerEnvironmentConfigPrivateEnvironmentConfig | undefined;
    set internalValue(value: DataGoogleComposerEnvironmentConfigPrivateEnvironmentConfig | undefined);
    get cloudComposerConnectionSubnetwork(): string;
    get cloudComposerNetworkIpv4CidrBlock(): string;
    get cloudSqlIpv4CidrBlock(): string;
    get enablePrivateEndpoint(): cdktf.IResolvable;
    get masterIpv4CidrBlock(): string;
    get webServerIpv4CidrBlock(): string;
}
export declare class DataGoogleComposerEnvironmentConfigPrivateEnvironmentConfigList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleComposerEnvironmentConfigPrivateEnvironmentConfigOutputReference;
}
export interface DataGoogleComposerEnvironmentConfigSoftwareConfig {
}
export declare function dataGoogleComposerEnvironmentConfigSoftwareConfigToTerraform(struct?: DataGoogleComposerEnvironmentConfigSoftwareConfig): any;
export declare class DataGoogleComposerEnvironmentConfigSoftwareConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleComposerEnvironmentConfigSoftwareConfig | undefined;
    set internalValue(value: DataGoogleComposerEnvironmentConfigSoftwareConfig | undefined);
    airflowConfigOverrides(key: string): string | cdktf.IResolvable;
    envVariables(key: string): string | cdktf.IResolvable;
    get imageVersion(): string;
    pypiPackages(key: string): string | cdktf.IResolvable;
    get pythonVersion(): string;
    get schedulerCount(): number;
}
export declare class DataGoogleComposerEnvironmentConfigSoftwareConfigList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleComposerEnvironmentConfigSoftwareConfigOutputReference;
}
export interface DataGoogleComposerEnvironmentConfigWebServerConfig {
}
export declare function dataGoogleComposerEnvironmentConfigWebServerConfigToTerraform(struct?: DataGoogleComposerEnvironmentConfigWebServerConfig): any;
export declare class DataGoogleComposerEnvironmentConfigWebServerConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleComposerEnvironmentConfigWebServerConfig | undefined;
    set internalValue(value: DataGoogleComposerEnvironmentConfigWebServerConfig | undefined);
    get machineType(): string;
}
export declare class DataGoogleComposerEnvironmentConfigWebServerConfigList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleComposerEnvironmentConfigWebServerConfigOutputReference;
}
export interface DataGoogleComposerEnvironmentConfigWebServerNetworkAccessControlAllowedIpRange {
}
export declare function dataGoogleComposerEnvironmentConfigWebServerNetworkAccessControlAllowedIpRangeToTerraform(struct?: DataGoogleComposerEnvironmentConfigWebServerNetworkAccessControlAllowedIpRange): any;
export declare class DataGoogleComposerEnvironmentConfigWebServerNetworkAccessControlAllowedIpRangeOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleComposerEnvironmentConfigWebServerNetworkAccessControlAllowedIpRange | undefined;
    set internalValue(value: DataGoogleComposerEnvironmentConfigWebServerNetworkAccessControlAllowedIpRange | undefined);
    get description(): string;
    get value(): string;
}
export declare class DataGoogleComposerEnvironmentConfigWebServerNetworkAccessControlAllowedIpRangeList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleComposerEnvironmentConfigWebServerNetworkAccessControlAllowedIpRangeOutputReference;
}
export interface DataGoogleComposerEnvironmentConfigWebServerNetworkAccessControl {
}
export declare function dataGoogleComposerEnvironmentConfigWebServerNetworkAccessControlToTerraform(struct?: DataGoogleComposerEnvironmentConfigWebServerNetworkAccessControl): any;
export declare class DataGoogleComposerEnvironmentConfigWebServerNetworkAccessControlOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleComposerEnvironmentConfigWebServerNetworkAccessControl | undefined;
    set internalValue(value: DataGoogleComposerEnvironmentConfigWebServerNetworkAccessControl | undefined);
    private _allowedIpRange;
    get allowedIpRange(): DataGoogleComposerEnvironmentConfigWebServerNetworkAccessControlAllowedIpRangeList;
}
export declare class DataGoogleComposerEnvironmentConfigWebServerNetworkAccessControlList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleComposerEnvironmentConfigWebServerNetworkAccessControlOutputReference;
}
export interface DataGoogleComposerEnvironmentConfigWorkloadsConfigScheduler {
}
export declare function dataGoogleComposerEnvironmentConfigWorkloadsConfigSchedulerToTerraform(struct?: DataGoogleComposerEnvironmentConfigWorkloadsConfigScheduler): any;
export declare class DataGoogleComposerEnvironmentConfigWorkloadsConfigSchedulerOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleComposerEnvironmentConfigWorkloadsConfigScheduler | undefined;
    set internalValue(value: DataGoogleComposerEnvironmentConfigWorkloadsConfigScheduler | undefined);
    get count(): number;
    get cpu(): number;
    get memoryGb(): number;
    get storageGb(): number;
}
export declare class DataGoogleComposerEnvironmentConfigWorkloadsConfigSchedulerList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleComposerEnvironmentConfigWorkloadsConfigSchedulerOutputReference;
}
export interface DataGoogleComposerEnvironmentConfigWorkloadsConfigWebServer {
}
export declare function dataGoogleComposerEnvironmentConfigWorkloadsConfigWebServerToTerraform(struct?: DataGoogleComposerEnvironmentConfigWorkloadsConfigWebServer): any;
export declare class DataGoogleComposerEnvironmentConfigWorkloadsConfigWebServerOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleComposerEnvironmentConfigWorkloadsConfigWebServer | undefined;
    set internalValue(value: DataGoogleComposerEnvironmentConfigWorkloadsConfigWebServer | undefined);
    get cpu(): number;
    get memoryGb(): number;
    get storageGb(): number;
}
export declare class DataGoogleComposerEnvironmentConfigWorkloadsConfigWebServerList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleComposerEnvironmentConfigWorkloadsConfigWebServerOutputReference;
}
export interface DataGoogleComposerEnvironmentConfigWorkloadsConfigWorker {
}
export declare function dataGoogleComposerEnvironmentConfigWorkloadsConfigWorkerToTerraform(struct?: DataGoogleComposerEnvironmentConfigWorkloadsConfigWorker): any;
export declare class DataGoogleComposerEnvironmentConfigWorkloadsConfigWorkerOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleComposerEnvironmentConfigWorkloadsConfigWorker | undefined;
    set internalValue(value: DataGoogleComposerEnvironmentConfigWorkloadsConfigWorker | undefined);
    get cpu(): number;
    get maxCount(): number;
    get memoryGb(): number;
    get minCount(): number;
    get storageGb(): number;
}
export declare class DataGoogleComposerEnvironmentConfigWorkloadsConfigWorkerList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleComposerEnvironmentConfigWorkloadsConfigWorkerOutputReference;
}
export interface DataGoogleComposerEnvironmentConfigWorkloadsConfig {
}
export declare function dataGoogleComposerEnvironmentConfigWorkloadsConfigToTerraform(struct?: DataGoogleComposerEnvironmentConfigWorkloadsConfig): any;
export declare class DataGoogleComposerEnvironmentConfigWorkloadsConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleComposerEnvironmentConfigWorkloadsConfig | undefined;
    set internalValue(value: DataGoogleComposerEnvironmentConfigWorkloadsConfig | undefined);
    private _scheduler;
    get scheduler(): DataGoogleComposerEnvironmentConfigWorkloadsConfigSchedulerList;
    private _webServer;
    get webServer(): DataGoogleComposerEnvironmentConfigWorkloadsConfigWebServerList;
    private _worker;
    get worker(): DataGoogleComposerEnvironmentConfigWorkloadsConfigWorkerList;
}
export declare class DataGoogleComposerEnvironmentConfigWorkloadsConfigList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleComposerEnvironmentConfigWorkloadsConfigOutputReference;
}
export interface DataGoogleComposerEnvironmentConfigA {
}
export declare function dataGoogleComposerEnvironmentConfigAToTerraform(struct?: DataGoogleComposerEnvironmentConfigA): any;
export declare class DataGoogleComposerEnvironmentConfigAOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleComposerEnvironmentConfigA | undefined;
    set internalValue(value: DataGoogleComposerEnvironmentConfigA | undefined);
    get airflowUri(): string;
    get dagGcsPrefix(): string;
    private _databaseConfig;
    get databaseConfig(): DataGoogleComposerEnvironmentConfigDatabaseConfigList;
    private _encryptionConfig;
    get encryptionConfig(): DataGoogleComposerEnvironmentConfigEncryptionConfigList;
    get environmentSize(): string;
    get gkeCluster(): string;
    private _maintenanceWindow;
    get maintenanceWindow(): DataGoogleComposerEnvironmentConfigMaintenanceWindowList;
    private _nodeConfig;
    get nodeConfig(): DataGoogleComposerEnvironmentConfigNodeConfigList;
    get nodeCount(): number;
    private _privateEnvironmentConfig;
    get privateEnvironmentConfig(): DataGoogleComposerEnvironmentConfigPrivateEnvironmentConfigList;
    private _softwareConfig;
    get softwareConfig(): DataGoogleComposerEnvironmentConfigSoftwareConfigList;
    private _webServerConfig;
    get webServerConfig(): DataGoogleComposerEnvironmentConfigWebServerConfigList;
    private _webServerNetworkAccessControl;
    get webServerNetworkAccessControl(): DataGoogleComposerEnvironmentConfigWebServerNetworkAccessControlList;
    private _workloadsConfig;
    get workloadsConfig(): DataGoogleComposerEnvironmentConfigWorkloadsConfigList;
}
export declare class DataGoogleComposerEnvironmentConfigAList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleComposerEnvironmentConfigAOutputReference;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google/d/composer_environment google_composer_environment}
*/
export declare class DataGoogleComposerEnvironment extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "google_composer_environment";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google/d/composer_environment google_composer_environment} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataGoogleComposerEnvironmentConfig
    */
    constructor(scope: Construct, id: string, config: DataGoogleComposerEnvironmentConfig);
    private _config;
    get config(): DataGoogleComposerEnvironmentConfigAList;
    get id(): string;
    labels(key: string): string | cdktf.IResolvable;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _region?;
    get region(): string;
    set region(value: string);
    resetRegion(): void;
    get regionInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
