import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataGoogleComputeDiskConfig extends cdktf.TerraformMetaArguments {
    /**
    * Name of the resource. Provided by the client when the resource is
  created. The name must be 1-63 characters long, and comply with
  RFC1035. Specifically, the name must be 1-63 characters long and match
  the regular expression '[a-z]([-a-z0-9]*[a-z0-9])?' which means the
  first character must be a lowercase letter, and all following
  characters must be a dash, lowercase letter, or digit, except the last
  character, which cannot be a dash.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/compute_disk#name DataGoogleComputeDisk#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/compute_disk#project DataGoogleComputeDisk#project}
    */
    readonly project?: string;
    /**
    * A reference to the zone where the disk resides.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/compute_disk#zone DataGoogleComputeDisk#zone}
    */
    readonly zone?: string;
}
export interface DataGoogleComputeDiskDiskEncryptionKey {
}
export declare function dataGoogleComputeDiskDiskEncryptionKeyToTerraform(struct?: DataGoogleComputeDiskDiskEncryptionKey): any;
export declare class DataGoogleComputeDiskDiskEncryptionKeyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleComputeDiskDiskEncryptionKey | undefined;
    set internalValue(value: DataGoogleComputeDiskDiskEncryptionKey | undefined);
    get kmsKeySelfLink(): string;
    get kmsKeyServiceAccount(): string;
    get rawKey(): string;
    get sha256(): string;
}
export declare class DataGoogleComputeDiskDiskEncryptionKeyList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleComputeDiskDiskEncryptionKeyOutputReference;
}
export interface DataGoogleComputeDiskSourceImageEncryptionKey {
}
export declare function dataGoogleComputeDiskSourceImageEncryptionKeyToTerraform(struct?: DataGoogleComputeDiskSourceImageEncryptionKey): any;
export declare class DataGoogleComputeDiskSourceImageEncryptionKeyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleComputeDiskSourceImageEncryptionKey | undefined;
    set internalValue(value: DataGoogleComputeDiskSourceImageEncryptionKey | undefined);
    get kmsKeySelfLink(): string;
    get kmsKeyServiceAccount(): string;
    get rawKey(): string;
    get sha256(): string;
}
export declare class DataGoogleComputeDiskSourceImageEncryptionKeyList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleComputeDiskSourceImageEncryptionKeyOutputReference;
}
export interface DataGoogleComputeDiskSourceSnapshotEncryptionKey {
}
export declare function dataGoogleComputeDiskSourceSnapshotEncryptionKeyToTerraform(struct?: DataGoogleComputeDiskSourceSnapshotEncryptionKey): any;
export declare class DataGoogleComputeDiskSourceSnapshotEncryptionKeyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleComputeDiskSourceSnapshotEncryptionKey | undefined;
    set internalValue(value: DataGoogleComputeDiskSourceSnapshotEncryptionKey | undefined);
    get kmsKeySelfLink(): string;
    get kmsKeyServiceAccount(): string;
    get rawKey(): string;
    get sha256(): string;
}
export declare class DataGoogleComputeDiskSourceSnapshotEncryptionKeyList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleComputeDiskSourceSnapshotEncryptionKeyOutputReference;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google/d/compute_disk google_compute_disk}
*/
export declare class DataGoogleComputeDisk extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "google_compute_disk";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google/d/compute_disk google_compute_disk} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataGoogleComputeDiskConfig
    */
    constructor(scope: Construct, id: string, config: DataGoogleComputeDiskConfig);
    get creationTimestamp(): string;
    get description(): string;
    private _diskEncryptionKey;
    get diskEncryptionKey(): DataGoogleComputeDiskDiskEncryptionKeyList;
    get id(): string;
    get image(): string;
    get labelFingerprint(): string;
    labels(key: string): string | cdktf.IResolvable;
    get lastAttachTimestamp(): string;
    get lastDetachTimestamp(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    get physicalBlockSizeBytes(): number;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    get provisionedIops(): number;
    get selfLink(): string;
    get size(): number;
    get snapshot(): string;
    private _sourceImageEncryptionKey;
    get sourceImageEncryptionKey(): DataGoogleComputeDiskSourceImageEncryptionKeyList;
    get sourceImageId(): string;
    private _sourceSnapshotEncryptionKey;
    get sourceSnapshotEncryptionKey(): DataGoogleComputeDiskSourceSnapshotEncryptionKeyList;
    get sourceSnapshotId(): string;
    get type(): string;
    get users(): string[];
    private _zone?;
    get zone(): string;
    set zone(value: string);
    resetZone(): void;
    get zoneInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
