import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataGoogleComputeRegionsConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/compute_regions#project DataGoogleComputeRegions#project}
    */
    readonly project?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/compute_regions#status DataGoogleComputeRegions#status}
    */
    readonly status?: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google/d/compute_regions google_compute_regions}
*/
export declare class DataGoogleComputeRegions extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "google_compute_regions";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google/d/compute_regions google_compute_regions} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataGoogleComputeRegionsConfig = {}
    */
    constructor(scope: Construct, id: string, config?: DataGoogleComputeRegionsConfig);
    get id(): string;
    get names(): string[];
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _status?;
    get status(): string;
    set status(value: string);
    resetStatus(): void;
    get statusInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
