import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataLossPreventionJobTriggerConfig extends cdktf.TerraformMetaArguments {
    /**
    * A description of the job trigger.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_job_trigger#description DataLossPreventionJobTrigger#description}
    */
    readonly description?: string;
    /**
    * User set display name of the job trigger.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_job_trigger#display_name DataLossPreventionJobTrigger#display_name}
    */
    readonly displayName?: string;
    /**
    * The parent of the trigger, either in the format 'projects/{{project}}'
  or 'projects/{{project}}/locations/{{location}}'
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_job_trigger#parent DataLossPreventionJobTrigger#parent}
    */
    readonly parent: string;
    /**
    * Whether the trigger is currently active. Default value: "HEALTHY" Possible values: ["PAUSED", "HEALTHY", "CANCELLED"]
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_job_trigger#status DataLossPreventionJobTrigger#status}
    */
    readonly status?: string;
    /**
    * inspect_job block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_job_trigger#inspect_job DataLossPreventionJobTrigger#inspect_job}
    */
    readonly inspectJob?: DataLossPreventionJobTriggerInspectJob;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_job_trigger#timeouts DataLossPreventionJobTrigger#timeouts}
    */
    readonly timeouts?: DataLossPreventionJobTriggerTimeouts;
    /**
    * triggers block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_job_trigger#triggers DataLossPreventionJobTrigger#triggers}
    */
    readonly triggers: DataLossPreventionJobTriggerTriggers[] | cdktf.IResolvable;
}
export interface DataLossPreventionJobTriggerInspectJobActionsSaveFindingsOutputConfigTable {
    /**
    * Dataset ID of the table.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_job_trigger#dataset_id DataLossPreventionJobTrigger#dataset_id}
    */
    readonly datasetId: string;
    /**
    * The Google Cloud Platform project ID of the project containing the table.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_job_trigger#project_id DataLossPreventionJobTrigger#project_id}
    */
    readonly projectId: string;
    /**
    * Name of the table. If is not set a new one will be generated for you with the following format:
  'dlp_googleapis_yyyy_mm_dd_[dlp_job_id]'. Pacific timezone will be used for generating the date details.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_job_trigger#table_id DataLossPreventionJobTrigger#table_id}
    */
    readonly tableId?: string;
}
export declare function dataLossPreventionJobTriggerInspectJobActionsSaveFindingsOutputConfigTableToTerraform(struct?: DataLossPreventionJobTriggerInspectJobActionsSaveFindingsOutputConfigTableOutputReference | DataLossPreventionJobTriggerInspectJobActionsSaveFindingsOutputConfigTable): any;
export declare class DataLossPreventionJobTriggerInspectJobActionsSaveFindingsOutputConfigTableOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataLossPreventionJobTriggerInspectJobActionsSaveFindingsOutputConfigTable | undefined;
    set internalValue(value: DataLossPreventionJobTriggerInspectJobActionsSaveFindingsOutputConfigTable | undefined);
    private _datasetId?;
    get datasetId(): string;
    set datasetId(value: string);
    get datasetIdInput(): string | undefined;
    private _projectId?;
    get projectId(): string;
    set projectId(value: string);
    get projectIdInput(): string | undefined;
    private _tableId?;
    get tableId(): string;
    set tableId(value: string);
    resetTableId(): void;
    get tableIdInput(): string | undefined;
}
export interface DataLossPreventionJobTriggerInspectJobActionsSaveFindingsOutputConfig {
    /**
    * Schema used for writing the findings for Inspect jobs. This field is only used for
  Inspect and must be unspecified for Risk jobs. Columns are derived from the Finding
  object. If appending to an existing table, any columns from the predefined schema
  that are missing will be added. No columns in the existing table will be deleted.
  
  If unspecified, then all available columns will be used for a new table or an (existing)
  table with no schema, and no changes will be made to an existing table that has a schema.
  Only for use with external storage. Possible values: ["BASIC_COLUMNS", "GCS_COLUMNS", "DATASTORE_COLUMNS", "BIG_QUERY_COLUMNS", "ALL_COLUMNS"]
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_job_trigger#output_schema DataLossPreventionJobTrigger#output_schema}
    */
    readonly outputSchema?: string;
    /**
    * table block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_job_trigger#table DataLossPreventionJobTrigger#table}
    */
    readonly table: DataLossPreventionJobTriggerInspectJobActionsSaveFindingsOutputConfigTable;
}
export declare function dataLossPreventionJobTriggerInspectJobActionsSaveFindingsOutputConfigToTerraform(struct?: DataLossPreventionJobTriggerInspectJobActionsSaveFindingsOutputConfigOutputReference | DataLossPreventionJobTriggerInspectJobActionsSaveFindingsOutputConfig): any;
export declare class DataLossPreventionJobTriggerInspectJobActionsSaveFindingsOutputConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataLossPreventionJobTriggerInspectJobActionsSaveFindingsOutputConfig | undefined;
    set internalValue(value: DataLossPreventionJobTriggerInspectJobActionsSaveFindingsOutputConfig | undefined);
    private _outputSchema?;
    get outputSchema(): string;
    set outputSchema(value: string);
    resetOutputSchema(): void;
    get outputSchemaInput(): string | undefined;
    private _table;
    get table(): DataLossPreventionJobTriggerInspectJobActionsSaveFindingsOutputConfigTableOutputReference;
    putTable(value: DataLossPreventionJobTriggerInspectJobActionsSaveFindingsOutputConfigTable): void;
    get tableInput(): DataLossPreventionJobTriggerInspectJobActionsSaveFindingsOutputConfigTable | undefined;
}
export interface DataLossPreventionJobTriggerInspectJobActionsSaveFindings {
    /**
    * output_config block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_job_trigger#output_config DataLossPreventionJobTrigger#output_config}
    */
    readonly outputConfig: DataLossPreventionJobTriggerInspectJobActionsSaveFindingsOutputConfig;
}
export declare function dataLossPreventionJobTriggerInspectJobActionsSaveFindingsToTerraform(struct?: DataLossPreventionJobTriggerInspectJobActionsSaveFindingsOutputReference | DataLossPreventionJobTriggerInspectJobActionsSaveFindings): any;
export declare class DataLossPreventionJobTriggerInspectJobActionsSaveFindingsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataLossPreventionJobTriggerInspectJobActionsSaveFindings | undefined;
    set internalValue(value: DataLossPreventionJobTriggerInspectJobActionsSaveFindings | undefined);
    private _outputConfig;
    get outputConfig(): DataLossPreventionJobTriggerInspectJobActionsSaveFindingsOutputConfigOutputReference;
    putOutputConfig(value: DataLossPreventionJobTriggerInspectJobActionsSaveFindingsOutputConfig): void;
    get outputConfigInput(): DataLossPreventionJobTriggerInspectJobActionsSaveFindingsOutputConfig | undefined;
}
export interface DataLossPreventionJobTriggerInspectJobActions {
    /**
    * save_findings block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_job_trigger#save_findings DataLossPreventionJobTrigger#save_findings}
    */
    readonly saveFindings: DataLossPreventionJobTriggerInspectJobActionsSaveFindings;
}
export declare function dataLossPreventionJobTriggerInspectJobActionsToTerraform(struct?: DataLossPreventionJobTriggerInspectJobActions | cdktf.IResolvable): any;
export interface DataLossPreventionJobTriggerInspectJobStorageConfigBigQueryOptionsTableReference {
    /**
    * The dataset ID of the table.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_job_trigger#dataset_id DataLossPreventionJobTrigger#dataset_id}
    */
    readonly datasetId: string;
    /**
    * The Google Cloud Platform project ID of the project containing the table.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_job_trigger#project_id DataLossPreventionJobTrigger#project_id}
    */
    readonly projectId: string;
    /**
    * The name of the table.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_job_trigger#table_id DataLossPreventionJobTrigger#table_id}
    */
    readonly tableId: string;
}
export declare function dataLossPreventionJobTriggerInspectJobStorageConfigBigQueryOptionsTableReferenceToTerraform(struct?: DataLossPreventionJobTriggerInspectJobStorageConfigBigQueryOptionsTableReferenceOutputReference | DataLossPreventionJobTriggerInspectJobStorageConfigBigQueryOptionsTableReference): any;
export declare class DataLossPreventionJobTriggerInspectJobStorageConfigBigQueryOptionsTableReferenceOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataLossPreventionJobTriggerInspectJobStorageConfigBigQueryOptionsTableReference | undefined;
    set internalValue(value: DataLossPreventionJobTriggerInspectJobStorageConfigBigQueryOptionsTableReference | undefined);
    private _datasetId?;
    get datasetId(): string;
    set datasetId(value: string);
    get datasetIdInput(): string | undefined;
    private _projectId?;
    get projectId(): string;
    set projectId(value: string);
    get projectIdInput(): string | undefined;
    private _tableId?;
    get tableId(): string;
    set tableId(value: string);
    get tableIdInput(): string | undefined;
}
export interface DataLossPreventionJobTriggerInspectJobStorageConfigBigQueryOptions {
    /**
    * table_reference block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_job_trigger#table_reference DataLossPreventionJobTrigger#table_reference}
    */
    readonly tableReference: DataLossPreventionJobTriggerInspectJobStorageConfigBigQueryOptionsTableReference;
}
export declare function dataLossPreventionJobTriggerInspectJobStorageConfigBigQueryOptionsToTerraform(struct?: DataLossPreventionJobTriggerInspectJobStorageConfigBigQueryOptionsOutputReference | DataLossPreventionJobTriggerInspectJobStorageConfigBigQueryOptions): any;
export declare class DataLossPreventionJobTriggerInspectJobStorageConfigBigQueryOptionsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataLossPreventionJobTriggerInspectJobStorageConfigBigQueryOptions | undefined;
    set internalValue(value: DataLossPreventionJobTriggerInspectJobStorageConfigBigQueryOptions | undefined);
    private _tableReference;
    get tableReference(): DataLossPreventionJobTriggerInspectJobStorageConfigBigQueryOptionsTableReferenceOutputReference;
    putTableReference(value: DataLossPreventionJobTriggerInspectJobStorageConfigBigQueryOptionsTableReference): void;
    get tableReferenceInput(): DataLossPreventionJobTriggerInspectJobStorageConfigBigQueryOptionsTableReference | undefined;
}
export interface DataLossPreventionJobTriggerInspectJobStorageConfigCloudStorageOptionsFileSetRegexFileSet {
    /**
    * The name of a Cloud Storage bucket.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_job_trigger#bucket_name DataLossPreventionJobTrigger#bucket_name}
    */
    readonly bucketName: string;
    /**
    * A list of regular expressions matching file paths to exclude. All files in the bucket that match at
  least one of these regular expressions will be excluded from the scan.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_job_trigger#exclude_regex DataLossPreventionJobTrigger#exclude_regex}
    */
    readonly excludeRegex?: string[];
    /**
    * A list of regular expressions matching file paths to include. All files in the bucket
  that match at least one of these regular expressions will be included in the set of files,
  except for those that also match an item in excludeRegex. Leaving this field empty will
  match all files by default (this is equivalent to including .* in the list)
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_job_trigger#include_regex DataLossPreventionJobTrigger#include_regex}
    */
    readonly includeRegex?: string[];
}
export declare function dataLossPreventionJobTriggerInspectJobStorageConfigCloudStorageOptionsFileSetRegexFileSetToTerraform(struct?: DataLossPreventionJobTriggerInspectJobStorageConfigCloudStorageOptionsFileSetRegexFileSetOutputReference | DataLossPreventionJobTriggerInspectJobStorageConfigCloudStorageOptionsFileSetRegexFileSet): any;
export declare class DataLossPreventionJobTriggerInspectJobStorageConfigCloudStorageOptionsFileSetRegexFileSetOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataLossPreventionJobTriggerInspectJobStorageConfigCloudStorageOptionsFileSetRegexFileSet | undefined;
    set internalValue(value: DataLossPreventionJobTriggerInspectJobStorageConfigCloudStorageOptionsFileSetRegexFileSet | undefined);
    private _bucketName?;
    get bucketName(): string;
    set bucketName(value: string);
    get bucketNameInput(): string | undefined;
    private _excludeRegex?;
    get excludeRegex(): string[];
    set excludeRegex(value: string[]);
    resetExcludeRegex(): void;
    get excludeRegexInput(): string[] | undefined;
    private _includeRegex?;
    get includeRegex(): string[];
    set includeRegex(value: string[]);
    resetIncludeRegex(): void;
    get includeRegexInput(): string[] | undefined;
}
export interface DataLossPreventionJobTriggerInspectJobStorageConfigCloudStorageOptionsFileSet {
    /**
    * The Cloud Storage url of the file(s) to scan, in the format 'gs://<bucket>/<path>'. Trailing wildcard
  in the path is allowed.
  
  If the url ends in a trailing slash, the bucket or directory represented by the url will be scanned
  non-recursively (content in sub-directories will not be scanned). This means that 'gs://mybucket/' is
  equivalent to 'gs://mybucket/*', and 'gs://mybucket/directory/' is equivalent to 'gs://mybucket/directory/*'.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_job_trigger#url DataLossPreventionJobTrigger#url}
    */
    readonly url?: string;
    /**
    * regex_file_set block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_job_trigger#regex_file_set DataLossPreventionJobTrigger#regex_file_set}
    */
    readonly regexFileSet?: DataLossPreventionJobTriggerInspectJobStorageConfigCloudStorageOptionsFileSetRegexFileSet;
}
export declare function dataLossPreventionJobTriggerInspectJobStorageConfigCloudStorageOptionsFileSetToTerraform(struct?: DataLossPreventionJobTriggerInspectJobStorageConfigCloudStorageOptionsFileSetOutputReference | DataLossPreventionJobTriggerInspectJobStorageConfigCloudStorageOptionsFileSet): any;
export declare class DataLossPreventionJobTriggerInspectJobStorageConfigCloudStorageOptionsFileSetOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataLossPreventionJobTriggerInspectJobStorageConfigCloudStorageOptionsFileSet | undefined;
    set internalValue(value: DataLossPreventionJobTriggerInspectJobStorageConfigCloudStorageOptionsFileSet | undefined);
    private _url?;
    get url(): string;
    set url(value: string);
    resetUrl(): void;
    get urlInput(): string | undefined;
    private _regexFileSet;
    get regexFileSet(): DataLossPreventionJobTriggerInspectJobStorageConfigCloudStorageOptionsFileSetRegexFileSetOutputReference;
    putRegexFileSet(value: DataLossPreventionJobTriggerInspectJobStorageConfigCloudStorageOptionsFileSetRegexFileSet): void;
    resetRegexFileSet(): void;
    get regexFileSetInput(): DataLossPreventionJobTriggerInspectJobStorageConfigCloudStorageOptionsFileSetRegexFileSet | undefined;
}
export interface DataLossPreventionJobTriggerInspectJobStorageConfigCloudStorageOptions {
    /**
    * Max number of bytes to scan from a file. If a scanned file's size is bigger than this value
  then the rest of the bytes are omitted.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_job_trigger#bytes_limit_per_file DataLossPreventionJobTrigger#bytes_limit_per_file}
    */
    readonly bytesLimitPerFile?: number;
    /**
    * Max percentage of bytes to scan from a file. The rest are omitted. The number of bytes scanned is rounded down.
  Must be between 0 and 100, inclusively. Both 0 and 100 means no limit.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_job_trigger#bytes_limit_per_file_percent DataLossPreventionJobTrigger#bytes_limit_per_file_percent}
    */
    readonly bytesLimitPerFilePercent?: number;
    /**
    * List of file type groups to include in the scan. If empty, all files are scanned and available data
  format processors are applied. In addition, the binary content of the selected files is always scanned as well.
  Images are scanned only as binary if the specified region does not support image inspection and no fileTypes were specified. Possible values: ["BINARY_FILE", "TEXT_FILE", "IMAGE", "WORD", "PDF", "AVRO", "CSV", "TSV"]
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_job_trigger#file_types DataLossPreventionJobTrigger#file_types}
    */
    readonly fileTypes?: string[];
    /**
    * Limits the number of files to scan to this percentage of the input FileSet. Number of files scanned is rounded down.
  Must be between 0 and 100, inclusively. Both 0 and 100 means no limit.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_job_trigger#files_limit_percent DataLossPreventionJobTrigger#files_limit_percent}
    */
    readonly filesLimitPercent?: number;
    /**
    * How to sample bytes if not all bytes are scanned. Meaningful only when used in conjunction with bytesLimitPerFile.
  If not specified, scanning would start from the top. Possible values: ["TOP", "RANDOM_START"]
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_job_trigger#sample_method DataLossPreventionJobTrigger#sample_method}
    */
    readonly sampleMethod?: string;
    /**
    * file_set block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_job_trigger#file_set DataLossPreventionJobTrigger#file_set}
    */
    readonly fileSet: DataLossPreventionJobTriggerInspectJobStorageConfigCloudStorageOptionsFileSet;
}
export declare function dataLossPreventionJobTriggerInspectJobStorageConfigCloudStorageOptionsToTerraform(struct?: DataLossPreventionJobTriggerInspectJobStorageConfigCloudStorageOptionsOutputReference | DataLossPreventionJobTriggerInspectJobStorageConfigCloudStorageOptions): any;
export declare class DataLossPreventionJobTriggerInspectJobStorageConfigCloudStorageOptionsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataLossPreventionJobTriggerInspectJobStorageConfigCloudStorageOptions | undefined;
    set internalValue(value: DataLossPreventionJobTriggerInspectJobStorageConfigCloudStorageOptions | undefined);
    private _bytesLimitPerFile?;
    get bytesLimitPerFile(): number;
    set bytesLimitPerFile(value: number);
    resetBytesLimitPerFile(): void;
    get bytesLimitPerFileInput(): number | undefined;
    private _bytesLimitPerFilePercent?;
    get bytesLimitPerFilePercent(): number;
    set bytesLimitPerFilePercent(value: number);
    resetBytesLimitPerFilePercent(): void;
    get bytesLimitPerFilePercentInput(): number | undefined;
    private _fileTypes?;
    get fileTypes(): string[];
    set fileTypes(value: string[]);
    resetFileTypes(): void;
    get fileTypesInput(): string[] | undefined;
    private _filesLimitPercent?;
    get filesLimitPercent(): number;
    set filesLimitPercent(value: number);
    resetFilesLimitPercent(): void;
    get filesLimitPercentInput(): number | undefined;
    private _sampleMethod?;
    get sampleMethod(): string;
    set sampleMethod(value: string);
    resetSampleMethod(): void;
    get sampleMethodInput(): string | undefined;
    private _fileSet;
    get fileSet(): DataLossPreventionJobTriggerInspectJobStorageConfigCloudStorageOptionsFileSetOutputReference;
    putFileSet(value: DataLossPreventionJobTriggerInspectJobStorageConfigCloudStorageOptionsFileSet): void;
    get fileSetInput(): DataLossPreventionJobTriggerInspectJobStorageConfigCloudStorageOptionsFileSet | undefined;
}
export interface DataLossPreventionJobTriggerInspectJobStorageConfigDatastoreOptionsKind {
    /**
    * The name of the Datastore kind.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_job_trigger#name DataLossPreventionJobTrigger#name}
    */
    readonly name: string;
}
export declare function dataLossPreventionJobTriggerInspectJobStorageConfigDatastoreOptionsKindToTerraform(struct?: DataLossPreventionJobTriggerInspectJobStorageConfigDatastoreOptionsKindOutputReference | DataLossPreventionJobTriggerInspectJobStorageConfigDatastoreOptionsKind): any;
export declare class DataLossPreventionJobTriggerInspectJobStorageConfigDatastoreOptionsKindOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataLossPreventionJobTriggerInspectJobStorageConfigDatastoreOptionsKind | undefined;
    set internalValue(value: DataLossPreventionJobTriggerInspectJobStorageConfigDatastoreOptionsKind | undefined);
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
}
export interface DataLossPreventionJobTriggerInspectJobStorageConfigDatastoreOptionsPartitionId {
    /**
    * If not empty, the ID of the namespace to which the entities belong.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_job_trigger#namespace_id DataLossPreventionJobTrigger#namespace_id}
    */
    readonly namespaceId?: string;
    /**
    * The ID of the project to which the entities belong.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_job_trigger#project_id DataLossPreventionJobTrigger#project_id}
    */
    readonly projectId: string;
}
export declare function dataLossPreventionJobTriggerInspectJobStorageConfigDatastoreOptionsPartitionIdToTerraform(struct?: DataLossPreventionJobTriggerInspectJobStorageConfigDatastoreOptionsPartitionIdOutputReference | DataLossPreventionJobTriggerInspectJobStorageConfigDatastoreOptionsPartitionId): any;
export declare class DataLossPreventionJobTriggerInspectJobStorageConfigDatastoreOptionsPartitionIdOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataLossPreventionJobTriggerInspectJobStorageConfigDatastoreOptionsPartitionId | undefined;
    set internalValue(value: DataLossPreventionJobTriggerInspectJobStorageConfigDatastoreOptionsPartitionId | undefined);
    private _namespaceId?;
    get namespaceId(): string;
    set namespaceId(value: string);
    resetNamespaceId(): void;
    get namespaceIdInput(): string | undefined;
    private _projectId?;
    get projectId(): string;
    set projectId(value: string);
    get projectIdInput(): string | undefined;
}
export interface DataLossPreventionJobTriggerInspectJobStorageConfigDatastoreOptions {
    /**
    * kind block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_job_trigger#kind DataLossPreventionJobTrigger#kind}
    */
    readonly kind: DataLossPreventionJobTriggerInspectJobStorageConfigDatastoreOptionsKind;
    /**
    * partition_id block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_job_trigger#partition_id DataLossPreventionJobTrigger#partition_id}
    */
    readonly partitionId: DataLossPreventionJobTriggerInspectJobStorageConfigDatastoreOptionsPartitionId;
}
export declare function dataLossPreventionJobTriggerInspectJobStorageConfigDatastoreOptionsToTerraform(struct?: DataLossPreventionJobTriggerInspectJobStorageConfigDatastoreOptionsOutputReference | DataLossPreventionJobTriggerInspectJobStorageConfigDatastoreOptions): any;
export declare class DataLossPreventionJobTriggerInspectJobStorageConfigDatastoreOptionsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataLossPreventionJobTriggerInspectJobStorageConfigDatastoreOptions | undefined;
    set internalValue(value: DataLossPreventionJobTriggerInspectJobStorageConfigDatastoreOptions | undefined);
    private _kind;
    get kind(): DataLossPreventionJobTriggerInspectJobStorageConfigDatastoreOptionsKindOutputReference;
    putKind(value: DataLossPreventionJobTriggerInspectJobStorageConfigDatastoreOptionsKind): void;
    get kindInput(): DataLossPreventionJobTriggerInspectJobStorageConfigDatastoreOptionsKind | undefined;
    private _partitionId;
    get partitionId(): DataLossPreventionJobTriggerInspectJobStorageConfigDatastoreOptionsPartitionIdOutputReference;
    putPartitionId(value: DataLossPreventionJobTriggerInspectJobStorageConfigDatastoreOptionsPartitionId): void;
    get partitionIdInput(): DataLossPreventionJobTriggerInspectJobStorageConfigDatastoreOptionsPartitionId | undefined;
}
export interface DataLossPreventionJobTriggerInspectJobStorageConfigTimespanConfigTimestampField {
    /**
    * Specification of the field containing the timestamp of scanned items. Used for data sources like Datastore and BigQuery.
  
  For BigQuery: Required to filter out rows based on the given start and end times. If not specified and the table was
  modified between the given start and end times, the entire table will be scanned. The valid data types of the timestamp
  field are: INTEGER, DATE, TIMESTAMP, or DATETIME BigQuery column.
  
  For Datastore. Valid data types of the timestamp field are: TIMESTAMP. Datastore entity will be scanned if the
  timestamp property does not exist or its value is empty or invalid.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_job_trigger#name DataLossPreventionJobTrigger#name}
    */
    readonly name: string;
}
export declare function dataLossPreventionJobTriggerInspectJobStorageConfigTimespanConfigTimestampFieldToTerraform(struct?: DataLossPreventionJobTriggerInspectJobStorageConfigTimespanConfigTimestampFieldOutputReference | DataLossPreventionJobTriggerInspectJobStorageConfigTimespanConfigTimestampField): any;
export declare class DataLossPreventionJobTriggerInspectJobStorageConfigTimespanConfigTimestampFieldOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataLossPreventionJobTriggerInspectJobStorageConfigTimespanConfigTimestampField | undefined;
    set internalValue(value: DataLossPreventionJobTriggerInspectJobStorageConfigTimespanConfigTimestampField | undefined);
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
}
export interface DataLossPreventionJobTriggerInspectJobStorageConfigTimespanConfig {
    /**
    * When the job is started by a JobTrigger we will automatically figure out a valid startTime to avoid
  scanning files that have not been modified since the last time the JobTrigger executed. This will
  be based on the time of the execution of the last run of the JobTrigger.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_job_trigger#enable_auto_population_of_timespan_config DataLossPreventionJobTrigger#enable_auto_population_of_timespan_config}
    */
    readonly enableAutoPopulationOfTimespanConfig?: boolean | cdktf.IResolvable;
    /**
    * Exclude files or rows newer than this value. If set to zero, no upper time limit is applied.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_job_trigger#end_time DataLossPreventionJobTrigger#end_time}
    */
    readonly endTime?: string;
    /**
    * Exclude files or rows older than this value.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_job_trigger#start_time DataLossPreventionJobTrigger#start_time}
    */
    readonly startTime?: string;
    /**
    * timestamp_field block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_job_trigger#timestamp_field DataLossPreventionJobTrigger#timestamp_field}
    */
    readonly timestampField: DataLossPreventionJobTriggerInspectJobStorageConfigTimespanConfigTimestampField;
}
export declare function dataLossPreventionJobTriggerInspectJobStorageConfigTimespanConfigToTerraform(struct?: DataLossPreventionJobTriggerInspectJobStorageConfigTimespanConfigOutputReference | DataLossPreventionJobTriggerInspectJobStorageConfigTimespanConfig): any;
export declare class DataLossPreventionJobTriggerInspectJobStorageConfigTimespanConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataLossPreventionJobTriggerInspectJobStorageConfigTimespanConfig | undefined;
    set internalValue(value: DataLossPreventionJobTriggerInspectJobStorageConfigTimespanConfig | undefined);
    private _enableAutoPopulationOfTimespanConfig?;
    get enableAutoPopulationOfTimespanConfig(): boolean | cdktf.IResolvable;
    set enableAutoPopulationOfTimespanConfig(value: boolean | cdktf.IResolvable);
    resetEnableAutoPopulationOfTimespanConfig(): void;
    get enableAutoPopulationOfTimespanConfigInput(): boolean | cdktf.IResolvable | undefined;
    private _endTime?;
    get endTime(): string;
    set endTime(value: string);
    resetEndTime(): void;
    get endTimeInput(): string | undefined;
    private _startTime?;
    get startTime(): string;
    set startTime(value: string);
    resetStartTime(): void;
    get startTimeInput(): string | undefined;
    private _timestampField;
    get timestampField(): DataLossPreventionJobTriggerInspectJobStorageConfigTimespanConfigTimestampFieldOutputReference;
    putTimestampField(value: DataLossPreventionJobTriggerInspectJobStorageConfigTimespanConfigTimestampField): void;
    get timestampFieldInput(): DataLossPreventionJobTriggerInspectJobStorageConfigTimespanConfigTimestampField | undefined;
}
export interface DataLossPreventionJobTriggerInspectJobStorageConfig {
    /**
    * big_query_options block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_job_trigger#big_query_options DataLossPreventionJobTrigger#big_query_options}
    */
    readonly bigQueryOptions?: DataLossPreventionJobTriggerInspectJobStorageConfigBigQueryOptions;
    /**
    * cloud_storage_options block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_job_trigger#cloud_storage_options DataLossPreventionJobTrigger#cloud_storage_options}
    */
    readonly cloudStorageOptions?: DataLossPreventionJobTriggerInspectJobStorageConfigCloudStorageOptions;
    /**
    * datastore_options block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_job_trigger#datastore_options DataLossPreventionJobTrigger#datastore_options}
    */
    readonly datastoreOptions?: DataLossPreventionJobTriggerInspectJobStorageConfigDatastoreOptions;
    /**
    * timespan_config block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_job_trigger#timespan_config DataLossPreventionJobTrigger#timespan_config}
    */
    readonly timespanConfig?: DataLossPreventionJobTriggerInspectJobStorageConfigTimespanConfig;
}
export declare function dataLossPreventionJobTriggerInspectJobStorageConfigToTerraform(struct?: DataLossPreventionJobTriggerInspectJobStorageConfigOutputReference | DataLossPreventionJobTriggerInspectJobStorageConfig): any;
export declare class DataLossPreventionJobTriggerInspectJobStorageConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataLossPreventionJobTriggerInspectJobStorageConfig | undefined;
    set internalValue(value: DataLossPreventionJobTriggerInspectJobStorageConfig | undefined);
    private _bigQueryOptions;
    get bigQueryOptions(): DataLossPreventionJobTriggerInspectJobStorageConfigBigQueryOptionsOutputReference;
    putBigQueryOptions(value: DataLossPreventionJobTriggerInspectJobStorageConfigBigQueryOptions): void;
    resetBigQueryOptions(): void;
    get bigQueryOptionsInput(): DataLossPreventionJobTriggerInspectJobStorageConfigBigQueryOptions | undefined;
    private _cloudStorageOptions;
    get cloudStorageOptions(): DataLossPreventionJobTriggerInspectJobStorageConfigCloudStorageOptionsOutputReference;
    putCloudStorageOptions(value: DataLossPreventionJobTriggerInspectJobStorageConfigCloudStorageOptions): void;
    resetCloudStorageOptions(): void;
    get cloudStorageOptionsInput(): DataLossPreventionJobTriggerInspectJobStorageConfigCloudStorageOptions | undefined;
    private _datastoreOptions;
    get datastoreOptions(): DataLossPreventionJobTriggerInspectJobStorageConfigDatastoreOptionsOutputReference;
    putDatastoreOptions(value: DataLossPreventionJobTriggerInspectJobStorageConfigDatastoreOptions): void;
    resetDatastoreOptions(): void;
    get datastoreOptionsInput(): DataLossPreventionJobTriggerInspectJobStorageConfigDatastoreOptions | undefined;
    private _timespanConfig;
    get timespanConfig(): DataLossPreventionJobTriggerInspectJobStorageConfigTimespanConfigOutputReference;
    putTimespanConfig(value: DataLossPreventionJobTriggerInspectJobStorageConfigTimespanConfig): void;
    resetTimespanConfig(): void;
    get timespanConfigInput(): DataLossPreventionJobTriggerInspectJobStorageConfigTimespanConfig | undefined;
}
export interface DataLossPreventionJobTriggerInspectJob {
    /**
    * The name of the template to run when this job is triggered.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_job_trigger#inspect_template_name DataLossPreventionJobTrigger#inspect_template_name}
    */
    readonly inspectTemplateName: string;
    /**
    * actions block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_job_trigger#actions DataLossPreventionJobTrigger#actions}
    */
    readonly actions: DataLossPreventionJobTriggerInspectJobActions[] | cdktf.IResolvable;
    /**
    * storage_config block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_job_trigger#storage_config DataLossPreventionJobTrigger#storage_config}
    */
    readonly storageConfig: DataLossPreventionJobTriggerInspectJobStorageConfig;
}
export declare function dataLossPreventionJobTriggerInspectJobToTerraform(struct?: DataLossPreventionJobTriggerInspectJobOutputReference | DataLossPreventionJobTriggerInspectJob): any;
export declare class DataLossPreventionJobTriggerInspectJobOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataLossPreventionJobTriggerInspectJob | undefined;
    set internalValue(value: DataLossPreventionJobTriggerInspectJob | undefined);
    private _inspectTemplateName?;
    get inspectTemplateName(): string;
    set inspectTemplateName(value: string);
    get inspectTemplateNameInput(): string | undefined;
    private _actions?;
    get actions(): DataLossPreventionJobTriggerInspectJobActions[] | cdktf.IResolvable;
    set actions(value: DataLossPreventionJobTriggerInspectJobActions[] | cdktf.IResolvable);
    get actionsInput(): cdktf.IResolvable | DataLossPreventionJobTriggerInspectJobActions[] | undefined;
    private _storageConfig;
    get storageConfig(): DataLossPreventionJobTriggerInspectJobStorageConfigOutputReference;
    putStorageConfig(value: DataLossPreventionJobTriggerInspectJobStorageConfig): void;
    get storageConfigInput(): DataLossPreventionJobTriggerInspectJobStorageConfig | undefined;
}
export interface DataLossPreventionJobTriggerTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_job_trigger#create DataLossPreventionJobTrigger#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_job_trigger#delete DataLossPreventionJobTrigger#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_job_trigger#update DataLossPreventionJobTrigger#update}
    */
    readonly update?: string;
}
export declare function dataLossPreventionJobTriggerTimeoutsToTerraform(struct?: DataLossPreventionJobTriggerTimeoutsOutputReference | DataLossPreventionJobTriggerTimeouts | cdktf.IResolvable): any;
export declare class DataLossPreventionJobTriggerTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataLossPreventionJobTriggerTimeouts | undefined;
    set internalValue(value: DataLossPreventionJobTriggerTimeouts | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
export interface DataLossPreventionJobTriggerTriggersSchedule {
    /**
    * With this option a job is started a regular periodic basis. For example: every day (86400 seconds).
  
  A scheduled start time will be skipped if the previous execution has not ended when its scheduled time occurs.
  
  This value must be set to a time duration greater than or equal to 1 day and can be no longer than 60 days.
  
  A duration in seconds with up to nine fractional digits, terminated by 's'. Example: "3.5s".
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_job_trigger#recurrence_period_duration DataLossPreventionJobTrigger#recurrence_period_duration}
    */
    readonly recurrencePeriodDuration?: string;
}
export declare function dataLossPreventionJobTriggerTriggersScheduleToTerraform(struct?: DataLossPreventionJobTriggerTriggersScheduleOutputReference | DataLossPreventionJobTriggerTriggersSchedule): any;
export declare class DataLossPreventionJobTriggerTriggersScheduleOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataLossPreventionJobTriggerTriggersSchedule | undefined;
    set internalValue(value: DataLossPreventionJobTriggerTriggersSchedule | undefined);
    private _recurrencePeriodDuration?;
    get recurrencePeriodDuration(): string;
    set recurrencePeriodDuration(value: string);
    resetRecurrencePeriodDuration(): void;
    get recurrencePeriodDurationInput(): string | undefined;
}
export interface DataLossPreventionJobTriggerTriggers {
    /**
    * schedule block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_job_trigger#schedule DataLossPreventionJobTrigger#schedule}
    */
    readonly schedule?: DataLossPreventionJobTriggerTriggersSchedule;
}
export declare function dataLossPreventionJobTriggerTriggersToTerraform(struct?: DataLossPreventionJobTriggerTriggers | cdktf.IResolvable): any;
/**
* Represents a {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_job_trigger google_data_loss_prevention_job_trigger}
*/
export declare class DataLossPreventionJobTrigger extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_data_loss_prevention_job_trigger";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google/r/data_loss_prevention_job_trigger google_data_loss_prevention_job_trigger} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataLossPreventionJobTriggerConfig
    */
    constructor(scope: Construct, id: string, config: DataLossPreventionJobTriggerConfig);
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _displayName?;
    get displayName(): string;
    set displayName(value: string);
    resetDisplayName(): void;
    get displayNameInput(): string | undefined;
    get id(): string;
    get lastRunTime(): string;
    get name(): string;
    private _parent?;
    get parent(): string;
    set parent(value: string);
    get parentInput(): string | undefined;
    private _status?;
    get status(): string;
    set status(value: string);
    resetStatus(): void;
    get statusInput(): string | undefined;
    private _inspectJob;
    get inspectJob(): DataLossPreventionJobTriggerInspectJobOutputReference;
    putInspectJob(value: DataLossPreventionJobTriggerInspectJob): void;
    resetInspectJob(): void;
    get inspectJobInput(): DataLossPreventionJobTriggerInspectJob | undefined;
    private _timeouts;
    get timeouts(): DataLossPreventionJobTriggerTimeoutsOutputReference;
    putTimeouts(value: DataLossPreventionJobTriggerTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): DataLossPreventionJobTriggerTimeouts | undefined;
    private _triggers?;
    get triggers(): DataLossPreventionJobTriggerTriggers[] | cdktf.IResolvable;
    set triggers(value: DataLossPreventionJobTriggerTriggers[] | cdktf.IResolvable);
    get triggersInput(): cdktf.IResolvable | DataLossPreventionJobTriggerTriggers[] | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
