import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface EndpointsServiceIamBindingConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/endpoints_service_iam_binding#members EndpointsServiceIamBinding#members}
    */
    readonly members: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/endpoints_service_iam_binding#role EndpointsServiceIamBinding#role}
    */
    readonly role: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/endpoints_service_iam_binding#service_name EndpointsServiceIamBinding#service_name}
    */
    readonly serviceName: string;
    /**
    * condition block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/endpoints_service_iam_binding#condition EndpointsServiceIamBinding#condition}
    */
    readonly condition?: EndpointsServiceIamBindingCondition;
}
export interface EndpointsServiceIamBindingCondition {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/endpoints_service_iam_binding#description EndpointsServiceIamBinding#description}
    */
    readonly description?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/endpoints_service_iam_binding#expression EndpointsServiceIamBinding#expression}
    */
    readonly expression: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/endpoints_service_iam_binding#title EndpointsServiceIamBinding#title}
    */
    readonly title: string;
}
export declare function endpointsServiceIamBindingConditionToTerraform(struct?: EndpointsServiceIamBindingConditionOutputReference | EndpointsServiceIamBindingCondition): any;
export declare class EndpointsServiceIamBindingConditionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): EndpointsServiceIamBindingCondition | undefined;
    set internalValue(value: EndpointsServiceIamBindingCondition | undefined);
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _expression?;
    get expression(): string;
    set expression(value: string);
    get expressionInput(): string | undefined;
    private _title?;
    get title(): string;
    set title(value: string);
    get titleInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google/r/endpoints_service_iam_binding google_endpoints_service_iam_binding}
*/
export declare class EndpointsServiceIamBinding extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_endpoints_service_iam_binding";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google/r/endpoints_service_iam_binding google_endpoints_service_iam_binding} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options EndpointsServiceIamBindingConfig
    */
    constructor(scope: Construct, id: string, config: EndpointsServiceIamBindingConfig);
    get etag(): string;
    get id(): string;
    private _members?;
    get members(): string[];
    set members(value: string[]);
    get membersInput(): string[] | undefined;
    private _role?;
    get role(): string;
    set role(value: string);
    get roleInput(): string | undefined;
    private _serviceName?;
    get serviceName(): string;
    set serviceName(value: string);
    get serviceNameInput(): string | undefined;
    private _condition;
    get condition(): EndpointsServiceIamBindingConditionOutputReference;
    putCondition(value: EndpointsServiceIamBindingCondition): void;
    resetCondition(): void;
    get conditionInput(): EndpointsServiceIamBindingCondition | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
