import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface IapTunnelInstanceIamMemberConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/iap_tunnel_instance_iam_member#instance IapTunnelInstanceIamMember#instance}
    */
    readonly instance: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/iap_tunnel_instance_iam_member#member IapTunnelInstanceIamMember#member}
    */
    readonly member: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/iap_tunnel_instance_iam_member#project IapTunnelInstanceIamMember#project}
    */
    readonly project?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/iap_tunnel_instance_iam_member#role IapTunnelInstanceIamMember#role}
    */
    readonly role: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/iap_tunnel_instance_iam_member#zone IapTunnelInstanceIamMember#zone}
    */
    readonly zone?: string;
    /**
    * condition block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/iap_tunnel_instance_iam_member#condition IapTunnelInstanceIamMember#condition}
    */
    readonly condition?: IapTunnelInstanceIamMemberCondition;
}
export interface IapTunnelInstanceIamMemberCondition {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/iap_tunnel_instance_iam_member#description IapTunnelInstanceIamMember#description}
    */
    readonly description?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/iap_tunnel_instance_iam_member#expression IapTunnelInstanceIamMember#expression}
    */
    readonly expression: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/iap_tunnel_instance_iam_member#title IapTunnelInstanceIamMember#title}
    */
    readonly title: string;
}
export declare function iapTunnelInstanceIamMemberConditionToTerraform(struct?: IapTunnelInstanceIamMemberConditionOutputReference | IapTunnelInstanceIamMemberCondition): any;
export declare class IapTunnelInstanceIamMemberConditionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): IapTunnelInstanceIamMemberCondition | undefined;
    set internalValue(value: IapTunnelInstanceIamMemberCondition | undefined);
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _expression?;
    get expression(): string;
    set expression(value: string);
    get expressionInput(): string | undefined;
    private _title?;
    get title(): string;
    set title(value: string);
    get titleInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google/r/iap_tunnel_instance_iam_member google_iap_tunnel_instance_iam_member}
*/
export declare class IapTunnelInstanceIamMember extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_iap_tunnel_instance_iam_member";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google/r/iap_tunnel_instance_iam_member google_iap_tunnel_instance_iam_member} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options IapTunnelInstanceIamMemberConfig
    */
    constructor(scope: Construct, id: string, config: IapTunnelInstanceIamMemberConfig);
    get etag(): string;
    get id(): string;
    private _instance?;
    get instance(): string;
    set instance(value: string);
    get instanceInput(): string | undefined;
    private _member?;
    get member(): string;
    set member(value: string);
    get memberInput(): string | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _role?;
    get role(): string;
    set role(value: string);
    get roleInput(): string | undefined;
    private _zone?;
    get zone(): string;
    set zone(value: string);
    resetZone(): void;
    get zoneInput(): string | undefined;
    private _condition;
    get condition(): IapTunnelInstanceIamMemberConditionOutputReference;
    putCondition(value: IapTunnelInstanceIamMemberCondition): void;
    resetCondition(): void;
    get conditionInput(): IapTunnelInstanceIamMemberCondition | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
