import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface IapWebTypeAppEngineIamPolicyConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/iap_web_type_app_engine_iam_policy#app_id IapWebTypeAppEngineIamPolicy#app_id}
    */
    readonly appId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/iap_web_type_app_engine_iam_policy#policy_data IapWebTypeAppEngineIamPolicy#policy_data}
    */
    readonly policyData: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/iap_web_type_app_engine_iam_policy#project IapWebTypeAppEngineIamPolicy#project}
    */
    readonly project?: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google/r/iap_web_type_app_engine_iam_policy google_iap_web_type_app_engine_iam_policy}
*/
export declare class IapWebTypeAppEngineIamPolicy extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_iap_web_type_app_engine_iam_policy";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google/r/iap_web_type_app_engine_iam_policy google_iap_web_type_app_engine_iam_policy} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options IapWebTypeAppEngineIamPolicyConfig
    */
    constructor(scope: Construct, id: string, config: IapWebTypeAppEngineIamPolicyConfig);
    private _appId?;
    get appId(): string;
    set appId(value: string);
    get appIdInput(): string | undefined;
    get etag(): string;
    get id(): string;
    private _policyData?;
    get policyData(): string;
    set policyData(value: string);
    get policyDataInput(): string | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
