import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface NetworkServicesEdgeCacheOriginConfig extends cdktf.TerraformMetaArguments {
    /**
    * A human-readable description of the resource.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/network_services_edge_cache_origin#description NetworkServicesEdgeCacheOrigin#description}
    */
    readonly description?: string;
    /**
    * The Origin resource to try when the current origin cannot be reached.
  After maxAttempts is reached, the configured failoverOrigin will be used to fulfil the request.
  
  The value of timeout.maxAttemptsTimeout dictates the timeout across all origins.
  A reference to a Topic resource.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/network_services_edge_cache_origin#failover_origin NetworkServicesEdgeCacheOrigin#failover_origin}
    */
    readonly failoverOrigin?: string;
    /**
    * Set of label tags associated with the EdgeCache resource.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/network_services_edge_cache_origin#labels NetworkServicesEdgeCacheOrigin#labels}
    */
    readonly labels?: {
        [key: string]: string;
    };
    /**
    * The maximum number of attempts to cache fill from this origin. Another attempt is made when a cache fill fails with one of the retryConditions.
  
  Once maxAttempts to this origin have failed the failoverOrigin will be used, if one is specified. That failoverOrigin may specify its own maxAttempts,
  retryConditions and failoverOrigin to control its own cache fill failures.
  
  The total number of allowed attempts to cache fill across this and failover origins is limited to four.
  The total time allowed for cache fill attempts across this and failover origins can be controlled with maxAttemptsTimeout.
  
  The last valid, non-retried response from all origins will be returned to the client.
  If no origin returns a valid response, an HTTP 502 will be returned to the client.
  
  Defaults to 1. Must be a value greater than 0 and less than 4.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/network_services_edge_cache_origin#max_attempts NetworkServicesEdgeCacheOrigin#max_attempts}
    */
    readonly maxAttempts?: number;
    /**
    * Name of the resource; provided by the client when the resource is created.
  The name must be 1-64 characters long, and match the regular expression [a-zA-Z][a-zA-Z0-9_-]* which means the first character must be a letter,
  and all following characters must be a dash, underscore, letter or digit.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/network_services_edge_cache_origin#name NetworkServicesEdgeCacheOrigin#name}
    */
    readonly name: string;
    /**
    * A fully qualified domain name (FQDN) or IP address reachable over the public Internet, or the address of a Google Cloud Storage bucket.
  
  This address will be used as the origin for cache requests - e.g. FQDN: media-backend.example.com, IPv4: 35.218.1.1, IPv6: 2607:f8b0:4012:809::200e, Cloud Storage: gs://bucketname
  
  When providing an FQDN (hostname), it must be publicly resolvable (e.g. via Google public DNS) and IP addresses must be publicly routable.  It must not contain a protocol (e.g., https://) and it must not contain any slashes.
  If a Cloud Storage bucket is provided, it must be in the canonical "gs://bucketname" format. Other forms, such as "storage.googleapis.com", will be rejected.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/network_services_edge_cache_origin#origin_address NetworkServicesEdgeCacheOrigin#origin_address}
    */
    readonly originAddress: string;
    /**
    * The port to connect to the origin on.
  Defaults to port 443 for HTTP2 and HTTPS protocols, and port 80 for HTTP.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/network_services_edge_cache_origin#port NetworkServicesEdgeCacheOrigin#port}
    */
    readonly port?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/network_services_edge_cache_origin#project NetworkServicesEdgeCacheOrigin#project}
    */
    readonly project?: string;
    /**
    * The protocol to use to connect to the configured origin. Defaults to HTTP2, and it is strongly recommended that users use HTTP2 for both security & performance.
  
  When using HTTP2 or HTTPS as the protocol, a valid, publicly-signed, unexpired TLS (SSL) certificate must be presented by the origin server. Possible values: ["HTTP2", "HTTPS", "HTTP"]
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/network_services_edge_cache_origin#protocol NetworkServicesEdgeCacheOrigin#protocol}
    */
    readonly protocol?: string;
    /**
    * Specifies one or more retry conditions for the configured origin.
  
  If the failure mode during a connection attempt to the origin matches the configured retryCondition(s),
  the origin request will be retried up to maxAttempts times. The failoverOrigin, if configured, will then be used to satisfy the request.
  
  The default retryCondition is "CONNECT_FAILURE".
  
  retryConditions apply to this origin, and not subsequent failoverOrigin(s),
  which may specify their own retryConditions and maxAttempts.
  
  Valid values are:
  
  - CONNECT_FAILURE: Retry on failures connecting to origins, for example due to connection timeouts.
  - HTTP_5XX: Retry if the origin responds with any 5xx response code, or if the origin does not respond at all, example: disconnects, reset, read timeout, connection failure, and refused streams.
  - GATEWAY_ERROR: Similar to 5xx, but only applies to response codes 502, 503 or 504.
  - RETRIABLE_4XX: Retry for retriable 4xx response codes, which include HTTP 409 (Conflict) and HTTP 429 (Too Many Requests)
  - NOT_FOUND: Retry if the origin returns a HTTP 404 (Not Found). This can be useful when generating video content, and the segment is not available yet.
  - FORBIDDEN: Retry if the origin returns a HTTP 403 (Forbidden). Possible values: ["CONNECT_FAILURE", "HTTP_5XX", "GATEWAY_ERROR", "RETRIABLE_4XX", "NOT_FOUND", "FORBIDDEN"]
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/network_services_edge_cache_origin#retry_conditions NetworkServicesEdgeCacheOrigin#retry_conditions}
    */
    readonly retryConditions?: string[];
    /**
    * timeout block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/network_services_edge_cache_origin#timeout NetworkServicesEdgeCacheOrigin#timeout}
    */
    readonly timeout?: NetworkServicesEdgeCacheOriginTimeout;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/network_services_edge_cache_origin#timeouts NetworkServicesEdgeCacheOrigin#timeouts}
    */
    readonly timeouts?: NetworkServicesEdgeCacheOriginTimeouts;
}
export interface NetworkServicesEdgeCacheOriginTimeout {
    /**
    * The maximum duration to wait for a single origin connection to be established, including DNS lookup, TLS handshake and TCP/QUIC connection establishment.
  
  Defaults to 5 seconds. The timeout must be a value between 1s and 15s.
  
  The connectTimeout capped by the deadline set by the request's maxAttemptsTimeout.  The last connection attempt may have a smaller connectTimeout in order to adhere to the overall maxAttemptsTimeout.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/network_services_edge_cache_origin#connect_timeout NetworkServicesEdgeCacheOrigin#connect_timeout}
    */
    readonly connectTimeout?: string;
    /**
    * The maximum time across all connection attempts to the origin, including failover origins, before returning an error to the client. A HTTP 504 will be returned if the timeout is reached before a response is returned.
  
  Defaults to 15 seconds. The timeout must be a value between 1s and 30s.
  
  If a failoverOrigin is specified, the maxAttemptsTimeout of the first configured origin sets the deadline for all connection attempts across all failoverOrigins.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/network_services_edge_cache_origin#max_attempts_timeout NetworkServicesEdgeCacheOrigin#max_attempts_timeout}
    */
    readonly maxAttemptsTimeout?: string;
    /**
    * The maximum duration to wait between reads of a single HTTP connection/stream.
  
  Defaults to 15 seconds.  The timeout must be a value between 1s and 30s.
  
  The readTimeout is capped by the responseTimeout.  All reads of the HTTP connection/stream must be completed by the deadline set by the responseTimeout.
  
  If the response headers have already been written to the connection, the response will be truncated and logged.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/network_services_edge_cache_origin#read_timeout NetworkServicesEdgeCacheOrigin#read_timeout}
    */
    readonly readTimeout?: string;
    /**
    * The maximum duration to wait for the last byte of a response to arrive when reading from the HTTP connection/stream.
  
  Defaults to 30 seconds. The timeout must be a value between 1s and 120s.
  
  The responseTimeout starts after the connection has been established.
  
  This also applies to HTTP Chunked Transfer Encoding responses, and/or when an open-ended Range request is made to the origin. Origins that take longer to write additional bytes to the response than the configured responseTimeout will result in an error being returned to the client.
  
  If the response headers have already been written to the connection, the response will be truncated and logged.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/network_services_edge_cache_origin#response_timeout NetworkServicesEdgeCacheOrigin#response_timeout}
    */
    readonly responseTimeout?: string;
}
export declare function networkServicesEdgeCacheOriginTimeoutToTerraform(struct?: NetworkServicesEdgeCacheOriginTimeoutOutputReference | NetworkServicesEdgeCacheOriginTimeout): any;
export declare class NetworkServicesEdgeCacheOriginTimeoutOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): NetworkServicesEdgeCacheOriginTimeout | undefined;
    set internalValue(value: NetworkServicesEdgeCacheOriginTimeout | undefined);
    private _connectTimeout?;
    get connectTimeout(): string;
    set connectTimeout(value: string);
    resetConnectTimeout(): void;
    get connectTimeoutInput(): string | undefined;
    private _maxAttemptsTimeout?;
    get maxAttemptsTimeout(): string;
    set maxAttemptsTimeout(value: string);
    resetMaxAttemptsTimeout(): void;
    get maxAttemptsTimeoutInput(): string | undefined;
    private _readTimeout?;
    get readTimeout(): string;
    set readTimeout(value: string);
    resetReadTimeout(): void;
    get readTimeoutInput(): string | undefined;
    private _responseTimeout?;
    get responseTimeout(): string;
    set responseTimeout(value: string);
    resetResponseTimeout(): void;
    get responseTimeoutInput(): string | undefined;
}
export interface NetworkServicesEdgeCacheOriginTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/network_services_edge_cache_origin#create NetworkServicesEdgeCacheOrigin#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/network_services_edge_cache_origin#delete NetworkServicesEdgeCacheOrigin#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/network_services_edge_cache_origin#update NetworkServicesEdgeCacheOrigin#update}
    */
    readonly update?: string;
}
export declare function networkServicesEdgeCacheOriginTimeoutsToTerraform(struct?: NetworkServicesEdgeCacheOriginTimeoutsOutputReference | NetworkServicesEdgeCacheOriginTimeouts | cdktf.IResolvable): any;
export declare class NetworkServicesEdgeCacheOriginTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): NetworkServicesEdgeCacheOriginTimeouts | undefined;
    set internalValue(value: NetworkServicesEdgeCacheOriginTimeouts | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google/r/network_services_edge_cache_origin google_network_services_edge_cache_origin}
*/
export declare class NetworkServicesEdgeCacheOrigin extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_network_services_edge_cache_origin";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google/r/network_services_edge_cache_origin google_network_services_edge_cache_origin} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options NetworkServicesEdgeCacheOriginConfig
    */
    constructor(scope: Construct, id: string, config: NetworkServicesEdgeCacheOriginConfig);
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _failoverOrigin?;
    get failoverOrigin(): string;
    set failoverOrigin(value: string);
    resetFailoverOrigin(): void;
    get failoverOriginInput(): string | undefined;
    get id(): string;
    private _labels?;
    get labels(): {
        [key: string]: string;
    };
    set labels(value: {
        [key: string]: string;
    });
    resetLabels(): void;
    get labelsInput(): {
        [key: string]: string;
    } | undefined;
    private _maxAttempts?;
    get maxAttempts(): number;
    set maxAttempts(value: number);
    resetMaxAttempts(): void;
    get maxAttemptsInput(): number | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _originAddress?;
    get originAddress(): string;
    set originAddress(value: string);
    get originAddressInput(): string | undefined;
    private _port?;
    get port(): number;
    set port(value: number);
    resetPort(): void;
    get portInput(): number | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _protocol?;
    get protocol(): string;
    set protocol(value: string);
    resetProtocol(): void;
    get protocolInput(): string | undefined;
    private _retryConditions?;
    get retryConditions(): string[];
    set retryConditions(value: string[]);
    resetRetryConditions(): void;
    get retryConditionsInput(): string[] | undefined;
    private _timeout;
    get timeout(): NetworkServicesEdgeCacheOriginTimeoutOutputReference;
    putTimeout(value: NetworkServicesEdgeCacheOriginTimeout): void;
    resetTimeout(): void;
    get timeoutInput(): NetworkServicesEdgeCacheOriginTimeout | undefined;
    private _timeouts;
    get timeouts(): NetworkServicesEdgeCacheOriginTimeoutsOutputReference;
    putTimeouts(value: NetworkServicesEdgeCacheOriginTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): NetworkServicesEdgeCacheOriginTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
