import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface NetworkServicesEdgeCacheServiceConfig extends cdktf.TerraformMetaArguments {
    /**
    * A human-readable description of the resource.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/network_services_edge_cache_service#description NetworkServicesEdgeCacheService#description}
    */
    readonly description?: string;
    /**
    * Disables HTTP/2.
  
  HTTP/2 (h2) is enabled by default and recommended for performance. HTTP/2 improves connection re-use and reduces connection setup overhead by sending multiple streams over the same connection.
  
  Some legacy HTTP clients may have issues with HTTP/2 connections due to broken HTTP/2 implementations. Setting this to true will prevent HTTP/2 from being advertised and negotiated.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/network_services_edge_cache_service#disable_http2 NetworkServicesEdgeCacheService#disable_http2}
    */
    readonly disableHttp2?: boolean | cdktf.IResolvable;
    /**
    * HTTP/3 (IETF QUIC) and Google QUIC are enabled by default.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/network_services_edge_cache_service#disable_quic NetworkServicesEdgeCacheService#disable_quic}
    */
    readonly disableQuic?: boolean | cdktf.IResolvable;
    /**
    * Resource URL that points at the Cloud Armor edge security policy that is applied on each request against the EdgeCacheService.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/network_services_edge_cache_service#edge_security_policy NetworkServicesEdgeCacheService#edge_security_policy}
    */
    readonly edgeSecurityPolicy?: string;
    /**
    * URLs to sslCertificate resources that are used to authenticate connections between users and the EdgeCacheService.
  
  Note that only "global" certificates with a "scope" of "EDGE_CACHE" can be attached to an EdgeCacheService.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/network_services_edge_cache_service#edge_ssl_certificates NetworkServicesEdgeCacheService#edge_ssl_certificates}
    */
    readonly edgeSslCertificates?: string[];
    /**
    * Set of label tags associated with the EdgeCache resource.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/network_services_edge_cache_service#labels NetworkServicesEdgeCacheService#labels}
    */
    readonly labels?: {
        [key: string]: string;
    };
    /**
    * Name of the resource; provided by the client when the resource is created.
  The name must be 1-64 characters long, and match the regular expression [a-zA-Z][a-zA-Z0-9_-]* which means the first character must be a letter,
  and all following characters must be a dash, underscore, letter or digit.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/network_services_edge_cache_service#name NetworkServicesEdgeCacheService#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/network_services_edge_cache_service#project NetworkServicesEdgeCacheService#project}
    */
    readonly project?: string;
    /**
    * Require TLS (HTTPS) for all clients connecting to this service.
  
  Clients who connect over HTTP (port 80) will receive a HTTP 301 to the same URL over HTTPS (port 443).
  You must have at least one (1) edgeSslCertificate specified to enable this.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/network_services_edge_cache_service#require_tls NetworkServicesEdgeCacheService#require_tls}
    */
    readonly requireTls?: boolean | cdktf.IResolvable;
    /**
    * URL of the SslPolicy resource that will be associated with the EdgeCacheService.
  
  If not set, the EdgeCacheService has no SSL policy configured, and will default to the "COMPATIBLE" policy.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/network_services_edge_cache_service#ssl_policy NetworkServicesEdgeCacheService#ssl_policy}
    */
    readonly sslPolicy?: string;
    /**
    * log_config block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/network_services_edge_cache_service#log_config NetworkServicesEdgeCacheService#log_config}
    */
    readonly logConfig?: NetworkServicesEdgeCacheServiceLogConfig;
    /**
    * routing block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/network_services_edge_cache_service#routing NetworkServicesEdgeCacheService#routing}
    */
    readonly routing: NetworkServicesEdgeCacheServiceRouting;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/network_services_edge_cache_service#timeouts NetworkServicesEdgeCacheService#timeouts}
    */
    readonly timeouts?: NetworkServicesEdgeCacheServiceTimeouts;
}
export interface NetworkServicesEdgeCacheServiceLogConfig {
    /**
    * Specifies whether to enable logging for traffic served by this service.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/network_services_edge_cache_service#enable NetworkServicesEdgeCacheService#enable}
    */
    readonly enable?: boolean | cdktf.IResolvable;
    /**
    * Configures the sampling rate of requests, where 1.0 means all logged requests are reported and 0.0 means no logged requests are reported. The default value is 1.0, and the value of the field must be in [0, 1].
  
  This field can only be specified if logging is enabled for this service.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/network_services_edge_cache_service#sample_rate NetworkServicesEdgeCacheService#sample_rate}
    */
    readonly sampleRate?: number;
}
export declare function networkServicesEdgeCacheServiceLogConfigToTerraform(struct?: NetworkServicesEdgeCacheServiceLogConfigOutputReference | NetworkServicesEdgeCacheServiceLogConfig): any;
export declare class NetworkServicesEdgeCacheServiceLogConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): NetworkServicesEdgeCacheServiceLogConfig | undefined;
    set internalValue(value: NetworkServicesEdgeCacheServiceLogConfig | undefined);
    private _enable?;
    get enable(): boolean | cdktf.IResolvable;
    set enable(value: boolean | cdktf.IResolvable);
    resetEnable(): void;
    get enableInput(): boolean | cdktf.IResolvable | undefined;
    private _sampleRate?;
    get sampleRate(): number;
    set sampleRate(value: number);
    resetSampleRate(): void;
    get sampleRateInput(): number | undefined;
}
export interface NetworkServicesEdgeCacheServiceRoutingHostRule {
    /**
    * A human-readable description of the hostRule.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/network_services_edge_cache_service#description NetworkServicesEdgeCacheService#description}
    */
    readonly description?: string;
    /**
    * The list of host patterns to match.
  
  Host patterns must be valid hostnames. Ports are not allowed. Wildcard hosts are supported in the suffix or prefix form. * matches any string of ([a-z0-9-.]*). It does not match the empty string.
  
  When multiple hosts are specified, hosts are matched in the following priority:
  
    1. Exact domain names: ''www.foo.com''.
    2. Suffix domain wildcards: ''*.foo.com'' or ''*-bar.foo.com''.
    3. Prefix domain wildcards: ''foo.*'' or ''foo-*''.
    4. Special wildcard ''*'' matching any domain.
  
    Notes:
  
      The wildcard will not match the empty string. e.g. ''*-bar.foo.com'' will match ''baz-bar.foo.com'' but not ''-bar.foo.com''. The longest wildcards match first. Only a single host in the entire service can match on ''*''. A domain must be unique across all configured hosts within a service.
  
      Hosts are matched against the HTTP Host header, or for HTTP/2 and HTTP/3, the ":authority" header, from the incoming request.
  
      You may specify up to 10 hosts.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/network_services_edge_cache_service#hosts NetworkServicesEdgeCacheService#hosts}
    */
    readonly hosts: string[];
    /**
    * The name of the pathMatcher associated with this hostRule.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/network_services_edge_cache_service#path_matcher NetworkServicesEdgeCacheService#path_matcher}
    */
    readonly pathMatcher: string;
}
export declare function networkServicesEdgeCacheServiceRoutingHostRuleToTerraform(struct?: NetworkServicesEdgeCacheServiceRoutingHostRule | cdktf.IResolvable): any;
export interface NetworkServicesEdgeCacheServiceRoutingPathMatcherRouteRuleHeaderActionRequestHeaderToAdd {
    /**
    * The name of the header to add.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/network_services_edge_cache_service#header_name NetworkServicesEdgeCacheService#header_name}
    */
    readonly headerName: string;
    /**
    * The value of the header to add.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/network_services_edge_cache_service#header_value NetworkServicesEdgeCacheService#header_value}
    */
    readonly headerValue: string;
    /**
    * Whether to replace all existing headers with the same name.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/network_services_edge_cache_service#replace NetworkServicesEdgeCacheService#replace}
    */
    readonly replace?: boolean | cdktf.IResolvable;
}
export declare function networkServicesEdgeCacheServiceRoutingPathMatcherRouteRuleHeaderActionRequestHeaderToAddToTerraform(struct?: NetworkServicesEdgeCacheServiceRoutingPathMatcherRouteRuleHeaderActionRequestHeaderToAdd | cdktf.IResolvable): any;
export interface NetworkServicesEdgeCacheServiceRoutingPathMatcherRouteRuleHeaderActionRequestHeaderToRemove {
    /**
    * The name of the header to remove.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/network_services_edge_cache_service#header_name NetworkServicesEdgeCacheService#header_name}
    */
    readonly headerName: string;
}
export declare function networkServicesEdgeCacheServiceRoutingPathMatcherRouteRuleHeaderActionRequestHeaderToRemoveToTerraform(struct?: NetworkServicesEdgeCacheServiceRoutingPathMatcherRouteRuleHeaderActionRequestHeaderToRemove | cdktf.IResolvable): any;
export interface NetworkServicesEdgeCacheServiceRoutingPathMatcherRouteRuleHeaderActionResponseHeaderToAdd {
    /**
    * The name of the header to add.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/network_services_edge_cache_service#header_name NetworkServicesEdgeCacheService#header_name}
    */
    readonly headerName: string;
    /**
    * The value of the header to add.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/network_services_edge_cache_service#header_value NetworkServicesEdgeCacheService#header_value}
    */
    readonly headerValue: string;
    /**
    * Whether to replace all existing headers with the same name.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/network_services_edge_cache_service#replace NetworkServicesEdgeCacheService#replace}
    */
    readonly replace?: boolean | cdktf.IResolvable;
}
export declare function networkServicesEdgeCacheServiceRoutingPathMatcherRouteRuleHeaderActionResponseHeaderToAddToTerraform(struct?: NetworkServicesEdgeCacheServiceRoutingPathMatcherRouteRuleHeaderActionResponseHeaderToAdd | cdktf.IResolvable): any;
export interface NetworkServicesEdgeCacheServiceRoutingPathMatcherRouteRuleHeaderActionResponseHeaderToRemove {
    /**
    * Headers to remove from the response prior to sending it back to the client.
  
  Response headers are only sent to the client, and do not have an effect on the cache serving the response.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/network_services_edge_cache_service#header_name NetworkServicesEdgeCacheService#header_name}
    */
    readonly headerName: string;
}
export declare function networkServicesEdgeCacheServiceRoutingPathMatcherRouteRuleHeaderActionResponseHeaderToRemoveToTerraform(struct?: NetworkServicesEdgeCacheServiceRoutingPathMatcherRouteRuleHeaderActionResponseHeaderToRemove | cdktf.IResolvable): any;
export interface NetworkServicesEdgeCacheServiceRoutingPathMatcherRouteRuleHeaderAction {
    /**
    * request_header_to_add block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/network_services_edge_cache_service#request_header_to_add NetworkServicesEdgeCacheService#request_header_to_add}
    */
    readonly requestHeaderToAdd?: NetworkServicesEdgeCacheServiceRoutingPathMatcherRouteRuleHeaderActionRequestHeaderToAdd[] | cdktf.IResolvable;
    /**
    * request_header_to_remove block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/network_services_edge_cache_service#request_header_to_remove NetworkServicesEdgeCacheService#request_header_to_remove}
    */
    readonly requestHeaderToRemove?: NetworkServicesEdgeCacheServiceRoutingPathMatcherRouteRuleHeaderActionRequestHeaderToRemove[] | cdktf.IResolvable;
    /**
    * response_header_to_add block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/network_services_edge_cache_service#response_header_to_add NetworkServicesEdgeCacheService#response_header_to_add}
    */
    readonly responseHeaderToAdd?: NetworkServicesEdgeCacheServiceRoutingPathMatcherRouteRuleHeaderActionResponseHeaderToAdd[] | cdktf.IResolvable;
    /**
    * response_header_to_remove block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/network_services_edge_cache_service#response_header_to_remove NetworkServicesEdgeCacheService#response_header_to_remove}
    */
    readonly responseHeaderToRemove?: NetworkServicesEdgeCacheServiceRoutingPathMatcherRouteRuleHeaderActionResponseHeaderToRemove[] | cdktf.IResolvable;
}
export declare function networkServicesEdgeCacheServiceRoutingPathMatcherRouteRuleHeaderActionToTerraform(struct?: NetworkServicesEdgeCacheServiceRoutingPathMatcherRouteRuleHeaderActionOutputReference | NetworkServicesEdgeCacheServiceRoutingPathMatcherRouteRuleHeaderAction): any;
export declare class NetworkServicesEdgeCacheServiceRoutingPathMatcherRouteRuleHeaderActionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): NetworkServicesEdgeCacheServiceRoutingPathMatcherRouteRuleHeaderAction | undefined;
    set internalValue(value: NetworkServicesEdgeCacheServiceRoutingPathMatcherRouteRuleHeaderAction | undefined);
    private _requestHeaderToAdd?;
    get requestHeaderToAdd(): NetworkServicesEdgeCacheServiceRoutingPathMatcherRouteRuleHeaderActionRequestHeaderToAdd[] | cdktf.IResolvable;
    set requestHeaderToAdd(value: NetworkServicesEdgeCacheServiceRoutingPathMatcherRouteRuleHeaderActionRequestHeaderToAdd[] | cdktf.IResolvable);
    resetRequestHeaderToAdd(): void;
    get requestHeaderToAddInput(): cdktf.IResolvable | NetworkServicesEdgeCacheServiceRoutingPathMatcherRouteRuleHeaderActionRequestHeaderToAdd[] | undefined;
    private _requestHeaderToRemove?;
    get requestHeaderToRemove(): NetworkServicesEdgeCacheServiceRoutingPathMatcherRouteRuleHeaderActionRequestHeaderToRemove[] | cdktf.IResolvable;
    set requestHeaderToRemove(value: NetworkServicesEdgeCacheServiceRoutingPathMatcherRouteRuleHeaderActionRequestHeaderToRemove[] | cdktf.IResolvable);
    resetRequestHeaderToRemove(): void;
    get requestHeaderToRemoveInput(): cdktf.IResolvable | NetworkServicesEdgeCacheServiceRoutingPathMatcherRouteRuleHeaderActionRequestHeaderToRemove[] | undefined;
    private _responseHeaderToAdd?;
    get responseHeaderToAdd(): NetworkServicesEdgeCacheServiceRoutingPathMatcherRouteRuleHeaderActionResponseHeaderToAdd[] | cdktf.IResolvable;
    set responseHeaderToAdd(value: NetworkServicesEdgeCacheServiceRoutingPathMatcherRouteRuleHeaderActionResponseHeaderToAdd[] | cdktf.IResolvable);
    resetResponseHeaderToAdd(): void;
    get responseHeaderToAddInput(): cdktf.IResolvable | NetworkServicesEdgeCacheServiceRoutingPathMatcherRouteRuleHeaderActionResponseHeaderToAdd[] | undefined;
    private _responseHeaderToRemove?;
    get responseHeaderToRemove(): NetworkServicesEdgeCacheServiceRoutingPathMatcherRouteRuleHeaderActionResponseHeaderToRemove[] | cdktf.IResolvable;
    set responseHeaderToRemove(value: NetworkServicesEdgeCacheServiceRoutingPathMatcherRouteRuleHeaderActionResponseHeaderToRemove[] | cdktf.IResolvable);
    resetResponseHeaderToRemove(): void;
    get responseHeaderToRemoveInput(): cdktf.IResolvable | NetworkServicesEdgeCacheServiceRoutingPathMatcherRouteRuleHeaderActionResponseHeaderToRemove[] | undefined;
}
export interface NetworkServicesEdgeCacheServiceRoutingPathMatcherRouteRuleMatchRuleHeaderMatch {
    /**
    * The value of the header should exactly match contents of exactMatch.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/network_services_edge_cache_service#exact_match NetworkServicesEdgeCacheService#exact_match}
    */
    readonly exactMatch?: string;
    /**
    * The header name to match on.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/network_services_edge_cache_service#header_name NetworkServicesEdgeCacheService#header_name}
    */
    readonly headerName: string;
    /**
    * If set to false (default), the headerMatch is considered a match if the match criteria above are met.
  If set to true, the headerMatch is considered a match if the match criteria above are NOT met.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/network_services_edge_cache_service#invert_match NetworkServicesEdgeCacheService#invert_match}
    */
    readonly invertMatch?: boolean | cdktf.IResolvable;
    /**
    * The value of the header must start with the contents of prefixMatch.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/network_services_edge_cache_service#prefix_match NetworkServicesEdgeCacheService#prefix_match}
    */
    readonly prefixMatch?: string;
    /**
    * A header with the contents of headerName must exist. The match takes place whether or not the request's header has a value.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/network_services_edge_cache_service#present_match NetworkServicesEdgeCacheService#present_match}
    */
    readonly presentMatch?: boolean | cdktf.IResolvable;
    /**
    * The value of the header must end with the contents of suffixMatch.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/network_services_edge_cache_service#suffix_match NetworkServicesEdgeCacheService#suffix_match}
    */
    readonly suffixMatch?: string;
}
export declare function networkServicesEdgeCacheServiceRoutingPathMatcherRouteRuleMatchRuleHeaderMatchToTerraform(struct?: NetworkServicesEdgeCacheServiceRoutingPathMatcherRouteRuleMatchRuleHeaderMatch | cdktf.IResolvable): any;
export interface NetworkServicesEdgeCacheServiceRoutingPathMatcherRouteRuleMatchRuleQueryParameterMatch {
    /**
    * The queryParameterMatch matches if the value of the parameter exactly matches the contents of exactMatch.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/network_services_edge_cache_service#exact_match NetworkServicesEdgeCacheService#exact_match}
    */
    readonly exactMatch?: string;
    /**
    * The name of the query parameter to match. The query parameter must exist in the request, in the absence of which the request match fails.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/network_services_edge_cache_service#name NetworkServicesEdgeCacheService#name}
    */
    readonly name: string;
    /**
    * Specifies that the queryParameterMatch matches if the request contains the query parameter, irrespective of whether the parameter has a value or not.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/network_services_edge_cache_service#present_match NetworkServicesEdgeCacheService#present_match}
    */
    readonly presentMatch?: boolean | cdktf.IResolvable;
}
export declare function networkServicesEdgeCacheServiceRoutingPathMatcherRouteRuleMatchRuleQueryParameterMatchToTerraform(struct?: NetworkServicesEdgeCacheServiceRoutingPathMatcherRouteRuleMatchRuleQueryParameterMatch | cdktf.IResolvable): any;
export interface NetworkServicesEdgeCacheServiceRoutingPathMatcherRouteRuleMatchRule {
    /**
    * For satisfying the matchRule condition, the path of the request must exactly match the value specified in fullPathMatch after removing any query parameters and anchor that may be part of the original URL.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/network_services_edge_cache_service#full_path_match NetworkServicesEdgeCacheService#full_path_match}
    */
    readonly fullPathMatch?: string;
    /**
    * Specifies that prefixMatch and fullPathMatch matches are case sensitive.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/network_services_edge_cache_service#ignore_case NetworkServicesEdgeCacheService#ignore_case}
    */
    readonly ignoreCase?: boolean | cdktf.IResolvable;
    /**
    * For satisfying the matchRule condition, the path of the request
  must match the wildcard pattern specified in pathTemplateMatch
  after removing any query parameters and anchor that may be part
  of the original URL.
  
  pathTemplateMatch must be between 1 and 255 characters
  (inclusive).  The pattern specified by pathTemplateMatch may
  have at most 5 wildcard operators and at most 5 variable
  captures in total.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/network_services_edge_cache_service#path_template_match NetworkServicesEdgeCacheService#path_template_match}
    */
    readonly pathTemplateMatch?: string;
    /**
    * For satisfying the matchRule condition, the request's path must begin with the specified prefixMatch. prefixMatch must begin with a /.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/network_services_edge_cache_service#prefix_match NetworkServicesEdgeCacheService#prefix_match}
    */
    readonly prefixMatch?: string;
    /**
    * header_match block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/network_services_edge_cache_service#header_match NetworkServicesEdgeCacheService#header_match}
    */
    readonly headerMatch?: NetworkServicesEdgeCacheServiceRoutingPathMatcherRouteRuleMatchRuleHeaderMatch[] | cdktf.IResolvable;
    /**
    * query_parameter_match block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/network_services_edge_cache_service#query_parameter_match NetworkServicesEdgeCacheService#query_parameter_match}
    */
    readonly queryParameterMatch?: NetworkServicesEdgeCacheServiceRoutingPathMatcherRouteRuleMatchRuleQueryParameterMatch[] | cdktf.IResolvable;
}
export declare function networkServicesEdgeCacheServiceRoutingPathMatcherRouteRuleMatchRuleToTerraform(struct?: NetworkServicesEdgeCacheServiceRoutingPathMatcherRouteRuleMatchRule | cdktf.IResolvable): any;
export interface NetworkServicesEdgeCacheServiceRoutingPathMatcherRouteRuleRouteActionCdnPolicyCacheKeyPolicy {
    /**
    * If true, requests to different hosts will be cached separately.
  
  Note: this should only be enabled if hosts share the same origin and content. Removing the host from the cache key may inadvertently result in different objects being cached than intended, depending on which route the first user matched.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/network_services_edge_cache_service#exclude_host NetworkServicesEdgeCacheService#exclude_host}
    */
    readonly excludeHost?: boolean | cdktf.IResolvable;
    /**
    * If true, exclude query string parameters from the cache key
  
  If false (the default), include the query string parameters in
  the cache key according to includeQueryParameters and
  excludeQueryParameters. If neither includeQueryParameters nor
  excludeQueryParameters is set, the entire query string will be
  included.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/network_services_edge_cache_service#exclude_query_string NetworkServicesEdgeCacheService#exclude_query_string}
    */
    readonly excludeQueryString?: boolean | cdktf.IResolvable;
    /**
    * Names of query string parameters to exclude from cache keys. All other parameters will be included.
  
  Either specify includedQueryParameters or excludedQueryParameters, not both. '&' and '=' will be percent encoded and not treated as delimiters.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/network_services_edge_cache_service#excluded_query_parameters NetworkServicesEdgeCacheService#excluded_query_parameters}
    */
    readonly excludedQueryParameters?: string[];
    /**
    * If true, http and https requests will be cached separately.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/network_services_edge_cache_service#include_protocol NetworkServicesEdgeCacheService#include_protocol}
    */
    readonly includeProtocol?: boolean | cdktf.IResolvable;
    /**
    * Names of Cookies to include in cache keys.  The cookie name and cookie value of each cookie named will be used as part of the cache key.
  
  Cookie names:
    - must be valid RFC 6265 "cookie-name" tokens
    - are case sensitive
    - cannot start with "Edge-Cache-" (case insensitive)
  
    Note that specifying several cookies, and/or cookies that have a large range of values (e.g., per-user) will dramatically impact the cache hit rate, and may result in a higher eviction rate and reduced performance.
  
    You may specify up to three cookie names.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/network_services_edge_cache_service#included_cookie_names NetworkServicesEdgeCacheService#included_cookie_names}
    */
    readonly includedCookieNames?: string[];
    /**
    * Names of HTTP request headers to include in cache keys. The value of the header field will be used as part of the cache key.
  
  - Header names must be valid HTTP RFC 7230 header field values.
  - Header field names are case insensitive
  - To include the HTTP method, use ":method"
  
  Note that specifying several headers, and/or headers that have a large range of values (e.g. per-user) will dramatically impact the cache hit rate, and may result in a higher eviction rate and reduced performance.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/network_services_edge_cache_service#included_header_names NetworkServicesEdgeCacheService#included_header_names}
    */
    readonly includedHeaderNames?: string[];
    /**
    * Names of query string parameters to include in cache keys. All other parameters will be excluded.
  
  Either specify includedQueryParameters or excludedQueryParameters, not both. '&' and '=' will be percent encoded and not treated as delimiters.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/network_services_edge_cache_service#included_query_parameters NetworkServicesEdgeCacheService#included_query_parameters}
    */
    readonly includedQueryParameters?: string[];
}
export declare function networkServicesEdgeCacheServiceRoutingPathMatcherRouteRuleRouteActionCdnPolicyCacheKeyPolicyToTerraform(struct?: NetworkServicesEdgeCacheServiceRoutingPathMatcherRouteRuleRouteActionCdnPolicyCacheKeyPolicyOutputReference | NetworkServicesEdgeCacheServiceRoutingPathMatcherRouteRuleRouteActionCdnPolicyCacheKeyPolicy): any;
export declare class NetworkServicesEdgeCacheServiceRoutingPathMatcherRouteRuleRouteActionCdnPolicyCacheKeyPolicyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): NetworkServicesEdgeCacheServiceRoutingPathMatcherRouteRuleRouteActionCdnPolicyCacheKeyPolicy | undefined;
    set internalValue(value: NetworkServicesEdgeCacheServiceRoutingPathMatcherRouteRuleRouteActionCdnPolicyCacheKeyPolicy | undefined);
    private _excludeHost?;
    get excludeHost(): boolean | cdktf.IResolvable;
    set excludeHost(value: boolean | cdktf.IResolvable);
    resetExcludeHost(): void;
    get excludeHostInput(): boolean | cdktf.IResolvable | undefined;
    private _excludeQueryString?;
    get excludeQueryString(): boolean | cdktf.IResolvable;
    set excludeQueryString(value: boolean | cdktf.IResolvable);
    resetExcludeQueryString(): void;
    get excludeQueryStringInput(): boolean | cdktf.IResolvable | undefined;
    private _excludedQueryParameters?;
    get excludedQueryParameters(): string[];
    set excludedQueryParameters(value: string[]);
    resetExcludedQueryParameters(): void;
    get excludedQueryParametersInput(): string[] | undefined;
    private _includeProtocol?;
    get includeProtocol(): boolean | cdktf.IResolvable;
    set includeProtocol(value: boolean | cdktf.IResolvable);
    resetIncludeProtocol(): void;
    get includeProtocolInput(): boolean | cdktf.IResolvable | undefined;
    private _includedCookieNames?;
    get includedCookieNames(): string[];
    set includedCookieNames(value: string[]);
    resetIncludedCookieNames(): void;
    get includedCookieNamesInput(): string[] | undefined;
    private _includedHeaderNames?;
    get includedHeaderNames(): string[];
    set includedHeaderNames(value: string[]);
    resetIncludedHeaderNames(): void;
    get includedHeaderNamesInput(): string[] | undefined;
    private _includedQueryParameters?;
    get includedQueryParameters(): string[];
    set includedQueryParameters(value: string[]);
    resetIncludedQueryParameters(): void;
    get includedQueryParametersInput(): string[] | undefined;
}
export interface NetworkServicesEdgeCacheServiceRoutingPathMatcherRouteRuleRouteActionCdnPolicy {
    /**
    * Cache modes allow users to control the behaviour of the cache, what content it should cache automatically, whether to respect origin headers, or whether to unconditionally cache all responses.
  
  For all cache modes, Cache-Control headers will be passed to the client. Use clientTtl to override what is sent to the client. Possible values: ["CACHE_ALL_STATIC", "USE_ORIGIN_HEADERS", "FORCE_CACHE_ALL", "BYPASS_CACHE"]
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/network_services_edge_cache_service#cache_mode NetworkServicesEdgeCacheService#cache_mode}
    */
    readonly cacheMode?: string;
    /**
    * Specifies a separate client (e.g. browser client) TTL, separate from the TTL used by the edge caches. Leaving this empty will use the same cache TTL for both the CDN and the client-facing response.
  
  - The TTL must be > 0 and <= 86400s (1 day)
  - The clientTtl cannot be larger than the defaultTtl (if set)
  - Fractions of a second are not allowed.
  
  Omit this field to use the defaultTtl, or the max-age set by the origin, as the client-facing TTL.
  
  When the cache mode is set to "USE_ORIGIN_HEADERS" or "BYPASS_CACHE", you must omit this field.
  A duration in seconds terminated by 's'. Example: "3s".
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/network_services_edge_cache_service#client_ttl NetworkServicesEdgeCacheService#client_ttl}
    */
    readonly clientTtl?: string;
    /**
    * Specifies the default TTL for cached content served by this origin for responses that do not have an existing valid TTL (max-age or s-max-age).
  
  Defaults to 3600s (1 hour).
  
  - The TTL must be >= 0 and <= 31,536,000 seconds (1 year)
  - Setting a TTL of "0" means "always revalidate" (equivalent to must-revalidate)
  - The value of defaultTTL cannot be set to a value greater than that of maxTTL.
  - Fractions of a second are not allowed.
  - When the cacheMode is set to FORCE_CACHE_ALL, the defaultTTL will overwrite the TTL set in all responses.
  
  Note that infrequently accessed objects may be evicted from the cache before the defined TTL. Objects that expire will be revalidated with the origin.
  
  When the cache mode is set to "USE_ORIGIN_HEADERS" or "BYPASS_CACHE", you must omit this field.
  
  A duration in seconds terminated by 's'. Example: "3s".
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/network_services_edge_cache_service#default_ttl NetworkServicesEdgeCacheService#default_ttl}
    */
    readonly defaultTtl?: string;
    /**
    * Specifies the maximum allowed TTL for cached content served by this origin.
  
  Defaults to 86400s (1 day).
  
  Cache directives that attempt to set a max-age or s-maxage higher than this, or an Expires header more than maxTtl seconds in the future will be capped at the value of maxTTL, as if it were the value of an s-maxage Cache-Control directive.
  
  - The TTL must be >= 0 and <= 31,536,000 seconds (1 year)
  - Setting a TTL of "0" means "always revalidate"
  - The value of maxTtl must be equal to or greater than defaultTtl.
  - Fractions of a second are not allowed.
  
  When the cache mode is set to "USE_ORIGIN_HEADERS", "FORCE_CACHE_ALL", or "BYPASS_CACHE", you must omit this field.
  
  A duration in seconds terminated by 's'. Example: "3s".
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/network_services_edge_cache_service#max_ttl NetworkServicesEdgeCacheService#max_ttl}
    */
    readonly maxTtl?: string;
    /**
    * Negative caching allows per-status code TTLs to be set, in order to apply fine-grained caching for common errors or redirects. This can reduce the load on your origin and improve end-user experience by reducing response latency.
  
  By default, the CDNPolicy will apply the following default TTLs to these status codes:
  
  - HTTP 300 (Multiple Choice), 301, 308 (Permanent Redirects): 10m
  - HTTP 404 (Not Found), 410 (Gone), 451 (Unavailable For Legal Reasons): 120s
  - HTTP 405 (Method Not Found), 414 (URI Too Long), 501 (Not Implemented): 60s
  
  These defaults can be overridden in negativeCachingPolicy
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/network_services_edge_cache_service#negative_caching NetworkServicesEdgeCacheService#negative_caching}
    */
    readonly negativeCaching?: boolean | cdktf.IResolvable;
    /**
    * Sets a cache TTL for the specified HTTP status code. negativeCaching must be enabled to configure negativeCachingPolicy.
  
  - Omitting the policy and leaving negativeCaching enabled will use the default TTLs for each status code, defined in negativeCaching.
  - TTLs must be >= 0 (where 0 is "always revalidate") and <= 86400s (1 day)
  
  Note that when specifying an explicit negativeCachingPolicy, you should take care to specify a cache TTL for all response codes that you wish to cache. The CDNPolicy will not apply any default negative caching when a policy exists.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/network_services_edge_cache_service#negative_caching_policy NetworkServicesEdgeCacheService#negative_caching_policy}
    */
    readonly negativeCachingPolicy?: {
        [key: string]: string;
    };
    /**
    * The EdgeCacheKeyset containing the set of public keys used to validate signed requests at the edge.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/network_services_edge_cache_service#signed_request_keyset NetworkServicesEdgeCacheService#signed_request_keyset}
    */
    readonly signedRequestKeyset?: string;
    /**
    * Whether to enforce signed requests. The default value is DISABLED, which means all content is public, and does not authorize access.
  
  You must also set a signedRequestKeyset to enable signed requests.
  
  When set to REQUIRE_SIGNATURES, all matching requests will have their signature validated. Requests that were not signed with the corresponding private key, or that are otherwise invalid (expired, do not match the signature, IP address, or header) will be rejected with a HTTP 403 and (if enabled) logged. Possible values: ["DISABLED", "REQUIRE_SIGNATURES"]
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/network_services_edge_cache_service#signed_request_mode NetworkServicesEdgeCacheService#signed_request_mode}
    */
    readonly signedRequestMode?: string;
    /**
    * cache_key_policy block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/network_services_edge_cache_service#cache_key_policy NetworkServicesEdgeCacheService#cache_key_policy}
    */
    readonly cacheKeyPolicy?: NetworkServicesEdgeCacheServiceRoutingPathMatcherRouteRuleRouteActionCdnPolicyCacheKeyPolicy;
}
export declare function networkServicesEdgeCacheServiceRoutingPathMatcherRouteRuleRouteActionCdnPolicyToTerraform(struct?: NetworkServicesEdgeCacheServiceRoutingPathMatcherRouteRuleRouteActionCdnPolicyOutputReference | NetworkServicesEdgeCacheServiceRoutingPathMatcherRouteRuleRouteActionCdnPolicy): any;
export declare class NetworkServicesEdgeCacheServiceRoutingPathMatcherRouteRuleRouteActionCdnPolicyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): NetworkServicesEdgeCacheServiceRoutingPathMatcherRouteRuleRouteActionCdnPolicy | undefined;
    set internalValue(value: NetworkServicesEdgeCacheServiceRoutingPathMatcherRouteRuleRouteActionCdnPolicy | undefined);
    private _cacheMode?;
    get cacheMode(): string;
    set cacheMode(value: string);
    resetCacheMode(): void;
    get cacheModeInput(): string | undefined;
    private _clientTtl?;
    get clientTtl(): string;
    set clientTtl(value: string);
    resetClientTtl(): void;
    get clientTtlInput(): string | undefined;
    private _defaultTtl?;
    get defaultTtl(): string;
    set defaultTtl(value: string);
    resetDefaultTtl(): void;
    get defaultTtlInput(): string | undefined;
    private _maxTtl?;
    get maxTtl(): string;
    set maxTtl(value: string);
    resetMaxTtl(): void;
    get maxTtlInput(): string | undefined;
    private _negativeCaching?;
    get negativeCaching(): boolean | cdktf.IResolvable;
    set negativeCaching(value: boolean | cdktf.IResolvable);
    resetNegativeCaching(): void;
    get negativeCachingInput(): boolean | cdktf.IResolvable | undefined;
    private _negativeCachingPolicy?;
    get negativeCachingPolicy(): {
        [key: string]: string;
    };
    set negativeCachingPolicy(value: {
        [key: string]: string;
    });
    resetNegativeCachingPolicy(): void;
    get negativeCachingPolicyInput(): {
        [key: string]: string;
    } | undefined;
    private _signedRequestKeyset?;
    get signedRequestKeyset(): string;
    set signedRequestKeyset(value: string);
    resetSignedRequestKeyset(): void;
    get signedRequestKeysetInput(): string | undefined;
    private _signedRequestMode?;
    get signedRequestMode(): string;
    set signedRequestMode(value: string);
    resetSignedRequestMode(): void;
    get signedRequestModeInput(): string | undefined;
    private _cacheKeyPolicy;
    get cacheKeyPolicy(): NetworkServicesEdgeCacheServiceRoutingPathMatcherRouteRuleRouteActionCdnPolicyCacheKeyPolicyOutputReference;
    putCacheKeyPolicy(value: NetworkServicesEdgeCacheServiceRoutingPathMatcherRouteRuleRouteActionCdnPolicyCacheKeyPolicy): void;
    resetCacheKeyPolicy(): void;
    get cacheKeyPolicyInput(): NetworkServicesEdgeCacheServiceRoutingPathMatcherRouteRuleRouteActionCdnPolicyCacheKeyPolicy | undefined;
}
export interface NetworkServicesEdgeCacheServiceRoutingPathMatcherRouteRuleRouteActionCorsPolicy {
    /**
    * In response to a preflight request, setting this to true indicates that the actual request can include user credentials.
  
  This translates to the Access-Control-Allow-Credentials response header.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/network_services_edge_cache_service#allow_credentials NetworkServicesEdgeCacheService#allow_credentials}
    */
    readonly allowCredentials?: boolean | cdktf.IResolvable;
    /**
    * Specifies the content for the Access-Control-Allow-Headers response header.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/network_services_edge_cache_service#allow_headers NetworkServicesEdgeCacheService#allow_headers}
    */
    readonly allowHeaders?: string[];
    /**
    * Specifies the content for the Access-Control-Allow-Methods response header.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/network_services_edge_cache_service#allow_methods NetworkServicesEdgeCacheService#allow_methods}
    */
    readonly allowMethods?: string[];
    /**
    * Specifies the list of origins that will be allowed to do CORS requests.
  
  This translates to the Access-Control-Allow-Origin response header.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/network_services_edge_cache_service#allow_origins NetworkServicesEdgeCacheService#allow_origins}
    */
    readonly allowOrigins?: string[];
    /**
    * If true, specifies the CORS policy is disabled. The default value is false, which indicates that the CORS policy is in effect.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/network_services_edge_cache_service#disabled NetworkServicesEdgeCacheService#disabled}
    */
    readonly disabled?: boolean | cdktf.IResolvable;
    /**
    * Specifies the content for the Access-Control-Allow-Headers response header.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/network_services_edge_cache_service#expose_headers NetworkServicesEdgeCacheService#expose_headers}
    */
    readonly exposeHeaders?: string[];
    /**
    * Specifies how long results of a preflight request can be cached by a client in seconds. Note that many browser clients enforce a maximum TTL of 600s (10 minutes).
  
  - Setting the value to -1 forces a pre-flight check for all requests (not recommended)
  - A maximum TTL of 86400s can be set, but note that (as above) some clients may force pre-flight checks at a more regular interval.
  - This translates to the Access-Control-Max-Age header.
  
  A duration in seconds with up to nine fractional digits, terminated by 's'. Example: "3.5s".
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/network_services_edge_cache_service#max_age NetworkServicesEdgeCacheService#max_age}
    */
    readonly maxAge: string;
}
export declare function networkServicesEdgeCacheServiceRoutingPathMatcherRouteRuleRouteActionCorsPolicyToTerraform(struct?: NetworkServicesEdgeCacheServiceRoutingPathMatcherRouteRuleRouteActionCorsPolicyOutputReference | NetworkServicesEdgeCacheServiceRoutingPathMatcherRouteRuleRouteActionCorsPolicy): any;
export declare class NetworkServicesEdgeCacheServiceRoutingPathMatcherRouteRuleRouteActionCorsPolicyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): NetworkServicesEdgeCacheServiceRoutingPathMatcherRouteRuleRouteActionCorsPolicy | undefined;
    set internalValue(value: NetworkServicesEdgeCacheServiceRoutingPathMatcherRouteRuleRouteActionCorsPolicy | undefined);
    private _allowCredentials?;
    get allowCredentials(): boolean | cdktf.IResolvable;
    set allowCredentials(value: boolean | cdktf.IResolvable);
    resetAllowCredentials(): void;
    get allowCredentialsInput(): boolean | cdktf.IResolvable | undefined;
    private _allowHeaders?;
    get allowHeaders(): string[];
    set allowHeaders(value: string[]);
    resetAllowHeaders(): void;
    get allowHeadersInput(): string[] | undefined;
    private _allowMethods?;
    get allowMethods(): string[];
    set allowMethods(value: string[]);
    resetAllowMethods(): void;
    get allowMethodsInput(): string[] | undefined;
    private _allowOrigins?;
    get allowOrigins(): string[];
    set allowOrigins(value: string[]);
    resetAllowOrigins(): void;
    get allowOriginsInput(): string[] | undefined;
    private _disabled?;
    get disabled(): boolean | cdktf.IResolvable;
    set disabled(value: boolean | cdktf.IResolvable);
    resetDisabled(): void;
    get disabledInput(): boolean | cdktf.IResolvable | undefined;
    private _exposeHeaders?;
    get exposeHeaders(): string[];
    set exposeHeaders(value: string[]);
    resetExposeHeaders(): void;
    get exposeHeadersInput(): string[] | undefined;
    private _maxAge?;
    get maxAge(): string;
    set maxAge(value: string);
    get maxAgeInput(): string | undefined;
}
export interface NetworkServicesEdgeCacheServiceRoutingPathMatcherRouteRuleRouteActionUrlRewrite {
    /**
    * Prior to forwarding the request to the selected origin, the request's host header is replaced with contents of hostRewrite.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/network_services_edge_cache_service#host_rewrite NetworkServicesEdgeCacheService#host_rewrite}
    */
    readonly hostRewrite?: string;
    /**
    * Prior to forwarding the request to the selected origin, the matching portion of the request's path is replaced by pathPrefixRewrite.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/network_services_edge_cache_service#path_prefix_rewrite NetworkServicesEdgeCacheService#path_prefix_rewrite}
    */
    readonly pathPrefixRewrite?: string;
    /**
    * Prior to forwarding the request to the selected origin, if the
  request matched a pathTemplateMatch, the matching portion of the
  request's path is replaced re-written using the pattern specified
  by pathTemplateRewrite.
  
  pathTemplateRewrite must be between 1 and 255 characters
  (inclusive), must start with a '/', and must only use variables
  captured by the route's pathTemplate matchers.
  
  pathTemplateRewrite may only be used when all of a route's
  MatchRules specify pathTemplate.
  
  Only one of pathPrefixRewrite and pathTemplateRewrite may be
  specified.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/network_services_edge_cache_service#path_template_rewrite NetworkServicesEdgeCacheService#path_template_rewrite}
    */
    readonly pathTemplateRewrite?: string;
}
export declare function networkServicesEdgeCacheServiceRoutingPathMatcherRouteRuleRouteActionUrlRewriteToTerraform(struct?: NetworkServicesEdgeCacheServiceRoutingPathMatcherRouteRuleRouteActionUrlRewriteOutputReference | NetworkServicesEdgeCacheServiceRoutingPathMatcherRouteRuleRouteActionUrlRewrite): any;
export declare class NetworkServicesEdgeCacheServiceRoutingPathMatcherRouteRuleRouteActionUrlRewriteOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): NetworkServicesEdgeCacheServiceRoutingPathMatcherRouteRuleRouteActionUrlRewrite | undefined;
    set internalValue(value: NetworkServicesEdgeCacheServiceRoutingPathMatcherRouteRuleRouteActionUrlRewrite | undefined);
    private _hostRewrite?;
    get hostRewrite(): string;
    set hostRewrite(value: string);
    resetHostRewrite(): void;
    get hostRewriteInput(): string | undefined;
    private _pathPrefixRewrite?;
    get pathPrefixRewrite(): string;
    set pathPrefixRewrite(value: string);
    resetPathPrefixRewrite(): void;
    get pathPrefixRewriteInput(): string | undefined;
    private _pathTemplateRewrite?;
    get pathTemplateRewrite(): string;
    set pathTemplateRewrite(value: string);
    resetPathTemplateRewrite(): void;
    get pathTemplateRewriteInput(): string | undefined;
}
export interface NetworkServicesEdgeCacheServiceRoutingPathMatcherRouteRuleRouteAction {
    /**
    * cdn_policy block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/network_services_edge_cache_service#cdn_policy NetworkServicesEdgeCacheService#cdn_policy}
    */
    readonly cdnPolicy?: NetworkServicesEdgeCacheServiceRoutingPathMatcherRouteRuleRouteActionCdnPolicy;
    /**
    * cors_policy block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/network_services_edge_cache_service#cors_policy NetworkServicesEdgeCacheService#cors_policy}
    */
    readonly corsPolicy?: NetworkServicesEdgeCacheServiceRoutingPathMatcherRouteRuleRouteActionCorsPolicy;
    /**
    * url_rewrite block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/network_services_edge_cache_service#url_rewrite NetworkServicesEdgeCacheService#url_rewrite}
    */
    readonly urlRewrite?: NetworkServicesEdgeCacheServiceRoutingPathMatcherRouteRuleRouteActionUrlRewrite;
}
export declare function networkServicesEdgeCacheServiceRoutingPathMatcherRouteRuleRouteActionToTerraform(struct?: NetworkServicesEdgeCacheServiceRoutingPathMatcherRouteRuleRouteActionOutputReference | NetworkServicesEdgeCacheServiceRoutingPathMatcherRouteRuleRouteAction): any;
export declare class NetworkServicesEdgeCacheServiceRoutingPathMatcherRouteRuleRouteActionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): NetworkServicesEdgeCacheServiceRoutingPathMatcherRouteRuleRouteAction | undefined;
    set internalValue(value: NetworkServicesEdgeCacheServiceRoutingPathMatcherRouteRuleRouteAction | undefined);
    private _cdnPolicy;
    get cdnPolicy(): NetworkServicesEdgeCacheServiceRoutingPathMatcherRouteRuleRouteActionCdnPolicyOutputReference;
    putCdnPolicy(value: NetworkServicesEdgeCacheServiceRoutingPathMatcherRouteRuleRouteActionCdnPolicy): void;
    resetCdnPolicy(): void;
    get cdnPolicyInput(): NetworkServicesEdgeCacheServiceRoutingPathMatcherRouteRuleRouteActionCdnPolicy | undefined;
    private _corsPolicy;
    get corsPolicy(): NetworkServicesEdgeCacheServiceRoutingPathMatcherRouteRuleRouteActionCorsPolicyOutputReference;
    putCorsPolicy(value: NetworkServicesEdgeCacheServiceRoutingPathMatcherRouteRuleRouteActionCorsPolicy): void;
    resetCorsPolicy(): void;
    get corsPolicyInput(): NetworkServicesEdgeCacheServiceRoutingPathMatcherRouteRuleRouteActionCorsPolicy | undefined;
    private _urlRewrite;
    get urlRewrite(): NetworkServicesEdgeCacheServiceRoutingPathMatcherRouteRuleRouteActionUrlRewriteOutputReference;
    putUrlRewrite(value: NetworkServicesEdgeCacheServiceRoutingPathMatcherRouteRuleRouteActionUrlRewrite): void;
    resetUrlRewrite(): void;
    get urlRewriteInput(): NetworkServicesEdgeCacheServiceRoutingPathMatcherRouteRuleRouteActionUrlRewrite | undefined;
}
export interface NetworkServicesEdgeCacheServiceRoutingPathMatcherRouteRuleUrlRedirect {
    /**
    * The host that will be used in the redirect response instead of the one that was supplied in the request.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/network_services_edge_cache_service#host_redirect NetworkServicesEdgeCacheService#host_redirect}
    */
    readonly hostRedirect?: string;
    /**
    * If set to true, the URL scheme in the redirected request is set to https. If set to false, the URL scheme of the redirected request will remain the same as that of the request.
  
  This can only be set if there is at least one (1) edgeSslCertificate set on the service.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/network_services_edge_cache_service#https_redirect NetworkServicesEdgeCacheService#https_redirect}
    */
    readonly httpsRedirect?: boolean | cdktf.IResolvable;
    /**
    * The path that will be used in the redirect response instead of the one that was supplied in the request.
  
  pathRedirect cannot be supplied together with prefixRedirect. Supply one alone or neither. If neither is supplied, the path of the original request will be used for the redirect.
  
  The path value must be between 1 and 1024 characters.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/network_services_edge_cache_service#path_redirect NetworkServicesEdgeCacheService#path_redirect}
    */
    readonly pathRedirect?: string;
    /**
    * The prefix that replaces the prefixMatch specified in the routeRule, retaining the remaining portion of the URL before redirecting the request.
  
  prefixRedirect cannot be supplied together with pathRedirect. Supply one alone or neither. If neither is supplied, the path of the original request will be used for the redirect.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/network_services_edge_cache_service#prefix_redirect NetworkServicesEdgeCacheService#prefix_redirect}
    */
    readonly prefixRedirect?: string;
    /**
    * The HTTP Status code to use for this RedirectAction.
  
  The supported values are:
  
  - 'MOVED_PERMANENTLY_DEFAULT', which is the default value and corresponds to 301.
  - 'FOUND', which corresponds to 302.
  - 'SEE_OTHER' which corresponds to 303.
  - 'TEMPORARY_REDIRECT', which corresponds to 307. in this case, the request method will be retained.
  - 'PERMANENT_REDIRECT', which corresponds to 308. in this case, the request method will be retained. Possible values: ["MOVED_PERMANENTLY_DEFAULT", "FOUND", "SEE_OTHER", "TEMPORARY_REDIRECT", "PERMANENT_REDIRECT"]
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/network_services_edge_cache_service#redirect_response_code NetworkServicesEdgeCacheService#redirect_response_code}
    */
    readonly redirectResponseCode?: string;
    /**
    * If set to true, any accompanying query portion of the original URL is removed prior to redirecting the request. If set to false, the query portion of the original URL is retained.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/network_services_edge_cache_service#strip_query NetworkServicesEdgeCacheService#strip_query}
    */
    readonly stripQuery?: boolean | cdktf.IResolvable;
}
export declare function networkServicesEdgeCacheServiceRoutingPathMatcherRouteRuleUrlRedirectToTerraform(struct?: NetworkServicesEdgeCacheServiceRoutingPathMatcherRouteRuleUrlRedirectOutputReference | NetworkServicesEdgeCacheServiceRoutingPathMatcherRouteRuleUrlRedirect): any;
export declare class NetworkServicesEdgeCacheServiceRoutingPathMatcherRouteRuleUrlRedirectOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): NetworkServicesEdgeCacheServiceRoutingPathMatcherRouteRuleUrlRedirect | undefined;
    set internalValue(value: NetworkServicesEdgeCacheServiceRoutingPathMatcherRouteRuleUrlRedirect | undefined);
    private _hostRedirect?;
    get hostRedirect(): string;
    set hostRedirect(value: string);
    resetHostRedirect(): void;
    get hostRedirectInput(): string | undefined;
    private _httpsRedirect?;
    get httpsRedirect(): boolean | cdktf.IResolvable;
    set httpsRedirect(value: boolean | cdktf.IResolvable);
    resetHttpsRedirect(): void;
    get httpsRedirectInput(): boolean | cdktf.IResolvable | undefined;
    private _pathRedirect?;
    get pathRedirect(): string;
    set pathRedirect(value: string);
    resetPathRedirect(): void;
    get pathRedirectInput(): string | undefined;
    private _prefixRedirect?;
    get prefixRedirect(): string;
    set prefixRedirect(value: string);
    resetPrefixRedirect(): void;
    get prefixRedirectInput(): string | undefined;
    private _redirectResponseCode?;
    get redirectResponseCode(): string;
    set redirectResponseCode(value: string);
    resetRedirectResponseCode(): void;
    get redirectResponseCodeInput(): string | undefined;
    private _stripQuery?;
    get stripQuery(): boolean | cdktf.IResolvable;
    set stripQuery(value: boolean | cdktf.IResolvable);
    resetStripQuery(): void;
    get stripQueryInput(): boolean | cdktf.IResolvable | undefined;
}
export interface NetworkServicesEdgeCacheServiceRoutingPathMatcherRouteRule {
    /**
    * A human-readable description of the routeRule.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/network_services_edge_cache_service#description NetworkServicesEdgeCacheService#description}
    */
    readonly description?: string;
    /**
    * The Origin resource that requests to this route should fetch from when a matching response is not in cache. Origins can be defined as short names ("my-origin") or fully-qualified resource URLs - e.g. "networkservices.googleapis.com/projects/my-project/global/edgecacheorigins/my-origin"
  
  Only one of origin or urlRedirect can be set.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/network_services_edge_cache_service#origin NetworkServicesEdgeCacheService#origin}
    */
    readonly origin?: string;
    /**
    * The priority of this route rule, where 1 is the highest priority.
  
  You cannot configure two or more routeRules with the same priority. Priority for each rule must be set to a number between 1 and 999 inclusive.
  
  Priority numbers can have gaps, which enable you to add or remove rules in the future without affecting the rest of the rules. For example, 1, 2, 3, 4, 5, 9, 12, 16 is a valid series of priority numbers
  to which you could add rules numbered from 6 to 8, 10 to 11, and 13 to 15 in the future without any impact on existing rules.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/network_services_edge_cache_service#priority NetworkServicesEdgeCacheService#priority}
    */
    readonly priority: string;
    /**
    * header_action block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/network_services_edge_cache_service#header_action NetworkServicesEdgeCacheService#header_action}
    */
    readonly headerAction?: NetworkServicesEdgeCacheServiceRoutingPathMatcherRouteRuleHeaderAction;
    /**
    * match_rule block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/network_services_edge_cache_service#match_rule NetworkServicesEdgeCacheService#match_rule}
    */
    readonly matchRule: NetworkServicesEdgeCacheServiceRoutingPathMatcherRouteRuleMatchRule[] | cdktf.IResolvable;
    /**
    * route_action block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/network_services_edge_cache_service#route_action NetworkServicesEdgeCacheService#route_action}
    */
    readonly routeAction?: NetworkServicesEdgeCacheServiceRoutingPathMatcherRouteRuleRouteAction;
    /**
    * url_redirect block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/network_services_edge_cache_service#url_redirect NetworkServicesEdgeCacheService#url_redirect}
    */
    readonly urlRedirect?: NetworkServicesEdgeCacheServiceRoutingPathMatcherRouteRuleUrlRedirect;
}
export declare function networkServicesEdgeCacheServiceRoutingPathMatcherRouteRuleToTerraform(struct?: NetworkServicesEdgeCacheServiceRoutingPathMatcherRouteRule | cdktf.IResolvable): any;
export interface NetworkServicesEdgeCacheServiceRoutingPathMatcher {
    /**
    * A human-readable description of the resource.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/network_services_edge_cache_service#description NetworkServicesEdgeCacheService#description}
    */
    readonly description?: string;
    /**
    * The name to which this PathMatcher is referred by the HostRule.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/network_services_edge_cache_service#name NetworkServicesEdgeCacheService#name}
    */
    readonly name: string;
    /**
    * route_rule block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/network_services_edge_cache_service#route_rule NetworkServicesEdgeCacheService#route_rule}
    */
    readonly routeRule: NetworkServicesEdgeCacheServiceRoutingPathMatcherRouteRule[] | cdktf.IResolvable;
}
export declare function networkServicesEdgeCacheServiceRoutingPathMatcherToTerraform(struct?: NetworkServicesEdgeCacheServiceRoutingPathMatcher | cdktf.IResolvable): any;
export interface NetworkServicesEdgeCacheServiceRouting {
    /**
    * host_rule block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/network_services_edge_cache_service#host_rule NetworkServicesEdgeCacheService#host_rule}
    */
    readonly hostRule: NetworkServicesEdgeCacheServiceRoutingHostRule[] | cdktf.IResolvable;
    /**
    * path_matcher block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/network_services_edge_cache_service#path_matcher NetworkServicesEdgeCacheService#path_matcher}
    */
    readonly pathMatcher: NetworkServicesEdgeCacheServiceRoutingPathMatcher[] | cdktf.IResolvable;
}
export declare function networkServicesEdgeCacheServiceRoutingToTerraform(struct?: NetworkServicesEdgeCacheServiceRoutingOutputReference | NetworkServicesEdgeCacheServiceRouting): any;
export declare class NetworkServicesEdgeCacheServiceRoutingOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): NetworkServicesEdgeCacheServiceRouting | undefined;
    set internalValue(value: NetworkServicesEdgeCacheServiceRouting | undefined);
    private _hostRule?;
    get hostRule(): NetworkServicesEdgeCacheServiceRoutingHostRule[] | cdktf.IResolvable;
    set hostRule(value: NetworkServicesEdgeCacheServiceRoutingHostRule[] | cdktf.IResolvable);
    get hostRuleInput(): cdktf.IResolvable | NetworkServicesEdgeCacheServiceRoutingHostRule[] | undefined;
    private _pathMatcher?;
    get pathMatcher(): NetworkServicesEdgeCacheServiceRoutingPathMatcher[] | cdktf.IResolvable;
    set pathMatcher(value: NetworkServicesEdgeCacheServiceRoutingPathMatcher[] | cdktf.IResolvable);
    get pathMatcherInput(): cdktf.IResolvable | NetworkServicesEdgeCacheServiceRoutingPathMatcher[] | undefined;
}
export interface NetworkServicesEdgeCacheServiceTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/network_services_edge_cache_service#create NetworkServicesEdgeCacheService#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/network_services_edge_cache_service#delete NetworkServicesEdgeCacheService#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/network_services_edge_cache_service#update NetworkServicesEdgeCacheService#update}
    */
    readonly update?: string;
}
export declare function networkServicesEdgeCacheServiceTimeoutsToTerraform(struct?: NetworkServicesEdgeCacheServiceTimeoutsOutputReference | NetworkServicesEdgeCacheServiceTimeouts | cdktf.IResolvable): any;
export declare class NetworkServicesEdgeCacheServiceTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): NetworkServicesEdgeCacheServiceTimeouts | undefined;
    set internalValue(value: NetworkServicesEdgeCacheServiceTimeouts | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google/r/network_services_edge_cache_service google_network_services_edge_cache_service}
*/
export declare class NetworkServicesEdgeCacheService extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_network_services_edge_cache_service";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google/r/network_services_edge_cache_service google_network_services_edge_cache_service} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options NetworkServicesEdgeCacheServiceConfig
    */
    constructor(scope: Construct, id: string, config: NetworkServicesEdgeCacheServiceConfig);
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _disableHttp2?;
    get disableHttp2(): boolean | cdktf.IResolvable;
    set disableHttp2(value: boolean | cdktf.IResolvable);
    resetDisableHttp2(): void;
    get disableHttp2Input(): boolean | cdktf.IResolvable | undefined;
    private _disableQuic?;
    get disableQuic(): boolean | cdktf.IResolvable;
    set disableQuic(value: boolean | cdktf.IResolvable);
    resetDisableQuic(): void;
    get disableQuicInput(): boolean | cdktf.IResolvable | undefined;
    private _edgeSecurityPolicy?;
    get edgeSecurityPolicy(): string;
    set edgeSecurityPolicy(value: string);
    resetEdgeSecurityPolicy(): void;
    get edgeSecurityPolicyInput(): string | undefined;
    private _edgeSslCertificates?;
    get edgeSslCertificates(): string[];
    set edgeSslCertificates(value: string[]);
    resetEdgeSslCertificates(): void;
    get edgeSslCertificatesInput(): string[] | undefined;
    get id(): string;
    get ipv4Addresses(): string[];
    get ipv6Addresses(): string[];
    private _labels?;
    get labels(): {
        [key: string]: string;
    };
    set labels(value: {
        [key: string]: string;
    });
    resetLabels(): void;
    get labelsInput(): {
        [key: string]: string;
    } | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _requireTls?;
    get requireTls(): boolean | cdktf.IResolvable;
    set requireTls(value: boolean | cdktf.IResolvable);
    resetRequireTls(): void;
    get requireTlsInput(): boolean | cdktf.IResolvable | undefined;
    private _sslPolicy?;
    get sslPolicy(): string;
    set sslPolicy(value: string);
    resetSslPolicy(): void;
    get sslPolicyInput(): string | undefined;
    private _logConfig;
    get logConfig(): NetworkServicesEdgeCacheServiceLogConfigOutputReference;
    putLogConfig(value: NetworkServicesEdgeCacheServiceLogConfig): void;
    resetLogConfig(): void;
    get logConfigInput(): NetworkServicesEdgeCacheServiceLogConfig | undefined;
    private _routing;
    get routing(): NetworkServicesEdgeCacheServiceRoutingOutputReference;
    putRouting(value: NetworkServicesEdgeCacheServiceRouting): void;
    get routingInput(): NetworkServicesEdgeCacheServiceRouting | undefined;
    private _timeouts;
    get timeouts(): NetworkServicesEdgeCacheServiceTimeoutsOutputReference;
    putTimeouts(value: NetworkServicesEdgeCacheServiceTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): NetworkServicesEdgeCacheServiceTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
