import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface SecretManagerSecretConfig extends cdktf.TerraformMetaArguments {
    /**
    * Timestamp in UTC when the Secret is scheduled to expire. This is always provided on output, regardless of what was sent on input.
  A timestamp in RFC3339 UTC "Zulu" format, with nanosecond resolution and up to nine fractional digits. Examples: "2014-10-02T15:01:23Z" and "2014-10-02T15:01:23.045123456Z".
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/secret_manager_secret#expire_time SecretManagerSecret#expire_time}
    */
    readonly expireTime?: string;
    /**
    * The labels assigned to this Secret.
  
  Label keys must be between 1 and 63 characters long, have a UTF-8 encoding of maximum 128 bytes,
  and must conform to the following PCRE regular expression: [\p{Ll}\p{Lo}][\p{Ll}\p{Lo}\p{N}_-]{0,62}
  
  Label values must be between 0 and 63 characters long, have a UTF-8 encoding of maximum 128 bytes,
  and must conform to the following PCRE regular expression: [\p{Ll}\p{Lo}\p{N}_-]{0,63}
  
  No more than 64 labels can be assigned to a given resource.
  
  An object containing a list of "key": value pairs. Example:
  { "name": "wrench", "mass": "1.3kg", "count": "3" }.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/secret_manager_secret#labels SecretManagerSecret#labels}
    */
    readonly labels?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/secret_manager_secret#project SecretManagerSecret#project}
    */
    readonly project?: string;
    /**
    * This must be unique within the project.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/secret_manager_secret#secret_id SecretManagerSecret#secret_id}
    */
    readonly secretId: string;
    /**
    * The TTL for the Secret.
  A duration in seconds with up to nine fractional digits, terminated by 's'. Example: "3.5s".
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/secret_manager_secret#ttl SecretManagerSecret#ttl}
    */
    readonly ttl?: string;
    /**
    * replication block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/secret_manager_secret#replication SecretManagerSecret#replication}
    */
    readonly replication: SecretManagerSecretReplication;
    /**
    * rotation block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/secret_manager_secret#rotation SecretManagerSecret#rotation}
    */
    readonly rotation?: SecretManagerSecretRotation;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/secret_manager_secret#timeouts SecretManagerSecret#timeouts}
    */
    readonly timeouts?: SecretManagerSecretTimeouts;
    /**
    * topics block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/secret_manager_secret#topics SecretManagerSecret#topics}
    */
    readonly topics?: SecretManagerSecretTopics[] | cdktf.IResolvable;
}
export interface SecretManagerSecretReplicationUserManagedReplicasCustomerManagedEncryption {
    /**
    * Describes the Cloud KMS encryption key that will be used to protect destination secret.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/secret_manager_secret#kms_key_name SecretManagerSecret#kms_key_name}
    */
    readonly kmsKeyName: string;
}
export declare function secretManagerSecretReplicationUserManagedReplicasCustomerManagedEncryptionToTerraform(struct?: SecretManagerSecretReplicationUserManagedReplicasCustomerManagedEncryptionOutputReference | SecretManagerSecretReplicationUserManagedReplicasCustomerManagedEncryption): any;
export declare class SecretManagerSecretReplicationUserManagedReplicasCustomerManagedEncryptionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): SecretManagerSecretReplicationUserManagedReplicasCustomerManagedEncryption | undefined;
    set internalValue(value: SecretManagerSecretReplicationUserManagedReplicasCustomerManagedEncryption | undefined);
    private _kmsKeyName?;
    get kmsKeyName(): string;
    set kmsKeyName(value: string);
    get kmsKeyNameInput(): string | undefined;
}
export interface SecretManagerSecretReplicationUserManagedReplicas {
    /**
    * The canonical IDs of the location to replicate data. For example: "us-east1".
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/secret_manager_secret#location SecretManagerSecret#location}
    */
    readonly location: string;
    /**
    * customer_managed_encryption block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/secret_manager_secret#customer_managed_encryption SecretManagerSecret#customer_managed_encryption}
    */
    readonly customerManagedEncryption?: SecretManagerSecretReplicationUserManagedReplicasCustomerManagedEncryption;
}
export declare function secretManagerSecretReplicationUserManagedReplicasToTerraform(struct?: SecretManagerSecretReplicationUserManagedReplicas | cdktf.IResolvable): any;
export interface SecretManagerSecretReplicationUserManaged {
    /**
    * replicas block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/secret_manager_secret#replicas SecretManagerSecret#replicas}
    */
    readonly replicas: SecretManagerSecretReplicationUserManagedReplicas[] | cdktf.IResolvable;
}
export declare function secretManagerSecretReplicationUserManagedToTerraform(struct?: SecretManagerSecretReplicationUserManagedOutputReference | SecretManagerSecretReplicationUserManaged): any;
export declare class SecretManagerSecretReplicationUserManagedOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): SecretManagerSecretReplicationUserManaged | undefined;
    set internalValue(value: SecretManagerSecretReplicationUserManaged | undefined);
    private _replicas?;
    get replicas(): SecretManagerSecretReplicationUserManagedReplicas[] | cdktf.IResolvable;
    set replicas(value: SecretManagerSecretReplicationUserManagedReplicas[] | cdktf.IResolvable);
    get replicasInput(): cdktf.IResolvable | SecretManagerSecretReplicationUserManagedReplicas[] | undefined;
}
export interface SecretManagerSecretReplication {
    /**
    * The Secret will automatically be replicated without any restrictions.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/secret_manager_secret#automatic SecretManagerSecret#automatic}
    */
    readonly automatic?: boolean | cdktf.IResolvable;
    /**
    * user_managed block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/secret_manager_secret#user_managed SecretManagerSecret#user_managed}
    */
    readonly userManaged?: SecretManagerSecretReplicationUserManaged;
}
export declare function secretManagerSecretReplicationToTerraform(struct?: SecretManagerSecretReplicationOutputReference | SecretManagerSecretReplication): any;
export declare class SecretManagerSecretReplicationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): SecretManagerSecretReplication | undefined;
    set internalValue(value: SecretManagerSecretReplication | undefined);
    private _automatic?;
    get automatic(): boolean | cdktf.IResolvable;
    set automatic(value: boolean | cdktf.IResolvable);
    resetAutomatic(): void;
    get automaticInput(): boolean | cdktf.IResolvable | undefined;
    private _userManaged;
    get userManaged(): SecretManagerSecretReplicationUserManagedOutputReference;
    putUserManaged(value: SecretManagerSecretReplicationUserManaged): void;
    resetUserManaged(): void;
    get userManagedInput(): SecretManagerSecretReplicationUserManaged | undefined;
}
export interface SecretManagerSecretRotation {
    /**
    * Timestamp in UTC at which the Secret is scheduled to rotate.
  A timestamp in RFC3339 UTC "Zulu" format, with nanosecond resolution and up to nine fractional digits. Examples: "2014-10-02T15:01:23Z" and "2014-10-02T15:01:23.045123456Z".
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/secret_manager_secret#next_rotation_time SecretManagerSecret#next_rotation_time}
    */
    readonly nextRotationTime?: string;
    /**
    * The Duration between rotation notifications. Must be in seconds and at least 3600s (1h) and at most 3153600000s (100 years).
  If rotationPeriod is set, 'next_rotation_time' must be set. 'next_rotation_time' will be advanced by this period when the service automatically sends rotation notifications.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/secret_manager_secret#rotation_period SecretManagerSecret#rotation_period}
    */
    readonly rotationPeriod?: string;
}
export declare function secretManagerSecretRotationToTerraform(struct?: SecretManagerSecretRotationOutputReference | SecretManagerSecretRotation): any;
export declare class SecretManagerSecretRotationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): SecretManagerSecretRotation | undefined;
    set internalValue(value: SecretManagerSecretRotation | undefined);
    private _nextRotationTime?;
    get nextRotationTime(): string;
    set nextRotationTime(value: string);
    resetNextRotationTime(): void;
    get nextRotationTimeInput(): string | undefined;
    private _rotationPeriod?;
    get rotationPeriod(): string;
    set rotationPeriod(value: string);
    resetRotationPeriod(): void;
    get rotationPeriodInput(): string | undefined;
}
export interface SecretManagerSecretTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/secret_manager_secret#create SecretManagerSecret#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/secret_manager_secret#delete SecretManagerSecret#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/secret_manager_secret#update SecretManagerSecret#update}
    */
    readonly update?: string;
}
export declare function secretManagerSecretTimeoutsToTerraform(struct?: SecretManagerSecretTimeoutsOutputReference | SecretManagerSecretTimeouts | cdktf.IResolvable): any;
export declare class SecretManagerSecretTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): SecretManagerSecretTimeouts | undefined;
    set internalValue(value: SecretManagerSecretTimeouts | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
export interface SecretManagerSecretTopics {
    /**
    * The resource name of the Pub/Sub topic that will be published to, in the following format: projects/*\/topics/*.
  For publication to succeed, the Secret Manager Service Agent service account must have pubsub.publisher permissions on the topic.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/secret_manager_secret#name SecretManagerSecret#name}
    */
    readonly name: string;
}
export declare function secretManagerSecretTopicsToTerraform(struct?: SecretManagerSecretTopics | cdktf.IResolvable): any;
/**
* Represents a {@link https://www.terraform.io/docs/providers/google/r/secret_manager_secret google_secret_manager_secret}
*/
export declare class SecretManagerSecret extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_secret_manager_secret";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google/r/secret_manager_secret google_secret_manager_secret} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options SecretManagerSecretConfig
    */
    constructor(scope: Construct, id: string, config: SecretManagerSecretConfig);
    get createTime(): string;
    private _expireTime?;
    get expireTime(): string;
    set expireTime(value: string);
    resetExpireTime(): void;
    get expireTimeInput(): string | undefined;
    get id(): string;
    private _labels?;
    get labels(): {
        [key: string]: string;
    };
    set labels(value: {
        [key: string]: string;
    });
    resetLabels(): void;
    get labelsInput(): {
        [key: string]: string;
    } | undefined;
    get name(): string;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _secretId?;
    get secretId(): string;
    set secretId(value: string);
    get secretIdInput(): string | undefined;
    private _ttl?;
    get ttl(): string;
    set ttl(value: string);
    resetTtl(): void;
    get ttlInput(): string | undefined;
    private _replication;
    get replication(): SecretManagerSecretReplicationOutputReference;
    putReplication(value: SecretManagerSecretReplication): void;
    get replicationInput(): SecretManagerSecretReplication | undefined;
    private _rotation;
    get rotation(): SecretManagerSecretRotationOutputReference;
    putRotation(value: SecretManagerSecretRotation): void;
    resetRotation(): void;
    get rotationInput(): SecretManagerSecretRotation | undefined;
    private _timeouts;
    get timeouts(): SecretManagerSecretTimeoutsOutputReference;
    putTimeouts(value: SecretManagerSecretTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): SecretManagerSecretTimeouts | undefined;
    private _topics?;
    get topics(): SecretManagerSecretTopics[] | cdktf.IResolvable;
    set topics(value: SecretManagerSecretTopics[] | cdktf.IResolvable);
    resetTopics(): void;
    get topicsInput(): cdktf.IResolvable | SecretManagerSecretTopics[] | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
