import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface StorageBucketObjectConfig extends cdktf.TerraformMetaArguments {
    /**
    * The name of the containing bucket.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_bucket_object#bucket StorageBucketObject#bucket}
    */
    readonly bucket: string;
    /**
    * Cache-Control directive to specify caching behavior of object data. If omitted and object is accessible to all anonymous users, the default will be public, max-age=3600
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_bucket_object#cache_control StorageBucketObject#cache_control}
    */
    readonly cacheControl?: string;
    /**
    * Data as string to be uploaded. Must be defined if source is not. Note: The content field is marked as sensitive. To view the raw contents of the object, please define an output.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_bucket_object#content StorageBucketObject#content}
    */
    readonly content?: string;
    /**
    * Content-Disposition of the object data.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_bucket_object#content_disposition StorageBucketObject#content_disposition}
    */
    readonly contentDisposition?: string;
    /**
    * Content-Encoding of the object data.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_bucket_object#content_encoding StorageBucketObject#content_encoding}
    */
    readonly contentEncoding?: string;
    /**
    * Content-Language of the object data.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_bucket_object#content_language StorageBucketObject#content_language}
    */
    readonly contentLanguage?: string;
    /**
    * Content-Type of the object data. Defaults to "application/octet-stream" or "text/plain; charset=utf-8".
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_bucket_object#content_type StorageBucketObject#content_type}
    */
    readonly contentType?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_bucket_object#detect_md5hash StorageBucketObject#detect_md5hash}
    */
    readonly detectMd5Hash?: string;
    /**
    * Whether an object is under event-based hold. Event-based hold is a way to retain objects until an event occurs, which is signified by the hold's release (i.e. this value is set to false). After being released (set to false), such objects will be subject to bucket-level retention (if any).
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_bucket_object#event_based_hold StorageBucketObject#event_based_hold}
    */
    readonly eventBasedHold?: boolean | cdktf.IResolvable;
    /**
    * Resource name of the Cloud KMS key that will be used to encrypt the object. Overrides the object metadata's kmsKeyName value, if any.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_bucket_object#kms_key_name StorageBucketObject#kms_key_name}
    */
    readonly kmsKeyName?: string;
    /**
    * User-provided metadata, in key/value pairs.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_bucket_object#metadata StorageBucketObject#metadata}
    */
    readonly metadata?: {
        [key: string]: string;
    };
    /**
    * The name of the object. If you're interpolating the name of this object, see output_name instead.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_bucket_object#name StorageBucketObject#name}
    */
    readonly name: string;
    /**
    * A path to the data you want to upload. Must be defined if content is not.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_bucket_object#source StorageBucketObject#source}
    */
    readonly source?: string;
    /**
    * The StorageClass of the new bucket object. Supported values include: MULTI_REGIONAL, REGIONAL, NEARLINE, COLDLINE, ARCHIVE. If not provided, this defaults to the bucket's default storage class or to a standard class.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_bucket_object#storage_class StorageBucketObject#storage_class}
    */
    readonly storageClass?: string;
    /**
    * Whether an object is under temporary hold. While this flag is set to true, the object is protected against deletion and overwrites.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_bucket_object#temporary_hold StorageBucketObject#temporary_hold}
    */
    readonly temporaryHold?: boolean | cdktf.IResolvable;
    /**
    * customer_encryption block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_bucket_object#customer_encryption StorageBucketObject#customer_encryption}
    */
    readonly customerEncryption?: StorageBucketObjectCustomerEncryption;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_bucket_object#timeouts StorageBucketObject#timeouts}
    */
    readonly timeouts?: StorageBucketObjectTimeouts;
}
export interface StorageBucketObjectCustomerEncryption {
    /**
    * The encryption algorithm. Default: AES256
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_bucket_object#encryption_algorithm StorageBucketObject#encryption_algorithm}
    */
    readonly encryptionAlgorithm?: string;
    /**
    * Base64 encoded customer supplied encryption key.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_bucket_object#encryption_key StorageBucketObject#encryption_key}
    */
    readonly encryptionKey: string;
}
export declare function storageBucketObjectCustomerEncryptionToTerraform(struct?: StorageBucketObjectCustomerEncryptionOutputReference | StorageBucketObjectCustomerEncryption): any;
export declare class StorageBucketObjectCustomerEncryptionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): StorageBucketObjectCustomerEncryption | undefined;
    set internalValue(value: StorageBucketObjectCustomerEncryption | undefined);
    private _encryptionAlgorithm?;
    get encryptionAlgorithm(): string;
    set encryptionAlgorithm(value: string);
    resetEncryptionAlgorithm(): void;
    get encryptionAlgorithmInput(): string | undefined;
    private _encryptionKey?;
    get encryptionKey(): string;
    set encryptionKey(value: string);
    get encryptionKeyInput(): string | undefined;
}
export interface StorageBucketObjectTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_bucket_object#create StorageBucketObject#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_bucket_object#delete StorageBucketObject#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_bucket_object#update StorageBucketObject#update}
    */
    readonly update?: string;
}
export declare function storageBucketObjectTimeoutsToTerraform(struct?: StorageBucketObjectTimeoutsOutputReference | StorageBucketObjectTimeouts | cdktf.IResolvable): any;
export declare class StorageBucketObjectTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): StorageBucketObjectTimeouts | undefined;
    set internalValue(value: StorageBucketObjectTimeouts | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google/r/storage_bucket_object google_storage_bucket_object}
*/
export declare class StorageBucketObject extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_storage_bucket_object";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google/r/storage_bucket_object google_storage_bucket_object} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options StorageBucketObjectConfig
    */
    constructor(scope: Construct, id: string, config: StorageBucketObjectConfig);
    private _bucket?;
    get bucket(): string;
    set bucket(value: string);
    get bucketInput(): string | undefined;
    private _cacheControl?;
    get cacheControl(): string;
    set cacheControl(value: string);
    resetCacheControl(): void;
    get cacheControlInput(): string | undefined;
    private _content?;
    get content(): string;
    set content(value: string);
    resetContent(): void;
    get contentInput(): string | undefined;
    private _contentDisposition?;
    get contentDisposition(): string;
    set contentDisposition(value: string);
    resetContentDisposition(): void;
    get contentDispositionInput(): string | undefined;
    private _contentEncoding?;
    get contentEncoding(): string;
    set contentEncoding(value: string);
    resetContentEncoding(): void;
    get contentEncodingInput(): string | undefined;
    private _contentLanguage?;
    get contentLanguage(): string;
    set contentLanguage(value: string);
    resetContentLanguage(): void;
    get contentLanguageInput(): string | undefined;
    private _contentType?;
    get contentType(): string;
    set contentType(value: string);
    resetContentType(): void;
    get contentTypeInput(): string | undefined;
    get crc32C(): string;
    private _detectMd5Hash?;
    get detectMd5Hash(): string;
    set detectMd5Hash(value: string);
    resetDetectMd5Hash(): void;
    get detectMd5HashInput(): string | undefined;
    private _eventBasedHold?;
    get eventBasedHold(): boolean | cdktf.IResolvable;
    set eventBasedHold(value: boolean | cdktf.IResolvable);
    resetEventBasedHold(): void;
    get eventBasedHoldInput(): boolean | cdktf.IResolvable | undefined;
    get id(): string;
    private _kmsKeyName?;
    get kmsKeyName(): string;
    set kmsKeyName(value: string);
    resetKmsKeyName(): void;
    get kmsKeyNameInput(): string | undefined;
    get md5Hash(): string;
    get mediaLink(): string;
    private _metadata?;
    get metadata(): {
        [key: string]: string;
    };
    set metadata(value: {
        [key: string]: string;
    });
    resetMetadata(): void;
    get metadataInput(): {
        [key: string]: string;
    } | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    get outputName(): string;
    get selfLink(): string;
    private _source?;
    get source(): string;
    set source(value: string);
    resetSource(): void;
    get sourceInput(): string | undefined;
    private _storageClass?;
    get storageClass(): string;
    set storageClass(value: string);
    resetStorageClass(): void;
    get storageClassInput(): string | undefined;
    private _temporaryHold?;
    get temporaryHold(): boolean | cdktf.IResolvable;
    set temporaryHold(value: boolean | cdktf.IResolvable);
    resetTemporaryHold(): void;
    get temporaryHoldInput(): boolean | cdktf.IResolvable | undefined;
    private _customerEncryption;
    get customerEncryption(): StorageBucketObjectCustomerEncryptionOutputReference;
    putCustomerEncryption(value: StorageBucketObjectCustomerEncryption): void;
    resetCustomerEncryption(): void;
    get customerEncryptionInput(): StorageBucketObjectCustomerEncryption | undefined;
    private _timeouts;
    get timeouts(): StorageBucketObjectTimeoutsOutputReference;
    putTimeouts(value: StorageBucketObjectTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): StorageBucketObjectTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
