import * as cdk from '@aws-cdk/core';
/**
 * Properties for defining a `AWS::GameLift::Alias`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gamelift-alias.html
 * @external
 */
export interface CfnAliasProps {
    /**
     * `AWS::GameLift::Alias.Name`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gamelift-alias.html#cfn-gamelift-alias-name
     * @external
     */
    readonly name: string;
    /**
     * `AWS::GameLift::Alias.RoutingStrategy`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gamelift-alias.html#cfn-gamelift-alias-routingstrategy
     * @external
     */
    readonly routingStrategy: CfnAlias.RoutingStrategyProperty | cdk.IResolvable;
    /**
     * `AWS::GameLift::Alias.Description`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gamelift-alias.html#cfn-gamelift-alias-description
     * @external
     */
    readonly description?: string;
}
/**
 * A CloudFormation `AWS::GameLift::Alias`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gamelift-alias.html
 * @external
 * @cloudformationResource AWS::GameLift::Alias
 */
export declare class CfnAlias extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::GameLift::Alias";
    /**
     * @external
     * @cloudformationAttribute AliasId
     */
    readonly attrAliasId: string;
    /**
     * `AWS::GameLift::Alias.Name`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gamelift-alias.html#cfn-gamelift-alias-name
     * @external
     */
    name: string;
    /**
     * `AWS::GameLift::Alias.RoutingStrategy`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gamelift-alias.html#cfn-gamelift-alias-routingstrategy
     * @external
     */
    routingStrategy: CfnAlias.RoutingStrategyProperty | cdk.IResolvable;
    /**
     * `AWS::GameLift::Alias.Description`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gamelift-alias.html#cfn-gamelift-alias-description
     * @external
     */
    description: string | undefined;
    /**
     * Create a new `AWS::GameLift::Alias`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnAliasProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::GameLift::Alias`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gamelift-alias.html
 * @external
 * @cloudformationResource AWS::GameLift::Alias
 */
export declare namespace CfnAlias {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-gamelift-alias-routingstrategy.html
     * @external
     */
    interface RoutingStrategyProperty {
        /**
         * `CfnAlias.RoutingStrategyProperty.FleetId`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-gamelift-alias-routingstrategy.html#cfn-gamelift-alias-routingstrategy-fleetid
         * @external
         */
        readonly fleetId?: string;
        /**
         * `CfnAlias.RoutingStrategyProperty.Message`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-gamelift-alias-routingstrategy.html#cfn-gamelift-alias-routingstrategy-message
         * @external
         */
        readonly message?: string;
        /**
         * `CfnAlias.RoutingStrategyProperty.Type`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-gamelift-alias-routingstrategy.html#cfn-gamelift-alias-routingstrategy-type
         * @external
         */
        readonly type?: string;
    }
}
/**
 * Properties for defining a `AWS::GameLift::Build`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gamelift-build.html
 * @external
 */
export interface CfnBuildProps {
    /**
     * `AWS::GameLift::Build.Name`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gamelift-build.html#cfn-gamelift-build-name
     * @external
     */
    readonly name?: string;
    /**
     * `AWS::GameLift::Build.OperatingSystem`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gamelift-build.html#cfn-gamelift-build-operatingsystem
     * @external
     */
    readonly operatingSystem?: string;
    /**
     * `AWS::GameLift::Build.StorageLocation`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gamelift-build.html#cfn-gamelift-build-storagelocation
     * @external
     */
    readonly storageLocation?: CfnBuild.S3LocationProperty | cdk.IResolvable;
    /**
     * `AWS::GameLift::Build.Version`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gamelift-build.html#cfn-gamelift-build-version
     * @external
     */
    readonly version?: string;
}
/**
 * A CloudFormation `AWS::GameLift::Build`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gamelift-build.html
 * @external
 * @cloudformationResource AWS::GameLift::Build
 */
export declare class CfnBuild extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::GameLift::Build";
    /**
     * `AWS::GameLift::Build.Name`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gamelift-build.html#cfn-gamelift-build-name
     * @external
     */
    name: string | undefined;
    /**
     * `AWS::GameLift::Build.OperatingSystem`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gamelift-build.html#cfn-gamelift-build-operatingsystem
     * @external
     */
    operatingSystem: string | undefined;
    /**
     * `AWS::GameLift::Build.StorageLocation`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gamelift-build.html#cfn-gamelift-build-storagelocation
     * @external
     */
    storageLocation: CfnBuild.S3LocationProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::GameLift::Build.Version`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gamelift-build.html#cfn-gamelift-build-version
     * @external
     */
    version: string | undefined;
    /**
     * Create a new `AWS::GameLift::Build`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props?: CfnBuildProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::GameLift::Build`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gamelift-build.html
 * @external
 * @cloudformationResource AWS::GameLift::Build
 */
export declare namespace CfnBuild {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-gamelift-build-storagelocation.html
     * @external
     */
    interface S3LocationProperty {
        /**
         * `CfnBuild.S3LocationProperty.Bucket`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-gamelift-build-storagelocation.html#cfn-gamelift-build-storage-bucket
         * @external
         */
        readonly bucket: string;
        /**
         * `CfnBuild.S3LocationProperty.Key`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-gamelift-build-storagelocation.html#cfn-gamelift-build-storage-key
         * @external
         */
        readonly key: string;
        /**
         * `CfnBuild.S3LocationProperty.ObjectVersion`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-gamelift-build-storagelocation.html#cfn-gamelift-build-object-verison
         * @external
         */
        readonly objectVersion?: string;
        /**
         * `CfnBuild.S3LocationProperty.RoleArn`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-gamelift-build-storagelocation.html#cfn-gamelift-build-storage-rolearn
         * @external
         */
        readonly roleArn: string;
    }
}
/**
 * Properties for defining a `AWS::GameLift::Fleet`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gamelift-fleet.html
 * @external
 */
export interface CfnFleetProps {
    /**
     * `AWS::GameLift::Fleet.EC2InstanceType`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gamelift-fleet.html#cfn-gamelift-fleet-ec2instancetype
     * @external
     */
    readonly ec2InstanceType: string;
    /**
     * `AWS::GameLift::Fleet.Name`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gamelift-fleet.html#cfn-gamelift-fleet-name
     * @external
     */
    readonly name: string;
    /**
     * `AWS::GameLift::Fleet.BuildId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gamelift-fleet.html#cfn-gamelift-fleet-buildid
     * @external
     */
    readonly buildId?: string;
    /**
     * `AWS::GameLift::Fleet.CertificateConfiguration`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gamelift-fleet.html#cfn-gamelift-fleet-certificateconfiguration
     * @external
     */
    readonly certificateConfiguration?: CfnFleet.CertificateConfigurationProperty | cdk.IResolvable;
    /**
     * `AWS::GameLift::Fleet.Description`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gamelift-fleet.html#cfn-gamelift-fleet-description
     * @external
     */
    readonly description?: string;
    /**
     * `AWS::GameLift::Fleet.DesiredEC2Instances`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gamelift-fleet.html#cfn-gamelift-fleet-desiredec2instances
     * @external
     */
    readonly desiredEc2Instances?: number;
    /**
     * `AWS::GameLift::Fleet.EC2InboundPermissions`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gamelift-fleet.html#cfn-gamelift-fleet-ec2inboundpermissions
     * @external
     */
    readonly ec2InboundPermissions?: Array<CfnFleet.IpPermissionProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::GameLift::Fleet.FleetType`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gamelift-fleet.html#cfn-gamelift-fleet-fleettype
     * @external
     */
    readonly fleetType?: string;
    /**
     * `AWS::GameLift::Fleet.InstanceRoleARN`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gamelift-fleet.html#cfn-gamelift-fleet-instancerolearn
     * @external
     */
    readonly instanceRoleArn?: string;
    /**
     * `AWS::GameLift::Fleet.LogPaths`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gamelift-fleet.html#cfn-gamelift-fleet-logpaths
     * @external
     */
    readonly logPaths?: string[];
    /**
     * `AWS::GameLift::Fleet.MaxSize`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gamelift-fleet.html#cfn-gamelift-fleet-maxsize
     * @external
     */
    readonly maxSize?: number;
    /**
     * `AWS::GameLift::Fleet.MetricGroups`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gamelift-fleet.html#cfn-gamelift-fleet-metricgroups
     * @external
     */
    readonly metricGroups?: string[];
    /**
     * `AWS::GameLift::Fleet.MinSize`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gamelift-fleet.html#cfn-gamelift-fleet-minsize
     * @external
     */
    readonly minSize?: number;
    /**
     * `AWS::GameLift::Fleet.NewGameSessionProtectionPolicy`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gamelift-fleet.html#cfn-gamelift-fleet-newgamesessionprotectionpolicy
     * @external
     */
    readonly newGameSessionProtectionPolicy?: string;
    /**
     * `AWS::GameLift::Fleet.PeerVpcAwsAccountId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gamelift-fleet.html#cfn-gamelift-fleet-peervpcawsaccountid
     * @external
     */
    readonly peerVpcAwsAccountId?: string;
    /**
     * `AWS::GameLift::Fleet.PeerVpcId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gamelift-fleet.html#cfn-gamelift-fleet-peervpcid
     * @external
     */
    readonly peerVpcId?: string;
    /**
     * `AWS::GameLift::Fleet.ResourceCreationLimitPolicy`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gamelift-fleet.html#cfn-gamelift-fleet-resourcecreationlimitpolicy
     * @external
     */
    readonly resourceCreationLimitPolicy?: CfnFleet.ResourceCreationLimitPolicyProperty | cdk.IResolvable;
    /**
     * `AWS::GameLift::Fleet.RuntimeConfiguration`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gamelift-fleet.html#cfn-gamelift-fleet-runtimeconfiguration
     * @external
     */
    readonly runtimeConfiguration?: CfnFleet.RuntimeConfigurationProperty | cdk.IResolvable;
    /**
     * `AWS::GameLift::Fleet.ScriptId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gamelift-fleet.html#cfn-gamelift-fleet-scriptid
     * @external
     */
    readonly scriptId?: string;
    /**
     * `AWS::GameLift::Fleet.ServerLaunchParameters`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gamelift-fleet.html#cfn-gamelift-fleet-serverlaunchparameters
     * @external
     */
    readonly serverLaunchParameters?: string;
    /**
     * `AWS::GameLift::Fleet.ServerLaunchPath`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gamelift-fleet.html#cfn-gamelift-fleet-serverlaunchpath
     * @external
     */
    readonly serverLaunchPath?: string;
}
/**
 * A CloudFormation `AWS::GameLift::Fleet`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gamelift-fleet.html
 * @external
 * @cloudformationResource AWS::GameLift::Fleet
 */
export declare class CfnFleet extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::GameLift::Fleet";
    /**
     * `AWS::GameLift::Fleet.EC2InstanceType`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gamelift-fleet.html#cfn-gamelift-fleet-ec2instancetype
     * @external
     */
    ec2InstanceType: string;
    /**
     * `AWS::GameLift::Fleet.Name`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gamelift-fleet.html#cfn-gamelift-fleet-name
     * @external
     */
    name: string;
    /**
     * `AWS::GameLift::Fleet.BuildId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gamelift-fleet.html#cfn-gamelift-fleet-buildid
     * @external
     */
    buildId: string | undefined;
    /**
     * `AWS::GameLift::Fleet.CertificateConfiguration`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gamelift-fleet.html#cfn-gamelift-fleet-certificateconfiguration
     * @external
     */
    certificateConfiguration: CfnFleet.CertificateConfigurationProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::GameLift::Fleet.Description`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gamelift-fleet.html#cfn-gamelift-fleet-description
     * @external
     */
    description: string | undefined;
    /**
     * `AWS::GameLift::Fleet.DesiredEC2Instances`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gamelift-fleet.html#cfn-gamelift-fleet-desiredec2instances
     * @external
     */
    desiredEc2Instances: number | undefined;
    /**
     * `AWS::GameLift::Fleet.EC2InboundPermissions`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gamelift-fleet.html#cfn-gamelift-fleet-ec2inboundpermissions
     * @external
     */
    ec2InboundPermissions: Array<CfnFleet.IpPermissionProperty | cdk.IResolvable> | cdk.IResolvable | undefined;
    /**
     * `AWS::GameLift::Fleet.FleetType`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gamelift-fleet.html#cfn-gamelift-fleet-fleettype
     * @external
     */
    fleetType: string | undefined;
    /**
     * `AWS::GameLift::Fleet.InstanceRoleARN`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gamelift-fleet.html#cfn-gamelift-fleet-instancerolearn
     * @external
     */
    instanceRoleArn: string | undefined;
    /**
     * `AWS::GameLift::Fleet.LogPaths`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gamelift-fleet.html#cfn-gamelift-fleet-logpaths
     * @external
     */
    logPaths: string[] | undefined;
    /**
     * `AWS::GameLift::Fleet.MaxSize`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gamelift-fleet.html#cfn-gamelift-fleet-maxsize
     * @external
     */
    maxSize: number | undefined;
    /**
     * `AWS::GameLift::Fleet.MetricGroups`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gamelift-fleet.html#cfn-gamelift-fleet-metricgroups
     * @external
     */
    metricGroups: string[] | undefined;
    /**
     * `AWS::GameLift::Fleet.MinSize`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gamelift-fleet.html#cfn-gamelift-fleet-minsize
     * @external
     */
    minSize: number | undefined;
    /**
     * `AWS::GameLift::Fleet.NewGameSessionProtectionPolicy`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gamelift-fleet.html#cfn-gamelift-fleet-newgamesessionprotectionpolicy
     * @external
     */
    newGameSessionProtectionPolicy: string | undefined;
    /**
     * `AWS::GameLift::Fleet.PeerVpcAwsAccountId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gamelift-fleet.html#cfn-gamelift-fleet-peervpcawsaccountid
     * @external
     */
    peerVpcAwsAccountId: string | undefined;
    /**
     * `AWS::GameLift::Fleet.PeerVpcId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gamelift-fleet.html#cfn-gamelift-fleet-peervpcid
     * @external
     */
    peerVpcId: string | undefined;
    /**
     * `AWS::GameLift::Fleet.ResourceCreationLimitPolicy`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gamelift-fleet.html#cfn-gamelift-fleet-resourcecreationlimitpolicy
     * @external
     */
    resourceCreationLimitPolicy: CfnFleet.ResourceCreationLimitPolicyProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::GameLift::Fleet.RuntimeConfiguration`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gamelift-fleet.html#cfn-gamelift-fleet-runtimeconfiguration
     * @external
     */
    runtimeConfiguration: CfnFleet.RuntimeConfigurationProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::GameLift::Fleet.ScriptId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gamelift-fleet.html#cfn-gamelift-fleet-scriptid
     * @external
     */
    scriptId: string | undefined;
    /**
     * `AWS::GameLift::Fleet.ServerLaunchParameters`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gamelift-fleet.html#cfn-gamelift-fleet-serverlaunchparameters
     * @external
     */
    serverLaunchParameters: string | undefined;
    /**
     * `AWS::GameLift::Fleet.ServerLaunchPath`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gamelift-fleet.html#cfn-gamelift-fleet-serverlaunchpath
     * @external
     */
    serverLaunchPath: string | undefined;
    /**
     * Create a new `AWS::GameLift::Fleet`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnFleetProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::GameLift::Fleet`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gamelift-fleet.html
 * @external
 * @cloudformationResource AWS::GameLift::Fleet
 */
export declare namespace CfnFleet {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-gamelift-fleet-certificateconfiguration.html
     * @external
     */
    interface CertificateConfigurationProperty {
        /**
         * `CfnFleet.CertificateConfigurationProperty.CertificateType`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-gamelift-fleet-certificateconfiguration.html#cfn-gamelift-fleet-certificateconfiguration-certificatetype
         * @external
         */
        readonly certificateType: string;
    }
}
/**
 * A CloudFormation `AWS::GameLift::Fleet`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gamelift-fleet.html
 * @external
 * @cloudformationResource AWS::GameLift::Fleet
 */
export declare namespace CfnFleet {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-gamelift-fleet-ec2inboundpermission.html
     * @external
     */
    interface IpPermissionProperty {
        /**
         * `CfnFleet.IpPermissionProperty.FromPort`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-gamelift-fleet-ec2inboundpermission.html#cfn-gamelift-fleet-ec2inboundpermissions-fromport
         * @external
         */
        readonly fromPort: number;
        /**
         * `CfnFleet.IpPermissionProperty.IpRange`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-gamelift-fleet-ec2inboundpermission.html#cfn-gamelift-fleet-ec2inboundpermissions-iprange
         * @external
         */
        readonly ipRange: string;
        /**
         * `CfnFleet.IpPermissionProperty.Protocol`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-gamelift-fleet-ec2inboundpermission.html#cfn-gamelift-fleet-ec2inboundpermissions-protocol
         * @external
         */
        readonly protocol: string;
        /**
         * `CfnFleet.IpPermissionProperty.ToPort`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-gamelift-fleet-ec2inboundpermission.html#cfn-gamelift-fleet-ec2inboundpermissions-toport
         * @external
         */
        readonly toPort: number;
    }
}
/**
 * A CloudFormation `AWS::GameLift::Fleet`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gamelift-fleet.html
 * @external
 * @cloudformationResource AWS::GameLift::Fleet
 */
export declare namespace CfnFleet {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-gamelift-fleet-resourcecreationlimitpolicy.html
     * @external
     */
    interface ResourceCreationLimitPolicyProperty {
        /**
         * `CfnFleet.ResourceCreationLimitPolicyProperty.NewGameSessionsPerCreator`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-gamelift-fleet-resourcecreationlimitpolicy.html#cfn-gamelift-fleet-resourcecreationlimitpolicy-newgamesessionspercreator
         * @external
         */
        readonly newGameSessionsPerCreator?: number;
        /**
         * `CfnFleet.ResourceCreationLimitPolicyProperty.PolicyPeriodInMinutes`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-gamelift-fleet-resourcecreationlimitpolicy.html#cfn-gamelift-fleet-resourcecreationlimitpolicy-policyperiodinminutes
         * @external
         */
        readonly policyPeriodInMinutes?: number;
    }
}
/**
 * A CloudFormation `AWS::GameLift::Fleet`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gamelift-fleet.html
 * @external
 * @cloudformationResource AWS::GameLift::Fleet
 */
export declare namespace CfnFleet {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-gamelift-fleet-runtimeconfiguration.html
     * @external
     */
    interface RuntimeConfigurationProperty {
        /**
         * `CfnFleet.RuntimeConfigurationProperty.GameSessionActivationTimeoutSeconds`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-gamelift-fleet-runtimeconfiguration.html#cfn-gamelift-fleet-runtimeconfiguration-gamesessionactivationtimeoutseconds
         * @external
         */
        readonly gameSessionActivationTimeoutSeconds?: number;
        /**
         * `CfnFleet.RuntimeConfigurationProperty.MaxConcurrentGameSessionActivations`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-gamelift-fleet-runtimeconfiguration.html#cfn-gamelift-fleet-runtimeconfiguration-maxconcurrentgamesessionactivations
         * @external
         */
        readonly maxConcurrentGameSessionActivations?: number;
        /**
         * `CfnFleet.RuntimeConfigurationProperty.ServerProcesses`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-gamelift-fleet-runtimeconfiguration.html#cfn-gamelift-fleet-runtimeconfiguration-serverprocesses
         * @external
         */
        readonly serverProcesses?: Array<CfnFleet.ServerProcessProperty | cdk.IResolvable> | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::GameLift::Fleet`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gamelift-fleet.html
 * @external
 * @cloudformationResource AWS::GameLift::Fleet
 */
export declare namespace CfnFleet {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-gamelift-fleet-serverprocess.html
     * @external
     */
    interface ServerProcessProperty {
        /**
         * `CfnFleet.ServerProcessProperty.ConcurrentExecutions`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-gamelift-fleet-serverprocess.html#cfn-gamelift-fleet-serverprocess-concurrentexecutions
         * @external
         */
        readonly concurrentExecutions: number;
        /**
         * `CfnFleet.ServerProcessProperty.LaunchPath`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-gamelift-fleet-serverprocess.html#cfn-gamelift-fleet-serverprocess-launchpath
         * @external
         */
        readonly launchPath: string;
        /**
         * `CfnFleet.ServerProcessProperty.Parameters`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-gamelift-fleet-serverprocess.html#cfn-gamelift-fleet-serverprocess-parameters
         * @external
         */
        readonly parameters?: string;
    }
}
/**
 * Properties for defining a `AWS::GameLift::GameServerGroup`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gamelift-gameservergroup.html
 * @external
 */
export interface CfnGameServerGroupProps {
    /**
     * `AWS::GameLift::GameServerGroup.GameServerGroupName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gamelift-gameservergroup.html#cfn-gamelift-gameservergroup-gameservergroupname
     * @external
     */
    readonly gameServerGroupName: string;
    /**
     * `AWS::GameLift::GameServerGroup.InstanceDefinitions`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gamelift-gameservergroup.html#cfn-gamelift-gameservergroup-instancedefinitions
     * @external
     */
    readonly instanceDefinitions: CfnGameServerGroup.InstanceDefinitionsProperty | cdk.IResolvable;
    /**
     * `AWS::GameLift::GameServerGroup.LaunchTemplate`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gamelift-gameservergroup.html#cfn-gamelift-gameservergroup-launchtemplate
     * @external
     */
    readonly launchTemplate: CfnGameServerGroup.LaunchTemplateProperty | cdk.IResolvable;
    /**
     * `AWS::GameLift::GameServerGroup.RoleArn`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gamelift-gameservergroup.html#cfn-gamelift-gameservergroup-rolearn
     * @external
     */
    readonly roleArn: string;
    /**
     * `AWS::GameLift::GameServerGroup.AutoScalingPolicy`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gamelift-gameservergroup.html#cfn-gamelift-gameservergroup-autoscalingpolicy
     * @external
     */
    readonly autoScalingPolicy?: CfnGameServerGroup.AutoScalingPolicyProperty | cdk.IResolvable;
    /**
     * `AWS::GameLift::GameServerGroup.BalancingStrategy`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gamelift-gameservergroup.html#cfn-gamelift-gameservergroup-balancingstrategy
     * @external
     */
    readonly balancingStrategy?: string;
    /**
     * `AWS::GameLift::GameServerGroup.DeleteOption`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gamelift-gameservergroup.html#cfn-gamelift-gameservergroup-deleteoption
     * @external
     */
    readonly deleteOption?: string;
    /**
     * `AWS::GameLift::GameServerGroup.GameServerProtectionPolicy`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gamelift-gameservergroup.html#cfn-gamelift-gameservergroup-gameserverprotectionpolicy
     * @external
     */
    readonly gameServerProtectionPolicy?: string;
    /**
     * `AWS::GameLift::GameServerGroup.MaxSize`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gamelift-gameservergroup.html#cfn-gamelift-gameservergroup-maxsize
     * @external
     */
    readonly maxSize?: number;
    /**
     * `AWS::GameLift::GameServerGroup.MinSize`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gamelift-gameservergroup.html#cfn-gamelift-gameservergroup-minsize
     * @external
     */
    readonly minSize?: number;
    /**
     * `AWS::GameLift::GameServerGroup.Tags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gamelift-gameservergroup.html#cfn-gamelift-gameservergroup-tags
     * @external
     */
    readonly tags?: CfnGameServerGroup.TagsProperty;
    /**
     * `AWS::GameLift::GameServerGroup.VpcSubnets`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gamelift-gameservergroup.html#cfn-gamelift-gameservergroup-vpcsubnets
     * @external
     */
    readonly vpcSubnets?: CfnGameServerGroup.VpcSubnetsProperty | cdk.IResolvable;
}
/**
 * A CloudFormation `AWS::GameLift::GameServerGroup`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gamelift-gameservergroup.html
 * @external
 * @cloudformationResource AWS::GameLift::GameServerGroup
 */
export declare class CfnGameServerGroup extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::GameLift::GameServerGroup";
    /**
     * @external
     * @cloudformationAttribute AutoScalingGroupArn
     */
    readonly attrAutoScalingGroupArn: string;
    /**
     * @external
     * @cloudformationAttribute GameServerGroupArn
     */
    readonly attrGameServerGroupArn: string;
    /**
     * `AWS::GameLift::GameServerGroup.GameServerGroupName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gamelift-gameservergroup.html#cfn-gamelift-gameservergroup-gameservergroupname
     * @external
     */
    gameServerGroupName: string;
    /**
     * `AWS::GameLift::GameServerGroup.InstanceDefinitions`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gamelift-gameservergroup.html#cfn-gamelift-gameservergroup-instancedefinitions
     * @external
     */
    instanceDefinitions: CfnGameServerGroup.InstanceDefinitionsProperty | cdk.IResolvable;
    /**
     * `AWS::GameLift::GameServerGroup.LaunchTemplate`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gamelift-gameservergroup.html#cfn-gamelift-gameservergroup-launchtemplate
     * @external
     */
    launchTemplate: CfnGameServerGroup.LaunchTemplateProperty | cdk.IResolvable;
    /**
     * `AWS::GameLift::GameServerGroup.RoleArn`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gamelift-gameservergroup.html#cfn-gamelift-gameservergroup-rolearn
     * @external
     */
    roleArn: string;
    /**
     * `AWS::GameLift::GameServerGroup.AutoScalingPolicy`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gamelift-gameservergroup.html#cfn-gamelift-gameservergroup-autoscalingpolicy
     * @external
     */
    autoScalingPolicy: CfnGameServerGroup.AutoScalingPolicyProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::GameLift::GameServerGroup.BalancingStrategy`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gamelift-gameservergroup.html#cfn-gamelift-gameservergroup-balancingstrategy
     * @external
     */
    balancingStrategy: string | undefined;
    /**
     * `AWS::GameLift::GameServerGroup.DeleteOption`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gamelift-gameservergroup.html#cfn-gamelift-gameservergroup-deleteoption
     * @external
     */
    deleteOption: string | undefined;
    /**
     * `AWS::GameLift::GameServerGroup.GameServerProtectionPolicy`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gamelift-gameservergroup.html#cfn-gamelift-gameservergroup-gameserverprotectionpolicy
     * @external
     */
    gameServerProtectionPolicy: string | undefined;
    /**
     * `AWS::GameLift::GameServerGroup.MaxSize`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gamelift-gameservergroup.html#cfn-gamelift-gameservergroup-maxsize
     * @external
     */
    maxSize: number | undefined;
    /**
     * `AWS::GameLift::GameServerGroup.MinSize`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gamelift-gameservergroup.html#cfn-gamelift-gameservergroup-minsize
     * @external
     */
    minSize: number | undefined;
    /**
     * `AWS::GameLift::GameServerGroup.Tags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gamelift-gameservergroup.html#cfn-gamelift-gameservergroup-tags
     * @external
     */
    readonly tags: cdk.TagManager;
    /**
     * `AWS::GameLift::GameServerGroup.VpcSubnets`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gamelift-gameservergroup.html#cfn-gamelift-gameservergroup-vpcsubnets
     * @external
     */
    vpcSubnets: CfnGameServerGroup.VpcSubnetsProperty | cdk.IResolvable | undefined;
    /**
     * Create a new `AWS::GameLift::GameServerGroup`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnGameServerGroupProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::GameLift::GameServerGroup`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gamelift-gameservergroup.html
 * @external
 * @cloudformationResource AWS::GameLift::GameServerGroup
 */
export declare namespace CfnGameServerGroup {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-gamelift-gameservergroup-autoscalingpolicy.html
     * @external
     */
    interface AutoScalingPolicyProperty {
        /**
         * `CfnGameServerGroup.AutoScalingPolicyProperty.EstimatedInstanceWarmup`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-gamelift-gameservergroup-autoscalingpolicy.html#cfn-gamelift-gameservergroup-autoscalingpolicy-estimatedinstancewarmup
         * @external
         */
        readonly estimatedInstanceWarmup?: number;
        /**
         * `CfnGameServerGroup.AutoScalingPolicyProperty.TargetTrackingConfiguration`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-gamelift-gameservergroup-autoscalingpolicy.html#cfn-gamelift-gameservergroup-autoscalingpolicy-targettrackingconfiguration
         * @external
         */
        readonly targetTrackingConfiguration: CfnGameServerGroup.TargetTrackingConfigurationProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::GameLift::GameServerGroup`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gamelift-gameservergroup.html
 * @external
 * @cloudformationResource AWS::GameLift::GameServerGroup
 */
export declare namespace CfnGameServerGroup {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-gamelift-gameservergroup-instancedefinition.html
     * @external
     */
    interface InstanceDefinitionProperty {
        /**
         * `CfnGameServerGroup.InstanceDefinitionProperty.InstanceType`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-gamelift-gameservergroup-instancedefinition.html#cfn-gamelift-gameservergroup-instancedefinition-instancetype
         * @external
         */
        readonly instanceType: string;
        /**
         * `CfnGameServerGroup.InstanceDefinitionProperty.WeightedCapacity`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-gamelift-gameservergroup-instancedefinition.html#cfn-gamelift-gameservergroup-instancedefinition-weightedcapacity
         * @external
         */
        readonly weightedCapacity?: string;
    }
}
/**
 * A CloudFormation `AWS::GameLift::GameServerGroup`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gamelift-gameservergroup.html
 * @external
 * @cloudformationResource AWS::GameLift::GameServerGroup
 */
export declare namespace CfnGameServerGroup {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-gamelift-gameservergroup-instancedefinitions.html
     * @external
     */
    interface InstanceDefinitionsProperty {
        /**
         * `CfnGameServerGroup.InstanceDefinitionsProperty.InstanceDefinitions`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-gamelift-gameservergroup-instancedefinitions.html#cfn-gamelift-gameservergroup-instancedefinitions-instancedefinitions
         * @external
         */
        readonly instanceDefinitions?: Array<CfnGameServerGroup.InstanceDefinitionProperty | cdk.IResolvable> | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::GameLift::GameServerGroup`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gamelift-gameservergroup.html
 * @external
 * @cloudformationResource AWS::GameLift::GameServerGroup
 */
export declare namespace CfnGameServerGroup {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-gamelift-gameservergroup-launchtemplate.html
     * @external
     */
    interface LaunchTemplateProperty {
        /**
         * `CfnGameServerGroup.LaunchTemplateProperty.LaunchTemplateId`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-gamelift-gameservergroup-launchtemplate.html#cfn-gamelift-gameservergroup-launchtemplate-launchtemplateid
         * @external
         */
        readonly launchTemplateId?: string;
        /**
         * `CfnGameServerGroup.LaunchTemplateProperty.LaunchTemplateName`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-gamelift-gameservergroup-launchtemplate.html#cfn-gamelift-gameservergroup-launchtemplate-launchtemplatename
         * @external
         */
        readonly launchTemplateName?: string;
        /**
         * `CfnGameServerGroup.LaunchTemplateProperty.Version`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-gamelift-gameservergroup-launchtemplate.html#cfn-gamelift-gameservergroup-launchtemplate-version
         * @external
         */
        readonly version?: string;
    }
}
/**
 * A CloudFormation `AWS::GameLift::GameServerGroup`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gamelift-gameservergroup.html
 * @external
 * @cloudformationResource AWS::GameLift::GameServerGroup
 */
export declare namespace CfnGameServerGroup {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-gamelift-gameservergroup-tags.html
     * @external
     */
    interface TagsProperty {
        /**
         * `CfnGameServerGroup.TagsProperty.Tags`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-gamelift-gameservergroup-tags.html#cfn-gamelift-gameservergroup-tags-tags
         * @external
         */
        readonly tags?: cdk.CfnTag[];
    }
}
/**
 * A CloudFormation `AWS::GameLift::GameServerGroup`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gamelift-gameservergroup.html
 * @external
 * @cloudformationResource AWS::GameLift::GameServerGroup
 */
export declare namespace CfnGameServerGroup {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-gamelift-gameservergroup-targettrackingconfiguration.html
     * @external
     */
    interface TargetTrackingConfigurationProperty {
        /**
         * `CfnGameServerGroup.TargetTrackingConfigurationProperty.TargetValue`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-gamelift-gameservergroup-targettrackingconfiguration.html#cfn-gamelift-gameservergroup-targettrackingconfiguration-targetvalue
         * @external
         */
        readonly targetValue: number;
    }
}
/**
 * A CloudFormation `AWS::GameLift::GameServerGroup`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gamelift-gameservergroup.html
 * @external
 * @cloudformationResource AWS::GameLift::GameServerGroup
 */
export declare namespace CfnGameServerGroup {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-gamelift-gameservergroup-vpcsubnets.html
     * @external
     */
    interface VpcSubnetsProperty {
        /**
         * `CfnGameServerGroup.VpcSubnetsProperty.VpcSubnets`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-gamelift-gameservergroup-vpcsubnets.html#cfn-gamelift-gameservergroup-vpcsubnets-vpcsubnets
         * @external
         */
        readonly vpcSubnets?: string[];
    }
}
/**
 * Properties for defining a `AWS::GameLift::GameSessionQueue`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gamelift-gamesessionqueue.html
 * @external
 */
export interface CfnGameSessionQueueProps {
    /**
     * `AWS::GameLift::GameSessionQueue.Name`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gamelift-gamesessionqueue.html#cfn-gamelift-gamesessionqueue-name
     * @external
     */
    readonly name: string;
    /**
     * `AWS::GameLift::GameSessionQueue.Destinations`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gamelift-gamesessionqueue.html#cfn-gamelift-gamesessionqueue-destinations
     * @external
     */
    readonly destinations?: Array<CfnGameSessionQueue.DestinationProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::GameLift::GameSessionQueue.PlayerLatencyPolicies`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gamelift-gamesessionqueue.html#cfn-gamelift-gamesessionqueue-playerlatencypolicies
     * @external
     */
    readonly playerLatencyPolicies?: Array<CfnGameSessionQueue.PlayerLatencyPolicyProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::GameLift::GameSessionQueue.TimeoutInSeconds`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gamelift-gamesessionqueue.html#cfn-gamelift-gamesessionqueue-timeoutinseconds
     * @external
     */
    readonly timeoutInSeconds?: number;
}
/**
 * A CloudFormation `AWS::GameLift::GameSessionQueue`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gamelift-gamesessionqueue.html
 * @external
 * @cloudformationResource AWS::GameLift::GameSessionQueue
 */
export declare class CfnGameSessionQueue extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::GameLift::GameSessionQueue";
    /**
     * @external
     * @cloudformationAttribute Arn
     */
    readonly attrArn: string;
    /**
     * @external
     * @cloudformationAttribute Name
     */
    readonly attrName: string;
    /**
     * `AWS::GameLift::GameSessionQueue.Name`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gamelift-gamesessionqueue.html#cfn-gamelift-gamesessionqueue-name
     * @external
     */
    name: string;
    /**
     * `AWS::GameLift::GameSessionQueue.Destinations`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gamelift-gamesessionqueue.html#cfn-gamelift-gamesessionqueue-destinations
     * @external
     */
    destinations: Array<CfnGameSessionQueue.DestinationProperty | cdk.IResolvable> | cdk.IResolvable | undefined;
    /**
     * `AWS::GameLift::GameSessionQueue.PlayerLatencyPolicies`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gamelift-gamesessionqueue.html#cfn-gamelift-gamesessionqueue-playerlatencypolicies
     * @external
     */
    playerLatencyPolicies: Array<CfnGameSessionQueue.PlayerLatencyPolicyProperty | cdk.IResolvable> | cdk.IResolvable | undefined;
    /**
     * `AWS::GameLift::GameSessionQueue.TimeoutInSeconds`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gamelift-gamesessionqueue.html#cfn-gamelift-gamesessionqueue-timeoutinseconds
     * @external
     */
    timeoutInSeconds: number | undefined;
    /**
     * Create a new `AWS::GameLift::GameSessionQueue`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnGameSessionQueueProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::GameLift::GameSessionQueue`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gamelift-gamesessionqueue.html
 * @external
 * @cloudformationResource AWS::GameLift::GameSessionQueue
 */
export declare namespace CfnGameSessionQueue {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-gamelift-gamesessionqueue-destination.html
     * @external
     */
    interface DestinationProperty {
        /**
         * `CfnGameSessionQueue.DestinationProperty.DestinationArn`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-gamelift-gamesessionqueue-destination.html#cfn-gamelift-gamesessionqueue-destination-destinationarn
         * @external
         */
        readonly destinationArn?: string;
    }
}
/**
 * A CloudFormation `AWS::GameLift::GameSessionQueue`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gamelift-gamesessionqueue.html
 * @external
 * @cloudformationResource AWS::GameLift::GameSessionQueue
 */
export declare namespace CfnGameSessionQueue {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-gamelift-gamesessionqueue-playerlatencypolicy.html
     * @external
     */
    interface PlayerLatencyPolicyProperty {
        /**
         * `CfnGameSessionQueue.PlayerLatencyPolicyProperty.MaximumIndividualPlayerLatencyMilliseconds`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-gamelift-gamesessionqueue-playerlatencypolicy.html#cfn-gamelift-gamesessionqueue-playerlatencypolicy-maximumindividualplayerlatencymilliseconds
         * @external
         */
        readonly maximumIndividualPlayerLatencyMilliseconds?: number;
        /**
         * `CfnGameSessionQueue.PlayerLatencyPolicyProperty.PolicyDurationSeconds`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-gamelift-gamesessionqueue-playerlatencypolicy.html#cfn-gamelift-gamesessionqueue-playerlatencypolicy-policydurationseconds
         * @external
         */
        readonly policyDurationSeconds?: number;
    }
}
/**
 * Properties for defining a `AWS::GameLift::MatchmakingConfiguration`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gamelift-matchmakingconfiguration.html
 * @external
 */
export interface CfnMatchmakingConfigurationProps {
    /**
     * `AWS::GameLift::MatchmakingConfiguration.AcceptanceRequired`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gamelift-matchmakingconfiguration.html#cfn-gamelift-matchmakingconfiguration-acceptancerequired
     * @external
     */
    readonly acceptanceRequired: boolean | cdk.IResolvable;
    /**
     * `AWS::GameLift::MatchmakingConfiguration.GameSessionQueueArns`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gamelift-matchmakingconfiguration.html#cfn-gamelift-matchmakingconfiguration-gamesessionqueuearns
     * @external
     */
    readonly gameSessionQueueArns: string[];
    /**
     * `AWS::GameLift::MatchmakingConfiguration.Name`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gamelift-matchmakingconfiguration.html#cfn-gamelift-matchmakingconfiguration-name
     * @external
     */
    readonly name: string;
    /**
     * `AWS::GameLift::MatchmakingConfiguration.RequestTimeoutSeconds`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gamelift-matchmakingconfiguration.html#cfn-gamelift-matchmakingconfiguration-requesttimeoutseconds
     * @external
     */
    readonly requestTimeoutSeconds: number;
    /**
     * `AWS::GameLift::MatchmakingConfiguration.RuleSetName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gamelift-matchmakingconfiguration.html#cfn-gamelift-matchmakingconfiguration-rulesetname
     * @external
     */
    readonly ruleSetName: string;
    /**
     * `AWS::GameLift::MatchmakingConfiguration.AcceptanceTimeoutSeconds`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gamelift-matchmakingconfiguration.html#cfn-gamelift-matchmakingconfiguration-acceptancetimeoutseconds
     * @external
     */
    readonly acceptanceTimeoutSeconds?: number;
    /**
     * `AWS::GameLift::MatchmakingConfiguration.AdditionalPlayerCount`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gamelift-matchmakingconfiguration.html#cfn-gamelift-matchmakingconfiguration-additionalplayercount
     * @external
     */
    readonly additionalPlayerCount?: number;
    /**
     * `AWS::GameLift::MatchmakingConfiguration.BackfillMode`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gamelift-matchmakingconfiguration.html#cfn-gamelift-matchmakingconfiguration-backfillmode
     * @external
     */
    readonly backfillMode?: string;
    /**
     * `AWS::GameLift::MatchmakingConfiguration.CustomEventData`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gamelift-matchmakingconfiguration.html#cfn-gamelift-matchmakingconfiguration-customeventdata
     * @external
     */
    readonly customEventData?: string;
    /**
     * `AWS::GameLift::MatchmakingConfiguration.Description`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gamelift-matchmakingconfiguration.html#cfn-gamelift-matchmakingconfiguration-description
     * @external
     */
    readonly description?: string;
    /**
     * `AWS::GameLift::MatchmakingConfiguration.GameProperties`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gamelift-matchmakingconfiguration.html#cfn-gamelift-matchmakingconfiguration-gameproperties
     * @external
     */
    readonly gameProperties?: Array<CfnMatchmakingConfiguration.GamePropertyProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::GameLift::MatchmakingConfiguration.GameSessionData`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gamelift-matchmakingconfiguration.html#cfn-gamelift-matchmakingconfiguration-gamesessiondata
     * @external
     */
    readonly gameSessionData?: string;
    /**
     * `AWS::GameLift::MatchmakingConfiguration.NotificationTarget`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gamelift-matchmakingconfiguration.html#cfn-gamelift-matchmakingconfiguration-notificationtarget
     * @external
     */
    readonly notificationTarget?: string;
}
/**
 * A CloudFormation `AWS::GameLift::MatchmakingConfiguration`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gamelift-matchmakingconfiguration.html
 * @external
 * @cloudformationResource AWS::GameLift::MatchmakingConfiguration
 */
export declare class CfnMatchmakingConfiguration extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::GameLift::MatchmakingConfiguration";
    /**
     * @external
     * @cloudformationAttribute Arn
     */
    readonly attrArn: string;
    /**
     * @external
     * @cloudformationAttribute Name
     */
    readonly attrName: string;
    /**
     * `AWS::GameLift::MatchmakingConfiguration.AcceptanceRequired`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gamelift-matchmakingconfiguration.html#cfn-gamelift-matchmakingconfiguration-acceptancerequired
     * @external
     */
    acceptanceRequired: boolean | cdk.IResolvable;
    /**
     * `AWS::GameLift::MatchmakingConfiguration.GameSessionQueueArns`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gamelift-matchmakingconfiguration.html#cfn-gamelift-matchmakingconfiguration-gamesessionqueuearns
     * @external
     */
    gameSessionQueueArns: string[];
    /**
     * `AWS::GameLift::MatchmakingConfiguration.Name`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gamelift-matchmakingconfiguration.html#cfn-gamelift-matchmakingconfiguration-name
     * @external
     */
    name: string;
    /**
     * `AWS::GameLift::MatchmakingConfiguration.RequestTimeoutSeconds`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gamelift-matchmakingconfiguration.html#cfn-gamelift-matchmakingconfiguration-requesttimeoutseconds
     * @external
     */
    requestTimeoutSeconds: number;
    /**
     * `AWS::GameLift::MatchmakingConfiguration.RuleSetName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gamelift-matchmakingconfiguration.html#cfn-gamelift-matchmakingconfiguration-rulesetname
     * @external
     */
    ruleSetName: string;
    /**
     * `AWS::GameLift::MatchmakingConfiguration.AcceptanceTimeoutSeconds`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gamelift-matchmakingconfiguration.html#cfn-gamelift-matchmakingconfiguration-acceptancetimeoutseconds
     * @external
     */
    acceptanceTimeoutSeconds: number | undefined;
    /**
     * `AWS::GameLift::MatchmakingConfiguration.AdditionalPlayerCount`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gamelift-matchmakingconfiguration.html#cfn-gamelift-matchmakingconfiguration-additionalplayercount
     * @external
     */
    additionalPlayerCount: number | undefined;
    /**
     * `AWS::GameLift::MatchmakingConfiguration.BackfillMode`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gamelift-matchmakingconfiguration.html#cfn-gamelift-matchmakingconfiguration-backfillmode
     * @external
     */
    backfillMode: string | undefined;
    /**
     * `AWS::GameLift::MatchmakingConfiguration.CustomEventData`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gamelift-matchmakingconfiguration.html#cfn-gamelift-matchmakingconfiguration-customeventdata
     * @external
     */
    customEventData: string | undefined;
    /**
     * `AWS::GameLift::MatchmakingConfiguration.Description`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gamelift-matchmakingconfiguration.html#cfn-gamelift-matchmakingconfiguration-description
     * @external
     */
    description: string | undefined;
    /**
     * `AWS::GameLift::MatchmakingConfiguration.GameProperties`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gamelift-matchmakingconfiguration.html#cfn-gamelift-matchmakingconfiguration-gameproperties
     * @external
     */
    gameProperties: Array<CfnMatchmakingConfiguration.GamePropertyProperty | cdk.IResolvable> | cdk.IResolvable | undefined;
    /**
     * `AWS::GameLift::MatchmakingConfiguration.GameSessionData`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gamelift-matchmakingconfiguration.html#cfn-gamelift-matchmakingconfiguration-gamesessiondata
     * @external
     */
    gameSessionData: string | undefined;
    /**
     * `AWS::GameLift::MatchmakingConfiguration.NotificationTarget`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gamelift-matchmakingconfiguration.html#cfn-gamelift-matchmakingconfiguration-notificationtarget
     * @external
     */
    notificationTarget: string | undefined;
    /**
     * Create a new `AWS::GameLift::MatchmakingConfiguration`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnMatchmakingConfigurationProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::GameLift::MatchmakingConfiguration`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gamelift-matchmakingconfiguration.html
 * @external
 * @cloudformationResource AWS::GameLift::MatchmakingConfiguration
 */
export declare namespace CfnMatchmakingConfiguration {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-gamelift-matchmakingconfiguration-gameproperty.html
     * @external
     */
    interface GamePropertyProperty {
        /**
         * `CfnMatchmakingConfiguration.GamePropertyProperty.Key`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-gamelift-matchmakingconfiguration-gameproperty.html#cfn-gamelift-matchmakingconfiguration-gameproperty-key
         * @external
         */
        readonly key: string;
        /**
         * `CfnMatchmakingConfiguration.GamePropertyProperty.Value`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-gamelift-matchmakingconfiguration-gameproperty.html#cfn-gamelift-matchmakingconfiguration-gameproperty-value
         * @external
         */
        readonly value: string;
    }
}
/**
 * Properties for defining a `AWS::GameLift::MatchmakingRuleSet`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gamelift-matchmakingruleset.html
 * @external
 */
export interface CfnMatchmakingRuleSetProps {
    /**
     * `AWS::GameLift::MatchmakingRuleSet.Name`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gamelift-matchmakingruleset.html#cfn-gamelift-matchmakingruleset-name
     * @external
     */
    readonly name: string;
    /**
     * `AWS::GameLift::MatchmakingRuleSet.RuleSetBody`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gamelift-matchmakingruleset.html#cfn-gamelift-matchmakingruleset-rulesetbody
     * @external
     */
    readonly ruleSetBody: string;
}
/**
 * A CloudFormation `AWS::GameLift::MatchmakingRuleSet`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gamelift-matchmakingruleset.html
 * @external
 * @cloudformationResource AWS::GameLift::MatchmakingRuleSet
 */
export declare class CfnMatchmakingRuleSet extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::GameLift::MatchmakingRuleSet";
    /**
     * @external
     * @cloudformationAttribute Arn
     */
    readonly attrArn: string;
    /**
     * @external
     * @cloudformationAttribute Name
     */
    readonly attrName: string;
    /**
     * `AWS::GameLift::MatchmakingRuleSet.Name`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gamelift-matchmakingruleset.html#cfn-gamelift-matchmakingruleset-name
     * @external
     */
    name: string;
    /**
     * `AWS::GameLift::MatchmakingRuleSet.RuleSetBody`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gamelift-matchmakingruleset.html#cfn-gamelift-matchmakingruleset-rulesetbody
     * @external
     */
    ruleSetBody: string;
    /**
     * Create a new `AWS::GameLift::MatchmakingRuleSet`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnMatchmakingRuleSetProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * Properties for defining a `AWS::GameLift::Script`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gamelift-script.html
 * @external
 */
export interface CfnScriptProps {
    /**
     * `AWS::GameLift::Script.StorageLocation`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gamelift-script.html#cfn-gamelift-script-storagelocation
     * @external
     */
    readonly storageLocation: CfnScript.S3LocationProperty | cdk.IResolvable;
    /**
     * `AWS::GameLift::Script.Name`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gamelift-script.html#cfn-gamelift-script-name
     * @external
     */
    readonly name?: string;
    /**
     * `AWS::GameLift::Script.Version`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gamelift-script.html#cfn-gamelift-script-version
     * @external
     */
    readonly version?: string;
}
/**
 * A CloudFormation `AWS::GameLift::Script`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gamelift-script.html
 * @external
 * @cloudformationResource AWS::GameLift::Script
 */
export declare class CfnScript extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::GameLift::Script";
    /**
     * @external
     * @cloudformationAttribute Arn
     */
    readonly attrArn: string;
    /**
     * @external
     * @cloudformationAttribute Id
     */
    readonly attrId: string;
    /**
     * `AWS::GameLift::Script.StorageLocation`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gamelift-script.html#cfn-gamelift-script-storagelocation
     * @external
     */
    storageLocation: CfnScript.S3LocationProperty | cdk.IResolvable;
    /**
     * `AWS::GameLift::Script.Name`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gamelift-script.html#cfn-gamelift-script-name
     * @external
     */
    name: string | undefined;
    /**
     * `AWS::GameLift::Script.Version`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gamelift-script.html#cfn-gamelift-script-version
     * @external
     */
    version: string | undefined;
    /**
     * Create a new `AWS::GameLift::Script`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnScriptProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::GameLift::Script`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gamelift-script.html
 * @external
 * @cloudformationResource AWS::GameLift::Script
 */
export declare namespace CfnScript {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-gamelift-script-s3location.html
     * @external
     */
    interface S3LocationProperty {
        /**
         * `CfnScript.S3LocationProperty.Bucket`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-gamelift-script-s3location.html#cfn-gamelift-script-s3location-bucket
         * @external
         */
        readonly bucket: string;
        /**
         * `CfnScript.S3LocationProperty.Key`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-gamelift-script-s3location.html#cfn-gamelift-script-s3location-key
         * @external
         */
        readonly key: string;
        /**
         * `CfnScript.S3LocationProperty.ObjectVersion`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-gamelift-script-s3location.html#cfn-gamelift-script-s3location-objectversion
         * @external
         */
        readonly objectVersion?: string;
        /**
         * `CfnScript.S3LocationProperty.RoleArn`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-gamelift-script-s3location.html#cfn-gamelift-script-s3location-rolearn
         * @external
         */
        readonly roleArn: string;
    }
}
