"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.LambdaSubscription = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const iam = require("@aws-cdk/aws-iam");
const sns = require("@aws-cdk/aws-sns");
const core_1 = require("@aws-cdk/core");
// keep this import separate from other imports to reduce chance for merge conflicts with v2-main
// eslint-disable-next-line no-duplicate-imports, import/order
const core_2 = require("@aws-cdk/core");
/**
 * Use a Lambda function as a subscription target
 */
class LambdaSubscription {
    constructor(fn, props = {}) {
        this.fn = fn;
        this.props = props;
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_sns_subscriptions_LambdaSubscriptionProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, LambdaSubscription);
            }
            throw error;
        }
    }
    /**
     * Returns a configuration for a Lambda function to subscribe to an SNS topic
     */
    bind(topic) {
        // Create subscription under *consuming* construct to make sure it ends up
        // in the correct stack in cases of cross-stack subscriptions.
        if (!core_2.Construct.isConstruct(this.fn)) {
            throw new Error('The supplied lambda Function object must be an instance of Construct');
        }
        this.fn.addPermission(`AllowInvoke:${core_1.Names.nodeUniqueId(topic.node)}`, {
            sourceArn: topic.topicArn,
            principal: new iam.ServicePrincipal('sns.amazonaws.com'),
        });
        // if the topic and function are created in different stacks
        // then we need to make sure the topic is created first
        if (topic instanceof sns.Topic && topic.stack !== this.fn.stack) {
            this.fn.stack.addDependency(topic.stack);
        }
        return {
            subscriberScope: this.fn,
            subscriberId: topic.node.id,
            endpoint: this.fn.functionArn,
            protocol: sns.SubscriptionProtocol.LAMBDA,
            filterPolicy: this.props.filterPolicy,
            region: this.regionFromArn(topic),
            deadLetterQueue: this.props.deadLetterQueue,
        };
    }
    regionFromArn(topic) {
        // no need to specify `region` for topics defined within the same stack.
        if (topic instanceof sns.Topic) {
            if (topic.stack !== this.fn.stack) {
                // only if we know the region, will not work for
                // env agnostic stacks
                if (!core_1.Token.isUnresolved(topic.env.region) &&
                    (topic.env.region !== this.fn.env.region)) {
                    return topic.env.region;
                }
            }
            return undefined;
        }
        return core_1.Stack.of(topic).splitArn(topic.topicArn, core_1.ArnFormat.SLASH_RESOURCE_NAME).region;
    }
}
exports.LambdaSubscription = LambdaSubscription;
_a = JSII_RTTI_SYMBOL_1;
LambdaSubscription[_a] = { fqn: "@aws-cdk/aws-sns-subscriptions.LambdaSubscription", version: "1.188.0" };
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoibGFtYmRhLmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsibGFtYmRhLnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7Ozs7OztBQUFBLHdDQUF3QztBQUV4Qyx3Q0FBd0M7QUFDeEMsd0NBQStEO0FBRy9ELGlHQUFpRztBQUNqRyw4REFBOEQ7QUFDOUQsd0NBQTBDO0FBUTFDOztHQUVHO0FBQ0gsTUFBYSxrQkFBa0I7SUFDN0IsWUFBNkIsRUFBb0IsRUFBbUIsUUFBaUMsRUFBRTtRQUExRSxPQUFFLEdBQUYsRUFBRSxDQUFrQjtRQUFtQixVQUFLLEdBQUwsS0FBSyxDQUE4Qjs7Ozs7OytDQUQ1RixrQkFBa0I7Ozs7S0FFNUI7SUFFRDs7T0FFRztJQUNJLElBQUksQ0FBQyxLQUFpQjtRQUMzQiwwRUFBMEU7UUFDMUUsOERBQThEO1FBQzlELElBQUksQ0FBQyxnQkFBUyxDQUFDLFdBQVcsQ0FBQyxJQUFJLENBQUMsRUFBRSxDQUFDLEVBQUU7WUFDbkMsTUFBTSxJQUFJLEtBQUssQ0FBQyxzRUFBc0UsQ0FBQyxDQUFDO1NBQ3pGO1FBRUQsSUFBSSxDQUFDLEVBQUUsQ0FBQyxhQUFhLENBQUMsZUFBZSxZQUFLLENBQUMsWUFBWSxDQUFDLEtBQUssQ0FBQyxJQUFJLENBQUMsRUFBRSxFQUFFO1lBQ3JFLFNBQVMsRUFBRSxLQUFLLENBQUMsUUFBUTtZQUN6QixTQUFTLEVBQUUsSUFBSSxHQUFHLENBQUMsZ0JBQWdCLENBQUMsbUJBQW1CLENBQUM7U0FDekQsQ0FBQyxDQUFDO1FBRUgsNERBQTREO1FBQzVELHVEQUF1RDtRQUN2RCxJQUFJLEtBQUssWUFBWSxHQUFHLENBQUMsS0FBSyxJQUFJLEtBQUssQ0FBQyxLQUFLLEtBQUssSUFBSSxDQUFDLEVBQUUsQ0FBQyxLQUFLLEVBQUU7WUFDL0QsSUFBSSxDQUFDLEVBQUUsQ0FBQyxLQUFLLENBQUMsYUFBYSxDQUFDLEtBQUssQ0FBQyxLQUFLLENBQUMsQ0FBQztTQUMxQztRQUVELE9BQU87WUFDTCxlQUFlLEVBQUUsSUFBSSxDQUFDLEVBQUU7WUFDeEIsWUFBWSxFQUFFLEtBQUssQ0FBQyxJQUFJLENBQUMsRUFBRTtZQUMzQixRQUFRLEVBQUUsSUFBSSxDQUFDLEVBQUUsQ0FBQyxXQUFXO1lBQzdCLFFBQVEsRUFBRSxHQUFHLENBQUMsb0JBQW9CLENBQUMsTUFBTTtZQUN6QyxZQUFZLEVBQUUsSUFBSSxDQUFDLEtBQUssQ0FBQyxZQUFZO1lBQ3JDLE1BQU0sRUFBRSxJQUFJLENBQUMsYUFBYSxDQUFDLEtBQUssQ0FBQztZQUNqQyxlQUFlLEVBQUUsSUFBSSxDQUFDLEtBQUssQ0FBQyxlQUFlO1NBQzVDLENBQUM7S0FDSDtJQUVPLGFBQWEsQ0FBQyxLQUFpQjtRQUNyQyx3RUFBd0U7UUFDeEUsSUFBSSxLQUFLLFlBQVksR0FBRyxDQUFDLEtBQUssRUFBRTtZQUM5QixJQUFJLEtBQUssQ0FBQyxLQUFLLEtBQUssSUFBSSxDQUFDLEVBQUUsQ0FBQyxLQUFLLEVBQUU7Z0JBQ2pDLGdEQUFnRDtnQkFDaEQsc0JBQXNCO2dCQUN0QixJQUFJLENBQUMsWUFBSyxDQUFDLFlBQVksQ0FBQyxLQUFLLENBQUMsR0FBRyxDQUFDLE1BQU0sQ0FBQztvQkFDdkMsQ0FBQyxLQUFLLENBQUMsR0FBRyxDQUFDLE1BQU0sS0FBSyxJQUFJLENBQUMsRUFBRSxDQUFDLEdBQUcsQ0FBQyxNQUFNLENBQUMsRUFBRTtvQkFDM0MsT0FBTyxLQUFLLENBQUMsR0FBRyxDQUFDLE1BQU0sQ0FBQztpQkFDekI7YUFDRjtZQUNELE9BQU8sU0FBUyxDQUFDO1NBQ2xCO1FBQ0QsT0FBTyxZQUFLLENBQUMsRUFBRSxDQUFDLEtBQUssQ0FBQyxDQUFDLFFBQVEsQ0FBQyxLQUFLLENBQUMsUUFBUSxFQUFFLGdCQUFTLENBQUMsbUJBQW1CLENBQUMsQ0FBQyxNQUFNLENBQUM7S0FDdkY7O0FBbERILGdEQW1EQyIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCAqIGFzIGlhbSBmcm9tICdAYXdzLWNkay9hd3MtaWFtJztcbmltcG9ydCAqIGFzIGxhbWJkYSBmcm9tICdAYXdzLWNkay9hd3MtbGFtYmRhJztcbmltcG9ydCAqIGFzIHNucyBmcm9tICdAYXdzLWNkay9hd3Mtc25zJztcbmltcG9ydCB7IEFybkZvcm1hdCwgTmFtZXMsIFN0YWNrLCBUb2tlbiB9IGZyb20gJ0Bhd3MtY2RrL2NvcmUnO1xuaW1wb3J0IHsgU3Vic2NyaXB0aW9uUHJvcHMgfSBmcm9tICcuL3N1YnNjcmlwdGlvbic7XG5cbi8vIGtlZXAgdGhpcyBpbXBvcnQgc2VwYXJhdGUgZnJvbSBvdGhlciBpbXBvcnRzIHRvIHJlZHVjZSBjaGFuY2UgZm9yIG1lcmdlIGNvbmZsaWN0cyB3aXRoIHYyLW1haW5cbi8vIGVzbGludC1kaXNhYmxlLW5leHQtbGluZSBuby1kdXBsaWNhdGUtaW1wb3J0cywgaW1wb3J0L29yZGVyXG5pbXBvcnQgeyBDb25zdHJ1Y3QgfSBmcm9tICdAYXdzLWNkay9jb3JlJztcblxuLyoqXG4gKiBQcm9wZXJ0aWVzIGZvciBhIExhbWJkYSBzdWJzY3JpcHRpb25cbiAqL1xuZXhwb3J0IGludGVyZmFjZSBMYW1iZGFTdWJzY3JpcHRpb25Qcm9wcyBleHRlbmRzIFN1YnNjcmlwdGlvblByb3BzIHtcblxufVxuLyoqXG4gKiBVc2UgYSBMYW1iZGEgZnVuY3Rpb24gYXMgYSBzdWJzY3JpcHRpb24gdGFyZ2V0XG4gKi9cbmV4cG9ydCBjbGFzcyBMYW1iZGFTdWJzY3JpcHRpb24gaW1wbGVtZW50cyBzbnMuSVRvcGljU3Vic2NyaXB0aW9uIHtcbiAgY29uc3RydWN0b3IocHJpdmF0ZSByZWFkb25seSBmbjogbGFtYmRhLklGdW5jdGlvbiwgcHJpdmF0ZSByZWFkb25seSBwcm9wczogTGFtYmRhU3Vic2NyaXB0aW9uUHJvcHMgPSB7fSkge1xuICB9XG5cbiAgLyoqXG4gICAqIFJldHVybnMgYSBjb25maWd1cmF0aW9uIGZvciBhIExhbWJkYSBmdW5jdGlvbiB0byBzdWJzY3JpYmUgdG8gYW4gU05TIHRvcGljXG4gICAqL1xuICBwdWJsaWMgYmluZCh0b3BpYzogc25zLklUb3BpYyk6IHNucy5Ub3BpY1N1YnNjcmlwdGlvbkNvbmZpZyB7XG4gICAgLy8gQ3JlYXRlIHN1YnNjcmlwdGlvbiB1bmRlciAqY29uc3VtaW5nKiBjb25zdHJ1Y3QgdG8gbWFrZSBzdXJlIGl0IGVuZHMgdXBcbiAgICAvLyBpbiB0aGUgY29ycmVjdCBzdGFjayBpbiBjYXNlcyBvZiBjcm9zcy1zdGFjayBzdWJzY3JpcHRpb25zLlxuICAgIGlmICghQ29uc3RydWN0LmlzQ29uc3RydWN0KHRoaXMuZm4pKSB7XG4gICAgICB0aHJvdyBuZXcgRXJyb3IoJ1RoZSBzdXBwbGllZCBsYW1iZGEgRnVuY3Rpb24gb2JqZWN0IG11c3QgYmUgYW4gaW5zdGFuY2Ugb2YgQ29uc3RydWN0Jyk7XG4gICAgfVxuXG4gICAgdGhpcy5mbi5hZGRQZXJtaXNzaW9uKGBBbGxvd0ludm9rZToke05hbWVzLm5vZGVVbmlxdWVJZCh0b3BpYy5ub2RlKX1gLCB7XG4gICAgICBzb3VyY2VBcm46IHRvcGljLnRvcGljQXJuLFxuICAgICAgcHJpbmNpcGFsOiBuZXcgaWFtLlNlcnZpY2VQcmluY2lwYWwoJ3Nucy5hbWF6b25hd3MuY29tJyksXG4gICAgfSk7XG5cbiAgICAvLyBpZiB0aGUgdG9waWMgYW5kIGZ1bmN0aW9uIGFyZSBjcmVhdGVkIGluIGRpZmZlcmVudCBzdGFja3NcbiAgICAvLyB0aGVuIHdlIG5lZWQgdG8gbWFrZSBzdXJlIHRoZSB0b3BpYyBpcyBjcmVhdGVkIGZpcnN0XG4gICAgaWYgKHRvcGljIGluc3RhbmNlb2Ygc25zLlRvcGljICYmIHRvcGljLnN0YWNrICE9PSB0aGlzLmZuLnN0YWNrKSB7XG4gICAgICB0aGlzLmZuLnN0YWNrLmFkZERlcGVuZGVuY3kodG9waWMuc3RhY2spO1xuICAgIH1cblxuICAgIHJldHVybiB7XG4gICAgICBzdWJzY3JpYmVyU2NvcGU6IHRoaXMuZm4sXG4gICAgICBzdWJzY3JpYmVySWQ6IHRvcGljLm5vZGUuaWQsXG4gICAgICBlbmRwb2ludDogdGhpcy5mbi5mdW5jdGlvbkFybixcbiAgICAgIHByb3RvY29sOiBzbnMuU3Vic2NyaXB0aW9uUHJvdG9jb2wuTEFNQkRBLFxuICAgICAgZmlsdGVyUG9saWN5OiB0aGlzLnByb3BzLmZpbHRlclBvbGljeSxcbiAgICAgIHJlZ2lvbjogdGhpcy5yZWdpb25Gcm9tQXJuKHRvcGljKSxcbiAgICAgIGRlYWRMZXR0ZXJRdWV1ZTogdGhpcy5wcm9wcy5kZWFkTGV0dGVyUXVldWUsXG4gICAgfTtcbiAgfVxuXG4gIHByaXZhdGUgcmVnaW9uRnJvbUFybih0b3BpYzogc25zLklUb3BpYyk6IHN0cmluZyB8IHVuZGVmaW5lZCB7XG4gICAgLy8gbm8gbmVlZCB0byBzcGVjaWZ5IGByZWdpb25gIGZvciB0b3BpY3MgZGVmaW5lZCB3aXRoaW4gdGhlIHNhbWUgc3RhY2suXG4gICAgaWYgKHRvcGljIGluc3RhbmNlb2Ygc25zLlRvcGljKSB7XG4gICAgICBpZiAodG9waWMuc3RhY2sgIT09IHRoaXMuZm4uc3RhY2spIHtcbiAgICAgICAgLy8gb25seSBpZiB3ZSBrbm93IHRoZSByZWdpb24sIHdpbGwgbm90IHdvcmsgZm9yXG4gICAgICAgIC8vIGVudiBhZ25vc3RpYyBzdGFja3NcbiAgICAgICAgaWYgKCFUb2tlbi5pc1VucmVzb2x2ZWQodG9waWMuZW52LnJlZ2lvbikgJiZcbiAgICAgICAgICAodG9waWMuZW52LnJlZ2lvbiAhPT0gdGhpcy5mbi5lbnYucmVnaW9uKSkge1xuICAgICAgICAgIHJldHVybiB0b3BpYy5lbnYucmVnaW9uO1xuICAgICAgICB9XG4gICAgICB9XG4gICAgICByZXR1cm4gdW5kZWZpbmVkO1xuICAgIH1cbiAgICByZXR1cm4gU3RhY2sub2YodG9waWMpLnNwbGl0QXJuKHRvcGljLnRvcGljQXJuLCBBcm5Gb3JtYXQuU0xBU0hfUkVTT1VSQ0VfTkFNRSkucmVnaW9uO1xuICB9XG59XG4iXX0=