import { Construct, Resource } from '@aws-cdk/core';
import { ILogGroup, MetricFilterOptions } from './log-group';
/**
 * Properties for a MetricFilter
 */
export interface MetricFilterProps extends MetricFilterOptions {
    /**
     * The log group to create the filter on.
     */
    readonly logGroup: ILogGroup;
}
/**
 * A filter that extracts information from CloudWatch Logs and emits to CloudWatch Metrics
 */
export declare class MetricFilter extends Resource {
    constructor(scope: Construct, id: string, props: MetricFilterProps);
}
