"""
author: meiqihezi
Data literal storing emoji names and unicode codes
"""


__all__ = ['LANG_EMOJI', 'EMOJI_LANG']

# emoji and english are both unique
EN_EMOJI = {
    u':1st_place_medal:': u'\U0001F947',
    u':2nd_place_medal:': u'\U0001F948',
    u':3rd_place_medal:': u'\U0001F949',
    u':AB_button_(blood_type):': u'\U0001F18E',
    u':ATM_sign:': u'\U0001F3E7',
    u':A_button_(blood_type):': u'\U0001F170',
    u':A_button_(blood_type)_selector:': u'\U0001F170\U0000FE0F',
    u':Afghanistan:': u'\U0001F1E6\U0001F1EB',
    u':Aland_Islands:': u'\U0001F1E6\U0001F1FD',
    u':Albania:': u'\U0001F1E6\U0001F1F1',
    u':Algeria:': u'\U0001F1E9\U0001F1FF',
    u':American_Samoa:': u'\U0001F1E6\U0001F1F8',
    u':Andorra:': u'\U0001F1E6\U0001F1E9',
    u':Angola:': u'\U0001F1E6\U0001F1F4',
    u':Anguilla:': u'\U0001F1E6\U0001F1EE',
    u':Antarctica:': u'\U0001F1E6\U0001F1F6',
    u':Antigua_&_Barbuda:': u'\U0001F1E6\U0001F1EC',
    u':Aquarius:': u'\U00002652',
    u':Argentina:': u'\U0001F1E6\U0001F1F7',
    u':Aries:': u'\U00002648',
    u':Armenia:': u'\U0001F1E6\U0001F1F2',
    u':Aruba:': u'\U0001F1E6\U0001F1FC',
    u':Ascension_Island:': u'\U0001F1E6\U0001F1E8',
    u':Australia:': u'\U0001F1E6\U0001F1FA',
    u':Austria:': u'\U0001F1E6\U0001F1F9',
    u':Azerbaijan:': u'\U0001F1E6\U0001F1FF',
    u':BACK_arrow:': u'\U0001F519',
    u':B_button_(blood_type):': u'\U0001F171',
    u':B_button_(blood_type)_selector:': u'\U0001F171\U0000FE0F',
    u':Bahamas:': u'\U0001F1E7\U0001F1F8',
    u':Bahrain:': u'\U0001F1E7\U0001F1ED',
    u':Bangladesh:': u'\U0001F1E7\U0001F1E9',
    u':Barbados:': u'\U0001F1E7\U0001F1E7',
    u':Belarus:': u'\U0001F1E7\U0001F1FE',
    u':Belgium:': u'\U0001F1E7\U0001F1EA',
    u':Belize:': u'\U0001F1E7\U0001F1FF',
    u':Benin:': u'\U0001F1E7\U0001F1EF',
    u':Bermuda:': u'\U0001F1E7\U0001F1F2',
    u':Bhutan:': u'\U0001F1E7\U0001F1F9',
    u':Bolivia:': u'\U0001F1E7\U0001F1F4',
    u':Bosnia_&_Herzegovina:': u'\U0001F1E7\U0001F1E6',
    u':Botswana:': u'\U0001F1E7\U0001F1FC',
    u':Bouvet_Island:': u'\U0001F1E7\U0001F1FB',
    u':Brazil:': u'\U0001F1E7\U0001F1F7',
    u':British_Indian_Ocean_Territory:': u'\U0001F1EE\U0001F1F4',
    u':British_Virgin_Islands:': u'\U0001F1FB\U0001F1EC',
    u':Brunei:': u'\U0001F1E7\U0001F1F3',
    u':Bulgaria:': u'\U0001F1E7\U0001F1EC',
    u':Burkina_Faso:': u'\U0001F1E7\U0001F1EB',
    u':Burundi:': u'\U0001F1E7\U0001F1EE',
    u':CL_button:': u'\U0001F191',
    u':COOL_button:': u'\U0001F192',
    u':Cambodia:': u'\U0001F1F0\U0001F1ED',
    u':Cameroon:': u'\U0001F1E8\U0001F1F2',
    u':Canada:': u'\U0001F1E8\U0001F1E6',
    u':Canary_Islands:': u'\U0001F1EE\U0001F1E8',
    u':Cancer:': u'\U0000264B',
    u':Cape_Verde:': u'\U0001F1E8\U0001F1FB',
    u':Capricorn:': u'\U00002651',
    u':Caribbean_Netherlands:': u'\U0001F1E7\U0001F1F6',
    u':Cayman_Islands:': u'\U0001F1F0\U0001F1FE',
    u':Central_African_Republic:': u'\U0001F1E8\U0001F1EB',
    u':Ceuta_&_Melilla:': u'\U0001F1EA\U0001F1E6',
    u':Chad:': u'\U0001F1F9\U0001F1E9',
    u':Chile:': u'\U0001F1E8\U0001F1F1',
    u':China:': u'\U0001F1E8\U0001F1F3',
    u':Christmas_Island:': u'\U0001F1E8\U0001F1FD',
    u':Christmas_tree:': u'\U0001F384',
    u':Clipperton_Island:': u'\U0001F1E8\U0001F1F5',
    u':Cocos_(Keeling)_Islands:': u'\U0001F1E8\U0001F1E8',
    u':Colombia:': u'\U0001F1E8\U0001F1F4',
    u':Comoros:': u'\U0001F1F0\U0001F1F2',
    u':Congo_-_Brazzaville:': u'\U0001F1E8\U0001F1EC',
    u':Congo_-_Kinshasa:': u'\U0001F1E8\U0001F1E9',
    u':Cook_Islands:': u'\U0001F1E8\U0001F1F0',
    u':Costa_Rica:': u'\U0001F1E8\U0001F1F7',
    u':Croatia:': u'\U0001F1ED\U0001F1F7',
    u':Cuba:': u'\U0001F1E8\U0001F1FA',
    u':Cura\xe7ao:': u'\U0001F1E8\U0001F1FC',
    u':Cyprus:': u'\U0001F1E8\U0001F1FE',
    u':Czechia:': u'\U0001F1E8\U0001F1FF',
    u':C\xf4te_d\u2019Ivoire:': u'\U0001F1E8\U0001F1EE',
    u':Denmark:': u'\U0001F1E9\U0001F1F0',
    u':Diego_Garcia:': u'\U0001F1E9\U0001F1EC',
    u':Djibouti:': u'\U0001F1E9\U0001F1EF',
    u':Dominica:': u'\U0001F1E9\U0001F1F2',
    u':Dominican_Republic:': u'\U0001F1E9\U0001F1F4',
    u':END_arrow:': u'\U0001F51A',
    u':Ecuador:': u'\U0001F1EA\U0001F1E8',
    u':Egypt:': u'\U0001F1EA\U0001F1EC',
    u':El_Salvador:': u'\U0001F1F8\U0001F1FB',
    u':England:': u'\U0001F3F4\U000E0067\U000E0062\U000E0065\U000E006E\U000E0067\U000E007F',
    u':Equatorial_Guinea:': u'\U0001F1EC\U0001F1F6',
    u':Eritrea:': u'\U0001F1EA\U0001F1F7',
    u':Estonia:': u'\U0001F1EA\U0001F1EA',
    u':Ethiopia:': u'\U0001F1EA\U0001F1F9',
    u':European_Union:': u'\U0001F1EA\U0001F1FA',
    u':FREE_button:': u'\U0001F193',
    u':Falkland_Islands:': u'\U0001F1EB\U0001F1F0',
    u':Faroe_Islands:': u'\U0001F1EB\U0001F1F4',
    u':Fiji:': u'\U0001F1EB\U0001F1EF',
    u':Finland:': u'\U0001F1EB\U0001F1EE',
    u':France:': u'\U0001F1EB\U0001F1F7',
    u':French_Guiana:': u'\U0001F1EC\U0001F1EB',
    u':French_Polynesia:': u'\U0001F1F5\U0001F1EB',
    u':French_Southern_Territories:': u'\U0001F1F9\U0001F1EB',
    u':Gabon:': u'\U0001F1EC\U0001F1E6',
    u':Gambia:': u'\U0001F1EC\U0001F1F2',
    u':Gemini:': u'\U0000264A',
    u':Georgia:': u'\U0001F1EC\U0001F1EA',
    u':Germany:': u'\U0001F1E9\U0001F1EA',
    u':Ghana:': u'\U0001F1EC\U0001F1ED',
    u':Gibraltar:': u'\U0001F1EC\U0001F1EE',
    u':Greece:': u'\U0001F1EC\U0001F1F7',
    u':Greenland:': u'\U0001F1EC\U0001F1F1',
    u':Grenada:': u'\U0001F1EC\U0001F1E9',
    u':Guadeloupe:': u'\U0001F1EC\U0001F1F5',
    u':Guam:': u'\U0001F1EC\U0001F1FA',
    u':Guatemala:': u'\U0001F1EC\U0001F1F9',
    u':Guernsey:': u'\U0001F1EC\U0001F1EC',
    u':Guinea-Bissau:': u'\U0001F1EC\U0001F1FC',
    u':Guinea:': u'\U0001F1EC\U0001F1F3',
    u':Guyana:': u'\U0001F1EC\U0001F1FE',
    u':Haiti:': u'\U0001F1ED\U0001F1F9',
    u':Heard_&_McDonald_Islands:': u'\U0001F1ED\U0001F1F2',
    u':Honduras:': u'\U0001F1ED\U0001F1F3',
    u':Hong_Kong_SAR_China:': u'\U0001F1ED\U0001F1F0',
    u':Hungary:': u'\U0001F1ED\U0001F1FA',
    u':ID_button:': u'\U0001F194',
    u':Iceland:': u'\U0001F1EE\U0001F1F8',
    u':India:': u'\U0001F1EE\U0001F1F3',
    u':Indonesia:': u'\U0001F1EE\U0001F1E9',
    u':Iran:': u'\U0001F1EE\U0001F1F7',
    u':Iraq:': u'\U0001F1EE\U0001F1F6',
    u':Ireland:': u'\U0001F1EE\U0001F1EA',
    u':Isle_of_Man:': u'\U0001F1EE\U0001F1F2',
    u':Israel:': u'\U0001F1EE\U0001F1F1',
    u':Italy:': u'\U0001F1EE\U0001F1F9',
    u':Jamaica:': u'\U0001F1EF\U0001F1F2',
    u':Japan:': u'\U0001F1EF\U0001F1F5',
    u':Japanese_acceptable_button:': u'\U0001F251',
    u':Japanese_application_button:': u'\U0001F238',
    u':Japanese_bargain_button:': u'\U0001F250',
    u':Japanese_castle:': u'\U0001F3EF',
    u':Japanese_congratulations_button:': u'\U00003297',
    u':Japanese_discount_button:': u'\U0001F239',
    u':Japanese_dolls:': u'\U0001F38E',
    u':Japanese_free_of_charge_button:': u'\U0001F21A',
    u':Japanese_here_button:': u'\U0001F201',
    u':Japanese_monthly_amount_button:': u'\U0001F237',
    u':Japanese_no_vacancy_button:': u'\U0001F235',
    u':Japanese_not_free_of_charge_button:': u'\U0001F236',
    u':Japanese_open_for_business_button:': u'\U0001F23A',
    u':Japanese_passing_grade_button:': u'\U0001F234',
    u':Japanese_post_office:': u'\U0001F3E3',
    u':Japanese_prohibited_button:': u'\U0001F232',
    u':Japanese_reserved_button:': u'\U0001F22F',
    u':Japanese_secret_button:': u'\U00003299',
    u':Japanese_service_charge_button:': u'\U0001F202',
    u':Japanese_symbol_for_beginner:': u'\U0001F530',
    u':Japanese_vacancy_button:': u'\U0001F233',
    u':Japanese_congratulations_button_selector:': u'\U00003297\U0000FE0F',
    u':Japanese_monthly_amount_button_selector:': u'\U0001F237\U0000FE0F',
    u':Japanese_secret_button_selector:': u'\U00003299\U0000FE0F',
    u':Japanese_service_charge_button_selector:': u'\U0001F202\U0000FE0F',
    u':Jersey:': u'\U0001F1EF\U0001F1EA',
    u':Jordan:': u'\U0001F1EF\U0001F1F4',
    u':Kazakhstan:': u'\U0001F1F0\U0001F1FF',
    u':Kenya:': u'\U0001F1F0\U0001F1EA',
    u':Kiribati:': u'\U0001F1F0\U0001F1EE',
    u':Kosovo:': u'\U0001F1FD\U0001F1F0',
    u':Kuwait:': u'\U0001F1F0\U0001F1FC',
    u':Kyrgyzstan:': u'\U0001F1F0\U0001F1EC',
    u':Laos:': u'\U0001F1F1\U0001F1E6',
    u':Latvia:': u'\U0001F1F1\U0001F1FB',
    u':Lebanon:': u'\U0001F1F1\U0001F1E7',
    u':Leo:': u'\U0000264C',
    u':Lesotho:': u'\U0001F1F1\U0001F1F8',
    u':Liberia:': u'\U0001F1F1\U0001F1F7',
    u':Libra:': u'\U0000264E',
    u':Libya:': u'\U0001F1F1\U0001F1FE',
    u':Liechtenstein:': u'\U0001F1F1\U0001F1EE',
    u':Lithuania:': u'\U0001F1F1\U0001F1F9',
    u':Luxembourg:': u'\U0001F1F1\U0001F1FA',
    u':Macau_SAR_China:': u'\U0001F1F2\U0001F1F4',
    u':Macedonia:': u'\U0001F1F2\U0001F1F0',
    u':Madagascar:': u'\U0001F1F2\U0001F1EC',
    u':Malawi:': u'\U0001F1F2\U0001F1FC',
    u':Malaysia:': u'\U0001F1F2\U0001F1FE',
    u':Maldives:': u'\U0001F1F2\U0001F1FB',
    u':Mali:': u'\U0001F1F2\U0001F1F1',
    u':Malta:': u'\U0001F1F2\U0001F1F9',
    u':Marshall_Islands:': u'\U0001F1F2\U0001F1ED',
    u':Martinique:': u'\U0001F1F2\U0001F1F6',
    u':Mauritania:': u'\U0001F1F2\U0001F1F7',
    u':Mauritius:': u'\U0001F1F2\U0001F1FA',
    u':Mayotte:': u'\U0001F1FE\U0001F1F9',
    u':Mexico:': u'\U0001F1F2\U0001F1FD',
    u':Micronesia:': u'\U0001F1EB\U0001F1F2',
    u':Moldova:': u'\U0001F1F2\U0001F1E9',
    u':Monaco:': u'\U0001F1F2\U0001F1E8',
    u':Mongolia:': u'\U0001F1F2\U0001F1F3',
    u':Montenegro:': u'\U0001F1F2\U0001F1EA',
    u':Montserrat:': u'\U0001F1F2\U0001F1F8',
    u':Morocco:': u'\U0001F1F2\U0001F1E6',
    u':Mozambique:': u'\U0001F1F2\U0001F1FF',
    u':Mrs._Claus:': u'\U0001F936',
    u':Mrs._Claus_dark_skin_tone:': u'\U0001F936\U0001F3FF',
    u':Mrs._Claus_light_skin_tone:': u'\U0001F936\U0001F3FB',
    u':Mrs._Claus_medium-dark_skin_tone:': u'\U0001F936\U0001F3FE',
    u':Mrs._Claus_medium-light_skin_tone:': u'\U0001F936\U0001F3FC',
    u':Mrs._Claus_medium_skin_tone:': u'\U0001F936\U0001F3FD',
    u':Myanmar_(Burma):': u'\U0001F1F2\U0001F1F2',
    u':NEW_button:': u'\U0001F195',
    u':NG_button:': u'\U0001F196',
    u':Namibia:': u'\U0001F1F3\U0001F1E6',
    u':Nauru:': u'\U0001F1F3\U0001F1F7',
    u':Nepal:': u'\U0001F1F3\U0001F1F5',
    u':Netherlands:': u'\U0001F1F3\U0001F1F1',
    u':New_Caledonia:': u'\U0001F1F3\U0001F1E8',
    u':New_Zealand:': u'\U0001F1F3\U0001F1FF',
    u':Nicaragua:': u'\U0001F1F3\U0001F1EE',
    u':Niger:': u'\U0001F1F3\U0001F1EA',
    u':Nigeria:': u'\U0001F1F3\U0001F1EC',
    u':Niue:': u'\U0001F1F3\U0001F1FA',
    u':Norfolk_Island:': u'\U0001F1F3\U0001F1EB',
    u':North_Korea:': u'\U0001F1F0\U0001F1F5',
    u':Northern_Mariana_Islands:': u'\U0001F1F2\U0001F1F5',
    u':Norway:': u'\U0001F1F3\U0001F1F4',
    u':OK_button:': u'\U0001F197',
    u':OK_hand:': u'\U0001F44C',
    u':OK_hand_dark_skin_tone:': u'\U0001F44C\U0001F3FF',
    u':OK_hand_light_skin_tone:': u'\U0001F44C\U0001F3FB',
    u':OK_hand_medium-dark_skin_tone:': u'\U0001F44C\U0001F3FE',
    u':OK_hand_medium-light_skin_tone:': u'\U0001F44C\U0001F3FC',
    u':OK_hand_medium_skin_tone:': u'\U0001F44C\U0001F3FD',
    u':ON!_arrow:': u'\U0001F51B',
    u':O_button_(blood_type):': u'\U0001F17E',
    u':O_button_(blood_type)_selector:': u'\U0001F17E\U0000FE0F',
    u':Oman:': u'\U0001F1F4\U0001F1F2',
    u':Ophiuchus:': u'\U000026CE',
    u':P_button:': u'\U0001F17F',
    u':P_button_selector:': u'\U0001F17F\U0000FE0F',
    u':Pakistan:': u'\U0001F1F5\U0001F1F0',
    u':Palau:': u'\U0001F1F5\U0001F1FC',
    u':Palestinian_Territories:': u'\U0001F1F5\U0001F1F8',
    u':Panama:': u'\U0001F1F5\U0001F1E6',
    u':Papua_New_Guinea:': u'\U0001F1F5\U0001F1EC',
    u':Paraguay:': u'\U0001F1F5\U0001F1FE',
    u':Peru:': u'\U0001F1F5\U0001F1EA',
    u':Philippines:': u'\U0001F1F5\U0001F1ED',
    u':Pisces:': u'\U00002653',
    u':Pitcairn_Islands:': u'\U0001F1F5\U0001F1F3',
    u':Poland:': u'\U0001F1F5\U0001F1F1',
    u':Portugal:': u'\U0001F1F5\U0001F1F9',
    u':Puerto_Rico:': u'\U0001F1F5\U0001F1F7',
    u':Qatar:': u'\U0001F1F6\U0001F1E6',
    u':Romania:': u'\U0001F1F7\U0001F1F4',
    u':Russia:': u'\U0001F1F7\U0001F1FA',
    u':Rwanda:': u'\U0001F1F7\U0001F1FC',
    u':R\xe9union:': u'\U0001F1F7\U0001F1EA',
    u':SOON_arrow:': u'\U0001F51C',
    u':SOS_button:': u'\U0001F198',
    u':Sagittarius:': u'\U00002650',
    u':Samoa:': u'\U0001F1FC\U0001F1F8',
    u':San_Marino:': u'\U0001F1F8\U0001F1F2',
    u':Santa_Claus:': u'\U0001F385',
    u':Santa_Claus_dark_skin_tone:': u'\U0001F385\U0001F3FF',
    u':Santa_Claus_light_skin_tone:': u'\U0001F385\U0001F3FB',
    u':Santa_Claus_medium-dark_skin_tone:': u'\U0001F385\U0001F3FE',
    u':Santa_Claus_medium-light_skin_tone:': u'\U0001F385\U0001F3FC',
    u':Santa_Claus_medium_skin_tone:': u'\U0001F385\U0001F3FD',
    u':Saudi_Arabia:': u'\U0001F1F8\U0001F1E6',
    u':Scorpio:': u'\U0000264F',
    u':Scotland:': u'\U0001F3F4\U000E0067\U000E0062\U000E0073\U000E0063\U000E0074\U000E007F',
    u':Senegal:': u'\U0001F1F8\U0001F1F3',
    u':Serbia:': u'\U0001F1F7\U0001F1F8',
    u':Seychelles:': u'\U0001F1F8\U0001F1E8',
    u':Sierra_Leone:': u'\U0001F1F8\U0001F1F1',
    u':Singapore:': u'\U0001F1F8\U0001F1EC',
    u':Sint_Maarten:': u'\U0001F1F8\U0001F1FD',
    u':Slovakia:': u'\U0001F1F8\U0001F1F0',
    u':Slovenia:': u'\U0001F1F8\U0001F1EE',
    u':Solomon_Islands:': u'\U0001F1F8\U0001F1E7',
    u':Somalia:': u'\U0001F1F8\U0001F1F4',
    u':South_Africa:': u'\U0001F1FF\U0001F1E6',
    u':South_Georgia_&_South_Sandwich_Islands:': u'\U0001F1EC\U0001F1F8',
    u':South_Korea:': u'\U0001F1F0\U0001F1F7',
    u':South_Sudan:': u'\U0001F1F8\U0001F1F8',
    u':Spain:': u'\U0001F1EA\U0001F1F8',
    u':Sri_Lanka:': u'\U0001F1F1\U0001F1F0',
    u':St._Barth\xe9lemy:': u'\U0001F1E7\U0001F1F1',
    u':St._Helena:': u'\U0001F1F8\U0001F1ED',
    u':St._Kitts_&_Nevis:': u'\U0001F1F0\U0001F1F3',
    u':St._Lucia:': u'\U0001F1F1\U0001F1E8',
    u':St._Martin:': u'\U0001F1F2\U0001F1EB',
    u':St._Pierre_&_Miquelon:': u'\U0001F1F5\U0001F1F2',
    u':St._Vincent_&_Grenadines:': u'\U0001F1FB\U0001F1E8',
    u':Statue_of_Liberty:': u'\U0001F5FD',
    u':Sudan:': u'\U0001F1F8\U0001F1E9',
    u':Suriname:': u'\U0001F1F8\U0001F1F7',
    u':Svalbard_&_Jan_Mayen:': u'\U0001F1F8\U0001F1EF',
    u':Swaziland:': u'\U0001F1F8\U0001F1FF',
    u':Sweden:': u'\U0001F1F8\U0001F1EA',
    u':Switzerland:': u'\U0001F1E8\U0001F1ED',
    u':Syria:': u'\U0001F1F8\U0001F1FE',
    u':S\xe3o_Tom\xe9_&_Pr\xedncipe:': u'\U0001F1F8\U0001F1F9',
    u':T-Rex:': u'\U0001F996',
    u':TOP_arrow:': u'\U0001F51D',
    u':Taiwan:': u'\U0001F1F9\U0001F1FC',
    u':Tajikistan:': u'\U0001F1F9\U0001F1EF',
    u':Tanzania:': u'\U0001F1F9\U0001F1FF',
    u':Taurus:': u'\U00002649',
    u':Thailand:': u'\U0001F1F9\U0001F1ED',
    u':Timor-Leste:': u'\U0001F1F9\U0001F1F1',
    u':Togo:': u'\U0001F1F9\U0001F1EC',
    u':Tokelau:': u'\U0001F1F9\U0001F1F0',
    u':Tokyo_tower:': u'\U0001F5FC',
    u':Tonga:': u'\U0001F1F9\U0001F1F4',
    u':Trinidad_&_Tobago:': u'\U0001F1F9\U0001F1F9',
    u':Tristan_da_Cunha:': u'\U0001F1F9\U0001F1E6',
    u':Tunisia:': u'\U0001F1F9\U0001F1F3',
    u':Turkey:': u'\U0001F1F9\U0001F1F7',
    u':Turkmenistan:': u'\U0001F1F9\U0001F1F2',
    u':Turks_&_Caicos_Islands:': u'\U0001F1F9\U0001F1E8',
    u':Tuvalu:': u'\U0001F1F9\U0001F1FB',
    u':U.S._Outlying_Islands:': u'\U0001F1FA\U0001F1F2',
    u':U.S._Virgin_Islands:': u'\U0001F1FB\U0001F1EE',
    u':UP!_button:': u'\U0001F199',
    u':Uganda:': u'\U0001F1FA\U0001F1EC',
    u':Ukraine:': u'\U0001F1FA\U0001F1E6',
    u':United_Arab_Emirates:': u'\U0001F1E6\U0001F1EA',
    u':United_Kingdom:': u'\U0001F1EC\U0001F1E7',
    u':United_Nations:': u'\U0001F1FA\U0001F1F3',
    u':United_States:': u'\U0001F1FA\U0001F1F8',
    u':Uruguay:': u'\U0001F1FA\U0001F1FE',
    u':Uzbekistan:': u'\U0001F1FA\U0001F1FF',
    u':VS_button:': u'\U0001F19A',
    u':Vanuatu:': u'\U0001F1FB\U0001F1FA',
    u':Vatican_City:': u'\U0001F1FB\U0001F1E6',
    u':Venezuela:': u'\U0001F1FB\U0001F1EA',
    u':Vietnam:': u'\U0001F1FB\U0001F1F3',
    u':Virgo:': u'\U0000264D',
    u':Wales:': u'\U0001F3F4\U000E0067\U000E0062\U000E0077\U000E006C\U000E0073\U000E007F',
    u':Wallis_&_Futuna:': u'\U0001F1FC\U0001F1EB',
    u':Western_Sahara:': u'\U0001F1EA\U0001F1ED',
    u':Yemen:': u'\U0001F1FE\U0001F1EA',
    u':Zambia:': u'\U0001F1FF\U0001F1F2',
    u':Zimbabwe:': u'\U0001F1FF\U0001F1FC',
    u':abacus:': u'\U0001F9EE',
    u':adhesive_bandage:': u'\U0001FA79',
    u':admission_tickets:': u'\U0001F39F',
    u':admission_tickets_selector:': u'\U0001F39F\U0000FE0F',
    u':adult:': u'\U0001F9D1',
    u':adult_dark_skin_tone:': u'\U0001F9D1\U0001F3FF',
    u':adult_light_skin_tone:': u'\U0001F9D1\U0001F3FB',
    u':adult_medium-dark_skin_tone:': u'\U0001F9D1\U0001F3FE',
    u':adult_medium-light_skin_tone:': u'\U0001F9D1\U0001F3FC',
    u':adult_medium_skin_tone:': u'\U0001F9D1\U0001F3FD',
    u':aerial_tramway:': u'\U0001F6A1',
    u':airplane:': u'\U00002708',
    u':airplane_arrival:': u'\U0001F6EC',
    u':airplane_departure:': u'\U0001F6EB',
    u':airplane_selector:': u'\U00002708\U0000FE0F',
    u':alarm_clock:': u'\U000023F0',
    u':alembic:': u'\U00002697',
    u':alembic_selector:': u'\U00002697\U0000FE0F',
    u':alien:': u'\U0001F47D',
    u':alien_monster:': u'\U0001F47E',
    u':ambulance:': u'\U0001F691',
    u':american_football:': u'\U0001F3C8',
    u':amphora:': u'\U0001F3FA',
    u':anchor:': u'\U00002693',
    u':anger_symbol:': u'\U0001F4A2',
    u':angry_face:': u'\U0001F620',
    u':angry_face_with_horns:': u'\U0001F47F',
    u':anguished_face:': u'\U0001F627',
    u':ant:': u'\U0001F41C',
    u':antenna_bars:': u'\U0001F4F6',
    u':anxious_face_with_sweat:': u'\U0001F630',
    u':articulated_lorry:': u'\U0001F69B',
    u':artist_palette:': u'\U0001F3A8',
    u':astonished_face:': u'\U0001F632',
    u':atom_symbol:': u'\U0000269B',
    u':atom_symbol_selector:': u'\U0000269B\U0000FE0F',
    u':auto_rickshaw:': u'\U0001F6FA',
    u':automobile:': u'\U0001F697',
    u':avocado:': u'\U0001F951',
    u':axe:': u'\U0001FA93',
    u':baby:': u'\U0001F476',
    u':baby_angel:': u'\U0001F47C',
    u':baby_angel_dark_skin_tone:': u'\U0001F47C\U0001F3FF',
    u':baby_angel_light_skin_tone:': u'\U0001F47C\U0001F3FB',
    u':baby_angel_medium-dark_skin_tone:': u'\U0001F47C\U0001F3FE',
    u':baby_angel_medium-light_skin_tone:': u'\U0001F47C\U0001F3FC',
    u':baby_angel_medium_skin_tone:': u'\U0001F47C\U0001F3FD',
    u':baby_bottle:': u'\U0001F37C',
    u':baby_chick:': u'\U0001F424',
    u':baby_dark_skin_tone:': u'\U0001F476\U0001F3FF',
    u':baby_light_skin_tone:': u'\U0001F476\U0001F3FB',
    u':baby_medium-dark_skin_tone:': u'\U0001F476\U0001F3FE',
    u':baby_medium-light_skin_tone:': u'\U0001F476\U0001F3FC',
    u':baby_medium_skin_tone:': u'\U0001F476\U0001F3FD',
    u':baby_symbol:': u'\U0001F6BC',
    u':backhand_index_pointing_down:': u'\U0001F447',
    u':backhand_index_pointing_down_dark_skin_tone:': u'\U0001F447\U0001F3FF',
    u':backhand_index_pointing_down_light_skin_tone:': u'\U0001F447\U0001F3FB',
    u':backhand_index_pointing_down_medium-dark_skin_tone:': u'\U0001F447\U0001F3FE',
    u':backhand_index_pointing_down_medium-light_skin_tone:': u'\U0001F447\U0001F3FC',
    u':backhand_index_pointing_down_medium_skin_tone:': u'\U0001F447\U0001F3FD',
    u':backhand_index_pointing_left:': u'\U0001F448',
    u':backhand_index_pointing_left_dark_skin_tone:': u'\U0001F448\U0001F3FF',
    u':backhand_index_pointing_left_light_skin_tone:': u'\U0001F448\U0001F3FB',
    u':backhand_index_pointing_left_medium-dark_skin_tone:': u'\U0001F448\U0001F3FE',
    u':backhand_index_pointing_left_medium-light_skin_tone:': u'\U0001F448\U0001F3FC',
    u':backhand_index_pointing_left_medium_skin_tone:': u'\U0001F448\U0001F3FD',
    u':backhand_index_pointing_right:': u'\U0001F449',
    u':backhand_index_pointing_right_dark_skin_tone:': u'\U0001F449\U0001F3FF',
    u':backhand_index_pointing_right_light_skin_tone:': u'\U0001F449\U0001F3FB',
    u':backhand_index_pointing_right_medium-dark_skin_tone:': u'\U0001F449\U0001F3FE',
    u':backhand_index_pointing_right_medium-light_skin_tone:': u'\U0001F449\U0001F3FC',
    u':backhand_index_pointing_right_medium_skin_tone:': u'\U0001F449\U0001F3FD',
    u':backhand_index_pointing_up:': u'\U0001F446',
    u':backhand_index_pointing_up_dark_skin_tone:': u'\U0001F446\U0001F3FF',
    u':backhand_index_pointing_up_light_skin_tone:': u'\U0001F446\U0001F3FB',
    u':backhand_index_pointing_up_medium-dark_skin_tone:': u'\U0001F446\U0001F3FE',
    u':backhand_index_pointing_up_medium-light_skin_tone:': u'\U0001F446\U0001F3FC',
    u':backhand_index_pointing_up_medium_skin_tone:': u'\U0001F446\U0001F3FD',
    u':bacon:': u'\U0001F953',
    u':badger:': u'\U0001F9A1',
    u':badminton:': u'\U0001F3F8',
    u':bagel:': u'\U0001F96F',
    u':baggage_claim:': u'\U0001F6C4',
    u':baguette_bread:': u'\U0001F956',
    u':balance_scale:': u'\U00002696',
    u':balance_scale_selector:': u'\U00002696\U0000FE0F',
    u':bald:': u'\U0001F9B2',
    u':bald_man:': u'\U0001F468\U0000200D\U0001F9B2',
    u':bald_woman:': u'\U0001F469\U0000200D\U0001F9B2',
    u':ballet_shoes:': u'\U0001FA70',
    u':balloon:': u'\U0001F388',
    u':ballot_box_with_ballot:': u'\U0001F5F3',
    u':ballot_box_with_ballot_selector:': u'\U0001F5F3\U0000FE0F',
    u':ballot_box_with_check:': u'\U00002611',
    u':banana:': u'\U0001F34C',
    u':banjo:': u'\U0001FA95',
    u':bank:': u'\U0001F3E6',
    u':bar_chart:': u'\U0001F4CA',
    u':barber_pole:': u'\U0001F488',
    u':baseball:': u'\U000026BE',
    u':basket:': u'\U0001F9FA',
    u':basketball:': u'\U0001F3C0',
    u':bat:': u'\U0001F987',
    u':bathtub:': u'\U0001F6C1',
    u':battery:': u'\U0001F50B',
    u':beach_with_umbrella:': u'\U0001F3D6',
    u':beach_with_umbrella_selector:': u'\U0001F3D6\U0000FE0F',
    u':beaming_face_with_smiling_eyes:': u'\U0001F601',
    u':bear_face:': u'\U0001F43B',
    u':bearded_person:': u'\U0001F9D4',
    u':bearded_person_dark_skin_tone:': u'\U0001F9D4\U0001F3FF',
    u':bearded_person_light_skin_tone:': u'\U0001F9D4\U0001F3FB',
    u':bearded_person_medium-dark_skin_tone:': u'\U0001F9D4\U0001F3FE',
    u':bearded_person_medium-light_skin_tone:': u'\U0001F9D4\U0001F3FC',
    u':bearded_person_medium_skin_tone:': u'\U0001F9D4\U0001F3FD',
    u':beating_heart:': u'\U0001F493',
    u':bed:': u'\U0001F6CF',
    u':bed_selector:': u'\U0001F6CF\U0000FE0F',
    u':beer_mug:': u'\U0001F37A',
    u':bell:': u'\U0001F514',
    u':bell_with_slash:': u'\U0001F515',
    u':bellhop_bell:': u'\U0001F6CE',
    u':bellhop_bell_selector:': u'\U0001F6CE\U0000FE0F',
    u':bento_box:': u'\U0001F371',
    u':beverage_box:': u'\U0001F9C3',
    u':bicycle:': u'\U0001F6B2',
    u':bikini:': u'\U0001F459',
    u':billed_cap:': u'\U0001F9E2',
    u':biohazard:': u'\U00002623',
    u':biohazard_selector:': u'\U00002623\U0000FE0F',
    u':bird:': u'\U0001F426',
    u':birthday_cake:': u'\U0001F382',
    u':black_circle:': u'\U000026AB',
    u':black_flag:': u'\U0001F3F4',
    u':black_heart:': u'\U0001F5A4',
    u':black_large_square:': u'\U00002B1B',
    u':black_medium-small_square:': u'\U000025FE',
    u':black_medium_square:': u'\U000025FC',
    u':black_medium_square_selector:': u'\U000025FC\U0000FE0F',
    u':black_nib:': u'\U00002712',
    u':black_nib_selector:': u'\U00002712\U0000FE0F',
    u':black_small_square:': u'\U000025AA',
    u':black_small_square_selector:': u'\U000025AA\U0000FE0F',
    u':black_square_button:': u'\U0001F532',
    u':blond-haired_man:': u'\U0001F471\U0000200D\U00002642\U0000FE0F',
    u':blond-haired_man_dark_skin_tone:': u'\U0001F471\U0001F3FF\U0000200D\U00002642\U0000FE0F',
    u':blond-haired_man_light_skin_tone:': u'\U0001F471\U0001F3FB\U0000200D\U00002642\U0000FE0F',
    u':blond-haired_man_medium-dark_skin_tone:': u'\U0001F471\U0001F3FE\U0000200D\U00002642\U0000FE0F',
    u':blond-haired_man_medium-light_skin_tone:': u'\U0001F471\U0001F3FC\U0000200D\U00002642\U0000FE0F',
    u':blond-haired_man_medium_skin_tone:': u'\U0001F471\U0001F3FD\U0000200D\U00002642\U0000FE0F',
    u':blond-haired_person:': u'\U0001F471',
    u':blond-haired_person_dark_skin_tone:': u'\U0001F471\U0001F3FF',
    u':blond-haired_person_light_skin_tone:': u'\U0001F471\U0001F3FB',
    u':blond-haired_person_medium-dark_skin_tone:': u'\U0001F471\U0001F3FE',
    u':blond-haired_person_medium-light_skin_tone:': u'\U0001F471\U0001F3FC',
    u':blond-haired_person_medium_skin_tone:': u'\U0001F471\U0001F3FD',
    u':blond-haired_woman:': u'\U0001F471\U0000200D\U00002640\U0000FE0F',
    u':blond-haired_woman_dark_skin_tone:': u'\U0001F471\U0001F3FF\U0000200D\U00002640\U0000FE0F',
    u':blond-haired_woman_light_skin_tone:': u'\U0001F471\U0001F3FB\U0000200D\U00002640\U0000FE0F',
    u':blond-haired_woman_medium-dark_skin_tone:': u'\U0001F471\U0001F3FE\U0000200D\U00002640\U0000FE0F',
    u':blond-haired_woman_medium-light_skin_tone:': u'\U0001F471\U0001F3FC\U0000200D\U00002640\U0000FE0F',
    u':blond-haired_woman_medium_skin_tone:': u'\U0001F471\U0001F3FD\U0000200D\U00002640\U0000FE0F',
    u':blossom:': u'\U0001F33C',
    u':blowfish:': u'\U0001F421',
    u':blue_book:': u'\U0001F4D8',
    u':blue_circle:': u'\U0001F535',
    u':blue_heart:': u'\U0001F499',
    u':blue_square:': u'\U0001F7E6',
    u':boar:': u'\U0001F417',
    u':bomb:': u'\U0001F4A3',
    u':bone:': u'\U0001F9B4',
    u':bookmark:': u'\U0001F516',
    u':bookmark_tabs:': u'\U0001F4D1',
    u':books:': u'\U0001F4DA',
    u':bottle_with_popping_cork:': u'\U0001F37E',
    u':bouquet:': u'\U0001F490',
    u':bow_and_arrow:': u'\U0001F3F9',
    u':bowl_with_spoon:': u'\U0001F963',
    u':bowling:': u'\U0001F3B3',
    u':boxing_glove:': u'\U0001F94A',
    u':boy:': u'\U0001F466',
    u':boy_dark_skin_tone:': u'\U0001F466\U0001F3FF',
    u':boy_light_skin_tone:': u'\U0001F466\U0001F3FB',
    u':boy_medium-dark_skin_tone:': u'\U0001F466\U0001F3FE',
    u':boy_medium-light_skin_tone:': u'\U0001F466\U0001F3FC',
    u':boy_medium_skin_tone:': u'\U0001F466\U0001F3FD',
    u':brain:': u'\U0001F9E0',
    u':bread:': u'\U0001F35E',
    u':breast-feeding:': u'\U0001F931',
    u':breast-feeding_dark_skin_tone:': u'\U0001F931\U0001F3FF',
    u':breast-feeding_light_skin_tone:': u'\U0001F931\U0001F3FB',
    u':breast-feeding_medium-dark_skin_tone:': u'\U0001F931\U0001F3FE',
    u':breast-feeding_medium-light_skin_tone:': u'\U0001F931\U0001F3FC',
    u':breast-feeding_medium_skin_tone:': u'\U0001F931\U0001F3FD',
    u':brick:': u'\U0001F9F1',
    u':bride_with_veil:': u'\U0001F470',
    u':bride_with_veil_dark_skin_tone:': u'\U0001F470\U0001F3FF',
    u':bride_with_veil_light_skin_tone:': u'\U0001F470\U0001F3FB',
    u':bride_with_veil_medium-dark_skin_tone:': u'\U0001F470\U0001F3FE',
    u':bride_with_veil_medium-light_skin_tone:': u'\U0001F470\U0001F3FC',
    u':bride_with_veil_medium_skin_tone:': u'\U0001F470\U0001F3FD',
    u':bridge_at_night:': u'\U0001F309',
    u':briefcase:': u'\U0001F4BC',
    u':briefs:': u'\U0001FA72',
    u':bright_button:': u'\U0001F506',
    u':broccoli:': u'\U0001F966',
    u':broken_heart:': u'\U0001F494',
    u':broom:': u'\U0001F9F9',
    u':brown_circle:': u'\U0001F7E4',
    u':brown_heart:': u'\U0001F90E',
    u':brown_square:': u'\U0001F7EB',
    u':bug:': u'\U0001F41B',
    u':building_construction:': u'\U0001F3D7',
    u':building_construction_selector:': u'\U0001F3D7\U0000FE0F',
    u':bullet_train:': u'\U0001F685',
    u':burrito:': u'\U0001F32F',
    u':bus:': u'\U0001F68C',
    u':bus_stop:': u'\U0001F68F',
    u':bust_in_silhouette:': u'\U0001F464',
    u':busts_in_silhouette:': u'\U0001F465',
    u':butter:': u'\U0001F9C8',
    u':butterfly:': u'\U0001F98B',
    u':cactus:': u'\U0001F335',
    u':calendar:': u'\U0001F4C5',
    u':call_me_hand:': u'\U0001F919',
    u':call_me_hand_dark_skin_tone:': u'\U0001F919\U0001F3FF',
    u':call_me_hand_light_skin_tone:': u'\U0001F919\U0001F3FB',
    u':call_me_hand_medium-dark_skin_tone:': u'\U0001F919\U0001F3FE',
    u':call_me_hand_medium-light_skin_tone:': u'\U0001F919\U0001F3FC',
    u':call_me_hand_medium_skin_tone:': u'\U0001F919\U0001F3FD',
    u':camel:': u'\U0001F42A',
    u':camera:': u'\U0001F4F7',
    u':camera_with_flash:': u'\U0001F4F8',
    u':camping:': u'\U0001F3D5',
    u':camping_selector:': u'\U0001F3D5\U0000FE0F',
    u':candle:': u'\U0001F56F',
    u':candle_selector:': u'\U0001F56F\U0000FE0F',
    u':candy:': u'\U0001F36C',
    u':canned_food:': u'\U0001F96B',
    u':canoe:': u'\U0001F6F6',
    u':card_file_box:': u'\U0001F5C3',
    u':card_file_box_selector:': u'\U0001F5C3\U0000FE0F',
    u':card_index:': u'\U0001F4C7',
    u':card_index_dividers:': u'\U0001F5C2',
    u':card_index_dividers_selector:': u'\U0001F5C2\U0000FE0F',
    u':carousel_horse:': u'\U0001F3A0',
    u':carp_streamer:': u'\U0001F38F',
    u':carrot:': u'\U0001F955',
    u':castle:': u'\U0001F3F0',
    u':cat:': u'\U0001F408',
    u':cat_face:': u'\U0001F431',
    u':cat_face_with_tears_of_joy:': u'\U0001F639',
    u':cat_face_with_wry_smile:': u'\U0001F63C',
    u':chains:': u'\U000026D3',
    u':chains_selector:': u'\U000026D3\U0000FE0F',
    u':chair:': u'\U0001FA91',
    u':chart_decreasing:': u'\U0001F4C9',
    u':chart_increasing:': u'\U0001F4C8',
    u':chart_increasing_with_yen:': u'\U0001F4B9',
    u':check_box_with_check:': u'\U00002611\U0000FE0F',
    u':check_mark:': u'\U00002714\U0000FE0F',
    u':cheese_wedge:': u'\U0001F9C0',
    u':chequered_flag:': u'\U0001F3C1',
    u':cherries:': u'\U0001F352',
    u':cherry_blossom:': u'\U0001F338',
    u':chess_pawn:': u'\U0000265F',
    u':chess_pawn_selector:': u'\U0000265F\U0000FE0F',
    u':chestnut:': u'\U0001F330',
    u':chicken:': u'\U0001F414',
    u':child:': u'\U0001F9D2',
    u':child_dark_skin_tone:': u'\U0001F9D2\U0001F3FF',
    u':child_light_skin_tone:': u'\U0001F9D2\U0001F3FB',
    u':child_medium-dark_skin_tone:': u'\U0001F9D2\U0001F3FE',
    u':child_medium-light_skin_tone:': u'\U0001F9D2\U0001F3FC',
    u':child_medium_skin_tone:': u'\U0001F9D2\U0001F3FD',
    u':children_crossing:': u'\U0001F6B8',
    u':chipmunk:': u'\U0001F43F',
    u':chipmunk_selector:': u'\U0001F43F\U0000FE0F',
    u':chocolate_bar:': u'\U0001F36B',
    u':chopsticks:': u'\U0001F962',
    u':church:': u'\U000026EA',
    u':cigarette:': u'\U0001F6AC',
    u':cinema:': u'\U0001F3A6',
    u':circled_M:': u'\U000024C2',
    u':circled_M_selector:': u'\U000024C2\U0000FE0F',
    u':circus_tent:': u'\U0001F3AA',
    u':cityscape:': u'\U0001F3D9',
    u':cityscape_at_dusk:': u'\U0001F306',
    u':cityscape_selector:': u'\U0001F3D9\U0000FE0F',
    u':clamp:': u'\U0001F5DC',
    u':clamp_selector:': u'\U0001F5DC\U0000FE0F',
    u':clapper_board:': u'\U0001F3AC',
    u':clapping_hands:': u'\U0001F44F',
    u':clapping_hands_dark_skin_tone:': u'\U0001F44F\U0001F3FF',
    u':clapping_hands_light_skin_tone:': u'\U0001F44F\U0001F3FB',
    u':clapping_hands_medium-dark_skin_tone:': u'\U0001F44F\U0001F3FE',
    u':clapping_hands_medium-light_skin_tone:': u'\U0001F44F\U0001F3FC',
    u':clapping_hands_medium_skin_tone:': u'\U0001F44F\U0001F3FD',
    u':classical_building:': u'\U0001F3DB',
    u':classical_building_selector:': u'\U0001F3DB\U0000FE0F',
    u':clinking_beer_mugs:': u'\U0001F37B',
    u':clinking_glasses:': u'\U0001F942',
    u':clipboard:': u'\U0001F4CB',
    u':clockwise_vertical_arrows:': u'\U0001F503',
    u':closed_book:': u'\U0001F4D5',
    u':closed_mailbox_with_lowered_flag:': u'\U0001F4EA',
    u':closed_mailbox_with_raised_flag:': u'\U0001F4EB',
    u':closed_umbrella:': u'\U0001F302',
    u':cloud:': u'\U00002601',
    u':cloud_selector:': u'\U00002601\U0000FE0F',
    u':cloud_with_lightning:': u'\U0001F329',
    u':cloud_with_lightning_and_rain:': u'\U000026C8',
    u':cloud_with_lightning_and_rain_selector:': u'\U000026C8\U0000FE0F',
    u':cloud_with_lightning_selector:': u'\U0001F329\U0000FE0F',
    u':cloud_with_rain:': u'\U0001F327',
    u':cloud_with_rain_selector:': u'\U0001F327\U0000FE0F',
    u':cloud_with_snow:': u'\U0001F328',
    u':cloud_with_snow_selector:': u'\U0001F328\U0000FE0F',
    u':clown_face:': u'\U0001F921',
    u':club_suit:': u'\U00002663',
    u':club_suit_selector:': u'\U00002663\U0000FE0F',
    u':clutch_bag:': u'\U0001F45D',
    u':coat:': u'\U0001F9E5',
    u':cocktail_glass:': u'\U0001F378',
    u':coconut:': u'\U0001F965',
    u':coffin:': u'\U000026B0',
    u':coffin_selector:': u'\U000026B0\U0000FE0F',
    u':cold_face:': u'\U0001F976',
    u':collision:': u'\U0001F4A5',
    u':comet:': u'\U00002604',
    u':comet_selector:': u'\U00002604\U0000FE0F',
    u':compass:': u'\U0001F9ED',
    u':computer_disk:': u'\U0001F4BD',
    u':computer_mouse:': u'\U0001F5B1',
    u':computer_mouse_selector:': u'\U0001F5B1\U0000FE0F',
    u':confetti_ball:': u'\U0001F38A',
    u':confounded_face:': u'\U0001F616',
    u':confused_face:': u'\U0001F615',
    u':construction:': u'\U0001F6A7',
    u':construction_worker:': u'\U0001F477',
    u':construction_worker_dark_skin_tone:': u'\U0001F477\U0001F3FF',
    u':construction_worker_light_skin_tone:': u'\U0001F477\U0001F3FB',
    u':construction_worker_medium-dark_skin_tone:': u'\U0001F477\U0001F3FE',
    u':construction_worker_medium-light_skin_tone:': u'\U0001F477\U0001F3FC',
    u':construction_worker_medium_skin_tone:': u'\U0001F477\U0001F3FD',
    u':control_knobs:': u'\U0001F39B',
    u':control_knobs_selector:': u'\U0001F39B\U0000FE0F',
    u':convenience_store:': u'\U0001F3EA',
    u':cooked_rice:': u'\U0001F35A',
    u':cookie:': u'\U0001F36A',
    u':cooking:': u'\U0001F373',
    u':copyright:': u'\U000000A9',
    u':copyright_selector:': u'\U000000A9\U0000FE0F',
    u':couch_and_lamp:': u'\U0001F6CB',
    u':couch_and_lamp_selector:': u'\U0001F6CB\U0000FE0F',
    u':counterclockwise_arrows_button:': u'\U0001F504',
    u':couple_with_heart-man-man:': u'\U0001F468\U0000200D\U00002764\U0000200D\U0001F468',
    u':couple_with_heart-woman-man:': u'\U0001F469\U0000200D\U00002764\U0000200D\U0001F468',
    u':couple_with_heart-woman-woman:': u'\U0001F469\U0000200D\U00002764\U0000200D\U0001F469',
    u':couple_with_heart:': u'\U0001F491',
    u':couple_with_heart_man_man:': u'\U0001F468\U0000200D\U00002764\U0000FE0F\U0000200D\U0001F468',
    u':couple_with_heart_woman_man:': u'\U0001F469\U0000200D\U00002764\U0000FE0F\U0000200D\U0001F468',
    u':couple_with_heart_woman_woman:': u'\U0001F469\U0000200D\U00002764\U0000FE0F\U0000200D\U0001F469',
    u':cow:': u'\U0001F404',
    u':cow_face:': u'\U0001F42E',
    u':cowboy_hat_face:': u'\U0001F920',
    u':crab:': u'\U0001F980',
    u':crayon:': u'\U0001F58D',
    u':crayon_selector:': u'\U0001F58D\U0000FE0F',
    u':credit_card:': u'\U0001F4B3',
    u':crescent_moon:': u'\U0001F319',
    u':cricket:': u'\U0001F997',
    u':cricket_game:': u'\U0001F3CF',
    u':crocodile:': u'\U0001F40A',
    u':croissant:': u'\U0001F950',
    u':cross_mark:': u'\U0000274C',
    u':cross_mark_button:': u'\U0000274E',
    u':crossed_fingers:': u'\U0001F91E',
    u':crossed_fingers_dark_skin_tone:': u'\U0001F91E\U0001F3FF',
    u':crossed_fingers_light_skin_tone:': u'\U0001F91E\U0001F3FB',
    u':crossed_fingers_medium-dark_skin_tone:': u'\U0001F91E\U0001F3FE',
    u':crossed_fingers_medium-light_skin_tone:': u'\U0001F91E\U0001F3FC',
    u':crossed_fingers_medium_skin_tone:': u'\U0001F91E\U0001F3FD',
    u':crossed_flags:': u'\U0001F38C',
    u':crossed_swords:': u'\U00002694',
    u':crossed_swords_selector:': u'\U00002694\U0000FE0F',
    u':crown:': u'\U0001F451',
    u':crying_cat_face:': u'\U0001F63F',
    u':crying_face:': u'\U0001F622',
    u':crystal_ball:': u'\U0001F52E',
    u':cucumber:': u'\U0001F952',
    u':cup_with_straw:': u'\U0001F964',
    u':cupcake:': u'\U0001F9C1',
    u':curling_stone:': u'\U0001F94C',
    u':curly-haired_man:': u'\U0001F468\U0000200D\U0001F9B1',
    u':curly-haired_woman:': u'\U0001F469\U0000200D\U0001F9B1',
    u':curly_hair:': u'\U0001F9B1',
    u':curly_loop:': u'\U000027B0',
    u':currency_exchange:': u'\U0001F4B1',
    u':curry_rice:': u'\U0001F35B',
    u':custard:': u'\U0001F36E',
    u':customs:': u'\U0001F6C3',
    u':cut_of_meat:': u'\U0001F969',
    u':cyclone:': u'\U0001F300',
    u':dagger:': u'\U0001F5E1',
    u':dagger_selector:': u'\U0001F5E1\U0000FE0F',
    u':dango:': u'\U0001F361',
    u':dark_skin_tone:': u'\U0001F3FF',
    u':dashing_away:': u'\U0001F4A8',
    u':deaf_man-dark_skin_tone:': u'\U0001F9CF\U0001F3FF\U0000200D\U00002642',
    u':deaf_man-dark_skin_tone_selector:': u'\U0001F9CF\U0001F3FF\U0000200D\U00002642\U0000FE0F',
    u':deaf_man-light_skin_tone:': u'\U0001F9CF\U0001F3FB\U0000200D\U00002642',
    u':deaf_man-light_skin_tone_selector:': u'\U0001F9CF\U0001F3FB\U0000200D\U00002642\U0000FE0F',
    u':deaf_man-medium-dark_skin_tone:': u'\U0001F9CF\U0001F3FE\U0000200D\U00002642',
    u':deaf_man-medium-dark_skin_tone_selector:': u'\U0001F9CF\U0001F3FE\U0000200D\U00002642\U0000FE0F',
    u':deaf_man-medium-light_skin_tone:': u'\U0001F9CF\U0001F3FC\U0000200D\U00002642',
    u':deaf_man-medium-light_skin_tone_selector:': u'\U0001F9CF\U0001F3FC\U0000200D\U00002642\U0000FE0F',
    u':deaf_man-medium_skin_tone:': u'\U0001F9CF\U0001F3FD\U0000200D\U00002642',
    u':deaf_man-medium_skin_tone_selector:': u'\U0001F9CF\U0001F3FD\U0000200D\U00002642\U0000FE0F',
    u':deaf_man:': u'\U0001F9CF\U0000200D\U00002642',
    u':deaf_man_selector:': u'\U0001F9CF\U0000200D\U00002642\U0000FE0F',
    u':deaf_person-dark_skin_tone:': u'\U0001F9CF\U0001F3FF',
    u':deaf_person-light_skin_tone:': u'\U0001F9CF\U0001F3FB',
    u':deaf_person-medium-dark_skin_tone:': u'\U0001F9CF\U0001F3FE',
    u':deaf_person-medium-light_skin_tone:': u'\U0001F9CF\U0001F3FC',
    u':deaf_person-medium_skin_tone:': u'\U0001F9CF\U0001F3FD',
    u':deaf_person:': u'\U0001F9CF',
    u':deaf_woman-dark_skin_tone:': u'\U0001F9CF\U0001F3FF\U0000200D\U00002640',
    u':deaf_woman-dark_skin_tone_selector:': u'\U0001F9CF\U0001F3FF\U0000200D\U00002640\U0000FE0F',
    u':deaf_woman-light_skin_tone:': u'\U0001F9CF\U0001F3FB\U0000200D\U00002640',
    u':deaf_woman-light_skin_tone_selector:': u'\U0001F9CF\U0001F3FB\U0000200D\U00002640\U0000FE0F',
    u':deaf_woman-medium-dark_skin_tone:': u'\U0001F9CF\U0001F3FE\U0000200D\U00002640',
    u':deaf_woman-medium-dark_skin_tone_selector:': u'\U0001F9CF\U0001F3FE\U0000200D\U00002640\U0000FE0F',
    u':deaf_woman-medium-light_skin_tone:': u'\U0001F9CF\U0001F3FC\U0000200D\U00002640',
    u':deaf_woman-medium-light_skin_tone_selector:': u'\U0001F9CF\U0001F3FC\U0000200D\U00002640\U0000FE0F',
    u':deaf_woman-medium_skin_tone:': u'\U0001F9CF\U0001F3FD\U0000200D\U00002640',
    u':deaf_woman-medium_skin_tone_selector:': u'\U0001F9CF\U0001F3FD\U0000200D\U00002640\U0000FE0F',
    u':deaf_woman:': u'\U0001F9CF\U0000200D\U00002640',
    u':deaf_woman_selector:': u'\U0001F9CF\U0000200D\U00002640\U0000FE0F',
    u':deciduous_tree:': u'\U0001F333',
    u':deer:': u'\U0001F98C',
    u':delivery_truck:': u'\U0001F69A',
    u':department_store:': u'\U0001F3EC',
    u':derelict_house:': u'\U0001F3DA',
    u':derelict_house_selector:': u'\U0001F3DA\U0000FE0F',
    u':desert:': u'\U0001F3DC',
    u':desert_island:': u'\U0001F3DD',
    u':desert_island_selector:': u'\U0001F3DD\U0000FE0F',
    u':desert_selector:': u'\U0001F3DC\U0000FE0F',
    u':desktop_computer:': u'\U0001F5A5',
    u':desktop_computer_selector:': u'\U0001F5A5\U0000FE0F',
    u':detective:': u'\U0001F575',
    u':detective_dark_skin_tone:': u'\U0001F575\U0001F3FF',
    u':detective_light_skin_tone:': u'\U0001F575\U0001F3FB',
    u':detective_medium-dark_skin_tone:': u'\U0001F575\U0001F3FE',
    u':detective_medium-light_skin_tone:': u'\U0001F575\U0001F3FC',
    u':detective_medium_skin_tone:': u'\U0001F575\U0001F3FD',
    u':detective_selector:': u'\U0001F575\U0000FE0F',
    u':diamond_suit:': u'\U00002666',
    u':diamond_suit_selector:': u'\U00002666\U0000FE0F',
    u':diamond_with_a_dot:': u'\U0001F4A0',
    u':dim_button:': u'\U0001F505',
    u':direct_hit:': u'\U0001F3AF',
    u':disappointed_face:': u'\U0001F61E',
    u':diving_mask:': u'\U0001F93F',
    u':diya_lamp:': u'\U0001FA94',
    u':dizzy:': u'\U0001F4AB',
    u':dizzy_face:': u'\U0001F635',
    u':dna:': u'\U0001F9EC',
    u':dog:': u'\U0001F415',
    u':dog_face:': u'\U0001F436',
    u':dollar_banknote:': u'\U0001F4B5',
    u':dolphin:': u'\U0001F42C',
    u':door:': u'\U0001F6AA',
    u':dotted_six-pointed_star:': u'\U0001F52F',
    u':double_curly_loop:': u'\U000027BF',
    u':double_exclamation_mark:': u'\U0000203C',
    u':double_exclamation_mark_selector:': u'\U0000203C\U0000FE0F',
    u':doughnut:': u'\U0001F369',
    u':dove:': u'\U0001F54A',
    u':dove_selector:': u'\U0001F54A\U0000FE0F',
    u':down-left_arrow:': u'\U00002199',
    u':down-left_arrow_selector:': u'\U00002199\U0000FE0F',
    u':down-right_arrow:': u'\U00002198',
    u':down-right_arrow_selector:': u'\U00002198\U0000FE0F',
    u':down_arrow:': u'\U00002B07',
    u':down_arrow_selector:': u'\U00002B07\U0000FE0F',
    u':downcast_face_with_sweat:': u'\U0001F613',
    u':downwards_button:': u'\U0001F53D',
    u':dragon:': u'\U0001F409',
    u':dragon_face:': u'\U0001F432',
    u':dress:': u'\U0001F457',
    u':drooling_face:': u'\U0001F924',
    u':drop_of_blood:': u'\U0001FA78',
    u':droplet:': u'\U0001F4A7',
    u':drum:': u'\U0001F941',
    u':duck:': u'\U0001F986',
    u':dumpling:': u'\U0001F95F',
    u':dvd:': u'\U0001F4C0',
    u':e-mail:': u'\U0001F4E7',
    u':eagle:': u'\U0001F985',
    u':ear:': u'\U0001F442',
    u':ear_dark_skin_tone:': u'\U0001F442\U0001F3FF',
    u':ear_light_skin_tone:': u'\U0001F442\U0001F3FB',
    u':ear_medium-dark_skin_tone:': u'\U0001F442\U0001F3FE',
    u':ear_medium-light_skin_tone:': u'\U0001F442\U0001F3FC',
    u':ear_medium_skin_tone:': u'\U0001F442\U0001F3FD',
    u':ear_of_corn:': u'\U0001F33D',
    u':ear_with_hearing_aid-dark_skin_tone:': u'\U0001F9BB\U0001F3FF',
    u':ear_with_hearing_aid-light_skin_tone:': u'\U0001F9BB\U0001F3FB',
    u':ear_with_hearing_aid-medium-dark_skin_tone:': u'\U0001F9BB\U0001F3FE',
    u':ear_with_hearing_aid-medium-light_skin_tone:': u'\U0001F9BB\U0001F3FC',
    u':ear_with_hearing_aid-medium_skin_tone:': u'\U0001F9BB\U0001F3FD',
    u':ear_with_hearing_aid:': u'\U0001F9BB',
    u':egg:': u'\U0001F95A',
    u':eggplant:': u'\U0001F346',
    u':eight-pointed_star:': u'\U00002734',
    u':eight-pointed_star_selector:': u'\U00002734\U0000FE0F',
    u':eight-spoked_asterisk:': u'\U00002733',
    u':eight-spoked_asterisk_selector:': u'\U00002733\U0000FE0F',
    u':eight-thirty:': u'\U0001F563',
    u':eight_o\u2019clock:': u'\U0001F557',
    u':eject_button:': u'\U000023CF',
    u':eject_button_selector:': u'\U000023CF\U0000FE0F',
    u':electric_plug:': u'\U0001F50C',
    u':elephant:': u'\U0001F418',
    u':eleven-thirty:': u'\U0001F566',
    u':eleven_o\u2019clock:': u'\U0001F55A',
    u':elf:': u'\U0001F9DD',
    u':elf_dark_skin_tone:': u'\U0001F9DD\U0001F3FF',
    u':elf_light_skin_tone:': u'\U0001F9DD\U0001F3FB',
    u':elf_medium-dark_skin_tone:': u'\U0001F9DD\U0001F3FE',
    u':elf_medium-light_skin_tone:': u'\U0001F9DD\U0001F3FC',
    u':elf_medium_skin_tone:': u'\U0001F9DD\U0001F3FD',
    u':envelope:': u'\U00002709',
    u':envelope_selector:': u'\U00002709\U0000FE0F',
    u':envelope_with_arrow:': u'\U0001F4E9',
    u':euro_banknote:': u'\U0001F4B6',
    u':evergreen_tree:': u'\U0001F332',
    u':ewe:': u'\U0001F411',
    u':exclamation_mark:': u'\U00002757',
    u':exclamation_question_mark:': u'\U00002049',
    u':exclamation_question_mark_selector:': u'\U00002049\U0000FE0F',
    u':exploding_head:': u'\U0001F92F',
    u':expressionless_face:': u'\U0001F611',
    u':eye:': u'\U0001F441',
    u':eye_in_speech_bubble:': u'\U0001F441\U0000200D\U0001F5E8',
    u':eye_in_speech_bubble_2:': u'\U0001F441\U0000200D\U0001F5E8\U0000FE0F',
    u':eye_in_speech_bubble_3:': u'\U0001F441\U0000FE0F\U0000200D\U0001F5E8\U0000FE0F',
    u':eye_in_speech_bubble_selector:': u'\U0001F441\U0000FE0F\U0000200D\U0001F5E8',
    u':eye_selector:': u'\U0001F441\U0000FE0F',
    u':eyes:': u'\U0001F440',
    u':face_blowing_a_kiss:': u'\U0001F618',
    u':face_savoring_food:': u'\U0001F60B',
    u':face_screaming_in_fear:': u'\U0001F631',
    u':face_vomiting:': u'\U0001F92E',
    u':face_with_hand_over_mouth:': u'\U0001F92D',
    u':face_with_head-bandage:': u'\U0001F915',
    u':face_with_medical_mask:': u'\U0001F637',
    u':face_with_monocle:': u'\U0001F9D0',
    u':face_with_open_mouth:': u'\U0001F62E',
    u':face_with_raised_eyebrow:': u'\U0001F928',
    u':face_with_rolling_eyes:': u'\U0001F644',
    u':face_with_steam_from_nose:': u'\U0001F624',
    u':face_with_symbols_on_mouth:': u'\U0001F92C',
    u':face_with_tears_of_joy:': u'\U0001F602',
    u':face_with_thermometer:': u'\U0001F912',
    u':face_with_tongue:': u'\U0001F61B',
    u':face_without_mouth:': u'\U0001F636',
    u':factory:': u'\U0001F3ED',
    u':fairy:': u'\U0001F9DA',
    u':fairy_dark_skin_tone:': u'\U0001F9DA\U0001F3FF',
    u':fairy_light_skin_tone:': u'\U0001F9DA\U0001F3FB',
    u':fairy_medium-dark_skin_tone:': u'\U0001F9DA\U0001F3FE',
    u':fairy_medium-light_skin_tone:': u'\U0001F9DA\U0001F3FC',
    u':fairy_medium_skin_tone:': u'\U0001F9DA\U0001F3FD',
    u':falafel:': u'\U0001F9C6',
    u':fallen_leaf:': u'\U0001F342',
    u':family:': u'\U0001F46A',
    u':family_man_boy:': u'\U0001F468\U0000200D\U0001F466',
    u':family_man_boy_boy:': u'\U0001F468\U0000200D\U0001F466\U0000200D\U0001F466',
    u':family_man_girl:': u'\U0001F468\U0000200D\U0001F467',
    u':family_man_girl_boy:': u'\U0001F468\U0000200D\U0001F467\U0000200D\U0001F466',
    u':family_man_girl_girl:': u'\U0001F468\U0000200D\U0001F467\U0000200D\U0001F467',
    u':family_man_man_boy:': u'\U0001F468\U0000200D\U0001F468\U0000200D\U0001F466',
    u':family_man_man_boy_boy:': u'\U0001F468\U0000200D\U0001F468\U0000200D\U0001F466\U0000200D\U0001F466',
    u':family_man_man_girl:': u'\U0001F468\U0000200D\U0001F468\U0000200D\U0001F467',
    u':family_man_man_girl_boy:': u'\U0001F468\U0000200D\U0001F468\U0000200D\U0001F467\U0000200D\U0001F466',
    u':family_man_man_girl_girl:': u'\U0001F468\U0000200D\U0001F468\U0000200D\U0001F467\U0000200D\U0001F467',
    u':family_man_woman_boy:': u'\U0001F468\U0000200D\U0001F469\U0000200D\U0001F466',
    u':family_man_woman_boy_boy:': u'\U0001F468\U0000200D\U0001F469\U0000200D\U0001F466\U0000200D\U0001F466',
    u':family_man_woman_girl:': u'\U0001F468\U0000200D\U0001F469\U0000200D\U0001F467',
    u':family_man_woman_girl_boy:': u'\U0001F468\U0000200D\U0001F469\U0000200D\U0001F467\U0000200D\U0001F466',
    u':family_man_woman_girl_girl:': u'\U0001F468\U0000200D\U0001F469\U0000200D\U0001F467\U0000200D\U0001F467',
    u':family_woman_boy:': u'\U0001F469\U0000200D\U0001F466',
    u':family_woman_boy_boy:': u'\U0001F469\U0000200D\U0001F466\U0000200D\U0001F466',
    u':family_woman_girl:': u'\U0001F469\U0000200D\U0001F467',
    u':family_woman_girl_boy:': u'\U0001F469\U0000200D\U0001F467\U0000200D\U0001F466',
    u':family_woman_girl_girl:': u'\U0001F469\U0000200D\U0001F467\U0000200D\U0001F467',
    u':family_woman_woman_boy:': u'\U0001F469\U0000200D\U0001F469\U0000200D\U0001F466',
    u':family_woman_woman_boy_boy:': u'\U0001F469\U0000200D\U0001F469\U0000200D\U0001F466\U0000200D\U0001F466',
    u':family_woman_woman_girl:': u'\U0001F469\U0000200D\U0001F469\U0000200D\U0001F467',
    u':family_woman_woman_girl_boy:': u'\U0001F469\U0000200D\U0001F469\U0000200D\U0001F467\U0000200D\U0001F466',
    u':family_woman_woman_girl_girl:': u'\U0001F469\U0000200D\U0001F469\U0000200D\U0001F467\U0000200D\U0001F467',
    u':fast-forward_button:': u'\U000023E9',
    u':fast_down_button:': u'\U000023EC',
    u':fast_reverse_button:': u'\U000023EA',
    u':fast_up_button:': u'\U000023EB',
    u':fax_machine:': u'\U0001F4E0',
    u':fearful_face:': u'\U0001F628',
    u':female_sign:': u'\U00002640',
    u':female_sign_selector:': u'\U00002640\U0000FE0F',
    u':ferris_wheel:': u'\U0001F3A1',
    u':ferry:': u'\U000026F4',
    u':ferry_selector:': u'\U000026F4\U0000FE0F',
    u':field_hockey:': u'\U0001F3D1',
    u':file_cabinet:': u'\U0001F5C4',
    u':file_cabinet_selector:': u'\U0001F5C4\U0000FE0F',
    u':file_folder:': u'\U0001F4C1',
    u':film_frames:': u'\U0001F39E',
    u':film_frames_selector:': u'\U0001F39E\U0000FE0F',
    u':film_projector:': u'\U0001F4FD',
    u':film_projector_selector:': u'\U0001F4FD\U0000FE0F',
    u':fire:': u'\U0001F525',
    u':fire_engine:': u'\U0001F692',
    u':fire_extinguisher:': u'\U0001F9EF',
    u':firecracker:': u'\U0001F9E8',
    u':fireworks:': u'\U0001F386',
    u':first_quarter_moon:': u'\U0001F313',
    u':first_quarter_moon_face:': u'\U0001F31B',
    u':fish:': u'\U0001F41F',
    u':fish_cake_with_swirl:': u'\U0001F365',
    u':fishing_pole:': u'\U0001F3A3',
    u':five-thirty:': u'\U0001F560',
    u':five_o\u2019clock:': u'\U0001F554',
    u':flag_in_hole:': u'\U000026F3',
    u':flamingo:': u'\U0001F9A9',
    u':flashlight:': u'\U0001F526',
    u':flat_shoe:': u'\U0001F97F',
    u':fleur-de-lis:': u'\U0000269C',
    u':fleur-de-lis_selector:': u'\U0000269C\U0000FE0F',
    u':flexed_biceps:': u'\U0001F4AA',
    u':flexed_biceps_dark_skin_tone:': u'\U0001F4AA\U0001F3FF',
    u':flexed_biceps_light_skin_tone:': u'\U0001F4AA\U0001F3FB',
    u':flexed_biceps_medium-dark_skin_tone:': u'\U0001F4AA\U0001F3FE',
    u':flexed_biceps_medium-light_skin_tone:': u'\U0001F4AA\U0001F3FC',
    u':flexed_biceps_medium_skin_tone:': u'\U0001F4AA\U0001F3FD',
    u':floppy_disk:': u'\U0001F4BE',
    u':flower_playing_cards:': u'\U0001F3B4',
    u':flushed_face:': u'\U0001F633',
    u':flying_disc:': u'\U0001F94F',
    u':flying_saucer:': u'\U0001F6F8',
    u':fog:': u'\U0001F32B',
    u':fog_selector:': u'\U0001F32B\U0000FE0F',
    u':foggy:': u'\U0001F301',
    u':folded_hands:': u'\U0001F64F',
    u':folded_hands_dark_skin_tone:': u'\U0001F64F\U0001F3FF',
    u':folded_hands_light_skin_tone:': u'\U0001F64F\U0001F3FB',
    u':folded_hands_medium-dark_skin_tone:': u'\U0001F64F\U0001F3FE',
    u':folded_hands_medium-light_skin_tone:': u'\U0001F64F\U0001F3FC',
    u':folded_hands_medium_skin_tone:': u'\U0001F64F\U0001F3FD',
    u':foot-dark_skin_tone:': u'\U0001F9B6\U0001F3FF',
    u':foot-light_skin_tone:': u'\U0001F9B6\U0001F3FB',
    u':foot-medium-dark_skin_tone:': u'\U0001F9B6\U0001F3FE',
    u':foot-medium-light_skin_tone:': u'\U0001F9B6\U0001F3FC',
    u':foot-medium_skin_tone:': u'\U0001F9B6\U0001F3FD',
    u':foot:': u'\U0001F9B6',
    u':footprints:': u'\U0001F463',
    u':fork_and_knife:': u'\U0001F374',
    u':fork_and_knife_with_plate:': u'\U0001F37D',
    u':fork_and_knife_with_plate_selector:': u'\U0001F37D\U0000FE0F',
    u':fortune_cookie:': u'\U0001F960',
    u':fountain:': u'\U000026F2',
    u':fountain_pen:': u'\U0001F58B',
    u':fountain_pen_selector:': u'\U0001F58B\U0000FE0F',
    u':four-thirty:': u'\U0001F55F',
    u':four_leaf_clover:': u'\U0001F340',
    u':four_o\u2019clock:': u'\U0001F553',
    u':fox_face:': u'\U0001F98A',
    u':framed_picture:': u'\U0001F5BC',
    u':framed_picture_selector:': u'\U0001F5BC\U0000FE0F',
    u':french_fries:': u'\U0001F35F',
    u':fried_shrimp:': u'\U0001F364',
    u':frog_face:': u'\U0001F438',
    u':front-facing_baby_chick:': u'\U0001F425',
    u':frowning_face:': u'\U00002639',
    u':frowning_face_selector:': u'\U00002639\U0000FE0F',
    u':frowning_face_with_open_mouth:': u'\U0001F626',
    u':fuel_pump:': u'\U000026FD',
    u':full_moon:': u'\U0001F315',
    u':full_moon_face:': u'\U0001F31D',
    u':funeral_urn:': u'\U000026B1',
    u':funeral_urn_selector:': u'\U000026B1\U0000FE0F',
    u':game_die:': u'\U0001F3B2',
    u':garlic:': u'\U0001F9C4',
    u':gear:': u'\U00002699',
    u':gear_selector:': u'\U00002699\U0000FE0F',
    u':gem_stone:': u'\U0001F48E',
    u':genie:': u'\U0001F9DE',
    u':ghost:': u'\U0001F47B',
    u':giraffe:': u'\U0001F992',
    u':girl:': u'\U0001F467',
    u':girl_dark_skin_tone:': u'\U0001F467\U0001F3FF',
    u':girl_light_skin_tone:': u'\U0001F467\U0001F3FB',
    u':girl_medium-dark_skin_tone:': u'\U0001F467\U0001F3FE',
    u':girl_medium-light_skin_tone:': u'\U0001F467\U0001F3FC',
    u':girl_medium_skin_tone:': u'\U0001F467\U0001F3FD',
    u':glass_of_milk:': u'\U0001F95B',
    u':glasses:': u'\U0001F453',
    u':globe_showing_Americas:': u'\U0001F30E',
    u':globe_showing_Asia-Australia:': u'\U0001F30F',
    u':globe_showing_Europe-Africa:': u'\U0001F30D',
    u':globe_with_meridians:': u'\U0001F310',
    u':gloves:': u'\U0001F9E4',
    u':glowing_star:': u'\U0001F31F',
    u':goal_net:': u'\U0001F945',
    u':goat:': u'\U0001F410',
    u':goblin:': u'\U0001F47A',
    u':goggles:': u'\U0001F97D',
    u':gorilla:': u'\U0001F98D',
    u':graduation_cap:': u'\U0001F393',
    u':grapes:': u'\U0001F347',
    u':green_apple:': u'\U0001F34F',
    u':green_book:': u'\U0001F4D7',
    u':green_circle:': u'\U0001F7E2',
    u':green_heart:': u'\U0001F49A',
    u':green_salad:': u'\U0001F957',
    u':green_square:': u'\U0001F7E9',
    u':grimacing_face:': u'\U0001F62C',
    u':grinning_cat_face:': u'\U0001F63A',
    u':grinning_cat_face_with_smiling_eyes:': u'\U0001F638',
    u':grinning_face:': u'\U0001F600',
    u':grinning_face_with_big_eyes:': u'\U0001F603',
    u':grinning_face_with_smiling_eyes:': u'\U0001F604',
    u':grinning_face_with_sweat:': u'\U0001F605',
    u':grinning_squinting_face:': u'\U0001F606',
    u':growing_heart:': u'\U0001F497',
    u':guard:': u'\U0001F482',
    u':guard_dark_skin_tone:': u'\U0001F482\U0001F3FF',
    u':guard_light_skin_tone:': u'\U0001F482\U0001F3FB',
    u':guard_medium-dark_skin_tone:': u'\U0001F482\U0001F3FE',
    u':guard_medium-light_skin_tone:': u'\U0001F482\U0001F3FC',
    u':guard_medium_skin_tone:': u'\U0001F482\U0001F3FD',
    u':guide_dog:': u'\U0001F9AE',
    u':guitar:': u'\U0001F3B8',
    u':hamburger:': u'\U0001F354',
    u':hammer:': u'\U0001F528',
    u':hammer_and_pick:': u'\U00002692',
    u':hammer_and_pick_selector:': u'\U00002692\U0000FE0F',
    u':hammer_and_wrench:': u'\U0001F6E0',
    u':hammer_and_wrench_selector:': u'\U0001F6E0\U0000FE0F',
    u':hamster_face:': u'\U0001F439',
    u':hand_with_fingers_splayed:': u'\U0001F590',
    u':hand_with_fingers_splayed_dark_skin_tone:': u'\U0001F590\U0001F3FF',
    u':hand_with_fingers_splayed_light_skin_tone:': u'\U0001F590\U0001F3FB',
    u':hand_with_fingers_splayed_medium-dark_skin_tone:': u'\U0001F590\U0001F3FE',
    u':hand_with_fingers_splayed_medium-light_skin_tone:': u'\U0001F590\U0001F3FC',
    u':hand_with_fingers_splayed_medium_skin_tone:': u'\U0001F590\U0001F3FD',
    u':hand_with_fingers_splayed_selector:': u'\U0001F590\U0000FE0F',
    u':handbag:': u'\U0001F45C',
    u':handshake:': u'\U0001F91D',
    u':hatching_chick:': u'\U0001F423',
    u':headphone:': u'\U0001F3A7',
    u':hear-no-evil_monkey:': u'\U0001F649',
    u':heart_decoration:': u'\U0001F49F',
    u':heart_exclamation:': u'\U00002763\U0000FE0F',
    u':heart_suit:': u'\U00002665',
    u':heart_suit_selector:': u'\U00002665\U0000FE0F',
    u':heart_with_arrow:': u'\U0001F498',
    u':heart_with_ribbon:': u'\U0001F49D',
    u':heavy_check_mark:': u'\U00002714',
    u':heavy_division_sign:': u'\U00002797',
    u':heavy_dollar_sign:': u'\U0001F4B2',
    u':heavy_heart_exclamation:': u'\U00002763',
    u':heavy_large_circle:': u'\U00002B55',
    u':heavy_minus_sign:': u'\U00002796',
    u':heavy_multiplication_x:': u'\U00002716',
    u':heavy_plus_sign:': u'\U00002795',
    u':hedgehog:': u'\U0001F994',
    u':helicopter:': u'\U0001F681',
    u':herb:': u'\U0001F33F',
    u':hibiscus:': u'\U0001F33A',
    u':high-heeled_shoe:': u'\U0001F460',
    u':high-speed_train:': u'\U0001F684',
    u':high_voltage:': u'\U000026A1',
    u':hiking_boot:': u'\U0001F97E',
    u':hindu_temple:': u'\U0001F6D5',
    u':hippopotamus:': u'\U0001F99B',
    u':hole:': u'\U0001F573',
    u':hole_selector:': u'\U0001F573\U0000FE0F',
    u':honey_pot:': u'\U0001F36F',
    u':honeybee:': u'\U0001F41D',
    u':horizontal_traffic_light:': u'\U0001F6A5',
    u':horse:': u'\U0001F40E',
    u':horse_face:': u'\U0001F434',
    u':horse_racing:': u'\U0001F3C7',
    u':horse_racing_dark_skin_tone:': u'\U0001F3C7\U0001F3FF',
    u':horse_racing_light_skin_tone:': u'\U0001F3C7\U0001F3FB',
    u':horse_racing_medium-dark_skin_tone:': u'\U0001F3C7\U0001F3FE',
    u':horse_racing_medium-light_skin_tone:': u'\U0001F3C7\U0001F3FC',
    u':horse_racing_medium_skin_tone:': u'\U0001F3C7\U0001F3FD',
    u':hospital:': u'\U0001F3E5',
    u':hot_beverage:': u'\U00002615',
    u':hot_dog:': u'\U0001F32D',
    u':hot_face:': u'\U0001F975',
    u':hot_pepper:': u'\U0001F336',
    u':hot_pepper_selector:': u'\U0001F336\U0000FE0F',
    u':hot_springs:': u'\U00002668',
    u':hot_springs_selector:': u'\U00002668\U0000FE0F',
    u':hotel:': u'\U0001F3E8',
    u':hourglass_done:': u'\U0000231B',
    u':hourglass_not_done:': u'\U000023F3',
    u':house:': u'\U0001F3E0',
    u':house_with_garden:': u'\U0001F3E1',
    u':houses:': u'\U0001F3D8',
    u':houses_selector:': u'\U0001F3D8\U0000FE0F',
    u':hugging_face:': u'\U0001F917',
    u':hundred_points:': u'\U0001F4AF',
    u':hushed_face:': u'\U0001F62F',
    u':ice:': u'\U0001F9CA',
    u':ice_cream:': u'\U0001F368',
    u':ice_hockey:': u'\U0001F3D2',
    u':ice_skate:': u'\U000026F8',
    u':ice_skate_selector:': u'\U000026F8\U0000FE0F',
    u':inbox_tray:': u'\U0001F4E5',
    u':incoming_envelope:': u'\U0001F4E8',
    u':index_pointing_up:': u'\U0000261D',
    u':index_pointing_up_dark_skin_tone:': u'\U0000261D\U0001F3FF',
    u':index_pointing_up_light_skin_tone:': u'\U0000261D\U0001F3FB',
    u':index_pointing_up_medium-dark_skin_tone:': u'\U0000261D\U0001F3FE',
    u':index_pointing_up_medium-light_skin_tone:': u'\U0000261D\U0001F3FC',
    u':index_pointing_up_medium_skin_tone:': u'\U0000261D\U0001F3FD',
    u':index_pointing_up_selector:': u'\U0000261D\U0000FE0F',
    u':infinity:': u'\U0000267E',
    u':infinity_selector:': u'\U0000267E\U0000FE0F',
    u':information:': u'\U00002139',
    u':information_selector:': u'\U00002139\U0000FE0F',
    u':input_latin_letters:': u'\U0001F524',
    u':input_latin_lowercase:': u'\U0001F521',
    u':input_latin_uppercase:': u'\U0001F520',
    u':input_numbers:': u'\U0001F522',
    u':input_symbols:': u'\U0001F523',
    u':jack-o-lantern:': u'\U0001F383',
    u':jeans:': u'\U0001F456',
    u':jigsaw:': u'\U0001F9E9',
    u':joker:': u'\U0001F0CF',
    u':joystick:': u'\U0001F579',
    u':joystick_selector:': u'\U0001F579\U0000FE0F',
    u':kaaba:': u'\U0001F54B',
    u':kangaroo:': u'\U0001F998',
    u':key:': u'\U0001F511',
    u':keyboard:': u'\U00002328',
    u':keyboard_selector:': u'\U00002328\U0000FE0F',
    u':keycap:': u'\U00000023\U000020E3',
    u':keycap_#:': u'\U00000023\U0000FE0F\U000020E3',
    u':keycap_*:': u'\U0000002A\U0000FE0F\U000020E3',
    u':keycap_0:': u'\U00000030\U0000FE0F\U000020E3',
    u':keycap_10:': u'\U0001F51F',
    u':keycap_1:': u'\U00000031\U0000FE0F\U000020E3',
    u':keycap_2:': u'\U00000032\U0000FE0F\U000020E3',
    u':keycap_3:': u'\U00000033\U0000FE0F\U000020E3',
    u':keycap_4:': u'\U00000034\U0000FE0F\U000020E3',
    u':keycap_5:': u'\U00000035\U0000FE0F\U000020E3',
    u':keycap_6:': u'\U00000036\U0000FE0F\U000020E3',
    u':keycap_7:': u'\U00000037\U0000FE0F\U000020E3',
    u':keycap_8:': u'\U00000038\U0000FE0F\U000020E3',
    u':keycap_9:': u'\U00000039\U0000FE0F\U000020E3',
    u':keycap_asterisk:': u'\U0000002A\U000020E3',
    u':keycap_digit_eight:': u'\U00000038\U000020E3',
    u':keycap_digit_five:': u'\U00000035\U000020E3',
    u':keycap_digit_four:': u'\U00000034\U000020E3',
    u':keycap_digit_nine:': u'\U00000039\U000020E3',
    u':keycap_digit_one:': u'\U00000031\U000020E3',
    u':keycap_digit_seven:': u'\U00000037\U000020E3',
    u':keycap_digit_six:': u'\U00000036\U000020E3',
    u':keycap_digit_three:': u'\U00000033\U000020E3',
    u':keycap_digit_two:': u'\U00000032\U000020E3',
    u':keycap_digit_zero:': u'\U00000030\U000020E3',
    u':kick_scooter:': u'\U0001F6F4',
    u':kimono:': u'\U0001F458',
    u':kiss-man-man:': u'\U0001F468\U0000200D\U00002764\U0000200D\U0001F48B\U0000200D\U0001F468',
    u':kiss-woman-man:': u'\U0001F469\U0000200D\U00002764\U0000200D\U0001F48B\U0000200D\U0001F468',
    u':kiss-woman-woman:': u'\U0001F469\U0000200D\U00002764\U0000200D\U0001F48B\U0000200D\U0001F469',
    u':kiss:': u'\U0001F48F',
    u':kiss_man_man:': u'\U0001F468\U0000200D\U00002764\U0000FE0F\U0000200D\U0001F48B\U0000200D\U0001F468',
    u':kiss_mark:': u'\U0001F48B',
    u':kiss_woman_man:': u'\U0001F469\U0000200D\U00002764\U0000FE0F\U0000200D\U0001F48B\U0000200D\U0001F468',
    u':kiss_woman_woman:': u'\U0001F469\U0000200D\U00002764\U0000FE0F\U0000200D\U0001F48B\U0000200D\U0001F469',
    u':kissing_cat_face:': u'\U0001F63D',
    u':kissing_face:': u'\U0001F617',
    u':kissing_face_with_closed_eyes:': u'\U0001F61A',
    u':kissing_face_with_smiling_eyes:': u'\U0001F619',
    u':kitchen_knife:': u'\U0001F52A',
    u':kite:': u'\U0001FA81',
    u':kiwi_fruit:': u'\U0001F95D',
    u':koala:': u'\U0001F428',
    u':lab_coat:': u'\U0001F97C',
    u':label:': u'\U0001F3F7',
    u':label_selector:': u'\U0001F3F7\U0000FE0F',
    u':lacrosse:': u'\U0001F94D',
    u':lady_beetle:': u'\U0001F41E',
    u':laptop_computer:': u'\U0001F4BB',
    u':large_blue_diamond:': u'\U0001F537',
    u':large_orange_diamond:': u'\U0001F536',
    u':last_quarter_moon:': u'\U0001F317',
    u':last_quarter_moon_face:': u'\U0001F31C',
    u':last_track_button:': u'\U000023EE',
    u':last_track_button_selector:': u'\U000023EE\U0000FE0F',
    u':latin_cross:': u'\U0000271D',
    u':latin_cross_selector:': u'\U0000271D\U0000FE0F',
    u':leaf_fluttering_in_wind:': u'\U0001F343',
    u':leafy_green:': u'\U0001F96C',
    u':ledger:': u'\U0001F4D2',
    u':left-facing_fist:': u'\U0001F91B',
    u':left-facing_fist_dark_skin_tone:': u'\U0001F91B\U0001F3FF',
    u':left-facing_fist_light_skin_tone:': u'\U0001F91B\U0001F3FB',
    u':left-facing_fist_medium-dark_skin_tone:': u'\U0001F91B\U0001F3FE',
    u':left-facing_fist_medium-light_skin_tone:': u'\U0001F91B\U0001F3FC',
    u':left-facing_fist_medium_skin_tone:': u'\U0001F91B\U0001F3FD',
    u':left-right_arrow:': u'\U00002194',
    u':left-right_arrow_selector:': u'\U00002194\U0000FE0F',
    u':left_arrow:': u'\U00002B05',
    u':left_arrow_curving_right:': u'\U000021AA',
    u':left_arrow_curving_right_selector:': u'\U000021AA\U0000FE0F',
    u':left_arrow_selector:': u'\U00002B05\U0000FE0F',
    u':left_luggage:': u'\U0001F6C5',
    u':left_speech_bubble:': u'\U0001F5E8',
    u':left_speech_bubble_selector:': u'\U0001F5E8\U0000FE0F',
    u':leg-dark_skin_tone:': u'\U0001F9B5\U0001F3FF',
    u':leg-light_skin_tone:': u'\U0001F9B5\U0001F3FB',
    u':leg-medium-dark_skin_tone:': u'\U0001F9B5\U0001F3FE',
    u':leg-medium-light_skin_tone:': u'\U0001F9B5\U0001F3FC',
    u':leg-medium_skin_tone:': u'\U0001F9B5\U0001F3FD',
    u':leg:': u'\U0001F9B5',
    u':lemon:': u'\U0001F34B',
    u':leopard:': u'\U0001F406',
    u':level_slider:': u'\U0001F39A',
    u':level_slider_selector:': u'\U0001F39A\U0000FE0F',
    u':light_bulb:': u'\U0001F4A1',
    u':light_rail:': u'\U0001F688',
    u':light_skin_tone:': u'\U0001F3FB',
    u':link:': u'\U0001F517',
    u':linked_paperclips:': u'\U0001F587',
    u':linked_paperclips_selector:': u'\U0001F587\U0000FE0F',
    u':lion_face:': u'\U0001F981',
    u':lipstick:': u'\U0001F484',
    u':litter_in_bin_sign:': u'\U0001F6AE',
    u':lizard:': u'\U0001F98E',
    u':llama:': u'\U0001F999',
    u':lobster:': u'\U0001F99E',
    u':locked:': u'\U0001F512',
    u':locked_with_key:': u'\U0001F510',
    u':locked_with_pen:': u'\U0001F50F',
    u':locomotive:': u'\U0001F682',
    u':lollipop:': u'\U0001F36D',
    u':lotion_bottle:': u'\U0001F9F4',
    u':loudly_crying_face:': u'\U0001F62D',
    u':loudspeaker:': u'\U0001F4E2',
    u':love-you_gesture:': u'\U0001F91F',
    u':love-you_gesture_dark_skin_tone:': u'\U0001F91F\U0001F3FF',
    u':love-you_gesture_light_skin_tone:': u'\U0001F91F\U0001F3FB',
    u':love-you_gesture_medium-dark_skin_tone:': u'\U0001F91F\U0001F3FE',
    u':love-you_gesture_medium-light_skin_tone:': u'\U0001F91F\U0001F3FC',
    u':love-you_gesture_medium_skin_tone:': u'\U0001F91F\U0001F3FD',
    u':love_hotel:': u'\U0001F3E9',
    u':love_letter:': u'\U0001F48C',
    u':luggage:': u'\U0001F9F3',
    u':lying_face:': u'\U0001F925',
    u':mage:': u'\U0001F9D9',
    u':mage_dark_skin_tone:': u'\U0001F9D9\U0001F3FF',
    u':mage_light_skin_tone:': u'\U0001F9D9\U0001F3FB',
    u':mage_medium-dark_skin_tone:': u'\U0001F9D9\U0001F3FE',
    u':mage_medium-light_skin_tone:': u'\U0001F9D9\U0001F3FC',
    u':mage_medium_skin_tone:': u'\U0001F9D9\U0001F3FD',
    u':magnet:': u'\U0001F9F2',
    u':magnifying_glass_tilted_left:': u'\U0001F50D',
    u':magnifying_glass_tilted_right:': u'\U0001F50E',
    u':mahjong_red_dragon:': u'\U0001F004',
    u':male_sign:': u'\U00002642',
    u':male_sign_selector:': u'\U00002642\U0000FE0F',
    u':man-blond_hair:': u'\U0001F471\U0000200D\U00002642',
    u':man-dark_skin_tone-bald:': u'\U0001F468\U0001F3FF\U0000200D\U0001F9B2',
    u':man-dark_skin_tone-blond_hair:': u'\U0001F471\U0001F3FF\U0000200D\U00002642',
    u':man-dark_skin_tone-curly_hair:': u'\U0001F468\U0001F3FF\U0000200D\U0001F9B1',
    u':man-dark_skin_tone-red_hair:': u'\U0001F468\U0001F3FF\U0000200D\U0001F9B0',
    u':man-dark_skin_tone-white_hair:': u'\U0001F468\U0001F3FF\U0000200D\U0001F9B3',
    u':man-light_skin_tone-bald:': u'\U0001F468\U0001F3FB\U0000200D\U0001F9B2',
    u':man-light_skin_tone-blond_hair:': u'\U0001F471\U0001F3FB\U0000200D\U00002642',
    u':man-light_skin_tone-curly_hair:': u'\U0001F468\U0001F3FB\U0000200D\U0001F9B1',
    u':man-light_skin_tone-red_hair:': u'\U0001F468\U0001F3FB\U0000200D\U0001F9B0',
    u':man-light_skin_tone-white_hair:': u'\U0001F468\U0001F3FB\U0000200D\U0001F9B3',
    u':man-medium-dark_skin_tone-bald:': u'\U0001F468\U0001F3FE\U0000200D\U0001F9B2',
    u':man-medium-dark_skin_tone-blond_hair:': u'\U0001F471\U0001F3FE\U0000200D\U00002642',
    u':man-medium-dark_skin_tone-curly_hair:': u'\U0001F468\U0001F3FE\U0000200D\U0001F9B1',
    u':man-medium-dark_skin_tone-red_hair:': u'\U0001F468\U0001F3FE\U0000200D\U0001F9B0',
    u':man-medium-dark_skin_tone-white_hair:': u'\U0001F468\U0001F3FE\U0000200D\U0001F9B3',
    u':man-medium-light_skin_tone-bald:': u'\U0001F468\U0001F3FC\U0000200D\U0001F9B2',
    u':man-medium-light_skin_tone-blond_hair:': u'\U0001F471\U0001F3FC\U0000200D\U00002642',
    u':man-medium-light_skin_tone-curly_hair:': u'\U0001F468\U0001F3FC\U0000200D\U0001F9B1',
    u':man-medium-light_skin_tone-red_hair:': u'\U0001F468\U0001F3FC\U0000200D\U0001F9B0',
    u':man-medium-light_skin_tone-white_hair:': u'\U0001F468\U0001F3FC\U0000200D\U0001F9B3',
    u':man-medium_skin_tone-bald:': u'\U0001F468\U0001F3FD\U0000200D\U0001F9B2',
    u':man-medium_skin_tone-blond_hair:': u'\U0001F471\U0001F3FD\U0000200D\U00002642',
    u':man-medium_skin_tone-curly_hair:': u'\U0001F468\U0001F3FD\U0000200D\U0001F9B1',
    u':man-medium_skin_tone-red_hair:': u'\U0001F468\U0001F3FD\U0000200D\U0001F9B0',
    u':man-medium_skin_tone-white_hair:': u'\U0001F468\U0001F3FD\U0000200D\U0001F9B3',
    u':man:': u'\U0001F468',
    u':man_and_woman_holding_hands:': u'\U0001F46B',
    u':man_artist:': u'\U0001F468\U0000200D\U0001F3A8',
    u':man_artist_dark_skin_tone:': u'\U0001F468\U0001F3FF\U0000200D\U0001F3A8',
    u':man_artist_light_skin_tone:': u'\U0001F468\U0001F3FB\U0000200D\U0001F3A8',
    u':man_artist_medium-dark_skin_tone:': u'\U0001F468\U0001F3FE\U0000200D\U0001F3A8',
    u':man_artist_medium-light_skin_tone:': u'\U0001F468\U0001F3FC\U0000200D\U0001F3A8',
    u':man_artist_medium_skin_tone:': u'\U0001F468\U0001F3FD\U0000200D\U0001F3A8',
    u':man_astronaut:': u'\U0001F468\U0000200D\U0001F680',
    u':man_astronaut_dark_skin_tone:': u'\U0001F468\U0001F3FF\U0000200D\U0001F680',
    u':man_astronaut_light_skin_tone:': u'\U0001F468\U0001F3FB\U0000200D\U0001F680',
    u':man_astronaut_medium-dark_skin_tone:': u'\U0001F468\U0001F3FE\U0000200D\U0001F680',
    u':man_astronaut_medium-light_skin_tone:': u'\U0001F468\U0001F3FC\U0000200D\U0001F680',
    u':man_astronaut_medium_skin_tone:': u'\U0001F468\U0001F3FD\U0000200D\U0001F680',
    u':man_biking-dark_skin_tone:': u'\U0001F6B4\U0001F3FF\U0000200D\U00002642',
    u':man_biking-light_skin_tone:': u'\U0001F6B4\U0001F3FB\U0000200D\U00002642',
    u':man_biking-medium-dark_skin_tone:': u'\U0001F6B4\U0001F3FE\U0000200D\U00002642',
    u':man_biking-medium-light_skin_tone:': u'\U0001F6B4\U0001F3FC\U0000200D\U00002642',
    u':man_biking-medium_skin_tone:': u'\U0001F6B4\U0001F3FD\U0000200D\U00002642',
    u':man_biking:': u'\U0001F6B4\U0000200D\U00002642',
    u':man_biking_dark_skin_tone:': u'\U0001F6B4\U0001F3FF\U0000200D\U00002642\U0000FE0F',
    u':man_biking_light_skin_tone:': u'\U0001F6B4\U0001F3FB\U0000200D\U00002642\U0000FE0F',
    u':man_biking_medium-dark_skin_tone:': u'\U0001F6B4\U0001F3FE\U0000200D\U00002642\U0000FE0F',
    u':man_biking_medium-light_skin_tone:': u'\U0001F6B4\U0001F3FC\U0000200D\U00002642\U0000FE0F',
    u':man_biking_medium_skin_tone:': u'\U0001F6B4\U0001F3FD\U0000200D\U00002642\U0000FE0F',
    u':man_biking_selector:': u'\U0001F6B4\U0000200D\U00002642\U0000FE0F',
    u':man_bouncing_ball-dark_skin_tone:': u'\U000026F9\U0001F3FF\U0000200D\U00002642',
    u':man_bouncing_ball-light_skin_tone:': u'\U000026F9\U0001F3FB\U0000200D\U00002642',
    u':man_bouncing_ball-medium-dark_skin_tone:': u'\U000026F9\U0001F3FE\U0000200D\U00002642',
    u':man_bouncing_ball-medium-light_skin_tone:': u'\U000026F9\U0001F3FC\U0000200D\U00002642',
    u':man_bouncing_ball-medium_skin_tone:': u'\U000026F9\U0001F3FD\U0000200D\U00002642',
    u':man_bouncing_ball:': u'\U000026F9\U0000200D\U00002642',
    u':man_bouncing_ball_2:': u'\U000026F9\U0000FE0F\U0000200D\U00002642\U0000FE0F',
    u':man_bouncing_ball_3:': u'\U000026F9\U0000200D\U00002642\U0000FE0F',
    u':man_bouncing_ball_dark_skin_tone:': u'\U000026F9\U0001F3FF\U0000200D\U00002642\U0000FE0F',
    u':man_bouncing_ball_light_skin_tone:': u'\U000026F9\U0001F3FB\U0000200D\U00002642\U0000FE0F',
    u':man_bouncing_ball_medium-dark_skin_tone:': u'\U000026F9\U0001F3FE\U0000200D\U00002642\U0000FE0F',
    u':man_bouncing_ball_medium-light_skin_tone:': u'\U000026F9\U0001F3FC\U0000200D\U00002642\U0000FE0F',
    u':man_bouncing_ball_medium_skin_tone:': u'\U000026F9\U0001F3FD\U0000200D\U00002642\U0000FE0F',
    u':man_bouncing_ball_selector:': u'\U000026F9\U0000FE0F\U0000200D\U00002642',
    u':man_bowing-dark_skin_tone:': u'\U0001F647\U0001F3FF\U0000200D\U00002642',
    u':man_bowing-light_skin_tone:': u'\U0001F647\U0001F3FB\U0000200D\U00002642',
    u':man_bowing-medium-dark_skin_tone:': u'\U0001F647\U0001F3FE\U0000200D\U00002642',
    u':man_bowing-medium-light_skin_tone:': u'\U0001F647\U0001F3FC\U0000200D\U00002642',
    u':man_bowing-medium_skin_tone:': u'\U0001F647\U0001F3FD\U0000200D\U00002642',
    u':man_bowing:': u'\U0001F647\U0000200D\U00002642',
    u':man_bowing_dark_skin_tone:': u'\U0001F647\U0001F3FF\U0000200D\U00002642\U0000FE0F',
    u':man_bowing_light_skin_tone:': u'\U0001F647\U0001F3FB\U0000200D\U00002642\U0000FE0F',
    u':man_bowing_medium-dark_skin_tone:': u'\U0001F647\U0001F3FE\U0000200D\U00002642\U0000FE0F',
    u':man_bowing_medium-light_skin_tone:': u'\U0001F647\U0001F3FC\U0000200D\U00002642\U0000FE0F',
    u':man_bowing_medium_skin_tone:': u'\U0001F647\U0001F3FD\U0000200D\U00002642\U0000FE0F',
    u':man_bowing_selector:': u'\U0001F647\U0000200D\U00002642\U0000FE0F',
    u':man_cartwheeling-dark_skin_tone:': u'\U0001F938\U0001F3FF\U0000200D\U00002642',
    u':man_cartwheeling-light_skin_tone:': u'\U0001F938\U0001F3FB\U0000200D\U00002642',
    u':man_cartwheeling-medium-dark_skin_tone:': u'\U0001F938\U0001F3FE\U0000200D\U00002642',
    u':man_cartwheeling-medium-light_skin_tone:': u'\U0001F938\U0001F3FC\U0000200D\U00002642',
    u':man_cartwheeling-medium_skin_tone:': u'\U0001F938\U0001F3FD\U0000200D\U00002642',
    u':man_cartwheeling:': u'\U0001F938\U0000200D\U00002642',
    u':man_cartwheeling_dark_skin_tone:': u'\U0001F938\U0001F3FF\U0000200D\U00002642\U0000FE0F',
    u':man_cartwheeling_light_skin_tone:': u'\U0001F938\U0001F3FB\U0000200D\U00002642\U0000FE0F',
    u':man_cartwheeling_medium-dark_skin_tone:': u'\U0001F938\U0001F3FE\U0000200D\U00002642\U0000FE0F',
    u':man_cartwheeling_medium-light_skin_tone:': u'\U0001F938\U0001F3FC\U0000200D\U00002642\U0000FE0F',
    u':man_cartwheeling_medium_skin_tone:': u'\U0001F938\U0001F3FD\U0000200D\U00002642\U0000FE0F',
    u':man_cartwheeling_selector:': u'\U0001F938\U0000200D\U00002642\U0000FE0F',
    u':man_climbing-dark_skin_tone:': u'\U0001F9D7\U0001F3FF\U0000200D\U00002642',
    u':man_climbing-light_skin_tone:': u'\U0001F9D7\U0001F3FB\U0000200D\U00002642',
    u':man_climbing-medium-dark_skin_tone:': u'\U0001F9D7\U0001F3FE\U0000200D\U00002642',
    u':man_climbing-medium-light_skin_tone:': u'\U0001F9D7\U0001F3FC\U0000200D\U00002642',
    u':man_climbing-medium_skin_tone:': u'\U0001F9D7\U0001F3FD\U0000200D\U00002642',
    u':man_climbing:': u'\U0001F9D7\U0000200D\U00002642',
    u':man_climbing_dark_skin_tone:': u'\U0001F9D7\U0001F3FF\U0000200D\U00002642\U0000FE0F',
    u':man_climbing_light_skin_tone:': u'\U0001F9D7\U0001F3FB\U0000200D\U00002642\U0000FE0F',
    u':man_climbing_medium-dark_skin_tone:': u'\U0001F9D7\U0001F3FE\U0000200D\U00002642\U0000FE0F',
    u':man_climbing_medium-light_skin_tone:': u'\U0001F9D7\U0001F3FC\U0000200D\U00002642\U0000FE0F',
    u':man_climbing_medium_skin_tone:': u'\U0001F9D7\U0001F3FD\U0000200D\U00002642\U0000FE0F',
    u':man_climbing_selector:': u'\U0001F9D7\U0000200D\U00002642\U0000FE0F',
    u':man_construction_worker-dark_skin_tone:': u'\U0001F477\U0001F3FF\U0000200D\U00002642',
    u':man_construction_worker-light_skin_tone:': u'\U0001F477\U0001F3FB\U0000200D\U00002642',
    u':man_construction_worker-medium-dark_skin_tone:': u'\U0001F477\U0001F3FE\U0000200D\U00002642',
    u':man_construction_worker-medium-light_skin_tone:': u'\U0001F477\U0001F3FC\U0000200D\U00002642',
    u':man_construction_worker-medium_skin_tone:': u'\U0001F477\U0001F3FD\U0000200D\U00002642',
    u':man_construction_worker:': u'\U0001F477\U0000200D\U00002642',
    u':man_construction_worker_dark_skin_tone:': u'\U0001F477\U0001F3FF\U0000200D\U00002642\U0000FE0F',
    u':man_construction_worker_light_skin_tone:': u'\U0001F477\U0001F3FB\U0000200D\U00002642\U0000FE0F',
    u':man_construction_worker_medium-dark_skin_tone:': u'\U0001F477\U0001F3FE\U0000200D\U00002642\U0000FE0F',
    u':man_construction_worker_medium-light_skin_tone:': u'\U0001F477\U0001F3FC\U0000200D\U00002642\U0000FE0F',
    u':man_construction_worker_medium_skin_tone:': u'\U0001F477\U0001F3FD\U0000200D\U00002642\U0000FE0F',
    u':man_construction_worker_selector:': u'\U0001F477\U0000200D\U00002642\U0000FE0F',
    u':man_cook:': u'\U0001F468\U0000200D\U0001F373',
    u':man_cook_dark_skin_tone:': u'\U0001F468\U0001F3FF\U0000200D\U0001F373',
    u':man_cook_light_skin_tone:': u'\U0001F468\U0001F3FB\U0000200D\U0001F373',
    u':man_cook_medium-dark_skin_tone:': u'\U0001F468\U0001F3FE\U0000200D\U0001F373',
    u':man_cook_medium-light_skin_tone:': u'\U0001F468\U0001F3FC\U0000200D\U0001F373',
    u':man_cook_medium_skin_tone:': u'\U0001F468\U0001F3FD\U0000200D\U0001F373',
    u':man_dancing:': u'\U0001F57A',
    u':man_dancing_dark_skin_tone:': u'\U0001F57A\U0001F3FF',
    u':man_dancing_light_skin_tone:': u'\U0001F57A\U0001F3FB',
    u':man_dancing_medium-dark_skin_tone:': u'\U0001F57A\U0001F3FE',
    u':man_dancing_medium-light_skin_tone:': u'\U0001F57A\U0001F3FC',
    u':man_dancing_medium_skin_tone:': u'\U0001F57A\U0001F3FD',
    u':man_dark_skin_tone:': u'\U0001F468\U0001F3FF',
    u':man_detective-dark_skin_tone:': u'\U0001F575\U0001F3FF\U0000200D\U00002642',
    u':man_detective-light_skin_tone:': u'\U0001F575\U0001F3FB\U0000200D\U00002642',
    u':man_detective-medium-dark_skin_tone:': u'\U0001F575\U0001F3FE\U0000200D\U00002642',
    u':man_detective-medium-light_skin_tone:': u'\U0001F575\U0001F3FC\U0000200D\U00002642',
    u':man_detective-medium_skin_tone:': u'\U0001F575\U0001F3FD\U0000200D\U00002642',
    u':man_detective:': u'\U0001F575\U0000200D\U00002642',
    u':man_detective_2:': u'\U0001F575\U0000FE0F\U0000200D\U00002642\U0000FE0F',
    u':man_detective_dark_skin_tone:': u'\U0001F575\U0001F3FF\U0000200D\U00002642\U0000FE0F',
    u':man_detective_light_skin_tone:': u'\U0001F575\U0001F3FB\U0000200D\U00002642\U0000FE0F',
    u':man_detective_medium-dark_skin_tone:': u'\U0001F575\U0001F3FE\U0000200D\U00002642\U0000FE0F',
    u':man_detective_medium-light_skin_tone:': u'\U0001F575\U0001F3FC\U0000200D\U00002642\U0000FE0F',
    u':man_detective_medium_skin_tone:': u'\U0001F575\U0001F3FD\U0000200D\U00002642\U0000FE0F',
    u':man_detective_selector:': u'\U0001F575\U0000FE0F\U0000200D\U00002642',
    u':man_elf-dark_skin_tone:': u'\U0001F9DD\U0001F3FF\U0000200D\U00002642',
    u':man_elf-light_skin_tone:': u'\U0001F9DD\U0001F3FB\U0000200D\U00002642',
    u':man_elf-medium-dark_skin_tone:': u'\U0001F9DD\U0001F3FE\U0000200D\U00002642',
    u':man_elf-medium-light_skin_tone:': u'\U0001F9DD\U0001F3FC\U0000200D\U00002642',
    u':man_elf-medium_skin_tone:': u'\U0001F9DD\U0001F3FD\U0000200D\U00002642',
    u':man_elf:': u'\U0001F9DD\U0000200D\U00002642',
    u':man_elf_dark_skin_tone:': u'\U0001F9DD\U0001F3FF\U0000200D\U00002642\U0000FE0F',
    u':man_elf_light_skin_tone:': u'\U0001F9DD\U0001F3FB\U0000200D\U00002642\U0000FE0F',
    u':man_elf_medium-dark_skin_tone:': u'\U0001F9DD\U0001F3FE\U0000200D\U00002642\U0000FE0F',
    u':man_elf_medium-light_skin_tone:': u'\U0001F9DD\U0001F3FC\U0000200D\U00002642\U0000FE0F',
    u':man_elf_medium_skin_tone:': u'\U0001F9DD\U0001F3FD\U0000200D\U00002642\U0000FE0F',
    u':man_elf_selector:': u'\U0001F9DD\U0000200D\U00002642\U0000FE0F',
    u':man_facepalming-dark_skin_tone:': u'\U0001F926\U0001F3FF\U0000200D\U00002642',
    u':man_facepalming-light_skin_tone:': u'\U0001F926\U0001F3FB\U0000200D\U00002642',
    u':man_facepalming-medium-dark_skin_tone:': u'\U0001F926\U0001F3FE\U0000200D\U00002642',
    u':man_facepalming-medium-light_skin_tone:': u'\U0001F926\U0001F3FC\U0000200D\U00002642',
    u':man_facepalming-medium_skin_tone:': u'\U0001F926\U0001F3FD\U0000200D\U00002642',
    u':man_facepalming:': u'\U0001F926\U0000200D\U00002642',
    u':man_facepalming_dark_skin_tone:': u'\U0001F926\U0001F3FF\U0000200D\U00002642\U0000FE0F',
    u':man_facepalming_light_skin_tone:': u'\U0001F926\U0001F3FB\U0000200D\U00002642\U0000FE0F',
    u':man_facepalming_medium-dark_skin_tone:': u'\U0001F926\U0001F3FE\U0000200D\U00002642\U0000FE0F',
    u':man_facepalming_medium-light_skin_tone:': u'\U0001F926\U0001F3FC\U0000200D\U00002642\U0000FE0F',
    u':man_facepalming_medium_skin_tone:': u'\U0001F926\U0001F3FD\U0000200D\U00002642\U0000FE0F',
    u':man_facepalming_selector:': u'\U0001F926\U0000200D\U00002642\U0000FE0F',
    u':man_factory_worker:': u'\U0001F468\U0000200D\U0001F3ED',
    u':man_factory_worker_dark_skin_tone:': u'\U0001F468\U0001F3FF\U0000200D\U0001F3ED',
    u':man_factory_worker_light_skin_tone:': u'\U0001F468\U0001F3FB\U0000200D\U0001F3ED',
    u':man_factory_worker_medium-dark_skin_tone:': u'\U0001F468\U0001F3FE\U0000200D\U0001F3ED',
    u':man_factory_worker_medium-light_skin_tone:': u'\U0001F468\U0001F3FC\U0000200D\U0001F3ED',
    u':man_factory_worker_medium_skin_tone:': u'\U0001F468\U0001F3FD\U0000200D\U0001F3ED',
    u':man_fairy-dark_skin_tone:': u'\U0001F9DA\U0001F3FF\U0000200D\U00002642',
    u':man_fairy-light_skin_tone:': u'\U0001F9DA\U0001F3FB\U0000200D\U00002642',
    u':man_fairy-medium-dark_skin_tone:': u'\U0001F9DA\U0001F3FE\U0000200D\U00002642',
    u':man_fairy-medium-light_skin_tone:': u'\U0001F9DA\U0001F3FC\U0000200D\U00002642',
    u':man_fairy-medium_skin_tone:': u'\U0001F9DA\U0001F3FD\U0000200D\U00002642',
    u':man_fairy:': u'\U0001F9DA\U0000200D\U00002642',
    u':man_fairy_dark_skin_tone:': u'\U0001F9DA\U0001F3FF\U0000200D\U00002642\U0000FE0F',
    u':man_fairy_light_skin_tone:': u'\U0001F9DA\U0001F3FB\U0000200D\U00002642\U0000FE0F',
    u':man_fairy_medium-dark_skin_tone:': u'\U0001F9DA\U0001F3FE\U0000200D\U00002642\U0000FE0F',
    u':man_fairy_medium-light_skin_tone:': u'\U0001F9DA\U0001F3FC\U0000200D\U00002642\U0000FE0F',
    u':man_fairy_medium_skin_tone:': u'\U0001F9DA\U0001F3FD\U0000200D\U00002642\U0000FE0F',
    u':man_fairy_selector:': u'\U0001F9DA\U0000200D\U00002642\U0000FE0F',
    u':man_farmer:': u'\U0001F468\U0000200D\U0001F33E',
    u':man_farmer_dark_skin_tone:': u'\U0001F468\U0001F3FF\U0000200D\U0001F33E',
    u':man_farmer_light_skin_tone:': u'\U0001F468\U0001F3FB\U0000200D\U0001F33E',
    u':man_farmer_medium-dark_skin_tone:': u'\U0001F468\U0001F3FE\U0000200D\U0001F33E',
    u':man_farmer_medium-light_skin_tone:': u'\U0001F468\U0001F3FC\U0000200D\U0001F33E',
    u':man_farmer_medium_skin_tone:': u'\U0001F468\U0001F3FD\U0000200D\U0001F33E',
    u':man_firefighter:': u'\U0001F468\U0000200D\U0001F692',
    u':man_firefighter_dark_skin_tone:': u'\U0001F468\U0001F3FF\U0000200D\U0001F692',
    u':man_firefighter_light_skin_tone:': u'\U0001F468\U0001F3FB\U0000200D\U0001F692',
    u':man_firefighter_medium-dark_skin_tone:': u'\U0001F468\U0001F3FE\U0000200D\U0001F692',
    u':man_firefighter_medium-light_skin_tone:': u'\U0001F468\U0001F3FC\U0000200D\U0001F692',
    u':man_firefighter_medium_skin_tone:': u'\U0001F468\U0001F3FD\U0000200D\U0001F692',
    u':man_frowning-dark_skin_tone:': u'\U0001F64D\U0001F3FF\U0000200D\U00002642',
    u':man_frowning-light_skin_tone:': u'\U0001F64D\U0001F3FB\U0000200D\U00002642',
    u':man_frowning-medium-dark_skin_tone:': u'\U0001F64D\U0001F3FE\U0000200D\U00002642',
    u':man_frowning-medium-light_skin_tone:': u'\U0001F64D\U0001F3FC\U0000200D\U00002642',
    u':man_frowning-medium_skin_tone:': u'\U0001F64D\U0001F3FD\U0000200D\U00002642',
    u':man_frowning:': u'\U0001F64D\U0000200D\U00002642',
    u':man_frowning_dark_skin_tone:': u'\U0001F64D\U0001F3FF\U0000200D\U00002642\U0000FE0F',
    u':man_frowning_light_skin_tone:': u'\U0001F64D\U0001F3FB\U0000200D\U00002642\U0000FE0F',
    u':man_frowning_medium-dark_skin_tone:': u'\U0001F64D\U0001F3FE\U0000200D\U00002642\U0000FE0F',
    u':man_frowning_medium-light_skin_tone:': u'\U0001F64D\U0001F3FC\U0000200D\U00002642\U0000FE0F',
    u':man_frowning_medium_skin_tone:': u'\U0001F64D\U0001F3FD\U0000200D\U00002642\U0000FE0F',
    u':man_frowning_selector:': u'\U0001F64D\U0000200D\U00002642\U0000FE0F',
    u':man_genie:': u'\U0001F9DE\U0000200D\U00002642',
    u':man_genie_selector:': u'\U0001F9DE\U0000200D\U00002642\U0000FE0F',
    u':man_gesturing_NO-dark_skin_tone:': u'\U0001F645\U0001F3FF\U0000200D\U00002642',
    u':man_gesturing_NO-light_skin_tone:': u'\U0001F645\U0001F3FB\U0000200D\U00002642',
    u':man_gesturing_NO-medium-dark_skin_tone:': u'\U0001F645\U0001F3FE\U0000200D\U00002642',
    u':man_gesturing_NO-medium-light_skin_tone:': u'\U0001F645\U0001F3FC\U0000200D\U00002642',
    u':man_gesturing_NO-medium_skin_tone:': u'\U0001F645\U0001F3FD\U0000200D\U00002642',
    u':man_gesturing_NO:': u'\U0001F645\U0000200D\U00002642',
    u':man_gesturing_NO_dark_skin_tone:': u'\U0001F645\U0001F3FF\U0000200D\U00002642\U0000FE0F',
    u':man_gesturing_NO_light_skin_tone:': u'\U0001F645\U0001F3FB\U0000200D\U00002642\U0000FE0F',
    u':man_gesturing_NO_medium-dark_skin_tone:': u'\U0001F645\U0001F3FE\U0000200D\U00002642\U0000FE0F',
    u':man_gesturing_NO_medium-light_skin_tone:': u'\U0001F645\U0001F3FC\U0000200D\U00002642\U0000FE0F',
    u':man_gesturing_NO_medium_skin_tone:': u'\U0001F645\U0001F3FD\U0000200D\U00002642\U0000FE0F',
    u':man_gesturing_NO_selector:': u'\U0001F645\U0000200D\U00002642\U0000FE0F',
    u':man_gesturing_OK-dark_skin_tone:': u'\U0001F646\U0001F3FF\U0000200D\U00002642',
    u':man_gesturing_OK-light_skin_tone:': u'\U0001F646\U0001F3FB\U0000200D\U00002642',
    u':man_gesturing_OK-medium-dark_skin_tone:': u'\U0001F646\U0001F3FE\U0000200D\U00002642',
    u':man_gesturing_OK-medium-light_skin_tone:': u'\U0001F646\U0001F3FC\U0000200D\U00002642',
    u':man_gesturing_OK-medium_skin_tone:': u'\U0001F646\U0001F3FD\U0000200D\U00002642',
    u':man_gesturing_OK:': u'\U0001F646\U0000200D\U00002642',
    u':man_gesturing_OK_dark_skin_tone:': u'\U0001F646\U0001F3FF\U0000200D\U00002642\U0000FE0F',
    u':man_gesturing_OK_light_skin_tone:': u'\U0001F646\U0001F3FB\U0000200D\U00002642\U0000FE0F',
    u':man_gesturing_OK_medium-dark_skin_tone:': u'\U0001F646\U0001F3FE\U0000200D\U00002642\U0000FE0F',
    u':man_gesturing_OK_medium-light_skin_tone:': u'\U0001F646\U0001F3FC\U0000200D\U00002642\U0000FE0F',
    u':man_gesturing_OK_medium_skin_tone:': u'\U0001F646\U0001F3FD\U0000200D\U00002642\U0000FE0F',
    u':man_gesturing_OK_selector:': u'\U0001F646\U0000200D\U00002642\U0000FE0F',
    u':man_getting_haircut-dark_skin_tone:': u'\U0001F487\U0001F3FF\U0000200D\U00002642',
    u':man_getting_haircut-light_skin_tone:': u'\U0001F487\U0001F3FB\U0000200D\U00002642',
    u':man_getting_haircut-medium-dark_skin_tone:': u'\U0001F487\U0001F3FE\U0000200D\U00002642',
    u':man_getting_haircut-medium-light_skin_tone:': u'\U0001F487\U0001F3FC\U0000200D\U00002642',
    u':man_getting_haircut-medium_skin_tone:': u'\U0001F487\U0001F3FD\U0000200D\U00002642',
    u':man_getting_haircut:': u'\U0001F487\U0000200D\U00002642',
    u':man_getting_haircut_dark_skin_tone:': u'\U0001F487\U0001F3FF\U0000200D\U00002642\U0000FE0F',
    u':man_getting_haircut_light_skin_tone:': u'\U0001F487\U0001F3FB\U0000200D\U00002642\U0000FE0F',
    u':man_getting_haircut_medium-dark_skin_tone:': u'\U0001F487\U0001F3FE\U0000200D\U00002642\U0000FE0F',
    u':man_getting_haircut_medium-light_skin_tone:': u'\U0001F487\U0001F3FC\U0000200D\U00002642\U0000FE0F',
    u':man_getting_haircut_medium_skin_tone:': u'\U0001F487\U0001F3FD\U0000200D\U00002642\U0000FE0F',
    u':man_getting_haircut_selector:': u'\U0001F487\U0000200D\U00002642\U0000FE0F',
    u':man_getting_massage-dark_skin_tone:': u'\U0001F486\U0001F3FF\U0000200D\U00002642',
    u':man_getting_massage-light_skin_tone:': u'\U0001F486\U0001F3FB\U0000200D\U00002642',
    u':man_getting_massage-medium-dark_skin_tone:': u'\U0001F486\U0001F3FE\U0000200D\U00002642',
    u':man_getting_massage-medium-light_skin_tone:': u'\U0001F486\U0001F3FC\U0000200D\U00002642',
    u':man_getting_massage-medium_skin_tone:': u'\U0001F486\U0001F3FD\U0000200D\U00002642',
    u':man_getting_massage:': u'\U0001F486\U0000200D\U00002642',
    u':man_getting_massage_dark_skin_tone:': u'\U0001F486\U0001F3FF\U0000200D\U00002642\U0000FE0F',
    u':man_getting_massage_light_skin_tone:': u'\U0001F486\U0001F3FB\U0000200D\U00002642\U0000FE0F',
    u':man_getting_massage_medium-dark_skin_tone:': u'\U0001F486\U0001F3FE\U0000200D\U00002642\U0000FE0F',
    u':man_getting_massage_medium-light_skin_tone:': u'\U0001F486\U0001F3FC\U0000200D\U00002642\U0000FE0F',
    u':man_getting_massage_medium_skin_tone:': u'\U0001F486\U0001F3FD\U0000200D\U00002642\U0000FE0F',
    u':man_getting_massage_selector:': u'\U0001F486\U0000200D\U00002642\U0000FE0F',
    u':man_golfing-dark_skin_tone:': u'\U0001F3CC\U0001F3FF\U0000200D\U00002642',
    u':man_golfing-light_skin_tone:': u'\U0001F3CC\U0001F3FB\U0000200D\U00002642',
    u':man_golfing-medium-dark_skin_tone:': u'\U0001F3CC\U0001F3FE\U0000200D\U00002642',
    u':man_golfing-medium-light_skin_tone:': u'\U0001F3CC\U0001F3FC\U0000200D\U00002642',
    u':man_golfing-medium_skin_tone:': u'\U0001F3CC\U0001F3FD\U0000200D\U00002642',
    u':man_golfing:': u'\U0001F3CC\U0000200D\U00002642',
    u':man_golfing_2:': u'\U0001F3CC\U0000FE0F\U0000200D\U00002642\U0000FE0F',
    u':man_golfing_3:': u'\U0001F3CC\U0000200D\U00002642\U0000FE0F',
    u':man_golfing_dark_skin_tone:': u'\U0001F3CC\U0001F3FF\U0000200D\U00002642\U0000FE0F',
    u':man_golfing_light_skin_tone:': u'\U0001F3CC\U0001F3FB\U0000200D\U00002642\U0000FE0F',
    u':man_golfing_medium-dark_skin_tone:': u'\U0001F3CC\U0001F3FE\U0000200D\U00002642\U0000FE0F',
    u':man_golfing_medium-light_skin_tone:': u'\U0001F3CC\U0001F3FC\U0000200D\U00002642\U0000FE0F',
    u':man_golfing_medium_skin_tone:': u'\U0001F3CC\U0001F3FD\U0000200D\U00002642\U0000FE0F',
    u':man_golfing_selector:': u'\U0001F3CC\U0000FE0F\U0000200D\U00002642',
    u':man_guard-dark_skin_tone:': u'\U0001F482\U0001F3FF\U0000200D\U00002642',
    u':man_guard-light_skin_tone:': u'\U0001F482\U0001F3FB\U0000200D\U00002642',
    u':man_guard-medium-dark_skin_tone:': u'\U0001F482\U0001F3FE\U0000200D\U00002642',
    u':man_guard-medium-light_skin_tone:': u'\U0001F482\U0001F3FC\U0000200D\U00002642',
    u':man_guard-medium_skin_tone:': u'\U0001F482\U0001F3FD\U0000200D\U00002642',
    u':man_guard:': u'\U0001F482\U0000200D\U00002642',
    u':man_guard_dark_skin_tone:': u'\U0001F482\U0001F3FF\U0000200D\U00002642\U0000FE0F',
    u':man_guard_light_skin_tone:': u'\U0001F482\U0001F3FB\U0000200D\U00002642\U0000FE0F',
    u':man_guard_medium-dark_skin_tone:': u'\U0001F482\U0001F3FE\U0000200D\U00002642\U0000FE0F',
    u':man_guard_medium-light_skin_tone:': u'\U0001F482\U0001F3FC\U0000200D\U00002642\U0000FE0F',
    u':man_guard_medium_skin_tone:': u'\U0001F482\U0001F3FD\U0000200D\U00002642\U0000FE0F',
    u':man_guard_selector:': u'\U0001F482\U0000200D\U00002642\U0000FE0F',
    u':man_health_worker-dark_skin_tone:': u'\U0001F468\U0001F3FF\U0000200D\U00002695',
    u':man_health_worker-light_skin_tone:': u'\U0001F468\U0001F3FB\U0000200D\U00002695',
    u':man_health_worker-medium-dark_skin_tone:': u'\U0001F468\U0001F3FE\U0000200D\U00002695',
    u':man_health_worker-medium-light_skin_tone:': u'\U0001F468\U0001F3FC\U0000200D\U00002695',
    u':man_health_worker-medium_skin_tone:': u'\U0001F468\U0001F3FD\U0000200D\U00002695',
    u':man_health_worker:': u'\U0001F468\U0000200D\U00002695',
    u':man_health_worker_dark_skin_tone:': u'\U0001F468\U0001F3FF\U0000200D\U00002695\U0000FE0F',
    u':man_health_worker_light_skin_tone:': u'\U0001F468\U0001F3FB\U0000200D\U00002695\U0000FE0F',
    u':man_health_worker_medium-dark_skin_tone:': u'\U0001F468\U0001F3FE\U0000200D\U00002695\U0000FE0F',
    u':man_health_worker_medium-light_skin_tone:': u'\U0001F468\U0001F3FC\U0000200D\U00002695\U0000FE0F',
    u':man_health_worker_medium_skin_tone:': u'\U0001F468\U0001F3FD\U0000200D\U00002695\U0000FE0F',
    u':man_health_worker_selector:': u'\U0001F468\U0000200D\U00002695\U0000FE0F',
    u':man_in_lotus_position-dark_skin_tone:': u'\U0001F9D8\U0001F3FF\U0000200D\U00002642',
    u':man_in_lotus_position-light_skin_tone:': u'\U0001F9D8\U0001F3FB\U0000200D\U00002642',
    u':man_in_lotus_position-medium-dark_skin_tone:': u'\U0001F9D8\U0001F3FE\U0000200D\U00002642',
    u':man_in_lotus_position-medium-light_skin_tone:': u'\U0001F9D8\U0001F3FC\U0000200D\U00002642',
    u':man_in_lotus_position-medium_skin_tone:': u'\U0001F9D8\U0001F3FD\U0000200D\U00002642',
    u':man_in_lotus_position:': u'\U0001F9D8\U0000200D\U00002642',
    u':man_in_lotus_position_dark_skin_tone:': u'\U0001F9D8\U0001F3FF\U0000200D\U00002642\U0000FE0F',
    u':man_in_lotus_position_light_skin_tone:': u'\U0001F9D8\U0001F3FB\U0000200D\U00002642\U0000FE0F',
    u':man_in_lotus_position_medium-dark_skin_tone:': u'\U0001F9D8\U0001F3FE\U0000200D\U00002642\U0000FE0F',
    u':man_in_lotus_position_medium-light_skin_tone:': u'\U0001F9D8\U0001F3FC\U0000200D\U00002642\U0000FE0F',
    u':man_in_lotus_position_medium_skin_tone:': u'\U0001F9D8\U0001F3FD\U0000200D\U00002642\U0000FE0F',
    u':man_in_lotus_position_selector:': u'\U0001F9D8\U0000200D\U00002642\U0000FE0F',
    u':man_in_manual_wheelchair-dark_skin_tone:': u'\U0001F468\U0001F3FF\U0000200D\U0001F9BD',
    u':man_in_manual_wheelchair-light_skin_tone:': u'\U0001F468\U0001F3FB\U0000200D\U0001F9BD',
    u':man_in_manual_wheelchair-medium-dark_skin_tone:': u'\U0001F468\U0001F3FE\U0000200D\U0001F9BD',
    u':man_in_manual_wheelchair-medium-light_skin_tone:': u'\U0001F468\U0001F3FC\U0000200D\U0001F9BD',
    u':man_in_manual_wheelchair-medium_skin_tone:': u'\U0001F468\U0001F3FD\U0000200D\U0001F9BD',
    u':man_in_manual_wheelchair:': u'\U0001F468\U0000200D\U0001F9BD',
    u':man_in_motorized_wheelchair-dark_skin_tone:': u'\U0001F468\U0001F3FF\U0000200D\U0001F9BC',
    u':man_in_motorized_wheelchair-light_skin_tone:': u'\U0001F468\U0001F3FB\U0000200D\U0001F9BC',
    u':man_in_motorized_wheelchair-medium-dark_skin_tone:': u'\U0001F468\U0001F3FE\U0000200D\U0001F9BC',
    u':man_in_motorized_wheelchair-medium-light_skin_tone:': u'\U0001F468\U0001F3FC\U0000200D\U0001F9BC',
    u':man_in_motorized_wheelchair-medium_skin_tone:': u'\U0001F468\U0001F3FD\U0000200D\U0001F9BC',
    u':man_in_motorized_wheelchair:': u'\U0001F468\U0000200D\U0001F9BC',
    u':man_in_steamy_room-dark_skin_tone:': u'\U0001F9D6\U0001F3FF\U0000200D\U00002642',
    u':man_in_steamy_room-light_skin_tone:': u'\U0001F9D6\U0001F3FB\U0000200D\U00002642',
    u':man_in_steamy_room-medium-dark_skin_tone:': u'\U0001F9D6\U0001F3FE\U0000200D\U00002642',
    u':man_in_steamy_room-medium-light_skin_tone:': u'\U0001F9D6\U0001F3FC\U0000200D\U00002642',
    u':man_in_steamy_room-medium_skin_tone:': u'\U0001F9D6\U0001F3FD\U0000200D\U00002642',
    u':man_in_steamy_room:': u'\U0001F9D6\U0000200D\U00002642',
    u':man_in_steamy_room_dark_skin_tone:': u'\U0001F9D6\U0001F3FF\U0000200D\U00002642\U0000FE0F',
    u':man_in_steamy_room_light_skin_tone:': u'\U0001F9D6\U0001F3FB\U0000200D\U00002642\U0000FE0F',
    u':man_in_steamy_room_medium-dark_skin_tone:': u'\U0001F9D6\U0001F3FE\U0000200D\U00002642\U0000FE0F',
    u':man_in_steamy_room_medium-light_skin_tone:': u'\U0001F9D6\U0001F3FC\U0000200D\U00002642\U0000FE0F',
    u':man_in_steamy_room_medium_skin_tone:': u'\U0001F9D6\U0001F3FD\U0000200D\U00002642\U0000FE0F',
    u':man_in_steamy_room_selector:': u'\U0001F9D6\U0000200D\U00002642\U0000FE0F',
    u':man_in_suit_levitating:': u'\U0001F574',
    u':man_in_suit_levitating_dark_skin_tone:': u'\U0001F574\U0001F3FF',
    u':man_in_suit_levitating_light_skin_tone:': u'\U0001F574\U0001F3FB',
    u':man_in_suit_levitating_medium-dark_skin_tone:': u'\U0001F574\U0001F3FE',
    u':man_in_suit_levitating_medium-light_skin_tone:': u'\U0001F574\U0001F3FC',
    u':man_in_suit_levitating_medium_skin_tone:': u'\U0001F574\U0001F3FD',
    u':man_in_suit_levitating_selector:': u'\U0001F574\U0000FE0F',
    u':man_in_tuxedo:': u'\U0001F935',
    u':man_in_tuxedo_dark_skin_tone:': u'\U0001F935\U0001F3FF',
    u':man_in_tuxedo_light_skin_tone:': u'\U0001F935\U0001F3FB',
    u':man_in_tuxedo_medium-dark_skin_tone:': u'\U0001F935\U0001F3FE',
    u':man_in_tuxedo_medium-light_skin_tone:': u'\U0001F935\U0001F3FC',
    u':man_in_tuxedo_medium_skin_tone:': u'\U0001F935\U0001F3FD',
    u':man_judge-dark_skin_tone:': u'\U0001F468\U0001F3FF\U0000200D\U00002696',
    u':man_judge-light_skin_tone:': u'\U0001F468\U0001F3FB\U0000200D\U00002696',
    u':man_judge-medium-dark_skin_tone:': u'\U0001F468\U0001F3FE\U0000200D\U00002696',
    u':man_judge-medium-light_skin_tone:': u'\U0001F468\U0001F3FC\U0000200D\U00002696',
    u':man_judge-medium_skin_tone:': u'\U0001F468\U0001F3FD\U0000200D\U00002696',
    u':man_judge:': u'\U0001F468\U0000200D\U00002696',
    u':man_judge_dark_skin_tone:': u'\U0001F468\U0001F3FF\U0000200D\U00002696\U0000FE0F',
    u':man_judge_light_skin_tone:': u'\U0001F468\U0001F3FB\U0000200D\U00002696\U0000FE0F',
    u':man_judge_medium-dark_skin_tone:': u'\U0001F468\U0001F3FE\U0000200D\U00002696\U0000FE0F',
    u':man_judge_medium-light_skin_tone:': u'\U0001F468\U0001F3FC\U0000200D\U00002696\U0000FE0F',
    u':man_judge_medium_skin_tone:': u'\U0001F468\U0001F3FD\U0000200D\U00002696\U0000FE0F',
    u':man_judge_selector:': u'\U0001F468\U0000200D\U00002696\U0000FE0F',
    u':man_juggling-dark_skin_tone:': u'\U0001F939\U0001F3FF\U0000200D\U00002642',
    u':man_juggling-light_skin_tone:': u'\U0001F939\U0001F3FB\U0000200D\U00002642',
    u':man_juggling-medium-dark_skin_tone:': u'\U0001F939\U0001F3FE\U0000200D\U00002642',
    u':man_juggling-medium-light_skin_tone:': u'\U0001F939\U0001F3FC\U0000200D\U00002642',
    u':man_juggling-medium_skin_tone:': u'\U0001F939\U0001F3FD\U0000200D\U00002642',
    u':man_juggling:': u'\U0001F939\U0000200D\U00002642',
    u':man_juggling_dark_skin_tone:': u'\U0001F939\U0001F3FF\U0000200D\U00002642\U0000FE0F',
    u':man_juggling_light_skin_tone:': u'\U0001F939\U0001F3FB\U0000200D\U00002642\U0000FE0F',
    u':man_juggling_medium-dark_skin_tone:': u'\U0001F939\U0001F3FE\U0000200D\U00002642\U0000FE0F',
    u':man_juggling_medium-light_skin_tone:': u'\U0001F939\U0001F3FC\U0000200D\U00002642\U0000FE0F',
    u':man_juggling_medium_skin_tone:': u'\U0001F939\U0001F3FD\U0000200D\U00002642\U0000FE0F',
    u':man_juggling_selector:': u'\U0001F939\U0000200D\U00002642\U0000FE0F',
    u':man_kneeling-dark_skin_tone:': u'\U0001F9CE\U0001F3FF\U0000200D\U00002642',
    u':man_kneeling-dark_skin_tone_selector:': u'\U0001F9CE\U0001F3FF\U0000200D\U00002642\U0000FE0F',
    u':man_kneeling-light_skin_tone:': u'\U0001F9CE\U0001F3FB\U0000200D\U00002642',
    u':man_kneeling-light_skin_tone_selector:': u'\U0001F9CE\U0001F3FB\U0000200D\U00002642\U0000FE0F',
    u':man_kneeling-medium-dark_skin_tone:': u'\U0001F9CE\U0001F3FE\U0000200D\U00002642',
    u':man_kneeling-medium-dark_skin_tone_selector:': u'\U0001F9CE\U0001F3FE\U0000200D\U00002642\U0000FE0F',
    u':man_kneeling-medium-light_skin_tone:': u'\U0001F9CE\U0001F3FC\U0000200D\U00002642',
    u':man_kneeling-medium-light_skin_tone_selector:': u'\U0001F9CE\U0001F3FC\U0000200D\U00002642\U0000FE0F',
    u':man_kneeling-medium_skin_tone:': u'\U0001F9CE\U0001F3FD\U0000200D\U00002642',
    u':man_kneeling-medium_skin_tone_selector:': u'\U0001F9CE\U0001F3FD\U0000200D\U00002642\U0000FE0F',
    u':man_kneeling:': u'\U0001F9CE\U0000200D\U00002642',
    u':man_kneeling_selector:': u'\U0001F9CE\U0000200D\U00002642\U0000FE0F',
    u':man_lifting_weights-dark_skin_tone:': u'\U0001F3CB\U0001F3FF\U0000200D\U00002642',
    u':man_lifting_weights-light_skin_tone:': u'\U0001F3CB\U0001F3FB\U0000200D\U00002642',
    u':man_lifting_weights-medium-dark_skin_tone:': u'\U0001F3CB\U0001F3FE\U0000200D\U00002642',
    u':man_lifting_weights-medium-light_skin_tone:': u'\U0001F3CB\U0001F3FC\U0000200D\U00002642',
    u':man_lifting_weights-medium_skin_tone:': u'\U0001F3CB\U0001F3FD\U0000200D\U00002642',
    u':man_lifting_weights:': u'\U0001F3CB\U0000200D\U00002642',
    u':man_lifting_weights_2:': u'\U0001F3CB\U0000FE0F\U0000200D\U00002642\U0000FE0F',
    u':man_lifting_weights_3:': u'\U0001F3CB\U0000200D\U00002642\U0000FE0F',
    u':man_lifting_weights_dark_skin_tone:': u'\U0001F3CB\U0001F3FF\U0000200D\U00002642\U0000FE0F',
    u':man_lifting_weights_light_skin_tone:': u'\U0001F3CB\U0001F3FB\U0000200D\U00002642\U0000FE0F',
    u':man_lifting_weights_medium-dark_skin_tone:': u'\U0001F3CB\U0001F3FE\U0000200D\U00002642\U0000FE0F',
    u':man_lifting_weights_medium-light_skin_tone:': u'\U0001F3CB\U0001F3FC\U0000200D\U00002642\U0000FE0F',
    u':man_lifting_weights_medium_skin_tone:': u'\U0001F3CB\U0001F3FD\U0000200D\U00002642\U0000FE0F',
    u':man_lifting_weights_selector:': u'\U0001F3CB\U0000FE0F\U0000200D\U00002642',
    u':man_light_skin_tone:': u'\U0001F468\U0001F3FB',
    u':man_mage-dark_skin_tone:': u'\U0001F9D9\U0001F3FF\U0000200D\U00002642',
    u':man_mage-light_skin_tone:': u'\U0001F9D9\U0001F3FB\U0000200D\U00002642',
    u':man_mage-medium-dark_skin_tone:': u'\U0001F9D9\U0001F3FE\U0000200D\U00002642',
    u':man_mage-medium-light_skin_tone:': u'\U0001F9D9\U0001F3FC\U0000200D\U00002642',
    u':man_mage-medium_skin_tone:': u'\U0001F9D9\U0001F3FD\U0000200D\U00002642',
    u':man_mage:': u'\U0001F9D9\U0000200D\U00002642',
    u':man_mage_dark_skin_tone:': u'\U0001F9D9\U0001F3FF\U0000200D\U00002642\U0000FE0F',
    u':man_mage_light_skin_tone:': u'\U0001F9D9\U0001F3FB\U0000200D\U00002642\U0000FE0F',
    u':man_mage_medium-dark_skin_tone:': u'\U0001F9D9\U0001F3FE\U0000200D\U00002642\U0000FE0F',
    u':man_mage_medium-light_skin_tone:': u'\U0001F9D9\U0001F3FC\U0000200D\U00002642\U0000FE0F',
    u':man_mage_medium_skin_tone:': u'\U0001F9D9\U0001F3FD\U0000200D\U00002642\U0000FE0F',
    u':man_mage_selector:': u'\U0001F9D9\U0000200D\U00002642\U0000FE0F',
    u':man_mechanic:': u'\U0001F468\U0000200D\U0001F527',
    u':man_mechanic_dark_skin_tone:': u'\U0001F468\U0001F3FF\U0000200D\U0001F527',
    u':man_mechanic_light_skin_tone:': u'\U0001F468\U0001F3FB\U0000200D\U0001F527',
    u':man_mechanic_medium-dark_skin_tone:': u'\U0001F468\U0001F3FE\U0000200D\U0001F527',
    u':man_mechanic_medium-light_skin_tone:': u'\U0001F468\U0001F3FC\U0000200D\U0001F527',
    u':man_mechanic_medium_skin_tone:': u'\U0001F468\U0001F3FD\U0000200D\U0001F527',
    u':man_medium-dark_skin_tone:': u'\U0001F468\U0001F3FE',
    u':man_medium-light_skin_tone:': u'\U0001F468\U0001F3FC',
    u':man_medium_skin_tone:': u'\U0001F468\U0001F3FD',
    u':man_mountain_biking-dark_skin_tone:': u'\U0001F6B5\U0001F3FF\U0000200D\U00002642',
    u':man_mountain_biking-light_skin_tone:': u'\U0001F6B5\U0001F3FB\U0000200D\U00002642',
    u':man_mountain_biking-medium-dark_skin_tone:': u'\U0001F6B5\U0001F3FE\U0000200D\U00002642',
    u':man_mountain_biking-medium-light_skin_tone:': u'\U0001F6B5\U0001F3FC\U0000200D\U00002642',
    u':man_mountain_biking-medium_skin_tone:': u'\U0001F6B5\U0001F3FD\U0000200D\U00002642',
    u':man_mountain_biking:': u'\U0001F6B5\U0000200D\U00002642',
    u':man_mountain_biking_dark_skin_tone:': u'\U0001F6B5\U0001F3FF\U0000200D\U00002642\U0000FE0F',
    u':man_mountain_biking_light_skin_tone:': u'\U0001F6B5\U0001F3FB\U0000200D\U00002642\U0000FE0F',
    u':man_mountain_biking_medium-dark_skin_tone:': u'\U0001F6B5\U0001F3FE\U0000200D\U00002642\U0000FE0F',
    u':man_mountain_biking_medium-light_skin_tone:': u'\U0001F6B5\U0001F3FC\U0000200D\U00002642\U0000FE0F',
    u':man_mountain_biking_medium_skin_tone:': u'\U0001F6B5\U0001F3FD\U0000200D\U00002642\U0000FE0F',
    u':man_mountain_biking_selector:': u'\U0001F6B5\U0000200D\U00002642\U0000FE0F',
    u':man_office_worker:': u'\U0001F468\U0000200D\U0001F4BC',
    u':man_office_worker_dark_skin_tone:': u'\U0001F468\U0001F3FF\U0000200D\U0001F4BC',
    u':man_office_worker_light_skin_tone:': u'\U0001F468\U0001F3FB\U0000200D\U0001F4BC',
    u':man_office_worker_medium-dark_skin_tone:': u'\U0001F468\U0001F3FE\U0000200D\U0001F4BC',
    u':man_office_worker_medium-light_skin_tone:': u'\U0001F468\U0001F3FC\U0000200D\U0001F4BC',
    u':man_office_worker_medium_skin_tone:': u'\U0001F468\U0001F3FD\U0000200D\U0001F4BC',
    u':man_pilot-dark_skin_tone:': u'\U0001F468\U0001F3FF\U0000200D\U00002708',
    u':man_pilot-light_skin_tone:': u'\U0001F468\U0001F3FB\U0000200D\U00002708',
    u':man_pilot-medium-dark_skin_tone:': u'\U0001F468\U0001F3FE\U0000200D\U00002708',
    u':man_pilot-medium-light_skin_tone:': u'\U0001F468\U0001F3FC\U0000200D\U00002708',
    u':man_pilot-medium_skin_tone:': u'\U0001F468\U0001F3FD\U0000200D\U00002708',
    u':man_pilot:': u'\U0001F468\U0000200D\U00002708',
    u':man_pilot_dark_skin_tone:': u'\U0001F468\U0001F3FF\U0000200D\U00002708\U0000FE0F',
    u':man_pilot_light_skin_tone:': u'\U0001F468\U0001F3FB\U0000200D\U00002708\U0000FE0F',
    u':man_pilot_medium-dark_skin_tone:': u'\U0001F468\U0001F3FE\U0000200D\U00002708\U0000FE0F',
    u':man_pilot_medium-light_skin_tone:': u'\U0001F468\U0001F3FC\U0000200D\U00002708\U0000FE0F',
    u':man_pilot_medium_skin_tone:': u'\U0001F468\U0001F3FD\U0000200D\U00002708\U0000FE0F',
    u':man_pilot_selector:': u'\U0001F468\U0000200D\U00002708\U0000FE0F',
    u':man_playing_handball-dark_skin_tone:': u'\U0001F93E\U0001F3FF\U0000200D\U00002642',
    u':man_playing_handball-light_skin_tone:': u'\U0001F93E\U0001F3FB\U0000200D\U00002642',
    u':man_playing_handball-medium-dark_skin_tone:': u'\U0001F93E\U0001F3FE\U0000200D\U00002642',
    u':man_playing_handball-medium-light_skin_tone:': u'\U0001F93E\U0001F3FC\U0000200D\U00002642',
    u':man_playing_handball-medium_skin_tone:': u'\U0001F93E\U0001F3FD\U0000200D\U00002642',
    u':man_playing_handball:': u'\U0001F93E\U0000200D\U00002642',
    u':man_playing_handball_dark_skin_tone:': u'\U0001F93E\U0001F3FF\U0000200D\U00002642\U0000FE0F',
    u':man_playing_handball_light_skin_tone:': u'\U0001F93E\U0001F3FB\U0000200D\U00002642\U0000FE0F',
    u':man_playing_handball_medium-dark_skin_tone:': u'\U0001F93E\U0001F3FE\U0000200D\U00002642\U0000FE0F',
    u':man_playing_handball_medium-light_skin_tone:': u'\U0001F93E\U0001F3FC\U0000200D\U00002642\U0000FE0F',
    u':man_playing_handball_medium_skin_tone:': u'\U0001F93E\U0001F3FD\U0000200D\U00002642\U0000FE0F',
    u':man_playing_handball_selector:': u'\U0001F93E\U0000200D\U00002642\U0000FE0F',
    u':man_playing_water_polo-dark_skin_tone:': u'\U0001F93D\U0001F3FF\U0000200D\U00002642',
    u':man_playing_water_polo-light_skin_tone:': u'\U0001F93D\U0001F3FB\U0000200D\U00002642',
    u':man_playing_water_polo-medium-dark_skin_tone:': u'\U0001F93D\U0001F3FE\U0000200D\U00002642',
    u':man_playing_water_polo-medium-light_skin_tone:': u'\U0001F93D\U0001F3FC\U0000200D\U00002642',
    u':man_playing_water_polo-medium_skin_tone:': u'\U0001F93D\U0001F3FD\U0000200D\U00002642',
    u':man_playing_water_polo:': u'\U0001F93D\U0000200D\U00002642',
    u':man_playing_water_polo_dark_skin_tone:': u'\U0001F93D\U0001F3FF\U0000200D\U00002642\U0000FE0F',
    u':man_playing_water_polo_light_skin_tone:': u'\U0001F93D\U0001F3FB\U0000200D\U00002642\U0000FE0F',
    u':man_playing_water_polo_medium-dark_skin_tone:': u'\U0001F93D\U0001F3FE\U0000200D\U00002642\U0000FE0F',
    u':man_playing_water_polo_medium-light_skin_tone:': u'\U0001F93D\U0001F3FC\U0000200D\U00002642\U0000FE0F',
    u':man_playing_water_polo_medium_skin_tone:': u'\U0001F93D\U0001F3FD\U0000200D\U00002642\U0000FE0F',
    u':man_playing_water_polo_selector:': u'\U0001F93D\U0000200D\U00002642\U0000FE0F',
    u':man_police_officer-dark_skin_tone:': u'\U0001F46E\U0001F3FF\U0000200D\U00002642',
    u':man_police_officer-light_skin_tone:': u'\U0001F46E\U0001F3FB\U0000200D\U00002642',
    u':man_police_officer-medium-dark_skin_tone:': u'\U0001F46E\U0001F3FE\U0000200D\U00002642',
    u':man_police_officer-medium-light_skin_tone:': u'\U0001F46E\U0001F3FC\U0000200D\U00002642',
    u':man_police_officer-medium_skin_tone:': u'\U0001F46E\U0001F3FD\U0000200D\U00002642',
    u':man_police_officer:': u'\U0001F46E\U0000200D\U00002642',
    u':man_police_officer_dark_skin_tone:': u'\U0001F46E\U0001F3FF\U0000200D\U00002642\U0000FE0F',
    u':man_police_officer_light_skin_tone:': u'\U0001F46E\U0001F3FB\U0000200D\U00002642\U0000FE0F',
    u':man_police_officer_medium-dark_skin_tone:': u'\U0001F46E\U0001F3FE\U0000200D\U00002642\U0000FE0F',
    u':man_police_officer_medium-light_skin_tone:': u'\U0001F46E\U0001F3FC\U0000200D\U00002642\U0000FE0F',
    u':man_police_officer_medium_skin_tone:': u'\U0001F46E\U0001F3FD\U0000200D\U00002642\U0000FE0F',
    u':man_police_officer_selector:': u'\U0001F46E\U0000200D\U00002642\U0000FE0F',
    u':man_pouting-dark_skin_tone:': u'\U0001F64E\U0001F3FF\U0000200D\U00002642',
    u':man_pouting-light_skin_tone:': u'\U0001F64E\U0001F3FB\U0000200D\U00002642',
    u':man_pouting-medium-dark_skin_tone:': u'\U0001F64E\U0001F3FE\U0000200D\U00002642',
    u':man_pouting-medium-light_skin_tone:': u'\U0001F64E\U0001F3FC\U0000200D\U00002642',
    u':man_pouting-medium_skin_tone:': u'\U0001F64E\U0001F3FD\U0000200D\U00002642',
    u':man_pouting:': u'\U0001F64E\U0000200D\U00002642',
    u':man_pouting_dark_skin_tone:': u'\U0001F64E\U0001F3FF\U0000200D\U00002642\U0000FE0F',
    u':man_pouting_light_skin_tone:': u'\U0001F64E\U0001F3FB\U0000200D\U00002642\U0000FE0F',
    u':man_pouting_medium-dark_skin_tone:': u'\U0001F64E\U0001F3FE\U0000200D\U00002642\U0000FE0F',
    u':man_pouting_medium-light_skin_tone:': u'\U0001F64E\U0001F3FC\U0000200D\U00002642\U0000FE0F',
    u':man_pouting_medium_skin_tone:': u'\U0001F64E\U0001F3FD\U0000200D\U00002642\U0000FE0F',
    u':man_pouting_selector:': u'\U0001F64E\U0000200D\U00002642\U0000FE0F',
    u':man_raising_hand-dark_skin_tone:': u'\U0001F64B\U0001F3FF\U0000200D\U00002642',
    u':man_raising_hand-light_skin_tone:': u'\U0001F64B\U0001F3FB\U0000200D\U00002642',
    u':man_raising_hand-medium-dark_skin_tone:': u'\U0001F64B\U0001F3FE\U0000200D\U00002642',
    u':man_raising_hand-medium-light_skin_tone:': u'\U0001F64B\U0001F3FC\U0000200D\U00002642',
    u':man_raising_hand-medium_skin_tone:': u'\U0001F64B\U0001F3FD\U0000200D\U00002642',
    u':man_raising_hand:': u'\U0001F64B\U0000200D\U00002642',
    u':man_raising_hand_dark_skin_tone:': u'\U0001F64B\U0001F3FF\U0000200D\U00002642\U0000FE0F',
    u':man_raising_hand_light_skin_tone:': u'\U0001F64B\U0001F3FB\U0000200D\U00002642\U0000FE0F',
    u':man_raising_hand_medium-dark_skin_tone:': u'\U0001F64B\U0001F3FE\U0000200D\U00002642\U0000FE0F',
    u':man_raising_hand_medium-light_skin_tone:': u'\U0001F64B\U0001F3FC\U0000200D\U00002642\U0000FE0F',
    u':man_raising_hand_medium_skin_tone:': u'\U0001F64B\U0001F3FD\U0000200D\U00002642\U0000FE0F',
    u':man_raising_hand_selector:': u'\U0001F64B\U0000200D\U00002642\U0000FE0F',
    u':man_rowing_boat-dark_skin_tone:': u'\U0001F6A3\U0001F3FF\U0000200D\U00002642',
    u':man_rowing_boat-light_skin_tone:': u'\U0001F6A3\U0001F3FB\U0000200D\U00002642',
    u':man_rowing_boat-medium-dark_skin_tone:': u'\U0001F6A3\U0001F3FE\U0000200D\U00002642',
    u':man_rowing_boat-medium-light_skin_tone:': u'\U0001F6A3\U0001F3FC\U0000200D\U00002642',
    u':man_rowing_boat-medium_skin_tone:': u'\U0001F6A3\U0001F3FD\U0000200D\U00002642',
    u':man_rowing_boat:': u'\U0001F6A3\U0000200D\U00002642',
    u':man_rowing_boat_dark_skin_tone:': u'\U0001F6A3\U0001F3FF\U0000200D\U00002642\U0000FE0F',
    u':man_rowing_boat_light_skin_tone:': u'\U0001F6A3\U0001F3FB\U0000200D\U00002642\U0000FE0F',
    u':man_rowing_boat_medium-dark_skin_tone:': u'\U0001F6A3\U0001F3FE\U0000200D\U00002642\U0000FE0F',
    u':man_rowing_boat_medium-light_skin_tone:': u'\U0001F6A3\U0001F3FC\U0000200D\U00002642\U0000FE0F',
    u':man_rowing_boat_medium_skin_tone:': u'\U0001F6A3\U0001F3FD\U0000200D\U00002642\U0000FE0F',
    u':man_rowing_boat_selector:': u'\U0001F6A3\U0000200D\U00002642\U0000FE0F',
    u':man_running-dark_skin_tone:': u'\U0001F3C3\U0001F3FF\U0000200D\U00002642',
    u':man_running-light_skin_tone:': u'\U0001F3C3\U0001F3FB\U0000200D\U00002642',
    u':man_running-medium-dark_skin_tone:': u'\U0001F3C3\U0001F3FE\U0000200D\U00002642',
    u':man_running-medium-light_skin_tone:': u'\U0001F3C3\U0001F3FC\U0000200D\U00002642',
    u':man_running-medium_skin_tone:': u'\U0001F3C3\U0001F3FD\U0000200D\U00002642',
    u':man_running:': u'\U0001F3C3\U0000200D\U00002642',
    u':man_running_dark_skin_tone:': u'\U0001F3C3\U0001F3FF\U0000200D\U00002642\U0000FE0F',
    u':man_running_light_skin_tone:': u'\U0001F3C3\U0001F3FB\U0000200D\U00002642\U0000FE0F',
    u':man_running_medium-dark_skin_tone:': u'\U0001F3C3\U0001F3FE\U0000200D\U00002642\U0000FE0F',
    u':man_running_medium-light_skin_tone:': u'\U0001F3C3\U0001F3FC\U0000200D\U00002642\U0000FE0F',
    u':man_running_medium_skin_tone:': u'\U0001F3C3\U0001F3FD\U0000200D\U00002642\U0000FE0F',
    u':man_running_selector:': u'\U0001F3C3\U0000200D\U00002642\U0000FE0F',
    u':man_scientist:': u'\U0001F468\U0000200D\U0001F52C',
    u':man_scientist_dark_skin_tone:': u'\U0001F468\U0001F3FF\U0000200D\U0001F52C',
    u':man_scientist_light_skin_tone:': u'\U0001F468\U0001F3FB\U0000200D\U0001F52C',
    u':man_scientist_medium-dark_skin_tone:': u'\U0001F468\U0001F3FE\U0000200D\U0001F52C',
    u':man_scientist_medium-light_skin_tone:': u'\U0001F468\U0001F3FC\U0000200D\U0001F52C',
    u':man_scientist_medium_skin_tone:': u'\U0001F468\U0001F3FD\U0000200D\U0001F52C',
    u':man_shrugging-dark_skin_tone:': u'\U0001F937\U0001F3FF\U0000200D\U00002642',
    u':man_shrugging-light_skin_tone:': u'\U0001F937\U0001F3FB\U0000200D\U00002642',
    u':man_shrugging-medium-dark_skin_tone:': u'\U0001F937\U0001F3FE\U0000200D\U00002642',
    u':man_shrugging-medium-light_skin_tone:': u'\U0001F937\U0001F3FC\U0000200D\U00002642',
    u':man_shrugging-medium_skin_tone:': u'\U0001F937\U0001F3FD\U0000200D\U00002642',
    u':man_shrugging:': u'\U0001F937\U0000200D\U00002642',
    u':man_shrugging_dark_skin_tone:': u'\U0001F937\U0001F3FF\U0000200D\U00002642\U0000FE0F',
    u':man_shrugging_light_skin_tone:': u'\U0001F937\U0001F3FB\U0000200D\U00002642\U0000FE0F',
    u':man_shrugging_medium-dark_skin_tone:': u'\U0001F937\U0001F3FE\U0000200D\U00002642\U0000FE0F',
    u':man_shrugging_medium-light_skin_tone:': u'\U0001F937\U0001F3FC\U0000200D\U00002642\U0000FE0F',
    u':man_shrugging_medium_skin_tone:': u'\U0001F937\U0001F3FD\U0000200D\U00002642\U0000FE0F',
    u':man_shrugging_selector:': u'\U0001F937\U0000200D\U00002642\U0000FE0F',
    u':man_singer:': u'\U0001F468\U0000200D\U0001F3A4',
    u':man_singer_dark_skin_tone:': u'\U0001F468\U0001F3FF\U0000200D\U0001F3A4',
    u':man_singer_light_skin_tone:': u'\U0001F468\U0001F3FB\U0000200D\U0001F3A4',
    u':man_singer_medium-dark_skin_tone:': u'\U0001F468\U0001F3FE\U0000200D\U0001F3A4',
    u':man_singer_medium-light_skin_tone:': u'\U0001F468\U0001F3FC\U0000200D\U0001F3A4',
    u':man_singer_medium_skin_tone:': u'\U0001F468\U0001F3FD\U0000200D\U0001F3A4',
    u':man_standing-dark_skin_tone:': u'\U0001F9CD\U0001F3FF\U0000200D\U00002642',
    u':man_standing-dark_skin_tone_selector:': u'\U0001F9CD\U0001F3FF\U0000200D\U00002642\U0000FE0F',
    u':man_standing-light_skin_tone:': u'\U0001F9CD\U0001F3FB\U0000200D\U00002642',
    u':man_standing-light_skin_tone_selector:': u'\U0001F9CD\U0001F3FB\U0000200D\U00002642\U0000FE0F',
    u':man_standing-medium-dark_skin_tone:': u'\U0001F9CD\U0001F3FE\U0000200D\U00002642',
    u':man_standing-medium-dark_skin_tone_selector:': u'\U0001F9CD\U0001F3FE\U0000200D\U00002642\U0000FE0F',
    u':man_standing-medium-light_skin_tone:': u'\U0001F9CD\U0001F3FC\U0000200D\U00002642',
    u':man_standing-medium-light_skin_tone_selector:': u'\U0001F9CD\U0001F3FC\U0000200D\U00002642\U0000FE0F',
    u':man_standing-medium_skin_tone:': u'\U0001F9CD\U0001F3FD\U0000200D\U00002642',
    u':man_standing-medium_skin_tone_selector:': u'\U0001F9CD\U0001F3FD\U0000200D\U00002642\U0000FE0F',
    u':man_standing:': u'\U0001F9CD\U0000200D\U00002642',
    u':man_standing_selector:': u'\U0001F9CD\U0000200D\U00002642\U0000FE0F',
    u':man_student:': u'\U0001F468\U0000200D\U0001F393',
    u':man_student_dark_skin_tone:': u'\U0001F468\U0001F3FF\U0000200D\U0001F393',
    u':man_student_light_skin_tone:': u'\U0001F468\U0001F3FB\U0000200D\U0001F393',
    u':man_student_medium-dark_skin_tone:': u'\U0001F468\U0001F3FE\U0000200D\U0001F393',
    u':man_student_medium-light_skin_tone:': u'\U0001F468\U0001F3FC\U0000200D\U0001F393',
    u':man_student_medium_skin_tone:': u'\U0001F468\U0001F3FD\U0000200D\U0001F393',
    u':man_superhero-dark_skin_tone:': u'\U0001F9B8\U0001F3FF\U0000200D\U00002642',
    u':man_superhero-dark_skin_tone_selector:': u'\U0001F9B8\U0001F3FF\U0000200D\U00002642\U0000FE0F',
    u':man_superhero-light_skin_tone:': u'\U0001F9B8\U0001F3FB\U0000200D\U00002642',
    u':man_superhero-light_skin_tone_selector:': u'\U0001F9B8\U0001F3FB\U0000200D\U00002642\U0000FE0F',
    u':man_superhero-medium-dark_skin_tone:': u'\U0001F9B8\U0001F3FE\U0000200D\U00002642',
    u':man_superhero-medium-dark_skin_tone_selector:': u'\U0001F9B8\U0001F3FE\U0000200D\U00002642\U0000FE0F',
    u':man_superhero-medium-light_skin_tone:': u'\U0001F9B8\U0001F3FC\U0000200D\U00002642',
    u':man_superhero-medium-light_skin_tone_selector:': u'\U0001F9B8\U0001F3FC\U0000200D\U00002642\U0000FE0F',
    u':man_superhero-medium_skin_tone:': u'\U0001F9B8\U0001F3FD\U0000200D\U00002642',
    u':man_superhero-medium_skin_tone_selector:': u'\U0001F9B8\U0001F3FD\U0000200D\U00002642\U0000FE0F',
    u':man_superhero:': u'\U0001F9B8\U0000200D\U00002642',
    u':man_superhero_selector:': u'\U0001F9B8\U0000200D\U00002642\U0000FE0F',
    u':man_supervillain-dark_skin_tone:': u'\U0001F9B9\U0001F3FF\U0000200D\U00002642',
    u':man_supervillain-dark_skin_tone_selector:': u'\U0001F9B9\U0001F3FF\U0000200D\U00002642\U0000FE0F',
    u':man_supervillain-light_skin_tone:': u'\U0001F9B9\U0001F3FB\U0000200D\U00002642',
    u':man_supervillain-light_skin_tone_selector:': u'\U0001F9B9\U0001F3FB\U0000200D\U00002642\U0000FE0F',
    u':man_supervillain-medium-dark_skin_tone:': u'\U0001F9B9\U0001F3FE\U0000200D\U00002642',
    u':man_supervillain-medium-dark_skin_tone_selector:': u'\U0001F9B9\U0001F3FE\U0000200D\U00002642\U0000FE0F',
    u':man_supervillain-medium-light_skin_tone:': u'\U0001F9B9\U0001F3FC\U0000200D\U00002642',
    u':man_supervillain-medium-light_skin_tone_selector:': u'\U0001F9B9\U0001F3FC\U0000200D\U00002642\U0000FE0F',
    u':man_supervillain-medium_skin_tone:': u'\U0001F9B9\U0001F3FD\U0000200D\U00002642',
    u':man_supervillain-medium_skin_tone_selector:': u'\U0001F9B9\U0001F3FD\U0000200D\U00002642\U0000FE0F',
    u':man_supervillain:': u'\U0001F9B9\U0000200D\U00002642',
    u':man_supervillain_selector:': u'\U0001F9B9\U0000200D\U00002642\U0000FE0F',
    u':man_surfing-dark_skin_tone:': u'\U0001F3C4\U0001F3FF\U0000200D\U00002642',
    u':man_surfing-light_skin_tone:': u'\U0001F3C4\U0001F3FB\U0000200D\U00002642',
    u':man_surfing-medium-dark_skin_tone:': u'\U0001F3C4\U0001F3FE\U0000200D\U00002642',
    u':man_surfing-medium-light_skin_tone:': u'\U0001F3C4\U0001F3FC\U0000200D\U00002642',
    u':man_surfing-medium_skin_tone:': u'\U0001F3C4\U0001F3FD\U0000200D\U00002642',
    u':man_surfing:': u'\U0001F3C4\U0000200D\U00002642',
    u':man_surfing_dark_skin_tone:': u'\U0001F3C4\U0001F3FF\U0000200D\U00002642\U0000FE0F',
    u':man_surfing_light_skin_tone:': u'\U0001F3C4\U0001F3FB\U0000200D\U00002642\U0000FE0F',
    u':man_surfing_medium-dark_skin_tone:': u'\U0001F3C4\U0001F3FE\U0000200D\U00002642\U0000FE0F',
    u':man_surfing_medium-light_skin_tone:': u'\U0001F3C4\U0001F3FC\U0000200D\U00002642\U0000FE0F',
    u':man_surfing_medium_skin_tone:': u'\U0001F3C4\U0001F3FD\U0000200D\U00002642\U0000FE0F',
    u':man_surfing_selector:': u'\U0001F3C4\U0000200D\U00002642\U0000FE0F',
    u':man_swimming-dark_skin_tone:': u'\U0001F3CA\U0001F3FF\U0000200D\U00002642',
    u':man_swimming-light_skin_tone:': u'\U0001F3CA\U0001F3FB\U0000200D\U00002642',
    u':man_swimming-medium-dark_skin_tone:': u'\U0001F3CA\U0001F3FE\U0000200D\U00002642',
    u':man_swimming-medium-light_skin_tone:': u'\U0001F3CA\U0001F3FC\U0000200D\U00002642',
    u':man_swimming-medium_skin_tone:': u'\U0001F3CA\U0001F3FD\U0000200D\U00002642',
    u':man_swimming:': u'\U0001F3CA\U0000200D\U00002642',
    u':man_swimming_dark_skin_tone:': u'\U0001F3CA\U0001F3FF\U0000200D\U00002642\U0000FE0F',
    u':man_swimming_light_skin_tone:': u'\U0001F3CA\U0001F3FB\U0000200D\U00002642\U0000FE0F',
    u':man_swimming_medium-dark_skin_tone:': u'\U0001F3CA\U0001F3FE\U0000200D\U00002642\U0000FE0F',
    u':man_swimming_medium-light_skin_tone:': u'\U0001F3CA\U0001F3FC\U0000200D\U00002642\U0000FE0F',
    u':man_swimming_medium_skin_tone:': u'\U0001F3CA\U0001F3FD\U0000200D\U00002642\U0000FE0F',
    u':man_swimming_selector:': u'\U0001F3CA\U0000200D\U00002642\U0000FE0F',
    u':man_teacher:': u'\U0001F468\U0000200D\U0001F3EB',
    u':man_teacher_dark_skin_tone:': u'\U0001F468\U0001F3FF\U0000200D\U0001F3EB',
    u':man_teacher_light_skin_tone:': u'\U0001F468\U0001F3FB\U0000200D\U0001F3EB',
    u':man_teacher_medium-dark_skin_tone:': u'\U0001F468\U0001F3FE\U0000200D\U0001F3EB',
    u':man_teacher_medium-light_skin_tone:': u'\U0001F468\U0001F3FC\U0000200D\U0001F3EB',
    u':man_teacher_medium_skin_tone:': u'\U0001F468\U0001F3FD\U0000200D\U0001F3EB',
    u':man_technologist:': u'\U0001F468\U0000200D\U0001F4BB',
    u':man_technologist_dark_skin_tone:': u'\U0001F468\U0001F3FF\U0000200D\U0001F4BB',
    u':man_technologist_light_skin_tone:': u'\U0001F468\U0001F3FB\U0000200D\U0001F4BB',
    u':man_technologist_medium-dark_skin_tone:': u'\U0001F468\U0001F3FE\U0000200D\U0001F4BB',
    u':man_technologist_medium-light_skin_tone:': u'\U0001F468\U0001F3FC\U0000200D\U0001F4BB',
    u':man_technologist_medium_skin_tone:': u'\U0001F468\U0001F3FD\U0000200D\U0001F4BB',
    u':man_tipping_hand-dark_skin_tone:': u'\U0001F481\U0001F3FF\U0000200D\U00002642',
    u':man_tipping_hand-light_skin_tone:': u'\U0001F481\U0001F3FB\U0000200D\U00002642',
    u':man_tipping_hand-medium-dark_skin_tone:': u'\U0001F481\U0001F3FE\U0000200D\U00002642',
    u':man_tipping_hand-medium-light_skin_tone:': u'\U0001F481\U0001F3FC\U0000200D\U00002642',
    u':man_tipping_hand-medium_skin_tone:': u'\U0001F481\U0001F3FD\U0000200D\U00002642',
    u':man_tipping_hand:': u'\U0001F481\U0000200D\U00002642',
    u':man_tipping_hand_dark_skin_tone:': u'\U0001F481\U0001F3FF\U0000200D\U00002642\U0000FE0F',
    u':man_tipping_hand_light_skin_tone:': u'\U0001F481\U0001F3FB\U0000200D\U00002642\U0000FE0F',
    u':man_tipping_hand_medium-dark_skin_tone:': u'\U0001F481\U0001F3FE\U0000200D\U00002642\U0000FE0F',
    u':man_tipping_hand_medium-light_skin_tone:': u'\U0001F481\U0001F3FC\U0000200D\U00002642\U0000FE0F',
    u':man_tipping_hand_medium_skin_tone:': u'\U0001F481\U0001F3FD\U0000200D\U00002642\U0000FE0F',
    u':man_tipping_hand_selector:': u'\U0001F481\U0000200D\U00002642\U0000FE0F',
    u':man_vampire-dark_skin_tone:': u'\U0001F9DB\U0001F3FF\U0000200D\U00002642',
    u':man_vampire-light_skin_tone:': u'\U0001F9DB\U0001F3FB\U0000200D\U00002642',
    u':man_vampire-medium-dark_skin_tone:': u'\U0001F9DB\U0001F3FE\U0000200D\U00002642',
    u':man_vampire-medium-light_skin_tone:': u'\U0001F9DB\U0001F3FC\U0000200D\U00002642',
    u':man_vampire-medium_skin_tone:': u'\U0001F9DB\U0001F3FD\U0000200D\U00002642',
    u':man_vampire:': u'\U0001F9DB\U0000200D\U00002642',
    u':man_vampire_dark_skin_tone:': u'\U0001F9DB\U0001F3FF\U0000200D\U00002642\U0000FE0F',
    u':man_vampire_light_skin_tone:': u'\U0001F9DB\U0001F3FB\U0000200D\U00002642\U0000FE0F',
    u':man_vampire_medium-dark_skin_tone:': u'\U0001F9DB\U0001F3FE\U0000200D\U00002642\U0000FE0F',
    u':man_vampire_medium-light_skin_tone:': u'\U0001F9DB\U0001F3FC\U0000200D\U00002642\U0000FE0F',
    u':man_vampire_medium_skin_tone:': u'\U0001F9DB\U0001F3FD\U0000200D\U00002642\U0000FE0F',
    u':man_vampire_selector:': u'\U0001F9DB\U0000200D\U00002642\U0000FE0F',
    u':man_walking-dark_skin_tone:': u'\U0001F6B6\U0001F3FF\U0000200D\U00002642',
    u':man_walking-light_skin_tone:': u'\U0001F6B6\U0001F3FB\U0000200D\U00002642',
    u':man_walking-medium-dark_skin_tone:': u'\U0001F6B6\U0001F3FE\U0000200D\U00002642',
    u':man_walking-medium-light_skin_tone:': u'\U0001F6B6\U0001F3FC\U0000200D\U00002642',
    u':man_walking-medium_skin_tone:': u'\U0001F6B6\U0001F3FD\U0000200D\U00002642',
    u':man_walking:': u'\U0001F6B6\U0000200D\U00002642',
    u':man_walking_dark_skin_tone:': u'\U0001F6B6\U0001F3FF\U0000200D\U00002642\U0000FE0F',
    u':man_walking_light_skin_tone:': u'\U0001F6B6\U0001F3FB\U0000200D\U00002642\U0000FE0F',
    u':man_walking_medium-dark_skin_tone:': u'\U0001F6B6\U0001F3FE\U0000200D\U00002642\U0000FE0F',
    u':man_walking_medium-light_skin_tone:': u'\U0001F6B6\U0001F3FC\U0000200D\U00002642\U0000FE0F',
    u':man_walking_medium_skin_tone:': u'\U0001F6B6\U0001F3FD\U0000200D\U00002642\U0000FE0F',
    u':man_walking_selector:': u'\U0001F6B6\U0000200D\U00002642\U0000FE0F',
    u':man_wearing_turban-dark_skin_tone:': u'\U0001F473\U0001F3FF\U0000200D\U00002642',
    u':man_wearing_turban-light_skin_tone:': u'\U0001F473\U0001F3FB\U0000200D\U00002642',
    u':man_wearing_turban-medium-dark_skin_tone:': u'\U0001F473\U0001F3FE\U0000200D\U00002642',
    u':man_wearing_turban-medium-light_skin_tone:': u'\U0001F473\U0001F3FC\U0000200D\U00002642',
    u':man_wearing_turban-medium_skin_tone:': u'\U0001F473\U0001F3FD\U0000200D\U00002642',
    u':man_wearing_turban:': u'\U0001F473\U0000200D\U00002642',
    u':man_wearing_turban_dark_skin_tone:': u'\U0001F473\U0001F3FF\U0000200D\U00002642\U0000FE0F',
    u':man_wearing_turban_light_skin_tone:': u'\U0001F473\U0001F3FB\U0000200D\U00002642\U0000FE0F',
    u':man_wearing_turban_medium-dark_skin_tone:': u'\U0001F473\U0001F3FE\U0000200D\U00002642\U0000FE0F',
    u':man_wearing_turban_medium-light_skin_tone:': u'\U0001F473\U0001F3FC\U0000200D\U00002642\U0000FE0F',
    u':man_wearing_turban_medium_skin_tone:': u'\U0001F473\U0001F3FD\U0000200D\U00002642\U0000FE0F',
    u':man_wearing_turban_selector:': u'\U0001F473\U0000200D\U00002642\U0000FE0F',
    u':man_with_Chinese_cap:': u'\U0001F472',
    u':man_with_Chinese_cap_dark_skin_tone:': u'\U0001F472\U0001F3FF',
    u':man_with_Chinese_cap_light_skin_tone:': u'\U0001F472\U0001F3FB',
    u':man_with_Chinese_cap_medium-dark_skin_tone:': u'\U0001F472\U0001F3FE',
    u':man_with_Chinese_cap_medium-light_skin_tone:': u'\U0001F472\U0001F3FC',
    u':man_with_Chinese_cap_medium_skin_tone:': u'\U0001F472\U0001F3FD',
    u':man_with_probing_cane-dark_skin_tone:': u'\U0001F468\U0001F3FF\U0000200D\U0001F9AF',
    u':man_with_probing_cane-light_skin_tone:': u'\U0001F468\U0001F3FB\U0000200D\U0001F9AF',
    u':man_with_probing_cane-medium-dark_skin_tone:': u'\U0001F468\U0001F3FE\U0000200D\U0001F9AF',
    u':man_with_probing_cane-medium-light_skin_tone:': u'\U0001F468\U0001F3FC\U0000200D\U0001F9AF',
    u':man_with_probing_cane-medium_skin_tone:': u'\U0001F468\U0001F3FD\U0000200D\U0001F9AF',
    u':man_with_probing_cane:': u'\U0001F468\U0000200D\U0001F9AF',
    u':man_zombie:': u'\U0001F9DF\U0000200D\U00002642',
    u':man_zombie_selector:': u'\U0001F9DF\U0000200D\U00002642\U0000FE0F',
    u':mango:': u'\U0001F96D',
    u':mantelpiece_clock:': u'\U0001F570',
    u':mantelpiece_clock_selector:': u'\U0001F570\U0000FE0F',
    u':manual_wheelchair:': u'\U0001F9BD',
    u':man\u2019s_shoe:': u'\U0001F45E',
    u':map_of_Japan:': u'\U0001F5FE',
    u':maple_leaf:': u'\U0001F341',
    u':martial_arts_uniform:': u'\U0001F94B',
    u':mate:': u'\U0001F9C9',
    u':meat_on_bone:': u'\U0001F356',
    u':mechanical_arm:': u'\U0001F9BE',
    u':mechanical_leg:': u'\U0001F9BF',
    u':medical_symbol:': u'\U00002695',
    u':medical_symbol_selector:': u'\U00002695\U0000FE0F',
    u':medium_dark_skin_tone:': u'\U0001F3FE',
    u':medium_light_skin_tone:': u'\U0001F3FC',
    u':medium_skin_tone:': u'\U0001F3FD',
    u':megaphone:': u'\U0001F4E3',
    u':melon:': u'\U0001F348',
    u':memo:': u'\U0001F4DD',
    u':men_holding_hands-dark_skin_tone-light_skin_tone:': u'\U0001F468\U0001F3FF\U0000200D\U0001F91D\U0000200D\U0001F468\U0001F3FB',
    u':men_holding_hands-dark_skin_tone-medium-dark_skin_tone:': u'\U0001F468\U0001F3FF\U0000200D\U0001F91D\U0000200D\U0001F468\U0001F3FE',
    u':men_holding_hands-dark_skin_tone-medium-light_skin_tone:': u'\U0001F468\U0001F3FF\U0000200D\U0001F91D\U0000200D\U0001F468\U0001F3FC',
    u':men_holding_hands-dark_skin_tone-medium_skin_tone:': u'\U0001F468\U0001F3FF\U0000200D\U0001F91D\U0000200D\U0001F468\U0001F3FD',
    u':men_holding_hands-dark_skin_tone:': u'\U0001F46C\U0001F3FF',
    u':men_holding_hands-light_skin_tone:': u'\U0001F46C\U0001F3FB',
    u':men_holding_hands-medium-dark_skin_tone-light_skin_tone:': u'\U0001F468\U0001F3FE\U0000200D\U0001F91D\U0000200D\U0001F468\U0001F3FB',
    u':men_holding_hands-medium-dark_skin_tone-medium-light_skin_tone:': u'\U0001F468\U0001F3FE\U0000200D\U0001F91D\U0000200D\U0001F468\U0001F3FC',
    u':men_holding_hands-medium-dark_skin_tone-medium_skin_tone:': u'\U0001F468\U0001F3FE\U0000200D\U0001F91D\U0000200D\U0001F468\U0001F3FD',
    u':men_holding_hands-medium-dark_skin_tone:': u'\U0001F46C\U0001F3FE',
    u':men_holding_hands-medium-light_skin_tone-light_skin_tone:': u'\U0001F468\U0001F3FC\U0000200D\U0001F91D\U0000200D\U0001F468\U0001F3FB',
    u':men_holding_hands-medium-light_skin_tone:': u'\U0001F46C\U0001F3FC',
    u':men_holding_hands-medium_skin_tone-light_skin_tone:': u'\U0001F468\U0001F3FD\U0000200D\U0001F91D\U0000200D\U0001F468\U0001F3FB',
    u':men_holding_hands-medium_skin_tone-medium-light_skin_tone:': u'\U0001F468\U0001F3FD\U0000200D\U0001F91D\U0000200D\U0001F468\U0001F3FC',
    u':men_holding_hands-medium_skin_tone:': u'\U0001F46C\U0001F3FD',
    u':men_with_bunny_ears:': u'\U0001F46F\U0000200D\U00002642',
    u':men_with_bunny_ears_selector:': u'\U0001F46F\U0000200D\U00002642\U0000FE0F',
    u':men_wrestling:': u'\U0001F93C\U0000200D\U00002642',
    u':men_wrestling_selector:': u'\U0001F93C\U0000200D\U00002642\U0000FE0F',
    u':menorah:': u'\U0001F54E',
    u':men\u2019s_room:': u'\U0001F6B9',
    u':mermaid-dark_skin_tone:': u'\U0001F9DC\U0001F3FF\U0000200D\U00002640',
    u':mermaid-light_skin_tone:': u'\U0001F9DC\U0001F3FB\U0000200D\U00002640',
    u':mermaid-medium-dark_skin_tone:': u'\U0001F9DC\U0001F3FE\U0000200D\U00002640',
    u':mermaid-medium-light_skin_tone:': u'\U0001F9DC\U0001F3FC\U0000200D\U00002640',
    u':mermaid-medium_skin_tone:': u'\U0001F9DC\U0001F3FD\U0000200D\U00002640',
    u':mermaid:': u'\U0001F9DC\U0000200D\U00002640',
    u':mermaid_dark_skin_tone:': u'\U0001F9DC\U0001F3FF\U0000200D\U00002640\U0000FE0F',
    u':mermaid_light_skin_tone:': u'\U0001F9DC\U0001F3FB\U0000200D\U00002640\U0000FE0F',
    u':mermaid_medium-dark_skin_tone:': u'\U0001F9DC\U0001F3FE\U0000200D\U00002640\U0000FE0F',
    u':mermaid_medium-light_skin_tone:': u'\U0001F9DC\U0001F3FC\U0000200D\U00002640\U0000FE0F',
    u':mermaid_medium_skin_tone:': u'\U0001F9DC\U0001F3FD\U0000200D\U00002640\U0000FE0F',
    u':mermaid_selector:': u'\U0001F9DC\U0000200D\U00002640\U0000FE0F',
    u':merman-dark_skin_tone:': u'\U0001F9DC\U0001F3FF\U0000200D\U00002642',
    u':merman-light_skin_tone:': u'\U0001F9DC\U0001F3FB\U0000200D\U00002642',
    u':merman-medium-dark_skin_tone:': u'\U0001F9DC\U0001F3FE\U0000200D\U00002642',
    u':merman-medium-light_skin_tone:': u'\U0001F9DC\U0001F3FC\U0000200D\U00002642',
    u':merman-medium_skin_tone:': u'\U0001F9DC\U0001F3FD\U0000200D\U00002642',
    u':merman:': u'\U0001F9DC\U0000200D\U00002642',
    u':merman_dark_skin_tone:': u'\U0001F9DC\U0001F3FF\U0000200D\U00002642\U0000FE0F',
    u':merman_light_skin_tone:': u'\U0001F9DC\U0001F3FB\U0000200D\U00002642\U0000FE0F',
    u':merman_medium-dark_skin_tone:': u'\U0001F9DC\U0001F3FE\U0000200D\U00002642\U0000FE0F',
    u':merman_medium-light_skin_tone:': u'\U0001F9DC\U0001F3FC\U0000200D\U00002642\U0000FE0F',
    u':merman_medium_skin_tone:': u'\U0001F9DC\U0001F3FD\U0000200D\U00002642\U0000FE0F',
    u':merman_selector:': u'\U0001F9DC\U0000200D\U00002642\U0000FE0F',
    u':merperson:': u'\U0001F9DC',
    u':merperson_dark_skin_tone:': u'\U0001F9DC\U0001F3FF',
    u':merperson_light_skin_tone:': u'\U0001F9DC\U0001F3FB',
    u':merperson_medium-dark_skin_tone:': u'\U0001F9DC\U0001F3FE',
    u':merperson_medium-light_skin_tone:': u'\U0001F9DC\U0001F3FC',
    u':merperson_medium_skin_tone:': u'\U0001F9DC\U0001F3FD',
    u':metro:': u'\U0001F687',
    u':microbe:': u'\U0001F9A0',
    u':microphone:': u'\U0001F3A4',
    u':microscope:': u'\U0001F52C',
    u':middle_finger:': u'\U0001F595',
    u':middle_finger_dark_skin_tone:': u'\U0001F595\U0001F3FF',
    u':middle_finger_light_skin_tone:': u'\U0001F595\U0001F3FB',
    u':middle_finger_medium-dark_skin_tone:': u'\U0001F595\U0001F3FE',
    u':middle_finger_medium-light_skin_tone:': u'\U0001F595\U0001F3FC',
    u':middle_finger_medium_skin_tone:': u'\U0001F595\U0001F3FD',
    u':military_medal:': u'\U0001F396',
    u':military_medal_selector:': u'\U0001F396\U0000FE0F',
    u':milky_way:': u'\U0001F30C',
    u':minibus:': u'\U0001F690',
    u':moai:': u'\U0001F5FF',
    u':mobile_phone:': u'\U0001F4F1',
    u':mobile_phone_off:': u'\U0001F4F4',
    u':mobile_phone_with_arrow:': u'\U0001F4F2',
    u':money-mouth_face:': u'\U0001F911',
    u':money_bag:': u'\U0001F4B0',
    u':money_with_wings:': u'\U0001F4B8',
    u':monkey:': u'\U0001F412',
    u':monkey_face:': u'\U0001F435',
    u':monorail:': u'\U0001F69D',
    u':moon_cake:': u'\U0001F96E',
    u':moon_viewing_ceremony:': u'\U0001F391',
    u':mosque:': u'\U0001F54C',
    u':mosquito:': u'\U0001F99F',
    u':motor_boat:': u'\U0001F6E5',
    u':motor_boat_selector:': u'\U0001F6E5\U0000FE0F',
    u':motor_scooter:': u'\U0001F6F5',
    u':motorcycle:': u'\U0001F3CD',
    u':motorcycle_selector:': u'\U0001F3CD\U0000FE0F',
    u':motorized_wheelchair:': u'\U0001F9BC',
    u':motorway:': u'\U0001F6E3',
    u':motorway_selector:': u'\U0001F6E3\U0000FE0F',
    u':mount_fuji:': u'\U0001F5FB',
    u':mountain:': u'\U000026F0',
    u':mountain_cableway:': u'\U0001F6A0',
    u':mountain_railway:': u'\U0001F69E',
    u':mountain_selector:': u'\U000026F0\U0000FE0F',
    u':mouse:': u'\U0001F401',
    u':mouse_face:': u'\U0001F42D',
    u':mouth:': u'\U0001F444',
    u':movie_camera:': u'\U0001F3A5',
    u':multiplication_sign:': u'\U00002716\U0000FE0F',
    u':mushroom:': u'\U0001F344',
    u':musical_keyboard:': u'\U0001F3B9',
    u':musical_note:': u'\U0001F3B5',
    u':musical_notes:': u'\U0001F3B6',
    u':musical_score:': u'\U0001F3BC',
    u':muted_speaker:': u'\U0001F507',
    u':nail_polish:': u'\U0001F485',
    u':nail_polish_dark_skin_tone:': u'\U0001F485\U0001F3FF',
    u':nail_polish_light_skin_tone:': u'\U0001F485\U0001F3FB',
    u':nail_polish_medium-dark_skin_tone:': u'\U0001F485\U0001F3FE',
    u':nail_polish_medium-light_skin_tone:': u'\U0001F485\U0001F3FC',
    u':nail_polish_medium_skin_tone:': u'\U0001F485\U0001F3FD',
    u':name_badge:': u'\U0001F4DB',
    u':national_park:': u'\U0001F3DE',
    u':national_park_selector:': u'\U0001F3DE\U0000FE0F',
    u':nauseated_face:': u'\U0001F922',
    u':nazar_amulet:': u'\U0001F9FF',
    u':necktie:': u'\U0001F454',
    u':nerd_face:': u'\U0001F913',
    u':neutral_face:': u'\U0001F610',
    u':new_moon:': u'\U0001F311',
    u':new_moon_face:': u'\U0001F31A',
    u':newspaper:': u'\U0001F4F0',
    u':next_track_button:': u'\U000023ED',
    u':next_track_button_selector:': u'\U000023ED\U0000FE0F',
    u':night_with_stars:': u'\U0001F303',
    u':nine-thirty:': u'\U0001F564',
    u':nine_o\u2019clock:': u'\U0001F558',
    u':no_bicycles:': u'\U0001F6B3',
    u':no_entry:': u'\U000026D4',
    u':no_littering:': u'\U0001F6AF',
    u':no_mobile_phones:': u'\U0001F4F5',
    u':no_one_under_eighteen:': u'\U0001F51E',
    u':no_pedestrians:': u'\U0001F6B7',
    u':no_smoking:': u'\U0001F6AD',
    u':non-potable_water:': u'\U0001F6B1',
    u':nose:': u'\U0001F443',
    u':nose_dark_skin_tone:': u'\U0001F443\U0001F3FF',
    u':nose_light_skin_tone:': u'\U0001F443\U0001F3FB',
    u':nose_medium-dark_skin_tone:': u'\U0001F443\U0001F3FE',
    u':nose_medium-light_skin_tone:': u'\U0001F443\U0001F3FC',
    u':nose_medium_skin_tone:': u'\U0001F443\U0001F3FD',
    u':notebook:': u'\U0001F4D3',
    u':notebook_with_decorative_cover:': u'\U0001F4D4',
    u':nut_and_bolt:': u'\U0001F529',
    u':octopus:': u'\U0001F419',
    u':oden:': u'\U0001F362',
    u':office_building:': u'\U0001F3E2',
    u':ogre:': u'\U0001F479',
    u':oil_drum:': u'\U0001F6E2',
    u':oil_drum_selector:': u'\U0001F6E2\U0000FE0F',
    u':old_key:': u'\U0001F5DD',
    u':old_key_selector:': u'\U0001F5DD\U0000FE0F',
    u':old_man:': u'\U0001F474',
    u':old_man_dark_skin_tone:': u'\U0001F474\U0001F3FF',
    u':old_man_light_skin_tone:': u'\U0001F474\U0001F3FB',
    u':old_man_medium-dark_skin_tone:': u'\U0001F474\U0001F3FE',
    u':old_man_medium-light_skin_tone:': u'\U0001F474\U0001F3FC',
    u':old_man_medium_skin_tone:': u'\U0001F474\U0001F3FD',
    u':old_woman:': u'\U0001F475',
    u':old_woman_dark_skin_tone:': u'\U0001F475\U0001F3FF',
    u':old_woman_light_skin_tone:': u'\U0001F475\U0001F3FB',
    u':old_woman_medium-dark_skin_tone:': u'\U0001F475\U0001F3FE',
    u':old_woman_medium-light_skin_tone:': u'\U0001F475\U0001F3FC',
    u':old_woman_medium_skin_tone:': u'\U0001F475\U0001F3FD',
    u':older_adult:': u'\U0001F9D3',
    u':older_adult_dark_skin_tone:': u'\U0001F9D3\U0001F3FF',
    u':older_adult_light_skin_tone:': u'\U0001F9D3\U0001F3FB',
    u':older_adult_medium-dark_skin_tone:': u'\U0001F9D3\U0001F3FE',
    u':older_adult_medium-light_skin_tone:': u'\U0001F9D3\U0001F3FC',
    u':older_adult_medium_skin_tone:': u'\U0001F9D3\U0001F3FD',
    u':om:': u'\U0001F549',
    u':om_selector:': u'\U0001F549\U0000FE0F',
    u':oncoming_automobile:': u'\U0001F698',
    u':oncoming_bus:': u'\U0001F68D',
    u':oncoming_fist:': u'\U0001F44A',
    u':oncoming_fist_dark_skin_tone:': u'\U0001F44A\U0001F3FF',
    u':oncoming_fist_light_skin_tone:': u'\U0001F44A\U0001F3FB',
    u':oncoming_fist_medium-dark_skin_tone:': u'\U0001F44A\U0001F3FE',
    u':oncoming_fist_medium-light_skin_tone:': u'\U0001F44A\U0001F3FC',
    u':oncoming_fist_medium_skin_tone:': u'\U0001F44A\U0001F3FD',
    u':oncoming_police_car:': u'\U0001F694',
    u':oncoming_taxi:': u'\U0001F696',
    u':one-piece_swimsuit:': u'\U0001FA71',
    u':one-thirty:': u'\U0001F55C',
    u':one_o\u2019clock:': u'\U0001F550',
    u':onion:': u'\U0001F9C5',
    u':open_book:': u'\U0001F4D6',
    u':open_file_folder:': u'\U0001F4C2',
    u':open_hands:': u'\U0001F450',
    u':open_hands_dark_skin_tone:': u'\U0001F450\U0001F3FF',
    u':open_hands_light_skin_tone:': u'\U0001F450\U0001F3FB',
    u':open_hands_medium-dark_skin_tone:': u'\U0001F450\U0001F3FE',
    u':open_hands_medium-light_skin_tone:': u'\U0001F450\U0001F3FC',
    u':open_hands_medium_skin_tone:': u'\U0001F450\U0001F3FD',
    u':open_mailbox_with_lowered_flag:': u'\U0001F4ED',
    u':open_mailbox_with_raised_flag:': u'\U0001F4EC',
    u':optical_disk:': u'\U0001F4BF',
    u':orange_book:': u'\U0001F4D9',
    u':orange_circle:': u'\U0001F7E0',
    u':orange_heart:': u'\U0001F9E1',
    u':orange_square:': u'\U0001F7E7',
    u':orangutan:': u'\U0001F9A7',
    u':orthodox_cross:': u'\U00002626',
    u':orthodox_cross_selector:': u'\U00002626\U0000FE0F',
    u':otter:': u'\U0001F9A6',
    u':outbox_tray:': u'\U0001F4E4',
    u':owl:': u'\U0001F989',
    u':ox:': u'\U0001F402',
    u':oyster:': u'\U0001F9AA',
    u':package:': u'\U0001F4E6',
    u':page_facing_up:': u'\U0001F4C4',
    u':page_with_curl:': u'\U0001F4C3',
    u':pager:': u'\U0001F4DF',
    u':paintbrush:': u'\U0001F58C',
    u':paintbrush_selector:': u'\U0001F58C\U0000FE0F',
    u':palm_tree:': u'\U0001F334',
    u':palms_up_together:': u'\U0001F932',
    u':palms_up_together_dark_skin_tone:': u'\U0001F932\U0001F3FF',
    u':palms_up_together_light_skin_tone:': u'\U0001F932\U0001F3FB',
    u':palms_up_together_medium-dark_skin_tone:': u'\U0001F932\U0001F3FE',
    u':palms_up_together_medium-light_skin_tone:': u'\U0001F932\U0001F3FC',
    u':palms_up_together_medium_skin_tone:': u'\U0001F932\U0001F3FD',
    u':pancakes:': u'\U0001F95E',
    u':panda_face:': u'\U0001F43C',
    u':paperclip:': u'\U0001F4CE',
    u':parachute:': u'\U0001FA82',
    u':parrot:': u'\U0001F99C',
    u':part_alternation_mark:': u'\U0000303D',
    u':part_alternation_mark_selector:': u'\U0000303D\U0000FE0F',
    u':party_popper:': u'\U0001F389',
    u':partying_face:': u'\U0001F973',
    u':passenger_ship:': u'\U0001F6F3',
    u':passenger_ship_selector:': u'\U0001F6F3\U0000FE0F',
    u':passport_control:': u'\U0001F6C2',
    u':pause_button:': u'\U000023F8',
    u':pause_button_selector:': u'\U000023F8\U0000FE0F',
    u':paw_prints:': u'\U0001F43E',
    u':peace_symbol:': u'\U0000262E',
    u':peace_symbol_selector:': u'\U0000262E\U0000FE0F',
    u':peach:': u'\U0001F351',
    u':peacock:': u'\U0001F99A',
    u':peanuts:': u'\U0001F95C',
    u':pear:': u'\U0001F350',
    u':pen:': u'\U0001F58A',
    u':pen_selector:': u'\U0001F58A\U0000FE0F',
    u':pencil:': u'\U0000270F',
    u':pencil_selector:': u'\U0000270F\U0000FE0F',
    u':penguin:': u'\U0001F427',
    u':pensive_face:': u'\U0001F614',
    u':people_holding_hands-dark_skin_tone-light_skin_tone:': u'\U0001F9D1\U0001F3FF\U0000200D\U0001F91D\U0000200D\U0001F9D1\U0001F3FB',
    u':people_holding_hands-dark_skin_tone-medium-dark_skin_tone:': u'\U0001F9D1\U0001F3FF\U0000200D\U0001F91D\U0000200D\U0001F9D1\U0001F3FE',
    u':people_holding_hands-dark_skin_tone-medium-light_skin_tone:': u'\U0001F9D1\U0001F3FF\U0000200D\U0001F91D\U0000200D\U0001F9D1\U0001F3FC',
    u':people_holding_hands-dark_skin_tone-medium_skin_tone:': u'\U0001F9D1\U0001F3FF\U0000200D\U0001F91D\U0000200D\U0001F9D1\U0001F3FD',
    u':people_holding_hands-dark_skin_tone:': u'\U0001F9D1\U0001F3FF\U0000200D\U0001F91D\U0000200D\U0001F9D1\U0001F3FF',
    u':people_holding_hands-light_skin_tone:': u'\U0001F9D1\U0001F3FB\U0000200D\U0001F91D\U0000200D\U0001F9D1\U0001F3FB',
    u':people_holding_hands-medium-dark_skin_tone-light_skin_tone:': u'\U0001F9D1\U0001F3FE\U0000200D\U0001F91D\U0000200D\U0001F9D1\U0001F3FB',
    u':people_holding_hands-medium-dark_skin_tone-medium-light_skin_tone:': u'\U0001F9D1\U0001F3FE\U0000200D\U0001F91D\U0000200D\U0001F9D1\U0001F3FC',
    u':people_holding_hands-medium-dark_skin_tone-medium_skin_tone:': u'\U0001F9D1\U0001F3FE\U0000200D\U0001F91D\U0000200D\U0001F9D1\U0001F3FD',
    u':people_holding_hands-medium-dark_skin_tone:': u'\U0001F9D1\U0001F3FE\U0000200D\U0001F91D\U0000200D\U0001F9D1\U0001F3FE',
    u':people_holding_hands-medium-light_skin_tone-light_skin_tone:': u'\U0001F9D1\U0001F3FC\U0000200D\U0001F91D\U0000200D\U0001F9D1\U0001F3FB',
    u':people_holding_hands-medium-light_skin_tone:': u'\U0001F9D1\U0001F3FC\U0000200D\U0001F91D\U0000200D\U0001F9D1\U0001F3FC',
    u':people_holding_hands-medium_skin_tone-light_skin_tone:': u'\U0001F9D1\U0001F3FD\U0000200D\U0001F91D\U0000200D\U0001F9D1\U0001F3FB',
    u':people_holding_hands-medium_skin_tone-medium-light_skin_tone:': u'\U0001F9D1\U0001F3FD\U0000200D\U0001F91D\U0000200D\U0001F9D1\U0001F3FC',
    u':people_holding_hands-medium_skin_tone:': u'\U0001F9D1\U0001F3FD\U0000200D\U0001F91D\U0000200D\U0001F9D1\U0001F3FD',
    u':people_holding_hands:': u'\U0001F9D1\U0000200D\U0001F91D\U0000200D\U0001F9D1',
    u':people_with_bunny_ears:': u'\U0001F46F',
    u':people_wrestling:': u'\U0001F93C',
    u':performing_arts:': u'\U0001F3AD',
    u':persevering_face:': u'\U0001F623',
    u':person_biking:': u'\U0001F6B4',
    u':person_biking_dark_skin_tone:': u'\U0001F6B4\U0001F3FF',
    u':person_biking_light_skin_tone:': u'\U0001F6B4\U0001F3FB',
    u':person_biking_medium-dark_skin_tone:': u'\U0001F6B4\U0001F3FE',
    u':person_biking_medium-light_skin_tone:': u'\U0001F6B4\U0001F3FC',
    u':person_biking_medium_skin_tone:': u'\U0001F6B4\U0001F3FD',
    u':person_bouncing_ball:': u'\U000026F9',
    u':person_bouncing_ball_dark_skin_tone:': u'\U000026F9\U0001F3FF',
    u':person_bouncing_ball_light_skin_tone:': u'\U000026F9\U0001F3FB',
    u':person_bouncing_ball_medium-dark_skin_tone:': u'\U000026F9\U0001F3FE',
    u':person_bouncing_ball_medium-light_skin_tone:': u'\U000026F9\U0001F3FC',
    u':person_bouncing_ball_medium_skin_tone:': u'\U000026F9\U0001F3FD',
    u':person_bouncing_ball_selector:': u'\U000026F9\U0000FE0F',
    u':person_bowing:': u'\U0001F647',
    u':person_bowing_dark_skin_tone:': u'\U0001F647\U0001F3FF',
    u':person_bowing_light_skin_tone:': u'\U0001F647\U0001F3FB',
    u':person_bowing_medium-dark_skin_tone:': u'\U0001F647\U0001F3FE',
    u':person_bowing_medium-light_skin_tone:': u'\U0001F647\U0001F3FC',
    u':person_bowing_medium_skin_tone:': u'\U0001F647\U0001F3FD',
    u':person_cartwheeling:': u'\U0001F938',
    u':person_cartwheeling_dark_skin_tone:': u'\U0001F938\U0001F3FF',
    u':person_cartwheeling_light_skin_tone:': u'\U0001F938\U0001F3FB',
    u':person_cartwheeling_medium-dark_skin_tone:': u'\U0001F938\U0001F3FE',
    u':person_cartwheeling_medium-light_skin_tone:': u'\U0001F938\U0001F3FC',
    u':person_cartwheeling_medium_skin_tone:': u'\U0001F938\U0001F3FD',
    u':person_climbing:': u'\U0001F9D7',
    u':person_climbing_dark_skin_tone:': u'\U0001F9D7\U0001F3FF',
    u':person_climbing_light_skin_tone:': u'\U0001F9D7\U0001F3FB',
    u':person_climbing_medium-dark_skin_tone:': u'\U0001F9D7\U0001F3FE',
    u':person_climbing_medium-light_skin_tone:': u'\U0001F9D7\U0001F3FC',
    u':person_climbing_medium_skin_tone:': u'\U0001F9D7\U0001F3FD',
    u':person_facepalming:': u'\U0001F926',
    u':person_facepalming_dark_skin_tone:': u'\U0001F926\U0001F3FF',
    u':person_facepalming_light_skin_tone:': u'\U0001F926\U0001F3FB',
    u':person_facepalming_medium-dark_skin_tone:': u'\U0001F926\U0001F3FE',
    u':person_facepalming_medium-light_skin_tone:': u'\U0001F926\U0001F3FC',
    u':person_facepalming_medium_skin_tone:': u'\U0001F926\U0001F3FD',
    u':person_fencing:': u'\U0001F93A',
    u':person_frowning:': u'\U0001F64D',
    u':person_frowning_dark_skin_tone:': u'\U0001F64D\U0001F3FF',
    u':person_frowning_light_skin_tone:': u'\U0001F64D\U0001F3FB',
    u':person_frowning_medium-dark_skin_tone:': u'\U0001F64D\U0001F3FE',
    u':person_frowning_medium-light_skin_tone:': u'\U0001F64D\U0001F3FC',
    u':person_frowning_medium_skin_tone:': u'\U0001F64D\U0001F3FD',
    u':person_gesturing_NO:': u'\U0001F645',
    u':person_gesturing_NO_dark_skin_tone:': u'\U0001F645\U0001F3FF',
    u':person_gesturing_NO_light_skin_tone:': u'\U0001F645\U0001F3FB',
    u':person_gesturing_NO_medium-dark_skin_tone:': u'\U0001F645\U0001F3FE',
    u':person_gesturing_NO_medium-light_skin_tone:': u'\U0001F645\U0001F3FC',
    u':person_gesturing_NO_medium_skin_tone:': u'\U0001F645\U0001F3FD',
    u':person_gesturing_OK:': u'\U0001F646',
    u':person_gesturing_OK_dark_skin_tone:': u'\U0001F646\U0001F3FF',
    u':person_gesturing_OK_light_skin_tone:': u'\U0001F646\U0001F3FB',
    u':person_gesturing_OK_medium-dark_skin_tone:': u'\U0001F646\U0001F3FE',
    u':person_gesturing_OK_medium-light_skin_tone:': u'\U0001F646\U0001F3FC',
    u':person_gesturing_OK_medium_skin_tone:': u'\U0001F646\U0001F3FD',
    u':person_getting_haircut:': u'\U0001F487',
    u':person_getting_haircut_dark_skin_tone:': u'\U0001F487\U0001F3FF',
    u':person_getting_haircut_light_skin_tone:': u'\U0001F487\U0001F3FB',
    u':person_getting_haircut_medium-dark_skin_tone:': u'\U0001F487\U0001F3FE',
    u':person_getting_haircut_medium-light_skin_tone:': u'\U0001F487\U0001F3FC',
    u':person_getting_haircut_medium_skin_tone:': u'\U0001F487\U0001F3FD',
    u':person_getting_massage:': u'\U0001F486',
    u':person_getting_massage_dark_skin_tone:': u'\U0001F486\U0001F3FF',
    u':person_getting_massage_light_skin_tone:': u'\U0001F486\U0001F3FB',
    u':person_getting_massage_medium-dark_skin_tone:': u'\U0001F486\U0001F3FE',
    u':person_getting_massage_medium-light_skin_tone:': u'\U0001F486\U0001F3FC',
    u':person_getting_massage_medium_skin_tone:': u'\U0001F486\U0001F3FD',
    u':person_golfing:': u'\U0001F3CC',
    u':person_golfing_dark_skin_tone:': u'\U0001F3CC\U0001F3FF',
    u':person_golfing_light_skin_tone:': u'\U0001F3CC\U0001F3FB',
    u':person_golfing_medium-dark_skin_tone:': u'\U0001F3CC\U0001F3FE',
    u':person_golfing_medium-light_skin_tone:': u'\U0001F3CC\U0001F3FC',
    u':person_golfing_medium_skin_tone:': u'\U0001F3CC\U0001F3FD',
    u':person_golfing_selector:': u'\U0001F3CC\U0000FE0F',
    u':person_in_bed:': u'\U0001F6CC',
    u':person_in_bed_dark_skin_tone:': u'\U0001F6CC\U0001F3FF',
    u':person_in_bed_light_skin_tone:': u'\U0001F6CC\U0001F3FB',
    u':person_in_bed_medium-dark_skin_tone:': u'\U0001F6CC\U0001F3FE',
    u':person_in_bed_medium-light_skin_tone:': u'\U0001F6CC\U0001F3FC',
    u':person_in_bed_medium_skin_tone:': u'\U0001F6CC\U0001F3FD',
    u':person_in_lotus_position:': u'\U0001F9D8',
    u':person_in_lotus_position_dark_skin_tone:': u'\U0001F9D8\U0001F3FF',
    u':person_in_lotus_position_light_skin_tone:': u'\U0001F9D8\U0001F3FB',
    u':person_in_lotus_position_medium-dark_skin_tone:': u'\U0001F9D8\U0001F3FE',
    u':person_in_lotus_position_medium-light_skin_tone:': u'\U0001F9D8\U0001F3FC',
    u':person_in_lotus_position_medium_skin_tone:': u'\U0001F9D8\U0001F3FD',
    u':person_in_steamy_room:': u'\U0001F9D6',
    u':person_in_steamy_room_dark_skin_tone:': u'\U0001F9D6\U0001F3FF',
    u':person_in_steamy_room_light_skin_tone:': u'\U0001F9D6\U0001F3FB',
    u':person_in_steamy_room_medium-dark_skin_tone:': u'\U0001F9D6\U0001F3FE',
    u':person_in_steamy_room_medium-light_skin_tone:': u'\U0001F9D6\U0001F3FC',
    u':person_in_steamy_room_medium_skin_tone:': u'\U0001F9D6\U0001F3FD',
    u':person_juggling:': u'\U0001F939',
    u':person_juggling_dark_skin_tone:': u'\U0001F939\U0001F3FF',
    u':person_juggling_light_skin_tone:': u'\U0001F939\U0001F3FB',
    u':person_juggling_medium-dark_skin_tone:': u'\U0001F939\U0001F3FE',
    u':person_juggling_medium-light_skin_tone:': u'\U0001F939\U0001F3FC',
    u':person_juggling_medium_skin_tone:': u'\U0001F939\U0001F3FD',
    u':person_kneeling-dark_skin_tone:': u'\U0001F9CE\U0001F3FF',
    u':person_kneeling-light_skin_tone:': u'\U0001F9CE\U0001F3FB',
    u':person_kneeling-medium-dark_skin_tone:': u'\U0001F9CE\U0001F3FE',
    u':person_kneeling-medium-light_skin_tone:': u'\U0001F9CE\U0001F3FC',
    u':person_kneeling-medium_skin_tone:': u'\U0001F9CE\U0001F3FD',
    u':person_kneeling:': u'\U0001F9CE',
    u':person_lifting_weights:': u'\U0001F3CB',
    u':person_lifting_weights_dark_skin_tone:': u'\U0001F3CB\U0001F3FF',
    u':person_lifting_weights_light_skin_tone:': u'\U0001F3CB\U0001F3FB',
    u':person_lifting_weights_medium-dark_skin_tone:': u'\U0001F3CB\U0001F3FE',
    u':person_lifting_weights_medium-light_skin_tone:': u'\U0001F3CB\U0001F3FC',
    u':person_lifting_weights_medium_skin_tone:': u'\U0001F3CB\U0001F3FD',
    u':person_lifting_weights_selector:': u'\U0001F3CB\U0000FE0F',
    u':person_mountain_biking:': u'\U0001F6B5',
    u':person_mountain_biking_dark_skin_tone:': u'\U0001F6B5\U0001F3FF',
    u':person_mountain_biking_light_skin_tone:': u'\U0001F6B5\U0001F3FB',
    u':person_mountain_biking_medium-dark_skin_tone:': u'\U0001F6B5\U0001F3FE',
    u':person_mountain_biking_medium-light_skin_tone:': u'\U0001F6B5\U0001F3FC',
    u':person_mountain_biking_medium_skin_tone:': u'\U0001F6B5\U0001F3FD',
    u':person_playing_handball:': u'\U0001F93E',
    u':person_playing_handball_dark_skin_tone:': u'\U0001F93E\U0001F3FF',
    u':person_playing_handball_light_skin_tone:': u'\U0001F93E\U0001F3FB',
    u':person_playing_handball_medium-dark_skin_tone:': u'\U0001F93E\U0001F3FE',
    u':person_playing_handball_medium-light_skin_tone:': u'\U0001F93E\U0001F3FC',
    u':person_playing_handball_medium_skin_tone:': u'\U0001F93E\U0001F3FD',
    u':person_playing_water_polo:': u'\U0001F93D',
    u':person_playing_water_polo_dark_skin_tone:': u'\U0001F93D\U0001F3FF',
    u':person_playing_water_polo_light_skin_tone:': u'\U0001F93D\U0001F3FB',
    u':person_playing_water_polo_medium-dark_skin_tone:': u'\U0001F93D\U0001F3FE',
    u':person_playing_water_polo_medium-light_skin_tone:': u'\U0001F93D\U0001F3FC',
    u':person_playing_water_polo_medium_skin_tone:': u'\U0001F93D\U0001F3FD',
    u':person_pouting:': u'\U0001F64E',
    u':person_pouting_dark_skin_tone:': u'\U0001F64E\U0001F3FF',
    u':person_pouting_light_skin_tone:': u'\U0001F64E\U0001F3FB',
    u':person_pouting_medium-dark_skin_tone:': u'\U0001F64E\U0001F3FE',
    u':person_pouting_medium-light_skin_tone:': u'\U0001F64E\U0001F3FC',
    u':person_pouting_medium_skin_tone:': u'\U0001F64E\U0001F3FD',
    u':person_raising_hand:': u'\U0001F64B',
    u':person_raising_hand_dark_skin_tone:': u'\U0001F64B\U0001F3FF',
    u':person_raising_hand_light_skin_tone:': u'\U0001F64B\U0001F3FB',
    u':person_raising_hand_medium-dark_skin_tone:': u'\U0001F64B\U0001F3FE',
    u':person_raising_hand_medium-light_skin_tone:': u'\U0001F64B\U0001F3FC',
    u':person_raising_hand_medium_skin_tone:': u'\U0001F64B\U0001F3FD',
    u':person_rowing_boat:': u'\U0001F6A3',
    u':person_rowing_boat_dark_skin_tone:': u'\U0001F6A3\U0001F3FF',
    u':person_rowing_boat_light_skin_tone:': u'\U0001F6A3\U0001F3FB',
    u':person_rowing_boat_medium-dark_skin_tone:': u'\U0001F6A3\U0001F3FE',
    u':person_rowing_boat_medium-light_skin_tone:': u'\U0001F6A3\U0001F3FC',
    u':person_rowing_boat_medium_skin_tone:': u'\U0001F6A3\U0001F3FD',
    u':person_running:': u'\U0001F3C3',
    u':person_running_dark_skin_tone:': u'\U0001F3C3\U0001F3FF',
    u':person_running_light_skin_tone:': u'\U0001F3C3\U0001F3FB',
    u':person_running_medium-dark_skin_tone:': u'\U0001F3C3\U0001F3FE',
    u':person_running_medium-light_skin_tone:': u'\U0001F3C3\U0001F3FC',
    u':person_running_medium_skin_tone:': u'\U0001F3C3\U0001F3FD',
    u':person_shrugging:': u'\U0001F937',
    u':person_shrugging_dark_skin_tone:': u'\U0001F937\U0001F3FF',
    u':person_shrugging_light_skin_tone:': u'\U0001F937\U0001F3FB',
    u':person_shrugging_medium-dark_skin_tone:': u'\U0001F937\U0001F3FE',
    u':person_shrugging_medium-light_skin_tone:': u'\U0001F937\U0001F3FC',
    u':person_shrugging_medium_skin_tone:': u'\U0001F937\U0001F3FD',
    u':person_standing-dark_skin_tone:': u'\U0001F9CD\U0001F3FF',
    u':person_standing-light_skin_tone:': u'\U0001F9CD\U0001F3FB',
    u':person_standing-medium-dark_skin_tone:': u'\U0001F9CD\U0001F3FE',
    u':person_standing-medium-light_skin_tone:': u'\U0001F9CD\U0001F3FC',
    u':person_standing-medium_skin_tone:': u'\U0001F9CD\U0001F3FD',
    u':person_standing:': u'\U0001F9CD',
    u':person_surfing:': u'\U0001F3C4',
    u':person_surfing_dark_skin_tone:': u'\U0001F3C4\U0001F3FF',
    u':person_surfing_light_skin_tone:': u'\U0001F3C4\U0001F3FB',
    u':person_surfing_medium-dark_skin_tone:': u'\U0001F3C4\U0001F3FE',
    u':person_surfing_medium-light_skin_tone:': u'\U0001F3C4\U0001F3FC',
    u':person_surfing_medium_skin_tone:': u'\U0001F3C4\U0001F3FD',
    u':person_swimming:': u'\U0001F3CA',
    u':person_swimming_dark_skin_tone:': u'\U0001F3CA\U0001F3FF',
    u':person_swimming_light_skin_tone:': u'\U0001F3CA\U0001F3FB',
    u':person_swimming_medium-dark_skin_tone:': u'\U0001F3CA\U0001F3FE',
    u':person_swimming_medium-light_skin_tone:': u'\U0001F3CA\U0001F3FC',
    u':person_swimming_medium_skin_tone:': u'\U0001F3CA\U0001F3FD',
    u':person_taking_bath:': u'\U0001F6C0',
    u':person_taking_bath_dark_skin_tone:': u'\U0001F6C0\U0001F3FF',
    u':person_taking_bath_light_skin_tone:': u'\U0001F6C0\U0001F3FB',
    u':person_taking_bath_medium-dark_skin_tone:': u'\U0001F6C0\U0001F3FE',
    u':person_taking_bath_medium-light_skin_tone:': u'\U0001F6C0\U0001F3FC',
    u':person_taking_bath_medium_skin_tone:': u'\U0001F6C0\U0001F3FD',
    u':person_tipping_hand:': u'\U0001F481',
    u':person_tipping_hand_dark_skin_tone:': u'\U0001F481\U0001F3FF',
    u':person_tipping_hand_light_skin_tone:': u'\U0001F481\U0001F3FB',
    u':person_tipping_hand_medium-dark_skin_tone:': u'\U0001F481\U0001F3FE',
    u':person_tipping_hand_medium-light_skin_tone:': u'\U0001F481\U0001F3FC',
    u':person_tipping_hand_medium_skin_tone:': u'\U0001F481\U0001F3FD',
    u':person_walking:': u'\U0001F6B6',
    u':person_walking_dark_skin_tone:': u'\U0001F6B6\U0001F3FF',
    u':person_walking_light_skin_tone:': u'\U0001F6B6\U0001F3FB',
    u':person_walking_medium-dark_skin_tone:': u'\U0001F6B6\U0001F3FE',
    u':person_walking_medium-light_skin_tone:': u'\U0001F6B6\U0001F3FC',
    u':person_walking_medium_skin_tone:': u'\U0001F6B6\U0001F3FD',
    u':person_wearing_turban:': u'\U0001F473',
    u':person_wearing_turban_dark_skin_tone:': u'\U0001F473\U0001F3FF',
    u':person_wearing_turban_light_skin_tone:': u'\U0001F473\U0001F3FB',
    u':person_wearing_turban_medium-dark_skin_tone:': u'\U0001F473\U0001F3FE',
    u':person_wearing_turban_medium-light_skin_tone:': u'\U0001F473\U0001F3FC',
    u':person_wearing_turban_medium_skin_tone:': u'\U0001F473\U0001F3FD',
    u':petri_dish:': u'\U0001F9EB',
    u':pick:': u'\U000026CF',
    u':pick_selector:': u'\U000026CF\U0000FE0F',
    u':pie:': u'\U0001F967',
    u':pig:': u'\U0001F416',
    u':pig_face:': u'\U0001F437',
    u':pig_nose:': u'\U0001F43D',
    u':pile_of_poo:': u'\U0001F4A9',
    u':pill:': u'\U0001F48A',
    u':pinching_hand-dark_skin_tone:': u'\U0001F90F\U0001F3FF',
    u':pinching_hand-light_skin_tone:': u'\U0001F90F\U0001F3FB',
    u':pinching_hand-medium-dark_skin_tone:': u'\U0001F90F\U0001F3FE',
    u':pinching_hand-medium-light_skin_tone:': u'\U0001F90F\U0001F3FC',
    u':pinching_hand-medium_skin_tone:': u'\U0001F90F\U0001F3FD',
    u':pinching_hand:': u'\U0001F90F',
    u':pine_decoration:': u'\U0001F38D',
    u':pineapple:': u'\U0001F34D',
    u':ping_pong:': u'\U0001F3D3',
    u':pirate_flag:': u'\U0001F3F4\U0000200D\U00002620',
    u':pirate_flag_selector:': u'\U0001F3F4\U0000200D\U00002620\U0000FE0F',
    u':pistol:': u'\U0001F52B',
    u':pizza:': u'\U0001F355',
    u':place_of_worship:': u'\U0001F6D0',
    u':play_button:': u'\U000025B6',
    u':play_button_selector:': u'\U000025B6\U0000FE0F',
    u':play_or_pause_button:': u'\U000023EF',
    u':play_or_pause_button_selector:': u'\U000023EF\U0000FE0F',
    u':pleading_face:': u'\U0001F97A',
    u':police_car:': u'\U0001F693',
    u':police_car_light:': u'\U0001F6A8',
    u':police_officer:': u'\U0001F46E',
    u':police_officer_dark_skin_tone:': u'\U0001F46E\U0001F3FF',
    u':police_officer_light_skin_tone:': u'\U0001F46E\U0001F3FB',
    u':police_officer_medium-dark_skin_tone:': u'\U0001F46E\U0001F3FE',
    u':police_officer_medium-light_skin_tone:': u'\U0001F46E\U0001F3FC',
    u':police_officer_medium_skin_tone:': u'\U0001F46E\U0001F3FD',
    u':poodle:': u'\U0001F429',
    u':pool_8_ball:': u'\U0001F3B1',
    u':popcorn:': u'\U0001F37F',
    u':post_office:': u'\U0001F3E4',
    u':postal_horn:': u'\U0001F4EF',
    u':postbox:': u'\U0001F4EE',
    u':pot_of_food:': u'\U0001F372',
    u':potable_water:': u'\U0001F6B0',
    u':potato:': u'\U0001F954',
    u':poultry_leg:': u'\U0001F357',
    u':pound_banknote:': u'\U0001F4B7',
    u':pouting_cat_face:': u'\U0001F63E',
    u':pouting_face:': u'\U0001F621',
    u':prayer_beads:': u'\U0001F4FF',
    u':pregnant_woman:': u'\U0001F930',
    u':pregnant_woman_dark_skin_tone:': u'\U0001F930\U0001F3FF',
    u':pregnant_woman_light_skin_tone:': u'\U0001F930\U0001F3FB',
    u':pregnant_woman_medium-dark_skin_tone:': u'\U0001F930\U0001F3FE',
    u':pregnant_woman_medium-light_skin_tone:': u'\U0001F930\U0001F3FC',
    u':pregnant_woman_medium_skin_tone:': u'\U0001F930\U0001F3FD',
    u':pretzel:': u'\U0001F968',
    u':prince:': u'\U0001F934',
    u':prince_dark_skin_tone:': u'\U0001F934\U0001F3FF',
    u':prince_light_skin_tone:': u'\U0001F934\U0001F3FB',
    u':prince_medium-dark_skin_tone:': u'\U0001F934\U0001F3FE',
    u':prince_medium-light_skin_tone:': u'\U0001F934\U0001F3FC',
    u':prince_medium_skin_tone:': u'\U0001F934\U0001F3FD',
    u':princess:': u'\U0001F478',
    u':princess_dark_skin_tone:': u'\U0001F478\U0001F3FF',
    u':princess_light_skin_tone:': u'\U0001F478\U0001F3FB',
    u':princess_medium-dark_skin_tone:': u'\U0001F478\U0001F3FE',
    u':princess_medium-light_skin_tone:': u'\U0001F478\U0001F3FC',
    u':princess_medium_skin_tone:': u'\U0001F478\U0001F3FD',
    u':printer:': u'\U0001F5A8',
    u':printer_selector:': u'\U0001F5A8\U0000FE0F',
    u':probing_cane:': u'\U0001F9AF',
    u':prohibited:': u'\U0001F6AB',
    u':purple_circle:': u'\U0001F7E3',
    u':purple_heart:': u'\U0001F49C',
    u':purple_square:': u'\U0001F7EA',
    u':purse:': u'\U0001F45B',
    u':pushpin:': u'\U0001F4CC',
    u':question_mark:': u'\U00002753',
    u':rabbit:': u'\U0001F407',
    u':rabbit_face:': u'\U0001F430',
    u':raccoon:': u'\U0001F99D',
    u':racing_car:': u'\U0001F3CE',
    u':racing_car_selector:': u'\U0001F3CE\U0000FE0F',
    u':radio:': u'\U0001F4FB',
    u':radio_button:': u'\U0001F518',
    u':radioactive:': u'\U00002622',
    u':radioactive_selector:': u'\U00002622\U0000FE0F',
    u':railway_car:': u'\U0001F683',
    u':railway_track:': u'\U0001F6E4',
    u':railway_track_selector:': u'\U0001F6E4\U0000FE0F',
    u':rainbow:': u'\U0001F308',
    u':rainbow_flag:': u'\U0001F3F3\U0000200D\U0001F308',
    u':rainbow_flag_selector:': u'\U0001F3F3\U0000FE0F\U0000200D\U0001F308',
    u':raised_back_of_hand:': u'\U0001F91A',
    u':raised_back_of_hand_dark_skin_tone:': u'\U0001F91A\U0001F3FF',
    u':raised_back_of_hand_light_skin_tone:': u'\U0001F91A\U0001F3FB',
    u':raised_back_of_hand_medium-dark_skin_tone:': u'\U0001F91A\U0001F3FE',
    u':raised_back_of_hand_medium-light_skin_tone:': u'\U0001F91A\U0001F3FC',
    u':raised_back_of_hand_medium_skin_tone:': u'\U0001F91A\U0001F3FD',
    u':raised_fist:': u'\U0000270A',
    u':raised_fist_dark_skin_tone:': u'\U0000270A\U0001F3FF',
    u':raised_fist_light_skin_tone:': u'\U0000270A\U0001F3FB',
    u':raised_fist_medium-dark_skin_tone:': u'\U0000270A\U0001F3FE',
    u':raised_fist_medium-light_skin_tone:': u'\U0000270A\U0001F3FC',
    u':raised_fist_medium_skin_tone:': u'\U0000270A\U0001F3FD',
    u':raised_hand:': u'\U0000270B',
    u':raised_hand_dark_skin_tone:': u'\U0000270B\U0001F3FF',
    u':raised_hand_light_skin_tone:': u'\U0000270B\U0001F3FB',
    u':raised_hand_medium-dark_skin_tone:': u'\U0000270B\U0001F3FE',
    u':raised_hand_medium-light_skin_tone:': u'\U0000270B\U0001F3FC',
    u':raised_hand_medium_skin_tone:': u'\U0000270B\U0001F3FD',
    u':raising_hands:': u'\U0001F64C',
    u':raising_hands_dark_skin_tone:': u'\U0001F64C\U0001F3FF',
    u':raising_hands_light_skin_tone:': u'\U0001F64C\U0001F3FB',
    u':raising_hands_medium-dark_skin_tone:': u'\U0001F64C\U0001F3FE',
    u':raising_hands_medium-light_skin_tone:': u'\U0001F64C\U0001F3FC',
    u':raising_hands_medium_skin_tone:': u'\U0001F64C\U0001F3FD',
    u':ram:': u'\U0001F40F',
    u':rat:': u'\U0001F400',
    u':razor:': u'\U0001FA92',
    u':receipt:': u'\U0001F9FE',
    u':record_button:': u'\U000023FA',
    u':record_button_selector:': u'\U000023FA\U0000FE0F',
    u':recycling_symbol:': u'\U0000267B',
    u':recycling_symbol_selector:': u'\U0000267B\U0000FE0F',
    u':red-haired_man:': u'\U0001F468\U0000200D\U0001F9B0',
    u':red-haired_woman:': u'\U0001F469\U0000200D\U0001F9B0',
    u':red_apple:': u'\U0001F34E',
    u':red_circle:': u'\U0001F534',
    u':red_envelope:': u'\U0001F9E7',
    u':red_hair:': u'\U0001F9B0',
    u':red_heart:': u'\U00002764',
    u':red_heart_selector:': u'\U00002764\U0000FE0F',
    u':red_paper_lantern:': u'\U0001F3EE',
    u':red_square:': u'\U0001F7E5',
    u':red_triangle_pointed_down:': u'\U0001F53B',
    u':red_triangle_pointed_up:': u'\U0001F53A',
    u':regional_indicator_symbol_letter_a:': u'\U0001F1E6',
    u':regional_indicator_symbol_letter_b:': u'\U0001F1E7',
    u':regional_indicator_symbol_letter_c:': u'\U0001F1E8',
    u':regional_indicator_symbol_letter_d:': u'\U0001F1E9',
    u':regional_indicator_symbol_letter_e:': u'\U0001F1EA',
    u':regional_indicator_symbol_letter_f:': u'\U0001F1EB',
    u':regional_indicator_symbol_letter_g:': u'\U0001F1EC',
    u':regional_indicator_symbol_letter_h:': u'\U0001F1ED',
    u':regional_indicator_symbol_letter_i:': u'\U0001F1EE',
    u':regional_indicator_symbol_letter_j:': u'\U0001F1EF',
    u':regional_indicator_symbol_letter_k:': u'\U0001F1F0',
    u':regional_indicator_symbol_letter_l:': u'\U0001F1F1',
    u':regional_indicator_symbol_letter_m:': u'\U0001F1F2',
    u':regional_indicator_symbol_letter_n:': u'\U0001F1F3',
    u':regional_indicator_symbol_letter_o:': u'\U0001F1F4',
    u':regional_indicator_symbol_letter_p:': u'\U0001F1F5',
    u':regional_indicator_symbol_letter_q:': u'\U0001F1F6',
    u':regional_indicator_symbol_letter_r:': u'\U0001F1F7',
    u':regional_indicator_symbol_letter_s:': u'\U0001F1F8',
    u':regional_indicator_symbol_letter_t:': u'\U0001F1F9',
    u':regional_indicator_symbol_letter_u:': u'\U0001F1FA',
    u':regional_indicator_symbol_letter_v:': u'\U0001F1FB',
    u':regional_indicator_symbol_letter_w:': u'\U0001F1FC',
    u':regional_indicator_symbol_letter_x:': u'\U0001F1FD',
    u':regional_indicator_symbol_letter_y:': u'\U0001F1FE',
    u':regional_indicator_symbol_letter_z:': u'\U0001F1FF',
    u':registered:': u'\U000000AE',
    u':registered_selector:': u'\U000000AE\U0000FE0F',
    u':relieved_face:': u'\U0001F60C',
    u':reminder_ribbon:': u'\U0001F397',
    u':reminder_ribbon_selector:': u'\U0001F397\U0000FE0F',
    u':repeat_button:': u'\U0001F501',
    u':repeat_single_button:': u'\U0001F502',
    u':rescue_worker\u2019s_helmet:': u'\U000026D1',
    u':rescue_worker\u2019s_helmet_selector:': u'\U000026D1\U0000FE0F',
    u':restroom:': u'\U0001F6BB',
    u':reverse_button:': u'\U000025C0',
    u':reverse_button_selector:': u'\U000025C0\U0000FE0F',
    u':revolving_hearts:': u'\U0001F49E',
    u':rhinoceros:': u'\U0001F98F',
    u':ribbon:': u'\U0001F380',
    u':rice_ball:': u'\U0001F359',
    u':rice_cracker:': u'\U0001F358',
    u':right-facing_fist:': u'\U0001F91C',
    u':right-facing_fist_dark_skin_tone:': u'\U0001F91C\U0001F3FF',
    u':right-facing_fist_light_skin_tone:': u'\U0001F91C\U0001F3FB',
    u':right-facing_fist_medium-dark_skin_tone:': u'\U0001F91C\U0001F3FE',
    u':right-facing_fist_medium-light_skin_tone:': u'\U0001F91C\U0001F3FC',
    u':right-facing_fist_medium_skin_tone:': u'\U0001F91C\U0001F3FD',
    u':right_anger_bubble:': u'\U0001F5EF',
    u':right_anger_bubble_selector:': u'\U0001F5EF\U0000FE0F',
    u':right_arrow:': u'\U000027A1',
    u':right_arrow_curving_down:': u'\U00002935',
    u':right_arrow_curving_down_selector:': u'\U00002935\U0000FE0F',
    u':right_arrow_curving_left:': u'\U000021A9',
    u':right_arrow_curving_left_selector:': u'\U000021A9\U0000FE0F',
    u':right_arrow_curving_up:': u'\U00002934',
    u':right_arrow_curving_up_selector:': u'\U00002934\U0000FE0F',
    u':right_arrow_selector:': u'\U000027A1\U0000FE0F',
    u':ring:': u'\U0001F48D',
    u':ringed_planet:': u'\U0001FA90',
    u':roasted_sweet_potato:': u'\U0001F360',
    u':robot_face:': u'\U0001F916',
    u':rocket:': u'\U0001F680',
    u':roll_of_paper:': u'\U0001F9FB',
    u':rolled-up_newspaper:': u'\U0001F5DE',
    u':rolled-up_newspaper_selector:': u'\U0001F5DE\U0000FE0F',
    u':roller_coaster:': u'\U0001F3A2',
    u':rolling_on_the_floor_laughing:': u'\U0001F923',
    u':rooster:': u'\U0001F413',
    u':rose:': u'\U0001F339',
    u':rosette:': u'\U0001F3F5',
    u':rosette_selector:': u'\U0001F3F5\U0000FE0F',
    u':round_pushpin:': u'\U0001F4CD',
    u':rugby_football:': u'\U0001F3C9',
    u':running_shirt:': u'\U0001F3BD',
    u':running_shoe:': u'\U0001F45F',
    u':sad_but_relieved_face:': u'\U0001F625',
    u':safety_pin:': u'\U0001F9F7',
    u':safety_vest:': u'\U0001F9BA',
    u':sailboat:': u'\U000026F5',
    u':sake:': u'\U0001F376',
    u':salt:': u'\U0001F9C2',
    u':sandwich:': u'\U0001F96A',
    u':sari:': u'\U0001F97B',
    u':satellite:': u'\U0001F6F0',
    u':satellite_antenna:': u'\U0001F4E1',
    u':satellite_selector:': u'\U0001F6F0\U0000FE0F',
    u':sauropod:': u'\U0001F995',
    u':saxophone:': u'\U0001F3B7',
    u':scarf:': u'\U0001F9E3',
    u':school:': u'\U0001F3EB',
    u':school_backpack:': u'\U0001F392',
    u':scissors:': u'\U00002702',
    u':scissors_selector:': u'\U00002702\U0000FE0F',
    u':scorpion:': u'\U0001F982',
    u':scroll:': u'\U0001F4DC',
    u':seat:': u'\U0001F4BA',
    u':see-no-evil_monkey:': u'\U0001F648',
    u':seedling:': u'\U0001F331',
    u':selfie:': u'\U0001F933',
    u':selfie_dark_skin_tone:': u'\U0001F933\U0001F3FF',
    u':selfie_light_skin_tone:': u'\U0001F933\U0001F3FB',
    u':selfie_medium-dark_skin_tone:': u'\U0001F933\U0001F3FE',
    u':selfie_medium-light_skin_tone:': u'\U0001F933\U0001F3FC',
    u':selfie_medium_skin_tone:': u'\U0001F933\U0001F3FD',
    u':service_dog:': u'\U0001F415\U0000200D\U0001F9BA',
    u':seven-thirty:': u'\U0001F562',
    u':seven_o\u2019clock:': u'\U0001F556',
    u':shallow_pan_of_food:': u'\U0001F958',
    u':shamrock:': u'\U00002618',
    u':shamrock_selector:': u'\U00002618\U0000FE0F',
    u':shark:': u'\U0001F988',
    u':shaved_ice:': u'\U0001F367',
    u':sheaf_of_rice:': u'\U0001F33E',
    u':shield:': u'\U0001F6E1',
    u':shield_selector:': u'\U0001F6E1\U0000FE0F',
    u':shinto_shrine:': u'\U000026E9\U0000FE0F',
    u':ship:': u'\U0001F6A2',
    u':shooting_star:': u'\U0001F320',
    u':shopping_bags:': u'\U0001F6CD',
    u':shopping_bags_selector:': u'\U0001F6CD\U0000FE0F',
    u':shopping_cart:': u'\U0001F6D2',
    u':shortcake:': u'\U0001F370',
    u':shorts:': u'\U0001FA73',
    u':shower:': u'\U0001F6BF',
    u':shrimp:': u'\U0001F990',
    u':shuffle_tracks_button:': u'\U0001F500',
    u':shushing_face:': u'\U0001F92B',
    u':sign_of_the_horns:': u'\U0001F918',
    u':sign_of_the_horns_dark_skin_tone:': u'\U0001F918\U0001F3FF',
    u':sign_of_the_horns_light_skin_tone:': u'\U0001F918\U0001F3FB',
    u':sign_of_the_horns_medium-dark_skin_tone:': u'\U0001F918\U0001F3FE',
    u':sign_of_the_horns_medium-light_skin_tone:': u'\U0001F918\U0001F3FC',
    u':sign_of_the_horns_medium_skin_tone:': u'\U0001F918\U0001F3FD',
    u':six-thirty:': u'\U0001F561',
    u':six_o\u2019clock:': u'\U0001F555',
    u':skateboard:': u'\U0001F6F9',
    u':skier:': u'\U000026F7',
    u':skier_selector:': u'\U000026F7\U0000FE0F',
    u':skis:': u'\U0001F3BF',
    u':skull:': u'\U0001F480',
    u':skull_and_crossbones:': u'\U00002620',
    u':skull_and_crossbones_selector:': u'\U00002620\U0000FE0F',
    u':skunk:': u'\U0001F9A8',
    u':sled:': u'\U0001F6F7',
    u':sleeping_face:': u'\U0001F634',
    u':sleepy_face:': u'\U0001F62A',
    u':slightly_frowning_face:': u'\U0001F641',
    u':slightly_smiling_face:': u'\U0001F642',
    u':slot_machine:': u'\U0001F3B0',
    u':sloth:': u'\U0001F9A5',
    u':small_airplane:': u'\U0001F6E9',
    u':small_airplane_selector:': u'\U0001F6E9\U0000FE0F',
    u':small_blue_diamond:': u'\U0001F539',
    u':small_orange_diamond:': u'\U0001F538',
    u':smiling_cat_face_with_heart-eyes:': u'\U0001F63B',
    u':smiling_face:': u'\U0000263A',
    u':smiling_face_selector:': u'\U0000263A\U0000FE0F',
    u':smiling_face_with_3_hearts:': u'\U0001F970',
    u':smiling_face_with_halo:': u'\U0001F607',
    u':smiling_face_with_heart-eyes:': u'\U0001F60D',
    u':smiling_face_with_horns:': u'\U0001F608',
    u':smiling_face_with_smiling_eyes:': u'\U0001F60A',
    u':smiling_face_with_sunglasses:': u'\U0001F60E',
    u':smirking_face:': u'\U0001F60F',
    u':snail:': u'\U0001F40C',
    u':snake:': u'\U0001F40D',
    u':sneezing_face:': u'\U0001F927',
    u':snow-capped_mountain:': u'\U0001F3D4',
    u':snow-capped_mountain_selector:': u'\U0001F3D4\U0000FE0F',
    u':snowboarder:': u'\U0001F3C2',
    u':snowboarder_dark_skin_tone:': u'\U0001F3C2\U0001F3FF',
    u':snowboarder_light_skin_tone:': u'\U0001F3C2\U0001F3FB',
    u':snowboarder_medium-dark_skin_tone:': u'\U0001F3C2\U0001F3FE',
    u':snowboarder_medium-light_skin_tone:': u'\U0001F3C2\U0001F3FC',
    u':snowboarder_medium_skin_tone:': u'\U0001F3C2\U0001F3FD',
    u':snowflake:': u'\U00002744',
    u':snowflake_selector:': u'\U00002744\U0000FE0F',
    u':snowman:': u'\U00002603',
    u':snowman_selector:': u'\U00002603\U0000FE0F',
    u':snowman_without_snow:': u'\U000026C4',
    u':soap:': u'\U0001F9FC',
    u':soccer_ball:': u'\U000026BD',
    u':socks:': u'\U0001F9E6',
    u':soft_ice_cream:': u'\U0001F366',
    u':softball:': u'\U0001F94E',
    u':spade_suit:': u'\U00002660',
    u':spade_suit_selector:': u'\U00002660\U0000FE0F',
    u':spaghetti:': u'\U0001F35D',
    u':sparkle:': u'\U00002747',
    u':sparkle_selector:': u'\U00002747\U0000FE0F',
    u':sparkler:': u'\U0001F387',
    u':sparkles:': u'\U00002728',
    u':sparkling_heart:': u'\U0001F496',
    u':speak-no-evil_monkey:': u'\U0001F64A',
    u':speaker_high_volume:': u'\U0001F50A',
    u':speaker_low_volume:': u'\U0001F508',
    u':speaker_medium_volume:': u'\U0001F509',
    u':speaking_head:': u'\U0001F5E3',
    u':speaking_head_selector:': u'\U0001F5E3\U0000FE0F',
    u':speech_balloon:': u'\U0001F4AC',
    u':speedboat:': u'\U0001F6A4',
    u':spider:': u'\U0001F577',
    u':spider_selector:': u'\U0001F577\U0000FE0F',
    u':spider_web:': u'\U0001F578',
    u':spider_web_selector:': u'\U0001F578\U0000FE0F',
    u':spiral_calendar:': u'\U0001F5D3',
    u':spiral_calendar_selector:': u'\U0001F5D3\U0000FE0F',
    u':spiral_notepad:': u'\U0001F5D2',
    u':spiral_notepad_selector:': u'\U0001F5D2\U0000FE0F',
    u':spiral_shell:': u'\U0001F41A',
    u':sponge:': u'\U0001F9FD',
    u':spoon:': u'\U0001F944',
    u':sport_utility_vehicle:': u'\U0001F699',
    u':sports_medal:': u'\U0001F3C5',
    u':spouting_whale:': u'\U0001F433',
    u':squid:': u'\U0001F991',
    u':squinting_face_with_tongue:': u'\U0001F61D',
    u':stadium:': u'\U0001F3DF',
    u':stadium_selector:': u'\U0001F3DF\U0000FE0F',
    u':star-struck:': u'\U0001F929',
    u':star_and_crescent:': u'\U0000262A',
    u':star_and_crescent_selector:': u'\U0000262A\U0000FE0F',
    u':star_of_David:': u'\U00002721',
    u':star_of_David_selector:': u'\U00002721\U0000FE0F',
    u':station:': u'\U0001F689',
    u':steaming_bowl:': u'\U0001F35C',
    u':stethoscope:': u'\U0001FA7A',
    u':stop_button:': u'\U000023F9',
    u':stop_button_selector:': u'\U000023F9\U0000FE0F',
    u':stop_sign:': u'\U0001F6D1',
    u':stopwatch:': u'\U000023F1',
    u':stopwatch_selector:': u'\U000023F1\U0000FE0F',
    u':straight_ruler:': u'\U0001F4CF',
    u':strawberry:': u'\U0001F353',
    u':studio_microphone:': u'\U0001F399',
    u':studio_microphone_selector:': u'\U0001F399\U0000FE0F',
    u':stuffed_flatbread:': u'\U0001F959',
    u':sun:': u'\U00002600',
    u':sun_behind_cloud:': u'\U000026C5',
    u':sun_behind_large_cloud:': u'\U0001F325',
    u':sun_behind_large_cloud_selector:': u'\U0001F325\U0000FE0F',
    u':sun_behind_rain_cloud:': u'\U0001F326',
    u':sun_behind_rain_cloud_selector:': u'\U0001F326\U0000FE0F',
    u':sun_behind_small_cloud:': u'\U0001F324',
    u':sun_behind_small_cloud_selector:': u'\U0001F324\U0000FE0F',
    u':sun_selector:': u'\U00002600\U0000FE0F',
    u':sun_with_face:': u'\U0001F31E',
    u':sunflower:': u'\U0001F33B',
    u':sunglasses:': u'\U0001F576',
    u':sunglasses_selector:': u'\U0001F576\U0000FE0F',
    u':sunrise:': u'\U0001F305',
    u':sunrise_over_mountains:': u'\U0001F304',
    u':sunset:': u'\U0001F307',
    u':superhero-dark_skin_tone:': u'\U0001F9B8\U0001F3FF',
    u':superhero-light_skin_tone:': u'\U0001F9B8\U0001F3FB',
    u':superhero-medium-dark_skin_tone:': u'\U0001F9B8\U0001F3FE',
    u':superhero-medium-light_skin_tone:': u'\U0001F9B8\U0001F3FC',
    u':superhero-medium_skin_tone:': u'\U0001F9B8\U0001F3FD',
    u':superhero:': u'\U0001F9B8',
    u':supervillain-dark_skin_tone:': u'\U0001F9B9\U0001F3FF',
    u':supervillain-light_skin_tone:': u'\U0001F9B9\U0001F3FB',
    u':supervillain-medium-dark_skin_tone:': u'\U0001F9B9\U0001F3FE',
    u':supervillain-medium-light_skin_tone:': u'\U0001F9B9\U0001F3FC',
    u':supervillain-medium_skin_tone:': u'\U0001F9B9\U0001F3FD',
    u':supervillain:': u'\U0001F9B9',
    u':sushi:': u'\U0001F363',
    u':suspension_railway:': u'\U0001F69F',
    u':swan:': u'\U0001F9A2',
    u':sweat_droplets:': u'\U0001F4A6',
    u':synagogue:': u'\U0001F54D',
    u':syringe:': u'\U0001F489',
    u':t-shirt:': u'\U0001F455',
    u':taco:': u'\U0001F32E',
    u':takeout_box:': u'\U0001F961',
    u':tanabata_tree:': u'\U0001F38B',
    u':tangerine:': u'\U0001F34A',
    u':taxi:': u'\U0001F695',
    u':teacup_without_handle:': u'\U0001F375',
    u':tear-off_calendar:': u'\U0001F4C6',
    u':teddy_bear:': u'\U0001F9F8',
    u':telephone:': u'\U0000260E',
    u':telephone_receiver:': u'\U0001F4DE',
    u':telephone_selector:': u'\U0000260E\U0000FE0F',
    u':telescope:': u'\U0001F52D',
    u':television:': u'\U0001F4FA',
    u':ten-thirty:': u'\U0001F565',
    u':ten_o\u2019clock:': u'\U0001F559',
    u':tennis:': u'\U0001F3BE',
    u':tent:': u'\U000026FA',
    u':test_tube:': u'\U0001F9EA',
    u':thermometer:': u'\U0001F321',
    u':thermometer_selector:': u'\U0001F321\U0000FE0F',
    u':thinking_face:': u'\U0001F914',
    u':thought_balloon:': u'\U0001F4AD',
    u':thread:': u'\U0001F9F5',
    u':three-thirty:': u'\U0001F55E',
    u':three_o\u2019clock:': u'\U0001F552',
    u':thumbs_down:': u'\U0001F44E',
    u':thumbs_down_dark_skin_tone:': u'\U0001F44E\U0001F3FF',
    u':thumbs_down_light_skin_tone:': u'\U0001F44E\U0001F3FB',
    u':thumbs_down_medium-dark_skin_tone:': u'\U0001F44E\U0001F3FE',
    u':thumbs_down_medium-light_skin_tone:': u'\U0001F44E\U0001F3FC',
    u':thumbs_down_medium_skin_tone:': u'\U0001F44E\U0001F3FD',
    u':thumbs_up:': u'\U0001F44D',
    u':thumbs_up_dark_skin_tone:': u'\U0001F44D\U0001F3FF',
    u':thumbs_up_light_skin_tone:': u'\U0001F44D\U0001F3FB',
    u':thumbs_up_medium-dark_skin_tone:': u'\U0001F44D\U0001F3FE',
    u':thumbs_up_medium-light_skin_tone:': u'\U0001F44D\U0001F3FC',
    u':thumbs_up_medium_skin_tone:': u'\U0001F44D\U0001F3FD',
    u':ticket:': u'\U0001F3AB',
    u':tiger:': u'\U0001F405',
    u':tiger_face:': u'\U0001F42F',
    u':timer_clock:': u'\U000023F2',
    u':timer_clock_selector:': u'\U000023F2\U0000FE0F',
    u':tired_face:': u'\U0001F62B',
    u':toilet:': u'\U0001F6BD',
    u':tomato:': u'\U0001F345',
    u':tongue:': u'\U0001F445',
    u':toolbox:': u'\U0001F9F0',
    u':tooth:': u'\U0001F9B7',
    u':top_hat:': u'\U0001F3A9',
    u':tornado:': u'\U0001F32A',
    u':tornado_selector:': u'\U0001F32A\U0000FE0F',
    u':trackball:': u'\U0001F5B2',
    u':trackball_selector:': u'\U0001F5B2\U0000FE0F',
    u':tractor:': u'\U0001F69C',
    u':trade_mark:': u'\U00002122',
    u':trade_mark_selector:': u'\U00002122\U0000FE0F',
    u':train:': u'\U0001F686',
    u':tram:': u'\U0001F68A',
    u':tram_car:': u'\U0001F68B',
    u':triangular_flag:': u'\U0001F6A9',
    u':triangular_ruler:': u'\U0001F4D0',
    u':trident_emblem:': u'\U0001F531',
    u':trolleybus:': u'\U0001F68E',
    u':trophy:': u'\U0001F3C6',
    u':tropical_drink:': u'\U0001F379',
    u':tropical_fish:': u'\U0001F420',
    u':trumpet:': u'\U0001F3BA',
    u':tulip:': u'\U0001F337',
    u':tumbler_glass:': u'\U0001F943',
    u':turkey:': u'\U0001F983',
    u':turtle:': u'\U0001F422',
    u':twelve-thirty:': u'\U0001F567',
    u':twelve_o\u2019clock:': u'\U0001F55B',
    u':two-hump_camel:': u'\U0001F42B',
    u':two-thirty:': u'\U0001F55D',
    u':two_hearts:': u'\U0001F495',
    u':two_men_holding_hands:': u'\U0001F46C',
    u':two_o\u2019clock:': u'\U0001F551',
    u':two_women_holding_hands:': u'\U0001F46D',
    u':umbrella:': u'\U00002602',
    u':umbrella_on_ground:': u'\U000026F1',
    u':umbrella_on_ground_selector:': u'\U000026F1\U0000FE0F',
    u':umbrella_selector:': u'\U00002602\U0000FE0F',
    u':umbrella_with_rain_drops:': u'\U00002614',
    u':unamused_face:': u'\U0001F612',
    u':unicorn_face:': u'\U0001F984',
    u':unlocked:': u'\U0001F513',
    u':up-down_arrow:': u'\U00002195',
    u':up-down_arrow_selector:': u'\U00002195\U0000FE0F',
    u':up-left_arrow:': u'\U00002196',
    u':up-left_arrow_selector:': u'\U00002196\U0000FE0F',
    u':up-right_arrow:': u'\U00002197',
    u':up-right_arrow_selector:': u'\U00002197\U0000FE0F',
    u':up_arrow:': u'\U00002B06',
    u':up_arrow_selector:': u'\U00002B06\U0000FE0F',
    u':upside-down_face:': u'\U0001F643',
    u':upwards_button:': u'\U0001F53C',
    u':vampire:': u'\U0001F9DB',
    u':vampire_dark_skin_tone:': u'\U0001F9DB\U0001F3FF',
    u':vampire_light_skin_tone:': u'\U0001F9DB\U0001F3FB',
    u':vampire_medium-dark_skin_tone:': u'\U0001F9DB\U0001F3FE',
    u':vampire_medium-light_skin_tone:': u'\U0001F9DB\U0001F3FC',
    u':vampire_medium_skin_tone:': u'\U0001F9DB\U0001F3FD',
    u':vertical_traffic_light:': u'\U0001F6A6',
    u':vibration_mode:': u'\U0001F4F3',
    u':victory_hand:': u'\U0000270C',
    u':victory_hand_dark_skin_tone:': u'\U0000270C\U0001F3FF',
    u':victory_hand_light_skin_tone:': u'\U0000270C\U0001F3FB',
    u':victory_hand_medium-dark_skin_tone:': u'\U0000270C\U0001F3FE',
    u':victory_hand_medium-light_skin_tone:': u'\U0000270C\U0001F3FC',
    u':victory_hand_medium_skin_tone:': u'\U0000270C\U0001F3FD',
    u':victory_hand_selector:': u'\U0000270C\U0000FE0F',
    u':video_camera:': u'\U0001F4F9',
    u':video_game:': u'\U0001F3AE',
    u':videocassette:': u'\U0001F4FC',
    u':violin:': u'\U0001F3BB',
    u':volcano:': u'\U0001F30B',
    u':volleyball:': u'\U0001F3D0',
    u':vulcan_salute:': u'\U0001F596',
    u':vulcan_salute_dark_skin_tone:': u'\U0001F596\U0001F3FF',
    u':vulcan_salute_light_skin_tone:': u'\U0001F596\U0001F3FB',
    u':vulcan_salute_medium-dark_skin_tone:': u'\U0001F596\U0001F3FE',
    u':vulcan_salute_medium-light_skin_tone:': u'\U0001F596\U0001F3FC',
    u':vulcan_salute_medium_skin_tone:': u'\U0001F596\U0001F3FD',
    u':waffle:': u'\U0001F9C7',
    u':waning_crescent_moon:': u'\U0001F318',
    u':waning_gibbous_moon:': u'\U0001F316',
    u':warning:': u'\U000026A0',
    u':warning_selector:': u'\U000026A0\U0000FE0F',
    u':wastebasket:': u'\U0001F5D1',
    u':wastebasket_selector:': u'\U0001F5D1\U0000FE0F',
    u':watch:': u'\U0000231A',
    u':water_buffalo:': u'\U0001F403',
    u':water_closet:': u'\U0001F6BE',
    u':water_wave:': u'\U0001F30A',
    u':watermelon:': u'\U0001F349',
    u':waving_hand:': u'\U0001F44B',
    u':waving_hand_dark_skin_tone:': u'\U0001F44B\U0001F3FF',
    u':waving_hand_light_skin_tone:': u'\U0001F44B\U0001F3FB',
    u':waving_hand_medium-dark_skin_tone:': u'\U0001F44B\U0001F3FE',
    u':waving_hand_medium-light_skin_tone:': u'\U0001F44B\U0001F3FC',
    u':waving_hand_medium_skin_tone:': u'\U0001F44B\U0001F3FD',
    u':wavy_dash:': u'\U00003030',
    u':wavy_dash_selector:': u'\U00003030\U0000FE0F',
    u':waxing_crescent_moon:': u'\U0001F312',
    u':waxing_gibbous_moon:': u'\U0001F314',
    u':weary_cat_face:': u'\U0001F640',
    u':weary_face:': u'\U0001F629',
    u':wedding:': u'\U0001F492',
    u':whale:': u'\U0001F40B',
    u':wheel_of_dharma:': u'\U00002638',
    u':wheel_of_dharma_selector:': u'\U00002638\U0000FE0F',
    u':wheelchair_symbol:': u'\U0000267F',
    u':white-haired_man:': u'\U0001F468\U0000200D\U0001F9B3',
    u':white-haired_woman:': u'\U0001F469\U0000200D\U0001F9B3',
    u':white_circle:': u'\U000026AA',
    u':white_exclamation_mark:': u'\U00002755',
    u':white_flag:': u'\U0001F3F3',
    u':white_flag_selector:': u'\U0001F3F3\U0000FE0F',
    u':white_flower:': u'\U0001F4AE',
    u':white_hair:': u'\U0001F9B3',
    u':white_heart:': u'\U0001F90D',
    u':white_heavy_check_mark:': u'\U00002705',
    u':white_large_square:': u'\U00002B1C',
    u':white_medium-small_square:': u'\U000025FD',
    u':white_medium_square:': u'\U000025FB',
    u':white_medium_square_selector:': u'\U000025FB\U0000FE0F',
    u':white_medium_star:': u'\U00002B50',
    u':white_question_mark:': u'\U00002754',
    u':white_small_square:': u'\U000025AB',
    u':white_small_square_selector:': u'\U000025AB\U0000FE0F',
    u':white_square_button:': u'\U0001F533',
    u':wilted_flower:': u'\U0001F940',
    u':wind_chime:': u'\U0001F390',
    u':wind_face:': u'\U0001F32C',
    u':wind_face_selector:': u'\U0001F32C\U0000FE0F',
    u':wine_glass:': u'\U0001F377',
    u':winking_face:': u'\U0001F609',
    u':winking_face_with_tongue:': u'\U0001F61C',
    u':wolf_face:': u'\U0001F43A',
    u':woman-blond_hair:': u'\U0001F471\U0000200D\U00002640',
    u':woman-dark_skin_tone-bald:': u'\U0001F469\U0001F3FF\U0000200D\U0001F9B2',
    u':woman-dark_skin_tone-blond_hair:': u'\U0001F471\U0001F3FF\U0000200D\U00002640',
    u':woman-dark_skin_tone-curly_hair:': u'\U0001F469\U0001F3FF\U0000200D\U0001F9B1',
    u':woman-dark_skin_tone-red_hair:': u'\U0001F469\U0001F3FF\U0000200D\U0001F9B0',
    u':woman-dark_skin_tone-white_hair:': u'\U0001F469\U0001F3FF\U0000200D\U0001F9B3',
    u':woman-light_skin_tone-bald:': u'\U0001F469\U0001F3FB\U0000200D\U0001F9B2',
    u':woman-light_skin_tone-blond_hair:': u'\U0001F471\U0001F3FB\U0000200D\U00002640',
    u':woman-light_skin_tone-curly_hair:': u'\U0001F469\U0001F3FB\U0000200D\U0001F9B1',
    u':woman-light_skin_tone-red_hair:': u'\U0001F469\U0001F3FB\U0000200D\U0001F9B0',
    u':woman-light_skin_tone-white_hair:': u'\U0001F469\U0001F3FB\U0000200D\U0001F9B3',
    u':woman-medium-dark_skin_tone-bald:': u'\U0001F469\U0001F3FE\U0000200D\U0001F9B2',
    u':woman-medium-dark_skin_tone-blond_hair:': u'\U0001F471\U0001F3FE\U0000200D\U00002640',
    u':woman-medium-dark_skin_tone-curly_hair:': u'\U0001F469\U0001F3FE\U0000200D\U0001F9B1',
    u':woman-medium-dark_skin_tone-red_hair:': u'\U0001F469\U0001F3FE\U0000200D\U0001F9B0',
    u':woman-medium-dark_skin_tone-white_hair:': u'\U0001F469\U0001F3FE\U0000200D\U0001F9B3',
    u':woman-medium-light_skin_tone-bald:': u'\U0001F469\U0001F3FC\U0000200D\U0001F9B2',
    u':woman-medium-light_skin_tone-blond_hair:': u'\U0001F471\U0001F3FC\U0000200D\U00002640',
    u':woman-medium-light_skin_tone-curly_hair:': u'\U0001F469\U0001F3FC\U0000200D\U0001F9B1',
    u':woman-medium-light_skin_tone-red_hair:': u'\U0001F469\U0001F3FC\U0000200D\U0001F9B0',
    u':woman-medium-light_skin_tone-white_hair:': u'\U0001F469\U0001F3FC\U0000200D\U0001F9B3',
    u':woman-medium_skin_tone-bald:': u'\U0001F469\U0001F3FD\U0000200D\U0001F9B2',
    u':woman-medium_skin_tone-blond_hair:': u'\U0001F471\U0001F3FD\U0000200D\U00002640',
    u':woman-medium_skin_tone-curly_hair:': u'\U0001F469\U0001F3FD\U0000200D\U0001F9B1',
    u':woman-medium_skin_tone-red_hair:': u'\U0001F469\U0001F3FD\U0000200D\U0001F9B0',
    u':woman-medium_skin_tone-white_hair:': u'\U0001F469\U0001F3FD\U0000200D\U0001F9B3',
    u':woman:': u'\U0001F469',
    u':woman_and_man_holding_hands-dark_skin_tone-light_skin_tone:': u'\U0001F469\U0001F3FF\U0000200D\U0001F91D\U0000200D\U0001F468\U0001F3FB',
    u':woman_and_man_holding_hands-dark_skin_tone-medium-dark_skin_tone:': u'\U0001F469\U0001F3FF\U0000200D\U0001F91D\U0000200D\U0001F468\U0001F3FE',
    u':woman_and_man_holding_hands-dark_skin_tone-medium-light_skin_tone:': u'\U0001F469\U0001F3FF\U0000200D\U0001F91D\U0000200D\U0001F468\U0001F3FC',
    u':woman_and_man_holding_hands-dark_skin_tone-medium_skin_tone:': u'\U0001F469\U0001F3FF\U0000200D\U0001F91D\U0000200D\U0001F468\U0001F3FD',
    u':woman_and_man_holding_hands-dark_skin_tone:': u'\U0001F46B\U0001F3FF',
    u':woman_and_man_holding_hands-light_skin_tone-dark_skin_tone:': u'\U0001F469\U0001F3FB\U0000200D\U0001F91D\U0000200D\U0001F468\U0001F3FF',
    u':woman_and_man_holding_hands-light_skin_tone-medium-dark_skin_tone:': u'\U0001F469\U0001F3FB\U0000200D\U0001F91D\U0000200D\U0001F468\U0001F3FE',
    u':woman_and_man_holding_hands-light_skin_tone-medium-light_skin_tone:': u'\U0001F469\U0001F3FB\U0000200D\U0001F91D\U0000200D\U0001F468\U0001F3FC',
    u':woman_and_man_holding_hands-light_skin_tone-medium_skin_tone:': u'\U0001F469\U0001F3FB\U0000200D\U0001F91D\U0000200D\U0001F468\U0001F3FD',
    u':woman_and_man_holding_hands-light_skin_tone:': u'\U0001F46B\U0001F3FB',
    u':woman_and_man_holding_hands-medium-dark_skin_tone-dark_skin_tone:': u'\U0001F469\U0001F3FE\U0000200D\U0001F91D\U0000200D\U0001F468\U0001F3FF',
    u':woman_and_man_holding_hands-medium-dark_skin_tone-light_skin_tone:': u'\U0001F469\U0001F3FE\U0000200D\U0001F91D\U0000200D\U0001F468\U0001F3FB',
    u':woman_and_man_holding_hands-medium-dark_skin_tone-medium-light_skin_tone:': u'\U0001F469\U0001F3FE\U0000200D\U0001F91D\U0000200D\U0001F468\U0001F3FC',
    u':woman_and_man_holding_hands-medium-dark_skin_tone-medium_skin_tone:': u'\U0001F469\U0001F3FE\U0000200D\U0001F91D\U0000200D\U0001F468\U0001F3FD',
    u':woman_and_man_holding_hands-medium-dark_skin_tone:': u'\U0001F46B\U0001F3FE',
    u':woman_and_man_holding_hands-medium-light_skin_tone-dark_skin_tone:': u'\U0001F469\U0001F3FC\U0000200D\U0001F91D\U0000200D\U0001F468\U0001F3FF',
    u':woman_and_man_holding_hands-medium-light_skin_tone-light_skin_tone:': u'\U0001F469\U0001F3FC\U0000200D\U0001F91D\U0000200D\U0001F468\U0001F3FB',
    u':woman_and_man_holding_hands-medium-light_skin_tone-medium-dark_skin_tone:': u'\U0001F469\U0001F3FC\U0000200D\U0001F91D\U0000200D\U0001F468\U0001F3FE',
    u':woman_and_man_holding_hands-medium-light_skin_tone-medium_skin_tone:': u'\U0001F469\U0001F3FC\U0000200D\U0001F91D\U0000200D\U0001F468\U0001F3FD',
    u':woman_and_man_holding_hands-medium-light_skin_tone:': u'\U0001F46B\U0001F3FC',
    u':woman_and_man_holding_hands-medium_skin_tone-dark_skin_tone:': u'\U0001F469\U0001F3FD\U0000200D\U0001F91D\U0000200D\U0001F468\U0001F3FF',
    u':woman_and_man_holding_hands-medium_skin_tone-light_skin_tone:': u'\U0001F469\U0001F3FD\U0000200D\U0001F91D\U0000200D\U0001F468\U0001F3FB',
    u':woman_and_man_holding_hands-medium_skin_tone-medium-dark_skin_tone:': u'\U0001F469\U0001F3FD\U0000200D\U0001F91D\U0000200D\U0001F468\U0001F3FE',
    u':woman_and_man_holding_hands-medium_skin_tone-medium-light_skin_tone:': u'\U0001F469\U0001F3FD\U0000200D\U0001F91D\U0000200D\U0001F468\U0001F3FC',
    u':woman_and_man_holding_hands-medium_skin_tone:': u'\U0001F46B\U0001F3FD',
    u':woman_artist:': u'\U0001F469\U0000200D\U0001F3A8',
    u':woman_artist_dark_skin_tone:': u'\U0001F469\U0001F3FF\U0000200D\U0001F3A8',
    u':woman_artist_light_skin_tone:': u'\U0001F469\U0001F3FB\U0000200D\U0001F3A8',
    u':woman_artist_medium-dark_skin_tone:': u'\U0001F469\U0001F3FE\U0000200D\U0001F3A8',
    u':woman_artist_medium-light_skin_tone:': u'\U0001F469\U0001F3FC\U0000200D\U0001F3A8',
    u':woman_artist_medium_skin_tone:': u'\U0001F469\U0001F3FD\U0000200D\U0001F3A8',
    u':woman_astronaut:': u'\U0001F469\U0000200D\U0001F680',
    u':woman_astronaut_dark_skin_tone:': u'\U0001F469\U0001F3FF\U0000200D\U0001F680',
    u':woman_astronaut_light_skin_tone:': u'\U0001F469\U0001F3FB\U0000200D\U0001F680',
    u':woman_astronaut_medium-dark_skin_tone:': u'\U0001F469\U0001F3FE\U0000200D\U0001F680',
    u':woman_astronaut_medium-light_skin_tone:': u'\U0001F469\U0001F3FC\U0000200D\U0001F680',
    u':woman_astronaut_medium_skin_tone:': u'\U0001F469\U0001F3FD\U0000200D\U0001F680',
    u':woman_biking-dark_skin_tone:': u'\U0001F6B4\U0001F3FF\U0000200D\U00002640',
    u':woman_biking-light_skin_tone:': u'\U0001F6B4\U0001F3FB\U0000200D\U00002640',
    u':woman_biking-medium-dark_skin_tone:': u'\U0001F6B4\U0001F3FE\U0000200D\U00002640',
    u':woman_biking-medium-light_skin_tone:': u'\U0001F6B4\U0001F3FC\U0000200D\U00002640',
    u':woman_biking-medium_skin_tone:': u'\U0001F6B4\U0001F3FD\U0000200D\U00002640',
    u':woman_biking:': u'\U0001F6B4\U0000200D\U00002640',
    u':woman_biking_dark_skin_tone:': u'\U0001F6B4\U0001F3FF\U0000200D\U00002640\U0000FE0F',
    u':woman_biking_light_skin_tone:': u'\U0001F6B4\U0001F3FB\U0000200D\U00002640\U0000FE0F',
    u':woman_biking_medium-dark_skin_tone:': u'\U0001F6B4\U0001F3FE\U0000200D\U00002640\U0000FE0F',
    u':woman_biking_medium-light_skin_tone:': u'\U0001F6B4\U0001F3FC\U0000200D\U00002640\U0000FE0F',
    u':woman_biking_medium_skin_tone:': u'\U0001F6B4\U0001F3FD\U0000200D\U00002640\U0000FE0F',
    u':woman_biking_selector:': u'\U0001F6B4\U0000200D\U00002640\U0000FE0F',
    u':woman_bouncing_ball-dark_skin_tone:': u'\U000026F9\U0001F3FF\U0000200D\U00002640',
    u':woman_bouncing_ball-light_skin_tone:': u'\U000026F9\U0001F3FB\U0000200D\U00002640',
    u':woman_bouncing_ball-medium-dark_skin_tone:': u'\U000026F9\U0001F3FE\U0000200D\U00002640',
    u':woman_bouncing_ball-medium-light_skin_tone:': u'\U000026F9\U0001F3FC\U0000200D\U00002640',
    u':woman_bouncing_ball-medium_skin_tone:': u'\U000026F9\U0001F3FD\U0000200D\U00002640',
    u':woman_bouncing_ball:': u'\U000026F9\U0000200D\U00002640',
    u':woman_bouncing_ball_2:': u'\U000026F9\U0000FE0F\U0000200D\U00002640\U0000FE0F',
    u':woman_bouncing_ball_3:': u'\U000026F9\U0000200D\U00002640\U0000FE0F',
    u':woman_bouncing_ball_dark_skin_tone:': u'\U000026F9\U0001F3FF\U0000200D\U00002640\U0000FE0F',
    u':woman_bouncing_ball_light_skin_tone:': u'\U000026F9\U0001F3FB\U0000200D\U00002640\U0000FE0F',
    u':woman_bouncing_ball_medium-dark_skin_tone:': u'\U000026F9\U0001F3FE\U0000200D\U00002640\U0000FE0F',
    u':woman_bouncing_ball_medium-light_skin_tone:': u'\U000026F9\U0001F3FC\U0000200D\U00002640\U0000FE0F',
    u':woman_bouncing_ball_medium_skin_tone:': u'\U000026F9\U0001F3FD\U0000200D\U00002640\U0000FE0F',
    u':woman_bouncing_ball_selector:': u'\U000026F9\U0000FE0F\U0000200D\U00002640',
    u':woman_bowing-dark_skin_tone:': u'\U0001F647\U0001F3FF\U0000200D\U00002640',
    u':woman_bowing-light_skin_tone:': u'\U0001F647\U0001F3FB\U0000200D\U00002640',
    u':woman_bowing-medium-dark_skin_tone:': u'\U0001F647\U0001F3FE\U0000200D\U00002640',
    u':woman_bowing-medium-light_skin_tone:': u'\U0001F647\U0001F3FC\U0000200D\U00002640',
    u':woman_bowing-medium_skin_tone:': u'\U0001F647\U0001F3FD\U0000200D\U00002640',
    u':woman_bowing:': u'\U0001F647\U0000200D\U00002640',
    u':woman_bowing_dark_skin_tone:': u'\U0001F647\U0001F3FF\U0000200D\U00002640\U0000FE0F',
    u':woman_bowing_light_skin_tone:': u'\U0001F647\U0001F3FB\U0000200D\U00002640\U0000FE0F',
    u':woman_bowing_medium-dark_skin_tone:': u'\U0001F647\U0001F3FE\U0000200D\U00002640\U0000FE0F',
    u':woman_bowing_medium-light_skin_tone:': u'\U0001F647\U0001F3FC\U0000200D\U00002640\U0000FE0F',
    u':woman_bowing_medium_skin_tone:': u'\U0001F647\U0001F3FD\U0000200D\U00002640\U0000FE0F',
    u':woman_bowing_selector:': u'\U0001F647\U0000200D\U00002640\U0000FE0F',
    u':woman_cartwheeling-dark_skin_tone:': u'\U0001F938\U0001F3FF\U0000200D\U00002640',
    u':woman_cartwheeling-light_skin_tone:': u'\U0001F938\U0001F3FB\U0000200D\U00002640',
    u':woman_cartwheeling-medium-dark_skin_tone:': u'\U0001F938\U0001F3FE\U0000200D\U00002640',
    u':woman_cartwheeling-medium-light_skin_tone:': u'\U0001F938\U0001F3FC\U0000200D\U00002640',
    u':woman_cartwheeling-medium_skin_tone:': u'\U0001F938\U0001F3FD\U0000200D\U00002640',
    u':woman_cartwheeling:': u'\U0001F938\U0000200D\U00002640',
    u':woman_cartwheeling_dark_skin_tone:': u'\U0001F938\U0001F3FF\U0000200D\U00002640\U0000FE0F',
    u':woman_cartwheeling_light_skin_tone:': u'\U0001F938\U0001F3FB\U0000200D\U00002640\U0000FE0F',
    u':woman_cartwheeling_medium-dark_skin_tone:': u'\U0001F938\U0001F3FE\U0000200D\U00002640\U0000FE0F',
    u':woman_cartwheeling_medium-light_skin_tone:': u'\U0001F938\U0001F3FC\U0000200D\U00002640\U0000FE0F',
    u':woman_cartwheeling_medium_skin_tone:': u'\U0001F938\U0001F3FD\U0000200D\U00002640\U0000FE0F',
    u':woman_cartwheeling_selector:': u'\U0001F938\U0000200D\U00002640\U0000FE0F',
    u':woman_climbing-dark_skin_tone:': u'\U0001F9D7\U0001F3FF\U0000200D\U00002640',
    u':woman_climbing-light_skin_tone:': u'\U0001F9D7\U0001F3FB\U0000200D\U00002640',
    u':woman_climbing-medium-dark_skin_tone:': u'\U0001F9D7\U0001F3FE\U0000200D\U00002640',
    u':woman_climbing-medium-light_skin_tone:': u'\U0001F9D7\U0001F3FC\U0000200D\U00002640',
    u':woman_climbing-medium_skin_tone:': u'\U0001F9D7\U0001F3FD\U0000200D\U00002640',
    u':woman_climbing:': u'\U0001F9D7\U0000200D\U00002640',
    u':woman_climbing_dark_skin_tone:': u'\U0001F9D7\U0001F3FF\U0000200D\U00002640\U0000FE0F',
    u':woman_climbing_light_skin_tone:': u'\U0001F9D7\U0001F3FB\U0000200D\U00002640\U0000FE0F',
    u':woman_climbing_medium-dark_skin_tone:': u'\U0001F9D7\U0001F3FE\U0000200D\U00002640\U0000FE0F',
    u':woman_climbing_medium-light_skin_tone:': u'\U0001F9D7\U0001F3FC\U0000200D\U00002640\U0000FE0F',
    u':woman_climbing_medium_skin_tone:': u'\U0001F9D7\U0001F3FD\U0000200D\U00002640\U0000FE0F',
    u':woman_climbing_selector:': u'\U0001F9D7\U0000200D\U00002640\U0000FE0F',
    u':woman_construction_worker-dark_skin_tone:': u'\U0001F477\U0001F3FF\U0000200D\U00002640',
    u':woman_construction_worker-light_skin_tone:': u'\U0001F477\U0001F3FB\U0000200D\U00002640',
    u':woman_construction_worker-medium-dark_skin_tone:': u'\U0001F477\U0001F3FE\U0000200D\U00002640',
    u':woman_construction_worker-medium-light_skin_tone:': u'\U0001F477\U0001F3FC\U0000200D\U00002640',
    u':woman_construction_worker-medium_skin_tone:': u'\U0001F477\U0001F3FD\U0000200D\U00002640',
    u':woman_construction_worker:': u'\U0001F477\U0000200D\U00002640',
    u':woman_construction_worker_dark_skin_tone:': u'\U0001F477\U0001F3FF\U0000200D\U00002640\U0000FE0F',
    u':woman_construction_worker_light_skin_tone:': u'\U0001F477\U0001F3FB\U0000200D\U00002640\U0000FE0F',
    u':woman_construction_worker_medium-dark_skin_tone:': u'\U0001F477\U0001F3FE\U0000200D\U00002640\U0000FE0F',
    u':woman_construction_worker_medium-light_skin_tone:': u'\U0001F477\U0001F3FC\U0000200D\U00002640\U0000FE0F',
    u':woman_construction_worker_medium_skin_tone:': u'\U0001F477\U0001F3FD\U0000200D\U00002640\U0000FE0F',
    u':woman_construction_worker_selector:': u'\U0001F477\U0000200D\U00002640\U0000FE0F',
    u':woman_cook:': u'\U0001F469\U0000200D\U0001F373',
    u':woman_cook_dark_skin_tone:': u'\U0001F469\U0001F3FF\U0000200D\U0001F373',
    u':woman_cook_light_skin_tone:': u'\U0001F469\U0001F3FB\U0000200D\U0001F373',
    u':woman_cook_medium-dark_skin_tone:': u'\U0001F469\U0001F3FE\U0000200D\U0001F373',
    u':woman_cook_medium-light_skin_tone:': u'\U0001F469\U0001F3FC\U0000200D\U0001F373',
    u':woman_cook_medium_skin_tone:': u'\U0001F469\U0001F3FD\U0000200D\U0001F373',
    u':woman_dancing:': u'\U0001F483',
    u':woman_dancing_dark_skin_tone:': u'\U0001F483\U0001F3FF',
    u':woman_dancing_light_skin_tone:': u'\U0001F483\U0001F3FB',
    u':woman_dancing_medium-dark_skin_tone:': u'\U0001F483\U0001F3FE',
    u':woman_dancing_medium-light_skin_tone:': u'\U0001F483\U0001F3FC',
    u':woman_dancing_medium_skin_tone:': u'\U0001F483\U0001F3FD',
    u':woman_dark_skin_tone:': u'\U0001F469\U0001F3FF',
    u':woman_detective-dark_skin_tone:': u'\U0001F575\U0001F3FF\U0000200D\U00002640',
    u':woman_detective-light_skin_tone:': u'\U0001F575\U0001F3FB\U0000200D\U00002640',
    u':woman_detective-medium-dark_skin_tone:': u'\U0001F575\U0001F3FE\U0000200D\U00002640',
    u':woman_detective-medium-light_skin_tone:': u'\U0001F575\U0001F3FC\U0000200D\U00002640',
    u':woman_detective-medium_skin_tone:': u'\U0001F575\U0001F3FD\U0000200D\U00002640',
    u':woman_detective:': u'\U0001F575\U0000200D\U00002640',
    u':woman_detective_2:': u'\U0001F575\U0000200D\U00002640\U0000FE0F',
    u':woman_detective_dark_skin_tone:': u'\U0001F575\U0001F3FF\U0000200D\U00002640\U0000FE0F',
    u':woman_detective_light_skin_tone:': u'\U0001F575\U0001F3FB\U0000200D\U00002640\U0000FE0F',
    u':woman_detective_medium-dark_skin_tone:': u'\U0001F575\U0001F3FE\U0000200D\U00002640\U0000FE0F',
    u':woman_detective_medium-light_skin_tone:': u'\U0001F575\U0001F3FC\U0000200D\U00002640\U0000FE0F',
    u':woman_detective_medium_skin_tone:': u'\U0001F575\U0001F3FD\U0000200D\U00002640\U0000FE0F',
    u':woman_detective_selector:': u'\U0001F575\U0000FE0F\U0000200D\U00002640',
    u':woman_elf-dark_skin_tone:': u'\U0001F9DD\U0001F3FF\U0000200D\U00002640',
    u':woman_elf-light_skin_tone:': u'\U0001F9DD\U0001F3FB\U0000200D\U00002640',
    u':woman_elf-medium-dark_skin_tone:': u'\U0001F9DD\U0001F3FE\U0000200D\U00002640',
    u':woman_elf-medium-light_skin_tone:': u'\U0001F9DD\U0001F3FC\U0000200D\U00002640',
    u':woman_elf-medium_skin_tone:': u'\U0001F9DD\U0001F3FD\U0000200D\U00002640',
    u':woman_elf:': u'\U0001F9DD\U0000200D\U00002640',
    u':woman_elf_dark_skin_tone:': u'\U0001F9DD\U0001F3FF\U0000200D\U00002640\U0000FE0F',
    u':woman_elf_light_skin_tone:': u'\U0001F9DD\U0001F3FB\U0000200D\U00002640\U0000FE0F',
    u':woman_elf_medium-dark_skin_tone:': u'\U0001F9DD\U0001F3FE\U0000200D\U00002640\U0000FE0F',
    u':woman_elf_medium-light_skin_tone:': u'\U0001F9DD\U0001F3FC\U0000200D\U00002640\U0000FE0F',
    u':woman_elf_medium_skin_tone:': u'\U0001F9DD\U0001F3FD\U0000200D\U00002640\U0000FE0F',
    u':woman_elf_selector:': u'\U0001F9DD\U0000200D\U00002640\U0000FE0F',
    u':woman_facepalming-dark_skin_tone:': u'\U0001F926\U0001F3FF\U0000200D\U00002640',
    u':woman_facepalming-light_skin_tone:': u'\U0001F926\U0001F3FB\U0000200D\U00002640',
    u':woman_facepalming-medium-dark_skin_tone:': u'\U0001F926\U0001F3FE\U0000200D\U00002640',
    u':woman_facepalming-medium-light_skin_tone:': u'\U0001F926\U0001F3FC\U0000200D\U00002640',
    u':woman_facepalming-medium_skin_tone:': u'\U0001F926\U0001F3FD\U0000200D\U00002640',
    u':woman_facepalming:': u'\U0001F926\U0000200D\U00002640',
    u':woman_facepalming_dark_skin_tone:': u'\U0001F926\U0001F3FF\U0000200D\U00002640\U0000FE0F',
    u':woman_facepalming_light_skin_tone:': u'\U0001F926\U0001F3FB\U0000200D\U00002640\U0000FE0F',
    u':woman_facepalming_medium-dark_skin_tone:': u'\U0001F926\U0001F3FE\U0000200D\U00002640\U0000FE0F',
    u':woman_facepalming_medium-light_skin_tone:': u'\U0001F926\U0001F3FC\U0000200D\U00002640\U0000FE0F',
    u':woman_facepalming_medium_skin_tone:': u'\U0001F926\U0001F3FD\U0000200D\U00002640\U0000FE0F',
    u':woman_facepalming_selector:': u'\U0001F926\U0000200D\U00002640\U0000FE0F',
    u':woman_factory_worker:': u'\U0001F469\U0000200D\U0001F3ED',
    u':woman_factory_worker_dark_skin_tone:': u'\U0001F469\U0001F3FF\U0000200D\U0001F3ED',
    u':woman_factory_worker_light_skin_tone:': u'\U0001F469\U0001F3FB\U0000200D\U0001F3ED',
    u':woman_factory_worker_medium-dark_skin_tone:': u'\U0001F469\U0001F3FE\U0000200D\U0001F3ED',
    u':woman_factory_worker_medium-light_skin_tone:': u'\U0001F469\U0001F3FC\U0000200D\U0001F3ED',
    u':woman_factory_worker_medium_skin_tone:': u'\U0001F469\U0001F3FD\U0000200D\U0001F3ED',
    u':woman_fairy-dark_skin_tone:': u'\U0001F9DA\U0001F3FF\U0000200D\U00002640',
    u':woman_fairy-light_skin_tone:': u'\U0001F9DA\U0001F3FB\U0000200D\U00002640',
    u':woman_fairy-medium-dark_skin_tone:': u'\U0001F9DA\U0001F3FE\U0000200D\U00002640',
    u':woman_fairy-medium-light_skin_tone:': u'\U0001F9DA\U0001F3FC\U0000200D\U00002640',
    u':woman_fairy-medium_skin_tone:': u'\U0001F9DA\U0001F3FD\U0000200D\U00002640',
    u':woman_fairy:': u'\U0001F9DA\U0000200D\U00002640',
    u':woman_fairy_dark_skin_tone:': u'\U0001F9DA\U0001F3FF\U0000200D\U00002640\U0000FE0F',
    u':woman_fairy_light_skin_tone:': u'\U0001F9DA\U0001F3FB\U0000200D\U00002640\U0000FE0F',
    u':woman_fairy_medium-dark_skin_tone:': u'\U0001F9DA\U0001F3FE\U0000200D\U00002640\U0000FE0F',
    u':woman_fairy_medium-light_skin_tone:': u'\U0001F9DA\U0001F3FC\U0000200D\U00002640\U0000FE0F',
    u':woman_fairy_medium_skin_tone:': u'\U0001F9DA\U0001F3FD\U0000200D\U00002640\U0000FE0F',
    u':woman_fairy_selector:': u'\U0001F9DA\U0000200D\U00002640\U0000FE0F',
    u':woman_farmer:': u'\U0001F469\U0000200D\U0001F33E',
    u':woman_farmer_dark_skin_tone:': u'\U0001F469\U0001F3FF\U0000200D\U0001F33E',
    u':woman_farmer_light_skin_tone:': u'\U0001F469\U0001F3FB\U0000200D\U0001F33E',
    u':woman_farmer_medium-dark_skin_tone:': u'\U0001F469\U0001F3FE\U0000200D\U0001F33E',
    u':woman_farmer_medium-light_skin_tone:': u'\U0001F469\U0001F3FC\U0000200D\U0001F33E',
    u':woman_farmer_medium_skin_tone:': u'\U0001F469\U0001F3FD\U0000200D\U0001F33E',
    u':woman_firefighter:': u'\U0001F469\U0000200D\U0001F692',
    u':woman_firefighter_dark_skin_tone:': u'\U0001F469\U0001F3FF\U0000200D\U0001F692',
    u':woman_firefighter_light_skin_tone:': u'\U0001F469\U0001F3FB\U0000200D\U0001F692',
    u':woman_firefighter_medium-dark_skin_tone:': u'\U0001F469\U0001F3FE\U0000200D\U0001F692',
    u':woman_firefighter_medium-light_skin_tone:': u'\U0001F469\U0001F3FC\U0000200D\U0001F692',
    u':woman_firefighter_medium_skin_tone:': u'\U0001F469\U0001F3FD\U0000200D\U0001F692',
    u':woman_frowning-dark_skin_tone:': u'\U0001F64D\U0001F3FF\U0000200D\U00002640',
    u':woman_frowning-light_skin_tone:': u'\U0001F64D\U0001F3FB\U0000200D\U00002640',
    u':woman_frowning-medium-dark_skin_tone:': u'\U0001F64D\U0001F3FE\U0000200D\U00002640',
    u':woman_frowning-medium-light_skin_tone:': u'\U0001F64D\U0001F3FC\U0000200D\U00002640',
    u':woman_frowning-medium_skin_tone:': u'\U0001F64D\U0001F3FD\U0000200D\U00002640',
    u':woman_frowning:': u'\U0001F64D\U0000200D\U00002640',
    u':woman_frowning_dark_skin_tone:': u'\U0001F64D\U0001F3FF\U0000200D\U00002640\U0000FE0F',
    u':woman_frowning_light_skin_tone:': u'\U0001F64D\U0001F3FB\U0000200D\U00002640\U0000FE0F',
    u':woman_frowning_medium-dark_skin_tone:': u'\U0001F64D\U0001F3FE\U0000200D\U00002640\U0000FE0F',
    u':woman_frowning_medium-light_skin_tone:': u'\U0001F64D\U0001F3FC\U0000200D\U00002640\U0000FE0F',
    u':woman_frowning_medium_skin_tone:': u'\U0001F64D\U0001F3FD\U0000200D\U00002640\U0000FE0F',
    u':woman_frowning_selector:': u'\U0001F64D\U0000200D\U00002640\U0000FE0F',
    u':woman_genie:': u'\U0001F9DE\U0000200D\U00002640',
    u':woman_genie_selector:': u'\U0001F9DE\U0000200D\U00002640\U0000FE0F',
    u':woman_gesturing_NO-dark_skin_tone:': u'\U0001F645\U0001F3FF\U0000200D\U00002640',
    u':woman_gesturing_NO-light_skin_tone:': u'\U0001F645\U0001F3FB\U0000200D\U00002640',
    u':woman_gesturing_NO-medium-dark_skin_tone:': u'\U0001F645\U0001F3FE\U0000200D\U00002640',
    u':woman_gesturing_NO-medium-light_skin_tone:': u'\U0001F645\U0001F3FC\U0000200D\U00002640',
    u':woman_gesturing_NO-medium_skin_tone:': u'\U0001F645\U0001F3FD\U0000200D\U00002640',
    u':woman_gesturing_NO:': u'\U0001F645\U0000200D\U00002640',
    u':woman_gesturing_NO_dark_skin_tone:': u'\U0001F645\U0001F3FF\U0000200D\U00002640\U0000FE0F',
    u':woman_gesturing_NO_light_skin_tone:': u'\U0001F645\U0001F3FB\U0000200D\U00002640\U0000FE0F',
    u':woman_gesturing_NO_medium-dark_skin_tone:': u'\U0001F645\U0001F3FE\U0000200D\U00002640\U0000FE0F',
    u':woman_gesturing_NO_medium-light_skin_tone:': u'\U0001F645\U0001F3FC\U0000200D\U00002640\U0000FE0F',
    u':woman_gesturing_NO_medium_skin_tone:': u'\U0001F645\U0001F3FD\U0000200D\U00002640\U0000FE0F',
    u':woman_gesturing_NO_selector:': u'\U0001F645\U0000200D\U00002640\U0000FE0F',
    u':woman_gesturing_OK-dark_skin_tone:': u'\U0001F646\U0001F3FF\U0000200D\U00002640',
    u':woman_gesturing_OK-light_skin_tone:': u'\U0001F646\U0001F3FB\U0000200D\U00002640',
    u':woman_gesturing_OK-medium-dark_skin_tone:': u'\U0001F646\U0001F3FE\U0000200D\U00002640',
    u':woman_gesturing_OK-medium-light_skin_tone:': u'\U0001F646\U0001F3FC\U0000200D\U00002640',
    u':woman_gesturing_OK-medium_skin_tone:': u'\U0001F646\U0001F3FD\U0000200D\U00002640',
    u':woman_gesturing_OK:': u'\U0001F646\U0000200D\U00002640',
    u':woman_gesturing_OK_dark_skin_tone:': u'\U0001F646\U0001F3FF\U0000200D\U00002640\U0000FE0F',
    u':woman_gesturing_OK_light_skin_tone:': u'\U0001F646\U0001F3FB\U0000200D\U00002640\U0000FE0F',
    u':woman_gesturing_OK_medium-dark_skin_tone:': u'\U0001F646\U0001F3FE\U0000200D\U00002640\U0000FE0F',
    u':woman_gesturing_OK_medium-light_skin_tone:': u'\U0001F646\U0001F3FC\U0000200D\U00002640\U0000FE0F',
    u':woman_gesturing_OK_medium_skin_tone:': u'\U0001F646\U0001F3FD\U0000200D\U00002640\U0000FE0F',
    u':woman_gesturing_OK_selector:': u'\U0001F646\U0000200D\U00002640\U0000FE0F',
    u':woman_getting_haircut-dark_skin_tone:': u'\U0001F487\U0001F3FF\U0000200D\U00002640',
    u':woman_getting_haircut-light_skin_tone:': u'\U0001F487\U0001F3FB\U0000200D\U00002640',
    u':woman_getting_haircut-medium-dark_skin_tone:': u'\U0001F487\U0001F3FE\U0000200D\U00002640',
    u':woman_getting_haircut-medium-light_skin_tone:': u'\U0001F487\U0001F3FC\U0000200D\U00002640',
    u':woman_getting_haircut-medium_skin_tone:': u'\U0001F487\U0001F3FD\U0000200D\U00002640',
    u':woman_getting_haircut:': u'\U0001F487\U0000200D\U00002640',
    u':woman_getting_haircut_dark_skin_tone:': u'\U0001F487\U0001F3FF\U0000200D\U00002640\U0000FE0F',
    u':woman_getting_haircut_light_skin_tone:': u'\U0001F487\U0001F3FB\U0000200D\U00002640\U0000FE0F',
    u':woman_getting_haircut_medium-dark_skin_tone:': u'\U0001F487\U0001F3FE\U0000200D\U00002640\U0000FE0F',
    u':woman_getting_haircut_medium-light_skin_tone:': u'\U0001F487\U0001F3FC\U0000200D\U00002640\U0000FE0F',
    u':woman_getting_haircut_medium_skin_tone:': u'\U0001F487\U0001F3FD\U0000200D\U00002640\U0000FE0F',
    u':woman_getting_haircut_selector:': u'\U0001F487\U0000200D\U00002640\U0000FE0F',
    u':woman_getting_massage-dark_skin_tone:': u'\U0001F486\U0001F3FF\U0000200D\U00002640',
    u':woman_getting_massage-light_skin_tone:': u'\U0001F486\U0001F3FB\U0000200D\U00002640',
    u':woman_getting_massage-medium-dark_skin_tone:': u'\U0001F486\U0001F3FE\U0000200D\U00002640',
    u':woman_getting_massage-medium-light_skin_tone:': u'\U0001F486\U0001F3FC\U0000200D\U00002640',
    u':woman_getting_massage-medium_skin_tone:': u'\U0001F486\U0001F3FD\U0000200D\U00002640',
    u':woman_getting_massage:': u'\U0001F486\U0000200D\U00002640',
    u':woman_getting_massage_dark_skin_tone:': u'\U0001F486\U0001F3FF\U0000200D\U00002640\U0000FE0F',
    u':woman_getting_massage_light_skin_tone:': u'\U0001F486\U0001F3FB\U0000200D\U00002640\U0000FE0F',
    u':woman_getting_massage_medium-dark_skin_tone:': u'\U0001F486\U0001F3FE\U0000200D\U00002640\U0000FE0F',
    u':woman_getting_massage_medium-light_skin_tone:': u'\U0001F486\U0001F3FC\U0000200D\U00002640\U0000FE0F',
    u':woman_getting_massage_medium_skin_tone:': u'\U0001F486\U0001F3FD\U0000200D\U00002640\U0000FE0F',
    u':woman_getting_massage_selector:': u'\U0001F486\U0000200D\U00002640\U0000FE0F',
    u':woman_golfing-dark_skin_tone:': u'\U0001F3CC\U0001F3FF\U0000200D\U00002640',
    u':woman_golfing-light_skin_tone:': u'\U0001F3CC\U0001F3FB\U0000200D\U00002640',
    u':woman_golfing-medium-dark_skin_tone:': u'\U0001F3CC\U0001F3FE\U0000200D\U00002640',
    u':woman_golfing-medium-light_skin_tone:': u'\U0001F3CC\U0001F3FC\U0000200D\U00002640',
    u':woman_golfing-medium_skin_tone:': u'\U0001F3CC\U0001F3FD\U0000200D\U00002640',
    u':woman_golfing:': u'\U0001F3CC\U0000200D\U00002640',
    u':woman_golfing_2:': u'\U0001F3CC\U0000FE0F\U0000200D\U00002640\U0000FE0F',
    u':woman_golfing_3:': u'\U0001F3CC\U0000200D\U00002640\U0000FE0F',
    u':woman_golfing_dark_skin_tone:': u'\U0001F3CC\U0001F3FF\U0000200D\U00002640\U0000FE0F',
    u':woman_golfing_light_skin_tone:': u'\U0001F3CC\U0001F3FB\U0000200D\U00002640\U0000FE0F',
    u':woman_golfing_medium-dark_skin_tone:': u'\U0001F3CC\U0001F3FE\U0000200D\U00002640\U0000FE0F',
    u':woman_golfing_medium-light_skin_tone:': u'\U0001F3CC\U0001F3FC\U0000200D\U00002640\U0000FE0F',
    u':woman_golfing_medium_skin_tone:': u'\U0001F3CC\U0001F3FD\U0000200D\U00002640\U0000FE0F',
    u':woman_golfing_selector:': u'\U0001F3CC\U0000FE0F\U0000200D\U00002640',
    u':woman_guard-dark_skin_tone:': u'\U0001F482\U0001F3FF\U0000200D\U00002640',
    u':woman_guard-light_skin_tone:': u'\U0001F482\U0001F3FB\U0000200D\U00002640',
    u':woman_guard-medium-dark_skin_tone:': u'\U0001F482\U0001F3FE\U0000200D\U00002640',
    u':woman_guard-medium-light_skin_tone:': u'\U0001F482\U0001F3FC\U0000200D\U00002640',
    u':woman_guard-medium_skin_tone:': u'\U0001F482\U0001F3FD\U0000200D\U00002640',
    u':woman_guard:': u'\U0001F482\U0000200D\U00002640',
    u':woman_guard_dark_skin_tone:': u'\U0001F482\U0001F3FF\U0000200D\U00002640\U0000FE0F',
    u':woman_guard_light_skin_tone:': u'\U0001F482\U0001F3FB\U0000200D\U00002640\U0000FE0F',
    u':woman_guard_medium-dark_skin_tone:': u'\U0001F482\U0001F3FE\U0000200D\U00002640\U0000FE0F',
    u':woman_guard_medium-light_skin_tone:': u'\U0001F482\U0001F3FC\U0000200D\U00002640\U0000FE0F',
    u':woman_guard_medium_skin_tone:': u'\U0001F482\U0001F3FD\U0000200D\U00002640\U0000FE0F',
    u':woman_guard_selector:': u'\U0001F482\U0000200D\U00002640\U0000FE0F',
    u':woman_health_worker-dark_skin_tone:': u'\U0001F469\U0001F3FF\U0000200D\U00002695',
    u':woman_health_worker-light_skin_tone:': u'\U0001F469\U0001F3FB\U0000200D\U00002695',
    u':woman_health_worker-medium-dark_skin_tone:': u'\U0001F469\U0001F3FE\U0000200D\U00002695',
    u':woman_health_worker-medium-light_skin_tone:': u'\U0001F469\U0001F3FC\U0000200D\U00002695',
    u':woman_health_worker-medium_skin_tone:': u'\U0001F469\U0001F3FD\U0000200D\U00002695',
    u':woman_health_worker:': u'\U0001F469\U0000200D\U00002695',
    u':woman_health_worker_dark_skin_tone:': u'\U0001F469\U0001F3FF\U0000200D\U00002695\U0000FE0F',
    u':woman_health_worker_light_skin_tone:': u'\U0001F469\U0001F3FB\U0000200D\U00002695\U0000FE0F',
    u':woman_health_worker_medium-dark_skin_tone:': u'\U0001F469\U0001F3FE\U0000200D\U00002695\U0000FE0F',
    u':woman_health_worker_medium-light_skin_tone:': u'\U0001F469\U0001F3FC\U0000200D\U00002695\U0000FE0F',
    u':woman_health_worker_medium_skin_tone:': u'\U0001F469\U0001F3FD\U0000200D\U00002695\U0000FE0F',
    u':woman_health_worker_selector:': u'\U0001F469\U0000200D\U00002695\U0000FE0F',
    u':woman_in_lotus_position-dark_skin_tone:': u'\U0001F9D8\U0001F3FF\U0000200D\U00002640',
    u':woman_in_lotus_position-light_skin_tone:': u'\U0001F9D8\U0001F3FB\U0000200D\U00002640',
    u':woman_in_lotus_position-medium-dark_skin_tone:': u'\U0001F9D8\U0001F3FE\U0000200D\U00002640',
    u':woman_in_lotus_position-medium-light_skin_tone:': u'\U0001F9D8\U0001F3FC\U0000200D\U00002640',
    u':woman_in_lotus_position-medium_skin_tone:': u'\U0001F9D8\U0001F3FD\U0000200D\U00002640',
    u':woman_in_lotus_position:': u'\U0001F9D8\U0000200D\U00002640',
    u':woman_in_lotus_position_dark_skin_tone:': u'\U0001F9D8\U0001F3FF\U0000200D\U00002640\U0000FE0F',
    u':woman_in_lotus_position_light_skin_tone:': u'\U0001F9D8\U0001F3FB\U0000200D\U00002640\U0000FE0F',
    u':woman_in_lotus_position_medium-dark_skin_tone:': u'\U0001F9D8\U0001F3FE\U0000200D\U00002640\U0000FE0F',
    u':woman_in_lotus_position_medium-light_skin_tone:': u'\U0001F9D8\U0001F3FC\U0000200D\U00002640\U0000FE0F',
    u':woman_in_lotus_position_medium_skin_tone:': u'\U0001F9D8\U0001F3FD\U0000200D\U00002640\U0000FE0F',
    u':woman_in_lotus_position_selector:': u'\U0001F9D8\U0000200D\U00002640\U0000FE0F',
    u':woman_in_manual_wheelchair-dark_skin_tone:': u'\U0001F469\U0001F3FF\U0000200D\U0001F9BD',
    u':woman_in_manual_wheelchair-light_skin_tone:': u'\U0001F469\U0001F3FB\U0000200D\U0001F9BD',
    u':woman_in_manual_wheelchair-medium-dark_skin_tone:': u'\U0001F469\U0001F3FE\U0000200D\U0001F9BD',
    u':woman_in_manual_wheelchair-medium-light_skin_tone:': u'\U0001F469\U0001F3FC\U0000200D\U0001F9BD',
    u':woman_in_manual_wheelchair-medium_skin_tone:': u'\U0001F469\U0001F3FD\U0000200D\U0001F9BD',
    u':woman_in_manual_wheelchair:': u'\U0001F469\U0000200D\U0001F9BD',
    u':woman_in_motorized_wheelchair-dark_skin_tone:': u'\U0001F469\U0001F3FF\U0000200D\U0001F9BC',
    u':woman_in_motorized_wheelchair-light_skin_tone:': u'\U0001F469\U0001F3FB\U0000200D\U0001F9BC',
    u':woman_in_motorized_wheelchair-medium-dark_skin_tone:': u'\U0001F469\U0001F3FE\U0000200D\U0001F9BC',
    u':woman_in_motorized_wheelchair-medium-light_skin_tone:': u'\U0001F469\U0001F3FC\U0000200D\U0001F9BC',
    u':woman_in_motorized_wheelchair-medium_skin_tone:': u'\U0001F469\U0001F3FD\U0000200D\U0001F9BC',
    u':woman_in_motorized_wheelchair:': u'\U0001F469\U0000200D\U0001F9BC',
    u':woman_in_steamy_room-dark_skin_tone:': u'\U0001F9D6\U0001F3FF\U0000200D\U00002640',
    u':woman_in_steamy_room-light_skin_tone:': u'\U0001F9D6\U0001F3FB\U0000200D\U00002640',
    u':woman_in_steamy_room-medium-dark_skin_tone:': u'\U0001F9D6\U0001F3FE\U0000200D\U00002640',
    u':woman_in_steamy_room-medium-light_skin_tone:': u'\U0001F9D6\U0001F3FC\U0000200D\U00002640',
    u':woman_in_steamy_room-medium_skin_tone:': u'\U0001F9D6\U0001F3FD\U0000200D\U00002640',
    u':woman_in_steamy_room:': u'\U0001F9D6\U0000200D\U00002640',
    u':woman_in_steamy_room_dark_skin_tone:': u'\U0001F9D6\U0001F3FF\U0000200D\U00002640\U0000FE0F',
    u':woman_in_steamy_room_light_skin_tone:': u'\U0001F9D6\U0001F3FB\U0000200D\U00002640\U0000FE0F',
    u':woman_in_steamy_room_medium-dark_skin_tone:': u'\U0001F9D6\U0001F3FE\U0000200D\U00002640\U0000FE0F',
    u':woman_in_steamy_room_medium-light_skin_tone:': u'\U0001F9D6\U0001F3FC\U0000200D\U00002640\U0000FE0F',
    u':woman_in_steamy_room_medium_skin_tone:': u'\U0001F9D6\U0001F3FD\U0000200D\U00002640\U0000FE0F',
    u':woman_in_steamy_room_selector:': u'\U0001F9D6\U0000200D\U00002640\U0000FE0F',
    u':woman_judge-dark_skin_tone:': u'\U0001F469\U0001F3FF\U0000200D\U00002696',
    u':woman_judge-light_skin_tone:': u'\U0001F469\U0001F3FB\U0000200D\U00002696',
    u':woman_judge-medium-dark_skin_tone:': u'\U0001F469\U0001F3FE\U0000200D\U00002696',
    u':woman_judge-medium-light_skin_tone:': u'\U0001F469\U0001F3FC\U0000200D\U00002696',
    u':woman_judge-medium_skin_tone:': u'\U0001F469\U0001F3FD\U0000200D\U00002696',
    u':woman_judge:': u'\U0001F469\U0000200D\U00002696',
    u':woman_judge_dark_skin_tone:': u'\U0001F469\U0001F3FF\U0000200D\U00002696\U0000FE0F',
    u':woman_judge_light_skin_tone:': u'\U0001F469\U0001F3FB\U0000200D\U00002696\U0000FE0F',
    u':woman_judge_medium-dark_skin_tone:': u'\U0001F469\U0001F3FE\U0000200D\U00002696\U0000FE0F',
    u':woman_judge_medium-light_skin_tone:': u'\U0001F469\U0001F3FC\U0000200D\U00002696\U0000FE0F',
    u':woman_judge_medium_skin_tone:': u'\U0001F469\U0001F3FD\U0000200D\U00002696\U0000FE0F',
    u':woman_judge_selector:': u'\U0001F469\U0000200D\U00002696\U0000FE0F',
    u':woman_juggling-dark_skin_tone:': u'\U0001F939\U0001F3FF\U0000200D\U00002640',
    u':woman_juggling-light_skin_tone:': u'\U0001F939\U0001F3FB\U0000200D\U00002640',
    u':woman_juggling-medium-dark_skin_tone:': u'\U0001F939\U0001F3FE\U0000200D\U00002640',
    u':woman_juggling-medium-light_skin_tone:': u'\U0001F939\U0001F3FC\U0000200D\U00002640',
    u':woman_juggling-medium_skin_tone:': u'\U0001F939\U0001F3FD\U0000200D\U00002640',
    u':woman_juggling:': u'\U0001F939\U0000200D\U00002640',
    u':woman_juggling_dark_skin_tone:': u'\U0001F939\U0001F3FF\U0000200D\U00002640\U0000FE0F',
    u':woman_juggling_light_skin_tone:': u'\U0001F939\U0001F3FB\U0000200D\U00002640\U0000FE0F',
    u':woman_juggling_medium-dark_skin_tone:': u'\U0001F939\U0001F3FE\U0000200D\U00002640\U0000FE0F',
    u':woman_juggling_medium-light_skin_tone:': u'\U0001F939\U0001F3FC\U0000200D\U00002640\U0000FE0F',
    u':woman_juggling_medium_skin_tone:': u'\U0001F939\U0001F3FD\U0000200D\U00002640\U0000FE0F',
    u':woman_juggling_selector:': u'\U0001F939\U0000200D\U00002640\U0000FE0F',
    u':woman_kneeling-dark_skin_tone:': u'\U0001F9CE\U0001F3FF\U0000200D\U00002640',
    u':woman_kneeling-dark_skin_tone_selector:': u'\U0001F9CE\U0001F3FF\U0000200D\U00002640\U0000FE0F',
    u':woman_kneeling-light_skin_tone:': u'\U0001F9CE\U0001F3FB\U0000200D\U00002640',
    u':woman_kneeling-light_skin_tone_selector:': u'\U0001F9CE\U0001F3FB\U0000200D\U00002640\U0000FE0F',
    u':woman_kneeling-medium-dark_skin_tone:': u'\U0001F9CE\U0001F3FE\U0000200D\U00002640',
    u':woman_kneeling-medium-dark_skin_tone_selector:': u'\U0001F9CE\U0001F3FE\U0000200D\U00002640\U0000FE0F',
    u':woman_kneeling-medium-light_skin_tone:': u'\U0001F9CE\U0001F3FC\U0000200D\U00002640',
    u':woman_kneeling-medium-light_skin_tone_selector:': u'\U0001F9CE\U0001F3FC\U0000200D\U00002640\U0000FE0F',
    u':woman_kneeling-medium_skin_tone:': u'\U0001F9CE\U0001F3FD\U0000200D\U00002640',
    u':woman_kneeling-medium_skin_tone_selector:': u'\U0001F9CE\U0001F3FD\U0000200D\U00002640\U0000FE0F',
    u':woman_kneeling:': u'\U0001F9CE\U0000200D\U00002640',
    u':woman_kneeling_selector:': u'\U0001F9CE\U0000200D\U00002640\U0000FE0F',
    u':woman_lifting_weights-dark_skin_tone:': u'\U0001F3CB\U0001F3FF\U0000200D\U00002640',
    u':woman_lifting_weights-light_skin_tone:': u'\U0001F3CB\U0001F3FB\U0000200D\U00002640',
    u':woman_lifting_weights-medium-dark_skin_tone:': u'\U0001F3CB\U0001F3FE\U0000200D\U00002640',
    u':woman_lifting_weights-medium-light_skin_tone:': u'\U0001F3CB\U0001F3FC\U0000200D\U00002640',
    u':woman_lifting_weights-medium_skin_tone:': u'\U0001F3CB\U0001F3FD\U0000200D\U00002640',
    u':woman_lifting_weights:': u'\U0001F3CB\U0000200D\U00002640',
    u':woman_lifting_weights_2:': u'\U0001F3CB\U0000FE0F\U0000200D\U00002640\U0000FE0F',
    u':woman_lifting_weights_3:': u'\U0001F3CB\U0000200D\U00002640\U0000FE0F',
    u':woman_lifting_weights_dark_skin_tone:': u'\U0001F3CB\U0001F3FF\U0000200D\U00002640\U0000FE0F',
    u':woman_lifting_weights_light_skin_tone:': u'\U0001F3CB\U0001F3FB\U0000200D\U00002640\U0000FE0F',
    u':woman_lifting_weights_medium-dark_skin_tone:': u'\U0001F3CB\U0001F3FE\U0000200D\U00002640\U0000FE0F',
    u':woman_lifting_weights_medium-light_skin_tone:': u'\U0001F3CB\U0001F3FC\U0000200D\U00002640\U0000FE0F',
    u':woman_lifting_weights_medium_skin_tone:': u'\U0001F3CB\U0001F3FD\U0000200D\U00002640\U0000FE0F',
    u':woman_lifting_weights_selector:': u'\U0001F3CB\U0000FE0F\U0000200D\U00002640',
    u':woman_light_skin_tone:': u'\U0001F469\U0001F3FB',
    u':woman_mage-dark_skin_tone:': u'\U0001F9D9\U0001F3FF\U0000200D\U00002640',
    u':woman_mage-light_skin_tone:': u'\U0001F9D9\U0001F3FB\U0000200D\U00002640',
    u':woman_mage-medium-dark_skin_tone:': u'\U0001F9D9\U0001F3FE\U0000200D\U00002640',
    u':woman_mage-medium-light_skin_tone:': u'\U0001F9D9\U0001F3FC\U0000200D\U00002640',
    u':woman_mage-medium_skin_tone:': u'\U0001F9D9\U0001F3FD\U0000200D\U00002640',
    u':woman_mage:': u'\U0001F9D9\U0000200D\U00002640',
    u':woman_mage_dark_skin_tone:': u'\U0001F9D9\U0001F3FF\U0000200D\U00002640\U0000FE0F',
    u':woman_mage_light_skin_tone:': u'\U0001F9D9\U0001F3FB\U0000200D\U00002640\U0000FE0F',
    u':woman_mage_medium-dark_skin_tone:': u'\U0001F9D9\U0001F3FE\U0000200D\U00002640\U0000FE0F',
    u':woman_mage_medium-light_skin_tone:': u'\U0001F9D9\U0001F3FC\U0000200D\U00002640\U0000FE0F',
    u':woman_mage_medium_skin_tone:': u'\U0001F9D9\U0001F3FD\U0000200D\U00002640\U0000FE0F',
    u':woman_mage_selector:': u'\U0001F9D9\U0000200D\U00002640\U0000FE0F',
    u':woman_mechanic:': u'\U0001F469\U0000200D\U0001F527',
    u':woman_mechanic_dark_skin_tone:': u'\U0001F469\U0001F3FF\U0000200D\U0001F527',
    u':woman_mechanic_light_skin_tone:': u'\U0001F469\U0001F3FB\U0000200D\U0001F527',
    u':woman_mechanic_medium-dark_skin_tone:': u'\U0001F469\U0001F3FE\U0000200D\U0001F527',
    u':woman_mechanic_medium-light_skin_tone:': u'\U0001F469\U0001F3FC\U0000200D\U0001F527',
    u':woman_mechanic_medium_skin_tone:': u'\U0001F469\U0001F3FD\U0000200D\U0001F527',
    u':woman_medium-dark_skin_tone:': u'\U0001F469\U0001F3FE',
    u':woman_medium-light_skin_tone:': u'\U0001F469\U0001F3FC',
    u':woman_medium_skin_tone:': u'\U0001F469\U0001F3FD',
    u':woman_mountain_biking-dark_skin_tone:': u'\U0001F6B5\U0001F3FF\U0000200D\U00002640',
    u':woman_mountain_biking-light_skin_tone:': u'\U0001F6B5\U0001F3FB\U0000200D\U00002640',
    u':woman_mountain_biking-medium-dark_skin_tone:': u'\U0001F6B5\U0001F3FE\U0000200D\U00002640',
    u':woman_mountain_biking-medium-light_skin_tone:': u'\U0001F6B5\U0001F3FC\U0000200D\U00002640',
    u':woman_mountain_biking-medium_skin_tone:': u'\U0001F6B5\U0001F3FD\U0000200D\U00002640',
    u':woman_mountain_biking:': u'\U0001F6B5\U0000200D\U00002640',
    u':woman_mountain_biking_dark_skin_tone:': u'\U0001F6B5\U0001F3FF\U0000200D\U00002640\U0000FE0F',
    u':woman_mountain_biking_light_skin_tone:': u'\U0001F6B5\U0001F3FB\U0000200D\U00002640\U0000FE0F',
    u':woman_mountain_biking_medium-dark_skin_tone:': u'\U0001F6B5\U0001F3FE\U0000200D\U00002640\U0000FE0F',
    u':woman_mountain_biking_medium-light_skin_tone:': u'\U0001F6B5\U0001F3FC\U0000200D\U00002640\U0000FE0F',
    u':woman_mountain_biking_medium_skin_tone:': u'\U0001F6B5\U0001F3FD\U0000200D\U00002640\U0000FE0F',
    u':woman_mountain_biking_selector:': u'\U0001F6B5\U0000200D\U00002640\U0000FE0F',
    u':woman_office_worker:': u'\U0001F469\U0000200D\U0001F4BC',
    u':woman_office_worker_dark_skin_tone:': u'\U0001F469\U0001F3FF\U0000200D\U0001F4BC',
    u':woman_office_worker_light_skin_tone:': u'\U0001F469\U0001F3FB\U0000200D\U0001F4BC',
    u':woman_office_worker_medium-dark_skin_tone:': u'\U0001F469\U0001F3FE\U0000200D\U0001F4BC',
    u':woman_office_worker_medium-light_skin_tone:': u'\U0001F469\U0001F3FC\U0000200D\U0001F4BC',
    u':woman_office_worker_medium_skin_tone:': u'\U0001F469\U0001F3FD\U0000200D\U0001F4BC',
    u':woman_pilot-dark_skin_tone:': u'\U0001F469\U0001F3FF\U0000200D\U00002708',
    u':woman_pilot-light_skin_tone:': u'\U0001F469\U0001F3FB\U0000200D\U00002708',
    u':woman_pilot-medium-dark_skin_tone:': u'\U0001F469\U0001F3FE\U0000200D\U00002708',
    u':woman_pilot-medium-light_skin_tone:': u'\U0001F469\U0001F3FC\U0000200D\U00002708',
    u':woman_pilot-medium_skin_tone:': u'\U0001F469\U0001F3FD\U0000200D\U00002708',
    u':woman_pilot:': u'\U0001F469\U0000200D\U00002708',
    u':woman_pilot_dark_skin_tone:': u'\U0001F469\U0001F3FF\U0000200D\U00002708\U0000FE0F',
    u':woman_pilot_light_skin_tone:': u'\U0001F469\U0001F3FB\U0000200D\U00002708\U0000FE0F',
    u':woman_pilot_medium-dark_skin_tone:': u'\U0001F469\U0001F3FE\U0000200D\U00002708\U0000FE0F',
    u':woman_pilot_medium-light_skin_tone:': u'\U0001F469\U0001F3FC\U0000200D\U00002708\U0000FE0F',
    u':woman_pilot_medium_skin_tone:': u'\U0001F469\U0001F3FD\U0000200D\U00002708\U0000FE0F',
    u':woman_pilot_selector:': u'\U0001F469\U0000200D\U00002708\U0000FE0F',
    u':woman_playing_handball-dark_skin_tone:': u'\U0001F93E\U0001F3FF\U0000200D\U00002640',
    u':woman_playing_handball-light_skin_tone:': u'\U0001F93E\U0001F3FB\U0000200D\U00002640',
    u':woman_playing_handball-medium-dark_skin_tone:': u'\U0001F93E\U0001F3FE\U0000200D\U00002640',
    u':woman_playing_handball-medium-light_skin_tone:': u'\U0001F93E\U0001F3FC\U0000200D\U00002640',
    u':woman_playing_handball-medium_skin_tone:': u'\U0001F93E\U0001F3FD\U0000200D\U00002640',
    u':woman_playing_handball:': u'\U0001F93E\U0000200D\U00002640',
    u':woman_playing_handball_dark_skin_tone:': u'\U0001F93E\U0001F3FF\U0000200D\U00002640\U0000FE0F',
    u':woman_playing_handball_light_skin_tone:': u'\U0001F93E\U0001F3FB\U0000200D\U00002640\U0000FE0F',
    u':woman_playing_handball_medium-dark_skin_tone:': u'\U0001F93E\U0001F3FE\U0000200D\U00002640\U0000FE0F',
    u':woman_playing_handball_medium-light_skin_tone:': u'\U0001F93E\U0001F3FC\U0000200D\U00002640\U0000FE0F',
    u':woman_playing_handball_medium_skin_tone:': u'\U0001F93E\U0001F3FD\U0000200D\U00002640\U0000FE0F',
    u':woman_playing_handball_selector:': u'\U0001F93E\U0000200D\U00002640\U0000FE0F',
    u':woman_playing_water_polo-dark_skin_tone:': u'\U0001F93D\U0001F3FF\U0000200D\U00002640',
    u':woman_playing_water_polo-light_skin_tone:': u'\U0001F93D\U0001F3FB\U0000200D\U00002640',
    u':woman_playing_water_polo-medium-dark_skin_tone:': u'\U0001F93D\U0001F3FE\U0000200D\U00002640',
    u':woman_playing_water_polo-medium-light_skin_tone:': u'\U0001F93D\U0001F3FC\U0000200D\U00002640',
    u':woman_playing_water_polo-medium_skin_tone:': u'\U0001F93D\U0001F3FD\U0000200D\U00002640',
    u':woman_playing_water_polo:': u'\U0001F93D\U0000200D\U00002640',
    u':woman_playing_water_polo_dark_skin_tone:': u'\U0001F93D\U0001F3FF\U0000200D\U00002640\U0000FE0F',
    u':woman_playing_water_polo_light_skin_tone:': u'\U0001F93D\U0001F3FB\U0000200D\U00002640\U0000FE0F',
    u':woman_playing_water_polo_medium-dark_skin_tone:': u'\U0001F93D\U0001F3FE\U0000200D\U00002640\U0000FE0F',
    u':woman_playing_water_polo_medium-light_skin_tone:': u'\U0001F93D\U0001F3FC\U0000200D\U00002640\U0000FE0F',
    u':woman_playing_water_polo_medium_skin_tone:': u'\U0001F93D\U0001F3FD\U0000200D\U00002640\U0000FE0F',
    u':woman_playing_water_polo_selector:': u'\U0001F93D\U0000200D\U00002640\U0000FE0F',
    u':woman_police_officer-dark_skin_tone:': u'\U0001F46E\U0001F3FF\U0000200D\U00002640',
    u':woman_police_officer-light_skin_tone:': u'\U0001F46E\U0001F3FB\U0000200D\U00002640',
    u':woman_police_officer-medium-dark_skin_tone:': u'\U0001F46E\U0001F3FE\U0000200D\U00002640',
    u':woman_police_officer-medium-light_skin_tone:': u'\U0001F46E\U0001F3FC\U0000200D\U00002640',
    u':woman_police_officer-medium_skin_tone:': u'\U0001F46E\U0001F3FD\U0000200D\U00002640',
    u':woman_police_officer:': u'\U0001F46E\U0000200D\U00002640',
    u':woman_police_officer_dark_skin_tone:': u'\U0001F46E\U0001F3FF\U0000200D\U00002640\U0000FE0F',
    u':woman_police_officer_light_skin_tone:': u'\U0001F46E\U0001F3FB\U0000200D\U00002640\U0000FE0F',
    u':woman_police_officer_medium-dark_skin_tone:': u'\U0001F46E\U0001F3FE\U0000200D\U00002640\U0000FE0F',
    u':woman_police_officer_medium-light_skin_tone:': u'\U0001F46E\U0001F3FC\U0000200D\U00002640\U0000FE0F',
    u':woman_police_officer_medium_skin_tone:': u'\U0001F46E\U0001F3FD\U0000200D\U00002640\U0000FE0F',
    u':woman_police_officer_selector:': u'\U0001F46E\U0000200D\U00002640\U0000FE0F',
    u':woman_pouting-dark_skin_tone:': u'\U0001F64E\U0001F3FF\U0000200D\U00002640',
    u':woman_pouting-light_skin_tone:': u'\U0001F64E\U0001F3FB\U0000200D\U00002640',
    u':woman_pouting-medium-dark_skin_tone:': u'\U0001F64E\U0001F3FE\U0000200D\U00002640',
    u':woman_pouting-medium-light_skin_tone:': u'\U0001F64E\U0001F3FC\U0000200D\U00002640',
    u':woman_pouting-medium_skin_tone:': u'\U0001F64E\U0001F3FD\U0000200D\U00002640',
    u':woman_pouting:': u'\U0001F64E\U0000200D\U00002640',
    u':woman_pouting_dark_skin_tone:': u'\U0001F64E\U0001F3FF\U0000200D\U00002640\U0000FE0F',
    u':woman_pouting_light_skin_tone:': u'\U0001F64E\U0001F3FB\U0000200D\U00002640\U0000FE0F',
    u':woman_pouting_medium-dark_skin_tone:': u'\U0001F64E\U0001F3FE\U0000200D\U00002640\U0000FE0F',
    u':woman_pouting_medium-light_skin_tone:': u'\U0001F64E\U0001F3FC\U0000200D\U00002640\U0000FE0F',
    u':woman_pouting_medium_skin_tone:': u'\U0001F64E\U0001F3FD\U0000200D\U00002640\U0000FE0F',
    u':woman_pouting_selector:': u'\U0001F64E\U0000200D\U00002640\U0000FE0F',
    u':woman_raising_hand-dark_skin_tone:': u'\U0001F64B\U0001F3FF\U0000200D\U00002640',
    u':woman_raising_hand-light_skin_tone:': u'\U0001F64B\U0001F3FB\U0000200D\U00002640',
    u':woman_raising_hand-medium-dark_skin_tone:': u'\U0001F64B\U0001F3FE\U0000200D\U00002640',
    u':woman_raising_hand-medium-light_skin_tone:': u'\U0001F64B\U0001F3FC\U0000200D\U00002640',
    u':woman_raising_hand-medium_skin_tone:': u'\U0001F64B\U0001F3FD\U0000200D\U00002640',
    u':woman_raising_hand:': u'\U0001F64B\U0000200D\U00002640',
    u':woman_raising_hand_dark_skin_tone:': u'\U0001F64B\U0001F3FF\U0000200D\U00002640\U0000FE0F',
    u':woman_raising_hand_light_skin_tone:': u'\U0001F64B\U0001F3FB\U0000200D\U00002640\U0000FE0F',
    u':woman_raising_hand_medium-dark_skin_tone:': u'\U0001F64B\U0001F3FE\U0000200D\U00002640\U0000FE0F',
    u':woman_raising_hand_medium-light_skin_tone:': u'\U0001F64B\U0001F3FC\U0000200D\U00002640\U0000FE0F',
    u':woman_raising_hand_medium_skin_tone:': u'\U0001F64B\U0001F3FD\U0000200D\U00002640\U0000FE0F',
    u':woman_raising_hand_selector:': u'\U0001F64B\U0000200D\U00002640\U0000FE0F',
    u':woman_rowing_boat-dark_skin_tone:': u'\U0001F6A3\U0001F3FF\U0000200D\U00002640',
    u':woman_rowing_boat-light_skin_tone:': u'\U0001F6A3\U0001F3FB\U0000200D\U00002640',
    u':woman_rowing_boat-medium-dark_skin_tone:': u'\U0001F6A3\U0001F3FE\U0000200D\U00002640',
    u':woman_rowing_boat-medium-light_skin_tone:': u'\U0001F6A3\U0001F3FC\U0000200D\U00002640',
    u':woman_rowing_boat-medium_skin_tone:': u'\U0001F6A3\U0001F3FD\U0000200D\U00002640',
    u':woman_rowing_boat:': u'\U0001F6A3\U0000200D\U00002640',
    u':woman_rowing_boat_dark_skin_tone:': u'\U0001F6A3\U0001F3FF\U0000200D\U00002640\U0000FE0F',
    u':woman_rowing_boat_light_skin_tone:': u'\U0001F6A3\U0001F3FB\U0000200D\U00002640\U0000FE0F',
    u':woman_rowing_boat_medium-dark_skin_tone:': u'\U0001F6A3\U0001F3FE\U0000200D\U00002640\U0000FE0F',
    u':woman_rowing_boat_medium-light_skin_tone:': u'\U0001F6A3\U0001F3FC\U0000200D\U00002640\U0000FE0F',
    u':woman_rowing_boat_medium_skin_tone:': u'\U0001F6A3\U0001F3FD\U0000200D\U00002640\U0000FE0F',
    u':woman_rowing_boat_selector:': u'\U0001F6A3\U0000200D\U00002640\U0000FE0F',
    u':woman_running-dark_skin_tone:': u'\U0001F3C3\U0001F3FF\U0000200D\U00002640',
    u':woman_running-light_skin_tone:': u'\U0001F3C3\U0001F3FB\U0000200D\U00002640',
    u':woman_running-medium-dark_skin_tone:': u'\U0001F3C3\U0001F3FE\U0000200D\U00002640',
    u':woman_running-medium-light_skin_tone:': u'\U0001F3C3\U0001F3FC\U0000200D\U00002640',
    u':woman_running-medium_skin_tone:': u'\U0001F3C3\U0001F3FD\U0000200D\U00002640',
    u':woman_running:': u'\U0001F3C3\U0000200D\U00002640',
    u':woman_running_dark_skin_tone:': u'\U0001F3C3\U0001F3FF\U0000200D\U00002640\U0000FE0F',
    u':woman_running_light_skin_tone:': u'\U0001F3C3\U0001F3FB\U0000200D\U00002640\U0000FE0F',
    u':woman_running_medium-dark_skin_tone:': u'\U0001F3C3\U0001F3FE\U0000200D\U00002640\U0000FE0F',
    u':woman_running_medium-light_skin_tone:': u'\U0001F3C3\U0001F3FC\U0000200D\U00002640\U0000FE0F',
    u':woman_running_medium_skin_tone:': u'\U0001F3C3\U0001F3FD\U0000200D\U00002640\U0000FE0F',
    u':woman_running_selector:': u'\U0001F3C3\U0000200D\U00002640\U0000FE0F',
    u':woman_scientist:': u'\U0001F469\U0000200D\U0001F52C',
    u':woman_scientist_dark_skin_tone:': u'\U0001F469\U0001F3FF\U0000200D\U0001F52C',
    u':woman_scientist_light_skin_tone:': u'\U0001F469\U0001F3FB\U0000200D\U0001F52C',
    u':woman_scientist_medium-dark_skin_tone:': u'\U0001F469\U0001F3FE\U0000200D\U0001F52C',
    u':woman_scientist_medium-light_skin_tone:': u'\U0001F469\U0001F3FC\U0000200D\U0001F52C',
    u':woman_scientist_medium_skin_tone:': u'\U0001F469\U0001F3FD\U0000200D\U0001F52C',
    u':woman_shrugging-dark_skin_tone:': u'\U0001F937\U0001F3FF\U0000200D\U00002640',
    u':woman_shrugging-light_skin_tone:': u'\U0001F937\U0001F3FB\U0000200D\U00002640',
    u':woman_shrugging-medium-dark_skin_tone:': u'\U0001F937\U0001F3FE\U0000200D\U00002640',
    u':woman_shrugging-medium-light_skin_tone:': u'\U0001F937\U0001F3FC\U0000200D\U00002640',
    u':woman_shrugging-medium_skin_tone:': u'\U0001F937\U0001F3FD\U0000200D\U00002640',
    u':woman_shrugging:': u'\U0001F937\U0000200D\U00002640',
    u':woman_shrugging_dark_skin_tone:': u'\U0001F937\U0001F3FF\U0000200D\U00002640\U0000FE0F',
    u':woman_shrugging_light_skin_tone:': u'\U0001F937\U0001F3FB\U0000200D\U00002640\U0000FE0F',
    u':woman_shrugging_medium-dark_skin_tone:': u'\U0001F937\U0001F3FE\U0000200D\U00002640\U0000FE0F',
    u':woman_shrugging_medium-light_skin_tone:': u'\U0001F937\U0001F3FC\U0000200D\U00002640\U0000FE0F',
    u':woman_shrugging_medium_skin_tone:': u'\U0001F937\U0001F3FD\U0000200D\U00002640\U0000FE0F',
    u':woman_shrugging_selector:': u'\U0001F937\U0000200D\U00002640\U0000FE0F',
    u':woman_singer:': u'\U0001F469\U0000200D\U0001F3A4',
    u':woman_singer_dark_skin_tone:': u'\U0001F469\U0001F3FF\U0000200D\U0001F3A4',
    u':woman_singer_light_skin_tone:': u'\U0001F469\U0001F3FB\U0000200D\U0001F3A4',
    u':woman_singer_medium-dark_skin_tone:': u'\U0001F469\U0001F3FE\U0000200D\U0001F3A4',
    u':woman_singer_medium-light_skin_tone:': u'\U0001F469\U0001F3FC\U0000200D\U0001F3A4',
    u':woman_singer_medium_skin_tone:': u'\U0001F469\U0001F3FD\U0000200D\U0001F3A4',
    u':woman_standing-dark_skin_tone:': u'\U0001F9CD\U0001F3FF\U0000200D\U00002640',
    u':woman_standing-dark_skin_tone_selector:': u'\U0001F9CD\U0001F3FF\U0000200D\U00002640\U0000FE0F',
    u':woman_standing-light_skin_tone:': u'\U0001F9CD\U0001F3FB\U0000200D\U00002640',
    u':woman_standing-light_skin_tone_selector:': u'\U0001F9CD\U0001F3FB\U0000200D\U00002640\U0000FE0F',
    u':woman_standing-medium-dark_skin_tone:': u'\U0001F9CD\U0001F3FE\U0000200D\U00002640',
    u':woman_standing-medium-dark_skin_tone_selector:': u'\U0001F9CD\U0001F3FE\U0000200D\U00002640\U0000FE0F',
    u':woman_standing-medium-light_skin_tone:': u'\U0001F9CD\U0001F3FC\U0000200D\U00002640',
    u':woman_standing-medium-light_skin_tone_selector:': u'\U0001F9CD\U0001F3FC\U0000200D\U00002640\U0000FE0F',
    u':woman_standing-medium_skin_tone:': u'\U0001F9CD\U0001F3FD\U0000200D\U00002640',
    u':woman_standing-medium_skin_tone_selector:': u'\U0001F9CD\U0001F3FD\U0000200D\U00002640\U0000FE0F',
    u':woman_standing:': u'\U0001F9CD\U0000200D\U00002640',
    u':woman_standing_selector:': u'\U0001F9CD\U0000200D\U00002640\U0000FE0F',
    u':woman_student:': u'\U0001F469\U0000200D\U0001F393',
    u':woman_student_dark_skin_tone:': u'\U0001F469\U0001F3FF\U0000200D\U0001F393',
    u':woman_student_light_skin_tone:': u'\U0001F469\U0001F3FB\U0000200D\U0001F393',
    u':woman_student_medium-dark_skin_tone:': u'\U0001F469\U0001F3FE\U0000200D\U0001F393',
    u':woman_student_medium-light_skin_tone:': u'\U0001F469\U0001F3FC\U0000200D\U0001F393',
    u':woman_student_medium_skin_tone:': u'\U0001F469\U0001F3FD\U0000200D\U0001F393',
    u':woman_superhero-dark_skin_tone:': u'\U0001F9B8\U0001F3FF\U0000200D\U00002640',
    u':woman_superhero-dark_skin_tone_selector:': u'\U0001F9B8\U0001F3FF\U0000200D\U00002640\U0000FE0F',
    u':woman_superhero-light_skin_tone:': u'\U0001F9B8\U0001F3FB\U0000200D\U00002640',
    u':woman_superhero-light_skin_tone_selector:': u'\U0001F9B8\U0001F3FB\U0000200D\U00002640\U0000FE0F',
    u':woman_superhero-medium-dark_skin_tone:': u'\U0001F9B8\U0001F3FE\U0000200D\U00002640',
    u':woman_superhero-medium-dark_skin_tone_selector:': u'\U0001F9B8\U0001F3FE\U0000200D\U00002640\U0000FE0F',
    u':woman_superhero-medium-light_skin_tone:': u'\U0001F9B8\U0001F3FC\U0000200D\U00002640',
    u':woman_superhero-medium-light_skin_tone_selector:': u'\U0001F9B8\U0001F3FC\U0000200D\U00002640\U0000FE0F',
    u':woman_superhero-medium_skin_tone:': u'\U0001F9B8\U0001F3FD\U0000200D\U00002640',
    u':woman_superhero-medium_skin_tone_selector:': u'\U0001F9B8\U0001F3FD\U0000200D\U00002640\U0000FE0F',
    u':woman_superhero:': u'\U0001F9B8\U0000200D\U00002640',
    u':woman_superhero_selector:': u'\U0001F9B8\U0000200D\U00002640\U0000FE0F',
    u':woman_supervillain-dark_skin_tone:': u'\U0001F9B9\U0001F3FF\U0000200D\U00002640',
    u':woman_supervillain-dark_skin_tone_selector:': u'\U0001F9B9\U0001F3FF\U0000200D\U00002640\U0000FE0F',
    u':woman_supervillain-light_skin_tone:': u'\U0001F9B9\U0001F3FB\U0000200D\U00002640',
    u':woman_supervillain-light_skin_tone_selector:': u'\U0001F9B9\U0001F3FB\U0000200D\U00002640\U0000FE0F',
    u':woman_supervillain-medium-dark_skin_tone:': u'\U0001F9B9\U0001F3FE\U0000200D\U00002640',
    u':woman_supervillain-medium-dark_skin_tone_selector:': u'\U0001F9B9\U0001F3FE\U0000200D\U00002640\U0000FE0F',
    u':woman_supervillain-medium-light_skin_tone:': u'\U0001F9B9\U0001F3FC\U0000200D\U00002640',
    u':woman_supervillain-medium-light_skin_tone_selector:': u'\U0001F9B9\U0001F3FC\U0000200D\U00002640\U0000FE0F',
    u':woman_supervillain-medium_skin_tone:': u'\U0001F9B9\U0001F3FD\U0000200D\U00002640',
    u':woman_supervillain-medium_skin_tone_selector:': u'\U0001F9B9\U0001F3FD\U0000200D\U00002640\U0000FE0F',
    u':woman_supervillain:': u'\U0001F9B9\U0000200D\U00002640',
    u':woman_supervillain_selector:': u'\U0001F9B9\U0000200D\U00002640\U0000FE0F',
    u':woman_surfing-dark_skin_tone:': u'\U0001F3C4\U0001F3FF\U0000200D\U00002640',
    u':woman_surfing-light_skin_tone:': u'\U0001F3C4\U0001F3FB\U0000200D\U00002640',
    u':woman_surfing-medium-dark_skin_tone:': u'\U0001F3C4\U0001F3FE\U0000200D\U00002640',
    u':woman_surfing-medium-light_skin_tone:': u'\U0001F3C4\U0001F3FC\U0000200D\U00002640',
    u':woman_surfing-medium_skin_tone:': u'\U0001F3C4\U0001F3FD\U0000200D\U00002640',
    u':woman_surfing:': u'\U0001F3C4\U0000200D\U00002640',
    u':woman_surfing_dark_skin_tone:': u'\U0001F3C4\U0001F3FF\U0000200D\U00002640\U0000FE0F',
    u':woman_surfing_light_skin_tone:': u'\U0001F3C4\U0001F3FB\U0000200D\U00002640\U0000FE0F',
    u':woman_surfing_medium-dark_skin_tone:': u'\U0001F3C4\U0001F3FE\U0000200D\U00002640\U0000FE0F',
    u':woman_surfing_medium-light_skin_tone:': u'\U0001F3C4\U0001F3FC\U0000200D\U00002640\U0000FE0F',
    u':woman_surfing_medium_skin_tone:': u'\U0001F3C4\U0001F3FD\U0000200D\U00002640\U0000FE0F',
    u':woman_surfing_selector:': u'\U0001F3C4\U0000200D\U00002640\U0000FE0F',
    u':woman_swimming-dark_skin_tone:': u'\U0001F3CA\U0001F3FF\U0000200D\U00002640',
    u':woman_swimming-light_skin_tone:': u'\U0001F3CA\U0001F3FB\U0000200D\U00002640',
    u':woman_swimming-medium-dark_skin_tone:': u'\U0001F3CA\U0001F3FE\U0000200D\U00002640',
    u':woman_swimming-medium-light_skin_tone:': u'\U0001F3CA\U0001F3FC\U0000200D\U00002640',
    u':woman_swimming-medium_skin_tone:': u'\U0001F3CA\U0001F3FD\U0000200D\U00002640',
    u':woman_swimming:': u'\U0001F3CA\U0000200D\U00002640',
    u':woman_swimming_dark_skin_tone:': u'\U0001F3CA\U0001F3FF\U0000200D\U00002640\U0000FE0F',
    u':woman_swimming_light_skin_tone:': u'\U0001F3CA\U0001F3FB\U0000200D\U00002640\U0000FE0F',
    u':woman_swimming_medium-dark_skin_tone:': u'\U0001F3CA\U0001F3FE\U0000200D\U00002640\U0000FE0F',
    u':woman_swimming_medium-light_skin_tone:': u'\U0001F3CA\U0001F3FC\U0000200D\U00002640\U0000FE0F',
    u':woman_swimming_medium_skin_tone:': u'\U0001F3CA\U0001F3FD\U0000200D\U00002640\U0000FE0F',
    u':woman_swimming_selector:': u'\U0001F3CA\U0000200D\U00002640\U0000FE0F',
    u':woman_teacher:': u'\U0001F469\U0000200D\U0001F3EB',
    u':woman_teacher_dark_skin_tone:': u'\U0001F469\U0001F3FF\U0000200D\U0001F3EB',
    u':woman_teacher_light_skin_tone:': u'\U0001F469\U0001F3FB\U0000200D\U0001F3EB',
    u':woman_teacher_medium-dark_skin_tone:': u'\U0001F469\U0001F3FE\U0000200D\U0001F3EB',
    u':woman_teacher_medium-light_skin_tone:': u'\U0001F469\U0001F3FC\U0000200D\U0001F3EB',
    u':woman_teacher_medium_skin_tone:': u'\U0001F469\U0001F3FD\U0000200D\U0001F3EB',
    u':woman_technologist:': u'\U0001F469\U0000200D\U0001F4BB',
    u':woman_technologist_dark_skin_tone:': u'\U0001F469\U0001F3FF\U0000200D\U0001F4BB',
    u':woman_technologist_light_skin_tone:': u'\U0001F469\U0001F3FB\U0000200D\U0001F4BB',
    u':woman_technologist_medium-dark_skin_tone:': u'\U0001F469\U0001F3FE\U0000200D\U0001F4BB',
    u':woman_technologist_medium-light_skin_tone:': u'\U0001F469\U0001F3FC\U0000200D\U0001F4BB',
    u':woman_technologist_medium_skin_tone:': u'\U0001F469\U0001F3FD\U0000200D\U0001F4BB',
    u':woman_tipping_hand-dark_skin_tone:': u'\U0001F481\U0001F3FF\U0000200D\U00002640',
    u':woman_tipping_hand-light_skin_tone:': u'\U0001F481\U0001F3FB\U0000200D\U00002640',
    u':woman_tipping_hand-medium-dark_skin_tone:': u'\U0001F481\U0001F3FE\U0000200D\U00002640',
    u':woman_tipping_hand-medium-light_skin_tone:': u'\U0001F481\U0001F3FC\U0000200D\U00002640',
    u':woman_tipping_hand-medium_skin_tone:': u'\U0001F481\U0001F3FD\U0000200D\U00002640',
    u':woman_tipping_hand:': u'\U0001F481\U0000200D\U00002640',
    u':woman_tipping_hand_dark_skin_tone:': u'\U0001F481\U0001F3FF\U0000200D\U00002640\U0000FE0F',
    u':woman_tipping_hand_light_skin_tone:': u'\U0001F481\U0001F3FB\U0000200D\U00002640\U0000FE0F',
    u':woman_tipping_hand_medium-dark_skin_tone:': u'\U0001F481\U0001F3FE\U0000200D\U00002640\U0000FE0F',
    u':woman_tipping_hand_medium-light_skin_tone:': u'\U0001F481\U0001F3FC\U0000200D\U00002640\U0000FE0F',
    u':woman_tipping_hand_medium_skin_tone:': u'\U0001F481\U0001F3FD\U0000200D\U00002640\U0000FE0F',
    u':woman_tipping_hand_selector:': u'\U0001F481\U0000200D\U00002640\U0000FE0F',
    u':woman_vampire-dark_skin_tone:': u'\U0001F9DB\U0001F3FF\U0000200D\U00002640',
    u':woman_vampire-light_skin_tone:': u'\U0001F9DB\U0001F3FB\U0000200D\U00002640',
    u':woman_vampire-medium-dark_skin_tone:': u'\U0001F9DB\U0001F3FE\U0000200D\U00002640',
    u':woman_vampire-medium-light_skin_tone:': u'\U0001F9DB\U0001F3FC\U0000200D\U00002640',
    u':woman_vampire-medium_skin_tone:': u'\U0001F9DB\U0001F3FD\U0000200D\U00002640',
    u':woman_vampire:': u'\U0001F9DB\U0000200D\U00002640',
    u':woman_vampire_dark_skin_tone:': u'\U0001F9DB\U0001F3FF\U0000200D\U00002640\U0000FE0F',
    u':woman_vampire_light_skin_tone:': u'\U0001F9DB\U0001F3FB\U0000200D\U00002640\U0000FE0F',
    u':woman_vampire_medium-dark_skin_tone:': u'\U0001F9DB\U0001F3FE\U0000200D\U00002640\U0000FE0F',
    u':woman_vampire_medium-light_skin_tone:': u'\U0001F9DB\U0001F3FC\U0000200D\U00002640\U0000FE0F',
    u':woman_vampire_medium_skin_tone:': u'\U0001F9DB\U0001F3FD\U0000200D\U00002640\U0000FE0F',
    u':woman_vampire_selector:': u'\U0001F9DB\U0000200D\U00002640\U0000FE0F',
    u':woman_walking-dark_skin_tone:': u'\U0001F6B6\U0001F3FF\U0000200D\U00002640',
    u':woman_walking-light_skin_tone:': u'\U0001F6B6\U0001F3FB\U0000200D\U00002640',
    u':woman_walking-medium-dark_skin_tone:': u'\U0001F6B6\U0001F3FE\U0000200D\U00002640',
    u':woman_walking-medium-light_skin_tone:': u'\U0001F6B6\U0001F3FC\U0000200D\U00002640',
    u':woman_walking-medium_skin_tone:': u'\U0001F6B6\U0001F3FD\U0000200D\U00002640',
    u':woman_walking:': u'\U0001F6B6\U0000200D\U00002640',
    u':woman_walking_dark_skin_tone:': u'\U0001F6B6\U0001F3FF\U0000200D\U00002640\U0000FE0F',
    u':woman_walking_light_skin_tone:': u'\U0001F6B6\U0001F3FB\U0000200D\U00002640\U0000FE0F',
    u':woman_walking_medium-dark_skin_tone:': u'\U0001F6B6\U0001F3FE\U0000200D\U00002640\U0000FE0F',
    u':woman_walking_medium-light_skin_tone:': u'\U0001F6B6\U0001F3FC\U0000200D\U00002640\U0000FE0F',
    u':woman_walking_medium_skin_tone:': u'\U0001F6B6\U0001F3FD\U0000200D\U00002640\U0000FE0F',
    u':woman_walking_selector:': u'\U0001F6B6\U0000200D\U00002640\U0000FE0F',
    u':woman_wearing_turban-dark_skin_tone:': u'\U0001F473\U0001F3FF\U0000200D\U00002640',
    u':woman_wearing_turban-light_skin_tone:': u'\U0001F473\U0001F3FB\U0000200D\U00002640',
    u':woman_wearing_turban-medium-dark_skin_tone:': u'\U0001F473\U0001F3FE\U0000200D\U00002640',
    u':woman_wearing_turban-medium-light_skin_tone:': u'\U0001F473\U0001F3FC\U0000200D\U00002640',
    u':woman_wearing_turban-medium_skin_tone:': u'\U0001F473\U0001F3FD\U0000200D\U00002640',
    u':woman_wearing_turban:': u'\U0001F473\U0000200D\U00002640',
    u':woman_wearing_turban_dark_skin_tone:': u'\U0001F473\U0001F3FF\U0000200D\U00002640\U0000FE0F',
    u':woman_wearing_turban_light_skin_tone:': u'\U0001F473\U0001F3FB\U0000200D\U00002640\U0000FE0F',
    u':woman_wearing_turban_medium-dark_skin_tone:': u'\U0001F473\U0001F3FE\U0000200D\U00002640\U0000FE0F',
    u':woman_wearing_turban_medium-light_skin_tone:': u'\U0001F473\U0001F3FC\U0000200D\U00002640\U0000FE0F',
    u':woman_wearing_turban_medium_skin_tone:': u'\U0001F473\U0001F3FD\U0000200D\U00002640\U0000FE0F',
    u':woman_wearing_turban_selector:': u'\U0001F473\U0000200D\U00002640\U0000FE0F',
    u':woman_with_headscarf:': u'\U0001F9D5',
    u':woman_with_headscarf_dark_skin_tone:': u'\U0001F9D5\U0001F3FF',
    u':woman_with_headscarf_light_skin_tone:': u'\U0001F9D5\U0001F3FB',
    u':woman_with_headscarf_medium-dark_skin_tone:': u'\U0001F9D5\U0001F3FE',
    u':woman_with_headscarf_medium-light_skin_tone:': u'\U0001F9D5\U0001F3FC',
    u':woman_with_headscarf_medium_skin_tone:': u'\U0001F9D5\U0001F3FD',
    u':woman_with_probing_cane-dark_skin_tone:': u'\U0001F469\U0001F3FF\U0000200D\U0001F9AF',
    u':woman_with_probing_cane-light_skin_tone:': u'\U0001F469\U0001F3FB\U0000200D\U0001F9AF',
    u':woman_with_probing_cane-medium-dark_skin_tone:': u'\U0001F469\U0001F3FE\U0000200D\U0001F9AF',
    u':woman_with_probing_cane-medium-light_skin_tone:': u'\U0001F469\U0001F3FC\U0000200D\U0001F9AF',
    u':woman_with_probing_cane-medium_skin_tone:': u'\U0001F469\U0001F3FD\U0000200D\U0001F9AF',
    u':woman_with_probing_cane:': u'\U0001F469\U0000200D\U0001F9AF',
    u':woman_zombie:': u'\U0001F9DF\U0000200D\U00002640',
    u':woman_zombie_selector:': u'\U0001F9DF\U0000200D\U00002640\U0000FE0F',
    u':woman\u2019s_boot:': u'\U0001F462',
    u':woman\u2019s_clothes:': u'\U0001F45A',
    u':woman\u2019s_hat:': u'\U0001F452',
    u':woman\u2019s_sandal:': u'\U0001F461',
    u':women_holding_hands-dark_skin_tone-light_skin_tone:': u'\U0001F469\U0001F3FF\U0000200D\U0001F91D\U0000200D\U0001F469\U0001F3FB',
    u':women_holding_hands-dark_skin_tone-medium-dark_skin_tone:': u'\U0001F469\U0001F3FF\U0000200D\U0001F91D\U0000200D\U0001F469\U0001F3FE',
    u':women_holding_hands-dark_skin_tone-medium-light_skin_tone:': u'\U0001F469\U0001F3FF\U0000200D\U0001F91D\U0000200D\U0001F469\U0001F3FC',
    u':women_holding_hands-dark_skin_tone-medium_skin_tone:': u'\U0001F469\U0001F3FF\U0000200D\U0001F91D\U0000200D\U0001F469\U0001F3FD',
    u':women_holding_hands-dark_skin_tone:': u'\U0001F46D\U0001F3FF',
    u':women_holding_hands-light_skin_tone:': u'\U0001F46D\U0001F3FB',
    u':women_holding_hands-medium-dark_skin_tone-light_skin_tone:': u'\U0001F469\U0001F3FE\U0000200D\U0001F91D\U0000200D\U0001F469\U0001F3FB',
    u':women_holding_hands-medium-dark_skin_tone-medium-light_skin_tone:': u'\U0001F469\U0001F3FE\U0000200D\U0001F91D\U0000200D\U0001F469\U0001F3FC',
    u':women_holding_hands-medium-dark_skin_tone-medium_skin_tone:': u'\U0001F469\U0001F3FE\U0000200D\U0001F91D\U0000200D\U0001F469\U0001F3FD',
    u':women_holding_hands-medium-dark_skin_tone:': u'\U0001F46D\U0001F3FE',
    u':women_holding_hands-medium-light_skin_tone-light_skin_tone:': u'\U0001F469\U0001F3FC\U0000200D\U0001F91D\U0000200D\U0001F469\U0001F3FB',
    u':women_holding_hands-medium-light_skin_tone:': u'\U0001F46D\U0001F3FC',
    u':women_holding_hands-medium_skin_tone-light_skin_tone:': u'\U0001F469\U0001F3FD\U0000200D\U0001F91D\U0000200D\U0001F469\U0001F3FB',
    u':women_holding_hands-medium_skin_tone-medium-light_skin_tone:': u'\U0001F469\U0001F3FD\U0000200D\U0001F91D\U0000200D\U0001F469\U0001F3FC',
    u':women_holding_hands-medium_skin_tone:': u'\U0001F46D\U0001F3FD',
    u':women_with_bunny_ears:': u'\U0001F46F\U0000200D\U00002640',
    u':women_with_bunny_ears_selector:': u'\U0001F46F\U0000200D\U00002640\U0000FE0F',
    u':women_wrestling:': u'\U0001F93C\U0000200D\U00002640',
    u':women_wrestling_selector:': u'\U0001F93C\U0000200D\U00002640\U0000FE0F',
    u':women\u2019s_room:': u'\U0001F6BA',
    u':woozy_face:': u'\U0001F974',
    u':world_map:': u'\U0001F5FA',
    u':world_map_selector:': u'\U0001F5FA\U0000FE0F',
    u':worried_face:': u'\U0001F61F',
    u':wrapped_gift:': u'\U0001F381',
    u':wrench:': u'\U0001F527',
    u':writing_hand:': u'\U0000270D',
    u':writing_hand_dark_skin_tone:': u'\U0000270D\U0001F3FF',
    u':writing_hand_light_skin_tone:': u'\U0000270D\U0001F3FB',
    u':writing_hand_medium-dark_skin_tone:': u'\U0000270D\U0001F3FE',
    u':writing_hand_medium-light_skin_tone:': u'\U0000270D\U0001F3FC',
    u':writing_hand_medium_skin_tone:': u'\U0000270D\U0001F3FD',
    u':writing_hand_selector:': u'\U0000270D\U0000FE0F',
    u':yarn:': u'\U0001F9F6',
    u':yawning_face:': u'\U0001F971',
    u':yellow_circle:': u'\U0001F7E1',
    u':yellow_heart:': u'\U0001F49B',
    u':yellow_square:': u'\U0001F7E8',
    u':yen_banknote:': u'\U0001F4B4',
    u':yin_yang:': u'\U0000262F',
    u':yin_yang_selector:': u'\U0000262F\U0000FE0F',
    u':yo-yo:': u'\U0001FA80',
    u':zany_face:': u'\U0001F92A',
    u':zebra:': u'\U0001F993',
    u':zipper-mouth_face:': u'\U0001F910',
    u':zombie:': u'\U0001F9DF',
    u':zzz:': u'\U0001F4A4',
}

EMOJI_EN = {v: k for k, v in EN_EMOJI.items()}

# There may be multiple emojis corresponding to one Chinese character
EMOJI_ZH = {
    u"\U0001F947": ":\u91d1\u724c:",
    u"\U0001F948": ":\u94f6\u724c:",
    u"\U0001F949": ":\u94dc\u724c:",
    u"\U0001F18E": ":AB\u6309\u94ae\uff08\u8840\u578b\uff09:",
    u"\U0001F3E7": ":ATM\u6807\u5fd7:",
    u"\U0001F170": ":\u6309\u94ae\uff08\u8840\u578b\uff09:",
    u"\U0001F170\U0000FE0F": ":\u6309\u94ae\uff08\u8840\u578b\uff09:",
    u"\U0001F1E6\U0001F1EB": ":\u963f\u5bcc\u6c57:",
    u"\U0001F1E6\U0001F1FD": ":\u963f\u5170\u7fa4\u5c9b:",
    u"\U0001F1E6\U0001F1F1": ":\u963f\u5c14\u5df4\u5c3c\u4e9a:",
    u"\U0001F1E9\U0001F1FF": ":\u963f\u5c14\u53ca\u5229\u4e9a:",
    u"\U0001F1E6\U0001F1F8": ":\u7f8e\u5c5e\u8428\u6469\u4e9a:",
    u"\U0001F1E6\U0001F1E9": ":\u5b89\u9053\u5c14:",
    u"\U0001F1E6\U0001F1F4": ":\u5b89\u54e5\u62c9:",
    u"\U0001F1E6\U0001F1EE": ":\u5b89\u572d\u62c9:",
    u"\U0001F1E6\U0001F1F6": ":\u5357\u6781\u6d32:",
    u"\U0001F1E6\U0001F1EC": ":\u5b89\u63d0\u74dc\u548c\u5df4\u5e03\u8fbe:",
    u"\U00002652": ":\u6c34\u74f6\u5ea7:",
    u"\U0001F1E6\U0001F1F7": ":\u963f\u6839\u5ef7:",
    u"\U00002648": ":\u767d\u7f8a\u5ea7:",
    u"\U0001F1E6\U0001F1F2": ":\u4e9a\u7f8e\u5c3c\u4e9a:",
    u"\U0001F1E6\U0001F1FC": ":\u963f\u9c81\u5df4:",
    u"\U0001F1E6\U0001F1E8": ":\u963f\u68ee\u677e\u5c9b:",
    u"\U0001F1E6\U0001F1FA": ":\u6fb3\u5927\u5229\u4e9a:",
    u"\U0001F1E6\U0001F1F9": ":\u5965\u5730\u5229:",
    u"\U0001F1E6\U0001F1FF": ":\u963f\u585e\u62dc\u7586:",
    u"\U0001F519": ":\u540e\u9000\u7bad\u5934:",
    u"\U0001F171": ":B\u6309\u94ae\uff08\u8840\u578b\uff09:",
    u"\U0001F171\U0000FE0F": ":B\u6309\u94ae\uff08\u8840\u578b\uff09:",
    u"\U0001F1E7\U0001F1F8": ":\u5df4\u54c8\u9a6c:",
    u"\U0001F1E7\U0001F1ED": ":\u5df4\u6797:",
    u"\U0001F1E7\U0001F1E9": ":\u5b5f\u52a0\u62c9\u56fd:",
    u"\U0001F1E7\U0001F1E7": ":\u5df4\u5df4\u591a\u65af:",
    u"\U0001F1E7\U0001F1FE": ":\u767d\u4fc4\u7f57\u65af:",
    u"\U0001F1E7\U0001F1EA": ":\u6bd4\u5229\u65f6:",
    u"\U0001F1E7\U0001F1FF": ":\u4f2f\u5229\u5179:",
    u"\U0001F1E7\U0001F1EF": ":\u8d1d\u5b81:",
    u"\U0001F1E7\U0001F1F2": ":\u767e\u6155\u5927\u7fa4\u5c9b:",
    u"\U0001F1E7\U0001F1F9": ":\u4e0d\u4e39:",
    u"\U0001F1E7\U0001F1F4": ":\u73bb\u5229\u7ef4\u4e9a:",
    u"\U0001F1E7\U0001F1E6": ":\u6ce2\u65af\u5c3c\u4e9a\u548c\u9ed1\u585e\u54e5\u7ef4\u90a3:",
    u"\U0001F1E7\U0001F1FC": ":\u535a\u8328\u74e6\u7eb3:",
    u"\U0001F1E7\U0001F1FB": ":\u5e03\u97e6\u5c9b:",
    u"\U0001F1E7\U0001F1F7": ":\u5df4\u897f:",
    u"\U0001F1EE\U0001F1F4": ":\u82f1\u5c5e\u5370\u5ea6\u6d0b\u9886\u571f:",
    u"\U0001F1FB\U0001F1EC": ":\u82f1\u5c5e\u7ef4\u5c14\u4eac\u7fa4\u5c9b:",
    u"\U0001F1E7\U0001F1F3": ":\u6587\u83b1:",
    u"\U0001F1E7\U0001F1EC": ":\u4fdd\u52a0\u5229\u4e9a:",
    u"\U0001F1E7\U0001F1EB": ":\u5e03\u57fa\u7eb3\u6cd5\u7d22:",
    u"\U0001F1E7\U0001F1EE": ":\u5e03\u9686\u8fea:",
    u"\U0001F191": ":CL\u6309\u94ae:",
    u"\U0001F192": ":\u51b7\u5374\u6309\u94ae:",
    u"\U0001F1F0\U0001F1ED": ":\u67ec\u57d4\u5be8:",
    u"\U0001F1E8\U0001F1F2": ":\u5580\u9ea6\u9686:",
    u"\U0001F1E8\U0001F1E6": ":\u52a0\u62ff\u5927:",
    u"\U0001F1EE\U0001F1E8": ":\u52a0\u90a3\u5229\u7fa4\u5c9b:",
    u"\U0000264B": ":\u764c\u75c7:",
    u"\U0001F1E8\U0001F1FB": ":\u4f5b\u5f97\u89d2:",
    u"\U00002651": ":\u6469\u7faf\u5ea7:",
    u"\U0001F1E7\U0001F1F6": ":\u8377\u5170\u52a0\u52d2\u6bd4\u533a:",
    u"\U0001F1F0\U0001F1FE": ":\u5f00\u66fc\u7fa4\u5c9b:",
    u"\U0001F1E8\U0001F1EB": ":\u4e2d\u975e\u5171\u548c\u56fd:",
    u"\U0001F1EA\U0001F1E6": ":\u4f11\u8fbe\u548c\u6885\u5229\u62c9:",
    u"\U0001F1F9\U0001F1E9": ":\u4e4d\u5f97:",
    u"\U0001F1E8\U0001F1F1": ":\u667a\u5229:",
    u"\U0001F1E8\U0001F1F3": ":\u4e2d\u56fd:",
    u"\U0001F1E8\U0001F1FD": ":\u5723\u8bde\u5c9b:",
    u"\U0001F384": ":\u5723\u8bde\u6811:",
    u"\U0001F1E8\U0001F1F5": ":\u514b\u5229\u73c0\u987f\u5c9b:",
    u"\U0001F1E8\U0001F1E8": ":\u79d1\u79d1\u65af\uff08\u57fa\u6797\uff09\u7fa4\u5c9b:",
    u"\U0001F1E8\U0001F1F4": ":\u54e5\u4f26\u6bd4\u4e9a:",
    u"\U0001F1F0\U0001F1F2": ":\u79d1\u6469\u7f57:",
    u"\U0001F1E8\U0001F1EC": ":\u521a\u679c-\u5e03\u62c9\u67f4\u7ef4\u5c14:",
    u"\U0001F1E8\U0001F1E9": ":\u521a\u679c-\u91d1\u6c99\u8428:",
    u"\U0001F1E8\U0001F1F0": ":\u5e93\u514b\u7fa4\u5c9b:",
    u"\U0001F1E8\U0001F1F7": ":\u54e5\u65af\u8fbe\u9ece\u52a0:",
    u"\U0001F1ED\U0001F1F7": ":\u514b\u7f57\u5730\u4e9a:",
    u"\U0001F1E8\U0001F1FA": ":\u53e4\u5df4:",
    u"\U0001F1E8\U0001F1FC": ":\u5e93\u62c9\u7d22\u5c9b:",
    u"\U0001F1E8\U0001F1FE": ":\u585e\u6d66\u8def\u65af:",
    u"\U0001F1E8\U0001F1FF": ":\u6377\u514b:",
    u"\U0001F1E8\U0001F1EE": ":\u79d1\u7279\u8fea\u74e6:",
    u"\U0001F1E9\U0001F1F0": ":\u4e39\u9ea6:",
    u"\U0001F1E9\U0001F1EC": ":\u8fed\u6208\u00b7\u52a0\u897f\u4e9a:",
    u"\U0001F1E9\U0001F1EF": ":\u5409\u5e03\u63d0:",
    u"\U0001F1E9\U0001F1F2": ":\u591a\u7c73\u5c3c\u52a0:",
    u"\U0001F1E9\U0001F1F4": ":\u591a\u7c73\u5c3c\u52a0\u5171\u548c\u56fd:",
    u"\U0001F51A": ":\u7ed3\u675f\u7bad\u5934:",
    u"\U0001F1EA\U0001F1E8": ":\u5384\u74dc\u591a\u5c14:",
    u"\U0001F1EA\U0001F1EC": ":\u57c3\u53ca:",
    u"\U0001F1F8\U0001F1FB": ":\u8428\u5c14\u74e6\u591a:",
    u"\U0001F3F4\U000E0067\U000E0062\U000E0065\U000E006E\U000E0067\U000E007F": ":\u82f1\u683c\u5170:",
    u"\U0001F1EC\U0001F1F6": ":\u8d64\u9053\u51e0\u5185\u4e9a:",
    u"\U0001F1EA\U0001F1F7": ":\u5384\u7acb\u7279\u91cc\u4e9a:",
    u"\U0001F1EA\U0001F1EA": ":\u7231\u6c99\u5c3c\u4e9a:",
    u"\U0001F1EA\U0001F1F9": ":\u57c3\u585e\u4fc4\u6bd4\u4e9a:",
    u"\U0001F1EA\U0001F1FA": ":\u6b27\u6d32\u8054\u76df:",
    u"\U0001F193": ":\u81ea\u7531\u6309\u94ae:",
    u"\U0001F1EB\U0001F1F0": ":\u798f\u514b\u5170\u7fa4\u5c9b:",
    u"\U0001F1EB\U0001F1F4": ":\u6cd5\u7f57\u7fa4\u5c9b:",
    u"\U0001F1EB\U0001F1EF": ":\u6590\u6d4e:",
    u"\U0001F1EB\U0001F1EE": ":\u82ac\u5170:",
    u"\U0001F1EB\U0001F1F7": ":\u6cd5\u56fd:",
    u"\U0001F1EC\U0001F1EB": ":\u6cd5\u5c5e\u572d\u4e9a\u90a3:",
    u"\U0001F1F5\U0001F1EB": ":\u6cd5\u5c5e\u6ce2\u5229\u5c3c\u897f\u4e9a:",
    u"\U0001F1F9\U0001F1EB": ":\u6cd5\u5c5e\u5357\u90e8\u9886\u5730:",
    u"\U0001F1EC\U0001F1E6": ":\u52a0\u84ec:",
    u"\U0001F1EC\U0001F1F2": ":\u5188\u6bd4\u4e9a:",
    u"\U0000264A": ":\u53cc\u5b50\u5ea7:",
    u"\U0001F1EC\U0001F1EA": ":\u4f50\u6cbb\u4e9a\u5dde:",
    u"\U0001F1E9\U0001F1EA": ":\u5fb7\u56fd:",
    u"\U0001F1EC\U0001F1ED": ":\u52a0\u7eb3:",
    u"\U0001F1EC\U0001F1EE": ":\u76f4\u5e03\u7f57\u9640:",
    u"\U0001F1EC\U0001F1F7": ":\u5e0c\u814a:",
    u"\U0001F1EC\U0001F1F1": ":\u683c\u9675\u5170\u5c9b:",
    u"\U0001F1EC\U0001F1E9": ":\u683c\u6797\u7eb3\u8fbe:",
    u"\U0001F1EC\U0001F1F5": ":\u74dc\u5fb7\u7f57\u666e\u5c9b:",
    u"\U0001F1EC\U0001F1FA": ":\u5173\u5c9b:",
    u"\U0001F1EC\U0001F1F9": ":\u5371\u5730\u9a6c\u62c9:",
    u"\U0001F1EC\U0001F1EC": ":\u6839\u897f\u5c9b:",
    u"\U0001F1EC\U0001F1FC": ":\u51e0\u5185\u4e9a\u6bd4\u7ecd:",
    u"\U0001F1EC\U0001F1F3": ":\u51e0\u5185\u4e9a:",
    u"\U0001F1EC\U0001F1FE": ":\u572d\u4e9a\u90a3:",
    u"\U0001F1ED\U0001F1F9": ":\u6d77\u5730:",
    u"\U0001F1ED\U0001F1F2": ":\u8d6b\u5fb7\u548c\u9ea6\u514b\u5510\u7eb3\u7fa4\u5c9b:",
    u"\U0001F1ED\U0001F1F3": ":\u6d2a\u90fd\u62c9\u65af:",
    u"\U0001F1ED\U0001F1F0": ":\u9999\u6e2f\u7279\u522b\u884c\u653f\u533a\u4e2d\u56fd:",
    u"\U0001F1ED\U0001F1FA": ":\u5308\u7259\u5229:",
    u"\U0001F194": ":ID\u6309\u94ae:",
    u"\U0001F1EE\U0001F1F8": ":\u51b0\u5c9b:",
    u"\U0001F1EE\U0001F1F3": ":\u5370\u5ea6:",
    u"\U0001F1EE\U0001F1E9": ":\u5370\u5ea6\u5c3c\u897f\u4e9a:",
    u"\U0001F1EE\U0001F1F7": ":\u4f0a\u6717:",
    u"\U0001F1EE\U0001F1F6": ":\u4f0a\u62c9\u514b:",
    u"\U0001F1EE\U0001F1EA": ":\u7231\u5c14\u5170:",
    u"\U0001F1EE\U0001F1F2": ":\u9a6c\u6069\u5c9b:",
    u"\U0001F1EE\U0001F1F1": ":\u4ee5\u8272\u5217:",
    u"\U0001F1EE\U0001F1F9": ":\u610f\u5927\u5229:",
    u"\U0001F1EF\U0001F1F2": ":\u7259\u4e70\u52a0:",
    u"\U0001F1EF\U0001F1F5": ":\u65e5\u672c:",
    u"\U0001F251": ":\u65e5\u8bed\u53ef\u63a5\u53d7\u6309\u94ae:",
    u"\U0001F238": ":\u65e5\u8bed\u5e94\u7528\u7a0b\u5e8f\u6309\u94ae:",
    u"\U0001F250": ":\u65e5\u672c\u5ec9\u4ef7\u6309\u94ae:",
    u"\U0001F3EF": ":\u65e5\u672c\u57ce\u5821:",
    u"\U00003297": ":\u65e5\u8bed\u795d\u8d3a\u6309\u94ae:",
    u"\U0001F239": ":\u65e5\u5f0f\u6298\u6263\u6309\u94ae:",
    u"\U0001F38E": ":\u65e5\u672c\u5a03\u5a03:",
    u"\U0001F21A": ":\u65e5\u5f0f\u514d\u8d39\u6309\u94ae:",
    u"\U0001F201": ":\u65e5\u8bed\u6b64\u5904\u6309\u94ae:",
    u"\U0001F237": ":\u65e5\u5f0f\u6bcf\u6708\u91d1\u989d\u6309\u94ae:",
    u"\U0001F235": ":\u65e5\u5f0f\u65e0\u7a7a\u7f3a\u6309\u94ae:",
    u"\U0001F236": ":\u65e5\u5f0f\u975e\u514d\u8d39\u6309\u94ae:",
    u"\U0001F23A": ":\u65e5\u8bed\u5546\u52a1\u5f00\u653e\u6309\u94ae:",
    u"\U0001F234": ":\u65e5\u5f0f\u53ca\u683c\u6309\u94ae:",
    u"\U0001F3E3": ":\u65e5\u672c\u90ae\u5c40:",
    u"\U0001F232": ":\u65e5\u8bed\u7981\u6b62\u6309\u94ae:",
    u"\U0001F22F": ":\u65e5\u8bed\u4fdd\u7559\u6309\u94ae:",
    u"\U00003299": ":\u65e5\u5f0f\u79d8\u5bc6\u6309\u94ae:",
    u"\U0001F202": ":\u65e5\u5f0f\u670d\u52a1\u6536\u8d39\u6309\u94ae:",
    u"\U0001F530": ":\u65e5\u8bed\u521d\u5b66\u8005\u7b26\u53f7:",
    u"\U0001F233": ":\u65e5\u8bed\u7a7a\u7f3a\u6309\u94ae:",
    u"\U00003297\U0000FE0F": ":\u65e5\u8bed\u795d\u8d3a\u6309\u94ae:",
    u"\U0001F237\U0000FE0F": ":\u65e5\u5f0f\u6bcf\u6708\u91d1\u989d\u6309\u94ae:",
    u"\U00003299\U0000FE0F": ":\u65e5\u672c\u79d8\u5bc6\u6309\u94ae:",
    u"\U0001F202\U0000FE0F": ":\u65e5\u5f0f\u670d\u52a1\u6536\u8d39\u6309\u94ae:",
    u"\U0001F1EF\U0001F1EA": ":\u6cfd\u897f\u5c9b:",
    u"\U0001F1EF\U0001F1F4": ":\u4e54\u4e39:",
    u"\U0001F1F0\U0001F1FF": ":\u54c8\u8428\u514b\u65af\u5766:",
    u"\U0001F1F0\U0001F1EA": ":\u80af\u5c3c\u4e9a:",
    u"\U0001F1F0\U0001F1EE": ":\u57fa\u91cc\u5df4\u65af:",
    u"\U0001F1FD\U0001F1F0": ":\u79d1\u7d22\u6c83:",
    u"\U0001F1F0\U0001F1FC": ":\u79d1\u5a01\u7279:",
    u"\U0001F1F0\U0001F1EC": ":\u5409\u5c14\u5409\u65af\u65af\u5766:",
    u"\U0001F1F1\U0001F1E6": ":\u8001\u631d:",
    u"\U0001F1F1\U0001F1FB": ":\u62c9\u8131\u7ef4\u4e9a:",
    u"\U0001F1F1\U0001F1E7": ":\u9ece\u5df4\u5ae9:",
    u"\U0000264C": ":\u72ee\u5b50\u5ea7:",
    u"\U0001F1F1\U0001F1F8": ":\u83b1\u7d22\u6258:",
    u"\U0001F1F1\U0001F1F7": ":\u5229\u6bd4\u91cc\u4e9a:",
    u"\U0000264E": ":\u5929\u79e4\u5ea7:",
    u"\U0001F1F1\U0001F1FE": ":\u5229\u6bd4\u4e9a:",
    u"\U0001F1F1\U0001F1EE": ":\u5217\u652f\u6566\u58eb\u767b:",
    u"\U0001F1F1\U0001F1F9": ":\u7acb\u9676\u5b9b:",
    u"\U0001F1F1\U0001F1FA": ":\u5362\u68ee\u5821:",
    u"\U0001F1F2\U0001F1F4": ":\u4e2d\u56fd\u6fb3\u95e8\u7279\u522b\u884c\u653f\u533a:",
    u"\U0001F1F2\U0001F1F0": ":\u9a6c\u5176\u987f:",
    u"\U0001F1F2\U0001F1EC": ":\u9a6c\u8fbe\u52a0\u65af\u52a0:",
    u"\U0001F1F2\U0001F1FC": ":\u9a6c\u62c9\u7ef4:",
    u"\U0001F1F2\U0001F1FE": ":\u9a6c\u6765\u897f\u4e9a:",
    u"\U0001F1F2\U0001F1FB": ":\u9a6c\u5c14\u4ee3\u592b:",
    u"\U0001F1F2\U0001F1F1": ":\u9a6c\u91cc:",
    u"\U0001F1F2\U0001F1F9": ":\u9a6c\u8033\u4ed6:",
    u"\U0001F1F2\U0001F1ED": ":\u9a6c\u7ecd\u5c14\u7fa4\u5c9b:",
    u"\U0001F1F2\U0001F1F6": ":\u9a6c\u63d0\u5c3c\u514b:",
    u"\U0001F1F2\U0001F1F7": ":\u6bdb\u91cc\u5854\u5c3c\u4e9a:",
    u"\U0001F1F2\U0001F1FA": ":\u6bdb\u91cc\u6c42\u65af:",
    u"\U0001F1FE\U0001F1F9": ":\u9a6c\u7ea6\u7279:",
    u"\U0001F1F2\U0001F1FD": ":\u58a8\u897f\u54e5:",
    u"\U0001F1EB\U0001F1F2": ":\u5bc6\u514b\u7f57\u5c3c\u897f\u4e9a:",
    u"\U0001F1F2\U0001F1E9": ":\u6469\u5c14\u591a\u74e6:",
    u"\U0001F1F2\U0001F1E8": ":\u6469\u7eb3\u54e5:",
    u"\U0001F1F2\U0001F1F3": ":\u8499\u53e4:",
    u"\U0001F1F2\U0001F1EA": ":\u9ed1\u5c71:",
    u"\U0001F1F2\U0001F1F8": ":\u8499\u7279\u585e\u62c9\u7279:",
    u"\U0001F1F2\U0001F1E6": ":\u6469\u6d1b\u54e5:",
    u"\U0001F1F2\U0001F1FF": ":\u83ab\u6851\u6bd4\u514b:",
    u"\U0001F936": ":\u514b\u52b3\u65af\u592b\u4eba:",
    u"\U0001F936\U0001F3FF": ":\u514b\u52b3\u65af\u592b\u4eba\u76ae\u80a4\u9edd\u9ed1:",
    u"\U0001F936\U0001F3FB": ":\u514b\u52b3\u65af\u592b\u4eba\u80a4\u8272\u6d45:",
    u"\U0001F936\U0001F3FE": ":\u514b\u52b3\u65af\u592b\u4eba\u4e2d\u7b49\u504f\u6df1\u80a4\u8272:",
    u"\U0001F936\U0001F3FC": ":\u514b\u52b3\u65af\u592b\u4eba\u4e2d\u6d45\u80a4\u8272:",
    u"\U0001F936\U0001F3FD": ":\u514b\u52b3\u65af\u592b\u4eba\u4e2d\u7b49\u80a4\u8272:",
    u"\U0001F1F2\U0001F1F2": ":\u7f05\u7538\uff08\u7f05\u7538\uff09:",
    u"\U0001F195": ":\u65b0\u5efa\u6309\u94ae:",
    u"\U0001F196": ":NG\u6309\u94ae:",
    u"\U0001F1F3\U0001F1E6": ":\u7eb3\u7c73\u6bd4\u4e9a:",
    u"\U0001F1F3\U0001F1F7": ":\u7459\u9c81:",
    u"\U0001F1F3\U0001F1F5": ":\u5c3c\u6cca\u5c14:",
    u"\U0001F1F3\U0001F1F1": ":\u8377\u5170:",
    u"\U0001F1F3\U0001F1E8": ":\u65b0\u5580\u91cc\u591a\u5c3c\u4e9a:",
    u"\U0001F1F3\U0001F1FF": ":\u65b0\u897f\u5170:",
    u"\U0001F1F3\U0001F1EE": ":\u5c3c\u52a0\u62c9\u74dc:",
    u"\U0001F1F3\U0001F1EA": ":\u5c3c\u65e5\u5c14:",
    u"\U0001F1F3\U0001F1EC": ":\u5c3c\u65e5\u5229\u4e9a:",
    u"\U0001F1F3\U0001F1FA": ":\u7ebd\u57c3:",
    u"\U0001F1F3\U0001F1EB": ":\u8bfa\u798f\u514b\u5c9b:",
    u"\U0001F1F0\U0001F1F5": ":\u671d\u9c9c:",
    u"\U0001F1F2\U0001F1F5": ":\u5317\u9a6c\u91cc\u4e9a\u7eb3\u7fa4\u5c9b:",
    u"\U0001F1F3\U0001F1F4": ":\u632a\u5a01:",
    u"\U0001F197": ":\u201c\u786e\u5b9a\u201d\u6309\u94ae:",
    u"\U0001F44C": ":\u597d\u7684\u624b:",
    u"\U0001F44C\U0001F3FF": ":\u597d\u7684\u624b\u6df1\u8272\u80a4\u8272:",
    u"\U0001F44C\U0001F3FB": ":\u597d\u7684\u624b\u6d45\u80a4\u8272:",
    u"\U0001F44C\U0001F3FE": ":\u597d\u7684\u624b\u4e2d\u7b49\u6df1\u80a4\u8272:",
    u"\U0001F44C\U0001F3FC": ":\u597d\u7684\u624b\u4e2d\u6d45\u80a4\u8272:",
    u"\U0001F44C\U0001F3FD": ":\u597d\u7684\u624b\u4e2d\u7b49\u80a4\u8272:",
    u"\U0001F51B": ":\u52a0\u6cb9\uff01\u7bad\u5934:",
    u"\U0001F17E": ":O\u6309\u94ae\uff08\u8840\u578b\uff09:",
    u"\U0001F17E\U0000FE0F": ":O\u6309\u94ae\uff08\u8840\u578b\uff09:",
    u"\U0001F1F4\U0001F1F2": ":\u963f\u66fc:",
    u"\U000026CE": ":\u86c7\u592b\u5ea7:",
    u"\U0001F17F": ":P\u6309\u94ae:",
    u"\U0001F17F\U0000FE0F": ":P\u6309\u94ae:",
    u"\U0001F1F5\U0001F1F0": ":\u5df4\u57fa\u65af\u5766:",
    u"\U0001F1F5\U0001F1FC": ":\u5e15\u52b3:",
    u"\U0001F1F5\U0001F1F8": ":\u5df4\u52d2\u65af\u5766\u9886\u571f:",
    u"\U0001F1F5\U0001F1E6": ":\u5df4\u62ff\u9a6c:",
    u"\U0001F1F5\U0001F1EC": ":\u5df4\u5e03\u4e9a\u65b0\u51e0\u5185\u4e9a:",
    u"\U0001F1F5\U0001F1FE": ":\u5df4\u62c9\u572d:",
    u"\U0001F1F5\U0001F1EA": ":\u79d8\u9c81:",
    u"\U0001F1F5\U0001F1ED": ":\u83f2\u5f8b\u5bbe:",
    u"\U00002653": ":\u53cc\u9c7c\u5ea7:",
    u"\U0001F1F5\U0001F1F3": ":\u76ae\u7279\u51ef\u6069\u7fa4\u5c9b:",
    u"\U0001F1F5\U0001F1F1": ":\u6ce2\u5170:",
    u"\U0001F1F5\U0001F1F9": ":\u8461\u8404\u7259:",
    u"\U0001F1F5\U0001F1F7": ":\u6ce2\u591a\u9ece\u5404:",
    u"\U0001F1F6\U0001F1E6": ":\u5361\u5854\u5c14:",
    u"\U0001F1F7\U0001F1F4": ":\u7f57\u9a6c\u5c3c\u4e9a:",
    u"\U0001F1F7\U0001F1FA": ":\u4fc4\u7f57\u65af:",
    u"\U0001F1F7\U0001F1FC": ":\u5362\u65fa\u8fbe:",
    u"\U0001F1F7\U0001F1EA": ":\u91cd\u7ec4:",
    u"\U0001F51C": ":\u4e0d\u4e45\u7684\u7bad:",
    u"\U0001F198": ":SOS\u6309\u94ae:",
    u"\U00002650": ":\u5c04\u624b\u5ea7:",
    u"\U0001F1FC\U0001F1F8": ":\u8428\u6469\u4e9a:",
    u"\U0001F1F8\U0001F1F2": ":\u5723\u9a6c\u529b\u8bfa:",
    u"\U0001F385": ":\u5723\u8bde\u8001\u4eba:",
    u"\U0001F385\U0001F3FF": ":\u5723\u8bde\u8001\u4eba\u6df1\u8272\u80a4\u8272:",
    u"\U0001F385\U0001F3FB": ":\u5723\u8bde\u8001\u4eba\u6d45\u80a4\u8272:",
    u"\U0001F385\U0001F3FE": ":\u5723\u8bde\u8001\u4eba\u4e2d\u6df1\u8272\u80a4\u8272:",
    u"\U0001F385\U0001F3FC": ":\u5723\u8bde\u8001\u4eba\u4e2d\u6d45\u80a4\u8272:",
    u"\U0001F385\U0001F3FD": ":\u5723\u8bde\u8001\u4eba\u4e2d\u7b49\u80a4\u8272:",
    u"\U0001F1F8\U0001F1E6": ":\u6c99\u7279\u963f\u62c9\u4f2f:",
    u"\U0000264F": ":\u5929\u874e\u5ea7:",
    u"\U0001F3F4\U000E0067\U000E0062\U000E0073\U000E0063\U000E0074\U000E007F": ":\u82cf\u683c\u5170:",
    u"\U0001F1F8\U0001F1F3": ":\u585e\u5185\u52a0\u5c14:",
    u"\U0001F1F7\U0001F1F8": ":\u585e\u5c14\u7ef4\u4e9a:",
    u"\U0001F1F8\U0001F1E8": ":\u585e\u820c\u5c14:",
    u"\U0001F1F8\U0001F1F1": ":\u585e\u62c9\u5229\u6602:",
    u"\U0001F1F8\U0001F1EC": ":\u65b0\u52a0\u5761:",
    u"\U0001F1F8\U0001F1FD": ":\u8377\u5c5e\u5723\u9a6c\u4e01:",
    u"\U0001F1F8\U0001F1F0": ":\u65af\u6d1b\u4f10\u514b:",
    u"\U0001F1F8\U0001F1EE": ":\u65af\u6d1b\u6587\u5c3c\u4e9a:",
    u"\U0001F1F8\U0001F1E7": ":\u6240\u7f57\u95e8\u7fa4\u5c9b:",
    u"\U0001F1F8\U0001F1F4": ":\u7d22\u9a6c\u91cc:",
    u"\U0001F1FF\U0001F1E6": ":\u5357\u975e:",
    u"\U0001F1EC\U0001F1F8": ":\u5357\u4e54\u6cbb\u4e9a\u548c\u5357\u6851\u5a01\u5947\u7fa4\u5c9b:",
    u"\U0001F1F0\U0001F1F7": ":\u97e9\u56fd:",
    u"\U0001F1F8\U0001F1F8": ":\u5357\u82cf\u4e39:",
    u"\U0001F1EA\U0001F1F8": ":\u897f\u73ed\u7259:",
    u"\U0001F1F1\U0001F1F0": ":\u65af\u91cc\u5170\u5361:",
    u"\U0001F1E7\U0001F1F1": ":\u5723\u5df4\u7279\u83b1\u7c73:",
    u"\U0001F1F8\U0001F1ED": ":\u5723\u8d6b\u52d2\u62ff:",
    u"\U0001F1F0\U0001F1F3": ":\u5723\u57fa\u8328\u548c\u5c3c\u7ef4\u65af:",
    u"\U0001F1F1\U0001F1E8": ":\u5723\u5362\u897f\u4e9a:",
    u"\U0001F1F2\U0001F1EB": ":\u5723\u9a6c\u4e01:",
    u"\U0001F1F5\U0001F1F2": ":\u5723\u76ae\u57c3\u5c14\u548c\u5bc6\u514b\u9686:",
    u"\U0001F1FB\U0001F1E8": ":\u5723\u6587\u68ee\u5c9b:",
    u"\U0001F5FD": ":\u81ea\u7531\u5973\u795e\u50cf:",
    u"\U0001F1F8\U0001F1E9": ":\u82cf\u4e39:",
    u"\U0001F1F8\U0001F1F7": ":\u82cf\u91cc\u5357:",
    u"\U0001F1F8\U0001F1EF": ":\u65af\u74e6\u5c14\u5df4\u548c\u626c\u9a6c\u5ef6:",
    u"\U0001F1F8\U0001F1FF": ":\u65af\u5a01\u58eb\u5170:",
    u"\U0001F1F8\U0001F1EA": ":\u745e\u5178:",
    u"\U0001F1E8\U0001F1ED": ":\u745e\u58eb:",
    u"\U0001F1F8\U0001F1FE": ":\u53d9\u5229\u4e9a:",
    u"\U0001F1F8\U0001F1F9": ":\u5723\u591a\u7f8e\u548c\u666e\u6797\u897f\u6bd4:",
    u"\U0001F996": ":\u9738\u738b\u9f99:",
    u"\U0001F51D": ":\u4e0a\u7bad\u5934:",
    u"\U0001F1F9\U0001F1FC": ":\u53f0\u6e7e:",
    u"\U0001F1F9\U0001F1EF": ":\u5854\u5409\u514b\u65af\u5766:",
    u"\U0001F1F9\U0001F1FF": ":\u5766\u6851\u5c3c\u4e9a:",
    u"\U00002649": ":\u91d1\u725b\u5ea7:",
    u"\U0001F1F9\U0001F1ED": ":\u6cf0\u56fd:",
    u"\U0001F1F9\U0001F1F1": ":\u4e1c\u5e1d\u6c76:",
    u"\U0001F1F9\U0001F1EC": ":\u591a\u54e5:",
    u"\U0001F1F9\U0001F1F0": ":\u6258\u514b\u52b3:",
    u"\U0001F5FC": ":\u4e1c\u4eac\u5854:",
    u"\U0001F1F9\U0001F1F4": ":\u6c64\u52a0:",
    u"\U0001F1F9\U0001F1F9": ":\u7279\u7acb\u5c3c\u8fbe\u548c\u591a\u5df4\u54e5:",
    u"\U0001F1F9\U0001F1E6": ":\u7279\u91cc\u65af\u5766\u8fbe\u5e93\u5c3c\u4e9a:",
    u"\U0001F1F9\U0001F1F3": ":\u7a81\u5c3c\u65af:",
    u"\U0001F1F9\U0001F1F7": ":\u571f\u8033\u5176:",
    u"\U0001F1F9\U0001F1F2": ":\u571f\u5e93\u66fc\u65af\u5766:",
    u"\U0001F1F9\U0001F1E8": ":\u7279\u514b\u65af\u548c\u51ef\u79d1\u65af\u7fa4\u5c9b:",
    u"\U0001F1F9\U0001F1FB": ":\u56fe\u74e6\u5362:",
    u"\U0001F1FA\U0001F1F2": ":\u7f8e\u56fd:",
    u"\U0001F1FB\U0001F1EE": ":\u7f8e\u5c5e\u7ef4\u5c14\u4eac\u7fa4\u5c9b:",
    u"\U0001F199": ":\u8d77\u6765\uff01\u6309\u94ae:",
    u"\U0001F1FA\U0001F1EC": ":\u4e4c\u5e72\u8fbe:",
    u"\U0001F1FA\U0001F1E6": ":\u4e4c\u514b\u5170:",
    u"\U0001F1E6\U0001F1EA": ":\u963f\u62c9\u4f2f\u8054\u5408\u914b\u957f\u56fd:",
    u"\U0001F1EC\U0001F1E7": ":\u5927\u4e0d\u5217\u98a0\u8054\u5408\u738b\u56fd:",
    u"\U0001F1FA\U0001F1F3": ":\u8054\u5408\u56fd:",
    u"\U0001F1FA\U0001F1F8": ":\u7f8e\u56fd:",
    u"\U0001F1FA\U0001F1FE": ":\u4e4c\u62c9\u572d:",
    u"\U0001F1FA\U0001F1FF": ":\u4e4c\u5179\u522b\u514b\u65af\u5766:",
    u"\U0001F19A": ":VS:",
    u"\U0001F1FB\U0001F1FA": ":\u74e6\u52aa\u963f\u56fe:",
    u"\U0001F1FB\U0001F1E6": ":\u68b5\u8482\u5188\u57ce:",
    u"\U0001F1FB\U0001F1EA": ":\u59d4\u5185\u745e\u62c9:",
    u"\U0001F1FB\U0001F1F3": ":\u8d8a\u5357:",
    u"\U0000264D": ":\u5904\u5973\u5ea7:",
    u"\U0001F3F4\U000E0067\U000E0062\U000E0077\U000E006C\U000E0073\U000E007F": ":\u5a01\u5c14\u58eb:",
    u"\U0001F1FC\U0001F1EB": ":\u74e6\u5229\u65af\u548c\u5bcc\u56fe\u7eb3:",
    u"\U0001F1EA\U0001F1ED": ":\u897f\u6492\u54c8\u62c9:",
    u"\U0001F1FE\U0001F1EA": ":\u4e5f\u95e8:",
    u"\U0001F1FF\U0001F1F2": ":\u8d5e\u6bd4\u4e9a:",
    u"\U0001F1FF\U0001F1FC": ":\u6d25\u5df4\u5e03\u97e6:",
    u"\U0001F9EE": ":\u7b97\u76d8:",
    u"\U0001FA79": ":\u80f6\u5e03:",
    u"\U0001F39F": ":\u5165\u573a\u5238:",
    u"\U0001F39F\U0000FE0F": ":\u95e8\u7968:",
    u"\U0001F9D1": ":\u6210\u4eba:",
    u"\U0001F9D1\U0001F3FF": ":\u6210\u4eba\u6697\u80a4\u8272:",
    u"\U0001F9D1\U0001F3FB": ":\u6210\u4eba\u6d45\u80a4\u8272:",
    u"\U0001F9D1\U0001F3FE": ":\u6210\u4eba\u4e2d\u6df1\u8272\u80a4\u8272:",
    u"\U0001F9D1\U0001F3FC": ":\u6210\u4eba\u4e2d\u6d45\u80a4\u8272:",
    u"\U0001F9D1\U0001F3FD": ":\u6210\u4eba\u4e2d\u7b49\u80a4\u8272:",
    u"\U0001F6A1": ":\u67b6\u7a7a\u7535\u8f66:",
    u"\U00002708": ":\u98de\u673a:",
    u"\U0001F6EC": ":\u98de\u673a\u5230\u8fbe:",
    u"\U0001F6EB": ":\u98de\u673a\u8d77\u98de:",
    u"\U00002708\U0000FE0F": ":\u98de\u673a\u3001:",
    u"\U000023F0": ":\u95f9\u949f:",
    u"\U00002697": ":\u963f\u4f26\u6bd4\u8bed:",
    u"\U00002697\U0000FE0F": ":\u84b8\u998f\u5668:",
    u"\U0001F47D": ":\u5916\u661f\u4eba:",
    u"\U0001F47E": ":\u5916\u661f\u602a\u7269:",
    u"\U0001F691": ":\u6551\u62a4\u8f66:",
    u"\U0001F3C8": ":\u7f8e\u5f0f\u8db3\u7403:",
    u"\U0001F3FA": ":\u53cc\u8033:",
    u"\U00002693": ":\u951a:",
    u"\U0001F4A2": ":\u6124\u6012\u7b26\u53f7:",
    u"\U0001F620": ":\u6124\u6012\u7684\u8138:",
    u"\U0001F47F": ":\u6012\u6c14\u51b2\u51b2\u7684\u8138:",
    u"\U0001F627": ":\u75db\u82e6\u7684\u8138:",
    u"\U0001F41C": ":\u8682\u8681:",
    u"\U0001F4F6": ":\u5929\u7ebf\u6746:",
    u"\U0001F630": ":\u6c57\u6d41\u6ee1\u9762:",
    u"\U0001F69B": ":\u94f0\u63a5\u5f0f\u8d27\u8f66:",
    u"\U0001F3A8": ":\u827a\u672f\u5bb6\u8c03\u8272\u677f:",
    u"\U0001F632": ":\u60ca\u8bb6\u7684\u8138:",
    u"\U0000269B": ":\u539f\u5b50\u7b26\u53f7:",
    u"\U0000269B\U0000FE0F": ":\u539f\u5b50\u7b26\u53f7:",
    u"\U0001F6FA": ":\u6c7d\u8f66\u4eba\u529b\u8f66:",
    u"\U0001F697": ":\u6c7d\u8f66:",
    u"\U0001F951": ":\u9cc4\u68a8:",
    u"\U0001FA93": ":\u65a7\u5934:",
    u"\U0001F476": ":\u5b9d\u8d1d:",
    u"\U0001F47C": ":\u5c0f\u5929\u4f7f:",
    u"\U0001F47C\U0001F3FF": ":\u5929\u4f7f\u5b9d\u5b9d\u6697\u80a4\u8272:",
    u"\U0001F47C\U0001F3FB": ":\u5929\u4f7f\u5b9d\u5b9d\u6d45\u80a4\u8272:",
    u"\U0001F47C\U0001F3FE": ":\u5929\u4f7f\u5b9d\u5b9d\u4e2d\u9ed1\u80a4\u8272:",
    u"\U0001F47C\U0001F3FC": ":\u5929\u4f7f\u5b9d\u5b9d\u4e2d\u6d45\u80a4\u8272:",
    u"\U0001F47C\U0001F3FD": ":\u5929\u4f7f\u5b9d\u5b9d\u4e2d\u7b49\u80a4\u8272:",
    u"\U0001F37C": ":\u5a74\u513f\u5976\u74f6:",
    u"\U0001F424": ":\u5c0f\u9e21:",
    u"\U0001F476\U0001F3FF": ":\u5a74\u513f\u6697\u80a4\u8272:",
    u"\U0001F476\U0001F3FB": ":\u5a74\u513f\u6d45\u80a4\u8272:",
    u"\U0001F476\U0001F3FE": ":\u5a74\u513f\u4e2d\u6df1\u8272\u80a4\u8272:",
    u"\U0001F476\U0001F3FC": ":\u5a74\u513f\u4e2d\u6d45\u80a4\u8272:",
    u"\U0001F476\U0001F3FD": ":\u5a74\u513f\u4e2d\u7b49\u80a4\u8272:",
    u"\U0001F6BC": ":\u5a74\u513f\u6807\u5fd7:",
    u"\U0001F447": ":\u53cd\u624b\u98df\u6307\u5411\u4e0b:",
    u"\U0001F447\U0001F3FF": ":\u53cd\u624b\u98df\u6307\u5411\u4e0b\u6df1\u8272\u80a4\u8272:",
    u"\U0001F447\U0001F3FB": ":\u53cd\u624b\u98df\u6307\u5411\u4e0b\u6d45\u80a4\u8272:",
    u"\U0001F447\U0001F3FE": ":\u53cd\u624b\u98df\u6307\u5411\u4e0b\u4e2d\u6df1\u8272\u80a4\u8272:",
    u"\U0001F447\U0001F3FC": ":\u53cd\u624b\u98df\u6307\u5411\u4e0b\u4e2d\u6d45\u80a4\u8272:",
    u"\U0001F447\U0001F3FD": ":\u53cd\u624b\u98df\u6307\u5411\u4e0b\u4e2d\u7b49\u80a4\u8272:",
    u"\U0001F448": ":\u53cd\u624b\u98df\u6307\u5411\u5de6:",
    u"\U0001F448\U0001F3FF": ":\u53cd\u624b\u98df\u6307\u5411\u5de6\u6df1\u8272\u80a4\u8272:",
    u"\U0001F448\U0001F3FB": ":\u53cd\u624b\u98df\u6307\u5411\u5de6\u6d45\u80a4\u8272:",
    u"\U0001F448\U0001F3FE": ":\u53cd\u624b\u98df\u6307\u5411\u5de6\u6df1\u8272\u80a4\u8272:",
    u"\U0001F448\U0001F3FC": ":\u53cd\u624b\u98df\u6307\u5411\u5de6\u4e2d\u6d45\u80a4\u8272:",
    u"\U0001F448\U0001F3FD": ":\u53cd\u624b\u98df\u6307\u5411\u5de6\u4e2d\u7b49\u80a4\u8272:",
    u"\U0001F449": ":\u53cd\u624b\u98df\u6307\u5411\u53f3:",
    u"\U0001F449\U0001F3FF": ":\u53cd\u624b\u98df\u6307\u5411\u53f3\u6df1\u8272\u80a4\u8272:",
    u"\U0001F449\U0001F3FB": ":\u53cd\u624b\u98df\u6307\u5411\u53f3\u6d45\u80a4\u8272:",
    u"\U0001F449\U0001F3FE": ":\u53cd\u624b\u98df\u6307\u5411\u53f3\u4e2d\u6df1\u8272\u80a4\u8272:",
    u"\U0001F449\U0001F3FC": ":\u53cd\u624b\u98df\u6307\u5411\u53f3\u4e2d\u6d45\u80a4\u8272:",
    u"\U0001F449\U0001F3FD": ":\u53cd\u624b\u98df\u6307\u5411\u53f3\u4e2d\u7b49\u80a4\u8272:",
    u"\U0001F446": ":\u53cd\u624b\u98df\u6307\u5411\u4e0a:",
    u"\U0001F446\U0001F3FF": ":\u53cd\u624b\u98df\u6307\u5411\u4e0a\u6df1\u8272\u80a4\u8272:",
    u"\U0001F446\U0001F3FB": ":\u53cd\u624b\u98df\u6307\u5411\u4e0a\u6d45\u80a4\u8272:",
    u"\U0001F446\U0001F3FE": ":\u53cd\u624b\u98df\u6307\u5411\u4e0a\u4e2d\u6df1\u8272\u80a4\u8272:",
    u"\U0001F446\U0001F3FC": ":\u53cd\u624b\u98df\u6307\u5411\u4e0a\u4e2d\u6d45\u80a4\u8272:",
    u"\U0001F446\U0001F3FD": ":\u53cd\u624b\u98df\u6307\u5411\u4e0a\u4e2d\u7b49\u80a4\u8272:",
    u"\U0001F953": ":\u57f9\u6839:",
    u"\U0001F9A1": ":\u737e:",
    u"\U0001F3F8": ":\u7fbd\u6bdb\u7403:",
    u"\U0001F96F": ":\u767e\u5409\u997c:",
    u"\U0001F6C4": ":\u884c\u674e\u9886\u53d6\u5904:",
    u"\U0001F956": ":\u6cd5\u5f0f\u9762\u5305:",
    u"\U00002696": ":\u5929\u5e73:",
    u"\U00002696\U0000FE0F": ":\u5929\u5e73\u7535\u5b50\u79e4:",
    u"\U0001F9B2": ":\u79c3\u5934:",
    u"\U0001F468\U0000200D\U0001F9B2": ":\u79c3\u5b50:",
    u"\U0001F469\U0000200D\U0001F9B2": ":\u79c3\u5934\u5973\u4eba:",
    u"\U0001FA70": ":\u82ad\u857e\u821e\u978b:",
    u"\U0001F388": ":\u6c14\u7403:",
    u"\U0001F5F3": ":\u5e26\u9009\u7968\u7684\u6295\u7968\u7bb1:",
    u"\U0001F5F3\U0000FE0F": ":\u5e26\u9009\u7968\u7684\u6295\u7968\u7bb1:",
    u"\U00002611": ":\u5e26\u652f\u7968\u7684\u6295\u7968\u7bb1:",
    u"\U0001F34C": ":\u9999\u8549:",
    u"\U0001FA95": ":\u73ed\u5353\u7434:",
    u"\U0001F3E6": ":\u94f6\u884c:",
    u"\U0001F4CA": ":\u6761\u5f62\u56fe:",
    u"\U0001F488": ":\u7406\u53d1\u6746:",
    u"\U000026BE": ":\u68d2\u7403:",
    u"\U0001F9FA": ":\u7bee\u5b50:",
    u"\U0001F3C0": ":\u7bee\u7403:",
    u"\U0001F987": ":\u8759\u8760:",
    u"\U0001F6C1": ":\u6d74\u7f38:",
    u"\U0001F50B": ":\u7535\u6c60:",
    u"\U0001F3D6": ":\u5e26\u4f1e\u6d77\u6ee9:",
    u"\U0001F3D6\U0000FE0F": ":\u5e26\u96e8\u4f1e\u7684\u6d77\u6ee9:",
    u"\U0001F601": ":\u7b11\u772f\u772f\u7684\u8138:",
    u"\U0001F43B": ":\u718a\u8138:",
    u"\U0001F9D4": ":\u957f\u80e1\u5b50\u7684\u4eba:",
    u"\U0001F9D4\U0001F3FF": ":\u80e1\u987b\u4eba\u6df1\u8272\u80a4\u8272:",
    u"\U0001F9D4\U0001F3FB": ":\u80e1\u987b\u4eba\u6d45\u80a4\u8272:",
    u"\U0001F9D4\U0001F3FE": ":\u80e1\u987b\u4eba\u4e2d\u6df1\u8272\u80a4\u8272:",
    u"\U0001F9D4\U0001F3FC": ":\u80e1\u987b\u4eba\u4e2d\u6d45\u80a4\u8272:",
    u"\U0001F9D4\U0001F3FD": ":\u80e1\u987b\u4eba\u4e2d\u7b49\u80a4\u8272:",
    u"\U0001F493": ":\u8df3\u52a8\u7684\u5fc3\u810f:",
    u"\U0001F6CF": ":\u5e8a:",
    u"\U0001F6CF\U0000FE0F": ":\u5e8a\u4f4d:",
    u"\U0001F37A": ":\u5564\u9152\u676f:",
    u"\U0001F514": ":\u949f:",
    u"\U0001F515": ":\u659c\u7ebf\u949f:",
    u"\U0001F6CE": ":\u884c\u674e\u5458\u94c3:",
    u"\U0001F6CE\U0000FE0F": ":\u884c\u674e\u5458\u94c3:",
    u"\U0001F371": ":\u4fbf\u5f53\u76d2:",
    u"\U0001F9C3": ":\u996e\u6599\u76d2:",
    u"\U0001F6B2": ":\u81ea\u884c\u8f66:",
    u"\U0001F459": ":\u6bd4\u57fa\u5c3c:",
    u"\U0001F9E2": ":\u76d6\u5e3d:",
    u"\U00002623": ":\u751f\u7269\u5371\u5bb3:",
    u"\U00002623\U0000FE0F": ":\u751f\u7269\u5371\u5bb3:",
    u"\U0001F426": ":\u9e1f:",
    u"\U0001F382": ":\u751f\u65e5\u86cb\u7cd5:",
    u"\U000026AB": ":\u9ed1\u8272\u5706\u5708:",
    u"\U0001F3F4": ":\u9ed1\u65d7:",
    u"\U0001F5A4": ":\u9ed1\u5fc3:",
    u"\U00002B1B": ":\u9ed1\u8272\u5927\u6b63\u65b9\u5f62:",
    u"\U000025FE": ":\u9ed1\u8272\u4e2d\u5c0f\u578b\u6b63\u65b9\u5f62:",
    u"\U000025FC": ":\u9ed1\u8272\u4e2d\u65b9\u5f62:",
    u"\U000025FC\U0000FE0F": ":\u9ed1\u8272\u4e2d\u65b9\u5f62:",
    u"\U00002712": ":\u9ed1\u7b14\u5c16:",
    u"\U00002712\U0000FE0F": ":\u9ed1\u7b14\u5c16:",
    u"\U000025AA": ":\u9ed1\u8272\u5c0f\u6b63\u65b9\u5f62:",
    u"\U000025AA\U0000FE0F": ":\u9ed1\u8272\u5c0f\u65b9\u5f62:",
    u"\U0001F532": ":\u9ed1\u8272\u65b9\u5f62\u6309\u94ae:",
    u"\U0001F471\U0000200D\U00002642\U0000FE0F": ":\u91d1\u53d1\u7537\u5b50:",
    u"\U0001F471\U0001F3FF\U0000200D\U00002642\U0000FE0F": ":\u91d1\u53d1\u7537\u6df1\u8272\u80a4\u8272:",
    u"\U0001F471\U0001F3FB\U0000200D\U00002642\U0000FE0F": ":\u91d1\u53d1\u7537\u6d45\u80a4\u8272:",
    u"\U0001F471\U0001F3FE\U0000200D\U00002642\U0000FE0F": ":\u91d1\u53d1\u7537\u4e2d\u6df1\u8272\u80a4\u8272:",
    u"\U0001F471\U0001F3FC\U0000200D\U00002642\U0000FE0F": ":\u91d1\u53d1\u7537\u4e2d\u6d45\u80a4\u8272:",
    u"\U0001F471\U0001F3FD\U0000200D\U00002642\U0000FE0F": ":\u91d1\u53d1\u7537\u4e2d\u7b49\u80a4\u8272:",
    u"\U0001F471": ":\u91d1\u53d1\u7684\u4eba:",
    u"\U0001F471\U0001F3FF": ":\u91d1\u53d1\u7684\u4eba\u76ae\u80a4\u9edd\u9ed1:",
    u"\U0001F471\U0001F3FB": ":\u91d1\u53d1\u7684\u4eba\u80a4\u8272\u6d45:",
    u"\U0001F471\U0001F3FE": ":\u91d1\u53d1\u7684\u4eba\u4e2d\u6df1\u8272\u80a4\u8272:",
    u"\U0001F471\U0001F3FC": ":\u91d1\u53d1\u4eba\u4e2d\u6d45\u80a4\u8272:",
    u"\U0001F471\U0001F3FD": ":\u91d1\u53d1\u7684\u4eba\u4e2d\u7b49\u80a4\u8272:",
    u"\U0001F471\U0000200D\U00002640\U0000FE0F": ":\u91d1\u53d1\u5973\u5b50:",
    u"\U0001F471\U0001F3FF\U0000200D\U00002640\U0000FE0F": ":\u91d1\u53d1\u5973\u4eba\u6df1\u8272\u80a4\u8272:",
    u"\U0001F471\U0001F3FB\U0000200D\U00002640\U0000FE0F": ":\u91d1\u53d1\u5973\u4eba\u6d45\u80a4\u8272:",
    u"\U0001F471\U0001F3FE\U0000200D\U00002640\U0000FE0F": ":\u6df1\u8272\u80a4\u8272\u5973\u6027ED:",
    u"\U0001F471\U0001F3FC\U0000200D\U00002640\U0000FE0F": ":\u91d1\u53d1\u5973\u5b50\u4e2d\u6d45\u80a4\u8272:",
    u"\U0001F471\U0001F3FD\U0000200D\U00002640\U0000FE0F": ":\u91d1\u53d1\u5973\u4eba\u4e2d\u7b49\u80a4\u8272:",
    u"\U0001F33C": ":\u5f00\u82b1:",
    u"\U0001F421": ":\u6cb3\u8c5a:",
    u"\U0001F4D8": ":\u84dd\u76ae\u4e66:",
    u"\U0001F535": ":\u84dd\u8272\u5706\u5708:",
    u"\U0001F499": ":\u84dd\u5fc3:",
    u"\U0001F7E6": ":\u84dd\u8272\u65b9\u5757:",
    u"\U0001F417": ":\u91ce\u732a:",
    u"\U0001F4A3": ":\u70b8\u5f39:",
    u"\U0001F9B4": ":\u9aa8:",
    u"\U0001F516": ":\u4e66\u7b7e:",
    u"\U0001F4D1": ":\u4e66\u7b7e\u9009\u9879\u5361:",
    u"\U0001F4DA": ":\u4e66:",
    u"\U0001F37E": ":\u74f6\u585e\u74f6\u585e:",
    u"\U0001F490": ":\u82b1\u675f:",
    u"\U0001F3F9": ":\u5f13\u7bad:",
    u"\U0001F963": ":\u5e26\u52fa\u5b50\u7684\u7897:",
    u"\U0001F3B3": ":\u4fdd\u9f84\u7403:",
    u"\U0001F94A": ":\u62f3\u51fb\u624b\u5957:",
    u"\U0001F466": ":\u7537\u5b69:",
    u"\U0001F466\U0001F3FF": ":\u7537\u5b69\u6697\u80a4\u8272:",
    u"\U0001F466\U0001F3FB": ":\u7537\u5b69\u6d45\u80a4\u8272:",
    u"\U0001F466\U0001F3FE": ":\u7537\u5b69\u4e2d\u6df1\u8272\u80a4\u8272:",
    u"\U0001F466\U0001F3FC": ":\u7537\u5b69\u4e2d\u6d45\u80a4\u8272:",
    u"\U0001F466\U0001F3FD": ":\u7537\u5b69\u4e2d\u7b49\u80a4\u8272:",
    u"\U0001F9E0": ":\u8111:",
    u"\U0001F35E": ":\u9762\u5305:",
    u"\U0001F931": ":\u6bcd\u4e73\u5582\u517b:",
    u"\U0001F931\U0001F3FF": ":\u6bcd\u4e73\u5582\u517b\u6697\u80a4\u8272:",
    u"\U0001F931\U0001F3FB": ":\u6bcd\u4e73\u5582\u517b\u6d45\u80a4\u8272:",
    u"\U0001F931\U0001F3FE": ":\u6bcd\u4e73\u5582\u517b\u4e2d\u6df1\u8272\u80a4\u8272:",
    u"\U0001F931\U0001F3FC": ":\u6bcd\u4e73\u5582\u517b\u4e2d\u6d45\u80a4\u8272:",
    u"\U0001F931\U0001F3FD": ":\u6bcd\u4e73\u5582\u517b\u4e2d\u7b49\u80a4\u8272:",
    u"\U0001F9F1": ":\u7816:",
    u"\U0001F470": ":\u6234\u9762\u7eb1\u7684\u65b0\u5a18:",
    u"\U0001F470\U0001F3FF": ":\u65b0\u5a18\u9762\u7eb1\u6df1\u8272\u80a4\u8272:",
    u"\U0001F470\U0001F3FB": ":\u65b0\u5a18\u9762\u7eb1\u6d45\u80a4\u8272:",
    u"\U0001F470\U0001F3FE": ":\u5e26\u9762\u7eb1\u7684\u65b0\u5a18\u4e2d\u6df1\u8272\u80a4\u8272:",
    u"\U0001F470\U0001F3FC": ":\u65b0\u5a18\u9762\u7eb1\u4e2d\u6d45\u80a4\u8272:",
    u"\U0001F470\U0001F3FD": ":\u65b0\u5a18\u9762\u7eb1\u4e2d\u7b49\u80a4\u8272:",
    u"\U0001F309": ":\u665a\u4e0a\u7684\u6865:",
    u"\U0001F4BC": ":\u516c\u6587\u5305:",
    u"\U0001FA72": ":\u6982\u8981:",
    u"\U0001F506": ":\u4eae\u6309\u94ae:",
    u"\U0001F966": ":\u897f\u5170\u82b1:",
    u"\U0001F494": ":\u5fc3\u788e:",
    u"\U0001F9F9": ":\u626b\u5e1a:",
    u"\U0001F7E4": ":\u68d5\u8272\u5706\u5708:",
    u"\U0001F90E": ":\u8910\u8272\u5fc3\u810f:",
    u"\U0001F7EB": ":\u68d5\u8272\u6b63\u65b9\u5f62:",
    u"\U0001F41B": ":\u7f3a\u9677:",
    u"\U0001F3D7": ":\u5efa\u7b51\u65bd\u5de5:",
    u"\U0001F3D7\U0000FE0F": ":\u5efa\u7b51\u6784\u9020:",
    u"\U0001F685": ":\u5b50\u5f39\u5934\u5217\u8f66:",
    u"\U0001F32F": ":\u7389\u7c73\u714e\u997c:",
    u"\U0001F68C": ":\u516c\u5171\u6c7d\u8f66:",
    u"\U0001F68F": ":\u516c\u4ea4\u7ad9:",
    u"\U0001F464": ":\u80f8\u90e8\u8f6e\u5ed3:",
    u"\U0001F465": ":\u534a\u8eab\u50cf:",
    u"\U0001F9C8": ":\u9ec4\u6cb9:",
    u"\U0001F98B": ":\u8774\u8776:",
    u"\U0001F335": ":\u4ed9\u4eba\u638c:",
    u"\U0001F4C5": ":\u65e5\u5386:",
    u"\U0001F919": ":\u53eb\u6211\u624b:",
    u"\U0001F919\U0001F3FF": ":\u53eb\u6211\u624b\u9ed1\u80a4\u8272:",
    u"\U0001F919\U0001F3FB": ":\u53eb\u6211\u624b\u6d45\u80a4\u8272:",
    u"\U0001F919\U0001F3FE": ":\u53eb\u6211\u624b\u4e2d\u9ed1\u80a4\u8272:",
    u"\U0001F919\U0001F3FC": ":\u53eb\u6211\u624b\u4e2d\u6d45\u80a4\u8272:",
    u"\U0001F919\U0001F3FD": ":\u53eb\u6211\u624b\u4e2d\u7b49\u80a4\u8272:",
    u"\U0001F42A": ":\u9a86\u9a7c:",
    u"\U0001F4F7": ":\u7167\u76f8\u673a:",
    u"\U0001F4F8": ":\u5e26\u95ea\u5149\u706f\u7684\u7167\u76f8\u673a:",
    u"\U0001F3D5": ":\u9732\u8425:",
    u"\U0001F3D5\U0000FE0F": ":\u91ce\u8425:",
    u"\U0001F56F": ":\u8721\u70db:",
    u"\U0001F56F\U0000FE0F": ":\u8721\u70db:",
    u"\U0001F36C": ":\u7cd6\u679c:",
    u"\U0001F96B": ":\u7f50\u5934\u98df\u54c1:",
    u"\U0001F6F6": ":\u72ec\u6728\u821f:",
    u"\U0001F5C3": ":\u5361\u7247\u6863\u6848\u7bb1:",
    u"\U0001F5C3\U0000FE0F": ":\u5361\u7247\u6587\u4ef6\u76d2:",
    u"\U0001F4C7": ":\u5361\u7247\u7d22\u5f15:",
    u"\U0001F5C2": ":\u5361\u7247\u7d22\u5f15\u5206\u9694\u5668:",
    u"\U0001F5C2\U0000FE0F": ":\u5361\u7247\u7d22\u5f15\u5206\u9694\u5668:",
    u"\U0001F3A0": ":\u65cb\u8f6c\u6728\u9a6c:",
    u"\U0001F38F": ":\u9ca4\u9c7c\u98d8\u5e26:",
    u"\U0001F955": ":\u80e1\u841d\u535c:",
    u"\U0001F3F0": ":\u57ce\u5821:",
    u"\U0001F408": ":\u732b:",
    u"\U0001F431": ":\u732b\u8138:",
    u"\U0001F639": ":\u559c\u6781\u800c\u6ce3\u7684\u732b\u8138:",
    u"\U0001F63C": ":\u82e6\u7b11\u7684\u732b\u8138:",
    u"\U000026D3": ":\u94fe:",
    u"\U000026D3\U0000FE0F": ":\u94fe\u6761:",
    u"\U0001FA91": ":\u6905\u5b50:",
    u"\U0001F4C9": ":\u56fe\u8868\u9012\u51cf:",
    u"\U0001F4C8": ":\u56fe\u8868\u589e\u52a0:",
    u"\U0001F4B9": ":\u56fe\u8868\u968f\u65e5\u5143\u4e0a\u5347:",
    u"\U00002611\U0000FE0F": ":\u5e26\u590d\u9009\u6846:",
    u"\U00002714\U0000FE0F": ":\u590d\u9009\u6807\u8bb0:",
    u"\U0001F9C0": ":\u5976\u916a\u6954:",
    u"\U0001F3C1": ":\u9ed1\u767d\u65b9\u683c\u65d7:",
    u"\U0001F352": ":\u6a31\u6843:",
    u"\U0001F338": ":\u6a31\u82b1:",
    u"\U0000265F": ":\u68cb\u5b50:",
    u"\U0000265F\U0000FE0F": ":\u68cb\u5b50:",
    u"\U0001F330": ":\u677f\u6817:",
    u"\U0001F414": ":\u9e21:",
    u"\U0001F9D2": ":\u5c0f\u5b69:",
    u"\U0001F9D2\U0001F3FF": ":\u513f\u7ae5\u6697\u80a4\u8272:",
    u"\U0001F9D2\U0001F3FB": ":\u513f\u7ae5\u6d45\u80a4\u8272:",
    u"\U0001F9D2\U0001F3FE": ":\u513f\u7ae5\u4e2d\u6df1\u8272\u80a4\u8272:",
    u"\U0001F9D2\U0001F3FC": ":\u513f\u7ae5\u4e2d\u6d45\u80a4\u8272:",
    u"\U0001F9D2\U0001F3FD": ":\u513f\u7ae5\u4e2d\u7b49\u80a4\u8272:",
    u"\U0001F6B8": ":\u513f\u7ae5\u7a7f\u8d8a:",
    u"\U0001F43F": ":\u82b1\u6817\u9f20:",
    u"\U0001F43F\U0000FE0F": ":\u82b1\u6817\u9f20:",
    u"\U0001F36B": ":\u5de7\u514b\u529b\u68d2:",
    u"\U0001F962": ":\u7b77\u5b50:",
    u"\U000026EA": ":\u6559\u5802:",
    u"\U0001F6AC": ":\u9999\u70df:",
    u"\U0001F3A6": ":\u7535\u5f71\u9662:",
    u"\U000024C2": ":\u5e26\u5706\u5708M:",
    u"\U000024C2\U0000FE0F": ":\u5e26\u5706\u5708M:",
    u"\U0001F3AA": ":\u9a6c\u620f\u56e2\u5e10\u7bf7:",
    u"\U0001F3D9": ":\u57ce\u5e02\u666f\u89c2:",
    u"\U0001F306": ":\u9ec4\u660f\u7684\u57ce\u5e02\u666f\u8272:",
    u"\U0001F3D9\U0000FE0F": ":\u57ce\u5e02\u666f\u89c2:",
    u"\U0001F5DC": ":\u5939\u7d27:",
    u"\U0001F5DC\U0000FE0F": ":\u5939\u94b3:",
    u"\U0001F3AC": ":\u9694\u677f:",
    u"\U0001F44F": ":\u62cd\u624b:",
    u"\U0001F44F\U0001F3FF": ":\u62cd\u624b\u6697\u80a4\u8272:",
    u"\U0001F44F\U0001F3FB": ":\u62cd\u624b\u8f7b\u80a4\u8272:",
    u"\U0001F44F\U0001F3FE": ":\u62cd\u624b\u4e2d\u6df1\u8272\u80a4\u8272:",
    u"\U0001F44F\U0001F3FC": ":\u62cd\u624b\u4e2d\u6d45\u80a4\u8272:",
    u"\U0001F44F\U0001F3FD": ":\u62cd\u624b\u4e2d\u7b49\u80a4\u8272:",
    u"\U0001F3DB": ":\u53e4\u5178\u5efa\u7b51:",
    u"\U0001F3DB\U0000FE0F": ":\u7ecf\u5178\u5efa\u7b51:",
    u"\U0001F37B": ":\u78b0\u676f:",
    u"\U0001F942": ":\u78b0\u676f:",
    u"\U0001F4CB": ":\u526a\u8d34\u677f:",
    u"\U0001F503": ":\u987a\u65f6\u9488\u5782\u76f4\u7bad\u5934:",
    u"\U0001F4D5": ":\u95ed\u5f0f\u5e10\u7c3f:",
    u"\U0001F4EA": ":\u5e26\u964d\u4e0b\u6807\u5fd7\u7684\u5c01\u95ed\u90ae\u7bb1:",
    u"\U0001F4EB": ":\u5e26\u63d0\u5347\u6807\u5fd7\u7684\u5df2\u5173\u95ed\u90ae\u7bb1:",
    u"\U0001F302": ":\u5c01\u95ed\u5f0f\u96e8\u4f1e:",
    u"\U00002601": ":\u4e91:",
    u"\U00002601\U0000FE0F": ":\u4e91:",
    u"\U0001F329": ":\u95ea\u7535\u4e91:",
    u"\U000026C8": ":\u95ea\u7535\u96e8\u4e91:",
    u"\U000026C8\U0000FE0F": ":\u5e26\u95ea\u7535\u548c\u96e8\u7684\u4e91:",
    u"\U0001F329\U0000FE0F": ":\u5e26\u95ea\u7535\u7684\u4e91:",
    u"\U0001F327": ":\u96e8\u4e91:",
    u"\U0001F327\U0000FE0F": ":\u5e26\u96e8\u7684\u4e91:",
    u"\U0001F328": ":\u6709\u96ea\u7684\u4e91:",
    u"\U0001F328\U0000FE0F": ":\u5e26\u96ea\u7684\u4e91:",
    u"\U0001F921": ":\u5c0f\u4e11\u8138:",
    u"\U00002663": ":\u4ff1\u4e50\u90e8\u5957\u88c5:",
    u"\U00002663\U0000FE0F": ":\u4ff1\u4e50\u90e8\u5957\u88c5\u9009\u62e9:",
    u"\U0001F45D": ":\u79bb\u5408\u5668\u888b:",
    u"\U0001F9E5": ":\u5916\u5957:",
    u"\U0001F378": ":\u9e21\u5c3e\u9152\u676f:",
    u"\U0001F965": ":\u6930\u5b50:",
    u"\U000026B0": ":\u68fa\u6750:",
    u"\U000026B0\U0000FE0F": ":\u68fa\u6750:",
    u"\U0001F976": ":\u51b7\u9762:",
    u"\U0001F4A5": ":\u78b0\u649e:",
    u"\U00002604": ":\u5f57\u661f:",
    u"\U00002604\U0000FE0F": ":\u5f57\u661f:",
    u"\U0001F9ED": ":\u7f57\u76d8:",
    u"\U0001F4BD": ":\u8ba1\u7b97\u673a\u78c1\u76d8:",
    u"\U0001F5B1": ":\u7535\u8111\u9f20\u6807:",
    u"\U0001F5B1\U0000FE0F": ":\u8ba1\u7b97\u673a\u9f20\u6807:",
    u"\U0001F38A": ":\u4e94\u5f69\u7eb8\u7403:",
    u"\U0001F616": ":\u56f0\u60d1\u7684\u8138:",
    u"\U0001F615": ":\u56f0\u60d1\u7684\u8138:",
    u"\U0001F6A7": ":\u5efa\u8bbe:",
    u"\U0001F477": ":\u5efa\u7b51\u5de5\u4eba:",
    u"\U0001F477\U0001F3FF": ":\u5efa\u7b51\u5de5\u4eba\u80a4\u8272\u6697\u6c89:",
    u"\U0001F477\U0001F3FB": ":\u5efa\u7b51\u5de5\u4eba\u80a4\u8272\u6d45:",
    u"\U0001F477\U0001F3FE": ":\u5efa\u7b51\u5de5\u4eba\u4e2d\u9ed1\u80a4\u8272:",
    u"\U0001F477\U0001F3FC": ":\u5efa\u7b51\u5de5\u4eba\u4e2d\u6d45\u80a4\u8272:",
    u"\U0001F477\U0001F3FD": ":\u5efa\u7b51\u5de5\u4eba\u4e2d\u7b49\u80a4\u8272:",
    u"\U0001F39B": ":\u63a7\u5236\u65cb\u94ae:",
    u"\U0001F39B\U0000FE0F": ":\u63a7\u5236\u65cb\u94ae:",
    u"\U0001F3EA": ":\u4fbf\u5229\u5e97:",
    u"\U0001F35A": ":\u7c73\u996d:",
    u"\U0001F36A": ":\u66f2\u5947:",
    u"\U0001F373": ":\u70f9\u996a:",
    u"\U000000A9": ":\u7248\u6743:",
    u"\U000000A9\U0000FE0F": ":\u7248\u6743:",
    u"\U0001F6CB": ":\u6c99\u53d1\u548c\u706f:",
    u"\U0001F6CB\U0000FE0F": ":\u6c99\u53d1\u706f:",
    u"\U0001F504": ":\u9006\u65f6\u9488\u7bad\u5934\u6309\u94ae:",
    u"\U0001F468\U0000200D\U00002764\U0000200D\U0001F468": ":\u4e0e\u5fc3\u809d\u7537\u642d\u6863:",
    u"\U0001F469\U0000200D\U00002764\U0000200D\U0001F468": ":\u5fc3\u4e0a\u4eba:",
    u"\U0001F469\U0000200D\U00002764\U0000200D\U0001F469": ":\u5fc3\u4e0a\u4eba:",
    u"\U0001F491": ":\u5fc3\u5fc3\u76f8\u5370:",
    u"\U0001F468\U0000200D\U00002764\U0000FE0F\U0000200D\U0001F468": ":\u7537\u4eba\u4e0e\u7537\u4eba\u7684\u7ed3\u5408:",
    u"\U0001F469\U0000200D\U00002764\U0000FE0F\U0000200D\U0001F468": ":\u5fc3\u4e0a\u4eba:",
    u"\U0001F469\U0000200D\U00002764\U0000FE0F\U0000200D\U0001F469": ":\u5fc3\u4e0a\u4eba:",
    u"\U0001F404": ":\u5976\u725b:",
    u"\U0001F42E": ":\u725b\u8138:",
    u"\U0001F920": ":\u725b\u4ed4\u5e3d\u9762:",
    u"\U0001F980": ":\u87f9:",
    u"\U0001F58D": ":\u8721\u7b14:",
    u"\U0001F58D\U0000FE0F": ":\u8721\u7b14:",
    u"\U0001F4B3": ":\u4fe1\u7528\u5361:",
    u"\U0001F319": ":\u65b0\u6708:",
    u"\U0001F997": ":\u677f\u7403:",
    u"\U0001F3CF": ":\u677f\u7403\u6bd4\u8d5b:",
    u"\U0001F40A": ":\u9cc4\u9c7c:",
    u"\U0001F950": ":\u725b\u89d2\u9762\u5305:",
    u"\U0000274C": ":\u5341\u5b57\u8bb0\u53f7:",
    u"\U0000274E": ":\u5341\u5b57\u6807\u8bb0\u6309\u94ae:",
    u"\U0001F91E": ":\u7948\u7977:",
    u"\U0001F91E\U0001F3FF": ":\u4ea4\u53c9\u624b\u6307\u6df1\u8272\u80a4\u8272:",
    u"\U0001F91E\U0001F3FB": ":\u4ea4\u53c9\u624b\u6307\u6d45\u80a4\u8272:",
    u"\U0001F91E\U0001F3FE": ":\u4ea4\u53c9\u624b\u6307\u4e2d\u6df1\u8272\u80a4\u8272:",
    u"\U0001F91E\U0001F3FC": ":\u4ea4\u53c9\u624b\u6307\u4e2d\u6d45\u80a4\u8272:",
    u"\U0001F91E\U0001F3FD": ":\u4ea4\u53c9\u624b\u6307\u4e2d\u7b49\u80a4\u8272:",
    u"\U0001F38C": ":\u4ea4\u53c9\u65d7:",
    u"\U00002694": ":\u4ea4\u53c9\u7684\u5251:",
    u"\U00002694\U0000FE0F": ":\u4ea4\u53c9\u5251:",
    u"\U0001F451": ":\u738b\u51a0:",
    u"\U0001F63F": ":\u54ed\u54ed\u557c\u557c\u7684\u732b\u8138:",
    u"\U0001F622": ":\u54ed\u8138:",
    u"\U0001F52E": ":\u6c34\u6676\u7403:",
    u"\U0001F952": ":\u9ec4\u74dc:",
    u"\U0001F964": ":\u5438\u7ba1\u676f:",
    u"\U0001F9C1": ":\u7eb8\u676f\u86cb\u7cd5:",
    u"\U0001F94C": ":\u5377\u66f2\u77f3:",
    u"\U0001F468\U0000200D\U0001F9B1": ":\u5377\u53d1\u4eba:",
    u"\U0001F469\U0000200D\U0001F9B1": ":\u5377\u53d1\u5973\u4eba:",
    u"\U0001F9B1": ":\u5377\u53d1:",
    u"\U000027B0": ":\u5377\u66f2\u73af:",
    u"\U0001F4B1": ":\u8d27\u5e01\u5151\u6362:",
    u"\U0001F35B": ":\u5496\u55b1\u996d:",
    u"\U0001F36E": ":\u5976\u6cb9\u51bb:",
    u"\U0001F6C3": ":\u6d77\u5173:",
    u"\U0001F969": ":\u8089\u5757:",
    u"\U0001F300": ":\u65cb\u98ce:",
    u"\U0001F5E1": ":\u5315\u9996:",
    u"\U0001F5E1\U0000FE0F": ":\u9009\u62e9\u5315\u9996:",
    u"\U0001F361": ":\u4e39\u6208:",
    u"\U0001F3FF": ":\u6697\u80a4\u8272:",
    u"\U0001F4A8": ":\u51b2\u51fa\u53bb:",
    u"\U0001F9CF\U0001F3FF\U0000200D\U00002642": ":\u804b\u4eba\u6697\u80a4\u8272:",
    u"\U0001F9CF\U0001F3FF\U0000200D\U00002642\U0000FE0F": ":\u804b\u4eba\u6df1\u8272\u80a4\u8272:",
    u"\U0001F9CF\U0001F3FB\U0000200D\U00002642": ":\u804b\u4eba\u80a4\u8272\u6d45:",
    u"\U0001F9CF\U0001F3FB\U0000200D\U00002642\U0000FE0F": ":\u804b\u4eba\u6d45\u80a4\u8272:",
    u"\U0001F9CF\U0001F3FE\U0000200D\U00002642": ":\u804b\u4eba\u4e2d\u6df1\u8272\u80a4\u8272:",
    u"\U0001F9CF\U0001F3FE\U0000200D\U00002642\U0000FE0F": ":\u804b\u4eba\u4e2d\u6df1\u8272\u80a4\u8272:",
    u"\U0001F9CF\U0001F3FC\U0000200D\U00002642": ":\u804b\u4eba\u4e2d\u6d45\u80a4\u8272:",
    u"\U0001F9CF\U0001F3FC\U0000200D\U00002642\U0000FE0F": ":\u804b\u4eba\u4e2d\u6d45\u80a4\u8272:",
    u"\U0001F9CF\U0001F3FD\U0000200D\U00002642": ":\u804b\u4eba\u4e2d\u7b49\u80a4\u8272:",
    u"\U0001F9CF\U0001F3FD\U0000200D\U00002642\U0000FE0F": ":\u804b\u4eba\u4e2d\u7b49\u80a4\u8272:",
    u"\U0001F9CF\U0000200D\U00002642": ":\u804b\u5b50:",
    u"\U0001F9CF\U0000200D\U00002642\U0000FE0F": ":\u804b\u4eba:",
    u"\U0001F9CF\U0001F3FF": ":\u804b\u4eba\u6697\u80a4\u8272:",
    u"\U0001F9CF\U0001F3FB": ":\u804b\u4eba\u6d45\u80a4\u8272:",
    u"\U0001F9CF\U0001F3FE": ":\u804b\u4eba\u4e2d\u6df1\u8272\u80a4\u8272:",
    u"\U0001F9CF\U0001F3FC": ":\u804b\u4eba\u4e2d\u6d45\u80a4\u8272:",
    u"\U0001F9CF\U0001F3FD": ":\u804b\u4eba\u4e2d\u7b49\u80a4\u8272:",
    u"\U0001F9CF": ":\u804b\u5b50:",
    u"\U0001F9CF\U0001F3FF\U0000200D\U00002640": ":\u804b\u5973\u6697\u80a4\u8272:",
    u"\U0001F9CF\U0001F3FF\U0000200D\U00002640\U0000FE0F": ":\u804b\u5973\u6df1\u8272\u80a4\u8272:",
    u"\U0001F9CF\U0001F3FB\U0000200D\U00002640": ":\u804b\u5973\u6d45\u80a4\u8272:",
    u"\U0001F9CF\U0001F3FB\U0000200D\U00002640\U0000FE0F": ":\u804b\u5973\u6d45\u80a4\u8272:",
    u"\U0001F9CF\U0001F3FE\U0000200D\U00002640": ":\u804b\u5973\u4e2d\u6df1\u8272\u80a4\u8272:",
    u"\U0001F9CF\U0001F3FE\U0000200D\U00002640\U0000FE0F": ":\u804b\u5973\u4e2d\u6df1\u8272\u80a4\u8272:",
    u"\U0001F9CF\U0001F3FC\U0000200D\U00002640": ":\u804b\u5973\u4e2d\u6d45\u80a4\u8272:",
    u"\U0001F9CF\U0001F3FC\U0000200D\U00002640\U0000FE0F": ":\u804b\u5973\u4e2d\u6d45\u80a4\u8272:",
    u"\U0001F9CF\U0001F3FD\U0000200D\U00002640": ":\u804b\u5973\u4e2d\u7b49\u80a4\u8272:",
    u"\U0001F9CF\U0001F3FD\U0000200D\U00002640\U0000FE0F": ":\u804b\u5973\u4e2d\u7b49\u80a4\u8272\u9009\u62e9:",
    u"\U0001F9CF\U0000200D\U00002640": ":\u804b\u5973:",
    u"\U0001F9CF\U0000200D\U00002640\U0000FE0F": ":\u804b\u5973\u9009\u62e9:",
    u"\U0001F333": ":\u843d\u53f6\u6811:",
    u"\U0001F98C": ":\u9e7f:",
    u"\U0001F69A": ":\u8fd0\u8d27\u8f66:",
    u"\U0001F3EC": ":\u767e\u8d27\u516c\u53f8:",
    u"\U0001F3DA": ":\u5e9f\u5f03\u623f\u5c4b:",
    u"\U0001F3DA\U0000FE0F": ":\u88ab\u9057\u5f03\u7684\u623f\u5c4b:",
    u"\U0001F3DC": ":\u6c99\u6f20:",
    u"\U0001F3DD": ":\u8352\u5c9b:",
    u"\U0001F3DD\U0000FE0F": ":\u8352\u5c9b:",
    u"\U0001F3DC\U0000FE0F": ":\u6c99\u6f20:",
    u"\U0001F5A5": ":\u53f0\u5f0f\u8ba1\u7b97\u673a:",
    u"\U0001F5A5\U0000FE0F": ":\u684c\u9762\u8ba1\u7b97\u673a:",
    u"\U0001F575": ":\u4fa6\u63a2:",
    u"\U0001F575\U0001F3FF": ":\u6df1\u8272\u80a4\u8272\u63a2\u957f:",
    u"\U0001F575\U0001F3FB": ":\u6d45\u80a4\u8272\u63a2\u957f:",
    u"\U0001F575\U0001F3FE": ":\u4e2d\u9ed1\u80a4\u8272\u4fa6\u63a2:",
    u"\U0001F575\U0001F3FC": ":\u6d45\u80a4\u8272\u63a2\u6d4b\u4eea:",
    u"\U0001F575\U0001F3FD": ":\u4e2d\u7b49\u80a4\u8272:",
    u"\U0001F575\U0000FE0F": ":\u63a2\u6d4b:",
    u"\U00002666": ":\u94bb\u77f3\u5957\u88c5:",
    u"\U00002666\U0000FE0F": ":\u94bb\u77f3\u5957\u88c5\u9009\u62e9:",
    u"\U0001F4A0": ":\u5e26\u70b9\u7684\u83f1\u5f62:",
    u"\U0001F505": ":\u53d8\u6697\u6309\u94ae:",
    u"\U0001F3AF": ":\u76f4\u63a5\u547d\u4e2d:",
    u"\U0001F61E": ":\u5931\u671b\u7684\u8138:",
    u"\U0001F93F": ":\u6f5c\u6c34\u9762\u7f69:",
    u"\U0001FA94": ":\u8fea\u96c5\u706f:",
    u"\U0001F4AB": ":\u5934\u6655:",
    u"\U0001F635": ":\u5934\u6655:",
    u"\U0001F9EC": ":DNA:",
    u"\U0001F415": ":\u72d7:",
    u"\U0001F436": ":\u72d7\u8138:",
    u"\U0001F4B5": ":\u7f8e\u5143\u949e\u7968:",
    u"\U0001F42C": ":\u6d77\u8c5a:",
    u"\U0001F6AA": ":\u95e8:",
    u"\U0001F52F": ":\u70b9\u516d\u89d2\u661f:",
    u"\U000027BF": ":\u53cc\u5377\u5708:",
    u"\U0000203C": ":\u53cc\u611f\u53f9\u53f7:",
    u"\U0000203C\U0000FE0F": ":\u53cc\u611f\u53f9\u53f7:",
    u"\U0001F369": ":\u751c\u751c\u5708:",
    u"\U0001F54A": ":\u9e3d\u5b50:",
    u"\U0001F54A\U0000FE0F": ":\u9e3d\u5b50:",
    u"\U00002199": ":\u5de6\u4e0b\u7bad\u5934:",
    u"\U00002199\U0000FE0F": ":\u5de6\u4e0b\u7bad\u5934:",
    u"\U00002198": ":\u53f3\u4e0b\u7bad\u5934:",
    u"\U00002198\U0000FE0F": ":\u53f3\u4e0b\u7bad\u5934:",
    u"\U00002B07": ":\u4e0b\u7bad\u5934:",
    u"\U00002B07\U0000FE0F": ":\u4e0b\u7bad\u5934:",
    u"\U0001F613": ":\u6c57\u6d41\u6ee1\u9762:",
    u"\U0001F53D": ":\u5411\u4e0b\u6309\u94ae:",
    u"\U0001F409": ":\u9f99:",
    u"\U0001F432": ":\u9f99\u8138:",
    u"\U0001F457": ":\u8fde\u8863\u88d9:",
    u"\U0001F924": ":\u6d41\u53e3\u6c34\u7684\u8138:",
    u"\U0001FA78": ":\u8840\u6ef4:",
    u"\U0001F4A7": ":\u6db2\u6ef4:",
    u"\U0001F941": ":\u9f13:",
    u"\U0001F986": ":\u9e2d\u5b50:",
    u"\U0001F95F": ":\u997a\u5b50:",
    u"\U0001F4C0": ":DVD:",
    u"\U0001F4E7": ":\u7535\u5b50\u90ae\u4ef6:",
    u"\U0001F985": ":\u9e70:",
    u"\U0001F442": ":\u8033\u6735:",
    u"\U0001F442\U0001F3FF": ":\u8033\u90e8\u6697\u80a4\u8272:",
    u"\U0001F442\U0001F3FB": ":\u8033\u5149\u80a4\u8272:",
    u"\U0001F442\U0001F3FE": ":\u8033\u6735\u4e2d\u6df1\u8272\u80a4\u8272:",
    u"\U0001F442\U0001F3FC": ":\u8033\u6735\u4e2d\u6d45\u80a4\u8272:",
    u"\U0001F442\U0001F3FD": ":\u4e2d\u8033\u80a4\u8272:",
    u"\U0001F33D": ":\u7389\u7c73\u7a57:",
    u"\U0001F9BB\U0001F3FF": ":\u8033\u90e8\u6709\u52a9\u542c\u5668\uff0c\u80a4\u8272\u6697\u6c89:",
    u"\U0001F9BB\U0001F3FB": ":\u5e26\u52a9\u542c\u5668\u7684\u8033\u6735\u80a4\u8272\u6d45:",
    u"\U0001F9BB\U0001F3FE": ":\u5e26\u52a9\u542c\u5668\u7684\u8033\u6735-\u4e2d\u7b49\u80a4\u8272:",
    u"\U0001F9BB\U0001F3FC": ":\u5e26\u52a9\u542c\u5668\u7684\u8033\u6735\u4e2d\u7b49\u6d45\u80a4\u8272:",
    u"\U0001F9BB\U0001F3FD": ":\u5e26\u52a9\u542c\u5668\u7684\u8033\u6735\u4e2d\u7b49\u80a4\u8272:",
    u"\U0001F9BB": ":\u5e26\u52a9\u542c\u5668\u7684\u8033\u6735:",
    u"\U0001F95A": ":\u9e21\u86cb:",
    u"\U0001F346": ":\u8304\u5b50:",
    u"\U00002734": ":\u516b\u89d2\u661f:",
    u"\U00002734\U0000FE0F": ":\u516b\u89d2\u661f\u578b:",
    u"\U00002733": ":\u516b\u8f90\u661f\u53f7:",
    u"\U00002733\U0000FE0F": ":\u516b\u8f90\u661f\u53f7:",
    u"\U0001F563": ":\u516b\u70b9\u534a:",
    u"\U0001F557": ":\u516b\u70b9\u949f:",
    u"\U000023CF": ":\u5f39\u51fa\u6309\u94ae:",
    u"\U000023CF\U0000FE0F": ":\u5f39\u51fa\u6309\u94ae:",
    u"\U0001F50C": ":\u7535\u6c14\u63d2\u5934:",
    u"\U0001F418": ":\u5927\u8c61:",
    u"\U0001F566": ":\u5341\u4e00\u70b9\u534a:",
    u"\U0001F55A": ":\u5341\u4e00\u70b9\u949f:",
    u"\U0001F9DD": ":\u7cbe\u7075:",
    u"\U0001F9DD\U0001F3FF": ":\u7cbe\u7075\u9ed1\u80a4\u8272:",
    u"\U0001F9DD\U0001F3FB": ":\u7cbe\u7075\u6d45\u80a4\u8272:",
    u"\U0001F9DD\U0001F3FE": ":\u7cbe\u7075\u4e2d\u9ed1\u80a4\u8272:",
    u"\U0001F9DD\U0001F3FC": ":\u7cbe\u7075\u4e2d\u6d45\u80a4\u8272:",
    u"\U0001F9DD\U0001F3FD": ":\u7cbe\u7075\u4e2d\u7b49\u80a4\u8272:",
    u"\U00002709": ":\u4fe1\u5c01:",
    u"\U00002709\U0000FE0F": ":\u4fe1\u5c01:",
    u"\U0001F4E9": ":\u5e26\u7bad\u5934\u7684\u4fe1\u5c01:",
    u"\U0001F4B6": ":\u6b27\u5143\u7eb8\u5e01:",
    u"\U0001F332": ":\u5e38\u7eff\u4e54\u6728:",
    u"\U0001F411": ":\u6bcd\u7f8a:",
    u"\U00002757": ":\u611f\u53f9\u53f7:",
    u"\U00002049": ":\u611f\u53f9\u95ee\u53f7:",
    u"\U00002049\U0000FE0F": ":\u611f\u53f9\u53f7\u95ee\u53f7:",
    u"\U0001F92F": ":\u7206\u70b8\u5934:",
    u"\U0001F611": ":\u65e0\u8868\u60c5\u7684\u8138:",
    u"\U0001F441": ":\u773c\u775b:",
    u"\U0001F441\U0000200D\U0001F5E8": ":\u8a00\u8bed\u4e2d\u7684\u773c\u775b:",
    u"\U0001F441\U0000200D\U0001F5E8\U0000FE0F": ":\u8bed\u97f3\u6ce1\u6ce12:",
    u"\U0001F441\U0000FE0F\U0000200D\U0001F5E8\U0000FE0F": ":\u8bed\u97f3\u6ce1\u6ce13:",
    u"\U0001F441\U0000FE0F\U0000200D\U0001F5E8": ":\u8bed\u97f3\u6c14\u6ce1:",
    u"\U0001F441\U0000FE0F": ":\u773c\u775b:",
    u"\U0001F440": ":\u773c\u775b:",
    u"\U0001F618": ":\u5439\u8138\u543b:",
    u"\U0001F60B": ":\u54c1\u5c1d\u98df\u7269\u7684\u8138:",
    u"\U0001F631": ":\u6050\u60e7\u4e2d\u5c16\u53eb\u7684\u8138:",
    u"\U0001F92E": ":\u9762\u90e8\u5455\u5410:",
    u"\U0001F92D": ":\u5634\u89d2\u4ea4\u53e0\u7684\u8138:",
    u"\U0001F915": ":\u5934\u5dfe\u5305\u624e:",
    u"\U0001F637": ":\u5e26\u533b\u7528\u9762\u7f69\u7684\u8138:",
    u"\U0001F9D0": ":\u5355\u773c\u8138:",
    u"\U0001F62E": ":\u5f20\u5634\u7684\u8138:",
    u"\U0001F928": ":\u626c\u8d77\u7709\u6bdb\u7684\u8138:",
    u"\U0001F644": ":\u773c\u775b\u6253\u8f6c\u7684\u8138:",
    u"\U0001F624": ":\u9f3b\u5b50\u5192\u7740\u84b8\u6c7d\u7684\u8138:",
    u"\U0001F92C": ":\u5634\u4e0a\u6709\u7b26\u53f7\u7684\u8138:",
    u"\U0001F602": ":\u559c\u6781\u800c\u6ce3:",
    u"\U0001F912": ":\u5e26\u6e29\u5ea6\u8ba1\u7684\u8138:",
    u"\U0001F61B": ":\u7528\u820c\u5934\u9762\u5bf9:",
    u"\U0001F636": ":\u6ca1\u6709\u5634\u7684\u8138:",
    u"\U0001F3ED": ":\u5de5\u5382:",
    u"\U0001F9DA": ":\u4ed9\u5973:",
    u"\U0001F9DA\U0001F3FF": ":\u795e\u4ed9\u9ed1\u80a4\u8272:",
    u"\U0001F9DA\U0001F3FB": ":\u4ed9\u5973\u822c\u7684\u6d45\u80a4\u8272:",
    u"\U0001F9DA\U0001F3FE": ":\u4ed9\u5973\u4e2d\u9ed1\u80a4\u8272:",
    u"\U0001F9DA\U0001F3FC": ":\u4ed9\u5973\u4e2d\u6d45\u80a4\u8272:",
    u"\U0001F9DA\U0001F3FD": ":\u4ed9\u5973\u4e2d\u7b49\u80a4\u8272:",
    u"\U0001F9C6": ":\u6cd5\u62c9\u8d39:",
    u"\U0001F342": ":\u843d\u53f6:",
    u"\U0001F46A": ":\u5bb6\u5ead:",
    u"\U0001F468\U0000200D\U0001F466": ":\u5bb6\u5ead\u7537\u4eba\u7537\u5b69:",
    u"\U0001F468\U0000200D\U0001F466\U0000200D\U0001F466": ":\u5bb6\u5ead\u7537\u4eba\u7537\u5b69\u7537\u5b69:",
    u"\U0001F468\U0000200D\U0001F467": ":\u5bb6\u5ead\u7537\u5973:",
    u"\U0001F468\U0000200D\U0001F467\U0000200D\U0001F466": ":\u5bb6\u5ead\u7537\u4eba\u5973\u5b69\u7537\u5b69:",
    u"\U0001F468\U0000200D\U0001F467\U0000200D\U0001F467": ":\u5bb6\u5ead\u7537\u4eba\u5973\u5b69\u5973\u5b69:",
    u"\U0001F468\U0000200D\U0001F468\U0000200D\U0001F466": ":\u5bb6\u5ead\u7537\u4eba\u7537\u4eba\u7537\u5b69:",
    u"\U0001F468\U0000200D\U0001F468\U0000200D\U0001F466\U0000200D\U0001F466": ":\u5bb6\u5ead\u7537\u4eba\u7537\u4eba\u7537\u5b69\u7537\u5b69\u7537\u5b69:",
    u"\U0001F468\U0000200D\U0001F468\U0000200D\U0001F467": ":\u5bb6\u5ead\u7537\u7537\u5973\u5973:",
    u"\U0001F468\U0000200D\U0001F468\U0000200D\U0001F467\U0000200D\U0001F466": ":\u5bb6\u5ead\u7537\u4eba\u7537\u4eba\u5973\u5b69\u7537\u5b69:",
    u"\U0001F468\U0000200D\U0001F468\U0000200D\U0001F467\U0000200D\U0001F467": ":\u5bb6\u5ead\u7537\u7537\u5973\u5973:",
    u"\U0001F468\U0000200D\U0001F469\U0000200D\U0001F466": ":\u5bb6\u5ead\u7537\u4eba\u5973\u4eba\u7537\u5b69:",
    u"\U0001F468\U0000200D\U0001F469\U0000200D\U0001F466\U0000200D\U0001F466": ":\u5bb6\u5ead\u7537\u4eba\u5973\u4eba\u7537\u5b69\u7537\u5b69:",
    u"\U0001F468\U0000200D\U0001F469\U0000200D\U0001F467": ":\u5bb6\u5ead\u7537\u7537\u5973\u5973:",
    u"\U0001F468\U0000200D\U0001F469\U0000200D\U0001F467\U0000200D\U0001F466": ":\u5bb6\u5ead\u7537\u4eba\u5973\u4eba\u5973\u5b69\u7537\u5b69:",
    u"\U0001F468\U0000200D\U0001F469\U0000200D\U0001F467\U0000200D\U0001F467": ":\u5bb6\u5ead\u7537\u4eba\u5973\u4eba\u5973\u5b69\u5973\u5b69:",
    u"\U0001F469\U0000200D\U0001F466": ":\u5bb6\u5ead\u5973\u5b69\u513f:",
    u"\U0001F469\U0000200D\U0001F466\U0000200D\U0001F466": ":\u5bb6\u5ead\u5987\u5973\u7537\u5b69\u7537\u5b69:",
    u"\U0001F469\U0000200D\U0001F467": ":\u5bb6\u5ead\u5973\u5b69\u513f:",
    u"\U0001F469\U0000200D\U0001F467\U0000200D\U0001F466": ":\u5bb6\u5ead\u5987\u5973\u5973\u5b69\u7537\u5b69:",
    u"\U0001F469\U0000200D\U0001F467\U0000200D\U0001F467": ":\u5bb6\u5ead\u5973\u5b69\u513f:",
    u"\U0001F469\U0000200D\U0001F469\U0000200D\U0001F466": ":\u5bb6\u5ead\u5987\u5973\u5987\u5973\u7537\u5b69:",
    u"\U0001F469\U0000200D\U0001F469\U0000200D\U0001F466\U0000200D\U0001F466": ":\u5bb6\u5ead\u5987\u5973\u5987\u5973\u7537\u5b69\u7537\u5b69:",
    u"\U0001F469\U0000200D\U0001F469\U0000200D\U0001F467": ":\u5bb6\u5ead\u5987\u5973\u5973\u5b69:",
    u"\U0001F469\U0000200D\U0001F469\U0000200D\U0001F467\U0000200D\U0001F466": ":\u5bb6\u5ead\u5987\u5973\u5987\u5973\u5973\u5b69\u7537\u5b69:",
    u"\U0001F469\U0000200D\U0001F469\U0000200D\U0001F467\U0000200D\U0001F467": ":\u5bb6\u5ead\u5987\u5973\u5987\u5973\u5973\u5b69\u5973\u5b69:",
    u"\U000023E9": ":\u5feb\u8fdb\u6309\u94ae:",
    u"\U000023EC": ":\u5feb\u901f\u4e0b\u964d\u6309\u94ae:",
    u"\U000023EA": ":\u5feb\u901f\u540e\u9000\u6309\u94ae:",
    u"\U000023EB": ":\u5feb\u901f\u4e0a\u5347\u6309\u94ae:",
    u"\U0001F4E0": ":\u4f20\u771f\u673a:",
    u"\U0001F628": ":\u6050\u60e7\u7684\u8138:",
    u"\U00002640": ":\u5973\u6027\u6807\u5fd7:",
    u"\U00002640\U0000FE0F": ":\u5973\u6027\u6807\u5fd7:",
    u"\U0001F3A1": ":\u6469\u5929\u8f6e:",
    u"\U000026F4": ":\u6e21\u8239:",
    u"\U000026F4\U0000FE0F": ":\u8f6e\u6e21:",
    u"\U0001F3D1": ":\u66f2\u68cd\u7403:",
    u"\U0001F5C4": ":\u6587\u4ef6\u67dc:",
    u"\U0001F5C4\U0000FE0F": ":\u6587\u4ef6\u67dc:",
    u"\U0001F4C1": ":\u6587\u4ef6\u5939:",
    u"\U0001F39E": ":\u5e95\u7247\u6846\u67b6:",
    u"\U0001F39E\U0000FE0F": ":\u80f6\u7247\u6846:",
    u"\U0001F4FD": ":\u7535\u5f71\u653e\u6620\u673a:",
    u"\U0001F4FD\U0000FE0F": ":\u7535\u5f71\u653e\u6620\u673a:",
    u"\U0001F525": ":\u706b:",
    u"\U0001F692": ":\u6d88\u9632\u8f66:",
    u"\U0001F9EF": ":\u706d\u706b\u5668:",
    u"\U0001F9E8": ":\u97ad\u70ae:",
    u"\U0001F386": ":\u70df\u706b:",
    u"\U0001F313": ":\u7b2c\u4e00\u5b63\u5ea6\u6708\u4eae:",
    u"\U0001F31B": ":\u7b2c\u4e00\u5b63\u5ea6\u6708\u9762:",
    u"\U0001F41F": ":\u9c7c:",
    u"\U0001F365": ":\u6f29\u6da1\u9c7c\u7cd5:",
    u"\U0001F3A3": ":\u9493\u9c7c\u7aff:",
    u"\U0001F560": ":\u4e94\u70b9\u534a:",
    u"\U0001F554": ":\u4e94\u70b9\u949f:",
    u"\U000026F3": ":\u6d1e\u5185\u65d7\u5b50:",
    u"\U0001F9A9": ":\u706b\u70c8\u9e1f:",
    u"\U0001F526": ":\u624b\u7535\u7b52:",
    u"\U0001F97F": ":\u5e73\u5e95\u978b:",
    u"\U0000269C": ":\u73ab\u7470\u82b1:",
    u"\U0000269C\U0000FE0F": ":\u767e\u5408\u82b1\u9970:",
    u"\U0001F4AA": ":\u5c48\u808c:",
    u"\U0001F4AA\U0001F3FF": ":\u5f2f\u66f2\u7684\u4e8c\u5934\u808c\u6df1\u8272\u80a4\u8272:",
    u"\U0001F4AA\U0001F3FB": ":\u5f2f\u66f2\u4e8c\u5934\u808c\u6d45\u80a4\u8272:",
    u"\U0001F4AA\U0001F3FE": ":\u5f2f\u66f2\u7684\u4e8c\u5934\u808c\u4e2d\u7b49\u6df1\u8272\u80a4\u8272:",
    u"\U0001F4AA\U0001F3FC": ":\u5f2f\u66f2\u7684\u4e8c\u5934\u808c\u4e2d\u7b49\u6d45\u80a4\u8272:",
    u"\U0001F4AA\U0001F3FD": ":\u5f2f\u66f2\u7684\u80b1\u4e8c\u5934\u808c\u4e2d\u7b49\u80a4\u8272:",
    u"\U0001F4BE": ":\u8f6f\u76d8:",
    u"\U0001F3B4": ":\u82b1\u6251\u514b\u724c:",
    u"\U0001F633": ":\u8138\u7ea2:",
    u"\U0001F94F": ":\u98de\u789f:",
    u"\U0001F6F8": ":\u98de\u789f:",
    u"\U0001F32B": ":\u96fe:",
    u"\U0001F32B\U0000FE0F": ":\u96fe:",
    u"\U0001F301": ":\u96fe:",
    u"\U0001F64F": ":\u53cc\u624b\u5408\u5341:",
    u"\U0001F64F\U0001F3FF": ":\u53cc\u624b\u5408\u5341\u6df1\u8272\u80a4\u8272:",
    u"\U0001F64F\U0001F3FB": ":\u53cc\u624b\u5408\u5341\u6d45\u80a4\u8272:",
    u"\U0001F64F\U0001F3FE": ":\u53cc\u624b\u5408\u5341\u4e2d\u6df1\u8272\u80a4\u8272:",
    u"\U0001F64F\U0001F3FC": ":\u53cc\u624b\u5408\u5341\u4e2d\u6d45\u80a4\u8272:",
    u"\U0001F64F\U0001F3FD": ":\u53cc\u624b\u5408\u5341\u4e2d\u7b49\u80a4\u8272:",
    u"\U0001F9B6\U0001F3FF": ":\u8db3\u90e8\u80a4\u8272\u6697\u6c89:",
    u"\U0001F9B6\U0001F3FB": ":\u8db3\u90e8\u6d45\u80a4\u8272:",
    u"\U0001F9B6\U0001F3FE": ":\u8db3\u90e8\u4e2d\u6df1\u8272\u80a4\u8272:",
    u"\U0001F9B6\U0001F3FC": ":\u4e2d\u6d45\u80a4\u8272:",
    u"\U0001F9B6\U0001F3FD": ":\u8db3\u90e8\u4e2d\u7b49\u80a4\u8272:",
    u"\U0001F9B6": ":\u811a:",
    u"\U0001F463": ":\u811a\u5370:",
    u"\U0001F374": ":\u5200\u53c9:",
    u"\U0001F37D": ":\u5e26\u76d8\u5b50\u7684\u5200\u53c9:",
    u"\U0001F37D\U0000FE0F": ":\u5e26\u9009\u677f\u5668\u7684\u5200\u53c9:",
    u"\U0001F960": ":\u5e78\u8fd0\u997c\u5e72:",
    u"\U000026F2": ":\u55b7\u6cc9:",
    u"\U0001F58B": ":\u81ea\u6765\u6c34\u7b14:",
    u"\U0001F58B\U0000FE0F": ":\u81ea\u6765\u6c34\u7b14:",
    u"\U0001F55F": ":\u56db\u70b9\u534a:",
    u"\U0001F340": ":\u56db\u53f6\u8349:",
    u"\U0001F553": ":\u56db\u70b9\u949f:",
    u"\U0001F98A": ":\u72d0\u72f8\u8138:",
    u"\U0001F5BC": ":\u9576\u6846\u56fe\u7247:",
    u"\U0001F5BC\U0000FE0F": ":\u5e26\u6846\u56fe\u7247:",
    u"\U0001F35F": ":\u70b8\u85af\u6761:",
    u"\U0001F364": ":\u70b8\u867e\u4ec1:",
    u"\U0001F438": ":\u9752\u86d9\u8138:",
    u"\U0001F425": ":\u524d\u8138\u5c0f\u9e21:",
    u"\U00002639": ":\u76b1\u7709\u7684\u8138:",
    u"\U00002639\U0000FE0F": ":\u76b1\u7709\u5934:",
    u"\U0001F626": ":\u5f20\u5634\u76b1\u7709:",
    u"\U000026FD": ":\u71c3\u6cb9\u6cf5:",
    u"\U0001F315": ":\u6ee1\u6708:",
    u"\U0001F31D": ":\u6ee1\u6708\u8138:",
    u"\U000026B1": ":\u4e27\u846c\u74ee:",
    u"\U000026B1\U0000FE0F": ":\u9aa8\u7070\u76d2:",
    u"\U0001F3B2": ":\u6e38\u620f\u6b7b\u4ea1:",
    u"\U0001F9C4": ":\u5927\u849c:",
    u"\U00002699": ":\u9f7f\u8f6e:",
    u"\U00002699\U0000FE0F": ":\u6362\u6863\u6746:",
    u"\U0001F48E": ":\u5b9d\u77f3:",
    u"\U0001F9DE": ":\u7cbe\u7075:",
    u"\U0001F47B": ":\u9b3c:",
    u"\U0001F992": ":\u957f\u9888\u9e7f:",
    u"\U0001F467": ":\u5973\u5b69:",
    u"\U0001F467\U0001F3FF": ":\u5973\u5b69\u6697\u80a4\u8272:",
    u"\U0001F467\U0001F3FB": ":\u5973\u5b69\u6d45\u80a4\u8272:",
    u"\U0001F467\U0001F3FE": ":\u5973\u5b69\u4e2d\u6df1\u8272\u80a4\u8272:",
    u"\U0001F467\U0001F3FC": ":\u5973\u5b69\u4e2d\u6d45\u80a4\u8272:",
    u"\U0001F467\U0001F3FD": ":\u5973\u5b69\u4e2d\u7b49\u80a4\u8272:",
    u"\U0001F95B": ":\u4e00\u676f\u725b\u5976:",
    u"\U0001F453": ":\u73bb\u7483\u676f:",
    u"\U0001F30E": ":\u73af\u7403\u5c55\u7f8e\u6d32:",
    u"\U0001F30F": ":\u4e9a\u6d32\u6fb3\u5927\u5229\u4e9a\u73af\u7403\u5c55:",
    u"\U0001F30D": ":\u73af\u7403\u5c55\u6b27\u6d32\u975e\u6d32:",
    u"\U0001F310": ":\u6709\u5b50\u5348\u7ebf\u7684\u5730\u7403\u4eea:",
    u"\U0001F9E4": ":\u624b\u5957:",
    u"\U0001F31F": ":\u53d1\u5149\u7684\u661f\u661f:",
    u"\U0001F945": ":\u7403\u95e8\u7f51:",
    u"\U0001F410": ":\u5c71\u7f8a:",
    u"\U0001F47A": ":\u5996\u7cbe:",
    u"\U0001F97D": ":\u62a4\u76ee\u955c:",
    u"\U0001F98D": ":\u5927\u7329\u7329:",
    u"\U0001F393": ":\u523b\u5ea6\u5e3d:",
    u"\U0001F347": ":\u8461\u8404:",
    u"\U0001F34F": ":\u9752\u82f9\u679c:",
    u"\U0001F4D7": ":\u7eff\u76ae\u4e66:",
    u"\U0001F7E2": ":\u7eff\u8272\u5706\u5708:",
    u"\U0001F49A": ":\u9752\u5fc3\u6811:",
    u"\U0001F957": ":\u852c\u83dc\u6c99\u62c9:",
    u"\U0001F7E9": ":\u7eff\u8272\u5e7f\u573a:",
    u"\U0001F62C": ":\u6b6a\u626d:",
    u"\U0001F63A": ":\u54a7\u5634\u7b11\u7684\u732b\u8138:",
    u"\U0001F638": ":\u7b11\u772f\u772f\u7684\u732b\u8138:",
    u"\U0001F600": ":\u7b11\u8138:",
    u"\U0001F603": ":\u7b11\u8138\u5927\u773c\u775b:",
    u"\U0001F604": ":\u7b11\u772f\u772f\u7684\u8138:",
    u"\U0001F605": ":\u6ee1\u8138\u6c57\u6c34:",
    u"\U0001F606": ":\u7b11\u772f\u772f\u7684\u8138:",
    u"\U0001F497": ":\u6210\u957f\u7684\u5fc3:",
    u"\U0001F482": ":\u8b66\u536b:",
    u"\U0001F482\U0001F3FF": ":\u62a4\u9ed1\u80a4\u8272:",
    u"\U0001F482\U0001F3FB": ":\u62a4\u5149\u80a4\u8272:",
    u"\U0001F482\U0001F3FE": ":\u4e2d\u9ed1\u80a4\u8272:",
    u"\U0001F482\U0001F3FC": ":\u4e2d\u6d45\u80a4\u8272:",
    u"\U0001F482\U0001F3FD": ":\u4e2d\u7b49\u80a4\u8272:",
    u"\U0001F9AE": ":\u5bfc\u76f2\u72ac:",
    u"\U0001F3B8": ":\u5409\u4ed6:",
    u"\U0001F354": ":\u6c49\u5821\u5305:",
    u"\U0001F528": ":\u94c1\u9524:",
    u"\U00002692": ":\u9524\u5b50\u548c\u9550:",
    u"\U00002692\U0000FE0F": ":\u9524\u5f0f\u548c\u9550\u5f0f:",
    u"\U0001F6E0": ":\u9524\u5b50\u548c\u6273\u624b:",
    u"\U0001F6E0\U0000FE0F": ":\u9524\u5b50\u548c\u6273\u624b:",
    u"\U0001F439": ":\u4ed3\u9f20\u8138:",
    u"\U0001F590": ":\u624b\u6307\u5f20\u5f00\u7684\u624b:",
    u"\U0001F590\U0001F3FF": ":\u624b\u6307\u5f20\u5f00\u7684\u624b\u5448\u6df1\u80a4\u8272:",
    u"\U0001F590\U0001F3FB": ":\u624b\u6307\u5f20\u5f00\u7684\u624b\u6d45\u80a4\u8272:",
    u"\U0001F590\U0001F3FE": ":\u624b\u6307\u5f20\u5f00\u7684\u624b\u5448\u4e2d\u6df1\u8272\u80a4\u8272:",
    u"\U0001F590\U0001F3FC": ":\u624b\u6307\u5f20\u5f00\u7684\u624b\u4e2d\u7b49\u6d45\u80a4\u8272:",
    u"\U0001F590\U0001F3FD": ":\u624b\u6307\u5f20\u5f00\u7684\u624b\u4e2d\u7b49\u80a4\u8272:",
    u"\U0001F590\U0000FE0F": ":\u624b\u6307\u5f20\u5f00\u5f0f:",
    u"\U0001F45C": ":\u624b\u63d0\u5305:",
    u"\U0001F91D": ":\u63e1\u624b:",
    u"\U0001F423": ":\u5b75\u5316\u5c0f\u9e21:",
    u"\U0001F3A7": ":\u8033\u673a:",
    u"\U0001F649": ":\u542c\u4e0d\u89c1\u90aa\u6076\u7684\u7334\u5b50:",
    u"\U0001F49F": ":\u5fc3\u5f62\u88c5\u9970:",
    u"\U00002763\U0000FE0F": ":\u5fc3\u58f0\u611f\u53f9:",
    u"\U00002665": ":\u5fc3\u5f62\u5957\u88c5:",
    u"\U00002665\U0000FE0F": ":\u5fc3\u810f\u5957\u88c5:",
    u"\U0001F498": ":\u5fc3\u5f62\u7bad\u5934:",
    u"\U0001F49D": ":\u5fc3\u5f62\u4e1d\u5e26:",
    u"\U00002714": ":\u7c97\u590d\u9009\u6807\u8bb0:",
    u"\U00002797": ":\u91cd\u9664\u6cd5\u6807\u5fd7:",
    u"\U0001F4B2": ":\u91cd\u7f8e\u5143\u7b26\u53f7:",
    u"\U00002763": ":\u6c89\u91cd\u7684\u5fc3\u58f0\u611f\u53f9:",
    u"\U00002B55": ":\u7c97\u5927\u5706:",
    u"\U00002796": ":\u91cd\u51cf\u53f7:",
    u"\U00002716": ":\u91cd\u4e58\u6cd5x:",
    u"\U00002795": ":\u7c97\u52a0\u53f7:",
    u"\U0001F994": ":\u523a\u732c:",
    u"\U0001F681": ":\u76f4\u5347\u673a:",
    u"\U0001F33F": ":\u8349\u672c\u690d\u7269:",
    u"\U0001F33A": ":\u6728\u69ff:",
    u"\U0001F460": ":\u9ad8\u8ddf\u978b:",
    u"\U0001F684": ":\u9ad8\u901f\u5217\u8f66:",
    u"\U000026A1": ":\u9ad8\u538b:",
    u"\U0001F97E": ":\u767b\u5c71\u9774:",
    u"\U0001F6D5": ":\u5370\u5ea6\u6559\u5bfa\u5e99:",
    u"\U0001F99B": ":\u6cb3\u9a6c:",
    u"\U0001F573": ":\u5b54:",
    u"\U0001F573\U0000FE0F": ":\u5b54:",
    u"\U0001F36F": ":\u871c\u7f50:",
    u"\U0001F41D": ":\u871c\u8702:",
    u"\U0001F6A5": ":\u6c34\u5e73\u4ea4\u901a\u706f:",
    u"\U0001F40E": ":\u9a6c:",
    u"\U0001F434": ":\u9a6c\u8138:",
    u"\U0001F3C7": ":\u8d5b\u9a6c:",
    u"\U0001F3C7\U0001F3FF": ":\u8d5b\u9a6c\u6df1\u8272\u80a4\u8272:",
    u"\U0001F3C7\U0001F3FB": ":\u8d5b\u9a6c\u6d45\u80a4\u8272:",
    u"\U0001F3C7\U0001F3FE": ":\u8d5b\u9a6c\u4e2d\u6df1\u8272\u80a4\u8272:",
    u"\U0001F3C7\U0001F3FC": ":\u8d5b\u9a6c\u4e2d\u6d45\u80a4\u8272:",
    u"\U0001F3C7\U0001F3FD": ":\u8d5b\u9a6c\u4e2d\u7b49\u80a4\u8272:",
    u"\U0001F3E5": ":\u533b\u9662:",
    u"\U00002615": ":\u70ed\u996e:",
    u"\U0001F32D": ":\u70ed\u72d7:",
    u"\U0001F975": ":\u706b\u8fa3\u8138:",
    u"\U0001F336": ":\u8fa3\u6912:",
    u"\U0001F336\U0000FE0F": ":\u8fa3\u6912:",
    u"\U00002668": ":\u6e29\u6cc9:",
    u"\U00002668\U0000FE0F": ":\u6e29\u6cc9:",
    u"\U0001F3E8": ":\u9152\u5e97:",
    u"\U0000231B": ":\u6c99\u6f0f\u505a\u597d\u4e86:",
    u"\U000023F3": ":\u6c99\u6f0f\u672a\u5b8c\u6210:",
    u"\U0001F3E0": ":\u623f\u5b50:",
    u"\U0001F3E1": ":\u5e26\u82b1\u56ed\u7684\u623f\u5b50:",
    u"\U0001F3D8": ":\u623f\u5c4b:",
    u"\U0001F3D8\U0000FE0F": ":\u623f\u5c4b:",
    u"\U0001F917": ":\u62e5\u62b1\u7684\u8138:",
    u"\U0001F4AF": ":100\u5206:",
    u"\U0001F62F": ":\u5e73\u9759\u7684\u8138:",
    u"\U0001F9CA": ":\u51b0:",
    u"\U0001F368": ":\u51b0\u6dc7\u6dcb:",
    u"\U0001F3D2": ":\u51b0\u7403:",
    u"\U000026F8": ":\u6e9c\u51b0\u978b:",
    u"\U000026F8\U0000FE0F": ":\u51b0\u978b:",
    u"\U0001F4E5": ":\u6536\u4ef6\u7bb1\u9001\u7eb8\u5668:",
    u"\U0001F4E8": ":\u6536\u5230\u7684\u4fe1\u5c01:",
    u"\U0000261D": ":\u6307\u5411\u4e0a\u7684\u7d22\u5f15:",
    u"\U0000261D\U0001F3FF": ":\u6307\u5411\u6df1\u8272\u80a4\u8272\u7684\u7d22\u5f15:",
    u"\U0000261D\U0001F3FB": ":\u6307\u5411\u6d45\u80a4\u8272\u7684\u7d22\u5f15:",
    u"\U0000261D\U0001F3FE": ":\u6307\u5411\u4e2d\u6df1\u8272\u80a4\u8272\u7684\u7d22\u5f15:",
    u"\U0000261D\U0001F3FC": ":\u4e2d\u6d45\u80a4\u8272\u6307\u6570:",
    u"\U0000261D\U0001F3FD": ":\u6307\u5411\u4e2d\u7b49\u80a4\u8272\u7684\u7d22\u5f15:",
    u"\U0000261D\U0000FE0F": ":\u7d22\u5f15\u6307\u5411\u4e0a:",
    u"\U0000267E": ":\u65e0\u7a77:",
    u"\U0000267E\U0000FE0F": ":\u65e0\u9650:",
    u"\U00002139": ":\u4fe1\u606f:",
    u"\U00002139\U0000FE0F": ":\u4fe1\u606f:",
    u"\U0001F524": ":\u8f93\u5165\u62c9\u4e01\u5b57\u6bcd:",
    u"\U0001F521": ":\u8f93\u5165\u62c9\u4e01\u6587\u5c0f\u5199:",
    u"\U0001F520": ":\u8f93\u5165\u62c9\u4e01\u6587\u5927\u5199:",
    u"\U0001F522": ":\u8f93\u5165\u6570\u5b57:",
    u"\U0001F523": ":\u8f93\u5165\u7b26\u53f7:",
    u"\U0001F383": ":\u6770\u514b\u706f:",
    u"\U0001F456": ":\u725b\u4ed4\u88e4:",
    u"\U0001F9E9": ":\u62fc\u56fe:",
    u"\U0001F0CF": ":\u5c0f\u4e11:",
    u"\U0001F579": ":\u64cd\u7eb5\u6746:",
    u"\U0001F579\U0000FE0F": ":\u64cd\u7eb5\u6746:",
    u"\U0001F54B": ":\u5361\u5df4:",
    u"\U0001F998": ":\u888b\u9f20:",
    u"\U0001F511": ":\u94a5\u5319:",
    u"\U00002328": ":\u952e\u76d8:",
    u"\U00002328\U0000FE0F": ":\u952e\u76d8:",
    u"\U00000023\U000020E3": ":\u94a5\u5319\u76d6:",
    u"\U00000023\U0000FE0F\U000020E3": ":\u94a5\u5319\u76d62:",
    u"\U0000002A\U0000FE0F\U000020E3": ":\u94a5\u5319\u76d63:",
    u"\U00000030\U0000FE0F\U000020E3": ":\u94a5\u5319\u76d6#:",
    u"\U0001F51F": ":\u94a5\u5319\u76d6*:",
    u"\U00000031\U0000FE0F\U000020E3": ":\u5bc6\u94a5\u5e3d0:",
    u"\U00000032\U0000FE0F\U000020E3": ":\u94a5\u5319\u76d610:",
    u"\U00000033\U0000FE0F\U000020E3": ":\u94a5\u5319\u76d61:",
    u"\U00000034\U0000FE0F\U000020E3": ":\u94a5\u5319\u76d64:",
    u"\U00000035\U0000FE0F\U000020E3": ":\u94a5\u5319\u76d65:",
    u"\U00000036\U0000FE0F\U000020E3": ":\u94a5\u5319\u76d66:",
    u"\U00000037\U0000FE0F\U000020E3": ":\u94a5\u5319\u76d67:",
    u"\U00000038\U0000FE0F\U000020E3": ":\u94a5\u5319\u76d68:",
    u"\U00000039\U0000FE0F\U000020E3": ":\u94a5\u5319\u76d69:",
    u"\U0000002A\U000020E3": ":\u952e\u5e3d\u661f\u53f7:",
    u"\U00000038\U000020E3": ":\u952e\u5e3d\u6570\u5b57\u516b:",
    u"\U00000035\U000020E3": ":\u952e\u76d8\u5927\u5199\u6570\u5b57\u4e94:",
    u"\U00000034\U000020E3": ":\u94a5\u5319\u76d6\u6570\u5b57\u56db:",
    u"\U00000039\U000020E3": ":\u952e\u5e3d\u6570\u5b57\u4e5d:",
    u"\U00000031\U000020E3": ":\u94a5\u5319\u5e3d\u6570\u5b57\u4e00:",
    u"\U00000037\U000020E3": ":\u94a5\u5319\u5e3d\u6570\u5b57\u4e03:",
    u"\U00000036\U000020E3": ":\u952e\u5e3d\u6570\u5b57\u516d:",
    u"\U00000033\U000020E3": ":\u94a5\u5319\u5e3d\u6570\u5b57\u4e09:",
    u"\U00000032\U000020E3": ":\u94a5\u5319\u5e3d\u6570\u5b57\u4e8c:",
    u"\U00000030\U000020E3": ":\u952e\u5e3d\u6570\u5b57\u96f6:",
    u"\U0001F6F4": ":\u8e22\u677f\u8f66:",
    u"\U0001F458": ":\u548c\u670d:",
    u"\U0001F468\U0000200D\U00002764\U0000200D\U0001F48B\U0000200D\U0001F468": ":\u543b\u7537\u4eba\u7537\u4eba:",
    u"\U0001F469\U0000200D\U00002764\U0000200D\U0001F48B\U0000200D\U0001F468": ":\u543b\u5973\u4eba\u7537\u4eba:",
    u"\U0001F469\U0000200D\U00002764\U0000200D\U0001F48B\U0000200D\U0001F469": ":\u543b\u5973\u4eba:",
    u"\U0001F48F": ":\u543b:",
    u"\U0001F468\U0000200D\U00002764\U0000FE0F\U0000200D\U0001F48B\U0000200D\U0001F468": ":\u543b\u7537\u4eba\u7537\u4eba:",
    u"\U0001F48B": ":\u543b\u75d5:",
    u"\U0001F469\U0000200D\U00002764\U0000FE0F\U0000200D\U0001F48B\U0000200D\U0001F468": ":\u543b\u5973\u4eba\u7537\u4eba:",
    u"\U0001F469\U0000200D\U00002764\U0000FE0F\U0000200D\U0001F48B\U0000200D\U0001F469": ":\u543b\u5973\u4eba:",
    u"\U0001F63D": ":\u4eb2\u543b\u732b\u8138:",
    u"\U0001F617": ":\u63a5\u543b\u7684\u8138:",
    u"\U0001F61A": ":\u95ed\u773c\u63a5\u543b:",
    u"\U0001F619": ":\u7b11\u772f\u772f\u7684\u8138:",
    u"\U0001F52A": ":\u83dc\u5200:",
    u"\U0001FA81": ":\u98ce\u7b5d:",
    u"\U0001F95D": ":\u7315\u7334\u6843:",
    u"\U0001F428": ":\u8003\u62c9:",
    u"\U0001F97C": ":\u5b9e\u9a8c\u5ba4\u5916\u5957:",
    u"\U0001F3F7": ":\u6807\u7b7e:",
    u"\U0001F3F7\U0000FE0F": ":\u6807\u7b7e:",
    u"\U0001F94D": ":\u957f\u66f2\u68cd\u7403:",
    u"\U0001F41E": ":\u74e2\u866b:",
    u"\U0001F4BB": ":\u7b14\u8bb0\u672c\u7535\u8111:",
    u"\U0001F537": ":\u84dd\u8272\u5927\u94bb\u77f3:",
    u"\U0001F536": ":\u5927\u6a59\u8272\u94bb\u77f3:",
    u"\U0001F317": ":\u6700\u540e\u4e00\u523b\u6708\u4eae:",
    u"\U0001F31C": ":\u6700\u540e\u56db\u5206\u4e4b\u4e00\u6708\u9762:",
    u"\U000023EE": ":\u6700\u540e\u4e00\u9996\u66f2\u76ee\u6309\u94ae:",
    u"\U000023EE\U0000FE0F": ":\u6700\u540e\u4e00\u4e2a\u97f3\u8f68\u6309\u94ae:",
    u"\U0000271D": ":\u62c9\u4e01\u5341\u5b57:",
    u"\U0000271D\U0000FE0F": ":\u62c9\u4e01\u8bed\u4ea4\u53c9:",
    u"\U0001F343": ":\u98ce\u4e2d\u98d8\u52a8\u7684\u6811\u53f6:",
    u"\U0001F96C": ":\u7eff\u53f6:",
    u"\U0001F4D2": ":\u5206\u7c7b\u5e10:",
    u"\U0001F91B": ":\u5de6\u62f3:",
    u"\U0001F91B\U0001F3FF": ":\u5de6\u62f3\u6697\u80a4\u8272:",
    u"\U0001F91B\U0001F3FB": ":\u5de6\u62f3\u8f7b\u80a4\u8272:",
    u"\U0001F91B\U0001F3FE": ":\u5de6\u62f3\u4e2d\u6df1\u8272\u80a4\u8272:",
    u"\U0001F91B\U0001F3FC": ":\u5de6\u62f3\u4e2d\u6d45\u80a4\u8272:",
    u"\U0001F91B\U0001F3FD": ":\u5de6\u62f3\u4e2d\u80a4\u8272:",
    u"\U00002194": ":\u5de6\u53f3\u7bad\u5934:",
    u"\U00002194\U0000FE0F": ":\u5de6\u53f3\u7bad\u5934:",
    u"\U00002B05": ":\u5de6\u7bad\u5934:",
    u"\U000021AA": ":\u5de6\u7bad\u5934\u5411\u53f3\u5f2f\u66f2:",
    u"\U000021AA\U0000FE0F": ":\u5de6\u7bad\u5934\u66f2\u7ebf\u53f3:",
    u"\U00002B05\U0000FE0F": ":\u5de6\u7bad\u5934:",
    u"\U0001F6C5": ":\u884c\u674e\u5bc4\u5b58\u5904:",
    u"\U0001F5E8": ":\u5de6\u8bed\u97f3\u6c14\u6ce1:",
    u"\U0001F5E8\U0000FE0F": ":\u5de6\u8bed\u97f3\u6c14\u6ce1:",
    u"\U0001F9B5\U0001F3FF": ":\u6df1\u8272\u817f\u90e8\u80a4\u8272:",
    u"\U0001F9B5\U0001F3FB": ":\u817f\u90e8\u6d45\u80a4\u8272:",
    u"\U0001F9B5\U0001F3FE": ":\u817f\u90e8\u4e2d\u6df1\u8272\u80a4\u8272:",
    u"\U0001F9B5\U0001F3FC": ":\u817f\u90e8\u4e2d\u6d45\u80a4\u8272:",
    u"\U0001F9B5\U0001F3FD": ":\u4e2d\u7b49\u80a4\u8272:",
    u"\U0001F9B5": ":\u817f:",
    u"\U0001F34B": ":\u67e0\u6aac:",
    u"\U0001F406": ":\u8c79\u5b50:",
    u"\U0001F39A": ":\u6c34\u5e73\u6ed1\u5757:",
    u"\U0001F39A\U0000FE0F": ":\u7535\u5e73\u6ed1\u5757:",
    u"\U0001F4A1": ":\u706f\u6ce1:",
    u"\U0001F688": ":\u8f7b\u8f68:",
    u"\U0001F3FB": ":\u6d45\u80a4\u8272:",
    u"\U0001F517": ":\u94fe\u63a5:",
    u"\U0001F587": ":\u8fde\u73af\u56de\u5f62\u9488:",
    u"\U0001F587\U0000FE0F": ":\u94fe\u63a5\u56de\u5f62\u9488:",
    u"\U0001F981": ":\u72ee\u5b50\u8138:",
    u"\U0001F484": ":\u5507\u818f:",
    u"\U0001F6AE": ":\u5783\u573e\u7bb1\u6807\u8bc6:",
    u"\U0001F98E": ":\u8725\u8734:",
    u"\U0001F999": ":\u7f8e\u6d32\u9a7c:",
    u"\U0001F99E": ":\u9f99\u867e:",
    u"\U0001F512": ":\u9501\u5b9a:",
    u"\U0001F510": ":\u7528\u94a5\u5319\u9501\u4f4f:",
    u"\U0001F50F": ":\u7528\u94a2\u7b14\u9501\u4f4f:",
    u"\U0001F682": ":\u673a\u8f66:",
    u"\U0001F36D": ":\u68d2\u68d2\u7cd6:",
    u"\U0001F9F4": ":\u6d17\u6db2\u74f6:",
    u"\U0001F62D": ":\u5927\u58f0\u54ed\u558a\u7684\u8138:",
    u"\U0001F4E2": ":\u626c\u58f0\u5668:",
    u"\U0001F91F": ":\u7231\u4f60\u7684\u624b\u52bf:",
    u"\U0001F91F\U0001F3FF": ":\u7231\u4f60\u624b\u52bf\u6df1\u80a4\u8272:",
    u"\U0001F91F\U0001F3FB": ":\u7231\u4f60\u624b\u52bf\u6d45\u80a4\u8272:",
    u"\U0001F91F\U0001F3FE": ":\u7231\u4f60\u624b\u52bf\u4e2d\u6df1\u8272\u80a4\u8272:",
    u"\U0001F91F\U0001F3FC": ":\u7231\u4f60\u624b\u52bf\u4e2d\u6d45\u80a4\u8272:",
    u"\U0001F91F\U0001F3FD": ":\u7231\u4f60\u624b\u52bf\u4e2d\u7b49\u80a4\u8272:",
    u"\U0001F3E9": ":\u7231\u60c5\u9152\u5e97:",
    u"\U0001F48C": ":\u60c5\u4e66:",
    u"\U0001F9F3": ":\u884c\u674e:",
    u"\U0001F925": ":\u8eba\u7740\u7684\u8138:",
    u"\U0001F9D9": ":\u6cd5\u5e08:",
    u"\U0001F9D9\U0001F3FF": ":\u9b54\u6cd5\u5e08\u6697\u80a4\u8272:",
    u"\U0001F9D9\U0001F3FB": ":\u9b54\u5149\u80a4\u8272:",
    u"\U0001F9D9\U0001F3FE": ":mage\u4e2d\u6697\u80a4\u8272:",
    u"\U0001F9D9\U0001F3FC": ":\u6cd5\u5e08\u4e2d\u6d45\u80a4\u8272:",
    u"\U0001F9D9\U0001F3FD": ":\u6cd5\u5e08\u4e2d\u7b49\u80a4\u8272:",
    u"\U0001F9F2": ":\u78c1\u94c1:",
    u"\U0001F50D": ":\u653e\u5927\u955c\u5411\u5de6\u503e\u659c:",
    u"\U0001F50E": ":\u653e\u5927\u955c\u5411\u53f3\u503e\u659c:",
    u"\U0001F004": ":\u9ebb\u5c06\u7ea2\u4e2d:",
    u"\U00002642": ":\u7537\u6027\u6807\u5fd7:",
    u"\U00002642\U0000FE0F": ":\u7537\u6027\u6807\u5fd7:",
    u"\U0001F471\U0000200D\U00002642": ":\u7537\u4eba\u91d1\u53d1:",
    u"\U0001F468\U0001F3FF\U0000200D\U0001F9B2": ":\u7537\u6027\u6df1\u8272\u80a4\u8272\u79c3\u9876:",
    u"\U0001F471\U0001F3FF\U0000200D\U00002642": ":\u7537\u58eb\u6df1\u8272\u80a4\u8272\u91d1\u53d1:",
    u"\U0001F468\U0001F3FF\U0000200D\U0001F9B1": ":\u7537\u58eb\u6df1\u8272\u80a4\u8272\u5377\u53d1:",
    u"\U0001F468\U0001F3FF\U0000200D\U0001F9B0": ":\u7537\u4eba\u6df1\u8272\u80a4\u8272\u7ea2\u53d1:",
    u"\U0001F468\U0001F3FF\U0000200D\U0001F9B3": ":\u7537\u4eba\u6df1\u8272\u80a4\u8272\u767d\u53d1:",
    u"\U0001F468\U0001F3FB\U0000200D\U0001F9B2": ":\u7537\u6027\u6d45\u80a4\u8272\u79c3\u5934:",
    u"\U0001F471\U0001F3FB\U0000200D\U00002642": ":\u7537\u58eb\u6d45\u80a4\u8272\u91d1\u53d1:",
    u"\U0001F468\U0001F3FB\U0000200D\U0001F9B1": ":\u7537\u58eb\u6d45\u80a4\u8272\u5377\u53d1:",
    u"\U0001F468\U0001F3FB\U0000200D\U0001F9B0": ":\u7537\u4eba\u6d45\u80a4\u8272\u7ea2\u53d1:",
    u"\U0001F468\U0001F3FB\U0000200D\U0001F9B3": ":\u7537\u4eba\u6d45\u80a4\u8272\u767d\u53d1:",
    u"\U0001F468\U0001F3FE\U0000200D\U0001F9B2": ":\u7537\u6027\u4e2d\u6df1\u8272\u80a4\u8272\u79c3\u5934:",
    u"\U0001F471\U0001F3FE\U0000200D\U00002642": ":\u7537\u58eb\u4e2d\u6df1\u8272\u80a4\u8272\u91d1\u53d1:",
    u"\U0001F468\U0001F3FE\U0000200D\U0001F9B1": ":\u7537\u58eb\u4e2d\u6df1\u8272\u80a4\u8272\u5377\u53d1:",
    u"\U0001F468\U0001F3FE\U0000200D\U0001F9B0": ":\u7537\u58eb\u4e2d\u6df1\u8272\u80a4\u8272\u7ea2\u53d1:",
    u"\U0001F468\U0001F3FE\U0000200D\U0001F9B3": ":\u7537\u58eb\u4e2d\u6df1\u8272\u80a4\u8272\u767d\u53d1:",
    u"\U0001F468\U0001F3FC\U0000200D\U0001F9B2": ":\u7537\u58eb\u4e2d\u6d45\u80a4\u8272\u79c3\u5934:",
    u"\U0001F471\U0001F3FC\U0000200D\U00002642": ":\u7537\u58eb\u4e2d\u6d45\u80a4\u8272\u91d1\u53d1:",
    u"\U0001F468\U0001F3FC\U0000200D\U0001F9B1": ":\u7537\u58eb\u4e2d\u6d45\u80a4\u8272\u5377\u53d1:",
    u"\U0001F468\U0001F3FC\U0000200D\U0001F9B0": ":\u7537\u58eb\u4e2d\u6d45\u80a4\u8272\u7ea2\u53d1:",
    u"\U0001F468\U0001F3FC\U0000200D\U0001F9B3": ":\u7537\u58eb\u4e2d\u6d45\u80a4\u8272\u767d\u53d1:",
    u"\U0001F468\U0001F3FD\U0000200D\U0001F9B2": ":\u7537\u6027\u4e2d\u7b49\u80a4\u8272\u79c3\u5934:",
    u"\U0001F471\U0001F3FD\U0000200D\U00002642": ":\u7537\u58eb\u4e2d\u7b49\u80a4\u8272\u91d1\u53d1:",
    u"\U0001F468\U0001F3FD\U0000200D\U0001F9B1": ":\u7537\u58eb\u4e2d\u7b49\u80a4\u8272\u5377\u53d1:",
    u"\U0001F468\U0001F3FD\U0000200D\U0001F9B0": ":\u7537\u58eb\u4e2d\u7b49\u80a4\u8272\u7ea2\u53d1:",
    u"\U0001F468\U0001F3FD\U0000200D\U0001F9B3": ":\u7537\u58eb\u4e2d\u7b49\u80a4\u8272\u767d\u53d1:",
    u"\U0001F468": ":\u7537\u4eba:",
    u"\U0001F46B": ":\u624b\u7275\u624b\u7684\u5973\u4eba:",
    u"\U0001F468\U0000200D\U0001F3A8": ":\u7537\u827a\u672f\u5bb6:",
    u"\U0001F468\U0001F3FF\U0000200D\U0001F3A8": ":\u7537\u827a\u4eba\u6697\u80a4\u8272:",
    u"\U0001F468\U0001F3FB\U0000200D\U0001F3A8": ":\u7537\u827a\u4eba\u6d45\u80a4\u8272:",
    u"\U0001F468\U0001F3FE\U0000200D\U0001F3A8": ":\u7537\u827a\u4eba\u4e2d\u6df1\u8272\u80a4\u8272:",
    u"\U0001F468\U0001F3FC\U0000200D\U0001F3A8": ":\u7537\u827a\u4eba\u4e2d\u6d45\u80a4\u8272:",
    u"\U0001F468\U0001F3FD\U0000200D\U0001F3A8": ":\u7537\u827a\u4eba\u4e2d\u7b49\u80a4\u8272:",
    u"\U0001F468\U0000200D\U0001F680": ":\u5b87\u822a\u5458:",
    u"\U0001F468\U0001F3FF\U0000200D\U0001F680": ":\u7537\u5b87\u822a\u5458\u6df1\u8272\u80a4\u8272:",
    u"\U0001F468\U0001F3FB\U0000200D\U0001F680": ":\u5b87\u822a\u5458\u80a4\u8272\u6d45:",
    u"\U0001F468\U0001F3FE\U0000200D\U0001F680": ":\u6df1\u80a4\u8272\u5b87\u822a\u5458:",
    u"\U0001F468\U0001F3FC\U0000200D\U0001F680": ":\u5b87\u822a\u5458\u4e2d\u6d45\u80a4\u8272:",
    u"\U0001F468\U0001F3FD\U0000200D\U0001F680": ":\u7537\u5b87\u822a\u5458\u4e2d\u7b49\u80a4\u8272:",
    u"\U0001F6B4\U0001F3FF\U0000200D\U00002642": ":\u7537\u5b50\u81ea\u884c\u8f66\u6df1\u8272\u80a4\u8272:",
    u"\U0001F6B4\U0001F3FB\U0000200D\U00002642": ":\u7537\u5b50\u81ea\u884c\u8f66\u6d45\u80a4\u8272:",
    u"\U0001F6B4\U0001F3FE\U0000200D\U00002642": ":\u7537\u5b50\u81ea\u884c\u8f66\u4e2d\u6df1\u8272\u80a4\u8272:",
    u"\U0001F6B4\U0001F3FC\U0000200D\U00002642": ":\u7537\u5b50\u81ea\u884c\u8f66\u4e2d\u6d45\u80a4\u8272:",
    u"\U0001F6B4\U0001F3FD\U0000200D\U00002642": ":\u7537\u5b50\u81ea\u884c\u8f66\u4e2d\u7b49\u80a4\u8272:",
    u"\U0001F6B4\U0000200D\U00002642": ":\u7537\u5b50\u81ea\u884c\u8f66:",
    u"\U0001F6B4\U0001F3FF\U0000200D\U00002642\U0000FE0F": ":\u7537\u5b50\u81ea\u884c\u8f66\u6df1\u8272\u80a4\u8272:",
    u"\U0001F6B4\U0001F3FB\U0000200D\U00002642\U0000FE0F": ":\u7537\u5b50\u81ea\u884c\u8f66\u6d45\u80a4\u8272:",
    u"\U0001F6B4\U0001F3FE\U0000200D\U00002642\U0000FE0F": ":\u7537\u5b50\u81ea\u884c\u8f66\u4e2d\u6df1\u8272\u80a4\u8272:",
    u"\U0001F6B4\U0001F3FC\U0000200D\U00002642\U0000FE0F": ":\u7537\u5b50\u81ea\u884c\u8f66\u4e2d\u6d45\u80a4\u8272:",
    u"\U0001F6B4\U0001F3FD\U0000200D\U00002642\U0000FE0F": ":\u7537\u5b50\u81ea\u884c\u8f66\u4e2d\u7b49\u80a4\u8272:",
    u"\U0001F6B4\U0000200D\U00002642\U0000FE0F": ":\u7537\u5b50\u81ea\u884c\u8f66:",
    u"\U000026F9\U0001F3FF\U0000200D\U00002642": ":\u7537\u4eba\u5f39\u8df3\u7403\u6df1\u8272\u80a4\u8272:",
    u"\U000026F9\U0001F3FB\U0000200D\U00002642": ":\u7537\u4eba\u5f39\u8df3\u7403\u8f7b\u80a4\u8272:",
    u"\U000026F9\U0001F3FE\U0000200D\U00002642": ":\u7537\u5b50\u5f39\u8df3\u7403\u4e2d\u6df1\u8272\u80a4\u8272:",
    u"\U000026F9\U0001F3FC\U0000200D\U00002642": ":\u7537\u5b50\u5f39\u8df3\u7403\u4e2d\u6d45\u80a4\u8272:",
    u"\U000026F9\U0001F3FD\U0000200D\U00002642": ":\u7537\u5b50\u5f39\u8df3\u7403\u4e2d\u7b49\u80a4\u8272:",
    u"\U000026F9\U0000200D\U00002642": ":\u7537\u5b50\u5f39\u7403:",
    u"\U000026F9\U0000FE0F\U0000200D\U00002642\U0000FE0F": ":\u7537\u5b50\u5f39\u74032:",
    u"\U000026F9\U0000200D\U00002642\U0000FE0F": ":\u7537\u5b50\u5f39\u74033:",
    u"\U000026F9\U0001F3FF\U0000200D\U00002642\U0000FE0F": ":\u7537\u4eba\u5f39\u8df3\u7403\u6df1\u8272\u80a4\u8272:",
    u"\U000026F9\U0001F3FB\U0000200D\U00002642\U0000FE0F": ":\u7537\u4eba\u5f39\u8df3\u7403\u8f7b\u80a4\u8272:",
    u"\U000026F9\U0001F3FE\U0000200D\U00002642\U0000FE0F": ":\u7537\u5b50\u5f39\u8df3\u7403\u4e2d\u6df1\u8272\u80a4\u8272:",
    u"\U000026F9\U0001F3FC\U0000200D\U00002642\U0000FE0F": ":\u7537\u5b50\u5f39\u8df3\u7403\u4e2d\u6d45\u80a4\u8272:",
    u"\U000026F9\U0001F3FD\U0000200D\U00002642\U0000FE0F": ":\u7537\u5b50\u5f39\u8df3\u7403\u4e2d\u7b49\u80a4\u8272:",
    u"\U000026F9\U0000FE0F\U0000200D\U00002642": ":\u4eba\u5f39\u7403:",
    u"\U0001F647\U0001F3FF\U0000200D\U00002642": ":\u7537\u6027\u5f13\u5f62\u6df1\u8272\u80a4\u8272:",
    u"\U0001F647\U0001F3FB\U0000200D\U00002642": ":\u7537\u4eba\u5f13\u5f62\u6d45\u80a4\u8272:",
    u"\U0001F647\U0001F3FE\U0000200D\U00002642": ":\u7537\u6027\u5f13\u5f62\u4e2d\u6df1\u8272\u80a4\u8272:",
    u"\U0001F647\U0001F3FC\U0000200D\U00002642": ":\u7537\u58eb\u5f13\u5f62\u4e2d\u6d45\u80a4\u8272:",
    u"\U0001F647\U0001F3FD\U0000200D\U00002642": ":\u7537\u58eb\u5f13\u5f62\u4e2d\u7b49\u80a4\u8272:",
    u"\U0001F647\U0000200D\U00002642": ":\u97a0\u8eac:",
    u"\U0001F647\U0001F3FF\U0000200D\U00002642\U0000FE0F": ":\u7537\u6027\u5f13\u5f62\u6df1\u8272\u80a4\u8272:",
    u"\U0001F647\U0001F3FB\U0000200D\U00002642\U0000FE0F": ":\u7537\u4eba\u5f13\u5f62\u6d45\u80a4\u8272:",
    u"\U0001F647\U0001F3FE\U0000200D\U00002642\U0000FE0F": ":\u7537\u6027\u5f13\u5f62\u4e2d\u6df1\u8272\u80a4\u8272:",
    u"\U0001F647\U0001F3FC\U0000200D\U00002642\U0000FE0F": ":\u7537\u58eb\u5f13\u5f62\u4e2d\u6d45\u80a4\u8272:",
    u"\U0001F647\U0001F3FD\U0000200D\U00002642\U0000FE0F": ":\u7537\u58eb\u5f13\u5f62\u4e2d\u7b49\u80a4\u8272:",
    u"\U0001F647\U0000200D\U00002642\U0000FE0F": ":\u7537\u5b50\u97a0\u8eac:",
    u"\U0001F938\U0001F3FF\U0000200D\U00002642": ":\u7537\u4eba\u63a8\u8f66\u5f0f\u6df1\u8272\u80a4\u8272:",
    u"\U0001F938\U0001F3FB\U0000200D\U00002642": ":\u7537\u88c5\u8f7b\u80a4\u8272:",
    u"\U0001F938\U0001F3FE\U0000200D\U00002642": ":\u7537\u58eb\u63a8\u8f66\u5f0f\u4e2d\u6df1\u8272\u80a4\u8272:",
    u"\U0001F938\U0001F3FC\U0000200D\U00002642": ":\u7537\u58eb\u63a8\u8f66\u5f0f\u4e2d\u6d45\u80a4\u8272:",
    u"\U0001F938\U0001F3FD\U0000200D\U00002642": ":\u7537\u58eb\u63a8\u8f66\u5f0f\u4e2d\u7b49\u80a4\u8272:",
    u"\U0001F938\U0000200D\U00002642": ":\u4eba\u529b\u63a8\u8f66:",
    u"\U0001F938\U0001F3FF\U0000200D\U00002642\U0000FE0F": ":\u7537\u4eba\u63a8\u8f66\u5f0f\u6df1\u8272\u80a4\u8272:",
    u"\U0001F938\U0001F3FB\U0000200D\U00002642\U0000FE0F": ":\u7537\u88c5\u8f7b\u80a4\u8272:",
    u"\U0001F938\U0001F3FE\U0000200D\U00002642\U0000FE0F": ":\u7537\u58eb\u63a8\u8f66\u5f0f\u4e2d\u6df1\u8272\u80a4\u8272:",
    u"\U0001F938\U0001F3FC\U0000200D\U00002642\U0000FE0F": ":\u7537\u58eb\u63a8\u8f66\u5f0f\u4e2d\u6d45\u80a4\u8272:",
    u"\U0001F938\U0001F3FD\U0000200D\U00002642\U0000FE0F": ":\u7537\u58eb\u63a8\u8f66\u5f0f\u4e2d\u7b49\u80a4\u8272:",
    u"\U0001F938\U0000200D\U00002642\U0000FE0F": ":\u4eba\u529b\u63a8\u8f66:",
    u"\U0001F9D7\U0001F3FF\U0000200D\U00002642": ":\u7537\u6027\u6500\u722c\u6df1\u8272\u80a4\u8272:",
    u"\U0001F9D7\U0001F3FB\U0000200D\U00002642": ":\u7537\u5b50\u6500\u5ca9\u6d45\u80a4\u8272:",
    u"\U0001F9D7\U0001F3FE\U0000200D\U00002642": ":\u7537\u6027\u6500\u5ca9\u4e2d\u6df1\u8272\u80a4\u8272:",
    u"\U0001F9D7\U0001F3FC\U0000200D\U00002642": ":\u7537\u58eb\u6500\u5ca9\u4e2d\u6d45\u80a4\u8272:",
    u"\U0001F9D7\U0001F3FD\U0000200D\U00002642": ":\u7537\u5b50\u6500\u5ca9\u4e2d\u7b49\u80a4\u8272:",
    u"\U0001F9D7\U0000200D\U00002642": ":\u7537\u5b50\u6500\u5ca9:",
    u"\U0001F9D7\U0001F3FF\U0000200D\U00002642\U0000FE0F": ":\u7537\u6027\u6500\u722c\u6df1\u8272\u80a4\u8272:",
    u"\U0001F9D7\U0001F3FB\U0000200D\U00002642\U0000FE0F": ":\u7537\u5b50\u6500\u5ca9\u6d45\u80a4\u8272:",
    u"\U0001F9D7\U0001F3FE\U0000200D\U00002642\U0000FE0F": ":\u7537\u6027\u6500\u5ca9\u4e2d\u6df1\u8272\u80a4\u8272:",
    u"\U0001F9D7\U0001F3FC\U0000200D\U00002642\U0000FE0F": ":\u7537\u58eb\u6500\u5ca9\u4e2d\u6d45\u80a4\u8272:",
    u"\U0001F9D7\U0001F3FD\U0000200D\U00002642\U0000FE0F": ":\u7537\u5b50\u6500\u5ca9\u4e2d\u7b49\u80a4\u8272:",
    u"\U0001F9D7\U0000200D\U00002642\U0000FE0F": ":\u4eba\u722c:",
    u"\U0001F477\U0001F3FF\U0000200D\U00002642": ":\u7537\u5efa\u7b51\u5de5\u4eba\u80a4\u8272\u6697\u6c89:",
    u"\U0001F477\U0001F3FB\U0000200D\U00002642": ":\u7537\u5efa\u7b51\u5de5\u4eba\u80a4\u8272\u6d45:",
    u"\U0001F477\U0001F3FE\U0000200D\U00002642": ":\u7537\u5efa\u7b51\u5de5\u4eba\u4e2d\u6df1\u8272\u80a4\u8272:",
    u"\U0001F477\U0001F3FC\U0000200D\U00002642": ":\u7537\u5efa\u7b51\u5de5\u4eba\u4e2d\u6d45\u80a4\u8272:",
    u"\U0001F477\U0001F3FD\U0000200D\U00002642": ":\u7537\u5efa\u7b51\u5de5\u4eba\u4e2d\u7b49\u80a4\u8272:",
    u"\U0001F477\U0000200D\U00002642": ":\u7537\u5efa\u7b51\u5de5\u4eba:",
    u"\U0001F477\U0001F3FF\U0000200D\U00002642\U0000FE0F": ":\u7537\u5efa\u7b51\u5de5\u4eba\u80a4\u8272\u6697\u6c89:",
    u"\U0001F477\U0001F3FB\U0000200D\U00002642\U0000FE0F": ":\u7537\u5efa\u7b51\u5de5\u4eba\u80a4\u8272\u6d45:",
    u"\U0001F477\U0001F3FE\U0000200D\U00002642\U0000FE0F": ":\u7537\u5efa\u7b51\u5de5\u4eba\u4e2d\u6df1\u8272\u80a4\u8272:",
    u"\U0001F477\U0001F3FC\U0000200D\U00002642\U0000FE0F": ":\u7537\u5efa\u7b51\u5de5\u4eba\u4e2d\u6d45\u80a4\u8272:",
    u"\U0001F477\U0001F3FD\U0000200D\U00002642\U0000FE0F": ":\u7537\u5efa\u7b51\u5de5\u4eba\u4e2d\u7b49\u80a4\u8272:",
    u"\U0001F477\U0000200D\U00002642\U0000FE0F": ":\u4eba\u5de5\u5efa\u7b51\u5de5\u4eba:",
    u"\U0001F468\U0000200D\U0001F373": ":\u7537\u53a8\u5e08:",
    u"\U0001F468\U0001F3FF\U0000200D\U0001F373": ":\u7537\u53a8\u5e08\u6697\u80a4\u8272:",
    u"\U0001F468\U0001F3FB\U0000200D\U0001F373": ":\u7537\u53a8\u5e08\u6d45\u80a4\u8272:",
    u"\U0001F468\U0001F3FE\U0000200D\U0001F373": ":\u7537\u53a8\u5e08\u4e2d\u6df1\u8272\u80a4\u8272:",
    u"\U0001F468\U0001F3FC\U0000200D\U0001F373": ":\u7537\u53a8\u4e2d\u6d45\u80a4\u8272:",
    u"\U0001F468\U0001F3FD\U0000200D\U0001F373": ":\u7537\u53a8\u5e08\u4e2d\u7b49\u80a4\u8272:",
    u"\U0001F57A": ":\u8df3\u821e\u7684\u7537\u4eba:",
    u"\U0001F57A\U0001F3FF": ":\u821e\u7537\u6df1\u8272\u80a4\u8272:",
    u"\U0001F57A\U0001F3FB": ":\u821e\u7537\u6d45\u80a4\u8272:",
    u"\U0001F57A\U0001F3FE": ":\u821e\u7537\u4e2d\u6df1\u8272\u80a4\u8272:",
    u"\U0001F57A\U0001F3FC": ":\u821e\u7537\u4e2d\u6d45\u80a4\u8272:",
    u"\U0001F57A\U0001F3FD": ":\u7537\u5b50\u821e\u8e48\u4e2d\u7b49\u80a4\u8272:",
    u"\U0001F468\U0001F3FF": ":\u7537\u6027\u6697\u80a4\u8272:",
    u"\U0001F575\U0001F3FF\U0000200D\U00002642": ":\u7537\u4fa6\u63a2\u6df1\u8272\u80a4\u8272:",
    u"\U0001F575\U0001F3FB\U0000200D\U00002642": ":\u7537\u4fa6\u63a2\u6d45\u80a4\u8272:",
    u"\U0001F575\U0001F3FE\U0000200D\U00002642": ":\u7537\u4fa6\u63a2\u4e2d\u6df1\u8272\u80a4\u8272:",
    u"\U0001F575\U0001F3FC\U0000200D\U00002642": ":\u7537\u4fa6\u63a2\u4e2d\u6d45\u80a4\u8272:",
    u"\U0001F575\U0001F3FD\U0000200D\U00002642": ":\u7537\u4fa6\u63a2\u4e2d\u7b49\u80a4\u8272:",
    u"\U0001F575\U0000200D\U00002642": ":\u7537\u4fa6\u63a2:",
    u"\U0001F575\U0000FE0F\U0000200D\U00002642\U0000FE0F": ":\u7537\u4fa6\u63a22:",
    u"\U0001F575\U0000200D\U00002642\U0000FE0F": ":\u7537\u4fa6\u63a2:",
    u"\U0001F575\U0001F3FF\U0000200D\U00002642\U0000FE0F": ":\u7537\u4fa6\u63a2\u6df1\u8272\u80a4\u8272:",
    u"\U0001F575\U0001F3FB\U0000200D\U00002642\U0000FE0F": ":\u7537\u4fa6\u63a2\u6d45\u80a4\u8272:",
    u"\U0001F575\U0001F3FE\U0000200D\U00002642\U0000FE0F": ":\u7537\u4fa6\u63a2\u4e2d\u6df1\u8272\u80a4\u8272:",
    u"\U0001F575\U0001F3FC\U0000200D\U00002642\U0000FE0F": ":\u7537\u4fa6\u63a2\u4e2d\u6d45\u80a4\u8272:",
    u"\U0001F575\U0001F3FD\U0000200D\U00002642\U0000FE0F": ":\u7537\u4fa6\u63a2\u4e2d\u7b49\u80a4\u8272:",
    u"\U0001F9DD\U0001F3FF\U0000200D\U00002642": ":\u4eba\u7cbe\u7075\u9ed1\u80a4\u8272:",
    u"\U0001F9DD\U0001F3FB\U0000200D\U00002642": ":\u4eba\u7cbe\u7075\u6d45\u80a4\u8272:",
    u"\U0001F9DD\U0001F3FE\U0000200D\U00002642": ":\u7537\u7cbe\u7075\u4e2d\u6df1\u8272\u80a4\u8272:",
    u"\U0001F9DD\U0001F3FC\U0000200D\U00002642": ":\u4eba\u7cbe\u7075\u4e2d\u6d45\u80a4\u8272:",
    u"\U0001F9DD\U0001F3FD\U0000200D\U00002642": ":\u4eba\u7cbe\u7075\u4e2d\u7b49\u80a4\u8272:",
    u"\U0001F9DD\U0000200D\U00002642": ":\u4eba\u7cbe\u7075:",
    u"\U0001F9DD\U0001F3FF\U0000200D\U00002642\U0000FE0F": ":\u4eba\u7cbe\u7075\u9ed1\u80a4\u8272:",
    u"\U0001F9DD\U0001F3FB\U0000200D\U00002642\U0000FE0F": ":\u4eba\u7cbe\u7075\u6d45\u80a4\u8272:",
    u"\U0001F9DD\U0001F3FE\U0000200D\U00002642\U0000FE0F": ":\u7537\u7cbe\u7075\u4e2d\u6df1\u8272\u80a4\u8272:",
    u"\U0001F9DD\U0001F3FC\U0000200D\U00002642\U0000FE0F": ":\u7cbe\u7075\u80a4\u8272\u4e2d\u6d45\u80a4\u8272:",
    u"\U0001F9DD\U0001F3FD\U0000200D\U00002642\U0000FE0F": ":\u4eba\u7cbe\u7075\u4e2d\u7b49\u80a4\u8272:",
    u"\U0001F9DD\U0000200D\U00002642\U0000FE0F": ":\u4eba\u7cbe\u7075:",
    u"\U0001F926\U0001F3FF\U0000200D\U00002642": ":\u7537\u6027\u638c\u7eb9\u6697\u80a4\u8272:",
    u"\U0001F926\U0001F3FB\U0000200D\U00002642": ":\u7537\u6027\u638c\u7eb9\u6d45\u80a4\u8272:",
    u"\U0001F926\U0001F3FE\U0000200D\U00002642": ":\u7537\u58eb\u638c\u7eb9\u4e2d\u6df1\u8272\u80a4\u8272:",
    u"\U0001F926\U0001F3FC\U0000200D\U00002642": ":\u7537\u58eb\u638c\u7eb9\u4e2d\u6d45\u80a4\u8272:",
    u"\U0001F926\U0001F3FD\U0000200D\U00002642": ":\u7537\u58eb\u638c\u7eb9\u4e2d\u7b49\u80a4\u8272:",
    u"\U0001F926\U0000200D\U00002642": ":\u7537\u4eba\u638c\u5fc3:",
    u"\U0001F926\U0001F3FF\U0000200D\U00002642\U0000FE0F": ":\u7537\u6027\u638c\u7eb9\u6697\u80a4\u8272:",
    u"\U0001F926\U0001F3FB\U0000200D\U00002642\U0000FE0F": ":\u7537\u6027\u638c\u7eb9\u6d45\u80a4\u8272:",
    u"\U0001F926\U0001F3FE\U0000200D\U00002642\U0000FE0F": ":\u7537\u58eb\u638c\u7eb9\u4e2d\u6df1\u8272\u80a4\u8272:",
    u"\U0001F926\U0001F3FC\U0000200D\U00002642\U0000FE0F": ":\u7537\u58eb\u638c\u7eb9\u4e2d\u6d45\u80a4\u8272:",
    u"\U0001F926\U0001F3FD\U0000200D\U00002642\U0000FE0F": ":\u7537\u58eb\u638c\u7eb9\u4e2d\u7b49\u80a4\u8272:",
    u"\U0001F926\U0000200D\U00002642\U0000FE0F": ":\u4eba\u8138\u638c\u7eb9:",
    u"\U0001F468\U0000200D\U0001F3ED": ":\u5de5\u5382\u5de5\u4eba:",
    u"\U0001F468\U0001F3FF\U0000200D\U0001F3ED": ":\u7537\u5de5\u80a4\u8272\u6697\u6c89:",
    u"\U0001F468\U0001F3FB\U0000200D\U0001F3ED": ":\u7537\u5de5\u5382\u5de5\u4eba\u80a4\u8272\u6d45:",
    u"\U0001F468\U0001F3FE\U0000200D\U0001F3ED": ":\u7537\u5382\u5de5\u4eba\u4e2d\u6df1\u8272\u80a4\u8272:",
    u"\U0001F468\U0001F3FC\U0000200D\U0001F3ED": ":\u7537\u5de5\u4e2d\u6d45\u80a4\u8272:",
    u"\U0001F468\U0001F3FD\U0000200D\U0001F3ED": ":\u7537\u5382\u5de5\u4eba\u4e2d\u80a4\u8272:",
    u"\U0001F9DA\U0001F3FF\U0000200D\U00002642": ":\u7537\u4ed9\u5b50\u6697\u80a4\u8272:",
    u"\U0001F9DA\U0001F3FB\U0000200D\U00002642": ":\u7537\u4ed9\u5b50\u6d45\u80a4\u8272:",
    u"\U0001F9DA\U0001F3FE\U0000200D\U00002642": ":\u7537\u4ed9\u5b50\u4e2d\u6df1\u8272\u80a4\u8272:",
    u"\U0001F9DA\U0001F3FC\U0000200D\U00002642": ":\u7537\u4ed9\u5b50\u4e2d\u6d45\u80a4\u8272:",
    u"\U0001F9DA\U0001F3FD\U0000200D\U00002642": ":\u7537\u4ed9\u5b50\u4e2d\u80a4\u8272:",
    u"\U0001F9DA\U0000200D\U00002642": ":\u4eba\u7c7b\u7cbe\u7075:",
    u"\U0001F9DA\U0001F3FF\U0000200D\U00002642\U0000FE0F": ":\u7537\u4ed9\u5b50\u6697\u80a4\u8272:",
    u"\U0001F9DA\U0001F3FB\U0000200D\U00002642\U0000FE0F": ":\u7537\u4ed9\u5b50\u6d45\u80a4\u8272:",
    u"\U0001F9DA\U0001F3FE\U0000200D\U00002642\U0000FE0F": ":\u7537\u4ed9\u5b50\u4e2d\u6df1\u8272\u80a4\u8272:",
    u"\U0001F9DA\U0001F3FC\U0000200D\U00002642\U0000FE0F": ":\u7537\u4ed9\u5b50\u4e2d\u6d45\u80a4\u8272:",
    u"\U0001F9DA\U0001F3FD\U0000200D\U00002642\U0000FE0F": ":\u7537\u4ed9\u5b50\u4e2d\u80a4\u8272:",
    u"\U0001F9DA\U0000200D\U00002642\U0000FE0F": ":\u4eba\u5996:",
    u"\U0001F468\U0000200D\U0001F33E": ":\u519c\u573a\u4e3b:",
    u"\U0001F468\U0001F3FF\U0000200D\U0001F33E": ":\u7537\u519c\u592b\u80a4\u8272\u6697\u6c89:",
    u"\U0001F468\U0001F3FB\U0000200D\U0001F33E": ":\u7537\u4eba\u519c\u592b\u6d45\u80a4\u8272:",
    u"\U0001F468\U0001F3FE\U0000200D\U0001F33E": ":\u7537\u519c\u592b\u4e2d\u6df1\u8272\u80a4\u8272:",
    u"\U0001F468\U0001F3FC\U0000200D\U0001F33E": ":\u7537\u519c\u592b\u4e2d\u6d45\u80a4\u8272:",
    u"\U0001F468\U0001F3FD\U0000200D\U0001F33E": ":\u7537\u519c\u592b\u4e2d\u7b49\u80a4\u8272:",
    u"\U0001F468\U0000200D\U0001F692": ":\u6d88\u9632\u5458:",
    u"\U0001F468\U0001F3FF\U0000200D\U0001F692": ":\u7537\u6d88\u9632\u5458\u6df1\u8272\u80a4\u8272:",
    u"\U0001F468\U0001F3FB\U0000200D\U0001F692": ":\u7537\u6d88\u9632\u5458\u6d45\u80a4\u8272:",
    u"\U0001F468\U0001F3FE\U0000200D\U0001F692": ":\u7537\u6d88\u9632\u5458\u4e2d\u6df1\u8272\u80a4\u8272:",
    u"\U0001F468\U0001F3FC\U0000200D\U0001F692": ":\u7537\u6d88\u9632\u5458\u4e2d\u6d45\u80a4\u8272:",
    u"\U0001F468\U0001F3FD\U0000200D\U0001F692": ":\u7537\u6d88\u9632\u5458\u4e2d\u7b49\u80a4\u8272:",
    u"\U0001F64D\U0001F3FF\U0000200D\U00002642": ":\u7537\u4eba\u76b1\u7740\u7709\u5934\uff0c\u76ae\u80a4\u9edd\u9ed1:",
    u"\U0001F64D\U0001F3FB\U0000200D\U00002642": ":\u7537\u4eba\u76b1\u7709\u6d45\u80a4\u8272:",
    u"\U0001F64D\U0001F3FE\U0000200D\U00002642": ":\u7537\u4eba\u76b1\u7709\u4e2d\u6df1\u8272\u80a4\u8272:",
    u"\U0001F64D\U0001F3FC\U0000200D\U00002642": ":\u7537\u4eba\u76b1\u7709\u4e2d\u6d45\u80a4\u8272:",
    u"\U0001F64D\U0001F3FD\U0000200D\U00002642": ":\u7537\u4eba\u76b1\u7709\u4e2d\u7b49\u80a4\u8272:",
    u"\U0001F64D\U0000200D\U00002642": ":\u76b1\u7740\u7709\u5934\u7684\u7537\u4eba:",
    u"\U0001F64D\U0001F3FF\U0000200D\U00002642\U0000FE0F": ":\u7537\u4eba\u76b1\u7740\u7709\u5934\uff0c\u76ae\u80a4\u9edd\u9ed1:",
    u"\U0001F64D\U0001F3FB\U0000200D\U00002642\U0000FE0F": ":\u7537\u4eba\u76b1\u7709\u6d45\u80a4\u8272:",
    u"\U0001F64D\U0001F3FE\U0000200D\U00002642\U0000FE0F": ":\u7537\u4eba\u76b1\u7709\u4e2d\u6df1\u8272\u80a4\u8272:",
    u"\U0001F64D\U0001F3FC\U0000200D\U00002642\U0000FE0F": ":\u7537\u4eba\u76b1\u7709\u4e2d\u6d45\u80a4\u8272:",
    u"\U0001F64D\U0001F3FD\U0000200D\U00002642\U0000FE0F": ":\u7537\u4eba\u76b1\u7709\u4e2d\u7b49\u80a4\u8272:",
    u"\U0001F64D\U0000200D\U00002642\U0000FE0F": ":\u7537\u4eba\u76b1\u7709:",
    u"\U0001F9DE\U0000200D\U00002642": ":\u4eba\u7c7b\u7cbe\u7075:",
    u"\U0001F9DE\U0000200D\U00002642\U0000FE0F": ":\u4eba\u7cbe\u7075:",
    u"\U0001F645\U0001F3FF\U0000200D\U00002642": ":\u4e00\u4e2a\u6ca1\u6709\u6df1\u8272\u80a4\u8272\u7684\u7537\u4eba:",
    u"\U0001F645\U0001F3FB\U0000200D\U00002642": ":\u4e00\u4e2a\u6ca1\u6709\u80a4\u8272\u7684\u7537\u4eba:",
    u"\U0001F645\U0001F3FE\U0000200D\U00002642": ":\u4e00\u4e2a\u6ca1\u6709\u4e2d\u7b49\u80a4\u8272\u7684\u7537\u4eba:",
    u"\U0001F645\U0001F3FC\U0000200D\U00002642": ":\u7537\u4eba\u6ca1\u6709\u4e2d\u7b49\u80a4\u8272\u7684\u624b\u52bf:",
    u"\U0001F645\U0001F3FD\U0000200D\U00002642": ":\u7537\u4eba\u6ca1\u6709\u4e2d\u7b49\u80a4\u8272\u7684\u624b\u52bf:",
    u"\U0001F645\U0000200D\U00002642": ":\u7537\u4eba\u6253\u624b\u52bf\u8bf4\u4e0d:",
    u"\U0001F645\U0001F3FF\U0000200D\U00002642\U0000FE0F": ":\u4e00\u4e2a\u6ca1\u6709\u6df1\u8272\u80a4\u8272\u7684\u7537\u4eba:",
    u"\U0001F645\U0001F3FB\U0000200D\U00002642\U0000FE0F": ":\u4e00\u4e2a\u6ca1\u6709\u80a4\u8272\u7684\u7537\u4eba:",
    u"\U0001F645\U0001F3FE\U0000200D\U00002642\U0000FE0F": ":\u4e00\u4e2a\u6ca1\u6709\u4e2d\u7b49\u80a4\u8272\u7684\u7537\u4eba:",
    u"\U0001F645\U0001F3FC\U0000200D\U00002642\U0000FE0F": ":\u7537\u4eba\u6ca1\u6709\u4e2d\u7b49\u80a4\u8272\u7684\u624b\u52bf:",
    u"\U0001F645\U0001F3FD\U0000200D\U00002642\U0000FE0F": ":\u7537\u4eba\u6ca1\u6709\u4e2d\u7b49\u80a4\u8272\u7684\u624b\u52bf:",
    u"\U0001F645\U0000200D\U00002642\U0000FE0F": ":\u6253\u624b\u52bf\u7981\u6b62\u9009\u62e9:",
    u"\U0001F646\U0001F3FF\U0000200D\U00002642": ":\u7537\u4eba\u505a\u624b\u52bf\u597d\u7684\u6df1\u8272\u80a4\u8272:",
    u"\U0001F646\U0001F3FB\U0000200D\U00002642": ":\u7537\u4eba\u6253\u624b\u52bf\u53ef\u4ee5\u6de1\u80a4\u8272\u5417:",
    u"\U0001F646\U0001F3FE\U0000200D\U00002642": ":\u7537\u58eb\u624b\u52bfOK\u4e2d\u6df1\u8272\u80a4\u8272:",
    u"\U0001F646\U0001F3FC\U0000200D\U00002642": ":\u7537\u58eb\u624b\u52bfOK\u4e2d\u6d45\u80a4\u8272:",
    u"\U0001F646\U0001F3FD\U0000200D\U00002642": ":\u7537\u58eb\u624b\u52bfOK\u4e2d\u7b49\u80a4\u8272:",
    u"\U0001F646\U0000200D\U00002642": ":\u7537\u4eba\u505a\u624b\u52bf\u597d\u5417:",
    u"\U0001F646\U0001F3FF\U0000200D\U00002642\U0000FE0F": ":\u7537\u4eba\u505a\u624b\u52bf\u597d\u7684\u6df1\u8272\u80a4\u8272:",
    u"\U0001F646\U0001F3FB\U0000200D\U00002642\U0000FE0F": ":\u7537\u4eba\u6253\u624b\u52bf\u53ef\u4ee5\u6de1\u80a4\u8272\u5417:",
    u"\U0001F646\U0001F3FE\U0000200D\U00002642\U0000FE0F": ":\u7537\u58eb\u4e2d\u6027\u80a4\u8272:",
    u"\U0001F646\U0001F3FC\U0000200D\U00002642\U0000FE0F": ":\u7537\u58eb\u624b\u52bfOK\u4e2d\u6d45\u80a4\u8272:",
    u"\U0001F646\U0001F3FD\U0000200D\U00002642\U0000FE0F": ":\u7537\u58eb\u624b\u52bfOK\u4e2d\u7b49\u80a4\u8272:",
    u"\U0001F646\U0000200D\U00002642\U0000FE0F": ":\u7537\u5b50\u6253\u624b\u52bf\u201c\u597d\u201d:",
    u"\U0001F487\U0001F3FF\U0000200D\U00002642": ":\u7406\u53d1\u7684\u7537\u4eba\u80a4\u8272\u9edd\u9ed1:",
    u"\U0001F487\U0001F3FB\U0000200D\U00002642": ":\u7537\u58eb\u7406\u53d1\u80a4\u8272\u6d45:",
    u"\U0001F487\U0001F3FE\U0000200D\U00002642": ":\u7537\u58eb\u7406\u53d1\u4e2d\u6df1\u8272\u80a4\u8272:",
    u"\U0001F487\U0001F3FC\U0000200D\U00002642": ":\u7537\u58eb\u7406\u53d1\u4e2d\u6d45\u80a4\u8272:",
    u"\U0001F487\U0001F3FD\U0000200D\U00002642": ":\u7537\u58eb\u7406\u53d1\u4e2d\u7b49\u80a4\u8272:",
    u"\U0001F487\U0000200D\U00002642": ":\u7406\u53d1\u7684\u7537\u4eba:",
    u"\U0001F487\U0001F3FF\U0000200D\U00002642\U0000FE0F": ":\u7406\u53d1\u7684\u7537\u4eba\u80a4\u8272\u9edd\u9ed1:",
    u"\U0001F487\U0001F3FB\U0000200D\U00002642\U0000FE0F": ":\u7537\u58eb\u7406\u53d1\u80a4\u8272\u6d45:",
    u"\U0001F487\U0001F3FE\U0000200D\U00002642\U0000FE0F": ":\u7537\u58eb\u7406\u53d1\u4e2d\u6df1\u8272\u80a4\u8272:",
    u"\U0001F487\U0001F3FC\U0000200D\U00002642\U0000FE0F": ":\u7537\u58eb\u7406\u53d1\u4e2d\u6d45\u80a4\u8272:",
    u"\U0001F487\U0001F3FD\U0000200D\U00002642\U0000FE0F": ":\u7537\u58eb\u7406\u53d1\u4e2d\u7b49\u80a4\u8272:",
    u"\U0001F487\U0000200D\U00002642\U0000FE0F": ":\u7537\u7406\u53d1\u5e08:",
    u"\U0001F486\U0001F3FF\U0000200D\U00002642": ":\u7537\u58eb\u6309\u6469\u6df1\u8272\u80a4\u8272:",
    u"\U0001F486\U0001F3FB\U0000200D\U00002642": ":\u7537\u58eb\u6309\u6469\u6de1\u80a4\u8272:",
    u"\U0001F486\U0001F3FE\U0000200D\U00002642": ":\u7537\u58eb\u6309\u6469\u4e2d\u6df1\u8272\u80a4\u8272:",
    u"\U0001F486\U0001F3FC\U0000200D\U00002642": ":\u7537\u58eb\u6309\u6469\u4e2d\u6d45\u80a4\u8272:",
    u"\U0001F486\U0001F3FD\U0000200D\U00002642": ":\u7537\u58eb\u6309\u6469\u4e2d\u80a4\u8272:",
    u"\U0001F486\U0000200D\U00002642": ":\u7537\u6309\u6469\u5e08:",
    u"\U0001F486\U0001F3FF\U0000200D\U00002642\U0000FE0F": ":\u7537\u58eb\u6309\u6469\u6df1\u8272\u80a4\u8272:",
    u"\U0001F486\U0001F3FB\U0000200D\U00002642\U0000FE0F": ":\u7537\u58eb\u6309\u6469\u6de1\u80a4\u8272:",
    u"\U0001F486\U0001F3FE\U0000200D\U00002642\U0000FE0F": ":\u7537\u58eb\u6309\u6469\u4e2d\u6df1\u8272\u80a4\u8272:",
    u"\U0001F486\U0001F3FC\U0000200D\U00002642\U0000FE0F": ":\u7537\u58eb\u6309\u6469\u4e2d\u6d45\u80a4\u8272:",
    u"\U0001F486\U0001F3FD\U0000200D\U00002642\U0000FE0F": ":\u7537\u58eb\u6309\u6469\u4e2d\u80a4\u8272:",
    u"\U0001F486\U0000200D\U00002642\U0000FE0F": ":\u7537\u58eb\u6309\u6469\u9009\u62e9:",
    u"\U0001F3CC\U0001F3FF\U0000200D\U00002642": ":\u7537\u5b50\u9ad8\u5c14\u592b\u6df1\u8272\u80a4\u8272:",
    u"\U0001F3CC\U0001F3FB\U0000200D\U00002642": ":\u7537\u5b50\u9ad8\u5c14\u592b\u6d45\u80a4\u8272:",
    u"\U0001F3CC\U0001F3FE\U0000200D\U00002642": ":\u7537\u5b50\u9ad8\u5c14\u592b\u4e2d\u6df1\u8272\u80a4\u8272:",
    u"\U0001F3CC\U0001F3FC\U0000200D\U00002642": ":\u7537\u5b50\u9ad8\u5c14\u592b\u4e2d\u6d45\u80a4\u8272:",
    u"\U0001F3CC\U0001F3FD\U0000200D\U00002642": ":\u7537\u5b50\u9ad8\u5c14\u592b\u4e2d\u7b49\u80a4\u8272:",
    u"\U0001F3CC\U0000200D\U00002642": ":\u7537\u5b50\u9ad8\u5c14\u592b:",
    u"\U0001F3CC\U0000FE0F\U0000200D\U00002642\U0000FE0F": ":\u7537\u5b50\u9ad8\u5c14\u592b2:",
    u"\U0001F3CC\U0000200D\U00002642\U0000FE0F": ":\u7537\u5b50\u9ad8\u5c14\u592b3:",
    u"\U0001F3CC\U0001F3FF\U0000200D\U00002642\U0000FE0F": ":\u7537\u5b50\u9ad8\u5c14\u592b\u6df1\u8272\u80a4\u8272:",
    u"\U0001F3CC\U0001F3FB\U0000200D\U00002642\U0000FE0F": ":\u7537\u5b50\u9ad8\u5c14\u592b\u6d45\u80a4\u8272:",
    u"\U0001F3CC\U0001F3FE\U0000200D\U00002642\U0000FE0F": ":\u7537\u5b50\u9ad8\u5c14\u592b\u4e2d\u6df1\u8272\u80a4\u8272:",
    u"\U0001F3CC\U0001F3FC\U0000200D\U00002642\U0000FE0F": ":\u7537\u5b50\u9ad8\u5c14\u592b\u4e2d\u6d45\u80a4\u8272:",
    u"\U0001F3CC\U0001F3FD\U0000200D\U00002642\U0000FE0F": ":\u7537\u5b50\u9ad8\u5c14\u592b\u4e2d\u7b49\u80a4\u8272:",
    u"\U0001F3CC\U0000FE0F\U0000200D\U00002642": ":\u7537\u5b50\u9ad8\u5c14\u592b:",
    u"\U0001F482\U0001F3FF\U0000200D\U00002642": ":\u7537\u58eb\u62a4\u9ed1\u80a4\u8272:",
    u"\U0001F482\U0001F3FB\U0000200D\U00002642": ":\u7537\u58eb\u536b\u58eb\u6d45\u80a4\u8272:",
    u"\U0001F482\U0001F3FE\U0000200D\U00002642": ":\u7537\u58eb\u536b\u58eb\u4e2d\u6df1\u8272\u80a4\u8272:",
    u"\U0001F482\U0001F3FC\U0000200D\U00002642": ":\u7537\u58eb\u536b\u58eb\u4e2d\u6d45\u80a4\u8272:",
    u"\U0001F482\U0001F3FD\U0000200D\U00002642": ":\u7537\u58eb\u536b\u58eb\u4e2d\u7b49\u80a4\u8272:",
    u"\U0001F482\U0000200D\U00002642": ":\u8b66\u536b:",
    u"\U0001F482\U0001F3FF\U0000200D\U00002642\U0000FE0F": ":\u7537\u58eb\u62a4\u9ed1\u80a4\u8272:",
    u"\U0001F482\U0001F3FB\U0000200D\U00002642\U0000FE0F": ":\u7537\u58eb\u536b\u58eb\u6d45\u80a4\u8272:",
    u"\U0001F482\U0001F3FE\U0000200D\U00002642\U0000FE0F": ":\u7537\u58eb\u536b\u58eb\u4e2d\u6df1\u8272\u80a4\u8272:",
    u"\U0001F482\U0001F3FC\U0000200D\U00002642\U0000FE0F": ":\u7537\u58eb\u536b\u58eb\u4e2d\u6d45\u80a4\u8272:",
    u"\U0001F482\U0001F3FD\U0000200D\U00002642\U0000FE0F": ":\u7537\u58eb\u536b\u58eb\u4e2d\u7b49\u80a4\u8272:",
    u"\U0001F482\U0000200D\U00002642\U0000FE0F": ":\u4eba\u536b:",
    u"\U0001F468\U0001F3FF\U0000200D\U00002695": ":\u7537\u6027\u536b\u751f\u5de5\u4f5c\u8005\u80a4\u8272\u6697\u6c89:",
    u"\U0001F468\U0001F3FB\U0000200D\U00002695": ":\u7537\u536b\u751f\u5458\u80a4\u8272\u6d45:",
    u"\U0001F468\U0001F3FE\U0000200D\U00002695": ":\u7537\u6027\u536b\u751f\u5de5\u4f5c\u8005\u4e2d\u6df1\u8272\u80a4\u8272:",
    u"\U0001F468\U0001F3FC\U0000200D\U00002695": ":\u7537\u536b\u751f\u5458\u4e2d\u6d45\u80a4\u8272:",
    u"\U0001F468\U0001F3FD\U0000200D\U00002695": ":\u7537\u536b\u751f\u5458\u4e2d\u7b49\u80a4\u8272:",
    u"\U0001F468\U0000200D\U00002695": ":\u7537\u536b\u751f\u5458:",
    u"\U0001F468\U0001F3FF\U0000200D\U00002695\U0000FE0F": ":\u7537\u6027\u536b\u751f\u5de5\u4f5c\u8005\u80a4\u8272\u6697\u6c89:",
    u"\U0001F468\U0001F3FB\U0000200D\U00002695\U0000FE0F": ":\u7537\u536b\u751f\u5458\u80a4\u8272\u6d45:",
    u"\U0001F468\U0001F3FE\U0000200D\U00002695\U0000FE0F": ":\u7537\u6027\u536b\u751f\u5de5\u4f5c\u8005\u4e2d\u6df1\u8272\u80a4\u8272:",
    u"\U0001F468\U0001F3FC\U0000200D\U00002695\U0000FE0F": ":\u7537\u536b\u751f\u5458\u4e2d\u6d45\u80a4\u8272:",
    u"\U0001F468\U0001F3FD\U0000200D\U00002695\U0000FE0F": ":\u7537\u536b\u751f\u5458\u4e2d\u7b49\u80a4\u8272:",
    u"\U0001F468\U0000200D\U00002695\U0000FE0F": ":\u7537\u536b\u751f\u5de5\u4f5c\u8005\u9009\u62e9:",
    u"\U0001F9D8\U0001F3FF\U0000200D\U00002642": ":\u8377\u82b1\u4f4d\u7537\u58eb\u80a4\u8272\u6697\u6c89:",
    u"\U0001F9D8\U0001F3FB\U0000200D\U00002642": ":\u8377\u82b1\u4f4d\u7537\u58eb\u80a4\u8272\u6d45:",
    u"\U0001F9D8\U0001F3FE\U0000200D\U00002642": ":\u8377\u82b1\u4f4d\u7537\u58eb\u4e2d\u6df1\u8272\u80a4\u8272:",
    u"\U0001F9D8\U0001F3FC\U0000200D\U00002642": ":\u8377\u82b1\u4f4d\u7537\u58eb\u4e2d\u6d45\u80a4\u8272:",
    u"\U0001F9D8\U0001F3FD\U0000200D\U00002642": ":\u8377\u82b1\u4f4d\u7537\u58eb\u4e2d\u80a4\u8272:",
    u"\U0001F9D8\U0000200D\U00002642": ":\u83b2\u82b1\u4f4d\u7537\u5b50:",
    u"\U0001F9D8\U0001F3FF\U0000200D\U00002642\U0000FE0F": ":\u8377\u82b1\u4f4d\u7537\u58eb\u80a4\u8272\u6697\u6c89:",
    u"\U0001F9D8\U0001F3FB\U0000200D\U00002642\U0000FE0F": ":\u8377\u82b1\u4f4d\u7537\u58eb\u80a4\u8272\u6d45:",
    u"\U0001F9D8\U0001F3FE\U0000200D\U00002642\U0000FE0F": ":\u8377\u82b1\u4f4d\u7537\u58eb\u4e2d\u6df1\u8272\u80a4\u8272:",
    u"\U0001F9D8\U0001F3FC\U0000200D\U00002642\U0000FE0F": ":\u8377\u82b1\u4f4d\u7537\u58eb\u4e2d\u6d45\u80a4\u8272:",
    u"\U0001F9D8\U0001F3FD\U0000200D\U00002642\U0000FE0F": ":\u8377\u82b1\u4f4d\u7537\u58eb\u4e2d\u80a4\u8272:",
    u"\U0001F9D8\U0000200D\U00002642\U0000FE0F": ":\u83b2\u82b1\u4eba\u4f4d\u7f6e:",
    u"\U0001F468\U0001F3FF\U0000200D\U0001F9BD": ":\u5750\u624b\u52a8\u8f6e\u6905\u7684\u7537\u5b50\u80a4\u8272\u9edd\u9ed1:",
    u"\U0001F468\U0001F3FB\U0000200D\U0001F9BD": ":\u5750\u624b\u52a8\u8f6e\u6905\u7684\u7537\u5b50\u80a4\u8272\u6d45:",
    u"\U0001F468\U0001F3FE\U0000200D\U0001F9BD": ":\u5750\u624b\u52a8\u8f6e\u6905\u7684\u7537\u5b50\u80a4\u8272\u4e2d\u6697:",
    u"\U0001F468\U0001F3FC\U0000200D\U0001F9BD": ":\u5750\u624b\u52a8\u8f6e\u6905\u7684\u4eba-\u4e2d\u6d45\u80a4\u8272:",
    u"\U0001F468\U0001F3FD\U0000200D\U0001F9BD": ":\u5750\u624b\u52a8\u8f6e\u6905\u7684\u7537\u6027\u4e2d\u7b49\u80a4\u8272:",
    u"\U0001F468\U0000200D\U0001F9BD": ":\u5750\u624b\u52a8\u8f6e\u6905\u7684\u4eba:",
    u"\U0001F468\U0001F3FF\U0000200D\U0001F9BC": ":\u5750\u673a\u52a8\u8f6e\u6905\u7684\u7537\u5b50\u80a4\u8272\u9edd\u9ed1:",
    u"\U0001F468\U0001F3FB\U0000200D\U0001F9BC": ":\u5750\u673a\u52a8\u8f6e\u6905\u7684\u7537\u5b50\u80a4\u8272\u6d45:",
    u"\U0001F468\U0001F3FE\U0000200D\U0001F9BC": ":\u5750\u673a\u52a8\u8f6e\u6905\u7684\u7537\u5b50\u80a4\u8272\u4e2d\u7b49\u504f\u6697:",
    u"\U0001F468\U0001F3FC\U0000200D\U0001F9BC": ":\u5750\u673a\u52a8\u8f6e\u6905\u7684\u7537\u5b50\u80a4\u8272\u4e2d\u7b49\u504f\u6d45:",
    u"\U0001F468\U0001F3FD\U0000200D\U0001F9BC": ":\u5750\u673a\u52a8\u8f6e\u6905\u7684\u7537\u5b50\u4e2d\u7b49\u80a4\u8272:",
    u"\U0001F468\U0000200D\U0001F9BC": ":\u5750\u7535\u52a8\u8f6e\u6905\u7684\u4eba:",
    u"\U0001F9D6\U0001F3FF\U0000200D\U00002642": ":\u84b8\u6c7d\u623f\u91cc\u7684\u7537\u4eba\u80a4\u8272\u9edd\u9ed1:",
    u"\U0001F9D6\U0001F3FB\U0000200D\U00002642": ":\u84b8\u6c7d\u623f\u7537\u4eba\u80a4\u8272\u6d45:",
    u"\U0001F9D6\U0001F3FE\U0000200D\U00002642": ":\u84b8\u6c7d\u623f\u91cc\u7684\u7537\u4eba\u80a4\u8272\u4e2d\u7b49\u504f\u9ed1:",
    u"\U0001F9D6\U0001F3FC\U0000200D\U00002642": ":\u84b8\u6c7d\u623f\u91cc\u7684\u7537\u4eba\u4e2d\u6d45\u80a4\u8272:",
    u"\U0001F9D6\U0001F3FD\U0000200D\U00002642": ":\u84b8\u6c7d\u623f\u7537\u58eb\u4e2d\u7b49\u80a4\u8272:",
    u"\U0001F9D6\U0000200D\U00002642": ":\u84b8\u6c7d\u623f\u91cc\u7684\u7537\u4eba:",
    u"\U0001F9D6\U0001F3FF\U0000200D\U00002642\U0000FE0F": ":\u84b8\u6c7d\u623f\u91cc\u7684\u7537\u4eba\u80a4\u8272\u9edd\u9ed1:",
    u"\U0001F9D6\U0001F3FB\U0000200D\U00002642\U0000FE0F": ":\u84b8\u6c7d\u623f\u7537\u4eba\u80a4\u8272\u6d45:",
    u"\U0001F9D6\U0001F3FE\U0000200D\U00002642\U0000FE0F": ":\u84b8\u6c7d\u623f\u91cc\u7684\u7537\u4eba\u80a4\u8272\u4e2d\u7b49\u504f\u9ed1:",
    u"\U0001F9D6\U0001F3FC\U0000200D\U00002642\U0000FE0F": ":\u84b8\u6c7d\u623f\u91cc\u7684\u7537\u4eba\u4e2d\u6d45\u80a4\u8272:",
    u"\U0001F9D6\U0001F3FD\U0000200D\U00002642\U0000FE0F": ":\u84b8\u6c7d\u623f\u7537\u58eb\u4e2d\u7b49\u80a4\u8272:",
    u"\U0001F9D6\U0000200D\U00002642\U0000FE0F": ":\u5728\u84b8\u6c7d\u623f\u95f4\u91cc\u7684\u4eba\u9009\u62e9:",
    u"\U0001F574": ":\u897f\u88c5\u9769\u5c65:",
    u"\U0001F574\U0001F3FF": ":\u9ed1\u8863\u98d8\u98d8\u7537:",
    u"\U0001F574\U0001F3FB": ":\u897f\u88c5\u9769\u5c65\u8f7b\u8584\u80a4\u8272:",
    u"\U0001F574\U0001F3FE": ":\u897f\u88c5\u7537\u60ac\u6d6e\u4e2d\u6df1\u8272\u80a4\u8272:",
    u"\U0001F574\U0001F3FC": ":\u897f\u88c5\u98d8\u9038\u4e2d\u6d45\u80a4\u8272:",
    u"\U0001F574\U0001F3FD": ":\u897f\u88c5\u98d8\u9038\u4e2d\u80a4\u8272:",
    u"\U0001F574\U0000FE0F": ":\u897f\u88c5\u9769\u5c65:",
    u"\U0001F935": ":\u7a7f\u71d5\u5c3e\u670d\u7684\u7537\u4eba:",
    u"\U0001F935\U0001F3FF": ":\u7537\u58eb\u71d5\u5c3e\u670d\u6df1\u8272\u80a4\u8272:",
    u"\U0001F935\U0001F3FB": ":\u7537\u58eb\u71d5\u5c3e\u670d\u6d45\u80a4\u8272:",
    u"\U0001F935\U0001F3FE": ":\u7537\u58eb\u65e0\u5c3e\u665a\u793c\u670d\u4e2d\u6df1\u8272\u80a4\u8272:",
    u"\U0001F935\U0001F3FC": ":\u7537\u58eb\u65e0\u5c3e\u665a\u793c\u670d\u4e2d\u6d45\u80a4\u8272:",
    u"\U0001F935\U0001F3FD": ":\u7537\u58eb\u71d5\u5c3e\u670d\u4e2d\u7b49\u80a4\u8272:",
    u"\U0001F468\U0001F3FF\U0000200D\U00002696": ":\u7537\u4eba\u5224\u65ad\u80a4\u8272\u6697\u6c89:",
    u"\U0001F468\U0001F3FB\U0000200D\U00002696": ":\u7537\u4eba\u5224\u65ad\u80a4\u8272\u6d45:",
    u"\U0001F468\U0001F3FE\U0000200D\U00002696": ":\u7537\u58eb\u5224\u65ad\u4e2d\u6df1\u8272\u80a4\u8272:",
    u"\U0001F468\U0001F3FC\U0000200D\U00002696": ":\u7537\u58eb\u5224\u65ad\u4e2d\u6d45\u80a4\u8272:",
    u"\U0001F468\U0001F3FD\U0000200D\U00002696": ":\u7537\u58eb\u5224\u65ad\u4e2d\u7b49\u80a4\u8272:",
    u"\U0001F468\U0000200D\U00002696": ":\u7537\u6cd5\u5b98:",
    u"\U0001F468\U0001F3FF\U0000200D\U00002696\U0000FE0F": ":\u7537\u4eba\u5224\u65ad\u80a4\u8272\u6697\u6c89:",
    u"\U0001F468\U0001F3FB\U0000200D\U00002696\U0000FE0F": ":\u6d45\u80a4\u8272\u8bc4\u5224:",
    u"\U0001F468\U0001F3FE\U0000200D\U00002696\U0000FE0F": ":\u7537\u58eb\u5224\u65ad\u4e2d\u6df1\u8272\u80a4\u8272:",
    u"\U0001F468\U0001F3FC\U0000200D\U00002696\U0000FE0F": ":\u7537\u58eb\u5224\u65ad\u4e2d\u6d45\u80a4\u8272:",
    u"\U0001F468\U0001F3FD\U0000200D\U00002696\U0000FE0F": ":\u7537\u58eb\u5224\u65ad\u4e2d\u7b49\u80a4\u8272:",
    u"\U0001F468\U0000200D\U00002696\U0000FE0F": ":\u7537\u88c1\u5224:",
    u"\U0001F939\U0001F3FF\U0000200D\U00002642": ":\u53d8\u9ed1\u80a4\u8272\u7684\u7537\u4eba:",
    u"\U0001F939\U0001F3FB\U0000200D\U00002642": ":\u7537\u4eba\u53d8\u6d45\u80a4\u8272:",
    u"\U0001F939\U0001F3FE\U0000200D\U00002642": ":\u7537\u6742\u800d\u4e2d\u6df1\u8272\u80a4\u8272:",
    u"\U0001F939\U0001F3FC\U0000200D\U00002642": ":\u7537\u6742\u800d\u4e2d\u6d45\u80a4\u8272:",
    u"\U0001F939\U0001F3FD\U0000200D\U00002642": ":\u4e2d\u7b49\u80a4\u8272\u7684\u7537\u4eba:",
    u"\U0001F939\U0000200D\U00002642": ":\u73a9\u6742\u800d\u7684\u4eba:",
    u"\U0001F939\U0001F3FF\U0000200D\U00002642\U0000FE0F": ":\u53d8\u9ed1\u80a4\u8272\u7684\u7537\u4eba:",
    u"\U0001F939\U0001F3FB\U0000200D\U00002642\U0000FE0F": ":\u7537\u4eba\u53d8\u6d45\u80a4\u8272:",
    u"\U0001F939\U0001F3FE\U0000200D\U00002642\U0000FE0F": ":\u7537\u6742\u800d\u4e2d\u6df1\u8272\u80a4\u8272:",
    u"\U0001F939\U0001F3FC\U0000200D\U00002642\U0000FE0F": ":\u7537\u6742\u800d\u4e2d\u6d45\u80a4\u8272:",
    u"\U0001F939\U0001F3FD\U0000200D\U00002642\U0000FE0F": ":\u4e2d\u7b49\u80a4\u8272\u7684\u7537\u4eba:",
    u"\U0001F939\U0000200D\U00002642\U0000FE0F": ":\u6742\u800d:",
    u"\U0001F9CE\U0001F3FF\U0000200D\U00002642": ":\u7537\u5b50\u8dea\u4e0b\u80a4\u8272\u9edd\u9ed1:",
    u"\U0001F9CE\U0001F3FF\U0000200D\U00002642\U0000FE0F": ":\u7537\u4eba\u8dea\u4e0b\u6df1\u8272\u80a4\u8272:",
    u"\U0001F9CE\U0001F3FB\U0000200D\U00002642": ":\u7537\u4eba\u8dea\u5730\u80a4\u8272\u6d45:",
    u"\U0001F9CE\U0001F3FB\U0000200D\U00002642\U0000FE0F": ":\u7537\u58eb\u8dea\u5f0f\u6d45\u80a4\u8272:",
    u"\U0001F9CE\U0001F3FE\U0000200D\U00002642": ":\u7537\u4eba\u8dea\u5728\u5730\u4e0a\uff0c\u80a4\u8272\u4e2d\u7b49\u504f\u9ed1:",
    u"\U0001F9CE\U0001F3FE\U0000200D\U00002642\U0000FE0F": ":\u7537\u58eb\u8dea\u5f0f\u4e2d\u6df1\u8272\u80a4\u8272:",
    u"\U0001F9CE\U0001F3FC\U0000200D\U00002642": ":\u4e2d\u6d45\u80a4\u8272:",
    u"\U0001F9CE\U0001F3FC\U0000200D\U00002642\U0000FE0F": ":\u7537\u58eb\u8dea\u5f0f\u4e2d\u6d45\u80a4\u8272:",
    u"\U0001F9CE\U0001F3FD\U0000200D\U00002642": ":\u7537\u4eba\u8dea\u7740\u4e2d\u7b49\u80a4\u8272:",
    u"\U0001F9CE\U0001F3FD\U0000200D\U00002642\U0000FE0F": ":\u7537\u58eb\u8dea\u5f0f\u4e2d\u7b49\u80a4\u8272\u9009\u62e9:",
    u"\U0001F9CE\U0000200D\U00002642": ":\u8dea\u7740\u7684\u4eba:",
    u"\U0001F9CE\U0000200D\U00002642\U0000FE0F": ":\u4eba\u8dea\u5f0f:",
    u"\U0001F3CB\U0001F3FF\U0000200D\U00002642": ":\u7537\u5b50\u4e3e\u91cd\u6df1\u8272\u80a4\u8272:",
    u"\U0001F3CB\U0001F3FB\U0000200D\U00002642": ":\u7537\u5b50\u4e3e\u91cd\u8f7b\u80a4\u8272:",
    u"\U0001F3CB\U0001F3FE\U0000200D\U00002642": ":\u7537\u5b50\u4e3e\u91cd\u4e2d\u7b49\u80a4\u8272:",
    u"\U0001F3CB\U0001F3FC\U0000200D\U00002642": ":\u7537\u5b50\u4e3e\u91cd\u4e2d\u7b49\u504f\u8f7b\u80a4\u8272:",
    u"\U0001F3CB\U0001F3FD\U0000200D\U00002642": ":\u7537\u5b50\u4e3e\u91cd\u4e2d\u7b49\u80a4\u8272:",
    u"\U0001F3CB\U0000200D\U00002642": ":\u7537\u5b50\u4e3e\u91cd:",
    u"\U0001F3CB\U0000FE0F\U0000200D\U00002642\U0000FE0F": ":\u7537\u5b50\u4e3e\u91cd2:",
    u"\U0001F3CB\U0000200D\U00002642\U0000FE0F": ":\u7537\u5b50\u4e3e\u91cd3:",
    u"\U0001F3CB\U0001F3FF\U0000200D\U00002642\U0000FE0F": ":\u7537\u5b50\u4e3e\u91cd\u6df1\u8272\u80a4\u8272:",
    u"\U0001F3CB\U0001F3FB\U0000200D\U00002642\U0000FE0F": ":\u7537\u5b50\u4e3e\u91cd\u8f7b\u80a4\u8272:",
    u"\U0001F3CB\U0001F3FE\U0000200D\U00002642\U0000FE0F": ":\u7537\u5b50\u4e3e\u91cd\u4e2d\u7b49\u80a4\u8272:",
    u"\U0001F3CB\U0001F3FC\U0000200D\U00002642\U0000FE0F": ":\u7537\u5b50\u4e3e\u91cd\u4e2d\u7b49\u504f\u8f7b\u80a4\u8272:",
    u"\U0001F3CB\U0001F3FD\U0000200D\U00002642\U0000FE0F": ":\u7537\u5b50\u4e3e\u91cd\u4e2d\u7b49\u80a4\u8272:",
    u"\U0001F3CB\U0000FE0F\U0000200D\U00002642": ":\u7537\u5b50\u4e3e\u91cd:",
    u"\U0001F468\U0001F3FB": ":\u7537\u58eb\u6d45\u80a4\u8272:",
    u"\U0001F9D9\U0001F3FF\U0000200D\U00002642": ":\u7537\u9b54\u6cd5\u5e08\u6697\u80a4\u8272:",
    u"\U0001F9D9\U0001F3FB\U0000200D\U00002642": ":\u7537\u6cd5\u5e08\u6d45\u80a4\u8272:",
    u"\U0001F9D9\U0001F3FE\U0000200D\U00002642": ":\u7537\u6cd5\u5e08\u4e2d\u6df1\u8272\u80a4\u8272:",
    u"\U0001F9D9\U0001F3FC\U0000200D\U00002642": ":\u7537\u6cd5\u5e08\u4e2d\u6d45\u80a4\u8272:",
    u"\U0001F9D9\U0001F3FD\U0000200D\U00002642": ":\u7537\u6cd5\u5e08\u4e2d\u7b49\u80a4\u8272:",
    u"\U0001F9D9\U0000200D\U00002642": ":\u7537\u6cd5\u5e08:",
    u"\U0001F9D9\U0001F3FF\U0000200D\U00002642\U0000FE0F": ":\u7537\u9b54\u6cd5\u5e08\u6697\u80a4\u8272:",
    u"\U0001F9D9\U0001F3FB\U0000200D\U00002642\U0000FE0F": ":\u7537\u6cd5\u5e08\u6d45\u80a4\u8272:",
    u"\U0001F9D9\U0001F3FE\U0000200D\U00002642\U0000FE0F": ":\u7537\u6cd5\u5e08\u4e2d\u6df1\u8272\u80a4\u8272:",
    u"\U0001F9D9\U0001F3FC\U0000200D\U00002642\U0000FE0F": ":\u7537\u6cd5\u5e08\u4e2d\u6d45\u80a4\u8272:",
    u"\U0001F9D9\U0001F3FD\U0000200D\U00002642\U0000FE0F": ":\u7537\u6cd5\u5e08\u4e2d\u7b49\u80a4\u8272:",
    u"\U0001F9D9\U0000200D\U00002642\U0000FE0F": ":\u4eba\u6cd5\u5e08:",
    u"\U0001F468\U0000200D\U0001F527": ":\u673a\u68b0\u5e08:",
    u"\U0001F468\U0001F3FF\U0000200D\U0001F527": ":\u7537\u673a\u68b0\u5e08\u6697\u80a4\u8272:",
    u"\U0001F468\U0001F3FB\U0000200D\U0001F527": ":\u7537\u673a\u68b0\u5e08\u6d45\u80a4\u8272:",
    u"\U0001F468\U0001F3FE\U0000200D\U0001F527": ":\u7537\u673a\u68b0\u5e08\u4e2d\u6df1\u8272\u80a4\u8272:",
    u"\U0001F468\U0001F3FC\U0000200D\U0001F527": ":\u7537\u673a\u68b0\u4e2d\u6d45\u80a4\u8272:",
    u"\U0001F468\U0001F3FD\U0000200D\U0001F527": ":\u7537\u673a\u68b0\u4e2d\u7b49\u80a4\u8272:",
    u"\U0001F468\U0001F3FE": ":\u7537\u6027\u4e2d\u6df1\u8272\u80a4\u8272:",
    u"\U0001F468\U0001F3FC": ":\u7537\u58eb\u4e2d\u6d45\u80a4\u8272:",
    u"\U0001F468\U0001F3FD": ":\u7537\u58eb\u4e2d\u7b49\u80a4\u8272:",
    u"\U0001F6B5\U0001F3FF\U0000200D\U00002642": ":\u7537\u5b50\u5c71\u5730\u81ea\u884c\u8f66\u6df1\u8272\u80a4\u8272:",
    u"\U0001F6B5\U0001F3FB\U0000200D\U00002642": ":\u7537\u5b50\u5c71\u5730\u81ea\u884c\u8f66\u6d45\u80a4\u8272:",
    u"\U0001F6B5\U0001F3FE\U0000200D\U00002642": ":\u7537\u5b50\u5c71\u5730\u81ea\u884c\u8f66\u4e2d\u6df1\u8272\u80a4\u8272:",
    u"\U0001F6B5\U0001F3FC\U0000200D\U00002642": ":\u7537\u5b50\u5c71\u5730\u81ea\u884c\u8f66\u4e2d\u6d45\u80a4\u8272:",
    u"\U0001F6B5\U0001F3FD\U0000200D\U00002642": ":\u7537\u5b50\u5c71\u5730\u81ea\u884c\u8f66\u4e2d\u7b49\u80a4\u8272:",
    u"\U0001F6B5\U0000200D\U00002642": ":\u7537\u5b50\u5c71\u5730\u81ea\u884c\u8f66:",
    u"\U0001F6B5\U0001F3FF\U0000200D\U00002642\U0000FE0F": ":\u7537\u5b50\u5c71\u5730\u81ea\u884c\u8f66\u6df1\u8272\u80a4\u8272:",
    u"\U0001F6B5\U0001F3FB\U0000200D\U00002642\U0000FE0F": ":\u7537\u5b50\u5c71\u5730\u81ea\u884c\u8f66\u6d45\u80a4\u8272:",
    u"\U0001F6B5\U0001F3FE\U0000200D\U00002642\U0000FE0F": ":\u7537\u5b50\u5c71\u5730\u81ea\u884c\u8f66\u4e2d\u6df1\u8272\u80a4\u8272:",
    u"\U0001F6B5\U0001F3FC\U0000200D\U00002642\U0000FE0F": ":\u7537\u5b50\u5c71\u5730\u81ea\u884c\u8f66\u4e2d\u6d45\u80a4\u8272:",
    u"\U0001F6B5\U0001F3FD\U0000200D\U00002642\U0000FE0F": ":\u7537\u5b50\u5c71\u5730\u81ea\u884c\u8f66\u4e2d\u7b49\u80a4\u8272:",
    u"\U0001F6B5\U0000200D\U00002642\U0000FE0F": ":\u7537\u5b50\u5c71\u5730\u81ea\u884c\u8f66:",
    u"\U0001F468\U0000200D\U0001F4BC": ":\u529e\u516c\u5ba4\u804c\u5458:",
    u"\U0001F468\U0001F3FF\U0000200D\U0001F4BC": ":\u529e\u516c\u5ba4\u804c\u5458\u80a4\u8272\u6697\u6c89:",
    u"\U0001F468\U0001F3FB\U0000200D\U0001F4BC": ":\u4e0a\u73ed\u65cf\u6d45\u80a4\u8272:",
    u"\U0001F468\U0001F3FE\U0000200D\U0001F4BC": ":\u7537\u529e\u516c\u5ba4\u804c\u5458\u4e2d\u6df1\u8272\u80a4\u8272:",
    u"\U0001F468\U0001F3FC\U0000200D\U0001F4BC": ":\u7537\u4e0a\u73ed\u65cf\u4e2d\u6d45\u80a4\u8272:",
    u"\U0001F468\U0001F3FD\U0000200D\U0001F4BC": ":\u529e\u516c\u5ba4\u804c\u5458\u4e2d\u7b49\u80a4\u8272:",
    u"\U0001F468\U0001F3FF\U0000200D\U00002708": ":\u7537\u98de\u884c\u5458\u6df1\u8272\u80a4\u8272:",
    u"\U0001F468\U0001F3FB\U0000200D\U00002708": ":\u7537\u98de\u884c\u5458\u6d45\u80a4\u8272:",
    u"\U0001F468\U0001F3FE\U0000200D\U00002708": ":\u7537\u98de\u884c\u5458\u4e2d\u6df1\u8272\u80a4\u8272:",
    u"\U0001F468\U0001F3FC\U0000200D\U00002708": ":\u7537\u98de\u884c\u5458\u4e2d\u6d45\u80a4\u8272:",
    u"\U0001F468\U0001F3FD\U0000200D\U00002708": ":\u7537\u98de\u884c\u5458\u4e2d\u7b49\u80a4\u8272:",
    u"\U0001F468\U0000200D\U00002708": ":\u9a7e\u9a76\u5458:",
    u"\U0001F468\U0001F3FF\U0000200D\U00002708\U0000FE0F": ":\u7537\u98de\u884c\u5458\u6df1\u8272\u80a4\u8272:",
    u"\U0001F468\U0001F3FB\U0000200D\U00002708\U0000FE0F": ":\u7537\u98de\u884c\u5458\u6d45\u80a4\u8272:",
    u"\U0001F468\U0001F3FE\U0000200D\U00002708\U0000FE0F": ":\u7537\u98de\u884c\u5458\u4e2d\u6df1\u8272\u80a4\u8272:",
    u"\U0001F468\U0001F3FC\U0000200D\U00002708\U0000FE0F": ":\u7537\u98de\u884c\u5458\u4e2d\u6d45\u80a4\u8272:",
    u"\U0001F468\U0001F3FD\U0000200D\U00002708\U0000FE0F": ":\u7537\u98de\u884c\u5458\u4e2d\u7b49\u80a4\u8272:",
    u"\U0001F468\U0000200D\U00002708\U0000FE0F": ":\u4eba\u5de5\u9a7e\u9a76:",
    u"\U0001F93E\U0001F3FF\U0000200D\U00002642": ":\u7537\u5b50\u6253\u624b\u7403\u80a4\u8272\u6697\u6c89:",
    u"\U0001F93E\U0001F3FB\U0000200D\U00002642": ":\u7537\u5b50\u624b\u7403\u8f7b\u80a4\u8272:",
    u"\U0001F93E\U0001F3FE\U0000200D\U00002642": ":\u7537\u5b50\u624b\u7403\u4e2d\u6df1\u8272\u80a4\u8272:",
    u"\U0001F93E\U0001F3FC\U0000200D\U00002642": ":\u7537\u5b50\u624b\u7403\u4e2d\u6d45\u80a4\u8272:",
    u"\U0001F93E\U0001F3FD\U0000200D\U00002642": ":\u7537\u5b50\u624b\u7403\u4e2d\u7b49\u80a4\u8272:",
    u"\U0001F93E\U0000200D\U00002642": ":\u6253\u624b\u7403\u7684\u4eba:",
    u"\U0001F93E\U0001F3FF\U0000200D\U00002642\U0000FE0F": ":\u7537\u5b50\u6253\u624b\u7403\u80a4\u8272\u6697\u6c89:",
    u"\U0001F93E\U0001F3FB\U0000200D\U00002642\U0000FE0F": ":\u7537\u5b50\u624b\u7403\u8f7b\u80a4\u8272:",
    u"\U0001F93E\U0001F3FE\U0000200D\U00002642\U0000FE0F": ":\u7537\u5b50\u624b\u7403\u4e2d\u6df1\u8272\u80a4\u8272:",
    u"\U0001F93E\U0001F3FC\U0000200D\U00002642\U0000FE0F": ":\u7537\u5b50\u624b\u7403\u4e2d\u6d45\u80a4\u8272:",
    u"\U0001F93E\U0001F3FD\U0000200D\U00002642\U0000FE0F": ":\u7537\u5b50\u624b\u7403\u4e2d\u7b49\u80a4\u8272:",
    u"\U0001F93E\U0000200D\U00002642\U0000FE0F": ":\u7537\u5b50\u624b\u7403:",
    u"\U0001F93D\U0001F3FF\U0000200D\U00002642": ":\u7537\u5b50\u6253\u6c34\u7403\u80a4\u8272\u6697\u6c89:",
    u"\U0001F93D\U0001F3FB\U0000200D\U00002642": ":\u7537\u5b50\u6253\u6c34\u7403\u6d45\u80a4\u8272:",
    u"\U0001F93D\U0001F3FE\U0000200D\U00002642": ":\u7537\u5b50\u6c34\u7403\u4e2d\u6df1\u8272\u80a4\u8272:",
    u"\U0001F93D\U0001F3FC\U0000200D\U00002642": ":\u7537\u5b50\u6c34\u7403\u4e2d\u6d45\u80a4\u8272:",
    u"\U0001F93D\U0001F3FD\U0000200D\U00002642": ":\u7537\u5b50\u6c34\u7403\u4e2d\u7b49\u80a4\u8272:",
    u"\U0001F93D\U0000200D\U00002642": ":\u6253\u6c34\u7403\u7684\u4eba:",
    u"\U0001F93D\U0001F3FF\U0000200D\U00002642\U0000FE0F": ":\u7537\u5b50\u6253\u6c34\u7403\u80a4\u8272\u6697\u6c89:",
    u"\U0001F93D\U0001F3FB\U0000200D\U00002642\U0000FE0F": ":\u7537\u5b50\u6253\u6c34\u7403\u6d45\u80a4\u8272:",
    u"\U0001F93D\U0001F3FE\U0000200D\U00002642\U0000FE0F": ":\u7537\u5b50\u6c34\u7403\u4e2d\u6df1\u8272\u80a4\u8272:",
    u"\U0001F93D\U0001F3FC\U0000200D\U00002642\U0000FE0F": ":\u7537\u5b50\u6c34\u7403\u4e2d\u6d45\u80a4\u8272:",
    u"\U0001F93D\U0001F3FD\U0000200D\U00002642\U0000FE0F": ":\u7537\u5b50\u6c34\u7403\u4e2d\u7b49\u80a4\u8272:",
    u"\U0001F93D\U0000200D\U00002642\U0000FE0F": ":\u7537\u5b50\u6253\u6c34\u7403:",
    u"\U0001F46E\U0001F3FF\U0000200D\U00002642": ":\u7537\u8b66\u5b98\u6df1\u8272\u80a4\u8272:",
    u"\U0001F46E\U0001F3FB\U0000200D\U00002642": ":\u7537\u8b66\u5b98\u80a4\u8272\u6d45:",
    u"\U0001F46E\U0001F3FE\U0000200D\U00002642": ":\u7537\u8b66\u5b98\u4e2d\u6df1\u8272\u80a4\u8272:",
    u"\U0001F46E\U0001F3FC\U0000200D\U00002642": ":\u7537\u8b66\u5b98\u4e2d\u6d45\u80a4\u8272:",
    u"\U0001F46E\U0001F3FD\U0000200D\U00002642": ":\u7537\u8b66\u5b98\u4e2d\u7b49\u80a4\u8272:",
    u"\U0001F46E\U0000200D\U00002642": ":\u7537\u8b66\u5b98:",
    u"\U0001F46E\U0001F3FF\U0000200D\U00002642\U0000FE0F": ":\u7537\u8b66\u5b98\u6df1\u8272\u80a4\u8272:",
    u"\U0001F46E\U0001F3FB\U0000200D\U00002642\U0000FE0F": ":\u7537\u8b66\u5b98\u80a4\u8272\u6d45:",
    u"\U0001F46E\U0001F3FE\U0000200D\U00002642\U0000FE0F": ":\u7537\u8b66\u5b98\u4e2d\u6df1\u8272\u80a4\u8272:",
    u"\U0001F46E\U0001F3FC\U0000200D\U00002642\U0000FE0F": ":\u7537\u8b66\u5b98\u4e2d\u6d45\u80a4\u8272:",
    u"\U0001F46E\U0001F3FD\U0000200D\U00002642\U0000FE0F": ":\u7537\u8b66\u5b98\u4e2d\u7b49\u80a4\u8272:",
    u"\U0001F46E\U0000200D\U00002642\U0000FE0F": ":\u7537\u8b66\u5b98:",
    u"\U0001F64E\U0001F3FF\U0000200D\U00002642": ":\u7537\u4eba\u6485\u7740\u5634\uff0c\u80a4\u8272\u9edd\u9ed1:",
    u"\U0001F64E\U0001F3FB\U0000200D\U00002642": ":\u7537\u4eba\u6485\u7740\u6d45\u8272\u80a4\u8272:",
    u"\U0001F64E\U0001F3FE\U0000200D\U00002642": ":\u7537\u4eba\u6485\u7740\u5634\uff0c\u80a4\u8272\u4e2d\u7b49\u504f\u9ed1:",
    u"\U0001F64E\U0001F3FC\U0000200D\U00002642": ":\u7537\u58eb\u6485\u8d77\u4e2d\u6d45\u80a4\u8272:",
    u"\U0001F64E\U0001F3FD\U0000200D\U00002642": ":\u7537\u4eba\u6485\u7740\u5634\u4e2d\u7b49\u80a4\u8272:",
    u"\U0001F64E\U0000200D\U00002642": ":\u7537\u4eba\u6485\u5634:",
    u"\U0001F64E\U0001F3FF\U0000200D\U00002642\U0000FE0F": ":\u7537\u4eba\u6485\u7740\u5634\uff0c\u80a4\u8272\u9edd\u9ed1:",
    u"\U0001F64E\U0001F3FB\U0000200D\U00002642\U0000FE0F": ":\u7537\u4eba\u6485\u7740\u6d45\u8272\u80a4\u8272:",
    u"\U0001F64E\U0001F3FE\U0000200D\U00002642\U0000FE0F": ":\u7537\u4eba\u6485\u7740\u5634\uff0c\u80a4\u8272\u4e2d\u7b49\u504f\u9ed1:",
    u"\U0001F64E\U0001F3FC\U0000200D\U00002642\U0000FE0F": ":\u7537\u58eb\u6485\u8d77\u4e2d\u6d45\u80a4\u8272:",
    u"\U0001F64E\U0001F3FD\U0000200D\U00002642\U0000FE0F": ":\u7537\u4eba\u6485\u7740\u5634\u4e2d\u7b49\u80a4\u8272:",
    u"\U0001F64E\U0000200D\U00002642\U0000FE0F": ":\u7537\u4eba\u6485\u5634:",
    u"\U0001F64B\U0001F3FF\U0000200D\U00002642": ":\u63d0\u7537\u624b\u6697\u80a4\u8272:",
    u"\U0001F64B\U0001F3FB\U0000200D\U00002642": ":\u62ac\u624b\u8f7b\u80a4\u8272:",
    u"\U0001F64B\U0001F3FE\U0000200D\U00002642": ":\u7537\u58eb\u62ac\u624b\u4e2d\u6df1\u8272\u80a4\u8272:",
    u"\U0001F64B\U0001F3FC\U0000200D\U00002642": ":\u7537\u58eb\u62ac\u624b\u4e2d\u6d45\u80a4\u8272:",
    u"\U0001F64B\U0001F3FD\U0000200D\U00002642": ":\u7537\u58eb\u62ac\u624b\u4e2d\u80a4\u8272:",
    u"\U0001F64B\U0000200D\U00002642": ":\u4e3e\u624b:",
    u"\U0001F64B\U0001F3FF\U0000200D\U00002642\U0000FE0F": ":\u63d0\u7537\u624b\u6697\u80a4\u8272:",
    u"\U0001F64B\U0001F3FB\U0000200D\U00002642\U0000FE0F": ":\u62ac\u624b\u8f7b\u80a4\u8272:",
    u"\U0001F64B\U0001F3FE\U0000200D\U00002642\U0000FE0F": ":\u7537\u58eb\u62ac\u624b\u4e2d\u6df1\u8272\u80a4\u8272:",
    u"\U0001F64B\U0001F3FC\U0000200D\U00002642\U0000FE0F": ":\u7537\u58eb\u62ac\u624b\u4e2d\u6d45\u80a4\u8272:",
    u"\U0001F64B\U0001F3FD\U0000200D\U00002642\U0000FE0F": ":\u7537\u58eb\u62ac\u624b\u4e2d\u80a4\u8272:",
    u"\U0001F64B\U0000200D\U00002642\U0000FE0F": ":\u5347\u964d\u624b:",
    u"\U0001F6A3\U0001F3FF\U0000200D\U00002642": ":\u7537\u5b50\u5212\u8239\u6df1\u8272\u80a4\u8272:",
    u"\U0001F6A3\U0001F3FB\U0000200D\U00002642": ":\u7537\u5b50\u5212\u8239\u6d45\u80a4\u8272:",
    u"\U0001F6A3\U0001F3FE\U0000200D\U00002642": ":\u7537\u5b50\u5212\u8239\u4e2d\u6df1\u8272\u80a4\u8272:",
    u"\U0001F6A3\U0001F3FC\U0000200D\U00002642": ":\u5212\u8247\u4e2d\u6d45\u80a4\u8272:",
    u"\U0001F6A3\U0001F3FD\U0000200D\U00002642": ":\u7537\u5b50\u5212\u8239\u4e2d\u7b49\u80a4\u8272:",
    u"\U0001F6A3\U0000200D\U00002642": ":\u5212\u8247:",
    u"\U0001F6A3\U0001F3FF\U0000200D\U00002642\U0000FE0F": ":\u7537\u5b50\u5212\u8239\u6df1\u8272\u80a4\u8272:",
    u"\U0001F6A3\U0001F3FB\U0000200D\U00002642\U0000FE0F": ":\u7537\u5b50\u5212\u8239\u6d45\u80a4\u8272:",
    u"\U0001F6A3\U0001F3FE\U0000200D\U00002642\U0000FE0F": ":\u7537\u5b50\u5212\u8239\u4e2d\u6df1\u8272\u80a4\u8272:",
    u"\U0001F6A3\U0001F3FC\U0000200D\U00002642\U0000FE0F": ":\u5212\u8247\u4e2d\u6d45\u80a4\u8272:",
    u"\U0001F6A3\U0001F3FD\U0000200D\U00002642\U0000FE0F": ":\u7537\u5b50\u5212\u8239\u4e2d\u7b49\u80a4\u8272:",
    u"\U0001F6A3\U0000200D\U00002642\U0000FE0F": ":\u4eba\u5212\u8247:",
    u"\U0001F3C3\U0001F3FF\U0000200D\U00002642": ":\u80a4\u8272\u6697\u6c89\u7684\u7537\u4eba:",
    u"\U0001F3C3\U0001F3FB\U0000200D\U00002642": ":\u7537\u58eb\u8dd1\u6b65\u6de1\u80a4\u8272:",
    u"\U0001F3C3\U0001F3FE\U0000200D\U00002642": ":\u7537\u6027\u8dd1\u6b65\u4e2d\u6df1\u8272\u80a4\u8272:",
    u"\U0001F3C3\U0001F3FC\U0000200D\U00002642": ":\u7537\u58eb\u8dd1\u6b65\u4e2d\u6d45\u80a4\u8272:",
    u"\U0001F3C3\U0001F3FD\U0000200D\U00002642": ":\u7537\u58eb\u8dd1\u6b65\u4e2d\u7b49\u80a4\u8272:",
    u"\U0001F3C3\U0000200D\U00002642": ":\u4eba\u5728\u5954\u8dd1:",
    u"\U0001F3C3\U0001F3FF\U0000200D\U00002642\U0000FE0F": ":\u80a4\u8272\u6697\u6c89\u7684\u7537\u4eba:",
    u"\U0001F3C3\U0001F3FB\U0000200D\U00002642\U0000FE0F": ":\u7537\u58eb\u8dd1\u6b65\u6de1\u80a4\u8272:",
    u"\U0001F3C3\U0001F3FE\U0000200D\U00002642\U0000FE0F": ":\u7537\u6027\u8dd1\u6b65\u4e2d\u6df1\u8272\u80a4\u8272:",
    u"\U0001F3C3\U0001F3FC\U0000200D\U00002642\U0000FE0F": ":\u7537\u58eb\u8dd1\u6b65\u4e2d\u6d45\u80a4\u8272:",
    u"\U0001F3C3\U0001F3FD\U0000200D\U00002642\U0000FE0F": ":\u7537\u58eb\u8dd1\u6b65\u4e2d\u7b49\u80a4\u8272:",
    u"\U0001F3C3\U0000200D\U00002642\U0000FE0F": ":\u4eba\u5de5\u9a7e\u9a76:",
    u"\U0001F468\U0000200D\U0001F52C": ":\u4eba\u7c7b\u79d1\u5b66\u5bb6:",
    u"\U0001F468\U0001F3FF\U0000200D\U0001F52C": ":\u7537\u79d1\u5b66\u5bb6\u6697\u80a4\u8272:",
    u"\U0001F468\U0001F3FB\U0000200D\U0001F52C": ":\u7537\u79d1\u5b66\u5bb6\u6d45\u80a4\u8272:",
    u"\U0001F468\U0001F3FE\U0000200D\U0001F52C": ":\u7537\u79d1\u5b66\u5bb6\u4e2d\u6df1\u8272\u80a4\u8272:",
    u"\U0001F468\U0001F3FC\U0000200D\U0001F52C": ":\u7537\u79d1\u5b66\u5bb6\u4e2d\u6d45\u80a4\u8272:",
    u"\U0001F468\U0001F3FD\U0000200D\U0001F52C": ":\u7537\u79d1\u5b66\u5bb6\u4e2d\u7b49\u80a4\u8272:",
    u"\U0001F937\U0001F3FF\U0000200D\U00002642": ":\u7537\u4eba\u8038\u8038\u80a9\u6df1\u8272\u80a4\u8272:",
    u"\U0001F937\U0001F3FB\U0000200D\U00002642": ":\u7537\u4eba\u8038\u8038\u80a9\u6d45\u80a4\u8272:",
    u"\U0001F937\U0001F3FE\U0000200D\U00002642": ":\u7537\u4eba\u8038\u8038\u80a9\uff0c\u80a4\u8272\u4e2d\u7b49\u504f\u9ed1:",
    u"\U0001F937\U0001F3FC\U0000200D\U00002642": ":\u7537\u58eb\u8038\u8038\u80a9\u4e2d\u6d45\u80a4\u8272:",
    u"\U0001F937\U0001F3FD\U0000200D\U00002642": ":\u7537\u58eb\u8038\u80a9\u4e2d\u7b49\u80a4\u8272:",
    u"\U0001F937\U0000200D\U00002642": ":\u7537\u4eba\u8038\u8038\u80a9:",
    u"\U0001F937\U0001F3FF\U0000200D\U00002642\U0000FE0F": ":\u7537\u4eba\u8038\u8038\u80a9\u6df1\u8272\u80a4\u8272:",
    u"\U0001F937\U0001F3FB\U0000200D\U00002642\U0000FE0F": ":\u7537\u4eba\u8038\u8038\u80a9\u6d45\u80a4\u8272:",
    u"\U0001F937\U0001F3FE\U0000200D\U00002642\U0000FE0F": ":\u7537\u4eba\u8038\u8038\u80a9\uff0c\u80a4\u8272\u4e2d\u7b49\u504f\u9ed1:",
    u"\U0001F937\U0001F3FC\U0000200D\U00002642\U0000FE0F": ":\u7537\u58eb\u8038\u8038\u80a9\u4e2d\u6d45\u80a4\u8272:",
    u"\U0001F937\U0001F3FD\U0000200D\U00002642\U0000FE0F": ":\u7537\u58eb\u8038\u80a9\u4e2d\u7b49\u80a4\u8272:",
    u"\U0001F937\U0000200D\U00002642\U0000FE0F": ":\u7537\u4eba\u8038\u8038\u80a9:",
    u"\U0001F468\U0000200D\U0001F3A4": ":\u7537\u6b4c\u624b:",
    u"\U0001F468\U0001F3FF\U0000200D\U0001F3A4": ":\u7537\u6b4c\u624b\u6697\u80a4\u8272:",
    u"\U0001F468\U0001F3FB\U0000200D\U0001F3A4": ":\u7537\u6b4c\u624b\u6d45\u80a4\u8272:",
    u"\U0001F468\U0001F3FE\U0000200D\U0001F3A4": ":\u7537\u6b4c\u624b\u4e2d\u6df1\u8272\u80a4\u8272:",
    u"\U0001F468\U0001F3FC\U0000200D\U0001F3A4": ":\u7537\u6b4c\u624b\u4e2d\u6d45\u80a4\u8272:",
    u"\U0001F468\U0001F3FD\U0000200D\U0001F3A4": ":\u7537\u6b4c\u624b\u4e2d\u7b49\u80a4\u8272:",
    u"\U0001F9CD\U0001F3FF\U0000200D\U00002642": ":\u6df1\u8272\u80a4\u8272:",
    u"\U0001F9CD\U0001F3FF\U0000200D\U00002642\U0000FE0F": ":\u7537\u58eb\u7ad9\u7acb\u6df1\u8272\u80a4\u8272:",
    u"\U0001F9CD\U0001F3FB\U0000200D\U00002642": ":\u7537\u58eb\u7ad9\u7acb\u8f7b\u80a4\u8272:",
    u"\U0001F9CD\U0001F3FB\U0000200D\U00002642\U0000FE0F": ":\u7537\u58eb\u7ad9\u706f\u80a4\u8272:",
    u"\U0001F9CD\U0001F3FE\U0000200D\U00002642": ":\u7537\u6027\u7ad9\u7740\u4e2d\u6df1\u8272\u80a4\u8272:",
    u"\U0001F9CD\U0001F3FE\U0000200D\U00002642\U0000FE0F": ":\u7537\u58eb\u7ad9\u7acb\u4e2d\u6df1\u8272\u80a4\u8272:",
    u"\U0001F9CD\U0001F3FC\U0000200D\U00002642": ":\u7537\u58eb\u7ad9\u7acb\u4e2d\u6d45\u80a4\u8272:",
    u"\U0001F9CD\U0001F3FC\U0000200D\U00002642\U0000FE0F": ":\u7537\u58eb\u7ad9\u7acb\u4e2d\u6d45\u80a4\u8272:",
    u"\U0001F9CD\U0001F3FD\U0000200D\U00002642": ":\u7537\u58eb\u7ad9\u7740\u4e2d\u7b49\u80a4\u8272:",
    u"\U0001F9CD\U0001F3FD\U0000200D\U00002642\U0000FE0F": ":\u7537\u58eb\u7ad9\u7acb\u4e2d\u7b49\u80a4\u8272:",
    u"\U0001F9CD\U0000200D\U00002642": ":\u7ad9\u7740\u7684\u4eba:",
    u"\U0001F9CD\U0000200D\U00002642\U0000FE0F": ":\u7ad9\u7acb\u5f0f:",
    u"\U0001F468\U0000200D\U0001F393": ":\u7537\u5b66\u751f:",
    u"\U0001F468\U0001F3FF\U0000200D\U0001F393": ":\u7537\u5b66\u751f\u6697\u80a4\u8272:",
    u"\U0001F468\U0001F3FB\U0000200D\U0001F393": ":\u7537\u5b66\u751f\u6d45\u80a4\u8272:",
    u"\U0001F468\U0001F3FE\U0000200D\U0001F393": ":\u7537\u5b66\u751f\u4e2d\u6df1\u8272\u80a4\u8272:",
    u"\U0001F468\U0001F3FC\U0000200D\U0001F393": ":\u7537\u5b66\u751f\u4e2d\u6d45\u80a4\u8272:",
    u"\U0001F468\U0001F3FD\U0000200D\U0001F393": ":\u7537\u5b66\u751f\u4e2d\u7b49\u80a4\u8272:",
    u"\U0001F9B8\U0001F3FF\U0000200D\U00002642": ":\u7537\u6027\u8d85\u7ea7\u82f1\u96c4\u6df1\u8272\u80a4\u8272:",
    u"\U0001F9B8\U0001F3FF\U0000200D\U00002642\U0000FE0F": ":\u7537\u6027\u8d85\u7ea7\u82f1\u96c4\u6df1\u8272\u80a4\u8272:",
    u"\U0001F9B8\U0001F3FB\U0000200D\U00002642": ":\u7537\u4eba\u8d85\u7ea7\u82f1\u96c4\u6d45\u80a4\u8272:",
    u"\U0001F9B8\U0001F3FB\U0000200D\U00002642\U0000FE0F": ":\u7537\u8d85\u4eba\u5149\u80a4\u8272:",
    u"\U0001F9B8\U0001F3FE\U0000200D\U00002642": ":\u7537\u8d85\u4eba\u4e2d\u6df1\u8272\u80a4\u8272:",
    u"\U0001F9B8\U0001F3FE\U0000200D\U00002642\U0000FE0F": ":\u7537\u8d85\u4eba\u4e2d\u6df1\u8272\u80a4\u8272:",
    u"\U0001F9B8\U0001F3FC\U0000200D\U00002642": ":\u7537\u8d85\u4eba\u4e2d\u6d45\u80a4\u8272:",
    u"\U0001F9B8\U0001F3FC\U0000200D\U00002642\U0000FE0F": ":\u7537\u8d85\u4eba\u4e2d\u6d45\u80a4\u8272:",
    u"\U0001F9B8\U0001F3FD\U0000200D\U00002642": ":\u7537\u6027\u8d85\u7ea7\u82f1\u96c4\u4e2d\u7b49\u80a4\u8272:",
    u"\U0001F9B8\U0001F3FD\U0000200D\U00002642\U0000FE0F": ":\u7537\u58eb\u8d85\u7ea7\u82f1\u96c4\u4e2d\u7b49\u80a4\u8272:",
    u"\U0001F9B8\U0000200D\U00002642": ":\u8d85\u7ea7\u82f1\u96c4:",
    u"\U0001F9B8\U0000200D\U00002642\U0000FE0F": ":\u8d85\u7ea7\u82f1\u96c4\u9009\u62e9:",
    u"\U0001F9B9\U0001F3FF\U0000200D\U00002642": ":\u7537\u4eba\u8d85\u7ea7\u6076\u68cd\u6df1\u8272\u80a4\u8272:",
    u"\U0001F9B9\U0001F3FF\U0000200D\U00002642\U0000FE0F": ":\u7537\u4eba\u8d85\u7ea7\u6076\u68cd\u6df1\u8272\u80a4\u8272:",
    u"\U0001F9B9\U0001F3FB\U0000200D\U00002642": ":\u7537\u4eba\u8d85\u7ea7\u6076\u68cd\u6d45\u80a4\u8272:",
    u"\U0001F9B9\U0001F3FB\U0000200D\U00002642\U0000FE0F": ":\u7537\u4eba\u8d85\u7ea7\u6076\u68cd\u6d45\u80a4\u8272:",
    u"\U0001F9B9\U0001F3FE\U0000200D\U00002642": ":\u7537\u4eba\u8d85\u7ea7\u6076\u68cd\u4e2d\u9ed1\u80a4\u8272:",
    u"\U0001F9B9\U0001F3FE\U0000200D\U00002642\U0000FE0F": ":\u7537\u4eba\u8d85\u7ea7\u6076\u68cd\u4e2d\u6df1\u8272\u80a4\u8272\u9009\u62e9:",
    u"\U0001F9B9\U0001F3FC\U0000200D\U00002642": ":\u7537\u4eba\u8d85\u7ea7\u6076\u68cd\u4e2d\u6d45\u80a4\u8272:",
    u"\U0001F9B9\U0001F3FC\U0000200D\U00002642\U0000FE0F": ":\u7537\u4eba\u8d85\u7ea7\u6076\u68cd\u4e2d\u6d45\u80a4\u8272\u9009\u62e9:",
    u"\U0001F9B9\U0001F3FD\U0000200D\U00002642": ":\u7537\u4eba\u8d85\u7ea7\u6076\u68cd\u4e2d\u7b49\u80a4\u8272:",
    u"\U0001F9B9\U0001F3FD\U0000200D\U00002642\U0000FE0F": ":\u7537\u4eba\u8d85\u7ea7\u6076\u68cd\u4e2d\u7b49\u80a4\u8272\u9009\u62e9:",
    u"\U0001F9B9\U0000200D\U00002642": ":\u4eba\u7c7b\u8d85\u7ea7\u6076\u68cd:",
    u"\U0001F9B9\U0000200D\U00002642\U0000FE0F": ":\u8d85\u7ea7\u6076\u68cd\u9009\u62e9:",
    u"\U0001F3C4\U0001F3FF\U0000200D\U00002642": ":\u7537\u5b50\u51b2\u6d6a\u6df1\u8272\u80a4\u8272:",
    u"\U0001F3C4\U0001F3FB\U0000200D\U00002642": ":\u7537\u5b50\u51b2\u6d6a\u6d45\u80a4\u8272:",
    u"\U0001F3C4\U0001F3FE\U0000200D\U00002642": ":\u7537\u58eb\u51b2\u6d6a\u4e2d\u6df1\u8272\u80a4\u8272:",
    u"\U0001F3C4\U0001F3FC\U0000200D\U00002642": ":\u7537\u58eb\u51b2\u6d6a\u4e2d\u6d45\u80a4\u8272:",
    u"\U0001F3C4\U0001F3FD\U0000200D\U00002642": ":\u7537\u58eb\u51b2\u6d6a\u4e2d\u7b49\u80a4\u8272:",
    u"\U0001F3C4\U0000200D\U00002642": ":\u7537\u5b50\u51b2\u6d6a:",
    u"\U0001F3C4\U0001F3FF\U0000200D\U00002642\U0000FE0F": ":\u7537\u5b50\u51b2\u6d6a\u6df1\u8272\u80a4\u8272:",
    u"\U0001F3C4\U0001F3FB\U0000200D\U00002642\U0000FE0F": ":\u7537\u5b50\u51b2\u6d6a\u6d45\u80a4\u8272:",
    u"\U0001F3C4\U0001F3FE\U0000200D\U00002642\U0000FE0F": ":\u7537\u58eb\u51b2\u6d6a\u4e2d\u6df1\u8272\u80a4\u8272:",
    u"\U0001F3C4\U0001F3FC\U0000200D\U00002642\U0000FE0F": ":\u7537\u58eb\u51b2\u6d6a\u4e2d\u6d45\u80a4\u8272:",
    u"\U0001F3C4\U0001F3FD\U0000200D\U00002642\U0000FE0F": ":\u7537\u58eb\u51b2\u6d6a\u4e2d\u7b49\u80a4\u8272:",
    u"\U0001F3C4\U0000200D\U00002642\U0000FE0F": ":\u7537\u5b50\u51b2\u6d6a:",
    u"\U0001F3CA\U0001F3FF\U0000200D\U00002642": ":\u7537\u5b50\u6e38\u6cf3\u6df1\u8272\u80a4\u8272:",
    u"\U0001F3CA\U0001F3FB\U0000200D\U00002642": ":\u7537\u5b50\u6e38\u6cf3\u6d45\u80a4\u8272:",
    u"\U0001F3CA\U0001F3FE\U0000200D\U00002642": ":\u7537\u5b50\u6e38\u6cf3\u4e2d\u6df1\u8272\u80a4\u8272:",
    u"\U0001F3CA\U0001F3FC\U0000200D\U00002642": ":\u7537\u5b50\u6e38\u6cf3\u4e2d\u6d45\u80a4\u8272:",
    u"\U0001F3CA\U0001F3FD\U0000200D\U00002642": ":\u7537\u5b50\u6e38\u6cf3\u4e2d\u7b49\u80a4\u8272:",
    u"\U0001F3CA\U0000200D\U00002642": ":\u7537\u5b50\u6e38\u6cf3:",
    u"\U0001F3CA\U0001F3FF\U0000200D\U00002642\U0000FE0F": ":\u7537\u5b50\u6e38\u6cf3\u6df1\u8272\u80a4\u8272:",
    u"\U0001F3CA\U0001F3FB\U0000200D\U00002642\U0000FE0F": ":\u7537\u5b50\u6e38\u6cf3\u6d45\u80a4\u8272:",
    u"\U0001F3CA\U0001F3FE\U0000200D\U00002642\U0000FE0F": ":\u7537\u5b50\u6e38\u6cf3\u4e2d\u6df1\u8272\u80a4\u8272:",
    u"\U0001F3CA\U0001F3FC\U0000200D\U00002642\U0000FE0F": ":\u7537\u5b50\u6e38\u6cf3\u4e2d\u6d45\u80a4\u8272:",
    u"\U0001F3CA\U0001F3FD\U0000200D\U00002642\U0000FE0F": ":\u7537\u5b50\u6e38\u6cf3\u4e2d\u7b49\u80a4\u8272:",
    u"\U0001F3CA\U0000200D\U00002642\U0000FE0F": ":\u7537\u5b50\u6e38\u6cf3:",
    u"\U0001F468\U0000200D\U0001F3EB": ":\u7537\u6559\u5e08:",
    u"\U0001F468\U0001F3FF\U0000200D\U0001F3EB": ":\u7537\u6559\u5e08\u6697\u80a4\u8272:",
    u"\U0001F468\U0001F3FB\U0000200D\U0001F3EB": ":\u7537\u6559\u5e08\u6d45\u80a4\u8272:",
    u"\U0001F468\U0001F3FE\U0000200D\U0001F3EB": ":\u7537\u6559\u5e08\u4e2d\u6df1\u8272\u80a4\u8272:",
    u"\U0001F468\U0001F3FC\U0000200D\U0001F3EB": ":\u7537\u6559\u5e08\u4e2d\u6d45\u80a4\u8272:",
    u"\U0001F468\U0001F3FD\U0000200D\U0001F3EB": ":\u7537\u6559\u5e08\u4e2d\u7b49\u80a4\u8272:",
    u"\U0001F468\U0000200D\U0001F4BB": ":\u7537\u6280\u5e08:",
    u"\U0001F468\U0001F3FF\U0000200D\U0001F4BB": ":\u7537\u6280\u5e08\u6697\u80a4\u8272:",
    u"\U0001F468\U0001F3FB\U0000200D\U0001F4BB": ":\u7537\u6280\u5e08\u6d45\u80a4\u8272:",
    u"\U0001F468\U0001F3FE\U0000200D\U0001F4BB": ":\u7537\u6280\u5e08\u4e2d\u6df1\u8272\u80a4\u8272:",
    u"\U0001F468\U0001F3FC\U0000200D\U0001F4BB": ":\u7537\u6280\u5e08\u4e2d\u6d45\u80a4\u8272:",
    u"\U0001F468\U0001F3FD\U0000200D\U0001F4BB": ":\u7537\u6280\u5e08\u4e2d\u7b49\u80a4\u8272:",
    u"\U0001F481\U0001F3FF\U0000200D\U00002642": ":\u7537\u58eb\u7ffb\u624b\u6df1\u8272\u80a4\u8272:",
    u"\U0001F481\U0001F3FB\U0000200D\U00002642": ":\u7537\u58eb\u7ffb\u624b\u8f7b\u80a4\u8272:",
    u"\U0001F481\U0001F3FE\U0000200D\U00002642": ":\u7537\u58eb\u7ffb\u624b\u4e2d\u6df1\u8272\u80a4\u8272:",
    u"\U0001F481\U0001F3FC\U0000200D\U00002642": ":\u7537\u58eb\u7ffb\u624b\u4e2d\u6d45\u80a4\u8272:",
    u"\U0001F481\U0001F3FD\U0000200D\U00002642": ":\u7537\u58eb\u7ffb\u624b\u4e2d\u7b49\u80a4\u8272:",
    u"\U0001F481\U0000200D\U00002642": ":\u7537\u4eba\u7ffb\u624b:",
    u"\U0001F481\U0001F3FF\U0000200D\U00002642\U0000FE0F": ":\u7537\u58eb\u7ffb\u624b\u6df1\u8272\u80a4\u8272:",
    u"\U0001F481\U0001F3FB\U0000200D\U00002642\U0000FE0F": ":\u7537\u58eb\u7ffb\u624b\u8f7b\u80a4\u8272:",
    u"\U0001F481\U0001F3FE\U0000200D\U00002642\U0000FE0F": ":\u7537\u58eb\u7ffb\u624b\u4e2d\u6df1\u8272\u80a4\u8272:",
    u"\U0001F481\U0001F3FC\U0000200D\U00002642\U0000FE0F": ":\u7537\u58eb\u7ffb\u624b\u4e2d\u6d45\u80a4\u8272:",
    u"\U0001F481\U0001F3FD\U0000200D\U00002642\U0000FE0F": ":\u7537\u58eb\u7ffb\u624b\u4e2d\u7b49\u80a4\u8272:",
    u"\U0001F481\U0000200D\U00002642\U0000FE0F": ":\u624b\u52a8\u7ffb\u6597:",
    u"\U0001F9DB\U0001F3FF\U0000200D\U00002642": ":\u7537\u4eba\u5438\u8840\u9b3c\u6df1\u8272\u80a4\u8272:",
    u"\U0001F9DB\U0001F3FB\U0000200D\U00002642": ":\u7537\u4eba\u5438\u8840\u9b3c\u6d45\u80a4\u8272:",
    u"\U0001F9DB\U0001F3FE\U0000200D\U00002642": ":\u7537\u4eba\u5438\u8840\u9b3c\u4e2d\u6df1\u8272\u80a4\u8272:",
    u"\U0001F9DB\U0001F3FC\U0000200D\U00002642": ":\u7537\u4eba\u5438\u8840\u9b3c\u4e2d\u6d45\u80a4\u8272:",
    u"\U0001F9DB\U0001F3FD\U0000200D\U00002642": ":\u7537\u4eba\u5438\u8840\u9b3c\u4e2d\u7b49\u80a4\u8272:",
    u"\U0001F9DB\U0000200D\U00002642": ":\u5438\u8840\u9b3c:",
    u"\U0001F9DB\U0001F3FF\U0000200D\U00002642\U0000FE0F": ":\u7537\u4eba\u5438\u8840\u9b3c\u6df1\u8272\u80a4\u8272:",
    u"\U0001F9DB\U0001F3FB\U0000200D\U00002642\U0000FE0F": ":\u7537\u4eba\u5438\u8840\u9b3c\u6d45\u80a4\u8272:",
    u"\U0001F9DB\U0001F3FE\U0000200D\U00002642\U0000FE0F": ":\u7537\u4eba\u5438\u8840\u9b3c\u4e2d\u6df1\u8272\u80a4\u8272:",
    u"\U0001F9DB\U0001F3FC\U0000200D\U00002642\U0000FE0F": ":\u7537\u4eba\u5438\u8840\u9b3c\u4e2d\u6d45\u80a4\u8272:",
    u"\U0001F9DB\U0001F3FD\U0000200D\U00002642\U0000FE0F": ":\u7537\u4eba\u5438\u8840\u9b3c\u4e2d\u7b49\u80a4\u8272:",
    u"\U0001F9DB\U0000200D\U00002642\U0000FE0F": ":\u5438\u8840\u9b3c:",
    u"\U0001F6B6\U0001F3FF\U0000200D\U00002642": ":\u7537\u4eba\u8d70\u8def\u80a4\u8272\u6697:",
    u"\U0001F6B6\U0001F3FB\U0000200D\U00002642": ":\u7537\u4eba\u8d70\u8def\u6d45\u80a4\u8272:",
    u"\U0001F6B6\U0001F3FE\U0000200D\U00002642": ":\u7537\u6027\u884c\u8d70\u4e2d\u6df1\u8272\u80a4\u8272:",
    u"\U0001F6B6\U0001F3FC\U0000200D\U00002642": ":\u4e2d\u7b49\u80a4\u8272\u6b65\u884c\u7537\u58eb:",
    u"\U0001F6B6\U0001F3FD\U0000200D\U00002642": ":\u7537\u4eba\u8d70\u8def\u4e2d\u7b49\u80a4\u8272:",
    u"\U0001F6B6\U0000200D\U00002642": ":\u884c\u8d70\u7684\u4eba:",
    u"\U0001F6B6\U0001F3FF\U0000200D\U00002642\U0000FE0F": ":\u7537\u4eba\u8d70\u8def\u80a4\u8272\u6697:",
    u"\U0001F6B6\U0001F3FB\U0000200D\U00002642\U0000FE0F": ":\u7537\u4eba\u8d70\u8def\u6d45\u80a4\u8272:",
    u"\U0001F6B6\U0001F3FE\U0000200D\U00002642\U0000FE0F": ":\u7537\u6027\u884c\u8d70\u4e2d\u6df1\u8272\u80a4\u8272:",
    u"\U0001F6B6\U0001F3FC\U0000200D\U00002642\U0000FE0F": ":\u7537\u4eba\u8d70\u8def\u4e2d\u6d45\u80a4\u8272:",
    u"\U0001F6B6\U0001F3FD\U0000200D\U00002642\U0000FE0F": ":\u7537\u4eba\u8d70\u8def\u4e2d\u7b49\u80a4\u8272:",
    u"\U0001F6B6\U0000200D\U00002642\U0000FE0F": ":\u4eba\u884c:",
    u"\U0001F473\U0001F3FF\U0000200D\U00002642": ":\u6234\u5934\u5dfe\u7684\u7537\u4eba\u80a4\u8272\u9edd\u9ed1:",
    u"\U0001F473\U0001F3FB\U0000200D\U00002642": ":\u6234\u5934\u5dfe\u7684\u7537\u4eba\u80a4\u8272\u6d45:",
    u"\U0001F473\U0001F3FE\U0000200D\U00002642": ":\u6234\u5934\u5dfe\u7684\u7537\u4eba\u80a4\u8272\u4e2d\u7b49\u504f\u9ed1:",
    u"\U0001F473\U0001F3FC\U0000200D\U00002642": ":\u7537\u4eba\u6234\u5934\u5dfe\u4e2d\u6d45\u80a4\u8272:",
    u"\U0001F473\U0001F3FD\U0000200D\U00002642": ":\u7537\u4eba\u6234\u5934\u5dfe\u4e2d\u7b49\u80a4\u8272:",
    u"\U0001F473\U0000200D\U00002642": ":\u6234\u5934\u5dfe\u7684\u4eba:",
    u"\U0001F473\U0001F3FF\U0000200D\U00002642\U0000FE0F": ":\u6234\u5934\u5dfe\u7684\u7537\u4eba\u80a4\u8272\u9edd\u9ed1:",
    u"\U0001F473\U0001F3FB\U0000200D\U00002642\U0000FE0F": ":\u6234\u5934\u5dfe\u7684\u7537\u4eba\u80a4\u8272\u6d45:",
    u"\U0001F473\U0001F3FE\U0000200D\U00002642\U0000FE0F": ":\u6234\u5934\u5dfe\u7684\u7537\u4eba\u80a4\u8272\u4e2d\u7b49\u504f\u9ed1:",
    u"\U0001F473\U0001F3FC\U0000200D\U00002642\U0000FE0F": ":\u7537\u4eba\u6234\u5934\u5dfe\u4e2d\u6d45\u80a4\u8272:",
    u"\U0001F473\U0001F3FD\U0000200D\U00002642\U0000FE0F": ":\u7537\u4eba\u6234\u5934\u5dfe\u4e2d\u7b49\u80a4\u8272:",
    u"\U0001F473\U0000200D\U00002642\U0000FE0F": ":\u6234\u5934\u5dfe\u7684\u4eba\u9009\u62e9:",
    u"\U0001F472": ":\u6234\u4e2d\u56fd\u5e3d\u7684\u4eba:",
    u"\U0001F472\U0001F3FF": ":\u9ed1\u80a4\u8272\u7684\u4e2d\u56fd\u5e3d\u7537\u4eba:",
    u"\U0001F472\U0001F3FB": ":\u4e2d\u56fd\u5e3d\u7537\u6d45\u80a4\u8272:",
    u"\U0001F472\U0001F3FE": ":\u4e2d\u6df1\u8272\u80a4\u8272\u7684\u4e2d\u56fd\u5e3d\u7537\u58eb:",
    u"\U0001F472\U0001F3FC": ":\u4e2d\u6d45\u80a4\u8272\u7684\u4e2d\u56fd\u5e3d\u7537\u58eb:",
    u"\U0001F472\U0001F3FD": ":\u4e2d\u7b49\u80a4\u8272\u7684\u4e2d\u56fd\u5e3d\u7537\u58eb:",
    u"\U0001F468\U0001F3FF\U0000200D\U0001F9AF": ":\u76ae\u80a4\u9edd\u9ed1\u7684\u7537\u4eba:",
    u"\U0001F468\U0001F3FB\U0000200D\U0001F9AF": ":\u7537\u4eba\u6709\u63a2\u7d22\u8005\u624b\u6756\u8f7b\u80a4\u8272:",
    u"\U0001F468\U0001F3FE\U0000200D\U0001F9AF": ":\u7537\u6027\uff0c\u4e2d\u6df1\u8272\u80a4\u8272:",
    u"\U0001F468\U0001F3FC\U0000200D\U0001F9AF": ":\u4e2d\u6d45\u80a4\u8272\u7537\u6027:",
    u"\U0001F468\U0001F3FD\U0000200D\U0001F9AF": ":\u4e2d\u7b49\u80a4\u8272\u7684\u7537\u4eba:",
    u"\U0001F468\U0000200D\U0001F9AF": ":\u62ff\u7740\u63a2\u6d4b\u6756\u7684\u4eba:",
    u"\U0001F9DF\U0000200D\U00002642": ":\u4eba\u7c7b\u50f5\u5c38:",
    u"\U0001F9DF\U0000200D\U00002642\U0000FE0F": ":\u4eba\u50f5\u5c38:",
    u"\U0001F96D": ":\u8292\u679c:",
    u"\U0001F570": ":\u58c1\u7089\u53f0\u949f:",
    u"\U0001F570\U0000FE0F": ":\u58c1\u7089\u53f0\u65f6\u949f:",
    u"\U0001F9BD": ":\u624b\u52a8\u8f6e\u6905:",
    u"\U0001F45E": ":\u7537\u978b:",
    u"\U0001F5FE": ":\u65e5\u672c\u5730\u56fe:",
    u"\U0001F341": ":\u67ab\u53f6:",
    u"\U0001F94B": ":\u6b66\u88c5:",
    u"\U0001F9C9": ":\u4f19\u4f34:",
    u"\U0001F356": ":\u9aa8\u5934\u4e0a\u7684\u8089:",
    u"\U0001F9BE": ":\u673a\u68b0\u81c2:",
    u"\U0001F9BF": ":\u673a\u68b0\u652f\u817f:",
    u"\U00002695": ":\u533b\u5b66\u7b26\u53f7:",
    u"\U00002695\U0000FE0F": ":\u533b\u5b66\u7b26\u53f7:",
    u"\U0001F3FE": ":\u4e2d\u6df1\u8272\u80a4\u8272:",
    u"\U0001F3FC": ":\u4e2d\u6d45\u80a4\u8272:",
    u"\U0001F3FD": ":\u4e2d\u7b49\u80a4\u8272:",
    u"\U0001F4E3": ":\u6269\u97f3\u5668:",
    u"\U0001F348": ":\u751c\u74dc:",
    u"\U0001F4DD": ":\u5907\u5fd8\u5f55:",
    u"\U0001F468\U0001F3FF\U0000200D\U0001F91D\U0000200D\U0001F468\U0001F3FB": ":\u7537\u4eba\u7275\u7740\u624b\u6df1\u8272\u80a4\u8272\u6d45\u80a4\u8272:",
    u"\U0001F468\U0001F3FF\U0000200D\U0001F91D\U0000200D\U0001F468\U0001F3FE": ":\u7537\u58eb\u63e1\u7740\u624b\u6df1\u8272\u80a4\u8272\u4e2d\u7b49\u6df1\u8272\u80a4\u8272:",
    u"\U0001F468\U0001F3FF\U0000200D\U0001F91D\U0000200D\U0001F468\U0001F3FC": ":\u7537\u58eb\u63e1\u7740\u624b\u6df1\u8272\u80a4\u8272\u4e2d\u6d45\u80a4\u8272:",
    u"\U0001F468\U0001F3FF\U0000200D\U0001F91D\U0000200D\U0001F468\U0001F3FD": ":\u7537\u58eb\u63e1\u7740\u624b\u6df1\u8272\u80a4\u8272\u4e2d\u7b49\u80a4\u8272:",
    u"\U0001F46C\U0001F3FF": ":\u7537\u4eba\u7275\u7740\u624b\u80a4\u8272\u9edd\u9ed1:",
    u"\U0001F46C\U0001F3FB": ":\u7537\u4eba\u624b\u7275\u624b\u80a4\u8272\u6d45:",
    u"\U0001F468\U0001F3FE\U0000200D\U0001F91D\U0000200D\U0001F468\U0001F3FB": ":\u7537\u58eb\u63e1\u7740\u624b\u4e2d\u6df1\u8272\u80a4\u8272\u6d45\u80a4\u8272:",
    u"\U0001F468\U0001F3FE\U0000200D\U0001F91D\U0000200D\U0001F468\U0001F3FC": ":\u7537\u58eb\u7275\u624b\u4e2d\u6df1\u8272\u80a4\u8272\u4e2d\u6d45\u80a4\u8272:",
    u"\U0001F468\U0001F3FE\U0000200D\U0001F91D\U0000200D\U0001F468\U0001F3FD": ":\u7537\u58eb\u63e1\u7740\u624b\u4e2d\u6df1\u8272\u80a4\u8272\u4e2d\u7b49\u80a4\u8272:",
    u"\U0001F46C\U0001F3FE": ":\u7537\u58eb\u624b\u7275\u624b\u80a4\u8272\u4e2d\u7b49\u504f\u6697:",
    u"\U0001F468\U0001F3FC\U0000200D\U0001F91D\U0000200D\U0001F468\U0001F3FB": ":\u7537\u58eb\u624b\u7275\u624b\u4e2d\u6d45\u80a4\u8272\u6d45\u80a4\u8272:",
    u"\U0001F46C\U0001F3FC": ":\u7537\u58eb\u624b\u7275\u624b\u4e2d\u6d45\u80a4\u8272:",
    u"\U0001F468\U0001F3FD\U0000200D\U0001F91D\U0000200D\U0001F468\U0001F3FB": ":\u7537\u58eb\u63e1\u7740\u624b\u4e2d\u7b49\u80a4\u8272\u6d45\u80a4\u8272:",
    u"\U0001F468\U0001F3FD\U0000200D\U0001F91D\U0000200D\U0001F468\U0001F3FC": ":\u7537\u58eb\u63e1\u7740\u624b\u4e2d\u7b49\u80a4\u8272\u4e2d\u7b49\u504f\u6d45\u80a4\u8272:",
    u"\U0001F46C\U0001F3FD": ":\u7537\u58eb\u63e1\u7740\u624b\u4e2d\u7b49\u80a4\u8272:",
    u"\U0001F46F\U0000200D\U00002642": ":\u6709\u5154\u5b50\u8033\u6735\u7684\u7537\u4eba:",
    u"\U0001F46F\U0000200D\U00002642\U0000FE0F": ":\u5e26\u5154\u5b50\u8033\u6735\u7684\u7537\u4eba:",
    u"\U0001F93C\U0000200D\U00002642": ":\u7537\u5b50\u6454\u8de4:",
    u"\U0001F93C\U0000200D\U00002642\U0000FE0F": ":\u7537\u5b50\u6454\u8de4:",
    u"\U0001F54E": ":\u70db\u53f0:",
    u"\U0001F6B9": ":\u7537\u536b\u751f\u95f4:",
    u"\U0001F9DC\U0001F3FF\U0000200D\U00002640": ":\u7f8e\u4eba\u9c7c\u6df1\u8272\u80a4\u8272:",
    u"\U0001F9DC\U0001F3FB\U0000200D\U00002640": ":\u7f8e\u4eba\u9c7c\u6d45\u80a4\u8272:",
    u"\U0001F9DC\U0001F3FE\U0000200D\U00002640": ":\u7f8e\u4eba\u9c7c\u4e2d\u6df1\u8272\u80a4\u8272:",
    u"\U0001F9DC\U0001F3FC\U0000200D\U00002640": ":\u7f8e\u4eba\u9c7c\u4e2d\u6d45\u80a4\u8272:",
    u"\U0001F9DC\U0001F3FD\U0000200D\U00002640": ":\u7f8e\u4eba\u9c7c\u4e2d\u7b49\u80a4\u8272:",
    u"\U0001F9DC\U0000200D\U00002640": ":\u7f8e\u4eba\u9c7c:",
    u"\U0001F9DC\U0001F3FF\U0000200D\U00002640\U0000FE0F": ":\u7f8e\u4eba\u9c7c\u6df1\u8272\u80a4\u8272:",
    u"\U0001F9DC\U0001F3FB\U0000200D\U00002640\U0000FE0F": ":\u7f8e\u4eba\u9c7c\u6d45\u80a4\u8272:",
    u"\U0001F9DC\U0001F3FE\U0000200D\U00002640\U0000FE0F": ":\u7f8e\u4eba\u9c7c\u4e2d\u6df1\u8272\u80a4\u8272:",
    u"\U0001F9DC\U0001F3FC\U0000200D\U00002640\U0000FE0F": ":\u7f8e\u4eba\u9c7c\u4e2d\u6d45\u80a4\u8272:",
    u"\U0001F9DC\U0001F3FD\U0000200D\U00002640\U0000FE0F": ":\u7f8e\u4eba\u9c7c\u4e2d\u7b49\u80a4\u8272:",
    u"\U0001F9DC\U0000200D\U00002640\U0000FE0F": ":\u7f8e\u4eba\u9c7c:",
    u"\U0001F9DC\U0001F3FF\U0000200D\U00002642": ":\u9ed8\u66fc\u6df1\u8272\u80a4\u8272:",
    u"\U0001F9DC\U0001F3FB\U0000200D\U00002642": ":\u4eba\u9c7c\u6d45\u80a4\u8272:",
    u"\U0001F9DC\U0001F3FE\U0000200D\U00002642": ":\u4eba\u9c7c\u4e2d\u6df1\u8272\u80a4\u8272:",
    u"\U0001F9DC\U0001F3FC\U0000200D\U00002642": ":\u4eba\u9c7c\u4e2d\u6d45\u80a4\u8272:",
    u"\U0001F9DC\U0001F3FD\U0000200D\U00002642": ":\u4eba\u9c7c\u4e2d\u7b49\u80a4\u8272:",
    u"\U0001F9DC\U0000200D\U00002642": ":\u4eba\u9c7c:",
    u"\U0001F9DC\U0001F3FF\U0000200D\U00002642\U0000FE0F": ":\u4eba\u9c7c\u6df1\u8272\u80a4\u8272:",
    u"\U0001F9DC\U0001F3FB\U0000200D\U00002642\U0000FE0F": ":\u4eba\u9c7c\u6d45\u80a4\u8272:",
    u"\U0001F9DC\U0001F3FE\U0000200D\U00002642\U0000FE0F": ":\u4eba\u9c7c\u4e2d\u6df1\u8272\u80a4\u8272:",
    u"\U0001F9DC\U0001F3FC\U0000200D\U00002642\U0000FE0F": ":\u4eba\u9c7c\u4e2d\u6d45\u80a4\u8272:",
    u"\U0001F9DC\U0001F3FD\U0000200D\U00002642\U0000FE0F": ":\u4eba\u9c7c\u4e2d\u7b49\u80a4\u8272:",
    u"\U0001F9DC\U0000200D\U00002642\U0000FE0F": ":\u4eba\u9c7c:",
    u"\U0001F9DC": ":\u7f8e\u4eba\u9c7c:",
    u"\U0001F9DC\U0001F3FF": ":\u7f8e\u4eba\u9c7c\u6df1\u8272\u80a4\u8272:",
    u"\U0001F9DC\U0001F3FB": ":\u7f8e\u4eba\u9c7c\u6de1\u80a4\u8272:",
    u"\U0001F9DC\U0001F3FE": ":\u7f8e\u4eba\u9c7c\u4e2d\u6df1\u8272\u80a4\u8272:",
    u"\U0001F9DC\U0001F3FC": ":\u7f8e\u4eba\u9c7c\u4e2d\u6d45\u80a4\u8272:",
    u"\U0001F9DC\U0001F3FD": ":\u7f8e\u4eba\u9c7c\u4e2d\u7b49\u80a4\u8272:",
    u"\U0001F687": ":\u5730\u94c1:",
    u"\U0001F9A0": ":\u5fae\u751f\u7269:",
    u"\U0001F3A4": ":\u9ea6\u514b\u98ce:",
    u"\U0001F52C": ":\u663e\u5fae\u955c:",
    u"\U0001F595": ":\u4e2d\u6307:",
    u"\U0001F595\U0001F3FF": ":\u4e2d\u6307\u6697\u80a4\u8272:",
    u"\U0001F595\U0001F3FB": ":\u4e2d\u6307\u6d45\u80a4\u8272:",
    u"\U0001F595\U0001F3FE": ":\u4e2d\u6307\u4e2d\u6df1\u8272\u80a4\u8272:",
    u"\U0001F595\U0001F3FC": ":\u4e2d\u6307\u4e2d\u6d45\u80a4\u8272:",
    u"\U0001F595\U0001F3FD": ":\u4e2d\u6307\u4e2d\u80a4\u8272:",
    u"\U0001F396": ":\u519b\u4e8b\u5956\u7ae0:",
    u"\U0001F396\U0000FE0F": ":\u519b\u4e8b\u5956\u7ae0:",
    u"\U0001F30C": ":\u94f6\u6cb3\u7cfb:",
    u"\U0001F690": ":\u5c0f\u578b\u5df4\u58eb:",
    u"\U0001F5FF": ":\u83ab\u57c3:",
    u"\U0001F4F1": ":\u79fb\u52a8\u7535\u8bdd:",
    u"\U0001F4F4": ":\u624b\u673a\u5173\u673a:",
    u"\U0001F4F2": ":\u5e26\u7bad\u5934\u7684\u624b\u673a:",
    u"\U0001F911": ":\u94b1\u5634\u8138:",
    u"\U0001F4B0": ":\u94b1\u888b:",
    u"\U0001F4B8": ":\u6709\u7fc5\u8180\u7684\u94b1:",
    u"\U0001F412": ":\u7334\u5b50:",
    u"\U0001F435": ":\u7334\u8138:",
    u"\U0001F69D": ":\u5355\u8f68\u94c1\u8def:",
    u"\U0001F96E": ":\u6708\u997c:",
    u"\U0001F391": ":\u8d4f\u6708\u4eea\u5f0f:",
    u"\U0001F54C": ":\u6e05\u771f\u5bfa:",
    u"\U0001F99F": ":\u868a\u5b50:",
    u"\U0001F6E5": ":\u6469\u6258\u8247:",
    u"\U0001F6E5\U0000FE0F": ":\u673a\u52a8\u8239:",
    u"\U0001F6F5": ":\u6469\u6258\u8f66:",
    u"\U0001F3CD": ":\u6469\u6258\u8f66:",
    u"\U0001F3CD\U0000FE0F": ":\u6469\u6258\u8f66:",
    u"\U0001F9BC": ":\u7535\u52a8\u8f6e\u6905:",
    u"\U0001F6E3": ":\u9ad8\u901f\u516c\u8def:",
    u"\U0001F6E3\U0000FE0F": ":\u9ad8\u901f\u516c\u8def:",
    u"\U0001F5FB": ":\u5bcc\u58eb\u5c71:",
    u"\U000026F0": ":\u5c71:",
    u"\U0001F6A0": ":\u5c71\u533a\u7d22\u9053:",
    u"\U0001F69E": ":\u5c71\u533a\u94c1\u8def:",
    u"\U000026F0\U0000FE0F": ":\u5c71\u5730:",
    u"\U0001F401": ":\u9f20\u6807:",
    u"\U0001F42D": ":\u8001\u9f20\u8138:",
    u"\U0001F444": ":\u53e3:",
    u"\U0001F3A5": ":\u7535\u5f71\u6444\u5f71\u673a:",
    u"\U00002716\U0000FE0F": ":\u7b26\u53f7\u4e58\u6cd5:",
    u"\U0001F344": ":\u8611\u83c7:",
    u"\U0001F3B9": ":\u97f3\u4e50\u952e\u76d8:",
    u"\U0001F3B5": ":\u97f3\u7b26:",
    u"\U0001F3B6": ":\u97f3\u7b26:",
    u"\U0001F3BC": ":\u4e50\u8c31:",
    u"\U0001F507": ":\u626c\u58f0\u5668\u9759\u97f3:",
    u"\U0001F485": ":\u6307\u7532\u6cb9:",
    u"\U0001F485\U0001F3FF": ":\u6307\u7532\u6cb9\u6697\u80a4\u8272:",
    u"\U0001F485\U0001F3FB": ":\u6307\u7532\u6cb9\u6d45\u80a4\u8272:",
    u"\U0001F485\U0001F3FE": ":\u6307\u7532\u6cb9\u4e2d\u6df1\u8272\u80a4\u8272:",
    u"\U0001F485\U0001F3FC": ":\u6307\u7532\u6cb9\u4e2d\u6d45\u80a4\u8272:",
    u"\U0001F485\U0001F3FD": ":\u6307\u7532\u6cb9\u4e2d\u7b49\u80a4\u8272:",
    u"\U0001F4DB": ":\u59d3\u540d\u5fbd\u7ae0:",
    u"\U0001F3DE": ":\u56fd\u5bb6\u516c\u56ed:",
    u"\U0001F3DE\U0000FE0F": ":\u56fd\u5bb6\u516c\u56ed:",
    u"\U0001F922": ":\u6076\u5fc3\u7684\u8138:",
    u"\U0001F9FF": ":\u7eb3\u624e\u5c14\u62a4\u8eab\u7b26:",
    u"\U0001F454": ":\u9886\u5e26:",
    u"\U0001F913": ":\u4e66\u5446\u5b50\u8138:",
    u"\U0001F610": ":\u4e2d\u6027\u9762:",
    u"\U0001F311": ":\u65b0\u6708:",
    u"\U0001F31A": ":\u65b0\u6708\u8138:",
    u"\U0001F4F0": ":\u62a5\u7eb8:",
    u"\U000023ED": ":\u4e0b\u4e00\u66f2\u76ee\u6309\u94ae:",
    u"\U000023ED\U0000FE0F": ":\u4e0b\u4e00\u66f2\u76ee\u6309\u94ae:",
    u"\U0001F303": ":\u661f\u591c:",
    u"\U0001F564": ":\u4e5d\u70b9\u534a:",
    u"\U0001F558": ":\u4e5d\u70b9\u949f:",
    u"\U0001F6B3": ":\u7981\u6b62\u9a91\u81ea\u884c\u8f66:",
    u"\U000026D4": ":\u7981\u6b62\u5165\u5185:",
    u"\U0001F6AF": ":\u7981\u6b62\u4e71\u6254\u5783\u573e:",
    u"\U0001F4F5": ":\u6ca1\u6709\u624b\u673a:",
    u"\U0001F51E": ":\u6ca1\u6709\u5341\u516b\u5c81\u4ee5\u4e0b\u7684\u4eba:",
    u"\U0001F6B7": ":\u7981\u6b62\u884c\u4eba:",
    u"\U0001F6AD": ":\u7981\u6b62\u5438\u70df:",
    u"\U0001F6B1": ":\u975e\u996e\u7528\u6c34:",
    u"\U0001F443": ":\u9f3b\u5b50:",
    u"\U0001F443\U0001F3FF": ":\u9f3b\u5b50\u6697\u80a4\u8272:",
    u"\U0001F443\U0001F3FB": ":\u9f3b\u8f7b\u80a4\u8272:",
    u"\U0001F443\U0001F3FE": ":\u9f3b\u5b50\u4e2d\u6df1\u8272\u80a4\u8272:",
    u"\U0001F443\U0001F3FC": ":\u9f3b\u5b50\u4e2d\u6d45\u80a4\u8272:",
    u"\U0001F443\U0001F3FD": ":\u9f3b\u5b50\u4e2d\u7b49\u80a4\u8272:",
    u"\U0001F4D3": ":\u7b14\u8bb0\u672c:",
    u"\U0001F4D4": ":\u5e26\u88c5\u9970\u5c01\u9762\u7684\u7b14\u8bb0\u672c:",
    u"\U0001F529": ":\u87ba\u6bcd\u548c\u87ba\u6813:",
    u"\U0001F419": ":\u7ae0\u9c7c:",
    u"\U0001F362": ":\u5965\u767b:",
    u"\U0001F3E2": ":\u529e\u516c\u697c:",
    u"\U0001F479": ":\u98df\u4eba\u9b54:",
    u"\U0001F6E2": ":\u6cb9\u6876:",
    u"\U0001F6E2\U0000FE0F": ":\u9009\u6cb9\u6876:",
    u"\U0001F5DD": ":\u65e7\u94a5\u5319:",
    u"\U0001F5DD\U0000FE0F": ":\u65e7\u94a5\u5319:",
    u"\U0001F474": ":\u8001\u4eba\u5bb6:",
    u"\U0001F474\U0001F3FF": ":\u8001\u4eba\u80a4\u8272\u6697\u6c89:",
    u"\U0001F474\U0001F3FB": ":\u8001\u4eba\u80a4\u8272\u6d45:",
    u"\U0001F474\U0001F3FE": ":\u8001\u4eba\u4e2d\u6df1\u8272\u80a4\u8272:",
    u"\U0001F474\U0001F3FC": ":\u8001\u4eba\u4e2d\u6d45\u80a4\u8272:",
    u"\U0001F474\U0001F3FD": ":\u8001\u4eba\u4e2d\u7b49\u80a4\u8272:",
    u"\U0001F475": ":\u8001\u5987\u4eba:",
    u"\U0001F475\U0001F3FF": ":\u8001\u592a\u5a46\u6697\u80a4\u8272:",
    u"\U0001F475\U0001F3FB": ":\u8001\u592a\u592a\u80a4\u8272\u6d45:",
    u"\U0001F475\U0001F3FE": ":\u8001\u592a\u5a46\u4e2d\u9ed1\u80a4\u8272:",
    u"\U0001F475\U0001F3FC": ":\u8001\u592a\u592a\u4e2d\u6d45\u80a4\u8272:",
    u"\U0001F475\U0001F3FD": ":\u8001\u5987\u4eba\u4e2d\u7b49\u80a4\u8272:",
    u"\U0001F9D3": ":\u8001\u5e74\u4eba:",
    u"\U0001F9D3\U0001F3FF": ":\u8001\u5e74\u4eba\u6697\u80a4\u8272:",
    u"\U0001F9D3\U0001F3FB": ":\u8001\u5e74\u4eba\u6d45\u80a4\u8272:",
    u"\U0001F9D3\U0001F3FE": ":\u8001\u5e74\u4eba\u4e2d\u6df1\u8272\u80a4\u8272:",
    u"\U0001F9D3\U0001F3FC": ":\u8001\u5e74\u4eba\u4e2d\u6d45\u80a4\u8272:",
    u"\U0001F9D3\U0001F3FD": ":\u8001\u5e74\u4eba\u4e2d\u7b49\u80a4\u8272:",
    u"\U0001F549": ":\u54e6:",
    u"\U0001F549\U0000FE0F": ":om:",
    u"\U0001F698": ":\u8fce\u9762\u800c\u6765\u7684\u6c7d\u8f66:",
    u"\U0001F68D": ":\u8fce\u9762\u800c\u6765\u7684\u516c\u5171\u6c7d\u8f66:",
    u"\U0001F44A": ":\u8fce\u9762\u800c\u6765\u7684\u62f3\u5934:",
    u"\U0001F44A\U0001F3FF": ":\u8fce\u9762\u800c\u6765\u7684\u62f3\u5934\u6df1\u8272\u80a4\u8272:",
    u"\U0001F44A\U0001F3FB": ":\u8fce\u9762\u800c\u6765\u7684\u62f3\u5934\u8f7b\u80a4\u8272:",
    u"\U0001F44A\U0001F3FE": ":\u8fce\u9762\u62f3\u4e2d\u6df1\u8272\u80a4\u8272:",
    u"\U0001F44A\U0001F3FC": ":\u8fce\u9762\u62f3\u4e2d\u6d45\u80a4\u8272:",
    u"\U0001F44A\U0001F3FD": ":\u8fce\u9762\u62f3\u4e2d\u80a4\u8272:",
    u"\U0001F694": ":\u8fce\u9762\u800c\u6765\u7684\u8b66\u8f66:",
    u"\U0001F696": ":\u8fce\u9762\u800c\u6765\u7684\u51fa\u79df\u8f66:",
    u"\U0001FA71": ":\u8fde\u4f53\u5f0f\u6cf3\u8863:",
    u"\U0001F55C": ":\u4e00\u70b9\u534a:",
    u"\U0001F550": ":\u4e00\u70b9\u949f:",
    u"\U0001F9C5": ":\u6d0b\u8471:",
    u"\U0001F4D6": ":\u4e00\u76ee\u4e86\u7136\u7684\u4e8b:",
    u"\U0001F4C2": ":\u6253\u5f00\u6587\u4ef6\u5939:",
    u"\U0001F450": ":\u5f20\u5f00\u53cc\u624b:",
    u"\U0001F450\U0001F3FF": ":\u5f20\u5f00\u53cc\u624b\u80a4\u8272\u6697\u6c89:",
    u"\U0001F450\U0001F3FB": ":\u5f20\u5f00\u53cc\u624b\uff0c\u80a4\u8272\u8f7b\u76c8:",
    u"\U0001F450\U0001F3FE": ":\u5f20\u5f00\u7684\u53cc\u624b\u4e2d\u6df1\u8272\u80a4\u8272:",
    u"\U0001F450\U0001F3FC": ":\u5f20\u5f00\u53cc\u624b\u4e2d\u6d45\u80a4\u8272:",
    u"\U0001F450\U0001F3FD": ":\u5f20\u5f00\u53cc\u624b\u4e2d\u7b49\u80a4\u8272:",
    u"\U0001F4ED": ":\u6253\u5f00\u5e26\u6709\u964d\u4e0b\u6807\u5fd7\u7684\u90ae\u7bb1:",
    u"\U0001F4EC": ":\u6253\u5f00\u5e26\u6709\u5347\u8d77\u6807\u5fd7\u7684\u90ae\u7bb1:",
    u"\U0001F4BF": ":\u5149\u76d8:",
    u"\U0001F4D9": ":\u6a58\u76ae\u4e66:",
    u"\U0001F7E0": ":\u6a59\u8272\u5706\u5708:",
    u"\U0001F9E1": ":\u6a59\u8272\u5fc3\u810f:",
    u"\U0001F7E7": ":\u6a59\u8272\u65b9\u5757:",
    u"\U0001F9A7": ":\u7ea2\u6bdb\u7329\u7329:",
    u"\U00002626": ":\u6b63\u7edf\u5341\u5b57\u67b6:",
    u"\U00002626\U0000FE0F": ":\u6b63\u7edf\u4ea4\u53c9:",
    u"\U0001F9A6": ":\u6c34\u736d:",
    u"\U0001F4E4": ":\u53d1\u4ef6\u7bb1\u6258\u76d8:",
    u"\U0001F989": ":\u732b\u5934\u9e70:",
    u"\U0001F402": ":\u516c\u725b:",
    u"\U0001F9AA": ":\u7261\u86ce:",
    u"\U0001F4E6": ":\u5305\u88f9:",
    u"\U0001F4C4": ":\u9875\u9762\u671d\u4e0a:",
    u"\U0001F4C3": ":\u5377\u66f2\u7684\u9875\u9762:",
    u"\U0001F4DF": ":\u5bfb\u547c\u673a:",
    u"\U0001F58C": ":\u753b\u7b14:",
    u"\U0001F58C\U0000FE0F": ":\u6f06\u5237:",
    u"\U0001F334": ":\u68d5\u6988\u6811:",
    u"\U0001F932": ":\u53cc\u624b\u5408\u5341:",
    u"\U0001F932\U0001F3FF": ":\u638c\u5fc3\u5408\u4e00\u6697\u80a4\u8272:",
    u"\U0001F932\U0001F3FB": ":\u638c\u5fc3\u5411\u4e0a\u63d0\u4eae\u80a4\u8272:",
    u"\U0001F932\U0001F3FE": ":\u638c\u5fc3\u5411\u4e0a\uff0c\u4e2d\u6df1\u8272\u80a4\u8272:",
    u"\U0001F932\U0001F3FC": ":\u638c\u5fc3\u5411\u4e0a\u4e2d\u6d45\u80a4\u8272:",
    u"\U0001F932\U0001F3FD": ":\u624b\u638c\u5411\u4e0a\uff0c\u4e2d\u7b49\u80a4\u8272:",
    u"\U0001F95E": ":\u70d9\u997c:",
    u"\U0001F43C": ":\u718a\u732b\u8138:",
    u"\U0001F4CE": ":\u56de\u5f62\u9488:",
    u"\U0001FA82": ":\u964d\u843d\u4f1e:",
    u"\U0001F99C": ":\u9e66\u9e49:",
    u"\U0000303D": ":\u96f6\u4ef6\u66f4\u6362\u6807\u8bb0:",
    u"\U0000303D\U0000FE0F": ":\u96f6\u4ef6\u66ff\u6362\u6807\u8bb0:",
    u"\U0001F389": ":\u6d3e\u5bf9\u7206\u6599:",
    u"\U0001F973": ":\u6d3e\u5bf9\u8138:",
    u"\U0001F6F3": ":\u5ba2\u8239:",
    u"\U0001F6F3\U0000FE0F": ":\u5ba2\u8239:",
    u"\U0001F6C2": ":\u62a4\u7167\u68c0\u67e5:",
    u"\U000023F8": ":\u6682\u505c\u6309\u94ae:",
    u"\U000023F8\U0000FE0F": ":\u6682\u505c\u6309\u94ae:",
    u"\U0001F43E": ":\u722a\u5370:",
    u"\U0000262E": ":\u548c\u5e73\u8c61\u5f81:",
    u"\U0000262E\U0000FE0F": ":\u548c\u5e73\u7b26\u53f7:",
    u"\U0001F351": ":\u6843:",
    u"\U0001F99A": ":\u5b54\u96c0:",
    u"\U0001F95C": ":\u82b1\u751f:",
    u"\U0001F350": ":\u68a8:",
    u"\U0001F58A": ":\u7b14:",
    u"\U0001F58A\U0000FE0F": ":\u7b14:",
    u"\U0000270F": ":\u94c5\u7b14:",
    u"\U0000270F\U0000FE0F": ":\u94c5\u7b14:",
    u"\U0001F427": ":\u4f01\u9e45:",
    u"\U0001F614": ":\u5fe7\u90c1\u7684\u8138:",
    u"\U0001F9D1\U0001F3FF\U0000200D\U0001F91D\U0000200D\U0001F9D1\U0001F3FB": ":\u624b\u7275\u624b\u80a4\u8272\u6697\u80a4\u8272\u6de1\u80a4\u8272:",
    u"\U0001F9D1\U0001F3FF\U0000200D\U0001F91D\U0000200D\U0001F9D1\U0001F3FE": ":\u624b\u7275\u624b\u6697\u80a4\u8272\u4e2d\u6df1\u8272\u80a4\u8272:",
    u"\U0001F9D1\U0001F3FF\U0000200D\U0001F91D\U0000200D\U0001F9D1\U0001F3FC": ":\u624b\u7275\u624b\u6697\u80a4\u8272\u4e2d\u6d45\u80a4\u8272:",
    u"\U0001F9D1\U0001F3FF\U0000200D\U0001F91D\U0000200D\U0001F9D1\U0001F3FD": ":\u624b\u7275\u624b\u6697\u80a4\u8272\u4e2d\u7b49\u80a4\u8272:",
    u"\U0001F9D1\U0001F3FF\U0000200D\U0001F91D\U0000200D\U0001F9D1\U0001F3FF": ":\u624b\u7275\u624b\u80a4\u8272\u6697\u6c89:",
    u"\U0001F9D1\U0001F3FB\U0000200D\U0001F91D\U0000200D\U0001F9D1\U0001F3FB": ":\u624b\u7275\u624b\u80a4\u8272\u6d45:",
    u"\U0001F9D1\U0001F3FE\U0000200D\U0001F91D\U0000200D\U0001F9D1\U0001F3FB": ":\u624b\u7275\u624b\u4e2d\u6df1\u8272\u80a4\u8272\u6d45\u80a4\u8272:",
    u"\U0001F9D1\U0001F3FE\U0000200D\U0001F91D\U0000200D\U0001F9D1\U0001F3FC": ":\u624b\u7275\u624b\u4e2d\u6df1\u8272\u80a4\u8272\u4e2d\u6d45\u80a4\u8272:",
    u"\U0001F9D1\U0001F3FE\U0000200D\U0001F91D\U0000200D\U0001F9D1\U0001F3FD": ":\u624b\u7275\u624b\u4e2d\u6df1\u8272\u80a4\u8272\u4e2d\u7b49\u80a4\u8272:",
    u"\U0001F9D1\U0001F3FE\U0000200D\U0001F91D\U0000200D\U0001F9D1\U0001F3FE": ":\u624b\u7275\u624b\u80a4\u8272\u504f\u6697:",
    u"\U0001F9D1\U0001F3FC\U0000200D\U0001F91D\U0000200D\U0001F9D1\U0001F3FB": ":\u624b\u7275\u624b\u4e2d\u6d45\u80a4\u8272\u6d45\u80a4\u8272:",
    u"\U0001F9D1\U0001F3FC\U0000200D\U0001F91D\U0000200D\U0001F9D1\U0001F3FC": ":\u624b\u7275\u624b\u4e2d\u6d45\u80a4\u8272:",
    u"\U0001F9D1\U0001F3FD\U0000200D\U0001F91D\U0000200D\U0001F9D1\U0001F3FB": ":\u624b\u7275\u624b\u4e2d\u80a4\u8272\u6d45\u80a4\u8272:",
    u"\U0001F9D1\U0001F3FD\U0000200D\U0001F91D\U0000200D\U0001F9D1\U0001F3FC": ":\u624b\u7275\u624b\u4e2d\u80a4\u8272\u4e2d\u6d45\u80a4\u8272:",
    u"\U0001F9D1\U0001F3FD\U0000200D\U0001F91D\U0000200D\U0001F9D1\U0001F3FD": ":\u624b\u7275\u624b\u4e2d\u7b49\u80a4\u8272:",
    u"\U0001F9D1\U0000200D\U0001F91D\U0000200D\U0001F9D1": ":\u7275\u624b\u7684\u4eba:",
    u"\U0001F46F": ":\u6709\u5154\u5b50\u8033\u6735\u7684\u4eba:",
    u"\U0001F93C": ":\u4eba\u4eec\u6454\u8de4:",
    u"\U0001F3AD": ":\u8868\u6f14\u827a\u672f:",
    u"\U0001F623": ":\u575a\u6bc5\u7684\u8138:",
    u"\U0001F6B4": ":\u4eba\u9a91\u81ea\u884c\u8f66:",
    u"\U0001F6B4\U0001F3FF": ":\u4eba\u9a91\u81ea\u884c\u8f66\u6df1\u8272\u80a4\u8272:",
    u"\U0001F6B4\U0001F3FB": ":\u4eba\u9a91\u81ea\u884c\u8f66\u6d45\u80a4\u8272:",
    u"\U0001F6B4\U0001F3FE": ":\u4eba\u9a91\u81ea\u884c\u8f66\u4e2d\u6df1\u8272\u80a4\u8272:",
    u"\U0001F6B4\U0001F3FC": ":\u4eba\u9a91\u81ea\u884c\u8f66\u4e2d\u6d45\u80a4\u8272:",
    u"\U0001F6B4\U0001F3FD": ":\u4eba\u9a91\u81ea\u884c\u8f66\u4e2d\u7b49\u80a4\u8272:",
    u"\U000026F9": ":\u5f39\u7403\u7684\u4eba:",
    u"\U000026F9\U0001F3FF": ":\u4eba\u5f39\u7403\u6697\u80a4\u8272:",
    u"\U000026F9\U0001F3FB": ":\u4eba\u5f39\u7403\u8f7b\u80a4\u8272:",
    u"\U000026F9\U0001F3FE": ":\u4eba\u5f39\u7403\u4e2d\u6df1\u8272\u80a4\u8272:",
    u"\U000026F9\U0001F3FC": ":\u4eba\u5f39\u7403\u4e2d\u6d45\u80a4\u8272:",
    u"\U000026F9\U0001F3FD": ":\u4eba\u5f39\u7403\u4e2d\u7b49\u80a4\u8272:",
    u"\U000026F9\U0000FE0F": ":\u4eba\u5f39\u7403:",
    u"\U0001F647": ":\u97a0\u8eac\u7684\u4eba:",
    u"\U0001F647\U0001F3FF": ":\u6df1\u80a4\u8272\u7684\u4eba:",
    u"\U0001F647\U0001F3FB": ":\u6d45\u80a4\u8272\u7684\u4eba:",
    u"\U0001F647\U0001F3FE": ":\u4e2d\u6df1\u8272\u80a4\u8272\u7684\u4eba:",
    u"\U0001F647\U0001F3FC": ":\u4e2d\u6d45\u80a4\u8272\u7684\u4eba:",
    u"\U0001F647\U0001F3FD": ":\u4e2d\u7b49\u80a4\u8272\u7684\u4eba:",
    u"\U0001F938": ":\u4eba\u529b\u63a8\u8f66:",
    u"\U0001F938\U0001F3FF": ":\u76ae\u80a4\u9edd\u9ed1\u7684\u4eba:",
    u"\U0001F938\U0001F3FB": ":\u4eba\u8f66\u8f7b\u80a4\u8272:",
    u"\U0001F938\U0001F3FE": ":\u4e2d\u6df1\u8272\u80a4\u8272\u7684\u4eba:",
    u"\U0001F938\U0001F3FC": ":\u4eba\u8f66\u4e2d\u6d45\u80a4\u8272:",
    u"\U0001F938\U0001F3FD": ":\u4e2d\u7b49\u80a4\u8272\u7684\u4eba:",
    u"\U0001F9D7": ":\u6500\u5ca9\u8005:",
    u"\U0001F9D7\U0001F3FF": ":\u80a4\u8272\u6697\u6c89\u7684\u4eba:",
    u"\U0001F9D7\U0001F3FB": ":\u4eba\u6500\u722c\u6d45\u80a4\u8272:",
    u"\U0001F9D7\U0001F3FE": ":\u4eba\u6500\u722c\u4e2d\u6df1\u8272\u80a4\u8272:",
    u"\U0001F9D7\U0001F3FC": ":\u6500\u5ca9\u8005\u4e2d\u6d45\u80a4\u8272:",
    u"\U0001F9D7\U0001F3FD": ":\u6500\u5ca9\u8005\u4e2d\u7b49\u80a4\u8272:",
    u"\U0001F926": ":\u9762\u671d\u624b\u638c:",
    u"\U0001F926\U0001F3FF": ":\u4eba\u638c\u5fc3\u6697\u80a4\u8272:",
    u"\U0001F926\U0001F3FB": ":\u4eba\u638c\u7eb9\u6d45\u80a4\u8272:",
    u"\U0001F926\U0001F3FE": ":\u4eba\u638c\u7eb9\u4e2d\u6697\u80a4\u8272:",
    u"\U0001F926\U0001F3FC": ":\u4eba\u638c\u7eb9\u4e2d\u6d45\u80a4\u8272:",
    u"\U0001F926\U0001F3FD": ":\u4eba\u638c\u7eb9\u4e2d\u7b49\u80a4\u8272:",
    u"\U0001F93A": ":\u4eba\u5458\u56f4\u680f:",
    u"\U0001F64D": ":\u76b1\u7709\u7684\u4eba:",
    u"\U0001F64D\U0001F3FF": ":\u6101\u7709\u82e6\u8138\u7684\u4eba:",
    u"\U0001F64D\U0001F3FB": ":\u4eba\u7709\u5934\u5fae\u76b1\u80a4\u8272:",
    u"\U0001F64D\U0001F3FE": ":\u76b1\u7709\u5934\u7684\u4eba\u80a4\u8272\u4e2d\u7b49\u504f\u6697:",
    u"\U0001F64D\U0001F3FC": ":\u4eba\u7709\u5934\u5fae\u4eae\u80a4\u8272:",
    u"\U0001F64D\U0001F3FD": ":\u76b1\u7709\u5934\u7684\u4eba\u4e2d\u7b49\u80a4\u8272:",
    u"\U0001F645": ":\u6253\u624b\u52bf\u4e0d\u7684\u4eba:",
    u"\U0001F645\U0001F3FF": ":\u6307\u6ca1\u6709\u6df1\u8272\u80a4\u8272\u7684\u4eba:",
    u"\U0001F645\U0001F3FB": ":\u6307\u6ca1\u6709\u80a4\u8272\u7684\u4eba:",
    u"\U0001F645\U0001F3FE": ":\u6ca1\u6709\u4e2d\u7b49\u80a4\u8272\u7684\u4eba:",
    u"\U0001F645\U0001F3FC": ":\u6ca1\u6709\u4e2d\u7b49\u80a4\u8272\u7684\u4eba:",
    u"\U0001F645\U0001F3FD": ":\u6ca1\u6709\u4e2d\u7b49\u80a4\u8272\u7684\u4eba:",
    u"\U0001F646": ":\u6253\u624b\u52bf\u7684\u4eba\u53ef\u4ee5\u5417:",
    u"\U0001F646\U0001F3FF": ":\u6253\u624b\u52bf\u7684\u4eba\u80a4\u8272\u5f88\u9ed1:",
    u"\U0001F646\U0001F3FB": ":\u6253\u624b\u52bf\u53ef\u4ee5\u6de1\u80a4\u8272\u7684\u4eba:",
    u"\U0001F646\U0001F3FE": ":\u6253\u624b\u52bf\u7684\u4eba\u53ef\u4ee5\u4e2d\u6df1\u8272\u80a4\u8272:",
    u"\U0001F646\U0001F3FC": ":\u6253\u624b\u52bf\u7684\u4eba\u53ef\u4ee5\u4e2d\u6d45\u80a4\u8272:",
    u"\U0001F646\U0001F3FD": ":\u6253\u624b\u52bf\u7684\u4eba\u53ef\u4ee5\u4e2d\u7b49\u80a4\u8272:",
    u"\U0001F487": ":\u7406\u53d1\u7684\u4eba:",
    u"\U0001F487\U0001F3FF": ":\u7406\u53d1\u8005\u80a4\u8272\u6697:",
    u"\U0001F487\U0001F3FB": ":\u7406\u53d1\u8005\u80a4\u8272\u6d45:",
    u"\U0001F487\U0001F3FE": ":\u526a\u5934\u53d1\u7684\u4eba\u80a4\u8272\u4e2d\u7b49\u504f\u6697:",
    u"\U0001F487\U0001F3FC": ":\u7406\u53d1\u8005\u4e2d\u6d45\u80a4\u8272:",
    u"\U0001F487\U0001F3FD": ":\u7406\u53d1\u5e08\u4e2d\u7b49\u80a4\u8272:",
    u"\U0001F486": ":\u6309\u6469\u5e08:",
    u"\U0001F486\U0001F3FF": ":\u6309\u6469\u8005\u80a4\u8272\u6697\u6c89:",
    u"\U0001F486\U0001F3FB": ":\u6309\u6469\u8005\u80a4\u8272\u6d45:",
    u"\U0001F486\U0001F3FE": ":\u6309\u6469\u8005\u4e2d\u6df1\u8272\u80a4\u8272:",
    u"\U0001F486\U0001F3FC": ":\u6309\u6469\u8005\u4e2d\u6d45\u80a4\u8272:",
    u"\U0001F486\U0001F3FD": ":\u6309\u6469\u8005\u4e2d\u7b49\u80a4\u8272:",
    u"\U0001F3CC": ":\u4e2a\u4eba\u9ad8\u5c14\u592b:",
    u"\U0001F3CC\U0001F3FF": ":\u6253\u9ad8\u5c14\u592b\u7684\u4eba\u76ae\u80a4\u9edd\u9ed1:",
    u"\U0001F3CC\U0001F3FB": ":\u4eba\u9ad8\u5c14\u592b\u6d45\u80a4\u8272:",
    u"\U0001F3CC\U0001F3FE": ":\u4eba\u9ad8\u5c14\u592b\u4e2d\u6df1\u8272\u80a4\u8272:",
    u"\U0001F3CC\U0001F3FC": ":\u4eba\u9ad8\u5c14\u592b\u4e2d\u6d45\u80a4\u8272:",
    u"\U0001F3CC\U0001F3FD": ":\u4eba\u9ad8\u5c14\u592b\u4e2d\u7b49\u80a4\u8272:",
    u"\U0001F3CC\U0000FE0F": ":\u4e2a\u4eba\u9ad8\u5c14\u592b:",
    u"\U0001F6CC": ":\u5367\u5e8a\u7684\u4eba:",
    u"\U0001F6CC\U0001F3FF": ":\u5367\u5e8a\u8005\u80a4\u8272\u6697\u6c89:",
    u"\U0001F6CC\U0001F3FB": ":\u5e8a\u4e0a\u4eba\u80a4\u8272\u6d45:",
    u"\U0001F6CC\U0001F3FE": ":\u5367\u5e8a\u8005\u80a4\u8272\u504f\u6697:",
    u"\U0001F6CC\U0001F3FC": ":\u5367\u5e8a\u8005\u4e2d\u6d45\u80a4\u8272:",
    u"\U0001F6CC\U0001F3FD": ":\u5367\u5e8a\u8005\u4e2d\u7b49\u80a4\u8272:",
    u"\U0001F9D8": ":\u83b2\u82b1\u4f4d\u4eba:",
    u"\U0001F9D8\U0001F3FF": ":\u8377\u82b1\u4f4d\u4eba\u80a4\u8272\u6697\u6c89:",
    u"\U0001F9D8\U0001F3FB": ":\u8377\u82b1\u4f4d\u4eba\u80a4\u8272\u6d45:",
    u"\U0001F9D8\U0001F3FE": ":\u8377\u82b1\u4f4d\u4e2d\u6df1\u8272\u80a4\u8272:",
    u"\U0001F9D8\U0001F3FC": ":\u8377\u82b1\u4f4d\u4e2d\u6d45\u80a4\u8272:",
    u"\U0001F9D8\U0001F3FD": ":\u8377\u82b1\u4f4d\u4e2d\u80a4\u8272\u8005:",
    u"\U0001F9D6": ":\u84b8\u6c7d\u623f\u91cc\u7684\u4eba:",
    u"\U0001F9D6\U0001F3FF": ":\u84b8\u6c7d\u623f\u91cc\u7684\u4eba\u76ae\u80a4\u9edd\u9ed1:",
    u"\U0001F9D6\U0001F3FB": ":\u84b8\u6c7d\u623f\u91cc\u7684\u4eba\u80a4\u8272\u6d45:",
    u"\U0001F9D6\U0001F3FE": ":\u84b8\u6c7d\u623f\u91cc\u7684\u4eba\u80a4\u8272\u4e2d\u7b49\u504f\u6697:",
    u"\U0001F9D6\U0001F3FC": ":\u84b8\u6c7d\u623f\u91cc\u7684\u4eba\u4e2d\u6d45\u80a4\u8272:",
    u"\U0001F9D6\U0001F3FD": ":\u84b8\u6c7d\u623f\u91cc\u7684\u4eba\u4e2d\u7b49\u80a4\u8272:",
    u"\U0001F939": ":\u6742\u800d\u7684\u4eba:",
    u"\U0001F939\U0001F3FF": ":\u53d8\u9ed1\u80a4\u8272\u7684\u4eba:",
    u"\U0001F939\U0001F3FB": ":\u8f7b\u8584\u80a4\u8272\u7684\u4eba:",
    u"\U0001F939\U0001F3FE": ":\u4e2d\u6df1\u8272\u80a4\u8272\u7684\u4eba:",
    u"\U0001F939\U0001F3FC": ":\u4e2d\u6d45\u80a4\u8272\u7684\u4eba:",
    u"\U0001F939\U0001F3FD": ":\u4e2d\u7b49\u80a4\u8272\u7684\u4eba:",
    u"\U0001F9CE\U0001F3FF": ":\u8dea\u7740\u7684\u4eba\u80a4\u8272\u9edd\u9ed1:",
    u"\U0001F9CE\U0001F3FB": ":\u4eba\u8dea\u5730\u80a4\u8272\u6d45:",
    u"\U0001F9CE\U0001F3FE": ":\u8dea\u7740\u7684\u4eba\u80a4\u8272\u4e2d\u7b49\u504f\u6697:",
    u"\U0001F9CE\U0001F3FC": ":\u4e2d\u6d45\u80a4\u8272:",
    u"\U0001F9CE\U0001F3FD": ":\u4e2d\u80a4\u8272\u8dea\u7740\u7684\u4eba:",
    u"\U0001F9CE": ":\u8dea\u7740\u7684\u4eba:",
    u"\U0001F3CB": ":\u4e3e\u91cd\u4eba\u5458:",
    u"\U0001F3CB\U0001F3FF": ":\u4e3e\u91cd\u8005\u80a4\u8272\u6697\u6c89:",
    u"\U0001F3CB\U0001F3FB": ":\u4e3e\u91cd\u8f7b\u80a4\u8272:",
    u"\U0001F3CB\U0001F3FE": ":\u4e3e\u91cd\u8005\u80a4\u8272\u504f\u6697:",
    u"\U0001F3CB\U0001F3FC": ":\u4e3e\u91cd\u8005\u80a4\u8272\u4e2d\u7b49\u504f\u6d45:",
    u"\U0001F3CB\U0001F3FD": ":\u4e3e\u91cd\u4e2d\u7b49\u80a4\u8272:",
    u"\U0001F3CB\U0000FE0F": ":\u4eba\u5458\u4e3e\u91cd:",
    u"\U0001F6B5": ":\u5c71\u5730\u81ea\u884c\u8f66\u8d5b:",
    u"\U0001F6B5\U0001F3FF": ":\u4eba\u5c71\u81ea\u884c\u8f66\u6df1\u8272\u80a4\u8272:",
    u"\U0001F6B5\U0001F3FB": ":\u4eba\u5c71\u5730\u81ea\u884c\u8f66\u6d45\u80a4\u8272:",
    u"\U0001F6B5\U0001F3FE": ":\u4eba\u5c71\u5730\u81ea\u884c\u8f66\u4e2d\u6df1\u8272\u80a4\u8272:",
    u"\U0001F6B5\U0001F3FC": ":\u4eba\u5c71\u5730\u81ea\u884c\u8f66\u4e2d\u6d45\u80a4\u8272:",
    u"\U0001F6B5\U0001F3FD": ":\u4eba\u5c71\u5730\u81ea\u884c\u8f66\u4e2d\u7b49\u80a4\u8272:",
    u"\U0001F93E": ":\u6253\u624b\u7403\u7684\u4eba:",
    u"\U0001F93E\U0001F3FF": ":\u6253\u624b\u7403\u7684\u4eba\u80a4\u8272\u6697\u6c89:",
    u"\U0001F93E\U0001F3FB": ":\u6253\u624b\u7403\u7684\u4eba\u80a4\u8272\u6d45:",
    u"\U0001F93E\U0001F3FE": ":\u6253\u624b\u7403\u7684\u4eba\u80a4\u8272\u504f\u6697:",
    u"\U0001F93E\U0001F3FC": ":\u6253\u624b\u7403\u7684\u4eba\u4e2d\u6d45\u80a4\u8272:",
    u"\U0001F93E\U0001F3FD": ":\u6253\u624b\u7403\u7684\u4eba\u80a4\u8272\u4e2d\u7b49:",
    u"\U0001F93D": ":\u6253\u6c34\u7403\u7684\u4eba:",
    u"\U0001F93D\U0001F3FF": ":\u6253\u6c34\u7403\u7684\u4eba\u80a4\u8272\u6697\u6c89:",
    u"\U0001F93D\U0001F3FB": ":\u6253\u6c34\u7403\u7684\u4eba\u80a4\u8272\u6d45:",
    u"\U0001F93D\U0001F3FE": ":\u6253\u6c34\u7403\u7684\u4eba\u80a4\u8272\u504f\u6697:",
    u"\U0001F93D\U0001F3FC": ":\u6253\u6c34\u7403\u7684\u4eba\u4e2d\u6d45\u80a4\u8272:",
    u"\U0001F93D\U0001F3FD": ":\u6253\u6c34\u7403\u7684\u4eba\u80a4\u8272\u4e2d\u7b49:",
    u"\U0001F64E": ":\u6485\u5634\u7684\u4eba:",
    u"\U0001F64E\U0001F3FF": ":\u8138\u8272\u9edd\u9ed1\u7684\u4eba:",
    u"\U0001F64E\U0001F3FB": ":\u8138\u8272\u6d45\u7684\u4eba:",
    u"\U0001F64E\U0001F3FE": ":\u8138\u8272\u4e2d\u7b49\u504f\u6697\u7684\u4eba:",
    u"\U0001F64E\U0001F3FC": ":\u4e2d\u6d45\u80a4\u8272\u7684\u4eba:",
    u"\U0001F64E\U0001F3FD": ":\u4e2d\u7b49\u80a4\u8272\u7684\u4eba:",
    u"\U0001F64B": ":\u4e3e\u8d77\u624b\u7684\u4eba:",
    u"\U0001F64B\U0001F3FF": ":\u63d0\u4eba\u80a4\u8272\u6697\u6c89:",
    u"\U0001F64B\U0001F3FB": ":\u4eba\u62ac\u624b\u8f7b\u80a4\u8272:",
    u"\U0001F64B\U0001F3FE": ":\u62ac\u624b\u4e2d\u6df1\u8272\u80a4\u8272:",
    u"\U0001F64B\U0001F3FC": ":\u62ac\u624b\u4e2d\u6d45\u80a4\u8272:",
    u"\U0001F64B\U0001F3FD": ":\u4eba\u62ac\u624b\u4e2d\u80a4\u8272:",
    u"\U0001F6A3": ":\u5212\u8239\u4eba:",
    u"\U0001F6A3\U0001F3FF": ":\u5212\u8239\u4eba\u80a4\u8272\u6697\u6c89:",
    u"\U0001F6A3\U0001F3FB": ":\u4eba\u5212\u8239\u6d45\u80a4\u8272:",
    u"\U0001F6A3\U0001F3FE": ":\u4eba\u5212\u8239\u4e2d\u6df1\u8272\u80a4\u8272:",
    u"\U0001F6A3\U0001F3FC": ":\u4eba\u5212\u8239\u4e2d\u6d45\u80a4\u8272:",
    u"\U0001F6A3\U0001F3FD": ":\u4eba\u5212\u8239\u4e2d\u7b49\u80a4\u8272:",
    u"\U0001F3C3": ":\u8dd1\u6b65\u7684\u4eba:",
    u"\U0001F3C3\U0001F3FF": ":\u80a4\u8272\u6697\u6c89\u7684\u4eba:",
    u"\U0001F3C3\U0001F3FB": ":\u4eba\u8dd1\u6de1\u80a4\u8272:",
    u"\U0001F3C3\U0001F3FE": ":\u4e2d\u7b49\u80a4\u8272\u7684\u4eba:",
    u"\U0001F3C3\U0001F3FC": ":\u4e2d\u6d45\u80a4\u8272\u8005:",
    u"\U0001F3C3\U0001F3FD": ":\u4e2d\u7b49\u80a4\u8272\u7684\u4eba:",
    u"\U0001F937": ":\u8038\u8038\u80a9\u7684\u4eba:",
    u"\U0001F937\U0001F3FF": ":\u4eba\u8038\u8038\u80a9\uff0c\u80a4\u8272\u6697\u6c89:",
    u"\U0001F937\U0001F3FB": ":\u4eba\u8038\u8038\u80a9\uff0c\u80a4\u8272\u6d45:",
    u"\U0001F937\U0001F3FE": ":\u8038\u8038\u80a9\u7684\u4eba\u80a4\u8272\u4e2d\u7b49\u504f\u6697:",
    u"\U0001F937\U0001F3FC": ":\u8038\u8038\u80a9\u7684\u4eba\u4e2d\u6d45\u80a4\u8272:",
    u"\U0001F937\U0001F3FD": ":\u4e2d\u5ea6\u8038\u80a9\u80a4\u8272:",
    u"\U0001F9CD\U0001F3FF": ":\u7ad9\u7740\u7684\u4eba\u80a4\u8272\u6697\u6c89:",
    u"\U0001F9CD\U0001F3FB": ":\u4eba\u7ad9\u8f7b\u80a4\u8272:",
    u"\U0001F9CD\U0001F3FE": ":\u7ad9\u7740\u7684\u4eba\u80a4\u8272\u4e2d\u7b49\u504f\u6697:",
    u"\U0001F9CD\U0001F3FC": ":\u4e2d\u6d45\u80a4\u8272:",
    u"\U0001F9CD\U0001F3FD": ":\u4eba\u7ad9\u7740\u4e2d\u7b49\u80a4\u8272:",
    u"\U0001F9CD": ":\u7ad9\u7740\u7684\u4eba:",
    u"\U0001F3C4": ":\u4e2a\u4eba\u51b2\u6d6a:",
    u"\U0001F3C4\U0001F3FF": ":\u6df1\u8272\u80a4\u8272\u51b2\u6d6a\u8005:",
    u"\U0001F3C4\U0001F3FB": ":\u6d45\u80a4\u8272\u51b2\u6d6a\u8005:",
    u"\U0001F3C4\U0001F3FE": ":\u4e2d\u9ed1\u80a4\u8272\u51b2\u6d6a\u8005:",
    u"\U0001F3C4\U0001F3FC": ":\u4e2d\u6d45\u80a4\u8272\u51b2\u6d6a\u8005:",
    u"\U0001F3C4\U0001F3FD": ":\u4e2d\u80a4\u8272\u51b2\u6d6a\u8005:",
    u"\U0001F3CA": ":\u6e38\u6cf3\u7684\u4eba:",
    u"\U0001F3CA\U0001F3FF": ":\u4eba\u6e38\u6cf3\u6df1\u8272\u80a4\u8272:",
    u"\U0001F3CA\U0001F3FB": ":\u4eba\u6e38\u6cf3\u6d45\u80a4\u8272:",
    u"\U0001F3CA\U0001F3FE": ":\u4eba\u6e38\u6cf3\u4e2d\u6df1\u8272\u80a4\u8272:",
    u"\U0001F3CA\U0001F3FC": ":\u6e38\u6cf3\u4eba\u4e2d\u6d45\u80a4\u8272:",
    u"\U0001F3CA\U0001F3FD": ":\u4eba\u6e38\u6cf3\u4e2d\u7b49\u80a4\u8272:",
    u"\U0001F6C0": ":\u6d17\u6fa1\u7684\u4eba:",
    u"\U0001F6C0\U0001F3FF": ":\u6d17\u6fa1\u4eba\u80a4\u8272\u6697\u6c89:",
    u"\U0001F6C0\U0001F3FB": ":\u6c90\u6d74\u8005\u80a4\u8272\u6d45:",
    u"\U0001F6C0\U0001F3FE": ":\u6d17\u6fa1\u7684\u4eba\u80a4\u8272\u4e2d\u7b49\u504f\u6697:",
    u"\U0001F6C0\U0001F3FC": ":\u6c90\u6d74\u8005\u4e2d\u6d45\u80a4\u8272:",
    u"\U0001F6C0\U0001F3FD": ":\u6c90\u6d74\u8005\u4e2d\u7b49\u80a4\u8272:",
    u"\U0001F481": ":\u503e\u7ffb\u624b:",
    u"\U0001F481\U0001F3FF": ":\u4eba\u7ffb\u624b\u6697\u80a4\u8272:",
    u"\U0001F481\U0001F3FB": ":\u4eba\u503e\u624b\u8f7b\u80a4\u8272:",
    u"\U0001F481\U0001F3FE": ":\u4eba\u503e\u624b\u4e2d\u6df1\u8272\u80a4\u8272:",
    u"\U0001F481\U0001F3FC": ":\u4e2d\u6d45\u80a4\u8272:",
    u"\U0001F481\U0001F3FD": ":\u4e2d\u80a4\u8272:",
    u"\U0001F6B6": ":\u884c\u8d70\u7684\u4eba:",
    u"\U0001F6B6\U0001F3FF": ":\u4eba\u8d70\u6697\u80a4\u8272:",
    u"\U0001F6B6\U0001F3FB": ":\u4eba\u884c\u8f7b\u80a4\u8272:",
    u"\U0001F6B6\U0001F3FE": ":\u4eba\u8d70\u504f\u9ed1\u80a4\u8272:",
    u"\U0001F6B6\U0001F3FC": ":\u4eba\u884c\u4e2d\u6d45\u80a4\u8272:",
    u"\U0001F6B6\U0001F3FD": ":\u4eba\u8d70\u4e2d\u7b49\u80a4\u8272:",
    u"\U0001F473": ":\u6234\u5934\u5dfe\u7684\u4eba:",
    u"\U0001F473\U0001F3FF": ":\u6234\u5934\u5dfe\u7684\u4eba\u80a4\u8272\u6697:",
    u"\U0001F473\U0001F3FB": ":\u6234\u5934\u5dfe\u7684\u4eba\u80a4\u8272\u6d45:",
    u"\U0001F473\U0001F3FE": ":\u6234\u5934\u5dfe\u7684\u4eba\u80a4\u8272\u4e2d\u7b49\u504f\u6697:",
    u"\U0001F473\U0001F3FC": ":\u6234\u5934\u5dfe\u7684\u4eba\u80a4\u8272\u4e2d\u7b49\u504f\u6d45:",
    u"\U0001F473\U0001F3FD": ":\u6234\u5934\u5dfe\u4e2d\u7b49\u80a4\u8272\u7684\u4eba:",
    u"\U0001F9EB": ":\u57f9\u517b\u76bf:",
    u"\U000026CF": ":\u6311\u9009:",
    u"\U000026CF\U0000FE0F": ":\u9009\u62e9:",
    u"\U0001F967": ":\u9985\u997c:",
    u"\U0001F416": ":\u732a:",
    u"\U0001F437": ":\u732a\u8138:",
    u"\U0001F43D": ":\u732a\u9f3b\u5b50:",
    u"\U0001F4A9": ":\u4e00\u5806\u5c4e:",
    u"\U0001F48A": ":\u836f\u4e38:",
    u"\U0001F90F\U0001F3FF": ":\u634f\u624b\u6697\u80a4\u8272:",
    u"\U0001F90F\U0001F3FB": ":\u634f\u624b\u8f7b\u80a4\u8272:",
    u"\U0001F90F\U0001F3FE": ":\u634f\u624b\u4e2d\u6df1\u8272\u80a4\u8272:",
    u"\U0001F90F\U0001F3FC": ":\u634f\u624b\u4e2d\u6d45\u80a4\u8272:",
    u"\U0001F90F\U0001F3FD": ":\u4e2d\u5ea6\u634f\u624b\u80a4\u8272:",
    u"\U0001F90F": ":\u634f\u624b:",
    u"\U0001F38D": ":\u677e\u6728\u88c5\u9970:",
    u"\U0001F34D": ":\u83e0\u841d:",
    u"\U0001F3D3": ":\u4e52\u4e53\u7403:",
    u"\U0001F3F4\U0000200D\U00002620": ":\u6d77\u76d7\u65d7:",
    u"\U0001F3F4\U0000200D\U00002620\U0000FE0F": ":\u6d77\u76d7\u65d7:",
    u"\U0001F52B": ":\u624b\u67aa:",
    u"\U0001F355": ":\u62ab\u8428:",
    u"\U0001F6D0": ":\u793c\u62dc\u573a\u6240:",
    u"\U000025B6": ":\u64ad\u653e\u6309\u94ae:",
    u"\U000025B6\U0000FE0F": ":\u64ad\u653e\u6309\u94ae:",
    u"\U000023EF": ":\u64ad\u653e\u6216\u6682\u505c\u6309\u94ae:",
    u"\U000023EF\U0000FE0F": ":\u64ad\u653e\u6216\u6682\u505c\u6309\u94ae:",
    u"\U0001F97A": ":\u8fa9\u62a4\u72b6:",
    u"\U0001F693": ":\u8b66\u8f66:",
    u"\U0001F6A8": ":\u8b66\u8f66\u706f:",
    u"\U0001F46E": ":\u8b66\u5b98:",
    u"\U0001F46E\U0001F3FF": ":\u8b66\u5458\u80a4\u8272\u6697\u6c89:",
    u"\U0001F46E\U0001F3FB": ":\u8b66\u5b98\u80a4\u8272\u6d45:",
    u"\U0001F46E\U0001F3FE": ":\u8b66\u5b98\u4e2d\u6df1\u8272\u80a4\u8272:",
    u"\U0001F46E\U0001F3FC": ":\u8b66\u5b98\u4e2d\u6d45\u80a4\u8272:",
    u"\U0001F46E\U0001F3FD": ":\u8b66\u5b98\u4e2d\u7b49\u80a4\u8272:",
    u"\U0001F429": ":\u8d35\u5bbe\u72ac:",
    u"\U0001F3B1": ":\u9ed18\u7403:",
    u"\U0001F37F": ":\u7206\u7c73\u82b1:",
    u"\U0001F3E4": ":\u90ae\u5c40:",
    u"\U0001F4EF": ":\u90ae\u653f\u5587\u53ed:",
    u"\U0001F4EE": ":\u4fe1\u7bb1:",
    u"\U0001F372": ":\u4e00\u9505\u98df\u7269:",
    u"\U0001F6B0": ":\u996e\u7528\u6c34:",
    u"\U0001F954": ":\u9a6c\u94c3\u85af:",
    u"\U0001F357": ":\u5bb6\u79bd\u817f:",
    u"\U0001F4B7": ":\u82f1\u9551\u949e\u7968:",
    u"\U0001F63E": ":\u6485\u5634\u732b\u8138:",
    u"\U0001F621": ":\u6485\u5634:",
    u"\U0001F4FF": ":\u5ff5\u73e0:",
    u"\U0001F930": ":\u5b55\u5987:",
    u"\U0001F930\U0001F3FF": ":\u5b55\u5987\u80a4\u8272\u6697\u6c89:",
    u"\U0001F930\U0001F3FB": ":\u5b55\u5987\u6d45\u80a4\u8272:",
    u"\U0001F930\U0001F3FE": ":\u5b55\u5987\u4e2d\u6df1\u8272\u80a4\u8272:",
    u"\U0001F930\U0001F3FC": ":\u5b55\u5987\u4e2d\u6d45\u80a4\u8272:",
    u"\U0001F930\U0001F3FD": ":\u5b55\u5987\u4e2d\u7b49\u80a4\u8272:",
    u"\U0001F968": ":\u6912\u76d0\u8106\u997c:",
    u"\U0001F934": ":\u738b\u5b50:",
    u"\U0001F934\U0001F3FF": ":\u738b\u5b50\u9ed1\u80a4\u8272:",
    u"\U0001F934\U0001F3FB": ":\u738b\u5b50\u6d45\u80a4\u8272:",
    u"\U0001F934\U0001F3FE": ":\u738b\u5b50\u4e2d\u6df1\u8272\u80a4\u8272:",
    u"\U0001F934\U0001F3FC": ":\u738b\u5b50\u4e2d\u6d45\u80a4\u8272:",
    u"\U0001F934\U0001F3FD": ":\u738b\u5b50\u4e2d\u7b49\u80a4\u8272:",
    u"\U0001F478": ":\u516c\u4e3b:",
    u"\U0001F478\U0001F3FF": ":\u516c\u4e3b\u6df1\u80a4\u8272:",
    u"\U0001F478\U0001F3FB": ":\u516c\u4e3b\u6de1\u80a4\u8272:",
    u"\U0001F478\U0001F3FE": ":\u516c\u4e3b\u4e2d\u6df1\u8272\u80a4\u8272:",
    u"\U0001F478\U0001F3FC": ":\u516c\u4e3b\u4e2d\u6d45\u80a4\u8272:",
    u"\U0001F478\U0001F3FD": ":\u516c\u4e3b\u4e2d\u7b49\u80a4\u8272:",
    u"\U0001F5A8": ":\u6253\u5370\u673a:",
    u"\U0001F5A8\U0000FE0F": ":\u6253\u5370\u673a:",
    u"\U0001F9AF": ":\u63a2\u6746:",
    u"\U0001F6AB": ":\u7981\u6b62:",
    u"\U0001F7E3": ":\u7d2b\u8272\u5706\u5708:",
    u"\U0001F49C": ":\u7d2b\u5fc3:",
    u"\U0001F7EA": ":\u7d2b\u8272\u65b9\u5757:",
    u"\U0001F45B": ":\u94b1\u5305:",
    u"\U0001F4CC": ":\u56fe\u9489:",
    u"\U00002753": ":\u95ee\u53f7:",
    u"\U0001F407": ":\u5154\u5b50:",
    u"\U0001F430": ":\u5154\u5b50\u8138:",
    u"\U0001F99D": ":\u6d63\u718a:",
    u"\U0001F3CE": ":\u8d5b\u8f66:",
    u"\U0001F3CE\U0000FE0F": ":\u8d5b\u8f66:",
    u"\U0001F4FB": ":\u6536\u97f3\u673a:",
    u"\U0001F518": ":\u5355\u9009\u6309\u94ae:",
    u"\U00002622": ":\u653e\u5c04\u6027\u7684:",
    u"\U00002622\U0000FE0F": ":\u653e\u5c04\u6027:",
    u"\U0001F683": ":\u6709\u8f68\u7535\u8f66:",
    u"\U0001F6E4": ":\u94c1\u8def\u8f68\u9053:",
    u"\U0001F6E4\U0000FE0F": ":\u8f68\u9053:",
    u"\U0001F308": ":\u5f69\u8679:",
    u"\U0001F3F3\U0000200D\U0001F308": ":\u5f69\u8679\u65d7:",
    u"\U0001F3F3\U0000FE0F\U0000200D\U0001F308": ":\u5f69\u8679\u65d7:",
    u"\U0001F91A": ":\u62ac\u8d77\u624b\u80cc:",
    u"\U0001F91A\U0001F3FF": ":\u624b\u80cc\u9686\u8d77\uff0c\u80a4\u8272\u6697\u6c89:",
    u"\U0001F91A\U0001F3FB": ":\u624b\u80cc\u63d0\u4eae\u80a4\u8272:",
    u"\U0001F91A\U0001F3FE": ":\u624b\u80cc\u62ac\u9ad8\u4e2d\u6df1\u8272\u80a4\u8272:",
    u"\U0001F91A\U0001F3FC": ":\u624b\u80cc\u62ac\u9ad8\u4e2d\u6d45\u80a4\u8272:",
    u"\U0001F91A\U0001F3FD": ":\u624b\u80cc\u62ac\u9ad8\u4e2d\u7b49\u80a4\u8272:",
    u"\U0000270A": ":\u4e3e\u8d77\u62f3\u5934:",
    u"\U0000270A\U0001F3FF": ":\u63d0\u62f3\u6697\u80a4\u8272:",
    u"\U0000270A\U0001F3FB": ":\u63d0\u62f3\u8f7b\u80a4\u8272:",
    u"\U0000270A\U0001F3FE": ":\u63d0\u62f3\u4e2d\u6df1\u8272\u80a4\u8272:",
    u"\U0000270A\U0001F3FC": ":\u63d0\u62f3\u4e2d\u6d45\u80a4\u8272:",
    u"\U0000270A\U0001F3FD": ":\u626c\u8d77\u62f3\u5934\u4e2d\u7b49\u80a4\u8272:",
    u"\U0000270B": ":\u4e3e\u624b:",
    u"\U0000270B\U0001F3FF": ":\u4e3e\u624b\u6697\u80a4\u8272:",
    u"\U0000270B\U0001F3FB": ":\u62ac\u624b\u8f7b\u80a4\u8272:",
    u"\U0000270B\U0001F3FE": ":\u4e3e\u624b\u4e2d\u6df1\u8272\u80a4\u8272:",
    u"\U0000270B\U0001F3FC": ":\u4e3e\u624b\u4e2d\u6d45\u80a4\u8272:",
    u"\U0000270B\U0001F3FD": ":\u62ac\u8d77\u624b\u4e2d\u7b49\u80a4\u8272:",
    u"\U0001F64C": ":\u4e3e\u624b:",
    u"\U0001F64C\U0001F3FF": ":\u4e3e\u624b\u6697\u80a4\u8272:",
    u"\U0001F64C\U0001F3FB": ":\u53cc\u624b\u63d0\u4eae\u80a4\u8272:",
    u"\U0001F64C\U0001F3FE": ":\u4e3e\u624b\u4e2d\u6df1\u8272\u80a4\u8272:",
    u"\U0001F64C\U0001F3FC": ":\u4e3e\u624b\u4e2d\u6d45\u80a4\u8272:",
    u"\U0001F64C\U0001F3FD": ":\u4e3e\u8d77\u624b\u4e2d\u7b49\u80a4\u8272:",
    u"\U0001F40F": ":\u731b\u649e:",
    u"\U0001F400": ":\u8001\u9f20:",
    u"\U0001FA92": ":\u5243\u5200:",
    u"\U0001F9FE": ":\u6536\u636e:",
    u"\U000023FA": ":\u201c\u5f55\u5236\u201d\u6309\u94ae:",
    u"\U000023FA\U0000FE0F": ":\u5f55\u5236\u6309\u94ae:",
    u"\U0000267B": ":\u56de\u6536\u7b26\u53f7:",
    u"\U0000267B\U0000FE0F": ":\u56de\u6536\u7b26\u53f7:",
    u"\U0001F468\U0000200D\U0001F9B0": ":\u7ea2\u53d1\u4eba:",
    u"\U0001F469\U0000200D\U0001F9B0": ":\u7ea2\u53d1\u5973\u5b50:",
    u"\U0001F34E": ":\u7ea2\u82f9\u679c:",
    u"\U0001F534": ":\u7ea2\u8272\u5706\u5708:",
    u"\U0001F9E7": ":\u7ea2\u5305:",
    u"\U0001F9B0": ":\u7ea2\u5934\u53d1:",
    u"\U00002764": ":\u7ea2\u5fc3:",
    u"\U00002764\U0000FE0F": ":\u7ea2\u5fc3:",
    u"\U0001F3EE": ":\u7ea2\u7eb8\u706f\u7b3c:",
    u"\U0001F7E5": ":\u7ea2\u573a:",
    u"\U0001F53B": ":\u7ea2\u8272\u4e09\u89d2\u5f62\u671d\u4e0b:",
    u"\U0001F53A": ":\u7ea2\u8272\u4e09\u89d2\u5f62\u5411\u4e0a:",
    u"\U0001F1E6": ":\u533a\u57df\u6307\u793a\u5668\u7b26\u53f7\u5b57\u6bcda:",
    u"\U0001F1E7": ":\u533a\u57df\u6307\u793a\u5668\u7b26\u53f7\u5b57\u6bcdb:",
    u"\U0001F1E8": ":\u533a\u57df\u6307\u793a\u5668\u7b26\u53f7\u5b57\u6bcdc:",
    u"\U0001F1E9": ":\u533a\u57df\u6307\u793a\u5668\u7b26\u53f7\u5b57\u6bcdd:",
    u"\U0001F1EA": ":\u533a\u57df\u6307\u793a\u5668\u7b26\u53f7\u5b57\u6bcde:",
    u"\U0001F1EB": ":\u533a\u57df\u6307\u793a\u5668\u7b26\u53f7\u5b57\u6bcdf:",
    u"\U0001F1EC": ":\u533a\u57df\u6307\u793a\u5668\u7b26\u53f7\u5b57\u6bcdg:",
    u"\U0001F1ED": ":\u533a\u57df\u6307\u793a\u5668\u7b26\u53f7\u5b57\u6bcdh:",
    u"\U0001F1EE": ":\u533a\u57df\u6307\u793a\u5668\u7b26\u53f7\u5b57\u6bcdi:",
    u"\U0001F1EF": ":\u533a\u57df\u6307\u793a\u5668\u7b26\u53f7\u5b57\u6bcdj:",
    u"\U0001F1F0": ":\u533a\u57df\u6307\u793a\u5668\u7b26\u53f7\u5b57\u6bcdk:",
    u"\U0001F1F1": ":\u533a\u57df\u6307\u793a\u5668\u7b26\u53f7\u5b57\u6bcdl:",
    u"\U0001F1F2": ":\u533a\u57df\u6307\u793a\u5668\u7b26\u53f7\u5b57\u6bcdm:",
    u"\U0001F1F3": ":\u533a\u57df\u6307\u793a\u5668\u7b26\u53f7\u5b57\u6bcdn:",
    u"\U0001F1F4": ":\u533a\u57df\u6307\u793a\u5668\u7b26\u53f7\u5b57\u6bcdo:",
    u"\U0001F1F5": ":\u533a\u57df\u6307\u793a\u5668\u7b26\u53f7\u5b57\u6bcdp:",
    u"\U0001F1F6": ":\u533a\u57df\u6307\u793a\u5668\u7b26\u53f7\u5b57\u6bcdq:",
    u"\U0001F1F7": ":\u533a\u57df\u6307\u793a\u5668\u7b26\u53f7\u5b57\u6bcdr:",
    u"\U0001F1F8": ":\u533a\u57df\u6307\u793a\u5668\u7b26\u53f7\u5b57\u6bcds:",
    u"\U0001F1F9": ":\u533a\u57df\u6307\u793a\u5668\u7b26\u53f7\u5b57\u6bcdt:",
    u"\U0001F1FA": ":\u533a\u57df\u6307\u793a\u5668\u7b26\u53f7\u5b57\u6bcdu:",
    u"\U0001F1FB": ":\u533a\u57df\u6307\u793a\u5668\u7b26\u53f7\u5b57\u6bcdv:",
    u"\U0001F1FC": ":\u533a\u57df\u6307\u793a\u5668\u7b26\u53f7\u5b57\u6bcdw:",
    u"\U0001F1FD": ":\u533a\u57df\u6307\u793a\u5668\u7b26\u53f7\u5b57\u6bcdx:",
    u"\U0001F1FE": ":\u533a\u57df\u6307\u793a\u5668\u7b26\u53f7\u5b57\u6bcdy:",
    u"\U0001F1FF": ":\u533a\u57df\u6307\u793a\u5668\u7b26\u53f7\u5b57\u6bcdz:",
    u"\U000000AE": ":\u6ce8\u518c:",
    u"\U000000AE\U0000FE0F": ":\u6ce8\u518c:",
    u"\U0001F60C": ":\u677e\u4e86\u4e00\u53e3\u6c14\u7684\u8138:",
    u"\U0001F397": ":\u63d0\u9192\u529f\u80fd\u533a:",
    u"\U0001F397\U0000FE0F": ":\u63d0\u9192\u529f\u80fd\u533a:",
    u"\U0001F501": ":\u91cd\u590d\u6309\u94ae:",
    u"\U0001F502": ":\u91cd\u590d\u5355\u4e2a\u6309\u94ae:",
    u"\U000026D1": ":\u6551\u63f4\u4eba\u5458\u5934\u76d4:",
    u"\U000026D1\U0000FE0F": ":\u6551\u63f4\u4eba\u5458\u5934\u76d4:",
    u"\U0001F6BB": ":\u536b\u751f\u95f4:",
    u"\U000025C0": ":\u53cd\u8f6c\u6309\u94ae:",
    u"\U000025C0\U0000FE0F": ":\u5012\u6863\u6309\u94ae:",
    u"\U0001F49E": ":\u65cb\u8f6c\u7684\u5fc3:",
    u"\U0001F98F": ":\u7280\u725b:",
    u"\U0001F380": ":\u4e1d\u5e26:",
    u"\U0001F359": ":\u996d\u56e2:",
    u"\U0001F358": ":\u7c73\u7cd5:",
    u"\U0001F91C": ":\u53f3\u62f3:",
    u"\U0001F91C\U0001F3FF": ":\u53f3\u62f3\u6697\u80a4\u8272:",
    u"\U0001F91C\U0001F3FB": ":\u53f3\u62f3\u8f7b\u80a4\u8272:",
    u"\U0001F91C\U0001F3FE": ":\u53f3\u62f3\u4e2d\u6df1\u8272\u80a4\u8272:",
    u"\U0001F91C\U0001F3FC": ":\u53f3\u62f3\u4e2d\u6d45\u80a4\u8272:",
    u"\U0001F91C\U0001F3FD": ":\u53f3\u62f3\u4e2d\u80a4\u8272:",
    u"\U0001F5EF": ":\u6b63\u786e\u7684\u6124\u6012\u6ce1\u6cab:",
    u"\U0001F5EF\U0000FE0F": ":\u53f3\u6124\u6012\u6c14\u6ce1:",
    u"\U000027A1": ":\u53f3\u7bad\u5934:",
    u"\U00002935": ":\u53f3\u7bad\u5934\u5411\u4e0b\u5f2f\u66f2:",
    u"\U00002935\U0000FE0F": ":\u53f3\u7bad\u5934\u66f2\u7ebf\u5411\u4e0b:",
    u"\U000021A9": ":\u53f3\u7bad\u5934\u5411\u5de6\u5f2f\u66f2:",
    u"\U000021A9\U0000FE0F": ":\u53f3\u7bad\u5934\u66f2\u7ebf\u5de6:",
    u"\U00002934": ":\u53f3\u7bad\u5934\u5411\u4e0a\u5f2f\u66f2:",
    u"\U00002934\U0000FE0F": ":\u53f3\u7bad\u5934\u66f2\u7ebf\u4e0a\u5347:",
    u"\U000027A1\U0000FE0F": ":\u53f3\u7bad\u5934:",
    u"\U0001F48D": ":\u6212\u6307:",
    u"\U0001FA90": ":\u73af\u72b6\u884c\u661f:",
    u"\U0001F360": ":\u70e4\u7ea2\u85af:",
    u"\U0001F916": ":\u673a\u5668\u4eba\u8138:",
    u"\U0001F680": ":\u706b\u7bad:",
    u"\U0001F9FB": ":\u7eb8\u5377:",
    u"\U0001F5DE": ":\u5377\u8d77\u6765\u7684\u62a5\u7eb8:",
    u"\U0001F5DE\U0000FE0F": ":\u5377\u8d77\u5f0f\u62a5\u7eb8:",
    u"\U0001F3A2": ":\u8fc7\u5c71\u8f66:",
    u"\U0001F923": ":\u5728\u5730\u677f\u4e0a\u6253\u6eda\u5927\u7b11:",
    u"\U0001F413": ":\u516c\u9e21:",
    u"\U0001F339": ":\u73ab\u7470:",
    u"\U0001F3F5": ":\u73ab\u7470\u82b1\u7ed3:",
    u"\U0001F3F5\U0000FE0F": ":\u73ab\u7470\u82b1\u7ed3:",
    u"\U0001F4CD": ":\u5706\u56fe\u9489:",
    u"\U0001F3C9": ":\u6a44\u6984\u7403:",
    u"\U0001F3BD": ":\u8dd1\u6b65\u886b:",
    u"\U0001F45F": ":\u8dd1\u978b:",
    u"\U0001F625": ":\u6101\u7709\u82e6\u8138:",
    u"\U0001F9F7": ":\u5b89\u5168\u522b\u9488:",
    u"\U0001F9BA": ":\u5b89\u5168\u80cc\u5fc3:",
    u"\U000026F5": ":\u5e06\u8239:",
    u"\U0001F376": ":\u76ee\u7684:",
    u"\U0001F9C2": ":\u76d0:",
    u"\U0001F96A": ":\u4e09\u660e\u6cbb:",
    u"\U0001F97B": ":\u7eb1\u4e3d:",
    u"\U0001F6F0": ":\u536b\u661f:",
    u"\U0001F4E1": ":\u536b\u661f\u5929\u7ebf:",
    u"\U0001F6F0\U0000FE0F": ":\u536b\u661f:",
    u"\U0001F995": ":\u8725\u811a\u7c7b:",
    u"\U0001F3B7": ":\u8428\u514b\u65af:",
    u"\U0001F9E3": ":\u56f4\u5dfe:",
    u"\U0001F3EB": ":\u5b66\u6821:",
    u"\U0001F392": ":\u5b66\u6821\u80cc\u5305:",
    u"\U00002702": ":\u526a\u5200:",
    u"\U00002702\U0000FE0F": ":\u526a\u5f0f:",
    u"\U0001F982": ":\u874e\u5b50:",
    u"\U0001F4DC": ":\u7eb8\u5377:",
    u"\U0001F4BA": ":\u5ea7\u4f4d:",
    u"\U0001F648": ":\u770b\u4e0d\u5230\u90aa\u6076\u7684\u7334\u5b50:",
    u"\U0001F331": ":\u82d7\u6728:",
    u"\U0001F933": ":\u81ea\u62cd:",
    u"\U0001F933\U0001F3FF": ":\u81ea\u62cd\u6697\u80a4\u8272:",
    u"\U0001F933\U0001F3FB": ":\u81ea\u62cd\u6d45\u80a4\u8272:",
    u"\U0001F933\U0001F3FE": ":\u81ea\u62cd\u4e2d\u6df1\u8272\u80a4\u8272:",
    u"\U0001F933\U0001F3FC": ":\u81ea\u62cd\u4e2d\u6d45\u80a4\u8272:",
    u"\U0001F933\U0001F3FD": ":\u81ea\u62cd\u4e2d\u7b49\u80a4\u8272:",
    u"\U0001F415\U0000200D\U0001F9BA": ":\u670d\u52a1\u72d7:",
    u"\U0001F562": ":\u4e03\u70b9\u534a:",
    u"\U0001F556": ":\u4e03\u70b9\u949f:",
    u"\U0001F958": ":\u6d45\u76d8\u98df\u7269:",
    u"\U00002618": ":\u4e09\u53f6\u8349:",
    u"\U00002618\U0000FE0F": ":\u4e09\u53f6\u8349:",
    u"\U0001F988": ":\u9ca8\u9c7c:",
    u"\U0001F367": ":\u5228\u51b0:",
    u"\U0001F33E": ":\u4e00\u6346\u7c73:",
    u"\U0001F6E1": ":\u76fe:",
    u"\U0001F6E1\U0000FE0F": ":\u5c4f\u853d:",
    u"\U000026E9\U0000FE0F": ":\u795e\u793e:",
    u"\U0001F6A2": ":\u8239:",
    u"\U0001F320": ":\u6d41\u661f:",
    u"\U0001F6CD": ":\u8d2d\u7269\u888b:",
    u"\U0001F6CD\U0000FE0F": ":\u8d2d\u7269\u888b:",
    u"\U0001F6D2": ":\u8d2d\u7269\u8f66:",
    u"\U0001F370": ":\u8584\u997c:",
    u"\U0001FA73": ":\u77ed\u88e4:",
    u"\U0001F6BF": ":\u6dcb\u6d74:",
    u"\U0001F990": ":\u867e:",
    u"\U0001F500": ":\u968f\u673a\u64ad\u653e\u8f68\u8ff9\u6309\u94ae:",
    u"\U0001F92B": ":\u6296\u8138:",
    u"\U0001F918": ":\u89d2\u7684\u8ff9\u8c61:",
    u"\U0001F918\U0001F3FF": ":\u89d2\u8d28\u6697\u80a4\u8272:",
    u"\U0001F918\U0001F3FB": ":\u89d2\u7684\u8ff9\u8c61\u8868\u660e\u80a4\u8272\u53d8\u6d45:",
    u"\U0001F918\U0001F3FE": ":\u89d2\u5f81\u4e2d\u6df1\u8272\u80a4\u8272:",
    u"\U0001F918\U0001F3FC": ":\u89d2\u5f81\u4e2d\u6d45\u80a4\u8272:",
    u"\U0001F918\U0001F3FD": ":\u89d2\u5f81\u4e2d\u7b49\u80a4\u8272:",
    u"\U0001F561": ":\u516d\u70b9\u534a:",
    u"\U0001F555": ":\u516d\u70b9\u949f:",
    u"\U0001F6F9": ":\u6ed1\u677f:",
    u"\U000026F7": ":\u6ed1\u96ea\u8005:",
    u"\U000026F7\U0000FE0F": ":\u6ed1\u96ea\u8005:",
    u"\U0001F3BF": ":\u6ed1\u96ea\u677f:",
    u"\U0001F480": ":\u9885\u9aa8:",
    u"\U00002620": ":\u5934\u9aa8\u548c\u4ea4\u53c9\u9aa8:",
    u"\U00002620\U0000FE0F": ":\u5934\u9aa8\u548c\u4ea4\u53c9\u9aa8:",
    u"\U0001F9A8": ":\u81ed\u9f2c:",
    u"\U0001F6F7": ":\u96ea\u6a47:",
    u"\U0001F634": ":\u7761\u89c9\u7684\u8138:",
    u"\U0001F62A": ":\u56f0\u5026\u7684\u8138:",
    u"\U0001F641": ":\u5fae\u5fae\u76b1\u7709\u7684\u8138:",
    u"\U0001F642": ":\u5fae\u5fae\u7b11\u8138:",
    u"\U0001F3B0": ":\u8001\u864e\u673a:",
    u"\U0001F9A5": ":\u6811\u736d:",
    u"\U0001F6E9": ":\u5c0f\u578b\u98de\u673a:",
    u"\U0001F6E9\U0000FE0F": ":\u5c0f\u578b\u98de\u673a:",
    u"\U0001F539": ":\u84dd\u8272\u5c0f\u94bb\u77f3:",
    u"\U0001F538": ":\u6a59\u8272\u5c0f\u94bb\u77f3:",
    u"\U0001F63B": ":\u7b11\u772f\u772f\u7684\u732b\u8138:",
    u"\U0000263A": ":\u7b11\u8138:",
    u"\U0000263A\U0000FE0F": ":\u7b11\u8138:",
    u"\U0001F970": ":\u4e09\u9897\u5fc3\u7684\u7b11\u8138:",
    u"\U0001F607": ":\u5e26\u5149\u73af\u7684\u7b11\u8138:",
    u"\U0001F60D": ":\u5fc3\u773c\u7b11\u8138:",
    u"\U0001F608": ":\u6709\u89d2\u7684\u7b11\u8138:",
    u"\U0001F60A": ":\u7b11\u8138\u542b\u7b11:",
    u"\U0001F60E": ":\u6234\u7740\u58a8\u955c\u7684\u7b11\u8138:",
    u"\U0001F60F": ":\u7b11\u8138:",
    u"\U0001F40C": ":\u8717\u725b:",
    u"\U0001F40D": ":\u86c7:",
    u"\U0001F927": ":\u6253\u55b7\u568f\u7684\u8138:",
    u"\U0001F3D4": ":\u96ea\u5c71:",
    u"\U0001F3D4\U0000FE0F": ":\u96ea\u5c71:",
    u"\U0001F3C2": ":\u6ed1\u96ea\u677f\u8fd0\u52a8\u5458:",
    u"\U0001F3C2\U0001F3FF": ":\u6ed1\u96ea\u677f\u6df1\u8272\u80a4\u8272:",
    u"\U0001F3C2\U0001F3FB": ":\u6ed1\u96ea\u677f\u6d45\u80a4\u8272:",
    u"\U0001F3C2\U0001F3FE": ":\u6ed1\u96ea\u677f\u4e2d\u6df1\u8272\u80a4\u8272:",
    u"\U0001F3C2\U0001F3FC": ":\u4e2d\u6d45\u80a4\u8272\u6ed1\u96ea\u677f:",
    u"\U0001F3C2\U0001F3FD": ":\u6ed1\u96ea\u677f\u4e2d\u7b49\u80a4\u8272:",
    u"\U00002744": ":\u96ea\u82b1:",
    u"\U00002744\U0000FE0F": ":\u96ea\u82b1:",
    u"\U00002603": ":\u96ea\u4eba:",
    u"\U00002603\U0000FE0F": ":\u96ea\u4eba:",
    u"\U000026C4": ":\u6ca1\u6709\u96ea\u7684\u96ea\u4eba:",
    u"\U0001F9FC": ":\u80a5\u7682:",
    u"\U000026BD": ":\u8db3\u7403:",
    u"\U0001F9E6": ":\u889c\u5b50:",
    u"\U0001F366": ":\u8f6f\u51b0\u6dc7\u6dcb:",
    u"\U0001F94E": ":\u5792\u7403:",
    u"\U00002660": ":\u9ed1\u6843\u5957:",
    u"\U00002660\U0000FE0F": ":\u94c1\u9539\u5957\u88c5:",
    u"\U0001F35D": ":\u610f\u5927\u5229\u9762:",
    u"\U00002747": ":\u95ea\u8000:",
    u"\U00002747\U0000FE0F": ":\u706b\u82b1:",
    u"\U0001F387": ":\u8d77\u6ce1\u5242:",
    u"\U00002728": ":\u706b\u82b1:",
    u"\U0001F496": ":\u95ea\u95ea\u53d1\u5149\u7684\u5fc3:",
    u"\U0001F64A": ":\u4e0d\u8981\u8bf4\u90aa\u6076\u7684\u7334\u5b50:",
    u"\U0001F50A": ":\u626c\u58f0\u5668\u9ad8\u97f3\u91cf:",
    u"\U0001F508": ":\u626c\u58f0\u5668\u4f4e\u97f3\u91cf:",
    u"\U0001F509": ":\u626c\u58f0\u5668\u4e2d\u7b49\u97f3\u91cf:",
    u"\U0001F5E3": ":\u8bf4\u8bdd\u7684\u5934:",
    u"\U0001F5E3\U0000FE0F": ":\u8bf4\u8bdd\u5934:",
    u"\U0001F4AC": ":\u6f14\u8bb2\u6c14\u7403:",
    u"\U0001F6A4": ":\u5feb\u8247:",
    u"\U0001F577": ":\u8718\u86db:",
    u"\U0001F577\U0000FE0F": ":\u5361\u76d8:",
    u"\U0001F578": ":\u8718\u86db\u7f51:",
    u"\U0001F578\U0000FE0F": ":\u8718\u86db\u7f51:",
    u"\U0001F5D3": ":\u87ba\u65cb\u65e5\u5386:",
    u"\U0001F5D3\U0000FE0F": ":\u87ba\u65cb\u65e5\u5386:",
    u"\U0001F5D2": ":\u87ba\u65cb\u8bb0\u4e8b\u672c:",
    u"\U0001F5D2\U0000FE0F": ":\u87ba\u65cb\u8bb0\u4e8b\u672c:",
    u"\U0001F41A": ":\u87ba\u65cb\u58f3:",
    u"\U0001F9FD": ":\u6d77\u7ef5:",
    u"\U0001F944": ":\u52fa\u5b50:",
    u"\U0001F699": ":\u8fd0\u52a8\u578b\u591a\u7528\u9014\u8f66:",
    u"\U0001F3C5": ":\u4f53\u80b2\u5956\u7ae0:",
    u"\U0001F433": ":\u55b7\u6c34\u9cb8:",
    u"\U0001F991": ":\u9c7f\u9c7c:",
    u"\U0001F61D": ":\u7528\u820c\u5934\u772f\u7740\u8138:",
    u"\U0001F3DF": ":\u4f53\u80b2\u573a:",
    u"\U0001F3DF\U0000FE0F": ":\u4f53\u80b2\u573a:",
    u"\U0001F929": ":\u661f\u5149\u95ea\u8000:",
    u"\U0000262A": ":\u661f\u661f\u548c\u65b0\u6708:",
    u"\U0000262A\U0000FE0F": ":\u661f\u65b0\u6708:",
    u"\U00002721": ":\u5927\u536b\u4e4b\u661f:",
    u"\U00002721\U0000FE0F": ":\u5927\u536b\u4e4b\u661f:",
    u"\U0001F689": ":\u7ad9:",
    u"\U0001F35C": ":\u84b8\u7897:",
    u"\U0001FA7A": ":\u542c\u8bca\u5668:",
    u"\U000023F9": ":\u505c\u6b62\u6309\u94ae:",
    u"\U000023F9\U0000FE0F": ":\u505c\u6b62\u6309\u94ae:",
    u"\U0001F6D1": ":\u505c\u8f66\u6807\u5fd7:",
    u"\U000023F1": ":\u79d2\u8868:",
    u"\U000023F1\U0000FE0F": ":\u79d2\u8868:",
    u"\U0001F4CF": ":\u76f4\u5c3a:",
    u"\U0001F353": ":\u8349\u8393:",
    u"\U0001F399": ":\u5f55\u97f3\u5ba4\u8bdd\u7b52:",
    u"\U0001F399\U0000FE0F": ":\u5f55\u97f3\u5ba4\u8bdd\u7b52:",
    u"\U0001F959": ":\u9985\u6241\u9762\u5305:",
    u"\U00002600": ":\u592a\u9633:",
    u"\U000026C5": ":\u4e91\u540e\u7684\u592a\u9633:",
    u"\U0001F325": ":\u5927\u4e91\u540e\u7684\u592a\u9633:",
    u"\U0001F325\U0000FE0F": ":\u5927\u578b\u4e91\u540e\u9762\u7684\u592a\u9633:",
    u"\U0001F326": ":\u96e8\u4e91\u80cc\u540e\u7684\u592a\u9633:",
    u"\U0001F326\U0000FE0F": ":\u96e8\u4e91\u540e\u9762\u7684\u592a\u9633:",
    u"\U0001F324": ":\u5c0f\u4e91\u540e\u7684\u592a\u9633:",
    u"\U0001F324\U0000FE0F": ":\u592a\u9633\u80cc\u540e\u7684\u5c0f\u4e91:",
    u"\U00002600\U0000FE0F": ":\u592a\u9633:",
    u"\U0001F31E": ":\u6709\u8138\u7684\u592a\u9633:",
    u"\U0001F33B": ":\u5411\u65e5\u8475:",
    u"\U0001F576": ":\u592a\u9633\u955c:",
    u"\U0001F576\U0000FE0F": ":\u592a\u9633\u955c:",
    u"\U0001F305": ":\u65e5\u51fa:",
    u"\U0001F304": ":\u5c71\u4e0a\u65e5\u51fa:",
    u"\U0001F307": ":\u65e5\u843d:",
    u"\U0001F9B8\U0001F3FF": ":\u8d85\u7ea7\u82f1\u96c4\u6df1\u8272\u80a4\u8272:",
    u"\U0001F9B8\U0001F3FB": ":\u8d85\u7ea7\u82f1\u96c4\u6d45\u80a4\u8272:",
    u"\U0001F9B8\U0001F3FE": ":\u8d85\u7ea7\u82f1\u96c4\u4e2d\u6df1\u8272\u80a4\u8272:",
    u"\U0001F9B8\U0001F3FC": ":\u8d85\u7ea7\u82f1\u96c4\u4e2d\u6d45\u80a4\u8272:",
    u"\U0001F9B8\U0001F3FD": ":\u8d85\u7ea7\u82f1\u96c4\u4e2d\u7b49\u80a4\u8272:",
    u"\U0001F9B8": ":\u8d85\u7ea7\u82f1\u96c4:",
    u"\U0001F9B9\U0001F3FF": ":\u8d85\u7ea7\u6076\u68cd\u6697\u80a4\u8272:",
    u"\U0001F9B9\U0001F3FB": ":\u8d85\u7ea7\u6076\u68cd\u6d45\u80a4\u8272:",
    u"\U0001F9B9\U0001F3FE": ":\u8d85\u7ea7\u6076\u68cd\u4e2d\u9ed1\u80a4\u8272:",
    u"\U0001F9B9\U0001F3FC": ":\u8d85\u7ea7\u6076\u68cd\u4e2d\u6d45\u80a4\u8272:",
    u"\U0001F9B9\U0001F3FD": ":\u8d85\u7ea7\u6076\u68cd\u4e2d\u7b49\u80a4\u8272:",
    u"\U0001F9B9": ":\u8d85\u7ea7\u6076\u68cd:",
    u"\U0001F363": ":\u5bff\u53f8:",
    u"\U0001F69F": ":\u60ac\u7d22\u94c1\u8def:",
    u"\U0001F9A2": ":\u5929\u9e45:",
    u"\U0001F4A6": ":\u6c57\u6ef4:",
    u"\U0001F54D": ":\u72b9\u592a\u4f1a\u5802:",
    u"\U0001F489": ":\u6ce8\u5c04\u5668:",
    u"\U0001F455": ":t\u6064\u886b:",
    u"\U0001F32E": ":\u58a8\u897f\u54e5\u7389\u7c73\u8584\u997c\u5377:",
    u"\U0001F961": ":\u5916\u5356\u76d2:",
    u"\U0001F38B": ":\u4e03\u5915\u6811:",
    u"\U0001F34A": ":\u6a58\u5b50:",
    u"\U0001F695": ":\u51fa\u79df\u8f66:",
    u"\U0001F375": ":\u65e0\u67c4\u8336\u676f:",
    u"\U0001F4C6": ":\u6495\u4e0b\u65e5\u5386:",
    u"\U0001F9F8": ":\u6cf0\u8fea\u718a:",
    u"\U0000260E": ":\u7535\u8bdd:",
    u"\U0001F4DE": ":\u7535\u8bdd\u542c\u7b52:",
    u"\U0000260E\U0000FE0F": ":\u7535\u8bdd:",
    u"\U0001F52D": ":\u671b\u8fdc\u955c:",
    u"\U0001F4FA": ":\u7535\u89c6:",
    u"\U0001F565": ":\u5341\u70b9\u534a:",
    u"\U0001F559": ":\u5341\u70b9\u949f:",
    u"\U0001F3BE": ":\u7f51\u7403:",
    u"\U000026FA": ":\u5e10\u7bf7:",
    u"\U0001F9EA": ":\u8bd5\u7ba1:",
    u"\U0001F321": ":\u6e29\u5ea6\u8ba1:",
    u"\U0001F321\U0000FE0F": ":\u6e29\u5ea6\u8ba1:",
    u"\U0001F914": ":\u601d\u8003\u7684\u9762\u5b54:",
    u"\U0001F4AD": ":\u601d\u60f3\u6c14\u7403:",
    u"\U0001F9F5": ":\u7ebf:",
    u"\U0001F55E": ":\u4e09\u70b9\u534a:",
    u"\U0001F552": ":\u4e09\u70b9\u949f:",
    u"\U0001F44E": ":\u5927\u62c7\u6307\u671d\u4e0b:",
    u"\U0001F44E\U0001F3FF": ":\u6df1\u80a4\u8272:",
    u"\U0001F44E\U0001F3FB": ":\u62c7\u6307\u5411\u4e0b\u8f7b\u80a4\u8272:",
    u"\U0001F44E\U0001F3FE": ":\u62c7\u6307\u671d\u4e0b\u4e2d\u6df1\u8272\u80a4\u8272:",
    u"\U0001F44E\U0001F3FC": ":\u62c7\u6307\u5411\u4e0b\u4e2d\u6d45\u80a4\u8272:",
    u"\U0001F44E\U0001F3FD": ":\u62c7\u6307\u671d\u4e0b\u4e2d\u7b49\u80a4\u8272:",
    u"\U0001F44D": ":\u7ad6\u8d77\u5927\u62c7\u6307:",
    u"\U0001F44D\U0001F3FF": ":\u7ad6\u8d77\u5927\u62c7\u6307\u6df1\u80a4\u8272:",
    u"\U0001F44D\U0001F3FB": ":\u62c7\u6307\u5411\u4e0a\u8f7b\u80a4\u8272:",
    u"\U0001F44D\U0001F3FE": ":\u62c7\u6307\u5411\u4e0a\u4e2d\u6df1\u8272\u80a4\u8272:",
    u"\U0001F44D\U0001F3FC": ":\u62c7\u6307\u5411\u4e0a\u4e2d\u6d45\u80a4\u8272:",
    u"\U0001F44D\U0001F3FD": ":\u62c7\u6307\u5411\u4e0a\u4e2d\u7b49\u80a4\u8272:",
    u"\U0001F3AB": ":\u7968:",
    u"\U0001F405": ":\u8001\u864e:",
    u"\U0001F42F": ":\u864e\u8138:",
    u"\U000023F2": ":\u5b9a\u65f6\u949f:",
    u"\U000023F2\U0000FE0F": ":\u5b9a\u65f6\u5668\u65f6\u949f:",
    u"\U0001F62B": ":\u75b2\u60eb\u7684\u8138:",
    u"\U0001F6BD": ":\u5395\u6240:",
    u"\U0001F345": ":\u756a\u8304:",
    u"\U0001F445": ":\u820c\u5934:",
    u"\U0001F9F0": ":\u5de5\u5177\u7bb1:",
    u"\U0001F9B7": ":\u7259\u9f7f:",
    u"\U0001F3A9": ":\u5927\u793c\u5e3d:",
    u"\U0001F32A": ":\u9f99\u5377\u98ce:",
    u"\U0001F32A\U0000FE0F": ":\u9f99\u5377\u98ce:",
    u"\U0001F5B2": ":\u8f68\u8ff9\u7403:",
    u"\U0001F5B2\U0000FE0F": ":\u8f68\u8ff9\u7403:",
    u"\U0001F69C": ":\u62d6\u62c9\u673a:",
    u"\U00002122": ":\u5546\u6807:",
    u"\U00002122\U0000FE0F": ":\u5546\u6807:",
    u"\U0001F686": ":\u706b\u8f66:",
    u"\U0001F68A": ":\u6709\u8f68\u7535\u8f66:",
    u"\U0001F68B": ":\u6709\u8f68\u7535\u8f66:",
    u"\U0001F6A9": ":\u4e09\u89d2\u65d7:",
    u"\U0001F4D0": ":\u4e09\u89d2\u5c3a:",
    u"\U0001F531": ":\u4e09\u53c9\u621f\u5fbd\u7ae0:",
    u"\U0001F68E": ":\u65e0\u8f68\u7535\u8f66:",
    u"\U0001F3C6": ":\u5956\u676f:",
    u"\U0001F379": ":\u70ed\u5e26\u996e\u6599:",
    u"\U0001F420": ":\u70ed\u5e26\u9c7c:",
    u"\U0001F3BA": ":\u5c0f\u53f7:",
    u"\U0001F337": ":\u90c1\u91d1\u9999:",
    u"\U0001F943": ":\u5e73\u5e95\u676f:",
    u"\U0001F983": ":\u706b\u9e21:",
    u"\U0001F422": ":\u4e4c\u9f9f:",
    u"\U0001F567": ":\u5341\u4e8c\u70b9\u4e09\u5341\u5206:",
    u"\U0001F55B": ":\u5341\u4e8c\u70b9\u949f:",
    u"\U0001F42B": ":\u53cc\u5cf0\u9a86\u9a7c:",
    u"\U0001F55D": ":\u4e24\u70b9\u534a:",
    u"\U0001F495": ":\u4e24\u9897\u5fc3:",
    u"\U0001F46C": ":\u4e24\u4e2a\u624b\u7275\u624b\u7684\u7537\u4eba:",
    u"\U0001F551": ":\u4e24\u70b9\u949f:",
    u"\U0001F46D": ":\u4e24\u4e2a\u5973\u4eba\u624b\u7275\u624b:",
    u"\U00002602": ":\u96e8\u4f1e:",
    u"\U000026F1": ":\u5730\u4e0a\u7684\u4f1e:",
    u"\U000026F1\U0000FE0F": ":\u4f1e\u5f0f\u5730\u9762:",
    u"\U00002602\U0000FE0F": ":\u4f1e\u5f0f:",
    u"\U00002614": ":\u96e8\u4f1e:",
    u"\U0001F612": ":\u672a\u4fee\u9970\u7684\u8138:",
    u"\U0001F984": ":\u72ec\u89d2\u517d\u8138:",
    u"\U0001F513": ":\u89e3\u9501:",
    u"\U00002195": ":\u4e0a\u4e0b\u7bad\u5934:",
    u"\U00002195\U0000FE0F": ":\u4e0a\u4e0b\u7bad\u5934:",
    u"\U00002196": ":\u5de6\u4e0a\u7bad\u5934:",
    u"\U00002196\U0000FE0F": ":\u5de6\u4e0a\u7bad\u5934:",
    u"\U00002197": ":\u53f3\u4e0a\u7bad\u5934:",
    u"\U00002197\U0000FE0F": ":\u53f3\u4e0a\u7bad\u5934:",
    u"\U00002B06": ":\u5411\u4e0a\u7bad\u5934:",
    u"\U00002B06\U0000FE0F": ":\u4e0a\u7bad\u5934:",
    u"\U0001F643": ":\u5012\u7acb\u8138:",
    u"\U0001F53C": ":\u5411\u4e0a\u6309\u94ae:",
    u"\U0001F9DB": ":\u5438\u8840\u9b3c:",
    u"\U0001F9DB\U0001F3FF": ":\u5438\u8840\u9b3c\u80a4\u8272:",
    u"\U0001F9DB\U0001F3FB": ":\u5438\u8840\u9b3c\u6d45\u80a4\u8272:",
    u"\U0001F9DB\U0001F3FE": ":\u5438\u8840\u9b3c\u4e2d\u6df1\u8272\u80a4\u8272:",
    u"\U0001F9DB\U0001F3FC": ":\u5438\u8840\u9b3c\u4e2d\u6d45\u80a4\u8272:",
    u"\U0001F9DB\U0001F3FD": ":\u5438\u8840\u9b3c\u4e2d\u7b49\u80a4\u8272:",
    u"\U0001F6A6": ":\u5782\u76f4\u7ea2\u7eff\u706f:",
    u"\U0001F4F3": ":\u632f\u52a8\u6a21\u5f0f:",
    u"\U0000270C": ":\u80dc\u5229\u4e4b\u624b:",
    u"\U0000270C\U0001F3FF": ":\u80dc\u5229\u4e4b\u624b\u6697\u80a4\u8272:",
    u"\U0000270C\U0001F3FB": ":\u80dc\u5229\u624b\u6d45\u80a4\u8272:",
    u"\U0000270C\U0001F3FE": ":\u80dc\u5229\u4e4b\u624b\u4e2d\u6df1\u8272\u80a4\u8272:",
    u"\U0000270C\U0001F3FC": ":\u80dc\u5229\u4e4b\u624b\u4e2d\u6d45\u80a4\u8272:",
    u"\U0000270C\U0001F3FD": ":\u80dc\u5229\u4e4b\u624b\u4e2d\u7b49\u80a4\u8272:",
    u"\U0000270C\U0000FE0F": ":\u80dc\u5229\u724c:",
    u"\U0001F4F9": ":\u6444\u50cf\u673a:",
    u"\U0001F3AE": ":\u7535\u5b50\u6e38\u620f:",
    u"\U0001F4FC": ":\u5f55\u50cf\u5e26:",
    u"\U0001F3BB": ":\u5c0f\u63d0\u7434:",
    u"\U0001F30B": ":\u706b\u5c71:",
    u"\U0001F3D0": ":\u6392\u7403:",
    u"\U0001F596": ":\u74e6\u80af\u793c\u70ae:",
    u"\U0001F596\U0001F3FF": ":\u9ed1\u76ae\u80a4\u53ef\u4ee5\u656c\u793c:",
    u"\U0001F596\U0001F3FB": ":\u4e07\u51ef\u793c\u70ae\u6d45\u80a4\u8272:",
    u"\U0001F596\U0001F3FE": ":\u4e07\u51ef\u793c\u70ae\u4e2d\u6df1\u8272\u80a4\u8272:",
    u"\U0001F596\U0001F3FC": ":\u4e07\u51ef\u793c\u4e2d\u6d45\u80a4\u8272:",
    u"\U0001F596\U0001F3FD": ":\u4e07\u51ef\u793c\u4e2d\u7b49\u80a4\u8272:",
    u"\U0001F9C7": ":\u534e\u592b\u997c:",
    u"\U0001F318": ":\u6b8b\u6708:",
    u"\U0001F316": ":\u6e10\u4e8f\u51f8\u6708:",
    u"\U000026A0": ":\u8b66\u544a:",
    u"\U000026A0\U0000FE0F": ":\u8b66\u544a:",
    u"\U0001F5D1": ":\u5e9f\u7eb8\u7bd3:",
    u"\U0001F5D1\U0000FE0F": ":\u5e9f\u7eb8\u7bd3:",
    u"\U0000231A": ":\u770b:",
    u"\U0001F403": ":\u6c34\u725b:",
    u"\U0001F6BE": ":\u62bd\u6c34\u9a6c\u6876:",
    u"\U0001F30A": ":\u6c34\u6ce2:",
    u"\U0001F349": ":\u897f\u74dc:",
    u"\U0001F44B": ":\u6325\u624b:",
    u"\U0001F44B\U0001F3FF": ":\u6325\u624b\u6697\u80a4\u8272:",
    u"\U0001F44B\U0001F3FB": ":\u6325\u624b\u8f7b\u80a4\u8272:",
    u"\U0001F44B\U0001F3FE": ":\u6325\u624b\u4e2d\u6df1\u8272\u80a4\u8272:",
    u"\U0001F44B\U0001F3FC": ":\u6325\u624b\u4e2d\u6d45\u80a4\u8272:",
    u"\U0001F44B\U0001F3FD": ":\u6325\u624b\u4e2d\u7b49\u80a4\u8272:",
    u"\U00003030": ":\u6ce2\u6d6a\u5f62\u865a\u7ebf:",
    u"\U00003030\U0000FE0F": ":\u6ce2\u6d6a\u5f62\u77ed\u5212\u7ebf:",
    u"\U0001F312": ":\u5a25\u7709\u6708:",
    u"\U0001F314": ":\u51f8\u6708:",
    u"\U0001F640": ":\u75b2\u60eb\u7684\u732b\u8138:",
    u"\U0001F629": ":\u75b2\u60eb\u7684\u8138:",
    u"\U0001F492": ":\u5a5a\u793c:",
    u"\U0001F40B": ":\u9cb8\u9c7c:",
    u"\U00002638": ":\u6cd5\u8f6e:",
    u"\U00002638\U0000FE0F": ":\u6cd5\u8f6e:",
    u"\U0000267F": ":\u8f6e\u6905\u6807\u5fd7:",
    u"\U0001F468\U0000200D\U0001F9B3": ":\u767d\u53d1\u4eba:",
    u"\U0001F469\U0000200D\U0001F9B3": ":\u767d\u53d1\u5973\u5b50:",
    u"\U000026AA": ":\u767d\u8272\u5706\u5708:",
    u"\U00002755": ":\u767d\u8272\u611f\u53f9\u53f7:",
    u"\U0001F3F3": ":\u767d\u65d7:",
    u"\U0001F3F3\U0000FE0F": ":\u767d\u65d7:",
    u"\U0001F4AE": ":\u767d\u82b1:",
    u"\U0001F9B3": ":\u767d\u53d1:",
    u"\U0001F90D": ":\u767d\u5fc3:",
    u"\U00002705": ":\u767d\u8272\u7c97\u590d\u9009\u6807\u8bb0:",
    u"\U00002B1C": ":\u767d\u8272\u5927\u6b63\u65b9\u5f62:",
    u"\U000025FD": ":\u767d\u8272\u4e2d\u5c0f\u578b\u6b63\u65b9\u5f62:",
    u"\U000025FB": ":\u767d\u8272\u4e2d\u65b9\u5f62:",
    u"\U000025FB\U0000FE0F": ":\u767d\u8272\u4e2d\u65b9\u5f62:",
    u"\U00002B50": ":\u767d\u8272\u4e2d\u661f\u5f62:",
    u"\U00002754": ":\u767d\u8272\u95ee\u53f7:",
    u"\U000025AB": ":\u767d\u8272\u5c0f\u6b63\u65b9\u5f62:",
    u"\U000025AB\U0000FE0F": ":\u767d\u8272\u5c0f\u65b9\u5f62:",
    u"\U0001F533": ":\u767d\u8272\u65b9\u5f62\u6309\u94ae:",
    u"\U0001F940": ":\u67af\u840e\u7684\u82b1:",
    u"\U0001F390": ":\u98ce\u94c3:",
    u"\U0001F32C": ":\u8fce\u98ce\u9762:",
    u"\U0001F32C\U0000FE0F": ":\u98ce\u5411:",
    u"\U0001F377": ":\u9152\u676f:",
    u"\U0001F609": ":\u7728\u773c:",
    u"\U0001F61C": ":\u7528\u820c\u5934\u7728\u773c:",
    u"\U0001F43A": ":\u72fc\u8138:",
    u"\U0001F471\U0000200D\U00002640": ":\u5973\u4eba\u91d1\u53d1:",
    u"\U0001F469\U0001F3FF\U0000200D\U0001F9B2": ":\u5973\u6027\u79c3\u9876\u80a4\u8272:",
    u"\U0001F471\U0001F3FF\U0000200D\U00002640": ":\u5973\u6027\u6df1\u8272\u80a4\u8272\u91d1\u53d1:",
    u"\U0001F469\U0001F3FF\U0000200D\U0001F9B1": ":\u5973\u6027\u6df1\u8272\u80a4\u8272\u5377\u53d1:",
    u"\U0001F469\U0001F3FF\U0000200D\U0001F9B0": ":\u5973\u6027\u6df1\u8272\u80a4\u8272\u7ea2\u53d1:",
    u"\U0001F469\U0001F3FF\U0000200D\U0001F9B3": ":\u5973\u6027\u6df1\u8272\u80a4\u8272\u767d\u53d1:",
    u"\U0001F469\U0001F3FB\U0000200D\U0001F9B2": ":\u5973\u6027\u6d45\u80a4\u8272\u79c3\u5934:",
    u"\U0001F471\U0001F3FB\U0000200D\U00002640": ":\u5973\u6027\u6d45\u80a4\u8272\u91d1\u53d1:",
    u"\U0001F469\U0001F3FB\U0000200D\U0001F9B1": ":\u5973\u6027\u6d45\u80a4\u8272\u5377\u53d1:",
    u"\U0001F469\U0001F3FB\U0000200D\U0001F9B0": ":\u5973\u6027\u6d45\u80a4\u8272\u7ea2\u53d1:",
    u"\U0001F469\U0001F3FB\U0000200D\U0001F9B3": ":\u5973\u6027\u6d45\u80a4\u8272\u767d\u53d1:",
    u"\U0001F469\U0001F3FE\U0000200D\U0001F9B2": ":\u5973\u6027\u4e2d\u6df1\u8272\u80a4\u8272\u79c3\u5934:",
    u"\U0001F471\U0001F3FE\U0000200D\U00002640": ":\u5973\u6027\u4e2d\u6df1\u8272\u80a4\u8272\u91d1\u53d1:",
    u"\U0001F469\U0001F3FE\U0000200D\U0001F9B1": ":\u5973\u6027\u4e2d\u6df1\u8272\u80a4\u8272\u5377\u53d1:",
    u"\U0001F469\U0001F3FE\U0000200D\U0001F9B0": ":\u5973\u6027\u4e2d\u6df1\u8272\u80a4\u8272\u7ea2\u53d1:",
    u"\U0001F469\U0001F3FE\U0000200D\U0001F9B3": ":\u5973\u6027\u4e2d\u6df1\u8272\u80a4\u8272\u767d\u53d1:",
    u"\U0001F469\U0001F3FC\U0000200D\U0001F9B2": ":\u5973\u6027\u4e2d\u6d45\u80a4\u8272\u79c3\u5934:",
    u"\U0001F471\U0001F3FC\U0000200D\U00002640": ":\u5973\u6027\u4e2d\u6d45\u80a4\u8272\u91d1\u53d1:",
    u"\U0001F469\U0001F3FC\U0000200D\U0001F9B1": ":\u5973\u6027\u4e2d\u6d45\u80a4\u8272\u5377\u53d1:",
    u"\U0001F469\U0001F3FC\U0000200D\U0001F9B0": ":\u5973\u6027\u4e2d\u6d45\u80a4\u8272\u7ea2\u53d1:",
    u"\U0001F469\U0001F3FC\U0000200D\U0001F9B3": ":\u5973\u6027\u4e2d\u6d45\u80a4\u8272\u767d\u53d1:",
    u"\U0001F469\U0001F3FD\U0000200D\U0001F9B2": ":\u5973\u6027\u4e2d\u7b49\u80a4\u8272\u79c3\u5934:",
    u"\U0001F471\U0001F3FD\U0000200D\U00002640": ":\u5973\u6027\u4e2d\u7b49\u80a4\u8272\u91d1\u53d1:",
    u"\U0001F469\U0001F3FD\U0000200D\U0001F9B1": ":\u5973\u6027\u4e2d\u7b49\u80a4\u8272\u5377\u53d1:",
    u"\U0001F469\U0001F3FD\U0000200D\U0001F9B0": ":\u5973\u6027\u4e2d\u7b49\u80a4\u8272\u7ea2\u53d1:",
    u"\U0001F469\U0001F3FD\U0000200D\U0001F9B3": ":\u5973\u6027\u4e2d\u7b49\u80a4\u8272\u767d\u53d1:",
    u"\U0001F469": ":\u5973\u4eba:",
    u"\U0001F469\U0001F3FF\U0000200D\U0001F91D\U0000200D\U0001F468\U0001F3FB": ":\u5973\u4eba\u548c\u7537\u4eba\u624b\u7275\u624b\u6df1\u8272\u80a4\u8272\u6d45\u80a4\u8272:",
    u"\U0001F469\U0001F3FF\U0000200D\U0001F91D\U0000200D\U0001F468\U0001F3FE": ":\u5973\u4eba\u548c\u7537\u4eba\u624b\u7275\u624b\u6df1\u8272\u80a4\u8272\u4e2d\u6df1\u8272\u80a4\u8272:",
    u"\U0001F469\U0001F3FF\U0000200D\U0001F91D\U0000200D\U0001F468\U0001F3FC": ":\u5973\u4eba\u548c\u7537\u4eba\u624b\u7275\u624b\u6df1\u8272\u80a4\u8272\u4e2d\u6d45\u80a4\u8272:",
    u"\U0001F469\U0001F3FF\U0000200D\U0001F91D\U0000200D\U0001F468\U0001F3FD": ":\u5973\u4eba\u548c\u7537\u4eba\u624b\u7275\u624b\u6df1\u8272\u80a4\u8272\u4e2d\u7b49\u80a4\u8272:",
    u"\U0001F46B\U0001F3FF": ":\u624b\u7275\u7740\u624b\u7684\u5973\u4eba\u548c\u7537\u4eba\u80a4\u8272\u9edd\u9ed1:",
    u"\U0001F469\U0001F3FB\U0000200D\U0001F91D\U0000200D\U0001F468\U0001F3FF": ":\u7537\u5973\u624b\u7275\u624b\u6d45\u80a4\u8272\u6697\u80a4\u8272:",
    u"\U0001F469\U0001F3FB\U0000200D\U0001F91D\U0000200D\U0001F468\U0001F3FE": ":\u7537\u5973\u624b\u7275\u624b\u6d45\u80a4\u8272\u4e2d\u6df1\u8272\u80a4\u8272:",
    u"\U0001F469\U0001F3FB\U0000200D\U0001F91D\U0000200D\U0001F468\U0001F3FC": ":\u7537\u5973\u624b\u7275\u624b\u6d45\u80a4\u8272\u4e2d\u6d45\u80a4\u8272:",
    u"\U0001F469\U0001F3FB\U0000200D\U0001F91D\U0000200D\U0001F468\U0001F3FD": ":\u7537\u5973\u624b\u7275\u624b\u6d45\u80a4\u8272\u4e2d\u7b49\u80a4\u8272:",
    u"\U0001F46B\U0001F3FB": ":\u7537\u5973\u624b\u7275\u624b\u80a4\u8272\u6d45:",
    u"\U0001F469\U0001F3FE\U0000200D\U0001F91D\U0000200D\U0001F468\U0001F3FF": ":\u5973\u4eba\u548c\u7537\u4eba\u624b\u7275\u624b\u6697\u80a4\u8272\u6697\u80a4\u8272:",
    u"\U0001F469\U0001F3FE\U0000200D\U0001F91D\U0000200D\U0001F468\U0001F3FB": ":\u7537\u5973\u624b\u7275\u624b\u4e2d\u6df1\u8272\u80a4\u8272\u6d45\u80a4\u8272:",
    u"\U0001F469\U0001F3FE\U0000200D\U0001F91D\U0000200D\U0001F468\U0001F3FC": ":\u7537\u5973\u624b\u7275\u624b\u4e2d\u6df1\u8272\u80a4\u8272\u4e2d\u6d45\u80a4\u8272:",
    u"\U0001F469\U0001F3FE\U0000200D\U0001F91D\U0000200D\U0001F468\U0001F3FD": ":\u624b\u7275\u7740\u624b\u7684\u5973\u4eba\u548c\u7537\u4eba\u4e2d\u6df1\u8272\u80a4\u8272\u4e2d\u7b49\u80a4\u8272:",
    u"\U0001F46B\U0001F3FE": ":\u624b\u7275\u7740\u624b\u7684\u5973\u4eba\u548c\u7537\u4eba\u80a4\u8272\u504f\u9ed1:",
    u"\U0001F469\U0001F3FC\U0000200D\U0001F91D\U0000200D\U0001F468\U0001F3FF": ":\u7537\u5973\u624b\u7275\u624b\u4e2d\u6d45\u80a4\u8272\u6697\u80a4\u8272:",
    u"\U0001F469\U0001F3FC\U0000200D\U0001F91D\U0000200D\U0001F468\U0001F3FB": ":\u7537\u5973\u624b\u7275\u624b\u4e2d\u6d45\u80a4\u8272\u6d45\u80a4\u8272:",
    u"\U0001F469\U0001F3FC\U0000200D\U0001F91D\U0000200D\U0001F468\U0001F3FE": ":\u7537\u5973\u624b\u7275\u624b\u4e2d\u6d45\u80a4\u8272\u4e2d\u6df1\u8272\u80a4\u8272:",
    u"\U0001F469\U0001F3FC\U0000200D\U0001F91D\U0000200D\U0001F468\U0001F3FD": ":\u7537\u5973\u624b\u7275\u624b\u4e2d\u6d45\u80a4\u8272\u4e2d\u7b49\u80a4\u8272:",
    u"\U0001F46B\U0001F3FC": ":\u7537\u5973\u624b\u7275\u624b\u4e2d\u6d45\u80a4\u8272:",
    u"\U0001F469\U0001F3FD\U0000200D\U0001F91D\U0000200D\U0001F468\U0001F3FF": ":\u7537\u5973\u624b\u7275\u624b\u4e2d\u80a4\u8272\u6697\u80a4\u8272:",
    u"\U0001F469\U0001F3FD\U0000200D\U0001F91D\U0000200D\U0001F468\U0001F3FB": ":\u7537\u5973\u624b\u7275\u624b\u4e2d\u80a4\u8272\u6d45\u80a4\u8272:",
    u"\U0001F469\U0001F3FD\U0000200D\U0001F91D\U0000200D\U0001F468\U0001F3FE": ":\u5973\u4eba\u548c\u7537\u4eba\u624b\u7275\u624b\u4e2d\u7b49\u80a4\u8272\u4e2d\u7b49\u6df1\u8272\u80a4\u8272:",
    u"\U0001F469\U0001F3FD\U0000200D\U0001F91D\U0000200D\U0001F468\U0001F3FC": ":\u7537\u5973\u624b\u7275\u624b\u4e2d\u6d45\u80a4\u8272:",
    u"\U0001F46B\U0001F3FD": ":\u7537\u5973\u624b\u7275\u624b\u4e2d\u80a4\u8272:",
    u"\U0001F469\U0000200D\U0001F3A8": ":\u5973\u827a\u672f\u5bb6:",
    u"\U0001F469\U0001F3FF\U0000200D\U0001F3A8": ":\u5973\u827a\u4eba\u6697\u80a4\u8272:",
    u"\U0001F469\U0001F3FB\U0000200D\U0001F3A8": ":\u5973\u827a\u4eba\u6d45\u80a4\u8272:",
    u"\U0001F469\U0001F3FE\U0000200D\U0001F3A8": ":\u5973\u827a\u4eba\u4e2d\u6df1\u8272\u80a4\u8272:",
    u"\U0001F469\U0001F3FC\U0000200D\U0001F3A8": ":\u5973\u827a\u4eba\u4e2d\u6d45\u80a4\u8272:",
    u"\U0001F469\U0001F3FD\U0000200D\U0001F3A8": ":\u5973\u827a\u4eba\u4e2d\u7b49\u80a4\u8272:",
    u"\U0001F469\U0000200D\U0001F680": ":\u5973\u5b87\u822a\u5458:",
    u"\U0001F469\U0001F3FF\U0000200D\U0001F680": ":\u5973\u5b87\u822a\u5458\u6df1\u8272\u80a4\u8272:",
    u"\U0001F469\U0001F3FB\U0000200D\U0001F680": ":\u5973\u822a\u5929\u5458\u6d45\u80a4\u8272:",
    u"\U0001F469\U0001F3FE\U0000200D\U0001F680": ":\u5973\u5b87\u822a\u5458\u4e2d\u6df1\u8272\u80a4\u8272:",
    u"\U0001F469\U0001F3FC\U0000200D\U0001F680": ":\u5973\u822a\u5929\u5458\u4e2d\u6d45\u80a4\u8272:",
    u"\U0001F469\U0001F3FD\U0000200D\U0001F680": ":\u5973\u5b87\u822a\u5458\u4e2d\u7b49\u80a4\u8272:",
    u"\U0001F6B4\U0001F3FF\U0000200D\U00002640": ":\u5973\u81ea\u884c\u8f66\u6df1\u8272\u80a4\u8272:",
    u"\U0001F6B4\U0001F3FB\U0000200D\U00002640": ":\u5973\u6027\u81ea\u884c\u8f66\u6d45\u80a4\u8272:",
    u"\U0001F6B4\U0001F3FE\U0000200D\U00002640": ":\u5973\u6027\u81ea\u884c\u8f66\u4e2d\u6df1\u8272\u80a4\u8272:",
    u"\U0001F6B4\U0001F3FC\U0000200D\U00002640": ":\u5973\u6027\u81ea\u884c\u8f66\u4e2d\u6d45\u80a4\u8272:",
    u"\U0001F6B4\U0001F3FD\U0000200D\U00002640": ":\u5973\u6027\u81ea\u884c\u8f66\u4e2d\u7b49\u80a4\u8272:",
    u"\U0001F6B4\U0000200D\U00002640": ":\u5973\u5b50\u81ea\u884c\u8f66:",
    u"\U0001F6B4\U0001F3FF\U0000200D\U00002640\U0000FE0F": ":\u5973\u81ea\u884c\u8f66\u6df1\u8272\u80a4\u8272:",
    u"\U0001F6B4\U0001F3FB\U0000200D\U00002640\U0000FE0F": ":\u5973\u6027\u81ea\u884c\u8f66\u6d45\u80a4\u8272:",
    u"\U0001F6B4\U0001F3FE\U0000200D\U00002640\U0000FE0F": ":\u5973\u6027\u81ea\u884c\u8f66\u4e2d\u6df1\u8272\u80a4\u8272:",
    u"\U0001F6B4\U0001F3FC\U0000200D\U00002640\U0000FE0F": ":\u5973\u6027\u81ea\u884c\u8f66\u4e2d\u6d45\u80a4\u8272:",
    u"\U0001F6B4\U0001F3FD\U0000200D\U00002640\U0000FE0F": ":\u5973\u6027\u81ea\u884c\u8f66\u4e2d\u7b49\u80a4\u8272:",
    u"\U0001F6B4\U0000200D\U00002640\U0000FE0F": ":\u5973\u5b50\u81ea\u884c\u8f66:",
    u"\U000026F9\U0001F3FF\U0000200D\U00002640": ":\u5973\u6027\u5f39\u8df3\u7403\u6df1\u8272\u80a4\u8272:",
    u"\U000026F9\U0001F3FB\U0000200D\U00002640": ":\u5973\u6027\u5f39\u8df3\u7403\u8f7b\u80a4\u8272:",
    u"\U000026F9\U0001F3FE\U0000200D\U00002640": ":\u5973\u6027\u5f39\u8df3\u7403\u4e2d\u6df1\u8272\u80a4\u8272:",
    u"\U000026F9\U0001F3FC\U0000200D\U00002640": ":\u5973\u6027\u5f39\u8df3\u7403\u4e2d\u6d45\u80a4\u8272:",
    u"\U000026F9\U0001F3FD\U0000200D\U00002640": ":\u5973\u6027\u5f39\u8df3\u7403\u4e2d\u7b49\u80a4\u8272:",
    u"\U000026F9\U0000200D\U00002640": ":\u5973\u5b50\u5f39\u7403:",
    u"\U000026F9\U0000FE0F\U0000200D\U00002640\U0000FE0F": ":\u5973\u5b50\u5f39\u7403:",
    u"\U000026F9\U0000200D\U00002640\U0000FE0F": ":\u5973\u5b50\u5f39\u7403:",
    u"\U000026F9\U0001F3FF\U0000200D\U00002640\U0000FE0F": ":\u5973\u6027\u5f39\u8df3\u7403\u6df1\u8272\u80a4\u8272:",
    u"\U000026F9\U0001F3FB\U0000200D\U00002640\U0000FE0F": ":\u5973\u6027\u5f39\u8df3\u7403\u8f7b\u80a4\u8272:",
    u"\U000026F9\U0001F3FE\U0000200D\U00002640\U0000FE0F": ":\u5973\u6027\u5f39\u8df3\u7403\u4e2d\u6df1\u8272\u80a4\u8272:",
    u"\U000026F9\U0001F3FC\U0000200D\U00002640\U0000FE0F": ":\u5973\u6027\u5f39\u8df3\u7403\u4e2d\u6d45\u80a4\u8272:",
    u"\U000026F9\U0001F3FD\U0000200D\U00002640\U0000FE0F": ":\u5973\u6027\u5f39\u8df3\u7403\u4e2d\u7b49\u80a4\u8272:",
    u"\U000026F9\U0000FE0F\U0000200D\U00002640": ":\u5973\u5b50\u5f39\u8df3\u7403:",
    u"\U0001F647\U0001F3FF\U0000200D\U00002640": ":\u5973\u6027\u5f13\u5f62\u6df1\u8272\u80a4\u8272:",
    u"\U0001F647\U0001F3FB\U0000200D\U00002640": ":\u5973\u6027\u5f13\u5f62\u6d45\u80a4\u8272:",
    u"\U0001F647\U0001F3FE\U0000200D\U00002640": ":\u5973\u6027\u5f13\u5f62\u4e2d\u6df1\u8272\u80a4\u8272:",
    u"\U0001F647\U0001F3FC\U0000200D\U00002640": ":\u5973\u6027\u5f13\u5f62\u4e2d\u6d45\u80a4\u8272:",
    u"\U0001F647\U0001F3FD\U0000200D\U00002640": ":\u5973\u6027\u5f13\u5f62\u4e2d\u7b49\u80a4\u8272:",
    u"\U0001F647\U0000200D\U00002640": ":\u5973\u4eba\u97a0\u8eac:",
    u"\U0001F647\U0001F3FF\U0000200D\U00002640\U0000FE0F": ":\u5973\u6027\u5f13\u5f62\u6df1\u8272\u80a4\u8272:",
    u"\U0001F647\U0001F3FB\U0000200D\U00002640\U0000FE0F": ":\u5973\u6027\u5f13\u5f62\u6d45\u80a4\u8272:",
    u"\U0001F647\U0001F3FE\U0000200D\U00002640\U0000FE0F": ":\u5973\u6027\u5f13\u5f62\u4e2d\u6df1\u8272\u80a4\u8272:",
    u"\U0001F647\U0001F3FC\U0000200D\U00002640\U0000FE0F": ":\u5973\u6027\u5f13\u5f62\u4e2d\u6d45\u80a4\u8272:",
    u"\U0001F647\U0001F3FD\U0000200D\U00002640\U0000FE0F": ":\u5973\u6027\u5f13\u5f62\u4e2d\u7b49\u80a4\u8272:",
    u"\U0001F647\U0000200D\U00002640\U0000FE0F": ":\u5973\u6027\u97a0\u8eac:",
    u"\U0001F938\U0001F3FF\U0000200D\U00002640": ":\u5973\u63a8\u8f66\u5f0f\u6df1\u8272\u80a4\u8272:",
    u"\U0001F938\U0001F3FB\U0000200D\U00002640": ":\u5973\u4eba\u8f7b\u80a4\u8272:",
    u"\U0001F938\U0001F3FE\U0000200D\U00002640": ":\u5973\u6027\u63a8\u8f66\u5f0f\u4e2d\u6df1\u8272\u80a4\u8272:",
    u"\U0001F938\U0001F3FC\U0000200D\U00002640": ":\u5973\u6027\u63a8\u8f66\u5f0f\u4e2d\u6d45\u80a4\u8272:",
    u"\U0001F938\U0001F3FD\U0000200D\U00002640": ":\u5973\u6027\u63a8\u8f66\u5f0f\u4e2d\u7b49\u80a4\u8272:",
    u"\U0001F938\U0000200D\U00002640": ":\u5987\u5973\u63a8\u8f66:",
    u"\U0001F938\U0001F3FF\U0000200D\U00002640\U0000FE0F": ":\u5973\u63a8\u8f66\u5f0f\u6df1\u8272\u80a4\u8272:",
    u"\U0001F938\U0001F3FB\U0000200D\U00002640\U0000FE0F": ":\u5973\u4eba\u8f7b\u80a4\u8272:",
    u"\U0001F938\U0001F3FE\U0000200D\U00002640\U0000FE0F": ":\u5973\u6027\u63a8\u8f66\u5f0f\u4e2d\u6df1\u8272\u80a4\u8272:",
    u"\U0001F938\U0001F3FC\U0000200D\U00002640\U0000FE0F": ":\u5973\u6027\u63a8\u8f66\u5f0f\u4e2d\u6d45\u80a4\u8272:",
    u"\U0001F938\U0001F3FD\U0000200D\U00002640\U0000FE0F": ":\u5973\u6027\u63a8\u8f66\u5f0f\u4e2d\u7b49\u80a4\u8272:",
    u"\U0001F938\U0000200D\U00002640\U0000FE0F": ":\u5987\u5973\u63a8\u8f66:",
    u"\U0001F9D7\U0001F3FF\U0000200D\U00002640": ":\u5973\u6027\u6500\u5ca9\u6df1\u8272\u80a4\u8272:",
    u"\U0001F9D7\U0001F3FB\U0000200D\U00002640": ":\u5973\u6027\u6500\u5ca9\u6d45\u80a4\u8272:",
    u"\U0001F9D7\U0001F3FE\U0000200D\U00002640": ":\u5973\u6027\u6500\u5ca9\u4e2d\u6df1\u8272\u80a4\u8272:",
    u"\U0001F9D7\U0001F3FC\U0000200D\U00002640": ":\u5973\u6027\u6500\u5ca9\u4e2d\u6d45\u80a4\u8272:",
    u"\U0001F9D7\U0001F3FD\U0000200D\U00002640": ":\u5973\u6027\u6500\u5ca9\u4e2d\u7b49\u80a4\u8272:",
    u"\U0001F9D7\U0000200D\U00002640": ":\u5973\u5b50\u6500\u5ca9:",
    u"\U0001F9D7\U0001F3FF\U0000200D\U00002640\U0000FE0F": ":\u5973\u6027\u6500\u5ca9\u6df1\u8272\u80a4\u8272:",
    u"\U0001F9D7\U0001F3FB\U0000200D\U00002640\U0000FE0F": ":\u5973\u6027\u6500\u5ca9\u6d45\u80a4\u8272:",
    u"\U0001F9D7\U0001F3FE\U0000200D\U00002640\U0000FE0F": ":\u5973\u6027\u6500\u5ca9\u4e2d\u6df1\u8272\u80a4\u8272:",
    u"\U0001F9D7\U0001F3FC\U0000200D\U00002640\U0000FE0F": ":\u5973\u6027\u6500\u5ca9\u4e2d\u6d45\u80a4\u8272:",
    u"\U0001F9D7\U0001F3FD\U0000200D\U00002640\U0000FE0F": ":\u5973\u6027\u6500\u5ca9\u4e2d\u7b49\u80a4\u8272:",
    u"\U0001F9D7\U0000200D\U00002640\U0000FE0F": ":\u5973\u5b50\u6500\u5ca9:",
    u"\U0001F477\U0001F3FF\U0000200D\U00002640": ":\u5973\u5efa\u7b51\u5de5\u4eba\u80a4\u8272\u6697\u6c89:",
    u"\U0001F477\U0001F3FB\U0000200D\U00002640": ":\u5973\u5efa\u7b51\u5de5\u4eba\u80a4\u8272\u6d45:",
    u"\U0001F477\U0001F3FE\U0000200D\U00002640": ":\u5973\u5efa\u7b51\u5de5\u4eba\u4e2d\u9ed1\u80a4\u8272:",
    u"\U0001F477\U0001F3FC\U0000200D\U00002640": ":\u5973\u5efa\u7b51\u5de5\u4eba\u4e2d\u6d45\u80a4\u8272:",
    u"\U0001F477\U0001F3FD\U0000200D\U00002640": ":\u5973\u5efa\u7b51\u5de5\u4eba\u4e2d\u7b49\u80a4\u8272:",
    u"\U0001F477\U0000200D\U00002640": ":\u5973\u5efa\u7b51\u5de5\u4eba:",
    u"\U0001F477\U0001F3FF\U0000200D\U00002640\U0000FE0F": ":\u5973\u5efa\u7b51\u5de5\u4eba\u80a4\u8272\u6697\u6c89:",
    u"\U0001F477\U0001F3FB\U0000200D\U00002640\U0000FE0F": ":\u5973\u5efa\u7b51\u5de5\u4eba\u80a4\u8272\u6d45:",
    u"\U0001F477\U0001F3FE\U0000200D\U00002640\U0000FE0F": ":\u5973\u5efa\u7b51\u5de5\u4eba\u4e2d\u9ed1\u80a4\u8272:",
    u"\U0001F477\U0001F3FC\U0000200D\U00002640\U0000FE0F": ":\u5973\u804c\u5de5\u80a4\u8272\u4e2d\u7b49\u504f\u6d45:",
    u"\U0001F477\U0001F3FD\U0000200D\U00002640\U0000FE0F": ":\u5973\u5efa\u7b51\u5de5\u4eba\u4e2d\u7b49\u80a4\u8272:",
    u"\U0001F477\U0000200D\U00002640\U0000FE0F": ":\u5973\u5efa\u7b51\u5de5\u4eba\u9009\u62e9:",
    u"\U0001F469\U0000200D\U0001F373": ":\u5973\u53a8\u5e08:",
    u"\U0001F469\U0001F3FF\U0000200D\U0001F373": ":\u5973\u53a8\u5e08\u6697\u80a4\u8272:",
    u"\U0001F469\U0001F3FB\U0000200D\U0001F373": ":\u5973\u53a8\u5e08\u6d45\u80a4\u8272:",
    u"\U0001F469\U0001F3FE\U0000200D\U0001F373": ":\u5973\u53a8\u5e08\u4e2d\u6df1\u8272\u80a4\u8272:",
    u"\U0001F469\U0001F3FC\U0000200D\U0001F373": ":\u5973\u53a8\u5e08\u4e2d\u6d45\u80a4\u8272:",
    u"\U0001F469\U0001F3FD\U0000200D\U0001F373": ":\u5973\u53a8\u5e08\u4e2d\u7b49\u80a4\u8272:",
    u"\U0001F483": ":\u8df3\u821e\u7684\u5973\u4eba:",
    u"\U0001F483\U0001F3FF": ":\u821e\u5973\u6697\u80a4\u8272:",
    u"\U0001F483\U0001F3FB": ":\u5973\u6027\u821e\u8e48\u6d45\u80a4\u8272:",
    u"\U0001F483\U0001F3FE": ":\u5973\u6027\u821e\u8e48\u4e2d\u6df1\u8272\u80a4\u8272:",
    u"\U0001F483\U0001F3FC": ":\u5973\u6027\u821e\u8e48\u4e2d\u6d45\u80a4\u8272:",
    u"\U0001F483\U0001F3FD": ":\u5973\u6027\u821e\u8e48\u4e2d\u7b49\u80a4\u8272:",
    u"\U0001F469\U0001F3FF": ":\u5973\u6027\u6697\u80a4\u8272:",
    u"\U0001F575\U0001F3FF\U0000200D\U00002640": ":\u5973\u4fa6\u63a2\u6df1\u8272\u80a4\u8272:",
    u"\U0001F575\U0001F3FB\U0000200D\U00002640": ":\u5973\u4fa6\u63a2\u6d45\u80a4\u8272:",
    u"\U0001F575\U0001F3FE\U0000200D\U00002640": ":\u5973\u4fa6\u63a2\u4e2d\u9ed1\u80a4\u8272:",
    u"\U0001F575\U0001F3FC\U0000200D\U00002640": ":\u5973\u4fa6\u63a2\u4e2d\u6d45\u80a4\u8272:",
    u"\U0001F575\U0001F3FD\U0000200D\U00002640": ":\u5973\u4fa6\u63a2\u4e2d\u7b49\u80a4\u8272:",
    u"\U0001F575\U0000200D\U00002640": ":\u5973\u4fa6\u63a2:",
    u"\U0001F575\U0000200D\U00002640\U0000FE0F": ":\u5973\u4fa6\u63a22:",
    u"\U0001F575\U0000FE0F\U0000200D\U00002640\U0000FE0F": ":\u5973\u4fa6\u63a2\u9009\u62e9:",
    u"\U0001F575\U0001F3FF\U0000200D\U00002640\U0000FE0F": ":\u5973\u4fa6\u63a2\u6df1\u8272\u80a4\u8272:",
    u"\U0001F575\U0001F3FB\U0000200D\U00002640\U0000FE0F": ":\u5973\u4fa6\u63a2\u6d45\u80a4\u8272:",
    u"\U0001F575\U0001F3FE\U0000200D\U00002640\U0000FE0F": ":\u5973\u4fa6\u63a2\u4e2d\u9ed1\u80a4\u8272:",
    u"\U0001F575\U0001F3FC\U0000200D\U00002640\U0000FE0F": ":\u5973\u4fa6\u63a2\u4e2d\u6d45\u80a4\u8272:",
    u"\U0001F575\U0001F3FD\U0000200D\U00002640\U0000FE0F": ":\u5973\u4fa6\u63a2\u4e2d\u7b49\u80a4\u8272:",
    u"\U0001F9DD\U0001F3FF\U0000200D\U00002640": ":\u5973\u7cbe\u7075\u6df1\u8272\u80a4\u8272:",
    u"\U0001F9DD\U0001F3FB\U0000200D\U00002640": ":\u5973\u7cbe\u7075\u6d45\u80a4\u8272:",
    u"\U0001F9DD\U0001F3FE\U0000200D\U00002640": ":\u5973\u7cbe\u7075\u4e2d\u6df1\u8272\u80a4\u8272:",
    u"\U0001F9DD\U0001F3FC\U0000200D\U00002640": ":\u5973\u7cbe\u7075\u4e2d\u6d45\u80a4\u8272:",
    u"\U0001F9DD\U0001F3FD\U0000200D\U00002640": ":\u5973\u7cbe\u7075\u4e2d\u7b49\u80a4\u8272:",
    u"\U0001F9DD\U0000200D\U00002640": ":\u5973\u7cbe\u7075:",
    u"\U0001F9DD\U0001F3FF\U0000200D\U00002640\U0000FE0F": ":\u5973\u7cbe\u7075\u6df1\u8272\u80a4\u8272:",
    u"\U0001F9DD\U0001F3FB\U0000200D\U00002640\U0000FE0F": ":\u5973\u7cbe\u7075\u6d45\u80a4\u8272:",
    u"\U0001F9DD\U0001F3FE\U0000200D\U00002640\U0000FE0F": ":\u5973\u7cbe\u7075\u4e2d\u6df1\u8272\u80a4\u8272:",
    u"\U0001F9DD\U0001F3FC\U0000200D\U00002640\U0000FE0F": ":\u5973\u7cbe\u7075\u4e2d\u6d45\u80a4\u8272:",
    u"\U0001F9DD\U0001F3FD\U0000200D\U00002640\U0000FE0F": ":\u5973\u7cbe\u7075\u4e2d\u7b49\u80a4\u8272:",
    u"\U0001F9DD\U0000200D\U00002640\U0000FE0F": ":\u5973\u7cbe\u7075:",
    u"\U0001F926\U0001F3FF\U0000200D\U00002640": ":\u5973\u6027\u638c\u5fc3\u6697\u80a4\u8272:",
    u"\U0001F926\U0001F3FB\U0000200D\U00002640": ":\u5973\u6027\u638c\u7eb9\u6d45\u80a4\u8272:",
    u"\U0001F926\U0001F3FE\U0000200D\U00002640": ":\u5973\u6027\u638c\u7eb9\u4e2d\u6df1\u8272\u80a4\u8272:",
    u"\U0001F926\U0001F3FC\U0000200D\U00002640": ":\u5973\u6027\u638c\u7eb9\u4e2d\u6d45\u80a4\u8272:",
    u"\U0001F926\U0001F3FD\U0000200D\U00002640": ":\u5973\u6027\u638c\u7eb9\u4e2d\u7b49\u80a4\u8272:",
    u"\U0001F926\U0000200D\U00002640": ":\u5973\u4eba\u638c\u5fc3:",
    u"\U0001F926\U0001F3FF\U0000200D\U00002640\U0000FE0F": ":\u5973\u6027\u638c\u5fc3\u6697\u80a4\u8272:",
    u"\U0001F926\U0001F3FB\U0000200D\U00002640\U0000FE0F": ":\u5973\u6027\u638c\u7eb9\u6d45\u80a4\u8272:",
    u"\U0001F926\U0001F3FE\U0000200D\U00002640\U0000FE0F": ":\u5973\u6027\u638c\u7eb9\u4e2d\u6df1\u8272\u80a4\u8272:",
    u"\U0001F926\U0001F3FC\U0000200D\U00002640\U0000FE0F": ":\u5973\u6027\u638c\u7eb9\u4e2d\u6d45\u80a4\u8272:",
    u"\U0001F926\U0001F3FD\U0000200D\U00002640\U0000FE0F": ":\u5973\u6027\u638c\u7eb9\u4e2d\u7b49\u80a4\u8272:",
    u"\U0001F926\U0000200D\U00002640\U0000FE0F": ":\u5973\u6027\u638c\u5fc3\u9009\u62e9:",
    u"\U0001F469\U0000200D\U0001F3ED": ":\u5de5\u5382\u5973\u5de5:",
    u"\U0001F469\U0001F3FF\U0000200D\U0001F3ED": ":\u5973\u5de5\u80a4\u8272\u6697\u6c89:",
    u"\U0001F469\U0001F3FB\U0000200D\U0001F3ED": ":\u5973\u5de5\u80a4\u8272\u6d45:",
    u"\U0001F469\U0001F3FE\U0000200D\U0001F3ED": ":\u5973\u5de5\u4e2d\u6df1\u8272\u80a4\u8272:",
    u"\U0001F469\U0001F3FC\U0000200D\U0001F3ED": ":\u5973\u5de5\u4e2d\u6d45\u80a4\u8272:",
    u"\U0001F469\U0001F3FD\U0000200D\U0001F3ED": ":\u5973\u5de5\u4e2d\u80a4\u8272:",
    u"\U0001F9DA\U0001F3FF\U0000200D\U00002640": ":\u5973\u4ed9\u5b50\u6697\u80a4\u8272:",
    u"\U0001F9DA\U0001F3FB\U0000200D\U00002640": ":\u5973\u4ed9\u5b50\u6d45\u80a4\u8272:",
    u"\U0001F9DA\U0001F3FE\U0000200D\U00002640": ":\u5973\u4ed9\u5b50\u4e2d\u6df1\u8272\u80a4\u8272:",
    u"\U0001F9DA\U0001F3FC\U0000200D\U00002640": ":\u5973\u4ed9\u5b50\u4e2d\u6d45\u80a4\u8272:",
    u"\U0001F9DA\U0001F3FD\U0000200D\U00002640": ":\u5973\u4ed9\u5b50\u4e2d\u7b49\u80a4\u8272:",
    u"\U0001F9DA\U0000200D\U00002640": ":\u5973\u4ed9\u5b50:",
    u"\U0001F9DA\U0001F3FF\U0000200D\U00002640\U0000FE0F": ":\u5973\u4ed9\u5b50\u6697\u80a4\u8272:",
    u"\U0001F9DA\U0001F3FB\U0000200D\U00002640\U0000FE0F": ":\u5973\u4ed9\u5b50\u6d45\u80a4\u8272:",
    u"\U0001F9DA\U0001F3FE\U0000200D\U00002640\U0000FE0F": ":\u5973\u6027\u80a4\u8272\u4e2d\u6697\u8272\u4ed9\u5973:",
    u"\U0001F9DA\U0001F3FC\U0000200D\U00002640\U0000FE0F": ":\u5973\u4ed9\u5b50\u4e2d\u6d45\u80a4\u8272:",
    u"\U0001F9DA\U0001F3FD\U0000200D\U00002640\U0000FE0F": ":\u5973\u4ed9\u5b50\u4e2d\u7b49\u80a4\u8272:",
    u"\U0001F9DA\U0000200D\U00002640\U0000FE0F": ":\u5973\u4ed9\u5973:",
    u"\U0001F469\U0000200D\U0001F33E": ":\u5973\u519c\u6c11:",
    u"\U0001F469\U0001F3FF\U0000200D\U0001F33E": ":\u5973\u519c\u6c11\u80a4\u8272\u6697\u6c89:",
    u"\U0001F469\U0001F3FB\U0000200D\U0001F33E": ":\u5973\u519c\u6c11\u80a4\u8272\u6d45:",
    u"\U0001F469\U0001F3FE\U0000200D\U0001F33E": ":\u5973\u519c\u6c11\u4e2d\u6df1\u8272\u80a4\u8272:",
    u"\U0001F469\U0001F3FC\U0000200D\U0001F33E": ":\u5973\u519c\u592b\u4e2d\u6d45\u80a4\u8272:",
    u"\U0001F469\U0001F3FD\U0000200D\U0001F33E": ":\u5973\u519c\u6c11\u4e2d\u7b49\u80a4\u8272:",
    u"\U0001F469\U0000200D\U0001F692": ":\u5973\u6d88\u9632\u5458:",
    u"\U0001F469\U0001F3FF\U0000200D\U0001F692": ":\u5973\u6d88\u9632\u5458\u6df1\u8272\u80a4\u8272:",
    u"\U0001F469\U0001F3FB\U0000200D\U0001F692": ":\u5973\u6d88\u9632\u5458\u6d45\u80a4\u8272:",
    u"\U0001F469\U0001F3FE\U0000200D\U0001F692": ":\u5973\u6d88\u9632\u5458\u4e2d\u6df1\u8272\u80a4\u8272:",
    u"\U0001F469\U0001F3FC\U0000200D\U0001F692": ":\u5973\u6d88\u9632\u5458\u4e2d\u6d45\u80a4\u8272:",
    u"\U0001F469\U0001F3FD\U0000200D\U0001F692": ":\u5973\u6d88\u9632\u5458\u4e2d\u7b49\u80a4\u8272:",
    u"\U0001F64D\U0001F3FF\U0000200D\U00002640": ":\u5973\u4eba\u76b1\u7740\u7709\u5934\uff0c\u76ae\u80a4\u9edd\u9ed1:",
    u"\U0001F64D\U0001F3FB\U0000200D\U00002640": ":\u5973\u4eba\u76b1\u7709\u6d45\u80a4\u8272:",
    u"\U0001F64D\U0001F3FE\U0000200D\U00002640": ":\u4e2d\u7b49\u80a4\u8272\u6df1\u76b1:",
    u"\U0001F64D\U0001F3FC\U0000200D\U00002640": ":\u5973\u6027\u76b1\u7709\u4e2d\u6d45\u80a4\u8272:",
    u"\U0001F64D\U0001F3FD\U0000200D\U00002640": ":\u5973\u6027\u76b1\u7709\u4e2d\u7b49\u80a4\u8272:",
    u"\U0001F64D\U0000200D\U00002640": ":\u76b1\u7709\u7684\u5973\u4eba:",
    u"\U0001F64D\U0001F3FF\U0000200D\U00002640\U0000FE0F": ":\u5973\u4eba\u76b1\u7740\u7709\u5934\uff0c\u76ae\u80a4\u9edd\u9ed1:",
    u"\U0001F64D\U0001F3FB\U0000200D\U00002640\U0000FE0F": ":\u5973\u4eba\u76b1\u7709\u6d45\u80a4\u8272:",
    u"\U0001F64D\U0001F3FE\U0000200D\U00002640\U0000FE0F": ":\u5973\u6027\u76b1\u7709\u4e2d\u6df1\u8272\u80a4\u8272:",
    u"\U0001F64D\U0001F3FC\U0000200D\U00002640\U0000FE0F": ":\u5973\u6027\u76b1\u7709\u4e2d\u6d45\u80a4\u8272:",
    u"\U0001F64D\U0001F3FD\U0000200D\U00002640\U0000FE0F": ":\u5973\u6027\u76b1\u7709\u4e2d\u7b49\u80a4\u8272:",
    u"\U0001F64D\U0000200D\U00002640\U0000FE0F": ":\u5973\u4eba\u76b1\u7709:",
    u"\U0001F9DE\U0000200D\U00002640": ":\u5973\u5996:",
    u"\U0001F9DE\U0000200D\U00002640\U0000FE0F": ":\u5973\u7cbe\u7075:",
    u"\U0001F645\U0001F3FF\U0000200D\U00002640": ":\u4e00\u4e2a\u6ca1\u6709\u6df1\u8272\u80a4\u8272\u7684\u5973\u4eba:",
    u"\U0001F645\U0001F3FB\U0000200D\U00002640": ":\u4e00\u4e2a\u6ca1\u6709\u80a4\u8272\u7684\u5973\u4eba:",
    u"\U0001F645\U0001F3FE\U0000200D\U00002640": ":\u4e00\u4e2a\u6ca1\u6709\u4e2d\u7b49\u80a4\u8272\u7684\u5973\u4eba:",
    u"\U0001F645\U0001F3FC\U0000200D\U00002640": ":\u4e00\u4e2a\u6ca1\u6709\u4e2d\u7b49\u80a4\u8272\u7684\u5973\u4eba:",
    u"\U0001F645\U0001F3FD\U0000200D\U00002640": ":\u6ca1\u6709\u4e2d\u7b49\u80a4\u8272\u7684\u5973\u4eba:",
    u"\U0001F645\U0000200D\U00002640": ":\u5973\u4eba\u6253\u624b\u52bf\u8bf4\u4e0d:",
    u"\U0001F645\U0001F3FF\U0000200D\U00002640\U0000FE0F": ":\u4e00\u4e2a\u6ca1\u6709\u6df1\u8272\u80a4\u8272\u7684\u5973\u4eba:",
    u"\U0001F645\U0001F3FB\U0000200D\U00002640\U0000FE0F": ":\u4e00\u4e2a\u6ca1\u6709\u80a4\u8272\u7684\u5973\u4eba:",
    u"\U0001F645\U0001F3FE\U0000200D\U00002640\U0000FE0F": ":\u4e00\u4e2a\u6ca1\u6709\u4e2d\u7b49\u80a4\u8272\u7684\u5973\u4eba:",
    u"\U0001F645\U0001F3FC\U0000200D\U00002640\U0000FE0F": ":\u4e00\u4e2a\u6ca1\u6709\u4e2d\u7b49\u80a4\u8272\u7684\u5973\u4eba:",
    u"\U0001F645\U0001F3FD\U0000200D\U00002640\U0000FE0F": ":\u6ca1\u6709\u4e2d\u7b49\u80a4\u8272\u7684\u5973\u4eba:",
    u"\U0001F645\U0000200D\U00002640\U0000FE0F": ":\u5973\u4eba\u6253\u624b\u52bf\u4e0d\u9009:",
    u"\U0001F646\U0001F3FF\U0000200D\U00002640": ":\u5973\u4eba\u505a\u624b\u52bf\u53ef\u4ee5\u6df1\u80a4\u8272:",
    u"\U0001F646\U0001F3FB\U0000200D\U00002640": ":\u5973\u58eb\u6253\u624b\u52bf\u53ef\u4ee5\u6de1\u80a4\u8272:",
    u"\U0001F646\U0001F3FE\U0000200D\U00002640": ":\u5973\u6027\u624b\u52bfOK\u4e2d\u6df1\u8272\u80a4\u8272:",
    u"\U0001F646\U0001F3FC\U0000200D\U00002640": ":\u5973\u6027\u624b\u52bfOK\u4e2d\u6d45\u80a4\u8272:",
    u"\U0001F646\U0001F3FD\U0000200D\U00002640": ":\u5973\u6027\u624b\u52bfOK\u4e2d\u7b49\u80a4\u8272:",
    u"\U0001F646\U0000200D\U00002640": ":\u5973\u4eba\u505a\u624b\u52bf\u597d\u5417:",
    u"\U0001F646\U0001F3FF\U0000200D\U00002640\U0000FE0F": ":\u5973\u4eba\u505a\u624b\u52bf\u53ef\u4ee5\u6df1\u80a4\u8272:",
    u"\U0001F646\U0001F3FB\U0000200D\U00002640\U0000FE0F": ":\u5973\u58eb\u6253\u624b\u52bf\u53ef\u4ee5\u6de1\u80a4\u8272:",
    u"\U0001F646\U0001F3FE\U0000200D\U00002640\U0000FE0F": ":\u5973\u6027\u624b\u52bfOK\u4e2d\u6df1\u8272\u80a4\u8272:",
    u"\U0001F646\U0001F3FC\U0000200D\U00002640\U0000FE0F": ":\u5973\u6027\u624b\u52bfOK\u4e2d\u6d45\u80a4\u8272:",
    u"\U0001F646\U0001F3FD\U0000200D\U00002640\U0000FE0F": ":\u5973\u6027\u624b\u52bfOK\u4e2d\u7b49\u80a4\u8272:",
    u"\U0001F646\U0000200D\U00002640\U0000FE0F": ":\u5973\u4eba\u505a\u624b\u52bf\u201c\u597d\u201d:",
    u"\U0001F487\U0001F3FF\U0000200D\U00002640": ":\u5973\u7406\u53d1\u5e08\u80a4\u8272\u9edd\u9ed1:",
    u"\U0001F487\U0001F3FB\U0000200D\U00002640": ":\u7406\u53d1\u7684\u5973\u4eba\u80a4\u8272\u6d45:",
    u"\U0001F487\U0001F3FE\U0000200D\U00002640": ":\u526a\u5934\u53d1\u7684\u5973\u4eba\u80a4\u8272\u4e2d\u7b49\u504f\u9ed1:",
    u"\U0001F487\U0001F3FC\U0000200D\U00002640": ":\u526a\u5934\u53d1\u7684\u5973\u4eba\u4e2d\u6d45\u80a4\u8272:",
    u"\U0001F487\U0001F3FD\U0000200D\U00002640": ":\u5973\u6027\u7406\u53d1\u4e2d\u7b49\u80a4\u8272:",
    u"\U0001F487\U0000200D\U00002640": ":\u7406\u53d1\u7684\u5973\u4eba:",
    u"\U0001F487\U0001F3FF\U0000200D\U00002640\U0000FE0F": ":\u5973\u7406\u53d1\u5e08\u80a4\u8272\u9edd\u9ed1:",
    u"\U0001F487\U0001F3FB\U0000200D\U00002640\U0000FE0F": ":\u7406\u53d1\u7684\u5973\u4eba\u80a4\u8272\u6d45:",
    u"\U0001F487\U0001F3FE\U0000200D\U00002640\U0000FE0F": ":\u526a\u5934\u53d1\u7684\u5973\u4eba\u80a4\u8272\u4e2d\u7b49\u504f\u9ed1:",
    u"\U0001F487\U0001F3FC\U0000200D\U00002640\U0000FE0F": ":\u526a\u5934\u53d1\u7684\u5973\u4eba\u4e2d\u6d45\u80a4\u8272:",
    u"\U0001F487\U0001F3FD\U0000200D\U00002640\U0000FE0F": ":\u5973\u6027\u7406\u53d1\u4e2d\u7b49\u80a4\u8272:",
    u"\U0001F487\U0000200D\U00002640\U0000FE0F": ":\u5973\u7406\u53d1\u5e08:",
    u"\U0001F486\U0001F3FF\U0000200D\U00002640": ":\u5973\u6309\u6469\u5e08\u80a4\u8272\u6697\u6c89:",
    u"\U0001F486\U0001F3FB\U0000200D\U00002640": ":\u6309\u6469\u5973\u6027\u6d45\u80a4\u8272:",
    u"\U0001F486\U0001F3FE\U0000200D\U00002640": ":\u5973\u6027\u6309\u6469\u4e2d\u6df1\u8272\u80a4\u8272:",
    u"\U0001F486\U0001F3FC\U0000200D\U00002640": ":\u5973\u6027\u6309\u6469\u4e2d\u6d45\u80a4\u8272:",
    u"\U0001F486\U0001F3FD\U0000200D\U00002640": ":\u5973\u6027\u6309\u6469\u4e2d\u80a4\u8272:",
    u"\U0001F486\U0000200D\U00002640": ":\u6309\u6469\u7684\u5973\u4eba:",
    u"\U0001F486\U0001F3FF\U0000200D\U00002640\U0000FE0F": ":\u76ae\u80a4\u6697\u8272\u6309\u6469:",
    u"\U0001F486\U0001F3FB\U0000200D\U00002640\U0000FE0F": ":\u6309\u6469\u5973\u6027\u6d45\u80a4\u8272:",
    u"\U0001F486\U0001F3FE\U0000200D\U00002640\U0000FE0F": ":\u5973\u6027\u6309\u6469\u4e2d\u6df1\u8272\u80a4\u8272:",
    u"\U0001F486\U0001F3FC\U0000200D\U00002640\U0000FE0F": ":\u5973\u6027\u6309\u6469\u4e2d\u6d45\u80a4\u8272:",
    u"\U0001F486\U0001F3FD\U0000200D\U00002640\U0000FE0F": ":\u5973\u6027\u6309\u6469\u4e2d\u80a4\u8272:",
    u"\U0001F486\U0000200D\U00002640\U0000FE0F": ":\u5973\u6309\u6469\u5e08:",
    u"\U0001F3CC\U0001F3FF\U0000200D\U00002640": ":\u5973\u5b50\u9ad8\u5c14\u592b\u6df1\u8272\u80a4\u8272:",
    u"\U0001F3CC\U0001F3FB\U0000200D\U00002640": ":\u5973\u5b50\u9ad8\u5c14\u592b\u6d45\u80a4\u8272:",
    u"\U0001F3CC\U0001F3FE\U0000200D\U00002640": ":\u5973\u5b50\u9ad8\u5c14\u592b\u4e2d\u6df1\u8272\u80a4\u8272:",
    u"\U0001F3CC\U0001F3FC\U0000200D\U00002640": ":\u5973\u5b50\u9ad8\u5c14\u592b\u4e2d\u6d45\u80a4\u8272:",
    u"\U0001F3CC\U0001F3FD\U0000200D\U00002640": ":\u5973\u5b50\u9ad8\u5c14\u592b\u4e2d\u7b49\u80a4\u8272:",
    u"\U0001F3CC\U0000200D\U00002640": ":\u5973\u5b50\u9ad8\u5c14\u592b:",
    u"\U0001F3CC\U0000FE0F\U0000200D\U00002640\U0000FE0F": ":\u5973\u5b50\u9ad8\u5c14\u592b:",
    u"\U0001F3CC\U0000200D\U00002640\U0000FE0F": ":\u5973\u5b50\u9ad8\u5c14\u592b:",
    u"\U0001F3CC\U0001F3FF\U0000200D\U00002640\U0000FE0F": ":\u5973\u5b50\u9ad8\u5c14\u592b\u6df1\u8272\u80a4\u8272:",
    u"\U0001F3CC\U0001F3FB\U0000200D\U00002640\U0000FE0F": ":\u5973\u5b50\u9ad8\u5c14\u592b\u6d45\u80a4\u8272:",
    u"\U0001F3CC\U0001F3FE\U0000200D\U00002640\U0000FE0F": ":\u5973\u5b50\u9ad8\u5c14\u592b\u4e2d\u6df1\u8272\u80a4\u8272:",
    u"\U0001F3CC\U0001F3FC\U0000200D\U00002640\U0000FE0F": ":\u5973\u5b50\u9ad8\u5c14\u592b\u4e2d\u6d45\u80a4\u8272:",
    u"\U0001F3CC\U0001F3FD\U0000200D\U00002640\U0000FE0F": ":\u5973\u5b50\u9ad8\u5c14\u592b\u4e2d\u7b49\u80a4\u8272:",
    u"\U0001F3CC\U0000FE0F\U0000200D\U00002640": ":\u5973\u5b50\u9ad8\u5c14\u592b:",
    u"\U0001F482\U0001F3FF\U0000200D\U00002640": ":\u5973\u536b\u6697\u80a4\u8272:",
    u"\U0001F482\U0001F3FB\U0000200D\U00002640": ":\u5973\u536b\u58eb\u6d45\u80a4\u8272:",
    u"\U0001F482\U0001F3FE\U0000200D\U00002640": ":\u5973\u536b\u58eb\u4e2d\u6df1\u8272\u80a4\u8272:",
    u"\U0001F482\U0001F3FC\U0000200D\U00002640": ":\u5973\u536b\u58eb\u4e2d\u6d45\u80a4\u8272:",
    u"\U0001F482\U0001F3FD\U0000200D\U00002640": ":\u5973\u536b\u58eb\u4e2d\u7b49\u80a4\u8272:",
    u"\U0001F482\U0000200D\U00002640": ":\u5973\u536b\u5175:",
    u"\U0001F482\U0001F3FF\U0000200D\U00002640\U0000FE0F": ":\u5973\u536b\u6697\u80a4\u8272:",
    u"\U0001F482\U0001F3FB\U0000200D\U00002640\U0000FE0F": ":\u5973\u536b\u58eb\u6d45\u80a4\u8272:",
    u"\U0001F482\U0001F3FE\U0000200D\U00002640\U0000FE0F": ":\u5973\u536b\u58eb\u4e2d\u6df1\u8272\u80a4\u8272:",
    u"\U0001F482\U0001F3FC\U0000200D\U00002640\U0000FE0F": ":\u5973\u536b\u58eb\u4e2d\u6d45\u80a4\u8272:",
    u"\U0001F482\U0001F3FD\U0000200D\U00002640\U0000FE0F": ":\u5973\u536b\u58eb\u4e2d\u7b49\u80a4\u8272:",
    u"\U0001F482\U0000200D\U00002640\U0000FE0F": ":\u5973\u8b66\u536b:",
    u"\U0001F469\U0001F3FF\U0000200D\U00002695": ":\u5973\u536b\u751f\u5458\u80a4\u8272\u6697\u6c89:",
    u"\U0001F469\U0001F3FB\U0000200D\U00002695": ":\u5973\u536b\u751f\u5458\u6d45\u80a4\u8272:",
    u"\U0001F469\U0001F3FE\U0000200D\U00002695": ":\u5973\u536b\u751f\u5458\u4e2d\u9ed1\u80a4\u8272:",
    u"\U0001F469\U0001F3FC\U0000200D\U00002695": ":\u5973\u536b\u751f\u5458\u4e2d\u6d45\u80a4\u8272:",
    u"\U0001F469\U0001F3FD\U0000200D\U00002695": ":\u5973\u536b\u751f\u5458\u4e2d\u7b49\u80a4\u8272:",
    u"\U0001F469\U0000200D\U00002695": ":\u5973\u536b\u751f\u5458:",
    u"\U0001F469\U0001F3FF\U0000200D\U00002695\U0000FE0F": ":\u5973\u536b\u751f\u5458\u80a4\u8272\u6697\u6c89:",
    u"\U0001F469\U0001F3FB\U0000200D\U00002695\U0000FE0F": ":\u5973\u536b\u751f\u5458\u6d45\u80a4\u8272:",
    u"\U0001F469\U0001F3FE\U0000200D\U00002695\U0000FE0F": ":\u5973\u536b\u751f\u5458\u4e2d\u9ed1\u80a4\u8272:",
    u"\U0001F469\U0001F3FC\U0000200D\U00002695\U0000FE0F": ":\u5973\u536b\u751f\u5458\u4e2d\u6d45\u80a4\u8272:",
    u"\U0001F469\U0001F3FD\U0000200D\U00002695\U0000FE0F": ":\u5973\u536b\u751f\u5458\u4e2d\u7b49\u80a4\u8272:",
    u"\U0001F469\U0000200D\U00002695\U0000FE0F": ":\u5973\u536b\u751f\u5de5\u4f5c\u8005\u9009\u62e9:",
    u"\U0001F9D8\U0001F3FF\U0000200D\U00002640": ":\u8377\u82b1\u4f4d\u5973\u6027\u80a4\u8272\u6697\u6c89:",
    u"\U0001F9D8\U0001F3FB\U0000200D\U00002640": ":\u8377\u82b1\u4f4d\u5973\u6027\u6d45\u80a4\u8272:",
    u"\U0001F9D8\U0001F3FE\U0000200D\U00002640": ":\u8377\u82b1\u4f4d\u5973\u6027\u4e2d\u6df1\u8272\u80a4\u8272:",
    u"\U0001F9D8\U0001F3FC\U0000200D\U00002640": ":\u8377\u82b1\u4f4d\u5973\u6027\u4e2d\u6d45\u80a4\u8272:",
    u"\U0001F9D8\U0001F3FD\U0000200D\U00002640": ":\u8377\u82b1\u4f4d\u5973\u6027\u4e2d\u7b49\u80a4\u8272:",
    u"\U0001F9D8\U0000200D\U00002640": ":\u83b2\u82b1\u4f4d\u5973\u5b50:",
    u"\U0001F9D8\U0001F3FF\U0000200D\U00002640\U0000FE0F": ":\u8377\u82b1\u4f4d\u5973\u6027\u80a4\u8272\u6697\u6c89:",
    u"\U0001F9D8\U0001F3FB\U0000200D\U00002640\U0000FE0F": ":\u8377\u82b1\u4f4d\u5973\u6027\u6d45\u80a4\u8272:",
    u"\U0001F9D8\U0001F3FE\U0000200D\U00002640\U0000FE0F": ":\u8377\u82b1\u4f4d\u5973\u6027\u4e2d\u6df1\u8272\u80a4\u8272:",
    u"\U0001F9D8\U0001F3FC\U0000200D\U00002640\U0000FE0F": ":\u8377\u82b1\u4f4d\u5973\u6027\u4e2d\u6d45\u80a4\u8272:",
    u"\U0001F9D8\U0001F3FD\U0000200D\U00002640\U0000FE0F": ":\u8377\u82b1\u4f4d\u5973\u6027\u4e2d\u7b49\u80a4\u8272:",
    u"\U0001F9D8\U0000200D\U00002640\U0000FE0F": ":\u83b2\u82b1\u5973\u9009\u4f4d\u5668:",
    u"\U0001F469\U0001F3FF\U0000200D\U0001F9BD": ":\u5750\u624b\u52a8\u8f6e\u6905\u7684\u5973\u4eba\u80a4\u8272\u9edd\u9ed1:",
    u"\U0001F469\U0001F3FB\U0000200D\U0001F9BD": ":\u5750\u624b\u52a8\u8f6e\u6905\u7684\u5973\u4eba\u80a4\u8272\u6d45:",
    u"\U0001F469\U0001F3FE\U0000200D\U0001F9BD": ":\u5750\u624b\u52a8\u8f6e\u6905\u7684\u5973\u6027-\u4e2d\u6df1\u8272\u80a4\u8272:",
    u"\U0001F469\U0001F3FC\U0000200D\U0001F9BD": ":\u5750\u624b\u52a8\u8f6e\u6905\u7684\u5973\u6027-\u6d45\u80a4\u8272:",
    u"\U0001F469\U0001F3FD\U0000200D\U0001F9BD": ":\u5750\u624b\u52a8\u8f6e\u6905\u7684\u5973\u6027\u4e2d\u7b49\u80a4\u8272:",
    u"\U0001F469\U0000200D\U0001F9BD": ":\u5750\u624b\u52a8\u8f6e\u6905\u7684\u5987\u5973:",
    u"\U0001F469\U0001F3FF\U0000200D\U0001F9BC": ":\u5750\u5728\u7535\u52a8\u8f6e\u6905\u4e0a\u7684\u5973\u4eba\u80a4\u8272\u9edd\u9ed1:",
    u"\U0001F469\U0001F3FB\U0000200D\U0001F9BC": ":\u5750\u673a\u52a8\u8f6e\u6905\u7684\u5973\u4eba\u80a4\u8272\u6d45:",
    u"\U0001F469\U0001F3FE\U0000200D\U0001F9BC": ":\u5750\u673a\u52a8\u8f6e\u6905\u7684\u5973\u6027\u80a4\u8272\u4e2d\u6df1\u8272:",
    u"\U0001F469\U0001F3FC\U0000200D\U0001F9BC": ":\u5750\u673a\u52a8\u8f6e\u6905\u7684\u5973\u6027\u4e2d\u7b49\u80a4\u8272:",
    u"\U0001F469\U0001F3FD\U0000200D\U0001F9BC": ":\u5750\u673a\u52a8\u8f6e\u6905\u7684\u5973\u6027\u4e2d\u7b49\u80a4\u8272:",
    u"\U0001F469\U0000200D\U0001F9BC": ":\u5750\u7535\u52a8\u8f6e\u6905\u7684\u5987\u5973:",
    u"\U0001F9D6\U0001F3FF\U0000200D\U00002640": ":\u84b8\u6c7d\u623f\u91cc\u7684\u5973\u4eba\u76ae\u80a4\u9edd\u9ed1:",
    u"\U0001F9D6\U0001F3FB\U0000200D\U00002640": ":\u84b8\u6c7d\u623f\u5973\u4eba\u80a4\u8272\u6d45:",
    u"\U0001F9D6\U0001F3FE\U0000200D\U00002640": ":\u84b8\u6c7d\u623f\u91cc\u7684\u5973\u4eba\u80a4\u8272\u4e2d\u7b49\u504f\u9ed1:",
    u"\U0001F9D6\U0001F3FC\U0000200D\U00002640": ":\u84b8\u6c7d\u623f\u91cc\u7684\u5973\u4eba\uff0c\u4e2d\u7b49\u6d45\u80a4\u8272:",
    u"\U0001F9D6\U0001F3FD\U0000200D\U00002640": ":\u84b8\u6c7d\u623f\u91cc\u7684\u5973\u4eba\u4e2d\u7b49\u80a4\u8272:",
    u"\U0001F9D6\U0000200D\U00002640": ":\u84b8\u6c7d\u623f\u91cc\u7684\u5973\u4eba:",
    u"\U0001F9D6\U0001F3FF\U0000200D\U00002640\U0000FE0F": ":\u84b8\u6c7d\u623f\u91cc\u7684\u5973\u4eba\u76ae\u80a4\u9edd\u9ed1:",
    u"\U0001F9D6\U0001F3FB\U0000200D\U00002640\U0000FE0F": ":\u84b8\u6c7d\u623f\u5973\u4eba\u80a4\u8272\u6d45:",
    u"\U0001F9D6\U0001F3FE\U0000200D\U00002640\U0000FE0F": ":\u84b8\u6c7d\u623f\u91cc\u7684\u5973\u4eba\u80a4\u8272\u4e2d\u7b49\u504f\u9ed1:",
    u"\U0001F9D6\U0001F3FC\U0000200D\U00002640\U0000FE0F": ":\u84b8\u6c7d\u623f\u91cc\u7684\u5973\u4eba\uff0c\u4e2d\u7b49\u6d45\u80a4\u8272:",
    u"\U0001F9D6\U0001F3FD\U0000200D\U00002640\U0000FE0F": ":\u84b8\u6c7d\u623f\u91cc\u7684\u5973\u4eba\u4e2d\u7b49\u80a4\u8272:",
    u"\U0001F9D6\U0000200D\U00002640\U0000FE0F": ":\u5973\u4eba\u5728\u84b8\u6c7d\u623f:",
    u"\U0001F469\U0001F3FF\U0000200D\U00002696": ":\u5973\u6027\u5224\u65ad\u80a4\u8272\u6697\u6c89:",
    u"\U0001F469\U0001F3FB\U0000200D\U00002696": ":\u5973\u6027\u5224\u65ad\u6d45\u80a4\u8272:",
    u"\U0001F469\U0001F3FE\U0000200D\U00002696": ":\u5973\u6027\u5224\u65ad\u4e2d\u6df1\u8272\u80a4\u8272:",
    u"\U0001F469\U0001F3FC\U0000200D\U00002696": ":\u5973\u6027\u5224\u65ad\u4e2d\u6d45\u80a4\u8272:",
    u"\U0001F469\U0001F3FD\U0000200D\U00002696": ":\u5973\u6027\u5224\u65ad\u4e2d\u7b49\u80a4\u8272:",
    u"\U0001F469\U0000200D\U00002696": ":\u5973\u6cd5\u5b98:",
    u"\U0001F469\U0001F3FF\U0000200D\U00002696\U0000FE0F": ":\u5973\u6027\u5224\u65ad\u80a4\u8272\u6697\u6c89:",
    u"\U0001F469\U0001F3FB\U0000200D\U00002696\U0000FE0F": ":\u5973\u6027\u5224\u65ad\u6d45\u80a4\u8272:",
    u"\U0001F469\U0001F3FE\U0000200D\U00002696\U0000FE0F": ":\u5973\u6027\u5224\u65ad\u4e2d\u6df1\u8272\u80a4\u8272:",
    u"\U0001F469\U0001F3FC\U0000200D\U00002696\U0000FE0F": ":\u5973\u6027\u5224\u65ad\u4e2d\u6d45\u80a4\u8272:",
    u"\U0001F469\U0001F3FD\U0000200D\U00002696\U0000FE0F": ":\u5973\u6027\u5224\u65ad\u4e2d\u7b49\u80a4\u8272:",
    u"\U0001F469\U0000200D\U00002696\U0000FE0F": ":\u5973\u6cd5\u5b98\u9009\u62e9:",
    u"\U0001F939\U0001F3FF\U0000200D\U00002640": ":\u5973\u6027\u53d8\u9ed1\u80a4\u8272:",
    u"\U0001F939\U0001F3FB\U0000200D\U00002640": ":\u5973\u6027\u53d8\u6d45\u80a4\u8272:",
    u"\U0001F939\U0001F3FE\U0000200D\U00002640": ":\u4e2d\u9ed1\u80a4\u8272\u7684\u5973\u4eba:",
    u"\U0001F939\U0001F3FC\U0000200D\U00002640": ":\u4e2d\u6d45\u80a4\u8272\u5973\u6027:",
    u"\U0001F939\U0001F3FD\U0000200D\U00002640": ":\u4e2d\u7b49\u80a4\u8272\u7684\u5973\u4eba:",
    u"\U0001F939\U0000200D\U00002640": ":\u5973\u6742\u800d:",
    u"\U0001F939\U0001F3FF\U0000200D\U00002640\U0000FE0F": ":\u5973\u6027\u53d8\u9ed1\u80a4\u8272:",
    u"\U0001F939\U0001F3FB\U0000200D\U00002640\U0000FE0F": ":\u5973\u6027\u53d8\u6d45\u80a4\u8272:",
    u"\U0001F939\U0001F3FE\U0000200D\U00002640\U0000FE0F": ":\u4e2d\u9ed1\u80a4\u8272\u7684\u5973\u4eba:",
    u"\U0001F939\U0001F3FC\U0000200D\U00002640\U0000FE0F": ":\u4e2d\u6d45\u80a4\u8272\u5973\u6027:",
    u"\U0001F939\U0001F3FD\U0000200D\U00002640\U0000FE0F": ":\u4e2d\u7b49\u80a4\u8272\u7684\u5973\u4eba:",
    u"\U0001F939\U0000200D\U00002640\U0000FE0F": ":\u5973\u9009\u89d2\u6742\u800d:",
    u"\U0001F9CE\U0001F3FF\U0000200D\U00002640": ":\u5973\u6027\u8dea\u4e0b\u80a4\u8272\u9edd\u9ed1:",
    u"\U0001F9CE\U0001F3FF\U0000200D\U00002640\U0000FE0F": ":\u5973\u6027\u8dea\u4e0b\u6df1\u8272\u80a4\u8272:",
    u"\U0001F9CE\U0001F3FB\U0000200D\U00002640": ":\u5973\u4eba\u8dea\u7740\u6d45\u80a4\u8272:",
    u"\U0001F9CE\U0001F3FB\U0000200D\U00002640\U0000FE0F": ":\u5973\u6027\u8dea\u5f0f\u6d45\u80a4\u8272:",
    u"\U0001F9CE\U0001F3FE\U0000200D\U00002640": ":\u5973\u6027\u8dea\u7740\uff0c\u80a4\u8272\u504f\u6697:",
    u"\U0001F9CE\U0001F3FE\U0000200D\U00002640\U0000FE0F": ":\u5973\u6027\u8dea\u5f0f\u4e2d\u6df1\u8272\u80a4\u8272\u9009\u62e9:",
    u"\U0001F9CE\U0001F3FC\U0000200D\U00002640": ":\u5973\u6027\u8dea\u5730\u4e2d\u6d45\u80a4\u8272:",
    u"\U0001F9CE\U0001F3FC\U0000200D\U00002640\U0000FE0F": ":\u5973\u6027\u8dea\u5f0f\u4e2d\u6d45\u80a4\u8272\u9009\u62e9:",
    u"\U0001F9CE\U0001F3FD\U0000200D\U00002640": ":\u5973\u6027\u8dea\u7740\u4e2d\u7b49\u80a4\u8272:",
    u"\U0001F9CE\U0001F3FD\U0000200D\U00002640\U0000FE0F": ":\u5973\u6027\u8dea\u5f0f\u4e2d\u7b49\u80a4\u8272\u9009\u62e9:",
    u"\U0001F9CE\U0000200D\U00002640": ":\u8dea\u7740\u7684\u5973\u4eba:",
    u"\U0001F9CE\U0000200D\U00002640\U0000FE0F": ":\u5973\u4eba\u8dea\u4e0b\u9009\u62e9:",
    u"\U0001F3CB\U0001F3FF\U0000200D\U00002640": ":\u5973\u6027\u4e3e\u91cd\u6df1\u8272\u80a4\u8272:",
    u"\U0001F3CB\U0001F3FB\U0000200D\U00002640": ":\u5973\u6027\u4e3e\u91cd\u8f7b\u80a4\u8272:",
    u"\U0001F3CB\U0001F3FE\U0000200D\U00002640": ":\u5973\u6027\u4e3e\u91cd\u4e2d\u7b49\u80a4\u8272:",
    u"\U0001F3CB\U0001F3FC\U0000200D\U00002640": ":\u5973\u6027\u4e3e\u91cd\u4e2d\u7b49\u504f\u8f7b\u80a4\u8272:",
    u"\U0001F3CB\U0001F3FD\U0000200D\U00002640": ":\u5973\u6027\u4e3e\u91cd\u4e2d\u7b49\u80a4\u8272:",
    u"\U0001F3CB\U0000200D\U00002640": ":\u5973\u5b50\u4e3e\u91cd:",
    u"\U0001F3CB\U0000FE0F\U0000200D\U00002640\U0000FE0F": ":\u5973\u5b50\u4e3e\u91cd2:",
    u"\U0001F3CB\U0000200D\U00002640\U0000FE0F": ":\u5973\u5b50\u4e3e\u91cd3:",
    u"\U0001F3CB\U0001F3FF\U0000200D\U00002640\U0000FE0F": ":\u5973\u5b50\u4e3e\u91cd\u6df1\u8272\u80a4\u8272:",
    u"\U0001F3CB\U0001F3FB\U0000200D\U00002640\U0000FE0F": ":\u5973\u6027\u4e3e\u91cd\u8f7b\u80a4\u8272:",
    u"\U0001F3CB\U0001F3FE\U0000200D\U00002640\U0000FE0F": ":\u5973\u6027\u4e3e\u91cd\u4e2d\u7b49\u80a4\u8272:",
    u"\U0001F3CB\U0001F3FC\U0000200D\U00002640\U0000FE0F": ":\u5973\u6027\u4e3e\u91cd\u4e2d\u7b49\u504f\u8f7b\u80a4\u8272:",
    u"\U0001F3CB\U0001F3FD\U0000200D\U00002640\U0000FE0F": ":\u5973\u6027\u4e3e\u91cd\u4e2d\u7b49\u80a4\u8272:",
    u"\U0001F3CB\U0000FE0F\U0000200D\U00002640": ":\u5973\u5b50\u4e3e\u91cd:",
    u"\U0001F469\U0001F3FB": ":\u5973\u6027\u6d45\u80a4\u8272:",
    u"\U0001F9D9\U0001F3FF\U0000200D\U00002640": ":\u5973\u6cd5\u5e08\u80a4\u8272\u9edd\u9ed1:",
    u"\U0001F9D9\U0001F3FB\U0000200D\U00002640": ":\u5973\u6cd5\u5e08\u6d45\u80a4\u8272:",
    u"\U0001F9D9\U0001F3FE\U0000200D\U00002640": ":\u5973\u6cd5\u5e08\u4e2d\u6df1\u8272\u80a4\u8272:",
    u"\U0001F9D9\U0001F3FC\U0000200D\U00002640": ":\u5973\u6cd5\u5e08\u4e2d\u6d45\u80a4\u8272:",
    u"\U0001F9D9\U0001F3FD\U0000200D\U00002640": ":\u5973\u6cd5\u5e08\u4e2d\u7b49\u80a4\u8272:",
    u"\U0001F9D9\U0000200D\U00002640": ":\u5973\u6cd5\u5e08:",
    u"\U0001F9D9\U0001F3FF\U0000200D\U00002640\U0000FE0F": ":\u5973\u6cd5\u5e08\u80a4\u8272\u9edd\u9ed1:",
    u"\U0001F9D9\U0001F3FB\U0000200D\U00002640\U0000FE0F": ":\u5973\u6cd5\u5e08\u6d45\u80a4\u8272:",
    u"\U0001F9D9\U0001F3FE\U0000200D\U00002640\U0000FE0F": ":\u5973\u6cd5\u5e08\u4e2d\u6df1\u8272\u80a4\u8272:",
    u"\U0001F9D9\U0001F3FC\U0000200D\U00002640\U0000FE0F": ":\u5973\u6cd5\u5e08\u4e2d\u6d45\u80a4\u8272:",
    u"\U0001F9D9\U0001F3FD\U0000200D\U00002640\U0000FE0F": ":\u5973\u6cd5\u5e08\u4e2d\u7b49\u80a4\u8272:",
    u"\U0001F9D9\U0000200D\U00002640\U0000FE0F": ":\u5973\u6cd5\u5e08\u9009\u62e9:",
    u"\U0001F469\U0000200D\U0001F527": ":\u5973\u673a\u68b0\u5e08:",
    u"\U0001F469\U0001F3FF\U0000200D\U0001F527": ":\u5973\u673a\u68b0\u5e08\u6697\u80a4\u8272:",
    u"\U0001F469\U0001F3FB\U0000200D\U0001F527": ":\u5973\u673a\u68b0\u5e08\u6d45\u80a4\u8272:",
    u"\U0001F469\U0001F3FE\U0000200D\U0001F527": ":\u5973\u673a\u68b0\u5e08\u4e2d\u6df1\u8272\u80a4\u8272:",
    u"\U0001F469\U0001F3FC\U0000200D\U0001F527": ":\u5973\u673a\u68b0\u5e08\u4e2d\u6d45\u80a4\u8272:",
    u"\U0001F469\U0001F3FD\U0000200D\U0001F527": ":\u5973\u673a\u68b0\u5e08\u4e2d\u7b49\u80a4\u8272:",
    u"\U0001F469\U0001F3FE": ":\u5973\u6027\u4e2d\u6df1\u8272\u80a4\u8272:",
    u"\U0001F469\U0001F3FC": ":\u5973\u6027\u4e2d\u6d45\u80a4\u8272:",
    u"\U0001F469\U0001F3FD": ":\u5973\u6027\u4e2d\u7b49\u80a4\u8272:",
    u"\U0001F6B5\U0001F3FF\U0000200D\U00002640": ":\u5973\u5b50\u5c71\u5730\u81ea\u884c\u8f66\u6df1\u8272\u80a4\u8272:",
    u"\U0001F6B5\U0001F3FB\U0000200D\U00002640": ":\u5973\u5b50\u5c71\u5730\u81ea\u884c\u8f66\u6d45\u80a4\u8272:",
    u"\U0001F6B5\U0001F3FE\U0000200D\U00002640": ":\u5973\u6027\u5c71\u5730\u81ea\u884c\u8f66\u4e2d\u6df1\u8272\u80a4\u8272:",
    u"\U0001F6B5\U0001F3FC\U0000200D\U00002640": ":\u5973\u6027\u5c71\u5730\u81ea\u884c\u8f66\u4e2d\u6d45\u80a4\u8272:",
    u"\U0001F6B5\U0001F3FD\U0000200D\U00002640": ":\u5973\u5b50\u5c71\u5730\u81ea\u884c\u8f66\u4e2d\u7b49\u80a4\u8272:",
    u"\U0001F6B5\U0000200D\U00002640": ":\u5973\u5b50\u5c71\u5730\u81ea\u884c\u8f66:",
    u"\U0001F6B5\U0001F3FF\U0000200D\U00002640\U0000FE0F": ":\u5973\u5b50\u5c71\u5730\u81ea\u884c\u8f66\u6df1\u8272\u80a4\u8272:",
    u"\U0001F6B5\U0001F3FB\U0000200D\U00002640\U0000FE0F": ":\u5973\u5b50\u5c71\u5730\u81ea\u884c\u8f66\u6d45\u80a4\u8272:",
    u"\U0001F6B5\U0001F3FE\U0000200D\U00002640\U0000FE0F": ":\u5973\u6027\u5c71\u5730\u81ea\u884c\u8f66\u4e2d\u6df1\u8272\u80a4\u8272:",
    u"\U0001F6B5\U0001F3FC\U0000200D\U00002640\U0000FE0F": ":\u5973\u6027\u5c71\u5730\u81ea\u884c\u8f66\u4e2d\u6d45\u80a4\u8272:",
    u"\U0001F6B5\U0001F3FD\U0000200D\U00002640\U0000FE0F": ":\u5973\u5b50\u5c71\u5730\u81ea\u884c\u8f66\u4e2d\u7b49\u80a4\u8272:",
    u"\U0001F6B5\U0000200D\U00002640\U0000FE0F": ":\u5973\u5b50\u5c71\u5730\u81ea\u884c\u8f66:",
    u"\U0001F469\U0000200D\U0001F4BC": ":\u5973\u4e0a\u73ed\u65cf:",
    u"\U0001F469\U0001F3FF\U0000200D\U0001F4BC": ":\u5973\u4e0a\u73ed\u65cf\u80a4\u8272\u6697\u6c89:",
    u"\U0001F469\U0001F3FB\U0000200D\U0001F4BC": ":\u5973\u4e0a\u73ed\u65cf\u80a4\u8272\u6d45:",
    u"\U0001F469\U0001F3FE\U0000200D\U0001F4BC": ":\u5973\u4e0a\u73ed\u65cf\u4e2d\u6df1\u8272\u80a4\u8272:",
    u"\U0001F469\U0001F3FC\U0000200D\U0001F4BC": ":\u5973\u4e0a\u73ed\u65cf\u4e2d\u6d45\u80a4\u8272:",
    u"\U0001F469\U0001F3FD\U0000200D\U0001F4BC": ":\u5973\u4e0a\u73ed\u65cf\u4e2d\u80a4\u8272:",
    u"\U0001F469\U0001F3FF\U0000200D\U00002708": ":\u5973\u98de\u884c\u5458\u6df1\u8272\u80a4\u8272:",
    u"\U0001F469\U0001F3FB\U0000200D\U00002708": ":\u5973\u98de\u884c\u5458\u6d45\u80a4\u8272:",
    u"\U0001F469\U0001F3FE\U0000200D\U00002708": ":\u5973\u98de\u884c\u5458\u4e2d\u6df1\u8272\u80a4\u8272:",
    u"\U0001F469\U0001F3FC\U0000200D\U00002708": ":\u5973\u98de\u884c\u5458\u4e2d\u6d45\u80a4\u8272:",
    u"\U0001F469\U0001F3FD\U0000200D\U00002708": ":\u5973\u98de\u884c\u5458\u4e2d\u7b49\u80a4\u8272:",
    u"\U0001F469\U0000200D\U00002708": ":\u5973\u98de\u884c\u5458:",
    u"\U0001F469\U0001F3FF\U0000200D\U00002708\U0000FE0F": ":\u5973\u98de\u884c\u5458\u6df1\u8272\u80a4\u8272:",
    u"\U0001F469\U0001F3FB\U0000200D\U00002708\U0000FE0F": ":\u5973\u98de\u884c\u5458\u6d45\u80a4\u8272:",
    u"\U0001F469\U0001F3FE\U0000200D\U00002708\U0000FE0F": ":\u5973\u98de\u884c\u5458\u4e2d\u6df1\u8272\u80a4\u8272:",
    u"\U0001F469\U0001F3FC\U0000200D\U00002708\U0000FE0F": ":\u5973\u98de\u884c\u5458\u4e2d\u6d45\u80a4\u8272:",
    u"\U0001F469\U0001F3FD\U0000200D\U00002708\U0000FE0F": ":\u5973\u98de\u884c\u5458\u4e2d\u7b49\u80a4\u8272:",
    u"\U0001F469\U0000200D\U00002708\U0000FE0F": ":\u5973\u98de\u884c\u5458:",
    u"\U0001F93E\U0001F3FF\U0000200D\U00002640": ":\u6253\u624b\u7403\u7684\u5973\u4eba\u80a4\u8272\u9edd\u9ed1:",
    u"\U0001F93E\U0001F3FB\U0000200D\U00002640": ":\u5973\u5b50\u624b\u7403\u8f7b\u80a4\u8272:",
    u"\U0001F93E\U0001F3FE\U0000200D\U00002640": ":\u6253\u624b\u7403\u7684\u5973\u4eba\u80a4\u8272\u504f\u9ed1:",
    u"\U0001F93E\U0001F3FC\U0000200D\U00002640": ":\u5973\u5b50\u624b\u7403\u4e2d\u6d45\u80a4\u8272:",
    u"\U0001F93E\U0001F3FD\U0000200D\U00002640": ":\u5973\u5b50\u624b\u7403\u4e2d\u7b49\u80a4\u8272:",
    u"\U0001F93E\U0000200D\U00002640": ":\u6253\u624b\u7403\u7684\u5973\u4eba:",
    u"\U0001F93E\U0001F3FF\U0000200D\U00002640\U0000FE0F": ":\u6253\u624b\u7403\u7684\u5973\u4eba\u80a4\u8272\u9edd\u9ed1:",
    u"\U0001F93E\U0001F3FB\U0000200D\U00002640\U0000FE0F": ":\u5973\u5b50\u624b\u7403\u8f7b\u80a4\u8272:",
    u"\U0001F93E\U0001F3FE\U0000200D\U00002640\U0000FE0F": ":\u6253\u624b\u7403\u7684\u5973\u4eba\u80a4\u8272\u504f\u9ed1:",
    u"\U0001F93E\U0001F3FC\U0000200D\U00002640\U0000FE0F": ":\u5973\u5b50\u624b\u7403\u4e2d\u6d45\u80a4\u8272:",
    u"\U0001F93E\U0001F3FD\U0000200D\U00002640\U0000FE0F": ":\u5973\u5b50\u624b\u7403\u4e2d\u7b49\u80a4\u8272:",
    u"\U0001F93E\U0000200D\U00002640\U0000FE0F": ":\u5973\u5b50\u624b\u7403\u9009\u62e9:",
    u"\U0001F93D\U0001F3FF\U0000200D\U00002640": ":\u5973\u5b50\u6253\u6c34\u7403\u80a4\u8272\u6697\u6c89:",
    u"\U0001F93D\U0001F3FB\U0000200D\U00002640": ":\u5973\u5b50\u6253\u6c34\u7403\u80a4\u8272\u6d45:",
    u"\U0001F93D\U0001F3FE\U0000200D\U00002640": ":\u6253\u6c34\u7403\u7684\u5973\u4eba\u80a4\u8272\u504f\u6697:",
    u"\U0001F93D\U0001F3FC\U0000200D\U00002640": ":\u5973\u5b50\u6c34\u7403\u4e2d\u6d45\u80a4\u8272:",
    u"\U0001F93D\U0001F3FD\U0000200D\U00002640": ":\u5973\u5b50\u6253\u6c34\u7403\u4e2d\u7b49\u80a4\u8272:",
    u"\U0001F93D\U0000200D\U00002640": ":\u6253\u6c34\u7403\u7684\u5973\u4eba:",
    u"\U0001F93D\U0001F3FF\U0000200D\U00002640\U0000FE0F": ":\u5973\u5b50\u6253\u6c34\u7403\u80a4\u8272\u6697\u6c89:",
    u"\U0001F93D\U0001F3FB\U0000200D\U00002640\U0000FE0F": ":\u5973\u5b50\u6253\u6c34\u7403\u80a4\u8272\u6d45:",
    u"\U0001F93D\U0001F3FE\U0000200D\U00002640\U0000FE0F": ":\u6253\u6c34\u7403\u7684\u5973\u4eba\u80a4\u8272\u504f\u6697:",
    u"\U0001F93D\U0001F3FC\U0000200D\U00002640\U0000FE0F": ":\u5973\u5b50\u6c34\u7403\u4e2d\u6d45\u80a4\u8272:",
    u"\U0001F93D\U0001F3FD\U0000200D\U00002640\U0000FE0F": ":\u5973\u5b50\u6253\u6c34\u7403\u4e2d\u7b49\u80a4\u8272:",
    u"\U0001F93D\U0000200D\U00002640\U0000FE0F": ":\u5973\u9009\u624b\u6253\u6c34\u7403:",
    u"\U0001F46E\U0001F3FF\U0000200D\U00002640": ":\u5973\u8b66\u5b98\u80a4\u8272\u9edd\u9ed1:",
    u"\U0001F46E\U0001F3FB\U0000200D\U00002640": ":\u5973\u8b66\u5b98\u80a4\u8272\u6d45:",
    u"\U0001F46E\U0001F3FE\U0000200D\U00002640": ":\u5973\u8b66\u5b98\u4e2d\u6df1\u8272\u80a4\u8272:",
    u"\U0001F46E\U0001F3FC\U0000200D\U00002640": ":\u5973\u8b66\u5b98\u4e2d\u6d45\u80a4\u8272:",
    u"\U0001F46E\U0001F3FD\U0000200D\U00002640": ":\u5973\u8b66\u5b98\u4e2d\u7b49\u80a4\u8272:",
    u"\U0001F46E\U0000200D\U00002640": ":\u5973\u8b66\u5b98:",
    u"\U0001F46E\U0001F3FF\U0000200D\U00002640\U0000FE0F": ":\u5973\u8b66\u5b98\u80a4\u8272\u9edd\u9ed1:",
    u"\U0001F46E\U0001F3FB\U0000200D\U00002640\U0000FE0F": ":\u5973\u8b66\u5b98\u80a4\u8272\u6d45:",
    u"\U0001F46E\U0001F3FE\U0000200D\U00002640\U0000FE0F": ":\u5973\u8b66\u5b98\u4e2d\u6df1\u8272\u80a4\u8272:",
    u"\U0001F46E\U0001F3FC\U0000200D\U00002640\U0000FE0F": ":\u5973\u8b66\u5b98\u4e2d\u6d45\u80a4\u8272:",
    u"\U0001F46E\U0001F3FD\U0000200D\U00002640\U0000FE0F": ":\u5973\u8b66\u5b98\u4e2d\u7b49\u80a4\u8272:",
    u"\U0001F46E\U0000200D\U00002640\U0000FE0F": ":\u5973\u8b66\u5b98:",
    u"\U0001F64E\U0001F3FF\U0000200D\U00002640": ":\u5973\u4eba\u6485\u7740\u5634\uff0c\u80a4\u8272\u9edd\u9ed1:",
    u"\U0001F64E\U0001F3FB\U0000200D\U00002640": ":\u5973\u4eba\u6485\u7740\u5634\u6d45\u80a4\u8272:",
    u"\U0001F64E\U0001F3FE\U0000200D\U00002640": ":\u5973\u6027\u6485\u8d77\u5634\u5507\uff0c\u80a4\u8272\u4e2d\u7b49\u504f\u6697:",
    u"\U0001F64E\U0001F3FC\U0000200D\U00002640": ":\u5973\u6027\u6485\u8d77\u5634\u5507\u4e2d\u7b49\u504f\u6d45\u80a4\u8272:",
    u"\U0001F64E\U0001F3FD\U0000200D\U00002640": ":\u5973\u6027\u6485\u5634\u4e2d\u7b49\u80a4\u8272:",
    u"\U0001F64E\U0000200D\U00002640": ":\u5973\u4eba\u6485\u5634:",
    u"\U0001F64E\U0001F3FF\U0000200D\U00002640\U0000FE0F": ":\u5973\u4eba\u6485\u7740\u5634\uff0c\u80a4\u8272\u9edd\u9ed1:",
    u"\U0001F64E\U0001F3FB\U0000200D\U00002640\U0000FE0F": ":\u5973\u4eba\u6485\u7740\u5634\u6d45\u80a4\u8272:",
    u"\U0001F64E\U0001F3FE\U0000200D\U00002640\U0000FE0F": ":\u5973\u6027\u6df1\u80a4\u8272\u6485\u5634:",
    u"\U0001F64E\U0001F3FC\U0000200D\U00002640\U0000FE0F": ":\u5973\u4eba\u6485\u5634\u4e2d\u7b49\u6d45\u80a4\u8272:",
    u"\U0001F64E\U0001F3FD\U0000200D\U00002640\U0000FE0F": ":\u5973\u6027\u6485\u5634\u4e2d\u7b49\u80a4\u8272:",
    u"\U0001F64E\U0000200D\U00002640\U0000FE0F": ":\u5973\u4eba\u6485\u5634:",
    u"\U0001F64B\U0001F3FF\U0000200D\U00002640": ":\u5973\u6027\u4e3e\u624b\u6697\u80a4\u8272:",
    u"\U0001F64B\U0001F3FB\U0000200D\U00002640": ":\u5973\u6027\u62ac\u624b\u8f7b\u80a4\u8272:",
    u"\U0001F64B\U0001F3FE\U0000200D\U00002640": ":\u5973\u6027\u62ac\u624b\u4e2d\u6df1\u8272\u80a4\u8272:",
    u"\U0001F64B\U0001F3FC\U0000200D\U00002640": ":\u5973\u6027\u62ac\u624b\u4e2d\u6d45\u80a4\u8272:",
    u"\U0001F64B\U0001F3FD\U0000200D\U00002640": ":\u5973\u6027\u4e3e\u624b\u4e2d\u7b49\u80a4\u8272:",
    u"\U0001F64B\U0000200D\U00002640": ":\u4e3e\u8d77\u624b\u7684\u5973\u4eba:",
    u"\U0001F64B\U0001F3FF\U0000200D\U00002640\U0000FE0F": ":\u5973\u6027\u4e3e\u624b\u6697\u80a4\u8272:",
    u"\U0001F64B\U0001F3FB\U0000200D\U00002640\U0000FE0F": ":\u5973\u6027\u62ac\u624b\u8f7b\u80a4\u8272:",
    u"\U0001F64B\U0001F3FE\U0000200D\U00002640\U0000FE0F": ":\u5973\u6027\u62ac\u624b\u4e2d\u6df1\u8272\u80a4\u8272:",
    u"\U0001F64B\U0001F3FC\U0000200D\U00002640\U0000FE0F": ":\u5973\u6027\u62ac\u624b\u4e2d\u6d45\u80a4\u8272:",
    u"\U0001F64B\U0001F3FD\U0000200D\U00002640\U0000FE0F": ":\u5973\u6027\u4e3e\u624b\u4e2d\u7b49\u80a4\u8272:",
    u"\U0001F64B\U0000200D\U00002640\U0000FE0F": ":\u5973\u6027\u4e3e\u624b:",
    u"\U0001F6A3\U0001F3FF\U0000200D\U00002640": ":\u5973\u5212\u8239\u6df1\u8272\u80a4\u8272:",
    u"\U0001F6A3\U0001F3FB\U0000200D\U00002640": ":\u5973\u5b50\u5212\u8239\u6d45\u80a4\u8272:",
    u"\U0001F6A3\U0001F3FE\U0000200D\U00002640": ":\u5973\u5b50\u5212\u8239\u4e2d\u6df1\u8272\u80a4\u8272:",
    u"\U0001F6A3\U0001F3FC\U0000200D\U00002640": ":\u5973\u5b50\u5212\u8239\u4e2d\u6d45\u80a4\u8272:",
    u"\U0001F6A3\U0001F3FD\U0000200D\U00002640": ":\u5973\u5b50\u5212\u8239\u4e2d\u7b49\u80a4\u8272:",
    u"\U0001F6A3\U0000200D\U00002640": ":\u5973\u5b50\u5212\u8239:",
    u"\U0001F6A3\U0001F3FF\U0000200D\U00002640\U0000FE0F": ":\u5973\u5212\u8239\u6df1\u8272\u80a4\u8272:",
    u"\U0001F6A3\U0001F3FB\U0000200D\U00002640\U0000FE0F": ":\u5973\u5b50\u5212\u8239\u6d45\u80a4\u8272:",
    u"\U0001F6A3\U0001F3FE\U0000200D\U00002640\U0000FE0F": ":\u5973\u5b50\u5212\u8239\u4e2d\u6df1\u8272\u80a4\u8272:",
    u"\U0001F6A3\U0001F3FC\U0000200D\U00002640\U0000FE0F": ":\u5973\u5b50\u5212\u8239\u4e2d\u6d45\u80a4\u8272:",
    u"\U0001F6A3\U0001F3FD\U0000200D\U00002640\U0000FE0F": ":\u5973\u5b50\u5212\u8239\u4e2d\u7b49\u80a4\u8272:",
    u"\U0001F6A3\U0000200D\U00002640\U0000FE0F": ":\u5973\u5212\u8239\u624b:",
    u"\U0001F3C3\U0001F3FF\U0000200D\U00002640": ":\u5973\u6027\u6697\u80a4\u8272:",
    u"\U0001F3C3\U0001F3FB\U0000200D\U00002640": ":\u5973\u6027\u8dd1\u6b65\u6de1\u80a4\u8272:",
    u"\U0001F3C3\U0001F3FE\U0000200D\U00002640": ":\u5973\u6027\u8dd1\u6b65\u4e2d\u6df1\u8272\u80a4\u8272:",
    u"\U0001F3C3\U0001F3FC\U0000200D\U00002640": ":\u5973\u6027\u8dd1\u6b65\u4e2d\u6d45\u80a4\u8272:",
    u"\U0001F3C3\U0001F3FD\U0000200D\U00002640": ":\u5973\u6027\u8dd1\u6b65\u4e2d\u7b49\u80a4\u8272:",
    u"\U0001F3C3\U0000200D\U00002640": ":\u5973\u5b50\u8dd1\u6b65:",
    u"\U0001F3C3\U0001F3FF\U0000200D\U00002640\U0000FE0F": ":\u5973\u6027\u6697\u80a4\u8272:",
    u"\U0001F3C3\U0001F3FB\U0000200D\U00002640\U0000FE0F": ":\u5973\u6027\u8dd1\u6b65\u6de1\u80a4\u8272:",
    u"\U0001F3C3\U0001F3FE\U0000200D\U00002640\U0000FE0F": ":\u5973\u6027\u8dd1\u6b65\u4e2d\u6df1\u8272\u80a4\u8272:",
    u"\U0001F3C3\U0001F3FC\U0000200D\U00002640\U0000FE0F": ":\u5973\u6027\u8dd1\u6b65\u4e2d\u6d45\u80a4\u8272:",
    u"\U0001F3C3\U0001F3FD\U0000200D\U00002640\U0000FE0F": ":\u5973\u6027\u8dd1\u6b65\u4e2d\u7b49\u80a4\u8272:",
    u"\U0001F3C3\U0000200D\U00002640\U0000FE0F": ":\u5973\u5b50\u8dd1\u6b65:",
    u"\U0001F469\U0000200D\U0001F52C": ":\u5973\u79d1\u5b66\u5bb6:",
    u"\U0001F469\U0001F3FF\U0000200D\U0001F52C": ":\u5973\u79d1\u5b66\u5bb6\u6697\u80a4\u8272:",
    u"\U0001F469\U0001F3FB\U0000200D\U0001F52C": ":\u5973\u79d1\u5b66\u5bb6\u6d45\u80a4\u8272:",
    u"\U0001F469\U0001F3FE\U0000200D\U0001F52C": ":\u5973\u79d1\u5b66\u5bb6\u4e2d\u9ed1\u80a4\u8272:",
    u"\U0001F469\U0001F3FC\U0000200D\U0001F52C": ":\u5973\u79d1\u5b66\u5bb6\u4e2d\u6d45\u80a4\u8272:",
    u"\U0001F469\U0001F3FD\U0000200D\U0001F52C": ":\u5973\u79d1\u5b66\u5bb6\u4e2d\u7b49\u80a4\u8272:",
    u"\U0001F937\U0001F3FF\U0000200D\U00002640": ":\u5973\u4eba\u8038\u8038\u80a9\u6df1\u8272\u80a4\u8272:",
    u"\U0001F937\U0001F3FB\U0000200D\U00002640": ":\u5973\u4eba\u8038\u8038\u80a9\uff0c\u80a4\u8272\u6d45:",
    u"\U0001F937\U0001F3FE\U0000200D\U00002640": ":\u5973\u6027\u8038\u8038\u80a9\u4e2d\u6df1\u8272\u80a4\u8272:",
    u"\U0001F937\U0001F3FC\U0000200D\U00002640": ":\u5973\u6027\u8038\u80a9\u4e2d\u6d45\u80a4\u8272:",
    u"\U0001F937\U0001F3FD\U0000200D\U00002640": ":\u5973\u6027\u8038\u8038\u80a9\u4e2d\u7b49\u80a4\u8272:",
    u"\U0001F937\U0000200D\U00002640": ":\u5973\u4eba\u8038\u8038\u80a9:",
    u"\U0001F937\U0001F3FF\U0000200D\U00002640\U0000FE0F": ":\u5973\u4eba\u8038\u8038\u80a9\u6df1\u8272\u80a4\u8272:",
    u"\U0001F937\U0001F3FB\U0000200D\U00002640\U0000FE0F": ":\u5973\u4eba\u8038\u8038\u80a9\uff0c\u80a4\u8272\u6d45:",
    u"\U0001F937\U0001F3FE\U0000200D\U00002640\U0000FE0F": ":\u5973\u6027\u8038\u8038\u80a9\u4e2d\u6df1\u8272\u80a4\u8272:",
    u"\U0001F937\U0001F3FC\U0000200D\U00002640\U0000FE0F": ":\u5973\u6027\u8038\u80a9\u4e2d\u6d45\u80a4\u8272:",
    u"\U0001F937\U0001F3FD\U0000200D\U00002640\U0000FE0F": ":\u5973\u6027\u8038\u8038\u80a9\u4e2d\u7b49\u80a4\u8272:",
    u"\U0001F937\U0000200D\U00002640\U0000FE0F": ":\u5973\u4eba\u8038\u8038\u80a9:",
    u"\U0001F469\U0000200D\U0001F3A4": ":\u5973\u6b4c\u624b:",
    u"\U0001F469\U0001F3FF\U0000200D\U0001F3A4": ":\u5973\u6b4c\u624b\u6697\u80a4\u8272:",
    u"\U0001F469\U0001F3FB\U0000200D\U0001F3A4": ":\u5973\u6b4c\u624b\u6d45\u80a4\u8272:",
    u"\U0001F469\U0001F3FE\U0000200D\U0001F3A4": ":\u5973\u6b4c\u624b\u4e2d\u6df1\u8272\u80a4\u8272:",
    u"\U0001F469\U0001F3FC\U0000200D\U0001F3A4": ":\u5973\u6b4c\u624b\u4e2d\u6d45\u80a4\u8272:",
    u"\U0001F469\U0001F3FD\U0000200D\U0001F3A4": ":\u5973\u6b4c\u624b\u4e2d\u7b49\u80a4\u8272:",
    u"\U0001F9CD\U0001F3FF\U0000200D\U00002640": ":\u5973\u6027\u7ad9\u5728\u6df1\u8272\u80a4\u8272:",
    u"\U0001F9CD\U0001F3FF\U0000200D\U00002640\U0000FE0F": ":\u5973\u6027\u7ad9\u7acb\u6df1\u8272\u80a4\u8272:",
    u"\U0001F9CD\U0001F3FB\U0000200D\U00002640": ":\u5973\u6027\u7ad9\u7acb\u8f7b\u80a4\u8272:",
    u"\U0001F9CD\U0001F3FB\U0000200D\U00002640\U0000FE0F": ":\u5973\u6027\u7ad9\u706f\u80a4\u8272:",
    u"\U0001F9CD\U0001F3FE\U0000200D\U00002640": ":\u5973\u6027\u7ad9\u7740\u4e2d\u6df1\u8272\u80a4\u8272:",
    u"\U0001F9CD\U0001F3FE\U0000200D\U00002640\U0000FE0F": ":\u5973\u6027\u7ad9\u7acb\u4e2d\u6df1\u8272\u80a4\u8272:",
    u"\U0001F9CD\U0001F3FC\U0000200D\U00002640": ":\u5973\u6027\u7ad9\u7acb\u4e2d\u6d45\u80a4\u8272:",
    u"\U0001F9CD\U0001F3FC\U0000200D\U00002640\U0000FE0F": ":\u5973\u6027\u7ad9\u7acb\u4e2d\u6d45\u80a4\u8272:",
    u"\U0001F9CD\U0001F3FD\U0000200D\U00002640": ":\u5973\u6027\u7ad9\u7acb\u4e2d\u7b49\u80a4\u8272:",
    u"\U0001F9CD\U0001F3FD\U0000200D\U00002640\U0000FE0F": ":\u5973\u6027\u7ad9\u7acb\u4e2d\u7b49\u80a4\u8272:",
    u"\U0001F9CD\U0000200D\U00002640": ":\u7ad9\u7740\u7684\u5973\u4eba:",
    u"\U0001F9CD\U0000200D\U00002640\U0000FE0F": ":\u5973\u7ad9\u9009:",
    u"\U0001F469\U0000200D\U0001F393": ":\u5973\u5b66\u751f:",
    u"\U0001F469\U0001F3FF\U0000200D\U0001F393": ":\u5973\u5b66\u751f\u6697\u80a4\u8272:",
    u"\U0001F469\U0001F3FB\U0000200D\U0001F393": ":\u5973\u5b66\u751f\u6d45\u80a4\u8272:",
    u"\U0001F469\U0001F3FE\U0000200D\U0001F393": ":\u5973\u5b66\u751f\u4e2d\u6df1\u8272\u80a4\u8272:",
    u"\U0001F469\U0001F3FC\U0000200D\U0001F393": ":\u5973\u5b66\u751f\u4e2d\u6d45\u80a4\u8272:",
    u"\U0001F469\U0001F3FD\U0000200D\U0001F393": ":\u5973\u5b66\u751f\u4e2d\u7b49\u80a4\u8272:",
    u"\U0001F9B8\U0001F3FF\U0000200D\U00002640": ":\u5973\u8d85\u4eba\u6df1\u8272\u80a4\u8272:",
    u"\U0001F9B8\U0001F3FF\U0000200D\U00002640\U0000FE0F": ":\u5973\u8d85\u4eba\u6df1\u8272\u80a4\u8272:",
    u"\U0001F9B8\U0001F3FB\U0000200D\U00002640": ":\u5973\u8d85\u4eba\u6d45\u80a4\u8272:",
    u"\U0001F9B8\U0001F3FB\U0000200D\U00002640\U0000FE0F": ":\u5973\u8d85\u4eba\u8f7b\u8584\u80a4\u8272:",
    u"\U0001F9B8\U0001F3FE\U0000200D\U00002640": ":\u5973\u8d85\u4eba\u4e2d\u6df1\u8272\u80a4\u8272:",
    u"\U0001F9B8\U0001F3FE\U0000200D\U00002640\U0000FE0F": ":\u5973\u8d85\u4eba\u4e2d\u6df1\u8272\u80a4\u8272\u9009\u62e9:",
    u"\U0001F9B8\U0001F3FC\U0000200D\U00002640": ":\u5973\u8d85\u4eba\u4e2d\u6d45\u80a4\u8272:",
    u"\U0001F9B8\U0001F3FC\U0000200D\U00002640\U0000FE0F": ":\u5973\u8d85\u4eba\u4e2d\u6d45\u80a4\u8272\u9009\u62e9:",
    u"\U0001F9B8\U0001F3FD\U0000200D\U00002640": ":\u5973\u6027\u8d85\u7ea7\u82f1\u96c4\u4e2d\u7b49\u80a4\u8272:",
    u"\U0001F9B8\U0001F3FD\U0000200D\U00002640\U0000FE0F": ":\u5973\u6027\u8d85\u7ea7\u82f1\u96c4\u4e2d\u7b49\u80a4\u8272\u9009\u62e9:",
    u"\U0001F9B8\U0000200D\U00002640": ":\u5973\u8d85\u7ea7\u82f1\u96c4:",
    u"\U0001F9B8\U0000200D\U00002640\U0000FE0F": ":\u5973\u8d85\u7ea7\u82f1\u96c4\u9009\u62e9:",
    u"\U0001F9B9\U0001F3FF\U0000200D\U00002640": ":\u5973\u8d85\u4eba\u9ed1\u80a4\u8272:",
    u"\U0001F9B9\U0001F3FF\U0000200D\U00002640\U0000FE0F": ":\u5973\u6027\u8d85\u7ea7\u6076\u68cd\u6df1\u8272\u80a4\u8272\u9009\u62e9:",
    u"\U0001F9B9\U0001F3FB\U0000200D\U00002640": ":\u5973\u4eba\u8d85\u7ea7\u6076\u68cd\u6de1\u80a4\u8272:",
    u"\U0001F9B9\U0001F3FB\U0000200D\U00002640\U0000FE0F": ":\u5973\u8d85\u4eba\u8f7b\u80a4\u8272\u9009\u62e9:",
    u"\U0001F9B9\U0001F3FE\U0000200D\U00002640": ":\u5973\u4eba\u8d85\u7ea7\u6076\u68cd\u4e2d\u9ed1\u80a4\u8272:",
    u"\U0001F9B9\U0001F3FE\U0000200D\U00002640\U0000FE0F": ":\u5973\u6027\u8d85\u7ea7\u53cd\u6d3e\u4e2d\u6df1\u8272\u80a4\u8272\u9009\u62e9:",
    u"\U0001F9B9\U0001F3FC\U0000200D\U00002640": ":\u5973\u8d85\u4eba\u4e2d\u6d45\u80a4\u8272:",
    u"\U0001F9B9\U0001F3FC\U0000200D\U00002640\U0000FE0F": ":\u5973\u8d85\u4eba\u4e2d\u6d45\u80a4\u8272\u9009\u62e9:",
    u"\U0001F9B9\U0001F3FD\U0000200D\U00002640": ":\u5973\u4eba\u8d85\u7ea7\u6076\u68cd\u4e2d\u7b49\u80a4\u8272:",
    u"\U0001F9B9\U0001F3FD\U0000200D\U00002640\U0000FE0F": ":\u5973\u4eba\u8d85\u7ea7\u6076\u68cd\u4e2d\u7b49\u80a4\u8272\u9009\u62e9:",
    u"\U0001F9B9\U0000200D\U00002640": ":\u5973\u5927\u53cd\u6d3e:",
    u"\U0001F9B9\U0000200D\U00002640\U0000FE0F": ":\u5973\u8d85\u4eba\u9009\u62e9:",
    u"\U0001F3C4\U0001F3FF\U0000200D\U00002640": ":\u5973\u6027\u51b2\u6d6a\u6df1\u8272\u80a4\u8272:",
    u"\U0001F3C4\U0001F3FB\U0000200D\U00002640": ":\u5973\u6027\u51b2\u6d6a\u6d45\u80a4\u8272:",
    u"\U0001F3C4\U0001F3FE\U0000200D\U00002640": ":\u5973\u6027\u51b2\u6d6a\u4e2d\u6df1\u8272\u80a4\u8272:",
    u"\U0001F3C4\U0001F3FC\U0000200D\U00002640": ":\u5973\u6027\u51b2\u6d6a\u4e2d\u6d45\u80a4\u8272:",
    u"\U0001F3C4\U0001F3FD\U0000200D\U00002640": ":\u5973\u6027\u51b2\u6d6a\u4e2d\u7b49\u80a4\u8272:",
    u"\U0001F3C4\U0000200D\U00002640": ":\u5973\u5b50\u51b2\u6d6a:",
    u"\U0001F3C4\U0001F3FF\U0000200D\U00002640\U0000FE0F": ":\u5973\u6027\u51b2\u6d6a\u6df1\u8272\u80a4\u8272:",
    u"\U0001F3C4\U0001F3FB\U0000200D\U00002640\U0000FE0F": ":\u5973\u6027\u51b2\u6d6a\u6d45\u80a4\u8272:",
    u"\U0001F3C4\U0001F3FE\U0000200D\U00002640\U0000FE0F": ":\u5973\u6027\u51b2\u6d6a\u4e2d\u6df1\u8272\u80a4\u8272:",
    u"\U0001F3C4\U0001F3FC\U0000200D\U00002640\U0000FE0F": ":\u5973\u6027\u51b2\u6d6a\u4e2d\u6d45\u80a4\u8272:",
    u"\U0001F3C4\U0001F3FD\U0000200D\U00002640\U0000FE0F": ":\u5973\u6027\u51b2\u6d6a\u4e2d\u7b49\u80a4\u8272:",
    u"\U0001F3C4\U0000200D\U00002640\U0000FE0F": ":\u5973\u5b50\u51b2\u6d6a:",
    u"\U0001F3CA\U0001F3FF\U0000200D\U00002640": ":\u5973\u6027\u6e38\u6cf3\u6df1\u8272\u80a4\u8272:",
    u"\U0001F3CA\U0001F3FB\U0000200D\U00002640": ":\u6e38\u6cf3\u5973\u6d45\u80a4\u8272:",
    u"\U0001F3CA\U0001F3FE\U0000200D\U00002640": ":\u5973\u6027\u6e38\u6cf3\u4e2d\u6df1\u8272\u80a4\u8272:",
    u"\U0001F3CA\U0001F3FC\U0000200D\U00002640": ":\u5973\u5b50\u6e38\u6cf3\u4e2d\u6d45\u80a4\u8272:",
    u"\U0001F3CA\U0001F3FD\U0000200D\U00002640": ":\u5973\u6027\u6e38\u6cf3\u4e2d\u7b49\u80a4\u8272:",
    u"\U0001F3CA\U0000200D\U00002640": ":\u5973\u5b50\u6e38\u6cf3:",
    u"\U0001F3CA\U0001F3FF\U0000200D\U00002640\U0000FE0F": ":\u5973\u6027\u6e38\u6cf3\u6df1\u8272\u80a4\u8272:",
    u"\U0001F3CA\U0001F3FB\U0000200D\U00002640\U0000FE0F": ":\u6e38\u6cf3\u5973\u6d45\u80a4\u8272:",
    u"\U0001F3CA\U0001F3FE\U0000200D\U00002640\U0000FE0F": ":\u5973\u6027\u6e38\u6cf3\u4e2d\u6df1\u8272\u80a4\u8272:",
    u"\U0001F3CA\U0001F3FC\U0000200D\U00002640\U0000FE0F": ":\u5973\u5b50\u6e38\u6cf3\u4e2d\u6d45\u80a4\u8272:",
    u"\U0001F3CA\U0001F3FD\U0000200D\U00002640\U0000FE0F": ":\u5973\u6027\u6e38\u6cf3\u4e2d\u7b49\u80a4\u8272:",
    u"\U0001F3CA\U0000200D\U00002640\U0000FE0F": ":\u5973\u5b50\u6e38\u6cf3:",
    u"\U0001F469\U0000200D\U0001F3EB": ":\u5973\u6559\u5e08:",
    u"\U0001F469\U0001F3FF\U0000200D\U0001F3EB": ":\u5973\u6559\u5e08\u80a4\u8272\u6697\u6c89:",
    u"\U0001F469\U0001F3FB\U0000200D\U0001F3EB": ":\u5973\u6559\u5e08\u6d45\u80a4\u8272:",
    u"\U0001F469\U0001F3FE\U0000200D\U0001F3EB": ":\u5973\u6559\u5e08\u4e2d\u6df1\u8272\u80a4\u8272:",
    u"\U0001F469\U0001F3FC\U0000200D\U0001F3EB": ":\u5973\u6559\u5e08\u4e2d\u6d45\u80a4\u8272:",
    u"\U0001F469\U0001F3FD\U0000200D\U0001F3EB": ":\u5973\u6559\u5e08\u4e2d\u7b49\u80a4\u8272:",
    u"\U0001F469\U0000200D\U0001F4BB": ":\u5973\u6280\u5e08:",
    u"\U0001F469\U0001F3FF\U0000200D\U0001F4BB": ":\u5973\u6280\u5e08\u6697\u80a4\u8272:",
    u"\U0001F469\U0001F3FB\U0000200D\U0001F4BB": ":\u5973\u6280\u5e08\u6d45\u80a4\u8272:",
    u"\U0001F469\U0001F3FE\U0000200D\U0001F4BB": ":\u5973\u6280\u5e08\u4e2d\u6df1\u8272\u80a4\u8272:",
    u"\U0001F469\U0001F3FC\U0000200D\U0001F4BB": ":\u5973\u6280\u5e08\u4e2d\u6d45\u80a4\u8272:",
    u"\U0001F469\U0001F3FD\U0000200D\U0001F4BB": ":\u5973\u6280\u5e08\u4e2d\u7b49\u80a4\u8272:",
    u"\U0001F481\U0001F3FF\U0000200D\U00002640": ":\u5973\u6027\u7ffb\u624b\u6df1\u8272\u80a4\u8272:",
    u"\U0001F481\U0001F3FB\U0000200D\U00002640": ":\u5973\u6027\u7ffb\u624b\u8f7b\u80a4\u8272:",
    u"\U0001F481\U0001F3FE\U0000200D\U00002640": ":\u5973\u6027\u7ffb\u624b\u4e2d\u6df1\u8272\u80a4\u8272:",
    u"\U0001F481\U0001F3FC\U0000200D\U00002640": ":\u5973\u6027\u7ffb\u624b\u4e2d\u6d45\u80a4\u8272:",
    u"\U0001F481\U0001F3FD\U0000200D\U00002640": ":\u5973\u6027\u7ffb\u624b\u4e2d\u7b49\u80a4\u8272:",
    u"\U0001F481\U0000200D\U00002640": ":\u5973\u5c0f\u8d39\u624b:",
    u"\U0001F481\U0001F3FF\U0000200D\U00002640\U0000FE0F": ":\u5973\u6027\u7ffb\u624b\u6df1\u8272\u80a4\u8272:",
    u"\U0001F481\U0001F3FB\U0000200D\U00002640\U0000FE0F": ":\u5973\u6027\u7ffb\u624b\u8f7b\u80a4\u8272:",
    u"\U0001F481\U0001F3FE\U0000200D\U00002640\U0000FE0F": ":\u5973\u6027\u7ffb\u624b\u4e2d\u6df1\u8272\u80a4\u8272:",
    u"\U0001F481\U0001F3FC\U0000200D\U00002640\U0000FE0F": ":\u5973\u6027\u7ffb\u624b\u4e2d\u6d45\u80a4\u8272:",
    u"\U0001F481\U0001F3FD\U0000200D\U00002640\U0000FE0F": ":\u5973\u6027\u7ffb\u624b\u4e2d\u7b49\u80a4\u8272:",
    u"\U0001F481\U0000200D\U00002640\U0000FE0F": ":\u5973\u5c0f\u8d39\u624b:",
    u"\U0001F9DB\U0001F3FF\U0000200D\U00002640": ":\u5973\u5438\u8840\u9b3c\u6df1\u8272\u80a4\u8272:",
    u"\U0001F9DB\U0001F3FB\U0000200D\U00002640": ":\u5973\u5438\u8840\u9b3c\u6d45\u80a4\u8272:",
    u"\U0001F9DB\U0001F3FE\U0000200D\U00002640": ":\u5973\u5438\u8840\u9b3c\u4e2d\u6df1\u8272\u80a4\u8272:",
    u"\U0001F9DB\U0001F3FC\U0000200D\U00002640": ":\u5973\u5438\u8840\u9b3c\u4e2d\u6d45\u80a4\u8272:",
    u"\U0001F9DB\U0001F3FD\U0000200D\U00002640": ":\u5973\u5438\u8840\u9b3c\u4e2d\u7b49\u80a4\u8272:",
    u"\U0001F9DB\U0000200D\U00002640": ":\u5973\u5438\u8840\u9b3c:",
    u"\U0001F9DB\U0001F3FF\U0000200D\U00002640\U0000FE0F": ":\u5973\u5438\u8840\u9b3c\u6df1\u8272\u80a4\u8272:",
    u"\U0001F9DB\U0001F3FB\U0000200D\U00002640\U0000FE0F": ":\u5973\u5438\u8840\u9b3c\u6d45\u80a4\u8272:",
    u"\U0001F9DB\U0001F3FE\U0000200D\U00002640\U0000FE0F": ":\u5973\u5438\u8840\u9b3c\u4e2d\u6df1\u8272\u80a4\u8272:",
    u"\U0001F9DB\U0001F3FC\U0000200D\U00002640\U0000FE0F": ":\u5973\u5438\u8840\u9b3c\u4e2d\u6d45\u80a4\u8272:",
    u"\U0001F9DB\U0001F3FD\U0000200D\U00002640\U0000FE0F": ":\u5973\u5438\u8840\u9b3c\u4e2d\u7b49\u80a4\u8272:",
    u"\U0001F9DB\U0000200D\U00002640\U0000FE0F": ":\u5438\u8840\u9b3c\u5973:",
    u"\U0001F6B6\U0001F3FF\U0000200D\U00002640": ":\u5973\u6027\u884c\u8d70\u65f6\u80a4\u8272\u6697\u6c89:",
    u"\U0001F6B6\U0001F3FB\U0000200D\U00002640": ":\u5973\u4eba\u8d70\u8def\u65f6\u80a4\u8272\u6d45:",
    u"\U0001F6B6\U0001F3FE\U0000200D\U00002640": ":\u5973\u6027\u884c\u8d70\u4e2d\u6df1\u8272\u80a4\u8272:",
    u"\U0001F6B6\U0001F3FC\U0000200D\U00002640": ":\u5973\u6027\u884c\u8d70\u4e2d\u6d45\u80a4\u8272:",
    u"\U0001F6B6\U0001F3FD\U0000200D\U00002640": ":\u5973\u6027\u884c\u8d70\u4e2d\u7b49\u80a4\u8272:",
    u"\U0001F6B6\U0000200D\U00002640": ":\u8d70\u8def\u7684\u5973\u4eba:",
    u"\U0001F6B6\U0001F3FF\U0000200D\U00002640\U0000FE0F": ":\u5973\u6027\u884c\u8d70\u65f6\u80a4\u8272\u6697\u6c89:",
    u"\U0001F6B6\U0001F3FB\U0000200D\U00002640\U0000FE0F": ":\u5973\u4eba\u8d70\u8def\u65f6\u80a4\u8272\u6d45:",
    u"\U0001F6B6\U0001F3FE\U0000200D\U00002640\U0000FE0F": ":\u5973\u6027\u884c\u8d70\u4e2d\u6df1\u8272\u80a4\u8272:",
    u"\U0001F6B6\U0001F3FC\U0000200D\U00002640\U0000FE0F": ":\u5973\u6027\u884c\u8d70\u4e2d\u6d45\u80a4\u8272:",
    u"\U0001F6B6\U0001F3FD\U0000200D\U00002640\U0000FE0F": ":\u5973\u6027\u884c\u8d70\u4e2d\u7b49\u80a4\u8272:",
    u"\U0001F6B6\U0000200D\U00002640\U0000FE0F": ":\u5973\u6b65\u884c:",
    u"\U0001F473\U0001F3FF\U0000200D\U00002640": ":\u6234\u5934\u5dfe\u7684\u5973\u4eba\u80a4\u8272\u9edd\u9ed1:",
    u"\U0001F473\U0001F3FB\U0000200D\U00002640": ":\u6234\u5934\u5dfe\u7684\u5973\u4eba\u80a4\u8272\u6d45:",
    u"\U0001F473\U0001F3FE\U0000200D\U00002640": ":\u6234\u5934\u5dfe\u7684\u5973\u4eba\u80a4\u8272\u4e2d\u7b49\u504f\u9ed1:",
    u"\U0001F473\U0001F3FC\U0000200D\U00002640": ":\u6234\u5934\u5dfe\u7684\u5973\u4eba\u80a4\u8272\u4e2d\u7b49\u504f\u6d45:",
    u"\U0001F473\U0001F3FD\U0000200D\U00002640": ":\u5973\u4eba\u6234\u5934\u5dfe\u4e2d\u7b49\u80a4\u8272:",
    u"\U0001F473\U0000200D\U00002640": ":\u6234\u5934\u5dfe\u7684\u5973\u4eba:",
    u"\U0001F473\U0001F3FF\U0000200D\U00002640\U0000FE0F": ":\u6234\u5934\u5dfe\u7684\u5973\u4eba\u80a4\u8272\u9edd\u9ed1:",
    u"\U0001F473\U0001F3FB\U0000200D\U00002640\U0000FE0F": ":\u6234\u5934\u5dfe\u7684\u5973\u4eba\u80a4\u8272\u6d45:",
    u"\U0001F473\U0001F3FE\U0000200D\U00002640\U0000FE0F": ":\u6234\u5934\u5dfe\u7684\u5973\u4eba\u80a4\u8272\u4e2d\u7b49\u504f\u9ed1:",
    u"\U0001F473\U0001F3FC\U0000200D\U00002640\U0000FE0F": ":\u6234\u5934\u5dfe\u7684\u5973\u4eba\u80a4\u8272\u4e2d\u7b49\u504f\u6d45:",
    u"\U0001F473\U0001F3FD\U0000200D\U00002640\U0000FE0F": ":\u5973\u4eba\u6234\u5934\u5dfe\u4e2d\u7b49\u80a4\u8272:",
    u"\U0001F473\U0000200D\U00002640\U0000FE0F": ":\u6234\u5934\u5dfe\u7684\u5973\u4eba:",
    u"\U0001F9D5": ":\u6234\u5934\u5dfe\u7684\u5973\u4eba:",
    u"\U0001F9D5\U0001F3FF": ":\u6234\u5934\u5dfe\u7684\u5973\u4eba\u80a4\u8272\u9edd\u9ed1:",
    u"\U0001F9D5\U0001F3FB": ":\u6234\u5934\u5dfe\u7684\u5973\u4eba\u80a4\u8272\u6d45:",
    u"\U0001F9D5\U0001F3FE": ":\u6234\u5934\u5dfe\u7684\u5973\u4eba\u80a4\u8272\u4e2d\u7b49\u504f\u6df1:",
    u"\U0001F9D5\U0001F3FC": ":\u6d45\u80a4\u8272\u5973\u5893\u77f3:",
    u"\U0001F9D5\U0001F3FD": ":\u6234\u5934\u5dfe\u7684\u5973\u6027\u4e2d\u7b49\u80a4\u8272:",
    u"\U0001F469\U0001F3FF\U0000200D\U0001F9AF": ":\u76ae\u80a4\u6697\u8272\u8c03\u7684\u5973\u6027:",
    u"\U0001F469\U0001F3FB\U0000200D\U0001F9AF": ":\u5973\u6027\u63a2\u79d8\u624b\u6756\u8f7b\u80a4\u8272:",
    u"\U0001F469\U0001F3FE\U0000200D\U0001F9AF": ":\u5973\u6027\uff0c\u4e2d\u6df1\u8272\u80a4\u8272:",
    u"\U0001F469\U0001F3FC\U0000200D\U0001F9AF": ":\u4e2d\u6d45\u80a4\u8272\u5973\u6027:",
    u"\U0001F469\U0001F3FD\U0000200D\U0001F9AF": ":\u4e2d\u7b49\u80a4\u8272\u7684\u5973\u6027:",
    u"\U0001F469\U0000200D\U0001F9AF": ":\u624b\u6756\u63a2\u5b50\u7684\u5973\u4eba:",
    u"\U0001F9DF\U0000200D\U00002640": ":\u5973\u50f5\u5c38:",
    u"\U0001F9DF\U0000200D\U00002640\U0000FE0F": ":\u5973\u50f5\u5c38:",
    u"\U0001F462": ":\u5973\u9774:",
    u"\U0001F45A": ":\u5973\u88c5:",
    u"\U0001F452": ":\u5973\u5e3d:",
    u"\U0001F461": ":\u5973\u5f0f\u51c9\u978b:",
    u"\U0001F469\U0001F3FF\U0000200D\U0001F91D\U0000200D\U0001F469\U0001F3FB": ":\u5973\u6027\u63e1\u7740\u624b\u6df1\u8272\u80a4\u8272\u6d45\u80a4\u8272:",
    u"\U0001F469\U0001F3FF\U0000200D\U0001F91D\U0000200D\U0001F469\U0001F3FE": ":\u5973\u6027\u63e1\u7740\u624b\u6df1\u8272\u80a4\u8272\u4e2d\u7b49\u6df1\u8272\u80a4\u8272:",
    u"\U0001F469\U0001F3FF\U0000200D\U0001F91D\U0000200D\U0001F469\U0001F3FC": ":\u5973\u6027\u624b\u62c9\u6df1\u8272\u80a4\u8272\u4e2d\u6d45\u80a4\u8272:",
    u"\U0001F469\U0001F3FF\U0000200D\U0001F91D\U0000200D\U0001F469\U0001F3FD": ":\u5973\u6027\u63e1\u7740\u624b\u6df1\u8272\u80a4\u8272\u4e2d\u7b49\u80a4\u8272:",
    u"\U0001F46D\U0001F3FF": ":\u624b\u7275\u7740\u624b\u7684\u5973\u4eba\u80a4\u8272\u9edd\u9ed1:",
    u"\U0001F46D\U0001F3FB": ":\u624b\u7275\u624b\u5973\u6027\u80a4\u8272\u6d45:",
    u"\U0001F469\U0001F3FE\U0000200D\U0001F91D\U0000200D\U0001F469\U0001F3FB": ":\u5973\u6027\u624b\u7275\u624b\u4e2d\u6df1\u8272\u80a4\u8272\u6d45\u80a4\u8272:",
    u"\U0001F469\U0001F3FE\U0000200D\U0001F91D\U0000200D\U0001F469\U0001F3FC": ":\u624b\u7275\u624b\u4e2d\u6df1\u8272\u80a4\u8272\u4e2d\u6d45\u80a4\u8272:",
    u"\U0001F469\U0001F3FE\U0000200D\U0001F91D\U0000200D\U0001F469\U0001F3FD": ":\u624b\u7275\u624b\u4e2d\u6df1\u8272\u80a4\u8272\u4e2d\u7b49\u80a4\u8272:",
    u"\U0001F46D\U0001F3FE": ":\u624b\u7275\u7740\u624b\u7684\u5973\u6027\u80a4\u8272\u504f\u6697:",
    u"\U0001F469\U0001F3FC\U0000200D\U0001F91D\U0000200D\U0001F469\U0001F3FB": ":\u5973\u6027\u624b\u7275\u624b\u4e2d\u6d45\u80a4\u8272\u6d45\u80a4\u8272:",
    u"\U0001F46D\U0001F3FC": ":\u5973\u6027\u624b\u7275\u624b\u4e2d\u6d45\u80a4\u8272:",
    u"\U0001F469\U0001F3FD\U0000200D\U0001F91D\U0000200D\U0001F469\U0001F3FB": ":\u5973\u6027\u624b\u7275\u624b\u4e2d\u7b49\u80a4\u8272\u6d45\u80a4\u8272:",
    u"\U0001F469\U0001F3FD\U0000200D\U0001F91D\U0000200D\U0001F469\U0001F3FC": ":\u5973\u6027\u624b\u7275\u624b\u4e2d\u7b49\u80a4\u8272\u4e2d\u7b49\u504f\u6d45\u80a4\u8272:",
    u"\U0001F46D\U0001F3FD": ":\u5973\u6027\u624b\u7275\u624b\u4e2d\u7b49\u80a4\u8272:",
    u"\U0001F46F\U0000200D\U00002640": ":\u6709\u5154\u5b50\u8033\u6735\u7684\u5973\u4eba:",
    u"\U0001F46F\U0000200D\U00002640\U0000FE0F": ":\u5e26\u5154\u5b50\u8033\u6735\u7684\u5973\u4eba:",
    u"\U0001F93C\U0000200D\U00002640": ":\u5973\u5b50\u6454\u8de4:",
    u"\U0001F93C\U0000200D\U00002640\U0000FE0F": ":\u5973\u5b50\u6454\u8de4:",
    u"\U0001F6BA": ":\u5973\u536b\u751f\u95f4:",
    u"\U0001F974": ":\u660f\u660f\u6b32\u7761\u7684\u8138:",
    u"\U0001F5FA": ":\u4e16\u754c\u5730\u56fe:",
    u"\U0001F5FA\U0000FE0F": ":\u4e16\u754c\u5730\u56fe:",
    u"\U0001F61F": ":\u6101\u7709\u82e6\u8138:",
    u"\U0001F381": ":\u5305\u88c5\u597d\u7684\u793c\u7269:",
    u"\U0001F527": ":\u6273\u624b:",
    u"\U0000270D": ":\u4e66\u5199\u624b:",
    u"\U0000270D\U0001F3FF": ":\u5199\u5b57\u624b\u6697\u80a4\u8272:",
    u"\U0000270D\U0001F3FB": ":\u4e66\u5199\u624b\u6d45\u80a4\u8272:",
    u"\U0000270D\U0001F3FE": ":\u5199\u5b57\u624b\u4e2d\u6df1\u8272\u80a4\u8272:",
    u"\U0000270D\U0001F3FC": ":\u5199\u5b57\u624b\u4e2d\u6d45\u80a4\u8272:",
    u"\U0000270D\U0001F3FD": ":\u4e66\u5199\u624b\u4e2d\u7b49\u80a4\u8272:",
    u"\U0000270D\U0000FE0F": ":\u624b\u5199:",
    u"\U0001F9F6": ":\u7eb1\u7ebf:",
    u"\U0001F971": ":\u54c8\u6b20\u7684\u8138:",
    u"\U0001F7E1": ":\u9ec4\u8272\u5706\u5708:",
    u"\U0001F49B": ":\u9ec4\u5fc3:",
    u"\U0001F7E8": ":\u9ec4\u8272\u65b9\u5757:",
    u"\U0001F4B4": ":\u65e5\u5143\u949e\u7968:",
    u"\U0000262F": ":\u9634\u9633:",
    u"\U0000262F\U0000FE0F": ":\u9634\u9633:",
    u"\U0001FA80": ":\u54df\u54df:",
    u"\U0001F92A": ":\u6ed1\u7a3d\u7684\u8138:",
    u"\U0001F993": ":\u6591\u9a6c:",
    u"\U0001F910": ":\u62c9\u94fe\u5634\u8138:",
    u"\U0001F9DF": ":\u50f5\u5c38:",
    u"\U0001F4A4": ":zzz:"
}
# When multiple emojis correspond to one Chinese, only one emoji is taken
ZH_EMOJI = {v: k for k, v in EMOJI_ZH.items()}

LANG_EMOJI = {
    "en": EN_EMOJI,
    "zh": ZH_EMOJI
}

EMOJI_LANG = {
    "en": EMOJI_EN,
    "zh": EMOJI_ZH
}
