var __create = Object.create;
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __getProtoOf = Object.getPrototypeOf;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toESM = (mod, isNodeMode, target) => (target = mod != null ? __create(__getProtoOf(mod)) : {}, __copyProps(isNodeMode || !mod || !mod.__esModule ? __defProp(target, "default", { value: mod, enumerable: true }) : target, mod));

// src/delete-old.lambda.ts
var AWS = __toESM(require("aws-sdk"));
var tagging = new AWS.ResourceGroupsTaggingAPI();
var rds = new AWS.RDS();
exports.handler = async function(input) {
  const snapshotsResponse = await tagging.getResources({
    TagFilters: input.tags.map((f) => {
      return { Key: f.Key, Values: [f.Value] };
    }),
    ResourceTypeFilters: [input.resourceType]
  }).promise();
  if (!snapshotsResponse.ResourceTagMappingList) {
    console.error("No snapshots found");
  }
  const snapshots = [];
  snapshotsResponse.ResourceTagMappingList.forEach((r) => {
    var _a;
    const id = (_a = r.ResourceARN) == null ? void 0 : _a.split(":").pop();
    if (id) {
      snapshots.push(id);
    } else {
      console.error(`Bad response from tagging API: ${r}`);
    }
  });
  snapshots.sort();
  const toDelete = snapshots.slice(0, -1 * input.historyLimit);
  for (const snapshot of toDelete) {
    console.log(`Deleting old snapshot: ${snapshot}`);
    await rds.deleteDBClusterSnapshot({
      DBClusterSnapshotIdentifier: snapshot
    }).promise();
  }
};
