"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
/* eslint-disable import/no-extraneous-dependencies */
const AWS = require("aws-sdk");
const tagging = new AWS.ResourceGroupsTaggingAPI();
const rds = new AWS.RDS();
exports.handler = async function (input) {
    const snapshotsResponse = await tagging.getResources({
        TagFilters: input.tags.map(f => {
            return { Key: f.Key, Values: [f.Value] };
        }),
        ResourceTypeFilters: [input.resourceType],
    }).promise();
    if (!snapshotsResponse.ResourceTagMappingList) {
        console.error('No snapshots found');
    }
    const snapshots = [];
    snapshotsResponse.ResourceTagMappingList.forEach(r => {
        const id = r.ResourceARN?.split(':').pop();
        if (id) {
            snapshots.push(id);
        }
        else {
            console.error(`Bad response from tagging API: ${r}`);
        }
    });
    snapshots.sort();
    const toDelete = snapshots.slice(0, -1 * input.historyLimit);
    for (const snapshot of toDelete) {
        console.log(`Deleting old snapshot: ${snapshot}`);
        await rds.deleteDBClusterSnapshot({
            DBClusterSnapshotIdentifier: snapshot,
        }).promise();
    }
};
//# sourceMappingURL=data:application/json;base64,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